/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_MANAGERPROXY_H
#define ORG_FREEDESKTOP_SYSTEMD1_MANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/freedesktop/systemd1/Manager.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

class ManagerProxy;

class AddDependencyUnitFilesCallbackIF {
public:
    virtual ~AddDependencyUnitFilesCallbackIF() {}

    virtual void onAddDependencyUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AddDependencyUnitFilesError >& error) = 0;

    virtual void onAddDependencyUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AddDependencyUnitFilesResponse >& response) = 0;
};

class ArchitectureCallbackIF {
public:
    virtual ~ArchitectureCallbackIF() {}

    virtual void onArchitectureError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ArchitectureError >& error) = 0;

    virtual void onArchitectureUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ArchitectureUpdate >& update) = 0;
};

class CancelJobCallbackIF {
public:
    virtual ~CancelJobCallbackIF() {}

    virtual void onCancelJobError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CancelJobError >& error) = 0;

    virtual void onCancelJobResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CancelJobResponse >& response) = 0;
};

class ClearJobsCallbackIF {
public:
    virtual ~ClearJobsCallbackIF() {}

    virtual void onClearJobsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ClearJobsError >& error) = 0;

    virtual void onClearJobsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ClearJobsResponse >& response) = 0;
};

class ConfirmSpawnCallbackIF {
public:
    virtual ~ConfirmSpawnCallbackIF() {}

    virtual void onConfirmSpawnError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ConfirmSpawnError >& error) = 0;

    virtual void onConfirmSpawnUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ConfirmSpawnUpdate >& update) = 0;
};

class ControlGroupCallbackIF {
public:
    virtual ~ControlGroupCallbackIF() {}

    virtual void onControlGroupError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ControlGroupError >& error) = 0;

    virtual void onControlGroupUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ControlGroupUpdate >& update) = 0;
};

class CreateSnapshotCallbackIF {
public:
    virtual ~CreateSnapshotCallbackIF() {}

    virtual void onCreateSnapshotError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSnapshotError >& error) = 0;

    virtual void onCreateSnapshotResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSnapshotResponse >& response) = 0;
};

class DefaultStandardErrorCallbackIF {
public:
    virtual ~DefaultStandardErrorCallbackIF() {}

    virtual void onDefaultStandardErrorError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DefaultStandardErrorError >& error) = 0;

    virtual void onDefaultStandardErrorUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DefaultStandardErrorUpdate >& update) = 0;
};

class DefaultStandardOutputCallbackIF {
public:
    virtual ~DefaultStandardOutputCallbackIF() {}

    virtual void onDefaultStandardOutputError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DefaultStandardOutputError >& error) = 0;

    virtual void onDefaultStandardOutputUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DefaultStandardOutputUpdate >& update) = 0;
};

class DisableUnitFilesCallbackIF {
public:
    virtual ~DisableUnitFilesCallbackIF() {}

    virtual void onDisableUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DisableUnitFilesError >& error) = 0;

    virtual void onDisableUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DisableUnitFilesResponse >& response) = 0;
};

class DumpCallbackIF {
public:
    virtual ~DumpCallbackIF() {}

    virtual void onDumpError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DumpError >& error) = 0;

    virtual void onDumpResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DumpResponse >& response) = 0;
};

class EnableUnitFilesCallbackIF {
public:
    virtual ~EnableUnitFilesCallbackIF() {}

    virtual void onEnableUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< EnableUnitFilesError >& error) = 0;

    virtual void onEnableUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< EnableUnitFilesResponse >& response) = 0;
};

class EnvironmentCallbackIF {
public:
    virtual ~EnvironmentCallbackIF() {}

    virtual void onEnvironmentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< EnvironmentError >& error) = 0;

    virtual void onEnvironmentUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< EnvironmentUpdate >& update) = 0;
};

class ExitCallbackIF {
public:
    virtual ~ExitCallbackIF() {}

    virtual void onExitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ExitError >& error) = 0;

    virtual void onExitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ExitResponse >& response) = 0;
};

class FeaturesCallbackIF {
public:
    virtual ~FeaturesCallbackIF() {}

    virtual void onFeaturesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FeaturesError >& error) = 0;

    virtual void onFeaturesUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FeaturesUpdate >& update) = 0;
};

class FinishTimestampCallbackIF {
public:
    virtual ~FinishTimestampCallbackIF() {}

    virtual void onFinishTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FinishTimestampError >& error) = 0;

    virtual void onFinishTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FinishTimestampUpdate >& update) = 0;
};

class FinishTimestampMonotonicCallbackIF {
public:
    virtual ~FinishTimestampMonotonicCallbackIF() {}

    virtual void onFinishTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FinishTimestampMonotonicError >& error) = 0;

    virtual void onFinishTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FinishTimestampMonotonicUpdate >& update) = 0;
};

class FirmwareTimestampCallbackIF {
public:
    virtual ~FirmwareTimestampCallbackIF() {}

    virtual void onFirmwareTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FirmwareTimestampError >& error) = 0;

    virtual void onFirmwareTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FirmwareTimestampUpdate >& update) = 0;
};

class FirmwareTimestampMonotonicCallbackIF {
public:
    virtual ~FirmwareTimestampMonotonicCallbackIF() {}

    virtual void onFirmwareTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FirmwareTimestampMonotonicError >& error) = 0;

    virtual void onFirmwareTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FirmwareTimestampMonotonicUpdate >& update) = 0;
};

class GeneratorsFinishTimestampCallbackIF {
public:
    virtual ~GeneratorsFinishTimestampCallbackIF() {}

    virtual void onGeneratorsFinishTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsFinishTimestampError >& error) = 0;

    virtual void onGeneratorsFinishTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsFinishTimestampUpdate >& update) = 0;
};

class GeneratorsFinishTimestampMonotonicCallbackIF {
public:
    virtual ~GeneratorsFinishTimestampMonotonicCallbackIF() {}

    virtual void onGeneratorsFinishTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicError >& error) = 0;

    virtual void onGeneratorsFinishTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicUpdate >& update) = 0;
};

class GeneratorsStartTimestampCallbackIF {
public:
    virtual ~GeneratorsStartTimestampCallbackIF() {}

    virtual void onGeneratorsStartTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsStartTimestampError >& error) = 0;

    virtual void onGeneratorsStartTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsStartTimestampUpdate >& update) = 0;
};

class GeneratorsStartTimestampMonotonicCallbackIF {
public:
    virtual ~GeneratorsStartTimestampMonotonicCallbackIF() {}

    virtual void onGeneratorsStartTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsStartTimestampMonotonicError >& error) = 0;

    virtual void onGeneratorsStartTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GeneratorsStartTimestampMonotonicUpdate >& update) = 0;
};

class GetDefaultTargetCallbackIF {
public:
    virtual ~GetDefaultTargetCallbackIF() {}

    virtual void onGetDefaultTargetError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetDefaultTargetError >& error) = 0;

    virtual void onGetDefaultTargetResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetDefaultTargetResponse >& response) = 0;
};

class GetJobCallbackIF {
public:
    virtual ~GetJobCallbackIF() {}

    virtual void onGetJobError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetJobError >& error) = 0;

    virtual void onGetJobResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetJobResponse >& response) = 0;
};

class GetUnitByPIDCallbackIF {
public:
    virtual ~GetUnitByPIDCallbackIF() {}

    virtual void onGetUnitByPIDError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitByPIDError >& error) = 0;

    virtual void onGetUnitByPIDResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitByPIDResponse >& response) = 0;
};

class GetUnitCallbackIF {
public:
    virtual ~GetUnitCallbackIF() {}

    virtual void onGetUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitError >& error) = 0;

    virtual void onGetUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitResponse >& response) = 0;
};

class GetUnitFileStateCallbackIF {
public:
    virtual ~GetUnitFileStateCallbackIF() {}

    virtual void onGetUnitFileStateError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitFileStateError >& error) = 0;

    virtual void onGetUnitFileStateResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetUnitFileStateResponse >& response) = 0;
};

class HaltCallbackIF {
public:
    virtual ~HaltCallbackIF() {}

    virtual void onHaltError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< HaltError >& error) = 0;

    virtual void onHaltResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< HaltResponse >& response) = 0;
};

class InitRDTimestampCallbackIF {
public:
    virtual ~InitRDTimestampCallbackIF() {}

    virtual void onInitRDTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< InitRDTimestampError >& error) = 0;

    virtual void onInitRDTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< InitRDTimestampUpdate >& update) = 0;
};

class InitRDTimestampMonotonicCallbackIF {
public:
    virtual ~InitRDTimestampMonotonicCallbackIF() {}

    virtual void onInitRDTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< InitRDTimestampMonotonicError >& error) = 0;

    virtual void onInitRDTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< InitRDTimestampMonotonicUpdate >& update) = 0;
};

class JobNewCallbackIF {
public:
    virtual ~JobNewCallbackIF() {}

    virtual void onJobNewError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< JobNewError >& error) = 0;

    virtual void onJobNewSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< JobNewSignal >& signal) = 0;
};

class JobRemovedCallbackIF {
public:
    virtual ~JobRemovedCallbackIF() {}

    virtual void onJobRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< JobRemovedError >& error) = 0;

    virtual void onJobRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< JobRemovedSignal >& signal) = 0;
};

class KExecCallbackIF {
public:
    virtual ~KExecCallbackIF() {}

    virtual void onKExecError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KExecError >& error) = 0;

    virtual void onKExecResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KExecResponse >& response) = 0;
};

class KernelTimestampCallbackIF {
public:
    virtual ~KernelTimestampCallbackIF() {}

    virtual void onKernelTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KernelTimestampError >& error) = 0;

    virtual void onKernelTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KernelTimestampUpdate >& update) = 0;
};

class KernelTimestampMonotonicCallbackIF {
public:
    virtual ~KernelTimestampMonotonicCallbackIF() {}

    virtual void onKernelTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KernelTimestampMonotonicError >& error) = 0;

    virtual void onKernelTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KernelTimestampMonotonicUpdate >& update) = 0;
};

class KillUnitCallbackIF {
public:
    virtual ~KillUnitCallbackIF() {}

    virtual void onKillUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KillUnitError >& error) = 0;

    virtual void onKillUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< KillUnitResponse >& response) = 0;
};

class LinkUnitFilesCallbackIF {
public:
    virtual ~LinkUnitFilesCallbackIF() {}

    virtual void onLinkUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LinkUnitFilesError >& error) = 0;

    virtual void onLinkUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LinkUnitFilesResponse >& response) = 0;
};

class ListJobsCallbackIF {
public:
    virtual ~ListJobsCallbackIF() {}

    virtual void onListJobsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListJobsError >& error) = 0;

    virtual void onListJobsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListJobsResponse >& response) = 0;
};

class ListUnitFilesCallbackIF {
public:
    virtual ~ListUnitFilesCallbackIF() {}

    virtual void onListUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitFilesError >& error) = 0;

    virtual void onListUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitFilesResponse >& response) = 0;
};

class ListUnitsCallbackIF {
public:
    virtual ~ListUnitsCallbackIF() {}

    virtual void onListUnitsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitsError >& error) = 0;

    virtual void onListUnitsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitsResponse >& response) = 0;
};

class ListUnitsFilteredCallbackIF {
public:
    virtual ~ListUnitsFilteredCallbackIF() {}

    virtual void onListUnitsFilteredError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitsFilteredError >& error) = 0;

    virtual void onListUnitsFilteredResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ListUnitsFilteredResponse >& response) = 0;
};

class LoadUnitCallbackIF {
public:
    virtual ~LoadUnitCallbackIF() {}

    virtual void onLoadUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoadUnitError >& error) = 0;

    virtual void onLoadUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoadUnitResponse >& response) = 0;
};

class LoaderTimestampCallbackIF {
public:
    virtual ~LoaderTimestampCallbackIF() {}

    virtual void onLoaderTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoaderTimestampError >& error) = 0;

    virtual void onLoaderTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoaderTimestampUpdate >& update) = 0;
};

class LoaderTimestampMonotonicCallbackIF {
public:
    virtual ~LoaderTimestampMonotonicCallbackIF() {}

    virtual void onLoaderTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoaderTimestampMonotonicError >& error) = 0;

    virtual void onLoaderTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LoaderTimestampMonotonicUpdate >& update) = 0;
};

class LogLevelCallbackIF {
public:
    virtual ~LogLevelCallbackIF() {}

    virtual void onLogLevelError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LogLevelError >& error) = 0;

    virtual void onLogLevelUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LogLevelUpdate >& update) = 0;
};

class LogTargetCallbackIF {
public:
    virtual ~LogTargetCallbackIF() {}

    virtual void onLogTargetError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LogTargetError >& error) = 0;

    virtual void onLogTargetUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< LogTargetUpdate >& update) = 0;
};

class MaskUnitFilesCallbackIF {
public:
    virtual ~MaskUnitFilesCallbackIF() {}

    virtual void onMaskUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< MaskUnitFilesError >& error) = 0;

    virtual void onMaskUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< MaskUnitFilesResponse >& response) = 0;
};

class NFailedJobsCallbackIF {
public:
    virtual ~NFailedJobsCallbackIF() {}

    virtual void onNFailedJobsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NFailedJobsError >& error) = 0;

    virtual void onNFailedJobsUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NFailedJobsUpdate >& update) = 0;
};

class NFailedUnitsCallbackIF {
public:
    virtual ~NFailedUnitsCallbackIF() {}

    virtual void onNFailedUnitsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NFailedUnitsError >& error) = 0;

    virtual void onNFailedUnitsUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NFailedUnitsUpdate >& update) = 0;
};

class NInstalledJobsCallbackIF {
public:
    virtual ~NInstalledJobsCallbackIF() {}

    virtual void onNInstalledJobsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NInstalledJobsError >& error) = 0;

    virtual void onNInstalledJobsUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NInstalledJobsUpdate >& update) = 0;
};

class NJobsCallbackIF {
public:
    virtual ~NJobsCallbackIF() {}

    virtual void onNJobsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NJobsError >& error) = 0;

    virtual void onNJobsUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NJobsUpdate >& update) = 0;
};

class NNamesCallbackIF {
public:
    virtual ~NNamesCallbackIF() {}

    virtual void onNNamesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NNamesError >& error) = 0;

    virtual void onNNamesUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< NNamesUpdate >& update) = 0;
};

class PowerOffCallbackIF {
public:
    virtual ~PowerOffCallbackIF() {}

    virtual void onPowerOffError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PowerOffError >& error) = 0;

    virtual void onPowerOffResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PowerOffResponse >& response) = 0;
};

class PresetAllUnitFilesCallbackIF {
public:
    virtual ~PresetAllUnitFilesCallbackIF() {}

    virtual void onPresetAllUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetAllUnitFilesError >& error) = 0;

    virtual void onPresetAllUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetAllUnitFilesResponse >& response) = 0;
};

class PresetUnitFilesCallbackIF {
public:
    virtual ~PresetUnitFilesCallbackIF() {}

    virtual void onPresetUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetUnitFilesError >& error) = 0;

    virtual void onPresetUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetUnitFilesResponse >& response) = 0;
};

class PresetUnitFilesWithModeCallbackIF {
public:
    virtual ~PresetUnitFilesWithModeCallbackIF() {}

    virtual void onPresetUnitFilesWithModeError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetUnitFilesWithModeError >& error) = 0;

    virtual void onPresetUnitFilesWithModeResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PresetUnitFilesWithModeResponse >& response) = 0;
};

class ProgressCallbackIF {
public:
    virtual ~ProgressCallbackIF() {}

    virtual void onProgressError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ProgressError >& error) = 0;

    virtual void onProgressUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ProgressUpdate >& update) = 0;
};

class RebootCallbackIF {
public:
    virtual ~RebootCallbackIF() {}

    virtual void onRebootError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RebootError >& error) = 0;

    virtual void onRebootResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RebootResponse >& response) = 0;
};

class ReenableUnitFilesCallbackIF {
public:
    virtual ~ReenableUnitFilesCallbackIF() {}

    virtual void onReenableUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReenableUnitFilesError >& error) = 0;

    virtual void onReenableUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReenableUnitFilesResponse >& response) = 0;
};

class ReexecuteCallbackIF {
public:
    virtual ~ReexecuteCallbackIF() {}

    virtual void onReexecuteError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReexecuteError >& error) = 0;

    virtual void onReexecuteResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReexecuteResponse >& response) = 0;
};

class ReloadCallbackIF {
public:
    virtual ~ReloadCallbackIF() {}

    virtual void onReloadError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadError >& error) = 0;

    virtual void onReloadResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadResponse >& response) = 0;
};

class ReloadOrRestartUnitCallbackIF {
public:
    virtual ~ReloadOrRestartUnitCallbackIF() {}

    virtual void onReloadOrRestartUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadOrRestartUnitError >& error) = 0;

    virtual void onReloadOrRestartUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadOrRestartUnitResponse >& response) = 0;
};

class ReloadOrTryRestartUnitCallbackIF {
public:
    virtual ~ReloadOrTryRestartUnitCallbackIF() {}

    virtual void onReloadOrTryRestartUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadOrTryRestartUnitError >& error) = 0;

    virtual void onReloadOrTryRestartUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadOrTryRestartUnitResponse >& response) = 0;
};

class ReloadUnitCallbackIF {
public:
    virtual ~ReloadUnitCallbackIF() {}

    virtual void onReloadUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadUnitError >& error) = 0;

    virtual void onReloadUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadUnitResponse >& response) = 0;
};

class ReloadingCallbackIF {
public:
    virtual ~ReloadingCallbackIF() {}

    virtual void onReloadingError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadingError >& error) = 0;

    virtual void onReloadingSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ReloadingSignal >& signal) = 0;
};

class RemoveSnapshotCallbackIF {
public:
    virtual ~RemoveSnapshotCallbackIF() {}

    virtual void onRemoveSnapshotError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RemoveSnapshotError >& error) = 0;

    virtual void onRemoveSnapshotResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RemoveSnapshotResponse >& response) = 0;
};

class ResetFailedCallbackIF {
public:
    virtual ~ResetFailedCallbackIF() {}

    virtual void onResetFailedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ResetFailedError >& error) = 0;

    virtual void onResetFailedResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ResetFailedResponse >& response) = 0;
};

class ResetFailedUnitCallbackIF {
public:
    virtual ~ResetFailedUnitCallbackIF() {}

    virtual void onResetFailedUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ResetFailedUnitError >& error) = 0;

    virtual void onResetFailedUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ResetFailedUnitResponse >& response) = 0;
};

class RestartUnitCallbackIF {
public:
    virtual ~RestartUnitCallbackIF() {}

    virtual void onRestartUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RestartUnitError >& error) = 0;

    virtual void onRestartUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RestartUnitResponse >& response) = 0;
};

class RuntimeWatchdogUSecCallbackIF {
public:
    virtual ~RuntimeWatchdogUSecCallbackIF() {}

    virtual void onRuntimeWatchdogUSecError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RuntimeWatchdogUSecError >& error) = 0;

    virtual void onRuntimeWatchdogUSecUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RuntimeWatchdogUSecUpdate >& update) = 0;
};

class SecurityFinishTimestampCallbackIF {
public:
    virtual ~SecurityFinishTimestampCallbackIF() {}

    virtual void onSecurityFinishTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityFinishTimestampError >& error) = 0;

    virtual void onSecurityFinishTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityFinishTimestampUpdate >& update) = 0;
};

class SecurityFinishTimestampMonotonicCallbackIF {
public:
    virtual ~SecurityFinishTimestampMonotonicCallbackIF() {}

    virtual void onSecurityFinishTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityFinishTimestampMonotonicError >& error) = 0;

    virtual void onSecurityFinishTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityFinishTimestampMonotonicUpdate >& update) = 0;
};

class SecurityStartTimestampCallbackIF {
public:
    virtual ~SecurityStartTimestampCallbackIF() {}

    virtual void onSecurityStartTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityStartTimestampError >& error) = 0;

    virtual void onSecurityStartTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityStartTimestampUpdate >& update) = 0;
};

class SecurityStartTimestampMonotonicCallbackIF {
public:
    virtual ~SecurityStartTimestampMonotonicCallbackIF() {}

    virtual void onSecurityStartTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityStartTimestampMonotonicError >& error) = 0;

    virtual void onSecurityStartTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SecurityStartTimestampMonotonicUpdate >& update) = 0;
};

class SetDefaultTargetCallbackIF {
public:
    virtual ~SetDefaultTargetCallbackIF() {}

    virtual void onSetDefaultTargetError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetDefaultTargetError >& error) = 0;

    virtual void onSetDefaultTargetResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetDefaultTargetResponse >& response) = 0;
};

class SetEnvironmentCallbackIF {
public:
    virtual ~SetEnvironmentCallbackIF() {}

    virtual void onSetEnvironmentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetEnvironmentError >& error) = 0;

    virtual void onSetEnvironmentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetEnvironmentResponse >& response) = 0;
};

class SetUnitPropertiesCallbackIF {
public:
    virtual ~SetUnitPropertiesCallbackIF() {}

    virtual void onSetUnitPropertiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetUnitPropertiesError >& error) = 0;

    virtual void onSetUnitPropertiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SetUnitPropertiesResponse >& response) = 0;
};

class ShowStatusCallbackIF {
public:
    virtual ~ShowStatusCallbackIF() {}

    virtual void onShowStatusError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ShowStatusError >& error) = 0;

    virtual void onShowStatusUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ShowStatusUpdate >& update) = 0;
};

class ShutdownWatchdogUSecCallbackIF {
public:
    virtual ~ShutdownWatchdogUSecCallbackIF() {}

    virtual void onShutdownWatchdogUSecError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ShutdownWatchdogUSecError >& error) = 0;

    virtual void onShutdownWatchdogUSecUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ShutdownWatchdogUSecUpdate >& update) = 0;
};

class StartTransientUnitCallbackIF {
public:
    virtual ~StartTransientUnitCallbackIF() {}

    virtual void onStartTransientUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartTransientUnitError >& error) = 0;

    virtual void onStartTransientUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartTransientUnitResponse >& response) = 0;
};

class StartUnitCallbackIF {
public:
    virtual ~StartUnitCallbackIF() {}

    virtual void onStartUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartUnitError >& error) = 0;

    virtual void onStartUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartUnitResponse >& response) = 0;
};

class StartUnitReplaceCallbackIF {
public:
    virtual ~StartUnitReplaceCallbackIF() {}

    virtual void onStartUnitReplaceError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartUnitReplaceError >& error) = 0;

    virtual void onStartUnitReplaceResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartUnitReplaceResponse >& response) = 0;
};

class StartupFinishedCallbackIF {
public:
    virtual ~StartupFinishedCallbackIF() {}

    virtual void onStartupFinishedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartupFinishedError >& error) = 0;

    virtual void onStartupFinishedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StartupFinishedSignal >& signal) = 0;
};

class StopUnitCallbackIF {
public:
    virtual ~StopUnitCallbackIF() {}

    virtual void onStopUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StopUnitError >& error) = 0;

    virtual void onStopUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< StopUnitResponse >& response) = 0;
};

class SubscribeCallbackIF {
public:
    virtual ~SubscribeCallbackIF() {}

    virtual void onSubscribeError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SubscribeError >& error) = 0;

    virtual void onSubscribeResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SubscribeResponse >& response) = 0;
};

class SwitchRootCallbackIF {
public:
    virtual ~SwitchRootCallbackIF() {}

    virtual void onSwitchRootError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SwitchRootError >& error) = 0;

    virtual void onSwitchRootResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SwitchRootResponse >& response) = 0;
};

class SystemStateCallbackIF {
public:
    virtual ~SystemStateCallbackIF() {}

    virtual void onSystemStateError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SystemStateError >& error) = 0;

    virtual void onSystemStateUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< SystemStateUpdate >& update) = 0;
};

class TaintedCallbackIF {
public:
    virtual ~TaintedCallbackIF() {}

    virtual void onTaintedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TaintedError >& error) = 0;

    virtual void onTaintedUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TaintedUpdate >& update) = 0;
};

class TryRestartUnitCallbackIF {
public:
    virtual ~TryRestartUnitCallbackIF() {}

    virtual void onTryRestartUnitError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TryRestartUnitError >& error) = 0;

    virtual void onTryRestartUnitResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TryRestartUnitResponse >& response) = 0;
};

class UnitFilesChangedCallbackIF {
public:
    virtual ~UnitFilesChangedCallbackIF() {}

    virtual void onUnitFilesChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitFilesChangedError >& error) = 0;

    virtual void onUnitFilesChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitFilesChangedSignal >& signal) = 0;
};

class UnitNewCallbackIF {
public:
    virtual ~UnitNewCallbackIF() {}

    virtual void onUnitNewError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitNewError >& error) = 0;

    virtual void onUnitNewSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitNewSignal >& signal) = 0;
};

class UnitPathCallbackIF {
public:
    virtual ~UnitPathCallbackIF() {}

    virtual void onUnitPathError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitPathError >& error) = 0;

    virtual void onUnitPathUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitPathUpdate >& update) = 0;
};

class UnitRemovedCallbackIF {
public:
    virtual ~UnitRemovedCallbackIF() {}

    virtual void onUnitRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitRemovedError >& error) = 0;

    virtual void onUnitRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitRemovedSignal >& signal) = 0;
};

class UnitsLoadFinishTimestampCallbackIF {
public:
    virtual ~UnitsLoadFinishTimestampCallbackIF() {}

    virtual void onUnitsLoadFinishTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadFinishTimestampError >& error) = 0;

    virtual void onUnitsLoadFinishTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadFinishTimestampUpdate >& update) = 0;
};

class UnitsLoadFinishTimestampMonotonicCallbackIF {
public:
    virtual ~UnitsLoadFinishTimestampMonotonicCallbackIF() {}

    virtual void onUnitsLoadFinishTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicError >& error) = 0;

    virtual void onUnitsLoadFinishTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicUpdate >& update) = 0;
};

class UnitsLoadStartTimestampCallbackIF {
public:
    virtual ~UnitsLoadStartTimestampCallbackIF() {}

    virtual void onUnitsLoadStartTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadStartTimestampError >& error) = 0;

    virtual void onUnitsLoadStartTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadStartTimestampUpdate >& update) = 0;
};

class UnitsLoadStartTimestampMonotonicCallbackIF {
public:
    virtual ~UnitsLoadStartTimestampMonotonicCallbackIF() {}

    virtual void onUnitsLoadStartTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicError >& error) = 0;

    virtual void onUnitsLoadStartTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicUpdate >& update) = 0;
};

class UnmaskUnitFilesCallbackIF {
public:
    virtual ~UnmaskUnitFilesCallbackIF() {}

    virtual void onUnmaskUnitFilesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnmaskUnitFilesError >& error) = 0;

    virtual void onUnmaskUnitFilesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnmaskUnitFilesResponse >& response) = 0;
};

class UnsetAndSetEnvironmentCallbackIF {
public:
    virtual ~UnsetAndSetEnvironmentCallbackIF() {}

    virtual void onUnsetAndSetEnvironmentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsetAndSetEnvironmentError >& error) = 0;

    virtual void onUnsetAndSetEnvironmentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsetAndSetEnvironmentResponse >& response) = 0;
};

class UnsetEnvironmentCallbackIF {
public:
    virtual ~UnsetEnvironmentCallbackIF() {}

    virtual void onUnsetEnvironmentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsetEnvironmentError >& error) = 0;

    virtual void onUnsetEnvironmentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsetEnvironmentResponse >& response) = 0;
};

class UnsubscribeCallbackIF {
public:
    virtual ~UnsubscribeCallbackIF() {}

    virtual void onUnsubscribeError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsubscribeError >& error) = 0;

    virtual void onUnsubscribeResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnsubscribeResponse >& response) = 0;
};

class UserspaceTimestampCallbackIF {
public:
    virtual ~UserspaceTimestampCallbackIF() {}

    virtual void onUserspaceTimestampError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UserspaceTimestampError >& error) = 0;

    virtual void onUserspaceTimestampUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UserspaceTimestampUpdate >& update) = 0;
};

class UserspaceTimestampMonotonicCallbackIF {
public:
    virtual ~UserspaceTimestampMonotonicCallbackIF() {}

    virtual void onUserspaceTimestampMonotonicError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UserspaceTimestampMonotonicError >& error) = 0;

    virtual void onUserspaceTimestampMonotonicUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UserspaceTimestampMonotonicUpdate >& update) = 0;
};

class VersionCallbackIF {
public:
    virtual ~VersionCallbackIF() {}

    virtual void onVersionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

    virtual void onVersionUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
};

class VirtualizationCallbackIF {
public:
    virtual ~VirtualizationCallbackIF() {}

    virtual void onVirtualizationError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< VirtualizationError >& error) = 0;

    virtual void onVirtualizationUpdate(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< VirtualizationUpdate >& update) = 0;
};


/**
 * ManagerProxy is the client side representation of the D-Bus service
 * interface 'org.freedesktop.systemd1.Manager' (specified in file
 * DBusManager_.xml).
 *
 * systemd Manager interface.
 *
 *                     As this is an example interface only, it doesn't contain full
 *                     documentation. Some documentation has been added to illustrate
 *                     how Franca interfaces could be documented.
 */
class ManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ManagerProxy.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ManagerProxy ();


    // Signal 'UnitNew'

    /**
     * Notify on the signal 'UnitNew'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'UnitNew'</b>:
     *
     * This signal is sent out each time a new unit is loaded.
     * 	    Note that this has little to do with whether a unit is available on disk or not,
     * 	    and simply reflects the units that are currently loaded into memory.
     * 	    The signals take two parameters: the primary unit name and the object path.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitNewRegister(UnitNewCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'UnitNew'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitNew'</b>:
     *
     * This signal is sent out each time a new unit is loaded.
     * 	    Note that this has little to do with whether a unit is available on disk or not,
     * 	    and simply reflects the units that are currently loaded into memory.
     * 	    The signals take two parameters: the primary unit name and the object path.
     *
     * @param act The act which was previously returned by the
     * sendUnitNewRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitNewDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'UnitNew'.
     */
    void sendUnitNewDeregisterAll () const;

    // Signal 'UnitRemoved'

    /**
     * Notify on the signal 'UnitRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'UnitRemoved'</b>:
     *
     * UnitRemoved()
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitRemovedRegister(UnitRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'UnitRemoved'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitRemoved'</b>:
     *
     * UnitRemoved()
     *
     * @param act The act which was previously returned by the
     * sendUnitRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'UnitRemoved'.
     */
    void sendUnitRemovedDeregisterAll () const;

    // Signal 'JobNew'

    /**
     * Notify on the signal 'JobNew'. This method registers for signal changes
     * by D-Bus service.
     *
     * <b>Documentation of 'JobNew'</b>:
     *
     * JobNew() and JobRemoved() are sent out each time a new job is queued or dequeued. Both signals take the numeric job ID, the bus path
     * 		and the primary unit name for this job as argument. JobRemoved() also includes a result string, being one of done, canceled, timeout, failed, dependency,
     * 		skipped. done indicates successful execution of a job. canceled indicates that a job has been canceled (via CancelJob() above) before it finished execution
     * 		(this doesn't necessarily mean though that the job operation is actually cancelled too, see above). timeout indicates that the job timeout was reached.
     * 		failed indicates that the job failed. dependency indicates that a job this job has been depending on failed and the job hence has been removed too.
     * 		skipped indicates that a job was skipped because it didn't apply to the units current state.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobNewRegister(JobNewCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'JobNew'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'JobNew'</b>:
     *
     * JobNew() and JobRemoved() are sent out each time a new job is queued or dequeued. Both signals take the numeric job ID, the bus path
     * 		and the primary unit name for this job as argument. JobRemoved() also includes a result string, being one of done, canceled, timeout, failed, dependency,
     * 		skipped. done indicates successful execution of a job. canceled indicates that a job has been canceled (via CancelJob() above) before it finished execution
     * 		(this doesn't necessarily mean though that the job operation is actually cancelled too, see above). timeout indicates that the job timeout was reached.
     * 		failed indicates that the job failed. dependency indicates that a job this job has been depending on failed and the job hence has been removed too.
     * 		skipped indicates that a job was skipped because it didn't apply to the units current state.
     *
     * @param act The act which was previously returned by the
     * sendJobNewRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobNewDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'JobNew'.
     */
    void sendJobNewDeregisterAll () const;

    // Signal 'JobRemoved'

    /**
     * Notify on the signal 'JobRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'JobRemoved'</b>:
     *
     * JobRemoved()
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobRemovedRegister(JobRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'JobRemoved'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'JobRemoved'</b>:
     *
     * JobRemoved()
     *
     * @param act The act which was previously returned by the
     * sendJobRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'JobRemoved'.
     */
    void sendJobRemovedDeregisterAll () const;

    // Signal 'StartupFinished'

    /**
     * Notify on the signal 'StartupFinished'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * StartupFinished() is sent out when startup finished. It carries six usec timespan values each indicating how much boot time has been spent
     * 		in the firmware (if known), in the boot loader (if known), in the kernel initialization phase, in the initrd (if known),
     * 		in userspace and in total. These values may also be calculated from the FirmwareTimestampMonotonic, LoaderTimestampMonotonic,
     * 		InitRDTimestampMonotonic, UserspaceTimestampMonotonic, FinishTimestampMonotonic properties (see below).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFinishedRegister(StartupFinishedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'StartupFinished'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * StartupFinished() is sent out when startup finished. It carries six usec timespan values each indicating how much boot time has been spent
     * 		in the firmware (if known), in the boot loader (if known), in the kernel initialization phase, in the initrd (if known),
     * 		in userspace and in total. These values may also be calculated from the FirmwareTimestampMonotonic, LoaderTimestampMonotonic,
     * 		InitRDTimestampMonotonic, UserspaceTimestampMonotonic, FinishTimestampMonotonic properties (see below).
     *
     * @param act The act which was previously returned by the
     * sendStartupFinishedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStartupFinishedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'StartupFinished'.
     */
    void sendStartupFinishedDeregisterAll () const;

    // Signal 'UnitFilesChanged'

    /**
     * Notify on the signal 'UnitFilesChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'UnitFilesChanged'</b>:
     *
     * UnitFilesChanged() is sent out each time the list of enabled or masked unit files on disk have changed.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitFilesChangedRegister(UnitFilesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'UnitFilesChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitFilesChanged'</b>:
     *
     * UnitFilesChanged() is sent out each time the list of enabled or masked unit files on disk have changed.
     *
     * @param act The act which was previously returned by the
     * sendUnitFilesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitFilesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'UnitFilesChanged'.
     */
    void sendUnitFilesChangedDeregisterAll () const;

    // Signal 'Reloading'

    /**
     * Notify on the signal 'Reloading'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Reloading'</b>:
     *
     * Reloading() is sent out immediately before a daemon reload is done (with the boolean parameter set to True)
     * 		and after a daemon reload is completed (with the boolean parameter set to False). This may be used by UIs to optimize UI updates.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadingRegister(ReloadingCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'Reloading'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'Reloading'</b>:
     *
     * Reloading() is sent out immediately before a daemon reload is done (with the boolean parameter set to True)
     * 		and after a daemon reload is completed (with the boolean parameter set to False). This may be used by UIs to optimize UI updates.
     *
     * @param act The act which was previously returned by the
     * sendReloadingRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReloadingDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'Reloading'.
     */
    void sendReloadingDeregisterAll () const;


    // Property 'Version'

    /**
     * Notify on the property 'Version'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionRegister(VersionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Version'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param act The act which was previously returned by the
     * sendVersionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVersionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Version'.
     */
    void sendVersionDeregisterAll() const;

    /**
     * Request the value of the property 'Version' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionGet(VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVersion()
     * returns true.
     *
     * @return the previously received value of the property 'Version'.
     */
    const ::std::string& getVersion() const;

    /**
     * Determines whether a status message for the property 'Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVersion() const;

    // Property 'Features'

    /**
     * Notify on the property 'Features'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFeaturesRegister(FeaturesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Features'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param act The act which was previously returned by the
     * sendFeaturesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFeaturesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Features'.
     */
    void sendFeaturesDeregisterAll() const;

    /**
     * Request the value of the property 'Features' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFeaturesGet(FeaturesCallbackIF& cb);


    /**
     * Returns the current value of the property 'Features' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFeatures()
     * returns true.
     *
     * @return the previously received value of the property 'Features'.
     */
    const ::std::string& getFeatures() const;

    /**
     * Determines whether a status message for the property 'Features' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFeatures() const;

    // Property 'Virtualization'

    /**
     * Notify on the property 'Virtualization'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVirtualizationRegister(VirtualizationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Virtualization'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param act The act which was previously returned by the
     * sendVirtualizationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVirtualizationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Virtualization'.
     */
    void sendVirtualizationDeregisterAll() const;

    /**
     * Request the value of the property 'Virtualization' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVirtualizationGet(VirtualizationCallbackIF& cb);


    /**
     * Returns the current value of the property 'Virtualization' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVirtualization() returns true.
     *
     * @return the previously received value of the property 'Virtualization'.
     */
    const ::std::string& getVirtualization() const;

    /**
     * Determines whether a status message for the property 'Virtualization'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVirtualization() const;

    // Property 'Architecture'

    /**
     * Notify on the property 'Architecture'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendArchitectureRegister(ArchitectureCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Architecture'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param act The act which was previously returned by the
     * sendArchitectureRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendArchitectureDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Architecture'.
     */
    void sendArchitectureDeregisterAll() const;

    /**
     * Request the value of the property 'Architecture' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendArchitectureGet(ArchitectureCallbackIF& cb);


    /**
     * Returns the current value of the property 'Architecture' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasArchitecture() returns true.
     *
     * @return the previously received value of the property 'Architecture'.
     */
    const ::std::string& getArchitecture() const;

    /**
     * Determines whether a status message for the property 'Architecture' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasArchitecture() const;

    // Property 'Tainted'

    /**
     * Notify on the property 'Tainted'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTaintedRegister(TaintedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Tainted'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param act The act which was previously returned by the
     * sendTaintedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTaintedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Tainted'.
     */
    void sendTaintedDeregisterAll() const;

    /**
     * Request the value of the property 'Tainted' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTaintedGet(TaintedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Tainted' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTainted()
     * returns true.
     *
     * @return the previously received value of the property 'Tainted'.
     */
    const ::std::string& getTainted() const;

    /**
     * Determines whether a status message for the property 'Tainted' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTainted() const;

    // Property 'FirmwareTimestamp'

    /**
     * Notify on the property 'FirmwareTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFirmwareTimestampRegister(FirmwareTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FirmwareTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @param act The act which was previously returned by the
     * sendFirmwareTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFirmwareTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FirmwareTimestamp'.
     */
    void sendFirmwareTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'FirmwareTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFirmwareTimestampGet(FirmwareTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'FirmwareTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFirmwareTimestamp() returns true.
     *
     * @return the previously received value of the property 'FirmwareTimestamp'.
     */
    uint64 getFirmwareTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'FirmwareTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFirmwareTimestamp() const;

    // Property 'FirmwareTimestampMonotonic'

    /**
     * Notify on the property 'FirmwareTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFirmwareTimestampMonotonicRegister(FirmwareTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FirmwareTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendFirmwareTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFirmwareTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'FirmwareTimestampMonotonic'.
     */
    void sendFirmwareTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'FirmwareTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFirmwareTimestampMonotonicGet(FirmwareTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'FirmwareTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFirmwareTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'FirmwareTimestampMonotonic'.
     */
    uint64 getFirmwareTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'FirmwareTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFirmwareTimestampMonotonic() const;

    // Property 'LoaderTimestamp'

    /**
     * Notify on the property 'LoaderTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoaderTimestampRegister(LoaderTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LoaderTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     *
     * @param act The act which was previously returned by the
     * sendLoaderTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLoaderTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LoaderTimestamp'.
     */
    void sendLoaderTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'LoaderTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoaderTimestampGet(LoaderTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'LoaderTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasLoaderTimestamp() returns true.
     *
     * @return the previously received value of the property 'LoaderTimestamp'.
     */
    uint64 getLoaderTimestamp() const;

    /**
     * Determines whether a status message for the property 'LoaderTimestamp'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLoaderTimestamp() const;

    // Property 'LoaderTimestampMonotonic'

    /**
     * Notify on the property 'LoaderTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoaderTimestampMonotonicRegister(LoaderTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LoaderTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendLoaderTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLoaderTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'LoaderTimestampMonotonic'.
     */
    void sendLoaderTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'LoaderTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoaderTimestampMonotonicGet(LoaderTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'LoaderTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasLoaderTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'LoaderTimestampMonotonic'.
     */
    uint64 getLoaderTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'LoaderTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLoaderTimestampMonotonic() const;

    // Property 'KernelTimestamp'

    /**
     * Notify on the property 'KernelTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKernelTimestampRegister(KernelTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'KernelTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     *
     * @param act The act which was previously returned by the
     * sendKernelTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKernelTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'KernelTimestamp'.
     */
    void sendKernelTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'KernelTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKernelTimestampGet(KernelTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'KernelTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasKernelTimestamp() returns true.
     *
     * @return the previously received value of the property 'KernelTimestamp'.
     */
    uint64 getKernelTimestamp() const;

    /**
     * Determines whether a status message for the property 'KernelTimestamp'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKernelTimestamp() const;

    // Property 'KernelTimestampMonotonic'

    /**
     * Notify on the property 'KernelTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKernelTimestampMonotonicRegister(KernelTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'KernelTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendKernelTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKernelTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'KernelTimestampMonotonic'.
     */
    void sendKernelTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'KernelTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKernelTimestampMonotonicGet(KernelTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'KernelTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasKernelTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'KernelTimestampMonotonic'.
     */
    uint64 getKernelTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'KernelTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKernelTimestampMonotonic() const;

    // Property 'InitRDTimestamp'

    /**
     * Notify on the property 'InitRDTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitRDTimestampRegister(InitRDTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InitRDTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     *
     * @param act The act which was previously returned by the
     * sendInitRDTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInitRDTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'InitRDTimestamp'.
     */
    void sendInitRDTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'InitRDTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitRDTimestampGet(InitRDTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'InitRDTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasInitRDTimestamp() returns true.
     *
     * @return the previously received value of the property 'InitRDTimestamp'.
     */
    uint64 getInitRDTimestamp() const;

    /**
     * Determines whether a status message for the property 'InitRDTimestamp'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInitRDTimestamp() const;

    // Property 'InitRDTimestampMonotonic'

    /**
     * Notify on the property 'InitRDTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitRDTimestampMonotonicRegister(InitRDTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InitRDTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendInitRDTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInitRDTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'InitRDTimestampMonotonic'.
     */
    void sendInitRDTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'InitRDTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitRDTimestampMonotonicGet(InitRDTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'InitRDTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasInitRDTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'InitRDTimestampMonotonic'.
     */
    uint64 getInitRDTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'InitRDTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInitRDTimestampMonotonic() const;

    // Property 'UserspaceTimestamp'

    /**
     * Notify on the property 'UserspaceTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUserspaceTimestampRegister(UserspaceTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UserspaceTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     *
     * @param act The act which was previously returned by the
     * sendUserspaceTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUserspaceTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UserspaceTimestamp'.
     */
    void sendUserspaceTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'UserspaceTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUserspaceTimestampGet(UserspaceTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'UserspaceTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUserspaceTimestamp() returns true.
     *
     * @return the previously received value of the property 'UserspaceTimestamp'.
     */
    uint64 getUserspaceTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'UserspaceTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUserspaceTimestamp() const;

    // Property 'UserspaceTimestampMonotonic'

    /**
     * Notify on the property 'UserspaceTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUserspaceTimestampMonotonicRegister(UserspaceTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UserspaceTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendUserspaceTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUserspaceTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'UserspaceTimestampMonotonic'.
     */
    void sendUserspaceTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'UserspaceTimestampMonotonic' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUserspaceTimestampMonotonicGet(UserspaceTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'UserspaceTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUserspaceTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'UserspaceTimestampMonotonic'.
     */
    uint64 getUserspaceTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'UserspaceTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUserspaceTimestampMonotonic() const;

    // Property 'FinishTimestamp'

    /**
     * Notify on the property 'FinishTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFinishTimestampRegister(FinishTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FinishTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     *
     * @param act The act which was previously returned by the
     * sendFinishTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFinishTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FinishTimestamp'.
     */
    void sendFinishTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'FinishTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFinishTimestampGet(FinishTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'FinishTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFinishTimestamp() returns true.
     *
     * @return the previously received value of the property 'FinishTimestamp'.
     */
    uint64 getFinishTimestamp() const;

    /**
     * Determines whether a status message for the property 'FinishTimestamp'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFinishTimestamp() const;

    // Property 'FinishTimestampMonotonic'

    /**
     * Notify on the property 'FinishTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFinishTimestampMonotonicRegister(FinishTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FinishTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendFinishTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFinishTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'FinishTimestampMonotonic'.
     */
    void sendFinishTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'FinishTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFinishTimestampMonotonicGet(FinishTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'FinishTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFinishTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'FinishTimestampMonotonic'.
     */
    uint64 getFinishTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'FinishTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFinishTimestampMonotonic() const;

    // Property 'SecurityStartTimestamp'

    /**
     * Notify on the property 'SecurityStartTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityStartTimestampRegister(SecurityStartTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SecurityStartTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     *
     * @param act The act which was previously returned by the
     * sendSecurityStartTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSecurityStartTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SecurityStartTimestamp'.
     */
    void sendSecurityStartTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'SecurityStartTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityStartTimestampGet(SecurityStartTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'SecurityStartTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSecurityStartTimestamp() returns true.
     *
     * @return the previously received value of the property 'SecurityStartTimestamp'.
     */
    uint64 getSecurityStartTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'SecurityStartTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSecurityStartTimestamp() const;

    // Property 'SecurityStartTimestampMonotonic'

    /**
     * Notify on the property 'SecurityStartTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityStartTimestampMonotonicRegister(SecurityStartTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SecurityStartTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendSecurityStartTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSecurityStartTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'SecurityStartTimestampMonotonic'.
     */
    void sendSecurityStartTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'SecurityStartTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityStartTimestampMonotonicGet(SecurityStartTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'SecurityStartTimestampMonotonic' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasSecurityStartTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'SecurityStartTimestampMonotonic'.
     */
    uint64 getSecurityStartTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'SecurityStartTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSecurityStartTimestampMonotonic() const;

    // Property 'SecurityFinishTimestamp'

    /**
     * Notify on the property 'SecurityFinishTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityFinishTimestampRegister(SecurityFinishTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SecurityFinishTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     *
     * @param act The act which was previously returned by the
     * sendSecurityFinishTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSecurityFinishTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'SecurityFinishTimestamp'.
     */
    void sendSecurityFinishTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'SecurityFinishTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityFinishTimestampGet(SecurityFinishTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'SecurityFinishTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSecurityFinishTimestamp() returns true.
     *
     * @return the previously received value of the property 'SecurityFinishTimestamp'.
     */
    uint64 getSecurityFinishTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'SecurityFinishTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSecurityFinishTimestamp() const;

    // Property 'SecurityFinishTimestampMonotonic'

    /**
     * Notify on the property 'SecurityFinishTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityFinishTimestampMonotonicRegister(SecurityFinishTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SecurityFinishTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendSecurityFinishTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSecurityFinishTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'SecurityFinishTimestampMonotonic'.
     */
    void sendSecurityFinishTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'SecurityFinishTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSecurityFinishTimestampMonotonicGet(SecurityFinishTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'SecurityFinishTimestampMonotonic' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasSecurityFinishTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'SecurityFinishTimestampMonotonic'.
     */
    uint64 getSecurityFinishTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'SecurityFinishTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSecurityFinishTimestampMonotonic() const;

    // Property 'GeneratorsStartTimestamp'

    /**
     * Notify on the property 'GeneratorsStartTimestamp'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsStartTimestampRegister(GeneratorsStartTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'GeneratorsStartTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     *
     * @param act The act which was previously returned by the
     * sendGeneratorsStartTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendGeneratorsStartTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'GeneratorsStartTimestamp'.
     */
    void sendGeneratorsStartTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'GeneratorsStartTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsStartTimestampGet(GeneratorsStartTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'GeneratorsStartTimestamp'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGeneratorsStartTimestamp() returns true.
     *
     * @return the previously received value of the property 'GeneratorsStartTimestamp'.
     */
    uint64 getGeneratorsStartTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'GeneratorsStartTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneratorsStartTimestamp() const;

    // Property 'GeneratorsStartTimestampMonotonic'

    /**
     * Notify on the property 'GeneratorsStartTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsStartTimestampMonotonicRegister(GeneratorsStartTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'GeneratorsStartTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendGeneratorsStartTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendGeneratorsStartTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'GeneratorsStartTimestampMonotonic'.
     */
    void sendGeneratorsStartTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'GeneratorsStartTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsStartTimestampMonotonicGet(GeneratorsStartTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'GeneratorsStartTimestampMonotonic' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasGeneratorsStartTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'GeneratorsStartTimestampMonotonic'.
     */
    uint64 getGeneratorsStartTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'GeneratorsStartTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneratorsStartTimestampMonotonic() const;

    // Property 'GeneratorsFinishTimestamp'

    /**
     * Notify on the property 'GeneratorsFinishTimestamp'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsFinishTimestampRegister(GeneratorsFinishTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'GeneratorsFinishTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     *
     * @param act The act which was previously returned by the
     * sendGeneratorsFinishTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendGeneratorsFinishTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'GeneratorsFinishTimestamp'.
     */
    void sendGeneratorsFinishTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'GeneratorsFinishTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsFinishTimestampGet(GeneratorsFinishTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'GeneratorsFinishTimestamp'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGeneratorsFinishTimestamp() returns true.
     *
     * @return the previously received value of the property 'GeneratorsFinishTimestamp'.
     */
    uint64 getGeneratorsFinishTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'GeneratorsFinishTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneratorsFinishTimestamp() const;

    // Property 'GeneratorsFinishTimestampMonotonic'

    /**
     * Notify on the property 'GeneratorsFinishTimestampMonotonic'. This
     * method registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsFinishTimestampMonotonicRegister(GeneratorsFinishTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property
     * 'GeneratorsFinishTimestampMonotonic'. This method deregisters property
     * changes from the D-Bus service.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendGeneratorsFinishTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendGeneratorsFinishTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'GeneratorsFinishTimestampMonotonic'.
     */
    void sendGeneratorsFinishTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'GeneratorsFinishTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneratorsFinishTimestampMonotonicGet(GeneratorsFinishTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'GeneratorsFinishTimestampMonotonic' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasGeneratorsFinishTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'GeneratorsFinishTimestampMonotonic'.
     */
    uint64 getGeneratorsFinishTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'GeneratorsFinishTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneratorsFinishTimestampMonotonic() const;

    // Property 'UnitsLoadStartTimestamp'

    /**
     * Notify on the property 'UnitsLoadStartTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadStartTimestampRegister(UnitsLoadStartTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitsLoadStartTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     *
     * @param act The act which was previously returned by the
     * sendUnitsLoadStartTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitsLoadStartTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'UnitsLoadStartTimestamp'.
     */
    void sendUnitsLoadStartTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'UnitsLoadStartTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadStartTimestampGet(UnitsLoadStartTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'UnitsLoadStartTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUnitsLoadStartTimestamp() returns true.
     *
     * @return the previously received value of the property 'UnitsLoadStartTimestamp'.
     */
    uint64 getUnitsLoadStartTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'UnitsLoadStartTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitsLoadStartTimestamp() const;

    // Property 'UnitsLoadStartTimestampMonotonic'

    /**
     * Notify on the property 'UnitsLoadStartTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadStartTimestampMonotonicRegister(UnitsLoadStartTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitsLoadStartTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendUnitsLoadStartTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitsLoadStartTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'UnitsLoadStartTimestampMonotonic'.
     */
    void sendUnitsLoadStartTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'UnitsLoadStartTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadStartTimestampMonotonicGet(UnitsLoadStartTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'UnitsLoadStartTimestampMonotonic' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasUnitsLoadStartTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'UnitsLoadStartTimestampMonotonic'.
     */
    uint64 getUnitsLoadStartTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'UnitsLoadStartTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitsLoadStartTimestampMonotonic() const;

    // Property 'UnitsLoadFinishTimestamp'

    /**
     * Notify on the property 'UnitsLoadFinishTimestamp'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadFinishTimestampRegister(UnitsLoadFinishTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitsLoadFinishTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     *
     * @param act The act which was previously returned by the
     * sendUnitsLoadFinishTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitsLoadFinishTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'UnitsLoadFinishTimestamp'.
     */
    void sendUnitsLoadFinishTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'UnitsLoadFinishTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadFinishTimestampGet(UnitsLoadFinishTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'UnitsLoadFinishTimestamp'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUnitsLoadFinishTimestamp() returns true.
     *
     * @return the previously received value of the property 'UnitsLoadFinishTimestamp'.
     */
    uint64 getUnitsLoadFinishTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'UnitsLoadFinishTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitsLoadFinishTimestamp() const;

    // Property 'UnitsLoadFinishTimestampMonotonic'

    /**
     * Notify on the property 'UnitsLoadFinishTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadFinishTimestampMonotonicRegister(UnitsLoadFinishTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitsLoadFinishTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendUnitsLoadFinishTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitsLoadFinishTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'UnitsLoadFinishTimestampMonotonic'.
     */
    void sendUnitsLoadFinishTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'UnitsLoadFinishTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitsLoadFinishTimestampMonotonicGet(UnitsLoadFinishTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'UnitsLoadFinishTimestampMonotonic' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasUnitsLoadFinishTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'UnitsLoadFinishTimestampMonotonic'.
     */
    uint64 getUnitsLoadFinishTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'UnitsLoadFinishTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitsLoadFinishTimestampMonotonic() const;

    // Property 'LogLevel'

    /**
     * Notify on the property 'LogLevel'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogLevelRegister(LogLevelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LogLevel'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param act The act which was previously returned by the
     * sendLogLevelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLogLevelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LogLevel'.
     */
    void sendLogLevelDeregisterAll() const;

    /**
     * Request the value of the property 'LogLevel' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogLevelGet(LogLevelCallbackIF& cb);

    /**
     * Set the value of the property 'LogLevel'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendLogLevelSet(LogLevelCallbackIF& cb, const
     * ::std::string& logLevel) method instead.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    void sendLogLevelSet(const ::std::string& logLevel);

    /**
     * Set the value of the property 'LogLevel'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogLevelSet(LogLevelCallbackIF& cb, const ::std::string& logLevel);

    /**
     * Returns the current value of the property 'LogLevel' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLogLevel()
     * returns true.
     *
     * @return the previously received value of the property 'LogLevel'.
     */
    const ::std::string& getLogLevel() const;

    /**
     * Determines whether a status message for the property 'LogLevel' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLogLevel() const;

    // Property 'LogTarget'

    /**
     * Notify on the property 'LogTarget'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogTargetRegister(LogTargetCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LogTarget'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param act The act which was previously returned by the
     * sendLogTargetRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLogTargetDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LogTarget'.
     */
    void sendLogTargetDeregisterAll() const;

    /**
     * Request the value of the property 'LogTarget' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogTargetGet(LogTargetCallbackIF& cb);

    /**
     * Set the value of the property 'LogTarget'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendLogTargetSet(LogTargetCallbackIF& cb, const
     * ::std::string& logTarget) method instead.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    void sendLogTargetSet(const ::std::string& logTarget);

    /**
     * Set the value of the property 'LogTarget'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLogTargetSet(LogTargetCallbackIF& cb, const ::std::string& logTarget);

    /**
     * Returns the current value of the property 'LogTarget' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLogTarget()
     * returns true.
     *
     * @return the previously received value of the property 'LogTarget'.
     */
    const ::std::string& getLogTarget() const;

    /**
     * Determines whether a status message for the property 'LogTarget' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLogTarget() const;

    // Property 'NNames'

    /**
     * Notify on the property 'NNames'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNNamesRegister(NNamesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NNames'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @param act The act which was previously returned by the
     * sendNNamesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNNamesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NNames'.
     */
    void sendNNamesDeregisterAll() const;

    /**
     * Request the value of the property 'NNames' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNNamesGet(NNamesCallbackIF& cb);


    /**
     * Returns the current value of the property 'NNames' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasNNames()
     * returns true.
     *
     * @return the previously received value of the property 'NNames'.
     */
    uint32 getNNames() const;

    /**
     * Determines whether a status message for the property 'NNames' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNNames() const;

    // Property 'NFailedUnits'

    /**
     * Notify on the property 'NFailedUnits'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNFailedUnitsRegister(NFailedUnitsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NFailedUnits'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     *
     * @param act The act which was previously returned by the
     * sendNFailedUnitsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNFailedUnitsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NFailedUnits'.
     */
    void sendNFailedUnitsDeregisterAll() const;

    /**
     * Request the value of the property 'NFailedUnits' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNFailedUnitsGet(NFailedUnitsCallbackIF& cb);


    /**
     * Returns the current value of the property 'NFailedUnits' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNFailedUnits() returns true.
     *
     * @return the previously received value of the property 'NFailedUnits'.
     */
    uint32 getNFailedUnits() const;

    /**
     * Determines whether a status message for the property 'NFailedUnits' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNFailedUnits() const;

    // Property 'NJobs'

    /**
     * Notify on the property 'NJobs'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNJobsRegister(NJobsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NJobs'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @param act The act which was previously returned by the
     * sendNJobsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNJobsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NJobs'.
     */
    void sendNJobsDeregisterAll() const;

    /**
     * Request the value of the property 'NJobs' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNJobsGet(NJobsCallbackIF& cb);


    /**
     * Returns the current value of the property 'NJobs' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasNJobs()
     * returns true.
     *
     * @return the previously received value of the property 'NJobs'.
     */
    uint32 getNJobs() const;

    /**
     * Determines whether a status message for the property 'NJobs' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNJobs() const;

    // Property 'NInstalledJobs'

    /**
     * Notify on the property 'NInstalledJobs'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNInstalledJobsRegister(NInstalledJobsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NInstalledJobs'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @param act The act which was previously returned by the
     * sendNInstalledJobsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNInstalledJobsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NInstalledJobs'.
     */
    void sendNInstalledJobsDeregisterAll() const;

    /**
     * Request the value of the property 'NInstalledJobs' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNInstalledJobsGet(NInstalledJobsCallbackIF& cb);


    /**
     * Returns the current value of the property 'NInstalledJobs' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNInstalledJobs() returns true.
     *
     * @return the previously received value of the property 'NInstalledJobs'.
     */
    uint32 getNInstalledJobs() const;

    /**
     * Determines whether a status message for the property 'NInstalledJobs'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNInstalledJobs() const;

    // Property 'NFailedJobs'

    /**
     * Notify on the property 'NFailedJobs'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNFailedJobsRegister(NFailedJobsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NFailedJobs'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @param act The act which was previously returned by the
     * sendNFailedJobsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNFailedJobsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NFailedJobs'.
     */
    void sendNFailedJobsDeregisterAll() const;

    /**
     * Request the value of the property 'NFailedJobs' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNFailedJobsGet(NFailedJobsCallbackIF& cb);


    /**
     * Returns the current value of the property 'NFailedJobs' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNFailedJobs() returns true.
     *
     * @return the previously received value of the property 'NFailedJobs'.
     */
    uint32 getNFailedJobs() const;

    /**
     * Determines whether a status message for the property 'NFailedJobs' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNFailedJobs() const;

    // Property 'Progress'

    /**
     * Notify on the property 'Progress'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProgressRegister(ProgressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Progress'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @param act The act which was previously returned by the
     * sendProgressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProgressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Progress'.
     */
    void sendProgressDeregisterAll() const;

    /**
     * Request the value of the property 'Progress' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProgressGet(ProgressCallbackIF& cb);


    /**
     * Returns the current value of the property 'Progress' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasProgress()
     * returns true.
     *
     * @return the previously received value of the property 'Progress'.
     */
    double getProgress() const;

    /**
     * Determines whether a status message for the property 'Progress' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProgress() const;

    // Property 'Environment'

    /**
     * Notify on the property 'Environment'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnvironmentRegister(EnvironmentCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Environment'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @param act The act which was previously returned by the
     * sendEnvironmentRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEnvironmentDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Environment'.
     */
    void sendEnvironmentDeregisterAll() const;

    /**
     * Request the value of the property 'Environment' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnvironmentGet(EnvironmentCallbackIF& cb);


    /**
     * Returns the current value of the property 'Environment' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasEnvironment() returns true.
     *
     * @return the previously received value of the property 'Environment'.
     */
    const ::std::vector< ::std::string >& getEnvironment() const;

    /**
     * Determines whether a status message for the property 'Environment' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEnvironment() const;

    // Property 'ConfirmSpawn'

    /**
     * Notify on the property 'ConfirmSpawn'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfirmSpawnRegister(ConfirmSpawnCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConfirmSpawn'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     *
     * @param act The act which was previously returned by the
     * sendConfirmSpawnRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConfirmSpawnDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConfirmSpawn'.
     */
    void sendConfirmSpawnDeregisterAll() const;

    /**
     * Request the value of the property 'ConfirmSpawn' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfirmSpawnGet(ConfirmSpawnCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConfirmSpawn' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConfirmSpawn() returns true.
     *
     * @return the previously received value of the property 'ConfirmSpawn'.
     */
    bool getConfirmSpawn() const;

    /**
     * Determines whether a status message for the property 'ConfirmSpawn' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConfirmSpawn() const;

    // Property 'ShowStatus'

    /**
     * Notify on the property 'ShowStatus'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShowStatusRegister(ShowStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ShowStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     *
     * @param act The act which was previously returned by the
     * sendShowStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendShowStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ShowStatus'.
     */
    void sendShowStatusDeregisterAll() const;

    /**
     * Request the value of the property 'ShowStatus' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShowStatusGet(ShowStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'ShowStatus' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasShowStatus() returns true.
     *
     * @return the previously received value of the property 'ShowStatus'.
     */
    bool getShowStatus() const;

    /**
     * Determines whether a status message for the property 'ShowStatus' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasShowStatus() const;

    // Property 'UnitPath'

    /**
     * Notify on the property 'UnitPath'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitPathRegister(UnitPathCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitPath'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @param act The act which was previously returned by the
     * sendUnitPathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitPathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UnitPath'.
     */
    void sendUnitPathDeregisterAll() const;

    /**
     * Request the value of the property 'UnitPath' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitPathGet(UnitPathCallbackIF& cb);


    /**
     * Returns the current value of the property 'UnitPath' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasUnitPath()
     * returns true.
     *
     * @return the previously received value of the property 'UnitPath'.
     */
    const ::std::vector< ::std::string >& getUnitPath() const;

    /**
     * Determines whether a status message for the property 'UnitPath' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitPath() const;

    // Property 'DefaultStandardOutput'

    /**
     * Notify on the property 'DefaultStandardOutput'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultStandardOutputRegister(DefaultStandardOutputCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DefaultStandardOutput'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     *
     * @param act The act which was previously returned by the
     * sendDefaultStandardOutputRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDefaultStandardOutputDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DefaultStandardOutput'.
     */
    void sendDefaultStandardOutputDeregisterAll() const;

    /**
     * Request the value of the property 'DefaultStandardOutput' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultStandardOutputGet(DefaultStandardOutputCallbackIF& cb);


    /**
     * Returns the current value of the property 'DefaultStandardOutput' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDefaultStandardOutput() returns true.
     *
     * @return the previously received value of the property 'DefaultStandardOutput'.
     */
    const ::std::string& getDefaultStandardOutput() const;

    /**
     * Determines whether a status message for the property
     * 'DefaultStandardOutput' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDefaultStandardOutput() const;

    // Property 'DefaultStandardError'

    /**
     * Notify on the property 'DefaultStandardError'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultStandardErrorRegister(DefaultStandardErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DefaultStandardError'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     *
     * @param act The act which was previously returned by the
     * sendDefaultStandardErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDefaultStandardErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DefaultStandardError'.
     */
    void sendDefaultStandardErrorDeregisterAll() const;

    /**
     * Request the value of the property 'DefaultStandardError' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultStandardErrorGet(DefaultStandardErrorCallbackIF& cb);


    /**
     * Returns the current value of the property 'DefaultStandardError' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDefaultStandardError() returns true.
     *
     * @return the previously received value of the property 'DefaultStandardError'.
     */
    const ::std::string& getDefaultStandardError() const;

    /**
     * Determines whether a status message for the property
     * 'DefaultStandardError' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDefaultStandardError() const;

    // Property 'RuntimeWatchdogUSec'

    /**
     * Notify on the property 'RuntimeWatchdogUSec'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRuntimeWatchdogUSecRegister(RuntimeWatchdogUSecCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RuntimeWatchdogUSec'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param act The act which was previously returned by the
     * sendRuntimeWatchdogUSecRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRuntimeWatchdogUSecDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RuntimeWatchdogUSec'.
     */
    void sendRuntimeWatchdogUSecDeregisterAll() const;

    /**
     * Request the value of the property 'RuntimeWatchdogUSec' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRuntimeWatchdogUSecGet(RuntimeWatchdogUSecCallbackIF& cb);

    /**
     * Set the value of the property 'RuntimeWatchdogUSec'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendRuntimeWatchdogUSecSet(RuntimeWatchdogUSecCallbackIF& cb, uint64
     * runtimeWatchdogUSec) method instead.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    void sendRuntimeWatchdogUSecSet(uint64 runtimeWatchdogUSec);

    /**
     * Set the value of the property 'RuntimeWatchdogUSec'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRuntimeWatchdogUSecSet(RuntimeWatchdogUSecCallbackIF& cb, uint64 runtimeWatchdogUSec);

    /**
     * Returns the current value of the property 'RuntimeWatchdogUSec' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRuntimeWatchdogUSec() returns true.
     *
     * @return the previously received value of the property 'RuntimeWatchdogUSec'.
     */
    uint64 getRuntimeWatchdogUSec() const;

    /**
     * Determines whether a status message for the property
     * 'RuntimeWatchdogUSec' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRuntimeWatchdogUSec() const;

    // Property 'ShutdownWatchdogUSec'

    /**
     * Notify on the property 'ShutdownWatchdogUSec'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShutdownWatchdogUSecRegister(ShutdownWatchdogUSecCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ShutdownWatchdogUSec'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param act The act which was previously returned by the
     * sendShutdownWatchdogUSecRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendShutdownWatchdogUSecDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ShutdownWatchdogUSec'.
     */
    void sendShutdownWatchdogUSecDeregisterAll() const;

    /**
     * Request the value of the property 'ShutdownWatchdogUSec' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShutdownWatchdogUSecGet(ShutdownWatchdogUSecCallbackIF& cb);

    /**
     * Set the value of the property 'ShutdownWatchdogUSec'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendShutdownWatchdogUSecSet(ShutdownWatchdogUSecCallbackIF& cb, uint64
     * shutdownWatchdogUSec) method instead.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    void sendShutdownWatchdogUSecSet(uint64 shutdownWatchdogUSec);

    /**
     * Set the value of the property 'ShutdownWatchdogUSec'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShutdownWatchdogUSecSet(ShutdownWatchdogUSecCallbackIF& cb, uint64 shutdownWatchdogUSec);

    /**
     * Returns the current value of the property 'ShutdownWatchdogUSec' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasShutdownWatchdogUSec() returns true.
     *
     * @return the previously received value of the property 'ShutdownWatchdogUSec'.
     */
    uint64 getShutdownWatchdogUSec() const;

    /**
     * Determines whether a status message for the property
     * 'ShutdownWatchdogUSec' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasShutdownWatchdogUSec() const;

    // Property 'ControlGroup'

    /**
     * Notify on the property 'ControlGroup'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendControlGroupRegister(ControlGroupCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ControlGroup'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param act The act which was previously returned by the
     * sendControlGroupRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendControlGroupDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ControlGroup'.
     */
    void sendControlGroupDeregisterAll() const;

    /**
     * Request the value of the property 'ControlGroup' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendControlGroupGet(ControlGroupCallbackIF& cb);

    /**
     * Set the value of the property 'ControlGroup'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendControlGroupSet(ControlGroupCallbackIF& cb,
     * const ::std::string& controlGroup) method instead.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    void sendControlGroupSet(const ::std::string& controlGroup);

    /**
     * Set the value of the property 'ControlGroup'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendControlGroupSet(ControlGroupCallbackIF& cb, const ::std::string& controlGroup);

    /**
     * Returns the current value of the property 'ControlGroup' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasControlGroup() returns true.
     *
     * @return the previously received value of the property 'ControlGroup'.
     */
    const ::std::string& getControlGroup() const;

    /**
     * Determines whether a status message for the property 'ControlGroup' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasControlGroup() const;

    // Property 'SystemState'

    /**
     * Notify on the property 'SystemState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemStateRegister(SystemStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SystemState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param act The act which was previously returned by the
     * sendSystemStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSystemStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SystemState'.
     */
    void sendSystemStateDeregisterAll() const;

    /**
     * Request the value of the property 'SystemState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemStateGet(SystemStateCallbackIF& cb);

    /**
     * Set the value of the property 'SystemState'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendSystemStateSet(SystemStateCallbackIF& cb, const
     * ::std::string& systemState) method instead.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    void sendSystemStateSet(const ::std::string& systemState);

    /**
     * Set the value of the property 'SystemState'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemStateSet(SystemStateCallbackIF& cb, const ::std::string& systemState);

    /**
     * Returns the current value of the property 'SystemState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSystemState() returns true.
     *
     * @return the previously received value of the property 'SystemState'.
     */
    const ::std::string& getSystemState() const;

    /**
     * Determines whether a status message for the property 'SystemState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemState() const;


    // Method 'GetUnit'

    /**
     * Call the method 'GetUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetUnit'</b>:
     *
     * GetUnit() may be used to get the unit object path
     * 	    for a unit name. It takes the unit name and returns the object path.
     * 	    If a unit has not been loaded yet by this name this call will fail.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetUnitRequest(GetUnitCallbackIF& cb, const ::std::string& name) const;

    // Method 'GetUnitByPID'

    /**
     * Call the method 'GetUnitByPID'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetUnitByPID'</b>:
     *
     * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
     * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pid If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetUnitByPIDRequest(GetUnitByPIDCallbackIF& cb, uint32 pid) const;

    // Method 'LoadUnit'

    /**
     * Call the method 'LoadUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'LoadUnit'</b>:
     *
     * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadUnitRequest(LoadUnitCallbackIF& cb, const ::std::string& name) const;

    // Method 'StartUnit'

    /**
     * Call the method 'StartUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'StartUnit'</b>:
     *
     * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
     *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
     *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
     *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
     *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
     *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
     *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
     *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartUnitRequest(StartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'StartUnitReplace'

    /**
     * Call the method 'StartUnitReplace'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'StartUnitReplace'</b>:
     *
     * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param old_unit If the meaning of "old_unit" isn't clear, then there should be a description here.
     *
     * @param new_unit If the meaning of "new_unit" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartUnitReplaceRequest(StartUnitReplaceCallbackIF& cb, const ::std::string& old_unit, const ::std::string& new_unit, const ::std::string& mode) const;

    // Method 'StopUnit'

    /**
     * Call the method 'StopUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'StopUnit'</b>:
     *
     * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopUnitRequest(StopUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'ReloadUnit'

    /**
     * Call the method 'ReloadUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ReloadUnit'</b>:
     *
     * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
     *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
     *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
     *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadUnitRequest(ReloadUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'RestartUnit'

    /**
     * Call the method 'RestartUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'RestartUnit'</b>:
     *
     * RestartUnit()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestartUnitRequest(RestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'TryRestartUnit'

    /**
     * Call the method 'TryRestartUnit'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'TryRestartUnit'</b>:
     *
     * TryRestartUnit()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTryRestartUnitRequest(TryRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'ReloadOrRestartUnit'

    /**
     * Call the method 'ReloadOrRestartUnit'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReloadOrRestartUnit'</b>:
     *
     * ReloadOrRestartUnit()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadOrRestartUnitRequest(ReloadOrRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'ReloadOrTryRestartUnit'

    /**
     * Call the method 'ReloadOrTryRestartUnit'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'ReloadOrTryRestartUnit'</b>:
     *
     * ReloadOrTryRestartUnit()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadOrTryRestartUnitRequest(ReloadOrTryRestartUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode) const;

    // Method 'KillUnit'

    /**
     * Call the method 'KillUnit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'KillUnit'</b>:
     *
     * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
     * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
     * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
     * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param who If the meaning of "who" isn't clear, then there should be a description here.
     *
     * @param signal If the meaning of "signal" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKillUnitRequest(KillUnitCallbackIF& cb, const ::std::string& name, const ::std::string& who, int32 signal) const;

    // Method 'ResetFailedUnit'

    /**
     * Call the method 'ResetFailedUnit'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ResetFailedUnit'</b>:
     *
     * ResetFailedUnit
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetFailedUnitRequest(ResetFailedUnitCallbackIF& cb, const ::std::string& name) const;

    // Method 'SetUnitProperties'

    /**
     * Call the method 'SetUnitProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetUnitProperties'</b>:
     *
     * SetUnitProperties
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetUnitPropertiesRequest(SetUnitPropertiesCallbackIF& cb, const ::std::string& name, bool runtime, const ::std::vector< property >& properties) const;

    // Method 'StartTransientUnit'

    /**
     * Call the method 'StartTransientUnit'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'StartTransientUnit'</b>:
     *
     * StartTransientUnit
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param transientunitdata If the meaning of "transientunitdata" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartTransientUnitRequest(StartTransientUnitCallbackIF& cb, const ::std::string& name, const ::std::string& mode, const ::std::vector< property >& properties, const ::std::vector< transientunitdata >& transientunitdata) const;

    // Method 'GetJob'

    /**
     * Call the method 'GetJob'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetJob'</b>:
     *
     * GetJob() returns the job object path for a specific job, identified by its id.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetJobRequest(GetJobCallbackIF& cb, uint32 id) const;

    // Method 'CancelJob'

    /**
     * Call the method 'CancelJob'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'CancelJob'</b>:
     *
     * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
     * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
     * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelJobRequest(CancelJobCallbackIF& cb, uint32 id) const;

    // Method 'ClearJobs'

    /**
     * Call the method 'ClearJobs'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ClearJobs'</b>:
     *
     * ClearJobs() flushes the job queue, removing all jobs that are still queued.
     * 		Note that this does not have any effect on jobs whose execution has already begun,
     * 		it only flushes jobs that are queued and have not yet begun execution.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearJobsRequest(ClearJobsCallbackIF& cb) const;

    // Method 'ResetFailed'

    /**
     * Call the method 'ResetFailed'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed() resets the "failed" state of all units.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetFailedRequest(ResetFailedCallbackIF& cb) const;

    // Method 'ListUnits'

    /**
     * Call the method 'ListUnits'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ListUnits'</b>:
     *
     * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
     * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
     *
     *     	The primary unit name as string
     *     	The human readable description string
     *     	The load state (i.e. whether the unit file has been loaded successfully)
     *     	The active state (i.e. whether the unit is currently started or not)
     *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
     *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
     *     	The unit object path
     *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
     *     	The job type as string
     *     	The job object path
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListUnitsRequest(ListUnitsCallbackIF& cb) const;

    // Method 'ListUnitsFiltered'

    /**
     * Call the method 'ListUnitsFiltered'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ListUnitsFiltered'</b>:
     *
     * ListUnitsFiltered
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param unitList If the meaning of "unitList" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListUnitsFilteredRequest(ListUnitsFilteredCallbackIF& cb, const ::std::vector< ::std::string >& unitList) const;

    // Method 'ListJobs'

    /**
     * Call the method 'ListJobs'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ListJobs'</b>:
     *
     * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
     *
     *    		 The numeric job id
     *     	The primary unit name for this job
     *     	The job type as string
     *     	The job state as string
     *     	The job object path
     *     	The unit object path
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListJobsRequest(ListJobsCallbackIF& cb) const;

    // Method 'Subscribe'

    /**
     * Call the method 'Subscribe'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Subscribe'</b>:
     *
     * Subscribe() enables most bus signals to be sent out.
     * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
     * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
     * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubscribeRequest(SubscribeCallbackIF& cb) const;

    // Method 'Unsubscribe'

    /**
     * Call the method 'Unsubscribe'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Unsubscribe'</b>:
     *
     * Unsubscribe
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnsubscribeRequest(UnsubscribeCallbackIF& cb) const;

    // Method 'Dump'

    /**
     * Call the method 'Dump'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Dump'</b>:
     *
     * Dump
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDumpRequest(DumpCallbackIF& cb) const;

    // Method 'CreateSnapshot'

    /**
     * Call the method 'CreateSnapshot'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateSnapshot'</b>:
     *
     * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
     * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
     * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param cleanup If the meaning of "cleanup" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateSnapshotRequest(CreateSnapshotCallbackIF& cb, const ::std::string& name, bool cleanup) const;

    // Method 'RemoveSnapshot'

    /**
     * Call the method 'RemoveSnapshot'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RemoveSnapshot'</b>:
     *
     * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
     * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveSnapshotRequest(RemoveSnapshotCallbackIF& cb, const ::std::string& name) const;

    // Method 'Reload'

    /**
     * Call the method 'Reload'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload() may be invoked to reload all unit files.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadRequest(ReloadCallbackIF& cb) const;

    // Method 'Reexecute'

    /**
     * Call the method 'Reexecute'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Reexecute'</b>:
     *
     * Reexecute() may be invoked to reexecute the main manager process.
     * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReexecuteRequest(ReexecuteCallbackIF& cb) const;

    // Method 'Exit'

    /**
     * Call the method 'Exit'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Exit'</b>:
     *
     * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExitRequest(ExitCallbackIF& cb) const;

    // Method 'Reboot'

    /**
     * Call the method 'Reboot'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Reboot'</b>:
     *
     * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
     * 		Note that this does not shut down any services and immediately transitions into the reboot process.
     * 		These functions are normally only called as last step of shutdown, and should not be called directly.
     * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRebootRequest(RebootCallbackIF& cb) const;

    // Method 'PowerOff'

    /**
     * Call the method 'PowerOff'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'PowerOff'</b>:
     *
     * PowerOff()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPowerOffRequest(PowerOffCallbackIF& cb) const;

    // Method 'Halt'

    /**
     * Call the method 'Halt'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Halt'</b>:
     *
     * Halt()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHaltRequest(HaltCallbackIF& cb) const;

    // Method 'KExec'

    /**
     * Call the method 'KExec'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'KExec'</b>:
     *
     * KExec()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKExecRequest(KExecCallbackIF& cb) const;

    // Method 'SwitchRoot'

    /**
     * Call the method 'SwitchRoot'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SwitchRoot'</b>:
     *
     * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
     *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
     *  		in which case it is automatically searched for).
     *  		The state of the system manager will be serialized before the transition.
     *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param new_root If the meaning of "new_root" isn't clear, then there should be a description here.
     *
     * @param init If the meaning of "init" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchRootRequest(SwitchRootCallbackIF& cb, const ::std::string& new_root, const ::std::string& init) const;

    // Method 'SetEnvironment'

    /**
     * Call the method 'SetEnvironment'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetEnvironment'</b>:
     *
     * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
     * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param names If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetEnvironmentRequest(SetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& names) const;

    // Method 'UnsetEnvironment'

    /**
     * Call the method 'UnsetEnvironment'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnsetEnvironment'</b>:
     *
     * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
     * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
     * 		This call has no effect for variables that were previously not set, but will not fail in that case.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param names If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnsetEnvironmentRequest(UnsetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& names) const;

    // Method 'UnsetAndSetEnvironment'

    /**
     * Call the method 'UnsetAndSetEnvironment'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'UnsetAndSetEnvironment'</b>:
     *
     * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
     * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
     * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param unset If the meaning of "unset" isn't clear, then there should be a description here.
     *
     * @param set If the meaning of "set" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnsetAndSetEnvironmentRequest(UnsetAndSetEnvironmentCallbackIF& cb, const ::std::vector< ::std::string >& unset, const ::std::vector< ::std::string >& set) const;

    // Method 'ListUnitFiles'

    /**
     * Call the method 'ListUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ListUnitFiles'</b>:
     *
     * ListUnitFiles() returns an array of unit names plus their enablement status.
     * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
     * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
     * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListUnitFilesRequest(ListUnitFilesCallbackIF& cb) const;

    // Method 'GetUnitFileState'

    /**
     * Call the method 'GetUnitFileState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetUnitFileState'</b>:
     *
     * GetUnitFileState() returns the current enablement status of specific unit file.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param file If the meaning of "file" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetUnitFileStateRequest(GetUnitFileStateCallbackIF& cb, const ::std::string& file) const;

    // Method 'EnableUnitFiles'

    /**
     * Call the method 'EnableUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'EnableUnitFiles'</b>:
     *
     * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
     * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
     * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
     * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
     * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
     * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
     * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableUnitFilesRequest(EnableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const;

    // Method 'DisableUnitFiles'

    /**
     * Call the method 'DisableUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DisableUnitFiles'</b>:
     *
     * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisableUnitFilesRequest(DisableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime) const;

    // Method 'ReenableUnitFiles'

    /**
     * Call the method 'ReenableUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReenableUnitFiles'</b>:
     *
     * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
     * 		unit quickly one after the other in an atomic fashion.
     * 		This is useful to apply updated [Install] information contained in unit files.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReenableUnitFilesRequest(ReenableUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const;

    // Method 'LinkUnitFiles'

    /**
     * Call the method 'LinkUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'LinkUnitFiles'</b>:
     *
     * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLinkUnitFilesRequest(LinkUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const;

    // Method 'PresetUnitFiles'

    /**
     * Call the method 'PresetUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'PresetUnitFiles'</b>:
     *
     * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPresetUnitFilesRequest(PresetUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const;

    // Method 'PresetUnitFilesWithMode'

    /**
     * Call the method 'PresetUnitFilesWithMode'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'PresetUnitFilesWithMode'</b>:
     *
     * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPresetUnitFilesWithModeRequest(PresetUnitFilesWithModeCallbackIF& cb, const ::std::vector< ::std::string >& files, const ::std::string& mode, bool runtime, bool force) const;

    // Method 'MaskUnitFiles'

    /**
     * Call the method 'MaskUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'MaskUnitFiles'</b>:
     *
     * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaskUnitFilesRequest(MaskUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime, bool force) const;

    // Method 'UnmaskUnitFiles'

    /**
     * Call the method 'UnmaskUnitFiles'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnmaskUnitFiles'</b>:
     *
     * UnmaskUnitFiles()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnmaskUnitFilesRequest(UnmaskUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, bool runtime) const;

    // Method 'SetDefaultTarget'

    /**
     * Call the method 'SetDefaultTarget'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetDefaultTarget'</b>:
     *
     * SetDefaultTarget() changes the default.target link.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param arg_0 If the meaning of "arg_0" isn't clear, then there should be a description here.
     *
     * @param arg_1 If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDefaultTargetRequest(SetDefaultTargetCallbackIF& cb, const ::std::string& arg_0, bool arg_1) const;

    // Method 'GetDefaultTarget'

    /**
     * Call the method 'GetDefaultTarget'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetDefaultTarget'</b>:
     *
     * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDefaultTargetRequest(GetDefaultTargetCallbackIF& cb) const;

    // Method 'PresetAllUnitFiles'

    /**
     * Call the method 'PresetAllUnitFiles'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'PresetAllUnitFiles'</b>:
     *
     * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPresetAllUnitFilesRequest(PresetAllUnitFilesCallbackIF& cb, const ::std::string& name, bool runtime, bool force) const;

    // Method 'AddDependencyUnitFiles'

    /**
     * Call the method 'AddDependencyUnitFiles'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'AddDependencyUnitFiles'</b>:
     *
     * AddDependencyUnitFiles()
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param arg_1 If the meaning of "arg_1" isn't clear, then there should be a description here.
     *
     * @param arg_2 If the meaning of "arg_2" isn't clear, then there should be a description here.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param force If the meaning of "force" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddDependencyUnitFilesRequest(AddDependencyUnitFilesCallbackIF& cb, const ::std::vector< ::std::string >& files, const ::std::string& arg_1, const ::std::string& arg_2, bool runtime, bool force) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Version'

    ::asf::core::nullable< VersionUpdate > _version;

    // Property 'Features'

    ::asf::core::nullable< FeaturesUpdate > _features;

    // Property 'Virtualization'

    ::asf::core::nullable< VirtualizationUpdate > _virtualization;

    // Property 'Architecture'

    ::asf::core::nullable< ArchitectureUpdate > _architecture;

    // Property 'Tainted'

    ::asf::core::nullable< TaintedUpdate > _tainted;

    // Property 'FirmwareTimestamp'

    ::asf::core::nullable< FirmwareTimestampUpdate > _firmwareTimestamp;

    // Property 'FirmwareTimestampMonotonic'

    ::asf::core::nullable< FirmwareTimestampMonotonicUpdate > _firmwareTimestampMonotonic;

    // Property 'LoaderTimestamp'

    ::asf::core::nullable< LoaderTimestampUpdate > _loaderTimestamp;

    // Property 'LoaderTimestampMonotonic'

    ::asf::core::nullable< LoaderTimestampMonotonicUpdate > _loaderTimestampMonotonic;

    // Property 'KernelTimestamp'

    ::asf::core::nullable< KernelTimestampUpdate > _kernelTimestamp;

    // Property 'KernelTimestampMonotonic'

    ::asf::core::nullable< KernelTimestampMonotonicUpdate > _kernelTimestampMonotonic;

    // Property 'InitRDTimestamp'

    ::asf::core::nullable< InitRDTimestampUpdate > _initRDTimestamp;

    // Property 'InitRDTimestampMonotonic'

    ::asf::core::nullable< InitRDTimestampMonotonicUpdate > _initRDTimestampMonotonic;

    // Property 'UserspaceTimestamp'

    ::asf::core::nullable< UserspaceTimestampUpdate > _userspaceTimestamp;

    // Property 'UserspaceTimestampMonotonic'

    ::asf::core::nullable< UserspaceTimestampMonotonicUpdate > _userspaceTimestampMonotonic;

    // Property 'FinishTimestamp'

    ::asf::core::nullable< FinishTimestampUpdate > _finishTimestamp;

    // Property 'FinishTimestampMonotonic'

    ::asf::core::nullable< FinishTimestampMonotonicUpdate > _finishTimestampMonotonic;

    // Property 'SecurityStartTimestamp'

    ::asf::core::nullable< SecurityStartTimestampUpdate > _securityStartTimestamp;

    // Property 'SecurityStartTimestampMonotonic'

    ::asf::core::nullable< SecurityStartTimestampMonotonicUpdate > _securityStartTimestampMonotonic;

    // Property 'SecurityFinishTimestamp'

    ::asf::core::nullable< SecurityFinishTimestampUpdate > _securityFinishTimestamp;

    // Property 'SecurityFinishTimestampMonotonic'

    ::asf::core::nullable< SecurityFinishTimestampMonotonicUpdate > _securityFinishTimestampMonotonic;

    // Property 'GeneratorsStartTimestamp'

    ::asf::core::nullable< GeneratorsStartTimestampUpdate > _generatorsStartTimestamp;

    // Property 'GeneratorsStartTimestampMonotonic'

    ::asf::core::nullable< GeneratorsStartTimestampMonotonicUpdate > _generatorsStartTimestampMonotonic;

    // Property 'GeneratorsFinishTimestamp'

    ::asf::core::nullable< GeneratorsFinishTimestampUpdate > _generatorsFinishTimestamp;

    // Property 'GeneratorsFinishTimestampMonotonic'

    ::asf::core::nullable< GeneratorsFinishTimestampMonotonicUpdate > _generatorsFinishTimestampMonotonic;

    // Property 'UnitsLoadStartTimestamp'

    ::asf::core::nullable< UnitsLoadStartTimestampUpdate > _unitsLoadStartTimestamp;

    // Property 'UnitsLoadStartTimestampMonotonic'

    ::asf::core::nullable< UnitsLoadStartTimestampMonotonicUpdate > _unitsLoadStartTimestampMonotonic;

    // Property 'UnitsLoadFinishTimestamp'

    ::asf::core::nullable< UnitsLoadFinishTimestampUpdate > _unitsLoadFinishTimestamp;

    // Property 'UnitsLoadFinishTimestampMonotonic'

    ::asf::core::nullable< UnitsLoadFinishTimestampMonotonicUpdate > _unitsLoadFinishTimestampMonotonic;

    // Property 'LogLevel'

    ::asf::core::nullable< LogLevelUpdate > _logLevel;

    // Property 'LogTarget'

    ::asf::core::nullable< LogTargetUpdate > _logTarget;

    // Property 'NNames'

    ::asf::core::nullable< NNamesUpdate > _nNames;

    // Property 'NFailedUnits'

    ::asf::core::nullable< NFailedUnitsUpdate > _nFailedUnits;

    // Property 'NJobs'

    ::asf::core::nullable< NJobsUpdate > _nJobs;

    // Property 'NInstalledJobs'

    ::asf::core::nullable< NInstalledJobsUpdate > _nInstalledJobs;

    // Property 'NFailedJobs'

    ::asf::core::nullable< NFailedJobsUpdate > _nFailedJobs;

    // Property 'Progress'

    ::asf::core::nullable< ProgressUpdate > _progress;

    // Property 'Environment'

    ::asf::core::nullable< EnvironmentUpdate > _environment;

    // Property 'ConfirmSpawn'

    ::asf::core::nullable< ConfirmSpawnUpdate > _confirmSpawn;

    // Property 'ShowStatus'

    ::asf::core::nullable< ShowStatusUpdate > _showStatus;

    // Property 'UnitPath'

    ::asf::core::nullable< UnitPathUpdate > _unitPath;

    // Property 'DefaultStandardOutput'

    ::asf::core::nullable< DefaultStandardOutputUpdate > _defaultStandardOutput;

    // Property 'DefaultStandardError'

    ::asf::core::nullable< DefaultStandardErrorUpdate > _defaultStandardError;

    // Property 'RuntimeWatchdogUSec'

    ::asf::core::nullable< RuntimeWatchdogUSecUpdate > _runtimeWatchdogUSec;

    // Property 'ShutdownWatchdogUSec'

    ::asf::core::nullable< ShutdownWatchdogUSecUpdate > _shutdownWatchdogUSec;

    // Property 'ControlGroup'

    ::asf::core::nullable< ControlGroupUpdate > _controlGroup;

    // Property 'SystemState'

    ::asf::core::nullable< SystemStateUpdate > _systemState;

    DECLARE_CLASS_LOGGER();

    friend class ManagerProxyCallback;
};

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_MANAGERPROXY_H
