/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_JOBSTUB_H
#define ORG_FREEDESKTOP_SYSTEMD1_JOBSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Job.h"
#include <string>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Job {

class JobStubDelegate;

class JobStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the JobStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    JobStub (const std::string& portName);

    /**
     * Create an instance of the JobStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    JobStub (const std::string& portName, const std::string& objectPath);

    virtual ~JobStub();

    // property 'Id'

    /**
     * The method onIdGet() is called by ASF when a client invokes the read
     * method for the property 'Id'. The onIdGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     */
    virtual void onIdGet(const ::boost::shared_ptr< IdGet >& payload);

    /**
     * Sends back the update to a previous onIdGet().
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @param act Identifies a previous invocation of onIdGet(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendIdGetUpdate(uint32 id, act_t act = 0);

    /**
     * Set the value of the property 'Id' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     */
    void setId(uint32 id);

    /**
     * Returns the current value of the property 'Id'.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     */
    uint32 getId() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIdUpdate().
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     */
    void sendIdUpdate();

    // property 'Unit'

    /**
     * The method onUnitGet() is called by ASF when a client invokes the read
     * method for the property 'Unit'. The onUnitGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     */
    virtual void onUnitGet(const ::boost::shared_ptr< UnitGet >& payload);

    /**
     * Sends back the update to a previous onUnitGet().
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @param act Identifies a previous invocation of onUnitGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUnitGetUpdate(const unit& unit, act_t act = 0);

    /**
     * Set the value of the property 'Unit' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     */
    void setUnit(const unit& unit);

    /**
     * Returns the current value of the property 'Unit'.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     */
    const unit& getUnit() const;

    /**
     * Returns the current value of the property 'Unit' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUnitUpdate() method.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     */
    unit& getUnitMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitUpdate().
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     */
    void sendUnitUpdate();

    // property 'JobType'

    /**
     * The method onJobTypeGet() is called by ASF when a client invokes the
     * read method for the property 'JobType'. The onJobTypeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     */
    virtual void onJobTypeGet(const ::boost::shared_ptr< JobTypeGet >& payload);

    /**
     * Sends back the update to a previous onJobTypeGet().
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param act Identifies a previous invocation of onJobTypeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendJobTypeGetUpdate(const ::std::string& jobType, act_t act = 0);

    /**
     * Set the value of the property 'JobType' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     */
    void setJobType(const ::std::string& jobType);

    /**
     * Returns the current value of the property 'JobType'.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     */
    const ::std::string& getJobType() const;

    /**
     * Returns the current value of the property 'JobType' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendJobTypeUpdate() method.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     */
    ::std::string& getJobTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJobTypeUpdate().
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     */
    void sendJobTypeUpdate();

    // property 'State'

    /**
     * The method onStateGet() is called by ASF when a client invokes the read
     * method for the property 'State'. The onStateGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     */
    virtual void onStateGet(const ::boost::shared_ptr< StateGet >& payload);

    /**
     * Sends back the update to a previous onStateGet().
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param act Identifies a previous invocation of onStateGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStateGetUpdate(const ::std::string& state, act_t act = 0);

    /**
     * Set the value of the property 'State' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     */
    void setState(const ::std::string& state);

    /**
     * Returns the current value of the property 'State'.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     */
    const ::std::string& getState() const;

    /**
     * Returns the current value of the property 'State' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStateUpdate() method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     */
    ::std::string& getStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStateUpdate().
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     */
    void sendStateUpdate();

    // method 'Cancel'

    /**
     * The method onCancel() is called by ASF when a client invokes the method
     * 'Cancel'. A subclass has to implement this method and send back a
     * response to the client either with the sendCancel() or
     * sendCancelError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * Cancel:
     * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
     * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
     * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
     * 		which is sometimes useful to reduce roundtrips.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRequest (const ::boost::shared_ptr< CancelRequest >& request) = 0;

    /**
     * The method sendCancelResponse() sends a response of a previous method
     * invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * Cancel:
     * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
     * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
     * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
     * 		which is sometimes useful to reduce roundtrips.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancel(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelResponse (act_t act = 0);

    /**
     * The method sendCancelError() sends an error response of a previous
     * method invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * Cancel:
     * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
     * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
     * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
     * 		which is sometimes useful to reduce roundtrips.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancel(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    IdUpdate _IdProperty;

    UnitUpdate _UnitProperty;

    JobTypeUpdate _JobTypeProperty;

    StateUpdate _StateProperty;

    friend class JobStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Job
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_JOBSTUB_H
