/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Job.h"
#include "org/freedesktop/systemd1/JobDBus.h"
#include "org/freedesktop/systemd1/JobJson.h"
#include "org/freedesktop/systemd1/JobStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Job {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Job", JobStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Cancel", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 2, "Id", 0 },
    { 4, "Unit", 1 },
    { 5, "State", 3 },
    { 7, "JobType", 2 },
};

class JobStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    JobStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    JobStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    JobStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.systemd1.Job"),
          _logger(logger) {}

    virtual ~JobStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void JobStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Cancel'

            LOG_DEBUG_STUB("process method '%s'", "Cancel");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Cancel", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelRequest > payload = ::boost::static_pointer_cast<CancelRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<JobStub*>(getStub())->onCancelRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* JobStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.systemd1.Job\">\n"
            "    <property access=\"read\" name=\"Id\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Unit\" type=\"(ss)\"/>\n"
            "    <property access=\"read\" name=\"JobType\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"State\" type=\"s\"/>\n"
            "    <method name=\"Cancel\">\n"
            "      <doc>\n"
            "        <line>Cancel = Cancel:</line>\n"
            "        <line>The method cancels the job. Note that this will remove a job from the queue if it is not yet executed</line>\n"
            "        <line>but generally will not cause a job that is already in the process of being executed to be aborted. This operation</line>\n"
            "        <line>may also be requested via the ?CancelJob() method of the Manager object (see above),</line>\n"
            "        <line>which is sometimes useful to reduce roundtrips.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "</interface>\n";
}

void JobStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<JobStub*>(getStub()))->onGetAll (properties);
}

void JobStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Id");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Unit");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "JobType");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void JobStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Id");
            ::boost::shared_ptr< IdGet > payload(new IdGet());
            payload->setAct(act);
            static_cast<JobStub*>(getStub())->onIdGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Unit");
            ::boost::shared_ptr< UnitGet > payload(new UnitGet());
            payload->setAct(act);
            static_cast<JobStub*>(getStub())->onUnitGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "JobType");
            ::boost::shared_ptr< JobTypeGet > payload(new JobTypeGet());
            payload->setAct(act);
            static_cast<JobStub*>(getStub())->onJobTypeGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            ::boost::shared_ptr< StateGet > payload(new StateGet());
            payload->setAct(act);
            static_cast<JobStub*>(getStub())->onStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

JobStub::JobStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new JobStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

JobStub::JobStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new JobStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

JobStub::~JobStub() {
    delete _stubDelegate;
}

void JobStub::sendIdUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IdUpdate payload(_IdProperty);

        LOG_INFO ("-> send%s", "IdUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Id", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Job", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IdUpdate");
    }
}

void JobStub::onIdGet(const ::boost::shared_ptr< IdGet >& id) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IdGet", id->getAct());
    sendIdGetUpdate(_IdProperty.getId(), id->getAct());
}

void JobStub::sendIdGetUpdate(uint32 id, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IdGet payload(id);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IdGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void JobStub::setId(uint32 id) {
    if(id!=_IdProperty.getId()) {
        _IdProperty.setId(id);
        sendIdUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 JobStub::getId() const {
    return _IdProperty.getId();
}

void JobStub::sendUnitUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitUpdate payload(_UnitProperty);

        LOG_INFO ("-> send%s", "UnitUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Unit", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Job", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitUpdate");
    }
}

void JobStub::onUnitGet(const ::boost::shared_ptr< UnitGet >& unit) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitGet", unit->getAct());
    sendUnitGetUpdate(_UnitProperty.getUnit(), unit->getAct());
}

void JobStub::sendUnitGetUpdate(const unit& unit, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitGet payload(unit);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void JobStub::setUnit(const unit& unit) {
    if(unit!=_UnitProperty.getUnit()) {
        _UnitProperty.setUnit(unit);
        sendUnitUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const unit& JobStub::getUnit() const {
    return _UnitProperty.getUnit();
}

unit& JobStub::getUnitMutable() {
    return _UnitProperty.getUnitMutable();
}

void JobStub::sendJobTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JobTypeUpdate payload(_JobTypeProperty);

        LOG_INFO ("-> send%s", "JobTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("JobType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Job", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JobTypeUpdate");
    }
}

void JobStub::onJobTypeGet(const ::boost::shared_ptr< JobTypeGet >& jobType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JobTypeGet", jobType->getAct());
    sendJobTypeGetUpdate(_JobTypeProperty.getJobType(), jobType->getAct());
}

void JobStub::sendJobTypeGetUpdate(const ::std::string& jobType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JobTypeGet payload(jobType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JobTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void JobStub::setJobType(const ::std::string& jobType) {
    if(jobType!=_JobTypeProperty.getJobType()) {
        _JobTypeProperty.setJobType(jobType);
        sendJobTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& JobStub::getJobType() const {
    return _JobTypeProperty.getJobType();
}

::std::string& JobStub::getJobTypeMutable() {
    return _JobTypeProperty.getJobTypeMutable();
}

void JobStub::sendStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StateUpdate payload(_StateProperty);

        LOG_INFO ("-> send%s", "StateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("State", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Job", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StateUpdate");
    }
}

void JobStub::onStateGet(const ::boost::shared_ptr< StateGet >& state) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StateGet", state->getAct());
    sendStateGetUpdate(_StateProperty.getState(), state->getAct());
}

void JobStub::sendStateGetUpdate(const ::std::string& state, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StateGet payload(state);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void JobStub::setState(const ::std::string& state) {
    if(state!=_StateProperty.getState()) {
        _StateProperty.setState(state);
        sendStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& JobStub::getState() const {
    return _StateProperty.getState();
}

::std::string& JobStub::getStateMutable() {
    return _StateProperty.getStateMutable();
}

void  JobStub::sendCancelResponse (act_t act) {
    CancelResponse* payload = new CancelResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Cancel", CancelResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  JobStub::sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelError* payload = new CancelError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Cancel", CancelError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Cancel", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void JobStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Id'
    {
        ::asf::dbus::DBusVariant variant;
        IdGet payload(_IdProperty.getId());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Id", variant));
    }

    //property 'Unit'
    {
        ::asf::dbus::DBusVariant variant;
        UnitGet payload(_UnitProperty.getUnit());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Unit", variant));
    }

    //property 'JobType'
    {
        ::asf::dbus::DBusVariant variant;
        JobTypeGet payload(_JobTypeProperty.getJobType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("JobType", variant));
    }

    //property 'State'
    {
        ::asf::dbus::DBusVariant variant;
        StateGet payload(_StateProperty.getState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("State", variant));
    }
}

} // namespace Job
} // namespace systemd1
} // namespace freedesktop
} // namespace org
