/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_JOBPROXY_H
#define ORG_FREEDESKTOP_SYSTEMD1_JOBPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/freedesktop/systemd1/Job.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Job {

class JobProxy;

class CancelCallbackIF {
public:
    virtual ~CancelCallbackIF() {}

    virtual void onCancelError(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< CancelError >& error) = 0;

    virtual void onCancelResponse(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response) = 0;
};

class IdCallbackIF {
public:
    virtual ~IdCallbackIF() {}

    virtual void onIdError(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< IdError >& error) = 0;

    virtual void onIdUpdate(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< IdUpdate >& update) = 0;
};

class JobTypeCallbackIF {
public:
    virtual ~JobTypeCallbackIF() {}

    virtual void onJobTypeError(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< JobTypeError >& error) = 0;

    virtual void onJobTypeUpdate(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< JobTypeUpdate >& update) = 0;
};

class StateCallbackIF {
public:
    virtual ~StateCallbackIF() {}

    virtual void onStateError(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< StateError >& error) = 0;

    virtual void onStateUpdate(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< StateUpdate >& update) = 0;
};

class UnitCallbackIF {
public:
    virtual ~UnitCallbackIF() {}

    virtual void onUnitError(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< UnitError >& error) = 0;

    virtual void onUnitUpdate(const ::boost::shared_ptr< JobProxy >& proxy, const ::boost::shared_ptr< UnitUpdate >& update) = 0;
};


/**
 * JobProxy is the client side representation of the D-Bus service
 * interface 'org.freedesktop.systemd1.Job' (specified in file
 * DBusJob_.xml).
 *
 * org.freedesktop.systemd1.Job:
 *     short_description: All Job objects implement the generic org.freedesktop.systemd1.Job interface.
 */
class JobProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of JobProxy.
     */
    static ::boost::shared_ptr< JobProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of JobProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< JobProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of JobProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< JobProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< JobProxy > proxyNew(new JobProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~JobProxy ();



    // Property 'Id'

    /**
     * Notify on the property 'Id'. This method registers for property changes
     * by D-Bus service.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIdRegister(IdCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Id'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @param act The act which was previously returned by the
     * sendIdRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIdDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Id'.
     */
    void sendIdDeregisterAll() const;

    /**
     * Request the value of the property 'Id' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id is the numeric Id of the job. During the runtime of a systemd instance each numeric ID is
     * 		only assigned once.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIdGet(IdCallbackIF& cb);


    /**
     * Returns the current value of the property 'Id' (as known by the proxy).
     * This method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when hasId() returns true.
     *
     * @return the previously received value of the property 'Id'.
     */
    uint32 getId() const;

    /**
     * Determines whether a status message for the property 'Id' was received
     * before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasId() const;

    // Property 'Unit'

    /**
     * Notify on the property 'Unit'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitRegister(UnitCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Unit'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @param act The act which was previously returned by the
     * sendUnitRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Unit'.
     */
    void sendUnitDeregisterAll() const;

    /**
     * Request the value of the property 'Unit' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Unit'</b>:
     *
     * Unit refers to the unit this job belongs two. It is a structure consisting of the name of the unit
     * 		and a bus path to the unit's object.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitGet(UnitCallbackIF& cb);


    /**
     * Returns the current value of the property 'Unit' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasUnit()
     * returns true.
     *
     * @return the previously received value of the property 'Unit'.
     */
    const unit& getUnit() const;

    /**
     * Determines whether a status message for the property 'Unit' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnit() const;

    // Property 'JobType'

    /**
     * Notify on the property 'JobType'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTypeRegister(JobTypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'JobType'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param act The act which was previously returned by the
     * sendJobTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'JobType'.
     */
    void sendJobTypeDeregisterAll() const;

    /**
     * Request the value of the property 'JobType' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'JobType'</b>:
     *
     * JobType refers to the job's type and is one of start, verify-active, stop, reload, restart,
     * 		try-restart, reload-or-start. Note that later versions might define additional values.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTypeGet(JobTypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'JobType' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasJobType()
     * returns true.
     *
     * @return the previously received value of the property 'JobType'.
     */
    const ::std::string& getJobType() const;

    /**
     * Determines whether a status message for the property 'JobType' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJobType() const;

    // Property 'State'

    /**
     * Notify on the property 'State'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateRegister(StateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'State'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param act The act which was previously returned by the
     * sendStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'State'.
     */
    void sendStateDeregisterAll() const;

    /**
     * Request the value of the property 'State' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'State'</b>:
     *
     * State  refers to the job's state and is one of waiting and running. The former indicates that a job
     * 		is currently queued but has not begun to execute yet, the latter indicates that a job is currently being executed.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateGet(StateCallbackIF& cb);


    /**
     * Returns the current value of the property 'State' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasState()
     * returns true.
     *
     * @return the previously received value of the property 'State'.
     */
    const ::std::string& getState() const;

    /**
     * Determines whether a status message for the property 'State' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasState() const;


    // Method 'Cancel'

    /**
     * Call the method 'Cancel'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * Cancel:
     * 		The method cancels the job. Note that this will remove a job from the queue if it is not yet executed
     * 		but generally will not cause a job that is already in the process of being executed to be aborted. This operation
     * 		may also be requested via the ?CancelJob() method of the Manager object (see above),
     * 		which is sometimes useful to reduce roundtrips.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequest(CancelCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    JobProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Id'

    ::asf::core::nullable< IdUpdate > _id;

    // Property 'Unit'

    ::asf::core::nullable< UnitUpdate > _unit;

    // Property 'JobType'

    ::asf::core::nullable< JobTypeUpdate > _jobType;

    // Property 'State'

    ::asf::core::nullable< StateUpdate > _state;

    DECLARE_CLASS_LOGGER();

    friend class JobProxyCallback;
};

} // namespace Job
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_JOBPROXY_H
