/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SYNCDISPLAY_MAIN_FIPROXY_H
#define SYNCDISPLAY_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "syncdisplay_main_fi.h"

namespace syncdisplay_main_fi {

class Syncdisplay_main_fiProxy;

class AnimationStatusCallbackIF {
public:
    virtual ~AnimationStatusCallbackIF() {}

    virtual void onAnimationStatusError(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< AnimationStatusError >& error) = 0;

    virtual void onAnimationStatusStatus(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< AnimationStatusStatus >& status) = 0;
};

class EarlyVideoLayerStatusCallbackIF {
public:
    virtual ~EarlyVideoLayerStatusCallbackIF() {}

    virtual void onEarlyVideoLayerStatusError(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< EarlyVideoLayerStatusError >& error) = 0;

    virtual void onEarlyVideoLayerStatusStatus(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< EarlyVideoLayerStatusStatus >& status) = 0;
};

class SetAnimationRunCallbackIF {
public:
    virtual ~SetAnimationRunCallbackIF() {}

    virtual void onSetAnimationRunError(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAnimationRunError >& error) = 0;

    virtual void onSetAnimationRunResult(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAnimationRunResult >& result) = 0;
};

class SetAnimationStopCallbackIF {
public:
    virtual ~SetAnimationStopCallbackIF() {}

    virtual void onSetAnimationStopError(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAnimationStopError >& error) = 0;

    virtual void onSetAnimationStopResult(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAnimationStopResult >& result) = 0;
};

class SetFirstScreenReadyCallbackIF {
public:
    virtual ~SetFirstScreenReadyCallbackIF() {}

    virtual void onSetFirstScreenReadyError(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFirstScreenReadyError >& error) = 0;

    virtual void onSetFirstScreenReadyResult(const ::boost::shared_ptr< Syncdisplay_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFirstScreenReadyResult >& result) = 0;
};

class Syncdisplay_main_fiProxyCallback;

/**
 * Syncdisplay_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'syncdisplay_main_fi' (specified in file
 * syncdisplay_main_fi.xml).
 *
 * CCA Functional Interface 'syncdisplay_main_fi'
 *
 * Fullname: Display Synchornization. Handle Animation, First Screen, Backlight.
 *
 * Version: $Revision:   1.0.0  $
 *
 * Author: Klaus-Peter Kollai
 *
 * Date: $Date:  18.10.2015  $
 *
 * Department:
 *
 * Title: syncdisplay_fi
 *
 * <b>Description of 'syncdisplay_main_fi':</b>
 *
 * CCA_C_U16_SRV_SYNC_DISPLAY -- Service 0x61 (97)
 */
class Syncdisplay_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Syncdisplay_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Syncdisplay_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Syncdisplay_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Syncdisplay_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Syncdisplay_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Syncdisplay_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Syncdisplay_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Syncdisplay_main_fiProxy();

    // Method 'SetFirstScreenReady'

    /**
     * Call the method 'SetFirstScreenReady'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetFirstScreenReady'</b>:
     *
     * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param T_tU8_ScreenType Set when a screen is available on layer.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFirstScreenReadyStart(SetFirstScreenReadyCallbackIF& cb, uint8 t_tU8_ScreenType);

    // Method 'SetAnimationRun'

    /**
     * Call the method 'SetAnimationRun'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetAnimationRun'</b>:
     *
     * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param T_tU8_PlayRun Set the Animation to run.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAnimationRunStart(SetAnimationRunCallbackIF& cb, uint8 t_tU8_PlayRun);

    // Method 'SetAnimationStop'

    /**
     * Call the method 'SetAnimationStop'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetAnimationStop'</b>:
     *
     * This method is used to set the status to stop, which stops the animation.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param T_tU8_PlayStop Set the Animation to stop.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAnimationStopStart(SetAnimationStopCallbackIF& cb, uint8 t_tU8_PlayStop);

    // Property 'EarlyVideoLayerStatus'

    /**
     * Notify on the property 'EarlyVideoLayerStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'EarlyVideoLayerStatus'</b>:
     *
     * This property gives information about the current status of the early video layer (Rvc, Animation).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEarlyVideoLayerStatusUpReg(EarlyVideoLayerStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'EarlyVideoLayerStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'EarlyVideoLayerStatus'</b>:
     *
     * This property gives information about the current status of the early video layer (Rvc, Animation).
     *
     * @param act The act which was previously returned by the
     * sendEarlyVideoLayerStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEarlyVideoLayerStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'EarlyVideoLayerStatus'.
     */
    void sendEarlyVideoLayerStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'EarlyVideoLayerStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasEarlyVideoLayerStatus() returns true.
     *
     * @return the previously received value of the property 'EarlyVideoLayerStatus'.
     */
    const EarlyVideoLayerStatusStatus& getEarlyVideoLayerStatus() const;

    /**
     * Determines whether a status message for the property 'EarlyVideoLayerStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEarlyVideoLayerStatus() const;

    /**
     * Request the value of the property 'EarlyVideoLayerStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'EarlyVideoLayerStatus'</b>:
     *
     * This property gives information about the current status of the early video layer (Rvc, Animation).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEarlyVideoLayerStatusGet(EarlyVideoLayerStatusCallbackIF& cb);

    // Property 'AnimationStatus'

    /**
     * Notify on the property 'AnimationStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AnimationStatus'</b>:
     *
     * This property gives information about the current settings of the animation.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAnimationStatusUpReg(AnimationStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AnimationStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AnimationStatus'</b>:
     *
     * This property gives information about the current settings of the animation.
     *
     * @param act The act which was previously returned by the
     * sendAnimationStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAnimationStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AnimationStatus'.
     */
    void sendAnimationStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'AnimationStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAnimationStatus() returns true.
     *
     * @return the previously received value of the property 'AnimationStatus'.
     */
    const AnimationStatusStatus& getAnimationStatus() const;

    /**
     * Determines whether a status message for the property 'AnimationStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAnimationStatus() const;

    /**
     * Request the value of the property 'AnimationStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AnimationStatus'</b>:
     *
     * This property gives information about the current settings of the animation.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAnimationStatusGet(AnimationStatusCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Syncdisplay_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'EarlyVideoLayerStatus'

    ::asf::core::nullable< EarlyVideoLayerStatusStatus > _earlyVideoLayerStatus;

    // Property 'AnimationStatus'

    ::asf::core::nullable< AnimationStatusStatus > _animationStatus;

    DECLARE_CLASS_LOGGER();

    friend class Syncdisplay_main_fiProxyCallback;
};

} // namespace syncdisplay_main_fi

#endif // SYNCDISPLAY_MAIN_FIPROXY_H
