/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "syncdisplay_main_fiCca.h"
#include "syncdisplay_main_fiJson.h"
#include "syncdisplay_main_fiProxy.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace syncdisplay_main_fi {

/*static*/ ::asf::core::Logger Syncdisplay_main_fiProxy::_logger ("/syncdisplay_main_fi/Syncdisplay_main_fiProxy");


class Syncdisplay_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Syncdisplay_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Syncdisplay_main_fiProxy> proxy = ::boost::static_pointer_cast<Syncdisplay_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_SetFirstScreenReady: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetFirstScreenReadyResult);
                                setActAndLogResult(message, "SetFirstScreenReady", reinterpret_cast<act_t>(this), _logger);
                                ((SetFirstScreenReadyCallbackIF*) _callback)->onSetFirstScreenReadyResult (proxy, ::boost::static_pointer_cast<SetFirstScreenReadyResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetFirstScreenReadyError);
                                setActAndLogError(message, "SetFirstScreenReady", reinterpret_cast<act_t>(this), _logger);
                                ((SetFirstScreenReadyCallbackIF*) _callback)->onSetFirstScreenReadyError (proxy, ::boost::static_pointer_cast<SetFirstScreenReadyError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetAnimationRun: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetAnimationRunResult);
                                setActAndLogResult(message, "SetAnimationRun", reinterpret_cast<act_t>(this), _logger);
                                ((SetAnimationRunCallbackIF*) _callback)->onSetAnimationRunResult (proxy, ::boost::static_pointer_cast<SetAnimationRunResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetAnimationRunError);
                                setActAndLogError(message, "SetAnimationRun", reinterpret_cast<act_t>(this), _logger);
                                ((SetAnimationRunCallbackIF*) _callback)->onSetAnimationRunError (proxy, ::boost::static_pointer_cast<SetAnimationRunError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetAnimationStop: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetAnimationStopResult);
                                setActAndLogResult(message, "SetAnimationStop", reinterpret_cast<act_t>(this), _logger);
                                ((SetAnimationStopCallbackIF*) _callback)->onSetAnimationStopResult (proxy, ::boost::static_pointer_cast<SetAnimationStopResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::SetAnimationStopError);
                                setActAndLogError(message, "SetAnimationStop", reinterpret_cast<act_t>(this), _logger);
                                ((SetAnimationStopCallbackIF*) _callback)->onSetAnimationStopError (proxy, ::boost::static_pointer_cast<SetAnimationStopError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EarlyVideoLayerStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::EarlyVideoLayerStatusStatus);
                                setActAndLogStatus(message, "EarlyVideoLayerStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EarlyVideoLayerStatusStatus> payload = ::boost::static_pointer_cast<EarlyVideoLayerStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EarlyVideoLayerStatusStatus >& refNullableStatus = proxy->_earlyVideoLayerStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EarlyVideoLayerStatusCallbackIF*) _callback)->onEarlyVideoLayerStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EarlyVideoLayerStatusCallbackIF*) _callback)->onEarlyVideoLayerStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::EarlyVideoLayerStatusError);
                                setActAndLogError(message, "EarlyVideoLayerStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EarlyVideoLayerStatusCallbackIF*) _callback)->onEarlyVideoLayerStatusError(proxy, ::boost::static_pointer_cast<EarlyVideoLayerStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AnimationStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::AnimationStatusStatus);
                                setActAndLogStatus(message, "AnimationStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AnimationStatusStatus> payload = ::boost::static_pointer_cast<AnimationStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AnimationStatusStatus >& refNullableStatus = proxy->_animationStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AnimationStatusCallbackIF*) _callback)->onAnimationStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AnimationStatusCallbackIF*) _callback)->onAnimationStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::syncdisplay_main_fi::AnimationStatusError);
                                setActAndLogError(message, "AnimationStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AnimationStatusCallbackIF*) _callback)->onAnimationStatusError(proxy, ::boost::static_pointer_cast<AnimationStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Syncdisplay_main_fiProxy> proxy = ::boost::static_pointer_cast<Syncdisplay_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_SetFirstScreenReady: {
                ::boost::shared_ptr< SetFirstScreenReadyError > payload (new SetFirstScreenReadyError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFirstScreenReady", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFirstScreenReadyCallbackIF*) _callback)->onSetFirstScreenReadyError (proxy, payload);
                return true;
            }
            case FID_SetAnimationRun: {
                ::boost::shared_ptr< SetAnimationRunError > payload (new SetAnimationRunError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAnimationRun", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetAnimationRunCallbackIF*) _callback)->onSetAnimationRunError (proxy, payload);
                return true;
            }
            case FID_SetAnimationStop: {
                ::boost::shared_ptr< SetAnimationStopError > payload (new SetAnimationStopError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAnimationStop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetAnimationStopCallbackIF*) _callback)->onSetAnimationStopError (proxy, payload);
                return true;
            }
            case FID_EarlyVideoLayerStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< EarlyVideoLayerStatusError > payload (new EarlyVideoLayerStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EarlyVideoLayerStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EarlyVideoLayerStatusCallbackIF*) _callback)->onEarlyVideoLayerStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AnimationStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AnimationStatusError > payload (new AnimationStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AnimationStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AnimationStatusCallbackIF*) _callback)->onAnimationStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Syncdisplay_main_fiProxyCallback::_logger (Syncdisplay_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Syncdisplay_main_fiProxy > Syncdisplay_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Syncdisplay_main_fiProxy >  proxyNew(new Syncdisplay_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Syncdisplay_main_fiProxy > Syncdisplay_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Syncdisplay_main_fiProxy >  proxyNew(new Syncdisplay_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Syncdisplay_main_fiProxy > Syncdisplay_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Syncdisplay_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Syncdisplay_main_fiProxy >  proxyNew(new Syncdisplay_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Syncdisplay_main_fiProxy::Syncdisplay_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Syncdisplay_main_fiProxy::~Syncdisplay_main_fiProxy()
{
    LOG_INFO ("Entering ~Syncdisplay_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Syncdisplay_main_fiProxy::sendSetFirstScreenReadyStart(SetFirstScreenReadyCallbackIF& cb, uint8 t_tU8_ScreenType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFirstScreenReady);
        ::boost::shared_ptr< SetFirstScreenReadyStart > payload (new SetFirstScreenReadyStart());
        payload->setT_tU8_ScreenType(t_tU8_ScreenType);
        CCA_MESSAGE(ccaMessage,header,SetFirstScreenReadyStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFirstScreenReady", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFirstScreenReady);
        ::boost::shared_ptr< SetFirstScreenReadyError > payload (new SetFirstScreenReadyError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFirstScreenReadyError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFirstScreenReady", &cb);
    }
}

act_t Syncdisplay_main_fiProxy::sendSetAnimationRunStart(SetAnimationRunCallbackIF& cb, uint8 t_tU8_PlayRun) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetAnimationRun);
        ::boost::shared_ptr< SetAnimationRunStart > payload (new SetAnimationRunStart());
        payload->setT_tU8_PlayRun(t_tU8_PlayRun);
        CCA_MESSAGE(ccaMessage,header,SetAnimationRunStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetAnimationRun", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAnimationRun);
        ::boost::shared_ptr< SetAnimationRunError > payload (new SetAnimationRunError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAnimationRunError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetAnimationRun", &cb);
    }
}

act_t Syncdisplay_main_fiProxy::sendSetAnimationStopStart(SetAnimationStopCallbackIF& cb, uint8 t_tU8_PlayStop) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetAnimationStop);
        ::boost::shared_ptr< SetAnimationStopStart > payload (new SetAnimationStopStart());
        payload->setT_tU8_PlayStop(t_tU8_PlayStop);
        CCA_MESSAGE(ccaMessage,header,SetAnimationStopStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetAnimationStop", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAnimationStop);
        ::boost::shared_ptr< SetAnimationStopError > payload (new SetAnimationStopError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAnimationStopError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetAnimationStop", &cb);
    }
}

act_t Syncdisplay_main_fiProxy::sendEarlyVideoLayerStatusUpReg(EarlyVideoLayerStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EarlyVideoLayerStatus);
        ::boost::shared_ptr< EarlyVideoLayerStatusUpReg > payload (new EarlyVideoLayerStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,EarlyVideoLayerStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EarlyVideoLayerStatusRelUpReg > payloadRelUpRegHeap (new EarlyVideoLayerStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EarlyVideoLayerStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::syncdisplay_main_fi::EarlyVideoLayerStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EarlyVideoLayerStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EarlyVideoLayerStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EarlyVideoLayerStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEarlyVideoLayerStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EarlyVideoLayerStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EarlyVideoLayerStatusStatus > payloadLoopback (new EarlyVideoLayerStatusStatus(getEarlyVideoLayerStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EarlyVideoLayerStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EarlyVideoLayerStatus);
        ::boost::shared_ptr< EarlyVideoLayerStatusError > payload (new EarlyVideoLayerStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EarlyVideoLayerStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EarlyVideoLayerStatus", &cb);
    }
}

bool Syncdisplay_main_fiProxy::sendEarlyVideoLayerStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EarlyVideoLayerStatus,"EarlyVideoLayerStatus");
}

void Syncdisplay_main_fiProxy::sendEarlyVideoLayerStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EarlyVideoLayerStatus);
}

const EarlyVideoLayerStatusStatus& Syncdisplay_main_fiProxy::getEarlyVideoLayerStatus() const {
    return _earlyVideoLayerStatus.get();
}

bool Syncdisplay_main_fiProxy::hasEarlyVideoLayerStatus() const {
    return _earlyVideoLayerStatus.hasValue();
}

act_t Syncdisplay_main_fiProxy::sendEarlyVideoLayerStatusGet(EarlyVideoLayerStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EarlyVideoLayerStatus);
        ::boost::shared_ptr< EarlyVideoLayerStatusGet > payload (new EarlyVideoLayerStatusGet());
        CCA_MESSAGE(ccaMessage,header,EarlyVideoLayerStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EarlyVideoLayerStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EarlyVideoLayerStatus);
        ::boost::shared_ptr< EarlyVideoLayerStatusError > payload (new EarlyVideoLayerStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EarlyVideoLayerStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EarlyVideoLayerStatus", &cb);
    }
}

act_t Syncdisplay_main_fiProxy::sendAnimationStatusUpReg(AnimationStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AnimationStatus);
        ::boost::shared_ptr< AnimationStatusUpReg > payload (new AnimationStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,AnimationStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AnimationStatusRelUpReg > payloadRelUpRegHeap (new AnimationStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AnimationStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::syncdisplay_main_fi::AnimationStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AnimationStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AnimationStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AnimationStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAnimationStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AnimationStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AnimationStatusStatus > payloadLoopback (new AnimationStatusStatus(getAnimationStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AnimationStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AnimationStatus);
        ::boost::shared_ptr< AnimationStatusError > payload (new AnimationStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AnimationStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AnimationStatus", &cb);
    }
}

bool Syncdisplay_main_fiProxy::sendAnimationStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AnimationStatus,"AnimationStatus");
}

void Syncdisplay_main_fiProxy::sendAnimationStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AnimationStatus);
}

const AnimationStatusStatus& Syncdisplay_main_fiProxy::getAnimationStatus() const {
    return _animationStatus.get();
}

bool Syncdisplay_main_fiProxy::hasAnimationStatus() const {
    return _animationStatus.hasValue();
}

act_t Syncdisplay_main_fiProxy::sendAnimationStatusGet(AnimationStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AnimationStatus);
        ::boost::shared_ptr< AnimationStatusGet > payload (new AnimationStatusGet());
        CCA_MESSAGE(ccaMessage,header,AnimationStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AnimationStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AnimationStatus);
        ::boost::shared_ptr< AnimationStatusError > payload (new AnimationStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AnimationStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AnimationStatus", &cb);
    }
}


void Syncdisplay_main_fiProxy::clearAllProperties ()
{
    _earlyVideoLayerStatus = ::asf::core::nullable<EarlyVideoLayerStatusStatus>();
    _animationStatus = ::asf::core::nullable<AnimationStatusStatus>();
}

void Syncdisplay_main_fiProxy::sendRelUpRegAll()
{
    sendEarlyVideoLayerStatusRelUpRegAll();
    sendAnimationStatusRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Syncdisplay_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Syncdisplay_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace syncdisplay_main_fi
