#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SYNCDISPLAY_MAIN_FI_H
#define SYNCDISPLAY_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "syncdisplay_main_fi_typesConst.h"
#include <cstring>

/**
 * CCA Functional Interface 'syncdisplay_main_fi'
 *
 * Fullname: Display Synchornization. Handle Animation, First Screen, Backlight.
 *
 * Version: $Revision:   1.0.0  $
 *
 * Author: Klaus-Peter Kollai
 *
 * Date: $Date:  18.10.2015  $
 *
 * Department:
 *
 * Title: syncdisplay_fi
 *
 * <b>Description of 'syncdisplay_main_fi':</b>
 *
 * CCA_C_U16_SRV_SYNC_DISPLAY -- Service 0x61 (97)
 */

namespace syncdisplay_main_fi {

static const int SERVICE_ID = 97;

static const int FID_SetFirstScreenReady = 256;

static const int FID_EarlyVideoLayerStatus = 257;

static const int FID_AnimationStatus = 4097;

static const int FID_SetAnimationRun = 4128;

static const int FID_SetAnimationStop = 4129;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class SetFirstScreenReadyStart;

class EarlyVideoLayerStatusStatus;

class AnimationStatusStatus;

class SetAnimationRunStart;

class SetAnimationStopStart;

// type definitions
/**
 * The result message of the method "SetFirstScreenReady"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetFirstScreenReadyResult;

/**
 * The abort error message of the method "SetFirstScreenReady"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFirstScreenReadyAbortError;

/**
 * The error message of 'SetFirstScreenReady'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFirstScreenReadyError;

/**
 * The get message of the property "EarlyVideoLayerStatus"
 * This property gives information about the current status of the early video layer (Rvc, Animation).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EarlyVideoLayerStatusGet;

/**
 * The upreg message of the property "EarlyVideoLayerStatus"
 * This property gives information about the current status of the early video layer (Rvc, Animation).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EarlyVideoLayerStatusUpReg;

/**
 * The relUpReg message of the property "EarlyVideoLayerStatus"
 * This property gives information about the current status of the early video layer (Rvc, Animation).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EarlyVideoLayerStatusRelUpReg;

/**
 * The error message of 'EarlyVideoLayerStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError EarlyVideoLayerStatusError;

/**
 * The get message of the property "AnimationStatus"
 * This property gives information about the current settings of the animation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AnimationStatusGet;

/**
 * The upreg message of the property "AnimationStatus"
 * This property gives information about the current settings of the animation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AnimationStatusUpReg;

/**
 * The relUpReg message of the property "AnimationStatus"
 * This property gives information about the current settings of the animation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AnimationStatusRelUpReg;

/**
 * The error message of 'AnimationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError AnimationStatusError;

/**
 * The result message of the method "SetAnimationRun"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAnimationRunResult;

/**
 * The abort error message of the method "SetAnimationRun"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAnimationRunAbortError;

/**
 * The error message of 'SetAnimationRun'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAnimationRunError;

/**
 * The result message of the method "SetAnimationStop"
 * This method is used to set the status to stop, which stops the animation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAnimationStopResult;

/**
 * The abort error message of the method "SetAnimationStop"
 * This method is used to set the status to stop, which stops the animation.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAnimationStopAbortError;

/**
 * The error message of 'SetAnimationStop'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAnimationStopError;


/**
 * The start message of the method "SetFirstScreenReady"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
class SetFirstScreenReadyStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFirstScreenReadyStart ();

    /**
     * Copy constructor
     */
    inline  SetFirstScreenReadyStart (const SetFirstScreenReadyStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFirstScreenReadyStart (uint8 T_tU8_ScreenType_);

    /**
     * Destructor
     */
    inline virtual  ~SetFirstScreenReadyStart();

    /**
     * Assignment operator
     */
    inline SetFirstScreenReadyStart& operator = (const SetFirstScreenReadyStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFirstScreenReadyStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFirstScreenReadyStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFirstScreenReadyStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFirstScreenReadyStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "T_tU8_ScreenType"

    static const int kT_tU8_ScreenType = 0;

    /**
     * Clears the field "T_tU8_ScreenType".
     *
     * The field will be set to its default value. The hasT_tU8_ScreenType()
     * method will return false.
     */
    inline void clearT_tU8_ScreenType();

    /**
     * Checks whether the field "T_tU8_ScreenType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setT_tU8_ScreenType()). Otherwise it will return false.
     */
    inline bool hasT_tU8_ScreenType () const;

    /**
     * Returns the value of the member "T_tU8_ScreenType".
     *
     * Set when a screen is available on layer.
     *
     * @return The value of the field "T_tU8_ScreenType"
     */
    inline uint8 getT_tU8_ScreenType () const;

    /**
     * Sets the value of the member "T_tU8_ScreenType".
     *
     * Set when a screen is available on layer.
     *
     * @param T_tU8_ScreenType The value which will be set
     */
    inline void setT_tU8_ScreenType (uint8 T_tU8_ScreenType_);

    static const SetFirstScreenReadyStart &getDefaultInstance();

private:

    inline void set_has_T_tU8_ScreenType ();

    inline void clear_has_T_tU8_ScreenType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _T_tU8_ScreenType;

};

/**
 * The status message of the property "EarlyVideoLayerStatus"
 * This property gives information about the current status of the early video layer (Rvc, Animation).
 */
class EarlyVideoLayerStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EarlyVideoLayerStatusStatus ();

    /**
     * Copy constructor
     */
    inline  EarlyVideoLayerStatusStatus (const EarlyVideoLayerStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EarlyVideoLayerStatusStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EarlyVideoLayerStatusStatus();

    /**
     * Assignment operator
     */
    inline EarlyVideoLayerStatusStatus& operator = (const EarlyVideoLayerStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EarlyVideoLayerStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EarlyVideoLayerStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EarlyVideoLayerStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EarlyVideoLayerStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eEarlyVideoLayerStatus"

    static const int kEEarlyVideoLayerStatus = 0;

    /**
     * Clears the field "eEarlyVideoLayerStatus".
     *
     * The field will be set to its default value. The hasEEarlyVideoLayerStatus()
     * method will return false.
     */
    inline void clearEEarlyVideoLayerStatus();

    /**
     * Checks whether the field "eEarlyVideoLayerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEEarlyVideoLayerStatus()). Otherwise it will return false.
     */
    inline bool hasEEarlyVideoLayerStatus () const;

    /**
     * Returns the value of the member "eEarlyVideoLayerStatus".
     *
     * Returns the actual satus of the early video layer.
     *
     * @return The value of the field "eEarlyVideoLayerStatus"
     */
    inline ::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status getEEarlyVideoLayerStatus () const;

    /**
     * Sets the value of the member "eEarlyVideoLayerStatus".
     *
     * Returns the actual satus of the early video layer.
     *
     * @param eEarlyVideoLayerStatus The value which will be set
     */
    inline void setEEarlyVideoLayerStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus_);

    static const EarlyVideoLayerStatusStatus &getDefaultInstance();

private:

    inline void set_has_eEarlyVideoLayerStatus ();

    inline void clear_has_eEarlyVideoLayerStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status _eEarlyVideoLayerStatus;

};

/**
 * The status message of the property "AnimationStatus"
 * This property gives information about the current settings of the animation.
 */
class AnimationStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AnimationStatusStatus ();

    /**
     * Copy constructor
     */
    inline  AnimationStatusStatus (const AnimationStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AnimationStatusStatus (::syncdisplay_main_fi_types::T_e8_Animation_Status T_e8_Animation_Status_);

    /**
     * Destructor
     */
    inline virtual  ~AnimationStatusStatus();

    /**
     * Assignment operator
     */
    inline AnimationStatusStatus& operator = (const AnimationStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AnimationStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AnimationStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AnimationStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AnimationStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "T_e8_Animation_Status"

    static const int kT_e8_Animation_Status = 0;

    /**
     * Clears the field "T_e8_Animation_Status".
     *
     * The field will be set to its default value. The hasT_e8_Animation_Status()
     * method will return false.
     */
    inline void clearT_e8_Animation_Status();

    /**
     * Checks whether the field "T_e8_Animation_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setT_e8_Animation_Status()). Otherwise it will return false.
     */
    inline bool hasT_e8_Animation_Status () const;

    /**
     * Returns the value of the member "T_e8_Animation_Status".
     *
     * Returns the actual Animation satus.
     *
     * @return The value of the field "T_e8_Animation_Status"
     */
    inline ::syncdisplay_main_fi_types::T_e8_Animation_Status getT_e8_Animation_Status () const;

    /**
     * Sets the value of the member "T_e8_Animation_Status".
     *
     * Returns the actual Animation satus.
     *
     * @param T_e8_Animation_Status The value which will be set
     */
    inline void setT_e8_Animation_Status (::syncdisplay_main_fi_types::T_e8_Animation_Status T_e8_Animation_Status_);

    static const AnimationStatusStatus &getDefaultInstance();

private:

    inline void set_has_T_e8_Animation_Status ();

    inline void clear_has_T_e8_Animation_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::syncdisplay_main_fi_types::T_e8_Animation_Status _T_e8_Animation_Status;

};

/**
 * The start message of the method "SetAnimationRun"
 * This method is used to set the status of animation to run. If it was stopped before, this service shall only show last Frame.
 */
class SetAnimationRunStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAnimationRunStart ();

    /**
     * Copy constructor
     */
    inline  SetAnimationRunStart (const SetAnimationRunStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAnimationRunStart (uint8 T_tU8_PlayRun_);

    /**
     * Destructor
     */
    inline virtual  ~SetAnimationRunStart();

    /**
     * Assignment operator
     */
    inline SetAnimationRunStart& operator = (const SetAnimationRunStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAnimationRunStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAnimationRunStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAnimationRunStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAnimationRunStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "T_tU8_PlayRun"

    static const int kT_tU8_PlayRun = 0;

    /**
     * Clears the field "T_tU8_PlayRun".
     *
     * The field will be set to its default value. The hasT_tU8_PlayRun()
     * method will return false.
     */
    inline void clearT_tU8_PlayRun();

    /**
     * Checks whether the field "T_tU8_PlayRun" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setT_tU8_PlayRun()). Otherwise it will return false.
     */
    inline bool hasT_tU8_PlayRun () const;

    /**
     * Returns the value of the member "T_tU8_PlayRun".
     *
     * Set the Animation to run.
     *
     * @return The value of the field "T_tU8_PlayRun"
     */
    inline uint8 getT_tU8_PlayRun () const;

    /**
     * Sets the value of the member "T_tU8_PlayRun".
     *
     * Set the Animation to run.
     *
     * @param T_tU8_PlayRun The value which will be set
     */
    inline void setT_tU8_PlayRun (uint8 T_tU8_PlayRun_);

    static const SetAnimationRunStart &getDefaultInstance();

private:

    inline void set_has_T_tU8_PlayRun ();

    inline void clear_has_T_tU8_PlayRun ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _T_tU8_PlayRun;

};

/**
 * The start message of the method "SetAnimationStop"
 * This method is used to set the status to stop, which stops the animation.
 */
class SetAnimationStopStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAnimationStopStart ();

    /**
     * Copy constructor
     */
    inline  SetAnimationStopStart (const SetAnimationStopStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAnimationStopStart (uint8 T_tU8_PlayStop_);

    /**
     * Destructor
     */
    inline virtual  ~SetAnimationStopStart();

    /**
     * Assignment operator
     */
    inline SetAnimationStopStart& operator = (const SetAnimationStopStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAnimationStopStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAnimationStopStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAnimationStopStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAnimationStopStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "T_tU8_PlayStop"

    static const int kT_tU8_PlayStop = 0;

    /**
     * Clears the field "T_tU8_PlayStop".
     *
     * The field will be set to its default value. The hasT_tU8_PlayStop()
     * method will return false.
     */
    inline void clearT_tU8_PlayStop();

    /**
     * Checks whether the field "T_tU8_PlayStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setT_tU8_PlayStop()). Otherwise it will return false.
     */
    inline bool hasT_tU8_PlayStop () const;

    /**
     * Returns the value of the member "T_tU8_PlayStop".
     *
     * Set the Animation to stop.
     *
     * @return The value of the field "T_tU8_PlayStop"
     */
    inline uint8 getT_tU8_PlayStop () const;

    /**
     * Sets the value of the member "T_tU8_PlayStop".
     *
     * Set the Animation to stop.
     *
     * @param T_tU8_PlayStop The value which will be set
     */
    inline void setT_tU8_PlayStop (uint8 T_tU8_PlayStop_);

    static const SetAnimationStopStart &getDefaultInstance();

private:

    inline void set_has_T_tU8_PlayStop ();

    inline void clear_has_T_tU8_PlayStop ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _T_tU8_PlayStop;

};

inline  SetFirstScreenReadyStart::SetFirstScreenReadyStart ()  :
    _T_tU8_ScreenType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFirstScreenReadyStart::SetFirstScreenReadyStart (const SetFirstScreenReadyStart &rhs)  :
    ::asf::core::Payload(rhs),
    _T_tU8_ScreenType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFirstScreenReadyStart::SetFirstScreenReadyStart (uint8 T_tU8_ScreenType_)  :
    _T_tU8_ScreenType (T_tU8_ScreenType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFirstScreenReadyStart::~SetFirstScreenReadyStart() {
}

inline SetFirstScreenReadyStart& SetFirstScreenReadyStart::operator = (const SetFirstScreenReadyStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasT_tU8_ScreenType()) {
            setT_tU8_ScreenType(rhs.getT_tU8_ScreenType());
        } else {
            clearT_tU8_ScreenType();
        }
    }
    return *this;
}

inline bool SetFirstScreenReadyStart::operator == (const SetFirstScreenReadyStart& rhs) const {
    return (((!hasT_tU8_ScreenType() && !rhs.hasT_tU8_ScreenType()) || getT_tU8_ScreenType() == rhs.getT_tU8_ScreenType()));
}

inline bool SetFirstScreenReadyStart::operator != (const SetFirstScreenReadyStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFirstScreenReadyStart::operator < (const SetFirstScreenReadyStart& rhs) const {
    if (hasT_tU8_ScreenType() || rhs.hasT_tU8_ScreenType()) {
        if (getT_tU8_ScreenType() < rhs.getT_tU8_ScreenType()) return true;
        if (getT_tU8_ScreenType() > rhs.getT_tU8_ScreenType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFirstScreenReadyStart::clone() {
    return new SetFirstScreenReadyStart(*this);
}

inline bool SetFirstScreenReadyStart::operator > (const SetFirstScreenReadyStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFirstScreenReadyStart::clear() {
    clearT_tU8_ScreenType();
}

inline void SetFirstScreenReadyStart::clearT_tU8_ScreenType() {
    if (hasT_tU8_ScreenType()) {
         clear_has_T_tU8_ScreenType();
        _T_tU8_ScreenType = 0u;
     }
}

inline bool SetFirstScreenReadyStart::hasT_tU8_ScreenType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetFirstScreenReadyStart::getT_tU8_ScreenType () const {
    return _T_tU8_ScreenType;
}

inline void SetFirstScreenReadyStart::setT_tU8_ScreenType (uint8 T_tU8_ScreenType_) {
    set_has_T_tU8_ScreenType();
    this->_T_tU8_ScreenType = T_tU8_ScreenType_;
}

inline void SetFirstScreenReadyStart::set_has_T_tU8_ScreenType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFirstScreenReadyStart::clear_has_T_tU8_ScreenType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EarlyVideoLayerStatusStatus::EarlyVideoLayerStatusStatus ()  :
    _eEarlyVideoLayerStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status__VIDEOLAYER_ANIMATION_NOT_YET_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EarlyVideoLayerStatusStatus::EarlyVideoLayerStatusStatus (const EarlyVideoLayerStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _eEarlyVideoLayerStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status__VIDEOLAYER_ANIMATION_NOT_YET_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EarlyVideoLayerStatusStatus::EarlyVideoLayerStatusStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus_)  :
    _eEarlyVideoLayerStatus (eEarlyVideoLayerStatus_)
{
    #ifndef NDEBUG
    if (!(::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status_IsValid(eEarlyVideoLayerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eEarlyVideoLayerStatus_, "T_e8_EarlyVideoLayer_Status", "eEarlyVideoLayerStatus", "EarlyVideoLayerStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EarlyVideoLayerStatusStatus::~EarlyVideoLayerStatusStatus() {
}

inline EarlyVideoLayerStatusStatus& EarlyVideoLayerStatusStatus::operator = (const EarlyVideoLayerStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEEarlyVideoLayerStatus()) {
            setEEarlyVideoLayerStatus(rhs.getEEarlyVideoLayerStatus());
        } else {
            clearEEarlyVideoLayerStatus();
        }
    }
    return *this;
}

inline bool EarlyVideoLayerStatusStatus::operator == (const EarlyVideoLayerStatusStatus& rhs) const {
    return (((!hasEEarlyVideoLayerStatus() && !rhs.hasEEarlyVideoLayerStatus()) || getEEarlyVideoLayerStatus() == rhs.getEEarlyVideoLayerStatus()));
}

inline bool EarlyVideoLayerStatusStatus::operator != (const EarlyVideoLayerStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool EarlyVideoLayerStatusStatus::operator < (const EarlyVideoLayerStatusStatus& rhs) const {
    if (hasEEarlyVideoLayerStatus() || rhs.hasEEarlyVideoLayerStatus()) {
        if ((uint32)getEEarlyVideoLayerStatus() < (uint32)rhs.getEEarlyVideoLayerStatus()) return true;
        if ((uint32)getEEarlyVideoLayerStatus() > (uint32)rhs.getEEarlyVideoLayerStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EarlyVideoLayerStatusStatus::clone() {
    return new EarlyVideoLayerStatusStatus(*this);
}

inline bool EarlyVideoLayerStatusStatus::operator > (const EarlyVideoLayerStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EarlyVideoLayerStatusStatus::clear() {
    clearEEarlyVideoLayerStatus();
}

inline void EarlyVideoLayerStatusStatus::clearEEarlyVideoLayerStatus() {
    if (hasEEarlyVideoLayerStatus()) {
         clear_has_eEarlyVideoLayerStatus();
        _eEarlyVideoLayerStatus = ::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status__VIDEOLAYER_ANIMATION_NOT_YET_STARTED;
     }
}

inline bool EarlyVideoLayerStatusStatus::hasEEarlyVideoLayerStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status EarlyVideoLayerStatusStatus::getEEarlyVideoLayerStatus () const {
    return _eEarlyVideoLayerStatus;
}

inline void EarlyVideoLayerStatusStatus::setEEarlyVideoLayerStatus (::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus_) {
    #ifndef NDEBUG
    if (!(::syncdisplay_main_fi_types::T_e8_EarlyVideoLayer_Status_IsValid(eEarlyVideoLayerStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eEarlyVideoLayerStatus_, "T_e8_EarlyVideoLayer_Status", "eEarlyVideoLayerStatus", "EarlyVideoLayerStatusStatus");
    }
    #endif
    set_has_eEarlyVideoLayerStatus();
    this->_eEarlyVideoLayerStatus = eEarlyVideoLayerStatus_;
}

inline void EarlyVideoLayerStatusStatus::set_has_eEarlyVideoLayerStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EarlyVideoLayerStatusStatus::clear_has_eEarlyVideoLayerStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AnimationStatusStatus::AnimationStatusStatus ()  :
    _T_e8_Animation_Status (::syncdisplay_main_fi_types::T_e8_Animation_Status__ANIMATION_FINISHED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AnimationStatusStatus::AnimationStatusStatus (const AnimationStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _T_e8_Animation_Status (::syncdisplay_main_fi_types::T_e8_Animation_Status__ANIMATION_FINISHED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AnimationStatusStatus::AnimationStatusStatus (::syncdisplay_main_fi_types::T_e8_Animation_Status T_e8_Animation_Status_)  :
    _T_e8_Animation_Status (T_e8_Animation_Status_)
{
    #ifndef NDEBUG
    if (!(::syncdisplay_main_fi_types::T_e8_Animation_Status_IsValid(T_e8_Animation_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", T_e8_Animation_Status_, "T_e8_Animation_Status", "T_e8_Animation_Status", "AnimationStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AnimationStatusStatus::~AnimationStatusStatus() {
}

inline AnimationStatusStatus& AnimationStatusStatus::operator = (const AnimationStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasT_e8_Animation_Status()) {
            setT_e8_Animation_Status(rhs.getT_e8_Animation_Status());
        } else {
            clearT_e8_Animation_Status();
        }
    }
    return *this;
}

inline bool AnimationStatusStatus::operator == (const AnimationStatusStatus& rhs) const {
    return (((!hasT_e8_Animation_Status() && !rhs.hasT_e8_Animation_Status()) || getT_e8_Animation_Status() == rhs.getT_e8_Animation_Status()));
}

inline bool AnimationStatusStatus::operator != (const AnimationStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AnimationStatusStatus::operator < (const AnimationStatusStatus& rhs) const {
    if (hasT_e8_Animation_Status() || rhs.hasT_e8_Animation_Status()) {
        if ((uint32)getT_e8_Animation_Status() < (uint32)rhs.getT_e8_Animation_Status()) return true;
        if ((uint32)getT_e8_Animation_Status() > (uint32)rhs.getT_e8_Animation_Status()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AnimationStatusStatus::clone() {
    return new AnimationStatusStatus(*this);
}

inline bool AnimationStatusStatus::operator > (const AnimationStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AnimationStatusStatus::clear() {
    clearT_e8_Animation_Status();
}

inline void AnimationStatusStatus::clearT_e8_Animation_Status() {
    if (hasT_e8_Animation_Status()) {
         clear_has_T_e8_Animation_Status();
        _T_e8_Animation_Status = ::syncdisplay_main_fi_types::T_e8_Animation_Status__ANIMATION_FINISHED;
     }
}

inline bool AnimationStatusStatus::hasT_e8_Animation_Status () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::syncdisplay_main_fi_types::T_e8_Animation_Status AnimationStatusStatus::getT_e8_Animation_Status () const {
    return _T_e8_Animation_Status;
}

inline void AnimationStatusStatus::setT_e8_Animation_Status (::syncdisplay_main_fi_types::T_e8_Animation_Status T_e8_Animation_Status_) {
    #ifndef NDEBUG
    if (!(::syncdisplay_main_fi_types::T_e8_Animation_Status_IsValid(T_e8_Animation_Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", T_e8_Animation_Status_, "T_e8_Animation_Status", "T_e8_Animation_Status", "AnimationStatusStatus");
    }
    #endif
    set_has_T_e8_Animation_Status();
    this->_T_e8_Animation_Status = T_e8_Animation_Status_;
}

inline void AnimationStatusStatus::set_has_T_e8_Animation_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AnimationStatusStatus::clear_has_T_e8_Animation_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetAnimationRunStart::SetAnimationRunStart ()  :
    _T_tU8_PlayRun (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAnimationRunStart::SetAnimationRunStart (const SetAnimationRunStart &rhs)  :
    ::asf::core::Payload(rhs),
    _T_tU8_PlayRun (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAnimationRunStart::SetAnimationRunStart (uint8 T_tU8_PlayRun_)  :
    _T_tU8_PlayRun (T_tU8_PlayRun_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAnimationRunStart::~SetAnimationRunStart() {
}

inline SetAnimationRunStart& SetAnimationRunStart::operator = (const SetAnimationRunStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasT_tU8_PlayRun()) {
            setT_tU8_PlayRun(rhs.getT_tU8_PlayRun());
        } else {
            clearT_tU8_PlayRun();
        }
    }
    return *this;
}

inline bool SetAnimationRunStart::operator == (const SetAnimationRunStart& rhs) const {
    return (((!hasT_tU8_PlayRun() && !rhs.hasT_tU8_PlayRun()) || getT_tU8_PlayRun() == rhs.getT_tU8_PlayRun()));
}

inline bool SetAnimationRunStart::operator != (const SetAnimationRunStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAnimationRunStart::operator < (const SetAnimationRunStart& rhs) const {
    if (hasT_tU8_PlayRun() || rhs.hasT_tU8_PlayRun()) {
        if (getT_tU8_PlayRun() < rhs.getT_tU8_PlayRun()) return true;
        if (getT_tU8_PlayRun() > rhs.getT_tU8_PlayRun()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAnimationRunStart::clone() {
    return new SetAnimationRunStart(*this);
}

inline bool SetAnimationRunStart::operator > (const SetAnimationRunStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAnimationRunStart::clear() {
    clearT_tU8_PlayRun();
}

inline void SetAnimationRunStart::clearT_tU8_PlayRun() {
    if (hasT_tU8_PlayRun()) {
         clear_has_T_tU8_PlayRun();
        _T_tU8_PlayRun = 0u;
     }
}

inline bool SetAnimationRunStart::hasT_tU8_PlayRun () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetAnimationRunStart::getT_tU8_PlayRun () const {
    return _T_tU8_PlayRun;
}

inline void SetAnimationRunStart::setT_tU8_PlayRun (uint8 T_tU8_PlayRun_) {
    set_has_T_tU8_PlayRun();
    this->_T_tU8_PlayRun = T_tU8_PlayRun_;
}

inline void SetAnimationRunStart::set_has_T_tU8_PlayRun () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAnimationRunStart::clear_has_T_tU8_PlayRun () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetAnimationStopStart::SetAnimationStopStart ()  :
    _T_tU8_PlayStop (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAnimationStopStart::SetAnimationStopStart (const SetAnimationStopStart &rhs)  :
    ::asf::core::Payload(rhs),
    _T_tU8_PlayStop (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAnimationStopStart::SetAnimationStopStart (uint8 T_tU8_PlayStop_)  :
    _T_tU8_PlayStop (T_tU8_PlayStop_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAnimationStopStart::~SetAnimationStopStart() {
}

inline SetAnimationStopStart& SetAnimationStopStart::operator = (const SetAnimationStopStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasT_tU8_PlayStop()) {
            setT_tU8_PlayStop(rhs.getT_tU8_PlayStop());
        } else {
            clearT_tU8_PlayStop();
        }
    }
    return *this;
}

inline bool SetAnimationStopStart::operator == (const SetAnimationStopStart& rhs) const {
    return (((!hasT_tU8_PlayStop() && !rhs.hasT_tU8_PlayStop()) || getT_tU8_PlayStop() == rhs.getT_tU8_PlayStop()));
}

inline bool SetAnimationStopStart::operator != (const SetAnimationStopStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAnimationStopStart::operator < (const SetAnimationStopStart& rhs) const {
    if (hasT_tU8_PlayStop() || rhs.hasT_tU8_PlayStop()) {
        if (getT_tU8_PlayStop() < rhs.getT_tU8_PlayStop()) return true;
        if (getT_tU8_PlayStop() > rhs.getT_tU8_PlayStop()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAnimationStopStart::clone() {
    return new SetAnimationStopStart(*this);
}

inline bool SetAnimationStopStart::operator > (const SetAnimationStopStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAnimationStopStart::clear() {
    clearT_tU8_PlayStop();
}

inline void SetAnimationStopStart::clearT_tU8_PlayStop() {
    if (hasT_tU8_PlayStop()) {
         clear_has_T_tU8_PlayStop();
        _T_tU8_PlayStop = 0u;
     }
}

inline bool SetAnimationStopStart::hasT_tU8_PlayStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetAnimationStopStart::getT_tU8_PlayStop () const {
    return _T_tU8_PlayStop;
}

inline void SetAnimationStopStart::setT_tU8_PlayStop (uint8 T_tU8_PlayStop_) {
    set_has_T_tU8_PlayStop();
    this->_T_tU8_PlayStop = T_tU8_PlayStop_;
}

inline void SetAnimationStopStart::set_has_T_tU8_PlayStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAnimationStopStart::clear_has_T_tU8_PlayStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace syncdisplay_main_fi

#endif // SYNCDISPLAY_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
