/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "fi_types.h"
#include "fi_typesCca.h"
#include "sxm_main_fi_typesCca.h"
#include "sxm_wsalerts_main_fi_types.h"
#include "sxm_wsalerts_main_fi_typesCca.h"
#include "sxm_wsalerts_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::sxm_wsalerts_main_fi_types::T_WSAlertLocation& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDescription();
    {
        uint32 o0 = static_cast<uint32>(in.getShapeGeoPoints().size());
        out << o0;
        ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o1;
        for (o1 = in.getShapeGeoPoints().begin(); o1 != in.getShapeGeoPoints().end(); ++o1) {
            serializeCca((*o1), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_wsalerts_main_fi_types::T_WSAlertLocation& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o2;
    in >> o2;
    out.setDescription(o2);
    {
        uint32 o3;
        in >> o3;
        out.getShapeGeoPointsMutable().clear ();
        out.getShapeGeoPointsMutable().reserve (o3);
        for (uint32 o4 = 0; o4 < o3; o4++) {
            ::fi_types::T_PositionWGS84 o5;
            deserializeCca(in, o5, majorVersion);
            out.getShapeGeoPointsMutable().push_back (o5);
        }
    }
}

void serializeCca(const ::sxm_wsalerts_main_fi_types::T_WSAlertInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAlertTypeID();
    out << in.getAlertExtRefCode();
    if (2 <= majorVersion) {
        out << in.getAlertNameID();
    }
    if (2 <= majorVersion) {
        out << in.getAlertGroupId();
    }
    if (2 <= majorVersion) {
        out << in.getAlertPrio();
    }
    if (2 <= majorVersion) {
        serializeCca(in.getAlertColor(), out, majorVersion);
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_wsalerts_main_fi_types::T_WSAlertInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o6;
    in >> o6;
    out.setAlertTypeID((::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes)o6);
    ::std::string o7;
    in >> o7;
    out.setAlertExtRefCode(o7);
    if (2 <= majorVersion) {
        uint32 o8;
        in >> o8;
        out.setAlertNameID(o8);
    }
    if (2 <= majorVersion) {
        uint32 o9;
        in >> o9;
        out.setAlertGroupId(o9);
    }
    if (2 <= majorVersion) {
        uint32 o10;
        in >> o10;
        out.setAlertPrio(o10);
    }
    if (2 <= majorVersion) {
        deserializeCca(in, out.getAlertColorMutable(), majorVersion);
    }
}

void serializeCca(const ::sxm_wsalerts_main_fi_types::T_WSAlertConfig& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAlertTypeID();
    out << in.getAlertExtRefCode();
    out << in.getAlertNameID();
    out << in.getAlertGroupId();
    out << in.getAlertPrio();
    serializeCca(in.getAlertColor(), out, majorVersion);
    out << (uint8) in.getIsEnabledInHMI();
    out << (uint8) in.getIsEnabledInMap();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_wsalerts_main_fi_types::T_WSAlertConfig& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o11;
    in >> o11;
    out.setAlertTypeID((::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes)o11);
    ::std::string o12;
    in >> o12;
    out.setAlertExtRefCode(o12);
    uint32 o13;
    in >> o13;
    out.setAlertNameID(o13);
    uint32 o14;
    in >> o14;
    out.setAlertGroupId(o14);
    uint32 o15;
    in >> o15;
    out.setAlertPrio(o15);
    deserializeCca(in, out.getAlertColorMutable(), majorVersion);
    bool o16;
    in >> o16;
    out.setIsEnabledInHMI(o16);
    bool o17;
    in >> o17;
    out.setIsEnabledInMap(o17);
}

void serializeCca(const ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getMessageID();
    out << in.getText();
    serializeCca(in.getStartTime(), out, majorVersion);
    serializeCca(in.getEndTime(), out, majorVersion);
    out << (uint8) in.getLanguage();
    out << in.getPriority();
    out << (uint8) in.getBIsMarineZone();
    {
        uint32 o18 = static_cast<uint32>(in.getAlertTypes().size());
        out << o18;
        ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertInfo >::const_iterator o19;
        for (o19 = in.getAlertTypes().begin(); o19 != in.getAlertTypes().end(); ++o19) {
            serializeCca((*o19), out, majorVersion);
        }
    }
    {
        uint32 o20 = static_cast<uint32>(in.getAlertLocations().size());
        out << o20;
        ::std::vector< ::sxm_wsalerts_main_fi_types::T_WSAlertLocation >::const_iterator o21;
        for (o21 = in.getAlertLocations().begin(); o21 != in.getAlertLocations().end(); ++o21) {
            serializeCca((*o21), out, majorVersion);
        }
    }
    out << in.getDistance();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_wsalerts_main_fi_types::T_WSAlertMsg& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o22;
    in >> o22;
    out.setMessageID(o22);
    ::std::string o23;
    in >> o23;
    out.setText(o23);
    deserializeCca(in, out.getStartTimeMutable(), majorVersion);
    deserializeCca(in, out.getEndTimeMutable(), majorVersion);
    uint8 o24;
    in >> o24;
    out.setLanguage((::sxm_wsalerts_main_fi_types::T_e8_Language)o24);
    uint16 o25;
    in >> o25;
    out.setPriority(o25);
    bool o26;
    in >> o26;
    out.setBIsMarineZone(o26);
    {
        uint32 o27;
        in >> o27;
        out.getAlertTypesMutable().clear ();
        out.getAlertTypesMutable().reserve (o27);
        for (uint32 o28 = 0; o28 < o27; o28++) {
            ::sxm_wsalerts_main_fi_types::T_WSAlertInfo o29;
            deserializeCca(in, o29, majorVersion);
            out.getAlertTypesMutable().push_back (o29);
        }
    }
    {
        uint32 o30;
        in >> o30;
        out.getAlertLocationsMutable().clear ();
        out.getAlertLocationsMutable().reserve (o30);
        for (uint32 o31 = 0; o31 < o30; o31++) {
            ::sxm_wsalerts_main_fi_types::T_WSAlertLocation o32;
            deserializeCca(in, o32, majorVersion);
            out.getAlertLocationsMutable().push_back (o32);
        }
    }
    float o33;
    in >> o33;
    out.setDistance(o33);
}

