#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_WSALERTS_MAIN_FI_TYPES_H
#define SXM_WSALERTS_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_types.h"
#include "sxm_main_fi_types.h"
#include "sxm_wsalerts_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_wsalerts_main_fi_types
 */

namespace sxm_wsalerts_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_WSAlertLocation;

class T_WSAlertInfo;

class T_WSAlertConfig;

class T_WSAlertMsg;


/**
 * It provides Weather and Security Alert location details
 */
class T_WSAlertLocation {
public:

    /**
     * Default constructor
     */
    inline  T_WSAlertLocation ();

    /**
     * Copy constructor
     */
    inline  T_WSAlertLocation (const T_WSAlertLocation &rhs);

    /**
     * All fields constructor
     */
    inline  T_WSAlertLocation (const ::std::string& Description_, const ::std::vector< ::fi_types::T_PositionWGS84 >& ShapeGeoPoints_);

    /**
     * Destructor
     */
    inline  ~T_WSAlertLocation();

    /**
     * Assignment operator
     */
    inline T_WSAlertLocation& operator = (const T_WSAlertLocation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WSAlertLocation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WSAlertLocation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WSAlertLocation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WSAlertLocation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Description"

    static const int kDescription = 0;

    /**
     * Clears the field "Description".
     *
     * The field will be set to its default value. The hasDescription()
     * method will return false.
     */
    inline void clearDescription();

    /**
     * Checks whether the field "Description" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDescription()). Otherwise it will return false.
     */
    inline bool hasDescription () const;

    /**
     * Returns the value of the member "Description".
     *
     * It describes the alert location
     *
     * @return The value of the field "Description"
     */
    inline const ::std::string& getDescription () const;

    /**
     * Retrieves the value of the field "Description" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Description".
     */
    inline ::std::string& getDescriptionMutable ();

    /**
     * Sets the value of the member "Description".
     *
     * It describes the alert location
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const ::std::string& Description_);

    /**
     * Sets the value of the member "Description".
     *
     * It describes the alert location
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const char* Description_);

    /**
     * Sets the value of the member "Description".
     *
     * It describes the alert location
     *
     * @param Description The value which will be set
     */
    inline void setDescription (const char* value, size_t size);

    // API of field "ShapeGeoPoints"

    static const int kShapeGeoPoints = 1;

    /**
     * Clears the field "ShapeGeoPoints".
     *
     * The field will be set to its default value. The hasShapeGeoPoints()
     * method will return false.
     */
    inline void clearShapeGeoPoints();

    /**
     * Checks whether the field "ShapeGeoPoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShapeGeoPoints()). Otherwise it will return false.
     */
    inline bool hasShapeGeoPoints () const;

    /**
     * Returns the value of the member "ShapeGeoPoints".
     *
     * List of coordinates forming this shape
     *
     * @return The value of the field "ShapeGeoPoints"
     */
    inline const ::std::vector< ::fi_types::T_PositionWGS84 >& getShapeGeoPoints () const;

    /**
     * Retrieves the value of the field "ShapeGeoPoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ShapeGeoPoints".
     */
    inline ::std::vector< ::fi_types::T_PositionWGS84 >& getShapeGeoPointsMutable ();

    /**
     * Sets the value of the member "ShapeGeoPoints".
     *
     * List of coordinates forming this shape
     *
     * @param ShapeGeoPoints The value which will be set
     */
    inline void setShapeGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& ShapeGeoPoints_);

    static const T_WSAlertLocation &getDefaultInstance();

private:

    static const ::std::vector< ::fi_types::T_PositionWGS84 >& getT_PositionWGS84List_DefaultInstance ();

    inline void set_has_Description ();

    inline void clear_has_Description ();

    inline void set_has_ShapeGeoPoints ();

    inline void clear_has_ShapeGeoPoints ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Description;

    ::std::vector< ::fi_types::T_PositionWGS84 > _ShapeGeoPoints;

};

/**
 * It provides Weather and Security Alert Information
 */
class T_WSAlertInfo {
public:

    /**
     * Default constructor
     */
    inline  T_WSAlertInfo ();

    /**
     * Copy constructor
     */
    inline  T_WSAlertInfo (const T_WSAlertInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_WSAlertInfo (T_e8_WSAlertTypes AlertTypeID_, const ::std::string& AlertExtRefCode_, uint32 AlertNameID_, uint32 AlertGroupId_, uint32 AlertPrio_, const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_);

    /**
     * Destructor
     */
    inline  ~T_WSAlertInfo();

    /**
     * Assignment operator
     */
    inline T_WSAlertInfo& operator = (const T_WSAlertInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WSAlertInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WSAlertInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WSAlertInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WSAlertInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AlertTypeID"

    static const int kAlertTypeID = 0;

    /**
     * Clears the field "AlertTypeID".
     *
     * The field will be set to its default value. The hasAlertTypeID()
     * method will return false.
     */
    inline void clearAlertTypeID();

    /**
     * Checks whether the field "AlertTypeID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertTypeID()). Otherwise it will return false.
     */
    inline bool hasAlertTypeID () const;

    /**
     * Returns the value of the member "AlertTypeID".
     *
     * Alert type ID
     *
     * @return The value of the field "AlertTypeID"
     */
    inline T_e8_WSAlertTypes getAlertTypeID () const;

    /**
     * Sets the value of the member "AlertTypeID".
     *
     * Alert type ID
     *
     * @param AlertTypeID The value which will be set
     */
    inline void setAlertTypeID (T_e8_WSAlertTypes AlertTypeID_);

    // API of field "AlertExtRefCode"

    static const int kAlertExtRefCode = 1;

    /**
     * Clears the field "AlertExtRefCode".
     *
     * The field will be set to its default value. The hasAlertExtRefCode()
     * method will return false.
     */
    inline void clearAlertExtRefCode();

    /**
     * Checks whether the field "AlertExtRefCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertExtRefCode()). Otherwise it will return false.
     */
    inline bool hasAlertExtRefCode () const;

    /**
     * Returns the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @return The value of the field "AlertExtRefCode"
     */
    inline const ::std::string& getAlertExtRefCode () const;

    /**
     * Retrieves the value of the field "AlertExtRefCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertExtRefCode".
     */
    inline ::std::string& getAlertExtRefCodeMutable ();

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const ::std::string& AlertExtRefCode_);

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const char* AlertExtRefCode_);

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const char* value, size_t size);

    // API of field "AlertNameID"

    static const int kAlertNameID = 2;

    /**
     * Clears the field "AlertNameID".
     *
     * The field will be set to its default value. The hasAlertNameID()
     * method will return false.
     */
    inline void clearAlertNameID();

    /**
     * Checks whether the field "AlertNameID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertNameID()). Otherwise it will return false.
     */
    inline bool hasAlertNameID () const;

    /**
     * Returns the value of the member "AlertNameID".
     *
     * Alert Name ID for Map
     *
     * @return The value of the field "AlertNameID"
     */
    inline uint32 getAlertNameID () const;

    /**
     * Sets the value of the member "AlertNameID".
     *
     * Alert Name ID for Map
     *
     * @param AlertNameID The value which will be set
     */
    inline void setAlertNameID (uint32 AlertNameID_);

    // API of field "AlertGroupId"

    static const int kAlertGroupId = 3;

    /**
     * Clears the field "AlertGroupId".
     *
     * The field will be set to its default value. The hasAlertGroupId()
     * method will return false.
     */
    inline void clearAlertGroupId();

    /**
     * Checks whether the field "AlertGroupId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertGroupId()). Otherwise it will return false.
     */
    inline bool hasAlertGroupId () const;

    /**
     * Returns the value of the member "AlertGroupId".
     *
     * Alert Category or Group ID for Map
     *
     * @return The value of the field "AlertGroupId"
     */
    inline uint32 getAlertGroupId () const;

    /**
     * Sets the value of the member "AlertGroupId".
     *
     * Alert Category or Group ID for Map
     *
     * @param AlertGroupId The value which will be set
     */
    inline void setAlertGroupId (uint32 AlertGroupId_);

    // API of field "AlertPrio"

    static const int kAlertPrio = 4;

    /**
     * Clears the field "AlertPrio".
     *
     * The field will be set to its default value. The hasAlertPrio()
     * method will return false.
     */
    inline void clearAlertPrio();

    /**
     * Checks whether the field "AlertPrio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertPrio()). Otherwise it will return false.
     */
    inline bool hasAlertPrio () const;

    /**
     * Returns the value of the member "AlertPrio".
     *
     * Alert Priority Information for Map
     *
     * @return The value of the field "AlertPrio"
     */
    inline uint32 getAlertPrio () const;

    /**
     * Sets the value of the member "AlertPrio".
     *
     * Alert Priority Information for Map
     *
     * @param AlertPrio The value which will be set
     */
    inline void setAlertPrio (uint32 AlertPrio_);

    // API of field "AlertColor"

    static const int kAlertColor = 5;

    /**
     * Clears the field "AlertColor".
     *
     * The field will be set to its default value. The hasAlertColor()
     * method will return false.
     */
    inline void clearAlertColor();

    /**
     * Checks whether the field "AlertColor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertColor()). Otherwise it will return false.
     */
    inline bool hasAlertColor () const;

    /**
     * Returns the value of the member "AlertColor".
     *
     * Alert Color Information for Map
     *
     * @return The value of the field "AlertColor"
     */
    inline const ::sxm_main_fi_types::T_RGBAcolor& getAlertColor () const;

    /**
     * Retrieves the value of the field "AlertColor" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertColor".
     */
    inline ::sxm_main_fi_types::T_RGBAcolor& getAlertColorMutable ();

    /**
     * Sets the value of the member "AlertColor".
     *
     * Alert Color Information for Map
     *
     * @param AlertColor The value which will be set
     */
    inline void setAlertColor (const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_);

    static const T_WSAlertInfo &getDefaultInstance();

private:

    inline void set_has_AlertTypeID ();

    inline void clear_has_AlertTypeID ();

    inline void set_has_AlertExtRefCode ();

    inline void clear_has_AlertExtRefCode ();

    inline void set_has_AlertNameID ();

    inline void clear_has_AlertNameID ();

    inline void set_has_AlertGroupId ();

    inline void clear_has_AlertGroupId ();

    inline void set_has_AlertPrio ();

    inline void clear_has_AlertPrio ();

    inline void set_has_AlertColor ();

    inline void clear_has_AlertColor ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_WSAlertTypes _AlertTypeID;

    ::std::string _AlertExtRefCode;

    uint32 _AlertNameID;

    uint32 _AlertGroupId;

    uint32 _AlertPrio;

    ::sxm_main_fi_types::T_RGBAcolor _AlertColor;

};

/**
 * It provides Weather and Security Alert Configuration
 */
class T_WSAlertConfig {
public:

    /**
     * Default constructor
     */
    inline  T_WSAlertConfig ();

    /**
     * Copy constructor
     */
    inline  T_WSAlertConfig (const T_WSAlertConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_WSAlertConfig (T_e8_WSAlertTypes AlertTypeID_, const ::std::string& AlertExtRefCode_, uint32 AlertNameID_, uint32 AlertGroupId_, uint32 AlertPrio_, const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_, bool IsEnabledInHMI_, bool IsEnabledInMap_);

    /**
     * Destructor
     */
    inline  ~T_WSAlertConfig();

    /**
     * Assignment operator
     */
    inline T_WSAlertConfig& operator = (const T_WSAlertConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WSAlertConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WSAlertConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WSAlertConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WSAlertConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AlertTypeID"

    static const int kAlertTypeID = 0;

    /**
     * Clears the field "AlertTypeID".
     *
     * The field will be set to its default value. The hasAlertTypeID()
     * method will return false.
     */
    inline void clearAlertTypeID();

    /**
     * Checks whether the field "AlertTypeID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertTypeID()). Otherwise it will return false.
     */
    inline bool hasAlertTypeID () const;

    /**
     * Returns the value of the member "AlertTypeID".
     *
     * Alert type ID
     *
     * @return The value of the field "AlertTypeID"
     */
    inline T_e8_WSAlertTypes getAlertTypeID () const;

    /**
     * Sets the value of the member "AlertTypeID".
     *
     * Alert type ID
     *
     * @param AlertTypeID The value which will be set
     */
    inline void setAlertTypeID (T_e8_WSAlertTypes AlertTypeID_);

    // API of field "AlertExtRefCode"

    static const int kAlertExtRefCode = 1;

    /**
     * Clears the field "AlertExtRefCode".
     *
     * The field will be set to its default value. The hasAlertExtRefCode()
     * method will return false.
     */
    inline void clearAlertExtRefCode();

    /**
     * Checks whether the field "AlertExtRefCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertExtRefCode()). Otherwise it will return false.
     */
    inline bool hasAlertExtRefCode () const;

    /**
     * Returns the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @return The value of the field "AlertExtRefCode"
     */
    inline const ::std::string& getAlertExtRefCode () const;

    /**
     * Retrieves the value of the field "AlertExtRefCode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertExtRefCode".
     */
    inline ::std::string& getAlertExtRefCodeMutable ();

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const ::std::string& AlertExtRefCode_);

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const char* AlertExtRefCode_);

    /**
     * Sets the value of the member "AlertExtRefCode".
     *
     * Alert ExtRef code
     *
     * @param AlertExtRefCode The value which will be set
     */
    inline void setAlertExtRefCode (const char* value, size_t size);

    // API of field "AlertNameID"

    static const int kAlertNameID = 2;

    /**
     * Clears the field "AlertNameID".
     *
     * The field will be set to its default value. The hasAlertNameID()
     * method will return false.
     */
    inline void clearAlertNameID();

    /**
     * Checks whether the field "AlertNameID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertNameID()). Otherwise it will return false.
     */
    inline bool hasAlertNameID () const;

    /**
     * Returns the value of the member "AlertNameID".
     *
     * Alert Name ID for Map
     *
     * @return The value of the field "AlertNameID"
     */
    inline uint32 getAlertNameID () const;

    /**
     * Sets the value of the member "AlertNameID".
     *
     * Alert Name ID for Map
     *
     * @param AlertNameID The value which will be set
     */
    inline void setAlertNameID (uint32 AlertNameID_);

    // API of field "AlertGroupId"

    static const int kAlertGroupId = 3;

    /**
     * Clears the field "AlertGroupId".
     *
     * The field will be set to its default value. The hasAlertGroupId()
     * method will return false.
     */
    inline void clearAlertGroupId();

    /**
     * Checks whether the field "AlertGroupId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertGroupId()). Otherwise it will return false.
     */
    inline bool hasAlertGroupId () const;

    /**
     * Returns the value of the member "AlertGroupId".
     *
     * Alert Category or Group ID for Map
     *
     * @return The value of the field "AlertGroupId"
     */
    inline uint32 getAlertGroupId () const;

    /**
     * Sets the value of the member "AlertGroupId".
     *
     * Alert Category or Group ID for Map
     *
     * @param AlertGroupId The value which will be set
     */
    inline void setAlertGroupId (uint32 AlertGroupId_);

    // API of field "AlertPrio"

    static const int kAlertPrio = 4;

    /**
     * Clears the field "AlertPrio".
     *
     * The field will be set to its default value. The hasAlertPrio()
     * method will return false.
     */
    inline void clearAlertPrio();

    /**
     * Checks whether the field "AlertPrio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertPrio()). Otherwise it will return false.
     */
    inline bool hasAlertPrio () const;

    /**
     * Returns the value of the member "AlertPrio".
     *
     * Alert Priority Information for Map
     *
     * @return The value of the field "AlertPrio"
     */
    inline uint32 getAlertPrio () const;

    /**
     * Sets the value of the member "AlertPrio".
     *
     * Alert Priority Information for Map
     *
     * @param AlertPrio The value which will be set
     */
    inline void setAlertPrio (uint32 AlertPrio_);

    // API of field "AlertColor"

    static const int kAlertColor = 5;

    /**
     * Clears the field "AlertColor".
     *
     * The field will be set to its default value. The hasAlertColor()
     * method will return false.
     */
    inline void clearAlertColor();

    /**
     * Checks whether the field "AlertColor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertColor()). Otherwise it will return false.
     */
    inline bool hasAlertColor () const;

    /**
     * Returns the value of the member "AlertColor".
     *
     * Alert Color Information for Map
     *
     * @return The value of the field "AlertColor"
     */
    inline const ::sxm_main_fi_types::T_RGBAcolor& getAlertColor () const;

    /**
     * Retrieves the value of the field "AlertColor" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertColor".
     */
    inline ::sxm_main_fi_types::T_RGBAcolor& getAlertColorMutable ();

    /**
     * Sets the value of the member "AlertColor".
     *
     * Alert Color Information for Map
     *
     * @param AlertColor The value which will be set
     */
    inline void setAlertColor (const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_);

    // API of field "IsEnabledInHMI"

    static const int kIsEnabledInHMI = 6;

    /**
     * Clears the field "IsEnabledInHMI".
     *
     * The field will be set to its default value. The hasIsEnabledInHMI()
     * method will return false.
     */
    inline void clearIsEnabledInHMI();

    /**
     * Checks whether the field "IsEnabledInHMI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsEnabledInHMI()). Otherwise it will return false.
     */
    inline bool hasIsEnabledInHMI () const;

    /**
     * Returns the value of the member "IsEnabledInHMI".
     *
     * True - Enabled
     *
     * @return The value of the field "IsEnabledInHMI"
     */
    inline bool getIsEnabledInHMI () const;

    /**
     * Sets the value of the member "IsEnabledInHMI".
     *
     * True - Enabled
     *
     * @param IsEnabledInHMI The value which will be set
     */
    inline void setIsEnabledInHMI (bool IsEnabledInHMI_);

    // API of field "IsEnabledInMap"

    static const int kIsEnabledInMap = 7;

    /**
     * Clears the field "IsEnabledInMap".
     *
     * The field will be set to its default value. The hasIsEnabledInMap()
     * method will return false.
     */
    inline void clearIsEnabledInMap();

    /**
     * Checks whether the field "IsEnabledInMap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsEnabledInMap()). Otherwise it will return false.
     */
    inline bool hasIsEnabledInMap () const;

    /**
     * Returns the value of the member "IsEnabledInMap".
     *
     * True - Enabled
     *
     * @return The value of the field "IsEnabledInMap"
     */
    inline bool getIsEnabledInMap () const;

    /**
     * Sets the value of the member "IsEnabledInMap".
     *
     * True - Enabled
     *
     * @param IsEnabledInMap The value which will be set
     */
    inline void setIsEnabledInMap (bool IsEnabledInMap_);

    static const T_WSAlertConfig &getDefaultInstance();

private:

    inline void set_has_AlertTypeID ();

    inline void clear_has_AlertTypeID ();

    inline void set_has_AlertExtRefCode ();

    inline void clear_has_AlertExtRefCode ();

    inline void set_has_AlertNameID ();

    inline void clear_has_AlertNameID ();

    inline void set_has_AlertGroupId ();

    inline void clear_has_AlertGroupId ();

    inline void set_has_AlertPrio ();

    inline void clear_has_AlertPrio ();

    inline void set_has_AlertColor ();

    inline void clear_has_AlertColor ();

    inline void set_has_IsEnabledInHMI ();

    inline void clear_has_IsEnabledInHMI ();

    inline void set_has_IsEnabledInMap ();

    inline void clear_has_IsEnabledInMap ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_e8_WSAlertTypes _AlertTypeID;

    ::std::string _AlertExtRefCode;

    uint32 _AlertNameID;

    uint32 _AlertGroupId;

    uint32 _AlertPrio;

    ::sxm_main_fi_types::T_RGBAcolor _AlertColor;

    bool _IsEnabledInHMI;

    bool _IsEnabledInMap;

};

/**
 * Weather and Security Alert message
 */
class T_WSAlertMsg {
public:

    /**
     * Default constructor
     */
    inline  T_WSAlertMsg ();

    /**
     * Copy constructor
     */
    inline  T_WSAlertMsg (const T_WSAlertMsg &rhs);

    /**
     * All fields constructor
     */
    inline  T_WSAlertMsg (uint32 MessageID_, const ::std::string& Text_, const ::fi_types::T_POSIXTime& StartTime_, const ::fi_types::T_POSIXTime& EndTime_, T_e8_Language Language_, uint16 Priority_, bool bIsMarineZone_, const ::std::vector< T_WSAlertInfo >& AlertTypes_, const ::std::vector< T_WSAlertLocation >& AlertLocations_, float Distance_);

    /**
     * Destructor
     */
    inline  ~T_WSAlertMsg();

    /**
     * Assignment operator
     */
    inline T_WSAlertMsg& operator = (const T_WSAlertMsg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WSAlertMsg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WSAlertMsg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WSAlertMsg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WSAlertMsg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MessageID"

    static const int kMessageID = 0;

    /**
     * Clears the field "MessageID".
     *
     * The field will be set to its default value. The hasMessageID()
     * method will return false.
     */
    inline void clearMessageID();

    /**
     * Checks whether the field "MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageID()). Otherwise it will return false.
     */
    inline bool hasMessageID () const;

    /**
     * Returns the value of the member "MessageID".
     *
     * It describes the unique ID for each alert message
     *
     * @return The value of the field "MessageID"
     */
    inline uint32 getMessageID () const;

    /**
     * Sets the value of the member "MessageID".
     *
     * It describes the unique ID for each alert message
     *
     * @param MessageID The value which will be set
     */
    inline void setMessageID (uint32 MessageID_);

    // API of field "Text"

    static const int kText = 1;

    /**
     * Clears the field "Text".
     *
     * The field will be set to its default value. The hasText()
     * method will return false.
     */
    inline void clearText();

    /**
     * Checks whether the field "Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText()). Otherwise it will return false.
     */
    inline bool hasText () const;

    /**
     * Returns the value of the member "Text".
     *
     * It describes the alert message text
     *
     * @return The value of the field "Text"
     */
    inline const ::std::string& getText () const;

    /**
     * Retrieves the value of the field "Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text".
     */
    inline ::std::string& getTextMutable ();

    /**
     * Sets the value of the member "Text".
     *
     * It describes the alert message text
     *
     * @param Text The value which will be set
     */
    inline void setText (const ::std::string& Text_);

    /**
     * Sets the value of the member "Text".
     *
     * It describes the alert message text
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* Text_);

    /**
     * Sets the value of the member "Text".
     *
     * It describes the alert message text
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* value, size_t size);

    // API of field "StartTime"

    static const int kStartTime = 2;

    /**
     * Clears the field "StartTime".
     *
     * The field will be set to its default value. The hasStartTime()
     * method will return false.
     */
    inline void clearStartTime();

    /**
     * Checks whether the field "StartTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartTime()). Otherwise it will return false.
     */
    inline bool hasStartTime () const;

    /**
     * Returns the value of the member "StartTime".
     *
     * Start time
     *
     * @return The value of the field "StartTime"
     */
    inline const ::fi_types::T_POSIXTime& getStartTime () const;

    /**
     * Retrieves the value of the field "StartTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StartTime".
     */
    inline ::fi_types::T_POSIXTime& getStartTimeMutable ();

    /**
     * Sets the value of the member "StartTime".
     *
     * Start time
     *
     * @param StartTime The value which will be set
     */
    inline void setStartTime (const ::fi_types::T_POSIXTime& StartTime_);

    // API of field "EndTime"

    static const int kEndTime = 3;

    /**
     * Clears the field "EndTime".
     *
     * The field will be set to its default value. The hasEndTime()
     * method will return false.
     */
    inline void clearEndTime();

    /**
     * Checks whether the field "EndTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEndTime()). Otherwise it will return false.
     */
    inline bool hasEndTime () const;

    /**
     * Returns the value of the member "EndTime".
     *
     * End time
     *
     * @return The value of the field "EndTime"
     */
    inline const ::fi_types::T_POSIXTime& getEndTime () const;

    /**
     * Retrieves the value of the field "EndTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EndTime".
     */
    inline ::fi_types::T_POSIXTime& getEndTimeMutable ();

    /**
     * Sets the value of the member "EndTime".
     *
     * End time
     *
     * @param EndTime The value which will be set
     */
    inline void setEndTime (const ::fi_types::T_POSIXTime& EndTime_);

    // API of field "Language"

    static const int kLanguage = 4;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * Alert message language
     *
     * @return The value of the field "Language"
     */
    inline T_e8_Language getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * Alert message language
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (T_e8_Language Language_);

    // API of field "Priority"

    static const int kPriority = 5;

    /**
     * Clears the field "Priority".
     *
     * The field will be set to its default value. The hasPriority()
     * method will return false.
     */
    inline void clearPriority();

    /**
     * Checks whether the field "Priority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPriority()). Otherwise it will return false.
     */
    inline bool hasPriority () const;

    /**
     * Returns the value of the member "Priority".
     *
     * Priority of the alert message
     *
     * @return The value of the field "Priority"
     */
    inline uint16 getPriority () const;

    /**
     * Sets the value of the member "Priority".
     *
     * Priority of the alert message
     *
     * @param Priority The value which will be set
     */
    inline void setPriority (uint16 Priority_);

    // API of field "bIsMarineZone"

    static const int kBIsMarineZone = 6;

    /**
     * Clears the field "bIsMarineZone".
     *
     * The field will be set to its default value. The hasBIsMarineZone()
     * method will return false.
     */
    inline void clearBIsMarineZone();

    /**
     * Checks whether the field "bIsMarineZone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsMarineZone()). Otherwise it will return false.
     */
    inline bool hasBIsMarineZone () const;

    /**
     * Returns the value of the member "bIsMarineZone".
     *
     * Indicates whether the alert region is a Marine zone or State/Province
     *
     * @return The value of the field "bIsMarineZone"
     */
    inline bool getBIsMarineZone () const;

    /**
     * Sets the value of the member "bIsMarineZone".
     *
     * Indicates whether the alert region is a Marine zone or State/Province
     *
     * @param bIsMarineZone The value which will be set
     */
    inline void setBIsMarineZone (bool bIsMarineZone_);

    // API of field "AlertTypes"

    static const int kAlertTypes = 7;

    /**
     * Clears the field "AlertTypes".
     *
     * The field will be set to its default value. The hasAlertTypes()
     * method will return false.
     */
    inline void clearAlertTypes();

    /**
     * Checks whether the field "AlertTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertTypes()). Otherwise it will return false.
     */
    inline bool hasAlertTypes () const;

    /**
     * Returns the value of the member "AlertTypes".
     *
     * List the available alert types
     *
     * @return The value of the field "AlertTypes"
     */
    inline const ::std::vector< T_WSAlertInfo >& getAlertTypes () const;

    /**
     * Retrieves the value of the field "AlertTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertTypes".
     */
    inline ::std::vector< T_WSAlertInfo >& getAlertTypesMutable ();

    /**
     * Sets the value of the member "AlertTypes".
     *
     * List the available alert types
     *
     * @param AlertTypes The value which will be set
     */
    inline void setAlertTypes (const ::std::vector< T_WSAlertInfo >& AlertTypes_);

    // API of field "AlertLocations"

    static const int kAlertLocations = 8;

    /**
     * Clears the field "AlertLocations".
     *
     * The field will be set to its default value. The hasAlertLocations()
     * method will return false.
     */
    inline void clearAlertLocations();

    /**
     * Checks whether the field "AlertLocations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlertLocations()). Otherwise it will return false.
     */
    inline bool hasAlertLocations () const;

    /**
     * Returns the value of the member "AlertLocations".
     *
     * List the available alert locations
     *
     * @return The value of the field "AlertLocations"
     */
    inline const ::std::vector< T_WSAlertLocation >& getAlertLocations () const;

    /**
     * Retrieves the value of the field "AlertLocations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AlertLocations".
     */
    inline ::std::vector< T_WSAlertLocation >& getAlertLocationsMutable ();

    /**
     * Sets the value of the member "AlertLocations".
     *
     * List the available alert locations
     *
     * @param AlertLocations The value which will be set
     */
    inline void setAlertLocations (const ::std::vector< T_WSAlertLocation >& AlertLocations_);

    // API of field "Distance"

    static const int kDistance = 9;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Alert location distance in Miles
     *
     * @return The value of the field "Distance"
     */
    inline float getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Alert location distance in Miles
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (float Distance_);

    static const T_WSAlertMsg &getDefaultInstance();

private:

    static const ::std::vector< T_WSAlertInfo >& getT_WSAlertInfoList_DefaultInstance ();

    static const ::std::vector< T_WSAlertLocation >& getT_WSAlertLocationList_DefaultInstance ();

    inline void set_has_MessageID ();

    inline void clear_has_MessageID ();

    inline void set_has_Text ();

    inline void clear_has_Text ();

    inline void set_has_StartTime ();

    inline void clear_has_StartTime ();

    inline void set_has_EndTime ();

    inline void clear_has_EndTime ();

    inline void set_has_Language ();

    inline void clear_has_Language ();

    inline void set_has_Priority ();

    inline void clear_has_Priority ();

    inline void set_has_bIsMarineZone ();

    inline void clear_has_bIsMarineZone ();

    inline void set_has_AlertTypes ();

    inline void clear_has_AlertTypes ();

    inline void set_has_AlertLocations ();

    inline void clear_has_AlertLocations ();

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    uint32 _has_bits_[ (10 + 31) / 32];

    uint32 _MessageID;

    ::std::string _Text;

    ::fi_types::T_POSIXTime _StartTime;

    ::fi_types::T_POSIXTime _EndTime;

    T_e8_Language _Language;

    uint16 _Priority;

    bool _bIsMarineZone;

    ::std::vector< T_WSAlertInfo > _AlertTypes;

    ::std::vector< T_WSAlertLocation > _AlertLocations;

    float _Distance;

};

inline  T_WSAlertLocation::T_WSAlertLocation ()  :
    _Description (),
    _ShapeGeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WSAlertLocation::T_WSAlertLocation (const T_WSAlertLocation &rhs)  :
    _Description (),
    _ShapeGeoPoints ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WSAlertLocation::T_WSAlertLocation (const ::std::string& Description_, const ::std::vector< ::fi_types::T_PositionWGS84 >& ShapeGeoPoints_)  :
    _Description (Description_),
    _ShapeGeoPoints (ShapeGeoPoints_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WSAlertLocation::~T_WSAlertLocation() {
}

inline T_WSAlertLocation& T_WSAlertLocation::operator = (const T_WSAlertLocation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDescription()) {
            setDescription(rhs.getDescription());
        } else {
            clearDescription();
        }
        if (rhs.hasShapeGeoPoints()) {
            setShapeGeoPoints(rhs.getShapeGeoPoints());
        } else {
            clearShapeGeoPoints();
        }
    }
    return *this;
}

inline bool T_WSAlertLocation::operator == (const T_WSAlertLocation& rhs) const {
    return (((!hasDescription() && !rhs.hasDescription()) || getDescription() == rhs.getDescription()) &&
        ((!hasShapeGeoPoints() && !rhs.hasShapeGeoPoints()) || getShapeGeoPoints() == rhs.getShapeGeoPoints()));
}

inline bool T_WSAlertLocation::operator != (const T_WSAlertLocation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WSAlertLocation::operator < (const T_WSAlertLocation& rhs) const {
    if (hasDescription() || rhs.hasDescription()) {
        if (getDescription() < rhs.getDescription()) return true;
        if (getDescription() > rhs.getDescription()) return false;
    }
    if (hasShapeGeoPoints() || rhs.hasShapeGeoPoints()) {
        if (getShapeGeoPoints() < rhs.getShapeGeoPoints()) return true;
        if (getShapeGeoPoints() > rhs.getShapeGeoPoints()) return false;
    }
    return false;
}

inline bool T_WSAlertLocation::operator > (const T_WSAlertLocation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WSAlertLocation::clear() {
    clearDescription();
    clearShapeGeoPoints();
}

inline void T_WSAlertLocation::clearDescription() {
    if (hasDescription()) {
         clear_has_Description();
        _Description.clear();
     }
}

inline bool T_WSAlertLocation::hasDescription () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_WSAlertLocation::getDescription () const {
    return _Description;
}

inline ::std::string& T_WSAlertLocation::getDescriptionMutable () {
    set_has_Description();
    return _Description;
}

inline void T_WSAlertLocation::setDescription (const ::std::string& Description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description = Description_;
}

inline void T_WSAlertLocation::setDescription (const char* Description_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Description_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description.assign(Description_);
}

inline void T_WSAlertLocation::setDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Description();
    this->_Description.assign(value, size);
}

inline void T_WSAlertLocation::clearShapeGeoPoints() {
    if (hasShapeGeoPoints()) {
         clear_has_ShapeGeoPoints();
        _ShapeGeoPoints.clear();
     }
}

inline bool T_WSAlertLocation::hasShapeGeoPoints () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::fi_types::T_PositionWGS84 >& T_WSAlertLocation::getShapeGeoPoints () const {
    return _ShapeGeoPoints;
}

inline ::std::vector< ::fi_types::T_PositionWGS84 >& T_WSAlertLocation::getShapeGeoPointsMutable () {
    set_has_ShapeGeoPoints();
    return _ShapeGeoPoints;
}

inline void T_WSAlertLocation::setShapeGeoPoints (const ::std::vector< ::fi_types::T_PositionWGS84 >& ShapeGeoPoints_) {
    set_has_ShapeGeoPoints();
    this->_ShapeGeoPoints = ShapeGeoPoints_;
}

inline void T_WSAlertLocation::set_has_Description () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WSAlertLocation::clear_has_Description () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WSAlertLocation::set_has_ShapeGeoPoints () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WSAlertLocation::clear_has_ShapeGeoPoints () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_WSAlertInfo::T_WSAlertInfo ()  :
    _AlertTypeID (::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE),
    _AlertExtRefCode (),
    _AlertNameID (0u),
    _AlertGroupId (0u),
    _AlertPrio (0u),
    _AlertColor ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WSAlertInfo::T_WSAlertInfo (const T_WSAlertInfo &rhs)  :
    _AlertTypeID (::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE),
    _AlertExtRefCode (),
    _AlertNameID (0u),
    _AlertGroupId (0u),
    _AlertPrio (0u),
    _AlertColor ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WSAlertInfo::T_WSAlertInfo (T_e8_WSAlertTypes AlertTypeID_, const ::std::string& AlertExtRefCode_, uint32 AlertNameID_, uint32 AlertGroupId_, uint32 AlertPrio_, const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_)  :
    _AlertTypeID (AlertTypeID_),
    _AlertExtRefCode (AlertExtRefCode_),
    _AlertNameID (AlertNameID_),
    _AlertGroupId (AlertGroupId_),
    _AlertPrio (AlertPrio_),
    _AlertColor (AlertColor_)
{
    #ifndef NDEBUG
    if (!(T_e8_WSAlertTypes_IsValid(AlertTypeID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlertTypeID_, "T_e8_WSAlertTypes", "AlertTypeID", "T_WSAlertInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WSAlertInfo::~T_WSAlertInfo() {
}

inline T_WSAlertInfo& T_WSAlertInfo::operator = (const T_WSAlertInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAlertTypeID()) {
            setAlertTypeID(rhs.getAlertTypeID());
        } else {
            clearAlertTypeID();
        }
        if (rhs.hasAlertExtRefCode()) {
            setAlertExtRefCode(rhs.getAlertExtRefCode());
        } else {
            clearAlertExtRefCode();
        }
        if (rhs.hasAlertNameID()) {
            setAlertNameID(rhs.getAlertNameID());
        } else {
            clearAlertNameID();
        }
        if (rhs.hasAlertGroupId()) {
            setAlertGroupId(rhs.getAlertGroupId());
        } else {
            clearAlertGroupId();
        }
        if (rhs.hasAlertPrio()) {
            setAlertPrio(rhs.getAlertPrio());
        } else {
            clearAlertPrio();
        }
        if (rhs.hasAlertColor()) {
            setAlertColor(rhs.getAlertColor());
        } else {
            clearAlertColor();
        }
    }
    return *this;
}

inline bool T_WSAlertInfo::operator == (const T_WSAlertInfo& rhs) const {
    return (((!hasAlertTypeID() && !rhs.hasAlertTypeID()) || getAlertTypeID() == rhs.getAlertTypeID()) &&
        ((!hasAlertExtRefCode() && !rhs.hasAlertExtRefCode()) || getAlertExtRefCode() == rhs.getAlertExtRefCode()) &&
        ((!hasAlertNameID() && !rhs.hasAlertNameID()) || getAlertNameID() == rhs.getAlertNameID()) &&
        ((!hasAlertGroupId() && !rhs.hasAlertGroupId()) || getAlertGroupId() == rhs.getAlertGroupId()) &&
        ((!hasAlertPrio() && !rhs.hasAlertPrio()) || getAlertPrio() == rhs.getAlertPrio()) &&
        ((!hasAlertColor() && !rhs.hasAlertColor()) || getAlertColor() == rhs.getAlertColor()));
}

inline bool T_WSAlertInfo::operator != (const T_WSAlertInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WSAlertInfo::operator < (const T_WSAlertInfo& rhs) const {
    if (hasAlertTypeID() || rhs.hasAlertTypeID()) {
        if ((uint32)getAlertTypeID() < (uint32)rhs.getAlertTypeID()) return true;
        if ((uint32)getAlertTypeID() > (uint32)rhs.getAlertTypeID()) return false;
    }
    if (hasAlertExtRefCode() || rhs.hasAlertExtRefCode()) {
        if (getAlertExtRefCode() < rhs.getAlertExtRefCode()) return true;
        if (getAlertExtRefCode() > rhs.getAlertExtRefCode()) return false;
    }
    if (hasAlertNameID() || rhs.hasAlertNameID()) {
        if (getAlertNameID() < rhs.getAlertNameID()) return true;
        if (getAlertNameID() > rhs.getAlertNameID()) return false;
    }
    if (hasAlertGroupId() || rhs.hasAlertGroupId()) {
        if (getAlertGroupId() < rhs.getAlertGroupId()) return true;
        if (getAlertGroupId() > rhs.getAlertGroupId()) return false;
    }
    if (hasAlertPrio() || rhs.hasAlertPrio()) {
        if (getAlertPrio() < rhs.getAlertPrio()) return true;
        if (getAlertPrio() > rhs.getAlertPrio()) return false;
    }
    if (hasAlertColor() || rhs.hasAlertColor()) {
        if (getAlertColor() < rhs.getAlertColor()) return true;
        if (getAlertColor() > rhs.getAlertColor()) return false;
    }
    return false;
}

inline bool T_WSAlertInfo::operator > (const T_WSAlertInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WSAlertInfo::clear() {
    clearAlertTypeID();
    clearAlertExtRefCode();
    clearAlertNameID();
    clearAlertGroupId();
    clearAlertPrio();
    clearAlertColor();
}

inline void T_WSAlertInfo::clearAlertTypeID() {
    if (hasAlertTypeID()) {
         clear_has_AlertTypeID();
        _AlertTypeID = ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE;
     }
}

inline bool T_WSAlertInfo::hasAlertTypeID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_WSAlertTypes T_WSAlertInfo::getAlertTypeID () const {
    return _AlertTypeID;
}

inline void T_WSAlertInfo::setAlertTypeID (T_e8_WSAlertTypes AlertTypeID_) {
    #ifndef NDEBUG
    if (!(T_e8_WSAlertTypes_IsValid(AlertTypeID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlertTypeID_, "T_e8_WSAlertTypes", "AlertTypeID", "T_WSAlertInfo");
    }
    #endif
    set_has_AlertTypeID();
    this->_AlertTypeID = AlertTypeID_;
}

inline void T_WSAlertInfo::clearAlertExtRefCode() {
    if (hasAlertExtRefCode()) {
         clear_has_AlertExtRefCode();
        _AlertExtRefCode.clear();
     }
}

inline bool T_WSAlertInfo::hasAlertExtRefCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_WSAlertInfo::getAlertExtRefCode () const {
    return _AlertExtRefCode;
}

inline ::std::string& T_WSAlertInfo::getAlertExtRefCodeMutable () {
    set_has_AlertExtRefCode();
    return _AlertExtRefCode;
}

inline void T_WSAlertInfo::setAlertExtRefCode (const ::std::string& AlertExtRefCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode = AlertExtRefCode_;
}

inline void T_WSAlertInfo::setAlertExtRefCode (const char* AlertExtRefCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode.assign(AlertExtRefCode_);
}

inline void T_WSAlertInfo::setAlertExtRefCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode.assign(value, size);
}

inline void T_WSAlertInfo::clearAlertNameID() {
    if (hasAlertNameID()) {
         clear_has_AlertNameID();
        _AlertNameID = 0u;
     }
}

inline bool T_WSAlertInfo::hasAlertNameID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_WSAlertInfo::getAlertNameID () const {
    return _AlertNameID;
}

inline void T_WSAlertInfo::setAlertNameID (uint32 AlertNameID_) {
    set_has_AlertNameID();
    this->_AlertNameID = AlertNameID_;
}

inline void T_WSAlertInfo::clearAlertGroupId() {
    if (hasAlertGroupId()) {
         clear_has_AlertGroupId();
        _AlertGroupId = 0u;
     }
}

inline bool T_WSAlertInfo::hasAlertGroupId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_WSAlertInfo::getAlertGroupId () const {
    return _AlertGroupId;
}

inline void T_WSAlertInfo::setAlertGroupId (uint32 AlertGroupId_) {
    set_has_AlertGroupId();
    this->_AlertGroupId = AlertGroupId_;
}

inline void T_WSAlertInfo::clearAlertPrio() {
    if (hasAlertPrio()) {
         clear_has_AlertPrio();
        _AlertPrio = 0u;
     }
}

inline bool T_WSAlertInfo::hasAlertPrio () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_WSAlertInfo::getAlertPrio () const {
    return _AlertPrio;
}

inline void T_WSAlertInfo::setAlertPrio (uint32 AlertPrio_) {
    set_has_AlertPrio();
    this->_AlertPrio = AlertPrio_;
}

inline void T_WSAlertInfo::clearAlertColor() {
    if (hasAlertColor()) {
         clear_has_AlertColor();
        _AlertColor.clear();
     }
}

inline bool T_WSAlertInfo::hasAlertColor () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::sxm_main_fi_types::T_RGBAcolor& T_WSAlertInfo::getAlertColor () const {
    return _AlertColor;
}

inline ::sxm_main_fi_types::T_RGBAcolor& T_WSAlertInfo::getAlertColorMutable () {
    set_has_AlertColor();
    return _AlertColor;
}

inline void T_WSAlertInfo::setAlertColor (const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_) {
    set_has_AlertColor();
    this->_AlertColor = AlertColor_;
}

inline void T_WSAlertInfo::set_has_AlertTypeID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WSAlertInfo::clear_has_AlertTypeID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WSAlertInfo::set_has_AlertExtRefCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WSAlertInfo::clear_has_AlertExtRefCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_WSAlertInfo::set_has_AlertNameID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_WSAlertInfo::clear_has_AlertNameID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_WSAlertInfo::set_has_AlertGroupId () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_WSAlertInfo::clear_has_AlertGroupId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_WSAlertInfo::set_has_AlertPrio () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_WSAlertInfo::clear_has_AlertPrio () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_WSAlertInfo::set_has_AlertColor () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_WSAlertInfo::clear_has_AlertColor () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_WSAlertConfig::T_WSAlertConfig ()  :
    _AlertTypeID (::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE),
    _AlertExtRefCode (),
    _AlertNameID (0u),
    _AlertGroupId (0u),
    _AlertPrio (0u),
    _AlertColor (),
    _IsEnabledInHMI (false),
    _IsEnabledInMap (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WSAlertConfig::T_WSAlertConfig (const T_WSAlertConfig &rhs)  :
    _AlertTypeID (::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE),
    _AlertExtRefCode (),
    _AlertNameID (0u),
    _AlertGroupId (0u),
    _AlertPrio (0u),
    _AlertColor (),
    _IsEnabledInHMI (false),
    _IsEnabledInMap (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WSAlertConfig::T_WSAlertConfig (T_e8_WSAlertTypes AlertTypeID_, const ::std::string& AlertExtRefCode_, uint32 AlertNameID_, uint32 AlertGroupId_, uint32 AlertPrio_, const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_, bool IsEnabledInHMI_, bool IsEnabledInMap_)  :
    _AlertTypeID (AlertTypeID_),
    _AlertExtRefCode (AlertExtRefCode_),
    _AlertNameID (AlertNameID_),
    _AlertGroupId (AlertGroupId_),
    _AlertPrio (AlertPrio_),
    _AlertColor (AlertColor_),
    _IsEnabledInHMI (IsEnabledInHMI_),
    _IsEnabledInMap (IsEnabledInMap_)
{
    #ifndef NDEBUG
    if (!(T_e8_WSAlertTypes_IsValid(AlertTypeID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlertTypeID_, "T_e8_WSAlertTypes", "AlertTypeID", "T_WSAlertConfig");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WSAlertConfig::~T_WSAlertConfig() {
}

inline T_WSAlertConfig& T_WSAlertConfig::operator = (const T_WSAlertConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAlertTypeID()) {
            setAlertTypeID(rhs.getAlertTypeID());
        } else {
            clearAlertTypeID();
        }
        if (rhs.hasAlertExtRefCode()) {
            setAlertExtRefCode(rhs.getAlertExtRefCode());
        } else {
            clearAlertExtRefCode();
        }
        if (rhs.hasAlertNameID()) {
            setAlertNameID(rhs.getAlertNameID());
        } else {
            clearAlertNameID();
        }
        if (rhs.hasAlertGroupId()) {
            setAlertGroupId(rhs.getAlertGroupId());
        } else {
            clearAlertGroupId();
        }
        if (rhs.hasAlertPrio()) {
            setAlertPrio(rhs.getAlertPrio());
        } else {
            clearAlertPrio();
        }
        if (rhs.hasAlertColor()) {
            setAlertColor(rhs.getAlertColor());
        } else {
            clearAlertColor();
        }
        if (rhs.hasIsEnabledInHMI()) {
            setIsEnabledInHMI(rhs.getIsEnabledInHMI());
        } else {
            clearIsEnabledInHMI();
        }
        if (rhs.hasIsEnabledInMap()) {
            setIsEnabledInMap(rhs.getIsEnabledInMap());
        } else {
            clearIsEnabledInMap();
        }
    }
    return *this;
}

inline bool T_WSAlertConfig::operator == (const T_WSAlertConfig& rhs) const {
    return (((!hasAlertTypeID() && !rhs.hasAlertTypeID()) || getAlertTypeID() == rhs.getAlertTypeID()) &&
        ((!hasAlertExtRefCode() && !rhs.hasAlertExtRefCode()) || getAlertExtRefCode() == rhs.getAlertExtRefCode()) &&
        ((!hasAlertNameID() && !rhs.hasAlertNameID()) || getAlertNameID() == rhs.getAlertNameID()) &&
        ((!hasAlertGroupId() && !rhs.hasAlertGroupId()) || getAlertGroupId() == rhs.getAlertGroupId()) &&
        ((!hasAlertPrio() && !rhs.hasAlertPrio()) || getAlertPrio() == rhs.getAlertPrio()) &&
        ((!hasAlertColor() && !rhs.hasAlertColor()) || getAlertColor() == rhs.getAlertColor()) &&
        ((!hasIsEnabledInHMI() && !rhs.hasIsEnabledInHMI()) || getIsEnabledInHMI() == rhs.getIsEnabledInHMI()) &&
        ((!hasIsEnabledInMap() && !rhs.hasIsEnabledInMap()) || getIsEnabledInMap() == rhs.getIsEnabledInMap()));
}

inline bool T_WSAlertConfig::operator != (const T_WSAlertConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WSAlertConfig::operator < (const T_WSAlertConfig& rhs) const {
    if (hasAlertTypeID() || rhs.hasAlertTypeID()) {
        if ((uint32)getAlertTypeID() < (uint32)rhs.getAlertTypeID()) return true;
        if ((uint32)getAlertTypeID() > (uint32)rhs.getAlertTypeID()) return false;
    }
    if (hasAlertExtRefCode() || rhs.hasAlertExtRefCode()) {
        if (getAlertExtRefCode() < rhs.getAlertExtRefCode()) return true;
        if (getAlertExtRefCode() > rhs.getAlertExtRefCode()) return false;
    }
    if (hasAlertNameID() || rhs.hasAlertNameID()) {
        if (getAlertNameID() < rhs.getAlertNameID()) return true;
        if (getAlertNameID() > rhs.getAlertNameID()) return false;
    }
    if (hasAlertGroupId() || rhs.hasAlertGroupId()) {
        if (getAlertGroupId() < rhs.getAlertGroupId()) return true;
        if (getAlertGroupId() > rhs.getAlertGroupId()) return false;
    }
    if (hasAlertPrio() || rhs.hasAlertPrio()) {
        if (getAlertPrio() < rhs.getAlertPrio()) return true;
        if (getAlertPrio() > rhs.getAlertPrio()) return false;
    }
    if (hasAlertColor() || rhs.hasAlertColor()) {
        if (getAlertColor() < rhs.getAlertColor()) return true;
        if (getAlertColor() > rhs.getAlertColor()) return false;
    }
    if (hasIsEnabledInHMI() || rhs.hasIsEnabledInHMI()) {
        if (getIsEnabledInHMI() < rhs.getIsEnabledInHMI()) return true;
        if (getIsEnabledInHMI() > rhs.getIsEnabledInHMI()) return false;
    }
    if (hasIsEnabledInMap() || rhs.hasIsEnabledInMap()) {
        if (getIsEnabledInMap() < rhs.getIsEnabledInMap()) return true;
        if (getIsEnabledInMap() > rhs.getIsEnabledInMap()) return false;
    }
    return false;
}

inline bool T_WSAlertConfig::operator > (const T_WSAlertConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WSAlertConfig::clear() {
    clearAlertTypeID();
    clearAlertExtRefCode();
    clearAlertNameID();
    clearAlertGroupId();
    clearAlertPrio();
    clearAlertColor();
    clearIsEnabledInHMI();
    clearIsEnabledInMap();
}

inline void T_WSAlertConfig::clearAlertTypeID() {
    if (hasAlertTypeID()) {
         clear_has_AlertTypeID();
        _AlertTypeID = ::sxm_wsalerts_main_fi_types::T_e8_WSAlertTypes__INVALID_ALERT_TYPE;
     }
}

inline bool T_WSAlertConfig::hasAlertTypeID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_WSAlertTypes T_WSAlertConfig::getAlertTypeID () const {
    return _AlertTypeID;
}

inline void T_WSAlertConfig::setAlertTypeID (T_e8_WSAlertTypes AlertTypeID_) {
    #ifndef NDEBUG
    if (!(T_e8_WSAlertTypes_IsValid(AlertTypeID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AlertTypeID_, "T_e8_WSAlertTypes", "AlertTypeID", "T_WSAlertConfig");
    }
    #endif
    set_has_AlertTypeID();
    this->_AlertTypeID = AlertTypeID_;
}

inline void T_WSAlertConfig::clearAlertExtRefCode() {
    if (hasAlertExtRefCode()) {
         clear_has_AlertExtRefCode();
        _AlertExtRefCode.clear();
     }
}

inline bool T_WSAlertConfig::hasAlertExtRefCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_WSAlertConfig::getAlertExtRefCode () const {
    return _AlertExtRefCode;
}

inline ::std::string& T_WSAlertConfig::getAlertExtRefCodeMutable () {
    set_has_AlertExtRefCode();
    return _AlertExtRefCode;
}

inline void T_WSAlertConfig::setAlertExtRefCode (const ::std::string& AlertExtRefCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode = AlertExtRefCode_;
}

inline void T_WSAlertConfig::setAlertExtRefCode (const char* AlertExtRefCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AlertExtRefCode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode.assign(AlertExtRefCode_);
}

inline void T_WSAlertConfig::setAlertExtRefCode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AlertExtRefCode();
    this->_AlertExtRefCode.assign(value, size);
}

inline void T_WSAlertConfig::clearAlertNameID() {
    if (hasAlertNameID()) {
         clear_has_AlertNameID();
        _AlertNameID = 0u;
     }
}

inline bool T_WSAlertConfig::hasAlertNameID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_WSAlertConfig::getAlertNameID () const {
    return _AlertNameID;
}

inline void T_WSAlertConfig::setAlertNameID (uint32 AlertNameID_) {
    set_has_AlertNameID();
    this->_AlertNameID = AlertNameID_;
}

inline void T_WSAlertConfig::clearAlertGroupId() {
    if (hasAlertGroupId()) {
         clear_has_AlertGroupId();
        _AlertGroupId = 0u;
     }
}

inline bool T_WSAlertConfig::hasAlertGroupId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_WSAlertConfig::getAlertGroupId () const {
    return _AlertGroupId;
}

inline void T_WSAlertConfig::setAlertGroupId (uint32 AlertGroupId_) {
    set_has_AlertGroupId();
    this->_AlertGroupId = AlertGroupId_;
}

inline void T_WSAlertConfig::clearAlertPrio() {
    if (hasAlertPrio()) {
         clear_has_AlertPrio();
        _AlertPrio = 0u;
     }
}

inline bool T_WSAlertConfig::hasAlertPrio () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_WSAlertConfig::getAlertPrio () const {
    return _AlertPrio;
}

inline void T_WSAlertConfig::setAlertPrio (uint32 AlertPrio_) {
    set_has_AlertPrio();
    this->_AlertPrio = AlertPrio_;
}

inline void T_WSAlertConfig::clearAlertColor() {
    if (hasAlertColor()) {
         clear_has_AlertColor();
        _AlertColor.clear();
     }
}

inline bool T_WSAlertConfig::hasAlertColor () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::sxm_main_fi_types::T_RGBAcolor& T_WSAlertConfig::getAlertColor () const {
    return _AlertColor;
}

inline ::sxm_main_fi_types::T_RGBAcolor& T_WSAlertConfig::getAlertColorMutable () {
    set_has_AlertColor();
    return _AlertColor;
}

inline void T_WSAlertConfig::setAlertColor (const ::sxm_main_fi_types::T_RGBAcolor& AlertColor_) {
    set_has_AlertColor();
    this->_AlertColor = AlertColor_;
}

inline void T_WSAlertConfig::clearIsEnabledInHMI() {
    if (hasIsEnabledInHMI()) {
         clear_has_IsEnabledInHMI();
        _IsEnabledInHMI = false;
     }
}

inline bool T_WSAlertConfig::hasIsEnabledInHMI () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_WSAlertConfig::getIsEnabledInHMI () const {
    return _IsEnabledInHMI;
}

inline void T_WSAlertConfig::setIsEnabledInHMI (bool IsEnabledInHMI_) {
    set_has_IsEnabledInHMI();
    this->_IsEnabledInHMI = IsEnabledInHMI_;
}

inline void T_WSAlertConfig::clearIsEnabledInMap() {
    if (hasIsEnabledInMap()) {
         clear_has_IsEnabledInMap();
        _IsEnabledInMap = false;
     }
}

inline bool T_WSAlertConfig::hasIsEnabledInMap () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_WSAlertConfig::getIsEnabledInMap () const {
    return _IsEnabledInMap;
}

inline void T_WSAlertConfig::setIsEnabledInMap (bool IsEnabledInMap_) {
    set_has_IsEnabledInMap();
    this->_IsEnabledInMap = IsEnabledInMap_;
}

inline void T_WSAlertConfig::set_has_AlertTypeID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WSAlertConfig::clear_has_AlertTypeID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WSAlertConfig::set_has_AlertExtRefCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WSAlertConfig::clear_has_AlertExtRefCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_WSAlertConfig::set_has_AlertNameID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_WSAlertConfig::clear_has_AlertNameID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_WSAlertConfig::set_has_AlertGroupId () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_WSAlertConfig::clear_has_AlertGroupId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_WSAlertConfig::set_has_AlertPrio () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_WSAlertConfig::clear_has_AlertPrio () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_WSAlertConfig::set_has_AlertColor () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_WSAlertConfig::clear_has_AlertColor () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_WSAlertConfig::set_has_IsEnabledInHMI () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_WSAlertConfig::clear_has_IsEnabledInHMI () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_WSAlertConfig::set_has_IsEnabledInMap () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_WSAlertConfig::clear_has_IsEnabledInMap () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_WSAlertMsg::T_WSAlertMsg ()  :
    _MessageID (0u),
    _Text (),
    _StartTime (),
    _EndTime (),
    _Language (::sxm_wsalerts_main_fi_types::T_e8_Language__ENGLISH),
    _Priority (0u),
    _bIsMarineZone (false),
    _AlertTypes (),
    _AlertLocations (),
    _Distance (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WSAlertMsg::T_WSAlertMsg (const T_WSAlertMsg &rhs)  :
    _MessageID (0u),
    _Text (),
    _StartTime (),
    _EndTime (),
    _Language (::sxm_wsalerts_main_fi_types::T_e8_Language__ENGLISH),
    _Priority (0u),
    _bIsMarineZone (false),
    _AlertTypes (),
    _AlertLocations (),
    _Distance (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WSAlertMsg::T_WSAlertMsg (uint32 MessageID_, const ::std::string& Text_, const ::fi_types::T_POSIXTime& StartTime_, const ::fi_types::T_POSIXTime& EndTime_, T_e8_Language Language_, uint16 Priority_, bool bIsMarineZone_, const ::std::vector< T_WSAlertInfo >& AlertTypes_, const ::std::vector< T_WSAlertLocation >& AlertLocations_, float Distance_)  :
    _MessageID (MessageID_),
    _Text (Text_),
    _StartTime (StartTime_),
    _EndTime (EndTime_),
    _Language (Language_),
    _Priority (Priority_),
    _bIsMarineZone (bIsMarineZone_),
    _AlertTypes (AlertTypes_),
    _AlertLocations (AlertLocations_),
    _Distance (Distance_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Language_IsValid(Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e8_Language", "Language", "T_WSAlertMsg");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WSAlertMsg::~T_WSAlertMsg() {
}

inline T_WSAlertMsg& T_WSAlertMsg::operator = (const T_WSAlertMsg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMessageID()) {
            setMessageID(rhs.getMessageID());
        } else {
            clearMessageID();
        }
        if (rhs.hasText()) {
            setText(rhs.getText());
        } else {
            clearText();
        }
        if (rhs.hasStartTime()) {
            setStartTime(rhs.getStartTime());
        } else {
            clearStartTime();
        }
        if (rhs.hasEndTime()) {
            setEndTime(rhs.getEndTime());
        } else {
            clearEndTime();
        }
        if (rhs.hasLanguage()) {
            setLanguage(rhs.getLanguage());
        } else {
            clearLanguage();
        }
        if (rhs.hasPriority()) {
            setPriority(rhs.getPriority());
        } else {
            clearPriority();
        }
        if (rhs.hasBIsMarineZone()) {
            setBIsMarineZone(rhs.getBIsMarineZone());
        } else {
            clearBIsMarineZone();
        }
        if (rhs.hasAlertTypes()) {
            setAlertTypes(rhs.getAlertTypes());
        } else {
            clearAlertTypes();
        }
        if (rhs.hasAlertLocations()) {
            setAlertLocations(rhs.getAlertLocations());
        } else {
            clearAlertLocations();
        }
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
    }
    return *this;
}

inline bool T_WSAlertMsg::operator == (const T_WSAlertMsg& rhs) const {
    return (((!hasMessageID() && !rhs.hasMessageID()) || getMessageID() == rhs.getMessageID()) &&
        ((!hasText() && !rhs.hasText()) || getText() == rhs.getText()) &&
        ((!hasStartTime() && !rhs.hasStartTime()) || getStartTime() == rhs.getStartTime()) &&
        ((!hasEndTime() && !rhs.hasEndTime()) || getEndTime() == rhs.getEndTime()) &&
        ((!hasLanguage() && !rhs.hasLanguage()) || getLanguage() == rhs.getLanguage()) &&
        ((!hasPriority() && !rhs.hasPriority()) || getPriority() == rhs.getPriority()) &&
        ((!hasBIsMarineZone() && !rhs.hasBIsMarineZone()) || getBIsMarineZone() == rhs.getBIsMarineZone()) &&
        ((!hasAlertTypes() && !rhs.hasAlertTypes()) || getAlertTypes() == rhs.getAlertTypes()) &&
        ((!hasAlertLocations() && !rhs.hasAlertLocations()) || getAlertLocations() == rhs.getAlertLocations()) &&
        ((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()));
}

inline bool T_WSAlertMsg::operator != (const T_WSAlertMsg& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WSAlertMsg::operator < (const T_WSAlertMsg& rhs) const {
    if (hasMessageID() || rhs.hasMessageID()) {
        if (getMessageID() < rhs.getMessageID()) return true;
        if (getMessageID() > rhs.getMessageID()) return false;
    }
    if (hasText() || rhs.hasText()) {
        if (getText() < rhs.getText()) return true;
        if (getText() > rhs.getText()) return false;
    }
    if (hasStartTime() || rhs.hasStartTime()) {
        if (getStartTime() < rhs.getStartTime()) return true;
        if (getStartTime() > rhs.getStartTime()) return false;
    }
    if (hasEndTime() || rhs.hasEndTime()) {
        if (getEndTime() < rhs.getEndTime()) return true;
        if (getEndTime() > rhs.getEndTime()) return false;
    }
    if (hasLanguage() || rhs.hasLanguage()) {
        if ((uint32)getLanguage() < (uint32)rhs.getLanguage()) return true;
        if ((uint32)getLanguage() > (uint32)rhs.getLanguage()) return false;
    }
    if (hasPriority() || rhs.hasPriority()) {
        if (getPriority() < rhs.getPriority()) return true;
        if (getPriority() > rhs.getPriority()) return false;
    }
    if (hasBIsMarineZone() || rhs.hasBIsMarineZone()) {
        if (getBIsMarineZone() < rhs.getBIsMarineZone()) return true;
        if (getBIsMarineZone() > rhs.getBIsMarineZone()) return false;
    }
    if (hasAlertTypes() || rhs.hasAlertTypes()) {
        if (getAlertTypes() < rhs.getAlertTypes()) return true;
        if (getAlertTypes() > rhs.getAlertTypes()) return false;
    }
    if (hasAlertLocations() || rhs.hasAlertLocations()) {
        if (getAlertLocations() < rhs.getAlertLocations()) return true;
        if (getAlertLocations() > rhs.getAlertLocations()) return false;
    }
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    return false;
}

inline bool T_WSAlertMsg::operator > (const T_WSAlertMsg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WSAlertMsg::clear() {
    clearMessageID();
    clearText();
    clearStartTime();
    clearEndTime();
    clearLanguage();
    clearPriority();
    clearBIsMarineZone();
    clearAlertTypes();
    clearAlertLocations();
    clearDistance();
}

inline void T_WSAlertMsg::clearMessageID() {
    if (hasMessageID()) {
         clear_has_MessageID();
        _MessageID = 0u;
     }
}

inline bool T_WSAlertMsg::hasMessageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_WSAlertMsg::getMessageID () const {
    return _MessageID;
}

inline void T_WSAlertMsg::setMessageID (uint32 MessageID_) {
    set_has_MessageID();
    this->_MessageID = MessageID_;
}

inline void T_WSAlertMsg::clearText() {
    if (hasText()) {
         clear_has_Text();
        _Text.clear();
     }
}

inline bool T_WSAlertMsg::hasText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_WSAlertMsg::getText () const {
    return _Text;
}

inline ::std::string& T_WSAlertMsg::getTextMutable () {
    set_has_Text();
    return _Text;
}

inline void T_WSAlertMsg::setText (const ::std::string& Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text = Text_;
}

inline void T_WSAlertMsg::setText (const char* Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text.assign(Text_);
}

inline void T_WSAlertMsg::setText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text();
    this->_Text.assign(value, size);
}

inline void T_WSAlertMsg::clearStartTime() {
    if (hasStartTime()) {
         clear_has_StartTime();
        _StartTime.clear();
     }
}

inline bool T_WSAlertMsg::hasStartTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_WSAlertMsg::getStartTime () const {
    return _StartTime;
}

inline ::fi_types::T_POSIXTime& T_WSAlertMsg::getStartTimeMutable () {
    set_has_StartTime();
    return _StartTime;
}

inline void T_WSAlertMsg::setStartTime (const ::fi_types::T_POSIXTime& StartTime_) {
    set_has_StartTime();
    this->_StartTime = StartTime_;
}

inline void T_WSAlertMsg::clearEndTime() {
    if (hasEndTime()) {
         clear_has_EndTime();
        _EndTime.clear();
     }
}

inline bool T_WSAlertMsg::hasEndTime () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_types::T_POSIXTime& T_WSAlertMsg::getEndTime () const {
    return _EndTime;
}

inline ::fi_types::T_POSIXTime& T_WSAlertMsg::getEndTimeMutable () {
    set_has_EndTime();
    return _EndTime;
}

inline void T_WSAlertMsg::setEndTime (const ::fi_types::T_POSIXTime& EndTime_) {
    set_has_EndTime();
    this->_EndTime = EndTime_;
}

inline void T_WSAlertMsg::clearLanguage() {
    if (hasLanguage()) {
         clear_has_Language();
        _Language = ::sxm_wsalerts_main_fi_types::T_e8_Language__ENGLISH;
     }
}

inline bool T_WSAlertMsg::hasLanguage () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_Language T_WSAlertMsg::getLanguage () const {
    return _Language;
}

inline void T_WSAlertMsg::setLanguage (T_e8_Language Language_) {
    #ifndef NDEBUG
    if (!(T_e8_Language_IsValid(Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e8_Language", "Language", "T_WSAlertMsg");
    }
    #endif
    set_has_Language();
    this->_Language = Language_;
}

inline void T_WSAlertMsg::clearPriority() {
    if (hasPriority()) {
         clear_has_Priority();
        _Priority = 0u;
     }
}

inline bool T_WSAlertMsg::hasPriority () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_WSAlertMsg::getPriority () const {
    return _Priority;
}

inline void T_WSAlertMsg::setPriority (uint16 Priority_) {
    set_has_Priority();
    this->_Priority = Priority_;
}

inline void T_WSAlertMsg::clearBIsMarineZone() {
    if (hasBIsMarineZone()) {
         clear_has_bIsMarineZone();
        _bIsMarineZone = false;
     }
}

inline bool T_WSAlertMsg::hasBIsMarineZone () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_WSAlertMsg::getBIsMarineZone () const {
    return _bIsMarineZone;
}

inline void T_WSAlertMsg::setBIsMarineZone (bool bIsMarineZone_) {
    set_has_bIsMarineZone();
    this->_bIsMarineZone = bIsMarineZone_;
}

inline void T_WSAlertMsg::clearAlertTypes() {
    if (hasAlertTypes()) {
         clear_has_AlertTypes();
        _AlertTypes.clear();
     }
}

inline bool T_WSAlertMsg::hasAlertTypes () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< T_WSAlertInfo >& T_WSAlertMsg::getAlertTypes () const {
    return _AlertTypes;
}

inline ::std::vector< T_WSAlertInfo >& T_WSAlertMsg::getAlertTypesMutable () {
    set_has_AlertTypes();
    return _AlertTypes;
}

inline void T_WSAlertMsg::setAlertTypes (const ::std::vector< T_WSAlertInfo >& AlertTypes_) {
    set_has_AlertTypes();
    this->_AlertTypes = AlertTypes_;
}

inline void T_WSAlertMsg::clearAlertLocations() {
    if (hasAlertLocations()) {
         clear_has_AlertLocations();
        _AlertLocations.clear();
     }
}

inline bool T_WSAlertMsg::hasAlertLocations () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::vector< T_WSAlertLocation >& T_WSAlertMsg::getAlertLocations () const {
    return _AlertLocations;
}

inline ::std::vector< T_WSAlertLocation >& T_WSAlertMsg::getAlertLocationsMutable () {
    set_has_AlertLocations();
    return _AlertLocations;
}

inline void T_WSAlertMsg::setAlertLocations (const ::std::vector< T_WSAlertLocation >& AlertLocations_) {
    set_has_AlertLocations();
    this->_AlertLocations = AlertLocations_;
}

inline void T_WSAlertMsg::clearDistance() {
    if (hasDistance()) {
         clear_has_Distance();
        _Distance = 0.0f;
     }
}

inline bool T_WSAlertMsg::hasDistance () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline float T_WSAlertMsg::getDistance () const {
    return _Distance;
}

inline void T_WSAlertMsg::setDistance (float Distance_) {
    set_has_Distance();
    this->_Distance = Distance_;
}

inline void T_WSAlertMsg::set_has_MessageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WSAlertMsg::clear_has_MessageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WSAlertMsg::set_has_Text () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WSAlertMsg::clear_has_Text () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_WSAlertMsg::set_has_StartTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_WSAlertMsg::clear_has_StartTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_WSAlertMsg::set_has_EndTime () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_WSAlertMsg::clear_has_EndTime () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_WSAlertMsg::set_has_Language () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_WSAlertMsg::clear_has_Language () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_WSAlertMsg::set_has_Priority () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_WSAlertMsg::clear_has_Priority () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_WSAlertMsg::set_has_bIsMarineZone () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_WSAlertMsg::clear_has_bIsMarineZone () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_WSAlertMsg::set_has_AlertTypes () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_WSAlertMsg::clear_has_AlertTypes () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_WSAlertMsg::set_has_AlertLocations () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_WSAlertMsg::clear_has_AlertLocations () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_WSAlertMsg::set_has_Distance () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_WSAlertMsg::clear_has_Distance () {
    _has_bits_[0] &= ~ (1u << 9);
}

} // namespace sxm_wsalerts_main_fi_types

#endif // SXM_WSALERTS_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
