/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "fi_types.h"
#include "fi_typesConst.h"
#include "fi_typesJson.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_Reserved"

void serializeJson (const ::fi_types::T_Reserved& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_Reserved& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_POSIXTime"

void serializeJson (const ::fi_types::T_POSIXTime& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTime()) {
        yajl_gen_string(g, (const unsigned char*)  "Time" , 4);
        yajl_gen_integer(g, (long long)value.getTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_POSIXTime& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TimeZoneElement"

void serializeJson (const ::fi_types::T_TimeZoneElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAbbreviation_StandardTime()) {
        yajl_gen_string(g, (const unsigned char*)  "Abbreviation_StandardTime" , 25);
        const char *s = value.getAbbreviation_StandardTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAbbreviation_DST_in_effect()) {
        yajl_gen_string(g, (const unsigned char*)  "Abbreviation_DST_in_effect" , 26);
        const char *s = value.getAbbreviation_DST_in_effect().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTimeZoneDifference()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeZoneDifference" , 18);
        yajl_gen_integer(g, (long long)value.getTimeZoneDifference());
    }
    if (!isSparse || value.hasDST_State()) {
        yajl_gen_string(g, (const unsigned char*)  "DST_State" , 9);
        const char* s = ::fi_types::T_e8_DST_State_Name(value.getDST_State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDST_State());
    }
    if (!isSparse || value.hasDSTDifference()) {
        yajl_gen_string(g, (const unsigned char*)  "DSTDifference" , 13);
        yajl_gen_integer(g, (long long)value.getDSTDifference());
    }
    if (!isSparse || value.hasDST_TimeDomain()) {
        yajl_gen_string(g, (const unsigned char*)  "DST_TimeDomain" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getDST_TimeDomain();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_TimeZoneElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_FIVersion"

void serializeJson (const ::fi_types::T_FIVersion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMajorVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "MajorVersion" , 12);
        yajl_gen_integer(g, (long long)value.getMajorVersion());
    }
    if (!isSparse || value.hasMinorVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "MinorVersion" , 12);
        yajl_gen_integer(g, (long long)value.getMinorVersion());
    }
    if (!isSparse || value.hasPatchVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "PatchVersion" , 12);
        yajl_gen_integer(g, (long long)value.getPatchVersion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_FIVersion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PositionWGS84"

void serializeJson (const ::fi_types::T_PositionWGS84& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "Longitude" , 9);
        yajl_gen_integer(g, (long long)value.getLongitude());
    }
    if (!isSparse || value.hasLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "Latitude" , 8);
        yajl_gen_integer(g, (long long)value.getLatitude());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_PositionWGS84& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RectangleWGS84"

void serializeJson (const ::fi_types::T_RectangleWGS84& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLongitudeMin()) {
        yajl_gen_string(g, (const unsigned char*)  "LongitudeMin" , 12);
        yajl_gen_integer(g, (long long)value.getLongitudeMin());
    }
    if (!isSparse || value.hasLatitudeMin()) {
        yajl_gen_string(g, (const unsigned char*)  "LatitudeMin" , 11);
        yajl_gen_integer(g, (long long)value.getLatitudeMin());
    }
    if (!isSparse || value.hasLongitudeMax()) {
        yajl_gen_string(g, (const unsigned char*)  "LongitudeMax" , 12);
        yajl_gen_integer(g, (long long)value.getLongitudeMax());
    }
    if (!isSparse || value.hasLatitudeMax()) {
        yajl_gen_string(g, (const unsigned char*)  "LatitudeMax" , 11);
        yajl_gen_integer(g, (long long)value.getLatitudeMax());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_RectangleWGS84& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_LanguageID"

void serializeJson (const ::fi_types::T_LanguageID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasISO639_LanguageCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO639_LanguageCode" , 19);
        const char* s = ::fi_types::T_e16_ISOLanguageCode_Name(value.getISO639_LanguageCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getISO639_LanguageCode());
    }
    if (!isSparse || value.hasISO3166_CountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ISO3166_CountryCode" , 19);
        const char* s = ::fi_types::T_e16_ISOCountryCode_Name(value.getISO3166_CountryCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getISO3166_CountryCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_LanguageID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DistTimeFuel"

void serializeJson (const ::fi_types::T_DistTimeFuel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "Distance" , 8);
        yajl_gen_integer(g, (long long)value.getDistance());
    }
    if (!isSparse || value.hasTime()) {
        yajl_gen_string(g, (const unsigned char*)  "Time" , 4);
        yajl_gen_integer(g, (long long)value.getTime());
    }
    if (!isSparse || value.hasFuel()) {
        yajl_gen_string(g, (const unsigned char*)  "Fuel" , 4);
        yajl_gen_integer(g, (long long)value.getFuel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::fi_types::T_DistTimeFuel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_Reserved& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_POSIXTime& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_TimeZoneElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_FIVersion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_PositionWGS84& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_RectangleWGS84& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_LanguageID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types
using namespace ::asf::stream::json;

namespace fi_types {

std::ostream& operator<<(std::ostream& o, const ::fi_types::T_DistTimeFuel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace fi_types

