/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "sxm_tabweather_main_fi_types.h"
#include "sxm_tabweather_main_fi_typesConst.h"
#include "sxm_tabweather_main_fi_typesJson.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "T_WeatherInfo"

void serializeJson (const ::sxm_tabweather_main_fi_types::T_WeatherInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWeatherForecastType()) {
        yajl_gen_string(g, (const unsigned char*)  "WeatherForecastType" , 19);
        const char* s = ::sxm_tabweather_main_fi_types::T_e8_ForecastType_Name(value.getWeatherForecastType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWeatherForecastType());
    }
    if (!isSparse || value.hasEventCode()) {
        yajl_gen_string(g, (const unsigned char*)  "EventCode" , 9);
        yajl_gen_integer(g, (long long)value.getEventCode());
    }
    if (!isSparse || value.hasEventDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "EventDescription" , 16);
        const char *s = value.getEventDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTabWeather_LOCID()) {
        yajl_gen_string(g, (const unsigned char*)  "TabWeather_LOCID" , 16);
        yajl_gen_integer(g, (long long)value.getTabWeather_LOCID());
    }
    if (!isSparse || value.hasWeatherStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "WeatherStationName" , 18);
        const char *s = value.getWeatherStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasWeatherStateName()) {
        yajl_gen_string(g, (const unsigned char*)  "WeatherStateName" , 16);
        const char *s = value.getWeatherStateName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCurrentTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentTemperature" , 18);
        yajl_gen_integer(g, (long long)value.getCurrentTemperature());
    }
    if (!isSparse || value.hasTemperatureHigh()) {
        yajl_gen_string(g, (const unsigned char*)  "TemperatureHigh" , 15);
        yajl_gen_integer(g, (long long)value.getTemperatureHigh());
    }
    if (!isSparse || value.hasTemperatureLow()) {
        yajl_gen_string(g, (const unsigned char*)  "TemperatureLow" , 14);
        yajl_gen_integer(g, (long long)value.getTemperatureLow());
    }
    if (!isSparse || value.hasPrecipitationChance()) {
        yajl_gen_string(g, (const unsigned char*)  "PrecipitationChance" , 19);
        yajl_gen_integer(g, (long long)value.getPrecipitationChance());
    }
    if (!isSparse || value.hasPrecipitationAmountRangeLow()) {
        yajl_gen_string(g, (const unsigned char*)  "PrecipitationAmountRangeLow" , 27);
        yajl_gen_double(g, (double)value.getPrecipitationAmountRangeLow());
    }
    if (!isSparse || value.hasPrecipitationAmountRangeHigh()) {
        yajl_gen_string(g, (const unsigned char*)  "PrecipitationAmountRangeHigh" , 28);
        yajl_gen_double(g, (double)value.getPrecipitationAmountRangeHigh());
    }
    if (!isSparse || value.hasWindSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "WindSpeed" , 9);
        yajl_gen_integer(g, (long long)value.getWindSpeed());
    }
    if (!isSparse || value.hasWindDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "WindDirection" , 13);
        yajl_gen_integer(g, (long long)value.getWindDirection());
    }
    if (!isSparse || value.hasHumidityRangeLow()) {
        yajl_gen_string(g, (const unsigned char*)  "HumidityRangeLow" , 16);
        yajl_gen_integer(g, (long long)value.getHumidityRangeLow());
    }
    if (!isSparse || value.hasHumidityRangeHigh()) {
        yajl_gen_string(g, (const unsigned char*)  "HumidityRangeHigh" , 17);
        yajl_gen_integer(g, (long long)value.getHumidityRangeHigh());
    }
    if (!isSparse || value.hasUV_InfoRangeLow()) {
        yajl_gen_string(g, (const unsigned char*)  "UV_InfoRangeLow" , 15);
        yajl_gen_integer(g, (long long)value.getUV_InfoRangeLow());
    }
    if (!isSparse || value.hasUV_InfoRangeHigh()) {
        yajl_gen_string(g, (const unsigned char*)  "UV_InfoRangeHigh" , 16);
        yajl_gen_integer(g, (long long)value.getUV_InfoRangeHigh());
    }
    if (!isSparse || value.hasPollenLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "PollenLevel" , 11);
        const char* s = ::sxm_tabweather_main_fi_types::T_e8_PollenLevelType_Name(value.getPollenLevel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPollenLevel());
    }
    if (!isSparse || value.hasAirQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "AirQuality" , 10);
        const char* s = ::sxm_tabweather_main_fi_types::T_e8_AirQualityType_Name(value.getAirQuality());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAirQuality());
    }
    if (!isSparse || value.hasCloudCover()) {
        yajl_gen_string(g, (const unsigned char*)  "CloudCover" , 10);
        const char* s = ::sxm_tabweather_main_fi_types::T_e8_CloudCoverType_Name(value.getCloudCover());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCloudCover());
    }
    if (!isSparse || value.hasForecastTimeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "ForecastTimeStamp" , 17);
        yajl_gen_integer(g, (long long)value.getForecastTimeStamp());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_tabweather_main_fi_types::T_WeatherInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sxm_tabweather_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_tabweather_main_fi_types::T_WeatherInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_tabweather_main_fi_types

