#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_TABWEATHER_MAIN_FI_TYPES_H
#define SXM_TABWEATHER_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_tabweather_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_tabweather_main_fi_types
 */

namespace sxm_tabweather_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_WeatherInfo;

// type definitions
/**
 * If the meaning of "T_WeatherInfoList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_WeatherInfo > T_WeatherInfoList;


/**
 * Weather Information with parameters for display
 */
class T_WeatherInfo {
public:

    /**
     * Default constructor
     */
    inline  T_WeatherInfo ();

    /**
     * Copy constructor
     */
    inline  T_WeatherInfo (const T_WeatherInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_WeatherInfo (T_e8_ForecastType WeatherForecastType_, uint8 EventCode_, const ::std::string& EventDescription_, uint32 TabWeather_LOCID_, const ::std::string& WeatherStationName_, const ::std::string& WeatherStateName_, int16 CurrentTemperature_, int16 TemperatureHigh_, int16 TemperatureLow_, uint8 PrecipitationChance_, float PrecipitationAmountRangeLow_, float PrecipitationAmountRangeHigh_, uint8 WindSpeed_, uint16 WindDirection_, uint8 HumidityRangeLow_, uint8 HumidityRangeHigh_, uint8 UV_InfoRangeLow_, uint8 UV_InfoRangeHigh_, T_e8_PollenLevelType PollenLevel_, T_e8_AirQualityType AirQuality_, T_e8_CloudCoverType CloudCover_, uint32 ForecastTimeStamp_);

    /**
     * Destructor
     */
    inline  ~T_WeatherInfo();

    /**
     * Assignment operator
     */
    inline T_WeatherInfo& operator = (const T_WeatherInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WeatherInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WeatherInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WeatherInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WeatherInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WeatherForecastType"

    static const int kWeatherForecastType = 0;

    /**
     * Clears the field "WeatherForecastType".
     *
     * The field will be set to its default value. The hasWeatherForecastType()
     * method will return false.
     */
    inline void clearWeatherForecastType();

    /**
     * Checks whether the field "WeatherForecastType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWeatherForecastType()). Otherwise it will return false.
     */
    inline bool hasWeatherForecastType () const;

    /**
     * Returns the value of the member "WeatherForecastType".
     *
     * Weather Forecast type
     *
     * @return The value of the field "WeatherForecastType"
     */
    inline T_e8_ForecastType getWeatherForecastType () const;

    /**
     * Sets the value of the member "WeatherForecastType".
     *
     * Weather Forecast type
     *
     * @param WeatherForecastType The value which will be set
     */
    inline void setWeatherForecastType (T_e8_ForecastType WeatherForecastType_);

    // API of field "EventCode"

    static const int kEventCode = 1;

    /**
     * Clears the field "EventCode".
     *
     * The field will be set to its default value. The hasEventCode()
     * method will return false.
     */
    inline void clearEventCode();

    /**
     * Checks whether the field "EventCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventCode()). Otherwise it will return false.
     */
    inline bool hasEventCode () const;

    /**
     * Returns the value of the member "EventCode".
     *
     * Weather Event code
     *
     * @return The value of the field "EventCode"
     */
    inline uint8 getEventCode () const;

    /**
     * Sets the value of the member "EventCode".
     *
     * Weather Event code
     *
     * @param EventCode The value which will be set
     */
    inline void setEventCode (uint8 EventCode_);

    // API of field "EventDescription"

    static const int kEventDescription = 2;

    /**
     * Clears the field "EventDescription".
     *
     * The field will be set to its default value. The hasEventDescription()
     * method will return false.
     */
    inline void clearEventDescription();

    /**
     * Checks whether the field "EventDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventDescription()). Otherwise it will return false.
     */
    inline bool hasEventDescription () const;

    /**
     * Returns the value of the member "EventDescription".
     *
     * SMS provided description for the Weather Event
     *
     * @return The value of the field "EventDescription"
     */
    inline const ::std::string& getEventDescription () const;

    /**
     * Retrieves the value of the field "EventDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EventDescription".
     */
    inline ::std::string& getEventDescriptionMutable ();

    /**
     * Sets the value of the member "EventDescription".
     *
     * SMS provided description for the Weather Event
     *
     * @param EventDescription The value which will be set
     */
    inline void setEventDescription (const ::std::string& EventDescription_);

    /**
     * Sets the value of the member "EventDescription".
     *
     * SMS provided description for the Weather Event
     *
     * @param EventDescription The value which will be set
     */
    inline void setEventDescription (const char* EventDescription_);

    /**
     * Sets the value of the member "EventDescription".
     *
     * SMS provided description for the Weather Event
     *
     * @param EventDescription The value which will be set
     */
    inline void setEventDescription (const char* value, size_t size);

    // API of field "TabWeather_LOCID"

    static const int kTabWeather_LOCID = 3;

    /**
     * Clears the field "TabWeather_LOCID".
     *
     * The field will be set to its default value. The hasTabWeather_LOCID()
     * method will return false.
     */
    inline void clearTabWeather_LOCID();

    /**
     * Checks whether the field "TabWeather_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTabWeather_LOCID()). Otherwise it will return false.
     */
    inline bool hasTabWeather_LOCID () const;

    /**
     * Returns the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @return The value of the field "TabWeather_LOCID"
     */
    inline uint32 getTabWeather_LOCID () const;

    /**
     * Sets the value of the member "TabWeather_LOCID".
     *
     * Weather Station Location ID
     *
     * @param TabWeather_LOCID The value which will be set
     */
    inline void setTabWeather_LOCID (uint32 TabWeather_LOCID_);

    // API of field "WeatherStationName"

    static const int kWeatherStationName = 4;

    /**
     * Clears the field "WeatherStationName".
     *
     * The field will be set to its default value. The hasWeatherStationName()
     * method will return false.
     */
    inline void clearWeatherStationName();

    /**
     * Checks whether the field "WeatherStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWeatherStationName()). Otherwise it will return false.
     */
    inline bool hasWeatherStationName () const;

    /**
     * Returns the value of the member "WeatherStationName".
     *
     * Weather Station description
     *
     * @return The value of the field "WeatherStationName"
     */
    inline const ::std::string& getWeatherStationName () const;

    /**
     * Retrieves the value of the field "WeatherStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WeatherStationName".
     */
    inline ::std::string& getWeatherStationNameMutable ();

    /**
     * Sets the value of the member "WeatherStationName".
     *
     * Weather Station description
     *
     * @param WeatherStationName The value which will be set
     */
    inline void setWeatherStationName (const ::std::string& WeatherStationName_);

    /**
     * Sets the value of the member "WeatherStationName".
     *
     * Weather Station description
     *
     * @param WeatherStationName The value which will be set
     */
    inline void setWeatherStationName (const char* WeatherStationName_);

    /**
     * Sets the value of the member "WeatherStationName".
     *
     * Weather Station description
     *
     * @param WeatherStationName The value which will be set
     */
    inline void setWeatherStationName (const char* value, size_t size);

    // API of field "WeatherStateName"

    static const int kWeatherStateName = 5;

    /**
     * Clears the field "WeatherStateName".
     *
     * The field will be set to its default value. The hasWeatherStateName()
     * method will return false.
     */
    inline void clearWeatherStateName();

    /**
     * Checks whether the field "WeatherStateName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWeatherStateName()). Otherwise it will return false.
     */
    inline bool hasWeatherStateName () const;

    /**
     * Returns the value of the member "WeatherStateName".
     *
     * Weather State Name
     *
     * @return The value of the field "WeatherStateName"
     */
    inline const ::std::string& getWeatherStateName () const;

    /**
     * Retrieves the value of the field "WeatherStateName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WeatherStateName".
     */
    inline ::std::string& getWeatherStateNameMutable ();

    /**
     * Sets the value of the member "WeatherStateName".
     *
     * Weather State Name
     *
     * @param WeatherStateName The value which will be set
     */
    inline void setWeatherStateName (const ::std::string& WeatherStateName_);

    /**
     * Sets the value of the member "WeatherStateName".
     *
     * Weather State Name
     *
     * @param WeatherStateName The value which will be set
     */
    inline void setWeatherStateName (const char* WeatherStateName_);

    /**
     * Sets the value of the member "WeatherStateName".
     *
     * Weather State Name
     *
     * @param WeatherStateName The value which will be set
     */
    inline void setWeatherStateName (const char* value, size_t size);

    // API of field "CurrentTemperature"

    static const int kCurrentTemperature = 6;

    /**
     * Clears the field "CurrentTemperature".
     *
     * The field will be set to its default value. The hasCurrentTemperature()
     * method will return false.
     */
    inline void clearCurrentTemperature();

    /**
     * Checks whether the field "CurrentTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentTemperature()). Otherwise it will return false.
     */
    inline bool hasCurrentTemperature () const;

    /**
     * Returns the value of the member "CurrentTemperature".
     *
     * Current Temperature
     *
     * @return The value of the field "CurrentTemperature"
     */
    inline int16 getCurrentTemperature () const;

    /**
     * Sets the value of the member "CurrentTemperature".
     *
     * Current Temperature
     *
     * @param CurrentTemperature The value which will be set
     */
    inline void setCurrentTemperature (int16 CurrentTemperature_);

    // API of field "TemperatureHigh"

    static const int kTemperatureHigh = 7;

    /**
     * Clears the field "TemperatureHigh".
     *
     * The field will be set to its default value. The hasTemperatureHigh()
     * method will return false.
     */
    inline void clearTemperatureHigh();

    /**
     * Checks whether the field "TemperatureHigh" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperatureHigh()). Otherwise it will return false.
     */
    inline bool hasTemperatureHigh () const;

    /**
     * Returns the value of the member "TemperatureHigh".
     *
     * Temperature high
     *
     * @return The value of the field "TemperatureHigh"
     */
    inline int16 getTemperatureHigh () const;

    /**
     * Sets the value of the member "TemperatureHigh".
     *
     * Temperature high
     *
     * @param TemperatureHigh The value which will be set
     */
    inline void setTemperatureHigh (int16 TemperatureHigh_);

    // API of field "TemperatureLow"

    static const int kTemperatureLow = 8;

    /**
     * Clears the field "TemperatureLow".
     *
     * The field will be set to its default value. The hasTemperatureLow()
     * method will return false.
     */
    inline void clearTemperatureLow();

    /**
     * Checks whether the field "TemperatureLow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperatureLow()). Otherwise it will return false.
     */
    inline bool hasTemperatureLow () const;

    /**
     * Returns the value of the member "TemperatureLow".
     *
     * Temperature low
     *
     * @return The value of the field "TemperatureLow"
     */
    inline int16 getTemperatureLow () const;

    /**
     * Sets the value of the member "TemperatureLow".
     *
     * Temperature low
     *
     * @param TemperatureLow The value which will be set
     */
    inline void setTemperatureLow (int16 TemperatureLow_);

    // API of field "PrecipitationChance"

    static const int kPrecipitationChance = 9;

    /**
     * Clears the field "PrecipitationChance".
     *
     * The field will be set to its default value. The hasPrecipitationChance()
     * method will return false.
     */
    inline void clearPrecipitationChance();

    /**
     * Checks whether the field "PrecipitationChance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrecipitationChance()). Otherwise it will return false.
     */
    inline bool hasPrecipitationChance () const;

    /**
     * Returns the value of the member "PrecipitationChance".
     *
     * Chance of Precipitation
     *
     * @return The value of the field "PrecipitationChance"
     */
    inline uint8 getPrecipitationChance () const;

    /**
     * Sets the value of the member "PrecipitationChance".
     *
     * Chance of Precipitation
     *
     * @param PrecipitationChance The value which will be set
     */
    inline void setPrecipitationChance (uint8 PrecipitationChance_);

    // API of field "PrecipitationAmountRangeLow"

    static const int kPrecipitationAmountRangeLow = 10;

    /**
     * Clears the field "PrecipitationAmountRangeLow".
     *
     * The field will be set to its default value. The hasPrecipitationAmountRangeLow()
     * method will return false.
     */
    inline void clearPrecipitationAmountRangeLow();

    /**
     * Checks whether the field "PrecipitationAmountRangeLow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrecipitationAmountRangeLow()). Otherwise it will return false.
     */
    inline bool hasPrecipitationAmountRangeLow () const;

    /**
     * Returns the value of the member "PrecipitationAmountRangeLow".
     *
     * Lower limit of Precipitation Amount
     *
     * @return The value of the field "PrecipitationAmountRangeLow"
     */
    inline float getPrecipitationAmountRangeLow () const;

    /**
     * Sets the value of the member "PrecipitationAmountRangeLow".
     *
     * Lower limit of Precipitation Amount
     *
     * @param PrecipitationAmountRangeLow The value which will be set
     */
    inline void setPrecipitationAmountRangeLow (float PrecipitationAmountRangeLow_);

    // API of field "PrecipitationAmountRangeHigh"

    static const int kPrecipitationAmountRangeHigh = 11;

    /**
     * Clears the field "PrecipitationAmountRangeHigh".
     *
     * The field will be set to its default value. The hasPrecipitationAmountRangeHigh()
     * method will return false.
     */
    inline void clearPrecipitationAmountRangeHigh();

    /**
     * Checks whether the field "PrecipitationAmountRangeHigh" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrecipitationAmountRangeHigh()). Otherwise it will return false.
     */
    inline bool hasPrecipitationAmountRangeHigh () const;

    /**
     * Returns the value of the member "PrecipitationAmountRangeHigh".
     *
     * Higher limit of Precipitation Amount
     *
     * @return The value of the field "PrecipitationAmountRangeHigh"
     */
    inline float getPrecipitationAmountRangeHigh () const;

    /**
     * Sets the value of the member "PrecipitationAmountRangeHigh".
     *
     * Higher limit of Precipitation Amount
     *
     * @param PrecipitationAmountRangeHigh The value which will be set
     */
    inline void setPrecipitationAmountRangeHigh (float PrecipitationAmountRangeHigh_);

    // API of field "WindSpeed"

    static const int kWindSpeed = 12;

    /**
     * Clears the field "WindSpeed".
     *
     * The field will be set to its default value. The hasWindSpeed()
     * method will return false.
     */
    inline void clearWindSpeed();

    /**
     * Checks whether the field "WindSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindSpeed()). Otherwise it will return false.
     */
    inline bool hasWindSpeed () const;

    /**
     * Returns the value of the member "WindSpeed".
     *
     * Speed of the Wind
     *
     * @return The value of the field "WindSpeed"
     */
    inline uint8 getWindSpeed () const;

    /**
     * Sets the value of the member "WindSpeed".
     *
     * Speed of the Wind
     *
     * @param WindSpeed The value which will be set
     */
    inline void setWindSpeed (uint8 WindSpeed_);

    // API of field "WindDirection"

    static const int kWindDirection = 13;

    /**
     * Clears the field "WindDirection".
     *
     * The field will be set to its default value. The hasWindDirection()
     * method will return false.
     */
    inline void clearWindDirection();

    /**
     * Checks whether the field "WindDirection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindDirection()). Otherwise it will return false.
     */
    inline bool hasWindDirection () const;

    /**
     * Returns the value of the member "WindDirection".
     *
     * Direction of the Wind
     *
     * @return The value of the field "WindDirection"
     */
    inline uint16 getWindDirection () const;

    /**
     * Sets the value of the member "WindDirection".
     *
     * Direction of the Wind
     *
     * @param WindDirection The value which will be set
     */
    inline void setWindDirection (uint16 WindDirection_);

    // API of field "HumidityRangeLow"

    static const int kHumidityRangeLow = 14;

    /**
     * Clears the field "HumidityRangeLow".
     *
     * The field will be set to its default value. The hasHumidityRangeLow()
     * method will return false.
     */
    inline void clearHumidityRangeLow();

    /**
     * Checks whether the field "HumidityRangeLow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHumidityRangeLow()). Otherwise it will return false.
     */
    inline bool hasHumidityRangeLow () const;

    /**
     * Returns the value of the member "HumidityRangeLow".
     *
     * Lower limit of Humidity Value
     *
     * @return The value of the field "HumidityRangeLow"
     */
    inline uint8 getHumidityRangeLow () const;

    /**
     * Sets the value of the member "HumidityRangeLow".
     *
     * Lower limit of Humidity Value
     *
     * @param HumidityRangeLow The value which will be set
     */
    inline void setHumidityRangeLow (uint8 HumidityRangeLow_);

    // API of field "HumidityRangeHigh"

    static const int kHumidityRangeHigh = 15;

    /**
     * Clears the field "HumidityRangeHigh".
     *
     * The field will be set to its default value. The hasHumidityRangeHigh()
     * method will return false.
     */
    inline void clearHumidityRangeHigh();

    /**
     * Checks whether the field "HumidityRangeHigh" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHumidityRangeHigh()). Otherwise it will return false.
     */
    inline bool hasHumidityRangeHigh () const;

    /**
     * Returns the value of the member "HumidityRangeHigh".
     *
     * Higher limit of Humidity Value
     *
     * @return The value of the field "HumidityRangeHigh"
     */
    inline uint8 getHumidityRangeHigh () const;

    /**
     * Sets the value of the member "HumidityRangeHigh".
     *
     * Higher limit of Humidity Value
     *
     * @param HumidityRangeHigh The value which will be set
     */
    inline void setHumidityRangeHigh (uint8 HumidityRangeHigh_);

    // API of field "UV_InfoRangeLow"

    static const int kUV_InfoRangeLow = 16;

    /**
     * Clears the field "UV_InfoRangeLow".
     *
     * The field will be set to its default value. The hasUV_InfoRangeLow()
     * method will return false.
     */
    inline void clearUV_InfoRangeLow();

    /**
     * Checks whether the field "UV_InfoRangeLow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUV_InfoRangeLow()). Otherwise it will return false.
     */
    inline bool hasUV_InfoRangeLow () const;

    /**
     * Returns the value of the member "UV_InfoRangeLow".
     *
     * Lower limit of UV index range
     *
     * @return The value of the field "UV_InfoRangeLow"
     */
    inline uint8 getUV_InfoRangeLow () const;

    /**
     * Sets the value of the member "UV_InfoRangeLow".
     *
     * Lower limit of UV index range
     *
     * @param UV_InfoRangeLow The value which will be set
     */
    inline void setUV_InfoRangeLow (uint8 UV_InfoRangeLow_);

    // API of field "UV_InfoRangeHigh"

    static const int kUV_InfoRangeHigh = 17;

    /**
     * Clears the field "UV_InfoRangeHigh".
     *
     * The field will be set to its default value. The hasUV_InfoRangeHigh()
     * method will return false.
     */
    inline void clearUV_InfoRangeHigh();

    /**
     * Checks whether the field "UV_InfoRangeHigh" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUV_InfoRangeHigh()). Otherwise it will return false.
     */
    inline bool hasUV_InfoRangeHigh () const;

    /**
     * Returns the value of the member "UV_InfoRangeHigh".
     *
     * Higher limit of UV index range
     *
     * @return The value of the field "UV_InfoRangeHigh"
     */
    inline uint8 getUV_InfoRangeHigh () const;

    /**
     * Sets the value of the member "UV_InfoRangeHigh".
     *
     * Higher limit of UV index range
     *
     * @param UV_InfoRangeHigh The value which will be set
     */
    inline void setUV_InfoRangeHigh (uint8 UV_InfoRangeHigh_);

    // API of field "PollenLevel"

    static const int kPollenLevel = 18;

    /**
     * Clears the field "PollenLevel".
     *
     * The field will be set to its default value. The hasPollenLevel()
     * method will return false.
     */
    inline void clearPollenLevel();

    /**
     * Checks whether the field "PollenLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPollenLevel()). Otherwise it will return false.
     */
    inline bool hasPollenLevel () const;

    /**
     * Returns the value of the member "PollenLevel".
     *
     * Pollen level in Air
     *
     * @return The value of the field "PollenLevel"
     */
    inline T_e8_PollenLevelType getPollenLevel () const;

    /**
     * Sets the value of the member "PollenLevel".
     *
     * Pollen level in Air
     *
     * @param PollenLevel The value which will be set
     */
    inline void setPollenLevel (T_e8_PollenLevelType PollenLevel_);

    // API of field "AirQuality"

    static const int kAirQuality = 19;

    /**
     * Clears the field "AirQuality".
     *
     * The field will be set to its default value. The hasAirQuality()
     * method will return false.
     */
    inline void clearAirQuality();

    /**
     * Checks whether the field "AirQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAirQuality()). Otherwise it will return false.
     */
    inline bool hasAirQuality () const;

    /**
     * Returns the value of the member "AirQuality".
     *
     * Quality of Air
     *
     * @return The value of the field "AirQuality"
     */
    inline T_e8_AirQualityType getAirQuality () const;

    /**
     * Sets the value of the member "AirQuality".
     *
     * Quality of Air
     *
     * @param AirQuality The value which will be set
     */
    inline void setAirQuality (T_e8_AirQualityType AirQuality_);

    // API of field "CloudCover"

    static const int kCloudCover = 20;

    /**
     * Clears the field "CloudCover".
     *
     * The field will be set to its default value. The hasCloudCover()
     * method will return false.
     */
    inline void clearCloudCover();

    /**
     * Checks whether the field "CloudCover" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCloudCover()). Otherwise it will return false.
     */
    inline bool hasCloudCover () const;

    /**
     * Returns the value of the member "CloudCover".
     *
     * Cloud cover for the reported weather location
     *
     * @return The value of the field "CloudCover"
     */
    inline T_e8_CloudCoverType getCloudCover () const;

    /**
     * Sets the value of the member "CloudCover".
     *
     * Cloud cover for the reported weather location
     *
     * @param CloudCover The value which will be set
     */
    inline void setCloudCover (T_e8_CloudCoverType CloudCover_);

    // API of field "ForecastTimeStamp"

    static const int kForecastTimeStamp = 21;

    /**
     * Clears the field "ForecastTimeStamp".
     *
     * The field will be set to its default value. The hasForecastTimeStamp()
     * method will return false.
     */
    inline void clearForecastTimeStamp();

    /**
     * Checks whether the field "ForecastTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForecastTimeStamp()). Otherwise it will return false.
     */
    inline bool hasForecastTimeStamp () const;

    /**
     * Returns the value of the member "ForecastTimeStamp".
     *
     * The time during which the Weather conditions were reported
     *
     * @return The value of the field "ForecastTimeStamp"
     */
    inline uint32 getForecastTimeStamp () const;

    /**
     * Sets the value of the member "ForecastTimeStamp".
     *
     * The time during which the Weather conditions were reported
     *
     * @param ForecastTimeStamp The value which will be set
     */
    inline void setForecastTimeStamp (uint32 ForecastTimeStamp_);

    static const T_WeatherInfo &getDefaultInstance();

private:

    inline void set_has_WeatherForecastType ();

    inline void clear_has_WeatherForecastType ();

    inline void set_has_EventCode ();

    inline void clear_has_EventCode ();

    inline void set_has_EventDescription ();

    inline void clear_has_EventDescription ();

    inline void set_has_TabWeather_LOCID ();

    inline void clear_has_TabWeather_LOCID ();

    inline void set_has_WeatherStationName ();

    inline void clear_has_WeatherStationName ();

    inline void set_has_WeatherStateName ();

    inline void clear_has_WeatherStateName ();

    inline void set_has_CurrentTemperature ();

    inline void clear_has_CurrentTemperature ();

    inline void set_has_TemperatureHigh ();

    inline void clear_has_TemperatureHigh ();

    inline void set_has_TemperatureLow ();

    inline void clear_has_TemperatureLow ();

    inline void set_has_PrecipitationChance ();

    inline void clear_has_PrecipitationChance ();

    inline void set_has_PrecipitationAmountRangeLow ();

    inline void clear_has_PrecipitationAmountRangeLow ();

    inline void set_has_PrecipitationAmountRangeHigh ();

    inline void clear_has_PrecipitationAmountRangeHigh ();

    inline void set_has_WindSpeed ();

    inline void clear_has_WindSpeed ();

    inline void set_has_WindDirection ();

    inline void clear_has_WindDirection ();

    inline void set_has_HumidityRangeLow ();

    inline void clear_has_HumidityRangeLow ();

    inline void set_has_HumidityRangeHigh ();

    inline void clear_has_HumidityRangeHigh ();

    inline void set_has_UV_InfoRangeLow ();

    inline void clear_has_UV_InfoRangeLow ();

    inline void set_has_UV_InfoRangeHigh ();

    inline void clear_has_UV_InfoRangeHigh ();

    inline void set_has_PollenLevel ();

    inline void clear_has_PollenLevel ();

    inline void set_has_AirQuality ();

    inline void clear_has_AirQuality ();

    inline void set_has_CloudCover ();

    inline void clear_has_CloudCover ();

    inline void set_has_ForecastTimeStamp ();

    inline void clear_has_ForecastTimeStamp ();

    uint32 _has_bits_[ (22 + 31) / 32];

    T_e8_ForecastType _WeatherForecastType;

    uint8 _EventCode;

    ::std::string _EventDescription;

    uint32 _TabWeather_LOCID;

    ::std::string _WeatherStationName;

    ::std::string _WeatherStateName;

    int16 _CurrentTemperature;

    int16 _TemperatureHigh;

    int16 _TemperatureLow;

    uint8 _PrecipitationChance;

    float _PrecipitationAmountRangeLow;

    float _PrecipitationAmountRangeHigh;

    uint8 _WindSpeed;

    uint16 _WindDirection;

    uint8 _HumidityRangeLow;

    uint8 _HumidityRangeHigh;

    uint8 _UV_InfoRangeLow;

    uint8 _UV_InfoRangeHigh;

    T_e8_PollenLevelType _PollenLevel;

    T_e8_AirQualityType _AirQuality;

    T_e8_CloudCoverType _CloudCover;

    uint32 _ForecastTimeStamp;

};

inline  T_WeatherInfo::T_WeatherInfo ()  :
    _WeatherForecastType (::sxm_tabweather_main_fi_types::T_e8_ForecastType__WEATHER_FORECAST_TYPE_CURRENT),
    _EventCode (0u),
    _EventDescription (),
    _TabWeather_LOCID (0u),
    _WeatherStationName (),
    _WeatherStateName (),
    _CurrentTemperature (0),
    _TemperatureHigh (0),
    _TemperatureLow (0),
    _PrecipitationChance (0u),
    _PrecipitationAmountRangeLow (0.0f),
    _PrecipitationAmountRangeHigh (0.0f),
    _WindSpeed (0u),
    _WindDirection (0u),
    _HumidityRangeLow (0u),
    _HumidityRangeHigh (0u),
    _UV_InfoRangeLow (0u),
    _UV_InfoRangeHigh (0u),
    _PollenLevel (::sxm_tabweather_main_fi_types::T_e8_PollenLevelType__WEATHER_AIR_POLLEN_LEVEL_LOW),
    _AirQuality (::sxm_tabweather_main_fi_types::T_e8_AirQualityType__WEATHER_AIR_QUALITY_GOOD),
    _CloudCover (::sxm_tabweather_main_fi_types::T_e8_CloudCoverType__WEATHER_FORECAST_CLOUD_COVER_CLEAR),
    _ForecastTimeStamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WeatherInfo::T_WeatherInfo (const T_WeatherInfo &rhs)  :
    _WeatherForecastType (::sxm_tabweather_main_fi_types::T_e8_ForecastType__WEATHER_FORECAST_TYPE_CURRENT),
    _EventCode (0u),
    _EventDescription (),
    _TabWeather_LOCID (0u),
    _WeatherStationName (),
    _WeatherStateName (),
    _CurrentTemperature (0),
    _TemperatureHigh (0),
    _TemperatureLow (0),
    _PrecipitationChance (0u),
    _PrecipitationAmountRangeLow (0.0f),
    _PrecipitationAmountRangeHigh (0.0f),
    _WindSpeed (0u),
    _WindDirection (0u),
    _HumidityRangeLow (0u),
    _HumidityRangeHigh (0u),
    _UV_InfoRangeLow (0u),
    _UV_InfoRangeHigh (0u),
    _PollenLevel (::sxm_tabweather_main_fi_types::T_e8_PollenLevelType__WEATHER_AIR_POLLEN_LEVEL_LOW),
    _AirQuality (::sxm_tabweather_main_fi_types::T_e8_AirQualityType__WEATHER_AIR_QUALITY_GOOD),
    _CloudCover (::sxm_tabweather_main_fi_types::T_e8_CloudCoverType__WEATHER_FORECAST_CLOUD_COVER_CLEAR),
    _ForecastTimeStamp (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WeatherInfo::T_WeatherInfo (T_e8_ForecastType WeatherForecastType_, uint8 EventCode_, const ::std::string& EventDescription_, uint32 TabWeather_LOCID_, const ::std::string& WeatherStationName_, const ::std::string& WeatherStateName_, int16 CurrentTemperature_, int16 TemperatureHigh_, int16 TemperatureLow_, uint8 PrecipitationChance_, float PrecipitationAmountRangeLow_, float PrecipitationAmountRangeHigh_, uint8 WindSpeed_, uint16 WindDirection_, uint8 HumidityRangeLow_, uint8 HumidityRangeHigh_, uint8 UV_InfoRangeLow_, uint8 UV_InfoRangeHigh_, T_e8_PollenLevelType PollenLevel_, T_e8_AirQualityType AirQuality_, T_e8_CloudCoverType CloudCover_, uint32 ForecastTimeStamp_)  :
    _WeatherForecastType (WeatherForecastType_),
    _EventCode (EventCode_),
    _EventDescription (EventDescription_),
    _TabWeather_LOCID (TabWeather_LOCID_),
    _WeatherStationName (WeatherStationName_),
    _WeatherStateName (WeatherStateName_),
    _CurrentTemperature (CurrentTemperature_),
    _TemperatureHigh (TemperatureHigh_),
    _TemperatureLow (TemperatureLow_),
    _PrecipitationChance (PrecipitationChance_),
    _PrecipitationAmountRangeLow (PrecipitationAmountRangeLow_),
    _PrecipitationAmountRangeHigh (PrecipitationAmountRangeHigh_),
    _WindSpeed (WindSpeed_),
    _WindDirection (WindDirection_),
    _HumidityRangeLow (HumidityRangeLow_),
    _HumidityRangeHigh (HumidityRangeHigh_),
    _UV_InfoRangeLow (UV_InfoRangeLow_),
    _UV_InfoRangeHigh (UV_InfoRangeHigh_),
    _PollenLevel (PollenLevel_),
    _AirQuality (AirQuality_),
    _CloudCover (CloudCover_),
    _ForecastTimeStamp (ForecastTimeStamp_)
{
    #ifndef NDEBUG
    if (!(T_e8_ForecastType_IsValid(WeatherForecastType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WeatherForecastType_, "T_e8_ForecastType", "WeatherForecastType", "T_WeatherInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EventDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_PollenLevelType_IsValid(PollenLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PollenLevel_, "T_e8_PollenLevelType", "PollenLevel", "T_WeatherInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AirQualityType_IsValid(AirQuality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AirQuality_, "T_e8_AirQualityType", "AirQuality", "T_WeatherInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_CloudCoverType_IsValid(CloudCover_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CloudCover_, "T_e8_CloudCoverType", "CloudCover", "T_WeatherInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WeatherInfo::~T_WeatherInfo() {
}

inline T_WeatherInfo& T_WeatherInfo::operator = (const T_WeatherInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasWeatherForecastType()) {
            setWeatherForecastType(rhs.getWeatherForecastType());
        } else {
            clearWeatherForecastType();
        }
        if (rhs.hasEventCode()) {
            setEventCode(rhs.getEventCode());
        } else {
            clearEventCode();
        }
        if (rhs.hasEventDescription()) {
            setEventDescription(rhs.getEventDescription());
        } else {
            clearEventDescription();
        }
        if (rhs.hasTabWeather_LOCID()) {
            setTabWeather_LOCID(rhs.getTabWeather_LOCID());
        } else {
            clearTabWeather_LOCID();
        }
        if (rhs.hasWeatherStationName()) {
            setWeatherStationName(rhs.getWeatherStationName());
        } else {
            clearWeatherStationName();
        }
        if (rhs.hasWeatherStateName()) {
            setWeatherStateName(rhs.getWeatherStateName());
        } else {
            clearWeatherStateName();
        }
        if (rhs.hasCurrentTemperature()) {
            setCurrentTemperature(rhs.getCurrentTemperature());
        } else {
            clearCurrentTemperature();
        }
        if (rhs.hasTemperatureHigh()) {
            setTemperatureHigh(rhs.getTemperatureHigh());
        } else {
            clearTemperatureHigh();
        }
        if (rhs.hasTemperatureLow()) {
            setTemperatureLow(rhs.getTemperatureLow());
        } else {
            clearTemperatureLow();
        }
        if (rhs.hasPrecipitationChance()) {
            setPrecipitationChance(rhs.getPrecipitationChance());
        } else {
            clearPrecipitationChance();
        }
        if (rhs.hasPrecipitationAmountRangeLow()) {
            setPrecipitationAmountRangeLow(rhs.getPrecipitationAmountRangeLow());
        } else {
            clearPrecipitationAmountRangeLow();
        }
        if (rhs.hasPrecipitationAmountRangeHigh()) {
            setPrecipitationAmountRangeHigh(rhs.getPrecipitationAmountRangeHigh());
        } else {
            clearPrecipitationAmountRangeHigh();
        }
        if (rhs.hasWindSpeed()) {
            setWindSpeed(rhs.getWindSpeed());
        } else {
            clearWindSpeed();
        }
        if (rhs.hasWindDirection()) {
            setWindDirection(rhs.getWindDirection());
        } else {
            clearWindDirection();
        }
        if (rhs.hasHumidityRangeLow()) {
            setHumidityRangeLow(rhs.getHumidityRangeLow());
        } else {
            clearHumidityRangeLow();
        }
        if (rhs.hasHumidityRangeHigh()) {
            setHumidityRangeHigh(rhs.getHumidityRangeHigh());
        } else {
            clearHumidityRangeHigh();
        }
        if (rhs.hasUV_InfoRangeLow()) {
            setUV_InfoRangeLow(rhs.getUV_InfoRangeLow());
        } else {
            clearUV_InfoRangeLow();
        }
        if (rhs.hasUV_InfoRangeHigh()) {
            setUV_InfoRangeHigh(rhs.getUV_InfoRangeHigh());
        } else {
            clearUV_InfoRangeHigh();
        }
        if (rhs.hasPollenLevel()) {
            setPollenLevel(rhs.getPollenLevel());
        } else {
            clearPollenLevel();
        }
        if (rhs.hasAirQuality()) {
            setAirQuality(rhs.getAirQuality());
        } else {
            clearAirQuality();
        }
        if (rhs.hasCloudCover()) {
            setCloudCover(rhs.getCloudCover());
        } else {
            clearCloudCover();
        }
        if (rhs.hasForecastTimeStamp()) {
            setForecastTimeStamp(rhs.getForecastTimeStamp());
        } else {
            clearForecastTimeStamp();
        }
    }
    return *this;
}

inline bool T_WeatherInfo::operator == (const T_WeatherInfo& rhs) const {
    return (((!hasWeatherForecastType() && !rhs.hasWeatherForecastType()) || getWeatherForecastType() == rhs.getWeatherForecastType()) &&
        ((!hasEventCode() && !rhs.hasEventCode()) || getEventCode() == rhs.getEventCode()) &&
        ((!hasEventDescription() && !rhs.hasEventDescription()) || getEventDescription() == rhs.getEventDescription()) &&
        ((!hasTabWeather_LOCID() && !rhs.hasTabWeather_LOCID()) || getTabWeather_LOCID() == rhs.getTabWeather_LOCID()) &&
        ((!hasWeatherStationName() && !rhs.hasWeatherStationName()) || getWeatherStationName() == rhs.getWeatherStationName()) &&
        ((!hasWeatherStateName() && !rhs.hasWeatherStateName()) || getWeatherStateName() == rhs.getWeatherStateName()) &&
        ((!hasCurrentTemperature() && !rhs.hasCurrentTemperature()) || getCurrentTemperature() == rhs.getCurrentTemperature()) &&
        ((!hasTemperatureHigh() && !rhs.hasTemperatureHigh()) || getTemperatureHigh() == rhs.getTemperatureHigh()) &&
        ((!hasTemperatureLow() && !rhs.hasTemperatureLow()) || getTemperatureLow() == rhs.getTemperatureLow()) &&
        ((!hasPrecipitationChance() && !rhs.hasPrecipitationChance()) || getPrecipitationChance() == rhs.getPrecipitationChance()) &&
        ((!hasPrecipitationAmountRangeLow() && !rhs.hasPrecipitationAmountRangeLow()) || getPrecipitationAmountRangeLow() == rhs.getPrecipitationAmountRangeLow()) &&
        ((!hasPrecipitationAmountRangeHigh() && !rhs.hasPrecipitationAmountRangeHigh()) || getPrecipitationAmountRangeHigh() == rhs.getPrecipitationAmountRangeHigh()) &&
        ((!hasWindSpeed() && !rhs.hasWindSpeed()) || getWindSpeed() == rhs.getWindSpeed()) &&
        ((!hasWindDirection() && !rhs.hasWindDirection()) || getWindDirection() == rhs.getWindDirection()) &&
        ((!hasHumidityRangeLow() && !rhs.hasHumidityRangeLow()) || getHumidityRangeLow() == rhs.getHumidityRangeLow()) &&
        ((!hasHumidityRangeHigh() && !rhs.hasHumidityRangeHigh()) || getHumidityRangeHigh() == rhs.getHumidityRangeHigh()) &&
        ((!hasUV_InfoRangeLow() && !rhs.hasUV_InfoRangeLow()) || getUV_InfoRangeLow() == rhs.getUV_InfoRangeLow()) &&
        ((!hasUV_InfoRangeHigh() && !rhs.hasUV_InfoRangeHigh()) || getUV_InfoRangeHigh() == rhs.getUV_InfoRangeHigh()) &&
        ((!hasPollenLevel() && !rhs.hasPollenLevel()) || getPollenLevel() == rhs.getPollenLevel()) &&
        ((!hasAirQuality() && !rhs.hasAirQuality()) || getAirQuality() == rhs.getAirQuality()) &&
        ((!hasCloudCover() && !rhs.hasCloudCover()) || getCloudCover() == rhs.getCloudCover()) &&
        ((!hasForecastTimeStamp() && !rhs.hasForecastTimeStamp()) || getForecastTimeStamp() == rhs.getForecastTimeStamp()));
}

inline bool T_WeatherInfo::operator != (const T_WeatherInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WeatherInfo::operator < (const T_WeatherInfo& rhs) const {
    if (hasWeatherForecastType() || rhs.hasWeatherForecastType()) {
        if ((uint32)getWeatherForecastType() < (uint32)rhs.getWeatherForecastType()) return true;
        if ((uint32)getWeatherForecastType() > (uint32)rhs.getWeatherForecastType()) return false;
    }
    if (hasEventCode() || rhs.hasEventCode()) {
        if (getEventCode() < rhs.getEventCode()) return true;
        if (getEventCode() > rhs.getEventCode()) return false;
    }
    if (hasEventDescription() || rhs.hasEventDescription()) {
        if (getEventDescription() < rhs.getEventDescription()) return true;
        if (getEventDescription() > rhs.getEventDescription()) return false;
    }
    if (hasTabWeather_LOCID() || rhs.hasTabWeather_LOCID()) {
        if (getTabWeather_LOCID() < rhs.getTabWeather_LOCID()) return true;
        if (getTabWeather_LOCID() > rhs.getTabWeather_LOCID()) return false;
    }
    if (hasWeatherStationName() || rhs.hasWeatherStationName()) {
        if (getWeatherStationName() < rhs.getWeatherStationName()) return true;
        if (getWeatherStationName() > rhs.getWeatherStationName()) return false;
    }
    if (hasWeatherStateName() || rhs.hasWeatherStateName()) {
        if (getWeatherStateName() < rhs.getWeatherStateName()) return true;
        if (getWeatherStateName() > rhs.getWeatherStateName()) return false;
    }
    if (hasCurrentTemperature() || rhs.hasCurrentTemperature()) {
        if (getCurrentTemperature() < rhs.getCurrentTemperature()) return true;
        if (getCurrentTemperature() > rhs.getCurrentTemperature()) return false;
    }
    if (hasTemperatureHigh() || rhs.hasTemperatureHigh()) {
        if (getTemperatureHigh() < rhs.getTemperatureHigh()) return true;
        if (getTemperatureHigh() > rhs.getTemperatureHigh()) return false;
    }
    if (hasTemperatureLow() || rhs.hasTemperatureLow()) {
        if (getTemperatureLow() < rhs.getTemperatureLow()) return true;
        if (getTemperatureLow() > rhs.getTemperatureLow()) return false;
    }
    if (hasPrecipitationChance() || rhs.hasPrecipitationChance()) {
        if (getPrecipitationChance() < rhs.getPrecipitationChance()) return true;
        if (getPrecipitationChance() > rhs.getPrecipitationChance()) return false;
    }
    if (hasPrecipitationAmountRangeLow() || rhs.hasPrecipitationAmountRangeLow()) {
        if (getPrecipitationAmountRangeLow() < rhs.getPrecipitationAmountRangeLow()) return true;
        if (getPrecipitationAmountRangeLow() > rhs.getPrecipitationAmountRangeLow()) return false;
    }
    if (hasPrecipitationAmountRangeHigh() || rhs.hasPrecipitationAmountRangeHigh()) {
        if (getPrecipitationAmountRangeHigh() < rhs.getPrecipitationAmountRangeHigh()) return true;
        if (getPrecipitationAmountRangeHigh() > rhs.getPrecipitationAmountRangeHigh()) return false;
    }
    if (hasWindSpeed() || rhs.hasWindSpeed()) {
        if (getWindSpeed() < rhs.getWindSpeed()) return true;
        if (getWindSpeed() > rhs.getWindSpeed()) return false;
    }
    if (hasWindDirection() || rhs.hasWindDirection()) {
        if (getWindDirection() < rhs.getWindDirection()) return true;
        if (getWindDirection() > rhs.getWindDirection()) return false;
    }
    if (hasHumidityRangeLow() || rhs.hasHumidityRangeLow()) {
        if (getHumidityRangeLow() < rhs.getHumidityRangeLow()) return true;
        if (getHumidityRangeLow() > rhs.getHumidityRangeLow()) return false;
    }
    if (hasHumidityRangeHigh() || rhs.hasHumidityRangeHigh()) {
        if (getHumidityRangeHigh() < rhs.getHumidityRangeHigh()) return true;
        if (getHumidityRangeHigh() > rhs.getHumidityRangeHigh()) return false;
    }
    if (hasUV_InfoRangeLow() || rhs.hasUV_InfoRangeLow()) {
        if (getUV_InfoRangeLow() < rhs.getUV_InfoRangeLow()) return true;
        if (getUV_InfoRangeLow() > rhs.getUV_InfoRangeLow()) return false;
    }
    if (hasUV_InfoRangeHigh() || rhs.hasUV_InfoRangeHigh()) {
        if (getUV_InfoRangeHigh() < rhs.getUV_InfoRangeHigh()) return true;
        if (getUV_InfoRangeHigh() > rhs.getUV_InfoRangeHigh()) return false;
    }
    if (hasPollenLevel() || rhs.hasPollenLevel()) {
        if ((uint32)getPollenLevel() < (uint32)rhs.getPollenLevel()) return true;
        if ((uint32)getPollenLevel() > (uint32)rhs.getPollenLevel()) return false;
    }
    if (hasAirQuality() || rhs.hasAirQuality()) {
        if ((uint32)getAirQuality() < (uint32)rhs.getAirQuality()) return true;
        if ((uint32)getAirQuality() > (uint32)rhs.getAirQuality()) return false;
    }
    if (hasCloudCover() || rhs.hasCloudCover()) {
        if ((uint32)getCloudCover() < (uint32)rhs.getCloudCover()) return true;
        if ((uint32)getCloudCover() > (uint32)rhs.getCloudCover()) return false;
    }
    if (hasForecastTimeStamp() || rhs.hasForecastTimeStamp()) {
        if (getForecastTimeStamp() < rhs.getForecastTimeStamp()) return true;
        if (getForecastTimeStamp() > rhs.getForecastTimeStamp()) return false;
    }
    return false;
}

inline bool T_WeatherInfo::operator > (const T_WeatherInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WeatherInfo::clear() {
    clearWeatherForecastType();
    clearEventCode();
    clearEventDescription();
    clearTabWeather_LOCID();
    clearWeatherStationName();
    clearWeatherStateName();
    clearCurrentTemperature();
    clearTemperatureHigh();
    clearTemperatureLow();
    clearPrecipitationChance();
    clearPrecipitationAmountRangeLow();
    clearPrecipitationAmountRangeHigh();
    clearWindSpeed();
    clearWindDirection();
    clearHumidityRangeLow();
    clearHumidityRangeHigh();
    clearUV_InfoRangeLow();
    clearUV_InfoRangeHigh();
    clearPollenLevel();
    clearAirQuality();
    clearCloudCover();
    clearForecastTimeStamp();
}

inline void T_WeatherInfo::clearWeatherForecastType() {
    if (hasWeatherForecastType()) {
         clear_has_WeatherForecastType();
        _WeatherForecastType = ::sxm_tabweather_main_fi_types::T_e8_ForecastType__WEATHER_FORECAST_TYPE_CURRENT;
     }
}

inline bool T_WeatherInfo::hasWeatherForecastType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_ForecastType T_WeatherInfo::getWeatherForecastType () const {
    return _WeatherForecastType;
}

inline void T_WeatherInfo::setWeatherForecastType (T_e8_ForecastType WeatherForecastType_) {
    #ifndef NDEBUG
    if (!(T_e8_ForecastType_IsValid(WeatherForecastType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WeatherForecastType_, "T_e8_ForecastType", "WeatherForecastType", "T_WeatherInfo");
    }
    #endif
    set_has_WeatherForecastType();
    this->_WeatherForecastType = WeatherForecastType_;
}

inline void T_WeatherInfo::clearEventCode() {
    if (hasEventCode()) {
         clear_has_EventCode();
        _EventCode = 0u;
     }
}

inline bool T_WeatherInfo::hasEventCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_WeatherInfo::getEventCode () const {
    return _EventCode;
}

inline void T_WeatherInfo::setEventCode (uint8 EventCode_) {
    set_has_EventCode();
    this->_EventCode = EventCode_;
}

inline void T_WeatherInfo::clearEventDescription() {
    if (hasEventDescription()) {
         clear_has_EventDescription();
        _EventDescription.clear();
     }
}

inline bool T_WeatherInfo::hasEventDescription () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_WeatherInfo::getEventDescription () const {
    return _EventDescription;
}

inline ::std::string& T_WeatherInfo::getEventDescriptionMutable () {
    set_has_EventDescription();
    return _EventDescription;
}

inline void T_WeatherInfo::setEventDescription (const ::std::string& EventDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EventDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EventDescription();
    this->_EventDescription = EventDescription_;
}

inline void T_WeatherInfo::setEventDescription (const char* EventDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EventDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EventDescription();
    this->_EventDescription.assign(EventDescription_);
}

inline void T_WeatherInfo::setEventDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EventDescription();
    this->_EventDescription.assign(value, size);
}

inline void T_WeatherInfo::clearTabWeather_LOCID() {
    if (hasTabWeather_LOCID()) {
         clear_has_TabWeather_LOCID();
        _TabWeather_LOCID = 0u;
     }
}

inline bool T_WeatherInfo::hasTabWeather_LOCID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_WeatherInfo::getTabWeather_LOCID () const {
    return _TabWeather_LOCID;
}

inline void T_WeatherInfo::setTabWeather_LOCID (uint32 TabWeather_LOCID_) {
    set_has_TabWeather_LOCID();
    this->_TabWeather_LOCID = TabWeather_LOCID_;
}

inline void T_WeatherInfo::clearWeatherStationName() {
    if (hasWeatherStationName()) {
         clear_has_WeatherStationName();
        _WeatherStationName.clear();
     }
}

inline bool T_WeatherInfo::hasWeatherStationName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_WeatherInfo::getWeatherStationName () const {
    return _WeatherStationName;
}

inline ::std::string& T_WeatherInfo::getWeatherStationNameMutable () {
    set_has_WeatherStationName();
    return _WeatherStationName;
}

inline void T_WeatherInfo::setWeatherStationName (const ::std::string& WeatherStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStationName();
    this->_WeatherStationName = WeatherStationName_;
}

inline void T_WeatherInfo::setWeatherStationName (const char* WeatherStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStationName();
    this->_WeatherStationName.assign(WeatherStationName_);
}

inline void T_WeatherInfo::setWeatherStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStationName();
    this->_WeatherStationName.assign(value, size);
}

inline void T_WeatherInfo::clearWeatherStateName() {
    if (hasWeatherStateName()) {
         clear_has_WeatherStateName();
        _WeatherStateName.clear();
     }
}

inline bool T_WeatherInfo::hasWeatherStateName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_WeatherInfo::getWeatherStateName () const {
    return _WeatherStateName;
}

inline ::std::string& T_WeatherInfo::getWeatherStateNameMutable () {
    set_has_WeatherStateName();
    return _WeatherStateName;
}

inline void T_WeatherInfo::setWeatherStateName (const ::std::string& WeatherStateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStateName();
    this->_WeatherStateName = WeatherStateName_;
}

inline void T_WeatherInfo::setWeatherStateName (const char* WeatherStateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WeatherStateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStateName();
    this->_WeatherStateName.assign(WeatherStateName_);
}

inline void T_WeatherInfo::setWeatherStateName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WeatherStateName();
    this->_WeatherStateName.assign(value, size);
}

inline void T_WeatherInfo::clearCurrentTemperature() {
    if (hasCurrentTemperature()) {
         clear_has_CurrentTemperature();
        _CurrentTemperature = 0;
     }
}

inline bool T_WeatherInfo::hasCurrentTemperature () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline int16 T_WeatherInfo::getCurrentTemperature () const {
    return _CurrentTemperature;
}

inline void T_WeatherInfo::setCurrentTemperature (int16 CurrentTemperature_) {
    set_has_CurrentTemperature();
    this->_CurrentTemperature = CurrentTemperature_;
}

inline void T_WeatherInfo::clearTemperatureHigh() {
    if (hasTemperatureHigh()) {
         clear_has_TemperatureHigh();
        _TemperatureHigh = 0;
     }
}

inline bool T_WeatherInfo::hasTemperatureHigh () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline int16 T_WeatherInfo::getTemperatureHigh () const {
    return _TemperatureHigh;
}

inline void T_WeatherInfo::setTemperatureHigh (int16 TemperatureHigh_) {
    set_has_TemperatureHigh();
    this->_TemperatureHigh = TemperatureHigh_;
}

inline void T_WeatherInfo::clearTemperatureLow() {
    if (hasTemperatureLow()) {
         clear_has_TemperatureLow();
        _TemperatureLow = 0;
     }
}

inline bool T_WeatherInfo::hasTemperatureLow () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline int16 T_WeatherInfo::getTemperatureLow () const {
    return _TemperatureLow;
}

inline void T_WeatherInfo::setTemperatureLow (int16 TemperatureLow_) {
    set_has_TemperatureLow();
    this->_TemperatureLow = TemperatureLow_;
}

inline void T_WeatherInfo::clearPrecipitationChance() {
    if (hasPrecipitationChance()) {
         clear_has_PrecipitationChance();
        _PrecipitationChance = 0u;
     }
}

inline bool T_WeatherInfo::hasPrecipitationChance () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_WeatherInfo::getPrecipitationChance () const {
    return _PrecipitationChance;
}

inline void T_WeatherInfo::setPrecipitationChance (uint8 PrecipitationChance_) {
    set_has_PrecipitationChance();
    this->_PrecipitationChance = PrecipitationChance_;
}

inline void T_WeatherInfo::clearPrecipitationAmountRangeLow() {
    if (hasPrecipitationAmountRangeLow()) {
         clear_has_PrecipitationAmountRangeLow();
        _PrecipitationAmountRangeLow = 0.0f;
     }
}

inline bool T_WeatherInfo::hasPrecipitationAmountRangeLow () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline float T_WeatherInfo::getPrecipitationAmountRangeLow () const {
    return _PrecipitationAmountRangeLow;
}

inline void T_WeatherInfo::setPrecipitationAmountRangeLow (float PrecipitationAmountRangeLow_) {
    set_has_PrecipitationAmountRangeLow();
    this->_PrecipitationAmountRangeLow = PrecipitationAmountRangeLow_;
}

inline void T_WeatherInfo::clearPrecipitationAmountRangeHigh() {
    if (hasPrecipitationAmountRangeHigh()) {
         clear_has_PrecipitationAmountRangeHigh();
        _PrecipitationAmountRangeHigh = 0.0f;
     }
}

inline bool T_WeatherInfo::hasPrecipitationAmountRangeHigh () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline float T_WeatherInfo::getPrecipitationAmountRangeHigh () const {
    return _PrecipitationAmountRangeHigh;
}

inline void T_WeatherInfo::setPrecipitationAmountRangeHigh (float PrecipitationAmountRangeHigh_) {
    set_has_PrecipitationAmountRangeHigh();
    this->_PrecipitationAmountRangeHigh = PrecipitationAmountRangeHigh_;
}

inline void T_WeatherInfo::clearWindSpeed() {
    if (hasWindSpeed()) {
         clear_has_WindSpeed();
        _WindSpeed = 0u;
     }
}

inline bool T_WeatherInfo::hasWindSpeed () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_WeatherInfo::getWindSpeed () const {
    return _WindSpeed;
}

inline void T_WeatherInfo::setWindSpeed (uint8 WindSpeed_) {
    set_has_WindSpeed();
    this->_WindSpeed = WindSpeed_;
}

inline void T_WeatherInfo::clearWindDirection() {
    if (hasWindDirection()) {
         clear_has_WindDirection();
        _WindDirection = 0u;
     }
}

inline bool T_WeatherInfo::hasWindDirection () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint16 T_WeatherInfo::getWindDirection () const {
    return _WindDirection;
}

inline void T_WeatherInfo::setWindDirection (uint16 WindDirection_) {
    set_has_WindDirection();
    this->_WindDirection = WindDirection_;
}

inline void T_WeatherInfo::clearHumidityRangeLow() {
    if (hasHumidityRangeLow()) {
         clear_has_HumidityRangeLow();
        _HumidityRangeLow = 0u;
     }
}

inline bool T_WeatherInfo::hasHumidityRangeLow () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 T_WeatherInfo::getHumidityRangeLow () const {
    return _HumidityRangeLow;
}

inline void T_WeatherInfo::setHumidityRangeLow (uint8 HumidityRangeLow_) {
    set_has_HumidityRangeLow();
    this->_HumidityRangeLow = HumidityRangeLow_;
}

inline void T_WeatherInfo::clearHumidityRangeHigh() {
    if (hasHumidityRangeHigh()) {
         clear_has_HumidityRangeHigh();
        _HumidityRangeHigh = 0u;
     }
}

inline bool T_WeatherInfo::hasHumidityRangeHigh () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_WeatherInfo::getHumidityRangeHigh () const {
    return _HumidityRangeHigh;
}

inline void T_WeatherInfo::setHumidityRangeHigh (uint8 HumidityRangeHigh_) {
    set_has_HumidityRangeHigh();
    this->_HumidityRangeHigh = HumidityRangeHigh_;
}

inline void T_WeatherInfo::clearUV_InfoRangeLow() {
    if (hasUV_InfoRangeLow()) {
         clear_has_UV_InfoRangeLow();
        _UV_InfoRangeLow = 0u;
     }
}

inline bool T_WeatherInfo::hasUV_InfoRangeLow () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_WeatherInfo::getUV_InfoRangeLow () const {
    return _UV_InfoRangeLow;
}

inline void T_WeatherInfo::setUV_InfoRangeLow (uint8 UV_InfoRangeLow_) {
    set_has_UV_InfoRangeLow();
    this->_UV_InfoRangeLow = UV_InfoRangeLow_;
}

inline void T_WeatherInfo::clearUV_InfoRangeHigh() {
    if (hasUV_InfoRangeHigh()) {
         clear_has_UV_InfoRangeHigh();
        _UV_InfoRangeHigh = 0u;
     }
}

inline bool T_WeatherInfo::hasUV_InfoRangeHigh () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint8 T_WeatherInfo::getUV_InfoRangeHigh () const {
    return _UV_InfoRangeHigh;
}

inline void T_WeatherInfo::setUV_InfoRangeHigh (uint8 UV_InfoRangeHigh_) {
    set_has_UV_InfoRangeHigh();
    this->_UV_InfoRangeHigh = UV_InfoRangeHigh_;
}

inline void T_WeatherInfo::clearPollenLevel() {
    if (hasPollenLevel()) {
         clear_has_PollenLevel();
        _PollenLevel = ::sxm_tabweather_main_fi_types::T_e8_PollenLevelType__WEATHER_AIR_POLLEN_LEVEL_LOW;
     }
}

inline bool T_WeatherInfo::hasPollenLevel () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline T_e8_PollenLevelType T_WeatherInfo::getPollenLevel () const {
    return _PollenLevel;
}

inline void T_WeatherInfo::setPollenLevel (T_e8_PollenLevelType PollenLevel_) {
    #ifndef NDEBUG
    if (!(T_e8_PollenLevelType_IsValid(PollenLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PollenLevel_, "T_e8_PollenLevelType", "PollenLevel", "T_WeatherInfo");
    }
    #endif
    set_has_PollenLevel();
    this->_PollenLevel = PollenLevel_;
}

inline void T_WeatherInfo::clearAirQuality() {
    if (hasAirQuality()) {
         clear_has_AirQuality();
        _AirQuality = ::sxm_tabweather_main_fi_types::T_e8_AirQualityType__WEATHER_AIR_QUALITY_GOOD;
     }
}

inline bool T_WeatherInfo::hasAirQuality () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline T_e8_AirQualityType T_WeatherInfo::getAirQuality () const {
    return _AirQuality;
}

inline void T_WeatherInfo::setAirQuality (T_e8_AirQualityType AirQuality_) {
    #ifndef NDEBUG
    if (!(T_e8_AirQualityType_IsValid(AirQuality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AirQuality_, "T_e8_AirQualityType", "AirQuality", "T_WeatherInfo");
    }
    #endif
    set_has_AirQuality();
    this->_AirQuality = AirQuality_;
}

inline void T_WeatherInfo::clearCloudCover() {
    if (hasCloudCover()) {
         clear_has_CloudCover();
        _CloudCover = ::sxm_tabweather_main_fi_types::T_e8_CloudCoverType__WEATHER_FORECAST_CLOUD_COVER_CLEAR;
     }
}

inline bool T_WeatherInfo::hasCloudCover () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline T_e8_CloudCoverType T_WeatherInfo::getCloudCover () const {
    return _CloudCover;
}

inline void T_WeatherInfo::setCloudCover (T_e8_CloudCoverType CloudCover_) {
    #ifndef NDEBUG
    if (!(T_e8_CloudCoverType_IsValid(CloudCover_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CloudCover_, "T_e8_CloudCoverType", "CloudCover", "T_WeatherInfo");
    }
    #endif
    set_has_CloudCover();
    this->_CloudCover = CloudCover_;
}

inline void T_WeatherInfo::clearForecastTimeStamp() {
    if (hasForecastTimeStamp()) {
         clear_has_ForecastTimeStamp();
        _ForecastTimeStamp = 0u;
     }
}

inline bool T_WeatherInfo::hasForecastTimeStamp () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 T_WeatherInfo::getForecastTimeStamp () const {
    return _ForecastTimeStamp;
}

inline void T_WeatherInfo::setForecastTimeStamp (uint32 ForecastTimeStamp_) {
    set_has_ForecastTimeStamp();
    this->_ForecastTimeStamp = ForecastTimeStamp_;
}

inline void T_WeatherInfo::set_has_WeatherForecastType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WeatherInfo::clear_has_WeatherForecastType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WeatherInfo::set_has_EventCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WeatherInfo::clear_has_EventCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_WeatherInfo::set_has_EventDescription () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_WeatherInfo::clear_has_EventDescription () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_WeatherInfo::set_has_TabWeather_LOCID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_WeatherInfo::clear_has_TabWeather_LOCID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_WeatherInfo::set_has_WeatherStationName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_WeatherInfo::clear_has_WeatherStationName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_WeatherInfo::set_has_WeatherStateName () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_WeatherInfo::clear_has_WeatherStateName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_WeatherInfo::set_has_CurrentTemperature () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_WeatherInfo::clear_has_CurrentTemperature () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_WeatherInfo::set_has_TemperatureHigh () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_WeatherInfo::clear_has_TemperatureHigh () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_WeatherInfo::set_has_TemperatureLow () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_WeatherInfo::clear_has_TemperatureLow () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_WeatherInfo::set_has_PrecipitationChance () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_WeatherInfo::clear_has_PrecipitationChance () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_WeatherInfo::set_has_PrecipitationAmountRangeLow () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_WeatherInfo::clear_has_PrecipitationAmountRangeLow () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_WeatherInfo::set_has_PrecipitationAmountRangeHigh () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_WeatherInfo::clear_has_PrecipitationAmountRangeHigh () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_WeatherInfo::set_has_WindSpeed () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_WeatherInfo::clear_has_WindSpeed () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_WeatherInfo::set_has_WindDirection () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_WeatherInfo::clear_has_WindDirection () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_WeatherInfo::set_has_HumidityRangeLow () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_WeatherInfo::clear_has_HumidityRangeLow () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_WeatherInfo::set_has_HumidityRangeHigh () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_WeatherInfo::clear_has_HumidityRangeHigh () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_WeatherInfo::set_has_UV_InfoRangeLow () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_WeatherInfo::clear_has_UV_InfoRangeLow () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_WeatherInfo::set_has_UV_InfoRangeHigh () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_WeatherInfo::clear_has_UV_InfoRangeHigh () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_WeatherInfo::set_has_PollenLevel () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_WeatherInfo::clear_has_PollenLevel () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_WeatherInfo::set_has_AirQuality () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_WeatherInfo::clear_has_AirQuality () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_WeatherInfo::set_has_CloudCover () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_WeatherInfo::clear_has_CloudCover () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_WeatherInfo::set_has_ForecastTimeStamp () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_WeatherInfo::clear_has_ForecastTimeStamp () {
    _has_bits_[0] &= ~ (1u << 21);
}

} // namespace sxm_tabweather_main_fi_types

#endif // SXM_TABWEATHER_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
