/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_TABWEATHER_MAIN_FIPROXY_H
#define SXM_TABWEATHER_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_tabweather_main_fi.h"

namespace sxm_tabweather_main_fi {

class Sxm_tabweather_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class GetFavoriteInfoCallbackIF {
public:
    virtual ~GetFavoriteInfoCallbackIF() {}

    virtual void onGetFavoriteInfoError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteInfoError >& error) = 0;

    virtual void onGetFavoriteInfoResult(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteInfoResult >& result) = 0;
};

class GetTabWeatherInfoListCallbackIF {
public:
    virtual ~GetTabWeatherInfoListCallbackIF() {}

    virtual void onGetTabWeatherInfoListError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTabWeatherInfoListError >& error) = 0;

    virtual void onGetTabWeatherInfoListResult(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTabWeatherInfoListResult >& result) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class TabWeatherInfoListStatusCallbackIF {
public:
    virtual ~TabWeatherInfoListStatusCallbackIF() {}

    virtual void onTabWeatherInfoListStatusError(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< TabWeatherInfoListStatusError >& error) = 0;

    virtual void onTabWeatherInfoListStatusStatus(const ::boost::shared_ptr< Sxm_tabweather_main_fiProxy >& proxy, const ::boost::shared_ptr< TabWeatherInfoListStatusStatus >& status) = 0;
};

class Sxm_tabweather_main_fiProxyCallback;

/**
 * Sxm_tabweather_main_fiProxy is the client side representation of the
 * CCA Functional Interface 'sxm_tabweather_main_fi' (specified in file
 * sxm_tabweather_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_tabweather_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Rajaram Sarangapani
 *
 * Date: $Date:   June 21 2012  $
 *
 * Department: ECV3
 *
 * Title: sxm_tabweather_main_fi
 *
 * <b>Description of 'sxm_tabweather_main_fi':</b>
 *
 * RBEI/ECM
 */
class Sxm_tabweather_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_tabweather_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_tabweather_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_tabweather_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_tabweather_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_tabweather_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_tabweather_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_tabweather_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_tabweather_main_fiProxy();

    // Method 'GetTabWeatherInfoList'

    /**
     * Call the method 'GetTabWeatherInfoList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetTabWeatherInfoList'</b>:
     *
     * This method is used to get Tab Weather Information for required location.
     * Used for "Near Destination", "Nearby" and "Another City" usecases.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListId List ID, value starts from 1. Refer types from T_e8_SxmListType, 4 - "Another City" usecase(LOCATION)
     *
     * @param Operation Operation to be performed
     *
     * @param Location Lat, Lon and Radius are given. To be checked for "LOCATION" list type.
     * ["Another City" usecase].
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTabWeatherInfoListStart(GetTabWeatherInfoListCallbackIF& cb, uint32 listId, ::sxm_main_fi_types::T_e8_SxmListOperation operation, const ::sxm_main_fi_types::T_SxmLocation& location);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method is used to get Tab Weather Information for required location
     * and to add it as a Favorite.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Location Lat, Lon and Radius are given
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, const ::sxm_main_fi_types::T_SxmLocation& location);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method is to remove a favorite location by LOC_ID
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TabWeather_LOCID Weather Station Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 tabWeather_LOCID);

    // Method 'GetFavoriteInfo'

    /**
     * Call the method 'GetFavoriteInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetFavoriteInfo'</b>:
     *
     * To get Tabular Weather information for the Favorite location
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TabWeather_LOCID Weather Station Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFavoriteInfoStart(GetFavoriteInfoCallbackIF& cb, uint32 tabWeather_LOCID);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure all lists
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Currently in T_SxmListsConfig, Capacity is passed.
     * Capacity for Weather is "1". This Method is to provide a control over capacity.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Property 'TabWeatherInfoListStatus'

    /**
     * Notify on the property 'TabWeatherInfoListStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'TabWeatherInfoListStatus'</b>:
     *
     * Tab Weather information result
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTabWeatherInfoListStatusUpReg(TabWeatherInfoListStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TabWeatherInfoListStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TabWeatherInfoListStatus'</b>:
     *
     * Tab Weather information result
     *
     * @param act The act which was previously returned by the
     * sendTabWeatherInfoListStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTabWeatherInfoListStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TabWeatherInfoListStatus'.
     */
    void sendTabWeatherInfoListStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'TabWeatherInfoListStatus'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTabWeatherInfoListStatus() returns true.
     *
     * @return the previously received value of the property 'TabWeatherInfoListStatus'.
     */
    const TabWeatherInfoListStatusStatus& getTabWeatherInfoListStatus() const;

    /**
     * Determines whether a status message for the property 'TabWeatherInfoListStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTabWeatherInfoListStatus() const;

    /**
     * Request the value of the property 'TabWeatherInfoListStatus' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TabWeatherInfoListStatus'</b>:
     *
     * Tab Weather information result
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTabWeatherInfoListStatusGet(TabWeatherInfoListStatusCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of TabWeather Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of TabWeather Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of TabWeather Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of TabWeather List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of TabWeather List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of TabWeather List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of TabWeather List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_tabweather_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'TabWeatherInfoListStatus'

    ::asf::core::nullable< TabWeatherInfoListStatusStatus > _tabWeatherInfoListStatus;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_tabweather_main_fiProxyCallback;
};

} // namespace sxm_tabweather_main_fi

#endif // SXM_TABWEATHER_MAIN_FIPROXY_H
