#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_STOCKS_MAIN_FI_TYPES_H
#define SXM_STOCKS_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_stocks_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_stocks_main_fi_types
 */

namespace sxm_stocks_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_StockQuote;

// type definitions
/**
 * If the meaning of "T_StockQuoteList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_StockQuote > T_StockQuoteList;

/**
 * If the meaning of "T_StockFilterList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_StockFilterList;


/**
 * Structure to hold Stock symbol, their Trading Values and Changes since previous market day's closing price
 */
class T_StockQuote {
public:

    /**
     * Default constructor
     */
    inline  T_StockQuote ();

    /**
     * Copy constructor
     */
    inline  T_StockQuote (const T_StockQuote &rhs);

    /**
     * All fields constructor
     */
    inline  T_StockQuote (const ::std::string& Symbol_, float MarketPrice_, float Delta_, T_e8_STOCK_PRICE_DIRECTION Direction_);

    /**
     * Destructor
     */
    inline  ~T_StockQuote();

    /**
     * Assignment operator
     */
    inline T_StockQuote& operator = (const T_StockQuote& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StockQuote& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StockQuote& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StockQuote& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StockQuote& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Symbol"

    static const int kSymbol = 0;

    /**
     * Clears the field "Symbol".
     *
     * The field will be set to its default value. The hasSymbol()
     * method will return false.
     */
    inline void clearSymbol();

    /**
     * Checks whether the field "Symbol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSymbol()). Otherwise it will return false.
     */
    inline bool hasSymbol () const;

    /**
     * Returns the value of the member "Symbol".
     *
     * Stock symbol
     *
     * @return The value of the field "Symbol"
     */
    inline const ::std::string& getSymbol () const;

    /**
     * Retrieves the value of the field "Symbol" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Symbol".
     */
    inline ::std::string& getSymbolMutable ();

    /**
     * Sets the value of the member "Symbol".
     *
     * Stock symbol
     *
     * @param Symbol The value which will be set
     */
    inline void setSymbol (const ::std::string& Symbol_);

    /**
     * Sets the value of the member "Symbol".
     *
     * Stock symbol
     *
     * @param Symbol The value which will be set
     */
    inline void setSymbol (const char* Symbol_);

    /**
     * Sets the value of the member "Symbol".
     *
     * Stock symbol
     *
     * @param Symbol The value which will be set
     */
    inline void setSymbol (const char* value, size_t size);

    // API of field "MarketPrice"

    static const int kMarketPrice = 1;

    /**
     * Clears the field "MarketPrice".
     *
     * The field will be set to its default value. The hasMarketPrice()
     * method will return false.
     */
    inline void clearMarketPrice();

    /**
     * Checks whether the field "MarketPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarketPrice()). Otherwise it will return false.
     */
    inline bool hasMarketPrice () const;

    /**
     * Returns the value of the member "MarketPrice".
     *
     * Current trading value of the stock
     *
     * @return The value of the field "MarketPrice"
     */
    inline float getMarketPrice () const;

    /**
     * Sets the value of the member "MarketPrice".
     *
     * Current trading value of the stock
     *
     * @param MarketPrice The value which will be set
     */
    inline void setMarketPrice (float MarketPrice_);

    // API of field "Delta"

    static const int kDelta = 2;

    /**
     * Clears the field "Delta".
     *
     * The field will be set to its default value. The hasDelta()
     * method will return false.
     */
    inline void clearDelta();

    /**
     * Checks whether the field "Delta" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDelta()). Otherwise it will return false.
     */
    inline bool hasDelta () const;

    /**
     * Returns the value of the member "Delta".
     *
     * Change in trading value of the stock since previous day's closing price
     *
     * @return The value of the field "Delta"
     */
    inline float getDelta () const;

    /**
     * Sets the value of the member "Delta".
     *
     * Change in trading value of the stock since previous day's closing price
     *
     * @param Delta The value which will be set
     */
    inline void setDelta (float Delta_);

    // API of field "Direction"

    static const int kDirection = 3;

    /**
     * Clears the field "Direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "Direction".
     *
     * Stock price change direction
     *
     * @return The value of the field "Direction"
     */
    inline T_e8_STOCK_PRICE_DIRECTION getDirection () const;

    /**
     * Sets the value of the member "Direction".
     *
     * Stock price change direction
     *
     * @param Direction The value which will be set
     */
    inline void setDirection (T_e8_STOCK_PRICE_DIRECTION Direction_);

    static const T_StockQuote &getDefaultInstance();

private:

    inline void set_has_Symbol ();

    inline void clear_has_Symbol ();

    inline void set_has_MarketPrice ();

    inline void clear_has_MarketPrice ();

    inline void set_has_Delta ();

    inline void clear_has_Delta ();

    inline void set_has_Direction ();

    inline void clear_has_Direction ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _Symbol;

    float _MarketPrice;

    float _Delta;

    T_e8_STOCK_PRICE_DIRECTION _Direction;

};

inline  T_StockQuote::T_StockQuote ()  :
    _Symbol (),
    _MarketPrice (0.0f),
    _Delta (0.0f),
    _Direction (::sxm_stocks_main_fi_types::T_e8_STOCK_PRICE_DIRECTION__STOCK_PRICE_DIRECTION_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StockQuote::T_StockQuote (const T_StockQuote &rhs)  :
    _Symbol (),
    _MarketPrice (0.0f),
    _Delta (0.0f),
    _Direction (::sxm_stocks_main_fi_types::T_e8_STOCK_PRICE_DIRECTION__STOCK_PRICE_DIRECTION_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StockQuote::T_StockQuote (const ::std::string& Symbol_, float MarketPrice_, float Delta_, T_e8_STOCK_PRICE_DIRECTION Direction_)  :
    _Symbol (Symbol_),
    _MarketPrice (MarketPrice_),
    _Delta (Delta_),
    _Direction (Direction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Symbol_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_STOCK_PRICE_DIRECTION_IsValid(Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Direction_, "T_e8_STOCK_PRICE_DIRECTION", "Direction", "T_StockQuote");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StockQuote::~T_StockQuote() {
}

inline T_StockQuote& T_StockQuote::operator = (const T_StockQuote& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSymbol()) {
            setSymbol(rhs.getSymbol());
        } else {
            clearSymbol();
        }
        if (rhs.hasMarketPrice()) {
            setMarketPrice(rhs.getMarketPrice());
        } else {
            clearMarketPrice();
        }
        if (rhs.hasDelta()) {
            setDelta(rhs.getDelta());
        } else {
            clearDelta();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
    }
    return *this;
}

inline bool T_StockQuote::operator == (const T_StockQuote& rhs) const {
    return (((!hasSymbol() && !rhs.hasSymbol()) || getSymbol() == rhs.getSymbol()) &&
        ((!hasMarketPrice() && !rhs.hasMarketPrice()) || getMarketPrice() == rhs.getMarketPrice()) &&
        ((!hasDelta() && !rhs.hasDelta()) || getDelta() == rhs.getDelta()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()));
}

inline bool T_StockQuote::operator != (const T_StockQuote& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StockQuote::operator < (const T_StockQuote& rhs) const {
    if (hasSymbol() || rhs.hasSymbol()) {
        if (getSymbol() < rhs.getSymbol()) return true;
        if (getSymbol() > rhs.getSymbol()) return false;
    }
    if (hasMarketPrice() || rhs.hasMarketPrice()) {
        if (getMarketPrice() < rhs.getMarketPrice()) return true;
        if (getMarketPrice() > rhs.getMarketPrice()) return false;
    }
    if (hasDelta() || rhs.hasDelta()) {
        if (getDelta() < rhs.getDelta()) return true;
        if (getDelta() > rhs.getDelta()) return false;
    }
    if (hasDirection() || rhs.hasDirection()) {
        if ((uint32)getDirection() < (uint32)rhs.getDirection()) return true;
        if ((uint32)getDirection() > (uint32)rhs.getDirection()) return false;
    }
    return false;
}

inline bool T_StockQuote::operator > (const T_StockQuote& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StockQuote::clear() {
    clearSymbol();
    clearMarketPrice();
    clearDelta();
    clearDirection();
}

inline void T_StockQuote::clearSymbol() {
    if (hasSymbol()) {
         clear_has_Symbol();
        _Symbol.clear();
     }
}

inline bool T_StockQuote::hasSymbol () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_StockQuote::getSymbol () const {
    return _Symbol;
}

inline ::std::string& T_StockQuote::getSymbolMutable () {
    set_has_Symbol();
    return _Symbol;
}

inline void T_StockQuote::setSymbol (const ::std::string& Symbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Symbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Symbol();
    this->_Symbol = Symbol_;
}

inline void T_StockQuote::setSymbol (const char* Symbol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Symbol_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Symbol();
    this->_Symbol.assign(Symbol_);
}

inline void T_StockQuote::setSymbol (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Symbol();
    this->_Symbol.assign(value, size);
}

inline void T_StockQuote::clearMarketPrice() {
    if (hasMarketPrice()) {
         clear_has_MarketPrice();
        _MarketPrice = 0.0f;
     }
}

inline bool T_StockQuote::hasMarketPrice () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline float T_StockQuote::getMarketPrice () const {
    return _MarketPrice;
}

inline void T_StockQuote::setMarketPrice (float MarketPrice_) {
    set_has_MarketPrice();
    this->_MarketPrice = MarketPrice_;
}

inline void T_StockQuote::clearDelta() {
    if (hasDelta()) {
         clear_has_Delta();
        _Delta = 0.0f;
     }
}

inline bool T_StockQuote::hasDelta () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float T_StockQuote::getDelta () const {
    return _Delta;
}

inline void T_StockQuote::setDelta (float Delta_) {
    set_has_Delta();
    this->_Delta = Delta_;
}

inline void T_StockQuote::clearDirection() {
    if (hasDirection()) {
         clear_has_Direction();
        _Direction = ::sxm_stocks_main_fi_types::T_e8_STOCK_PRICE_DIRECTION__STOCK_PRICE_DIRECTION_INVALID;
     }
}

inline bool T_StockQuote::hasDirection () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_STOCK_PRICE_DIRECTION T_StockQuote::getDirection () const {
    return _Direction;
}

inline void T_StockQuote::setDirection (T_e8_STOCK_PRICE_DIRECTION Direction_) {
    #ifndef NDEBUG
    if (!(T_e8_STOCK_PRICE_DIRECTION_IsValid(Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Direction_, "T_e8_STOCK_PRICE_DIRECTION", "Direction", "T_StockQuote");
    }
    #endif
    set_has_Direction();
    this->_Direction = Direction_;
}

inline void T_StockQuote::set_has_Symbol () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StockQuote::clear_has_Symbol () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StockQuote::set_has_MarketPrice () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StockQuote::clear_has_MarketPrice () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_StockQuote::set_has_Delta () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_StockQuote::clear_has_Delta () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_StockQuote::set_has_Direction () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_StockQuote::clear_has_Direction () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace sxm_stocks_main_fi_types

#endif // SXM_STOCKS_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
