/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_STOCKS_MAIN_FIPROXY_H
#define SXM_STOCKS_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_stocks_main_fi.h"
#include <string>

namespace sxm_stocks_main_fi {

class Sxm_stocks_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class ClearAllFavoritesCallbackIF {
public:
    virtual ~ClearAllFavoritesCallbackIF() {}

    virtual void onClearAllFavoritesError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< ClearAllFavoritesError >& error) = 0;

    virtual void onClearAllFavoritesResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< ClearAllFavoritesResult >& result) = 0;
};

class GetDataProviderInfoCallbackIF {
public:
    virtual ~GetDataProviderInfoCallbackIF() {}

    virtual void onGetDataProviderInfoError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDataProviderInfoError >& error) = 0;

    virtual void onGetDataProviderInfoResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDataProviderInfoResult >& result) = 0;
};

class GetFavoriteStockSymbolsCallbackIF {
public:
    virtual ~GetFavoriteStockSymbolsCallbackIF() {}

    virtual void onGetFavoriteStockSymbolsError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteStockSymbolsError >& error) = 0;

    virtual void onGetFavoriteStockSymbolsResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteStockSymbolsResult >& result) = 0;
};

class GetStockSymbolsByFilterCallbackIF {
public:
    virtual ~GetStockSymbolsByFilterCallbackIF() {}

    virtual void onGetStockSymbolsByFilterError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStockSymbolsByFilterError >& error) = 0;

    virtual void onGetStockSymbolsByFilterResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStockSymbolsByFilterResult >& result) = 0;
};

class GetStockSymbolsByFilterPSCallbackIF {
public:
    virtual ~GetStockSymbolsByFilterPSCallbackIF() {}

    virtual void onGetStockSymbolsByFilterPSError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStockSymbolsByFilterPSError >& error) = 0;

    virtual void onGetStockSymbolsByFilterPSResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStockSymbolsByFilterPSResult >& result) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class StockStatusCallbackIF {
public:
    virtual ~StockStatusCallbackIF() {}

    virtual void onStockStatusError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< StockStatusError >& error) = 0;

    virtual void onStockStatusStatus(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< StockStatusStatus >& status) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class SxmStocksDataProviderInfoStatusCallbackIF {
public:
    virtual ~SxmStocksDataProviderInfoStatusCallbackIF() {}

    virtual void onSxmStocksDataProviderInfoStatusError(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmStocksDataProviderInfoStatusError >& error) = 0;

    virtual void onSxmStocksDataProviderInfoStatusStatus(const ::boost::shared_ptr< Sxm_stocks_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmStocksDataProviderInfoStatusStatus >& status) = 0;
};

class Sxm_stocks_main_fiProxyCallback;

/**
 * Sxm_stocks_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_stocks_main_fi' (specified in file
 * sxm_stocks_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_stocks_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Stocks feature
 *
 * Version: $Revision:   0.6  $
 *
 * Author: Visahan Balasubramanian
 *
 * Date: $Date:   May 15 2015  $
 *
 * Department: ECV3Z
 *
 * Title: sxm_stocks_main_fi
 *
 * <b>Description of 'sxm_stocks_main_fi':</b>
 *
 * RBEI/ECM
 */
class Sxm_stocks_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_stocks_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_stocks_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_stocks_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_stocks_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_stocks_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_stocks_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_stocks_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_stocks_main_fiProxy();

    // Method 'GetFavoriteStockSymbols'

    /**
     * Call the method 'GetFavoriteStockSymbols'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetFavoriteStockSymbols'</b>:
     *
     * This method is used to get Quote of all Favorite Stock symbols.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID Stocks Type information as defined in T_e8_SxmPredefinedListIds.
     * For stocks this value must be equivalent to FAVORITES as defined in T_e8_SxmPredefinedListIds.
     *
     * @param Operation Operation to be performed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFavoriteStockSymbolsStart(GetFavoriteStockSymbolsCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method takes a stock symbol in tString format as input parameter and adds it to the Favorites list for Stocks if its a valid Stock symbol.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StockSymbol The stock symbol that needs to be added as favorite.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, const ::std::string& stockSymbol);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method takes a stock symbol in tString format as input parameter and removes it from the Stocks Favorites list if its a valid Stock symbol.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StockSymbol The stock symbol that needs to be removed from favorites list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, const ::std::string& stockSymbol);

    // Method 'GetStockSymbolsByFilter'

    /**
     * Call the method 'GetStockSymbolsByFilter'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetStockSymbolsByFilter'</b>:
     *
     * Retrieves a list of all stocks beginning with the given stock symbol.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StockFilter The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStockSymbolsByFilterStart(GetStockSymbolsByFilterCallbackIF& cb, const ::std::string& stockFilter);

    // Method 'GetDataProviderInfo'

    /**
     * Call the method 'GetDataProviderInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetDataProviderInfo'</b>:
     *
     * Get Data Provider information as string if available.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDataProviderInfoStart(GetDataProviderInfoCallbackIF& cb);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure lists for stocks services
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Generic configuration for stocks list. Capacity for Stocks is "1". This needs to be passed to maintain uniformity across all SXM services.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Method 'GetStockSymbolsByFilterPS'

    /**
     * Call the method 'GetStockSymbolsByFilterPS'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetStockSymbolsByFilterPS'</b>:
     *
     * Retrieves a list of all stocks beginning with the given stock symbol, evaluates the characters to be displayed and provides the Display string to be displayed as user input in Keypad. This method needs to be used by HMI for getting Predictive speller support from MIDW.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param StockFilter The input is the search key. All stocks symbols starting with this key must be retrieved.
     *
     * @param IsBackSpace True if backspace is entered, False otherwise.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStockSymbolsByFilterPSStart(GetStockSymbolsByFilterPSCallbackIF& cb, const ::std::string& stockFilter, bool isBackSpace);

    // Method 'ClearAllFavorites'

    /**
     * Call the method 'ClearAllFavorites'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ClearAllFavorites'</b>:
     *
     * Clears all stocks from Favorites List. No arguments needs to be supplied to the method. The method does not provide any return value for method result.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearAllFavoritesStart(ClearAllFavoritesCallbackIF& cb);

    // Property 'StockStatus'

    /**
     * Notify on the property 'StockStatus'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'StockStatus'</b>:
     *
     * Status of all stocks belonging to Favorites list.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStockStatusUpReg(StockStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'StockStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'StockStatus'</b>:
     *
     * Status of all stocks belonging to Favorites list.
     *
     * @param act The act which was previously returned by the
     * sendStockStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendStockStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'StockStatus'.
     */
    void sendStockStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'StockStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasStockStatus() returns true.
     *
     * @return the previously received value of the property 'StockStatus'.
     */
    const StockStatusStatus& getStockStatus() const;

    /**
     * Determines whether a status message for the property 'StockStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStockStatus() const;

    /**
     * Request the value of the property 'StockStatus' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'StockStatus'</b>:
     *
     * Status of all stocks belonging to Favorites list.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStockStatusGet(StockStatusCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Stocks Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Stocks Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Stocks Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Stocks List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Stocks List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Stocks List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Stocks List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    // Property 'SxmStocksDataProviderInfoStatus'

    /**
     * Notify on the property 'SxmStocksDataProviderInfoStatus'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmStocksDataProviderInfoStatus'</b>:
     *
     * Get the Status of Data Provider Information for Stocks Feature
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmStocksDataProviderInfoStatusUpReg(SxmStocksDataProviderInfoStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmStocksDataProviderInfoStatus'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmStocksDataProviderInfoStatus'</b>:
     *
     * Get the Status of Data Provider Information for Stocks Feature
     *
     * @param act The act which was previously returned by the
     * sendSxmStocksDataProviderInfoStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmStocksDataProviderInfoStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmStocksDataProviderInfoStatus'.
     */
    void sendSxmStocksDataProviderInfoStatusRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'SxmStocksDataProviderInfoStatus' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasSxmStocksDataProviderInfoStatus() returns true.
     *
     * @return the previously received value of the property 'SxmStocksDataProviderInfoStatus'.
     */
    const SxmStocksDataProviderInfoStatusStatus& getSxmStocksDataProviderInfoStatus() const;

    /**
     * Determines whether a status message for the property 'SxmStocksDataProviderInfoStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmStocksDataProviderInfoStatus() const;

    /**
     * Request the value of the property 'SxmStocksDataProviderInfoStatus'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmStocksDataProviderInfoStatus'</b>:
     *
     * Get the Status of Data Provider Information for Stocks Feature
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmStocksDataProviderInfoStatusGet(SxmStocksDataProviderInfoStatusCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_stocks_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'StockStatus'

    ::asf::core::nullable< StockStatusStatus > _stockStatus;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    // Property 'SxmStocksDataProviderInfoStatus'

    ::asf::core::nullable< SxmStocksDataProviderInfoStatusStatus > _sxmStocksDataProviderInfoStatus;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_stocks_main_fiProxyCallback;
};

} // namespace sxm_stocks_main_fi

#endif // SXM_STOCKS_MAIN_FIPROXY_H
