/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_stocks_main_fiCca.h"
#include "sxm_stocks_main_fiJson.h"
#include "sxm_stocks_main_fiProxy.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_stocks_main_fi {

/*static*/ ::asf::core::Logger Sxm_stocks_main_fiProxy::_logger ("/sxm_stocks_main_fi/Sxm_stocks_main_fiProxy");


class Sxm_stocks_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_stocks_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_stocks_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_stocks_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetFavoriteStockSymbols: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetFavoriteStockSymbolsResult);
                                setActAndLogResult(message, "GetFavoriteStockSymbols", reinterpret_cast<act_t>(this), _logger);
                                ((GetFavoriteStockSymbolsCallbackIF*) _callback)->onGetFavoriteStockSymbolsResult (proxy, ::boost::static_pointer_cast<GetFavoriteStockSymbolsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetFavoriteStockSymbolsError);
                                setActAndLogError(message, "GetFavoriteStockSymbols", reinterpret_cast<act_t>(this), _logger);
                                ((GetFavoriteStockSymbolsCallbackIF*) _callback)->onGetFavoriteStockSymbolsError (proxy, ::boost::static_pointer_cast<GetFavoriteStockSymbolsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AddFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::AddFavoriteResult);
                                setActAndLogResult(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteResult (proxy, ::boost::static_pointer_cast<AddFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::AddFavoriteError);
                                setActAndLogError(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, ::boost::static_pointer_cast<AddFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RemoveFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::RemoveFavoriteResult);
                                setActAndLogResult(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteResult (proxy, ::boost::static_pointer_cast<RemoveFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::RemoveFavoriteError);
                                setActAndLogError(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, ::boost::static_pointer_cast<RemoveFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetStockSymbolsByFilter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetStockSymbolsByFilterResult);
                                setActAndLogResult(message, "GetStockSymbolsByFilter", reinterpret_cast<act_t>(this), _logger);
                                ((GetStockSymbolsByFilterCallbackIF*) _callback)->onGetStockSymbolsByFilterResult (proxy, ::boost::static_pointer_cast<GetStockSymbolsByFilterResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetStockSymbolsByFilterError);
                                setActAndLogError(message, "GetStockSymbolsByFilter", reinterpret_cast<act_t>(this), _logger);
                                ((GetStockSymbolsByFilterCallbackIF*) _callback)->onGetStockSymbolsByFilterError (proxy, ::boost::static_pointer_cast<GetStockSymbolsByFilterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetDataProviderInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetDataProviderInfoResult);
                                setActAndLogResult(message, "GetDataProviderInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetDataProviderInfoCallbackIF*) _callback)->onGetDataProviderInfoResult (proxy, ::boost::static_pointer_cast<GetDataProviderInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetDataProviderInfoError);
                                setActAndLogError(message, "GetDataProviderInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetDataProviderInfoCallbackIF*) _callback)->onGetDataProviderInfoError (proxy, ::boost::static_pointer_cast<GetDataProviderInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetListsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SetListsConfigResult);
                                setActAndLogResult(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigResult (proxy, ::boost::static_pointer_cast<SetListsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SetListsConfigError);
                                setActAndLogError(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, ::boost::static_pointer_cast<SetListsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetStockSymbolsByFilterPS: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetStockSymbolsByFilterPSResult);
                                setActAndLogResult(message, "GetStockSymbolsByFilterPS", reinterpret_cast<act_t>(this), _logger);
                                ((GetStockSymbolsByFilterPSCallbackIF*) _callback)->onGetStockSymbolsByFilterPSResult (proxy, ::boost::static_pointer_cast<GetStockSymbolsByFilterPSResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::GetStockSymbolsByFilterPSError);
                                setActAndLogError(message, "GetStockSymbolsByFilterPS", reinterpret_cast<act_t>(this), _logger);
                                ((GetStockSymbolsByFilterPSCallbackIF*) _callback)->onGetStockSymbolsByFilterPSError (proxy, ::boost::static_pointer_cast<GetStockSymbolsByFilterPSError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClearAllFavorites: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::ClearAllFavoritesResult);
                                setActAndLogResult(message, "ClearAllFavorites", reinterpret_cast<act_t>(this), _logger);
                                ((ClearAllFavoritesCallbackIF*) _callback)->onClearAllFavoritesResult (proxy, ::boost::static_pointer_cast<ClearAllFavoritesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::ClearAllFavoritesError);
                                setActAndLogError(message, "ClearAllFavorites", reinterpret_cast<act_t>(this), _logger);
                                ((ClearAllFavoritesCallbackIF*) _callback)->onClearAllFavoritesError (proxy, ::boost::static_pointer_cast<ClearAllFavoritesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StockStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::StockStatusStatus);
                                setActAndLogStatus(message, "StockStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StockStatusStatus> payload = ::boost::static_pointer_cast<StockStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StockStatusStatus >& refNullableStatus = proxy->_stockStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StockStatusCallbackIF*) _callback)->onStockStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StockStatusCallbackIF*) _callback)->onStockStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::StockStatusError);
                                setActAndLogError(message, "StockStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StockStatusCallbackIF*) _callback)->onStockStatusError(proxy, ::boost::static_pointer_cast<StockStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmDataServiceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmDataServiceStatusStatus);
                                setActAndLogStatus(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmDataServiceStatusStatus> payload = ::boost::static_pointer_cast<SxmDataServiceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmDataServiceStatusStatus >& refNullableStatus = proxy->_sxmDataServiceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmDataServiceStatusError);
                                setActAndLogError(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError(proxy, ::boost::static_pointer_cast<SxmDataServiceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmListMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmListModeStatus);
                                setActAndLogStatus(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmListModeStatus> payload = ::boost::static_pointer_cast<SxmListModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmListModeStatus >& refNullableStatus = proxy->_sxmListMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmListModeError);
                                setActAndLogError(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError(proxy, ::boost::static_pointer_cast<SxmListModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmStocksDataProviderInfoStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmStocksDataProviderInfoStatusStatus);
                                setActAndLogStatus(message, "SxmStocksDataProviderInfoStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmStocksDataProviderInfoStatusStatus> payload = ::boost::static_pointer_cast<SxmStocksDataProviderInfoStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmStocksDataProviderInfoStatusStatus >& refNullableStatus = proxy->_sxmStocksDataProviderInfoStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmStocksDataProviderInfoStatusCallbackIF*) _callback)->onSxmStocksDataProviderInfoStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmStocksDataProviderInfoStatusCallbackIF*) _callback)->onSxmStocksDataProviderInfoStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_stocks_main_fi::SxmStocksDataProviderInfoStatusError);
                                setActAndLogError(message, "SxmStocksDataProviderInfoStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmStocksDataProviderInfoStatusCallbackIF*) _callback)->onSxmStocksDataProviderInfoStatusError(proxy, ::boost::static_pointer_cast<SxmStocksDataProviderInfoStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_stocks_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_stocks_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetFavoriteStockSymbols: {
                ::boost::shared_ptr< GetFavoriteStockSymbolsError > payload (new GetFavoriteStockSymbolsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetFavoriteStockSymbols", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetFavoriteStockSymbolsCallbackIF*) _callback)->onGetFavoriteStockSymbolsError (proxy, payload);
                return true;
            }
            case FID_AddFavorite: {
                ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, payload);
                return true;
            }
            case FID_RemoveFavorite: {
                ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, payload);
                return true;
            }
            case FID_GetStockSymbolsByFilter: {
                ::boost::shared_ptr< GetStockSymbolsByFilterError > payload (new GetStockSymbolsByFilterError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStockSymbolsByFilter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStockSymbolsByFilterCallbackIF*) _callback)->onGetStockSymbolsByFilterError (proxy, payload);
                return true;
            }
            case FID_GetDataProviderInfo: {
                ::boost::shared_ptr< GetDataProviderInfoError > payload (new GetDataProviderInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDataProviderInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetDataProviderInfoCallbackIF*) _callback)->onGetDataProviderInfoError (proxy, payload);
                return true;
            }
            case FID_SetListsConfig: {
                ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetListsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, payload);
                return true;
            }
            case FID_GetStockSymbolsByFilterPS: {
                ::boost::shared_ptr< GetStockSymbolsByFilterPSError > payload (new GetStockSymbolsByFilterPSError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStockSymbolsByFilterPS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStockSymbolsByFilterPSCallbackIF*) _callback)->onGetStockSymbolsByFilterPSError (proxy, payload);
                return true;
            }
            case FID_ClearAllFavorites: {
                ::boost::shared_ptr< ClearAllFavoritesError > payload (new ClearAllFavoritesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearAllFavorites", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ClearAllFavoritesCallbackIF*) _callback)->onClearAllFavoritesError (proxy, payload);
                return true;
            }
            case FID_StockStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StockStatusError > payload (new StockStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StockStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StockStatusCallbackIF*) _callback)->onStockStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmDataServiceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmListMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmListMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmStocksDataProviderInfoStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusError > payload (new SxmStocksDataProviderInfoStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmStocksDataProviderInfoStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmStocksDataProviderInfoStatusCallbackIF*) _callback)->onSxmStocksDataProviderInfoStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_stocks_main_fiProxyCallback::_logger (Sxm_stocks_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_stocks_main_fiProxy > Sxm_stocks_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_stocks_main_fiProxy >  proxyNew(new Sxm_stocks_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_stocks_main_fiProxy > Sxm_stocks_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_stocks_main_fiProxy >  proxyNew(new Sxm_stocks_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_stocks_main_fiProxy > Sxm_stocks_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_stocks_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_stocks_main_fiProxy >  proxyNew(new Sxm_stocks_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_stocks_main_fiProxy::Sxm_stocks_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_stocks_main_fiProxy::~Sxm_stocks_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_stocks_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_stocks_main_fiProxy::sendGetFavoriteStockSymbolsStart(GetFavoriteStockSymbolsCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetFavoriteStockSymbols);
        ::boost::shared_ptr< GetFavoriteStockSymbolsStart > payload (new GetFavoriteStockSymbolsStart());
        payload->setListID(listID);
        payload->setOperation(operation);
        CCA_MESSAGE(ccaMessage,header,GetFavoriteStockSymbolsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetFavoriteStockSymbols", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetFavoriteStockSymbols);
        ::boost::shared_ptr< GetFavoriteStockSymbolsError > payload (new GetFavoriteStockSymbolsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetFavoriteStockSymbolsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetFavoriteStockSymbols", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendAddFavoriteStart(AddFavoriteCallbackIF& cb, const ::std::string& stockSymbol) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteStart > payload (new AddFavoriteStart());
        payload->setStockSymbol(stockSymbol);
        CCA_MESSAGE(ccaMessage,header,AddFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AddFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AddFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AddFavorite", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, const ::std::string& stockSymbol) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteStart > payload (new RemoveFavoriteStart());
        payload->setStockSymbol(stockSymbol);
        CCA_MESSAGE(ccaMessage,header,RemoveFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RemoveFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoveFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RemoveFavorite", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendGetStockSymbolsByFilterStart(GetStockSymbolsByFilterCallbackIF& cb, const ::std::string& stockFilter) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetStockSymbolsByFilter);
        ::boost::shared_ptr< GetStockSymbolsByFilterStart > payload (new GetStockSymbolsByFilterStart());
        payload->setStockFilter(stockFilter);
        CCA_MESSAGE(ccaMessage,header,GetStockSymbolsByFilterStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStockSymbolsByFilter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetStockSymbolsByFilter);
        ::boost::shared_ptr< GetStockSymbolsByFilterError > payload (new GetStockSymbolsByFilterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStockSymbolsByFilterError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStockSymbolsByFilter", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendGetDataProviderInfoStart(GetDataProviderInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetDataProviderInfo);
        ::boost::shared_ptr< GetDataProviderInfoStart > payload (new GetDataProviderInfoStart());
        CCA_MESSAGE(ccaMessage,header,GetDataProviderInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetDataProviderInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetDataProviderInfo);
        ::boost::shared_ptr< GetDataProviderInfoError > payload (new GetDataProviderInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetDataProviderInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetDataProviderInfo", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigStart > payload (new SetListsConfigStart());
        payload->setConfig(config);
        CCA_MESSAGE(ccaMessage,header,SetListsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetListsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetListsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetListsConfig", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendGetStockSymbolsByFilterPSStart(GetStockSymbolsByFilterPSCallbackIF& cb, const ::std::string& stockFilter, bool isBackSpace) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetStockSymbolsByFilterPS);
        ::boost::shared_ptr< GetStockSymbolsByFilterPSStart > payload (new GetStockSymbolsByFilterPSStart());
        payload->setStockFilter(stockFilter);
        payload->setIsBackSpace(isBackSpace);
        CCA_MESSAGE(ccaMessage,header,GetStockSymbolsByFilterPSStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStockSymbolsByFilterPS", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetStockSymbolsByFilterPS);
        ::boost::shared_ptr< GetStockSymbolsByFilterPSError > payload (new GetStockSymbolsByFilterPSError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStockSymbolsByFilterPSError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStockSymbolsByFilterPS", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendClearAllFavoritesStart(ClearAllFavoritesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ClearAllFavorites);
        ::boost::shared_ptr< ClearAllFavoritesStart > payload (new ClearAllFavoritesStart());
        CCA_MESSAGE(ccaMessage,header,ClearAllFavoritesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ClearAllFavorites", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearAllFavorites);
        ::boost::shared_ptr< ClearAllFavoritesError > payload (new ClearAllFavoritesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearAllFavoritesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ClearAllFavorites", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendStockStatusUpReg(StockStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StockStatus);
        ::boost::shared_ptr< StockStatusUpReg > payload (new StockStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,StockStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StockStatusRelUpReg > payloadRelUpRegHeap (new StockStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StockStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_stocks_main_fi::StockStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StockStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StockStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StockStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStockStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StockStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StockStatusStatus > payloadLoopback (new StockStatusStatus(getStockStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StockStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StockStatus);
        ::boost::shared_ptr< StockStatusError > payload (new StockStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StockStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StockStatus", &cb);
    }
}

bool Sxm_stocks_main_fiProxy::sendStockStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StockStatus,"StockStatus");
}

void Sxm_stocks_main_fiProxy::sendStockStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StockStatus);
}

const StockStatusStatus& Sxm_stocks_main_fiProxy::getStockStatus() const {
    return _stockStatus.get();
}

bool Sxm_stocks_main_fiProxy::hasStockStatus() const {
    return _stockStatus.hasValue();
}

act_t Sxm_stocks_main_fiProxy::sendStockStatusGet(StockStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StockStatus);
        ::boost::shared_ptr< StockStatusGet > payload (new StockStatusGet());
        CCA_MESSAGE(ccaMessage,header,StockStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StockStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StockStatus);
        ::boost::shared_ptr< StockStatusError > payload (new StockStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StockStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StockStatus", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusUpReg > payload (new SxmDataServiceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmDataServiceStatusRelUpReg > payloadRelUpRegHeap (new SxmDataServiceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmDataServiceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_stocks_main_fi::SxmDataServiceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmDataServiceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmDataServiceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmDataServiceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmDataServiceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmDataServiceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmDataServiceStatusStatus > payloadLoopback (new SxmDataServiceStatusStatus(getSxmDataServiceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmDataServiceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

bool Sxm_stocks_main_fiProxy::sendSxmDataServiceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmDataServiceStatus,"SxmDataServiceStatus");
}

void Sxm_stocks_main_fiProxy::sendSxmDataServiceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmDataServiceStatus);
}

const SxmDataServiceStatusStatus& Sxm_stocks_main_fiProxy::getSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.get();
}

bool Sxm_stocks_main_fiProxy::hasSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.hasValue();
}

act_t Sxm_stocks_main_fiProxy::sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusGet > payload (new SxmDataServiceStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmDataServiceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendSxmListModeUpReg(SxmListModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeUpReg > payload (new SxmListModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmListModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmListModeRelUpReg > payloadRelUpRegHeap (new SxmListModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmListMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_stocks_main_fi::SxmListModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmListMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmListMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmListMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmListMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmListMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmListModeStatus > payloadLoopback (new SxmListModeStatus(getSxmListMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmListModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmListMode", &cb);
    }
}

bool Sxm_stocks_main_fiProxy::sendSxmListModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmListMode,"SxmListMode");
}

void Sxm_stocks_main_fiProxy::sendSxmListModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmListMode);
}

const SxmListModeStatus& Sxm_stocks_main_fiProxy::getSxmListMode() const {
    return _sxmListMode.get();
}

bool Sxm_stocks_main_fiProxy::hasSxmListMode() const {
    return _sxmListMode.hasValue();
}

act_t Sxm_stocks_main_fiProxy::sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeSet > payload (new SxmListModeSet());
        payload->setListMode(listMode);
        CCA_MESSAGE(ccaMessage,header,SxmListModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SxmListMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SxmListMode", &cb);
    }
}

act_t Sxm_stocks_main_fiProxy::sendSxmStocksDataProviderInfoStatusUpReg(SxmStocksDataProviderInfoStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmStocksDataProviderInfoStatus);
        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusUpReg > payload (new SxmStocksDataProviderInfoStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmStocksDataProviderInfoStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusRelUpReg > payloadRelUpRegHeap (new SxmStocksDataProviderInfoStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmStocksDataProviderInfoStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_stocks_main_fi::SxmStocksDataProviderInfoStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmStocksDataProviderInfoStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmStocksDataProviderInfoStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmStocksDataProviderInfoStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmStocksDataProviderInfoStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmStocksDataProviderInfoStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmStocksDataProviderInfoStatusStatus > payloadLoopback (new SxmStocksDataProviderInfoStatusStatus(getSxmStocksDataProviderInfoStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmStocksDataProviderInfoStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmStocksDataProviderInfoStatus);
        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusError > payload (new SxmStocksDataProviderInfoStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmStocksDataProviderInfoStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmStocksDataProviderInfoStatus", &cb);
    }
}

bool Sxm_stocks_main_fiProxy::sendSxmStocksDataProviderInfoStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmStocksDataProviderInfoStatus,"SxmStocksDataProviderInfoStatus");
}

void Sxm_stocks_main_fiProxy::sendSxmStocksDataProviderInfoStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmStocksDataProviderInfoStatus);
}

const SxmStocksDataProviderInfoStatusStatus& Sxm_stocks_main_fiProxy::getSxmStocksDataProviderInfoStatus() const {
    return _sxmStocksDataProviderInfoStatus.get();
}

bool Sxm_stocks_main_fiProxy::hasSxmStocksDataProviderInfoStatus() const {
    return _sxmStocksDataProviderInfoStatus.hasValue();
}

act_t Sxm_stocks_main_fiProxy::sendSxmStocksDataProviderInfoStatusGet(SxmStocksDataProviderInfoStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmStocksDataProviderInfoStatus);
        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusGet > payload (new SxmStocksDataProviderInfoStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmStocksDataProviderInfoStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmStocksDataProviderInfoStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmStocksDataProviderInfoStatus);
        ::boost::shared_ptr< SxmStocksDataProviderInfoStatusError > payload (new SxmStocksDataProviderInfoStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmStocksDataProviderInfoStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmStocksDataProviderInfoStatus", &cb);
    }
}


void Sxm_stocks_main_fiProxy::clearAllProperties ()
{
    _stockStatus = ::asf::core::nullable<StockStatusStatus>();
    _sxmDataServiceStatus = ::asf::core::nullable<SxmDataServiceStatusStatus>();
    _sxmListMode = ::asf::core::nullable<SxmListModeStatus>();
    _sxmStocksDataProviderInfoStatus = ::asf::core::nullable<SxmStocksDataProviderInfoStatusStatus>();
}

void Sxm_stocks_main_fiProxy::sendRelUpRegAll()
{
    sendStockStatusRelUpRegAll();
    sendSxmDataServiceStatusRelUpRegAll();
    sendSxmListModeRelUpRegAll();
    sendSxmStocksDataProviderInfoStatusRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_stocks_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_stocks_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_stocks_main_fi
