#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_MAIN_FI_TYPES_H
#define SXM_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types sxm_main_fi_types
 */

namespace sxm_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SxmListMode;

class T_SxmLocation;

class T_SxmListInfo;

class T_SxmListsConfig;

class T_SxmListInfos;

class T_SxmDataSrvState;

class T_SxmListElemDataSrvState;

class T_RGBAcolor;


/**
 * If the meaning of "T_SxmListMode" isn't clear, then there should be a description here.
 */
class T_SxmListMode {
public:

    /**
     * Default constructor
     */
    inline  T_SxmListMode ();

    /**
     * Copy constructor
     */
    inline  T_SxmListMode (const T_SxmListMode &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmListMode (uint32 ListID_, T_e8_SxmListMode Mode_);

    /**
     * Destructor
     */
    inline  ~T_SxmListMode();

    /**
     * Assignment operator
     */
    inline T_SxmListMode& operator = (const T_SxmListMode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmListMode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmListMode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmListMode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmListMode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Index to access the list, values 0-2 according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Index to access the list, values 0-2 according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Mode"

    static const int kMode = 1;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * Mode of list
     *
     * @return The value of the field "Mode"
     */
    inline T_e8_SxmListMode getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * Mode of list
     *
     * @param Mode The value which will be set
     */
    inline void setMode (T_e8_SxmListMode Mode_);

    static const T_SxmListMode &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ListID;

    T_e8_SxmListMode _Mode;

};

/**
 * If the meaning of "T_SxmLocation" isn't clear, then there should be a description here.
 */
class T_SxmLocation {
public:

    /**
     * Default constructor
     */
    inline  T_SxmLocation ();

    /**
     * Copy constructor
     */
    inline  T_SxmLocation (const T_SxmLocation &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmLocation (int32 Lat_, int32 Lon_, uint32 Radius_);

    /**
     * Destructor
     */
    inline  ~T_SxmLocation();

    /**
     * Assignment operator
     */
    inline T_SxmLocation& operator = (const T_SxmLocation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmLocation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmLocation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmLocation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmLocation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Lat"

    static const int kLat = 0;

    /**
     * Clears the field "Lat".
     *
     * The field will be set to its default value. The hasLat()
     * method will return false.
     */
    inline void clearLat();

    /**
     * Checks whether the field "Lat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLat()). Otherwise it will return false.
     */
    inline bool hasLat () const;

    /**
     * Returns the value of the member "Lat".
     *
     * Latitude
     *
     * @return The value of the field "Lat"
     */
    inline int32 getLat () const;

    /**
     * Sets the value of the member "Lat".
     *
     * Latitude
     *
     * @param Lat The value which will be set
     */
    inline void setLat (int32 Lat_);

    // API of field "Lon"

    static const int kLon = 1;

    /**
     * Clears the field "Lon".
     *
     * The field will be set to its default value. The hasLon()
     * method will return false.
     */
    inline void clearLon();

    /**
     * Checks whether the field "Lon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLon()). Otherwise it will return false.
     */
    inline bool hasLon () const;

    /**
     * Returns the value of the member "Lon".
     *
     * Longitude
     *
     * @return The value of the field "Lon"
     */
    inline int32 getLon () const;

    /**
     * Sets the value of the member "Lon".
     *
     * Longitude
     *
     * @param Lon The value which will be set
     */
    inline void setLon (int32 Lon_);

    // API of field "Radius"

    static const int kRadius = 2;

    /**
     * Clears the field "Radius".
     *
     * The field will be set to its default value. The hasRadius()
     * method will return false.
     */
    inline void clearRadius();

    /**
     * Checks whether the field "Radius" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadius()). Otherwise it will return false.
     */
    inline bool hasRadius () const;

    /**
     * Returns the value of the member "Radius".
     *
     * Radius
     *
     * @return The value of the field "Radius"
     */
    inline uint32 getRadius () const;

    /**
     * Sets the value of the member "Radius".
     *
     * Radius
     *
     * @param Radius The value which will be set
     */
    inline void setRadius (uint32 Radius_);

    static const T_SxmLocation &getDefaultInstance();

private:

    inline void set_has_Lat ();

    inline void clear_has_Lat ();

    inline void set_has_Lon ();

    inline void clear_has_Lon ();

    inline void set_has_Radius ();

    inline void clear_has_Radius ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _Lat;

    int32 _Lon;

    uint32 _Radius;

};

/**
 * If the meaning of "T_SxmListInfo" isn't clear, then there should be a description here.
 */
class T_SxmListInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SxmListInfo ();

    /**
     * Copy constructor
     */
    inline  T_SxmListInfo (const T_SxmListInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmListInfo (uint32 ListID_, T_e8_SxmListType ListType_, T_e8_SxmListStatus Status_, T_e8_SxmListStatus State_, T_e8_SxmListMode Mode_, bool bEmpty_, uint32 Size_);

    /**
     * Destructor
     */
    inline  ~T_SxmListInfo();

    /**
     * Assignment operator
     */
    inline T_SxmListInfo& operator = (const T_SxmListInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmListInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmListInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmListInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmListInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Index to acces the list, values 0-2 according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Index to acces the list, values 0-2 according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "ListType"

    static const int kListType = 1;

    /**
     * Clears the field "ListType".
     *
     * The field will be set to its default value. The hasListType()
     * method will return false.
     */
    inline void clearListType();

    /**
     * Checks whether the field "ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListType()). Otherwise it will return false.
     */
    inline bool hasListType () const;

    /**
     * Returns the value of the member "ListType".
     *
     * Type of list
     *
     * @return The value of the field "ListType"
     */
    inline T_e8_SxmListType getListType () const;

    /**
     * Sets the value of the member "ListType".
     *
     * Type of list
     *
     * @param ListType The value which will be set
     */
    inline void setListType (T_e8_SxmListType ListType_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of list
     *
     * @return The value of the field "Status"
     */
    inline T_e8_SxmListStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of list
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_e8_SxmListStatus Status_);

    // API of field "State"

    static const int kState = 3;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Status of list,deprecated,not in use
     *
     * @return The value of the field "State"
     */
    inline T_e8_SxmListStatus getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Status of list,deprecated,not in use
     *
     * @param State The value which will be set
     */
    inline void setState (T_e8_SxmListStatus State_);

    // API of field "Mode"

    static const int kMode = 4;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * Mode of list
     *
     * @return The value of the field "Mode"
     */
    inline T_e8_SxmListMode getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * Mode of list
     *
     * @param Mode The value which will be set
     */
    inline void setMode (T_e8_SxmListMode Mode_);

    // API of field "bEmpty"

    static const int kBEmpty = 5;

    /**
     * Clears the field "bEmpty".
     *
     * The field will be set to its default value. The hasBEmpty()
     * method will return false.
     */
    inline void clearBEmpty();

    /**
     * Checks whether the field "bEmpty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEmpty()). Otherwise it will return false.
     */
    inline bool hasBEmpty () const;

    /**
     * Returns the value of the member "bEmpty".
     *
     * TRUE if list is empty,deprecated,not in use
     *
     * @return The value of the field "bEmpty"
     */
    inline bool getBEmpty () const;

    /**
     * Sets the value of the member "bEmpty".
     *
     * TRUE if list is empty,deprecated,not in use
     *
     * @param bEmpty The value which will be set
     */
    inline void setBEmpty (bool bEmpty_);

    // API of field "Size"

    static const int kSize = 6;

    /**
     * Clears the field "Size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "Size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "Size".
     *
     * Size of the list
     *
     * @return The value of the field "Size"
     */
    inline uint32 getSize () const;

    /**
     * Sets the value of the member "Size".
     *
     * Size of the list
     *
     * @param Size The value which will be set
     */
    inline void setSize (uint32 Size_);

    static const T_SxmListInfo &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_ListType ();

    inline void clear_has_ListType ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    inline void set_has_bEmpty ();

    inline void clear_has_bEmpty ();

    inline void set_has_Size ();

    inline void clear_has_Size ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _ListID;

    T_e8_SxmListType _ListType;

    T_e8_SxmListStatus _Status;

    T_e8_SxmListStatus _State;

    T_e8_SxmListMode _Mode;

    bool _bEmpty;

    uint32 _Size;

};

/**
 * generic configuration of lists of a service
 */
class T_SxmListsConfig {
public:

    /**
     * Default constructor
     */
    inline  T_SxmListsConfig ();

    /**
     * Copy constructor
     */
    inline  T_SxmListsConfig (const T_SxmListsConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmListsConfig (uint32 Capacity_);

    /**
     * Destructor
     */
    inline  ~T_SxmListsConfig();

    /**
     * Assignment operator
     */
    inline T_SxmListsConfig& operator = (const T_SxmListsConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmListsConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmListsConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmListsConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmListsConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Capacity"

    static const int kCapacity = 0;

    /**
     * Clears the field "Capacity".
     *
     * The field will be set to its default value. The hasCapacity()
     * method will return false.
     */
    inline void clearCapacity();

    /**
     * Checks whether the field "Capacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCapacity()). Otherwise it will return false.
     */
    inline bool hasCapacity () const;

    /**
     * Returns the value of the member "Capacity".
     *
     * Capacity of lists
     *
     * @return The value of the field "Capacity"
     */
    inline uint32 getCapacity () const;

    /**
     * Sets the value of the member "Capacity".
     *
     * Capacity of lists
     *
     * @param Capacity The value which will be set
     */
    inline void setCapacity (uint32 Capacity_);

    static const T_SxmListsConfig &getDefaultInstance();

private:

    inline void set_has_Capacity ();

    inline void clear_has_Capacity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Capacity;

};

/**
 * List containing status of lists
 */
class T_SxmListInfos {
public:

    /**
     * Default constructor
     */
    inline  T_SxmListInfos ();

    /**
     * Copy constructor
     */
    inline  T_SxmListInfos (const T_SxmListInfos &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmListInfos (const T_SxmListsConfig& GenericConfig_, const ::std::vector< T_SxmListInfo >& ListInfo_);

    /**
     * Destructor
     */
    inline  ~T_SxmListInfos();

    /**
     * Assignment operator
     */
    inline T_SxmListInfos& operator = (const T_SxmListInfos& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmListInfos& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmListInfos& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmListInfos& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmListInfos& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GenericConfig"

    static const int kGenericConfig = 0;

    /**
     * Clears the field "GenericConfig".
     *
     * The field will be set to its default value. The hasGenericConfig()
     * method will return false.
     */
    inline void clearGenericConfig();

    /**
     * Checks whether the field "GenericConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGenericConfig()). Otherwise it will return false.
     */
    inline bool hasGenericConfig () const;

    /**
     * Returns the value of the member "GenericConfig".
     *
     * Capacity of lists
     *
     * @return The value of the field "GenericConfig"
     */
    inline const T_SxmListsConfig& getGenericConfig () const;

    /**
     * Retrieves the value of the field "GenericConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GenericConfig".
     */
    inline T_SxmListsConfig& getGenericConfigMutable ();

    /**
     * Sets the value of the member "GenericConfig".
     *
     * Capacity of lists
     *
     * @param GenericConfig The value which will be set
     */
    inline void setGenericConfig (const T_SxmListsConfig& GenericConfig_);

    // API of field "ListInfo"

    static const int kListInfo = 1;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * List Info
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::std::vector< T_SxmListInfo >& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::std::vector< T_SxmListInfo >& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * List Info
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::std::vector< T_SxmListInfo >& ListInfo_);

    static const T_SxmListInfos &getDefaultInstance();

private:

    static const ::std::vector< T_SxmListInfo >& getT_SxmListInfoList_DefaultInstance ();

    inline void set_has_GenericConfig ();

    inline void clear_has_GenericConfig ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_SxmListsConfig _GenericConfig;

    ::std::vector< T_SxmListInfo > _ListInfo;

};

/**
 * If the meaning of "T_SxmDataSrvState" isn't clear, then there should be a description here.
 */
class T_SxmDataSrvState {
public:

    /**
     * Default constructor
     */
    inline  T_SxmDataSrvState ();

    /**
     * Copy constructor
     */
    inline  T_SxmDataSrvState (const T_SxmDataSrvState &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmDataSrvState (T_e8_SxmDataServiceStatus Status_);

    /**
     * Destructor
     */
    inline  ~T_SxmDataSrvState();

    /**
     * Assignment operator
     */
    inline T_SxmDataSrvState& operator = (const T_SxmDataSrvState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmDataSrvState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmDataSrvState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmDataSrvState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmDataSrvState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of data service
     *
     * @return The value of the field "Status"
     */
    inline T_e8_SxmDataServiceStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of data service
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_e8_SxmDataServiceStatus Status_);

    static const T_SxmDataSrvState &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_SxmDataServiceStatus _Status;

};

/**
 * If the meaning of "T_SxmListElemDataSrvState" isn't clear, then there should be a description here.
 */
class T_SxmListElemDataSrvState {
public:

    /**
     * Default constructor
     */
    inline  T_SxmListElemDataSrvState ();

    /**
     * Copy constructor
     */
    inline  T_SxmListElemDataSrvState (const T_SxmListElemDataSrvState &rhs);

    /**
     * All fields constructor
     */
    inline  T_SxmListElemDataSrvState (T_e8_SxmDataServiceType Type_, const T_SxmDataSrvState& Status_);

    /**
     * Destructor
     */
    inline  ~T_SxmListElemDataSrvState();

    /**
     * Assignment operator
     */
    inline T_SxmListElemDataSrvState& operator = (const T_SxmListElemDataSrvState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SxmListElemDataSrvState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SxmListElemDataSrvState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SxmListElemDataSrvState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SxmListElemDataSrvState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * Status of data service
     *
     * @return The value of the field "Type"
     */
    inline T_e8_SxmDataServiceType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * Status of data service
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8_SxmDataServiceType Type_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of data service
     *
     * @return The value of the field "Status"
     */
    inline const T_SxmDataSrvState& getStatus () const;

    /**
     * Retrieves the value of the field "Status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Status".
     */
    inline T_SxmDataSrvState& getStatusMutable ();

    /**
     * Sets the value of the member "Status".
     *
     * Status of data service
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const T_SxmDataSrvState& Status_);

    static const T_SxmListElemDataSrvState &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_SxmDataServiceType _Type;

    T_SxmDataSrvState _Status;

};

/**
 * Contains RGBA value of a color description
 */
class T_RGBAcolor {
public:

    /**
     * Default constructor
     */
    inline  T_RGBAcolor ();

    /**
     * Copy constructor
     */
    inline  T_RGBAcolor (const T_RGBAcolor &rhs);

    /**
     * All fields constructor
     */
    inline  T_RGBAcolor (uint8 Red_, uint8 Green_, uint8 Blue_, uint8 Alpha_);

    /**
     * Destructor
     */
    inline  ~T_RGBAcolor();

    /**
     * Assignment operator
     */
    inline T_RGBAcolor& operator = (const T_RGBAcolor& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RGBAcolor& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RGBAcolor& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RGBAcolor& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RGBAcolor& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Red"

    static const int kRed = 0;

    /**
     * Clears the field "Red".
     *
     * The field will be set to its default value. The hasRed()
     * method will return false.
     */
    inline void clearRed();

    /**
     * Checks whether the field "Red" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRed()). Otherwise it will return false.
     */
    inline bool hasRed () const;

    /**
     * Returns the value of the member "Red".
     *
     * Red value of the color
     *
     * @return The value of the field "Red"
     */
    inline uint8 getRed () const;

    /**
     * Sets the value of the member "Red".
     *
     * Red value of the color
     *
     * @param Red The value which will be set
     */
    inline void setRed (uint8 Red_);

    // API of field "Green"

    static const int kGreen = 1;

    /**
     * Clears the field "Green".
     *
     * The field will be set to its default value. The hasGreen()
     * method will return false.
     */
    inline void clearGreen();

    /**
     * Checks whether the field "Green" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGreen()). Otherwise it will return false.
     */
    inline bool hasGreen () const;

    /**
     * Returns the value of the member "Green".
     *
     * Green value of the color
     *
     * @return The value of the field "Green"
     */
    inline uint8 getGreen () const;

    /**
     * Sets the value of the member "Green".
     *
     * Green value of the color
     *
     * @param Green The value which will be set
     */
    inline void setGreen (uint8 Green_);

    // API of field "Blue"

    static const int kBlue = 2;

    /**
     * Clears the field "Blue".
     *
     * The field will be set to its default value. The hasBlue()
     * method will return false.
     */
    inline void clearBlue();

    /**
     * Checks whether the field "Blue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlue()). Otherwise it will return false.
     */
    inline bool hasBlue () const;

    /**
     * Returns the value of the member "Blue".
     *
     * Blue value of the color
     *
     * @return The value of the field "Blue"
     */
    inline uint8 getBlue () const;

    /**
     * Sets the value of the member "Blue".
     *
     * Blue value of the color
     *
     * @param Blue The value which will be set
     */
    inline void setBlue (uint8 Blue_);

    // API of field "Alpha"

    static const int kAlpha = 3;

    /**
     * Clears the field "Alpha".
     *
     * The field will be set to its default value. The hasAlpha()
     * method will return false.
     */
    inline void clearAlpha();

    /**
     * Checks whether the field "Alpha" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlpha()). Otherwise it will return false.
     */
    inline bool hasAlpha () const;

    /**
     * Returns the value of the member "Alpha".
     *
     * Alpha channel value of the color
     *
     * @return The value of the field "Alpha"
     */
    inline uint8 getAlpha () const;

    /**
     * Sets the value of the member "Alpha".
     *
     * Alpha channel value of the color
     *
     * @param Alpha The value which will be set
     */
    inline void setAlpha (uint8 Alpha_);

    static const T_RGBAcolor &getDefaultInstance();

private:

    inline void set_has_Red ();

    inline void clear_has_Red ();

    inline void set_has_Green ();

    inline void clear_has_Green ();

    inline void set_has_Blue ();

    inline void clear_has_Blue ();

    inline void set_has_Alpha ();

    inline void clear_has_Alpha ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _Red;

    uint8 _Green;

    uint8 _Blue;

    uint8 _Alpha;

};

inline  T_SxmListMode::T_SxmListMode ()  :
    _ListID (0u),
    _Mode (::sxm_main_fi_types::T_e8_SxmListMode__RELEASE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmListMode::T_SxmListMode (const T_SxmListMode &rhs)  :
    _ListID (0u),
    _Mode (::sxm_main_fi_types::T_e8_SxmListMode__RELEASE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmListMode::T_SxmListMode (uint32 ListID_, T_e8_SxmListMode Mode_)  :
    _ListID (ListID_),
    _Mode (Mode_)
{
    #ifndef NDEBUG
    if (!(T_e8_SxmListMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_SxmListMode", "Mode", "T_SxmListMode");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmListMode::~T_SxmListMode() {
}

inline T_SxmListMode& T_SxmListMode::operator = (const T_SxmListMode& rhs) {
    if( this != &rhs ) {
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool T_SxmListMode::operator == (const T_SxmListMode& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool T_SxmListMode::operator != (const T_SxmListMode& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmListMode::operator < (const T_SxmListMode& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if ((uint32)getMode() < (uint32)rhs.getMode()) return true;
        if ((uint32)getMode() > (uint32)rhs.getMode()) return false;
    }
    return false;
}

inline bool T_SxmListMode::operator > (const T_SxmListMode& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmListMode::clear() {
    clearListID();
    clearMode();
}

inline void T_SxmListMode::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool T_SxmListMode::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SxmListMode::getListID () const {
    return _ListID;
}

inline void T_SxmListMode::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void T_SxmListMode::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = ::sxm_main_fi_types::T_e8_SxmListMode__RELEASE;
     }
}

inline bool T_SxmListMode::hasMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_SxmListMode T_SxmListMode::getMode () const {
    return _Mode;
}

inline void T_SxmListMode::setMode (T_e8_SxmListMode Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmListMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_SxmListMode", "Mode", "T_SxmListMode");
    }
    #endif
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void T_SxmListMode::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmListMode::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmListMode::set_has_Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmListMode::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SxmLocation::T_SxmLocation ()  :
    _Lat (0),
    _Lon (0),
    _Radius (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmLocation::T_SxmLocation (const T_SxmLocation &rhs)  :
    _Lat (0),
    _Lon (0),
    _Radius (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmLocation::T_SxmLocation (int32 Lat_, int32 Lon_, uint32 Radius_)  :
    _Lat (Lat_),
    _Lon (Lon_),
    _Radius (Radius_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmLocation::~T_SxmLocation() {
}

inline T_SxmLocation& T_SxmLocation::operator = (const T_SxmLocation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLat()) {
            setLat(rhs.getLat());
        } else {
            clearLat();
        }
        if (rhs.hasLon()) {
            setLon(rhs.getLon());
        } else {
            clearLon();
        }
        if (rhs.hasRadius()) {
            setRadius(rhs.getRadius());
        } else {
            clearRadius();
        }
    }
    return *this;
}

inline bool T_SxmLocation::operator == (const T_SxmLocation& rhs) const {
    return (((!hasLat() && !rhs.hasLat()) || getLat() == rhs.getLat()) &&
        ((!hasLon() && !rhs.hasLon()) || getLon() == rhs.getLon()) &&
        ((!hasRadius() && !rhs.hasRadius()) || getRadius() == rhs.getRadius()));
}

inline bool T_SxmLocation::operator != (const T_SxmLocation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmLocation::operator < (const T_SxmLocation& rhs) const {
    if (hasLat() || rhs.hasLat()) {
        if (getLat() < rhs.getLat()) return true;
        if (getLat() > rhs.getLat()) return false;
    }
    if (hasLon() || rhs.hasLon()) {
        if (getLon() < rhs.getLon()) return true;
        if (getLon() > rhs.getLon()) return false;
    }
    if (hasRadius() || rhs.hasRadius()) {
        if (getRadius() < rhs.getRadius()) return true;
        if (getRadius() > rhs.getRadius()) return false;
    }
    return false;
}

inline bool T_SxmLocation::operator > (const T_SxmLocation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmLocation::clear() {
    clearLat();
    clearLon();
    clearRadius();
}

inline void T_SxmLocation::clearLat() {
    if (hasLat()) {
         clear_has_Lat();
        _Lat = 0;
     }
}

inline bool T_SxmLocation::hasLat () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 T_SxmLocation::getLat () const {
    return _Lat;
}

inline void T_SxmLocation::setLat (int32 Lat_) {
    set_has_Lat();
    this->_Lat = Lat_;
}

inline void T_SxmLocation::clearLon() {
    if (hasLon()) {
         clear_has_Lon();
        _Lon = 0;
     }
}

inline bool T_SxmLocation::hasLon () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_SxmLocation::getLon () const {
    return _Lon;
}

inline void T_SxmLocation::setLon (int32 Lon_) {
    set_has_Lon();
    this->_Lon = Lon_;
}

inline void T_SxmLocation::clearRadius() {
    if (hasRadius()) {
         clear_has_Radius();
        _Radius = 0u;
     }
}

inline bool T_SxmLocation::hasRadius () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SxmLocation::getRadius () const {
    return _Radius;
}

inline void T_SxmLocation::setRadius (uint32 Radius_) {
    set_has_Radius();
    this->_Radius = Radius_;
}

inline void T_SxmLocation::set_has_Lat () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmLocation::clear_has_Lat () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmLocation::set_has_Lon () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmLocation::clear_has_Lon () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmLocation::set_has_Radius () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmLocation::clear_has_Radius () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SxmListInfo::T_SxmListInfo ()  :
    _ListID (0u),
    _ListType (::sxm_main_fi_types::T_e8_SxmListType__NEAR_BY),
    _Status (::sxm_main_fi_types::T_e8_SxmListStatus__INVALID),
    _State (::sxm_main_fi_types::T_e8_SxmListStatus__INVALID),
    _Mode (::sxm_main_fi_types::T_e8_SxmListMode__RELEASE),
    _bEmpty (false),
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmListInfo::T_SxmListInfo (const T_SxmListInfo &rhs)  :
    _ListID (0u),
    _ListType (::sxm_main_fi_types::T_e8_SxmListType__NEAR_BY),
    _Status (::sxm_main_fi_types::T_e8_SxmListStatus__INVALID),
    _State (::sxm_main_fi_types::T_e8_SxmListStatus__INVALID),
    _Mode (::sxm_main_fi_types::T_e8_SxmListMode__RELEASE),
    _bEmpty (false),
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmListInfo::T_SxmListInfo (uint32 ListID_, T_e8_SxmListType ListType_, T_e8_SxmListStatus Status_, T_e8_SxmListStatus State_, T_e8_SxmListMode Mode_, bool bEmpty_, uint32 Size_)  :
    _ListID (ListID_),
    _ListType (ListType_),
    _Status (Status_),
    _State (State_),
    _Mode (Mode_),
    _bEmpty (bEmpty_),
    _Size (Size_)
{
    #ifndef NDEBUG
    if (!(T_e8_SxmListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "T_e8_SxmListType", "ListType", "T_SxmListInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SxmListStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_SxmListStatus", "Status", "T_SxmListInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SxmListStatus_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_SxmListStatus", "State", "T_SxmListInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SxmListMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_SxmListMode", "Mode", "T_SxmListInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmListInfo::~T_SxmListInfo() {
}

inline T_SxmListInfo& T_SxmListInfo::operator = (const T_SxmListInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasListType()) {
            setListType(rhs.getListType());
        } else {
            clearListType();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
        if (rhs.hasBEmpty()) {
            setBEmpty(rhs.getBEmpty());
        } else {
            clearBEmpty();
        }
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
    }
    return *this;
}

inline bool T_SxmListInfo::operator == (const T_SxmListInfo& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasListType() && !rhs.hasListType()) || getListType() == rhs.getListType()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()) &&
        ((!hasBEmpty() && !rhs.hasBEmpty()) || getBEmpty() == rhs.getBEmpty()) &&
        ((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()));
}

inline bool T_SxmListInfo::operator != (const T_SxmListInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmListInfo::operator < (const T_SxmListInfo& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasListType() || rhs.hasListType()) {
        if ((uint32)getListType() < (uint32)rhs.getListType()) return true;
        if ((uint32)getListType() > (uint32)rhs.getListType()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    if (hasMode() || rhs.hasMode()) {
        if ((uint32)getMode() < (uint32)rhs.getMode()) return true;
        if ((uint32)getMode() > (uint32)rhs.getMode()) return false;
    }
    if (hasBEmpty() || rhs.hasBEmpty()) {
        if (getBEmpty() < rhs.getBEmpty()) return true;
        if (getBEmpty() > rhs.getBEmpty()) return false;
    }
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    return false;
}

inline bool T_SxmListInfo::operator > (const T_SxmListInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmListInfo::clear() {
    clearListID();
    clearListType();
    clearStatus();
    clearState();
    clearMode();
    clearBEmpty();
    clearSize();
}

inline void T_SxmListInfo::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool T_SxmListInfo::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SxmListInfo::getListID () const {
    return _ListID;
}

inline void T_SxmListInfo::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void T_SxmListInfo::clearListType() {
    if (hasListType()) {
         clear_has_ListType();
        _ListType = ::sxm_main_fi_types::T_e8_SxmListType__NEAR_BY;
     }
}

inline bool T_SxmListInfo::hasListType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_SxmListType T_SxmListInfo::getListType () const {
    return _ListType;
}

inline void T_SxmListInfo::setListType (T_e8_SxmListType ListType_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "T_e8_SxmListType", "ListType", "T_SxmListInfo");
    }
    #endif
    set_has_ListType();
    this->_ListType = ListType_;
}

inline void T_SxmListInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::sxm_main_fi_types::T_e8_SxmListStatus__INVALID;
     }
}

inline bool T_SxmListInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SxmListStatus T_SxmListInfo::getStatus () const {
    return _Status;
}

inline void T_SxmListInfo::setStatus (T_e8_SxmListStatus Status_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmListStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_SxmListStatus", "Status", "T_SxmListInfo");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void T_SxmListInfo::clearState() {
    if (hasState()) {
         clear_has_State();
        _State = ::sxm_main_fi_types::T_e8_SxmListStatus__INVALID;
     }
}

inline bool T_SxmListInfo::hasState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SxmListStatus T_SxmListInfo::getState () const {
    return _State;
}

inline void T_SxmListInfo::setState (T_e8_SxmListStatus State_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmListStatus_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_SxmListStatus", "State", "T_SxmListInfo");
    }
    #endif
    set_has_State();
    this->_State = State_;
}

inline void T_SxmListInfo::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = ::sxm_main_fi_types::T_e8_SxmListMode__RELEASE;
     }
}

inline bool T_SxmListInfo::hasMode () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_SxmListMode T_SxmListInfo::getMode () const {
    return _Mode;
}

inline void T_SxmListInfo::setMode (T_e8_SxmListMode Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmListMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_SxmListMode", "Mode", "T_SxmListInfo");
    }
    #endif
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void T_SxmListInfo::clearBEmpty() {
    if (hasBEmpty()) {
         clear_has_bEmpty();
        _bEmpty = false;
     }
}

inline bool T_SxmListInfo::hasBEmpty () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_SxmListInfo::getBEmpty () const {
    return _bEmpty;
}

inline void T_SxmListInfo::setBEmpty (bool bEmpty_) {
    set_has_bEmpty();
    this->_bEmpty = bEmpty_;
}

inline void T_SxmListInfo::clearSize() {
    if (hasSize()) {
         clear_has_Size();
        _Size = 0u;
     }
}

inline bool T_SxmListInfo::hasSize () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_SxmListInfo::getSize () const {
    return _Size;
}

inline void T_SxmListInfo::setSize (uint32 Size_) {
    set_has_Size();
    this->_Size = Size_;
}

inline void T_SxmListInfo::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmListInfo::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmListInfo::set_has_ListType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmListInfo::clear_has_ListType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SxmListInfo::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SxmListInfo::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SxmListInfo::set_has_State () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SxmListInfo::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SxmListInfo::set_has_Mode () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SxmListInfo::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SxmListInfo::set_has_bEmpty () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SxmListInfo::clear_has_bEmpty () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SxmListInfo::set_has_Size () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SxmListInfo::clear_has_Size () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_SxmListsConfig::T_SxmListsConfig ()  :
    _Capacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmListsConfig::T_SxmListsConfig (const T_SxmListsConfig &rhs)  :
    _Capacity (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmListsConfig::T_SxmListsConfig (uint32 Capacity_)  :
    _Capacity (Capacity_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmListsConfig::~T_SxmListsConfig() {
}

inline T_SxmListsConfig& T_SxmListsConfig::operator = (const T_SxmListsConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCapacity()) {
            setCapacity(rhs.getCapacity());
        } else {
            clearCapacity();
        }
    }
    return *this;
}

inline bool T_SxmListsConfig::operator == (const T_SxmListsConfig& rhs) const {
    return (((!hasCapacity() && !rhs.hasCapacity()) || getCapacity() == rhs.getCapacity()));
}

inline bool T_SxmListsConfig::operator != (const T_SxmListsConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmListsConfig::operator < (const T_SxmListsConfig& rhs) const {
    if (hasCapacity() || rhs.hasCapacity()) {
        if (getCapacity() < rhs.getCapacity()) return true;
        if (getCapacity() > rhs.getCapacity()) return false;
    }
    return false;
}

inline bool T_SxmListsConfig::operator > (const T_SxmListsConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmListsConfig::clear() {
    clearCapacity();
}

inline void T_SxmListsConfig::clearCapacity() {
    if (hasCapacity()) {
         clear_has_Capacity();
        _Capacity = 0u;
     }
}

inline bool T_SxmListsConfig::hasCapacity () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SxmListsConfig::getCapacity () const {
    return _Capacity;
}

inline void T_SxmListsConfig::setCapacity (uint32 Capacity_) {
    set_has_Capacity();
    this->_Capacity = Capacity_;
}

inline void T_SxmListsConfig::set_has_Capacity () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmListsConfig::clear_has_Capacity () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_SxmListInfos::T_SxmListInfos ()  :
    _GenericConfig (),
    _ListInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmListInfos::T_SxmListInfos (const T_SxmListInfos &rhs)  :
    _GenericConfig (),
    _ListInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmListInfos::T_SxmListInfos (const T_SxmListsConfig& GenericConfig_, const ::std::vector< T_SxmListInfo >& ListInfo_)  :
    _GenericConfig (GenericConfig_),
    _ListInfo (ListInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmListInfos::~T_SxmListInfos() {
}

inline T_SxmListInfos& T_SxmListInfos::operator = (const T_SxmListInfos& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGenericConfig()) {
            setGenericConfig(rhs.getGenericConfig());
        } else {
            clearGenericConfig();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
    }
    return *this;
}

inline bool T_SxmListInfos::operator == (const T_SxmListInfos& rhs) const {
    return (((!hasGenericConfig() && !rhs.hasGenericConfig()) || getGenericConfig() == rhs.getGenericConfig()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()));
}

inline bool T_SxmListInfos::operator != (const T_SxmListInfos& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmListInfos::operator < (const T_SxmListInfos& rhs) const {
    if (hasGenericConfig() || rhs.hasGenericConfig()) {
        if (getGenericConfig() < rhs.getGenericConfig()) return true;
        if (getGenericConfig() > rhs.getGenericConfig()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    return false;
}

inline bool T_SxmListInfos::operator > (const T_SxmListInfos& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmListInfos::clear() {
    clearGenericConfig();
    clearListInfo();
}

inline void T_SxmListInfos::clearGenericConfig() {
    if (hasGenericConfig()) {
         clear_has_GenericConfig();
        _GenericConfig.clear();
     }
}

inline bool T_SxmListInfos::hasGenericConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_SxmListsConfig& T_SxmListInfos::getGenericConfig () const {
    return _GenericConfig;
}

inline T_SxmListsConfig& T_SxmListInfos::getGenericConfigMutable () {
    set_has_GenericConfig();
    return _GenericConfig;
}

inline void T_SxmListInfos::setGenericConfig (const T_SxmListsConfig& GenericConfig_) {
    set_has_GenericConfig();
    this->_GenericConfig = GenericConfig_;
}

inline void T_SxmListInfos::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool T_SxmListInfos::hasListInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_SxmListInfo >& T_SxmListInfos::getListInfo () const {
    return _ListInfo;
}

inline ::std::vector< T_SxmListInfo >& T_SxmListInfos::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void T_SxmListInfos::setListInfo (const ::std::vector< T_SxmListInfo >& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void T_SxmListInfos::set_has_GenericConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmListInfos::clear_has_GenericConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmListInfos::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmListInfos::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SxmDataSrvState::T_SxmDataSrvState ()  :
    _Status (::sxm_main_fi_types::T_e8_SxmDataServiceStatus__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmDataSrvState::T_SxmDataSrvState (const T_SxmDataSrvState &rhs)  :
    _Status (::sxm_main_fi_types::T_e8_SxmDataServiceStatus__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmDataSrvState::T_SxmDataSrvState (T_e8_SxmDataServiceStatus Status_)  :
    _Status (Status_)
{
    #ifndef NDEBUG
    if (!(T_e8_SxmDataServiceStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_SxmDataServiceStatus", "Status", "T_SxmDataSrvState");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmDataSrvState::~T_SxmDataSrvState() {
}

inline T_SxmDataSrvState& T_SxmDataSrvState::operator = (const T_SxmDataSrvState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_SxmDataSrvState::operator == (const T_SxmDataSrvState& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_SxmDataSrvState::operator != (const T_SxmDataSrvState& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmDataSrvState::operator < (const T_SxmDataSrvState& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_SxmDataSrvState::operator > (const T_SxmDataSrvState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmDataSrvState::clear() {
    clearStatus();
}

inline void T_SxmDataSrvState::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::sxm_main_fi_types::T_e8_SxmDataServiceStatus__UNKNOWN;
     }
}

inline bool T_SxmDataSrvState::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SxmDataServiceStatus T_SxmDataSrvState::getStatus () const {
    return _Status;
}

inline void T_SxmDataSrvState::setStatus (T_e8_SxmDataServiceStatus Status_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmDataServiceStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_SxmDataServiceStatus", "Status", "T_SxmDataSrvState");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void T_SxmDataSrvState::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmDataSrvState::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_SxmListElemDataSrvState::T_SxmListElemDataSrvState ()  :
    _Type (::sxm_main_fi_types::T_e8_SxmDataServiceType__CHANNELART),
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SxmListElemDataSrvState::T_SxmListElemDataSrvState (const T_SxmListElemDataSrvState &rhs)  :
    _Type (::sxm_main_fi_types::T_e8_SxmDataServiceType__CHANNELART),
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SxmListElemDataSrvState::T_SxmListElemDataSrvState (T_e8_SxmDataServiceType Type_, const T_SxmDataSrvState& Status_)  :
    _Type (Type_),
    _Status (Status_)
{
    #ifndef NDEBUG
    if (!(T_e8_SxmDataServiceType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_SxmDataServiceType", "Type", "T_SxmListElemDataSrvState");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SxmListElemDataSrvState::~T_SxmListElemDataSrvState() {
}

inline T_SxmListElemDataSrvState& T_SxmListElemDataSrvState::operator = (const T_SxmListElemDataSrvState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_SxmListElemDataSrvState::operator == (const T_SxmListElemDataSrvState& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_SxmListElemDataSrvState::operator != (const T_SxmListElemDataSrvState& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SxmListElemDataSrvState::operator < (const T_SxmListElemDataSrvState& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_SxmListElemDataSrvState::operator > (const T_SxmListElemDataSrvState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SxmListElemDataSrvState::clear() {
    clearType();
    clearStatus();
}

inline void T_SxmListElemDataSrvState::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sxm_main_fi_types::T_e8_SxmDataServiceType__CHANNELART;
     }
}

inline bool T_SxmListElemDataSrvState::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SxmDataServiceType T_SxmListElemDataSrvState::getType () const {
    return _Type;
}

inline void T_SxmListElemDataSrvState::setType (T_e8_SxmDataServiceType Type_) {
    #ifndef NDEBUG
    if (!(T_e8_SxmDataServiceType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8_SxmDataServiceType", "Type", "T_SxmListElemDataSrvState");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_SxmListElemDataSrvState::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status.clear();
     }
}

inline bool T_SxmListElemDataSrvState::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_SxmDataSrvState& T_SxmListElemDataSrvState::getStatus () const {
    return _Status;
}

inline T_SxmDataSrvState& T_SxmListElemDataSrvState::getStatusMutable () {
    set_has_Status();
    return _Status;
}

inline void T_SxmListElemDataSrvState::setStatus (const T_SxmDataSrvState& Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void T_SxmListElemDataSrvState::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SxmListElemDataSrvState::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SxmListElemDataSrvState::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SxmListElemDataSrvState::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_RGBAcolor::T_RGBAcolor ()  :
    _Red (0u),
    _Green (0u),
    _Blue (0u),
    _Alpha (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RGBAcolor::T_RGBAcolor (const T_RGBAcolor &rhs)  :
    _Red (0u),
    _Green (0u),
    _Blue (0u),
    _Alpha (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RGBAcolor::T_RGBAcolor (uint8 Red_, uint8 Green_, uint8 Blue_, uint8 Alpha_)  :
    _Red (Red_),
    _Green (Green_),
    _Blue (Blue_),
    _Alpha (Alpha_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RGBAcolor::~T_RGBAcolor() {
}

inline T_RGBAcolor& T_RGBAcolor::operator = (const T_RGBAcolor& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRed()) {
            setRed(rhs.getRed());
        } else {
            clearRed();
        }
        if (rhs.hasGreen()) {
            setGreen(rhs.getGreen());
        } else {
            clearGreen();
        }
        if (rhs.hasBlue()) {
            setBlue(rhs.getBlue());
        } else {
            clearBlue();
        }
        if (rhs.hasAlpha()) {
            setAlpha(rhs.getAlpha());
        } else {
            clearAlpha();
        }
    }
    return *this;
}

inline bool T_RGBAcolor::operator == (const T_RGBAcolor& rhs) const {
    return (((!hasRed() && !rhs.hasRed()) || getRed() == rhs.getRed()) &&
        ((!hasGreen() && !rhs.hasGreen()) || getGreen() == rhs.getGreen()) &&
        ((!hasBlue() && !rhs.hasBlue()) || getBlue() == rhs.getBlue()) &&
        ((!hasAlpha() && !rhs.hasAlpha()) || getAlpha() == rhs.getAlpha()));
}

inline bool T_RGBAcolor::operator != (const T_RGBAcolor& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RGBAcolor::operator < (const T_RGBAcolor& rhs) const {
    if (hasRed() || rhs.hasRed()) {
        if (getRed() < rhs.getRed()) return true;
        if (getRed() > rhs.getRed()) return false;
    }
    if (hasGreen() || rhs.hasGreen()) {
        if (getGreen() < rhs.getGreen()) return true;
        if (getGreen() > rhs.getGreen()) return false;
    }
    if (hasBlue() || rhs.hasBlue()) {
        if (getBlue() < rhs.getBlue()) return true;
        if (getBlue() > rhs.getBlue()) return false;
    }
    if (hasAlpha() || rhs.hasAlpha()) {
        if (getAlpha() < rhs.getAlpha()) return true;
        if (getAlpha() > rhs.getAlpha()) return false;
    }
    return false;
}

inline bool T_RGBAcolor::operator > (const T_RGBAcolor& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RGBAcolor::clear() {
    clearRed();
    clearGreen();
    clearBlue();
    clearAlpha();
}

inline void T_RGBAcolor::clearRed() {
    if (hasRed()) {
         clear_has_Red();
        _Red = 0u;
     }
}

inline bool T_RGBAcolor::hasRed () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_RGBAcolor::getRed () const {
    return _Red;
}

inline void T_RGBAcolor::setRed (uint8 Red_) {
    set_has_Red();
    this->_Red = Red_;
}

inline void T_RGBAcolor::clearGreen() {
    if (hasGreen()) {
         clear_has_Green();
        _Green = 0u;
     }
}

inline bool T_RGBAcolor::hasGreen () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_RGBAcolor::getGreen () const {
    return _Green;
}

inline void T_RGBAcolor::setGreen (uint8 Green_) {
    set_has_Green();
    this->_Green = Green_;
}

inline void T_RGBAcolor::clearBlue() {
    if (hasBlue()) {
         clear_has_Blue();
        _Blue = 0u;
     }
}

inline bool T_RGBAcolor::hasBlue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_RGBAcolor::getBlue () const {
    return _Blue;
}

inline void T_RGBAcolor::setBlue (uint8 Blue_) {
    set_has_Blue();
    this->_Blue = Blue_;
}

inline void T_RGBAcolor::clearAlpha() {
    if (hasAlpha()) {
         clear_has_Alpha();
        _Alpha = 0u;
     }
}

inline bool T_RGBAcolor::hasAlpha () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_RGBAcolor::getAlpha () const {
    return _Alpha;
}

inline void T_RGBAcolor::setAlpha (uint8 Alpha_) {
    set_has_Alpha();
    this->_Alpha = Alpha_;
}

inline void T_RGBAcolor::set_has_Red () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RGBAcolor::clear_has_Red () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RGBAcolor::set_has_Green () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RGBAcolor::clear_has_Green () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RGBAcolor::set_has_Blue () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RGBAcolor::clear_has_Blue () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RGBAcolor::set_has_Alpha () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RGBAcolor::clear_has_Alpha () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace sxm_main_fi_types

#endif // SXM_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
