/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "sxm_sports_main_fi_types.h"
#include "sxm_sports_main_fi_typesConst.h"
#include "sxm_sports_main_fi_typesJson.h"
#include "sxm_sports_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_SportInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_SportInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasSportName()) {
        yajl_gen_string(g, (const unsigned char*)  "SportName" , 9);
        const char *s = value.getSportName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_SportInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RootAffiliateList"

void serializeJson (const ::sxm_sports_main_fi_types::T_RootAffiliateList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasRootAffiliateList()) {
        yajl_gen_string(g, (const unsigned char*)  "RootAffiliateList" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_AffiliateInfo >& o1 = value.getRootAffiliateList();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_AffiliateInfo >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_RootAffiliateList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AffiliateInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasAffiliateName()) {
        yajl_gen_string(g, (const unsigned char*)  "AffiliateName" , 13);
        const char *s = value.getAffiliateName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInSeason()) {
        yajl_gen_string(g, (const unsigned char*)  "InSeason" , 8);
        yajl_gen_bool(g, (bool)value.getInSeason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AffiliateDetails"

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateDetails& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasAffiliateDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "AffiliateDetails" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_AffiliateDetailInfo >& o3 = value.getAffiliateDetails();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_AffiliateDetailInfo >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateDetails& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AffiliateDetailInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateDetailInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCategory_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Category_ID" , 11);
        const char* s = ::sxm_sports_main_fi_types::T_AffiliateCategories_Name(value.getCategory_ID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCategory_ID());
    }
    if (!isSparse || value.hasIsDataAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "isDataAvailable" , 15);
        const char* s = ::sxm_sports_main_fi_types::T_e8CategoryAvailability_Name(value.getIsDataAvailable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getIsDataAvailable());
    }
    if (!isSparse || value.hasSUB_LEAGUE_INFO()) {
        yajl_gen_string(g, (const unsigned char*)  "SUB_LEAGUE_INFO" , 15);
        serializeJson(value.getSUB_LEAGUE_INFO(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_AffiliateDetailInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SubLeagues"

void serializeJson (const ::sxm_sports_main_fi_types::T_SubLeagues& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSUB_LEAGUE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SUB_LEAGUE_ID" , 13);
        yajl_gen_integer(g, (long long)value.getSUB_LEAGUE_ID());
    }
    if (!isSparse || value.hasSUB_LEAGUE_NAME()) {
        yajl_gen_string(g, (const unsigned char*)  "SUB_LEAGUE_NAME" , 15);
        const char *s = value.getSUB_LEAGUE_NAME().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_SubLeagues& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GameList"

void serializeJson (const ::sxm_sports_main_fi_types::T_GameList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_INFO()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_INFO" , 14);
        serializeJson(value.getAFFILIATE_INFO(), g, options);
    }
    if (!isSparse || value.hasBIsRecentGamesAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsRecentGamesAvl" , 17);
        yajl_gen_bool(g, (bool)value.getBIsRecentGamesAvl());
    }
    if (!isSparse || value.hasBIsCurrentGamesAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsCurrentGamesAvl" , 18);
        yajl_gen_bool(g, (bool)value.getBIsCurrentGamesAvl());
    }
    if (!isSparse || value.hasBIsFutureGamesAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFutureGamesAvl" , 17);
        yajl_gen_bool(g, (bool)value.getBIsFutureGamesAvl());
    }
    if (!isSparse || value.hasBIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFavorite" , 11);
        yajl_gen_bool(g, (bool)value.getBIsFavorite());
    }
    if (!isSparse || value.hasGameType()) {
        yajl_gen_string(g, (const unsigned char*)  "GameType" , 8);
        const char* s = ::sxm_sports_main_fi_types::T_GameType_Name(value.getGameType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGameType());
    }
    if (!isSparse || value.hasListIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "ListIndex" , 9);
        yajl_gen_integer(g, (long long)value.getListIndex());
    }
    if (!isSparse || value.hasGameInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "GameInfo" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_GameInfo >& o5 = value.getGameInfo();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_GameInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_GameList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GameInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_GameInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHome_Team_Info()) {
        yajl_gen_string(g, (const unsigned char*)  "Home_Team_Info" , 14);
        serializeJson(value.getHome_Team_Info(), g, options);
    }
    if (!isSparse || value.hasVisiting_Team_Info()) {
        yajl_gen_string(g, (const unsigned char*)  "Visiting_Team_Info" , 18);
        serializeJson(value.getVisiting_Team_Info(), g, options);
    }
    if (!isSparse || value.hasGame_Time()) {
        yajl_gen_string(g, (const unsigned char*)  "Game_Time" , 9);
        serializeJson(value.getGame_Time(), g, options);
    }
    if (!isSparse || value.hasGame_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "Game_Status" , 11);
        const char *s = value.getGame_Status().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasGame_Clock()) {
        yajl_gen_string(g, (const unsigned char*)  "Game_Clock" , 10);
        yajl_gen_integer(g, (long long)value.getGame_Clock());
    }
    if (!isSparse || value.hasWinning_Team_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Winning_Team_ID" , 15);
        yajl_gen_integer(g, (long long)value.getWinning_Team_ID());
    }
    if (!isSparse || value.hasEventState()) {
        yajl_gen_string(g, (const unsigned char*)  "EventState" , 10);
        const char* s = ::sxm_sports_main_fi_types::T_e8_Game_Status_Name(value.getEventState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEventState());
    }
    if (!isSparse || value.hasXMChannelList()) {
        yajl_gen_string(g, (const unsigned char*)  "XMChannelList" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_XMChannel >& o7 = value.getXMChannelList();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_XMChannel >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasGame_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Game_ID" , 7);
        yajl_gen_integer(g, (long long)value.getGame_ID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_GameInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TeamInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_TeamInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTeam_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_ID" , 7);
        yajl_gen_integer(g, (long long)value.getTeam_ID());
    }
    if (!isSparse || value.hasTeam_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Name" , 9);
        const char *s = value.getTeam_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Score()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Score" , 10);
        yajl_gen_integer(g, (long long)value.getTeam_Score());
    }
    if (!isSparse || value.hasTeam_Abbr_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Abbr_Name" , 14);
        const char *s = value.getTeam_Abbr_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Known_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Known_Name" , 15);
        const char *s = value.getTeam_Known_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Nick_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Nick_Name" , 14);
        const char *s = value.getTeam_Nick_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBIsFavorite()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFavorite" , 11);
        yajl_gen_bool(g, (bool)value.getBIsFavorite());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_TeamInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TimeInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_TimeInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDate()) {
        yajl_gen_string(g, (const unsigned char*)  "Date" , 4);
        const char *s = value.getDate().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTime()) {
        yajl_gen_string(g, (const unsigned char*)  "Time" , 4);
        const char *s = value.getTime().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_TimeInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_XMChannel"

void serializeJson (const ::sxm_sports_main_fi_types::T_XMChannel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelNumber" , 13);
        yajl_gen_integer(g, (long long)value.getChannelNumber());
    }
    if (!isSparse || value.hasChannelType()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelType" , 11);
        const char* s = ::sxm_sports_main_fi_types::T_XMChannelType_Name(value.getChannelType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getChannelType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_XMChannel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Details"

void serializeJson (const ::sxm_sports_main_fi_types::T_Details& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "Label" , 5);
        const char *s = value.getLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "Value" , 5);
        const char *s = value.getValue().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_Details& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AvailableGames"

void serializeJson (const ::sxm_sports_main_fi_types::T_AvailableGames& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGameType()) {
        yajl_gen_string(g, (const unsigned char*)  "GameType" , 8);
        const char* s = ::sxm_sports_main_fi_types::T_GameType_Name(value.getGameType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGameType());
    }
    if (!isSparse || value.hasIsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "IsAvailable" , 11);
        yajl_gen_bool(g, (bool)value.getIsAvailable());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_AvailableGames& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TeamList"

void serializeJson (const ::sxm_sports_main_fi_types::T_TeamList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasTeamDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamDetails" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_TeamInfo >& o9 = value.getTeamDetails();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_TeamInfo >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_TeamList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AllTeams"

void serializeJson (const ::sxm_sports_main_fi_types::T_AllTeams& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasTeamDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "TeamDetails" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_TeamInfo >& o11 = value.getTeamDetails();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_TeamInfo >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_AllTeams& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_FavoriteInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_FavoriteInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasTeam_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_ID" , 7);
        yajl_gen_integer(g, (long long)value.getTeam_ID());
    }
    if (!isSparse || value.hasTeam_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Name" , 9);
        const char *s = value.getTeam_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Abbr_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Abbr_Name" , 14);
        const char *s = value.getTeam_Abbr_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Known_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Known_Name" , 15);
        const char *s = value.getTeam_Known_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTeam_Nick_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Team_Nick_Name" , 14);
        const char *s = value.getTeam_Nick_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSport_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "Sport_Name" , 10);
        const char *s = value.getSport_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_FavoriteInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_EventSchedule"

void serializeJson (const ::sxm_sports_main_fi_types::T_EventSchedule& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTourney_Race()) {
        yajl_gen_string(g, (const unsigned char*)  "Tourney_Race" , 12);
        const char *s = value.getTourney_Race().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEventState()) {
        yajl_gen_string(g, (const unsigned char*)  "EventState" , 10);
        const char* s = ::sxm_sports_main_fi_types::T_e8_Game_Status_Name(value.getEventState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEventState());
    }
    if (!isSparse || value.hasCourse_Track()) {
        yajl_gen_string(g, (const unsigned char*)  "Course_Track" , 12);
        const char *s = value.getCourse_Track().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasGame_Time()) {
        yajl_gen_string(g, (const unsigned char*)  "Game_Time" , 9);
        serializeJson(value.getGame_Time(), g, options);
    }
    if (!isSparse || value.hasXMChannelList()) {
        yajl_gen_string(g, (const unsigned char*)  "XMChannelList" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_XMChannel >& o13 = value.getXMChannelList();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_XMChannel >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasPurse_Laps()) {
        yajl_gen_string(g, (const unsigned char*)  "Purse_Laps" , 10);
        yajl_gen_integer(g, (long long)value.getPurse_Laps());
    }
    if (!isSparse || value.hasWinner()) {
        yajl_gen_string(g, (const unsigned char*)  "Winner" , 6);
        const char *s = value.getWinner().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCarNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "CarNumber" , 9);
        const char *s = value.getCarNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCarMake()) {
        yajl_gen_string(g, (const unsigned char*)  "CarMake" , 7);
        const char *s = value.getCarMake().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasYardage_Lap()) {
        yajl_gen_string(g, (const unsigned char*)  "Yardage_Lap" , 11);
        yajl_gen_integer(g, (long long)value.getYardage_Lap());
    }
    if (!isSparse || value.hasIsRankListAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "IsRankListAvl" , 13);
        yajl_gen_bool(g, (bool)value.getIsRankListAvl());
    }
    if (!isSparse || value.hasTableParam()) {
        yajl_gen_string(g, (const unsigned char*)  "TableParam" , 10);
        yajl_gen_integer(g, (long long)value.getTableParam());
    }
    if (!isSparse || value.hasTableRef()) {
        yajl_gen_string(g, (const unsigned char*)  "TableRef" , 8);
        yajl_gen_integer(g, (long long)value.getTableRef());
    }
    if (!isSparse || value.hasEvent_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "Event_ID" , 8);
        yajl_gen_integer(g, (long long)value.getEvent_ID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_EventSchedule& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_EventSchedule_List"

void serializeJson (const ::sxm_sports_main_fi_types::T_EventSchedule_List& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_INFO()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_INFO" , 14);
        serializeJson(value.getAFFILIATE_INFO(), g, options);
    }
    if (!isSparse || value.hasBIsRecentEventsAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsRecentEventsAvl" , 18);
        yajl_gen_bool(g, (bool)value.getBIsRecentEventsAvl());
    }
    if (!isSparse || value.hasBIsCurrentEventsAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsCurrentEventsAvl" , 19);
        yajl_gen_bool(g, (bool)value.getBIsCurrentEventsAvl());
    }
    if (!isSparse || value.hasBIsFutureEventsAvl()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsFutureEventsAvl" , 18);
        yajl_gen_bool(g, (bool)value.getBIsFutureEventsAvl());
    }
    if (!isSparse || value.hasListIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "ListIndex" , 9);
        yajl_gen_integer(g, (long long)value.getListIndex());
    }
    if (!isSparse || value.hasEventType()) {
        yajl_gen_string(g, (const unsigned char*)  "EventType" , 9);
        const char* s = ::sxm_sports_main_fi_types::T_GameType_Name(value.getEventType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEventType());
    }
    if (!isSparse || value.hasEventlist()) {
        yajl_gen_string(g, (const unsigned char*)  "Eventlist" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_EventSchedule >& o15 = value.getEventlist();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_EventSchedule >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_EventSchedule_List& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_EventRank"

void serializeJson (const ::sxm_sports_main_fi_types::T_EventRank& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRank()) {
        yajl_gen_string(g, (const unsigned char*)  "Rank" , 4);
        const char *s = value.getRank().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "Name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLaps()) {
        yajl_gen_string(g, (const unsigned char*)  "Laps" , 4);
        yajl_gen_integer(g, (long long)value.getLaps());
    }
    if (!isSparse || value.hasScore_Make()) {
        yajl_gen_string(g, (const unsigned char*)  "Score_Make" , 10);
        const char *s = value.getScore_Make().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "Number" , 6);
        const char *s = value.getNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_EventRank& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_EventRankList"

void serializeJson (const ::sxm_sports_main_fi_types::T_EventRankList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPORT_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPORT_ID" , 8);
        yajl_gen_integer(g, (long long)value.getSPORT_ID());
    }
    if (!isSparse || value.hasAFFILIATE_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "AFFILIATE_ID" , 12);
        yajl_gen_integer(g, (long long)value.getAFFILIATE_ID());
    }
    if (!isSparse || value.hasRankList()) {
        yajl_gen_string(g, (const unsigned char*)  "RankList" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_sports_main_fi_types::T_EventRank >& o17 = value.getRankList();
        {
            ::std::vector< ::sxm_sports_main_fi_types::T_EventRank >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_EventRankList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_NewsInfo"

void serializeJson (const ::sxm_sports_main_fi_types::T_NewsInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNewsInDetail()) {
        yajl_gen_string(g, (const unsigned char*)  "NewsInDetail" , 12);
        const char *s = value.getNewsInDetail().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_sports_main_fi_types::T_NewsInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_SportInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_RootAffiliateList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_AffiliateInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_AffiliateDetails& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_AffiliateDetailInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_SubLeagues& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_GameList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_GameInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_TeamInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_TimeInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_XMChannel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_Details& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_AvailableGames& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_TeamList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_AllTeams& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_FavoriteInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_EventSchedule& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_EventSchedule_List& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_EventRank& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_EventRankList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_sports_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_sports_main_fi_types::T_NewsInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_sports_main_fi_types

