#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_SPORTS_MAIN_FI_TYPES_H
#define SXM_SPORTS_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_sports_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_sports_main_fi_types
 */

namespace sxm_sports_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SportInfo;

class T_AffiliateInfo;

class T_RootAffiliateList;

class T_AffiliateDetailInfo;

class T_AffiliateDetails;

class T_SubLeagues;

class T_TeamInfo;

class T_TimeInfo;

class T_XMChannel;

class T_GameInfo;

class T_GameList;

class T_Details;

class T_AvailableGames;

class T_TeamList;

class T_AllTeams;

class T_FavoriteInfo;

class T_EventSchedule;

class T_EventSchedule_List;

class T_EventRank;

class T_EventRankList;

class T_NewsInfo;

// type definitions
/**
 * If the meaning of "T_SportList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SportInfo > T_SportList;

/**
 * If the meaning of "T_FavoriteList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_FavoriteInfo > T_FavoriteList;

/**
 * If the meaning of "T_NewsList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_NewsInfo > T_NewsList;


/**
 * If the meaning of "T_SportInfo" isn't clear, then there should be a description here.
 */
class T_SportInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SportInfo ();

    /**
     * Copy constructor
     */
    inline  T_SportInfo (const T_SportInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SportInfo (uint8 SPORT_ID_, const ::std::string& SportName_);

    /**
     * Destructor
     */
    inline  ~T_SportInfo();

    /**
     * Assignment operator
     */
    inline T_SportInfo& operator = (const T_SportInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SportInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SportInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SportInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SportInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "SportName"

    static const int kSportName = 1;

    /**
     * Clears the field "SportName".
     *
     * The field will be set to its default value. The hasSportName()
     * method will return false.
     */
    inline void clearSportName();

    /**
     * Checks whether the field "SportName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportName()). Otherwise it will return false.
     */
    inline bool hasSportName () const;

    /**
     * Returns the value of the member "SportName".
     *
     * sport Name
     *
     * @return The value of the field "SportName"
     */
    inline const ::std::string& getSportName () const;

    /**
     * Retrieves the value of the field "SportName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SportName".
     */
    inline ::std::string& getSportNameMutable ();

    /**
     * Sets the value of the member "SportName".
     *
     * sport Name
     *
     * @param SportName The value which will be set
     */
    inline void setSportName (const ::std::string& SportName_);

    /**
     * Sets the value of the member "SportName".
     *
     * sport Name
     *
     * @param SportName The value which will be set
     */
    inline void setSportName (const char* SportName_);

    /**
     * Sets the value of the member "SportName".
     *
     * sport Name
     *
     * @param SportName The value which will be set
     */
    inline void setSportName (const char* value, size_t size);

    static const T_SportInfo &getDefaultInstance();

private:

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_SportName ();

    inline void clear_has_SportName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _SPORT_ID;

    ::std::string _SportName;

};

/**
 * If the meaning of "T_AffiliateInfo" isn't clear, then there should be a description here.
 */
class T_AffiliateInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AffiliateInfo ();

    /**
     * Copy constructor
     */
    inline  T_AffiliateInfo (const T_AffiliateInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AffiliateInfo (uint32 AFFILIATE_ID_, const ::std::string& AffiliateName_, bool InSeason_);

    /**
     * Destructor
     */
    inline  ~T_AffiliateInfo();

    /**
     * Assignment operator
     */
    inline T_AffiliateInfo& operator = (const T_AffiliateInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AffiliateInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AffiliateInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AffiliateInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AffiliateInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 0;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "AffiliateName"

    static const int kAffiliateName = 1;

    /**
     * Clears the field "AffiliateName".
     *
     * The field will be set to its default value. The hasAffiliateName()
     * method will return false.
     */
    inline void clearAffiliateName();

    /**
     * Checks whether the field "AffiliateName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAffiliateName()). Otherwise it will return false.
     */
    inline bool hasAffiliateName () const;

    /**
     * Returns the value of the member "AffiliateName".
     *
     * The stripped name of the league. If the
     * Affiliate Name provided by SMSe is NHL:Eastern
     * Conference:Atlantic Division, then this field would be
     * Atlantic Division.
     *
     * @return The value of the field "AffiliateName"
     */
    inline const ::std::string& getAffiliateName () const;

    /**
     * Retrieves the value of the field "AffiliateName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AffiliateName".
     */
    inline ::std::string& getAffiliateNameMutable ();

    /**
     * Sets the value of the member "AffiliateName".
     *
     * The stripped name of the league. If the
     * Affiliate Name provided by SMSe is NHL:Eastern
     * Conference:Atlantic Division, then this field would be
     * Atlantic Division.
     *
     * @param AffiliateName The value which will be set
     */
    inline void setAffiliateName (const ::std::string& AffiliateName_);

    /**
     * Sets the value of the member "AffiliateName".
     *
     * The stripped name of the league. If the
     * Affiliate Name provided by SMSe is NHL:Eastern
     * Conference:Atlantic Division, then this field would be
     * Atlantic Division.
     *
     * @param AffiliateName The value which will be set
     */
    inline void setAffiliateName (const char* AffiliateName_);

    /**
     * Sets the value of the member "AffiliateName".
     *
     * The stripped name of the league. If the
     * Affiliate Name provided by SMSe is NHL:Eastern
     * Conference:Atlantic Division, then this field would be
     * Atlantic Division.
     *
     * @param AffiliateName The value which will be set
     */
    inline void setAffiliateName (const char* value, size_t size);

    // API of field "InSeason"

    static const int kInSeason = 2;

    /**
     * Clears the field "InSeason".
     *
     * The field will be set to its default value. The hasInSeason()
     * method will return false.
     */
    inline void clearInSeason();

    /**
     * Checks whether the field "InSeason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInSeason()). Otherwise it will return false.
     */
    inline bool hasInSeason () const;

    /**
     * Returns the value of the member "InSeason".
     *
     * TRUE if the sport is in-season, else
     * FALSE
     *
     * @return The value of the field "InSeason"
     */
    inline bool getInSeason () const;

    /**
     * Sets the value of the member "InSeason".
     *
     * TRUE if the sport is in-season, else
     * FALSE
     *
     * @param InSeason The value which will be set
     */
    inline void setInSeason (bool InSeason_);

    static const T_AffiliateInfo &getDefaultInstance();

private:

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_AffiliateName ();

    inline void clear_has_AffiliateName ();

    inline void set_has_InSeason ();

    inline void clear_has_InSeason ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _AFFILIATE_ID;

    ::std::string _AffiliateName;

    bool _InSeason;

};

/**
 * List of Root Affiliates
 */
class T_RootAffiliateList {
public:

    /**
     * Default constructor
     */
    inline  T_RootAffiliateList ();

    /**
     * Copy constructor
     */
    inline  T_RootAffiliateList (const T_RootAffiliateList &rhs);

    /**
     * All fields constructor
     */
    inline  T_RootAffiliateList (uint8 SPORT_ID_, const ::std::vector< T_AffiliateInfo >& RootAffiliateList_);

    /**
     * Destructor
     */
    inline  ~T_RootAffiliateList();

    /**
     * Assignment operator
     */
    inline T_RootAffiliateList& operator = (const T_RootAffiliateList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RootAffiliateList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RootAffiliateList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RootAffiliateList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RootAffiliateList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "RootAffiliateList"

    static const int kRootAffiliateList = 1;

    /**
     * Clears the field "RootAffiliateList".
     *
     * The field will be set to its default value. The hasRootAffiliateList()
     * method will return false.
     */
    inline void clearRootAffiliateList();

    /**
     * Checks whether the field "RootAffiliateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRootAffiliateList()). Otherwise it will return false.
     */
    inline bool hasRootAffiliateList () const;

    /**
     * Returns the value of the member "RootAffiliateList".
     *
     * Affiliate Information
     *
     * @return The value of the field "RootAffiliateList"
     */
    inline const ::std::vector< T_AffiliateInfo >& getRootAffiliateList () const;

    /**
     * Retrieves the value of the field "RootAffiliateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RootAffiliateList".
     */
    inline ::std::vector< T_AffiliateInfo >& getRootAffiliateListMutable ();

    /**
     * Sets the value of the member "RootAffiliateList".
     *
     * Affiliate Information
     *
     * @param RootAffiliateList The value which will be set
     */
    inline void setRootAffiliateList (const ::std::vector< T_AffiliateInfo >& RootAffiliateList_);

    static const T_RootAffiliateList &getDefaultInstance();

private:

    static const ::std::vector< T_AffiliateInfo >& getT_AffiliateInfoList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_RootAffiliateList ();

    inline void clear_has_RootAffiliateList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _SPORT_ID;

    ::std::vector< T_AffiliateInfo > _RootAffiliateList;

};

/**
 * A table for the values returned by MIDW is given
 * below
 */
class T_AffiliateDetailInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AffiliateDetailInfo ();

    /**
     * Copy constructor
     */
    inline  T_AffiliateDetailInfo (const T_AffiliateDetailInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AffiliateDetailInfo (T_AffiliateCategories Category_ID_, T_e8CategoryAvailability isDataAvailable_, const T_AffiliateInfo& SUB_LEAGUE_INFO_);

    /**
     * Destructor
     */
    inline  ~T_AffiliateDetailInfo();

    /**
     * Assignment operator
     */
    inline T_AffiliateDetailInfo& operator = (const T_AffiliateDetailInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AffiliateDetailInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AffiliateDetailInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AffiliateDetailInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AffiliateDetailInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Category_ID"

    static const int kCategory_ID = 0;

    /**
     * Clears the field "Category_ID".
     *
     * The field will be set to its default value. The hasCategory_ID()
     * method will return false.
     */
    inline void clearCategory_ID();

    /**
     * Checks whether the field "Category_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory_ID()). Otherwise it will return false.
     */
    inline bool hasCategory_ID () const;

    /**
     * Returns the value of the member "Category_ID".
     *
     * The information category
     * <p>Category_ID</p>
     * <p>0 - News</p>
     * <p>1 - All Teams</p>
     * <p>2 - Recent Games or Events</p>
     * <p>3 - Today Games or Events</p>
     * <p>4 - Future Games or Events</p>
     * <p>5 - Top Teams</p>
     * <p>6 - Sub Leagues</p>
     *
     * @return The value of the field "Category_ID"
     */
    inline T_AffiliateCategories getCategory_ID () const;

    /**
     * Sets the value of the member "Category_ID".
     *
     * The information category
     * <p>Category_ID</p>
     * <p>0 - News</p>
     * <p>1 - All Teams</p>
     * <p>2 - Recent Games or Events</p>
     * <p>3 - Today Games or Events</p>
     * <p>4 - Future Games or Events</p>
     * <p>5 - Top Teams</p>
     * <p>6 - Sub Leagues</p>
     *
     * @param Category_ID The value which will be set
     */
    inline void setCategory_ID (T_AffiliateCategories Category_ID_);

    // API of field "isDataAvailable"

    static const int kIsDataAvailable = 1;

    /**
     * Clears the field "isDataAvailable".
     *
     * The field will be set to its default value. The hasIsDataAvailable()
     * method will return false.
     */
    inline void clearIsDataAvailable();

    /**
     * Checks whether the field "isDataAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDataAvailable()). Otherwise it will return false.
     */
    inline bool hasIsDataAvailable () const;

    /**
     * Returns the value of the member "isDataAvailable".
     *
     * 0 - Not Available,1 - Available,2-Not
     * Applicable
     * <p>Not Applicable to 'Sub Leagues'
     * Category</p>
     *
     * @return The value of the field "isDataAvailable"
     */
    inline T_e8CategoryAvailability getIsDataAvailable () const;

    /**
     * Sets the value of the member "isDataAvailable".
     *
     * 0 - Not Available,1 - Available,2-Not
     * Applicable
     * <p>Not Applicable to 'Sub Leagues'
     * Category</p>
     *
     * @param isDataAvailable The value which will be set
     */
    inline void setIsDataAvailable (T_e8CategoryAvailability isDataAvailable_);

    // API of field "SUB_LEAGUE_INFO"

    static const int kSUB_LEAGUE_INFO = 2;

    /**
     * Clears the field "SUB_LEAGUE_INFO".
     *
     * The field will be set to its default value. The hasSUB_LEAGUE_INFO()
     * method will return false.
     */
    inline void clearSUB_LEAGUE_INFO();

    /**
     * Checks whether the field "SUB_LEAGUE_INFO" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUB_LEAGUE_INFO()). Otherwise it will return false.
     */
    inline bool hasSUB_LEAGUE_INFO () const;

    /**
     * Returns the value of the member "SUB_LEAGUE_INFO".
     *
     * Sub League or Child Affiliate Details
     * <p>Applicable only to 'Sub Leagues'
     * Category</p>
     *
     * @return The value of the field "SUB_LEAGUE_INFO"
     */
    inline const T_AffiliateInfo& getSUB_LEAGUE_INFO () const;

    /**
     * Retrieves the value of the field "SUB_LEAGUE_INFO" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SUB_LEAGUE_INFO".
     */
    inline T_AffiliateInfo& getSUB_LEAGUE_INFOMutable ();

    /**
     * Sets the value of the member "SUB_LEAGUE_INFO".
     *
     * Sub League or Child Affiliate Details
     * <p>Applicable only to 'Sub Leagues'
     * Category</p>
     *
     * @param SUB_LEAGUE_INFO The value which will be set
     */
    inline void setSUB_LEAGUE_INFO (const T_AffiliateInfo& SUB_LEAGUE_INFO_);

    static const T_AffiliateDetailInfo &getDefaultInstance();

private:

    inline void set_has_Category_ID ();

    inline void clear_has_Category_ID ();

    inline void set_has_isDataAvailable ();

    inline void clear_has_isDataAvailable ();

    inline void set_has_SUB_LEAGUE_INFO ();

    inline void clear_has_SUB_LEAGUE_INFO ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_AffiliateCategories _Category_ID;

    T_e8CategoryAvailability _isDataAvailable;

    T_AffiliateInfo _SUB_LEAGUE_INFO;

};

/**
 * Details of a particular Affiliate
 */
class T_AffiliateDetails {
public:

    /**
     * Default constructor
     */
    inline  T_AffiliateDetails ();

    /**
     * Copy constructor
     */
    inline  T_AffiliateDetails (const T_AffiliateDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_AffiliateDetails (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_AffiliateDetailInfo >& AffiliateDetails_);

    /**
     * Destructor
     */
    inline  ~T_AffiliateDetails();

    /**
     * Assignment operator
     */
    inline T_AffiliateDetails& operator = (const T_AffiliateDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AffiliateDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AffiliateDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AffiliateDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AffiliateDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "AffiliateDetails"

    static const int kAffiliateDetails = 2;

    /**
     * Clears the field "AffiliateDetails".
     *
     * The field will be set to its default value. The hasAffiliateDetails()
     * method will return false.
     */
    inline void clearAffiliateDetails();

    /**
     * Checks whether the field "AffiliateDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAffiliateDetails()). Otherwise it will return false.
     */
    inline bool hasAffiliateDetails () const;

    /**
     * Returns the value of the member "AffiliateDetails".
     *
     * Affiliate Information
     *
     * @return The value of the field "AffiliateDetails"
     */
    inline const ::std::vector< T_AffiliateDetailInfo >& getAffiliateDetails () const;

    /**
     * Retrieves the value of the field "AffiliateDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AffiliateDetails".
     */
    inline ::std::vector< T_AffiliateDetailInfo >& getAffiliateDetailsMutable ();

    /**
     * Sets the value of the member "AffiliateDetails".
     *
     * Affiliate Information
     *
     * @param AffiliateDetails The value which will be set
     */
    inline void setAffiliateDetails (const ::std::vector< T_AffiliateDetailInfo >& AffiliateDetails_);

    static const T_AffiliateDetails &getDefaultInstance();

private:

    static const ::std::vector< T_AffiliateDetailInfo >& getT_AffiliateDetailInfoList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_AffiliateDetails ();

    inline void clear_has_AffiliateDetails ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _SPORT_ID;

    uint32 _AFFILIATE_ID;

    ::std::vector< T_AffiliateDetailInfo > _AffiliateDetails;

};

/**
 * Sub League or Child Affiliate Info
 */
class T_SubLeagues {
public:

    /**
     * Default constructor
     */
    inline  T_SubLeagues ();

    /**
     * Copy constructor
     */
    inline  T_SubLeagues (const T_SubLeagues &rhs);

    /**
     * All fields constructor
     */
    inline  T_SubLeagues (uint32 SUB_LEAGUE_ID_, const ::std::string& SUB_LEAGUE_NAME_);

    /**
     * Destructor
     */
    inline  ~T_SubLeagues();

    /**
     * Assignment operator
     */
    inline T_SubLeagues& operator = (const T_SubLeagues& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SubLeagues& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SubLeagues& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SubLeagues& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SubLeagues& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SUB_LEAGUE_ID"

    static const int kSUB_LEAGUE_ID = 0;

    /**
     * Clears the field "SUB_LEAGUE_ID".
     *
     * The field will be set to its default value. The hasSUB_LEAGUE_ID()
     * method will return false.
     */
    inline void clearSUB_LEAGUE_ID();

    /**
     * Checks whether the field "SUB_LEAGUE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUB_LEAGUE_ID()). Otherwise it will return false.
     */
    inline bool hasSUB_LEAGUE_ID () const;

    /**
     * Returns the value of the member "SUB_LEAGUE_ID".
     *
     * Sub League or Child Affiliate ID
     *
     * @return The value of the field "SUB_LEAGUE_ID"
     */
    inline uint32 getSUB_LEAGUE_ID () const;

    /**
     * Sets the value of the member "SUB_LEAGUE_ID".
     *
     * Sub League or Child Affiliate ID
     *
     * @param SUB_LEAGUE_ID The value which will be set
     */
    inline void setSUB_LEAGUE_ID (uint32 SUB_LEAGUE_ID_);

    // API of field "SUB_LEAGUE_NAME"

    static const int kSUB_LEAGUE_NAME = 1;

    /**
     * Clears the field "SUB_LEAGUE_NAME".
     *
     * The field will be set to its default value. The hasSUB_LEAGUE_NAME()
     * method will return false.
     */
    inline void clearSUB_LEAGUE_NAME();

    /**
     * Checks whether the field "SUB_LEAGUE_NAME" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUB_LEAGUE_NAME()). Otherwise it will return false.
     */
    inline bool hasSUB_LEAGUE_NAME () const;

    /**
     * Returns the value of the member "SUB_LEAGUE_NAME".
     *
     * Sub League or Child Affiliate
     * Name
     *
     * @return The value of the field "SUB_LEAGUE_NAME"
     */
    inline const ::std::string& getSUB_LEAGUE_NAME () const;

    /**
     * Retrieves the value of the field "SUB_LEAGUE_NAME" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SUB_LEAGUE_NAME".
     */
    inline ::std::string& getSUB_LEAGUE_NAMEMutable ();

    /**
     * Sets the value of the member "SUB_LEAGUE_NAME".
     *
     * Sub League or Child Affiliate
     * Name
     *
     * @param SUB_LEAGUE_NAME The value which will be set
     */
    inline void setSUB_LEAGUE_NAME (const ::std::string& SUB_LEAGUE_NAME_);

    /**
     * Sets the value of the member "SUB_LEAGUE_NAME".
     *
     * Sub League or Child Affiliate
     * Name
     *
     * @param SUB_LEAGUE_NAME The value which will be set
     */
    inline void setSUB_LEAGUE_NAME (const char* SUB_LEAGUE_NAME_);

    /**
     * Sets the value of the member "SUB_LEAGUE_NAME".
     *
     * Sub League or Child Affiliate
     * Name
     *
     * @param SUB_LEAGUE_NAME The value which will be set
     */
    inline void setSUB_LEAGUE_NAME (const char* value, size_t size);

    static const T_SubLeagues &getDefaultInstance();

private:

    inline void set_has_SUB_LEAGUE_ID ();

    inline void clear_has_SUB_LEAGUE_ID ();

    inline void set_has_SUB_LEAGUE_NAME ();

    inline void clear_has_SUB_LEAGUE_NAME ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _SUB_LEAGUE_ID;

    ::std::string _SUB_LEAGUE_NAME;

};

/**
 * The mapping of values returned by SMSe and values
 * provided by FC_SXM_SPORTS MIDW is explained below
 * <p>If the values returned by SMSe for fields TEAMID = 330, ABBR
 * = WashSt, NAME = Washington State, NICKNAME = Cougars</p>
 * <p>Then the values that would be filled up in struct T_TeamInfo
 * would be</p>
 * <p>Team_ID = 330</p>
 * <p>Team_Name = Washington State Cougars (NAME+" "+NICKNAME)</p>
 * <p>Team_Abbr_Name = WashSt</p>
 * <p>Team_Known_Name = Washington State</p>
 * <p>Team_Nick_Name = Cougars</p>
 */
class T_TeamInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TeamInfo ();

    /**
     * Copy constructor
     */
    inline  T_TeamInfo (const T_TeamInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TeamInfo (uint32 Team_ID_, const ::std::string& Team_Name_, uint32 Team_Score_, const ::std::string& Team_Abbr_Name_, const ::std::string& Team_Known_Name_, const ::std::string& Team_Nick_Name_, bool bIsFavorite_);

    /**
     * Destructor
     */
    inline  ~T_TeamInfo();

    /**
     * Assignment operator
     */
    inline T_TeamInfo& operator = (const T_TeamInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TeamInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TeamInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TeamInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TeamInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Team_ID"

    static const int kTeam_ID = 0;

    /**
     * Clears the field "Team_ID".
     *
     * The field will be set to its default value. The hasTeam_ID()
     * method will return false.
     */
    inline void clearTeam_ID();

    /**
     * Checks whether the field "Team_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_ID()). Otherwise it will return false.
     */
    inline bool hasTeam_ID () const;

    /**
     * Returns the value of the member "Team_ID".
     *
     * Team ID
     *
     * @return The value of the field "Team_ID"
     */
    inline uint32 getTeam_ID () const;

    /**
     * Sets the value of the member "Team_ID".
     *
     * Team ID
     *
     * @param Team_ID The value which will be set
     */
    inline void setTeam_ID (uint32 Team_ID_);

    // API of field "Team_Name"

    static const int kTeam_Name = 1;

    /**
     * Clears the field "Team_Name".
     *
     * The field will be set to its default value. The hasTeam_Name()
     * method will return false.
     */
    inline void clearTeam_Name();

    /**
     * Checks whether the field "Team_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Name () const;

    /**
     * Returns the value of the member "Team_Name".
     *
     * Team Name
     *
     * @return The value of the field "Team_Name"
     */
    inline const ::std::string& getTeam_Name () const;

    /**
     * Retrieves the value of the field "Team_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Name".
     */
    inline ::std::string& getTeam_NameMutable ();

    /**
     * Sets the value of the member "Team_Name".
     *
     * Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const ::std::string& Team_Name_);

    /**
     * Sets the value of the member "Team_Name".
     *
     * Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const char* Team_Name_);

    /**
     * Sets the value of the member "Team_Name".
     *
     * Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const char* value, size_t size);

    // API of field "Team_Score"

    static const int kTeam_Score = 2;

    /**
     * Clears the field "Team_Score".
     *
     * The field will be set to its default value. The hasTeam_Score()
     * method will return false.
     */
    inline void clearTeam_Score();

    /**
     * Checks whether the field "Team_Score" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Score()). Otherwise it will return false.
     */
    inline bool hasTeam_Score () const;

    /**
     * Returns the value of the member "Team_Score".
     *
     * Team Score
     *
     * @return The value of the field "Team_Score"
     */
    inline uint32 getTeam_Score () const;

    /**
     * Sets the value of the member "Team_Score".
     *
     * Team Score
     *
     * @param Team_Score The value which will be set
     */
    inline void setTeam_Score (uint32 Team_Score_);

    // API of field "Team_Abbr_Name"

    static const int kTeam_Abbr_Name = 3;

    /**
     * Clears the field "Team_Abbr_Name".
     *
     * The field will be set to its default value. The hasTeam_Abbr_Name()
     * method will return false.
     */
    inline void clearTeam_Abbr_Name();

    /**
     * Checks whether the field "Team_Abbr_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Abbr_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Abbr_Name () const;

    /**
     * Returns the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @return The value of the field "Team_Abbr_Name"
     */
    inline const ::std::string& getTeam_Abbr_Name () const;

    /**
     * Retrieves the value of the field "Team_Abbr_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Abbr_Name".
     */
    inline ::std::string& getTeam_Abbr_NameMutable ();

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const ::std::string& Team_Abbr_Name_);

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const char* Team_Abbr_Name_);

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const char* value, size_t size);

    // API of field "Team_Known_Name"

    static const int kTeam_Known_Name = 4;

    /**
     * Clears the field "Team_Known_Name".
     *
     * The field will be set to its default value. The hasTeam_Known_Name()
     * method will return false.
     */
    inline void clearTeam_Known_Name();

    /**
     * Checks whether the field "Team_Known_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Known_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Known_Name () const;

    /**
     * Returns the value of the member "Team_Known_Name".
     *
     * The actual team name. No changes or
     * extractions made to the Name value returned by
     * SMSe.
     *
     * @return The value of the field "Team_Known_Name"
     */
    inline const ::std::string& getTeam_Known_Name () const;

    /**
     * Retrieves the value of the field "Team_Known_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Known_Name".
     */
    inline ::std::string& getTeam_Known_NameMutable ();

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name. No changes or
     * extractions made to the Name value returned by
     * SMSe.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const ::std::string& Team_Known_Name_);

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name. No changes or
     * extractions made to the Name value returned by
     * SMSe.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const char* Team_Known_Name_);

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name. No changes or
     * extractions made to the Name value returned by
     * SMSe.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const char* value, size_t size);

    // API of field "Team_Nick_Name"

    static const int kTeam_Nick_Name = 5;

    /**
     * Clears the field "Team_Nick_Name".
     *
     * The field will be set to its default value. The hasTeam_Nick_Name()
     * method will return false.
     */
    inline void clearTeam_Nick_Name();

    /**
     * Checks whether the field "Team_Nick_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Nick_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Nick_Name () const;

    /**
     * Returns the value of the member "Team_Nick_Name".
     *
     * The nick name of the team. No changes or
     * extractions made to the Nick Name value returned by
     * SMSe.
     *
     * @return The value of the field "Team_Nick_Name"
     */
    inline const ::std::string& getTeam_Nick_Name () const;

    /**
     * Retrieves the value of the field "Team_Nick_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Nick_Name".
     */
    inline ::std::string& getTeam_Nick_NameMutable ();

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team. No changes or
     * extractions made to the Nick Name value returned by
     * SMSe.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const ::std::string& Team_Nick_Name_);

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team. No changes or
     * extractions made to the Nick Name value returned by
     * SMSe.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const char* Team_Nick_Name_);

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team. No changes or
     * extractions made to the Nick Name value returned by
     * SMSe.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const char* value, size_t size);

    // API of field "bIsFavorite"

    static const int kBIsFavorite = 6;

    /**
     * Clears the field "bIsFavorite".
     *
     * The field will be set to its default value. The hasBIsFavorite()
     * method will return false.
     */
    inline void clearBIsFavorite();

    /**
     * Checks whether the field "bIsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFavorite()). Otherwise it will return false.
     */
    inline bool hasBIsFavorite () const;

    /**
     * Returns the value of the member "bIsFavorite".
     *
     * True if the team is already set as a Favorite
     * team; False otherwise.
     *
     * @return The value of the field "bIsFavorite"
     */
    inline bool getBIsFavorite () const;

    /**
     * Sets the value of the member "bIsFavorite".
     *
     * True if the team is already set as a Favorite
     * team; False otherwise.
     *
     * @param bIsFavorite The value which will be set
     */
    inline void setBIsFavorite (bool bIsFavorite_);

    static const T_TeamInfo &getDefaultInstance();

private:

    inline void set_has_Team_ID ();

    inline void clear_has_Team_ID ();

    inline void set_has_Team_Name ();

    inline void clear_has_Team_Name ();

    inline void set_has_Team_Score ();

    inline void clear_has_Team_Score ();

    inline void set_has_Team_Abbr_Name ();

    inline void clear_has_Team_Abbr_Name ();

    inline void set_has_Team_Known_Name ();

    inline void clear_has_Team_Known_Name ();

    inline void set_has_Team_Nick_Name ();

    inline void clear_has_Team_Nick_Name ();

    inline void set_has_bIsFavorite ();

    inline void clear_has_bIsFavorite ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _Team_ID;

    ::std::string _Team_Name;

    uint32 _Team_Score;

    ::std::string _Team_Abbr_Name;

    ::std::string _Team_Known_Name;

    ::std::string _Team_Nick_Name;

    bool _bIsFavorite;

};

/**
 * If the meaning of "T_TimeInfo" isn't clear, then there should be a description here.
 */
class T_TimeInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TimeInfo ();

    /**
     * Copy constructor
     */
    inline  T_TimeInfo (const T_TimeInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TimeInfo (const ::std::string& Date_, const ::std::string& Time_);

    /**
     * Destructor
     */
    inline  ~T_TimeInfo();

    /**
     * Assignment operator
     */
    inline T_TimeInfo& operator = (const T_TimeInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TimeInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TimeInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TimeInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TimeInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Date"

    static const int kDate = 0;

    /**
     * Clears the field "Date".
     *
     * The field will be set to its default value. The hasDate()
     * method will return false.
     */
    inline void clearDate();

    /**
     * Checks whether the field "Date" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDate()). Otherwise it will return false.
     */
    inline bool hasDate () const;

    /**
     * Returns the value of the member "Date".
     *
     * Date
     *
     * @return The value of the field "Date"
     */
    inline const ::std::string& getDate () const;

    /**
     * Retrieves the value of the field "Date" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Date".
     */
    inline ::std::string& getDateMutable ();

    /**
     * Sets the value of the member "Date".
     *
     * Date
     *
     * @param Date The value which will be set
     */
    inline void setDate (const ::std::string& Date_);

    /**
     * Sets the value of the member "Date".
     *
     * Date
     *
     * @param Date The value which will be set
     */
    inline void setDate (const char* Date_);

    /**
     * Sets the value of the member "Date".
     *
     * Date
     *
     * @param Date The value which will be set
     */
    inline void setDate (const char* value, size_t size);

    // API of field "Time"

    static const int kTime = 1;

    /**
     * Clears the field "Time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "Time".
     *
     * Time
     *
     * @return The value of the field "Time"
     */
    inline const ::std::string& getTime () const;

    /**
     * Retrieves the value of the field "Time" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Time".
     */
    inline ::std::string& getTimeMutable ();

    /**
     * Sets the value of the member "Time".
     *
     * Time
     *
     * @param Time The value which will be set
     */
    inline void setTime (const ::std::string& Time_);

    /**
     * Sets the value of the member "Time".
     *
     * Time
     *
     * @param Time The value which will be set
     */
    inline void setTime (const char* Time_);

    /**
     * Sets the value of the member "Time".
     *
     * Time
     *
     * @param Time The value which will be set
     */
    inline void setTime (const char* value, size_t size);

    static const T_TimeInfo &getDefaultInstance();

private:

    inline void set_has_Date ();

    inline void clear_has_Date ();

    inline void set_has_Time ();

    inline void clear_has_Time ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Date;

    ::std::string _Time;

};

/**
 * If the meaning of "T_XMChannel" isn't clear, then there should be a description here.
 */
class T_XMChannel {
public:

    /**
     * Default constructor
     */
    inline  T_XMChannel ();

    /**
     * Copy constructor
     */
    inline  T_XMChannel (const T_XMChannel &rhs);

    /**
     * All fields constructor
     */
    inline  T_XMChannel (uint32 ChannelNumber_, T_XMChannelType ChannelType_);

    /**
     * Destructor
     */
    inline  ~T_XMChannel();

    /**
     * Assignment operator
     */
    inline T_XMChannel& operator = (const T_XMChannel& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_XMChannel& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_XMChannel& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_XMChannel& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_XMChannel& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelNumber"

    static const int kChannelNumber = 0;

    /**
     * Clears the field "ChannelNumber".
     *
     * The field will be set to its default value. The hasChannelNumber()
     * method will return false.
     */
    inline void clearChannelNumber();

    /**
     * Checks whether the field "ChannelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNumber()). Otherwise it will return false.
     */
    inline bool hasChannelNumber () const;

    /**
     * Returns the value of the member "ChannelNumber".
     *
     * Label Name
     *
     * @return The value of the field "ChannelNumber"
     */
    inline uint32 getChannelNumber () const;

    /**
     * Sets the value of the member "ChannelNumber".
     *
     * Label Name
     *
     * @param ChannelNumber The value which will be set
     */
    inline void setChannelNumber (uint32 ChannelNumber_);

    // API of field "ChannelType"

    static const int kChannelType = 1;

    /**
     * Clears the field "ChannelType".
     *
     * The field will be set to its default value. The hasChannelType()
     * method will return false.
     */
    inline void clearChannelType();

    /**
     * Checks whether the field "ChannelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelType()). Otherwise it will return false.
     */
    inline bool hasChannelType () const;

    /**
     * Returns the value of the member "ChannelType".
     *
     * Available XM Channel Types
     *
     * @return The value of the field "ChannelType"
     */
    inline T_XMChannelType getChannelType () const;

    /**
     * Sets the value of the member "ChannelType".
     *
     * Available XM Channel Types
     *
     * @param ChannelType The value which will be set
     */
    inline void setChannelType (T_XMChannelType ChannelType_);

    static const T_XMChannel &getDefaultInstance();

private:

    inline void set_has_ChannelNumber ();

    inline void clear_has_ChannelNumber ();

    inline void set_has_ChannelType ();

    inline void clear_has_ChannelType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ChannelNumber;

    T_XMChannelType _ChannelType;

};

/**
 * If the meaning of "T_GameInfo" isn't clear, then there should be a description here.
 */
class T_GameInfo {
public:

    /**
     * Default constructor
     */
    inline  T_GameInfo ();

    /**
     * Copy constructor
     */
    inline  T_GameInfo (const T_GameInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_GameInfo (const T_TeamInfo& Home_Team_Info_, const T_TeamInfo& Visiting_Team_Info_, const T_TimeInfo& Game_Time_, const ::std::string& Game_Status_, uint32 Game_Clock_, uint32 Winning_Team_ID_, T_e8_Game_Status EventState_, const ::std::vector< T_XMChannel >& XMChannelList_, uint32 Game_ID_);

    /**
     * Destructor
     */
    inline  ~T_GameInfo();

    /**
     * Assignment operator
     */
    inline T_GameInfo& operator = (const T_GameInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GameInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GameInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GameInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GameInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Home_Team_Info"

    static const int kHome_Team_Info = 0;

    /**
     * Clears the field "Home_Team_Info".
     *
     * The field will be set to its default value. The hasHome_Team_Info()
     * method will return false.
     */
    inline void clearHome_Team_Info();

    /**
     * Checks whether the field "Home_Team_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHome_Team_Info()). Otherwise it will return false.
     */
    inline bool hasHome_Team_Info () const;

    /**
     * Returns the value of the member "Home_Team_Info".
     *
     * Home Team ID
     *
     * @return The value of the field "Home_Team_Info"
     */
    inline const T_TeamInfo& getHome_Team_Info () const;

    /**
     * Retrieves the value of the field "Home_Team_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Home_Team_Info".
     */
    inline T_TeamInfo& getHome_Team_InfoMutable ();

    /**
     * Sets the value of the member "Home_Team_Info".
     *
     * Home Team ID
     *
     * @param Home_Team_Info The value which will be set
     */
    inline void setHome_Team_Info (const T_TeamInfo& Home_Team_Info_);

    // API of field "Visiting_Team_Info"

    static const int kVisiting_Team_Info = 1;

    /**
     * Clears the field "Visiting_Team_Info".
     *
     * The field will be set to its default value. The hasVisiting_Team_Info()
     * method will return false.
     */
    inline void clearVisiting_Team_Info();

    /**
     * Checks whether the field "Visiting_Team_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVisiting_Team_Info()). Otherwise it will return false.
     */
    inline bool hasVisiting_Team_Info () const;

    /**
     * Returns the value of the member "Visiting_Team_Info".
     *
     * Visiting Team Info
     *
     * @return The value of the field "Visiting_Team_Info"
     */
    inline const T_TeamInfo& getVisiting_Team_Info () const;

    /**
     * Retrieves the value of the field "Visiting_Team_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Visiting_Team_Info".
     */
    inline T_TeamInfo& getVisiting_Team_InfoMutable ();

    /**
     * Sets the value of the member "Visiting_Team_Info".
     *
     * Visiting Team Info
     *
     * @param Visiting_Team_Info The value which will be set
     */
    inline void setVisiting_Team_Info (const T_TeamInfo& Visiting_Team_Info_);

    // API of field "Game_Time"

    static const int kGame_Time = 2;

    /**
     * Clears the field "Game_Time".
     *
     * The field will be set to its default value. The hasGame_Time()
     * method will return false.
     */
    inline void clearGame_Time();

    /**
     * Checks whether the field "Game_Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_Time()). Otherwise it will return false.
     */
    inline bool hasGame_Time () const;

    /**
     * Returns the value of the member "Game_Time".
     *
     * Game Playing Time
     *
     * @return The value of the field "Game_Time"
     */
    inline const T_TimeInfo& getGame_Time () const;

    /**
     * Retrieves the value of the field "Game_Time" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Game_Time".
     */
    inline T_TimeInfo& getGame_TimeMutable ();

    /**
     * Sets the value of the member "Game_Time".
     *
     * Game Playing Time
     *
     * @param Game_Time The value which will be set
     */
    inline void setGame_Time (const T_TimeInfo& Game_Time_);

    // API of field "Game_Status"

    static const int kGame_Status = 3;

    /**
     * Clears the field "Game_Status".
     *
     * The field will be set to its default value. The hasGame_Status()
     * method will return false.
     */
    inline void clearGame_Status();

    /**
     * Checks whether the field "Game_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_Status()). Otherwise it will return false.
     */
    inline bool hasGame_Status () const;

    /**
     * Returns the value of the member "Game_Status".
     *
     * Game Division
     *
     * @return The value of the field "Game_Status"
     */
    inline const ::std::string& getGame_Status () const;

    /**
     * Retrieves the value of the field "Game_Status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Game_Status".
     */
    inline ::std::string& getGame_StatusMutable ();

    /**
     * Sets the value of the member "Game_Status".
     *
     * Game Division
     *
     * @param Game_Status The value which will be set
     */
    inline void setGame_Status (const ::std::string& Game_Status_);

    /**
     * Sets the value of the member "Game_Status".
     *
     * Game Division
     *
     * @param Game_Status The value which will be set
     */
    inline void setGame_Status (const char* Game_Status_);

    /**
     * Sets the value of the member "Game_Status".
     *
     * Game Division
     *
     * @param Game_Status The value which will be set
     */
    inline void setGame_Status (const char* value, size_t size);

    // API of field "Game_Clock"

    static const int kGame_Clock = 4;

    /**
     * Clears the field "Game_Clock".
     *
     * The field will be set to its default value. The hasGame_Clock()
     * method will return false.
     */
    inline void clearGame_Clock();

    /**
     * Checks whether the field "Game_Clock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_Clock()). Otherwise it will return false.
     */
    inline bool hasGame_Clock () const;

    /**
     * Returns the value of the member "Game_Clock".
     *
     * Game Clock
     *
     * @return The value of the field "Game_Clock"
     */
    inline uint32 getGame_Clock () const;

    /**
     * Sets the value of the member "Game_Clock".
     *
     * Game Clock
     *
     * @param Game_Clock The value which will be set
     */
    inline void setGame_Clock (uint32 Game_Clock_);

    // API of field "Winning_Team_ID"

    static const int kWinning_Team_ID = 5;

    /**
     * Clears the field "Winning_Team_ID".
     *
     * The field will be set to its default value. The hasWinning_Team_ID()
     * method will return false.
     */
    inline void clearWinning_Team_ID();

    /**
     * Checks whether the field "Winning_Team_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWinning_Team_ID()). Otherwise it will return false.
     */
    inline bool hasWinning_Team_ID () const;

    /**
     * Returns the value of the member "Winning_Team_ID".
     *
     * Indicator of the Winning Team
     * <p>If TeamID is zero, Winning Team would be Game Status -
     * FINAL + Highest Team Score If TeamID is one , the winning
     * team is Home Team and If TeamID is two , the winning team
     * is Visiting Team</p>
     *
     * @return The value of the field "Winning_Team_ID"
     */
    inline uint32 getWinning_Team_ID () const;

    /**
     * Sets the value of the member "Winning_Team_ID".
     *
     * Indicator of the Winning Team
     * <p>If TeamID is zero, Winning Team would be Game Status -
     * FINAL + Highest Team Score If TeamID is one , the winning
     * team is Home Team and If TeamID is two , the winning team
     * is Visiting Team</p>
     *
     * @param Winning_Team_ID The value which will be set
     */
    inline void setWinning_Team_ID (uint32 Winning_Team_ID_);

    // API of field "EventState"

    static const int kEventState = 6;

    /**
     * Clears the field "EventState".
     *
     * The field will be set to its default value. The hasEventState()
     * method will return false.
     */
    inline void clearEventState();

    /**
     * Checks whether the field "EventState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventState()). Otherwise it will return false.
     */
    inline bool hasEventState () const;

    /**
     * Returns the value of the member "EventState".
     *
     * Field represents the current state of the
     * game
     *
     * @return The value of the field "EventState"
     */
    inline T_e8_Game_Status getEventState () const;

    /**
     * Sets the value of the member "EventState".
     *
     * Field represents the current state of the
     * game
     *
     * @param EventState The value which will be set
     */
    inline void setEventState (T_e8_Game_Status EventState_);

    // API of field "XMChannelList"

    static const int kXMChannelList = 7;

    /**
     * Clears the field "XMChannelList".
     *
     * The field will be set to its default value. The hasXMChannelList()
     * method will return false.
     */
    inline void clearXMChannelList();

    /**
     * Checks whether the field "XMChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXMChannelList()). Otherwise it will return false.
     */
    inline bool hasXMChannelList () const;

    /**
     * Returns the value of the member "XMChannelList".
     *
     * XM Channel List
     *
     * @return The value of the field "XMChannelList"
     */
    inline const ::std::vector< T_XMChannel >& getXMChannelList () const;

    /**
     * Retrieves the value of the field "XMChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "XMChannelList".
     */
    inline ::std::vector< T_XMChannel >& getXMChannelListMutable ();

    /**
     * Sets the value of the member "XMChannelList".
     *
     * XM Channel List
     *
     * @param XMChannelList The value which will be set
     */
    inline void setXMChannelList (const ::std::vector< T_XMChannel >& XMChannelList_);

    // API of field "Game_ID"

    static const int kGame_ID = 8;

    /**
     * Clears the field "Game_ID".
     *
     * The field will be set to its default value. The hasGame_ID()
     * method will return false.
     */
    inline void clearGame_ID();

    /**
     * Checks whether the field "Game_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_ID()). Otherwise it will return false.
     */
    inline bool hasGame_ID () const;

    /**
     * Returns the value of the member "Game_ID".
     *
     * The generated unique ID for the particular
     * game in the list
     * <p>Every game would have a unique ID.</p>
     *
     * @return The value of the field "Game_ID"
     */
    inline uint32 getGame_ID () const;

    /**
     * Sets the value of the member "Game_ID".
     *
     * The generated unique ID for the particular
     * game in the list
     * <p>Every game would have a unique ID.</p>
     *
     * @param Game_ID The value which will be set
     */
    inline void setGame_ID (uint32 Game_ID_);

    static const T_GameInfo &getDefaultInstance();

private:

    static const ::std::vector< T_XMChannel >& getT_XMChannelList_DefaultInstance ();

    inline void set_has_Home_Team_Info ();

    inline void clear_has_Home_Team_Info ();

    inline void set_has_Visiting_Team_Info ();

    inline void clear_has_Visiting_Team_Info ();

    inline void set_has_Game_Time ();

    inline void clear_has_Game_Time ();

    inline void set_has_Game_Status ();

    inline void clear_has_Game_Status ();

    inline void set_has_Game_Clock ();

    inline void clear_has_Game_Clock ();

    inline void set_has_Winning_Team_ID ();

    inline void clear_has_Winning_Team_ID ();

    inline void set_has_EventState ();

    inline void clear_has_EventState ();

    inline void set_has_XMChannelList ();

    inline void clear_has_XMChannelList ();

    inline void set_has_Game_ID ();

    inline void clear_has_Game_ID ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_TeamInfo _Home_Team_Info;

    T_TeamInfo _Visiting_Team_Info;

    T_TimeInfo _Game_Time;

    ::std::string _Game_Status;

    uint32 _Game_Clock;

    uint32 _Winning_Team_ID;

    T_e8_Game_Status _EventState;

    ::std::vector< T_XMChannel > _XMChannelList;

    uint32 _Game_ID;

};

/**
 * List of Games
 */
class T_GameList {
public:

    /**
     * Default constructor
     */
    inline  T_GameList ();

    /**
     * Copy constructor
     */
    inline  T_GameList (const T_GameList &rhs);

    /**
     * All fields constructor
     */
    inline  T_GameList (uint8 SPORT_ID_, const T_AffiliateInfo& AFFILIATE_INFO_, bool bIsRecentGamesAvl_, bool bIsCurrentGamesAvl_, bool bIsFutureGamesAvl_, bool bIsFavorite_, T_GameType GameType_, uint32 ListIndex_, const ::std::vector< T_GameInfo >& GameInfo_);

    /**
     * Destructor
     */
    inline  ~T_GameList();

    /**
     * Assignment operator
     */
    inline T_GameList& operator = (const T_GameList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GameList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GameList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GameList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GameList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_INFO"

    static const int kAFFILIATE_INFO = 1;

    /**
     * Clears the field "AFFILIATE_INFO".
     *
     * The field will be set to its default value. The hasAFFILIATE_INFO()
     * method will return false.
     */
    inline void clearAFFILIATE_INFO();

    /**
     * Checks whether the field "AFFILIATE_INFO" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_INFO()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_INFO () const;

    /**
     * Returns the value of the member "AFFILIATE_INFO".
     *
     * Affiliate Info
     *
     * @return The value of the field "AFFILIATE_INFO"
     */
    inline const T_AffiliateInfo& getAFFILIATE_INFO () const;

    /**
     * Retrieves the value of the field "AFFILIATE_INFO" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AFFILIATE_INFO".
     */
    inline T_AffiliateInfo& getAFFILIATE_INFOMutable ();

    /**
     * Sets the value of the member "AFFILIATE_INFO".
     *
     * Affiliate Info
     *
     * @param AFFILIATE_INFO The value which will be set
     */
    inline void setAFFILIATE_INFO (const T_AffiliateInfo& AFFILIATE_INFO_);

    // API of field "bIsRecentGamesAvl"

    static const int kBIsRecentGamesAvl = 2;

    /**
     * Clears the field "bIsRecentGamesAvl".
     *
     * The field will be set to its default value. The hasBIsRecentGamesAvl()
     * method will return false.
     */
    inline void clearBIsRecentGamesAvl();

    /**
     * Checks whether the field "bIsRecentGamesAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsRecentGamesAvl()). Otherwise it will return false.
     */
    inline bool hasBIsRecentGamesAvl () const;

    /**
     * Returns the value of the member "bIsRecentGamesAvl".
     *
     * True if recent games are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsRecentGamesAvl"
     */
    inline bool getBIsRecentGamesAvl () const;

    /**
     * Sets the value of the member "bIsRecentGamesAvl".
     *
     * True if recent games are available; FALSE
     * otherwise
     *
     * @param bIsRecentGamesAvl The value which will be set
     */
    inline void setBIsRecentGamesAvl (bool bIsRecentGamesAvl_);

    // API of field "bIsCurrentGamesAvl"

    static const int kBIsCurrentGamesAvl = 3;

    /**
     * Clears the field "bIsCurrentGamesAvl".
     *
     * The field will be set to its default value. The hasBIsCurrentGamesAvl()
     * method will return false.
     */
    inline void clearBIsCurrentGamesAvl();

    /**
     * Checks whether the field "bIsCurrentGamesAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsCurrentGamesAvl()). Otherwise it will return false.
     */
    inline bool hasBIsCurrentGamesAvl () const;

    /**
     * Returns the value of the member "bIsCurrentGamesAvl".
     *
     * True if current games are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsCurrentGamesAvl"
     */
    inline bool getBIsCurrentGamesAvl () const;

    /**
     * Sets the value of the member "bIsCurrentGamesAvl".
     *
     * True if current games are available; FALSE
     * otherwise
     *
     * @param bIsCurrentGamesAvl The value which will be set
     */
    inline void setBIsCurrentGamesAvl (bool bIsCurrentGamesAvl_);

    // API of field "bIsFutureGamesAvl"

    static const int kBIsFutureGamesAvl = 4;

    /**
     * Clears the field "bIsFutureGamesAvl".
     *
     * The field will be set to its default value. The hasBIsFutureGamesAvl()
     * method will return false.
     */
    inline void clearBIsFutureGamesAvl();

    /**
     * Checks whether the field "bIsFutureGamesAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFutureGamesAvl()). Otherwise it will return false.
     */
    inline bool hasBIsFutureGamesAvl () const;

    /**
     * Returns the value of the member "bIsFutureGamesAvl".
     *
     * True if future games are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsFutureGamesAvl"
     */
    inline bool getBIsFutureGamesAvl () const;

    /**
     * Sets the value of the member "bIsFutureGamesAvl".
     *
     * True if future games are available; FALSE
     * otherwise
     *
     * @param bIsFutureGamesAvl The value which will be set
     */
    inline void setBIsFutureGamesAvl (bool bIsFutureGamesAvl_);

    // API of field "bIsFavorite"

    static const int kBIsFavorite = 5;

    /**
     * Clears the field "bIsFavorite".
     *
     * The field will be set to its default value. The hasBIsFavorite()
     * method will return false.
     */
    inline void clearBIsFavorite();

    /**
     * Checks whether the field "bIsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFavorite()). Otherwise it will return false.
     */
    inline bool hasBIsFavorite () const;

    /**
     * Returns the value of the member "bIsFavorite".
     *
     * TRUE - if the selected team is stored already
     * as a Favorite,FALSE otherwise
     *
     * @return The value of the field "bIsFavorite"
     */
    inline bool getBIsFavorite () const;

    /**
     * Sets the value of the member "bIsFavorite".
     *
     * TRUE - if the selected team is stored already
     * as a Favorite,FALSE otherwise
     *
     * @param bIsFavorite The value which will be set
     */
    inline void setBIsFavorite (bool bIsFavorite_);

    // API of field "GameType"

    static const int kGameType = 6;

    /**
     * Clears the field "GameType".
     *
     * The field will be set to its default value. The hasGameType()
     * method will return false.
     */
    inline void clearGameType();

    /**
     * Checks whether the field "GameType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameType()). Otherwise it will return false.
     */
    inline bool hasGameType () const;

    /**
     * Returns the value of the member "GameType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @return The value of the field "GameType"
     */
    inline T_GameType getGameType () const;

    /**
     * Sets the value of the member "GameType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @param GameType The value which will be set
     */
    inline void setGameType (T_GameType GameType_);

    // API of field "ListIndex"

    static const int kListIndex = 7;

    /**
     * Clears the field "ListIndex".
     *
     * The field will be set to its default value. The hasListIndex()
     * method will return false.
     */
    inline void clearListIndex();

    /**
     * Checks whether the field "ListIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListIndex()). Otherwise it will return false.
     */
    inline bool hasListIndex () const;

    /**
     * Returns the value of the member "ListIndex".
     *
     * Set the list item of the active screen with
     * this Index value.
     * <p>The default or invalid value is 4294967295 (0xffffffff).
     * If this value is passed from FC_SXM_SPORTS, then HMI need
     * not focus on any particular list item.</p>
     * <p>For the valid values, HMI would focus on the index
     * available from this field.</p>
     *
     * @return The value of the field "ListIndex"
     */
    inline uint32 getListIndex () const;

    /**
     * Sets the value of the member "ListIndex".
     *
     * Set the list item of the active screen with
     * this Index value.
     * <p>The default or invalid value is 4294967295 (0xffffffff).
     * If this value is passed from FC_SXM_SPORTS, then HMI need
     * not focus on any particular list item.</p>
     * <p>For the valid values, HMI would focus on the index
     * available from this field.</p>
     *
     * @param ListIndex The value which will be set
     */
    inline void setListIndex (uint32 ListIndex_);

    // API of field "GameInfo"

    static const int kGameInfo = 8;

    /**
     * Clears the field "GameInfo".
     *
     * The field will be set to its default value. The hasGameInfo()
     * method will return false.
     */
    inline void clearGameInfo();

    /**
     * Checks whether the field "GameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameInfo()). Otherwise it will return false.
     */
    inline bool hasGameInfo () const;

    /**
     * Returns the value of the member "GameInfo".
     *
     * Game Information
     *
     * @return The value of the field "GameInfo"
     */
    inline const ::std::vector< T_GameInfo >& getGameInfo () const;

    /**
     * Retrieves the value of the field "GameInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GameInfo".
     */
    inline ::std::vector< T_GameInfo >& getGameInfoMutable ();

    /**
     * Sets the value of the member "GameInfo".
     *
     * Game Information
     *
     * @param GameInfo The value which will be set
     */
    inline void setGameInfo (const ::std::vector< T_GameInfo >& GameInfo_);

    static const T_GameList &getDefaultInstance();

private:

    static const ::std::vector< T_GameInfo >& getT_GameInfoList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_INFO ();

    inline void clear_has_AFFILIATE_INFO ();

    inline void set_has_bIsRecentGamesAvl ();

    inline void clear_has_bIsRecentGamesAvl ();

    inline void set_has_bIsCurrentGamesAvl ();

    inline void clear_has_bIsCurrentGamesAvl ();

    inline void set_has_bIsFutureGamesAvl ();

    inline void clear_has_bIsFutureGamesAvl ();

    inline void set_has_bIsFavorite ();

    inline void clear_has_bIsFavorite ();

    inline void set_has_GameType ();

    inline void clear_has_GameType ();

    inline void set_has_ListIndex ();

    inline void clear_has_ListIndex ();

    inline void set_has_GameInfo ();

    inline void clear_has_GameInfo ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint8 _SPORT_ID;

    T_AffiliateInfo _AFFILIATE_INFO;

    bool _bIsRecentGamesAvl;

    bool _bIsCurrentGamesAvl;

    bool _bIsFutureGamesAvl;

    bool _bIsFavorite;

    T_GameType _GameType;

    uint32 _ListIndex;

    ::std::vector< T_GameInfo > _GameInfo;

};

/**
 * If the meaning of "T_Details" isn't clear, then there should be a description here.
 */
class T_Details {
public:

    /**
     * Default constructor
     */
    inline  T_Details ();

    /**
     * Copy constructor
     */
    inline  T_Details (const T_Details &rhs);

    /**
     * All fields constructor
     */
    inline  T_Details (const ::std::string& Label_, const ::std::string& Value_);

    /**
     * Destructor
     */
    inline  ~T_Details();

    /**
     * Assignment operator
     */
    inline T_Details& operator = (const T_Details& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Details& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Details& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Details& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Details& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Label"

    static const int kLabel = 0;

    /**
     * Clears the field "Label".
     *
     * The field will be set to its default value. The hasLabel()
     * method will return false.
     */
    inline void clearLabel();

    /**
     * Checks whether the field "Label" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLabel()). Otherwise it will return false.
     */
    inline bool hasLabel () const;

    /**
     * Returns the value of the member "Label".
     *
     * Label Name
     *
     * @return The value of the field "Label"
     */
    inline const ::std::string& getLabel () const;

    /**
     * Retrieves the value of the field "Label" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Label".
     */
    inline ::std::string& getLabelMutable ();

    /**
     * Sets the value of the member "Label".
     *
     * Label Name
     *
     * @param Label The value which will be set
     */
    inline void setLabel (const ::std::string& Label_);

    /**
     * Sets the value of the member "Label".
     *
     * Label Name
     *
     * @param Label The value which will be set
     */
    inline void setLabel (const char* Label_);

    /**
     * Sets the value of the member "Label".
     *
     * Label Name
     *
     * @param Label The value which will be set
     */
    inline void setLabel (const char* value, size_t size);

    // API of field "Value"

    static const int kValue = 1;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * Label Detail
     *
     * @return The value of the field "Value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "Value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "Value".
     *
     * Label Detail
     *
     * @param Value The value which will be set
     */
    inline void setValue (const ::std::string& Value_);

    /**
     * Sets the value of the member "Value".
     *
     * Label Detail
     *
     * @param Value The value which will be set
     */
    inline void setValue (const char* Value_);

    /**
     * Sets the value of the member "Value".
     *
     * Label Detail
     *
     * @param Value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const T_Details &getDefaultInstance();

private:

    inline void set_has_Label ();

    inline void clear_has_Label ();

    inline void set_has_Value ();

    inline void clear_has_Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Label;

    ::std::string _Value;

};

/**
 * If the meaning of "T_AvailableGames" isn't clear, then there should be a description here.
 */
class T_AvailableGames {
public:

    /**
     * Default constructor
     */
    inline  T_AvailableGames ();

    /**
     * Copy constructor
     */
    inline  T_AvailableGames (const T_AvailableGames &rhs);

    /**
     * All fields constructor
     */
    inline  T_AvailableGames (T_GameType GameType_, bool IsAvailable_);

    /**
     * Destructor
     */
    inline  ~T_AvailableGames();

    /**
     * Assignment operator
     */
    inline T_AvailableGames& operator = (const T_AvailableGames& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AvailableGames& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AvailableGames& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AvailableGames& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AvailableGames& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GameType"

    static const int kGameType = 0;

    /**
     * Clears the field "GameType".
     *
     * The field will be set to its default value. The hasGameType()
     * method will return false.
     */
    inline void clearGameType();

    /**
     * Checks whether the field "GameType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameType()). Otherwise it will return false.
     */
    inline bool hasGameType () const;

    /**
     * Returns the value of the member "GameType".
     *
     * Game Type
     *
     * @return The value of the field "GameType"
     */
    inline T_GameType getGameType () const;

    /**
     * Sets the value of the member "GameType".
     *
     * Game Type
     *
     * @param GameType The value which will be set
     */
    inline void setGameType (T_GameType GameType_);

    // API of field "IsAvailable"

    static const int kIsAvailable = 1;

    /**
     * Clears the field "IsAvailable".
     *
     * The field will be set to its default value. The hasIsAvailable()
     * method will return false.
     */
    inline void clearIsAvailable();

    /**
     * Checks whether the field "IsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAvailable()). Otherwise it will return false.
     */
    inline bool hasIsAvailable () const;

    /**
     * Returns the value of the member "IsAvailable".
     *
     * TRUE - Available,FALSE - Not
     * Available
     *
     * @return The value of the field "IsAvailable"
     */
    inline bool getIsAvailable () const;

    /**
     * Sets the value of the member "IsAvailable".
     *
     * TRUE - Available,FALSE - Not
     * Available
     *
     * @param IsAvailable The value which will be set
     */
    inline void setIsAvailable (bool IsAvailable_);

    static const T_AvailableGames &getDefaultInstance();

private:

    inline void set_has_GameType ();

    inline void clear_has_GameType ();

    inline void set_has_IsAvailable ();

    inline void clear_has_IsAvailable ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_GameType _GameType;

    bool _IsAvailable;

};

/**
 * Team List
 */
class T_TeamList {
public:

    /**
     * Default constructor
     */
    inline  T_TeamList ();

    /**
     * Copy constructor
     */
    inline  T_TeamList (const T_TeamList &rhs);

    /**
     * All fields constructor
     */
    inline  T_TeamList (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_TeamInfo >& TeamDetails_);

    /**
     * Destructor
     */
    inline  ~T_TeamList();

    /**
     * Assignment operator
     */
    inline T_TeamList& operator = (const T_TeamList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TeamList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TeamList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TeamList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TeamList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "TeamDetails"

    static const int kTeamDetails = 2;

    /**
     * Clears the field "TeamDetails".
     *
     * The field will be set to its default value. The hasTeamDetails()
     * method will return false.
     */
    inline void clearTeamDetails();

    /**
     * Checks whether the field "TeamDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamDetails()). Otherwise it will return false.
     */
    inline bool hasTeamDetails () const;

    /**
     * Returns the value of the member "TeamDetails".
     *
     * Team Information
     *
     * @return The value of the field "TeamDetails"
     */
    inline const ::std::vector< T_TeamInfo >& getTeamDetails () const;

    /**
     * Retrieves the value of the field "TeamDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamDetails".
     */
    inline ::std::vector< T_TeamInfo >& getTeamDetailsMutable ();

    /**
     * Sets the value of the member "TeamDetails".
     *
     * Team Information
     *
     * @param TeamDetails The value which will be set
     */
    inline void setTeamDetails (const ::std::vector< T_TeamInfo >& TeamDetails_);

    static const T_TeamList &getDefaultInstance();

private:

    static const ::std::vector< T_TeamInfo >& getT_TeamInfoList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_TeamDetails ();

    inline void clear_has_TeamDetails ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _SPORT_ID;

    uint32 _AFFILIATE_ID;

    ::std::vector< T_TeamInfo > _TeamDetails;

};

/**
 * All Team List
 */
class T_AllTeams {
public:

    /**
     * Default constructor
     */
    inline  T_AllTeams ();

    /**
     * Copy constructor
     */
    inline  T_AllTeams (const T_AllTeams &rhs);

    /**
     * All fields constructor
     */
    inline  T_AllTeams (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_TeamInfo >& TeamDetails_);

    /**
     * Destructor
     */
    inline  ~T_AllTeams();

    /**
     * Assignment operator
     */
    inline T_AllTeams& operator = (const T_AllTeams& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AllTeams& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AllTeams& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AllTeams& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AllTeams& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "TeamDetails"

    static const int kTeamDetails = 2;

    /**
     * Clears the field "TeamDetails".
     *
     * The field will be set to its default value. The hasTeamDetails()
     * method will return false.
     */
    inline void clearTeamDetails();

    /**
     * Checks whether the field "TeamDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamDetails()). Otherwise it will return false.
     */
    inline bool hasTeamDetails () const;

    /**
     * Returns the value of the member "TeamDetails".
     *
     * Team Information
     *
     * @return The value of the field "TeamDetails"
     */
    inline const ::std::vector< T_TeamInfo >& getTeamDetails () const;

    /**
     * Retrieves the value of the field "TeamDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamDetails".
     */
    inline ::std::vector< T_TeamInfo >& getTeamDetailsMutable ();

    /**
     * Sets the value of the member "TeamDetails".
     *
     * Team Information
     *
     * @param TeamDetails The value which will be set
     */
    inline void setTeamDetails (const ::std::vector< T_TeamInfo >& TeamDetails_);

    static const T_AllTeams &getDefaultInstance();

private:

    static const ::std::vector< T_TeamInfo >& getT_TeamInfoList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_TeamDetails ();

    inline void clear_has_TeamDetails ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _SPORT_ID;

    uint32 _AFFILIATE_ID;

    ::std::vector< T_TeamInfo > _TeamDetails;

};

/**
 * If the meaning of "T_FavoriteInfo" isn't clear, then there should be a description here.
 */
class T_FavoriteInfo {
public:

    /**
     * Default constructor
     */
    inline  T_FavoriteInfo ();

    /**
     * Copy constructor
     */
    inline  T_FavoriteInfo (const T_FavoriteInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_FavoriteInfo (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, uint32 Team_ID_, const ::std::string& Team_Name_, const ::std::string& Team_Abbr_Name_, const ::std::string& Team_Known_Name_, const ::std::string& Team_Nick_Name_, const ::std::string& Sport_Name_);

    /**
     * Destructor
     */
    inline  ~T_FavoriteInfo();

    /**
     * Assignment operator
     */
    inline T_FavoriteInfo& operator = (const T_FavoriteInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FavoriteInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FavoriteInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FavoriteInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FavoriteInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "Team_ID"

    static const int kTeam_ID = 2;

    /**
     * Clears the field "Team_ID".
     *
     * The field will be set to its default value. The hasTeam_ID()
     * method will return false.
     */
    inline void clearTeam_ID();

    /**
     * Checks whether the field "Team_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_ID()). Otherwise it will return false.
     */
    inline bool hasTeam_ID () const;

    /**
     * Returns the value of the member "Team_ID".
     *
     * Teams ID
     *
     * @return The value of the field "Team_ID"
     */
    inline uint32 getTeam_ID () const;

    /**
     * Sets the value of the member "Team_ID".
     *
     * Teams ID
     *
     * @param Team_ID The value which will be set
     */
    inline void setTeam_ID (uint32 Team_ID_);

    // API of field "Team_Name"

    static const int kTeam_Name = 3;

    /**
     * Clears the field "Team_Name".
     *
     * The field will be set to its default value. The hasTeam_Name()
     * method will return false.
     */
    inline void clearTeam_Name();

    /**
     * Checks whether the field "Team_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Name () const;

    /**
     * Returns the value of the member "Team_Name".
     *
     * complete Team Name
     *
     * @return The value of the field "Team_Name"
     */
    inline const ::std::string& getTeam_Name () const;

    /**
     * Retrieves the value of the field "Team_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Name".
     */
    inline ::std::string& getTeam_NameMutable ();

    /**
     * Sets the value of the member "Team_Name".
     *
     * complete Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const ::std::string& Team_Name_);

    /**
     * Sets the value of the member "Team_Name".
     *
     * complete Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const char* Team_Name_);

    /**
     * Sets the value of the member "Team_Name".
     *
     * complete Team Name
     *
     * @param Team_Name The value which will be set
     */
    inline void setTeam_Name (const char* value, size_t size);

    // API of field "Team_Abbr_Name"

    static const int kTeam_Abbr_Name = 4;

    /**
     * Clears the field "Team_Abbr_Name".
     *
     * The field will be set to its default value. The hasTeam_Abbr_Name()
     * method will return false.
     */
    inline void clearTeam_Abbr_Name();

    /**
     * Checks whether the field "Team_Abbr_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Abbr_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Abbr_Name () const;

    /**
     * Returns the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @return The value of the field "Team_Abbr_Name"
     */
    inline const ::std::string& getTeam_Abbr_Name () const;

    /**
     * Retrieves the value of the field "Team_Abbr_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Abbr_Name".
     */
    inline ::std::string& getTeam_Abbr_NameMutable ();

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const ::std::string& Team_Abbr_Name_);

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const char* Team_Abbr_Name_);

    /**
     * Sets the value of the member "Team_Abbr_Name".
     *
     * Abbreviated name of the team
     *
     * @param Team_Abbr_Name The value which will be set
     */
    inline void setTeam_Abbr_Name (const char* value, size_t size);

    // API of field "Team_Known_Name"

    static const int kTeam_Known_Name = 5;

    /**
     * Clears the field "Team_Known_Name".
     *
     * The field will be set to its default value. The hasTeam_Known_Name()
     * method will return false.
     */
    inline void clearTeam_Known_Name();

    /**
     * Checks whether the field "Team_Known_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Known_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Known_Name () const;

    /**
     * Returns the value of the member "Team_Known_Name".
     *
     * The actual team name.
     *
     * @return The value of the field "Team_Known_Name"
     */
    inline const ::std::string& getTeam_Known_Name () const;

    /**
     * Retrieves the value of the field "Team_Known_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Known_Name".
     */
    inline ::std::string& getTeam_Known_NameMutable ();

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const ::std::string& Team_Known_Name_);

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const char* Team_Known_Name_);

    /**
     * Sets the value of the member "Team_Known_Name".
     *
     * The actual team name.
     *
     * @param Team_Known_Name The value which will be set
     */
    inline void setTeam_Known_Name (const char* value, size_t size);

    // API of field "Team_Nick_Name"

    static const int kTeam_Nick_Name = 6;

    /**
     * Clears the field "Team_Nick_Name".
     *
     * The field will be set to its default value. The hasTeam_Nick_Name()
     * method will return false.
     */
    inline void clearTeam_Nick_Name();

    /**
     * Checks whether the field "Team_Nick_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeam_Nick_Name()). Otherwise it will return false.
     */
    inline bool hasTeam_Nick_Name () const;

    /**
     * Returns the value of the member "Team_Nick_Name".
     *
     * The nick name of the team.
     *
     * @return The value of the field "Team_Nick_Name"
     */
    inline const ::std::string& getTeam_Nick_Name () const;

    /**
     * Retrieves the value of the field "Team_Nick_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Team_Nick_Name".
     */
    inline ::std::string& getTeam_Nick_NameMutable ();

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const ::std::string& Team_Nick_Name_);

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const char* Team_Nick_Name_);

    /**
     * Sets the value of the member "Team_Nick_Name".
     *
     * The nick name of the team.
     *
     * @param Team_Nick_Name The value which will be set
     */
    inline void setTeam_Nick_Name (const char* value, size_t size);

    // API of field "Sport_Name"

    static const int kSport_Name = 7;

    /**
     * Clears the field "Sport_Name".
     *
     * The field will be set to its default value. The hasSport_Name()
     * method will return false.
     */
    inline void clearSport_Name();

    /**
     * Checks whether the field "Sport_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSport_Name()). Otherwise it will return false.
     */
    inline bool hasSport_Name () const;

    /**
     * Returns the value of the member "Sport_Name".
     *
     * Sport Name
     *
     * @return The value of the field "Sport_Name"
     */
    inline const ::std::string& getSport_Name () const;

    /**
     * Retrieves the value of the field "Sport_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Sport_Name".
     */
    inline ::std::string& getSport_NameMutable ();

    /**
     * Sets the value of the member "Sport_Name".
     *
     * Sport Name
     *
     * @param Sport_Name The value which will be set
     */
    inline void setSport_Name (const ::std::string& Sport_Name_);

    /**
     * Sets the value of the member "Sport_Name".
     *
     * Sport Name
     *
     * @param Sport_Name The value which will be set
     */
    inline void setSport_Name (const char* Sport_Name_);

    /**
     * Sets the value of the member "Sport_Name".
     *
     * Sport Name
     *
     * @param Sport_Name The value which will be set
     */
    inline void setSport_Name (const char* value, size_t size);

    static const T_FavoriteInfo &getDefaultInstance();

private:

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_Team_ID ();

    inline void clear_has_Team_ID ();

    inline void set_has_Team_Name ();

    inline void clear_has_Team_Name ();

    inline void set_has_Team_Abbr_Name ();

    inline void clear_has_Team_Abbr_Name ();

    inline void set_has_Team_Known_Name ();

    inline void clear_has_Team_Known_Name ();

    inline void set_has_Team_Nick_Name ();

    inline void clear_has_Team_Nick_Name ();

    inline void set_has_Sport_Name ();

    inline void clear_has_Sport_Name ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint8 _SPORT_ID;

    uint32 _AFFILIATE_ID;

    uint32 _Team_ID;

    ::std::string _Team_Name;

    ::std::string _Team_Abbr_Name;

    ::std::string _Team_Known_Name;

    ::std::string _Team_Nick_Name;

    ::std::string _Sport_Name;

};

/**
 * Information needed to display the complete Non
 * Team Sports Schedules screen.
 */
class T_EventSchedule {
public:

    /**
     * Default constructor
     */
    inline  T_EventSchedule ();

    /**
     * Copy constructor
     */
    inline  T_EventSchedule (const T_EventSchedule &rhs);

    /**
     * All fields constructor
     */
    inline  T_EventSchedule (const ::std::string& Tourney_Race_, T_e8_Game_Status EventState_, const ::std::string& Course_Track_, const T_TimeInfo& Game_Time_, const ::std::vector< T_XMChannel >& XMChannelList_, uint32 Purse_Laps_, const ::std::string& Winner_, const ::std::string& CarNumber_, const ::std::string& CarMake_, uint32 Yardage_Lap_, bool IsRankListAvl_, int32 TableParam_, int32 TableRef_, uint32 Event_ID_);

    /**
     * Destructor
     */
    inline  ~T_EventSchedule();

    /**
     * Assignment operator
     */
    inline T_EventSchedule& operator = (const T_EventSchedule& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EventSchedule& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EventSchedule& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EventSchedule& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EventSchedule& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tourney_Race"

    static const int kTourney_Race = 0;

    /**
     * Clears the field "Tourney_Race".
     *
     * The field will be set to its default value. The hasTourney_Race()
     * method will return false.
     */
    inline void clearTourney_Race();

    /**
     * Checks whether the field "Tourney_Race" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTourney_Race()). Otherwise it will return false.
     */
    inline bool hasTourney_Race () const;

    /**
     * Returns the value of the member "Tourney_Race".
     *
     * Field represents
     * <p>Tourney in case of Golf</p>
     * <p>Race Name in case of Motor sports</p>
     *
     * @return The value of the field "Tourney_Race"
     */
    inline const ::std::string& getTourney_Race () const;

    /**
     * Retrieves the value of the field "Tourney_Race" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tourney_Race".
     */
    inline ::std::string& getTourney_RaceMutable ();

    /**
     * Sets the value of the member "Tourney_Race".
     *
     * Field represents
     * <p>Tourney in case of Golf</p>
     * <p>Race Name in case of Motor sports</p>
     *
     * @param Tourney_Race The value which will be set
     */
    inline void setTourney_Race (const ::std::string& Tourney_Race_);

    /**
     * Sets the value of the member "Tourney_Race".
     *
     * Field represents
     * <p>Tourney in case of Golf</p>
     * <p>Race Name in case of Motor sports</p>
     *
     * @param Tourney_Race The value which will be set
     */
    inline void setTourney_Race (const char* Tourney_Race_);

    /**
     * Sets the value of the member "Tourney_Race".
     *
     * Field represents
     * <p>Tourney in case of Golf</p>
     * <p>Race Name in case of Motor sports</p>
     *
     * @param Tourney_Race The value which will be set
     */
    inline void setTourney_Race (const char* value, size_t size);

    // API of field "EventState"

    static const int kEventState = 1;

    /**
     * Clears the field "EventState".
     *
     * The field will be set to its default value. The hasEventState()
     * method will return false.
     */
    inline void clearEventState();

    /**
     * Checks whether the field "EventState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventState()). Otherwise it will return false.
     */
    inline bool hasEventState () const;

    /**
     * Returns the value of the member "EventState".
     *
     * Field represents the current state of the
     * game
     *
     * @return The value of the field "EventState"
     */
    inline T_e8_Game_Status getEventState () const;

    /**
     * Sets the value of the member "EventState".
     *
     * Field represents the current state of the
     * game
     *
     * @param EventState The value which will be set
     */
    inline void setEventState (T_e8_Game_Status EventState_);

    // API of field "Course_Track"

    static const int kCourse_Track = 2;

    /**
     * Clears the field "Course_Track".
     *
     * The field will be set to its default value. The hasCourse_Track()
     * method will return false.
     */
    inline void clearCourse_Track();

    /**
     * Checks whether the field "Course_Track" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCourse_Track()). Otherwise it will return false.
     */
    inline bool hasCourse_Track () const;

    /**
     * Returns the value of the member "Course_Track".
     *
     * Field represents
     * <p>Course name if the selected sport is Golf</p>
     * <p>Track name if the selected sport is
     * MotorSport</p>
     *
     * @return The value of the field "Course_Track"
     */
    inline const ::std::string& getCourse_Track () const;

    /**
     * Retrieves the value of the field "Course_Track" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Course_Track".
     */
    inline ::std::string& getCourse_TrackMutable ();

    /**
     * Sets the value of the member "Course_Track".
     *
     * Field represents
     * <p>Course name if the selected sport is Golf</p>
     * <p>Track name if the selected sport is
     * MotorSport</p>
     *
     * @param Course_Track The value which will be set
     */
    inline void setCourse_Track (const ::std::string& Course_Track_);

    /**
     * Sets the value of the member "Course_Track".
     *
     * Field represents
     * <p>Course name if the selected sport is Golf</p>
     * <p>Track name if the selected sport is
     * MotorSport</p>
     *
     * @param Course_Track The value which will be set
     */
    inline void setCourse_Track (const char* Course_Track_);

    /**
     * Sets the value of the member "Course_Track".
     *
     * Field represents
     * <p>Course name if the selected sport is Golf</p>
     * <p>Track name if the selected sport is
     * MotorSport</p>
     *
     * @param Course_Track The value which will be set
     */
    inline void setCourse_Track (const char* value, size_t size);

    // API of field "Game_Time"

    static const int kGame_Time = 3;

    /**
     * Clears the field "Game_Time".
     *
     * The field will be set to its default value. The hasGame_Time()
     * method will return false.
     */
    inline void clearGame_Time();

    /**
     * Checks whether the field "Game_Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_Time()). Otherwise it will return false.
     */
    inline bool hasGame_Time () const;

    /**
     * Returns the value of the member "Game_Time".
     *
     * Game Playing Time
     *
     * @return The value of the field "Game_Time"
     */
    inline const T_TimeInfo& getGame_Time () const;

    /**
     * Retrieves the value of the field "Game_Time" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Game_Time".
     */
    inline T_TimeInfo& getGame_TimeMutable ();

    /**
     * Sets the value of the member "Game_Time".
     *
     * Game Playing Time
     *
     * @param Game_Time The value which will be set
     */
    inline void setGame_Time (const T_TimeInfo& Game_Time_);

    // API of field "XMChannelList"

    static const int kXMChannelList = 4;

    /**
     * Clears the field "XMChannelList".
     *
     * The field will be set to its default value. The hasXMChannelList()
     * method will return false.
     */
    inline void clearXMChannelList();

    /**
     * Checks whether the field "XMChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXMChannelList()). Otherwise it will return false.
     */
    inline bool hasXMChannelList () const;

    /**
     * Returns the value of the member "XMChannelList".
     *
     * XM Channel List
     *
     * @return The value of the field "XMChannelList"
     */
    inline const ::std::vector< T_XMChannel >& getXMChannelList () const;

    /**
     * Retrieves the value of the field "XMChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "XMChannelList".
     */
    inline ::std::vector< T_XMChannel >& getXMChannelListMutable ();

    /**
     * Sets the value of the member "XMChannelList".
     *
     * XM Channel List
     *
     * @param XMChannelList The value which will be set
     */
    inline void setXMChannelList (const ::std::vector< T_XMChannel >& XMChannelList_);

    // API of field "Purse_Laps"

    static const int kPurse_Laps = 5;

    /**
     * Clears the field "Purse_Laps".
     *
     * The field will be set to its default value. The hasPurse_Laps()
     * method will return false.
     */
    inline void clearPurse_Laps();

    /**
     * Checks whether the field "Purse_Laps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPurse_Laps()). Otherwise it will return false.
     */
    inline bool hasPurse_Laps () const;

    /**
     * Returns the value of the member "Purse_Laps".
     *
     * Field represents
     * <p>For Golf: The total prize value of the Golfing Event in
     * US Dollars($).</p>
     * <p>Total Laps in the racing circuit if the selected sport
     * is MotorSport</p>
     *
     * @return The value of the field "Purse_Laps"
     */
    inline uint32 getPurse_Laps () const;

    /**
     * Sets the value of the member "Purse_Laps".
     *
     * Field represents
     * <p>For Golf: The total prize value of the Golfing Event in
     * US Dollars($).</p>
     * <p>Total Laps in the racing circuit if the selected sport
     * is MotorSport</p>
     *
     * @param Purse_Laps The value which will be set
     */
    inline void setPurse_Laps (uint32 Purse_Laps_);

    // API of field "Winner"

    static const int kWinner = 6;

    /**
     * Clears the field "Winner".
     *
     * The field will be set to its default value. The hasWinner()
     * method will return false.
     */
    inline void clearWinner();

    /**
     * Checks whether the field "Winner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWinner()). Otherwise it will return false.
     */
    inline bool hasWinner () const;

    /**
     * Returns the value of the member "Winner".
     *
     * This field is applicable for Motor Sports and
     * Golf
     * <p>If the race/event is completed already, this field would
     * contain Winner information.</p>
     * <p>If the race/event is in-progress, this field would
     * contain the leader information</p>
     *
     * @return The value of the field "Winner"
     */
    inline const ::std::string& getWinner () const;

    /**
     * Retrieves the value of the field "Winner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Winner".
     */
    inline ::std::string& getWinnerMutable ();

    /**
     * Sets the value of the member "Winner".
     *
     * This field is applicable for Motor Sports and
     * Golf
     * <p>If the race/event is completed already, this field would
     * contain Winner information.</p>
     * <p>If the race/event is in-progress, this field would
     * contain the leader information</p>
     *
     * @param Winner The value which will be set
     */
    inline void setWinner (const ::std::string& Winner_);

    /**
     * Sets the value of the member "Winner".
     *
     * This field is applicable for Motor Sports and
     * Golf
     * <p>If the race/event is completed already, this field would
     * contain Winner information.</p>
     * <p>If the race/event is in-progress, this field would
     * contain the leader information</p>
     *
     * @param Winner The value which will be set
     */
    inline void setWinner (const char* Winner_);

    /**
     * Sets the value of the member "Winner".
     *
     * This field is applicable for Motor Sports and
     * Golf
     * <p>If the race/event is completed already, this field would
     * contain Winner information.</p>
     * <p>If the race/event is in-progress, this field would
     * contain the leader information</p>
     *
     * @param Winner The value which will be set
     */
    inline void setWinner (const char* value, size_t size);

    // API of field "CarNumber"

    static const int kCarNumber = 7;

    /**
     * Clears the field "CarNumber".
     *
     * The field will be set to its default value. The hasCarNumber()
     * method will return false.
     */
    inline void clearCarNumber();

    /**
     * Checks whether the field "CarNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarNumber()). Otherwise it will return false.
     */
    inline bool hasCarNumber () const;

    /**
     * Returns the value of the member "CarNumber".
     *
     * Field represents the car number of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @return The value of the field "CarNumber"
     */
    inline const ::std::string& getCarNumber () const;

    /**
     * Retrieves the value of the field "CarNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarNumber".
     */
    inline ::std::string& getCarNumberMutable ();

    /**
     * Sets the value of the member "CarNumber".
     *
     * Field represents the car number of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarNumber The value which will be set
     */
    inline void setCarNumber (const ::std::string& CarNumber_);

    /**
     * Sets the value of the member "CarNumber".
     *
     * Field represents the car number of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarNumber The value which will be set
     */
    inline void setCarNumber (const char* CarNumber_);

    /**
     * Sets the value of the member "CarNumber".
     *
     * Field represents the car number of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarNumber The value which will be set
     */
    inline void setCarNumber (const char* value, size_t size);

    // API of field "CarMake"

    static const int kCarMake = 8;

    /**
     * Clears the field "CarMake".
     *
     * The field will be set to its default value. The hasCarMake()
     * method will return false.
     */
    inline void clearCarMake();

    /**
     * Checks whether the field "CarMake" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCarMake()). Otherwise it will return false.
     */
    inline bool hasCarMake () const;

    /**
     * Returns the value of the member "CarMake".
     *
     * Field represents the car make of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @return The value of the field "CarMake"
     */
    inline const ::std::string& getCarMake () const;

    /**
     * Retrieves the value of the field "CarMake" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CarMake".
     */
    inline ::std::string& getCarMakeMutable ();

    /**
     * Sets the value of the member "CarMake".
     *
     * Field represents the car make of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarMake The value which will be set
     */
    inline void setCarMake (const ::std::string& CarMake_);

    /**
     * Sets the value of the member "CarMake".
     *
     * Field represents the car make of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarMake The value which will be set
     */
    inline void setCarMake (const char* CarMake_);

    /**
     * Sets the value of the member "CarMake".
     *
     * Field represents the car make of the
     * <p>Winner if available if the race is already over</p>
     * <p>Leader if the race is in progress</p>
     * <p>For Golf and other Non Team Sports, this field is not
     * applicable and can be reused for future
     * changes.</p>
     *
     * @param CarMake The value which will be set
     */
    inline void setCarMake (const char* value, size_t size);

    // API of field "Yardage_Lap"

    static const int kYardage_Lap = 9;

    /**
     * Clears the field "Yardage_Lap".
     *
     * The field will be set to its default value. The hasYardage_Lap()
     * method will return false.
     */
    inline void clearYardage_Lap();

    /**
     * Checks whether the field "Yardage_Lap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYardage_Lap()). Otherwise it will return false.
     */
    inline bool hasYardage_Lap () const;

    /**
     * Returns the value of the member "Yardage_Lap".
     *
     * Field represents
     * <p>Yardage if the selected sport is Golf</p>
     * <p>For Motor Sports: The laps completed by the race leader
     * if the race is In-Progress. For completed and scheduled
     * races, this field is set to zero.</p>
     *
     * @return The value of the field "Yardage_Lap"
     */
    inline uint32 getYardage_Lap () const;

    /**
     * Sets the value of the member "Yardage_Lap".
     *
     * Field represents
     * <p>Yardage if the selected sport is Golf</p>
     * <p>For Motor Sports: The laps completed by the race leader
     * if the race is In-Progress. For completed and scheduled
     * races, this field is set to zero.</p>
     *
     * @param Yardage_Lap The value which will be set
     */
    inline void setYardage_Lap (uint32 Yardage_Lap_);

    // API of field "IsRankListAvl"

    static const int kIsRankListAvl = 10;

    /**
     * Clears the field "IsRankListAvl".
     *
     * The field will be set to its default value. The hasIsRankListAvl()
     * method will return false.
     */
    inline void clearIsRankListAvl();

    /**
     * Checks whether the field "IsRankListAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsRankListAvl()). Otherwise it will return false.
     */
    inline bool hasIsRankListAvl () const;

    /**
     * Returns the value of the member "IsRankListAvl".
     *
     * TRUE if the LeaderBoard(for Golf) or the
     * Ranking List(for Motor Sports) is available, FALSE
     * otherwise.
     * <p>Based on the status set by this field, HMI has the
     * option of Enabling/Disabling SK for displaying
     * RankList</p>
     *
     * @return The value of the field "IsRankListAvl"
     */
    inline bool getIsRankListAvl () const;

    /**
     * Sets the value of the member "IsRankListAvl".
     *
     * TRUE if the LeaderBoard(for Golf) or the
     * Ranking List(for Motor Sports) is available, FALSE
     * otherwise.
     * <p>Based on the status set by this field, HMI has the
     * option of Enabling/Disabling SK for displaying
     * RankList</p>
     *
     * @param IsRankListAvl The value which will be set
     */
    inline void setIsRankListAvl (bool IsRankListAvl_);

    // API of field "TableParam"

    static const int kTableParam = 11;

    /**
     * Clears the field "TableParam".
     *
     * The field will be set to its default value. The hasTableParam()
     * method will return false.
     */
    inline void clearTableParam();

    /**
     * Checks whether the field "TableParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTableParam()). Otherwise it will return false.
     */
    inline bool hasTableParam () const;

    /**
     * Returns the value of the member "TableParam".
     *
     * The table Parameter value provided by SMSe on
     * callback request. This value has to be passed as a
     * parameter to method GetEventRankList.
     * <p>This parameter is filled only if IsRankListAvl is set to
     * TRUE.</p>
     *
     * @return The value of the field "TableParam"
     */
    inline int32 getTableParam () const;

    /**
     * Sets the value of the member "TableParam".
     *
     * The table Parameter value provided by SMSe on
     * callback request. This value has to be passed as a
     * parameter to method GetEventRankList.
     * <p>This parameter is filled only if IsRankListAvl is set to
     * TRUE.</p>
     *
     * @param TableParam The value which will be set
     */
    inline void setTableParam (int32 TableParam_);

    // API of field "TableRef"

    static const int kTableRef = 12;

    /**
     * Clears the field "TableRef".
     *
     * The field will be set to its default value. The hasTableRef()
     * method will return false.
     */
    inline void clearTableRef();

    /**
     * Checks whether the field "TableRef" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTableRef()). Otherwise it will return false.
     */
    inline bool hasTableRef () const;

    /**
     * Returns the value of the member "TableRef".
     *
     * The TableRef for Ranking List provided by SMSe
     * on callback request. This value has to be passed as a
     * parameter to method GetEventRankList.
     * <p>This parameter is filled only if IsRankListAvl is set to
     * TRUE.</p>
     *
     * @return The value of the field "TableRef"
     */
    inline int32 getTableRef () const;

    /**
     * Sets the value of the member "TableRef".
     *
     * The TableRef for Ranking List provided by SMSe
     * on callback request. This value has to be passed as a
     * parameter to method GetEventRankList.
     * <p>This parameter is filled only if IsRankListAvl is set to
     * TRUE.</p>
     *
     * @param TableRef The value which will be set
     */
    inline void setTableRef (int32 TableRef_);

    // API of field "Event_ID"

    static const int kEvent_ID = 13;

    /**
     * Clears the field "Event_ID".
     *
     * The field will be set to its default value. The hasEvent_ID()
     * method will return false.
     */
    inline void clearEvent_ID();

    /**
     * Checks whether the field "Event_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEvent_ID()). Otherwise it will return false.
     */
    inline bool hasEvent_ID () const;

    /**
     * Returns the value of the member "Event_ID".
     *
     * The generated unique ID for the particular
     * event in the list
     * <p>Every event would have a unique ID.</p>
     *
     * @return The value of the field "Event_ID"
     */
    inline uint32 getEvent_ID () const;

    /**
     * Sets the value of the member "Event_ID".
     *
     * The generated unique ID for the particular
     * event in the list
     * <p>Every event would have a unique ID.</p>
     *
     * @param Event_ID The value which will be set
     */
    inline void setEvent_ID (uint32 Event_ID_);

    static const T_EventSchedule &getDefaultInstance();

private:

    static const ::std::vector< T_XMChannel >& getT_XMChannelList_DefaultInstance ();

    inline void set_has_Tourney_Race ();

    inline void clear_has_Tourney_Race ();

    inline void set_has_EventState ();

    inline void clear_has_EventState ();

    inline void set_has_Course_Track ();

    inline void clear_has_Course_Track ();

    inline void set_has_Game_Time ();

    inline void clear_has_Game_Time ();

    inline void set_has_XMChannelList ();

    inline void clear_has_XMChannelList ();

    inline void set_has_Purse_Laps ();

    inline void clear_has_Purse_Laps ();

    inline void set_has_Winner ();

    inline void clear_has_Winner ();

    inline void set_has_CarNumber ();

    inline void clear_has_CarNumber ();

    inline void set_has_CarMake ();

    inline void clear_has_CarMake ();

    inline void set_has_Yardage_Lap ();

    inline void clear_has_Yardage_Lap ();

    inline void set_has_IsRankListAvl ();

    inline void clear_has_IsRankListAvl ();

    inline void set_has_TableParam ();

    inline void clear_has_TableParam ();

    inline void set_has_TableRef ();

    inline void clear_has_TableRef ();

    inline void set_has_Event_ID ();

    inline void clear_has_Event_ID ();

    uint32 _has_bits_[ (14 + 31) / 32];

    ::std::string _Tourney_Race;

    T_e8_Game_Status _EventState;

    ::std::string _Course_Track;

    T_TimeInfo _Game_Time;

    ::std::vector< T_XMChannel > _XMChannelList;

    uint32 _Purse_Laps;

    ::std::string _Winner;

    ::std::string _CarNumber;

    ::std::string _CarMake;

    uint32 _Yardage_Lap;

    bool _IsRankListAvl;

    int32 _TableParam;

    int32 _TableRef;

    uint32 _Event_ID;

};

/**
 * Listed of Scheduled Events for a selected league.
 * Represents ONLY one of the following options
 * <p>List of all Recent Events for the selected League, or</p>
 * <p>List of all Today's Events for the selected League, or</p>
 * <p>List of all Future Events for the selected
 * League.</p>
 */
class T_EventSchedule_List {
public:

    /**
     * Default constructor
     */
    inline  T_EventSchedule_List ();

    /**
     * Copy constructor
     */
    inline  T_EventSchedule_List (const T_EventSchedule_List &rhs);

    /**
     * All fields constructor
     */
    inline  T_EventSchedule_List (uint8 SPORT_ID_, const T_AffiliateInfo& AFFILIATE_INFO_, bool bIsRecentEventsAvl_, bool bIsCurrentEventsAvl_, bool bIsFutureEventsAvl_, uint32 ListIndex_, T_GameType EventType_, const ::std::vector< T_EventSchedule >& Eventlist_);

    /**
     * Destructor
     */
    inline  ~T_EventSchedule_List();

    /**
     * Assignment operator
     */
    inline T_EventSchedule_List& operator = (const T_EventSchedule_List& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EventSchedule_List& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EventSchedule_List& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EventSchedule_List& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EventSchedule_List& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_INFO"

    static const int kAFFILIATE_INFO = 1;

    /**
     * Clears the field "AFFILIATE_INFO".
     *
     * The field will be set to its default value. The hasAFFILIATE_INFO()
     * method will return false.
     */
    inline void clearAFFILIATE_INFO();

    /**
     * Checks whether the field "AFFILIATE_INFO" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_INFO()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_INFO () const;

    /**
     * Returns the value of the member "AFFILIATE_INFO".
     *
     * Affiliate Info
     *
     * @return The value of the field "AFFILIATE_INFO"
     */
    inline const T_AffiliateInfo& getAFFILIATE_INFO () const;

    /**
     * Retrieves the value of the field "AFFILIATE_INFO" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AFFILIATE_INFO".
     */
    inline T_AffiliateInfo& getAFFILIATE_INFOMutable ();

    /**
     * Sets the value of the member "AFFILIATE_INFO".
     *
     * Affiliate Info
     *
     * @param AFFILIATE_INFO The value which will be set
     */
    inline void setAFFILIATE_INFO (const T_AffiliateInfo& AFFILIATE_INFO_);

    // API of field "bIsRecentEventsAvl"

    static const int kBIsRecentEventsAvl = 2;

    /**
     * Clears the field "bIsRecentEventsAvl".
     *
     * The field will be set to its default value. The hasBIsRecentEventsAvl()
     * method will return false.
     */
    inline void clearBIsRecentEventsAvl();

    /**
     * Checks whether the field "bIsRecentEventsAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsRecentEventsAvl()). Otherwise it will return false.
     */
    inline bool hasBIsRecentEventsAvl () const;

    /**
     * Returns the value of the member "bIsRecentEventsAvl".
     *
     * True if recent events are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsRecentEventsAvl"
     */
    inline bool getBIsRecentEventsAvl () const;

    /**
     * Sets the value of the member "bIsRecentEventsAvl".
     *
     * True if recent events are available; FALSE
     * otherwise
     *
     * @param bIsRecentEventsAvl The value which will be set
     */
    inline void setBIsRecentEventsAvl (bool bIsRecentEventsAvl_);

    // API of field "bIsCurrentEventsAvl"

    static const int kBIsCurrentEventsAvl = 3;

    /**
     * Clears the field "bIsCurrentEventsAvl".
     *
     * The field will be set to its default value. The hasBIsCurrentEventsAvl()
     * method will return false.
     */
    inline void clearBIsCurrentEventsAvl();

    /**
     * Checks whether the field "bIsCurrentEventsAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsCurrentEventsAvl()). Otherwise it will return false.
     */
    inline bool hasBIsCurrentEventsAvl () const;

    /**
     * Returns the value of the member "bIsCurrentEventsAvl".
     *
     * True if current events are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsCurrentEventsAvl"
     */
    inline bool getBIsCurrentEventsAvl () const;

    /**
     * Sets the value of the member "bIsCurrentEventsAvl".
     *
     * True if current events are available; FALSE
     * otherwise
     *
     * @param bIsCurrentEventsAvl The value which will be set
     */
    inline void setBIsCurrentEventsAvl (bool bIsCurrentEventsAvl_);

    // API of field "bIsFutureEventsAvl"

    static const int kBIsFutureEventsAvl = 4;

    /**
     * Clears the field "bIsFutureEventsAvl".
     *
     * The field will be set to its default value. The hasBIsFutureEventsAvl()
     * method will return false.
     */
    inline void clearBIsFutureEventsAvl();

    /**
     * Checks whether the field "bIsFutureEventsAvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsFutureEventsAvl()). Otherwise it will return false.
     */
    inline bool hasBIsFutureEventsAvl () const;

    /**
     * Returns the value of the member "bIsFutureEventsAvl".
     *
     * True if future events are available; FALSE
     * otherwise
     *
     * @return The value of the field "bIsFutureEventsAvl"
     */
    inline bool getBIsFutureEventsAvl () const;

    /**
     * Sets the value of the member "bIsFutureEventsAvl".
     *
     * True if future events are available; FALSE
     * otherwise
     *
     * @param bIsFutureEventsAvl The value which will be set
     */
    inline void setBIsFutureEventsAvl (bool bIsFutureEventsAvl_);

    // API of field "ListIndex"

    static const int kListIndex = 5;

    /**
     * Clears the field "ListIndex".
     *
     * The field will be set to its default value. The hasListIndex()
     * method will return false.
     */
    inline void clearListIndex();

    /**
     * Checks whether the field "ListIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListIndex()). Otherwise it will return false.
     */
    inline bool hasListIndex () const;

    /**
     * Returns the value of the member "ListIndex".
     *
     * Set the list item of the active screen with
     * this Index value.
     * <p>The default or invalid value is 4294967295 (0xffffffff).
     * If this value is passed from FC_SXM_SPORTS, then HMI need
     * not focus on any particular list item.</p>
     * <p>For the valid values, HMI would focus on the index
     * available from this field.</p>
     *
     * @return The value of the field "ListIndex"
     */
    inline uint32 getListIndex () const;

    /**
     * Sets the value of the member "ListIndex".
     *
     * Set the list item of the active screen with
     * this Index value.
     * <p>The default or invalid value is 4294967295 (0xffffffff).
     * If this value is passed from FC_SXM_SPORTS, then HMI need
     * not focus on any particular list item.</p>
     * <p>For the valid values, HMI would focus on the index
     * available from this field.</p>
     *
     * @param ListIndex The value which will be set
     */
    inline void setListIndex (uint32 ListIndex_);

    // API of field "EventType"

    static const int kEventType = 6;

    /**
     * Clears the field "EventType".
     *
     * The field will be set to its default value. The hasEventType()
     * method will return false.
     */
    inline void clearEventType();

    /**
     * Checks whether the field "EventType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventType()). Otherwise it will return false.
     */
    inline bool hasEventType () const;

    /**
     * Returns the value of the member "EventType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @return The value of the field "EventType"
     */
    inline T_GameType getEventType () const;

    /**
     * Sets the value of the member "EventType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @param EventType The value which will be set
     */
    inline void setEventType (T_GameType EventType_);

    // API of field "Eventlist"

    static const int kEventlist = 7;

    /**
     * Clears the field "Eventlist".
     *
     * The field will be set to its default value. The hasEventlist()
     * method will return false.
     */
    inline void clearEventlist();

    /**
     * Checks whether the field "Eventlist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventlist()). Otherwise it will return false.
     */
    inline bool hasEventlist () const;

    /**
     * Returns the value of the member "Eventlist".
     *
     * List of Events
     *
     * @return The value of the field "Eventlist"
     */
    inline const ::std::vector< T_EventSchedule >& getEventlist () const;

    /**
     * Retrieves the value of the field "Eventlist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Eventlist".
     */
    inline ::std::vector< T_EventSchedule >& getEventlistMutable ();

    /**
     * Sets the value of the member "Eventlist".
     *
     * List of Events
     *
     * @param Eventlist The value which will be set
     */
    inline void setEventlist (const ::std::vector< T_EventSchedule >& Eventlist_);

    static const T_EventSchedule_List &getDefaultInstance();

private:

    static const ::std::vector< T_EventSchedule >& getT_EventScheduleList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_INFO ();

    inline void clear_has_AFFILIATE_INFO ();

    inline void set_has_bIsRecentEventsAvl ();

    inline void clear_has_bIsRecentEventsAvl ();

    inline void set_has_bIsCurrentEventsAvl ();

    inline void clear_has_bIsCurrentEventsAvl ();

    inline void set_has_bIsFutureEventsAvl ();

    inline void clear_has_bIsFutureEventsAvl ();

    inline void set_has_ListIndex ();

    inline void clear_has_ListIndex ();

    inline void set_has_EventType ();

    inline void clear_has_EventType ();

    inline void set_has_Eventlist ();

    inline void clear_has_Eventlist ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint8 _SPORT_ID;

    T_AffiliateInfo _AFFILIATE_INFO;

    bool _bIsRecentEventsAvl;

    bool _bIsCurrentEventsAvl;

    bool _bIsFutureEventsAvl;

    uint32 _ListIndex;

    T_GameType _EventType;

    ::std::vector< T_EventSchedule > _Eventlist;

};

/**
 * Information needed to display Ranked List Screen
 * for Non-Team Sports. This type contains the ranking information
 * of one single player or driver for an Event that is in
 * progress.
 */
class T_EventRank {
public:

    /**
     * Default constructor
     */
    inline  T_EventRank ();

    /**
     * Copy constructor
     */
    inline  T_EventRank (const T_EventRank &rhs);

    /**
     * All fields constructor
     */
    inline  T_EventRank (const ::std::string& Rank_, const ::std::string& Name_, uint32 Laps_, const ::std::string& Score_Make_, const ::std::string& Number_);

    /**
     * Destructor
     */
    inline  ~T_EventRank();

    /**
     * Assignment operator
     */
    inline T_EventRank& operator = (const T_EventRank& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EventRank& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EventRank& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EventRank& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EventRank& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Rank"

    static const int kRank = 0;

    /**
     * Clears the field "Rank".
     *
     * The field will be set to its default value. The hasRank()
     * method will return false.
     */
    inline void clearRank();

    /**
     * Checks whether the field "Rank" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRank()). Otherwise it will return false.
     */
    inline bool hasRank () const;

    /**
     * Returns the value of the member "Rank".
     *
     * This field represents
     * <p>For Golf: the Ranking of a player;</p>
     * <p>For Motor sports: Standing of a
     * driver.</p>
     *
     * @return The value of the field "Rank"
     */
    inline const ::std::string& getRank () const;

    /**
     * Retrieves the value of the field "Rank" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Rank".
     */
    inline ::std::string& getRankMutable ();

    /**
     * Sets the value of the member "Rank".
     *
     * This field represents
     * <p>For Golf: the Ranking of a player;</p>
     * <p>For Motor sports: Standing of a
     * driver.</p>
     *
     * @param Rank The value which will be set
     */
    inline void setRank (const ::std::string& Rank_);

    /**
     * Sets the value of the member "Rank".
     *
     * This field represents
     * <p>For Golf: the Ranking of a player;</p>
     * <p>For Motor sports: Standing of a
     * driver.</p>
     *
     * @param Rank The value which will be set
     */
    inline void setRank (const char* Rank_);

    /**
     * Sets the value of the member "Rank".
     *
     * This field represents
     * <p>For Golf: the Ranking of a player;</p>
     * <p>For Motor sports: Standing of a
     * driver.</p>
     *
     * @param Rank The value which will be set
     */
    inline void setRank (const char* value, size_t size);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * This field represents
     * <p>For Golf: The Golfer Name;</p>
     * <p>For Motor sports: The Driver Name.</p>
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * This field represents
     * <p>For Golf: The Golfer Name;</p>
     * <p>For Motor sports: The Driver Name.</p>
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * This field represents
     * <p>For Golf: The Golfer Name;</p>
     * <p>For Motor sports: The Driver Name.</p>
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * This field represents
     * <p>For Golf: The Golfer Name;</p>
     * <p>For Motor sports: The Driver Name.</p>
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "Laps"

    static const int kLaps = 2;

    /**
     * Clears the field "Laps".
     *
     * The field will be set to its default value. The hasLaps()
     * method will return false.
     */
    inline void clearLaps();

    /**
     * Checks whether the field "Laps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLaps()). Otherwise it will return false.
     */
    inline bool hasLaps () const;

    /**
     * Returns the value of the member "Laps".
     *
     * This field represents the number of laps
     * completed by a driver and is applicable only for Motor
     * Sports.
     * <p>This field is not applicable for other Sports such as
     * Golf.</p>
     *
     * @return The value of the field "Laps"
     */
    inline uint32 getLaps () const;

    /**
     * Sets the value of the member "Laps".
     *
     * This field represents the number of laps
     * completed by a driver and is applicable only for Motor
     * Sports.
     * <p>This field is not applicable for other Sports such as
     * Golf.</p>
     *
     * @param Laps The value which will be set
     */
    inline void setLaps (uint32 Laps_);

    // API of field "Score_Make"

    static const int kScore_Make = 3;

    /**
     * Clears the field "Score_Make".
     *
     * The field will be set to its default value. The hasScore_Make()
     * method will return false.
     */
    inline void clearScore_Make();

    /**
     * Checks whether the field "Score_Make" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScore_Make()). Otherwise it will return false.
     */
    inline bool hasScore_Make () const;

    /**
     * Returns the value of the member "Score_Make".
     *
     * This field represents
     * <p>For Golf: The scores achieved by a Golfer;</p>
     * <p>For Motor Sports: The car manufacturer
     * name</p>
     *
     * @return The value of the field "Score_Make"
     */
    inline const ::std::string& getScore_Make () const;

    /**
     * Retrieves the value of the field "Score_Make" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Score_Make".
     */
    inline ::std::string& getScore_MakeMutable ();

    /**
     * Sets the value of the member "Score_Make".
     *
     * This field represents
     * <p>For Golf: The scores achieved by a Golfer;</p>
     * <p>For Motor Sports: The car manufacturer
     * name</p>
     *
     * @param Score_Make The value which will be set
     */
    inline void setScore_Make (const ::std::string& Score_Make_);

    /**
     * Sets the value of the member "Score_Make".
     *
     * This field represents
     * <p>For Golf: The scores achieved by a Golfer;</p>
     * <p>For Motor Sports: The car manufacturer
     * name</p>
     *
     * @param Score_Make The value which will be set
     */
    inline void setScore_Make (const char* Score_Make_);

    /**
     * Sets the value of the member "Score_Make".
     *
     * This field represents
     * <p>For Golf: The scores achieved by a Golfer;</p>
     * <p>For Motor Sports: The car manufacturer
     * name</p>
     *
     * @param Score_Make The value which will be set
     */
    inline void setScore_Make (const char* value, size_t size);

    // API of field "Number"

    static const int kNumber = 4;

    /**
     * Clears the field "Number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "Number".
     *
     * The car number that is/was used by the driver
     * during the race and is not applicable for other
     * Sports.
     *
     * @return The value of the field "Number"
     */
    inline const ::std::string& getNumber () const;

    /**
     * Retrieves the value of the field "Number" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Number".
     */
    inline ::std::string& getNumberMutable ();

    /**
     * Sets the value of the member "Number".
     *
     * The car number that is/was used by the driver
     * during the race and is not applicable for other
     * Sports.
     *
     * @param Number The value which will be set
     */
    inline void setNumber (const ::std::string& Number_);

    /**
     * Sets the value of the member "Number".
     *
     * The car number that is/was used by the driver
     * during the race and is not applicable for other
     * Sports.
     *
     * @param Number The value which will be set
     */
    inline void setNumber (const char* Number_);

    /**
     * Sets the value of the member "Number".
     *
     * The car number that is/was used by the driver
     * during the race and is not applicable for other
     * Sports.
     *
     * @param Number The value which will be set
     */
    inline void setNumber (const char* value, size_t size);

    static const T_EventRank &getDefaultInstance();

private:

    inline void set_has_Rank ();

    inline void clear_has_Rank ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_Laps ();

    inline void clear_has_Laps ();

    inline void set_has_Score_Make ();

    inline void clear_has_Score_Make ();

    inline void set_has_Number ();

    inline void clear_has_Number ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _Rank;

    ::std::string _Name;

    uint32 _Laps;

    ::std::string _Score_Make;

    ::std::string _Number;

};

/**
 * Information needed to display Ranked List Screen
 * for Non-Team Sports. This type can be used for displaying the
 * Leader-board in Golf and for displaying driver standings in
 * Motor sports.
 */
class T_EventRankList {
public:

    /**
     * Default constructor
     */
    inline  T_EventRankList ();

    /**
     * Copy constructor
     */
    inline  T_EventRankList (const T_EventRankList &rhs);

    /**
     * All fields constructor
     */
    inline  T_EventRankList (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_EventRank >& RankList_);

    /**
     * Destructor
     */
    inline  ~T_EventRankList();

    /**
     * Assignment operator
     */
    inline T_EventRankList& operator = (const T_EventRankList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EventRankList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EventRankList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EventRankList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EventRankList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPORT_ID"

    static const int kSPORT_ID = 0;

    /**
     * Clears the field "SPORT_ID".
     *
     * The field will be set to its default value. The hasSPORT_ID()
     * method will return false.
     */
    inline void clearSPORT_ID();

    /**
     * Checks whether the field "SPORT_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPORT_ID()). Otherwise it will return false.
     */
    inline bool hasSPORT_ID () const;

    /**
     * Returns the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @return The value of the field "SPORT_ID"
     */
    inline uint8 getSPORT_ID () const;

    /**
     * Sets the value of the member "SPORT_ID".
     *
     * Sport ID
     *
     * @param SPORT_ID The value which will be set
     */
    inline void setSPORT_ID (uint8 SPORT_ID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "RankList"

    static const int kRankList = 2;

    /**
     * Clears the field "RankList".
     *
     * The field will be set to its default value. The hasRankList()
     * method will return false.
     */
    inline void clearRankList();

    /**
     * Checks whether the field "RankList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRankList()). Otherwise it will return false.
     */
    inline bool hasRankList () const;

    /**
     * Returns the value of the member "RankList".
     *
     * List of Drivers/Players and their
     * standings/rankings.
     *
     * @return The value of the field "RankList"
     */
    inline const ::std::vector< T_EventRank >& getRankList () const;

    /**
     * Retrieves the value of the field "RankList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RankList".
     */
    inline ::std::vector< T_EventRank >& getRankListMutable ();

    /**
     * Sets the value of the member "RankList".
     *
     * List of Drivers/Players and their
     * standings/rankings.
     *
     * @param RankList The value which will be set
     */
    inline void setRankList (const ::std::vector< T_EventRank >& RankList_);

    static const T_EventRankList &getDefaultInstance();

private:

    static const ::std::vector< T_EventRank >& getT_EventRankList_DefaultInstance ();

    inline void set_has_SPORT_ID ();

    inline void clear_has_SPORT_ID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_RankList ();

    inline void clear_has_RankList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _SPORT_ID;

    uint32 _AFFILIATE_ID;

    ::std::vector< T_EventRank > _RankList;

};

/**
 * If the meaning of "T_NewsInfo" isn't clear, then there should be a description here.
 */
class T_NewsInfo {
public:

    /**
     * Default constructor
     */
    inline  T_NewsInfo ();

    /**
     * Copy constructor
     */
    inline  T_NewsInfo (const T_NewsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_NewsInfo (const ::std::string& NewsInDetail_);

    /**
     * Destructor
     */
    inline  ~T_NewsInfo();

    /**
     * Assignment operator
     */
    inline T_NewsInfo& operator = (const T_NewsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_NewsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_NewsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_NewsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_NewsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NewsInDetail"

    static const int kNewsInDetail = 0;

    /**
     * Clears the field "NewsInDetail".
     *
     * The field will be set to its default value. The hasNewsInDetail()
     * method will return false.
     */
    inline void clearNewsInDetail();

    /**
     * Checks whether the field "NewsInDetail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewsInDetail()). Otherwise it will return false.
     */
    inline bool hasNewsInDetail () const;

    /**
     * Returns the value of the member "NewsInDetail".
     *
     * Detailed News
     *
     * @return The value of the field "NewsInDetail"
     */
    inline const ::std::string& getNewsInDetail () const;

    /**
     * Retrieves the value of the field "NewsInDetail" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NewsInDetail".
     */
    inline ::std::string& getNewsInDetailMutable ();

    /**
     * Sets the value of the member "NewsInDetail".
     *
     * Detailed News
     *
     * @param NewsInDetail The value which will be set
     */
    inline void setNewsInDetail (const ::std::string& NewsInDetail_);

    /**
     * Sets the value of the member "NewsInDetail".
     *
     * Detailed News
     *
     * @param NewsInDetail The value which will be set
     */
    inline void setNewsInDetail (const char* NewsInDetail_);

    /**
     * Sets the value of the member "NewsInDetail".
     *
     * Detailed News
     *
     * @param NewsInDetail The value which will be set
     */
    inline void setNewsInDetail (const char* value, size_t size);

    static const T_NewsInfo &getDefaultInstance();

private:

    inline void set_has_NewsInDetail ();

    inline void clear_has_NewsInDetail ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _NewsInDetail;

};

inline  T_SportInfo::T_SportInfo ()  :
    _SPORT_ID (0u),
    _SportName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SportInfo::T_SportInfo (const T_SportInfo &rhs)  :
    _SPORT_ID (0u),
    _SportName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SportInfo::T_SportInfo (uint8 SPORT_ID_, const ::std::string& SportName_)  :
    _SPORT_ID (SPORT_ID_),
    _SportName (SportName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SportInfo::~T_SportInfo() {
}

inline T_SportInfo& T_SportInfo::operator = (const T_SportInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasSportName()) {
            setSportName(rhs.getSportName());
        } else {
            clearSportName();
        }
    }
    return *this;
}

inline bool T_SportInfo::operator == (const T_SportInfo& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasSportName() && !rhs.hasSportName()) || getSportName() == rhs.getSportName()));
}

inline bool T_SportInfo::operator != (const T_SportInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SportInfo::operator < (const T_SportInfo& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasSportName() || rhs.hasSportName()) {
        if (getSportName() < rhs.getSportName()) return true;
        if (getSportName() > rhs.getSportName()) return false;
    }
    return false;
}

inline bool T_SportInfo::operator > (const T_SportInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SportInfo::clear() {
    clearSPORT_ID();
    clearSportName();
}

inline void T_SportInfo::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_SportInfo::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SportInfo::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_SportInfo::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_SportInfo::clearSportName() {
    if (hasSportName()) {
         clear_has_SportName();
        _SportName.clear();
     }
}

inline bool T_SportInfo::hasSportName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SportInfo::getSportName () const {
    return _SportName;
}

inline ::std::string& T_SportInfo::getSportNameMutable () {
    set_has_SportName();
    return _SportName;
}

inline void T_SportInfo::setSportName (const ::std::string& SportName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportName();
    this->_SportName = SportName_;
}

inline void T_SportInfo::setSportName (const char* SportName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SportName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportName();
    this->_SportName.assign(SportName_);
}

inline void T_SportInfo::setSportName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SportName();
    this->_SportName.assign(value, size);
}

inline void T_SportInfo::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SportInfo::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SportInfo::set_has_SportName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SportInfo::clear_has_SportName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AffiliateInfo::T_AffiliateInfo ()  :
    _AFFILIATE_ID (0u),
    _AffiliateName (),
    _InSeason (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AffiliateInfo::T_AffiliateInfo (const T_AffiliateInfo &rhs)  :
    _AFFILIATE_ID (0u),
    _AffiliateName (),
    _InSeason (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AffiliateInfo::T_AffiliateInfo (uint32 AFFILIATE_ID_, const ::std::string& AffiliateName_, bool InSeason_)  :
    _AFFILIATE_ID (AFFILIATE_ID_),
    _AffiliateName (AffiliateName_),
    _InSeason (InSeason_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AffiliateName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AffiliateInfo::~T_AffiliateInfo() {
}

inline T_AffiliateInfo& T_AffiliateInfo::operator = (const T_AffiliateInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasAffiliateName()) {
            setAffiliateName(rhs.getAffiliateName());
        } else {
            clearAffiliateName();
        }
        if (rhs.hasInSeason()) {
            setInSeason(rhs.getInSeason());
        } else {
            clearInSeason();
        }
    }
    return *this;
}

inline bool T_AffiliateInfo::operator == (const T_AffiliateInfo& rhs) const {
    return (((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasAffiliateName() && !rhs.hasAffiliateName()) || getAffiliateName() == rhs.getAffiliateName()) &&
        ((!hasInSeason() && !rhs.hasInSeason()) || getInSeason() == rhs.getInSeason()));
}

inline bool T_AffiliateInfo::operator != (const T_AffiliateInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AffiliateInfo::operator < (const T_AffiliateInfo& rhs) const {
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasAffiliateName() || rhs.hasAffiliateName()) {
        if (getAffiliateName() < rhs.getAffiliateName()) return true;
        if (getAffiliateName() > rhs.getAffiliateName()) return false;
    }
    if (hasInSeason() || rhs.hasInSeason()) {
        if (getInSeason() < rhs.getInSeason()) return true;
        if (getInSeason() > rhs.getInSeason()) return false;
    }
    return false;
}

inline bool T_AffiliateInfo::operator > (const T_AffiliateInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AffiliateInfo::clear() {
    clearAFFILIATE_ID();
    clearAffiliateName();
    clearInSeason();
}

inline void T_AffiliateInfo::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_AffiliateInfo::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_AffiliateInfo::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_AffiliateInfo::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_AffiliateInfo::clearAffiliateName() {
    if (hasAffiliateName()) {
         clear_has_AffiliateName();
        _AffiliateName.clear();
     }
}

inline bool T_AffiliateInfo::hasAffiliateName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_AffiliateInfo::getAffiliateName () const {
    return _AffiliateName;
}

inline ::std::string& T_AffiliateInfo::getAffiliateNameMutable () {
    set_has_AffiliateName();
    return _AffiliateName;
}

inline void T_AffiliateInfo::setAffiliateName (const ::std::string& AffiliateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AffiliateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AffiliateName();
    this->_AffiliateName = AffiliateName_;
}

inline void T_AffiliateInfo::setAffiliateName (const char* AffiliateName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AffiliateName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AffiliateName();
    this->_AffiliateName.assign(AffiliateName_);
}

inline void T_AffiliateInfo::setAffiliateName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AffiliateName();
    this->_AffiliateName.assign(value, size);
}

inline void T_AffiliateInfo::clearInSeason() {
    if (hasInSeason()) {
         clear_has_InSeason();
        _InSeason = false;
     }
}

inline bool T_AffiliateInfo::hasInSeason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_AffiliateInfo::getInSeason () const {
    return _InSeason;
}

inline void T_AffiliateInfo::setInSeason (bool InSeason_) {
    set_has_InSeason();
    this->_InSeason = InSeason_;
}

inline void T_AffiliateInfo::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AffiliateInfo::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AffiliateInfo::set_has_AffiliateName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AffiliateInfo::clear_has_AffiliateName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AffiliateInfo::set_has_InSeason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AffiliateInfo::clear_has_InSeason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_RootAffiliateList::T_RootAffiliateList ()  :
    _SPORT_ID (0u),
    _RootAffiliateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RootAffiliateList::T_RootAffiliateList (const T_RootAffiliateList &rhs)  :
    _SPORT_ID (0u),
    _RootAffiliateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RootAffiliateList::T_RootAffiliateList (uint8 SPORT_ID_, const ::std::vector< T_AffiliateInfo >& RootAffiliateList_)  :
    _SPORT_ID (SPORT_ID_),
    _RootAffiliateList (RootAffiliateList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RootAffiliateList::~T_RootAffiliateList() {
}

inline T_RootAffiliateList& T_RootAffiliateList::operator = (const T_RootAffiliateList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasRootAffiliateList()) {
            setRootAffiliateList(rhs.getRootAffiliateList());
        } else {
            clearRootAffiliateList();
        }
    }
    return *this;
}

inline bool T_RootAffiliateList::operator == (const T_RootAffiliateList& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasRootAffiliateList() && !rhs.hasRootAffiliateList()) || getRootAffiliateList() == rhs.getRootAffiliateList()));
}

inline bool T_RootAffiliateList::operator != (const T_RootAffiliateList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RootAffiliateList::operator < (const T_RootAffiliateList& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasRootAffiliateList() || rhs.hasRootAffiliateList()) {
        if (getRootAffiliateList() < rhs.getRootAffiliateList()) return true;
        if (getRootAffiliateList() > rhs.getRootAffiliateList()) return false;
    }
    return false;
}

inline bool T_RootAffiliateList::operator > (const T_RootAffiliateList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RootAffiliateList::clear() {
    clearSPORT_ID();
    clearRootAffiliateList();
}

inline void T_RootAffiliateList::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_RootAffiliateList::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_RootAffiliateList::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_RootAffiliateList::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_RootAffiliateList::clearRootAffiliateList() {
    if (hasRootAffiliateList()) {
         clear_has_RootAffiliateList();
        _RootAffiliateList.clear();
     }
}

inline bool T_RootAffiliateList::hasRootAffiliateList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_AffiliateInfo >& T_RootAffiliateList::getRootAffiliateList () const {
    return _RootAffiliateList;
}

inline ::std::vector< T_AffiliateInfo >& T_RootAffiliateList::getRootAffiliateListMutable () {
    set_has_RootAffiliateList();
    return _RootAffiliateList;
}

inline void T_RootAffiliateList::setRootAffiliateList (const ::std::vector< T_AffiliateInfo >& RootAffiliateList_) {
    set_has_RootAffiliateList();
    this->_RootAffiliateList = RootAffiliateList_;
}

inline void T_RootAffiliateList::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RootAffiliateList::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RootAffiliateList::set_has_RootAffiliateList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RootAffiliateList::clear_has_RootAffiliateList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AffiliateDetailInfo::T_AffiliateDetailInfo ()  :
    _Category_ID (::sxm_sports_main_fi_types::T_AffiliateCategories__News),
    _isDataAvailable (::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE),
    _SUB_LEAGUE_INFO ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AffiliateDetailInfo::T_AffiliateDetailInfo (const T_AffiliateDetailInfo &rhs)  :
    _Category_ID (::sxm_sports_main_fi_types::T_AffiliateCategories__News),
    _isDataAvailable (::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE),
    _SUB_LEAGUE_INFO ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AffiliateDetailInfo::T_AffiliateDetailInfo (T_AffiliateCategories Category_ID_, T_e8CategoryAvailability isDataAvailable_, const T_AffiliateInfo& SUB_LEAGUE_INFO_)  :
    _Category_ID (Category_ID_),
    _isDataAvailable (isDataAvailable_),
    _SUB_LEAGUE_INFO (SUB_LEAGUE_INFO_)
{
    #ifndef NDEBUG
    if (!(T_AffiliateCategories_IsValid(Category_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Category_ID_, "T_AffiliateCategories", "Category_ID", "T_AffiliateDetailInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8CategoryAvailability_IsValid(isDataAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", isDataAvailable_, "T_e8CategoryAvailability", "isDataAvailable", "T_AffiliateDetailInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AffiliateDetailInfo::~T_AffiliateDetailInfo() {
}

inline T_AffiliateDetailInfo& T_AffiliateDetailInfo::operator = (const T_AffiliateDetailInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCategory_ID()) {
            setCategory_ID(rhs.getCategory_ID());
        } else {
            clearCategory_ID();
        }
        if (rhs.hasIsDataAvailable()) {
            setIsDataAvailable(rhs.getIsDataAvailable());
        } else {
            clearIsDataAvailable();
        }
        if (rhs.hasSUB_LEAGUE_INFO()) {
            setSUB_LEAGUE_INFO(rhs.getSUB_LEAGUE_INFO());
        } else {
            clearSUB_LEAGUE_INFO();
        }
    }
    return *this;
}

inline bool T_AffiliateDetailInfo::operator == (const T_AffiliateDetailInfo& rhs) const {
    return (((!hasCategory_ID() && !rhs.hasCategory_ID()) || getCategory_ID() == rhs.getCategory_ID()) &&
        ((!hasIsDataAvailable() && !rhs.hasIsDataAvailable()) || getIsDataAvailable() == rhs.getIsDataAvailable()) &&
        ((!hasSUB_LEAGUE_INFO() && !rhs.hasSUB_LEAGUE_INFO()) || getSUB_LEAGUE_INFO() == rhs.getSUB_LEAGUE_INFO()));
}

inline bool T_AffiliateDetailInfo::operator != (const T_AffiliateDetailInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AffiliateDetailInfo::operator < (const T_AffiliateDetailInfo& rhs) const {
    if (hasCategory_ID() || rhs.hasCategory_ID()) {
        if ((uint32)getCategory_ID() < (uint32)rhs.getCategory_ID()) return true;
        if ((uint32)getCategory_ID() > (uint32)rhs.getCategory_ID()) return false;
    }
    if (hasIsDataAvailable() || rhs.hasIsDataAvailable()) {
        if ((uint32)getIsDataAvailable() < (uint32)rhs.getIsDataAvailable()) return true;
        if ((uint32)getIsDataAvailable() > (uint32)rhs.getIsDataAvailable()) return false;
    }
    if (hasSUB_LEAGUE_INFO() || rhs.hasSUB_LEAGUE_INFO()) {
        if (getSUB_LEAGUE_INFO() < rhs.getSUB_LEAGUE_INFO()) return true;
        if (getSUB_LEAGUE_INFO() > rhs.getSUB_LEAGUE_INFO()) return false;
    }
    return false;
}

inline bool T_AffiliateDetailInfo::operator > (const T_AffiliateDetailInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AffiliateDetailInfo::clear() {
    clearCategory_ID();
    clearIsDataAvailable();
    clearSUB_LEAGUE_INFO();
}

inline void T_AffiliateDetailInfo::clearCategory_ID() {
    if (hasCategory_ID()) {
         clear_has_Category_ID();
        _Category_ID = ::sxm_sports_main_fi_types::T_AffiliateCategories__News;
     }
}

inline bool T_AffiliateDetailInfo::hasCategory_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_AffiliateCategories T_AffiliateDetailInfo::getCategory_ID () const {
    return _Category_ID;
}

inline void T_AffiliateDetailInfo::setCategory_ID (T_AffiliateCategories Category_ID_) {
    #ifndef NDEBUG
    if (!(T_AffiliateCategories_IsValid(Category_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Category_ID_, "T_AffiliateCategories", "Category_ID", "T_AffiliateDetailInfo");
    }
    #endif
    set_has_Category_ID();
    this->_Category_ID = Category_ID_;
}

inline void T_AffiliateDetailInfo::clearIsDataAvailable() {
    if (hasIsDataAvailable()) {
         clear_has_isDataAvailable();
        _isDataAvailable = ::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE;
     }
}

inline bool T_AffiliateDetailInfo::hasIsDataAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8CategoryAvailability T_AffiliateDetailInfo::getIsDataAvailable () const {
    return _isDataAvailable;
}

inline void T_AffiliateDetailInfo::setIsDataAvailable (T_e8CategoryAvailability isDataAvailable_) {
    #ifndef NDEBUG
    if (!(T_e8CategoryAvailability_IsValid(isDataAvailable_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", isDataAvailable_, "T_e8CategoryAvailability", "isDataAvailable", "T_AffiliateDetailInfo");
    }
    #endif
    set_has_isDataAvailable();
    this->_isDataAvailable = isDataAvailable_;
}

inline void T_AffiliateDetailInfo::clearSUB_LEAGUE_INFO() {
    if (hasSUB_LEAGUE_INFO()) {
         clear_has_SUB_LEAGUE_INFO();
        _SUB_LEAGUE_INFO.clear();
     }
}

inline bool T_AffiliateDetailInfo::hasSUB_LEAGUE_INFO () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_AffiliateInfo& T_AffiliateDetailInfo::getSUB_LEAGUE_INFO () const {
    return _SUB_LEAGUE_INFO;
}

inline T_AffiliateInfo& T_AffiliateDetailInfo::getSUB_LEAGUE_INFOMutable () {
    set_has_SUB_LEAGUE_INFO();
    return _SUB_LEAGUE_INFO;
}

inline void T_AffiliateDetailInfo::setSUB_LEAGUE_INFO (const T_AffiliateInfo& SUB_LEAGUE_INFO_) {
    set_has_SUB_LEAGUE_INFO();
    this->_SUB_LEAGUE_INFO = SUB_LEAGUE_INFO_;
}

inline void T_AffiliateDetailInfo::set_has_Category_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AffiliateDetailInfo::clear_has_Category_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AffiliateDetailInfo::set_has_isDataAvailable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AffiliateDetailInfo::clear_has_isDataAvailable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AffiliateDetailInfo::set_has_SUB_LEAGUE_INFO () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AffiliateDetailInfo::clear_has_SUB_LEAGUE_INFO () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AffiliateDetails::T_AffiliateDetails ()  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _AffiliateDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AffiliateDetails::T_AffiliateDetails (const T_AffiliateDetails &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _AffiliateDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AffiliateDetails::T_AffiliateDetails (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_AffiliateDetailInfo >& AffiliateDetails_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _AffiliateDetails (AffiliateDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AffiliateDetails::~T_AffiliateDetails() {
}

inline T_AffiliateDetails& T_AffiliateDetails::operator = (const T_AffiliateDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasAffiliateDetails()) {
            setAffiliateDetails(rhs.getAffiliateDetails());
        } else {
            clearAffiliateDetails();
        }
    }
    return *this;
}

inline bool T_AffiliateDetails::operator == (const T_AffiliateDetails& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasAffiliateDetails() && !rhs.hasAffiliateDetails()) || getAffiliateDetails() == rhs.getAffiliateDetails()));
}

inline bool T_AffiliateDetails::operator != (const T_AffiliateDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AffiliateDetails::operator < (const T_AffiliateDetails& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasAffiliateDetails() || rhs.hasAffiliateDetails()) {
        if (getAffiliateDetails() < rhs.getAffiliateDetails()) return true;
        if (getAffiliateDetails() > rhs.getAffiliateDetails()) return false;
    }
    return false;
}

inline bool T_AffiliateDetails::operator > (const T_AffiliateDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AffiliateDetails::clear() {
    clearSPORT_ID();
    clearAFFILIATE_ID();
    clearAffiliateDetails();
}

inline void T_AffiliateDetails::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_AffiliateDetails::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AffiliateDetails::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_AffiliateDetails::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_AffiliateDetails::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_AffiliateDetails::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_AffiliateDetails::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_AffiliateDetails::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_AffiliateDetails::clearAffiliateDetails() {
    if (hasAffiliateDetails()) {
         clear_has_AffiliateDetails();
        _AffiliateDetails.clear();
     }
}

inline bool T_AffiliateDetails::hasAffiliateDetails () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_AffiliateDetailInfo >& T_AffiliateDetails::getAffiliateDetails () const {
    return _AffiliateDetails;
}

inline ::std::vector< T_AffiliateDetailInfo >& T_AffiliateDetails::getAffiliateDetailsMutable () {
    set_has_AffiliateDetails();
    return _AffiliateDetails;
}

inline void T_AffiliateDetails::setAffiliateDetails (const ::std::vector< T_AffiliateDetailInfo >& AffiliateDetails_) {
    set_has_AffiliateDetails();
    this->_AffiliateDetails = AffiliateDetails_;
}

inline void T_AffiliateDetails::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AffiliateDetails::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AffiliateDetails::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AffiliateDetails::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AffiliateDetails::set_has_AffiliateDetails () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AffiliateDetails::clear_has_AffiliateDetails () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SubLeagues::T_SubLeagues ()  :
    _SUB_LEAGUE_ID (0u),
    _SUB_LEAGUE_NAME ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SubLeagues::T_SubLeagues (const T_SubLeagues &rhs)  :
    _SUB_LEAGUE_ID (0u),
    _SUB_LEAGUE_NAME ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SubLeagues::T_SubLeagues (uint32 SUB_LEAGUE_ID_, const ::std::string& SUB_LEAGUE_NAME_)  :
    _SUB_LEAGUE_ID (SUB_LEAGUE_ID_),
    _SUB_LEAGUE_NAME (SUB_LEAGUE_NAME_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SUB_LEAGUE_NAME_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SubLeagues::~T_SubLeagues() {
}

inline T_SubLeagues& T_SubLeagues::operator = (const T_SubLeagues& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSUB_LEAGUE_ID()) {
            setSUB_LEAGUE_ID(rhs.getSUB_LEAGUE_ID());
        } else {
            clearSUB_LEAGUE_ID();
        }
        if (rhs.hasSUB_LEAGUE_NAME()) {
            setSUB_LEAGUE_NAME(rhs.getSUB_LEAGUE_NAME());
        } else {
            clearSUB_LEAGUE_NAME();
        }
    }
    return *this;
}

inline bool T_SubLeagues::operator == (const T_SubLeagues& rhs) const {
    return (((!hasSUB_LEAGUE_ID() && !rhs.hasSUB_LEAGUE_ID()) || getSUB_LEAGUE_ID() == rhs.getSUB_LEAGUE_ID()) &&
        ((!hasSUB_LEAGUE_NAME() && !rhs.hasSUB_LEAGUE_NAME()) || getSUB_LEAGUE_NAME() == rhs.getSUB_LEAGUE_NAME()));
}

inline bool T_SubLeagues::operator != (const T_SubLeagues& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SubLeagues::operator < (const T_SubLeagues& rhs) const {
    if (hasSUB_LEAGUE_ID() || rhs.hasSUB_LEAGUE_ID()) {
        if (getSUB_LEAGUE_ID() < rhs.getSUB_LEAGUE_ID()) return true;
        if (getSUB_LEAGUE_ID() > rhs.getSUB_LEAGUE_ID()) return false;
    }
    if (hasSUB_LEAGUE_NAME() || rhs.hasSUB_LEAGUE_NAME()) {
        if (getSUB_LEAGUE_NAME() < rhs.getSUB_LEAGUE_NAME()) return true;
        if (getSUB_LEAGUE_NAME() > rhs.getSUB_LEAGUE_NAME()) return false;
    }
    return false;
}

inline bool T_SubLeagues::operator > (const T_SubLeagues& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SubLeagues::clear() {
    clearSUB_LEAGUE_ID();
    clearSUB_LEAGUE_NAME();
}

inline void T_SubLeagues::clearSUB_LEAGUE_ID() {
    if (hasSUB_LEAGUE_ID()) {
         clear_has_SUB_LEAGUE_ID();
        _SUB_LEAGUE_ID = 0u;
     }
}

inline bool T_SubLeagues::hasSUB_LEAGUE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SubLeagues::getSUB_LEAGUE_ID () const {
    return _SUB_LEAGUE_ID;
}

inline void T_SubLeagues::setSUB_LEAGUE_ID (uint32 SUB_LEAGUE_ID_) {
    set_has_SUB_LEAGUE_ID();
    this->_SUB_LEAGUE_ID = SUB_LEAGUE_ID_;
}

inline void T_SubLeagues::clearSUB_LEAGUE_NAME() {
    if (hasSUB_LEAGUE_NAME()) {
         clear_has_SUB_LEAGUE_NAME();
        _SUB_LEAGUE_NAME.clear();
     }
}

inline bool T_SubLeagues::hasSUB_LEAGUE_NAME () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SubLeagues::getSUB_LEAGUE_NAME () const {
    return _SUB_LEAGUE_NAME;
}

inline ::std::string& T_SubLeagues::getSUB_LEAGUE_NAMEMutable () {
    set_has_SUB_LEAGUE_NAME();
    return _SUB_LEAGUE_NAME;
}

inline void T_SubLeagues::setSUB_LEAGUE_NAME (const ::std::string& SUB_LEAGUE_NAME_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SUB_LEAGUE_NAME_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SUB_LEAGUE_NAME();
    this->_SUB_LEAGUE_NAME = SUB_LEAGUE_NAME_;
}

inline void T_SubLeagues::setSUB_LEAGUE_NAME (const char* SUB_LEAGUE_NAME_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SUB_LEAGUE_NAME_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SUB_LEAGUE_NAME();
    this->_SUB_LEAGUE_NAME.assign(SUB_LEAGUE_NAME_);
}

inline void T_SubLeagues::setSUB_LEAGUE_NAME (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SUB_LEAGUE_NAME();
    this->_SUB_LEAGUE_NAME.assign(value, size);
}

inline void T_SubLeagues::set_has_SUB_LEAGUE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SubLeagues::clear_has_SUB_LEAGUE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SubLeagues::set_has_SUB_LEAGUE_NAME () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SubLeagues::clear_has_SUB_LEAGUE_NAME () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TeamInfo::T_TeamInfo ()  :
    _Team_ID (0u),
    _Team_Name (),
    _Team_Score (0u),
    _Team_Abbr_Name (),
    _Team_Known_Name (),
    _Team_Nick_Name (),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TeamInfo::T_TeamInfo (const T_TeamInfo &rhs)  :
    _Team_ID (0u),
    _Team_Name (),
    _Team_Score (0u),
    _Team_Abbr_Name (),
    _Team_Known_Name (),
    _Team_Nick_Name (),
    _bIsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TeamInfo::T_TeamInfo (uint32 Team_ID_, const ::std::string& Team_Name_, uint32 Team_Score_, const ::std::string& Team_Abbr_Name_, const ::std::string& Team_Known_Name_, const ::std::string& Team_Nick_Name_, bool bIsFavorite_)  :
    _Team_ID (Team_ID_),
    _Team_Name (Team_Name_),
    _Team_Score (Team_Score_),
    _Team_Abbr_Name (Team_Abbr_Name_),
    _Team_Known_Name (Team_Known_Name_),
    _Team_Nick_Name (Team_Nick_Name_),
    _bIsFavorite (bIsFavorite_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TeamInfo::~T_TeamInfo() {
}

inline T_TeamInfo& T_TeamInfo::operator = (const T_TeamInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTeam_ID()) {
            setTeam_ID(rhs.getTeam_ID());
        } else {
            clearTeam_ID();
        }
        if (rhs.hasTeam_Name()) {
            setTeam_Name(rhs.getTeam_Name());
        } else {
            clearTeam_Name();
        }
        if (rhs.hasTeam_Score()) {
            setTeam_Score(rhs.getTeam_Score());
        } else {
            clearTeam_Score();
        }
        if (rhs.hasTeam_Abbr_Name()) {
            setTeam_Abbr_Name(rhs.getTeam_Abbr_Name());
        } else {
            clearTeam_Abbr_Name();
        }
        if (rhs.hasTeam_Known_Name()) {
            setTeam_Known_Name(rhs.getTeam_Known_Name());
        } else {
            clearTeam_Known_Name();
        }
        if (rhs.hasTeam_Nick_Name()) {
            setTeam_Nick_Name(rhs.getTeam_Nick_Name());
        } else {
            clearTeam_Nick_Name();
        }
        if (rhs.hasBIsFavorite()) {
            setBIsFavorite(rhs.getBIsFavorite());
        } else {
            clearBIsFavorite();
        }
    }
    return *this;
}

inline bool T_TeamInfo::operator == (const T_TeamInfo& rhs) const {
    return (((!hasTeam_ID() && !rhs.hasTeam_ID()) || getTeam_ID() == rhs.getTeam_ID()) &&
        ((!hasTeam_Name() && !rhs.hasTeam_Name()) || getTeam_Name() == rhs.getTeam_Name()) &&
        ((!hasTeam_Score() && !rhs.hasTeam_Score()) || getTeam_Score() == rhs.getTeam_Score()) &&
        ((!hasTeam_Abbr_Name() && !rhs.hasTeam_Abbr_Name()) || getTeam_Abbr_Name() == rhs.getTeam_Abbr_Name()) &&
        ((!hasTeam_Known_Name() && !rhs.hasTeam_Known_Name()) || getTeam_Known_Name() == rhs.getTeam_Known_Name()) &&
        ((!hasTeam_Nick_Name() && !rhs.hasTeam_Nick_Name()) || getTeam_Nick_Name() == rhs.getTeam_Nick_Name()) &&
        ((!hasBIsFavorite() && !rhs.hasBIsFavorite()) || getBIsFavorite() == rhs.getBIsFavorite()));
}

inline bool T_TeamInfo::operator != (const T_TeamInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TeamInfo::operator < (const T_TeamInfo& rhs) const {
    if (hasTeam_ID() || rhs.hasTeam_ID()) {
        if (getTeam_ID() < rhs.getTeam_ID()) return true;
        if (getTeam_ID() > rhs.getTeam_ID()) return false;
    }
    if (hasTeam_Name() || rhs.hasTeam_Name()) {
        if (getTeam_Name() < rhs.getTeam_Name()) return true;
        if (getTeam_Name() > rhs.getTeam_Name()) return false;
    }
    if (hasTeam_Score() || rhs.hasTeam_Score()) {
        if (getTeam_Score() < rhs.getTeam_Score()) return true;
        if (getTeam_Score() > rhs.getTeam_Score()) return false;
    }
    if (hasTeam_Abbr_Name() || rhs.hasTeam_Abbr_Name()) {
        if (getTeam_Abbr_Name() < rhs.getTeam_Abbr_Name()) return true;
        if (getTeam_Abbr_Name() > rhs.getTeam_Abbr_Name()) return false;
    }
    if (hasTeam_Known_Name() || rhs.hasTeam_Known_Name()) {
        if (getTeam_Known_Name() < rhs.getTeam_Known_Name()) return true;
        if (getTeam_Known_Name() > rhs.getTeam_Known_Name()) return false;
    }
    if (hasTeam_Nick_Name() || rhs.hasTeam_Nick_Name()) {
        if (getTeam_Nick_Name() < rhs.getTeam_Nick_Name()) return true;
        if (getTeam_Nick_Name() > rhs.getTeam_Nick_Name()) return false;
    }
    if (hasBIsFavorite() || rhs.hasBIsFavorite()) {
        if (getBIsFavorite() < rhs.getBIsFavorite()) return true;
        if (getBIsFavorite() > rhs.getBIsFavorite()) return false;
    }
    return false;
}

inline bool T_TeamInfo::operator > (const T_TeamInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TeamInfo::clear() {
    clearTeam_ID();
    clearTeam_Name();
    clearTeam_Score();
    clearTeam_Abbr_Name();
    clearTeam_Known_Name();
    clearTeam_Nick_Name();
    clearBIsFavorite();
}

inline void T_TeamInfo::clearTeam_ID() {
    if (hasTeam_ID()) {
         clear_has_Team_ID();
        _Team_ID = 0u;
     }
}

inline bool T_TeamInfo::hasTeam_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TeamInfo::getTeam_ID () const {
    return _Team_ID;
}

inline void T_TeamInfo::setTeam_ID (uint32 Team_ID_) {
    set_has_Team_ID();
    this->_Team_ID = Team_ID_;
}

inline void T_TeamInfo::clearTeam_Name() {
    if (hasTeam_Name()) {
         clear_has_Team_Name();
        _Team_Name.clear();
     }
}

inline bool T_TeamInfo::hasTeam_Name () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TeamInfo::getTeam_Name () const {
    return _Team_Name;
}

inline ::std::string& T_TeamInfo::getTeam_NameMutable () {
    set_has_Team_Name();
    return _Team_Name;
}

inline void T_TeamInfo::setTeam_Name (const ::std::string& Team_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name = Team_Name_;
}

inline void T_TeamInfo::setTeam_Name (const char* Team_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name.assign(Team_Name_);
}

inline void T_TeamInfo::setTeam_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name.assign(value, size);
}

inline void T_TeamInfo::clearTeam_Score() {
    if (hasTeam_Score()) {
         clear_has_Team_Score();
        _Team_Score = 0u;
     }
}

inline bool T_TeamInfo::hasTeam_Score () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_TeamInfo::getTeam_Score () const {
    return _Team_Score;
}

inline void T_TeamInfo::setTeam_Score (uint32 Team_Score_) {
    set_has_Team_Score();
    this->_Team_Score = Team_Score_;
}

inline void T_TeamInfo::clearTeam_Abbr_Name() {
    if (hasTeam_Abbr_Name()) {
         clear_has_Team_Abbr_Name();
        _Team_Abbr_Name.clear();
     }
}

inline bool T_TeamInfo::hasTeam_Abbr_Name () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_TeamInfo::getTeam_Abbr_Name () const {
    return _Team_Abbr_Name;
}

inline ::std::string& T_TeamInfo::getTeam_Abbr_NameMutable () {
    set_has_Team_Abbr_Name();
    return _Team_Abbr_Name;
}

inline void T_TeamInfo::setTeam_Abbr_Name (const ::std::string& Team_Abbr_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name = Team_Abbr_Name_;
}

inline void T_TeamInfo::setTeam_Abbr_Name (const char* Team_Abbr_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name.assign(Team_Abbr_Name_);
}

inline void T_TeamInfo::setTeam_Abbr_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name.assign(value, size);
}

inline void T_TeamInfo::clearTeam_Known_Name() {
    if (hasTeam_Known_Name()) {
         clear_has_Team_Known_Name();
        _Team_Known_Name.clear();
     }
}

inline bool T_TeamInfo::hasTeam_Known_Name () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_TeamInfo::getTeam_Known_Name () const {
    return _Team_Known_Name;
}

inline ::std::string& T_TeamInfo::getTeam_Known_NameMutable () {
    set_has_Team_Known_Name();
    return _Team_Known_Name;
}

inline void T_TeamInfo::setTeam_Known_Name (const ::std::string& Team_Known_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name = Team_Known_Name_;
}

inline void T_TeamInfo::setTeam_Known_Name (const char* Team_Known_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name.assign(Team_Known_Name_);
}

inline void T_TeamInfo::setTeam_Known_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name.assign(value, size);
}

inline void T_TeamInfo::clearTeam_Nick_Name() {
    if (hasTeam_Nick_Name()) {
         clear_has_Team_Nick_Name();
        _Team_Nick_Name.clear();
     }
}

inline bool T_TeamInfo::hasTeam_Nick_Name () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_TeamInfo::getTeam_Nick_Name () const {
    return _Team_Nick_Name;
}

inline ::std::string& T_TeamInfo::getTeam_Nick_NameMutable () {
    set_has_Team_Nick_Name();
    return _Team_Nick_Name;
}

inline void T_TeamInfo::setTeam_Nick_Name (const ::std::string& Team_Nick_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name = Team_Nick_Name_;
}

inline void T_TeamInfo::setTeam_Nick_Name (const char* Team_Nick_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name.assign(Team_Nick_Name_);
}

inline void T_TeamInfo::setTeam_Nick_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name.assign(value, size);
}

inline void T_TeamInfo::clearBIsFavorite() {
    if (hasBIsFavorite()) {
         clear_has_bIsFavorite();
        _bIsFavorite = false;
     }
}

inline bool T_TeamInfo::hasBIsFavorite () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_TeamInfo::getBIsFavorite () const {
    return _bIsFavorite;
}

inline void T_TeamInfo::setBIsFavorite (bool bIsFavorite_) {
    set_has_bIsFavorite();
    this->_bIsFavorite = bIsFavorite_;
}

inline void T_TeamInfo::set_has_Team_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TeamInfo::clear_has_Team_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TeamInfo::set_has_Team_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TeamInfo::clear_has_Team_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TeamInfo::set_has_Team_Score () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TeamInfo::clear_has_Team_Score () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TeamInfo::set_has_Team_Abbr_Name () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TeamInfo::clear_has_Team_Abbr_Name () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TeamInfo::set_has_Team_Known_Name () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TeamInfo::clear_has_Team_Known_Name () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TeamInfo::set_has_Team_Nick_Name () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TeamInfo::clear_has_Team_Nick_Name () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TeamInfo::set_has_bIsFavorite () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TeamInfo::clear_has_bIsFavorite () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TimeInfo::T_TimeInfo ()  :
    _Date (),
    _Time ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TimeInfo::T_TimeInfo (const T_TimeInfo &rhs)  :
    _Date (),
    _Time ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TimeInfo::T_TimeInfo (const ::std::string& Date_, const ::std::string& Time_)  :
    _Date (Date_),
    _Time (Time_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Date_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Time_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TimeInfo::~T_TimeInfo() {
}

inline T_TimeInfo& T_TimeInfo::operator = (const T_TimeInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDate()) {
            setDate(rhs.getDate());
        } else {
            clearDate();
        }
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
    }
    return *this;
}

inline bool T_TimeInfo::operator == (const T_TimeInfo& rhs) const {
    return (((!hasDate() && !rhs.hasDate()) || getDate() == rhs.getDate()) &&
        ((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()));
}

inline bool T_TimeInfo::operator != (const T_TimeInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TimeInfo::operator < (const T_TimeInfo& rhs) const {
    if (hasDate() || rhs.hasDate()) {
        if (getDate() < rhs.getDate()) return true;
        if (getDate() > rhs.getDate()) return false;
    }
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    return false;
}

inline bool T_TimeInfo::operator > (const T_TimeInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TimeInfo::clear() {
    clearDate();
    clearTime();
}

inline void T_TimeInfo::clearDate() {
    if (hasDate()) {
         clear_has_Date();
        _Date.clear();
     }
}

inline bool T_TimeInfo::hasDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_TimeInfo::getDate () const {
    return _Date;
}

inline ::std::string& T_TimeInfo::getDateMutable () {
    set_has_Date();
    return _Date;
}

inline void T_TimeInfo::setDate (const ::std::string& Date_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Date_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Date();
    this->_Date = Date_;
}

inline void T_TimeInfo::setDate (const char* Date_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Date_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Date();
    this->_Date.assign(Date_);
}

inline void T_TimeInfo::setDate (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Date();
    this->_Date.assign(value, size);
}

inline void T_TimeInfo::clearTime() {
    if (hasTime()) {
         clear_has_Time();
        _Time.clear();
     }
}

inline bool T_TimeInfo::hasTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TimeInfo::getTime () const {
    return _Time;
}

inline ::std::string& T_TimeInfo::getTimeMutable () {
    set_has_Time();
    return _Time;
}

inline void T_TimeInfo::setTime (const ::std::string& Time_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Time_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Time();
    this->_Time = Time_;
}

inline void T_TimeInfo::setTime (const char* Time_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Time_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Time();
    this->_Time.assign(Time_);
}

inline void T_TimeInfo::setTime (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Time();
    this->_Time.assign(value, size);
}

inline void T_TimeInfo::set_has_Date () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TimeInfo::clear_has_Date () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TimeInfo::set_has_Time () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TimeInfo::clear_has_Time () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_XMChannel::T_XMChannel ()  :
    _ChannelNumber (0u),
    _ChannelType (::sxm_sports_main_fi_types::T_XMChannelType__HOME)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_XMChannel::T_XMChannel (const T_XMChannel &rhs)  :
    _ChannelNumber (0u),
    _ChannelType (::sxm_sports_main_fi_types::T_XMChannelType__HOME)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_XMChannel::T_XMChannel (uint32 ChannelNumber_, T_XMChannelType ChannelType_)  :
    _ChannelNumber (ChannelNumber_),
    _ChannelType (ChannelType_)
{
    #ifndef NDEBUG
    if (!(T_XMChannelType_IsValid(ChannelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelType_, "T_XMChannelType", "ChannelType", "T_XMChannel");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_XMChannel::~T_XMChannel() {
}

inline T_XMChannel& T_XMChannel::operator = (const T_XMChannel& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelNumber()) {
            setChannelNumber(rhs.getChannelNumber());
        } else {
            clearChannelNumber();
        }
        if (rhs.hasChannelType()) {
            setChannelType(rhs.getChannelType());
        } else {
            clearChannelType();
        }
    }
    return *this;
}

inline bool T_XMChannel::operator == (const T_XMChannel& rhs) const {
    return (((!hasChannelNumber() && !rhs.hasChannelNumber()) || getChannelNumber() == rhs.getChannelNumber()) &&
        ((!hasChannelType() && !rhs.hasChannelType()) || getChannelType() == rhs.getChannelType()));
}

inline bool T_XMChannel::operator != (const T_XMChannel& rhs) const {
    return ! (*this == rhs);
}

inline bool T_XMChannel::operator < (const T_XMChannel& rhs) const {
    if (hasChannelNumber() || rhs.hasChannelNumber()) {
        if (getChannelNumber() < rhs.getChannelNumber()) return true;
        if (getChannelNumber() > rhs.getChannelNumber()) return false;
    }
    if (hasChannelType() || rhs.hasChannelType()) {
        if ((uint32)getChannelType() < (uint32)rhs.getChannelType()) return true;
        if ((uint32)getChannelType() > (uint32)rhs.getChannelType()) return false;
    }
    return false;
}

inline bool T_XMChannel::operator > (const T_XMChannel& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_XMChannel::clear() {
    clearChannelNumber();
    clearChannelType();
}

inline void T_XMChannel::clearChannelNumber() {
    if (hasChannelNumber()) {
         clear_has_ChannelNumber();
        _ChannelNumber = 0u;
     }
}

inline bool T_XMChannel::hasChannelNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_XMChannel::getChannelNumber () const {
    return _ChannelNumber;
}

inline void T_XMChannel::setChannelNumber (uint32 ChannelNumber_) {
    set_has_ChannelNumber();
    this->_ChannelNumber = ChannelNumber_;
}

inline void T_XMChannel::clearChannelType() {
    if (hasChannelType()) {
         clear_has_ChannelType();
        _ChannelType = ::sxm_sports_main_fi_types::T_XMChannelType__HOME;
     }
}

inline bool T_XMChannel::hasChannelType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_XMChannelType T_XMChannel::getChannelType () const {
    return _ChannelType;
}

inline void T_XMChannel::setChannelType (T_XMChannelType ChannelType_) {
    #ifndef NDEBUG
    if (!(T_XMChannelType_IsValid(ChannelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChannelType_, "T_XMChannelType", "ChannelType", "T_XMChannel");
    }
    #endif
    set_has_ChannelType();
    this->_ChannelType = ChannelType_;
}

inline void T_XMChannel::set_has_ChannelNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_XMChannel::clear_has_ChannelNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_XMChannel::set_has_ChannelType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_XMChannel::clear_has_ChannelType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_GameInfo::T_GameInfo ()  :
    _Home_Team_Info (),
    _Visiting_Team_Info (),
    _Game_Time (),
    _Game_Status (),
    _Game_Clock (0u),
    _Winning_Team_ID (0u),
    _EventState (::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled),
    _XMChannelList (),
    _Game_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GameInfo::T_GameInfo (const T_GameInfo &rhs)  :
    _Home_Team_Info (),
    _Visiting_Team_Info (),
    _Game_Time (),
    _Game_Status (),
    _Game_Clock (0u),
    _Winning_Team_ID (0u),
    _EventState (::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled),
    _XMChannelList (),
    _Game_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GameInfo::T_GameInfo (const T_TeamInfo& Home_Team_Info_, const T_TeamInfo& Visiting_Team_Info_, const T_TimeInfo& Game_Time_, const ::std::string& Game_Status_, uint32 Game_Clock_, uint32 Winning_Team_ID_, T_e8_Game_Status EventState_, const ::std::vector< T_XMChannel >& XMChannelList_, uint32 Game_ID_)  :
    _Home_Team_Info (Home_Team_Info_),
    _Visiting_Team_Info (Visiting_Team_Info_),
    _Game_Time (Game_Time_),
    _Game_Status (Game_Status_),
    _Game_Clock (Game_Clock_),
    _Winning_Team_ID (Winning_Team_ID_),
    _EventState (EventState_),
    _XMChannelList (XMChannelList_),
    _Game_ID (Game_ID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Game_Status_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Game_Status_IsValid(EventState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventState_, "T_e8_Game_Status", "EventState", "T_GameInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GameInfo::~T_GameInfo() {
}

inline T_GameInfo& T_GameInfo::operator = (const T_GameInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHome_Team_Info()) {
            setHome_Team_Info(rhs.getHome_Team_Info());
        } else {
            clearHome_Team_Info();
        }
        if (rhs.hasVisiting_Team_Info()) {
            setVisiting_Team_Info(rhs.getVisiting_Team_Info());
        } else {
            clearVisiting_Team_Info();
        }
        if (rhs.hasGame_Time()) {
            setGame_Time(rhs.getGame_Time());
        } else {
            clearGame_Time();
        }
        if (rhs.hasGame_Status()) {
            setGame_Status(rhs.getGame_Status());
        } else {
            clearGame_Status();
        }
        if (rhs.hasGame_Clock()) {
            setGame_Clock(rhs.getGame_Clock());
        } else {
            clearGame_Clock();
        }
        if (rhs.hasWinning_Team_ID()) {
            setWinning_Team_ID(rhs.getWinning_Team_ID());
        } else {
            clearWinning_Team_ID();
        }
        if (rhs.hasEventState()) {
            setEventState(rhs.getEventState());
        } else {
            clearEventState();
        }
        if (rhs.hasXMChannelList()) {
            setXMChannelList(rhs.getXMChannelList());
        } else {
            clearXMChannelList();
        }
        if (rhs.hasGame_ID()) {
            setGame_ID(rhs.getGame_ID());
        } else {
            clearGame_ID();
        }
    }
    return *this;
}

inline bool T_GameInfo::operator == (const T_GameInfo& rhs) const {
    return (((!hasHome_Team_Info() && !rhs.hasHome_Team_Info()) || getHome_Team_Info() == rhs.getHome_Team_Info()) &&
        ((!hasVisiting_Team_Info() && !rhs.hasVisiting_Team_Info()) || getVisiting_Team_Info() == rhs.getVisiting_Team_Info()) &&
        ((!hasGame_Time() && !rhs.hasGame_Time()) || getGame_Time() == rhs.getGame_Time()) &&
        ((!hasGame_Status() && !rhs.hasGame_Status()) || getGame_Status() == rhs.getGame_Status()) &&
        ((!hasGame_Clock() && !rhs.hasGame_Clock()) || getGame_Clock() == rhs.getGame_Clock()) &&
        ((!hasWinning_Team_ID() && !rhs.hasWinning_Team_ID()) || getWinning_Team_ID() == rhs.getWinning_Team_ID()) &&
        ((!hasEventState() && !rhs.hasEventState()) || getEventState() == rhs.getEventState()) &&
        ((!hasXMChannelList() && !rhs.hasXMChannelList()) || getXMChannelList() == rhs.getXMChannelList()) &&
        ((!hasGame_ID() && !rhs.hasGame_ID()) || getGame_ID() == rhs.getGame_ID()));
}

inline bool T_GameInfo::operator != (const T_GameInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GameInfo::operator < (const T_GameInfo& rhs) const {
    if (hasHome_Team_Info() || rhs.hasHome_Team_Info()) {
        if (getHome_Team_Info() < rhs.getHome_Team_Info()) return true;
        if (getHome_Team_Info() > rhs.getHome_Team_Info()) return false;
    }
    if (hasVisiting_Team_Info() || rhs.hasVisiting_Team_Info()) {
        if (getVisiting_Team_Info() < rhs.getVisiting_Team_Info()) return true;
        if (getVisiting_Team_Info() > rhs.getVisiting_Team_Info()) return false;
    }
    if (hasGame_Time() || rhs.hasGame_Time()) {
        if (getGame_Time() < rhs.getGame_Time()) return true;
        if (getGame_Time() > rhs.getGame_Time()) return false;
    }
    if (hasGame_Status() || rhs.hasGame_Status()) {
        if (getGame_Status() < rhs.getGame_Status()) return true;
        if (getGame_Status() > rhs.getGame_Status()) return false;
    }
    if (hasGame_Clock() || rhs.hasGame_Clock()) {
        if (getGame_Clock() < rhs.getGame_Clock()) return true;
        if (getGame_Clock() > rhs.getGame_Clock()) return false;
    }
    if (hasWinning_Team_ID() || rhs.hasWinning_Team_ID()) {
        if (getWinning_Team_ID() < rhs.getWinning_Team_ID()) return true;
        if (getWinning_Team_ID() > rhs.getWinning_Team_ID()) return false;
    }
    if (hasEventState() || rhs.hasEventState()) {
        if ((uint32)getEventState() < (uint32)rhs.getEventState()) return true;
        if ((uint32)getEventState() > (uint32)rhs.getEventState()) return false;
    }
    if (hasXMChannelList() || rhs.hasXMChannelList()) {
        if (getXMChannelList() < rhs.getXMChannelList()) return true;
        if (getXMChannelList() > rhs.getXMChannelList()) return false;
    }
    if (hasGame_ID() || rhs.hasGame_ID()) {
        if (getGame_ID() < rhs.getGame_ID()) return true;
        if (getGame_ID() > rhs.getGame_ID()) return false;
    }
    return false;
}

inline bool T_GameInfo::operator > (const T_GameInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GameInfo::clear() {
    clearHome_Team_Info();
    clearVisiting_Team_Info();
    clearGame_Time();
    clearGame_Status();
    clearGame_Clock();
    clearWinning_Team_ID();
    clearEventState();
    clearXMChannelList();
    clearGame_ID();
}

inline void T_GameInfo::clearHome_Team_Info() {
    if (hasHome_Team_Info()) {
         clear_has_Home_Team_Info();
        _Home_Team_Info.clear();
     }
}

inline bool T_GameInfo::hasHome_Team_Info () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TeamInfo& T_GameInfo::getHome_Team_Info () const {
    return _Home_Team_Info;
}

inline T_TeamInfo& T_GameInfo::getHome_Team_InfoMutable () {
    set_has_Home_Team_Info();
    return _Home_Team_Info;
}

inline void T_GameInfo::setHome_Team_Info (const T_TeamInfo& Home_Team_Info_) {
    set_has_Home_Team_Info();
    this->_Home_Team_Info = Home_Team_Info_;
}

inline void T_GameInfo::clearVisiting_Team_Info() {
    if (hasVisiting_Team_Info()) {
         clear_has_Visiting_Team_Info();
        _Visiting_Team_Info.clear();
     }
}

inline bool T_GameInfo::hasVisiting_Team_Info () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TeamInfo& T_GameInfo::getVisiting_Team_Info () const {
    return _Visiting_Team_Info;
}

inline T_TeamInfo& T_GameInfo::getVisiting_Team_InfoMutable () {
    set_has_Visiting_Team_Info();
    return _Visiting_Team_Info;
}

inline void T_GameInfo::setVisiting_Team_Info (const T_TeamInfo& Visiting_Team_Info_) {
    set_has_Visiting_Team_Info();
    this->_Visiting_Team_Info = Visiting_Team_Info_;
}

inline void T_GameInfo::clearGame_Time() {
    if (hasGame_Time()) {
         clear_has_Game_Time();
        _Game_Time.clear();
     }
}

inline bool T_GameInfo::hasGame_Time () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_TimeInfo& T_GameInfo::getGame_Time () const {
    return _Game_Time;
}

inline T_TimeInfo& T_GameInfo::getGame_TimeMutable () {
    set_has_Game_Time();
    return _Game_Time;
}

inline void T_GameInfo::setGame_Time (const T_TimeInfo& Game_Time_) {
    set_has_Game_Time();
    this->_Game_Time = Game_Time_;
}

inline void T_GameInfo::clearGame_Status() {
    if (hasGame_Status()) {
         clear_has_Game_Status();
        _Game_Status.clear();
     }
}

inline bool T_GameInfo::hasGame_Status () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_GameInfo::getGame_Status () const {
    return _Game_Status;
}

inline ::std::string& T_GameInfo::getGame_StatusMutable () {
    set_has_Game_Status();
    return _Game_Status;
}

inline void T_GameInfo::setGame_Status (const ::std::string& Game_Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Game_Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Game_Status();
    this->_Game_Status = Game_Status_;
}

inline void T_GameInfo::setGame_Status (const char* Game_Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Game_Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Game_Status();
    this->_Game_Status.assign(Game_Status_);
}

inline void T_GameInfo::setGame_Status (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Game_Status();
    this->_Game_Status.assign(value, size);
}

inline void T_GameInfo::clearGame_Clock() {
    if (hasGame_Clock()) {
         clear_has_Game_Clock();
        _Game_Clock = 0u;
     }
}

inline bool T_GameInfo::hasGame_Clock () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_GameInfo::getGame_Clock () const {
    return _Game_Clock;
}

inline void T_GameInfo::setGame_Clock (uint32 Game_Clock_) {
    set_has_Game_Clock();
    this->_Game_Clock = Game_Clock_;
}

inline void T_GameInfo::clearWinning_Team_ID() {
    if (hasWinning_Team_ID()) {
         clear_has_Winning_Team_ID();
        _Winning_Team_ID = 0u;
     }
}

inline bool T_GameInfo::hasWinning_Team_ID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_GameInfo::getWinning_Team_ID () const {
    return _Winning_Team_ID;
}

inline void T_GameInfo::setWinning_Team_ID (uint32 Winning_Team_ID_) {
    set_has_Winning_Team_ID();
    this->_Winning_Team_ID = Winning_Team_ID_;
}

inline void T_GameInfo::clearEventState() {
    if (hasEventState()) {
         clear_has_EventState();
        _EventState = ::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled;
     }
}

inline bool T_GameInfo::hasEventState () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_Game_Status T_GameInfo::getEventState () const {
    return _EventState;
}

inline void T_GameInfo::setEventState (T_e8_Game_Status EventState_) {
    #ifndef NDEBUG
    if (!(T_e8_Game_Status_IsValid(EventState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventState_, "T_e8_Game_Status", "EventState", "T_GameInfo");
    }
    #endif
    set_has_EventState();
    this->_EventState = EventState_;
}

inline void T_GameInfo::clearXMChannelList() {
    if (hasXMChannelList()) {
         clear_has_XMChannelList();
        _XMChannelList.clear();
     }
}

inline bool T_GameInfo::hasXMChannelList () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< T_XMChannel >& T_GameInfo::getXMChannelList () const {
    return _XMChannelList;
}

inline ::std::vector< T_XMChannel >& T_GameInfo::getXMChannelListMutable () {
    set_has_XMChannelList();
    return _XMChannelList;
}

inline void T_GameInfo::setXMChannelList (const ::std::vector< T_XMChannel >& XMChannelList_) {
    set_has_XMChannelList();
    this->_XMChannelList = XMChannelList_;
}

inline void T_GameInfo::clearGame_ID() {
    if (hasGame_ID()) {
         clear_has_Game_ID();
        _Game_ID = 0u;
     }
}

inline bool T_GameInfo::hasGame_ID () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_GameInfo::getGame_ID () const {
    return _Game_ID;
}

inline void T_GameInfo::setGame_ID (uint32 Game_ID_) {
    set_has_Game_ID();
    this->_Game_ID = Game_ID_;
}

inline void T_GameInfo::set_has_Home_Team_Info () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GameInfo::clear_has_Home_Team_Info () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GameInfo::set_has_Visiting_Team_Info () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GameInfo::clear_has_Visiting_Team_Info () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GameInfo::set_has_Game_Time () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GameInfo::clear_has_Game_Time () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GameInfo::set_has_Game_Status () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GameInfo::clear_has_Game_Status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GameInfo::set_has_Game_Clock () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GameInfo::clear_has_Game_Clock () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_GameInfo::set_has_Winning_Team_ID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_GameInfo::clear_has_Winning_Team_ID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_GameInfo::set_has_EventState () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_GameInfo::clear_has_EventState () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_GameInfo::set_has_XMChannelList () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_GameInfo::clear_has_XMChannelList () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_GameInfo::set_has_Game_ID () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_GameInfo::clear_has_Game_ID () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_GameList::T_GameList ()  :
    _SPORT_ID (0u),
    _AFFILIATE_INFO (),
    _bIsRecentGamesAvl (false),
    _bIsCurrentGamesAvl (false),
    _bIsFutureGamesAvl (false),
    _bIsFavorite (false),
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _ListIndex (0u),
    _GameInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GameList::T_GameList (const T_GameList &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_INFO (),
    _bIsRecentGamesAvl (false),
    _bIsCurrentGamesAvl (false),
    _bIsFutureGamesAvl (false),
    _bIsFavorite (false),
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _ListIndex (0u),
    _GameInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GameList::T_GameList (uint8 SPORT_ID_, const T_AffiliateInfo& AFFILIATE_INFO_, bool bIsRecentGamesAvl_, bool bIsCurrentGamesAvl_, bool bIsFutureGamesAvl_, bool bIsFavorite_, T_GameType GameType_, uint32 ListIndex_, const ::std::vector< T_GameInfo >& GameInfo_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_INFO (AFFILIATE_INFO_),
    _bIsRecentGamesAvl (bIsRecentGamesAvl_),
    _bIsCurrentGamesAvl (bIsCurrentGamesAvl_),
    _bIsFutureGamesAvl (bIsFutureGamesAvl_),
    _bIsFavorite (bIsFavorite_),
    _GameType (GameType_),
    _ListIndex (ListIndex_),
    _GameInfo (GameInfo_)
{
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "T_GameList");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GameList::~T_GameList() {
}

inline T_GameList& T_GameList::operator = (const T_GameList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_INFO()) {
            setAFFILIATE_INFO(rhs.getAFFILIATE_INFO());
        } else {
            clearAFFILIATE_INFO();
        }
        if (rhs.hasBIsRecentGamesAvl()) {
            setBIsRecentGamesAvl(rhs.getBIsRecentGamesAvl());
        } else {
            clearBIsRecentGamesAvl();
        }
        if (rhs.hasBIsCurrentGamesAvl()) {
            setBIsCurrentGamesAvl(rhs.getBIsCurrentGamesAvl());
        } else {
            clearBIsCurrentGamesAvl();
        }
        if (rhs.hasBIsFutureGamesAvl()) {
            setBIsFutureGamesAvl(rhs.getBIsFutureGamesAvl());
        } else {
            clearBIsFutureGamesAvl();
        }
        if (rhs.hasBIsFavorite()) {
            setBIsFavorite(rhs.getBIsFavorite());
        } else {
            clearBIsFavorite();
        }
        if (rhs.hasGameType()) {
            setGameType(rhs.getGameType());
        } else {
            clearGameType();
        }
        if (rhs.hasListIndex()) {
            setListIndex(rhs.getListIndex());
        } else {
            clearListIndex();
        }
        if (rhs.hasGameInfo()) {
            setGameInfo(rhs.getGameInfo());
        } else {
            clearGameInfo();
        }
    }
    return *this;
}

inline bool T_GameList::operator == (const T_GameList& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_INFO() && !rhs.hasAFFILIATE_INFO()) || getAFFILIATE_INFO() == rhs.getAFFILIATE_INFO()) &&
        ((!hasBIsRecentGamesAvl() && !rhs.hasBIsRecentGamesAvl()) || getBIsRecentGamesAvl() == rhs.getBIsRecentGamesAvl()) &&
        ((!hasBIsCurrentGamesAvl() && !rhs.hasBIsCurrentGamesAvl()) || getBIsCurrentGamesAvl() == rhs.getBIsCurrentGamesAvl()) &&
        ((!hasBIsFutureGamesAvl() && !rhs.hasBIsFutureGamesAvl()) || getBIsFutureGamesAvl() == rhs.getBIsFutureGamesAvl()) &&
        ((!hasBIsFavorite() && !rhs.hasBIsFavorite()) || getBIsFavorite() == rhs.getBIsFavorite()) &&
        ((!hasGameType() && !rhs.hasGameType()) || getGameType() == rhs.getGameType()) &&
        ((!hasListIndex() && !rhs.hasListIndex()) || getListIndex() == rhs.getListIndex()) &&
        ((!hasGameInfo() && !rhs.hasGameInfo()) || getGameInfo() == rhs.getGameInfo()));
}

inline bool T_GameList::operator != (const T_GameList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GameList::operator < (const T_GameList& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_INFO() || rhs.hasAFFILIATE_INFO()) {
        if (getAFFILIATE_INFO() < rhs.getAFFILIATE_INFO()) return true;
        if (getAFFILIATE_INFO() > rhs.getAFFILIATE_INFO()) return false;
    }
    if (hasBIsRecentGamesAvl() || rhs.hasBIsRecentGamesAvl()) {
        if (getBIsRecentGamesAvl() < rhs.getBIsRecentGamesAvl()) return true;
        if (getBIsRecentGamesAvl() > rhs.getBIsRecentGamesAvl()) return false;
    }
    if (hasBIsCurrentGamesAvl() || rhs.hasBIsCurrentGamesAvl()) {
        if (getBIsCurrentGamesAvl() < rhs.getBIsCurrentGamesAvl()) return true;
        if (getBIsCurrentGamesAvl() > rhs.getBIsCurrentGamesAvl()) return false;
    }
    if (hasBIsFutureGamesAvl() || rhs.hasBIsFutureGamesAvl()) {
        if (getBIsFutureGamesAvl() < rhs.getBIsFutureGamesAvl()) return true;
        if (getBIsFutureGamesAvl() > rhs.getBIsFutureGamesAvl()) return false;
    }
    if (hasBIsFavorite() || rhs.hasBIsFavorite()) {
        if (getBIsFavorite() < rhs.getBIsFavorite()) return true;
        if (getBIsFavorite() > rhs.getBIsFavorite()) return false;
    }
    if (hasGameType() || rhs.hasGameType()) {
        if ((uint32)getGameType() < (uint32)rhs.getGameType()) return true;
        if ((uint32)getGameType() > (uint32)rhs.getGameType()) return false;
    }
    if (hasListIndex() || rhs.hasListIndex()) {
        if (getListIndex() < rhs.getListIndex()) return true;
        if (getListIndex() > rhs.getListIndex()) return false;
    }
    if (hasGameInfo() || rhs.hasGameInfo()) {
        if (getGameInfo() < rhs.getGameInfo()) return true;
        if (getGameInfo() > rhs.getGameInfo()) return false;
    }
    return false;
}

inline bool T_GameList::operator > (const T_GameList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GameList::clear() {
    clearSPORT_ID();
    clearAFFILIATE_INFO();
    clearBIsRecentGamesAvl();
    clearBIsCurrentGamesAvl();
    clearBIsFutureGamesAvl();
    clearBIsFavorite();
    clearGameType();
    clearListIndex();
    clearGameInfo();
}

inline void T_GameList::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_GameList::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_GameList::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_GameList::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_GameList::clearAFFILIATE_INFO() {
    if (hasAFFILIATE_INFO()) {
         clear_has_AFFILIATE_INFO();
        _AFFILIATE_INFO.clear();
     }
}

inline bool T_GameList::hasAFFILIATE_INFO () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_AffiliateInfo& T_GameList::getAFFILIATE_INFO () const {
    return _AFFILIATE_INFO;
}

inline T_AffiliateInfo& T_GameList::getAFFILIATE_INFOMutable () {
    set_has_AFFILIATE_INFO();
    return _AFFILIATE_INFO;
}

inline void T_GameList::setAFFILIATE_INFO (const T_AffiliateInfo& AFFILIATE_INFO_) {
    set_has_AFFILIATE_INFO();
    this->_AFFILIATE_INFO = AFFILIATE_INFO_;
}

inline void T_GameList::clearBIsRecentGamesAvl() {
    if (hasBIsRecentGamesAvl()) {
         clear_has_bIsRecentGamesAvl();
        _bIsRecentGamesAvl = false;
     }
}

inline bool T_GameList::hasBIsRecentGamesAvl () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_GameList::getBIsRecentGamesAvl () const {
    return _bIsRecentGamesAvl;
}

inline void T_GameList::setBIsRecentGamesAvl (bool bIsRecentGamesAvl_) {
    set_has_bIsRecentGamesAvl();
    this->_bIsRecentGamesAvl = bIsRecentGamesAvl_;
}

inline void T_GameList::clearBIsCurrentGamesAvl() {
    if (hasBIsCurrentGamesAvl()) {
         clear_has_bIsCurrentGamesAvl();
        _bIsCurrentGamesAvl = false;
     }
}

inline bool T_GameList::hasBIsCurrentGamesAvl () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_GameList::getBIsCurrentGamesAvl () const {
    return _bIsCurrentGamesAvl;
}

inline void T_GameList::setBIsCurrentGamesAvl (bool bIsCurrentGamesAvl_) {
    set_has_bIsCurrentGamesAvl();
    this->_bIsCurrentGamesAvl = bIsCurrentGamesAvl_;
}

inline void T_GameList::clearBIsFutureGamesAvl() {
    if (hasBIsFutureGamesAvl()) {
         clear_has_bIsFutureGamesAvl();
        _bIsFutureGamesAvl = false;
     }
}

inline bool T_GameList::hasBIsFutureGamesAvl () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_GameList::getBIsFutureGamesAvl () const {
    return _bIsFutureGamesAvl;
}

inline void T_GameList::setBIsFutureGamesAvl (bool bIsFutureGamesAvl_) {
    set_has_bIsFutureGamesAvl();
    this->_bIsFutureGamesAvl = bIsFutureGamesAvl_;
}

inline void T_GameList::clearBIsFavorite() {
    if (hasBIsFavorite()) {
         clear_has_bIsFavorite();
        _bIsFavorite = false;
     }
}

inline bool T_GameList::hasBIsFavorite () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_GameList::getBIsFavorite () const {
    return _bIsFavorite;
}

inline void T_GameList::setBIsFavorite (bool bIsFavorite_) {
    set_has_bIsFavorite();
    this->_bIsFavorite = bIsFavorite_;
}

inline void T_GameList::clearGameType() {
    if (hasGameType()) {
         clear_has_GameType();
        _GameType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool T_GameList::hasGameType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_GameType T_GameList::getGameType () const {
    return _GameType;
}

inline void T_GameList::setGameType (T_GameType GameType_) {
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "T_GameList");
    }
    #endif
    set_has_GameType();
    this->_GameType = GameType_;
}

inline void T_GameList::clearListIndex() {
    if (hasListIndex()) {
         clear_has_ListIndex();
        _ListIndex = 0u;
     }
}

inline bool T_GameList::hasListIndex () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_GameList::getListIndex () const {
    return _ListIndex;
}

inline void T_GameList::setListIndex (uint32 ListIndex_) {
    set_has_ListIndex();
    this->_ListIndex = ListIndex_;
}

inline void T_GameList::clearGameInfo() {
    if (hasGameInfo()) {
         clear_has_GameInfo();
        _GameInfo.clear();
     }
}

inline bool T_GameList::hasGameInfo () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::vector< T_GameInfo >& T_GameList::getGameInfo () const {
    return _GameInfo;
}

inline ::std::vector< T_GameInfo >& T_GameList::getGameInfoMutable () {
    set_has_GameInfo();
    return _GameInfo;
}

inline void T_GameList::setGameInfo (const ::std::vector< T_GameInfo >& GameInfo_) {
    set_has_GameInfo();
    this->_GameInfo = GameInfo_;
}

inline void T_GameList::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GameList::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GameList::set_has_AFFILIATE_INFO () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GameList::clear_has_AFFILIATE_INFO () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GameList::set_has_bIsRecentGamesAvl () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GameList::clear_has_bIsRecentGamesAvl () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GameList::set_has_bIsCurrentGamesAvl () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GameList::clear_has_bIsCurrentGamesAvl () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GameList::set_has_bIsFutureGamesAvl () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GameList::clear_has_bIsFutureGamesAvl () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_GameList::set_has_bIsFavorite () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_GameList::clear_has_bIsFavorite () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_GameList::set_has_GameType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_GameList::clear_has_GameType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_GameList::set_has_ListIndex () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_GameList::clear_has_ListIndex () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_GameList::set_has_GameInfo () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_GameList::clear_has_GameInfo () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_Details::T_Details ()  :
    _Label (),
    _Value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Details::T_Details (const T_Details &rhs)  :
    _Label (),
    _Value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Details::T_Details (const ::std::string& Label_, const ::std::string& Value_)  :
    _Label (Label_),
    _Value (Value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Label_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Details::~T_Details() {
}

inline T_Details& T_Details::operator = (const T_Details& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLabel()) {
            setLabel(rhs.getLabel());
        } else {
            clearLabel();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool T_Details::operator == (const T_Details& rhs) const {
    return (((!hasLabel() && !rhs.hasLabel()) || getLabel() == rhs.getLabel()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool T_Details::operator != (const T_Details& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Details::operator < (const T_Details& rhs) const {
    if (hasLabel() || rhs.hasLabel()) {
        if (getLabel() < rhs.getLabel()) return true;
        if (getLabel() > rhs.getLabel()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool T_Details::operator > (const T_Details& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Details::clear() {
    clearLabel();
    clearValue();
}

inline void T_Details::clearLabel() {
    if (hasLabel()) {
         clear_has_Label();
        _Label.clear();
     }
}

inline bool T_Details::hasLabel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_Details::getLabel () const {
    return _Label;
}

inline ::std::string& T_Details::getLabelMutable () {
    set_has_Label();
    return _Label;
}

inline void T_Details::setLabel (const ::std::string& Label_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Label_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Label();
    this->_Label = Label_;
}

inline void T_Details::setLabel (const char* Label_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Label_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Label();
    this->_Label.assign(Label_);
}

inline void T_Details::setLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Label();
    this->_Label.assign(value, size);
}

inline void T_Details::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value.clear();
     }
}

inline bool T_Details::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_Details::getValue () const {
    return _Value;
}

inline ::std::string& T_Details::getValueMutable () {
    set_has_Value();
    return _Value;
}

inline void T_Details::setValue (const ::std::string& Value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Value();
    this->_Value = Value_;
}

inline void T_Details::setValue (const char* Value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Value();
    this->_Value.assign(Value_);
}

inline void T_Details::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Value();
    this->_Value.assign(value, size);
}

inline void T_Details::set_has_Label () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Details::clear_has_Label () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Details::set_has_Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Details::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AvailableGames::T_AvailableGames ()  :
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _IsAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AvailableGames::T_AvailableGames (const T_AvailableGames &rhs)  :
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _IsAvailable (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AvailableGames::T_AvailableGames (T_GameType GameType_, bool IsAvailable_)  :
    _GameType (GameType_),
    _IsAvailable (IsAvailable_)
{
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "T_AvailableGames");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AvailableGames::~T_AvailableGames() {
}

inline T_AvailableGames& T_AvailableGames::operator = (const T_AvailableGames& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGameType()) {
            setGameType(rhs.getGameType());
        } else {
            clearGameType();
        }
        if (rhs.hasIsAvailable()) {
            setIsAvailable(rhs.getIsAvailable());
        } else {
            clearIsAvailable();
        }
    }
    return *this;
}

inline bool T_AvailableGames::operator == (const T_AvailableGames& rhs) const {
    return (((!hasGameType() && !rhs.hasGameType()) || getGameType() == rhs.getGameType()) &&
        ((!hasIsAvailable() && !rhs.hasIsAvailable()) || getIsAvailable() == rhs.getIsAvailable()));
}

inline bool T_AvailableGames::operator != (const T_AvailableGames& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AvailableGames::operator < (const T_AvailableGames& rhs) const {
    if (hasGameType() || rhs.hasGameType()) {
        if ((uint32)getGameType() < (uint32)rhs.getGameType()) return true;
        if ((uint32)getGameType() > (uint32)rhs.getGameType()) return false;
    }
    if (hasIsAvailable() || rhs.hasIsAvailable()) {
        if (getIsAvailable() < rhs.getIsAvailable()) return true;
        if (getIsAvailable() > rhs.getIsAvailable()) return false;
    }
    return false;
}

inline bool T_AvailableGames::operator > (const T_AvailableGames& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AvailableGames::clear() {
    clearGameType();
    clearIsAvailable();
}

inline void T_AvailableGames::clearGameType() {
    if (hasGameType()) {
         clear_has_GameType();
        _GameType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool T_AvailableGames::hasGameType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_GameType T_AvailableGames::getGameType () const {
    return _GameType;
}

inline void T_AvailableGames::setGameType (T_GameType GameType_) {
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "T_AvailableGames");
    }
    #endif
    set_has_GameType();
    this->_GameType = GameType_;
}

inline void T_AvailableGames::clearIsAvailable() {
    if (hasIsAvailable()) {
         clear_has_IsAvailable();
        _IsAvailable = false;
     }
}

inline bool T_AvailableGames::hasIsAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_AvailableGames::getIsAvailable () const {
    return _IsAvailable;
}

inline void T_AvailableGames::setIsAvailable (bool IsAvailable_) {
    set_has_IsAvailable();
    this->_IsAvailable = IsAvailable_;
}

inline void T_AvailableGames::set_has_GameType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AvailableGames::clear_has_GameType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AvailableGames::set_has_IsAvailable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AvailableGames::clear_has_IsAvailable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TeamList::T_TeamList ()  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _TeamDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TeamList::T_TeamList (const T_TeamList &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _TeamDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TeamList::T_TeamList (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_TeamInfo >& TeamDetails_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _TeamDetails (TeamDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TeamList::~T_TeamList() {
}

inline T_TeamList& T_TeamList::operator = (const T_TeamList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasTeamDetails()) {
            setTeamDetails(rhs.getTeamDetails());
        } else {
            clearTeamDetails();
        }
    }
    return *this;
}

inline bool T_TeamList::operator == (const T_TeamList& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasTeamDetails() && !rhs.hasTeamDetails()) || getTeamDetails() == rhs.getTeamDetails()));
}

inline bool T_TeamList::operator != (const T_TeamList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TeamList::operator < (const T_TeamList& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasTeamDetails() || rhs.hasTeamDetails()) {
        if (getTeamDetails() < rhs.getTeamDetails()) return true;
        if (getTeamDetails() > rhs.getTeamDetails()) return false;
    }
    return false;
}

inline bool T_TeamList::operator > (const T_TeamList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TeamList::clear() {
    clearSPORT_ID();
    clearAFFILIATE_ID();
    clearTeamDetails();
}

inline void T_TeamList::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_TeamList::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TeamList::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_TeamList::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_TeamList::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_TeamList::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_TeamList::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_TeamList::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_TeamList::clearTeamDetails() {
    if (hasTeamDetails()) {
         clear_has_TeamDetails();
        _TeamDetails.clear();
     }
}

inline bool T_TeamList::hasTeamDetails () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_TeamInfo >& T_TeamList::getTeamDetails () const {
    return _TeamDetails;
}

inline ::std::vector< T_TeamInfo >& T_TeamList::getTeamDetailsMutable () {
    set_has_TeamDetails();
    return _TeamDetails;
}

inline void T_TeamList::setTeamDetails (const ::std::vector< T_TeamInfo >& TeamDetails_) {
    set_has_TeamDetails();
    this->_TeamDetails = TeamDetails_;
}

inline void T_TeamList::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TeamList::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TeamList::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TeamList::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TeamList::set_has_TeamDetails () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TeamList::clear_has_TeamDetails () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AllTeams::T_AllTeams ()  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _TeamDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AllTeams::T_AllTeams (const T_AllTeams &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _TeamDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AllTeams::T_AllTeams (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_TeamInfo >& TeamDetails_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _TeamDetails (TeamDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AllTeams::~T_AllTeams() {
}

inline T_AllTeams& T_AllTeams::operator = (const T_AllTeams& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasTeamDetails()) {
            setTeamDetails(rhs.getTeamDetails());
        } else {
            clearTeamDetails();
        }
    }
    return *this;
}

inline bool T_AllTeams::operator == (const T_AllTeams& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasTeamDetails() && !rhs.hasTeamDetails()) || getTeamDetails() == rhs.getTeamDetails()));
}

inline bool T_AllTeams::operator != (const T_AllTeams& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AllTeams::operator < (const T_AllTeams& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasTeamDetails() || rhs.hasTeamDetails()) {
        if (getTeamDetails() < rhs.getTeamDetails()) return true;
        if (getTeamDetails() > rhs.getTeamDetails()) return false;
    }
    return false;
}

inline bool T_AllTeams::operator > (const T_AllTeams& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AllTeams::clear() {
    clearSPORT_ID();
    clearAFFILIATE_ID();
    clearTeamDetails();
}

inline void T_AllTeams::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_AllTeams::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AllTeams::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_AllTeams::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_AllTeams::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_AllTeams::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_AllTeams::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_AllTeams::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_AllTeams::clearTeamDetails() {
    if (hasTeamDetails()) {
         clear_has_TeamDetails();
        _TeamDetails.clear();
     }
}

inline bool T_AllTeams::hasTeamDetails () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_TeamInfo >& T_AllTeams::getTeamDetails () const {
    return _TeamDetails;
}

inline ::std::vector< T_TeamInfo >& T_AllTeams::getTeamDetailsMutable () {
    set_has_TeamDetails();
    return _TeamDetails;
}

inline void T_AllTeams::setTeamDetails (const ::std::vector< T_TeamInfo >& TeamDetails_) {
    set_has_TeamDetails();
    this->_TeamDetails = TeamDetails_;
}

inline void T_AllTeams::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AllTeams::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AllTeams::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AllTeams::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AllTeams::set_has_TeamDetails () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AllTeams::clear_has_TeamDetails () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_FavoriteInfo::T_FavoriteInfo ()  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _Team_ID (0u),
    _Team_Name (),
    _Team_Abbr_Name (),
    _Team_Known_Name (),
    _Team_Nick_Name (),
    _Sport_Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FavoriteInfo::T_FavoriteInfo (const T_FavoriteInfo &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _Team_ID (0u),
    _Team_Name (),
    _Team_Abbr_Name (),
    _Team_Known_Name (),
    _Team_Nick_Name (),
    _Sport_Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FavoriteInfo::T_FavoriteInfo (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, uint32 Team_ID_, const ::std::string& Team_Name_, const ::std::string& Team_Abbr_Name_, const ::std::string& Team_Known_Name_, const ::std::string& Team_Nick_Name_, const ::std::string& Sport_Name_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _Team_ID (Team_ID_),
    _Team_Name (Team_Name_),
    _Team_Abbr_Name (Team_Abbr_Name_),
    _Team_Known_Name (Team_Known_Name_),
    _Team_Nick_Name (Team_Nick_Name_),
    _Sport_Name (Sport_Name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sport_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FavoriteInfo::~T_FavoriteInfo() {
}

inline T_FavoriteInfo& T_FavoriteInfo::operator = (const T_FavoriteInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasTeam_ID()) {
            setTeam_ID(rhs.getTeam_ID());
        } else {
            clearTeam_ID();
        }
        if (rhs.hasTeam_Name()) {
            setTeam_Name(rhs.getTeam_Name());
        } else {
            clearTeam_Name();
        }
        if (rhs.hasTeam_Abbr_Name()) {
            setTeam_Abbr_Name(rhs.getTeam_Abbr_Name());
        } else {
            clearTeam_Abbr_Name();
        }
        if (rhs.hasTeam_Known_Name()) {
            setTeam_Known_Name(rhs.getTeam_Known_Name());
        } else {
            clearTeam_Known_Name();
        }
        if (rhs.hasTeam_Nick_Name()) {
            setTeam_Nick_Name(rhs.getTeam_Nick_Name());
        } else {
            clearTeam_Nick_Name();
        }
        if (rhs.hasSport_Name()) {
            setSport_Name(rhs.getSport_Name());
        } else {
            clearSport_Name();
        }
    }
    return *this;
}

inline bool T_FavoriteInfo::operator == (const T_FavoriteInfo& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasTeam_ID() && !rhs.hasTeam_ID()) || getTeam_ID() == rhs.getTeam_ID()) &&
        ((!hasTeam_Name() && !rhs.hasTeam_Name()) || getTeam_Name() == rhs.getTeam_Name()) &&
        ((!hasTeam_Abbr_Name() && !rhs.hasTeam_Abbr_Name()) || getTeam_Abbr_Name() == rhs.getTeam_Abbr_Name()) &&
        ((!hasTeam_Known_Name() && !rhs.hasTeam_Known_Name()) || getTeam_Known_Name() == rhs.getTeam_Known_Name()) &&
        ((!hasTeam_Nick_Name() && !rhs.hasTeam_Nick_Name()) || getTeam_Nick_Name() == rhs.getTeam_Nick_Name()) &&
        ((!hasSport_Name() && !rhs.hasSport_Name()) || getSport_Name() == rhs.getSport_Name()));
}

inline bool T_FavoriteInfo::operator != (const T_FavoriteInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FavoriteInfo::operator < (const T_FavoriteInfo& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasTeam_ID() || rhs.hasTeam_ID()) {
        if (getTeam_ID() < rhs.getTeam_ID()) return true;
        if (getTeam_ID() > rhs.getTeam_ID()) return false;
    }
    if (hasTeam_Name() || rhs.hasTeam_Name()) {
        if (getTeam_Name() < rhs.getTeam_Name()) return true;
        if (getTeam_Name() > rhs.getTeam_Name()) return false;
    }
    if (hasTeam_Abbr_Name() || rhs.hasTeam_Abbr_Name()) {
        if (getTeam_Abbr_Name() < rhs.getTeam_Abbr_Name()) return true;
        if (getTeam_Abbr_Name() > rhs.getTeam_Abbr_Name()) return false;
    }
    if (hasTeam_Known_Name() || rhs.hasTeam_Known_Name()) {
        if (getTeam_Known_Name() < rhs.getTeam_Known_Name()) return true;
        if (getTeam_Known_Name() > rhs.getTeam_Known_Name()) return false;
    }
    if (hasTeam_Nick_Name() || rhs.hasTeam_Nick_Name()) {
        if (getTeam_Nick_Name() < rhs.getTeam_Nick_Name()) return true;
        if (getTeam_Nick_Name() > rhs.getTeam_Nick_Name()) return false;
    }
    if (hasSport_Name() || rhs.hasSport_Name()) {
        if (getSport_Name() < rhs.getSport_Name()) return true;
        if (getSport_Name() > rhs.getSport_Name()) return false;
    }
    return false;
}

inline bool T_FavoriteInfo::operator > (const T_FavoriteInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FavoriteInfo::clear() {
    clearSPORT_ID();
    clearAFFILIATE_ID();
    clearTeam_ID();
    clearTeam_Name();
    clearTeam_Abbr_Name();
    clearTeam_Known_Name();
    clearTeam_Nick_Name();
    clearSport_Name();
}

inline void T_FavoriteInfo::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_FavoriteInfo::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_FavoriteInfo::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_FavoriteInfo::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_FavoriteInfo::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_FavoriteInfo::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_FavoriteInfo::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_FavoriteInfo::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_FavoriteInfo::clearTeam_ID() {
    if (hasTeam_ID()) {
         clear_has_Team_ID();
        _Team_ID = 0u;
     }
}

inline bool T_FavoriteInfo::hasTeam_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_FavoriteInfo::getTeam_ID () const {
    return _Team_ID;
}

inline void T_FavoriteInfo::setTeam_ID (uint32 Team_ID_) {
    set_has_Team_ID();
    this->_Team_ID = Team_ID_;
}

inline void T_FavoriteInfo::clearTeam_Name() {
    if (hasTeam_Name()) {
         clear_has_Team_Name();
        _Team_Name.clear();
     }
}

inline bool T_FavoriteInfo::hasTeam_Name () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_FavoriteInfo::getTeam_Name () const {
    return _Team_Name;
}

inline ::std::string& T_FavoriteInfo::getTeam_NameMutable () {
    set_has_Team_Name();
    return _Team_Name;
}

inline void T_FavoriteInfo::setTeam_Name (const ::std::string& Team_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name = Team_Name_;
}

inline void T_FavoriteInfo::setTeam_Name (const char* Team_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name.assign(Team_Name_);
}

inline void T_FavoriteInfo::setTeam_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Name();
    this->_Team_Name.assign(value, size);
}

inline void T_FavoriteInfo::clearTeam_Abbr_Name() {
    if (hasTeam_Abbr_Name()) {
         clear_has_Team_Abbr_Name();
        _Team_Abbr_Name.clear();
     }
}

inline bool T_FavoriteInfo::hasTeam_Abbr_Name () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_FavoriteInfo::getTeam_Abbr_Name () const {
    return _Team_Abbr_Name;
}

inline ::std::string& T_FavoriteInfo::getTeam_Abbr_NameMutable () {
    set_has_Team_Abbr_Name();
    return _Team_Abbr_Name;
}

inline void T_FavoriteInfo::setTeam_Abbr_Name (const ::std::string& Team_Abbr_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name = Team_Abbr_Name_;
}

inline void T_FavoriteInfo::setTeam_Abbr_Name (const char* Team_Abbr_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Abbr_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name.assign(Team_Abbr_Name_);
}

inline void T_FavoriteInfo::setTeam_Abbr_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Abbr_Name();
    this->_Team_Abbr_Name.assign(value, size);
}

inline void T_FavoriteInfo::clearTeam_Known_Name() {
    if (hasTeam_Known_Name()) {
         clear_has_Team_Known_Name();
        _Team_Known_Name.clear();
     }
}

inline bool T_FavoriteInfo::hasTeam_Known_Name () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_FavoriteInfo::getTeam_Known_Name () const {
    return _Team_Known_Name;
}

inline ::std::string& T_FavoriteInfo::getTeam_Known_NameMutable () {
    set_has_Team_Known_Name();
    return _Team_Known_Name;
}

inline void T_FavoriteInfo::setTeam_Known_Name (const ::std::string& Team_Known_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name = Team_Known_Name_;
}

inline void T_FavoriteInfo::setTeam_Known_Name (const char* Team_Known_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Known_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name.assign(Team_Known_Name_);
}

inline void T_FavoriteInfo::setTeam_Known_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Known_Name();
    this->_Team_Known_Name.assign(value, size);
}

inline void T_FavoriteInfo::clearTeam_Nick_Name() {
    if (hasTeam_Nick_Name()) {
         clear_has_Team_Nick_Name();
        _Team_Nick_Name.clear();
     }
}

inline bool T_FavoriteInfo::hasTeam_Nick_Name () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_FavoriteInfo::getTeam_Nick_Name () const {
    return _Team_Nick_Name;
}

inline ::std::string& T_FavoriteInfo::getTeam_Nick_NameMutable () {
    set_has_Team_Nick_Name();
    return _Team_Nick_Name;
}

inline void T_FavoriteInfo::setTeam_Nick_Name (const ::std::string& Team_Nick_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name = Team_Nick_Name_;
}

inline void T_FavoriteInfo::setTeam_Nick_Name (const char* Team_Nick_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Team_Nick_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name.assign(Team_Nick_Name_);
}

inline void T_FavoriteInfo::setTeam_Nick_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Team_Nick_Name();
    this->_Team_Nick_Name.assign(value, size);
}

inline void T_FavoriteInfo::clearSport_Name() {
    if (hasSport_Name()) {
         clear_has_Sport_Name();
        _Sport_Name.clear();
     }
}

inline bool T_FavoriteInfo::hasSport_Name () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_FavoriteInfo::getSport_Name () const {
    return _Sport_Name;
}

inline ::std::string& T_FavoriteInfo::getSport_NameMutable () {
    set_has_Sport_Name();
    return _Sport_Name;
}

inline void T_FavoriteInfo::setSport_Name (const ::std::string& Sport_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sport_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sport_Name();
    this->_Sport_Name = Sport_Name_;
}

inline void T_FavoriteInfo::setSport_Name (const char* Sport_Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Sport_Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sport_Name();
    this->_Sport_Name.assign(Sport_Name_);
}

inline void T_FavoriteInfo::setSport_Name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Sport_Name();
    this->_Sport_Name.assign(value, size);
}

inline void T_FavoriteInfo::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FavoriteInfo::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FavoriteInfo::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FavoriteInfo::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FavoriteInfo::set_has_Team_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FavoriteInfo::clear_has_Team_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FavoriteInfo::set_has_Team_Name () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FavoriteInfo::clear_has_Team_Name () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FavoriteInfo::set_has_Team_Abbr_Name () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FavoriteInfo::clear_has_Team_Abbr_Name () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_FavoriteInfo::set_has_Team_Known_Name () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_FavoriteInfo::clear_has_Team_Known_Name () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_FavoriteInfo::set_has_Team_Nick_Name () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_FavoriteInfo::clear_has_Team_Nick_Name () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_FavoriteInfo::set_has_Sport_Name () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_FavoriteInfo::clear_has_Sport_Name () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_EventSchedule::T_EventSchedule ()  :
    _Tourney_Race (),
    _EventState (::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled),
    _Course_Track (),
    _Game_Time (),
    _XMChannelList (),
    _Purse_Laps (0u),
    _Winner (),
    _CarNumber (),
    _CarMake (),
    _Yardage_Lap (0u),
    _IsRankListAvl (false),
    _TableParam (0),
    _TableRef (0),
    _Event_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EventSchedule::T_EventSchedule (const T_EventSchedule &rhs)  :
    _Tourney_Race (),
    _EventState (::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled),
    _Course_Track (),
    _Game_Time (),
    _XMChannelList (),
    _Purse_Laps (0u),
    _Winner (),
    _CarNumber (),
    _CarMake (),
    _Yardage_Lap (0u),
    _IsRankListAvl (false),
    _TableParam (0),
    _TableRef (0),
    _Event_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EventSchedule::T_EventSchedule (const ::std::string& Tourney_Race_, T_e8_Game_Status EventState_, const ::std::string& Course_Track_, const T_TimeInfo& Game_Time_, const ::std::vector< T_XMChannel >& XMChannelList_, uint32 Purse_Laps_, const ::std::string& Winner_, const ::std::string& CarNumber_, const ::std::string& CarMake_, uint32 Yardage_Lap_, bool IsRankListAvl_, int32 TableParam_, int32 TableRef_, uint32 Event_ID_)  :
    _Tourney_Race (Tourney_Race_),
    _EventState (EventState_),
    _Course_Track (Course_Track_),
    _Game_Time (Game_Time_),
    _XMChannelList (XMChannelList_),
    _Purse_Laps (Purse_Laps_),
    _Winner (Winner_),
    _CarNumber (CarNumber_),
    _CarMake (CarMake_),
    _Yardage_Lap (Yardage_Lap_),
    _IsRankListAvl (IsRankListAvl_),
    _TableParam (TableParam_),
    _TableRef (TableRef_),
    _Event_ID (Event_ID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tourney_Race_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_Game_Status_IsValid(EventState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventState_, "T_e8_Game_Status", "EventState", "T_EventSchedule");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Course_Track_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Winner_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarMake_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EventSchedule::~T_EventSchedule() {
}

inline T_EventSchedule& T_EventSchedule::operator = (const T_EventSchedule& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTourney_Race()) {
            setTourney_Race(rhs.getTourney_Race());
        } else {
            clearTourney_Race();
        }
        if (rhs.hasEventState()) {
            setEventState(rhs.getEventState());
        } else {
            clearEventState();
        }
        if (rhs.hasCourse_Track()) {
            setCourse_Track(rhs.getCourse_Track());
        } else {
            clearCourse_Track();
        }
        if (rhs.hasGame_Time()) {
            setGame_Time(rhs.getGame_Time());
        } else {
            clearGame_Time();
        }
        if (rhs.hasXMChannelList()) {
            setXMChannelList(rhs.getXMChannelList());
        } else {
            clearXMChannelList();
        }
        if (rhs.hasPurse_Laps()) {
            setPurse_Laps(rhs.getPurse_Laps());
        } else {
            clearPurse_Laps();
        }
        if (rhs.hasWinner()) {
            setWinner(rhs.getWinner());
        } else {
            clearWinner();
        }
        if (rhs.hasCarNumber()) {
            setCarNumber(rhs.getCarNumber());
        } else {
            clearCarNumber();
        }
        if (rhs.hasCarMake()) {
            setCarMake(rhs.getCarMake());
        } else {
            clearCarMake();
        }
        if (rhs.hasYardage_Lap()) {
            setYardage_Lap(rhs.getYardage_Lap());
        } else {
            clearYardage_Lap();
        }
        if (rhs.hasIsRankListAvl()) {
            setIsRankListAvl(rhs.getIsRankListAvl());
        } else {
            clearIsRankListAvl();
        }
        if (rhs.hasTableParam()) {
            setTableParam(rhs.getTableParam());
        } else {
            clearTableParam();
        }
        if (rhs.hasTableRef()) {
            setTableRef(rhs.getTableRef());
        } else {
            clearTableRef();
        }
        if (rhs.hasEvent_ID()) {
            setEvent_ID(rhs.getEvent_ID());
        } else {
            clearEvent_ID();
        }
    }
    return *this;
}

inline bool T_EventSchedule::operator == (const T_EventSchedule& rhs) const {
    return (((!hasTourney_Race() && !rhs.hasTourney_Race()) || getTourney_Race() == rhs.getTourney_Race()) &&
        ((!hasEventState() && !rhs.hasEventState()) || getEventState() == rhs.getEventState()) &&
        ((!hasCourse_Track() && !rhs.hasCourse_Track()) || getCourse_Track() == rhs.getCourse_Track()) &&
        ((!hasGame_Time() && !rhs.hasGame_Time()) || getGame_Time() == rhs.getGame_Time()) &&
        ((!hasXMChannelList() && !rhs.hasXMChannelList()) || getXMChannelList() == rhs.getXMChannelList()) &&
        ((!hasPurse_Laps() && !rhs.hasPurse_Laps()) || getPurse_Laps() == rhs.getPurse_Laps()) &&
        ((!hasWinner() && !rhs.hasWinner()) || getWinner() == rhs.getWinner()) &&
        ((!hasCarNumber() && !rhs.hasCarNumber()) || getCarNumber() == rhs.getCarNumber()) &&
        ((!hasCarMake() && !rhs.hasCarMake()) || getCarMake() == rhs.getCarMake()) &&
        ((!hasYardage_Lap() && !rhs.hasYardage_Lap()) || getYardage_Lap() == rhs.getYardage_Lap()) &&
        ((!hasIsRankListAvl() && !rhs.hasIsRankListAvl()) || getIsRankListAvl() == rhs.getIsRankListAvl()) &&
        ((!hasTableParam() && !rhs.hasTableParam()) || getTableParam() == rhs.getTableParam()) &&
        ((!hasTableRef() && !rhs.hasTableRef()) || getTableRef() == rhs.getTableRef()) &&
        ((!hasEvent_ID() && !rhs.hasEvent_ID()) || getEvent_ID() == rhs.getEvent_ID()));
}

inline bool T_EventSchedule::operator != (const T_EventSchedule& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EventSchedule::operator < (const T_EventSchedule& rhs) const {
    if (hasTourney_Race() || rhs.hasTourney_Race()) {
        if (getTourney_Race() < rhs.getTourney_Race()) return true;
        if (getTourney_Race() > rhs.getTourney_Race()) return false;
    }
    if (hasEventState() || rhs.hasEventState()) {
        if ((uint32)getEventState() < (uint32)rhs.getEventState()) return true;
        if ((uint32)getEventState() > (uint32)rhs.getEventState()) return false;
    }
    if (hasCourse_Track() || rhs.hasCourse_Track()) {
        if (getCourse_Track() < rhs.getCourse_Track()) return true;
        if (getCourse_Track() > rhs.getCourse_Track()) return false;
    }
    if (hasGame_Time() || rhs.hasGame_Time()) {
        if (getGame_Time() < rhs.getGame_Time()) return true;
        if (getGame_Time() > rhs.getGame_Time()) return false;
    }
    if (hasXMChannelList() || rhs.hasXMChannelList()) {
        if (getXMChannelList() < rhs.getXMChannelList()) return true;
        if (getXMChannelList() > rhs.getXMChannelList()) return false;
    }
    if (hasPurse_Laps() || rhs.hasPurse_Laps()) {
        if (getPurse_Laps() < rhs.getPurse_Laps()) return true;
        if (getPurse_Laps() > rhs.getPurse_Laps()) return false;
    }
    if (hasWinner() || rhs.hasWinner()) {
        if (getWinner() < rhs.getWinner()) return true;
        if (getWinner() > rhs.getWinner()) return false;
    }
    if (hasCarNumber() || rhs.hasCarNumber()) {
        if (getCarNumber() < rhs.getCarNumber()) return true;
        if (getCarNumber() > rhs.getCarNumber()) return false;
    }
    if (hasCarMake() || rhs.hasCarMake()) {
        if (getCarMake() < rhs.getCarMake()) return true;
        if (getCarMake() > rhs.getCarMake()) return false;
    }
    if (hasYardage_Lap() || rhs.hasYardage_Lap()) {
        if (getYardage_Lap() < rhs.getYardage_Lap()) return true;
        if (getYardage_Lap() > rhs.getYardage_Lap()) return false;
    }
    if (hasIsRankListAvl() || rhs.hasIsRankListAvl()) {
        if (getIsRankListAvl() < rhs.getIsRankListAvl()) return true;
        if (getIsRankListAvl() > rhs.getIsRankListAvl()) return false;
    }
    if (hasTableParam() || rhs.hasTableParam()) {
        if (getTableParam() < rhs.getTableParam()) return true;
        if (getTableParam() > rhs.getTableParam()) return false;
    }
    if (hasTableRef() || rhs.hasTableRef()) {
        if (getTableRef() < rhs.getTableRef()) return true;
        if (getTableRef() > rhs.getTableRef()) return false;
    }
    if (hasEvent_ID() || rhs.hasEvent_ID()) {
        if (getEvent_ID() < rhs.getEvent_ID()) return true;
        if (getEvent_ID() > rhs.getEvent_ID()) return false;
    }
    return false;
}

inline bool T_EventSchedule::operator > (const T_EventSchedule& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EventSchedule::clear() {
    clearTourney_Race();
    clearEventState();
    clearCourse_Track();
    clearGame_Time();
    clearXMChannelList();
    clearPurse_Laps();
    clearWinner();
    clearCarNumber();
    clearCarMake();
    clearYardage_Lap();
    clearIsRankListAvl();
    clearTableParam();
    clearTableRef();
    clearEvent_ID();
}

inline void T_EventSchedule::clearTourney_Race() {
    if (hasTourney_Race()) {
         clear_has_Tourney_Race();
        _Tourney_Race.clear();
     }
}

inline bool T_EventSchedule::hasTourney_Race () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_EventSchedule::getTourney_Race () const {
    return _Tourney_Race;
}

inline ::std::string& T_EventSchedule::getTourney_RaceMutable () {
    set_has_Tourney_Race();
    return _Tourney_Race;
}

inline void T_EventSchedule::setTourney_Race (const ::std::string& Tourney_Race_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tourney_Race_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tourney_Race();
    this->_Tourney_Race = Tourney_Race_;
}

inline void T_EventSchedule::setTourney_Race (const char* Tourney_Race_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tourney_Race_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tourney_Race();
    this->_Tourney_Race.assign(Tourney_Race_);
}

inline void T_EventSchedule::setTourney_Race (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tourney_Race();
    this->_Tourney_Race.assign(value, size);
}

inline void T_EventSchedule::clearEventState() {
    if (hasEventState()) {
         clear_has_EventState();
        _EventState = ::sxm_sports_main_fi_types::T_e8_Game_Status__Game_Status_Scheduled;
     }
}

inline bool T_EventSchedule::hasEventState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Game_Status T_EventSchedule::getEventState () const {
    return _EventState;
}

inline void T_EventSchedule::setEventState (T_e8_Game_Status EventState_) {
    #ifndef NDEBUG
    if (!(T_e8_Game_Status_IsValid(EventState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventState_, "T_e8_Game_Status", "EventState", "T_EventSchedule");
    }
    #endif
    set_has_EventState();
    this->_EventState = EventState_;
}

inline void T_EventSchedule::clearCourse_Track() {
    if (hasCourse_Track()) {
         clear_has_Course_Track();
        _Course_Track.clear();
     }
}

inline bool T_EventSchedule::hasCourse_Track () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_EventSchedule::getCourse_Track () const {
    return _Course_Track;
}

inline ::std::string& T_EventSchedule::getCourse_TrackMutable () {
    set_has_Course_Track();
    return _Course_Track;
}

inline void T_EventSchedule::setCourse_Track (const ::std::string& Course_Track_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Course_Track_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Course_Track();
    this->_Course_Track = Course_Track_;
}

inline void T_EventSchedule::setCourse_Track (const char* Course_Track_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Course_Track_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Course_Track();
    this->_Course_Track.assign(Course_Track_);
}

inline void T_EventSchedule::setCourse_Track (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Course_Track();
    this->_Course_Track.assign(value, size);
}

inline void T_EventSchedule::clearGame_Time() {
    if (hasGame_Time()) {
         clear_has_Game_Time();
        _Game_Time.clear();
     }
}

inline bool T_EventSchedule::hasGame_Time () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_TimeInfo& T_EventSchedule::getGame_Time () const {
    return _Game_Time;
}

inline T_TimeInfo& T_EventSchedule::getGame_TimeMutable () {
    set_has_Game_Time();
    return _Game_Time;
}

inline void T_EventSchedule::setGame_Time (const T_TimeInfo& Game_Time_) {
    set_has_Game_Time();
    this->_Game_Time = Game_Time_;
}

inline void T_EventSchedule::clearXMChannelList() {
    if (hasXMChannelList()) {
         clear_has_XMChannelList();
        _XMChannelList.clear();
     }
}

inline bool T_EventSchedule::hasXMChannelList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< T_XMChannel >& T_EventSchedule::getXMChannelList () const {
    return _XMChannelList;
}

inline ::std::vector< T_XMChannel >& T_EventSchedule::getXMChannelListMutable () {
    set_has_XMChannelList();
    return _XMChannelList;
}

inline void T_EventSchedule::setXMChannelList (const ::std::vector< T_XMChannel >& XMChannelList_) {
    set_has_XMChannelList();
    this->_XMChannelList = XMChannelList_;
}

inline void T_EventSchedule::clearPurse_Laps() {
    if (hasPurse_Laps()) {
         clear_has_Purse_Laps();
        _Purse_Laps = 0u;
     }
}

inline bool T_EventSchedule::hasPurse_Laps () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_EventSchedule::getPurse_Laps () const {
    return _Purse_Laps;
}

inline void T_EventSchedule::setPurse_Laps (uint32 Purse_Laps_) {
    set_has_Purse_Laps();
    this->_Purse_Laps = Purse_Laps_;
}

inline void T_EventSchedule::clearWinner() {
    if (hasWinner()) {
         clear_has_Winner();
        _Winner.clear();
     }
}

inline bool T_EventSchedule::hasWinner () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_EventSchedule::getWinner () const {
    return _Winner;
}

inline ::std::string& T_EventSchedule::getWinnerMutable () {
    set_has_Winner();
    return _Winner;
}

inline void T_EventSchedule::setWinner (const ::std::string& Winner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Winner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Winner();
    this->_Winner = Winner_;
}

inline void T_EventSchedule::setWinner (const char* Winner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Winner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Winner();
    this->_Winner.assign(Winner_);
}

inline void T_EventSchedule::setWinner (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Winner();
    this->_Winner.assign(value, size);
}

inline void T_EventSchedule::clearCarNumber() {
    if (hasCarNumber()) {
         clear_has_CarNumber();
        _CarNumber.clear();
     }
}

inline bool T_EventSchedule::hasCarNumber () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_EventSchedule::getCarNumber () const {
    return _CarNumber;
}

inline ::std::string& T_EventSchedule::getCarNumberMutable () {
    set_has_CarNumber();
    return _CarNumber;
}

inline void T_EventSchedule::setCarNumber (const ::std::string& CarNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarNumber();
    this->_CarNumber = CarNumber_;
}

inline void T_EventSchedule::setCarNumber (const char* CarNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarNumber();
    this->_CarNumber.assign(CarNumber_);
}

inline void T_EventSchedule::setCarNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarNumber();
    this->_CarNumber.assign(value, size);
}

inline void T_EventSchedule::clearCarMake() {
    if (hasCarMake()) {
         clear_has_CarMake();
        _CarMake.clear();
     }
}

inline bool T_EventSchedule::hasCarMake () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_EventSchedule::getCarMake () const {
    return _CarMake;
}

inline ::std::string& T_EventSchedule::getCarMakeMutable () {
    set_has_CarMake();
    return _CarMake;
}

inline void T_EventSchedule::setCarMake (const ::std::string& CarMake_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarMake_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarMake();
    this->_CarMake = CarMake_;
}

inline void T_EventSchedule::setCarMake (const char* CarMake_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CarMake_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarMake();
    this->_CarMake.assign(CarMake_);
}

inline void T_EventSchedule::setCarMake (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CarMake();
    this->_CarMake.assign(value, size);
}

inline void T_EventSchedule::clearYardage_Lap() {
    if (hasYardage_Lap()) {
         clear_has_Yardage_Lap();
        _Yardage_Lap = 0u;
     }
}

inline bool T_EventSchedule::hasYardage_Lap () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 T_EventSchedule::getYardage_Lap () const {
    return _Yardage_Lap;
}

inline void T_EventSchedule::setYardage_Lap (uint32 Yardage_Lap_) {
    set_has_Yardage_Lap();
    this->_Yardage_Lap = Yardage_Lap_;
}

inline void T_EventSchedule::clearIsRankListAvl() {
    if (hasIsRankListAvl()) {
         clear_has_IsRankListAvl();
        _IsRankListAvl = false;
     }
}

inline bool T_EventSchedule::hasIsRankListAvl () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_EventSchedule::getIsRankListAvl () const {
    return _IsRankListAvl;
}

inline void T_EventSchedule::setIsRankListAvl (bool IsRankListAvl_) {
    set_has_IsRankListAvl();
    this->_IsRankListAvl = IsRankListAvl_;
}

inline void T_EventSchedule::clearTableParam() {
    if (hasTableParam()) {
         clear_has_TableParam();
        _TableParam = 0;
     }
}

inline bool T_EventSchedule::hasTableParam () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline int32 T_EventSchedule::getTableParam () const {
    return _TableParam;
}

inline void T_EventSchedule::setTableParam (int32 TableParam_) {
    set_has_TableParam();
    this->_TableParam = TableParam_;
}

inline void T_EventSchedule::clearTableRef() {
    if (hasTableRef()) {
         clear_has_TableRef();
        _TableRef = 0;
     }
}

inline bool T_EventSchedule::hasTableRef () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline int32 T_EventSchedule::getTableRef () const {
    return _TableRef;
}

inline void T_EventSchedule::setTableRef (int32 TableRef_) {
    set_has_TableRef();
    this->_TableRef = TableRef_;
}

inline void T_EventSchedule::clearEvent_ID() {
    if (hasEvent_ID()) {
         clear_has_Event_ID();
        _Event_ID = 0u;
     }
}

inline bool T_EventSchedule::hasEvent_ID () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_EventSchedule::getEvent_ID () const {
    return _Event_ID;
}

inline void T_EventSchedule::setEvent_ID (uint32 Event_ID_) {
    set_has_Event_ID();
    this->_Event_ID = Event_ID_;
}

inline void T_EventSchedule::set_has_Tourney_Race () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EventSchedule::clear_has_Tourney_Race () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EventSchedule::set_has_EventState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EventSchedule::clear_has_EventState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EventSchedule::set_has_Course_Track () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EventSchedule::clear_has_Course_Track () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_EventSchedule::set_has_Game_Time () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_EventSchedule::clear_has_Game_Time () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_EventSchedule::set_has_XMChannelList () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_EventSchedule::clear_has_XMChannelList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_EventSchedule::set_has_Purse_Laps () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_EventSchedule::clear_has_Purse_Laps () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_EventSchedule::set_has_Winner () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_EventSchedule::clear_has_Winner () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_EventSchedule::set_has_CarNumber () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_EventSchedule::clear_has_CarNumber () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_EventSchedule::set_has_CarMake () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_EventSchedule::clear_has_CarMake () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_EventSchedule::set_has_Yardage_Lap () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_EventSchedule::clear_has_Yardage_Lap () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_EventSchedule::set_has_IsRankListAvl () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_EventSchedule::clear_has_IsRankListAvl () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_EventSchedule::set_has_TableParam () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_EventSchedule::clear_has_TableParam () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_EventSchedule::set_has_TableRef () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_EventSchedule::clear_has_TableRef () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_EventSchedule::set_has_Event_ID () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_EventSchedule::clear_has_Event_ID () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_EventSchedule_List::T_EventSchedule_List ()  :
    _SPORT_ID (0u),
    _AFFILIATE_INFO (),
    _bIsRecentEventsAvl (false),
    _bIsCurrentEventsAvl (false),
    _bIsFutureEventsAvl (false),
    _ListIndex (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Eventlist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EventSchedule_List::T_EventSchedule_List (const T_EventSchedule_List &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_INFO (),
    _bIsRecentEventsAvl (false),
    _bIsCurrentEventsAvl (false),
    _bIsFutureEventsAvl (false),
    _ListIndex (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Eventlist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EventSchedule_List::T_EventSchedule_List (uint8 SPORT_ID_, const T_AffiliateInfo& AFFILIATE_INFO_, bool bIsRecentEventsAvl_, bool bIsCurrentEventsAvl_, bool bIsFutureEventsAvl_, uint32 ListIndex_, T_GameType EventType_, const ::std::vector< T_EventSchedule >& Eventlist_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_INFO (AFFILIATE_INFO_),
    _bIsRecentEventsAvl (bIsRecentEventsAvl_),
    _bIsCurrentEventsAvl (bIsCurrentEventsAvl_),
    _bIsFutureEventsAvl (bIsFutureEventsAvl_),
    _ListIndex (ListIndex_),
    _EventType (EventType_),
    _Eventlist (Eventlist_)
{
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "T_EventSchedule_List");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EventSchedule_List::~T_EventSchedule_List() {
}

inline T_EventSchedule_List& T_EventSchedule_List::operator = (const T_EventSchedule_List& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_INFO()) {
            setAFFILIATE_INFO(rhs.getAFFILIATE_INFO());
        } else {
            clearAFFILIATE_INFO();
        }
        if (rhs.hasBIsRecentEventsAvl()) {
            setBIsRecentEventsAvl(rhs.getBIsRecentEventsAvl());
        } else {
            clearBIsRecentEventsAvl();
        }
        if (rhs.hasBIsCurrentEventsAvl()) {
            setBIsCurrentEventsAvl(rhs.getBIsCurrentEventsAvl());
        } else {
            clearBIsCurrentEventsAvl();
        }
        if (rhs.hasBIsFutureEventsAvl()) {
            setBIsFutureEventsAvl(rhs.getBIsFutureEventsAvl());
        } else {
            clearBIsFutureEventsAvl();
        }
        if (rhs.hasListIndex()) {
            setListIndex(rhs.getListIndex());
        } else {
            clearListIndex();
        }
        if (rhs.hasEventType()) {
            setEventType(rhs.getEventType());
        } else {
            clearEventType();
        }
        if (rhs.hasEventlist()) {
            setEventlist(rhs.getEventlist());
        } else {
            clearEventlist();
        }
    }
    return *this;
}

inline bool T_EventSchedule_List::operator == (const T_EventSchedule_List& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_INFO() && !rhs.hasAFFILIATE_INFO()) || getAFFILIATE_INFO() == rhs.getAFFILIATE_INFO()) &&
        ((!hasBIsRecentEventsAvl() && !rhs.hasBIsRecentEventsAvl()) || getBIsRecentEventsAvl() == rhs.getBIsRecentEventsAvl()) &&
        ((!hasBIsCurrentEventsAvl() && !rhs.hasBIsCurrentEventsAvl()) || getBIsCurrentEventsAvl() == rhs.getBIsCurrentEventsAvl()) &&
        ((!hasBIsFutureEventsAvl() && !rhs.hasBIsFutureEventsAvl()) || getBIsFutureEventsAvl() == rhs.getBIsFutureEventsAvl()) &&
        ((!hasListIndex() && !rhs.hasListIndex()) || getListIndex() == rhs.getListIndex()) &&
        ((!hasEventType() && !rhs.hasEventType()) || getEventType() == rhs.getEventType()) &&
        ((!hasEventlist() && !rhs.hasEventlist()) || getEventlist() == rhs.getEventlist()));
}

inline bool T_EventSchedule_List::operator != (const T_EventSchedule_List& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EventSchedule_List::operator < (const T_EventSchedule_List& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_INFO() || rhs.hasAFFILIATE_INFO()) {
        if (getAFFILIATE_INFO() < rhs.getAFFILIATE_INFO()) return true;
        if (getAFFILIATE_INFO() > rhs.getAFFILIATE_INFO()) return false;
    }
    if (hasBIsRecentEventsAvl() || rhs.hasBIsRecentEventsAvl()) {
        if (getBIsRecentEventsAvl() < rhs.getBIsRecentEventsAvl()) return true;
        if (getBIsRecentEventsAvl() > rhs.getBIsRecentEventsAvl()) return false;
    }
    if (hasBIsCurrentEventsAvl() || rhs.hasBIsCurrentEventsAvl()) {
        if (getBIsCurrentEventsAvl() < rhs.getBIsCurrentEventsAvl()) return true;
        if (getBIsCurrentEventsAvl() > rhs.getBIsCurrentEventsAvl()) return false;
    }
    if (hasBIsFutureEventsAvl() || rhs.hasBIsFutureEventsAvl()) {
        if (getBIsFutureEventsAvl() < rhs.getBIsFutureEventsAvl()) return true;
        if (getBIsFutureEventsAvl() > rhs.getBIsFutureEventsAvl()) return false;
    }
    if (hasListIndex() || rhs.hasListIndex()) {
        if (getListIndex() < rhs.getListIndex()) return true;
        if (getListIndex() > rhs.getListIndex()) return false;
    }
    if (hasEventType() || rhs.hasEventType()) {
        if ((uint32)getEventType() < (uint32)rhs.getEventType()) return true;
        if ((uint32)getEventType() > (uint32)rhs.getEventType()) return false;
    }
    if (hasEventlist() || rhs.hasEventlist()) {
        if (getEventlist() < rhs.getEventlist()) return true;
        if (getEventlist() > rhs.getEventlist()) return false;
    }
    return false;
}

inline bool T_EventSchedule_List::operator > (const T_EventSchedule_List& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EventSchedule_List::clear() {
    clearSPORT_ID();
    clearAFFILIATE_INFO();
    clearBIsRecentEventsAvl();
    clearBIsCurrentEventsAvl();
    clearBIsFutureEventsAvl();
    clearListIndex();
    clearEventType();
    clearEventlist();
}

inline void T_EventSchedule_List::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_EventSchedule_List::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_EventSchedule_List::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_EventSchedule_List::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_EventSchedule_List::clearAFFILIATE_INFO() {
    if (hasAFFILIATE_INFO()) {
         clear_has_AFFILIATE_INFO();
        _AFFILIATE_INFO.clear();
     }
}

inline bool T_EventSchedule_List::hasAFFILIATE_INFO () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_AffiliateInfo& T_EventSchedule_List::getAFFILIATE_INFO () const {
    return _AFFILIATE_INFO;
}

inline T_AffiliateInfo& T_EventSchedule_List::getAFFILIATE_INFOMutable () {
    set_has_AFFILIATE_INFO();
    return _AFFILIATE_INFO;
}

inline void T_EventSchedule_List::setAFFILIATE_INFO (const T_AffiliateInfo& AFFILIATE_INFO_) {
    set_has_AFFILIATE_INFO();
    this->_AFFILIATE_INFO = AFFILIATE_INFO_;
}

inline void T_EventSchedule_List::clearBIsRecentEventsAvl() {
    if (hasBIsRecentEventsAvl()) {
         clear_has_bIsRecentEventsAvl();
        _bIsRecentEventsAvl = false;
     }
}

inline bool T_EventSchedule_List::hasBIsRecentEventsAvl () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_EventSchedule_List::getBIsRecentEventsAvl () const {
    return _bIsRecentEventsAvl;
}

inline void T_EventSchedule_List::setBIsRecentEventsAvl (bool bIsRecentEventsAvl_) {
    set_has_bIsRecentEventsAvl();
    this->_bIsRecentEventsAvl = bIsRecentEventsAvl_;
}

inline void T_EventSchedule_List::clearBIsCurrentEventsAvl() {
    if (hasBIsCurrentEventsAvl()) {
         clear_has_bIsCurrentEventsAvl();
        _bIsCurrentEventsAvl = false;
     }
}

inline bool T_EventSchedule_List::hasBIsCurrentEventsAvl () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_EventSchedule_List::getBIsCurrentEventsAvl () const {
    return _bIsCurrentEventsAvl;
}

inline void T_EventSchedule_List::setBIsCurrentEventsAvl (bool bIsCurrentEventsAvl_) {
    set_has_bIsCurrentEventsAvl();
    this->_bIsCurrentEventsAvl = bIsCurrentEventsAvl_;
}

inline void T_EventSchedule_List::clearBIsFutureEventsAvl() {
    if (hasBIsFutureEventsAvl()) {
         clear_has_bIsFutureEventsAvl();
        _bIsFutureEventsAvl = false;
     }
}

inline bool T_EventSchedule_List::hasBIsFutureEventsAvl () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_EventSchedule_List::getBIsFutureEventsAvl () const {
    return _bIsFutureEventsAvl;
}

inline void T_EventSchedule_List::setBIsFutureEventsAvl (bool bIsFutureEventsAvl_) {
    set_has_bIsFutureEventsAvl();
    this->_bIsFutureEventsAvl = bIsFutureEventsAvl_;
}

inline void T_EventSchedule_List::clearListIndex() {
    if (hasListIndex()) {
         clear_has_ListIndex();
        _ListIndex = 0u;
     }
}

inline bool T_EventSchedule_List::hasListIndex () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_EventSchedule_List::getListIndex () const {
    return _ListIndex;
}

inline void T_EventSchedule_List::setListIndex (uint32 ListIndex_) {
    set_has_ListIndex();
    this->_ListIndex = ListIndex_;
}

inline void T_EventSchedule_List::clearEventType() {
    if (hasEventType()) {
         clear_has_EventType();
        _EventType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool T_EventSchedule_List::hasEventType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_GameType T_EventSchedule_List::getEventType () const {
    return _EventType;
}

inline void T_EventSchedule_List::setEventType (T_GameType EventType_) {
    #ifndef NDEBUG
    if (!(T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "T_EventSchedule_List");
    }
    #endif
    set_has_EventType();
    this->_EventType = EventType_;
}

inline void T_EventSchedule_List::clearEventlist() {
    if (hasEventlist()) {
         clear_has_Eventlist();
        _Eventlist.clear();
     }
}

inline bool T_EventSchedule_List::hasEventlist () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< T_EventSchedule >& T_EventSchedule_List::getEventlist () const {
    return _Eventlist;
}

inline ::std::vector< T_EventSchedule >& T_EventSchedule_List::getEventlistMutable () {
    set_has_Eventlist();
    return _Eventlist;
}

inline void T_EventSchedule_List::setEventlist (const ::std::vector< T_EventSchedule >& Eventlist_) {
    set_has_Eventlist();
    this->_Eventlist = Eventlist_;
}

inline void T_EventSchedule_List::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EventSchedule_List::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EventSchedule_List::set_has_AFFILIATE_INFO () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EventSchedule_List::clear_has_AFFILIATE_INFO () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EventSchedule_List::set_has_bIsRecentEventsAvl () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EventSchedule_List::clear_has_bIsRecentEventsAvl () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_EventSchedule_List::set_has_bIsCurrentEventsAvl () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_EventSchedule_List::clear_has_bIsCurrentEventsAvl () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_EventSchedule_List::set_has_bIsFutureEventsAvl () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_EventSchedule_List::clear_has_bIsFutureEventsAvl () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_EventSchedule_List::set_has_ListIndex () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_EventSchedule_List::clear_has_ListIndex () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_EventSchedule_List::set_has_EventType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_EventSchedule_List::clear_has_EventType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_EventSchedule_List::set_has_Eventlist () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_EventSchedule_List::clear_has_Eventlist () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_EventRank::T_EventRank ()  :
    _Rank (),
    _Name (),
    _Laps (0u),
    _Score_Make (),
    _Number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EventRank::T_EventRank (const T_EventRank &rhs)  :
    _Rank (),
    _Name (),
    _Laps (0u),
    _Score_Make (),
    _Number ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EventRank::T_EventRank (const ::std::string& Rank_, const ::std::string& Name_, uint32 Laps_, const ::std::string& Score_Make_, const ::std::string& Number_)  :
    _Rank (Rank_),
    _Name (Name_),
    _Laps (Laps_),
    _Score_Make (Score_Make_),
    _Number (Number_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Rank_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Score_Make_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Number_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EventRank::~T_EventRank() {
}

inline T_EventRank& T_EventRank::operator = (const T_EventRank& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRank()) {
            setRank(rhs.getRank());
        } else {
            clearRank();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasLaps()) {
            setLaps(rhs.getLaps());
        } else {
            clearLaps();
        }
        if (rhs.hasScore_Make()) {
            setScore_Make(rhs.getScore_Make());
        } else {
            clearScore_Make();
        }
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
    }
    return *this;
}

inline bool T_EventRank::operator == (const T_EventRank& rhs) const {
    return (((!hasRank() && !rhs.hasRank()) || getRank() == rhs.getRank()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasLaps() && !rhs.hasLaps()) || getLaps() == rhs.getLaps()) &&
        ((!hasScore_Make() && !rhs.hasScore_Make()) || getScore_Make() == rhs.getScore_Make()) &&
        ((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()));
}

inline bool T_EventRank::operator != (const T_EventRank& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EventRank::operator < (const T_EventRank& rhs) const {
    if (hasRank() || rhs.hasRank()) {
        if (getRank() < rhs.getRank()) return true;
        if (getRank() > rhs.getRank()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasLaps() || rhs.hasLaps()) {
        if (getLaps() < rhs.getLaps()) return true;
        if (getLaps() > rhs.getLaps()) return false;
    }
    if (hasScore_Make() || rhs.hasScore_Make()) {
        if (getScore_Make() < rhs.getScore_Make()) return true;
        if (getScore_Make() > rhs.getScore_Make()) return false;
    }
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    return false;
}

inline bool T_EventRank::operator > (const T_EventRank& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EventRank::clear() {
    clearRank();
    clearName();
    clearLaps();
    clearScore_Make();
    clearNumber();
}

inline void T_EventRank::clearRank() {
    if (hasRank()) {
         clear_has_Rank();
        _Rank.clear();
     }
}

inline bool T_EventRank::hasRank () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_EventRank::getRank () const {
    return _Rank;
}

inline ::std::string& T_EventRank::getRankMutable () {
    set_has_Rank();
    return _Rank;
}

inline void T_EventRank::setRank (const ::std::string& Rank_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Rank_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Rank();
    this->_Rank = Rank_;
}

inline void T_EventRank::setRank (const char* Rank_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Rank_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Rank();
    this->_Rank.assign(Rank_);
}

inline void T_EventRank::setRank (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Rank();
    this->_Rank.assign(value, size);
}

inline void T_EventRank::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool T_EventRank::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_EventRank::getName () const {
    return _Name;
}

inline ::std::string& T_EventRank::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void T_EventRank::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void T_EventRank::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void T_EventRank::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void T_EventRank::clearLaps() {
    if (hasLaps()) {
         clear_has_Laps();
        _Laps = 0u;
     }
}

inline bool T_EventRank::hasLaps () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_EventRank::getLaps () const {
    return _Laps;
}

inline void T_EventRank::setLaps (uint32 Laps_) {
    set_has_Laps();
    this->_Laps = Laps_;
}

inline void T_EventRank::clearScore_Make() {
    if (hasScore_Make()) {
         clear_has_Score_Make();
        _Score_Make.clear();
     }
}

inline bool T_EventRank::hasScore_Make () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_EventRank::getScore_Make () const {
    return _Score_Make;
}

inline ::std::string& T_EventRank::getScore_MakeMutable () {
    set_has_Score_Make();
    return _Score_Make;
}

inline void T_EventRank::setScore_Make (const ::std::string& Score_Make_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Score_Make_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Score_Make();
    this->_Score_Make = Score_Make_;
}

inline void T_EventRank::setScore_Make (const char* Score_Make_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Score_Make_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Score_Make();
    this->_Score_Make.assign(Score_Make_);
}

inline void T_EventRank::setScore_Make (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Score_Make();
    this->_Score_Make.assign(value, size);
}

inline void T_EventRank::clearNumber() {
    if (hasNumber()) {
         clear_has_Number();
        _Number.clear();
     }
}

inline bool T_EventRank::hasNumber () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_EventRank::getNumber () const {
    return _Number;
}

inline ::std::string& T_EventRank::getNumberMutable () {
    set_has_Number();
    return _Number;
}

inline void T_EventRank::setNumber (const ::std::string& Number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Number();
    this->_Number = Number_;
}

inline void T_EventRank::setNumber (const char* Number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Number();
    this->_Number.assign(Number_);
}

inline void T_EventRank::setNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Number();
    this->_Number.assign(value, size);
}

inline void T_EventRank::set_has_Rank () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EventRank::clear_has_Rank () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EventRank::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EventRank::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EventRank::set_has_Laps () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EventRank::clear_has_Laps () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_EventRank::set_has_Score_Make () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_EventRank::clear_has_Score_Make () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_EventRank::set_has_Number () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_EventRank::clear_has_Number () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_EventRankList::T_EventRankList ()  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _RankList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EventRankList::T_EventRankList (const T_EventRankList &rhs)  :
    _SPORT_ID (0u),
    _AFFILIATE_ID (0u),
    _RankList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EventRankList::T_EventRankList (uint8 SPORT_ID_, uint32 AFFILIATE_ID_, const ::std::vector< T_EventRank >& RankList_)  :
    _SPORT_ID (SPORT_ID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _RankList (RankList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EventRankList::~T_EventRankList() {
}

inline T_EventRankList& T_EventRankList::operator = (const T_EventRankList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSPORT_ID()) {
            setSPORT_ID(rhs.getSPORT_ID());
        } else {
            clearSPORT_ID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasRankList()) {
            setRankList(rhs.getRankList());
        } else {
            clearRankList();
        }
    }
    return *this;
}

inline bool T_EventRankList::operator == (const T_EventRankList& rhs) const {
    return (((!hasSPORT_ID() && !rhs.hasSPORT_ID()) || getSPORT_ID() == rhs.getSPORT_ID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasRankList() && !rhs.hasRankList()) || getRankList() == rhs.getRankList()));
}

inline bool T_EventRankList::operator != (const T_EventRankList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EventRankList::operator < (const T_EventRankList& rhs) const {
    if (hasSPORT_ID() || rhs.hasSPORT_ID()) {
        if (getSPORT_ID() < rhs.getSPORT_ID()) return true;
        if (getSPORT_ID() > rhs.getSPORT_ID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasRankList() || rhs.hasRankList()) {
        if (getRankList() < rhs.getRankList()) return true;
        if (getRankList() > rhs.getRankList()) return false;
    }
    return false;
}

inline bool T_EventRankList::operator > (const T_EventRankList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EventRankList::clear() {
    clearSPORT_ID();
    clearAFFILIATE_ID();
    clearRankList();
}

inline void T_EventRankList::clearSPORT_ID() {
    if (hasSPORT_ID()) {
         clear_has_SPORT_ID();
        _SPORT_ID = 0u;
     }
}

inline bool T_EventRankList::hasSPORT_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_EventRankList::getSPORT_ID () const {
    return _SPORT_ID;
}

inline void T_EventRankList::setSPORT_ID (uint8 SPORT_ID_) {
    set_has_SPORT_ID();
    this->_SPORT_ID = SPORT_ID_;
}

inline void T_EventRankList::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool T_EventRankList::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_EventRankList::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void T_EventRankList::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void T_EventRankList::clearRankList() {
    if (hasRankList()) {
         clear_has_RankList();
        _RankList.clear();
     }
}

inline bool T_EventRankList::hasRankList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_EventRank >& T_EventRankList::getRankList () const {
    return _RankList;
}

inline ::std::vector< T_EventRank >& T_EventRankList::getRankListMutable () {
    set_has_RankList();
    return _RankList;
}

inline void T_EventRankList::setRankList (const ::std::vector< T_EventRank >& RankList_) {
    set_has_RankList();
    this->_RankList = RankList_;
}

inline void T_EventRankList::set_has_SPORT_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EventRankList::clear_has_SPORT_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EventRankList::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EventRankList::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EventRankList::set_has_RankList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EventRankList::clear_has_RankList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_NewsInfo::T_NewsInfo ()  :
    _NewsInDetail ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_NewsInfo::T_NewsInfo (const T_NewsInfo &rhs)  :
    _NewsInDetail ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_NewsInfo::T_NewsInfo (const ::std::string& NewsInDetail_)  :
    _NewsInDetail (NewsInDetail_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NewsInDetail_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_NewsInfo::~T_NewsInfo() {
}

inline T_NewsInfo& T_NewsInfo::operator = (const T_NewsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNewsInDetail()) {
            setNewsInDetail(rhs.getNewsInDetail());
        } else {
            clearNewsInDetail();
        }
    }
    return *this;
}

inline bool T_NewsInfo::operator == (const T_NewsInfo& rhs) const {
    return (((!hasNewsInDetail() && !rhs.hasNewsInDetail()) || getNewsInDetail() == rhs.getNewsInDetail()));
}

inline bool T_NewsInfo::operator != (const T_NewsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_NewsInfo::operator < (const T_NewsInfo& rhs) const {
    if (hasNewsInDetail() || rhs.hasNewsInDetail()) {
        if (getNewsInDetail() < rhs.getNewsInDetail()) return true;
        if (getNewsInDetail() > rhs.getNewsInDetail()) return false;
    }
    return false;
}

inline bool T_NewsInfo::operator > (const T_NewsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_NewsInfo::clear() {
    clearNewsInDetail();
}

inline void T_NewsInfo::clearNewsInDetail() {
    if (hasNewsInDetail()) {
         clear_has_NewsInDetail();
        _NewsInDetail.clear();
     }
}

inline bool T_NewsInfo::hasNewsInDetail () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_NewsInfo::getNewsInDetail () const {
    return _NewsInDetail;
}

inline ::std::string& T_NewsInfo::getNewsInDetailMutable () {
    set_has_NewsInDetail();
    return _NewsInDetail;
}

inline void T_NewsInfo::setNewsInDetail (const ::std::string& NewsInDetail_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NewsInDetail_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NewsInDetail();
    this->_NewsInDetail = NewsInDetail_;
}

inline void T_NewsInfo::setNewsInDetail (const char* NewsInDetail_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NewsInDetail_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NewsInDetail();
    this->_NewsInDetail.assign(NewsInDetail_);
}

inline void T_NewsInfo::setNewsInDetail (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_NewsInDetail();
    this->_NewsInDetail.assign(value, size);
}

inline void T_NewsInfo::set_has_NewsInDetail () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_NewsInfo::clear_has_NewsInDetail () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_sports_main_fi_types

#endif // SXM_SPORTS_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
