/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_SPORTS_MAIN_FIPROXY_H
#define SXM_SPORTS_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_sports_main_fi.h"
#include "sxm_sports_main_fi_typesConst.h"

namespace sxm_sports_main_fi {

class Sxm_sports_main_fiProxy;

class GetAffiliateDetailsCallbackIF {
public:
    virtual ~GetAffiliateDetailsCallbackIF() {}

    virtual void onGetAffiliateDetailsError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAffiliateDetailsError >& error) = 0;

    virtual void onGetAffiliateDetailsResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAffiliateDetailsResult >& result) = 0;
};

class GetAllTeamsCallbackIF {
public:
    virtual ~GetAllTeamsCallbackIF() {}

    virtual void onGetAllTeamsError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAllTeamsError >& error) = 0;

    virtual void onGetAllTeamsResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAllTeamsResult >& result) = 0;
};

class GetEventRankListCallbackIF {
public:
    virtual ~GetEventRankListCallbackIF() {}

    virtual void onGetEventRankListError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetEventRankListError >& error) = 0;

    virtual void onGetEventRankListResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetEventRankListResult >& result) = 0;
};

class GetFavoritesCallbackIF {
public:
    virtual ~GetFavoritesCallbackIF() {}

    virtual void onGetFavoritesError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoritesError >& error) = 0;

    virtual void onGetFavoritesResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoritesResult >& result) = 0;
};

class GetGameListCallbackIF {
public:
    virtual ~GetGameListCallbackIF() {}

    virtual void onGetGameListError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetGameListError >& error) = 0;

    virtual void onGetGameListResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetGameListResult >& result) = 0;
};

class GetNewsDetailsCallbackIF {
public:
    virtual ~GetNewsDetailsCallbackIF() {}

    virtual void onGetNewsDetailsError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetNewsDetailsError >& error) = 0;

    virtual void onGetNewsDetailsResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetNewsDetailsResult >& result) = 0;
};

class GetRootAffiliateListCallbackIF {
public:
    virtual ~GetRootAffiliateListCallbackIF() {}

    virtual void onGetRootAffiliateListError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetRootAffiliateListError >& error) = 0;

    virtual void onGetRootAffiliateListResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetRootAffiliateListResult >& result) = 0;
};

class GetScheduledEventsCallbackIF {
public:
    virtual ~GetScheduledEventsCallbackIF() {}

    virtual void onGetScheduledEventsError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetScheduledEventsError >& error) = 0;

    virtual void onGetScheduledEventsResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetScheduledEventsResult >& result) = 0;
};

class GetSportListCallbackIF {
public:
    virtual ~GetSportListCallbackIF() {}

    virtual void onGetSportListError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSportListError >& error) = 0;

    virtual void onGetSportListResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSportListResult >& result) = 0;
};

class GetTopTeamsCallbackIF {
public:
    virtual ~GetTopTeamsCallbackIF() {}

    virtual void onGetTopTeamsError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTopTeamsError >& error) = 0;

    virtual void onGetTopTeamsResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTopTeamsResult >& result) = 0;
};

class SetAsFavoriteCallbackIF {
public:
    virtual ~SetAsFavoriteCallbackIF() {}

    virtual void onSetAsFavoriteError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAsFavoriteError >& error) = 0;

    virtual void onSetAsFavoriteResult(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAsFavoriteResult >& result) = 0;
};

class SportsDataUpdateCallbackIF {
public:
    virtual ~SportsDataUpdateCallbackIF() {}

    virtual void onSportsDataUpdateError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SportsDataUpdateError >& error) = 0;

    virtual void onSportsDataUpdateStatus(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SportsDataUpdateStatus >& status) = 0;
};

class SportsServiceDataStatusCallbackIF {
public:
    virtual ~SportsServiceDataStatusCallbackIF() {}

    virtual void onSportsServiceDataStatusError(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SportsServiceDataStatusError >& error) = 0;

    virtual void onSportsServiceDataStatusStatus(const ::boost::shared_ptr< Sxm_sports_main_fiProxy >& proxy, const ::boost::shared_ptr< SportsServiceDataStatusStatus >& status) = 0;
};

class Sxm_sports_main_fiProxyCallback;

/**
 * Sxm_sports_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_sports_main_fi' (specified in file
 * sxm_sports_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_sports_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Sports
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Narasimhulu Kavadapu
 *
 * Date: $Date:   November 14 2014  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_sports_main_fi
 *
 * <b>Description of 'sxm_sports_main_fi':</b>
 *
 * RBEI
 */
class Sxm_sports_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_sports_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_sports_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_sports_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_sports_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_sports_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_sports_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_sports_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_sports_main_fiProxy();

    // Method 'GetSportList'

    /**
     * Call the method 'GetSportList'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetSportList'</b>:
     *
     * This method is used to get list of sports supported.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSportListStart(GetSportListCallbackIF& cb);

    // Method 'GetRootAffiliateList'

    /**
     * Call the method 'GetRootAffiliateList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetRootAffiliateList'</b>:
     *
     * This method is used to get list of Root Affiliates for a particular sport.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SportID Sport ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetRootAffiliateListStart(GetRootAffiliateListCallbackIF& cb, uint8 sportID);

    // Method 'GetAffiliateDetails'

    /**
     * Call the method 'GetAffiliateDetails'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetAffiliateDetails'</b>:
     *
     * Get complete details of particular Affiliate.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param SportID Sport ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAffiliateDetailsStart(GetAffiliateDetailsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID);

    // Method 'GetGameList'

    /**
     * Call the method 'GetGameList'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetGameList'</b>:
     *
     * Get current or recent or future game list played in particular Affiliate.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SportID Sport ID
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param TEAM_ID To get game list played for a particular Team.
     * <p>For League Based Use cases TEAM_ID will be INVALID</p>
     *
     * @param GameType 0-Today,1-Recent,2-Future
     *
     * @param Game_ID The Unique ID for the focussed or active screen element from Game list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Game ID of the game in active screen.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetGameListStart(GetGameListCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, uint32 tEAM_ID, ::sxm_sports_main_fi_types::T_GameType gameType, uint32 game_ID);

    // Method 'GetNewsDetails'

    /**
     * Call the method 'GetNewsDetails'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetNewsDetails'</b>:
     *
     * Get News Information.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param SportID Sport ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetNewsDetailsStart(GetNewsDetailsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID);

    // Method 'GetTopTeams'

    /**
     * Call the method 'GetTopTeams'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetTopTeams'</b>:
     *
     * Get the Top 25 teams for a given sub league. This is applicable only for college leagues.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param SportID Sport ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTopTeamsStart(GetTopTeamsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID);

    // Method 'GetAllTeams'

    /**
     * Call the method 'GetAllTeams'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetAllTeams'</b>:
     *
     * Get List of All Teams available for the selected League.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param SportID Sport ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAllTeamsStart(GetAllTeamsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID);

    // Method 'GetFavorites'

    /**
     * Call the method 'GetFavorites'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetFavorites'</b>:
     *
     * Get Favorite List of Team Sports.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFavoritesStart(GetFavoritesCallbackIF& cb);

    // Method 'SetAsFavorite'

    /**
     * Call the method 'SetAsFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetAsFavorite'</b>:
     *
     * To Add or Remove a Favorite To or From Favorite List.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SportID Sport ID
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param TEAM_ID Team ID - Team Sports
     *
     * @param FavoriteControl TRUE - Save As Favorite,FALSE - Remove from Favorite
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAsFavoriteStart(SetAsFavoriteCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, uint32 tEAM_ID, bool favoriteControl);

    // Method 'GetScheduledEvents'

    /**
     * Call the method 'GetScheduledEvents'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetScheduledEvents'</b>:
     *
     * Get current or recent or future event list played in particular Affiliate.
     * This method is  specific for Non Team sports ONLY.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SportID Sport ID
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param EventType 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @param Event_ID The Unique ID for the focussed or active screen element from Event list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Event ID for the event in active screen.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetScheduledEventsStart(GetScheduledEventsCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, ::sxm_sports_main_fi_types::T_GameType eventType, uint32 event_ID);

    // Method 'GetEventRankList'

    /**
     * Call the method 'GetEventRankList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetEventRankList'</b>:
     *
     * Get rank list if available for the selected non team sport event.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SportID Sport ID
     *
     * @param AFFILIATE_ID Affiliate ID
     *
     * @param EventType 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @param TableParam The table Param value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @param TableRef Rank List Table's reference value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetEventRankListStart(GetEventRankListCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, ::sxm_sports_main_fi_types::T_GameType eventType, int32 tableParam, int32 tableRef);

    // Property 'SportsServiceDataStatus'

    /**
     * Notify on the property 'SportsServiceDataStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SportsServiceDataStatus'</b>:
     *
     * Status of Sports Service Data Availability.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSportsServiceDataStatusUpReg(SportsServiceDataStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SportsServiceDataStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SportsServiceDataStatus'</b>:
     *
     * Status of Sports Service Data Availability.
     *
     * @param act The act which was previously returned by the
     * sendSportsServiceDataStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSportsServiceDataStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SportsServiceDataStatus'.
     */
    void sendSportsServiceDataStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SportsServiceDataStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSportsServiceDataStatus() returns true.
     *
     * @return the previously received value of the property 'SportsServiceDataStatus'.
     */
    const SportsServiceDataStatusStatus& getSportsServiceDataStatus() const;

    /**
     * Determines whether a status message for the property 'SportsServiceDataStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSportsServiceDataStatus() const;

    /**
     * Request the value of the property 'SportsServiceDataStatus' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SportsServiceDataStatus'</b>:
     *
     * Status of Sports Service Data Availability.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSportsServiceDataStatusGet(SportsServiceDataStatusCallbackIF& cb);

    // Property 'SportsDataUpdate'

    /**
     * Notify on the property 'SportsDataUpdate'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SportsDataUpdate'</b>:
     *
     * Report changes about Dynamic updates on News, Recent, Current, Future Games.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSportsDataUpdateUpReg(SportsDataUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SportsDataUpdate'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SportsDataUpdate'</b>:
     *
     * Report changes about Dynamic updates on News, Recent, Current, Future Games.
     *
     * @param act The act which was previously returned by the
     * sendSportsDataUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSportsDataUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SportsDataUpdate'.
     */
    void sendSportsDataUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'SportsDataUpdate' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSportsDataUpdate() returns true.
     *
     * @return the previously received value of the property 'SportsDataUpdate'.
     */
    const SportsDataUpdateStatus& getSportsDataUpdate() const;

    /**
     * Determines whether a status message for the property 'SportsDataUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSportsDataUpdate() const;

    /**
     * Request the value of the property 'SportsDataUpdate' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SportsDataUpdate'</b>:
     *
     * Report changes about Dynamic updates on News, Recent, Current, Future Games.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSportsDataUpdateGet(SportsDataUpdateCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_sports_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'SportsServiceDataStatus'

    ::asf::core::nullable< SportsServiceDataStatusStatus > _sportsServiceDataStatus;

    // Property 'SportsDataUpdate'

    ::asf::core::nullable< SportsDataUpdateStatus > _sportsDataUpdate;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_sports_main_fiProxyCallback;
};

} // namespace sxm_sports_main_fi

#endif // SXM_SPORTS_MAIN_FIPROXY_H
