/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_sports_main_fiCca.h"
#include "sxm_sports_main_fiJson.h"
#include "sxm_sports_main_fiProxy.h"
#include "sxm_sports_main_fi_typesConst.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_sports_main_fi {

/*static*/ ::asf::core::Logger Sxm_sports_main_fiProxy::_logger ("/sxm_sports_main_fi/Sxm_sports_main_fiProxy");


class Sxm_sports_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_sports_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_sports_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_sports_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetSportList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetSportListResult);
                                setActAndLogResult(message, "GetSportList", reinterpret_cast<act_t>(this), _logger);
                                ((GetSportListCallbackIF*) _callback)->onGetSportListResult (proxy, ::boost::static_pointer_cast<GetSportListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetSportListError);
                                setActAndLogError(message, "GetSportList", reinterpret_cast<act_t>(this), _logger);
                                ((GetSportListCallbackIF*) _callback)->onGetSportListError (proxy, ::boost::static_pointer_cast<GetSportListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetRootAffiliateList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetRootAffiliateListResult);
                                setActAndLogResult(message, "GetRootAffiliateList", reinterpret_cast<act_t>(this), _logger);
                                ((GetRootAffiliateListCallbackIF*) _callback)->onGetRootAffiliateListResult (proxy, ::boost::static_pointer_cast<GetRootAffiliateListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetRootAffiliateListError);
                                setActAndLogError(message, "GetRootAffiliateList", reinterpret_cast<act_t>(this), _logger);
                                ((GetRootAffiliateListCallbackIF*) _callback)->onGetRootAffiliateListError (proxy, ::boost::static_pointer_cast<GetRootAffiliateListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetAffiliateDetails: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetAffiliateDetailsResult);
                                setActAndLogResult(message, "GetAffiliateDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetAffiliateDetailsCallbackIF*) _callback)->onGetAffiliateDetailsResult (proxy, ::boost::static_pointer_cast<GetAffiliateDetailsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetAffiliateDetailsError);
                                setActAndLogError(message, "GetAffiliateDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetAffiliateDetailsCallbackIF*) _callback)->onGetAffiliateDetailsError (proxy, ::boost::static_pointer_cast<GetAffiliateDetailsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetGameList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetGameListResult);
                                setActAndLogResult(message, "GetGameList", reinterpret_cast<act_t>(this), _logger);
                                ((GetGameListCallbackIF*) _callback)->onGetGameListResult (proxy, ::boost::static_pointer_cast<GetGameListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetGameListError);
                                setActAndLogError(message, "GetGameList", reinterpret_cast<act_t>(this), _logger);
                                ((GetGameListCallbackIF*) _callback)->onGetGameListError (proxy, ::boost::static_pointer_cast<GetGameListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetNewsDetails: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetNewsDetailsResult);
                                setActAndLogResult(message, "GetNewsDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetNewsDetailsCallbackIF*) _callback)->onGetNewsDetailsResult (proxy, ::boost::static_pointer_cast<GetNewsDetailsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetNewsDetailsError);
                                setActAndLogError(message, "GetNewsDetails", reinterpret_cast<act_t>(this), _logger);
                                ((GetNewsDetailsCallbackIF*) _callback)->onGetNewsDetailsError (proxy, ::boost::static_pointer_cast<GetNewsDetailsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetTopTeams: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetTopTeamsResult);
                                setActAndLogResult(message, "GetTopTeams", reinterpret_cast<act_t>(this), _logger);
                                ((GetTopTeamsCallbackIF*) _callback)->onGetTopTeamsResult (proxy, ::boost::static_pointer_cast<GetTopTeamsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetTopTeamsError);
                                setActAndLogError(message, "GetTopTeams", reinterpret_cast<act_t>(this), _logger);
                                ((GetTopTeamsCallbackIF*) _callback)->onGetTopTeamsError (proxy, ::boost::static_pointer_cast<GetTopTeamsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetAllTeams: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetAllTeamsResult);
                                setActAndLogResult(message, "GetAllTeams", reinterpret_cast<act_t>(this), _logger);
                                ((GetAllTeamsCallbackIF*) _callback)->onGetAllTeamsResult (proxy, ::boost::static_pointer_cast<GetAllTeamsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetAllTeamsError);
                                setActAndLogError(message, "GetAllTeams", reinterpret_cast<act_t>(this), _logger);
                                ((GetAllTeamsCallbackIF*) _callback)->onGetAllTeamsError (proxy, ::boost::static_pointer_cast<GetAllTeamsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetFavorites: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetFavoritesResult);
                                setActAndLogResult(message, "GetFavorites", reinterpret_cast<act_t>(this), _logger);
                                ((GetFavoritesCallbackIF*) _callback)->onGetFavoritesResult (proxy, ::boost::static_pointer_cast<GetFavoritesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetFavoritesError);
                                setActAndLogError(message, "GetFavorites", reinterpret_cast<act_t>(this), _logger);
                                ((GetFavoritesCallbackIF*) _callback)->onGetFavoritesError (proxy, ::boost::static_pointer_cast<GetFavoritesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetAsFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SetAsFavoriteResult);
                                setActAndLogResult(message, "SetAsFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((SetAsFavoriteCallbackIF*) _callback)->onSetAsFavoriteResult (proxy, ::boost::static_pointer_cast<SetAsFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SetAsFavoriteError);
                                setActAndLogError(message, "SetAsFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((SetAsFavoriteCallbackIF*) _callback)->onSetAsFavoriteError (proxy, ::boost::static_pointer_cast<SetAsFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetScheduledEvents: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetScheduledEventsResult);
                                setActAndLogResult(message, "GetScheduledEvents", reinterpret_cast<act_t>(this), _logger);
                                ((GetScheduledEventsCallbackIF*) _callback)->onGetScheduledEventsResult (proxy, ::boost::static_pointer_cast<GetScheduledEventsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetScheduledEventsError);
                                setActAndLogError(message, "GetScheduledEvents", reinterpret_cast<act_t>(this), _logger);
                                ((GetScheduledEventsCallbackIF*) _callback)->onGetScheduledEventsError (proxy, ::boost::static_pointer_cast<GetScheduledEventsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetEventRankList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetEventRankListResult);
                                setActAndLogResult(message, "GetEventRankList", reinterpret_cast<act_t>(this), _logger);
                                ((GetEventRankListCallbackIF*) _callback)->onGetEventRankListResult (proxy, ::boost::static_pointer_cast<GetEventRankListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::GetEventRankListError);
                                setActAndLogError(message, "GetEventRankList", reinterpret_cast<act_t>(this), _logger);
                                ((GetEventRankListCallbackIF*) _callback)->onGetEventRankListError (proxy, ::boost::static_pointer_cast<GetEventRankListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SportsServiceDataStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SportsServiceDataStatusStatus);
                                setActAndLogStatus(message, "SportsServiceDataStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SportsServiceDataStatusStatus> payload = ::boost::static_pointer_cast<SportsServiceDataStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SportsServiceDataStatusStatus >& refNullableStatus = proxy->_sportsServiceDataStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SportsServiceDataStatusCallbackIF*) _callback)->onSportsServiceDataStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SportsServiceDataStatusCallbackIF*) _callback)->onSportsServiceDataStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SportsServiceDataStatusError);
                                setActAndLogError(message, "SportsServiceDataStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SportsServiceDataStatusCallbackIF*) _callback)->onSportsServiceDataStatusError(proxy, ::boost::static_pointer_cast<SportsServiceDataStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SportsDataUpdate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SportsDataUpdateStatus);
                                setActAndLogStatus(message, "SportsDataUpdate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SportsDataUpdateStatus> payload = ::boost::static_pointer_cast<SportsDataUpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SportsDataUpdateStatus >& refNullableStatus = proxy->_sportsDataUpdate;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SportsDataUpdateCallbackIF*) _callback)->onSportsDataUpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SportsDataUpdateCallbackIF*) _callback)->onSportsDataUpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_sports_main_fi::SportsDataUpdateError);
                                setActAndLogError(message, "SportsDataUpdate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SportsDataUpdateCallbackIF*) _callback)->onSportsDataUpdateError(proxy, ::boost::static_pointer_cast<SportsDataUpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_sports_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_sports_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetSportList: {
                ::boost::shared_ptr< GetSportListError > payload (new GetSportListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSportList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetSportListCallbackIF*) _callback)->onGetSportListError (proxy, payload);
                return true;
            }
            case FID_GetRootAffiliateList: {
                ::boost::shared_ptr< GetRootAffiliateListError > payload (new GetRootAffiliateListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetRootAffiliateList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetRootAffiliateListCallbackIF*) _callback)->onGetRootAffiliateListError (proxy, payload);
                return true;
            }
            case FID_GetAffiliateDetails: {
                ::boost::shared_ptr< GetAffiliateDetailsError > payload (new GetAffiliateDetailsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAffiliateDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetAffiliateDetailsCallbackIF*) _callback)->onGetAffiliateDetailsError (proxy, payload);
                return true;
            }
            case FID_GetGameList: {
                ::boost::shared_ptr< GetGameListError > payload (new GetGameListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetGameList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetGameListCallbackIF*) _callback)->onGetGameListError (proxy, payload);
                return true;
            }
            case FID_GetNewsDetails: {
                ::boost::shared_ptr< GetNewsDetailsError > payload (new GetNewsDetailsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNewsDetails", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetNewsDetailsCallbackIF*) _callback)->onGetNewsDetailsError (proxy, payload);
                return true;
            }
            case FID_GetTopTeams: {
                ::boost::shared_ptr< GetTopTeamsError > payload (new GetTopTeamsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTopTeams", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetTopTeamsCallbackIF*) _callback)->onGetTopTeamsError (proxy, payload);
                return true;
            }
            case FID_GetAllTeams: {
                ::boost::shared_ptr< GetAllTeamsError > payload (new GetAllTeamsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAllTeams", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetAllTeamsCallbackIF*) _callback)->onGetAllTeamsError (proxy, payload);
                return true;
            }
            case FID_GetFavorites: {
                ::boost::shared_ptr< GetFavoritesError > payload (new GetFavoritesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetFavorites", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetFavoritesCallbackIF*) _callback)->onGetFavoritesError (proxy, payload);
                return true;
            }
            case FID_SetAsFavorite: {
                ::boost::shared_ptr< SetAsFavoriteError > payload (new SetAsFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAsFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetAsFavoriteCallbackIF*) _callback)->onSetAsFavoriteError (proxy, payload);
                return true;
            }
            case FID_GetScheduledEvents: {
                ::boost::shared_ptr< GetScheduledEventsError > payload (new GetScheduledEventsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetScheduledEvents", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetScheduledEventsCallbackIF*) _callback)->onGetScheduledEventsError (proxy, payload);
                return true;
            }
            case FID_GetEventRankList: {
                ::boost::shared_ptr< GetEventRankListError > payload (new GetEventRankListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetEventRankList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetEventRankListCallbackIF*) _callback)->onGetEventRankListError (proxy, payload);
                return true;
            }
            case FID_SportsServiceDataStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SportsServiceDataStatusError > payload (new SportsServiceDataStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SportsServiceDataStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SportsServiceDataStatusCallbackIF*) _callback)->onSportsServiceDataStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SportsDataUpdate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SportsDataUpdateError > payload (new SportsDataUpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SportsDataUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SportsDataUpdateCallbackIF*) _callback)->onSportsDataUpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_sports_main_fiProxyCallback::_logger (Sxm_sports_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_sports_main_fiProxy > Sxm_sports_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_sports_main_fiProxy >  proxyNew(new Sxm_sports_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_sports_main_fiProxy > Sxm_sports_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_sports_main_fiProxy >  proxyNew(new Sxm_sports_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_sports_main_fiProxy > Sxm_sports_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_sports_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_sports_main_fiProxy >  proxyNew(new Sxm_sports_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_sports_main_fiProxy::Sxm_sports_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_sports_main_fiProxy::~Sxm_sports_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_sports_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_sports_main_fiProxy::sendGetSportListStart(GetSportListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetSportList);
        ::boost::shared_ptr< GetSportListStart > payload (new GetSportListStart());
        CCA_MESSAGE(ccaMessage,header,GetSportListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetSportList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetSportList);
        ::boost::shared_ptr< GetSportListError > payload (new GetSportListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetSportListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetSportList", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetRootAffiliateListStart(GetRootAffiliateListCallbackIF& cb, uint8 sportID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetRootAffiliateList);
        ::boost::shared_ptr< GetRootAffiliateListStart > payload (new GetRootAffiliateListStart());
        payload->setSportID(sportID);
        CCA_MESSAGE(ccaMessage,header,GetRootAffiliateListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetRootAffiliateList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetRootAffiliateList);
        ::boost::shared_ptr< GetRootAffiliateListError > payload (new GetRootAffiliateListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetRootAffiliateListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetRootAffiliateList", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetAffiliateDetailsStart(GetAffiliateDetailsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetAffiliateDetails);
        ::boost::shared_ptr< GetAffiliateDetailsStart > payload (new GetAffiliateDetailsStart());
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setSportID(sportID);
        CCA_MESSAGE(ccaMessage,header,GetAffiliateDetailsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetAffiliateDetails", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetAffiliateDetails);
        ::boost::shared_ptr< GetAffiliateDetailsError > payload (new GetAffiliateDetailsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetAffiliateDetailsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetAffiliateDetails", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetGameListStart(GetGameListCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, uint32 tEAM_ID, ::sxm_sports_main_fi_types::T_GameType gameType, uint32 game_ID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetGameList);
        ::boost::shared_ptr< GetGameListStart > payload (new GetGameListStart());
        payload->setSportID(sportID);
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setTEAM_ID(tEAM_ID);
        payload->setGameType(gameType);
        payload->setGame_ID(game_ID);
        CCA_MESSAGE(ccaMessage,header,GetGameListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetGameList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetGameList);
        ::boost::shared_ptr< GetGameListError > payload (new GetGameListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetGameListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetGameList", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetNewsDetailsStart(GetNewsDetailsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetNewsDetails);
        ::boost::shared_ptr< GetNewsDetailsStart > payload (new GetNewsDetailsStart());
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setSportID(sportID);
        CCA_MESSAGE(ccaMessage,header,GetNewsDetailsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetNewsDetails", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetNewsDetails);
        ::boost::shared_ptr< GetNewsDetailsError > payload (new GetNewsDetailsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetNewsDetailsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetNewsDetails", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetTopTeamsStart(GetTopTeamsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetTopTeams);
        ::boost::shared_ptr< GetTopTeamsStart > payload (new GetTopTeamsStart());
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setSportID(sportID);
        CCA_MESSAGE(ccaMessage,header,GetTopTeamsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetTopTeams", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetTopTeams);
        ::boost::shared_ptr< GetTopTeamsError > payload (new GetTopTeamsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetTopTeamsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetTopTeams", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetAllTeamsStart(GetAllTeamsCallbackIF& cb, uint32 aFFILIATE_ID, uint8 sportID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetAllTeams);
        ::boost::shared_ptr< GetAllTeamsStart > payload (new GetAllTeamsStart());
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setSportID(sportID);
        CCA_MESSAGE(ccaMessage,header,GetAllTeamsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetAllTeams", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetAllTeams);
        ::boost::shared_ptr< GetAllTeamsError > payload (new GetAllTeamsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetAllTeamsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetAllTeams", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetFavoritesStart(GetFavoritesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetFavorites);
        ::boost::shared_ptr< GetFavoritesStart > payload (new GetFavoritesStart());
        CCA_MESSAGE(ccaMessage,header,GetFavoritesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetFavorites", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetFavorites);
        ::boost::shared_ptr< GetFavoritesError > payload (new GetFavoritesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetFavoritesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetFavorites", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendSetAsFavoriteStart(SetAsFavoriteCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, uint32 tEAM_ID, bool favoriteControl) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetAsFavorite);
        ::boost::shared_ptr< SetAsFavoriteStart > payload (new SetAsFavoriteStart());
        payload->setSportID(sportID);
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setTEAM_ID(tEAM_ID);
        payload->setFavoriteControl(favoriteControl);
        CCA_MESSAGE(ccaMessage,header,SetAsFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetAsFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAsFavorite);
        ::boost::shared_ptr< SetAsFavoriteError > payload (new SetAsFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAsFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetAsFavorite", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetScheduledEventsStart(GetScheduledEventsCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, ::sxm_sports_main_fi_types::T_GameType eventType, uint32 event_ID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetScheduledEvents);
        ::boost::shared_ptr< GetScheduledEventsStart > payload (new GetScheduledEventsStart());
        payload->setSportID(sportID);
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setEventType(eventType);
        payload->setEvent_ID(event_ID);
        CCA_MESSAGE(ccaMessage,header,GetScheduledEventsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetScheduledEvents", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetScheduledEvents);
        ::boost::shared_ptr< GetScheduledEventsError > payload (new GetScheduledEventsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetScheduledEventsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetScheduledEvents", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendGetEventRankListStart(GetEventRankListCallbackIF& cb, uint8 sportID, uint32 aFFILIATE_ID, ::sxm_sports_main_fi_types::T_GameType eventType, int32 tableParam, int32 tableRef) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetEventRankList);
        ::boost::shared_ptr< GetEventRankListStart > payload (new GetEventRankListStart());
        payload->setSportID(sportID);
        payload->setAFFILIATE_ID(aFFILIATE_ID);
        payload->setEventType(eventType);
        payload->setTableParam(tableParam);
        payload->setTableRef(tableRef);
        CCA_MESSAGE(ccaMessage,header,GetEventRankListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetEventRankList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetEventRankList);
        ::boost::shared_ptr< GetEventRankListError > payload (new GetEventRankListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetEventRankListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetEventRankList", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendSportsServiceDataStatusUpReg(SportsServiceDataStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SportsServiceDataStatus);
        ::boost::shared_ptr< SportsServiceDataStatusUpReg > payload (new SportsServiceDataStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SportsServiceDataStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SportsServiceDataStatusRelUpReg > payloadRelUpRegHeap (new SportsServiceDataStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SportsServiceDataStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_sports_main_fi::SportsServiceDataStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SportsServiceDataStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SportsServiceDataStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SportsServiceDataStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSportsServiceDataStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SportsServiceDataStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SportsServiceDataStatusStatus > payloadLoopback (new SportsServiceDataStatusStatus(getSportsServiceDataStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SportsServiceDataStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SportsServiceDataStatus);
        ::boost::shared_ptr< SportsServiceDataStatusError > payload (new SportsServiceDataStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SportsServiceDataStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SportsServiceDataStatus", &cb);
    }
}

bool Sxm_sports_main_fiProxy::sendSportsServiceDataStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SportsServiceDataStatus,"SportsServiceDataStatus");
}

void Sxm_sports_main_fiProxy::sendSportsServiceDataStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SportsServiceDataStatus);
}

const SportsServiceDataStatusStatus& Sxm_sports_main_fiProxy::getSportsServiceDataStatus() const {
    return _sportsServiceDataStatus.get();
}

bool Sxm_sports_main_fiProxy::hasSportsServiceDataStatus() const {
    return _sportsServiceDataStatus.hasValue();
}

act_t Sxm_sports_main_fiProxy::sendSportsServiceDataStatusGet(SportsServiceDataStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SportsServiceDataStatus);
        ::boost::shared_ptr< SportsServiceDataStatusGet > payload (new SportsServiceDataStatusGet());
        CCA_MESSAGE(ccaMessage,header,SportsServiceDataStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SportsServiceDataStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SportsServiceDataStatus);
        ::boost::shared_ptr< SportsServiceDataStatusError > payload (new SportsServiceDataStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SportsServiceDataStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SportsServiceDataStatus", &cb);
    }
}

act_t Sxm_sports_main_fiProxy::sendSportsDataUpdateUpReg(SportsDataUpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SportsDataUpdate);
        ::boost::shared_ptr< SportsDataUpdateUpReg > payload (new SportsDataUpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,SportsDataUpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SportsDataUpdateRelUpReg > payloadRelUpRegHeap (new SportsDataUpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SportsDataUpdate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_sports_main_fi::SportsDataUpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SportsDataUpdate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SportsDataUpdate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SportsDataUpdate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSportsDataUpdate()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SportsDataUpdate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SportsDataUpdateStatus > payloadLoopback (new SportsDataUpdateStatus(getSportsDataUpdate()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SportsDataUpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SportsDataUpdate);
        ::boost::shared_ptr< SportsDataUpdateError > payload (new SportsDataUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SportsDataUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SportsDataUpdate", &cb);
    }
}

bool Sxm_sports_main_fiProxy::sendSportsDataUpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SportsDataUpdate,"SportsDataUpdate");
}

void Sxm_sports_main_fiProxy::sendSportsDataUpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SportsDataUpdate);
}

const SportsDataUpdateStatus& Sxm_sports_main_fiProxy::getSportsDataUpdate() const {
    return _sportsDataUpdate.get();
}

bool Sxm_sports_main_fiProxy::hasSportsDataUpdate() const {
    return _sportsDataUpdate.hasValue();
}

act_t Sxm_sports_main_fiProxy::sendSportsDataUpdateGet(SportsDataUpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SportsDataUpdate);
        ::boost::shared_ptr< SportsDataUpdateGet > payload (new SportsDataUpdateGet());
        CCA_MESSAGE(ccaMessage,header,SportsDataUpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SportsDataUpdate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SportsDataUpdate);
        ::boost::shared_ptr< SportsDataUpdateError > payload (new SportsDataUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SportsDataUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SportsDataUpdate", &cb);
    }
}


void Sxm_sports_main_fiProxy::clearAllProperties ()
{
    _sportsServiceDataStatus = ::asf::core::nullable<SportsServiceDataStatusStatus>();
    _sportsDataUpdate = ::asf::core::nullable<SportsDataUpdateStatus>();
}

void Sxm_sports_main_fiProxy::sendRelUpRegAll()
{
    sendSportsServiceDataStatusRelUpRegAll();
    sendSportsDataUpdateRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_sports_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_sports_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_sports_main_fi
