#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_SPORTS_MAIN_FI_H
#define SXM_SPORTS_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_sports_main_fi_types.h"
#include "sxm_sports_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_sports_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Sports
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Narasimhulu Kavadapu
 *
 * Date: $Date:   November 14 2014  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_sports_main_fi
 *
 * <b>Description of 'sxm_sports_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_sports_main_fi {

static const int SERVICE_ID = 154;

static const int FID_GetSportList = 1;

static const int FID_GetRootAffiliateList = 2;

static const int FID_GetAffiliateDetails = 3;

static const int FID_GetGameList = 4;

static const int FID_GetNewsDetails = 6;

static const int FID_GetTopTeams = 7;

static const int FID_GetAllTeams = 8;

static const int FID_GetFavorites = 9;

static const int FID_SetAsFavorite = 10;

static const int FID_GetScheduledEvents = 11;

static const int FID_GetEventRankList = 13;

static const int FID_SportsServiceDataStatus = 96;

static const int FID_SportsDataUpdate = 97;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 6;

// forward declarations
class GetSportListResult;

class GetSportListErrorStructure;

class GetSportListError;

class GetRootAffiliateListStart;

class GetRootAffiliateListResult;

class GetRootAffiliateListErrorStructure;

class GetRootAffiliateListError;

class GetAffiliateDetailsStart;

class GetAffiliateDetailsResult;

class GetAffiliateDetailsErrorStructure;

class GetAffiliateDetailsError;

class GetGameListStart;

class GetGameListResult;

class GetGameListErrorStructure;

class GetGameListError;

class GetNewsDetailsStart;

class GetNewsDetailsResult;

class GetNewsDetailsErrorStructure;

class GetNewsDetailsError;

class GetTopTeamsStart;

class GetTopTeamsResult;

class GetTopTeamsErrorStructure;

class GetTopTeamsError;

class GetAllTeamsStart;

class GetAllTeamsResult;

class GetAllTeamsErrorStructure;

class GetAllTeamsError;

class GetFavoritesResult;

class GetFavoritesErrorStructure;

class GetFavoritesError;

class SetAsFavoriteStart;

class SetAsFavoriteResult;

class SetAsFavoriteErrorStructure;

class SetAsFavoriteError;

class GetScheduledEventsStart;

class GetScheduledEventsResult;

class GetScheduledEventsErrorStructure;

class GetScheduledEventsError;

class GetEventRankListStart;

class GetEventRankListResult;

class GetEventRankListErrorStructure;

class GetEventRankListError;

class SportsServiceDataStatusStatus;

class SportsServiceDataStatusErrorStructure;

class SportsServiceDataStatusError;

class SportsDataUpdateStatus;

class SportsDataUpdateErrorStructure;

class SportsDataUpdateError;

// type definitions
/**
 * The start message of the method "GetSportList"
 * This method is used to get list of sports supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSportListStart;

/**
 * The abort error message of the method "GetSportList"
 * This method is used to get list of sports supported.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSportListAbortError;

/**
 * The abort error message of the method "GetRootAffiliateList"
 * This method is used to get list of Root Affiliates for a particular sport.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetRootAffiliateListAbortError;

/**
 * The abort error message of the method "GetAffiliateDetails"
 * Get complete details of particular Affiliate.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAffiliateDetailsAbortError;

/**
 * The abort error message of the method "GetGameList"
 * Get current or recent or future game list played in particular Affiliate.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetGameListAbortError;

/**
 * The abort error message of the method "GetNewsDetails"
 * Get News Information.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetNewsDetailsAbortError;

/**
 * The abort error message of the method "GetTopTeams"
 * Get the Top 25 teams for a given sub league. This is applicable only for college leagues.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTopTeamsAbortError;

/**
 * The abort error message of the method "GetAllTeams"
 * Get List of All Teams available for the selected League.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAllTeamsAbortError;

/**
 * The start message of the method "GetFavorites"
 * Get Favorite List of Team Sports.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetFavoritesStart;

/**
 * The abort error message of the method "GetFavorites"
 * Get Favorite List of Team Sports.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoritesAbortError;

/**
 * The abort error message of the method "SetAsFavorite"
 * To Add or Remove a Favorite To or From Favorite List.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAsFavoriteAbortError;

/**
 * The abort error message of the method "GetScheduledEvents"
 * Get current or recent or future event list played in particular Affiliate.
 * This method is  specific for Non Team sports ONLY.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetScheduledEventsAbortError;

/**
 * The abort error message of the method "GetEventRankList"
 * Get rank list if available for the selected non team sport event.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetEventRankListAbortError;

/**
 * The get message of the property "SportsServiceDataStatus"
 * Status of Sports Service Data Availability.
 * Request status of Sports Service Data availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsServiceDataStatusGet;

/**
 * The upreg message of the property "SportsServiceDataStatus"
 * Status of Sports Service Data Availability.
 * Register for Sports data availability updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsServiceDataStatusUpReg;

/**
 * The relUpReg message of the property "SportsServiceDataStatus"
 * Status of Sports Service Data Availability.
 * Unregister from Sports data availability updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsServiceDataStatusRelUpReg;

/**
 * The get message of the property "SportsDataUpdate"
 * Report changes about Dynamic updates on News, Recent, Current, Future Games.
 * Request status SXM Sports Dynamic Updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsDataUpdateGet;

/**
 * The upreg message of the property "SportsDataUpdate"
 * Report changes about Dynamic updates on News, Recent, Current, Future Games.
 * Register for Sports data updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsDataUpdateUpReg;

/**
 * The relUpReg message of the property "SportsDataUpdate"
 * Report changes about Dynamic updates on News, Recent, Current, Future Games.
 * Unregister from Sports data updates.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SportsDataUpdateRelUpReg;


/**
 * The result message of the method "GetSportList"
 * This method is used to get list of sports supported.
 */
class GetSportListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSportListResult ();

    /**
     * Copy constructor
     */
    inline  GetSportListResult (const GetSportListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetSportListResult (const ::sxm_sports_main_fi_types::T_SportList& SportList_);

    /**
     * Destructor
     */
    inline virtual  ~GetSportListResult();

    /**
     * Assignment operator
     */
    inline GetSportListResult& operator = (const GetSportListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSportListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSportListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSportListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSportListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportList"

    static const int kSportList = 0;

    /**
     * Clears the field "SportList".
     *
     * The field will be set to its default value. The hasSportList()
     * method will return false.
     */
    inline void clearSportList();

    /**
     * Checks whether the field "SportList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportList()). Otherwise it will return false.
     */
    inline bool hasSportList () const;

    /**
     * Returns the value of the member "SportList".
     *
     * Sports List.
     *
     * @return The value of the field "SportList"
     */
    inline const ::sxm_sports_main_fi_types::T_SportList& getSportList () const;

    /**
     * Retrieves the value of the field "SportList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SportList".
     */
    inline ::sxm_sports_main_fi_types::T_SportList& getSportListMutable ();

    /**
     * Sets the value of the member "SportList".
     *
     * Sports List.
     *
     * @param SportList The value which will be set
     */
    inline void setSportList (const ::sxm_sports_main_fi_types::T_SportList& SportList_);

    static const GetSportListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_sports_main_fi_types::T_SportInfo >& getT_SportInfoList_DefaultInstance ();

    inline void set_has_SportList ();

    inline void clear_has_SportList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_SportList _SportList;

};

/**
 * The error message of 'GetSportList'
 */
class GetSportListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetSportListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetSportListErrorStructure (const GetSportListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetSportListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetSportListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetSportListErrorStructure& operator = (const GetSportListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSportListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSportListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSportListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSportListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Sport list is not ready.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Sport list is not ready.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetSportListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetSportList'
 */
class GetSportListError  : public ::asf::core::Payload {
public:

    enum GetSportListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetSportListError ();

   /**
     * Copy constructor
     */
    inline  GetSportListError (const GetSportListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetSportListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetSportListError& operator = (const GetSportListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSportListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSportListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSportListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSportListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetSportListError::GetSportListErrorField getField () const;

    inline void setField(GetSportListError::GetSportListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetSportListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetSportListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetSportListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetSportListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetSportListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetSportListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetSportListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetSportListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetSportListError &getDefaultInstance();

private:

    inline void cloneData (const GetSportListError& rhs);

    inline void deleteData ();

    GetSportListErrorField __field;

    union {
        GetSportListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetRootAffiliateList"
 * This method is used to get list of Root Affiliates for a particular sport.
 */
class GetRootAffiliateListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRootAffiliateListStart ();

    /**
     * Copy constructor
     */
    inline  GetRootAffiliateListStart (const GetRootAffiliateListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetRootAffiliateListStart (uint8 SportID_);

    /**
     * Destructor
     */
    inline virtual  ~GetRootAffiliateListStart();

    /**
     * Assignment operator
     */
    inline GetRootAffiliateListStart& operator = (const GetRootAffiliateListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRootAffiliateListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRootAffiliateListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRootAffiliateListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRootAffiliateListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    static const GetRootAffiliateListStart &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SportID;

};

/**
 * The result message of the method "GetRootAffiliateList"
 * This method is used to get list of Root Affiliates for a particular sport.
 */
class GetRootAffiliateListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetRootAffiliateListResult ();

    /**
     * Copy constructor
     */
    inline  GetRootAffiliateListResult (const GetRootAffiliateListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetRootAffiliateListResult (const ::sxm_sports_main_fi_types::T_RootAffiliateList& RootAffiliateList_);

    /**
     * Destructor
     */
    inline virtual  ~GetRootAffiliateListResult();

    /**
     * Assignment operator
     */
    inline GetRootAffiliateListResult& operator = (const GetRootAffiliateListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRootAffiliateListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRootAffiliateListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRootAffiliateListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRootAffiliateListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RootAffiliateList"

    static const int kRootAffiliateList = 0;

    /**
     * Clears the field "RootAffiliateList".
     *
     * The field will be set to its default value. The hasRootAffiliateList()
     * method will return false.
     */
    inline void clearRootAffiliateList();

    /**
     * Checks whether the field "RootAffiliateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRootAffiliateList()). Otherwise it will return false.
     */
    inline bool hasRootAffiliateList () const;

    /**
     * Returns the value of the member "RootAffiliateList".
     *
     * Root Affiliate List.
     *
     * @return The value of the field "RootAffiliateList"
     */
    inline const ::sxm_sports_main_fi_types::T_RootAffiliateList& getRootAffiliateList () const;

    /**
     * Retrieves the value of the field "RootAffiliateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RootAffiliateList".
     */
    inline ::sxm_sports_main_fi_types::T_RootAffiliateList& getRootAffiliateListMutable ();

    /**
     * Sets the value of the member "RootAffiliateList".
     *
     * Root Affiliate List.
     *
     * @param RootAffiliateList The value which will be set
     */
    inline void setRootAffiliateList (const ::sxm_sports_main_fi_types::T_RootAffiliateList& RootAffiliateList_);

    static const GetRootAffiliateListResult &getDefaultInstance();

private:

    inline void set_has_RootAffiliateList ();

    inline void clear_has_RootAffiliateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_RootAffiliateList _RootAffiliateList;

};

/**
 * The error message of 'GetRootAffiliateList'
 */
class GetRootAffiliateListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetRootAffiliateListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetRootAffiliateListErrorStructure (const GetRootAffiliateListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetRootAffiliateListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetRootAffiliateListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetRootAffiliateListErrorStructure& operator = (const GetRootAffiliateListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRootAffiliateListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRootAffiliateListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRootAffiliateListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRootAffiliateListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Root Affiliate list is not ready.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Root Affiliate list is not ready.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetRootAffiliateListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetRootAffiliateList'
 */
class GetRootAffiliateListError  : public ::asf::core::Payload {
public:

    enum GetRootAffiliateListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetRootAffiliateListError ();

   /**
     * Copy constructor
     */
    inline  GetRootAffiliateListError (const GetRootAffiliateListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetRootAffiliateListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetRootAffiliateListError& operator = (const GetRootAffiliateListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetRootAffiliateListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetRootAffiliateListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetRootAffiliateListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetRootAffiliateListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetRootAffiliateListError::GetRootAffiliateListErrorField getField () const;

    inline void setField(GetRootAffiliateListError::GetRootAffiliateListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetRootAffiliateListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetRootAffiliateListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetRootAffiliateListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetRootAffiliateListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetRootAffiliateListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetRootAffiliateListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetRootAffiliateListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetRootAffiliateListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetRootAffiliateListError &getDefaultInstance();

private:

    inline void cloneData (const GetRootAffiliateListError& rhs);

    inline void deleteData ();

    GetRootAffiliateListErrorField __field;

    union {
        GetRootAffiliateListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetAffiliateDetails"
 * Get complete details of particular Affiliate.
 */
class GetAffiliateDetailsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAffiliateDetailsStart ();

    /**
     * Copy constructor
     */
    inline  GetAffiliateDetailsStart (const GetAffiliateDetailsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAffiliateDetailsStart (uint32 AFFILIATE_ID_, uint8 SportID_);

    /**
     * Destructor
     */
    inline virtual  ~GetAffiliateDetailsStart();

    /**
     * Assignment operator
     */
    inline GetAffiliateDetailsStart& operator = (const GetAffiliateDetailsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAffiliateDetailsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAffiliateDetailsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAffiliateDetailsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAffiliateDetailsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 0;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "SportID"

    static const int kSportID = 1;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    static const GetAffiliateDetailsStart &getDefaultInstance();

private:

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _AFFILIATE_ID;

    uint8 _SportID;

};

/**
 * The result message of the method "GetAffiliateDetails"
 * Get complete details of particular Affiliate.
 */
class GetAffiliateDetailsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAffiliateDetailsResult ();

    /**
     * Copy constructor
     */
    inline  GetAffiliateDetailsResult (const GetAffiliateDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAffiliateDetailsResult (const ::sxm_sports_main_fi_types::T_AffiliateDetails& AffiliateDetails_);

    /**
     * Destructor
     */
    inline virtual  ~GetAffiliateDetailsResult();

    /**
     * Assignment operator
     */
    inline GetAffiliateDetailsResult& operator = (const GetAffiliateDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAffiliateDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAffiliateDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAffiliateDetailsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAffiliateDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AffiliateDetails"

    static const int kAffiliateDetails = 0;

    /**
     * Clears the field "AffiliateDetails".
     *
     * The field will be set to its default value. The hasAffiliateDetails()
     * method will return false.
     */
    inline void clearAffiliateDetails();

    /**
     * Checks whether the field "AffiliateDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAffiliateDetails()). Otherwise it will return false.
     */
    inline bool hasAffiliateDetails () const;

    /**
     * Returns the value of the member "AffiliateDetails".
     *
     * Affiliate details.
     *
     * @return The value of the field "AffiliateDetails"
     */
    inline const ::sxm_sports_main_fi_types::T_AffiliateDetails& getAffiliateDetails () const;

    /**
     * Retrieves the value of the field "AffiliateDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AffiliateDetails".
     */
    inline ::sxm_sports_main_fi_types::T_AffiliateDetails& getAffiliateDetailsMutable ();

    /**
     * Sets the value of the member "AffiliateDetails".
     *
     * Affiliate details.
     *
     * @param AffiliateDetails The value which will be set
     */
    inline void setAffiliateDetails (const ::sxm_sports_main_fi_types::T_AffiliateDetails& AffiliateDetails_);

    static const GetAffiliateDetailsResult &getDefaultInstance();

private:

    inline void set_has_AffiliateDetails ();

    inline void clear_has_AffiliateDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_AffiliateDetails _AffiliateDetails;

};

/**
 * The error message of 'GetAffiliateDetails'
 */
class GetAffiliateDetailsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetAffiliateDetailsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetAffiliateDetailsErrorStructure (const GetAffiliateDetailsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetAffiliateDetailsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetAffiliateDetailsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetAffiliateDetailsErrorStructure& operator = (const GetAffiliateDetailsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAffiliateDetailsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAffiliateDetailsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAffiliateDetailsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAffiliateDetailsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Affiliate unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Affiliate unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetAffiliateDetailsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetAffiliateDetails'
 */
class GetAffiliateDetailsError  : public ::asf::core::Payload {
public:

    enum GetAffiliateDetailsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetAffiliateDetailsError ();

   /**
     * Copy constructor
     */
    inline  GetAffiliateDetailsError (const GetAffiliateDetailsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetAffiliateDetailsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetAffiliateDetailsError& operator = (const GetAffiliateDetailsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAffiliateDetailsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAffiliateDetailsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAffiliateDetailsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAffiliateDetailsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetAffiliateDetailsError::GetAffiliateDetailsErrorField getField () const;

    inline void setField(GetAffiliateDetailsError::GetAffiliateDetailsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetAffiliateDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetAffiliateDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetAffiliateDetailsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetAffiliateDetailsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetAffiliateDetailsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetAffiliateDetailsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetAffiliateDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetAffiliateDetailsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetAffiliateDetailsError &getDefaultInstance();

private:

    inline void cloneData (const GetAffiliateDetailsError& rhs);

    inline void deleteData ();

    GetAffiliateDetailsErrorField __field;

    union {
        GetAffiliateDetailsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetGameList"
 * Get current or recent or future game list played in particular Affiliate.
 */
class GetGameListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetGameListStart ();

    /**
     * Copy constructor
     */
    inline  GetGameListStart (const GetGameListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetGameListStart (uint8 SportID_, uint32 AFFILIATE_ID_, uint32 TEAM_ID_, ::sxm_sports_main_fi_types::T_GameType GameType_, uint32 Game_ID_);

    /**
     * Destructor
     */
    inline virtual  ~GetGameListStart();

    /**
     * Assignment operator
     */
    inline GetGameListStart& operator = (const GetGameListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetGameListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetGameListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetGameListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetGameListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "TEAM_ID"

    static const int kTEAM_ID = 2;

    /**
     * Clears the field "TEAM_ID".
     *
     * The field will be set to its default value. The hasTEAM_ID()
     * method will return false.
     */
    inline void clearTEAM_ID();

    /**
     * Checks whether the field "TEAM_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTEAM_ID()). Otherwise it will return false.
     */
    inline bool hasTEAM_ID () const;

    /**
     * Returns the value of the member "TEAM_ID".
     *
     * To get game list played for a particular Team.
     * <p>For League Based Use cases TEAM_ID will be INVALID</p>
     *
     * @return The value of the field "TEAM_ID"
     */
    inline uint32 getTEAM_ID () const;

    /**
     * Sets the value of the member "TEAM_ID".
     *
     * To get game list played for a particular Team.
     * <p>For League Based Use cases TEAM_ID will be INVALID</p>
     *
     * @param TEAM_ID The value which will be set
     */
    inline void setTEAM_ID (uint32 TEAM_ID_);

    // API of field "GameType"

    static const int kGameType = 3;

    /**
     * Clears the field "GameType".
     *
     * The field will be set to its default value. The hasGameType()
     * method will return false.
     */
    inline void clearGameType();

    /**
     * Checks whether the field "GameType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameType()). Otherwise it will return false.
     */
    inline bool hasGameType () const;

    /**
     * Returns the value of the member "GameType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @return The value of the field "GameType"
     */
    inline ::sxm_sports_main_fi_types::T_GameType getGameType () const;

    /**
     * Sets the value of the member "GameType".
     *
     * 0-Today,1-Recent,2-Future
     *
     * @param GameType The value which will be set
     */
    inline void setGameType (::sxm_sports_main_fi_types::T_GameType GameType_);

    // API of field "Game_ID"

    static const int kGame_ID = 4;

    /**
     * Clears the field "Game_ID".
     *
     * The field will be set to its default value. The hasGame_ID()
     * method will return false.
     */
    inline void clearGame_ID();

    /**
     * Checks whether the field "Game_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGame_ID()). Otherwise it will return false.
     */
    inline bool hasGame_ID () const;

    /**
     * Returns the value of the member "Game_ID".
     *
     * The Unique ID for the focussed or active screen element from Game list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Game ID of the game in active screen.</p>
     *
     * @return The value of the field "Game_ID"
     */
    inline uint32 getGame_ID () const;

    /**
     * Sets the value of the member "Game_ID".
     *
     * The Unique ID for the focussed or active screen element from Game list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Game ID of the game in active screen.</p>
     *
     * @param Game_ID The value which will be set
     */
    inline void setGame_ID (uint32 Game_ID_);

    static const GetGameListStart &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_TEAM_ID ();

    inline void clear_has_TEAM_ID ();

    inline void set_has_GameType ();

    inline void clear_has_GameType ();

    inline void set_has_Game_ID ();

    inline void clear_has_Game_ID ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _SportID;

    uint32 _AFFILIATE_ID;

    uint32 _TEAM_ID;

    ::sxm_sports_main_fi_types::T_GameType _GameType;

    uint32 _Game_ID;

};

/**
 * The result message of the method "GetGameList"
 * Get current or recent or future game list played in particular Affiliate.
 */
class GetGameListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetGameListResult ();

    /**
     * Copy constructor
     */
    inline  GetGameListResult (const GetGameListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetGameListResult (const ::sxm_sports_main_fi_types::T_GameList& GameList_);

    /**
     * Destructor
     */
    inline virtual  ~GetGameListResult();

    /**
     * Assignment operator
     */
    inline GetGameListResult& operator = (const GetGameListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetGameListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetGameListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetGameListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetGameListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GameList"

    static const int kGameList = 0;

    /**
     * Clears the field "GameList".
     *
     * The field will be set to its default value. The hasGameList()
     * method will return false.
     */
    inline void clearGameList();

    /**
     * Checks whether the field "GameList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGameList()). Otherwise it will return false.
     */
    inline bool hasGameList () const;

    /**
     * Returns the value of the member "GameList".
     *
     * List of Games Played in particular Affiliate.
     *
     * @return The value of the field "GameList"
     */
    inline const ::sxm_sports_main_fi_types::T_GameList& getGameList () const;

    /**
     * Retrieves the value of the field "GameList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GameList".
     */
    inline ::sxm_sports_main_fi_types::T_GameList& getGameListMutable ();

    /**
     * Sets the value of the member "GameList".
     *
     * List of Games Played in particular Affiliate.
     *
     * @param GameList The value which will be set
     */
    inline void setGameList (const ::sxm_sports_main_fi_types::T_GameList& GameList_);

    static const GetGameListResult &getDefaultInstance();

private:

    inline void set_has_GameList ();

    inline void clear_has_GameList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_GameList _GameList;

};

/**
 * The error message of 'GetGameList'
 */
class GetGameListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetGameListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetGameListErrorStructure (const GetGameListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetGameListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetGameListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetGameListErrorStructure& operator = (const GetGameListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetGameListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetGameListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetGameListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetGameListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Game List unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Game List unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetGameListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetGameList'
 */
class GetGameListError  : public ::asf::core::Payload {
public:

    enum GetGameListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetGameListError ();

   /**
     * Copy constructor
     */
    inline  GetGameListError (const GetGameListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetGameListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetGameListError& operator = (const GetGameListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetGameListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetGameListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetGameListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetGameListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetGameListError::GetGameListErrorField getField () const;

    inline void setField(GetGameListError::GetGameListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetGameListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetGameListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetGameListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetGameListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetGameListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetGameListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetGameListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetGameListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetGameListError &getDefaultInstance();

private:

    inline void cloneData (const GetGameListError& rhs);

    inline void deleteData ();

    GetGameListErrorField __field;

    union {
        GetGameListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetNewsDetails"
 * Get News Information.
 */
class GetNewsDetailsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNewsDetailsStart ();

    /**
     * Copy constructor
     */
    inline  GetNewsDetailsStart (const GetNewsDetailsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetNewsDetailsStart (uint32 AFFILIATE_ID_, uint8 SportID_);

    /**
     * Destructor
     */
    inline virtual  ~GetNewsDetailsStart();

    /**
     * Assignment operator
     */
    inline GetNewsDetailsStart& operator = (const GetNewsDetailsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNewsDetailsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNewsDetailsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNewsDetailsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNewsDetailsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 0;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "SportID"

    static const int kSportID = 1;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    static const GetNewsDetailsStart &getDefaultInstance();

private:

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _AFFILIATE_ID;

    uint8 _SportID;

};

/**
 * The result message of the method "GetNewsDetails"
 * Get News Information.
 */
class GetNewsDetailsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNewsDetailsResult ();

    /**
     * Copy constructor
     */
    inline  GetNewsDetailsResult (const GetNewsDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetNewsDetailsResult (const ::sxm_sports_main_fi_types::T_NewsList& News_);

    /**
     * Destructor
     */
    inline virtual  ~GetNewsDetailsResult();

    /**
     * Assignment operator
     */
    inline GetNewsDetailsResult& operator = (const GetNewsDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNewsDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNewsDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNewsDetailsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNewsDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "News"

    static const int kNews = 0;

    /**
     * Clears the field "News".
     *
     * The field will be set to its default value. The hasNews()
     * method will return false.
     */
    inline void clearNews();

    /**
     * Checks whether the field "News" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNews()). Otherwise it will return false.
     */
    inline bool hasNews () const;

    /**
     * Returns the value of the member "News".
     *
     * News Details
     *
     * @return The value of the field "News"
     */
    inline const ::sxm_sports_main_fi_types::T_NewsList& getNews () const;

    /**
     * Retrieves the value of the field "News" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "News".
     */
    inline ::sxm_sports_main_fi_types::T_NewsList& getNewsMutable ();

    /**
     * Sets the value of the member "News".
     *
     * News Details
     *
     * @param News The value which will be set
     */
    inline void setNews (const ::sxm_sports_main_fi_types::T_NewsList& News_);

    static const GetNewsDetailsResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_sports_main_fi_types::T_NewsInfo >& getT_NewsInfoList_DefaultInstance ();

    inline void set_has_News ();

    inline void clear_has_News ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_NewsList _News;

};

/**
 * The error message of 'GetNewsDetails'
 */
class GetNewsDetailsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetNewsDetailsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetNewsDetailsErrorStructure (const GetNewsDetailsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetNewsDetailsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetNewsDetailsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetNewsDetailsErrorStructure& operator = (const GetNewsDetailsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNewsDetailsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNewsDetailsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNewsDetailsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNewsDetailsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetNewsDetailsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetNewsDetails'
 */
class GetNewsDetailsError  : public ::asf::core::Payload {
public:

    enum GetNewsDetailsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetNewsDetailsError ();

   /**
     * Copy constructor
     */
    inline  GetNewsDetailsError (const GetNewsDetailsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetNewsDetailsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetNewsDetailsError& operator = (const GetNewsDetailsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNewsDetailsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNewsDetailsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNewsDetailsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNewsDetailsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetNewsDetailsError::GetNewsDetailsErrorField getField () const;

    inline void setField(GetNewsDetailsError::GetNewsDetailsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetNewsDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetNewsDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetNewsDetailsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetNewsDetailsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetNewsDetailsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetNewsDetailsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetNewsDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetNewsDetailsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetNewsDetailsError &getDefaultInstance();

private:

    inline void cloneData (const GetNewsDetailsError& rhs);

    inline void deleteData ();

    GetNewsDetailsErrorField __field;

    union {
        GetNewsDetailsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetTopTeams"
 * Get the Top 25 teams for a given sub league. This is applicable only for college leagues.
 */
class GetTopTeamsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTopTeamsStart ();

    /**
     * Copy constructor
     */
    inline  GetTopTeamsStart (const GetTopTeamsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetTopTeamsStart (uint32 AFFILIATE_ID_, uint8 SportID_);

    /**
     * Destructor
     */
    inline virtual  ~GetTopTeamsStart();

    /**
     * Assignment operator
     */
    inline GetTopTeamsStart& operator = (const GetTopTeamsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTopTeamsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTopTeamsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTopTeamsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTopTeamsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 0;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "SportID"

    static const int kSportID = 1;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    static const GetTopTeamsStart &getDefaultInstance();

private:

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _AFFILIATE_ID;

    uint8 _SportID;

};

/**
 * The result message of the method "GetTopTeams"
 * Get the Top 25 teams for a given sub league. This is applicable only for college leagues.
 */
class GetTopTeamsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetTopTeamsResult ();

    /**
     * Copy constructor
     */
    inline  GetTopTeamsResult (const GetTopTeamsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetTopTeamsResult (const ::sxm_sports_main_fi_types::T_TeamList& TeamList_);

    /**
     * Destructor
     */
    inline virtual  ~GetTopTeamsResult();

    /**
     * Assignment operator
     */
    inline GetTopTeamsResult& operator = (const GetTopTeamsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTopTeamsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTopTeamsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTopTeamsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTopTeamsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TeamList"

    static const int kTeamList = 0;

    /**
     * Clears the field "TeamList".
     *
     * The field will be set to its default value. The hasTeamList()
     * method will return false.
     */
    inline void clearTeamList();

    /**
     * Checks whether the field "TeamList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamList()). Otherwise it will return false.
     */
    inline bool hasTeamList () const;

    /**
     * Returns the value of the member "TeamList".
     *
     * List of All Teams or participants ascending by their Performance.
     *
     * @return The value of the field "TeamList"
     */
    inline const ::sxm_sports_main_fi_types::T_TeamList& getTeamList () const;

    /**
     * Retrieves the value of the field "TeamList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamList".
     */
    inline ::sxm_sports_main_fi_types::T_TeamList& getTeamListMutable ();

    /**
     * Sets the value of the member "TeamList".
     *
     * List of All Teams or participants ascending by their Performance.
     *
     * @param TeamList The value which will be set
     */
    inline void setTeamList (const ::sxm_sports_main_fi_types::T_TeamList& TeamList_);

    static const GetTopTeamsResult &getDefaultInstance();

private:

    inline void set_has_TeamList ();

    inline void clear_has_TeamList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_TeamList _TeamList;

};

/**
 * The error message of 'GetTopTeams'
 */
class GetTopTeamsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTopTeamsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTopTeamsErrorStructure (const GetTopTeamsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTopTeamsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetTopTeamsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTopTeamsErrorStructure& operator = (const GetTopTeamsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTopTeamsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTopTeamsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTopTeamsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTopTeamsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetTopTeamsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetTopTeams'
 */
class GetTopTeamsError  : public ::asf::core::Payload {
public:

    enum GetTopTeamsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTopTeamsError ();

   /**
     * Copy constructor
     */
    inline  GetTopTeamsError (const GetTopTeamsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTopTeamsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTopTeamsError& operator = (const GetTopTeamsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTopTeamsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTopTeamsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTopTeamsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTopTeamsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTopTeamsError::GetTopTeamsErrorField getField () const;

    inline void setField(GetTopTeamsError::GetTopTeamsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTopTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTopTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTopTeamsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTopTeamsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTopTeamsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTopTeamsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTopTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTopTeamsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTopTeamsError &getDefaultInstance();

private:

    inline void cloneData (const GetTopTeamsError& rhs);

    inline void deleteData ();

    GetTopTeamsErrorField __field;

    union {
        GetTopTeamsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetAllTeams"
 * Get List of All Teams available for the selected League.
 */
class GetAllTeamsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAllTeamsStart ();

    /**
     * Copy constructor
     */
    inline  GetAllTeamsStart (const GetAllTeamsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAllTeamsStart (uint32 AFFILIATE_ID_, uint8 SportID_);

    /**
     * Destructor
     */
    inline virtual  ~GetAllTeamsStart();

    /**
     * Assignment operator
     */
    inline GetAllTeamsStart& operator = (const GetAllTeamsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllTeamsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllTeamsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllTeamsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllTeamsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 0;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "SportID"

    static const int kSportID = 1;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    static const GetAllTeamsStart &getDefaultInstance();

private:

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _AFFILIATE_ID;

    uint8 _SportID;

};

/**
 * The result message of the method "GetAllTeams"
 * Get List of All Teams available for the selected League.
 */
class GetAllTeamsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAllTeamsResult ();

    /**
     * Copy constructor
     */
    inline  GetAllTeamsResult (const GetAllTeamsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAllTeamsResult (const ::sxm_sports_main_fi_types::T_TeamList& AllTeamList_);

    /**
     * Destructor
     */
    inline virtual  ~GetAllTeamsResult();

    /**
     * Assignment operator
     */
    inline GetAllTeamsResult& operator = (const GetAllTeamsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllTeamsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllTeamsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllTeamsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllTeamsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AllTeamList"

    static const int kAllTeamList = 0;

    /**
     * Clears the field "AllTeamList".
     *
     * The field will be set to its default value. The hasAllTeamList()
     * method will return false.
     */
    inline void clearAllTeamList();

    /**
     * Checks whether the field "AllTeamList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllTeamList()). Otherwise it will return false.
     */
    inline bool hasAllTeamList () const;

    /**
     * Returns the value of the member "AllTeamList".
     *
     * List of All Teams playing in particular League.
     *
     * @return The value of the field "AllTeamList"
     */
    inline const ::sxm_sports_main_fi_types::T_TeamList& getAllTeamList () const;

    /**
     * Retrieves the value of the field "AllTeamList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AllTeamList".
     */
    inline ::sxm_sports_main_fi_types::T_TeamList& getAllTeamListMutable ();

    /**
     * Sets the value of the member "AllTeamList".
     *
     * List of All Teams playing in particular League.
     *
     * @param AllTeamList The value which will be set
     */
    inline void setAllTeamList (const ::sxm_sports_main_fi_types::T_TeamList& AllTeamList_);

    static const GetAllTeamsResult &getDefaultInstance();

private:

    inline void set_has_AllTeamList ();

    inline void clear_has_AllTeamList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_TeamList _AllTeamList;

};

/**
 * The error message of 'GetAllTeams'
 */
class GetAllTeamsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetAllTeamsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetAllTeamsErrorStructure (const GetAllTeamsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetAllTeamsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetAllTeamsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetAllTeamsErrorStructure& operator = (const GetAllTeamsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllTeamsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllTeamsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllTeamsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllTeamsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Class Info unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetAllTeamsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetAllTeams'
 */
class GetAllTeamsError  : public ::asf::core::Payload {
public:

    enum GetAllTeamsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetAllTeamsError ();

   /**
     * Copy constructor
     */
    inline  GetAllTeamsError (const GetAllTeamsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetAllTeamsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetAllTeamsError& operator = (const GetAllTeamsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAllTeamsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAllTeamsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAllTeamsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAllTeamsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetAllTeamsError::GetAllTeamsErrorField getField () const;

    inline void setField(GetAllTeamsError::GetAllTeamsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetAllTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetAllTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetAllTeamsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetAllTeamsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetAllTeamsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetAllTeamsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetAllTeamsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetAllTeamsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetAllTeamsError &getDefaultInstance();

private:

    inline void cloneData (const GetAllTeamsError& rhs);

    inline void deleteData ();

    GetAllTeamsErrorField __field;

    union {
        GetAllTeamsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "GetFavorites"
 * Get Favorite List of Team Sports.
 */
class GetFavoritesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoritesResult ();

    /**
     * Copy constructor
     */
    inline  GetFavoritesResult (const GetFavoritesResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoritesResult (const ::sxm_sports_main_fi_types::T_FavoriteList& FavoriteList_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoritesResult();

    /**
     * Assignment operator
     */
    inline GetFavoritesResult& operator = (const GetFavoritesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoritesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoritesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoritesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoritesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FavoriteList"

    static const int kFavoriteList = 0;

    /**
     * Clears the field "FavoriteList".
     *
     * The field will be set to its default value. The hasFavoriteList()
     * method will return false.
     */
    inline void clearFavoriteList();

    /**
     * Checks whether the field "FavoriteList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteList()). Otherwise it will return false.
     */
    inline bool hasFavoriteList () const;

    /**
     * Returns the value of the member "FavoriteList".
     *
     * Favorite List i.e saved by user before.
     *
     * @return The value of the field "FavoriteList"
     */
    inline const ::sxm_sports_main_fi_types::T_FavoriteList& getFavoriteList () const;

    /**
     * Retrieves the value of the field "FavoriteList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FavoriteList".
     */
    inline ::sxm_sports_main_fi_types::T_FavoriteList& getFavoriteListMutable ();

    /**
     * Sets the value of the member "FavoriteList".
     *
     * Favorite List i.e saved by user before.
     *
     * @param FavoriteList The value which will be set
     */
    inline void setFavoriteList (const ::sxm_sports_main_fi_types::T_FavoriteList& FavoriteList_);

    static const GetFavoritesResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_sports_main_fi_types::T_FavoriteInfo >& getT_FavoriteInfoList_DefaultInstance ();

    inline void set_has_FavoriteList ();

    inline void clear_has_FavoriteList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_FavoriteList _FavoriteList;

};

/**
 * The error message of 'GetFavorites'
 */
class GetFavoritesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoritesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoritesErrorStructure (const GetFavoritesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoritesErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFavoritesErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoritesErrorStructure& operator = (const GetFavoritesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoritesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoritesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoritesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoritesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Favorite List unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Favorite List unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetFavoritesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFavorites'
 */
class GetFavoritesError  : public ::asf::core::Payload {
public:

    enum GetFavoritesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoritesError ();

   /**
     * Copy constructor
     */
    inline  GetFavoritesError (const GetFavoritesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoritesError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoritesError& operator = (const GetFavoritesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoritesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoritesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoritesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoritesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoritesError::GetFavoritesErrorField getField () const;

    inline void setField(GetFavoritesError::GetFavoritesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoritesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoritesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoritesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoritesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoritesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoritesError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoritesError& rhs);

    inline void deleteData ();

    GetFavoritesErrorField __field;

    union {
        GetFavoritesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetAsFavorite"
 * To Add or Remove a Favorite To or From Favorite List.
 */
class SetAsFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAsFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  SetAsFavoriteStart (const SetAsFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAsFavoriteStart (uint8 SportID_, uint32 AFFILIATE_ID_, uint32 TEAM_ID_, bool FavoriteControl_);

    /**
     * Destructor
     */
    inline virtual  ~SetAsFavoriteStart();

    /**
     * Assignment operator
     */
    inline SetAsFavoriteStart& operator = (const SetAsFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAsFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAsFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAsFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAsFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "TEAM_ID"

    static const int kTEAM_ID = 2;

    /**
     * Clears the field "TEAM_ID".
     *
     * The field will be set to its default value. The hasTEAM_ID()
     * method will return false.
     */
    inline void clearTEAM_ID();

    /**
     * Checks whether the field "TEAM_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTEAM_ID()). Otherwise it will return false.
     */
    inline bool hasTEAM_ID () const;

    /**
     * Returns the value of the member "TEAM_ID".
     *
     * Team ID - Team Sports
     *
     * @return The value of the field "TEAM_ID"
     */
    inline uint32 getTEAM_ID () const;

    /**
     * Sets the value of the member "TEAM_ID".
     *
     * Team ID - Team Sports
     *
     * @param TEAM_ID The value which will be set
     */
    inline void setTEAM_ID (uint32 TEAM_ID_);

    // API of field "FavoriteControl"

    static const int kFavoriteControl = 3;

    /**
     * Clears the field "FavoriteControl".
     *
     * The field will be set to its default value. The hasFavoriteControl()
     * method will return false.
     */
    inline void clearFavoriteControl();

    /**
     * Checks whether the field "FavoriteControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteControl()). Otherwise it will return false.
     */
    inline bool hasFavoriteControl () const;

    /**
     * Returns the value of the member "FavoriteControl".
     *
     * TRUE - Save As Favorite,FALSE - Remove from Favorite
     *
     * @return The value of the field "FavoriteControl"
     */
    inline bool getFavoriteControl () const;

    /**
     * Sets the value of the member "FavoriteControl".
     *
     * TRUE - Save As Favorite,FALSE - Remove from Favorite
     *
     * @param FavoriteControl The value which will be set
     */
    inline void setFavoriteControl (bool FavoriteControl_);

    static const SetAsFavoriteStart &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_TEAM_ID ();

    inline void clear_has_TEAM_ID ();

    inline void set_has_FavoriteControl ();

    inline void clear_has_FavoriteControl ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _SportID;

    uint32 _AFFILIATE_ID;

    uint32 _TEAM_ID;

    bool _FavoriteControl;

};

/**
 * The result message of the method "SetAsFavorite"
 * To Add or Remove a Favorite To or From Favorite List.
 */
class SetAsFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAsFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  SetAsFavoriteResult (const SetAsFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAsFavoriteResult (bool Result_, bool FavoriteControl_);

    /**
     * Destructor
     */
    inline virtual  ~SetAsFavoriteResult();

    /**
     * Assignment operator
     */
    inline SetAsFavoriteResult& operator = (const SetAsFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAsFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAsFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAsFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAsFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True - Save or Removed Successfully.
     * False - Operation not successful.
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True - Save or Removed Successfully.
     * False - Operation not successful.
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    // API of field "FavoriteControl"

    static const int kFavoriteControl = 1;

    /**
     * Clears the field "FavoriteControl".
     *
     * The field will be set to its default value. The hasFavoriteControl()
     * method will return false.
     */
    inline void clearFavoriteControl();

    /**
     * Checks whether the field "FavoriteControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavoriteControl()). Otherwise it will return false.
     */
    inline bool hasFavoriteControl () const;

    /**
     * Returns the value of the member "FavoriteControl".
     *
     * True - Save As Favorite.
     * False - Remove from Favorite.
     *
     * @return The value of the field "FavoriteControl"
     */
    inline bool getFavoriteControl () const;

    /**
     * Sets the value of the member "FavoriteControl".
     *
     * True - Save As Favorite.
     * False - Remove from Favorite.
     *
     * @param FavoriteControl The value which will be set
     */
    inline void setFavoriteControl (bool FavoriteControl_);

    static const SetAsFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_FavoriteControl ();

    inline void clear_has_FavoriteControl ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Result;

    bool _FavoriteControl;

};

/**
 * The error message of 'SetAsFavorite'
 */
class SetAsFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetAsFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetAsFavoriteErrorStructure (const SetAsFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetAsFavoriteErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetAsFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline SetAsFavoriteErrorStructure& operator = (const SetAsFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAsFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAsFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAsFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAsFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Favorite List unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Favorite List unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const SetAsFavoriteErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'SetAsFavorite'
 */
class SetAsFavoriteError  : public ::asf::core::Payload {
public:

    enum SetAsFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetAsFavoriteError ();

   /**
     * Copy constructor
     */
    inline  SetAsFavoriteError (const SetAsFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetAsFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline SetAsFavoriteError& operator = (const SetAsFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAsFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAsFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAsFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAsFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetAsFavoriteError::SetAsFavoriteErrorField getField () const;

    inline void setField(SetAsFavoriteError::SetAsFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetAsFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetAsFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetAsFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetAsFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetAsFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetAsFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetAsFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetAsFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetAsFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const SetAsFavoriteError& rhs);

    inline void deleteData ();

    SetAsFavoriteErrorField __field;

    union {
        SetAsFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetScheduledEvents"
 * Get current or recent or future event list played in particular Affiliate.
 * This method is  specific for Non Team sports ONLY.
 */
class GetScheduledEventsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetScheduledEventsStart ();

    /**
     * Copy constructor
     */
    inline  GetScheduledEventsStart (const GetScheduledEventsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetScheduledEventsStart (uint8 SportID_, uint32 AFFILIATE_ID_, ::sxm_sports_main_fi_types::T_GameType EventType_, uint32 Event_ID_);

    /**
     * Destructor
     */
    inline virtual  ~GetScheduledEventsStart();

    /**
     * Assignment operator
     */
    inline GetScheduledEventsStart& operator = (const GetScheduledEventsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetScheduledEventsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetScheduledEventsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetScheduledEventsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetScheduledEventsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "EventType"

    static const int kEventType = 2;

    /**
     * Clears the field "EventType".
     *
     * The field will be set to its default value. The hasEventType()
     * method will return false.
     */
    inline void clearEventType();

    /**
     * Checks whether the field "EventType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventType()). Otherwise it will return false.
     */
    inline bool hasEventType () const;

    /**
     * Returns the value of the member "EventType".
     *
     * 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @return The value of the field "EventType"
     */
    inline ::sxm_sports_main_fi_types::T_GameType getEventType () const;

    /**
     * Sets the value of the member "EventType".
     *
     * 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @param EventType The value which will be set
     */
    inline void setEventType (::sxm_sports_main_fi_types::T_GameType EventType_);

    // API of field "Event_ID"

    static const int kEvent_ID = 3;

    /**
     * Clears the field "Event_ID".
     *
     * The field will be set to its default value. The hasEvent_ID()
     * method will return false.
     */
    inline void clearEvent_ID();

    /**
     * Checks whether the field "Event_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEvent_ID()). Otherwise it will return false.
     */
    inline bool hasEvent_ID () const;

    /**
     * Returns the value of the member "Event_ID".
     *
     * The Unique ID for the focussed or active screen element from Event list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Event ID for the event in active screen.</p>
     *
     * @return The value of the field "Event_ID"
     */
    inline uint32 getEvent_ID () const;

    /**
     * Sets the value of the member "Event_ID".
     *
     * The Unique ID for the focussed or active screen element from Event list.
     * <p>If the user enters into the screen for the first time, HMI must pass a default value of 4294967295 (0xffffffff).</p>
     * <p>When the list is active and an update is reported, HMI must pass the valid Unique Event ID for the event in active screen.</p>
     *
     * @param Event_ID The value which will be set
     */
    inline void setEvent_ID (uint32 Event_ID_);

    static const GetScheduledEventsStart &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_EventType ();

    inline void clear_has_EventType ();

    inline void set_has_Event_ID ();

    inline void clear_has_Event_ID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _SportID;

    uint32 _AFFILIATE_ID;

    ::sxm_sports_main_fi_types::T_GameType _EventType;

    uint32 _Event_ID;

};

/**
 * The result message of the method "GetScheduledEvents"
 * Get current or recent or future event list played in particular Affiliate.
 * This method is  specific for Non Team sports ONLY.
 */
class GetScheduledEventsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetScheduledEventsResult ();

    /**
     * Copy constructor
     */
    inline  GetScheduledEventsResult (const GetScheduledEventsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetScheduledEventsResult (const ::sxm_sports_main_fi_types::T_EventSchedule_List& ScheduledEvents_);

    /**
     * Destructor
     */
    inline virtual  ~GetScheduledEventsResult();

    /**
     * Assignment operator
     */
    inline GetScheduledEventsResult& operator = (const GetScheduledEventsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetScheduledEventsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetScheduledEventsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetScheduledEventsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetScheduledEventsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ScheduledEvents"

    static const int kScheduledEvents = 0;

    /**
     * Clears the field "ScheduledEvents".
     *
     * The field will be set to its default value. The hasScheduledEvents()
     * method will return false.
     */
    inline void clearScheduledEvents();

    /**
     * Checks whether the field "ScheduledEvents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScheduledEvents()). Otherwise it will return false.
     */
    inline bool hasScheduledEvents () const;

    /**
     * Returns the value of the member "ScheduledEvents".
     *
     * List of Events for a particular Affiliate based on the selected schedule.
     *
     * @return The value of the field "ScheduledEvents"
     */
    inline const ::sxm_sports_main_fi_types::T_EventSchedule_List& getScheduledEvents () const;

    /**
     * Retrieves the value of the field "ScheduledEvents" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ScheduledEvents".
     */
    inline ::sxm_sports_main_fi_types::T_EventSchedule_List& getScheduledEventsMutable ();

    /**
     * Sets the value of the member "ScheduledEvents".
     *
     * List of Events for a particular Affiliate based on the selected schedule.
     *
     * @param ScheduledEvents The value which will be set
     */
    inline void setScheduledEvents (const ::sxm_sports_main_fi_types::T_EventSchedule_List& ScheduledEvents_);

    static const GetScheduledEventsResult &getDefaultInstance();

private:

    inline void set_has_ScheduledEvents ();

    inline void clear_has_ScheduledEvents ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_EventSchedule_List _ScheduledEvents;

};

/**
 * The error message of 'GetScheduledEvents'
 */
class GetScheduledEventsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetScheduledEventsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetScheduledEventsErrorStructure (const GetScheduledEventsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetScheduledEventsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetScheduledEventsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetScheduledEventsErrorStructure& operator = (const GetScheduledEventsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetScheduledEventsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetScheduledEventsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetScheduledEventsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetScheduledEventsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error code specifying Event List unavailability.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error code specifying Event List unavailability.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetScheduledEventsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetScheduledEvents'
 */
class GetScheduledEventsError  : public ::asf::core::Payload {
public:

    enum GetScheduledEventsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetScheduledEventsError ();

   /**
     * Copy constructor
     */
    inline  GetScheduledEventsError (const GetScheduledEventsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetScheduledEventsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetScheduledEventsError& operator = (const GetScheduledEventsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetScheduledEventsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetScheduledEventsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetScheduledEventsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetScheduledEventsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetScheduledEventsError::GetScheduledEventsErrorField getField () const;

    inline void setField(GetScheduledEventsError::GetScheduledEventsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetScheduledEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetScheduledEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetScheduledEventsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetScheduledEventsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetScheduledEventsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetScheduledEventsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetScheduledEventsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetScheduledEventsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetScheduledEventsError &getDefaultInstance();

private:

    inline void cloneData (const GetScheduledEventsError& rhs);

    inline void deleteData ();

    GetScheduledEventsErrorField __field;

    union {
        GetScheduledEventsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetEventRankList"
 * Get rank list if available for the selected non team sport event.
 */
class GetEventRankListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetEventRankListStart ();

    /**
     * Copy constructor
     */
    inline  GetEventRankListStart (const GetEventRankListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetEventRankListStart (uint8 SportID_, uint32 AFFILIATE_ID_, ::sxm_sports_main_fi_types::T_GameType EventType_, int32 TableParam_, int32 TableRef_);

    /**
     * Destructor
     */
    inline virtual  ~GetEventRankListStart();

    /**
     * Assignment operator
     */
    inline GetEventRankListStart& operator = (const GetEventRankListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetEventRankListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetEventRankListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetEventRankListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetEventRankListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * Sport ID
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * Sport ID
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    // API of field "AFFILIATE_ID"

    static const int kAFFILIATE_ID = 1;

    /**
     * Clears the field "AFFILIATE_ID".
     *
     * The field will be set to its default value. The hasAFFILIATE_ID()
     * method will return false.
     */
    inline void clearAFFILIATE_ID();

    /**
     * Checks whether the field "AFFILIATE_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAFFILIATE_ID()). Otherwise it will return false.
     */
    inline bool hasAFFILIATE_ID () const;

    /**
     * Returns the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @return The value of the field "AFFILIATE_ID"
     */
    inline uint32 getAFFILIATE_ID () const;

    /**
     * Sets the value of the member "AFFILIATE_ID".
     *
     * Affiliate ID
     *
     * @param AFFILIATE_ID The value which will be set
     */
    inline void setAFFILIATE_ID (uint32 AFFILIATE_ID_);

    // API of field "EventType"

    static const int kEventType = 2;

    /**
     * Clears the field "EventType".
     *
     * The field will be set to its default value. The hasEventType()
     * method will return false.
     */
    inline void clearEventType();

    /**
     * Checks whether the field "EventType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventType()). Otherwise it will return false.
     */
    inline bool hasEventType () const;

    /**
     * Returns the value of the member "EventType".
     *
     * 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @return The value of the field "EventType"
     */
    inline ::sxm_sports_main_fi_types::T_GameType getEventType () const;

    /**
     * Sets the value of the member "EventType".
     *
     * 0-Today's Event, 1-Recent Event, 2-Future Event
     *
     * @param EventType The value which will be set
     */
    inline void setEventType (::sxm_sports_main_fi_types::T_GameType EventType_);

    // API of field "TableParam"

    static const int kTableParam = 3;

    /**
     * Clears the field "TableParam".
     *
     * The field will be set to its default value. The hasTableParam()
     * method will return false.
     */
    inline void clearTableParam();

    /**
     * Checks whether the field "TableParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTableParam()). Otherwise it will return false.
     */
    inline bool hasTableParam () const;

    /**
     * Returns the value of the member "TableParam".
     *
     * The table Param value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @return The value of the field "TableParam"
     */
    inline int32 getTableParam () const;

    /**
     * Sets the value of the member "TableParam".
     *
     * The table Param value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @param TableParam The value which will be set
     */
    inline void setTableParam (int32 TableParam_);

    // API of field "TableRef"

    static const int kTableRef = 4;

    /**
     * Clears the field "TableRef".
     *
     * The field will be set to its default value. The hasTableRef()
     * method will return false.
     */
    inline void clearTableRef();

    /**
     * Checks whether the field "TableRef" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTableRef()). Otherwise it will return false.
     */
    inline bool hasTableRef () const;

    /**
     * Returns the value of the member "TableRef".
     *
     * Rank List Table's reference value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @return The value of the field "TableRef"
     */
    inline int32 getTableRef () const;

    /**
     * Sets the value of the member "TableRef".
     *
     * Rank List Table's reference value provided by SMSe.
     * <p>This value is passed as a parameter to HMI through type T_EventSchedule.</p>
     *
     * @param TableRef The value which will be set
     */
    inline void setTableRef (int32 TableRef_);

    static const GetEventRankListStart &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    inline void set_has_AFFILIATE_ID ();

    inline void clear_has_AFFILIATE_ID ();

    inline void set_has_EventType ();

    inline void clear_has_EventType ();

    inline void set_has_TableParam ();

    inline void clear_has_TableParam ();

    inline void set_has_TableRef ();

    inline void clear_has_TableRef ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _SportID;

    uint32 _AFFILIATE_ID;

    ::sxm_sports_main_fi_types::T_GameType _EventType;

    int32 _TableParam;

    int32 _TableRef;

};

/**
 * The result message of the method "GetEventRankList"
 * Get rank list if available for the selected non team sport event.
 */
class GetEventRankListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetEventRankListResult ();

    /**
     * Copy constructor
     */
    inline  GetEventRankListResult (const GetEventRankListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetEventRankListResult (const ::sxm_sports_main_fi_types::T_EventRankList& EventInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetEventRankListResult();

    /**
     * Assignment operator
     */
    inline GetEventRankListResult& operator = (const GetEventRankListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetEventRankListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetEventRankListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetEventRankListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetEventRankListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EventInfo"

    static const int kEventInfo = 0;

    /**
     * Clears the field "EventInfo".
     *
     * The field will be set to its default value. The hasEventInfo()
     * method will return false.
     */
    inline void clearEventInfo();

    /**
     * Checks whether the field "EventInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventInfo()). Otherwise it will return false.
     */
    inline bool hasEventInfo () const;

    /**
     * Returns the value of the member "EventInfo".
     *
     * RankList for user selected non team sport event.
     *
     * @return The value of the field "EventInfo"
     */
    inline const ::sxm_sports_main_fi_types::T_EventRankList& getEventInfo () const;

    /**
     * Retrieves the value of the field "EventInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EventInfo".
     */
    inline ::sxm_sports_main_fi_types::T_EventRankList& getEventInfoMutable ();

    /**
     * Sets the value of the member "EventInfo".
     *
     * RankList for user selected non team sport event.
     *
     * @param EventInfo The value which will be set
     */
    inline void setEventInfo (const ::sxm_sports_main_fi_types::T_EventRankList& EventInfo_);

    static const GetEventRankListResult &getDefaultInstance();

private:

    inline void set_has_EventInfo ();

    inline void clear_has_EventInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_EventRankList _EventInfo;

};

/**
 * The error message of 'GetEventRankList'
 */
class GetEventRankListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetEventRankListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetEventRankListErrorStructure (const GetEventRankListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetEventRankListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetEventRankListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetEventRankListErrorStructure& operator = (const GetEventRankListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetEventRankListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetEventRankListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetEventRankListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetEventRankListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error code occurred while retrieving Rank List for the selected event.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error code occurred while retrieving Rank List for the selected event.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const GetEventRankListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetEventRankList'
 */
class GetEventRankListError  : public ::asf::core::Payload {
public:

    enum GetEventRankListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetEventRankListError ();

   /**
     * Copy constructor
     */
    inline  GetEventRankListError (const GetEventRankListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetEventRankListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetEventRankListError& operator = (const GetEventRankListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetEventRankListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetEventRankListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetEventRankListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetEventRankListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetEventRankListError::GetEventRankListErrorField getField () const;

    inline void setField(GetEventRankListError::GetEventRankListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetEventRankListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetEventRankListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetEventRankListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetEventRankListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetEventRankListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetEventRankListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetEventRankListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetEventRankListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetEventRankListError &getDefaultInstance();

private:

    inline void cloneData (const GetEventRankListError& rhs);

    inline void deleteData ();

    GetEventRankListErrorField __field;

    union {
        GetEventRankListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SportsServiceDataStatus"
 * Status of Sports Service Data Availability.
 */
class SportsServiceDataStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsServiceDataStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SportsServiceDataStatusStatus (const SportsServiceDataStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SportsServiceDataStatusStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus SportsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SportsServiceDataStatusStatus();

    /**
     * Assignment operator
     */
    inline SportsServiceDataStatusStatus& operator = (const SportsServiceDataStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsServiceDataStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsServiceDataStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsServiceDataStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsServiceDataStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportsStatus"

    static const int kSportsStatus = 0;

    /**
     * Clears the field "SportsStatus".
     *
     * The field will be set to its default value. The hasSportsStatus()
     * method will return false.
     */
    inline void clearSportsStatus();

    /**
     * Checks whether the field "SportsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportsStatus()). Otherwise it will return false.
     */
    inline bool hasSportsStatus () const;

    /**
     * Returns the value of the member "SportsStatus".
     *
     * Status of Sports Data availability.
     *
     * @return The value of the field "SportsStatus"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus getSportsStatus () const;

    /**
     * Sets the value of the member "SportsStatus".
     *
     * Status of Sports Data availability.
     *
     * @param SportsStatus The value which will be set
     */
    inline void setSportsStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus SportsStatus_);

    static const SportsServiceDataStatusStatus &getDefaultInstance();

private:

    inline void set_has_SportsStatus ();

    inline void clear_has_SportsStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus _SportsStatus;

};

/**
 * The error message of 'SportsServiceDataStatus'
 */
class SportsServiceDataStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsServiceDataStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsServiceDataStatusErrorStructure (const SportsServiceDataStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsServiceDataStatusErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsServiceDataStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsServiceDataStatusErrorStructure& operator = (const SportsServiceDataStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsServiceDataStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsServiceDataStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsServiceDataStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsServiceDataStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Sports Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Sports Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const SportsServiceDataStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsServiceDataStatus'
 */
class SportsServiceDataStatusError  : public ::asf::core::Payload {
public:

    enum SportsServiceDataStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsServiceDataStatusError ();

   /**
     * Copy constructor
     */
    inline  SportsServiceDataStatusError (const SportsServiceDataStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsServiceDataStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsServiceDataStatusError& operator = (const SportsServiceDataStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsServiceDataStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsServiceDataStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsServiceDataStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsServiceDataStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsServiceDataStatusError::SportsServiceDataStatusErrorField getField () const;

    inline void setField(SportsServiceDataStatusError::SportsServiceDataStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsServiceDataStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsServiceDataStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsServiceDataStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsServiceDataStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsServiceDataStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsServiceDataStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsServiceDataStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsServiceDataStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsServiceDataStatusError &getDefaultInstance();

private:

    inline void cloneData (const SportsServiceDataStatusError& rhs);

    inline void deleteData ();

    SportsServiceDataStatusErrorField __field;

    union {
        SportsServiceDataStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SportsDataUpdate"
 * Report changes about Dynamic updates on News, Recent, Current, Future Games.
 */
class SportsDataUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SportsDataUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  SportsDataUpdateStatus (const SportsDataUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SportsDataUpdateStatus (uint8 SportID_, uint32 LeagueID_, ::sxm_sports_main_fi_types::T_SportsUpdateType UpdateType_, ::sxm_sports_main_fi_types::T_e8CategoryAvailability UpdateStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SportsDataUpdateStatus();

    /**
     * Assignment operator
     */
    inline SportsDataUpdateStatus& operator = (const SportsDataUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsDataUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsDataUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsDataUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsDataUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SportID"

    static const int kSportID = 0;

    /**
     * Clears the field "SportID".
     *
     * The field will be set to its default value. The hasSportID()
     * method will return false.
     */
    inline void clearSportID();

    /**
     * Checks whether the field "SportID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSportID()). Otherwise it will return false.
     */
    inline bool hasSportID () const;

    /**
     * Returns the value of the member "SportID".
     *
     * The sport ID for which the update is available.
     *
     * @return The value of the field "SportID"
     */
    inline uint8 getSportID () const;

    /**
     * Sets the value of the member "SportID".
     *
     * The sport ID for which the update is available.
     *
     * @param SportID The value which will be set
     */
    inline void setSportID (uint8 SportID_);

    // API of field "LeagueID"

    static const int kLeagueID = 1;

    /**
     * Clears the field "LeagueID".
     *
     * The field will be set to its default value. The hasLeagueID()
     * method will return false.
     */
    inline void clearLeagueID();

    /**
     * Checks whether the field "LeagueID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueID()). Otherwise it will return false.
     */
    inline bool hasLeagueID () const;

    /**
     * Returns the value of the member "LeagueID".
     *
     * The league ID for which the update is available.
     *
     * @return The value of the field "LeagueID"
     */
    inline uint32 getLeagueID () const;

    /**
     * Sets the value of the member "LeagueID".
     *
     * The league ID for which the update is available.
     *
     * @param LeagueID The value which will be set
     */
    inline void setLeagueID (uint32 LeagueID_);

    // API of field "UpdateType"

    static const int kUpdateType = 2;

    /**
     * Clears the field "UpdateType".
     *
     * The field will be set to its default value. The hasUpdateType()
     * method will return false.
     */
    inline void clearUpdateType();

    /**
     * Checks whether the field "UpdateType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateType()). Otherwise it will return false.
     */
    inline bool hasUpdateType () const;

    /**
     * Returns the value of the member "UpdateType".
     *
     * The type of update available.
     *
     * @return The value of the field "UpdateType"
     */
    inline ::sxm_sports_main_fi_types::T_SportsUpdateType getUpdateType () const;

    /**
     * Sets the value of the member "UpdateType".
     *
     * The type of update available.
     *
     * @param UpdateType The value which will be set
     */
    inline void setUpdateType (::sxm_sports_main_fi_types::T_SportsUpdateType UpdateType_);

    // API of field "UpdateStatus"

    static const int kUpdateStatus = 3;

    /**
     * Clears the field "UpdateStatus".
     *
     * The field will be set to its default value. The hasUpdateStatus()
     * method will return false.
     */
    inline void clearUpdateStatus();

    /**
     * Checks whether the field "UpdateStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateStatus()). Otherwise it will return false.
     */
    inline bool hasUpdateStatus () const;

    /**
     * Returns the value of the member "UpdateStatus".
     *
     * The status of the update type
     *
     * @return The value of the field "UpdateStatus"
     */
    inline ::sxm_sports_main_fi_types::T_e8CategoryAvailability getUpdateStatus () const;

    /**
     * Sets the value of the member "UpdateStatus".
     *
     * The status of the update type
     *
     * @param UpdateStatus The value which will be set
     */
    inline void setUpdateStatus (::sxm_sports_main_fi_types::T_e8CategoryAvailability UpdateStatus_);

    static const SportsDataUpdateStatus &getDefaultInstance();

private:

    inline void set_has_SportID ();

    inline void clear_has_SportID ();

    inline void set_has_LeagueID ();

    inline void clear_has_LeagueID ();

    inline void set_has_UpdateType ();

    inline void clear_has_UpdateType ();

    inline void set_has_UpdateStatus ();

    inline void clear_has_UpdateStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _SportID;

    uint32 _LeagueID;

    ::sxm_sports_main_fi_types::T_SportsUpdateType _UpdateType;

    ::sxm_sports_main_fi_types::T_e8CategoryAvailability _UpdateStatus;

};

/**
 * The error message of 'SportsDataUpdate'
 */
class SportsDataUpdateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SportsDataUpdateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SportsDataUpdateErrorStructure (const SportsDataUpdateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SportsDataUpdateErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SportsDataUpdateErrorStructure();

    /**
     * Assignment operator
     */
    inline SportsDataUpdateErrorStructure& operator = (const SportsDataUpdateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsDataUpdateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsDataUpdateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsDataUpdateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsDataUpdateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Sports Feature.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Enumerated messages that correspond to faults in SXM Sports Feature.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_);

    static const SportsDataUpdateErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_sports_main_fi_types::T_e8SportsErrorTypes _ErrorCode;

};

/**
 * The error message of 'SportsDataUpdate'
 */
class SportsDataUpdateError  : public ::asf::core::Payload {
public:

    enum SportsDataUpdateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SportsDataUpdateError ();

   /**
     * Copy constructor
     */
    inline  SportsDataUpdateError (const SportsDataUpdateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SportsDataUpdateError();

    /**
     * Assigns a new value to this object.
     */
    inline SportsDataUpdateError& operator = (const SportsDataUpdateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SportsDataUpdateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SportsDataUpdateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SportsDataUpdateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SportsDataUpdateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SportsDataUpdateError::SportsDataUpdateErrorField getField () const;

    inline void setField(SportsDataUpdateError::SportsDataUpdateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SportsDataUpdateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SportsDataUpdateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SportsDataUpdateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SportsDataUpdateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SportsDataUpdateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SportsDataUpdateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SportsDataUpdateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SportsDataUpdateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SportsDataUpdateError &getDefaultInstance();

private:

    inline void cloneData (const SportsDataUpdateError& rhs);

    inline void deleteData ();

    SportsDataUpdateErrorField __field;

    union {
        SportsDataUpdateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

inline  GetSportListResult::GetSportListResult ()  :
    _SportList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSportListResult::GetSportListResult (const GetSportListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SportList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSportListResult::GetSportListResult (const ::sxm_sports_main_fi_types::T_SportList& SportList_)  :
    _SportList (SportList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSportListResult::~GetSportListResult() {
}

inline GetSportListResult& GetSportListResult::operator = (const GetSportListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportList()) {
            setSportList(rhs.getSportList());
        } else {
            clearSportList();
        }
    }
    return *this;
}

inline bool GetSportListResult::operator == (const GetSportListResult& rhs) const {
    return (((!hasSportList() && !rhs.hasSportList()) || getSportList() == rhs.getSportList()));
}

inline bool GetSportListResult::operator != (const GetSportListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSportListResult::operator < (const GetSportListResult& rhs) const {
    if (hasSportList() || rhs.hasSportList()) {
        if (getSportList() < rhs.getSportList()) return true;
        if (getSportList() > rhs.getSportList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSportListResult::clone() {
    return new GetSportListResult(*this);
}

inline bool GetSportListResult::operator > (const GetSportListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSportListResult::clear() {
    clearSportList();
}

inline void GetSportListResult::clearSportList() {
    if (hasSportList()) {
         clear_has_SportList();
        _SportList.clear();
     }
}

inline bool GetSportListResult::hasSportList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_SportList& GetSportListResult::getSportList () const {
    return _SportList;
}

inline ::sxm_sports_main_fi_types::T_SportList& GetSportListResult::getSportListMutable () {
    set_has_SportList();
    return _SportList;
}

inline void GetSportListResult::setSportList (const ::sxm_sports_main_fi_types::T_SportList& SportList_) {
    set_has_SportList();
    this->_SportList = SportList_;
}

inline void GetSportListResult::set_has_SportList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSportListResult::clear_has_SportList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSportListErrorStructure::GetSportListErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSportListErrorStructure::GetSportListErrorStructure (const GetSportListErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSportListErrorStructure::GetSportListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetSportListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSportListErrorStructure::~GetSportListErrorStructure() {
}

inline GetSportListErrorStructure& GetSportListErrorStructure::operator = (const GetSportListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetSportListErrorStructure::operator == (const GetSportListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetSportListErrorStructure::operator != (const GetSportListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSportListErrorStructure::operator < (const GetSportListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetSportListErrorStructure::operator > (const GetSportListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSportListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetSportListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetSportListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetSportListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetSportListErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetSportListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetSportListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSportListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSportListError::GetSportListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetSportListError::GetSportListError (const GetSportListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetSportListError::~GetSportListError() {
    deleteData ();
}

inline GetSportListError& GetSportListError::operator = (const GetSportListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetSportListError::operator == (const GetSportListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetSportListError::operator != (const GetSportListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSportListError::operator < (const GetSportListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetSportListError::operator > (const GetSportListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetSportListError::GetSportListErrorField GetSportListError::getField () const {
    return __field;
}

inline void GetSportListError::setField(GetSportListError::GetSportListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetSportListError::clone() {
    return new GetSportListError(*this);
}

inline bool GetSportListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetSportListErrorStructure& GetSportListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetSportListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetSportListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetSportListErrorStructure& GetSportListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetSportListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetSportListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetSportListErrorStructure* GetSportListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetSportListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetSportListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetSportListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetSportListError::replaceCcaErrorCode (GetSportListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetSportListError::setCcaErrorCode (const GetSportListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetSportListErrorStructure(value);
    }
}

inline bool GetSportListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetSportListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetSportListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetSportListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetSportListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetSportListError::cloneData (const GetSportListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetSportListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetSportListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetSportListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetRootAffiliateListStart::GetRootAffiliateListStart ()  :
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRootAffiliateListStart::GetRootAffiliateListStart (const GetRootAffiliateListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRootAffiliateListStart::GetRootAffiliateListStart (uint8 SportID_)  :
    _SportID (SportID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRootAffiliateListStart::~GetRootAffiliateListStart() {
}

inline GetRootAffiliateListStart& GetRootAffiliateListStart::operator = (const GetRootAffiliateListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
    }
    return *this;
}

inline bool GetRootAffiliateListStart::operator == (const GetRootAffiliateListStart& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()));
}

inline bool GetRootAffiliateListStart::operator != (const GetRootAffiliateListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRootAffiliateListStart::operator < (const GetRootAffiliateListStart& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRootAffiliateListStart::clone() {
    return new GetRootAffiliateListStart(*this);
}

inline bool GetRootAffiliateListStart::operator > (const GetRootAffiliateListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRootAffiliateListStart::clear() {
    clearSportID();
}

inline void GetRootAffiliateListStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetRootAffiliateListStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetRootAffiliateListStart::getSportID () const {
    return _SportID;
}

inline void GetRootAffiliateListStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetRootAffiliateListStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRootAffiliateListStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetRootAffiliateListResult::GetRootAffiliateListResult ()  :
    _RootAffiliateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRootAffiliateListResult::GetRootAffiliateListResult (const GetRootAffiliateListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _RootAffiliateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRootAffiliateListResult::GetRootAffiliateListResult (const ::sxm_sports_main_fi_types::T_RootAffiliateList& RootAffiliateList_)  :
    _RootAffiliateList (RootAffiliateList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRootAffiliateListResult::~GetRootAffiliateListResult() {
}

inline GetRootAffiliateListResult& GetRootAffiliateListResult::operator = (const GetRootAffiliateListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRootAffiliateList()) {
            setRootAffiliateList(rhs.getRootAffiliateList());
        } else {
            clearRootAffiliateList();
        }
    }
    return *this;
}

inline bool GetRootAffiliateListResult::operator == (const GetRootAffiliateListResult& rhs) const {
    return (((!hasRootAffiliateList() && !rhs.hasRootAffiliateList()) || getRootAffiliateList() == rhs.getRootAffiliateList()));
}

inline bool GetRootAffiliateListResult::operator != (const GetRootAffiliateListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRootAffiliateListResult::operator < (const GetRootAffiliateListResult& rhs) const {
    if (hasRootAffiliateList() || rhs.hasRootAffiliateList()) {
        if (getRootAffiliateList() < rhs.getRootAffiliateList()) return true;
        if (getRootAffiliateList() > rhs.getRootAffiliateList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetRootAffiliateListResult::clone() {
    return new GetRootAffiliateListResult(*this);
}

inline bool GetRootAffiliateListResult::operator > (const GetRootAffiliateListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRootAffiliateListResult::clear() {
    clearRootAffiliateList();
}

inline void GetRootAffiliateListResult::clearRootAffiliateList() {
    if (hasRootAffiliateList()) {
         clear_has_RootAffiliateList();
        _RootAffiliateList.clear();
     }
}

inline bool GetRootAffiliateListResult::hasRootAffiliateList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_RootAffiliateList& GetRootAffiliateListResult::getRootAffiliateList () const {
    return _RootAffiliateList;
}

inline ::sxm_sports_main_fi_types::T_RootAffiliateList& GetRootAffiliateListResult::getRootAffiliateListMutable () {
    set_has_RootAffiliateList();
    return _RootAffiliateList;
}

inline void GetRootAffiliateListResult::setRootAffiliateList (const ::sxm_sports_main_fi_types::T_RootAffiliateList& RootAffiliateList_) {
    set_has_RootAffiliateList();
    this->_RootAffiliateList = RootAffiliateList_;
}

inline void GetRootAffiliateListResult::set_has_RootAffiliateList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRootAffiliateListResult::clear_has_RootAffiliateList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetRootAffiliateListErrorStructure::GetRootAffiliateListErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetRootAffiliateListErrorStructure::GetRootAffiliateListErrorStructure (const GetRootAffiliateListErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetRootAffiliateListErrorStructure::GetRootAffiliateListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetRootAffiliateListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetRootAffiliateListErrorStructure::~GetRootAffiliateListErrorStructure() {
}

inline GetRootAffiliateListErrorStructure& GetRootAffiliateListErrorStructure::operator = (const GetRootAffiliateListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetRootAffiliateListErrorStructure::operator == (const GetRootAffiliateListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetRootAffiliateListErrorStructure::operator != (const GetRootAffiliateListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRootAffiliateListErrorStructure::operator < (const GetRootAffiliateListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetRootAffiliateListErrorStructure::operator > (const GetRootAffiliateListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetRootAffiliateListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetRootAffiliateListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetRootAffiliateListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetRootAffiliateListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetRootAffiliateListErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetRootAffiliateListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetRootAffiliateListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetRootAffiliateListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetRootAffiliateListError::GetRootAffiliateListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetRootAffiliateListError::GetRootAffiliateListError (const GetRootAffiliateListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetRootAffiliateListError::~GetRootAffiliateListError() {
    deleteData ();
}

inline GetRootAffiliateListError& GetRootAffiliateListError::operator = (const GetRootAffiliateListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetRootAffiliateListError::operator == (const GetRootAffiliateListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetRootAffiliateListError::operator != (const GetRootAffiliateListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetRootAffiliateListError::operator < (const GetRootAffiliateListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetRootAffiliateListError::operator > (const GetRootAffiliateListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetRootAffiliateListError::GetRootAffiliateListErrorField GetRootAffiliateListError::getField () const {
    return __field;
}

inline void GetRootAffiliateListError::setField(GetRootAffiliateListError::GetRootAffiliateListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetRootAffiliateListError::clone() {
    return new GetRootAffiliateListError(*this);
}

inline bool GetRootAffiliateListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetRootAffiliateListErrorStructure& GetRootAffiliateListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetRootAffiliateListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetRootAffiliateListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetRootAffiliateListErrorStructure& GetRootAffiliateListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetRootAffiliateListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetRootAffiliateListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetRootAffiliateListErrorStructure* GetRootAffiliateListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetRootAffiliateListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetRootAffiliateListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetRootAffiliateListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetRootAffiliateListError::replaceCcaErrorCode (GetRootAffiliateListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetRootAffiliateListError::setCcaErrorCode (const GetRootAffiliateListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetRootAffiliateListErrorStructure(value);
    }
}

inline bool GetRootAffiliateListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetRootAffiliateListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetRootAffiliateListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetRootAffiliateListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetRootAffiliateListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetRootAffiliateListError::cloneData (const GetRootAffiliateListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetRootAffiliateListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetRootAffiliateListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetRootAffiliateListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetAffiliateDetailsStart::GetAffiliateDetailsStart ()  :
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsStart::GetAffiliateDetailsStart (const GetAffiliateDetailsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAffiliateDetailsStart::GetAffiliateDetailsStart (uint32 AFFILIATE_ID_, uint8 SportID_)  :
    _AFFILIATE_ID (AFFILIATE_ID_),
    _SportID (SportID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsStart::~GetAffiliateDetailsStart() {
}

inline GetAffiliateDetailsStart& GetAffiliateDetailsStart::operator = (const GetAffiliateDetailsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
    }
    return *this;
}

inline bool GetAffiliateDetailsStart::operator == (const GetAffiliateDetailsStart& rhs) const {
    return (((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()));
}

inline bool GetAffiliateDetailsStart::operator != (const GetAffiliateDetailsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAffiliateDetailsStart::operator < (const GetAffiliateDetailsStart& rhs) const {
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAffiliateDetailsStart::clone() {
    return new GetAffiliateDetailsStart(*this);
}

inline bool GetAffiliateDetailsStart::operator > (const GetAffiliateDetailsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAffiliateDetailsStart::clear() {
    clearAFFILIATE_ID();
    clearSportID();
}

inline void GetAffiliateDetailsStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetAffiliateDetailsStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetAffiliateDetailsStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetAffiliateDetailsStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetAffiliateDetailsStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetAffiliateDetailsStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetAffiliateDetailsStart::getSportID () const {
    return _SportID;
}

inline void GetAffiliateDetailsStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetAffiliateDetailsStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAffiliateDetailsStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetAffiliateDetailsStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetAffiliateDetailsStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetAffiliateDetailsResult::GetAffiliateDetailsResult ()  :
    _AffiliateDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsResult::GetAffiliateDetailsResult (const GetAffiliateDetailsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _AffiliateDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAffiliateDetailsResult::GetAffiliateDetailsResult (const ::sxm_sports_main_fi_types::T_AffiliateDetails& AffiliateDetails_)  :
    _AffiliateDetails (AffiliateDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsResult::~GetAffiliateDetailsResult() {
}

inline GetAffiliateDetailsResult& GetAffiliateDetailsResult::operator = (const GetAffiliateDetailsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAffiliateDetails()) {
            setAffiliateDetails(rhs.getAffiliateDetails());
        } else {
            clearAffiliateDetails();
        }
    }
    return *this;
}

inline bool GetAffiliateDetailsResult::operator == (const GetAffiliateDetailsResult& rhs) const {
    return (((!hasAffiliateDetails() && !rhs.hasAffiliateDetails()) || getAffiliateDetails() == rhs.getAffiliateDetails()));
}

inline bool GetAffiliateDetailsResult::operator != (const GetAffiliateDetailsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAffiliateDetailsResult::operator < (const GetAffiliateDetailsResult& rhs) const {
    if (hasAffiliateDetails() || rhs.hasAffiliateDetails()) {
        if (getAffiliateDetails() < rhs.getAffiliateDetails()) return true;
        if (getAffiliateDetails() > rhs.getAffiliateDetails()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAffiliateDetailsResult::clone() {
    return new GetAffiliateDetailsResult(*this);
}

inline bool GetAffiliateDetailsResult::operator > (const GetAffiliateDetailsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAffiliateDetailsResult::clear() {
    clearAffiliateDetails();
}

inline void GetAffiliateDetailsResult::clearAffiliateDetails() {
    if (hasAffiliateDetails()) {
         clear_has_AffiliateDetails();
        _AffiliateDetails.clear();
     }
}

inline bool GetAffiliateDetailsResult::hasAffiliateDetails () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_AffiliateDetails& GetAffiliateDetailsResult::getAffiliateDetails () const {
    return _AffiliateDetails;
}

inline ::sxm_sports_main_fi_types::T_AffiliateDetails& GetAffiliateDetailsResult::getAffiliateDetailsMutable () {
    set_has_AffiliateDetails();
    return _AffiliateDetails;
}

inline void GetAffiliateDetailsResult::setAffiliateDetails (const ::sxm_sports_main_fi_types::T_AffiliateDetails& AffiliateDetails_) {
    set_has_AffiliateDetails();
    this->_AffiliateDetails = AffiliateDetails_;
}

inline void GetAffiliateDetailsResult::set_has_AffiliateDetails () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAffiliateDetailsResult::clear_has_AffiliateDetails () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAffiliateDetailsErrorStructure::GetAffiliateDetailsErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsErrorStructure::GetAffiliateDetailsErrorStructure (const GetAffiliateDetailsErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAffiliateDetailsErrorStructure::GetAffiliateDetailsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetAffiliateDetailsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAffiliateDetailsErrorStructure::~GetAffiliateDetailsErrorStructure() {
}

inline GetAffiliateDetailsErrorStructure& GetAffiliateDetailsErrorStructure::operator = (const GetAffiliateDetailsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetAffiliateDetailsErrorStructure::operator == (const GetAffiliateDetailsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetAffiliateDetailsErrorStructure::operator != (const GetAffiliateDetailsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAffiliateDetailsErrorStructure::operator < (const GetAffiliateDetailsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetAffiliateDetailsErrorStructure::operator > (const GetAffiliateDetailsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAffiliateDetailsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetAffiliateDetailsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetAffiliateDetailsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetAffiliateDetailsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetAffiliateDetailsErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetAffiliateDetailsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetAffiliateDetailsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAffiliateDetailsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAffiliateDetailsError::GetAffiliateDetailsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetAffiliateDetailsError::GetAffiliateDetailsError (const GetAffiliateDetailsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetAffiliateDetailsError::~GetAffiliateDetailsError() {
    deleteData ();
}

inline GetAffiliateDetailsError& GetAffiliateDetailsError::operator = (const GetAffiliateDetailsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetAffiliateDetailsError::operator == (const GetAffiliateDetailsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetAffiliateDetailsError::operator != (const GetAffiliateDetailsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAffiliateDetailsError::operator < (const GetAffiliateDetailsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetAffiliateDetailsError::operator > (const GetAffiliateDetailsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetAffiliateDetailsError::GetAffiliateDetailsErrorField GetAffiliateDetailsError::getField () const {
    return __field;
}

inline void GetAffiliateDetailsError::setField(GetAffiliateDetailsError::GetAffiliateDetailsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetAffiliateDetailsError::clone() {
    return new GetAffiliateDetailsError(*this);
}

inline bool GetAffiliateDetailsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetAffiliateDetailsErrorStructure& GetAffiliateDetailsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetAffiliateDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetAffiliateDetailsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetAffiliateDetailsErrorStructure& GetAffiliateDetailsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetAffiliateDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetAffiliateDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetAffiliateDetailsErrorStructure* GetAffiliateDetailsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetAffiliateDetailsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetAffiliateDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetAffiliateDetailsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetAffiliateDetailsError::replaceCcaErrorCode (GetAffiliateDetailsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetAffiliateDetailsError::setCcaErrorCode (const GetAffiliateDetailsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetAffiliateDetailsErrorStructure(value);
    }
}

inline bool GetAffiliateDetailsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetAffiliateDetailsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetAffiliateDetailsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetAffiliateDetailsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetAffiliateDetailsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetAffiliateDetailsError::cloneData (const GetAffiliateDetailsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetAffiliateDetailsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetAffiliateDetailsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetAffiliateDetailsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetGameListStart::GetGameListStart ()  :
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _TEAM_ID (0u),
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Game_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetGameListStart::GetGameListStart (const GetGameListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _TEAM_ID (0u),
    _GameType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Game_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetGameListStart::GetGameListStart (uint8 SportID_, uint32 AFFILIATE_ID_, uint32 TEAM_ID_, ::sxm_sports_main_fi_types::T_GameType GameType_, uint32 Game_ID_)  :
    _SportID (SportID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _TEAM_ID (TEAM_ID_),
    _GameType (GameType_),
    _Game_ID (Game_ID_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "GetGameListStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetGameListStart::~GetGameListStart() {
}

inline GetGameListStart& GetGameListStart::operator = (const GetGameListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasTEAM_ID()) {
            setTEAM_ID(rhs.getTEAM_ID());
        } else {
            clearTEAM_ID();
        }
        if (rhs.hasGameType()) {
            setGameType(rhs.getGameType());
        } else {
            clearGameType();
        }
        if (rhs.hasGame_ID()) {
            setGame_ID(rhs.getGame_ID());
        } else {
            clearGame_ID();
        }
    }
    return *this;
}

inline bool GetGameListStart::operator == (const GetGameListStart& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasTEAM_ID() && !rhs.hasTEAM_ID()) || getTEAM_ID() == rhs.getTEAM_ID()) &&
        ((!hasGameType() && !rhs.hasGameType()) || getGameType() == rhs.getGameType()) &&
        ((!hasGame_ID() && !rhs.hasGame_ID()) || getGame_ID() == rhs.getGame_ID()));
}

inline bool GetGameListStart::operator != (const GetGameListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetGameListStart::operator < (const GetGameListStart& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasTEAM_ID() || rhs.hasTEAM_ID()) {
        if (getTEAM_ID() < rhs.getTEAM_ID()) return true;
        if (getTEAM_ID() > rhs.getTEAM_ID()) return false;
    }
    if (hasGameType() || rhs.hasGameType()) {
        if ((uint32)getGameType() < (uint32)rhs.getGameType()) return true;
        if ((uint32)getGameType() > (uint32)rhs.getGameType()) return false;
    }
    if (hasGame_ID() || rhs.hasGame_ID()) {
        if (getGame_ID() < rhs.getGame_ID()) return true;
        if (getGame_ID() > rhs.getGame_ID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetGameListStart::clone() {
    return new GetGameListStart(*this);
}

inline bool GetGameListStart::operator > (const GetGameListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetGameListStart::clear() {
    clearSportID();
    clearAFFILIATE_ID();
    clearTEAM_ID();
    clearGameType();
    clearGame_ID();
}

inline void GetGameListStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetGameListStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetGameListStart::getSportID () const {
    return _SportID;
}

inline void GetGameListStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetGameListStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetGameListStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetGameListStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetGameListStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetGameListStart::clearTEAM_ID() {
    if (hasTEAM_ID()) {
         clear_has_TEAM_ID();
        _TEAM_ID = 0u;
     }
}

inline bool GetGameListStart::hasTEAM_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetGameListStart::getTEAM_ID () const {
    return _TEAM_ID;
}

inline void GetGameListStart::setTEAM_ID (uint32 TEAM_ID_) {
    set_has_TEAM_ID();
    this->_TEAM_ID = TEAM_ID_;
}

inline void GetGameListStart::clearGameType() {
    if (hasGameType()) {
         clear_has_GameType();
        _GameType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool GetGameListStart::hasGameType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::sxm_sports_main_fi_types::T_GameType GetGameListStart::getGameType () const {
    return _GameType;
}

inline void GetGameListStart::setGameType (::sxm_sports_main_fi_types::T_GameType GameType_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(GameType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GameType_, "T_GameType", "GameType", "GetGameListStart");
    }
    #endif
    set_has_GameType();
    this->_GameType = GameType_;
}

inline void GetGameListStart::clearGame_ID() {
    if (hasGame_ID()) {
         clear_has_Game_ID();
        _Game_ID = 0u;
     }
}

inline bool GetGameListStart::hasGame_ID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 GetGameListStart::getGame_ID () const {
    return _Game_ID;
}

inline void GetGameListStart::setGame_ID (uint32 Game_ID_) {
    set_has_Game_ID();
    this->_Game_ID = Game_ID_;
}

inline void GetGameListStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetGameListStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetGameListStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetGameListStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetGameListStart::set_has_TEAM_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetGameListStart::clear_has_TEAM_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetGameListStart::set_has_GameType () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetGameListStart::clear_has_GameType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetGameListStart::set_has_Game_ID () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetGameListStart::clear_has_Game_ID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetGameListResult::GetGameListResult ()  :
    _GameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetGameListResult::GetGameListResult (const GetGameListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _GameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetGameListResult::GetGameListResult (const ::sxm_sports_main_fi_types::T_GameList& GameList_)  :
    _GameList (GameList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetGameListResult::~GetGameListResult() {
}

inline GetGameListResult& GetGameListResult::operator = (const GetGameListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGameList()) {
            setGameList(rhs.getGameList());
        } else {
            clearGameList();
        }
    }
    return *this;
}

inline bool GetGameListResult::operator == (const GetGameListResult& rhs) const {
    return (((!hasGameList() && !rhs.hasGameList()) || getGameList() == rhs.getGameList()));
}

inline bool GetGameListResult::operator != (const GetGameListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetGameListResult::operator < (const GetGameListResult& rhs) const {
    if (hasGameList() || rhs.hasGameList()) {
        if (getGameList() < rhs.getGameList()) return true;
        if (getGameList() > rhs.getGameList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetGameListResult::clone() {
    return new GetGameListResult(*this);
}

inline bool GetGameListResult::operator > (const GetGameListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetGameListResult::clear() {
    clearGameList();
}

inline void GetGameListResult::clearGameList() {
    if (hasGameList()) {
         clear_has_GameList();
        _GameList.clear();
     }
}

inline bool GetGameListResult::hasGameList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_GameList& GetGameListResult::getGameList () const {
    return _GameList;
}

inline ::sxm_sports_main_fi_types::T_GameList& GetGameListResult::getGameListMutable () {
    set_has_GameList();
    return _GameList;
}

inline void GetGameListResult::setGameList (const ::sxm_sports_main_fi_types::T_GameList& GameList_) {
    set_has_GameList();
    this->_GameList = GameList_;
}

inline void GetGameListResult::set_has_GameList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetGameListResult::clear_has_GameList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetGameListErrorStructure::GetGameListErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetGameListErrorStructure::GetGameListErrorStructure (const GetGameListErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetGameListErrorStructure::GetGameListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetGameListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetGameListErrorStructure::~GetGameListErrorStructure() {
}

inline GetGameListErrorStructure& GetGameListErrorStructure::operator = (const GetGameListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetGameListErrorStructure::operator == (const GetGameListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetGameListErrorStructure::operator != (const GetGameListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetGameListErrorStructure::operator < (const GetGameListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetGameListErrorStructure::operator > (const GetGameListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetGameListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetGameListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetGameListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetGameListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetGameListErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetGameListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetGameListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetGameListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetGameListError::GetGameListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetGameListError::GetGameListError (const GetGameListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetGameListError::~GetGameListError() {
    deleteData ();
}

inline GetGameListError& GetGameListError::operator = (const GetGameListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetGameListError::operator == (const GetGameListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetGameListError::operator != (const GetGameListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetGameListError::operator < (const GetGameListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetGameListError::operator > (const GetGameListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetGameListError::GetGameListErrorField GetGameListError::getField () const {
    return __field;
}

inline void GetGameListError::setField(GetGameListError::GetGameListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetGameListError::clone() {
    return new GetGameListError(*this);
}

inline bool GetGameListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetGameListErrorStructure& GetGameListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetGameListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetGameListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetGameListErrorStructure& GetGameListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetGameListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetGameListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetGameListErrorStructure* GetGameListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetGameListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetGameListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetGameListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetGameListError::replaceCcaErrorCode (GetGameListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetGameListError::setCcaErrorCode (const GetGameListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetGameListErrorStructure(value);
    }
}

inline bool GetGameListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetGameListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetGameListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetGameListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetGameListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetGameListError::cloneData (const GetGameListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetGameListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetGameListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetGameListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetNewsDetailsStart::GetNewsDetailsStart ()  :
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNewsDetailsStart::GetNewsDetailsStart (const GetNewsDetailsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNewsDetailsStart::GetNewsDetailsStart (uint32 AFFILIATE_ID_, uint8 SportID_)  :
    _AFFILIATE_ID (AFFILIATE_ID_),
    _SportID (SportID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNewsDetailsStart::~GetNewsDetailsStart() {
}

inline GetNewsDetailsStart& GetNewsDetailsStart::operator = (const GetNewsDetailsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
    }
    return *this;
}

inline bool GetNewsDetailsStart::operator == (const GetNewsDetailsStart& rhs) const {
    return (((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()));
}

inline bool GetNewsDetailsStart::operator != (const GetNewsDetailsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNewsDetailsStart::operator < (const GetNewsDetailsStart& rhs) const {
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNewsDetailsStart::clone() {
    return new GetNewsDetailsStart(*this);
}

inline bool GetNewsDetailsStart::operator > (const GetNewsDetailsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNewsDetailsStart::clear() {
    clearAFFILIATE_ID();
    clearSportID();
}

inline void GetNewsDetailsStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetNewsDetailsStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetNewsDetailsStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetNewsDetailsStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetNewsDetailsStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetNewsDetailsStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetNewsDetailsStart::getSportID () const {
    return _SportID;
}

inline void GetNewsDetailsStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetNewsDetailsStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNewsDetailsStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetNewsDetailsStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetNewsDetailsStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetNewsDetailsResult::GetNewsDetailsResult ()  :
    _News ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNewsDetailsResult::GetNewsDetailsResult (const GetNewsDetailsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _News ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNewsDetailsResult::GetNewsDetailsResult (const ::sxm_sports_main_fi_types::T_NewsList& News_)  :
    _News (News_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNewsDetailsResult::~GetNewsDetailsResult() {
}

inline GetNewsDetailsResult& GetNewsDetailsResult::operator = (const GetNewsDetailsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNews()) {
            setNews(rhs.getNews());
        } else {
            clearNews();
        }
    }
    return *this;
}

inline bool GetNewsDetailsResult::operator == (const GetNewsDetailsResult& rhs) const {
    return (((!hasNews() && !rhs.hasNews()) || getNews() == rhs.getNews()));
}

inline bool GetNewsDetailsResult::operator != (const GetNewsDetailsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNewsDetailsResult::operator < (const GetNewsDetailsResult& rhs) const {
    if (hasNews() || rhs.hasNews()) {
        if (getNews() < rhs.getNews()) return true;
        if (getNews() > rhs.getNews()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNewsDetailsResult::clone() {
    return new GetNewsDetailsResult(*this);
}

inline bool GetNewsDetailsResult::operator > (const GetNewsDetailsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNewsDetailsResult::clear() {
    clearNews();
}

inline void GetNewsDetailsResult::clearNews() {
    if (hasNews()) {
         clear_has_News();
        _News.clear();
     }
}

inline bool GetNewsDetailsResult::hasNews () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_NewsList& GetNewsDetailsResult::getNews () const {
    return _News;
}

inline ::sxm_sports_main_fi_types::T_NewsList& GetNewsDetailsResult::getNewsMutable () {
    set_has_News();
    return _News;
}

inline void GetNewsDetailsResult::setNews (const ::sxm_sports_main_fi_types::T_NewsList& News_) {
    set_has_News();
    this->_News = News_;
}

inline void GetNewsDetailsResult::set_has_News () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNewsDetailsResult::clear_has_News () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNewsDetailsErrorStructure::GetNewsDetailsErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNewsDetailsErrorStructure::GetNewsDetailsErrorStructure (const GetNewsDetailsErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNewsDetailsErrorStructure::GetNewsDetailsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetNewsDetailsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNewsDetailsErrorStructure::~GetNewsDetailsErrorStructure() {
}

inline GetNewsDetailsErrorStructure& GetNewsDetailsErrorStructure::operator = (const GetNewsDetailsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetNewsDetailsErrorStructure::operator == (const GetNewsDetailsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetNewsDetailsErrorStructure::operator != (const GetNewsDetailsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNewsDetailsErrorStructure::operator < (const GetNewsDetailsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetNewsDetailsErrorStructure::operator > (const GetNewsDetailsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNewsDetailsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetNewsDetailsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetNewsDetailsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetNewsDetailsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetNewsDetailsErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetNewsDetailsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetNewsDetailsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNewsDetailsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNewsDetailsError::GetNewsDetailsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetNewsDetailsError::GetNewsDetailsError (const GetNewsDetailsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetNewsDetailsError::~GetNewsDetailsError() {
    deleteData ();
}

inline GetNewsDetailsError& GetNewsDetailsError::operator = (const GetNewsDetailsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetNewsDetailsError::operator == (const GetNewsDetailsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetNewsDetailsError::operator != (const GetNewsDetailsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNewsDetailsError::operator < (const GetNewsDetailsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetNewsDetailsError::operator > (const GetNewsDetailsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetNewsDetailsError::GetNewsDetailsErrorField GetNewsDetailsError::getField () const {
    return __field;
}

inline void GetNewsDetailsError::setField(GetNewsDetailsError::GetNewsDetailsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetNewsDetailsError::clone() {
    return new GetNewsDetailsError(*this);
}

inline bool GetNewsDetailsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetNewsDetailsErrorStructure& GetNewsDetailsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetNewsDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetNewsDetailsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetNewsDetailsErrorStructure& GetNewsDetailsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetNewsDetailsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetNewsDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetNewsDetailsErrorStructure* GetNewsDetailsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetNewsDetailsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetNewsDetailsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetNewsDetailsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetNewsDetailsError::replaceCcaErrorCode (GetNewsDetailsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetNewsDetailsError::setCcaErrorCode (const GetNewsDetailsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetNewsDetailsErrorStructure(value);
    }
}

inline bool GetNewsDetailsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetNewsDetailsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetNewsDetailsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetNewsDetailsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetNewsDetailsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetNewsDetailsError::cloneData (const GetNewsDetailsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetNewsDetailsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetNewsDetailsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetNewsDetailsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetTopTeamsStart::GetTopTeamsStart ()  :
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTopTeamsStart::GetTopTeamsStart (const GetTopTeamsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTopTeamsStart::GetTopTeamsStart (uint32 AFFILIATE_ID_, uint8 SportID_)  :
    _AFFILIATE_ID (AFFILIATE_ID_),
    _SportID (SportID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTopTeamsStart::~GetTopTeamsStart() {
}

inline GetTopTeamsStart& GetTopTeamsStart::operator = (const GetTopTeamsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
    }
    return *this;
}

inline bool GetTopTeamsStart::operator == (const GetTopTeamsStart& rhs) const {
    return (((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()));
}

inline bool GetTopTeamsStart::operator != (const GetTopTeamsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTopTeamsStart::operator < (const GetTopTeamsStart& rhs) const {
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTopTeamsStart::clone() {
    return new GetTopTeamsStart(*this);
}

inline bool GetTopTeamsStart::operator > (const GetTopTeamsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTopTeamsStart::clear() {
    clearAFFILIATE_ID();
    clearSportID();
}

inline void GetTopTeamsStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetTopTeamsStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetTopTeamsStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetTopTeamsStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetTopTeamsStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetTopTeamsStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetTopTeamsStart::getSportID () const {
    return _SportID;
}

inline void GetTopTeamsStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetTopTeamsStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTopTeamsStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetTopTeamsStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetTopTeamsStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetTopTeamsResult::GetTopTeamsResult ()  :
    _TeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTopTeamsResult::GetTopTeamsResult (const GetTopTeamsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTopTeamsResult::GetTopTeamsResult (const ::sxm_sports_main_fi_types::T_TeamList& TeamList_)  :
    _TeamList (TeamList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTopTeamsResult::~GetTopTeamsResult() {
}

inline GetTopTeamsResult& GetTopTeamsResult::operator = (const GetTopTeamsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTeamList()) {
            setTeamList(rhs.getTeamList());
        } else {
            clearTeamList();
        }
    }
    return *this;
}

inline bool GetTopTeamsResult::operator == (const GetTopTeamsResult& rhs) const {
    return (((!hasTeamList() && !rhs.hasTeamList()) || getTeamList() == rhs.getTeamList()));
}

inline bool GetTopTeamsResult::operator != (const GetTopTeamsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTopTeamsResult::operator < (const GetTopTeamsResult& rhs) const {
    if (hasTeamList() || rhs.hasTeamList()) {
        if (getTeamList() < rhs.getTeamList()) return true;
        if (getTeamList() > rhs.getTeamList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetTopTeamsResult::clone() {
    return new GetTopTeamsResult(*this);
}

inline bool GetTopTeamsResult::operator > (const GetTopTeamsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTopTeamsResult::clear() {
    clearTeamList();
}

inline void GetTopTeamsResult::clearTeamList() {
    if (hasTeamList()) {
         clear_has_TeamList();
        _TeamList.clear();
     }
}

inline bool GetTopTeamsResult::hasTeamList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_TeamList& GetTopTeamsResult::getTeamList () const {
    return _TeamList;
}

inline ::sxm_sports_main_fi_types::T_TeamList& GetTopTeamsResult::getTeamListMutable () {
    set_has_TeamList();
    return _TeamList;
}

inline void GetTopTeamsResult::setTeamList (const ::sxm_sports_main_fi_types::T_TeamList& TeamList_) {
    set_has_TeamList();
    this->_TeamList = TeamList_;
}

inline void GetTopTeamsResult::set_has_TeamList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTopTeamsResult::clear_has_TeamList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTopTeamsErrorStructure::GetTopTeamsErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetTopTeamsErrorStructure::GetTopTeamsErrorStructure (const GetTopTeamsErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetTopTeamsErrorStructure::GetTopTeamsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetTopTeamsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetTopTeamsErrorStructure::~GetTopTeamsErrorStructure() {
}

inline GetTopTeamsErrorStructure& GetTopTeamsErrorStructure::operator = (const GetTopTeamsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetTopTeamsErrorStructure::operator == (const GetTopTeamsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetTopTeamsErrorStructure::operator != (const GetTopTeamsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTopTeamsErrorStructure::operator < (const GetTopTeamsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetTopTeamsErrorStructure::operator > (const GetTopTeamsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetTopTeamsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetTopTeamsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetTopTeamsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetTopTeamsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetTopTeamsErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetTopTeamsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetTopTeamsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetTopTeamsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetTopTeamsError::GetTopTeamsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetTopTeamsError::GetTopTeamsError (const GetTopTeamsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetTopTeamsError::~GetTopTeamsError() {
    deleteData ();
}

inline GetTopTeamsError& GetTopTeamsError::operator = (const GetTopTeamsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetTopTeamsError::operator == (const GetTopTeamsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetTopTeamsError::operator != (const GetTopTeamsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetTopTeamsError::operator < (const GetTopTeamsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetTopTeamsError::operator > (const GetTopTeamsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetTopTeamsError::GetTopTeamsErrorField GetTopTeamsError::getField () const {
    return __field;
}

inline void GetTopTeamsError::setField(GetTopTeamsError::GetTopTeamsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetTopTeamsError::clone() {
    return new GetTopTeamsError(*this);
}

inline bool GetTopTeamsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetTopTeamsErrorStructure& GetTopTeamsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTopTeamsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetTopTeamsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTopTeamsErrorStructure& GetTopTeamsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetTopTeamsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTopTeamsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetTopTeamsErrorStructure* GetTopTeamsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetTopTeamsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetTopTeamsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetTopTeamsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetTopTeamsError::replaceCcaErrorCode (GetTopTeamsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetTopTeamsError::setCcaErrorCode (const GetTopTeamsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetTopTeamsErrorStructure(value);
    }
}

inline bool GetTopTeamsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetTopTeamsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetTopTeamsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetTopTeamsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetTopTeamsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetTopTeamsError::cloneData (const GetTopTeamsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetTopTeamsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetTopTeamsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetTopTeamsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetAllTeamsStart::GetAllTeamsStart ()  :
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAllTeamsStart::GetAllTeamsStart (const GetAllTeamsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AFFILIATE_ID (0u),
    _SportID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAllTeamsStart::GetAllTeamsStart (uint32 AFFILIATE_ID_, uint8 SportID_)  :
    _AFFILIATE_ID (AFFILIATE_ID_),
    _SportID (SportID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAllTeamsStart::~GetAllTeamsStart() {
}

inline GetAllTeamsStart& GetAllTeamsStart::operator = (const GetAllTeamsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
    }
    return *this;
}

inline bool GetAllTeamsStart::operator == (const GetAllTeamsStart& rhs) const {
    return (((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()));
}

inline bool GetAllTeamsStart::operator != (const GetAllTeamsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllTeamsStart::operator < (const GetAllTeamsStart& rhs) const {
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAllTeamsStart::clone() {
    return new GetAllTeamsStart(*this);
}

inline bool GetAllTeamsStart::operator > (const GetAllTeamsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAllTeamsStart::clear() {
    clearAFFILIATE_ID();
    clearSportID();
}

inline void GetAllTeamsStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetAllTeamsStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetAllTeamsStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetAllTeamsStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetAllTeamsStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetAllTeamsStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetAllTeamsStart::getSportID () const {
    return _SportID;
}

inline void GetAllTeamsStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetAllTeamsStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAllTeamsStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetAllTeamsStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetAllTeamsStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetAllTeamsResult::GetAllTeamsResult ()  :
    _AllTeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAllTeamsResult::GetAllTeamsResult (const GetAllTeamsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _AllTeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAllTeamsResult::GetAllTeamsResult (const ::sxm_sports_main_fi_types::T_TeamList& AllTeamList_)  :
    _AllTeamList (AllTeamList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAllTeamsResult::~GetAllTeamsResult() {
}

inline GetAllTeamsResult& GetAllTeamsResult::operator = (const GetAllTeamsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAllTeamList()) {
            setAllTeamList(rhs.getAllTeamList());
        } else {
            clearAllTeamList();
        }
    }
    return *this;
}

inline bool GetAllTeamsResult::operator == (const GetAllTeamsResult& rhs) const {
    return (((!hasAllTeamList() && !rhs.hasAllTeamList()) || getAllTeamList() == rhs.getAllTeamList()));
}

inline bool GetAllTeamsResult::operator != (const GetAllTeamsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllTeamsResult::operator < (const GetAllTeamsResult& rhs) const {
    if (hasAllTeamList() || rhs.hasAllTeamList()) {
        if (getAllTeamList() < rhs.getAllTeamList()) return true;
        if (getAllTeamList() > rhs.getAllTeamList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetAllTeamsResult::clone() {
    return new GetAllTeamsResult(*this);
}

inline bool GetAllTeamsResult::operator > (const GetAllTeamsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAllTeamsResult::clear() {
    clearAllTeamList();
}

inline void GetAllTeamsResult::clearAllTeamList() {
    if (hasAllTeamList()) {
         clear_has_AllTeamList();
        _AllTeamList.clear();
     }
}

inline bool GetAllTeamsResult::hasAllTeamList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_TeamList& GetAllTeamsResult::getAllTeamList () const {
    return _AllTeamList;
}

inline ::sxm_sports_main_fi_types::T_TeamList& GetAllTeamsResult::getAllTeamListMutable () {
    set_has_AllTeamList();
    return _AllTeamList;
}

inline void GetAllTeamsResult::setAllTeamList (const ::sxm_sports_main_fi_types::T_TeamList& AllTeamList_) {
    set_has_AllTeamList();
    this->_AllTeamList = AllTeamList_;
}

inline void GetAllTeamsResult::set_has_AllTeamList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAllTeamsResult::clear_has_AllTeamList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAllTeamsErrorStructure::GetAllTeamsErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetAllTeamsErrorStructure::GetAllTeamsErrorStructure (const GetAllTeamsErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetAllTeamsErrorStructure::GetAllTeamsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetAllTeamsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetAllTeamsErrorStructure::~GetAllTeamsErrorStructure() {
}

inline GetAllTeamsErrorStructure& GetAllTeamsErrorStructure::operator = (const GetAllTeamsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetAllTeamsErrorStructure::operator == (const GetAllTeamsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetAllTeamsErrorStructure::operator != (const GetAllTeamsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllTeamsErrorStructure::operator < (const GetAllTeamsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetAllTeamsErrorStructure::operator > (const GetAllTeamsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetAllTeamsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetAllTeamsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetAllTeamsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetAllTeamsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetAllTeamsErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetAllTeamsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetAllTeamsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetAllTeamsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetAllTeamsError::GetAllTeamsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetAllTeamsError::GetAllTeamsError (const GetAllTeamsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetAllTeamsError::~GetAllTeamsError() {
    deleteData ();
}

inline GetAllTeamsError& GetAllTeamsError::operator = (const GetAllTeamsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetAllTeamsError::operator == (const GetAllTeamsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetAllTeamsError::operator != (const GetAllTeamsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetAllTeamsError::operator < (const GetAllTeamsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetAllTeamsError::operator > (const GetAllTeamsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetAllTeamsError::GetAllTeamsErrorField GetAllTeamsError::getField () const {
    return __field;
}

inline void GetAllTeamsError::setField(GetAllTeamsError::GetAllTeamsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetAllTeamsError::clone() {
    return new GetAllTeamsError(*this);
}

inline bool GetAllTeamsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetAllTeamsErrorStructure& GetAllTeamsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetAllTeamsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetAllTeamsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetAllTeamsErrorStructure& GetAllTeamsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetAllTeamsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetAllTeamsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetAllTeamsErrorStructure* GetAllTeamsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetAllTeamsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetAllTeamsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetAllTeamsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetAllTeamsError::replaceCcaErrorCode (GetAllTeamsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetAllTeamsError::setCcaErrorCode (const GetAllTeamsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetAllTeamsErrorStructure(value);
    }
}

inline bool GetAllTeamsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetAllTeamsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetAllTeamsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetAllTeamsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetAllTeamsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetAllTeamsError::cloneData (const GetAllTeamsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetAllTeamsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetAllTeamsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetAllTeamsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetFavoritesResult::GetFavoritesResult ()  :
    _FavoriteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoritesResult::GetFavoritesResult (const GetFavoritesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _FavoriteList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoritesResult::GetFavoritesResult (const ::sxm_sports_main_fi_types::T_FavoriteList& FavoriteList_)  :
    _FavoriteList (FavoriteList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoritesResult::~GetFavoritesResult() {
}

inline GetFavoritesResult& GetFavoritesResult::operator = (const GetFavoritesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFavoriteList()) {
            setFavoriteList(rhs.getFavoriteList());
        } else {
            clearFavoriteList();
        }
    }
    return *this;
}

inline bool GetFavoritesResult::operator == (const GetFavoritesResult& rhs) const {
    return (((!hasFavoriteList() && !rhs.hasFavoriteList()) || getFavoriteList() == rhs.getFavoriteList()));
}

inline bool GetFavoritesResult::operator != (const GetFavoritesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoritesResult::operator < (const GetFavoritesResult& rhs) const {
    if (hasFavoriteList() || rhs.hasFavoriteList()) {
        if (getFavoriteList() < rhs.getFavoriteList()) return true;
        if (getFavoriteList() > rhs.getFavoriteList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFavoritesResult::clone() {
    return new GetFavoritesResult(*this);
}

inline bool GetFavoritesResult::operator > (const GetFavoritesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoritesResult::clear() {
    clearFavoriteList();
}

inline void GetFavoritesResult::clearFavoriteList() {
    if (hasFavoriteList()) {
         clear_has_FavoriteList();
        _FavoriteList.clear();
     }
}

inline bool GetFavoritesResult::hasFavoriteList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_FavoriteList& GetFavoritesResult::getFavoriteList () const {
    return _FavoriteList;
}

inline ::sxm_sports_main_fi_types::T_FavoriteList& GetFavoritesResult::getFavoriteListMutable () {
    set_has_FavoriteList();
    return _FavoriteList;
}

inline void GetFavoritesResult::setFavoriteList (const ::sxm_sports_main_fi_types::T_FavoriteList& FavoriteList_) {
    set_has_FavoriteList();
    this->_FavoriteList = FavoriteList_;
}

inline void GetFavoritesResult::set_has_FavoriteList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoritesResult::clear_has_FavoriteList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoritesErrorStructure::GetFavoritesErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFavoritesErrorStructure::GetFavoritesErrorStructure (const GetFavoritesErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFavoritesErrorStructure::GetFavoritesErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetFavoritesErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFavoritesErrorStructure::~GetFavoritesErrorStructure() {
}

inline GetFavoritesErrorStructure& GetFavoritesErrorStructure::operator = (const GetFavoritesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetFavoritesErrorStructure::operator == (const GetFavoritesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetFavoritesErrorStructure::operator != (const GetFavoritesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoritesErrorStructure::operator < (const GetFavoritesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetFavoritesErrorStructure::operator > (const GetFavoritesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFavoritesErrorStructure::clear() {
    clearErrorCode();
}

inline void GetFavoritesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetFavoritesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetFavoritesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetFavoritesErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetFavoritesErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetFavoritesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFavoritesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFavoritesError::GetFavoritesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetFavoritesError::GetFavoritesError (const GetFavoritesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetFavoritesError::~GetFavoritesError() {
    deleteData ();
}

inline GetFavoritesError& GetFavoritesError::operator = (const GetFavoritesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetFavoritesError::operator == (const GetFavoritesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetFavoritesError::operator != (const GetFavoritesError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFavoritesError::operator < (const GetFavoritesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetFavoritesError::operator > (const GetFavoritesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetFavoritesError::GetFavoritesErrorField GetFavoritesError::getField () const {
    return __field;
}

inline void GetFavoritesError::setField(GetFavoritesError::GetFavoritesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetFavoritesError::clone() {
    return new GetFavoritesError(*this);
}

inline bool GetFavoritesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetFavoritesErrorStructure& GetFavoritesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoritesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetFavoritesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoritesErrorStructure& GetFavoritesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFavoritesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoritesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFavoritesErrorStructure* GetFavoritesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetFavoritesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFavoritesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetFavoritesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetFavoritesError::replaceCcaErrorCode (GetFavoritesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetFavoritesError::setCcaErrorCode (const GetFavoritesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetFavoritesErrorStructure(value);
    }
}

inline bool GetFavoritesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetFavoritesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetFavoritesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetFavoritesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetFavoritesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetFavoritesError::cloneData (const GetFavoritesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetFavoritesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetFavoritesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetFavoritesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetAsFavoriteStart::SetAsFavoriteStart ()  :
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _TEAM_ID (0u),
    _FavoriteControl (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAsFavoriteStart::SetAsFavoriteStart (const SetAsFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _TEAM_ID (0u),
    _FavoriteControl (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAsFavoriteStart::SetAsFavoriteStart (uint8 SportID_, uint32 AFFILIATE_ID_, uint32 TEAM_ID_, bool FavoriteControl_)  :
    _SportID (SportID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _TEAM_ID (TEAM_ID_),
    _FavoriteControl (FavoriteControl_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAsFavoriteStart::~SetAsFavoriteStart() {
}

inline SetAsFavoriteStart& SetAsFavoriteStart::operator = (const SetAsFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasTEAM_ID()) {
            setTEAM_ID(rhs.getTEAM_ID());
        } else {
            clearTEAM_ID();
        }
        if (rhs.hasFavoriteControl()) {
            setFavoriteControl(rhs.getFavoriteControl());
        } else {
            clearFavoriteControl();
        }
    }
    return *this;
}

inline bool SetAsFavoriteStart::operator == (const SetAsFavoriteStart& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasTEAM_ID() && !rhs.hasTEAM_ID()) || getTEAM_ID() == rhs.getTEAM_ID()) &&
        ((!hasFavoriteControl() && !rhs.hasFavoriteControl()) || getFavoriteControl() == rhs.getFavoriteControl()));
}

inline bool SetAsFavoriteStart::operator != (const SetAsFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAsFavoriteStart::operator < (const SetAsFavoriteStart& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasTEAM_ID() || rhs.hasTEAM_ID()) {
        if (getTEAM_ID() < rhs.getTEAM_ID()) return true;
        if (getTEAM_ID() > rhs.getTEAM_ID()) return false;
    }
    if (hasFavoriteControl() || rhs.hasFavoriteControl()) {
        if (getFavoriteControl() < rhs.getFavoriteControl()) return true;
        if (getFavoriteControl() > rhs.getFavoriteControl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAsFavoriteStart::clone() {
    return new SetAsFavoriteStart(*this);
}

inline bool SetAsFavoriteStart::operator > (const SetAsFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAsFavoriteStart::clear() {
    clearSportID();
    clearAFFILIATE_ID();
    clearTEAM_ID();
    clearFavoriteControl();
}

inline void SetAsFavoriteStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool SetAsFavoriteStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetAsFavoriteStart::getSportID () const {
    return _SportID;
}

inline void SetAsFavoriteStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void SetAsFavoriteStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool SetAsFavoriteStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SetAsFavoriteStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void SetAsFavoriteStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void SetAsFavoriteStart::clearTEAM_ID() {
    if (hasTEAM_ID()) {
         clear_has_TEAM_ID();
        _TEAM_ID = 0u;
     }
}

inline bool SetAsFavoriteStart::hasTEAM_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SetAsFavoriteStart::getTEAM_ID () const {
    return _TEAM_ID;
}

inline void SetAsFavoriteStart::setTEAM_ID (uint32 TEAM_ID_) {
    set_has_TEAM_ID();
    this->_TEAM_ID = TEAM_ID_;
}

inline void SetAsFavoriteStart::clearFavoriteControl() {
    if (hasFavoriteControl()) {
         clear_has_FavoriteControl();
        _FavoriteControl = false;
     }
}

inline bool SetAsFavoriteStart::hasFavoriteControl () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool SetAsFavoriteStart::getFavoriteControl () const {
    return _FavoriteControl;
}

inline void SetAsFavoriteStart::setFavoriteControl (bool FavoriteControl_) {
    set_has_FavoriteControl();
    this->_FavoriteControl = FavoriteControl_;
}

inline void SetAsFavoriteStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAsFavoriteStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetAsFavoriteStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetAsFavoriteStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetAsFavoriteStart::set_has_TEAM_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetAsFavoriteStart::clear_has_TEAM_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetAsFavoriteStart::set_has_FavoriteControl () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetAsFavoriteStart::clear_has_FavoriteControl () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SetAsFavoriteResult::SetAsFavoriteResult ()  :
    _Result (false),
    _FavoriteControl (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAsFavoriteResult::SetAsFavoriteResult (const SetAsFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (false),
    _FavoriteControl (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAsFavoriteResult::SetAsFavoriteResult (bool Result_, bool FavoriteControl_)  :
    _Result (Result_),
    _FavoriteControl (FavoriteControl_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAsFavoriteResult::~SetAsFavoriteResult() {
}

inline SetAsFavoriteResult& SetAsFavoriteResult::operator = (const SetAsFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasFavoriteControl()) {
            setFavoriteControl(rhs.getFavoriteControl());
        } else {
            clearFavoriteControl();
        }
    }
    return *this;
}

inline bool SetAsFavoriteResult::operator == (const SetAsFavoriteResult& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasFavoriteControl() && !rhs.hasFavoriteControl()) || getFavoriteControl() == rhs.getFavoriteControl()));
}

inline bool SetAsFavoriteResult::operator != (const SetAsFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAsFavoriteResult::operator < (const SetAsFavoriteResult& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    if (hasFavoriteControl() || rhs.hasFavoriteControl()) {
        if (getFavoriteControl() < rhs.getFavoriteControl()) return true;
        if (getFavoriteControl() > rhs.getFavoriteControl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetAsFavoriteResult::clone() {
    return new SetAsFavoriteResult(*this);
}

inline bool SetAsFavoriteResult::operator > (const SetAsFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAsFavoriteResult::clear() {
    clearResult();
    clearFavoriteControl();
}

inline void SetAsFavoriteResult::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = false;
     }
}

inline bool SetAsFavoriteResult::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetAsFavoriteResult::getResult () const {
    return _Result;
}

inline void SetAsFavoriteResult::setResult (bool Result_) {
    set_has_Result();
    this->_Result = Result_;
}

inline void SetAsFavoriteResult::clearFavoriteControl() {
    if (hasFavoriteControl()) {
         clear_has_FavoriteControl();
        _FavoriteControl = false;
     }
}

inline bool SetAsFavoriteResult::hasFavoriteControl () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetAsFavoriteResult::getFavoriteControl () const {
    return _FavoriteControl;
}

inline void SetAsFavoriteResult::setFavoriteControl (bool FavoriteControl_) {
    set_has_FavoriteControl();
    this->_FavoriteControl = FavoriteControl_;
}

inline void SetAsFavoriteResult::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAsFavoriteResult::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetAsFavoriteResult::set_has_FavoriteControl () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetAsFavoriteResult::clear_has_FavoriteControl () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetAsFavoriteErrorStructure::SetAsFavoriteErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetAsFavoriteErrorStructure::SetAsFavoriteErrorStructure (const SetAsFavoriteErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetAsFavoriteErrorStructure::SetAsFavoriteErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SetAsFavoriteErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetAsFavoriteErrorStructure::~SetAsFavoriteErrorStructure() {
}

inline SetAsFavoriteErrorStructure& SetAsFavoriteErrorStructure::operator = (const SetAsFavoriteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SetAsFavoriteErrorStructure::operator == (const SetAsFavoriteErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SetAsFavoriteErrorStructure::operator != (const SetAsFavoriteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAsFavoriteErrorStructure::operator < (const SetAsFavoriteErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SetAsFavoriteErrorStructure::operator > (const SetAsFavoriteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetAsFavoriteErrorStructure::clear() {
    clearErrorCode();
}

inline void SetAsFavoriteErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool SetAsFavoriteErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes SetAsFavoriteErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SetAsFavoriteErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SetAsFavoriteErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SetAsFavoriteErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetAsFavoriteErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetAsFavoriteError::SetAsFavoriteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetAsFavoriteError::SetAsFavoriteError (const SetAsFavoriteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetAsFavoriteError::~SetAsFavoriteError() {
    deleteData ();
}

inline SetAsFavoriteError& SetAsFavoriteError::operator = (const SetAsFavoriteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetAsFavoriteError::operator == (const SetAsFavoriteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetAsFavoriteError::operator != (const SetAsFavoriteError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetAsFavoriteError::operator < (const SetAsFavoriteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetAsFavoriteError::operator > (const SetAsFavoriteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetAsFavoriteError::SetAsFavoriteErrorField SetAsFavoriteError::getField () const {
    return __field;
}

inline void SetAsFavoriteError::setField(SetAsFavoriteError::SetAsFavoriteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetAsFavoriteError::clone() {
    return new SetAsFavoriteError(*this);
}

inline bool SetAsFavoriteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetAsFavoriteErrorStructure& SetAsFavoriteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetAsFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetAsFavoriteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetAsFavoriteErrorStructure& SetAsFavoriteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetAsFavoriteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetAsFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetAsFavoriteErrorStructure* SetAsFavoriteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetAsFavoriteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetAsFavoriteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetAsFavoriteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetAsFavoriteError::replaceCcaErrorCode (SetAsFavoriteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetAsFavoriteError::setCcaErrorCode (const SetAsFavoriteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetAsFavoriteErrorStructure(value);
    }
}

inline bool SetAsFavoriteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetAsFavoriteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetAsFavoriteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetAsFavoriteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetAsFavoriteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetAsFavoriteError::cloneData (const SetAsFavoriteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetAsFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetAsFavoriteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetAsFavoriteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetScheduledEventsStart::GetScheduledEventsStart ()  :
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Event_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetScheduledEventsStart::GetScheduledEventsStart (const GetScheduledEventsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _Event_ID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetScheduledEventsStart::GetScheduledEventsStart (uint8 SportID_, uint32 AFFILIATE_ID_, ::sxm_sports_main_fi_types::T_GameType EventType_, uint32 Event_ID_)  :
    _SportID (SportID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _EventType (EventType_),
    _Event_ID (Event_ID_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "GetScheduledEventsStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetScheduledEventsStart::~GetScheduledEventsStart() {
}

inline GetScheduledEventsStart& GetScheduledEventsStart::operator = (const GetScheduledEventsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasEventType()) {
            setEventType(rhs.getEventType());
        } else {
            clearEventType();
        }
        if (rhs.hasEvent_ID()) {
            setEvent_ID(rhs.getEvent_ID());
        } else {
            clearEvent_ID();
        }
    }
    return *this;
}

inline bool GetScheduledEventsStart::operator == (const GetScheduledEventsStart& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasEventType() && !rhs.hasEventType()) || getEventType() == rhs.getEventType()) &&
        ((!hasEvent_ID() && !rhs.hasEvent_ID()) || getEvent_ID() == rhs.getEvent_ID()));
}

inline bool GetScheduledEventsStart::operator != (const GetScheduledEventsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetScheduledEventsStart::operator < (const GetScheduledEventsStart& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasEventType() || rhs.hasEventType()) {
        if ((uint32)getEventType() < (uint32)rhs.getEventType()) return true;
        if ((uint32)getEventType() > (uint32)rhs.getEventType()) return false;
    }
    if (hasEvent_ID() || rhs.hasEvent_ID()) {
        if (getEvent_ID() < rhs.getEvent_ID()) return true;
        if (getEvent_ID() > rhs.getEvent_ID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetScheduledEventsStart::clone() {
    return new GetScheduledEventsStart(*this);
}

inline bool GetScheduledEventsStart::operator > (const GetScheduledEventsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetScheduledEventsStart::clear() {
    clearSportID();
    clearAFFILIATE_ID();
    clearEventType();
    clearEvent_ID();
}

inline void GetScheduledEventsStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetScheduledEventsStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetScheduledEventsStart::getSportID () const {
    return _SportID;
}

inline void GetScheduledEventsStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetScheduledEventsStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetScheduledEventsStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetScheduledEventsStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetScheduledEventsStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetScheduledEventsStart::clearEventType() {
    if (hasEventType()) {
         clear_has_EventType();
        _EventType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool GetScheduledEventsStart::hasEventType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sxm_sports_main_fi_types::T_GameType GetScheduledEventsStart::getEventType () const {
    return _EventType;
}

inline void GetScheduledEventsStart::setEventType (::sxm_sports_main_fi_types::T_GameType EventType_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "GetScheduledEventsStart");
    }
    #endif
    set_has_EventType();
    this->_EventType = EventType_;
}

inline void GetScheduledEventsStart::clearEvent_ID() {
    if (hasEvent_ID()) {
         clear_has_Event_ID();
        _Event_ID = 0u;
     }
}

inline bool GetScheduledEventsStart::hasEvent_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 GetScheduledEventsStart::getEvent_ID () const {
    return _Event_ID;
}

inline void GetScheduledEventsStart::setEvent_ID (uint32 Event_ID_) {
    set_has_Event_ID();
    this->_Event_ID = Event_ID_;
}

inline void GetScheduledEventsStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetScheduledEventsStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetScheduledEventsStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetScheduledEventsStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetScheduledEventsStart::set_has_EventType () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetScheduledEventsStart::clear_has_EventType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetScheduledEventsStart::set_has_Event_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetScheduledEventsStart::clear_has_Event_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetScheduledEventsResult::GetScheduledEventsResult ()  :
    _ScheduledEvents ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetScheduledEventsResult::GetScheduledEventsResult (const GetScheduledEventsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ScheduledEvents ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetScheduledEventsResult::GetScheduledEventsResult (const ::sxm_sports_main_fi_types::T_EventSchedule_List& ScheduledEvents_)  :
    _ScheduledEvents (ScheduledEvents_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetScheduledEventsResult::~GetScheduledEventsResult() {
}

inline GetScheduledEventsResult& GetScheduledEventsResult::operator = (const GetScheduledEventsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasScheduledEvents()) {
            setScheduledEvents(rhs.getScheduledEvents());
        } else {
            clearScheduledEvents();
        }
    }
    return *this;
}

inline bool GetScheduledEventsResult::operator == (const GetScheduledEventsResult& rhs) const {
    return (((!hasScheduledEvents() && !rhs.hasScheduledEvents()) || getScheduledEvents() == rhs.getScheduledEvents()));
}

inline bool GetScheduledEventsResult::operator != (const GetScheduledEventsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetScheduledEventsResult::operator < (const GetScheduledEventsResult& rhs) const {
    if (hasScheduledEvents() || rhs.hasScheduledEvents()) {
        if (getScheduledEvents() < rhs.getScheduledEvents()) return true;
        if (getScheduledEvents() > rhs.getScheduledEvents()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetScheduledEventsResult::clone() {
    return new GetScheduledEventsResult(*this);
}

inline bool GetScheduledEventsResult::operator > (const GetScheduledEventsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetScheduledEventsResult::clear() {
    clearScheduledEvents();
}

inline void GetScheduledEventsResult::clearScheduledEvents() {
    if (hasScheduledEvents()) {
         clear_has_ScheduledEvents();
        _ScheduledEvents.clear();
     }
}

inline bool GetScheduledEventsResult::hasScheduledEvents () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_EventSchedule_List& GetScheduledEventsResult::getScheduledEvents () const {
    return _ScheduledEvents;
}

inline ::sxm_sports_main_fi_types::T_EventSchedule_List& GetScheduledEventsResult::getScheduledEventsMutable () {
    set_has_ScheduledEvents();
    return _ScheduledEvents;
}

inline void GetScheduledEventsResult::setScheduledEvents (const ::sxm_sports_main_fi_types::T_EventSchedule_List& ScheduledEvents_) {
    set_has_ScheduledEvents();
    this->_ScheduledEvents = ScheduledEvents_;
}

inline void GetScheduledEventsResult::set_has_ScheduledEvents () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetScheduledEventsResult::clear_has_ScheduledEvents () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetScheduledEventsErrorStructure::GetScheduledEventsErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetScheduledEventsErrorStructure::GetScheduledEventsErrorStructure (const GetScheduledEventsErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetScheduledEventsErrorStructure::GetScheduledEventsErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetScheduledEventsErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetScheduledEventsErrorStructure::~GetScheduledEventsErrorStructure() {
}

inline GetScheduledEventsErrorStructure& GetScheduledEventsErrorStructure::operator = (const GetScheduledEventsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetScheduledEventsErrorStructure::operator == (const GetScheduledEventsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetScheduledEventsErrorStructure::operator != (const GetScheduledEventsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetScheduledEventsErrorStructure::operator < (const GetScheduledEventsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetScheduledEventsErrorStructure::operator > (const GetScheduledEventsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetScheduledEventsErrorStructure::clear() {
    clearErrorCode();
}

inline void GetScheduledEventsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetScheduledEventsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetScheduledEventsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetScheduledEventsErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetScheduledEventsErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetScheduledEventsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetScheduledEventsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetScheduledEventsError::GetScheduledEventsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetScheduledEventsError::GetScheduledEventsError (const GetScheduledEventsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetScheduledEventsError::~GetScheduledEventsError() {
    deleteData ();
}

inline GetScheduledEventsError& GetScheduledEventsError::operator = (const GetScheduledEventsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetScheduledEventsError::operator == (const GetScheduledEventsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetScheduledEventsError::operator != (const GetScheduledEventsError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetScheduledEventsError::operator < (const GetScheduledEventsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetScheduledEventsError::operator > (const GetScheduledEventsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetScheduledEventsError::GetScheduledEventsErrorField GetScheduledEventsError::getField () const {
    return __field;
}

inline void GetScheduledEventsError::setField(GetScheduledEventsError::GetScheduledEventsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetScheduledEventsError::clone() {
    return new GetScheduledEventsError(*this);
}

inline bool GetScheduledEventsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetScheduledEventsErrorStructure& GetScheduledEventsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetScheduledEventsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetScheduledEventsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetScheduledEventsErrorStructure& GetScheduledEventsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetScheduledEventsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetScheduledEventsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetScheduledEventsErrorStructure* GetScheduledEventsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetScheduledEventsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetScheduledEventsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetScheduledEventsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetScheduledEventsError::replaceCcaErrorCode (GetScheduledEventsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetScheduledEventsError::setCcaErrorCode (const GetScheduledEventsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetScheduledEventsErrorStructure(value);
    }
}

inline bool GetScheduledEventsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetScheduledEventsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetScheduledEventsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetScheduledEventsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetScheduledEventsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetScheduledEventsError::cloneData (const GetScheduledEventsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetScheduledEventsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetScheduledEventsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetScheduledEventsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetEventRankListStart::GetEventRankListStart ()  :
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _TableParam (0),
    _TableRef (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetEventRankListStart::GetEventRankListStart (const GetEventRankListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u),
    _AFFILIATE_ID (0u),
    _EventType (::sxm_sports_main_fi_types::T_GameType__Current),
    _TableParam (0),
    _TableRef (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetEventRankListStart::GetEventRankListStart (uint8 SportID_, uint32 AFFILIATE_ID_, ::sxm_sports_main_fi_types::T_GameType EventType_, int32 TableParam_, int32 TableRef_)  :
    _SportID (SportID_),
    _AFFILIATE_ID (AFFILIATE_ID_),
    _EventType (EventType_),
    _TableParam (TableParam_),
    _TableRef (TableRef_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "GetEventRankListStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetEventRankListStart::~GetEventRankListStart() {
}

inline GetEventRankListStart& GetEventRankListStart::operator = (const GetEventRankListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
        if (rhs.hasAFFILIATE_ID()) {
            setAFFILIATE_ID(rhs.getAFFILIATE_ID());
        } else {
            clearAFFILIATE_ID();
        }
        if (rhs.hasEventType()) {
            setEventType(rhs.getEventType());
        } else {
            clearEventType();
        }
        if (rhs.hasTableParam()) {
            setTableParam(rhs.getTableParam());
        } else {
            clearTableParam();
        }
        if (rhs.hasTableRef()) {
            setTableRef(rhs.getTableRef());
        } else {
            clearTableRef();
        }
    }
    return *this;
}

inline bool GetEventRankListStart::operator == (const GetEventRankListStart& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()) &&
        ((!hasAFFILIATE_ID() && !rhs.hasAFFILIATE_ID()) || getAFFILIATE_ID() == rhs.getAFFILIATE_ID()) &&
        ((!hasEventType() && !rhs.hasEventType()) || getEventType() == rhs.getEventType()) &&
        ((!hasTableParam() && !rhs.hasTableParam()) || getTableParam() == rhs.getTableParam()) &&
        ((!hasTableRef() && !rhs.hasTableRef()) || getTableRef() == rhs.getTableRef()));
}

inline bool GetEventRankListStart::operator != (const GetEventRankListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetEventRankListStart::operator < (const GetEventRankListStart& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    if (hasAFFILIATE_ID() || rhs.hasAFFILIATE_ID()) {
        if (getAFFILIATE_ID() < rhs.getAFFILIATE_ID()) return true;
        if (getAFFILIATE_ID() > rhs.getAFFILIATE_ID()) return false;
    }
    if (hasEventType() || rhs.hasEventType()) {
        if ((uint32)getEventType() < (uint32)rhs.getEventType()) return true;
        if ((uint32)getEventType() > (uint32)rhs.getEventType()) return false;
    }
    if (hasTableParam() || rhs.hasTableParam()) {
        if (getTableParam() < rhs.getTableParam()) return true;
        if (getTableParam() > rhs.getTableParam()) return false;
    }
    if (hasTableRef() || rhs.hasTableRef()) {
        if (getTableRef() < rhs.getTableRef()) return true;
        if (getTableRef() > rhs.getTableRef()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetEventRankListStart::clone() {
    return new GetEventRankListStart(*this);
}

inline bool GetEventRankListStart::operator > (const GetEventRankListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetEventRankListStart::clear() {
    clearSportID();
    clearAFFILIATE_ID();
    clearEventType();
    clearTableParam();
    clearTableRef();
}

inline void GetEventRankListStart::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool GetEventRankListStart::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetEventRankListStart::getSportID () const {
    return _SportID;
}

inline void GetEventRankListStart::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void GetEventRankListStart::clearAFFILIATE_ID() {
    if (hasAFFILIATE_ID()) {
         clear_has_AFFILIATE_ID();
        _AFFILIATE_ID = 0u;
     }
}

inline bool GetEventRankListStart::hasAFFILIATE_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetEventRankListStart::getAFFILIATE_ID () const {
    return _AFFILIATE_ID;
}

inline void GetEventRankListStart::setAFFILIATE_ID (uint32 AFFILIATE_ID_) {
    set_has_AFFILIATE_ID();
    this->_AFFILIATE_ID = AFFILIATE_ID_;
}

inline void GetEventRankListStart::clearEventType() {
    if (hasEventType()) {
         clear_has_EventType();
        _EventType = ::sxm_sports_main_fi_types::T_GameType__Current;
     }
}

inline bool GetEventRankListStart::hasEventType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sxm_sports_main_fi_types::T_GameType GetEventRankListStart::getEventType () const {
    return _EventType;
}

inline void GetEventRankListStart::setEventType (::sxm_sports_main_fi_types::T_GameType EventType_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_GameType_IsValid(EventType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", EventType_, "T_GameType", "EventType", "GetEventRankListStart");
    }
    #endif
    set_has_EventType();
    this->_EventType = EventType_;
}

inline void GetEventRankListStart::clearTableParam() {
    if (hasTableParam()) {
         clear_has_TableParam();
        _TableParam = 0;
     }
}

inline bool GetEventRankListStart::hasTableParam () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 GetEventRankListStart::getTableParam () const {
    return _TableParam;
}

inline void GetEventRankListStart::setTableParam (int32 TableParam_) {
    set_has_TableParam();
    this->_TableParam = TableParam_;
}

inline void GetEventRankListStart::clearTableRef() {
    if (hasTableRef()) {
         clear_has_TableRef();
        _TableRef = 0;
     }
}

inline bool GetEventRankListStart::hasTableRef () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 GetEventRankListStart::getTableRef () const {
    return _TableRef;
}

inline void GetEventRankListStart::setTableRef (int32 TableRef_) {
    set_has_TableRef();
    this->_TableRef = TableRef_;
}

inline void GetEventRankListStart::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetEventRankListStart::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetEventRankListStart::set_has_AFFILIATE_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetEventRankListStart::clear_has_AFFILIATE_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetEventRankListStart::set_has_EventType () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetEventRankListStart::clear_has_EventType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetEventRankListStart::set_has_TableParam () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetEventRankListStart::clear_has_TableParam () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetEventRankListStart::set_has_TableRef () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetEventRankListStart::clear_has_TableRef () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetEventRankListResult::GetEventRankListResult ()  :
    _EventInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetEventRankListResult::GetEventRankListResult (const GetEventRankListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _EventInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetEventRankListResult::GetEventRankListResult (const ::sxm_sports_main_fi_types::T_EventRankList& EventInfo_)  :
    _EventInfo (EventInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetEventRankListResult::~GetEventRankListResult() {
}

inline GetEventRankListResult& GetEventRankListResult::operator = (const GetEventRankListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEventInfo()) {
            setEventInfo(rhs.getEventInfo());
        } else {
            clearEventInfo();
        }
    }
    return *this;
}

inline bool GetEventRankListResult::operator == (const GetEventRankListResult& rhs) const {
    return (((!hasEventInfo() && !rhs.hasEventInfo()) || getEventInfo() == rhs.getEventInfo()));
}

inline bool GetEventRankListResult::operator != (const GetEventRankListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetEventRankListResult::operator < (const GetEventRankListResult& rhs) const {
    if (hasEventInfo() || rhs.hasEventInfo()) {
        if (getEventInfo() < rhs.getEventInfo()) return true;
        if (getEventInfo() > rhs.getEventInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetEventRankListResult::clone() {
    return new GetEventRankListResult(*this);
}

inline bool GetEventRankListResult::operator > (const GetEventRankListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetEventRankListResult::clear() {
    clearEventInfo();
}

inline void GetEventRankListResult::clearEventInfo() {
    if (hasEventInfo()) {
         clear_has_EventInfo();
        _EventInfo.clear();
     }
}

inline bool GetEventRankListResult::hasEventInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_sports_main_fi_types::T_EventRankList& GetEventRankListResult::getEventInfo () const {
    return _EventInfo;
}

inline ::sxm_sports_main_fi_types::T_EventRankList& GetEventRankListResult::getEventInfoMutable () {
    set_has_EventInfo();
    return _EventInfo;
}

inline void GetEventRankListResult::setEventInfo (const ::sxm_sports_main_fi_types::T_EventRankList& EventInfo_) {
    set_has_EventInfo();
    this->_EventInfo = EventInfo_;
}

inline void GetEventRankListResult::set_has_EventInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetEventRankListResult::clear_has_EventInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetEventRankListErrorStructure::GetEventRankListErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetEventRankListErrorStructure::GetEventRankListErrorStructure (const GetEventRankListErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetEventRankListErrorStructure::GetEventRankListErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetEventRankListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetEventRankListErrorStructure::~GetEventRankListErrorStructure() {
}

inline GetEventRankListErrorStructure& GetEventRankListErrorStructure::operator = (const GetEventRankListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetEventRankListErrorStructure::operator == (const GetEventRankListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetEventRankListErrorStructure::operator != (const GetEventRankListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetEventRankListErrorStructure::operator < (const GetEventRankListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetEventRankListErrorStructure::operator > (const GetEventRankListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetEventRankListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetEventRankListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool GetEventRankListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes GetEventRankListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetEventRankListErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "GetEventRankListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetEventRankListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetEventRankListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetEventRankListError::GetEventRankListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetEventRankListError::GetEventRankListError (const GetEventRankListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetEventRankListError::~GetEventRankListError() {
    deleteData ();
}

inline GetEventRankListError& GetEventRankListError::operator = (const GetEventRankListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetEventRankListError::operator == (const GetEventRankListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetEventRankListError::operator != (const GetEventRankListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetEventRankListError::operator < (const GetEventRankListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetEventRankListError::operator > (const GetEventRankListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetEventRankListError::GetEventRankListErrorField GetEventRankListError::getField () const {
    return __field;
}

inline void GetEventRankListError::setField(GetEventRankListError::GetEventRankListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetEventRankListError::clone() {
    return new GetEventRankListError(*this);
}

inline bool GetEventRankListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetEventRankListErrorStructure& GetEventRankListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetEventRankListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetEventRankListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetEventRankListErrorStructure& GetEventRankListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetEventRankListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetEventRankListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetEventRankListErrorStructure* GetEventRankListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetEventRankListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetEventRankListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetEventRankListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetEventRankListError::replaceCcaErrorCode (GetEventRankListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetEventRankListError::setCcaErrorCode (const GetEventRankListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetEventRankListErrorStructure(value);
    }
}

inline bool GetEventRankListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetEventRankListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetEventRankListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetEventRankListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetEventRankListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetEventRankListError::cloneData (const GetEventRankListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetEventRankListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetEventRankListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetEventRankListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SportsServiceDataStatusStatus::SportsServiceDataStatusStatus ()  :
    _SportsStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus__SPORTS_SERVICE_DATA_INITIAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SportsServiceDataStatusStatus::SportsServiceDataStatusStatus (const SportsServiceDataStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SportsStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus__SPORTS_SERVICE_DATA_INITIAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SportsServiceDataStatusStatus::SportsServiceDataStatusStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus SportsStatus_)  :
    _SportsStatus (SportsStatus_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus_IsValid(SportsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportsStatus_, "T_e8SportsServiceDataStatus", "SportsStatus", "SportsServiceDataStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SportsServiceDataStatusStatus::~SportsServiceDataStatusStatus() {
}

inline SportsServiceDataStatusStatus& SportsServiceDataStatusStatus::operator = (const SportsServiceDataStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportsStatus()) {
            setSportsStatus(rhs.getSportsStatus());
        } else {
            clearSportsStatus();
        }
    }
    return *this;
}

inline bool SportsServiceDataStatusStatus::operator == (const SportsServiceDataStatusStatus& rhs) const {
    return (((!hasSportsStatus() && !rhs.hasSportsStatus()) || getSportsStatus() == rhs.getSportsStatus()));
}

inline bool SportsServiceDataStatusStatus::operator != (const SportsServiceDataStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsServiceDataStatusStatus::operator < (const SportsServiceDataStatusStatus& rhs) const {
    if (hasSportsStatus() || rhs.hasSportsStatus()) {
        if ((uint32)getSportsStatus() < (uint32)rhs.getSportsStatus()) return true;
        if ((uint32)getSportsStatus() > (uint32)rhs.getSportsStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SportsServiceDataStatusStatus::clone() {
    return new SportsServiceDataStatusStatus(*this);
}

inline bool SportsServiceDataStatusStatus::operator > (const SportsServiceDataStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SportsServiceDataStatusStatus::clear() {
    clearSportsStatus();
}

inline void SportsServiceDataStatusStatus::clearSportsStatus() {
    if (hasSportsStatus()) {
         clear_has_SportsStatus();
        _SportsStatus = ::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus__SPORTS_SERVICE_DATA_INITIAL;
     }
}

inline bool SportsServiceDataStatusStatus::hasSportsStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus SportsServiceDataStatusStatus::getSportsStatus () const {
    return _SportsStatus;
}

inline void SportsServiceDataStatusStatus::setSportsStatus (::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus SportsStatus_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsServiceDataStatus_IsValid(SportsStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SportsStatus_, "T_e8SportsServiceDataStatus", "SportsStatus", "SportsServiceDataStatusStatus");
    }
    #endif
    set_has_SportsStatus();
    this->_SportsStatus = SportsStatus_;
}

inline void SportsServiceDataStatusStatus::set_has_SportsStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SportsServiceDataStatusStatus::clear_has_SportsStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SportsServiceDataStatusErrorStructure::SportsServiceDataStatusErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SportsServiceDataStatusErrorStructure::SportsServiceDataStatusErrorStructure (const SportsServiceDataStatusErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SportsServiceDataStatusErrorStructure::SportsServiceDataStatusErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SportsServiceDataStatusErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SportsServiceDataStatusErrorStructure::~SportsServiceDataStatusErrorStructure() {
}

inline SportsServiceDataStatusErrorStructure& SportsServiceDataStatusErrorStructure::operator = (const SportsServiceDataStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SportsServiceDataStatusErrorStructure::operator == (const SportsServiceDataStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SportsServiceDataStatusErrorStructure::operator != (const SportsServiceDataStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsServiceDataStatusErrorStructure::operator < (const SportsServiceDataStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SportsServiceDataStatusErrorStructure::operator > (const SportsServiceDataStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SportsServiceDataStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void SportsServiceDataStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool SportsServiceDataStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes SportsServiceDataStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SportsServiceDataStatusErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SportsServiceDataStatusErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SportsServiceDataStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SportsServiceDataStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SportsServiceDataStatusError::SportsServiceDataStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SportsServiceDataStatusError::SportsServiceDataStatusError (const SportsServiceDataStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SportsServiceDataStatusError::~SportsServiceDataStatusError() {
    deleteData ();
}

inline SportsServiceDataStatusError& SportsServiceDataStatusError::operator = (const SportsServiceDataStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SportsServiceDataStatusError::operator == (const SportsServiceDataStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SportsServiceDataStatusError::operator != (const SportsServiceDataStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsServiceDataStatusError::operator < (const SportsServiceDataStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SportsServiceDataStatusError::operator > (const SportsServiceDataStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SportsServiceDataStatusError::SportsServiceDataStatusErrorField SportsServiceDataStatusError::getField () const {
    return __field;
}

inline void SportsServiceDataStatusError::setField(SportsServiceDataStatusError::SportsServiceDataStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SportsServiceDataStatusError::clone() {
    return new SportsServiceDataStatusError(*this);
}

inline bool SportsServiceDataStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SportsServiceDataStatusErrorStructure& SportsServiceDataStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SportsServiceDataStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SportsServiceDataStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SportsServiceDataStatusErrorStructure& SportsServiceDataStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SportsServiceDataStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SportsServiceDataStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SportsServiceDataStatusErrorStructure* SportsServiceDataStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SportsServiceDataStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SportsServiceDataStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SportsServiceDataStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SportsServiceDataStatusError::replaceCcaErrorCode (SportsServiceDataStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SportsServiceDataStatusError::setCcaErrorCode (const SportsServiceDataStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SportsServiceDataStatusErrorStructure(value);
    }
}

inline bool SportsServiceDataStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SportsServiceDataStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SportsServiceDataStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SportsServiceDataStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SportsServiceDataStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SportsServiceDataStatusError::cloneData (const SportsServiceDataStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SportsServiceDataStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SportsServiceDataStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SportsServiceDataStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SportsDataUpdateStatus::SportsDataUpdateStatus ()  :
    _SportID (0u),
    _LeagueID (0u),
    _UpdateType (::sxm_sports_main_fi_types::T_SportsUpdateType__Today),
    _UpdateStatus (::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SportsDataUpdateStatus::SportsDataUpdateStatus (const SportsDataUpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SportID (0u),
    _LeagueID (0u),
    _UpdateType (::sxm_sports_main_fi_types::T_SportsUpdateType__Today),
    _UpdateStatus (::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SportsDataUpdateStatus::SportsDataUpdateStatus (uint8 SportID_, uint32 LeagueID_, ::sxm_sports_main_fi_types::T_SportsUpdateType UpdateType_, ::sxm_sports_main_fi_types::T_e8CategoryAvailability UpdateStatus_)  :
    _SportID (SportID_),
    _LeagueID (LeagueID_),
    _UpdateType (UpdateType_),
    _UpdateStatus (UpdateStatus_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_SportsUpdateType_IsValid(UpdateType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateType_, "T_SportsUpdateType", "UpdateType", "SportsDataUpdateStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8CategoryAvailability_IsValid(UpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateStatus_, "T_e8CategoryAvailability", "UpdateStatus", "SportsDataUpdateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SportsDataUpdateStatus::~SportsDataUpdateStatus() {
}

inline SportsDataUpdateStatus& SportsDataUpdateStatus::operator = (const SportsDataUpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSportID()) {
            setSportID(rhs.getSportID());
        } else {
            clearSportID();
        }
        if (rhs.hasLeagueID()) {
            setLeagueID(rhs.getLeagueID());
        } else {
            clearLeagueID();
        }
        if (rhs.hasUpdateType()) {
            setUpdateType(rhs.getUpdateType());
        } else {
            clearUpdateType();
        }
        if (rhs.hasUpdateStatus()) {
            setUpdateStatus(rhs.getUpdateStatus());
        } else {
            clearUpdateStatus();
        }
    }
    return *this;
}

inline bool SportsDataUpdateStatus::operator == (const SportsDataUpdateStatus& rhs) const {
    return (((!hasSportID() && !rhs.hasSportID()) || getSportID() == rhs.getSportID()) &&
        ((!hasLeagueID() && !rhs.hasLeagueID()) || getLeagueID() == rhs.getLeagueID()) &&
        ((!hasUpdateType() && !rhs.hasUpdateType()) || getUpdateType() == rhs.getUpdateType()) &&
        ((!hasUpdateStatus() && !rhs.hasUpdateStatus()) || getUpdateStatus() == rhs.getUpdateStatus()));
}

inline bool SportsDataUpdateStatus::operator != (const SportsDataUpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsDataUpdateStatus::operator < (const SportsDataUpdateStatus& rhs) const {
    if (hasSportID() || rhs.hasSportID()) {
        if (getSportID() < rhs.getSportID()) return true;
        if (getSportID() > rhs.getSportID()) return false;
    }
    if (hasLeagueID() || rhs.hasLeagueID()) {
        if (getLeagueID() < rhs.getLeagueID()) return true;
        if (getLeagueID() > rhs.getLeagueID()) return false;
    }
    if (hasUpdateType() || rhs.hasUpdateType()) {
        if ((uint32)getUpdateType() < (uint32)rhs.getUpdateType()) return true;
        if ((uint32)getUpdateType() > (uint32)rhs.getUpdateType()) return false;
    }
    if (hasUpdateStatus() || rhs.hasUpdateStatus()) {
        if ((uint32)getUpdateStatus() < (uint32)rhs.getUpdateStatus()) return true;
        if ((uint32)getUpdateStatus() > (uint32)rhs.getUpdateStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SportsDataUpdateStatus::clone() {
    return new SportsDataUpdateStatus(*this);
}

inline bool SportsDataUpdateStatus::operator > (const SportsDataUpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SportsDataUpdateStatus::clear() {
    clearSportID();
    clearLeagueID();
    clearUpdateType();
    clearUpdateStatus();
}

inline void SportsDataUpdateStatus::clearSportID() {
    if (hasSportID()) {
         clear_has_SportID();
        _SportID = 0u;
     }
}

inline bool SportsDataUpdateStatus::hasSportID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SportsDataUpdateStatus::getSportID () const {
    return _SportID;
}

inline void SportsDataUpdateStatus::setSportID (uint8 SportID_) {
    set_has_SportID();
    this->_SportID = SportID_;
}

inline void SportsDataUpdateStatus::clearLeagueID() {
    if (hasLeagueID()) {
         clear_has_LeagueID();
        _LeagueID = 0u;
     }
}

inline bool SportsDataUpdateStatus::hasLeagueID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SportsDataUpdateStatus::getLeagueID () const {
    return _LeagueID;
}

inline void SportsDataUpdateStatus::setLeagueID (uint32 LeagueID_) {
    set_has_LeagueID();
    this->_LeagueID = LeagueID_;
}

inline void SportsDataUpdateStatus::clearUpdateType() {
    if (hasUpdateType()) {
         clear_has_UpdateType();
        _UpdateType = ::sxm_sports_main_fi_types::T_SportsUpdateType__Today;
     }
}

inline bool SportsDataUpdateStatus::hasUpdateType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::sxm_sports_main_fi_types::T_SportsUpdateType SportsDataUpdateStatus::getUpdateType () const {
    return _UpdateType;
}

inline void SportsDataUpdateStatus::setUpdateType (::sxm_sports_main_fi_types::T_SportsUpdateType UpdateType_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_SportsUpdateType_IsValid(UpdateType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateType_, "T_SportsUpdateType", "UpdateType", "SportsDataUpdateStatus");
    }
    #endif
    set_has_UpdateType();
    this->_UpdateType = UpdateType_;
}

inline void SportsDataUpdateStatus::clearUpdateStatus() {
    if (hasUpdateStatus()) {
         clear_has_UpdateStatus();
        _UpdateStatus = ::sxm_sports_main_fi_types::T_e8CategoryAvailability__NOT_AVAILABLE;
     }
}

inline bool SportsDataUpdateStatus::hasUpdateStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8CategoryAvailability SportsDataUpdateStatus::getUpdateStatus () const {
    return _UpdateStatus;
}

inline void SportsDataUpdateStatus::setUpdateStatus (::sxm_sports_main_fi_types::T_e8CategoryAvailability UpdateStatus_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8CategoryAvailability_IsValid(UpdateStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", UpdateStatus_, "T_e8CategoryAvailability", "UpdateStatus", "SportsDataUpdateStatus");
    }
    #endif
    set_has_UpdateStatus();
    this->_UpdateStatus = UpdateStatus_;
}

inline void SportsDataUpdateStatus::set_has_SportID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SportsDataUpdateStatus::clear_has_SportID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SportsDataUpdateStatus::set_has_LeagueID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SportsDataUpdateStatus::clear_has_LeagueID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SportsDataUpdateStatus::set_has_UpdateType () {
    _has_bits_[0] |= 1u << 2;
}

inline void SportsDataUpdateStatus::clear_has_UpdateType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SportsDataUpdateStatus::set_has_UpdateStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void SportsDataUpdateStatus::clear_has_UpdateStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SportsDataUpdateErrorStructure::SportsDataUpdateErrorStructure ()  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SportsDataUpdateErrorStructure::SportsDataUpdateErrorStructure (const SportsDataUpdateErrorStructure &rhs)  :
    _ErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SportsDataUpdateErrorStructure::SportsDataUpdateErrorStructure (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SportsDataUpdateErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SportsDataUpdateErrorStructure::~SportsDataUpdateErrorStructure() {
}

inline SportsDataUpdateErrorStructure& SportsDataUpdateErrorStructure::operator = (const SportsDataUpdateErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool SportsDataUpdateErrorStructure::operator == (const SportsDataUpdateErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool SportsDataUpdateErrorStructure::operator != (const SportsDataUpdateErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsDataUpdateErrorStructure::operator < (const SportsDataUpdateErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool SportsDataUpdateErrorStructure::operator > (const SportsDataUpdateErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SportsDataUpdateErrorStructure::clear() {
    clearErrorCode();
}

inline void SportsDataUpdateErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_sports_main_fi_types::T_e8SportsErrorTypes__UNAVAILABLE;
     }
}

inline bool SportsDataUpdateErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_sports_main_fi_types::T_e8SportsErrorTypes SportsDataUpdateErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void SportsDataUpdateErrorStructure::setErrorCode (::sxm_sports_main_fi_types::T_e8SportsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_sports_main_fi_types::T_e8SportsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8SportsErrorTypes", "ErrorCode", "SportsDataUpdateErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void SportsDataUpdateErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SportsDataUpdateErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SportsDataUpdateError::SportsDataUpdateError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SportsDataUpdateError::SportsDataUpdateError (const SportsDataUpdateError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SportsDataUpdateError::~SportsDataUpdateError() {
    deleteData ();
}

inline SportsDataUpdateError& SportsDataUpdateError::operator = (const SportsDataUpdateError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SportsDataUpdateError::operator == (const SportsDataUpdateError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SportsDataUpdateError::operator != (const SportsDataUpdateError& rhs) const {
    return ! (*this == rhs);
}

inline bool SportsDataUpdateError::operator < (const SportsDataUpdateError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SportsDataUpdateError::operator > (const SportsDataUpdateError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SportsDataUpdateError::SportsDataUpdateErrorField SportsDataUpdateError::getField () const {
    return __field;
}

inline void SportsDataUpdateError::setField(SportsDataUpdateError::SportsDataUpdateErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SportsDataUpdateError::clone() {
    return new SportsDataUpdateError(*this);
}

inline bool SportsDataUpdateError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SportsDataUpdateErrorStructure& SportsDataUpdateError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SportsDataUpdateError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SportsDataUpdateErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SportsDataUpdateErrorStructure& SportsDataUpdateError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SportsDataUpdateError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SportsDataUpdateErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SportsDataUpdateErrorStructure* SportsDataUpdateError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SportsDataUpdateError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SportsDataUpdateErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SportsDataUpdateErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SportsDataUpdateError::replaceCcaErrorCode (SportsDataUpdateErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SportsDataUpdateError::setCcaErrorCode (const SportsDataUpdateErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SportsDataUpdateErrorStructure(value);
    }
}

inline bool SportsDataUpdateError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SportsDataUpdateError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SportsDataUpdateError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SportsDataUpdateError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SportsDataUpdateError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SportsDataUpdateError::cloneData (const SportsDataUpdateError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SportsDataUpdateErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SportsDataUpdateErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SportsDataUpdateError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace sxm_sports_main_fi

#endif // SXM_SPORTS_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
