/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_phonetics_main_fiCca.h"
#include "sxm_phonetics_main_fiJson.h"
#include "sxm_phonetics_main_fiProxy.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_phonetics_main_fi {

/*static*/ ::asf::core::Logger Sxm_phonetics_main_fiProxy::_logger ("/sxm_phonetics_main_fi/Sxm_phonetics_main_fiProxy");


class Sxm_phonetics_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_phonetics_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_phonetics_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_phonetics_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetPhoneticsData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_phonetics_main_fi::GetPhoneticsDataResult);
                                setActAndLogResult(message, "GetPhoneticsData", reinterpret_cast<act_t>(this), _logger);
                                ((GetPhoneticsDataCallbackIF*) _callback)->onGetPhoneticsDataResult (proxy, ::boost::static_pointer_cast<GetPhoneticsDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_phonetics_main_fi::GetPhoneticsDataError);
                                setActAndLogError(message, "GetPhoneticsData", reinterpret_cast<act_t>(this), _logger);
                                ((GetPhoneticsDataCallbackIF*) _callback)->onGetPhoneticsDataError (proxy, ::boost::static_pointer_cast<GetPhoneticsDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PhoneticsUpdate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_phonetics_main_fi::PhoneticsUpdateStatus);
                                setActAndLogStatus(message, "PhoneticsUpdate", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PhoneticsUpdateStatus> payload = ::boost::static_pointer_cast<PhoneticsUpdateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PhoneticsUpdateStatus >& refNullableStatus = proxy->_phoneticsUpdate;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PhoneticsUpdateCallbackIF*) _callback)->onPhoneticsUpdateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PhoneticsUpdateCallbackIF*) _callback)->onPhoneticsUpdateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_phonetics_main_fi::PhoneticsUpdateError);
                                setActAndLogError(message, "PhoneticsUpdate", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PhoneticsUpdateCallbackIF*) _callback)->onPhoneticsUpdateError(proxy, ::boost::static_pointer_cast<PhoneticsUpdateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_phonetics_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_phonetics_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetPhoneticsData: {
                ::boost::shared_ptr< GetPhoneticsDataError > payload (new GetPhoneticsDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPhoneticsData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetPhoneticsDataCallbackIF*) _callback)->onGetPhoneticsDataError (proxy, payload);
                return true;
            }
            case FID_PhoneticsUpdate: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< PhoneticsUpdateError > payload (new PhoneticsUpdateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PhoneticsUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PhoneticsUpdateCallbackIF*) _callback)->onPhoneticsUpdateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_phonetics_main_fiProxyCallback::_logger (Sxm_phonetics_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > Sxm_phonetics_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >  proxyNew(new Sxm_phonetics_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > Sxm_phonetics_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >  proxyNew(new Sxm_phonetics_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_phonetics_main_fiProxy > Sxm_phonetics_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_phonetics_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_phonetics_main_fiProxy >  proxyNew(new Sxm_phonetics_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_phonetics_main_fiProxy::Sxm_phonetics_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_phonetics_main_fiProxy::~Sxm_phonetics_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_phonetics_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_phonetics_main_fiProxy::sendGetPhoneticsDataStart(GetPhoneticsDataCallbackIF& cb, uint8 phoneticsType, uint8 languageType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetPhoneticsData);
        ::boost::shared_ptr< GetPhoneticsDataStart > payload (new GetPhoneticsDataStart());
        payload->setPhoneticsType(phoneticsType);
        payload->setLanguageType(languageType);
        CCA_MESSAGE(ccaMessage,header,GetPhoneticsDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetPhoneticsData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetPhoneticsData);
        ::boost::shared_ptr< GetPhoneticsDataError > payload (new GetPhoneticsDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetPhoneticsDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetPhoneticsData", &cb);
    }
}

act_t Sxm_phonetics_main_fiProxy::sendPhoneticsUpdateUpReg(PhoneticsUpdateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PhoneticsUpdate);
        ::boost::shared_ptr< PhoneticsUpdateUpReg > payload (new PhoneticsUpdateUpReg());
        CCA_MESSAGE(ccaMessage,header,PhoneticsUpdateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PhoneticsUpdateRelUpReg > payloadRelUpRegHeap (new PhoneticsUpdateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PhoneticsUpdate, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_phonetics_main_fi::PhoneticsUpdateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PhoneticsUpdate, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PhoneticsUpdate", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PhoneticsUpdate", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPhoneticsUpdate()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PhoneticsUpdate, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PhoneticsUpdateStatus > payloadLoopback (new PhoneticsUpdateStatus(getPhoneticsUpdate()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PhoneticsUpdateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PhoneticsUpdate);
        ::boost::shared_ptr< PhoneticsUpdateError > payload (new PhoneticsUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PhoneticsUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PhoneticsUpdate", &cb);
    }
}

bool Sxm_phonetics_main_fiProxy::sendPhoneticsUpdateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PhoneticsUpdate,"PhoneticsUpdate");
}

void Sxm_phonetics_main_fiProxy::sendPhoneticsUpdateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PhoneticsUpdate);
}

const PhoneticsUpdateStatus& Sxm_phonetics_main_fiProxy::getPhoneticsUpdate() const {
    return _phoneticsUpdate.get();
}

bool Sxm_phonetics_main_fiProxy::hasPhoneticsUpdate() const {
    return _phoneticsUpdate.hasValue();
}

act_t Sxm_phonetics_main_fiProxy::sendPhoneticsUpdateGet(PhoneticsUpdateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PhoneticsUpdate);
        ::boost::shared_ptr< PhoneticsUpdateGet > payload (new PhoneticsUpdateGet());
        CCA_MESSAGE(ccaMessage,header,PhoneticsUpdateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PhoneticsUpdate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PhoneticsUpdate);
        ::boost::shared_ptr< PhoneticsUpdateError > payload (new PhoneticsUpdateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PhoneticsUpdateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PhoneticsUpdate", &cb);
    }
}


void Sxm_phonetics_main_fiProxy::clearAllProperties ()
{
    _phoneticsUpdate = ::asf::core::nullable<PhoneticsUpdateStatus>();
}

void Sxm_phonetics_main_fiProxy::sendRelUpRegAll()
{
    sendPhoneticsUpdateRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_phonetics_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_phonetics_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_phonetics_main_fi
