#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PHONETICS_MAIN_FI_H
#define SXM_PHONETICS_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_phonetics_main_fi_types.h"
#include "sxm_phonetics_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_phonetics_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Phonetics
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Narasimhulu Kavadapu (Phonetics)
 *
 * Date: $Date:   AUG 21 2015  12:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_phonetics_main_fi
 *
 * <b>Description of 'sxm_phonetics_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_phonetics_main_fi {

static const int SERVICE_ID = 193;

static const int FID_GetPhoneticsData = 1;

static const int FID_PhoneticsUpdate = 16;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPhoneticsDataStart;

class GetPhoneticsDataResult;

class GetPhoneticsDataErrorStructure;

class GetPhoneticsDataError;

class PhoneticsUpdateStatus;

// type definitions
/**
 * The abort error message of the method "GetPhoneticsData"
 * method to get Phonetics Data for Channels, Categories, Markets, Teams and Leagues
 */
typedef ::asf::cca::CcaTypes::DefaultError GetPhoneticsDataAbortError;

/**
 * The get message of the property "PhoneticsUpdate"
 * Property to inform updates for phonetics data
 * Phonetics Data updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneticsUpdateGet;

/**
 * The upreg message of the property "PhoneticsUpdate"
 * Property to inform updates for phonetics data
 * Register for updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneticsUpdateUpReg;

/**
 * The relUpReg message of the property "PhoneticsUpdate"
 * Property to inform updates for phonetics data
 * Unregister for updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneticsUpdateRelUpReg;

/**
 * The error message of 'PhoneticsUpdate'
 * Error
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneticsUpdateError;


/**
 * The start message of the method "GetPhoneticsData"
 * method to get Phonetics Data for Channels, Categories, Markets, Teams and Leagues
 */
class GetPhoneticsDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPhoneticsDataStart ();

    /**
     * Copy constructor
     */
    inline  GetPhoneticsDataStart (const GetPhoneticsDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetPhoneticsDataStart (uint8 PhoneticsType_, uint8 LanguageType_);

    /**
     * Destructor
     */
    inline virtual  ~GetPhoneticsDataStart();

    /**
     * Assignment operator
     */
    inline GetPhoneticsDataStart& operator = (const GetPhoneticsDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhoneticsDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhoneticsDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhoneticsDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhoneticsDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneticsType"

    static const int kPhoneticsType = 0;

    /**
     * Clears the field "PhoneticsType".
     *
     * The field will be set to its default value. The hasPhoneticsType()
     * method will return false.
     */
    inline void clearPhoneticsType();

    /**
     * Checks whether the field "PhoneticsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsType()). Otherwise it will return false.
     */
    inline bool hasPhoneticsType () const;

    /**
     * Returns the value of the member "PhoneticsType".
     *
     * Type of the Phonetics Data required. Available types are defined in T_e8PhoneticsType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @return The value of the field "PhoneticsType"
     */
    inline uint8 getPhoneticsType () const;

    /**
     * Sets the value of the member "PhoneticsType".
     *
     * Type of the Phonetics Data required. Available types are defined in T_e8PhoneticsType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @param PhoneticsType The value which will be set
     */
    inline void setPhoneticsType (uint8 PhoneticsType_);

    // API of field "LanguageType"

    static const int kLanguageType = 1;

    /**
     * Clears the field "LanguageType".
     *
     * The field will be set to its default value. The hasLanguageType()
     * method will return false.
     */
    inline void clearLanguageType();

    /**
     * Checks whether the field "LanguageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageType()). Otherwise it will return false.
     */
    inline bool hasLanguageType () const;

    /**
     * Returns the value of the member "LanguageType".
     *
     * Type of Language in which the Phonetics data is required. Available types are defined in T_e8LanguageType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @return The value of the field "LanguageType"
     */
    inline uint8 getLanguageType () const;

    /**
     * Sets the value of the member "LanguageType".
     *
     * Type of Language in which the Phonetics data is required. Available types are defined in T_e8LanguageType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @param LanguageType The value which will be set
     */
    inline void setLanguageType (uint8 LanguageType_);

    static const GetPhoneticsDataStart &getDefaultInstance();

private:

    inline void set_has_PhoneticsType ();

    inline void clear_has_PhoneticsType ();

    inline void set_has_LanguageType ();

    inline void clear_has_LanguageType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _PhoneticsType;

    uint8 _LanguageType;

};

/**
 * The result message of the method "GetPhoneticsData"
 * method to get Phonetics Data for Channels, Categories, Markets, Teams and Leagues
 */
class GetPhoneticsDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPhoneticsDataResult ();

    /**
     * Copy constructor
     */
    inline  GetPhoneticsDataResult (const GetPhoneticsDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetPhoneticsDataResult (uint8 PhoneticsType_, uint8 LanguageType_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& ChannelList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& CategoryList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& MarketList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& LeagueList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& TeamList_);

    /**
     * Destructor
     */
    inline virtual  ~GetPhoneticsDataResult();

    /**
     * Assignment operator
     */
    inline GetPhoneticsDataResult& operator = (const GetPhoneticsDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhoneticsDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhoneticsDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhoneticsDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhoneticsDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneticsType"

    static const int kPhoneticsType = 0;

    /**
     * Clears the field "PhoneticsType".
     *
     * The field will be set to its default value. The hasPhoneticsType()
     * method will return false.
     */
    inline void clearPhoneticsType();

    /**
     * Checks whether the field "PhoneticsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsType()). Otherwise it will return false.
     */
    inline bool hasPhoneticsType () const;

    /**
     * Returns the value of the member "PhoneticsType".
     *
     * Type of Phonetics Data requested.
     *
     * @return The value of the field "PhoneticsType"
     */
    inline uint8 getPhoneticsType () const;

    /**
     * Sets the value of the member "PhoneticsType".
     *
     * Type of Phonetics Data requested.
     *
     * @param PhoneticsType The value which will be set
     */
    inline void setPhoneticsType (uint8 PhoneticsType_);

    // API of field "LanguageType"

    static const int kLanguageType = 1;

    /**
     * Clears the field "LanguageType".
     *
     * The field will be set to its default value. The hasLanguageType()
     * method will return false.
     */
    inline void clearLanguageType();

    /**
     * Checks whether the field "LanguageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageType()). Otherwise it will return false.
     */
    inline bool hasLanguageType () const;

    /**
     * Returns the value of the member "LanguageType".
     *
     * Type of Language requested.
     *
     * @return The value of the field "LanguageType"
     */
    inline uint8 getLanguageType () const;

    /**
     * Sets the value of the member "LanguageType".
     *
     * Type of Language requested.
     *
     * @param LanguageType The value which will be set
     */
    inline void setLanguageType (uint8 LanguageType_);

    // API of field "ChannelList"

    static const int kChannelList = 2;

    /**
     * Clears the field "ChannelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "ChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "ChannelList".
     *
     * list of phonetics data for Channel Names.
     *
     * @return The value of the field "ChannelList"
     */
    inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& getChannelList () const;

    /**
     * Retrieves the value of the field "ChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelList".
     */
    inline ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& getChannelListMutable ();

    /**
     * Sets the value of the member "ChannelList".
     *
     * list of phonetics data for Channel Names.
     *
     * @param ChannelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& ChannelList_);

    // API of field "CategoryList"

    static const int kCategoryList = 3;

    /**
     * Clears the field "CategoryList".
     *
     * The field will be set to its default value. The hasCategoryList()
     * method will return false.
     */
    inline void clearCategoryList();

    /**
     * Checks whether the field "CategoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategoryList()). Otherwise it will return false.
     */
    inline bool hasCategoryList () const;

    /**
     * Returns the value of the member "CategoryList".
     *
     * list of phonetics data for Category Names.
     *
     * @return The value of the field "CategoryList"
     */
    inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& getCategoryList () const;

    /**
     * Retrieves the value of the field "CategoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CategoryList".
     */
    inline ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& getCategoryListMutable ();

    /**
     * Sets the value of the member "CategoryList".
     *
     * list of phonetics data for Category Names.
     *
     * @param CategoryList The value which will be set
     */
    inline void setCategoryList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& CategoryList_);

    // API of field "MarketList"

    static const int kMarketList = 4;

    /**
     * Clears the field "MarketList".
     *
     * The field will be set to its default value. The hasMarketList()
     * method will return false.
     */
    inline void clearMarketList();

    /**
     * Checks whether the field "MarketList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMarketList()). Otherwise it will return false.
     */
    inline bool hasMarketList () const;

    /**
     * Returns the value of the member "MarketList".
     *
     * list of phonetics data for Market Names.
     *
     * @return The value of the field "MarketList"
     */
    inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& getMarketList () const;

    /**
     * Retrieves the value of the field "MarketList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MarketList".
     */
    inline ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& getMarketListMutable ();

    /**
     * Sets the value of the member "MarketList".
     *
     * list of phonetics data for Market Names.
     *
     * @param MarketList The value which will be set
     */
    inline void setMarketList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& MarketList_);

    // API of field "LeagueList"

    static const int kLeagueList = 5;

    /**
     * Clears the field "LeagueList".
     *
     * The field will be set to its default value. The hasLeagueList()
     * method will return false.
     */
    inline void clearLeagueList();

    /**
     * Checks whether the field "LeagueList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLeagueList()). Otherwise it will return false.
     */
    inline bool hasLeagueList () const;

    /**
     * Returns the value of the member "LeagueList".
     *
     * list of phonetics data for League Names.
     *
     * @return The value of the field "LeagueList"
     */
    inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& getLeagueList () const;

    /**
     * Retrieves the value of the field "LeagueList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LeagueList".
     */
    inline ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& getLeagueListMutable ();

    /**
     * Sets the value of the member "LeagueList".
     *
     * list of phonetics data for League Names.
     *
     * @param LeagueList The value which will be set
     */
    inline void setLeagueList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& LeagueList_);

    // API of field "TeamList"

    static const int kTeamList = 6;

    /**
     * Clears the field "TeamList".
     *
     * The field will be set to its default value. The hasTeamList()
     * method will return false.
     */
    inline void clearTeamList();

    /**
     * Checks whether the field "TeamList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTeamList()). Otherwise it will return false.
     */
    inline bool hasTeamList () const;

    /**
     * Returns the value of the member "TeamList".
     *
     * list of phonetics data for Team Names.
     *
     * @return The value of the field "TeamList"
     */
    inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& getTeamList () const;

    /**
     * Retrieves the value of the field "TeamList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TeamList".
     */
    inline ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& getTeamListMutable ();

    /**
     * Sets the value of the member "TeamList".
     *
     * list of phonetics data for Team Names.
     *
     * @param TeamList The value which will be set
     */
    inline void setTeamList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& TeamList_);

    static const GetPhoneticsDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& getT_ChannelPhoneticsInfoList_DefaultInstance ();

    static const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& getT_CategoryPhoneticsInfoList_DefaultInstance ();

    static const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& getT_MarketPhoneticsInfoList_DefaultInstance ();

    static const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& getT_LeaguePhoneticsInfoList_DefaultInstance ();

    static const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& getT_TeamPhoneticsInfoList_DefaultInstance ();

    inline void set_has_PhoneticsType ();

    inline void clear_has_PhoneticsType ();

    inline void set_has_LanguageType ();

    inline void clear_has_LanguageType ();

    inline void set_has_ChannelList ();

    inline void clear_has_ChannelList ();

    inline void set_has_CategoryList ();

    inline void clear_has_CategoryList ();

    inline void set_has_MarketList ();

    inline void clear_has_MarketList ();

    inline void set_has_LeagueList ();

    inline void clear_has_LeagueList ();

    inline void set_has_TeamList ();

    inline void clear_has_TeamList ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _PhoneticsType;

    uint8 _LanguageType;

    ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo > _ChannelList;

    ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo > _CategoryList;

    ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo > _MarketList;

    ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo > _LeagueList;

    ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo > _TeamList;

};

/**
 * The error message of 'GetPhoneticsData'
 */
class GetPhoneticsDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetPhoneticsDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetPhoneticsDataErrorStructure (const GetPhoneticsDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetPhoneticsDataErrorStructure (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetPhoneticsDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetPhoneticsDataErrorStructure& operator = (const GetPhoneticsDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhoneticsDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhoneticsDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhoneticsDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhoneticsDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies Phonetics list is empty
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies Phonetics list is empty
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes ErrorCode_);

    static const GetPhoneticsDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetPhoneticsData'
 */
class GetPhoneticsDataError  : public ::asf::core::Payload {
public:

    enum GetPhoneticsDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetPhoneticsDataError ();

   /**
     * Copy constructor
     */
    inline  GetPhoneticsDataError (const GetPhoneticsDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetPhoneticsDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetPhoneticsDataError& operator = (const GetPhoneticsDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPhoneticsDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPhoneticsDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPhoneticsDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPhoneticsDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetPhoneticsDataError::GetPhoneticsDataErrorField getField () const;

    inline void setField(GetPhoneticsDataError::GetPhoneticsDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetPhoneticsDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetPhoneticsDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetPhoneticsDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetPhoneticsDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetPhoneticsDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetPhoneticsDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetPhoneticsDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetPhoneticsDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetPhoneticsDataError &getDefaultInstance();

private:

    inline void cloneData (const GetPhoneticsDataError& rhs);

    inline void deleteData ();

    GetPhoneticsDataErrorField __field;

    union {
        GetPhoneticsDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PhoneticsUpdate"
 * Property to inform updates for phonetics data
 */
class PhoneticsUpdateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneticsUpdateStatus ();

    /**
     * Copy constructor
     */
    inline  PhoneticsUpdateStatus (const PhoneticsUpdateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneticsUpdateStatus (uint8 PhoneticsType_, uint8 LanguageType_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneticsUpdateStatus();

    /**
     * Assignment operator
     */
    inline PhoneticsUpdateStatus& operator = (const PhoneticsUpdateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneticsUpdateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneticsUpdateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneticsUpdateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneticsUpdateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneticsType"

    static const int kPhoneticsType = 0;

    /**
     * Clears the field "PhoneticsType".
     *
     * The field will be set to its default value. The hasPhoneticsType()
     * method will return false.
     */
    inline void clearPhoneticsType();

    /**
     * Checks whether the field "PhoneticsType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneticsType()). Otherwise it will return false.
     */
    inline bool hasPhoneticsType () const;

    /**
     * Returns the value of the member "PhoneticsType".
     *
     * Type of the Phonetics Data is updated. Available types are defined in T_e8PhoneticsType.
     * Multiple types can be updated using bitwise OR operator.
     *
     * @return The value of the field "PhoneticsType"
     */
    inline uint8 getPhoneticsType () const;

    /**
     * Sets the value of the member "PhoneticsType".
     *
     * Type of the Phonetics Data is updated. Available types are defined in T_e8PhoneticsType.
     * Multiple types can be updated using bitwise OR operator.
     *
     * @param PhoneticsType The value which will be set
     */
    inline void setPhoneticsType (uint8 PhoneticsType_);

    // API of field "LanguageType"

    static const int kLanguageType = 1;

    /**
     * Clears the field "LanguageType".
     *
     * The field will be set to its default value. The hasLanguageType()
     * method will return false.
     */
    inline void clearLanguageType();

    /**
     * Checks whether the field "LanguageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguageType()). Otherwise it will return false.
     */
    inline bool hasLanguageType () const;

    /**
     * Returns the value of the member "LanguageType".
     *
     * Type of Language in which the Phonetics data is updated. Available types are defined in T_e8LanguageType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @return The value of the field "LanguageType"
     */
    inline uint8 getLanguageType () const;

    /**
     * Sets the value of the member "LanguageType".
     *
     * Type of Language in which the Phonetics data is updated. Available types are defined in T_e8LanguageType.
     * Multiple types can be sent using bitwise OR operator.
     *
     * @param LanguageType The value which will be set
     */
    inline void setLanguageType (uint8 LanguageType_);

    static const PhoneticsUpdateStatus &getDefaultInstance();

private:

    inline void set_has_PhoneticsType ();

    inline void clear_has_PhoneticsType ();

    inline void set_has_LanguageType ();

    inline void clear_has_LanguageType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _PhoneticsType;

    uint8 _LanguageType;

};

inline  GetPhoneticsDataStart::GetPhoneticsDataStart ()  :
    _PhoneticsType (0u),
    _LanguageType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPhoneticsDataStart::GetPhoneticsDataStart (const GetPhoneticsDataStart &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneticsType (0u),
    _LanguageType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPhoneticsDataStart::GetPhoneticsDataStart (uint8 PhoneticsType_, uint8 LanguageType_)  :
    _PhoneticsType (PhoneticsType_),
    _LanguageType (LanguageType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPhoneticsDataStart::~GetPhoneticsDataStart() {
}

inline GetPhoneticsDataStart& GetPhoneticsDataStart::operator = (const GetPhoneticsDataStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneticsType()) {
            setPhoneticsType(rhs.getPhoneticsType());
        } else {
            clearPhoneticsType();
        }
        if (rhs.hasLanguageType()) {
            setLanguageType(rhs.getLanguageType());
        } else {
            clearLanguageType();
        }
    }
    return *this;
}

inline bool GetPhoneticsDataStart::operator == (const GetPhoneticsDataStart& rhs) const {
    return (((!hasPhoneticsType() && !rhs.hasPhoneticsType()) || getPhoneticsType() == rhs.getPhoneticsType()) &&
        ((!hasLanguageType() && !rhs.hasLanguageType()) || getLanguageType() == rhs.getLanguageType()));
}

inline bool GetPhoneticsDataStart::operator != (const GetPhoneticsDataStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhoneticsDataStart::operator < (const GetPhoneticsDataStart& rhs) const {
    if (hasPhoneticsType() || rhs.hasPhoneticsType()) {
        if (getPhoneticsType() < rhs.getPhoneticsType()) return true;
        if (getPhoneticsType() > rhs.getPhoneticsType()) return false;
    }
    if (hasLanguageType() || rhs.hasLanguageType()) {
        if (getLanguageType() < rhs.getLanguageType()) return true;
        if (getLanguageType() > rhs.getLanguageType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPhoneticsDataStart::clone() {
    return new GetPhoneticsDataStart(*this);
}

inline bool GetPhoneticsDataStart::operator > (const GetPhoneticsDataStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPhoneticsDataStart::clear() {
    clearPhoneticsType();
    clearLanguageType();
}

inline void GetPhoneticsDataStart::clearPhoneticsType() {
    if (hasPhoneticsType()) {
         clear_has_PhoneticsType();
        _PhoneticsType = 0u;
     }
}

inline bool GetPhoneticsDataStart::hasPhoneticsType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetPhoneticsDataStart::getPhoneticsType () const {
    return _PhoneticsType;
}

inline void GetPhoneticsDataStart::setPhoneticsType (uint8 PhoneticsType_) {
    set_has_PhoneticsType();
    this->_PhoneticsType = PhoneticsType_;
}

inline void GetPhoneticsDataStart::clearLanguageType() {
    if (hasLanguageType()) {
         clear_has_LanguageType();
        _LanguageType = 0u;
     }
}

inline bool GetPhoneticsDataStart::hasLanguageType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetPhoneticsDataStart::getLanguageType () const {
    return _LanguageType;
}

inline void GetPhoneticsDataStart::setLanguageType (uint8 LanguageType_) {
    set_has_LanguageType();
    this->_LanguageType = LanguageType_;
}

inline void GetPhoneticsDataStart::set_has_PhoneticsType () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPhoneticsDataStart::clear_has_PhoneticsType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPhoneticsDataStart::set_has_LanguageType () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPhoneticsDataStart::clear_has_LanguageType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetPhoneticsDataResult::GetPhoneticsDataResult ()  :
    _PhoneticsType (0u),
    _LanguageType (0u),
    _ChannelList (),
    _CategoryList (),
    _MarketList (),
    _LeagueList (),
    _TeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPhoneticsDataResult::GetPhoneticsDataResult (const GetPhoneticsDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneticsType (0u),
    _LanguageType (0u),
    _ChannelList (),
    _CategoryList (),
    _MarketList (),
    _LeagueList (),
    _TeamList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPhoneticsDataResult::GetPhoneticsDataResult (uint8 PhoneticsType_, uint8 LanguageType_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& ChannelList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& CategoryList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& MarketList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& LeagueList_, const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& TeamList_)  :
    _PhoneticsType (PhoneticsType_),
    _LanguageType (LanguageType_),
    _ChannelList (ChannelList_),
    _CategoryList (CategoryList_),
    _MarketList (MarketList_),
    _LeagueList (LeagueList_),
    _TeamList (TeamList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPhoneticsDataResult::~GetPhoneticsDataResult() {
}

inline GetPhoneticsDataResult& GetPhoneticsDataResult::operator = (const GetPhoneticsDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneticsType()) {
            setPhoneticsType(rhs.getPhoneticsType());
        } else {
            clearPhoneticsType();
        }
        if (rhs.hasLanguageType()) {
            setLanguageType(rhs.getLanguageType());
        } else {
            clearLanguageType();
        }
        if (rhs.hasChannelList()) {
            setChannelList(rhs.getChannelList());
        } else {
            clearChannelList();
        }
        if (rhs.hasCategoryList()) {
            setCategoryList(rhs.getCategoryList());
        } else {
            clearCategoryList();
        }
        if (rhs.hasMarketList()) {
            setMarketList(rhs.getMarketList());
        } else {
            clearMarketList();
        }
        if (rhs.hasLeagueList()) {
            setLeagueList(rhs.getLeagueList());
        } else {
            clearLeagueList();
        }
        if (rhs.hasTeamList()) {
            setTeamList(rhs.getTeamList());
        } else {
            clearTeamList();
        }
    }
    return *this;
}

inline bool GetPhoneticsDataResult::operator == (const GetPhoneticsDataResult& rhs) const {
    return (((!hasPhoneticsType() && !rhs.hasPhoneticsType()) || getPhoneticsType() == rhs.getPhoneticsType()) &&
        ((!hasLanguageType() && !rhs.hasLanguageType()) || getLanguageType() == rhs.getLanguageType()) &&
        ((!hasChannelList() && !rhs.hasChannelList()) || getChannelList() == rhs.getChannelList()) &&
        ((!hasCategoryList() && !rhs.hasCategoryList()) || getCategoryList() == rhs.getCategoryList()) &&
        ((!hasMarketList() && !rhs.hasMarketList()) || getMarketList() == rhs.getMarketList()) &&
        ((!hasLeagueList() && !rhs.hasLeagueList()) || getLeagueList() == rhs.getLeagueList()) &&
        ((!hasTeamList() && !rhs.hasTeamList()) || getTeamList() == rhs.getTeamList()));
}

inline bool GetPhoneticsDataResult::operator != (const GetPhoneticsDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhoneticsDataResult::operator < (const GetPhoneticsDataResult& rhs) const {
    if (hasPhoneticsType() || rhs.hasPhoneticsType()) {
        if (getPhoneticsType() < rhs.getPhoneticsType()) return true;
        if (getPhoneticsType() > rhs.getPhoneticsType()) return false;
    }
    if (hasLanguageType() || rhs.hasLanguageType()) {
        if (getLanguageType() < rhs.getLanguageType()) return true;
        if (getLanguageType() > rhs.getLanguageType()) return false;
    }
    if (hasChannelList() || rhs.hasChannelList()) {
        if (getChannelList() < rhs.getChannelList()) return true;
        if (getChannelList() > rhs.getChannelList()) return false;
    }
    if (hasCategoryList() || rhs.hasCategoryList()) {
        if (getCategoryList() < rhs.getCategoryList()) return true;
        if (getCategoryList() > rhs.getCategoryList()) return false;
    }
    if (hasMarketList() || rhs.hasMarketList()) {
        if (getMarketList() < rhs.getMarketList()) return true;
        if (getMarketList() > rhs.getMarketList()) return false;
    }
    if (hasLeagueList() || rhs.hasLeagueList()) {
        if (getLeagueList() < rhs.getLeagueList()) return true;
        if (getLeagueList() > rhs.getLeagueList()) return false;
    }
    if (hasTeamList() || rhs.hasTeamList()) {
        if (getTeamList() < rhs.getTeamList()) return true;
        if (getTeamList() > rhs.getTeamList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPhoneticsDataResult::clone() {
    return new GetPhoneticsDataResult(*this);
}

inline bool GetPhoneticsDataResult::operator > (const GetPhoneticsDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPhoneticsDataResult::clear() {
    clearPhoneticsType();
    clearLanguageType();
    clearChannelList();
    clearCategoryList();
    clearMarketList();
    clearLeagueList();
    clearTeamList();
}

inline void GetPhoneticsDataResult::clearPhoneticsType() {
    if (hasPhoneticsType()) {
         clear_has_PhoneticsType();
        _PhoneticsType = 0u;
     }
}

inline bool GetPhoneticsDataResult::hasPhoneticsType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetPhoneticsDataResult::getPhoneticsType () const {
    return _PhoneticsType;
}

inline void GetPhoneticsDataResult::setPhoneticsType (uint8 PhoneticsType_) {
    set_has_PhoneticsType();
    this->_PhoneticsType = PhoneticsType_;
}

inline void GetPhoneticsDataResult::clearLanguageType() {
    if (hasLanguageType()) {
         clear_has_LanguageType();
        _LanguageType = 0u;
     }
}

inline bool GetPhoneticsDataResult::hasLanguageType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetPhoneticsDataResult::getLanguageType () const {
    return _LanguageType;
}

inline void GetPhoneticsDataResult::setLanguageType (uint8 LanguageType_) {
    set_has_LanguageType();
    this->_LanguageType = LanguageType_;
}

inline void GetPhoneticsDataResult::clearChannelList() {
    if (hasChannelList()) {
         clear_has_ChannelList();
        _ChannelList.clear();
     }
}

inline bool GetPhoneticsDataResult::hasChannelList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& GetPhoneticsDataResult::getChannelList () const {
    return _ChannelList;
}

inline ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& GetPhoneticsDataResult::getChannelListMutable () {
    set_has_ChannelList();
    return _ChannelList;
}

inline void GetPhoneticsDataResult::setChannelList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_ChannelPhoneticsInfo >& ChannelList_) {
    set_has_ChannelList();
    this->_ChannelList = ChannelList_;
}

inline void GetPhoneticsDataResult::clearCategoryList() {
    if (hasCategoryList()) {
         clear_has_CategoryList();
        _CategoryList.clear();
     }
}

inline bool GetPhoneticsDataResult::hasCategoryList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& GetPhoneticsDataResult::getCategoryList () const {
    return _CategoryList;
}

inline ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& GetPhoneticsDataResult::getCategoryListMutable () {
    set_has_CategoryList();
    return _CategoryList;
}

inline void GetPhoneticsDataResult::setCategoryList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_CategoryPhoneticsInfo >& CategoryList_) {
    set_has_CategoryList();
    this->_CategoryList = CategoryList_;
}

inline void GetPhoneticsDataResult::clearMarketList() {
    if (hasMarketList()) {
         clear_has_MarketList();
        _MarketList.clear();
     }
}

inline bool GetPhoneticsDataResult::hasMarketList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& GetPhoneticsDataResult::getMarketList () const {
    return _MarketList;
}

inline ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& GetPhoneticsDataResult::getMarketListMutable () {
    set_has_MarketList();
    return _MarketList;
}

inline void GetPhoneticsDataResult::setMarketList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_MarketPhoneticsInfo >& MarketList_) {
    set_has_MarketList();
    this->_MarketList = MarketList_;
}

inline void GetPhoneticsDataResult::clearLeagueList() {
    if (hasLeagueList()) {
         clear_has_LeagueList();
        _LeagueList.clear();
     }
}

inline bool GetPhoneticsDataResult::hasLeagueList () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& GetPhoneticsDataResult::getLeagueList () const {
    return _LeagueList;
}

inline ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& GetPhoneticsDataResult::getLeagueListMutable () {
    set_has_LeagueList();
    return _LeagueList;
}

inline void GetPhoneticsDataResult::setLeagueList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_LeaguePhoneticsInfo >& LeagueList_) {
    set_has_LeagueList();
    this->_LeagueList = LeagueList_;
}

inline void GetPhoneticsDataResult::clearTeamList() {
    if (hasTeamList()) {
         clear_has_TeamList();
        _TeamList.clear();
     }
}

inline bool GetPhoneticsDataResult::hasTeamList () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& GetPhoneticsDataResult::getTeamList () const {
    return _TeamList;
}

inline ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& GetPhoneticsDataResult::getTeamListMutable () {
    set_has_TeamList();
    return _TeamList;
}

inline void GetPhoneticsDataResult::setTeamList (const ::std::vector< ::sxm_phonetics_main_fi_types::T_TeamPhoneticsInfo >& TeamList_) {
    set_has_TeamList();
    this->_TeamList = TeamList_;
}

inline void GetPhoneticsDataResult::set_has_PhoneticsType () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPhoneticsDataResult::clear_has_PhoneticsType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPhoneticsDataResult::set_has_LanguageType () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPhoneticsDataResult::clear_has_LanguageType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetPhoneticsDataResult::set_has_ChannelList () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetPhoneticsDataResult::clear_has_ChannelList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetPhoneticsDataResult::set_has_CategoryList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetPhoneticsDataResult::clear_has_CategoryList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetPhoneticsDataResult::set_has_MarketList () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetPhoneticsDataResult::clear_has_MarketList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void GetPhoneticsDataResult::set_has_LeagueList () {
    _has_bits_[0] |= 1u << 5;
}

inline void GetPhoneticsDataResult::clear_has_LeagueList () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void GetPhoneticsDataResult::set_has_TeamList () {
    _has_bits_[0] |= 1u << 6;
}

inline void GetPhoneticsDataResult::clear_has_TeamList () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  GetPhoneticsDataErrorStructure::GetPhoneticsDataErrorStructure ()  :
    _ErrorCode (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes__PHONETICS_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPhoneticsDataErrorStructure::GetPhoneticsDataErrorStructure (const GetPhoneticsDataErrorStructure &rhs)  :
    _ErrorCode (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes__PHONETICS_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPhoneticsDataErrorStructure::GetPhoneticsDataErrorStructure (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8PhoneticsErrorTypes", "ErrorCode", "GetPhoneticsDataErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPhoneticsDataErrorStructure::~GetPhoneticsDataErrorStructure() {
}

inline GetPhoneticsDataErrorStructure& GetPhoneticsDataErrorStructure::operator = (const GetPhoneticsDataErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetPhoneticsDataErrorStructure::operator == (const GetPhoneticsDataErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetPhoneticsDataErrorStructure::operator != (const GetPhoneticsDataErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhoneticsDataErrorStructure::operator < (const GetPhoneticsDataErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetPhoneticsDataErrorStructure::operator > (const GetPhoneticsDataErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPhoneticsDataErrorStructure::clear() {
    clearErrorCode();
}

inline void GetPhoneticsDataErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes__PHONETICS_INFOLIST_EMPTY;
     }
}

inline bool GetPhoneticsDataErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes GetPhoneticsDataErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetPhoneticsDataErrorStructure::setErrorCode (::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_phonetics_main_fi_types::T_e8PhoneticsErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8PhoneticsErrorTypes", "ErrorCode", "GetPhoneticsDataErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetPhoneticsDataErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPhoneticsDataErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPhoneticsDataError::GetPhoneticsDataError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetPhoneticsDataError::GetPhoneticsDataError (const GetPhoneticsDataError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetPhoneticsDataError::~GetPhoneticsDataError() {
    deleteData ();
}

inline GetPhoneticsDataError& GetPhoneticsDataError::operator = (const GetPhoneticsDataError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetPhoneticsDataError::operator == (const GetPhoneticsDataError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetPhoneticsDataError::operator != (const GetPhoneticsDataError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPhoneticsDataError::operator < (const GetPhoneticsDataError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetPhoneticsDataError::operator > (const GetPhoneticsDataError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetPhoneticsDataError::GetPhoneticsDataErrorField GetPhoneticsDataError::getField () const {
    return __field;
}

inline void GetPhoneticsDataError::setField(GetPhoneticsDataError::GetPhoneticsDataErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetPhoneticsDataError::clone() {
    return new GetPhoneticsDataError(*this);
}

inline bool GetPhoneticsDataError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetPhoneticsDataErrorStructure& GetPhoneticsDataError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetPhoneticsDataError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetPhoneticsDataErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetPhoneticsDataErrorStructure& GetPhoneticsDataError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetPhoneticsDataError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetPhoneticsDataErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetPhoneticsDataErrorStructure* GetPhoneticsDataError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetPhoneticsDataError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetPhoneticsDataErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetPhoneticsDataErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetPhoneticsDataError::replaceCcaErrorCode (GetPhoneticsDataErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetPhoneticsDataError::setCcaErrorCode (const GetPhoneticsDataErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetPhoneticsDataErrorStructure(value);
    }
}

inline bool GetPhoneticsDataError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetPhoneticsDataError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetPhoneticsDataError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetPhoneticsDataError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetPhoneticsDataError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetPhoneticsDataError::cloneData (const GetPhoneticsDataError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetPhoneticsDataErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetPhoneticsDataErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetPhoneticsDataError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  PhoneticsUpdateStatus::PhoneticsUpdateStatus ()  :
    _PhoneticsType (0u),
    _LanguageType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneticsUpdateStatus::PhoneticsUpdateStatus (const PhoneticsUpdateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneticsType (0u),
    _LanguageType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneticsUpdateStatus::PhoneticsUpdateStatus (uint8 PhoneticsType_, uint8 LanguageType_)  :
    _PhoneticsType (PhoneticsType_),
    _LanguageType (LanguageType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhoneticsUpdateStatus::~PhoneticsUpdateStatus() {
}

inline PhoneticsUpdateStatus& PhoneticsUpdateStatus::operator = (const PhoneticsUpdateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneticsType()) {
            setPhoneticsType(rhs.getPhoneticsType());
        } else {
            clearPhoneticsType();
        }
        if (rhs.hasLanguageType()) {
            setLanguageType(rhs.getLanguageType());
        } else {
            clearLanguageType();
        }
    }
    return *this;
}

inline bool PhoneticsUpdateStatus::operator == (const PhoneticsUpdateStatus& rhs) const {
    return (((!hasPhoneticsType() && !rhs.hasPhoneticsType()) || getPhoneticsType() == rhs.getPhoneticsType()) &&
        ((!hasLanguageType() && !rhs.hasLanguageType()) || getLanguageType() == rhs.getLanguageType()));
}

inline bool PhoneticsUpdateStatus::operator != (const PhoneticsUpdateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneticsUpdateStatus::operator < (const PhoneticsUpdateStatus& rhs) const {
    if (hasPhoneticsType() || rhs.hasPhoneticsType()) {
        if (getPhoneticsType() < rhs.getPhoneticsType()) return true;
        if (getPhoneticsType() > rhs.getPhoneticsType()) return false;
    }
    if (hasLanguageType() || rhs.hasLanguageType()) {
        if (getLanguageType() < rhs.getLanguageType()) return true;
        if (getLanguageType() > rhs.getLanguageType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PhoneticsUpdateStatus::clone() {
    return new PhoneticsUpdateStatus(*this);
}

inline bool PhoneticsUpdateStatus::operator > (const PhoneticsUpdateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneticsUpdateStatus::clear() {
    clearPhoneticsType();
    clearLanguageType();
}

inline void PhoneticsUpdateStatus::clearPhoneticsType() {
    if (hasPhoneticsType()) {
         clear_has_PhoneticsType();
        _PhoneticsType = 0u;
     }
}

inline bool PhoneticsUpdateStatus::hasPhoneticsType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PhoneticsUpdateStatus::getPhoneticsType () const {
    return _PhoneticsType;
}

inline void PhoneticsUpdateStatus::setPhoneticsType (uint8 PhoneticsType_) {
    set_has_PhoneticsType();
    this->_PhoneticsType = PhoneticsType_;
}

inline void PhoneticsUpdateStatus::clearLanguageType() {
    if (hasLanguageType()) {
         clear_has_LanguageType();
        _LanguageType = 0u;
     }
}

inline bool PhoneticsUpdateStatus::hasLanguageType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 PhoneticsUpdateStatus::getLanguageType () const {
    return _LanguageType;
}

inline void PhoneticsUpdateStatus::setLanguageType (uint8 LanguageType_) {
    set_has_LanguageType();
    this->_LanguageType = LanguageType_;
}

inline void PhoneticsUpdateStatus::set_has_PhoneticsType () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhoneticsUpdateStatus::clear_has_PhoneticsType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PhoneticsUpdateStatus::set_has_LanguageType () {
    _has_bits_[0] |= 1u << 1;
}

inline void PhoneticsUpdateStatus::clear_has_LanguageType () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace sxm_phonetics_main_fi

#endif // SXM_PHONETICS_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
