#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_PARKING_MAIN_FI_TYPES_H
#define SXM_PARKING_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_types.h"
#include "sxm_parking_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types sxm_parking_main_fi_types
 */

namespace sxm_parking_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_Fullness;

class T_AmenityInfo;

class T_PriceInfo;

class T_Time;

class T_PerDayOpeningTimes;

class T_OpeningTime;

class T_ParkingInfo;

class T_FilterConfig;

class T_AmenityConfig;

class T_FilterConfiguration;


/**
 * If the meaning of "T_Fullness" isn't clear, then there should be a description here.
 */
class T_Fullness {
public:

    /**
     * Default constructor
     */
    inline  T_Fullness ();

    /**
     * Copy constructor
     */
    inline  T_Fullness (const T_Fullness &rhs);

    /**
     * All fields constructor
     */
    inline  T_Fullness (T_e8FullType Type_, uint16 Value_);

    /**
     * Destructor
     */
    inline  ~T_Fullness();

    /**
     * Assignment operator
     */
    inline T_Fullness& operator = (const T_Fullness& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Fullness& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Fullness& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Fullness& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Fullness& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * Fullness type
     *
     * @return The value of the field "Type"
     */
    inline T_e8FullType getType () const;

    /**
     * Sets the value of the member "Type".
     *
     * Fullness type
     *
     * @param Type The value which will be set
     */
    inline void setType (T_e8FullType Type_);

    // API of field "Value"

    static const int kValue = 1;

    /**
     * Clears the field "Value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "Value".
     *
     * Fullness Value
     *
     * @return The value of the field "Value"
     */
    inline uint16 getValue () const;

    /**
     * Sets the value of the member "Value".
     *
     * Fullness Value
     *
     * @param Value The value which will be set
     */
    inline void setValue (uint16 Value_);

    static const T_Fullness &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    inline void set_has_Value ();

    inline void clear_has_Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8FullType _Type;

    uint16 _Value;

};

/**
 * If the meaning of "T_AmenityInfo" isn't clear, then there should be a description here.
 */
class T_AmenityInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AmenityInfo ();

    /**
     * Copy constructor
     */
    inline  T_AmenityInfo (const T_AmenityInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AmenityInfo (T_e8Open24Hours Open24Hours_, T_e8CashOrCard Cash_, T_e8CashOrCard Card_, T_e8ParkingType ParkingType_, T_e8MetroLocation MetroLocation_, T_e8AirPort AirPort_, T_e8OvernightParking OvernightParking_, T_e8Reservations Reservations_, T_e8SelfParking SelfParking_, T_e8Security Security_, T_e8TollTag TollTag_, T_e8SUVCharges SUVCharges_, T_e8RV RV_);

    /**
     * Destructor
     */
    inline  ~T_AmenityInfo();

    /**
     * Assignment operator
     */
    inline T_AmenityInfo& operator = (const T_AmenityInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AmenityInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AmenityInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AmenityInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AmenityInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Open24Hours"

    static const int kOpen24Hours = 0;

    /**
     * Clears the field "Open24Hours".
     *
     * The field will be set to its default value. The hasOpen24Hours()
     * method will return false.
     */
    inline void clearOpen24Hours();

    /**
     * Checks whether the field "Open24Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpen24Hours()). Otherwise it will return false.
     */
    inline bool hasOpen24Hours () const;

    /**
     * Returns the value of the member "Open24Hours".
     *
     * field indicates parking location availability for 24 hours
     *
     * @return The value of the field "Open24Hours"
     */
    inline T_e8Open24Hours getOpen24Hours () const;

    /**
     * Sets the value of the member "Open24Hours".
     *
     * field indicates parking location availability for 24 hours
     *
     * @param Open24Hours The value which will be set
     */
    inline void setOpen24Hours (T_e8Open24Hours Open24Hours_);

    // API of field "Cash"

    static const int kCash = 1;

    /**
     * Clears the field "Cash".
     *
     * The field will be set to its default value. The hasCash()
     * method will return false.
     */
    inline void clearCash();

    /**
     * Checks whether the field "Cash" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCash()). Otherwise it will return false.
     */
    inline bool hasCash () const;

    /**
     * Returns the value of the member "Cash".
     *
     * field indicates parking location Cash acceptance
     *
     * @return The value of the field "Cash"
     */
    inline T_e8CashOrCard getCash () const;

    /**
     * Sets the value of the member "Cash".
     *
     * field indicates parking location Cash acceptance
     *
     * @param Cash The value which will be set
     */
    inline void setCash (T_e8CashOrCard Cash_);

    // API of field "Card"

    static const int kCard = 2;

    /**
     * Clears the field "Card".
     *
     * The field will be set to its default value. The hasCard()
     * method will return false.
     */
    inline void clearCard();

    /**
     * Checks whether the field "Card" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCard()). Otherwise it will return false.
     */
    inline bool hasCard () const;

    /**
     * Returns the value of the member "Card".
     *
     * field indicates parking location Credit or Debit Card acceptance
     *
     * @return The value of the field "Card"
     */
    inline T_e8CashOrCard getCard () const;

    /**
     * Sets the value of the member "Card".
     *
     * field indicates parking location Credit or Debit Card acceptance
     *
     * @param Card The value which will be set
     */
    inline void setCard (T_e8CashOrCard Card_);

    // API of field "ParkingType"

    static const int kParkingType = 3;

    /**
     * Clears the field "ParkingType".
     *
     * The field will be set to its default value. The hasParkingType()
     * method will return false.
     */
    inline void clearParkingType();

    /**
     * Checks whether the field "ParkingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingType()). Otherwise it will return false.
     */
    inline bool hasParkingType () const;

    /**
     * Returns the value of the member "ParkingType".
     *
     * field indicates parking type
     *
     * @return The value of the field "ParkingType"
     */
    inline T_e8ParkingType getParkingType () const;

    /**
     * Sets the value of the member "ParkingType".
     *
     * field indicates parking type
     *
     * @param ParkingType The value which will be set
     */
    inline void setParkingType (T_e8ParkingType ParkingType_);

    // API of field "MetroLocation"

    static const int kMetroLocation = 4;

    /**
     * Clears the field "MetroLocation".
     *
     * The field will be set to its default value. The hasMetroLocation()
     * method will return false.
     */
    inline void clearMetroLocation();

    /**
     * Checks whether the field "MetroLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMetroLocation()). Otherwise it will return false.
     */
    inline bool hasMetroLocation () const;

    /**
     * Returns the value of the member "MetroLocation".
     *
     * field indicates parking location distance to Metro
     *
     * @return The value of the field "MetroLocation"
     */
    inline T_e8MetroLocation getMetroLocation () const;

    /**
     * Sets the value of the member "MetroLocation".
     *
     * field indicates parking location distance to Metro
     *
     * @param MetroLocation The value which will be set
     */
    inline void setMetroLocation (T_e8MetroLocation MetroLocation_);

    // API of field "AirPort"

    static const int kAirPort = 5;

    /**
     * Clears the field "AirPort".
     *
     * The field will be set to its default value. The hasAirPort()
     * method will return false.
     */
    inline void clearAirPort();

    /**
     * Checks whether the field "AirPort" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAirPort()). Otherwise it will return false.
     */
    inline bool hasAirPort () const;

    /**
     * Returns the value of the member "AirPort".
     *
     * field indicates is parking location belongs to airport
     *
     * @return The value of the field "AirPort"
     */
    inline T_e8AirPort getAirPort () const;

    /**
     * Sets the value of the member "AirPort".
     *
     * field indicates is parking location belongs to airport
     *
     * @param AirPort The value which will be set
     */
    inline void setAirPort (T_e8AirPort AirPort_);

    // API of field "OvernightParking"

    static const int kOvernightParking = 6;

    /**
     * Clears the field "OvernightParking".
     *
     * The field will be set to its default value. The hasOvernightParking()
     * method will return false.
     */
    inline void clearOvernightParking();

    /**
     * Checks whether the field "OvernightParking" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOvernightParking()). Otherwise it will return false.
     */
    inline bool hasOvernightParking () const;

    /**
     * Returns the value of the member "OvernightParking".
     *
     * field indicates parking location availability for overnight
     *
     * @return The value of the field "OvernightParking"
     */
    inline T_e8OvernightParking getOvernightParking () const;

    /**
     * Sets the value of the member "OvernightParking".
     *
     * field indicates parking location availability for overnight
     *
     * @param OvernightParking The value which will be set
     */
    inline void setOvernightParking (T_e8OvernightParking OvernightParking_);

    // API of field "Reservations"

    static const int kReservations = 7;

    /**
     * Clears the field "Reservations".
     *
     * The field will be set to its default value. The hasReservations()
     * method will return false.
     */
    inline void clearReservations();

    /**
     * Checks whether the field "Reservations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReservations()). Otherwise it will return false.
     */
    inline bool hasReservations () const;

    /**
     * Returns the value of the member "Reservations".
     *
     * field indicates Reservations availability of parking location
     *
     * @return The value of the field "Reservations"
     */
    inline T_e8Reservations getReservations () const;

    /**
     * Sets the value of the member "Reservations".
     *
     * field indicates Reservations availability of parking location
     *
     * @param Reservations The value which will be set
     */
    inline void setReservations (T_e8Reservations Reservations_);

    // API of field "SelfParking"

    static const int kSelfParking = 8;

    /**
     * Clears the field "SelfParking".
     *
     * The field will be set to its default value. The hasSelfParking()
     * method will return false.
     */
    inline void clearSelfParking();

    /**
     * Checks whether the field "SelfParking" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelfParking()). Otherwise it will return false.
     */
    inline bool hasSelfParking () const;

    /**
     * Returns the value of the member "SelfParking".
     *
     * field indicates Self and Valet parking availability
     *
     * @return The value of the field "SelfParking"
     */
    inline T_e8SelfParking getSelfParking () const;

    /**
     * Sets the value of the member "SelfParking".
     *
     * field indicates Self and Valet parking availability
     *
     * @param SelfParking The value which will be set
     */
    inline void setSelfParking (T_e8SelfParking SelfParking_);

    // API of field "Security"

    static const int kSecurity = 9;

    /**
     * Clears the field "Security".
     *
     * The field will be set to its default value. The hasSecurity()
     * method will return false.
     */
    inline void clearSecurity();

    /**
     * Checks whether the field "Security" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurity()). Otherwise it will return false.
     */
    inline bool hasSecurity () const;

    /**
     * Returns the value of the member "Security".
     *
     * field indicates Security details of parking location
     *
     * @return The value of the field "Security"
     */
    inline T_e8Security getSecurity () const;

    /**
     * Sets the value of the member "Security".
     *
     * field indicates Security details of parking location
     *
     * @param Security The value which will be set
     */
    inline void setSecurity (T_e8Security Security_);

    // API of field "TollTag"

    static const int kTollTag = 10;

    /**
     * Clears the field "TollTag".
     *
     * The field will be set to its default value. The hasTollTag()
     * method will return false.
     */
    inline void clearTollTag();

    /**
     * Checks whether the field "TollTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTollTag()). Otherwise it will return false.
     */
    inline bool hasTollTag () const;

    /**
     * Returns the value of the member "TollTag".
     *
     * field indicates parking location Toll Tag payment acceptance
     *
     * @return The value of the field "TollTag"
     */
    inline T_e8TollTag getTollTag () const;

    /**
     * Sets the value of the member "TollTag".
     *
     * field indicates parking location Toll Tag payment acceptance
     *
     * @param TollTag The value which will be set
     */
    inline void setTollTag (T_e8TollTag TollTag_);

    // API of field "SUVCharges"

    static const int kSUVCharges = 11;

    /**
     * Clears the field "SUVCharges".
     *
     * The field will be set to its default value. The hasSUVCharges()
     * method will return false.
     */
    inline void clearSUVCharges();

    /**
     * Checks whether the field "SUVCharges" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUVCharges()). Otherwise it will return false.
     */
    inline bool hasSUVCharges () const;

    /**
     * Returns the value of the member "SUVCharges".
     *
     * field indicates SUV or Van extra charges
     *
     * @return The value of the field "SUVCharges"
     */
    inline T_e8SUVCharges getSUVCharges () const;

    /**
     * Sets the value of the member "SUVCharges".
     *
     * field indicates SUV or Van extra charges
     *
     * @param SUVCharges The value which will be set
     */
    inline void setSUVCharges (T_e8SUVCharges SUVCharges_);

    // API of field "RV"

    static const int kRV = 12;

    /**
     * Clears the field "RV".
     *
     * The field will be set to its default value. The hasRV()
     * method will return false.
     */
    inline void clearRV();

    /**
     * Checks whether the field "RV" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRV()). Otherwise it will return false.
     */
    inline bool hasRV () const;

    /**
     * Returns the value of the member "RV".
     *
     * field indicates availability details for RVs
     *
     * @return The value of the field "RV"
     */
    inline T_e8RV getRV () const;

    /**
     * Sets the value of the member "RV".
     *
     * field indicates availability details for RVs
     *
     * @param RV The value which will be set
     */
    inline void setRV (T_e8RV RV_);

    static const T_AmenityInfo &getDefaultInstance();

private:

    inline void set_has_Open24Hours ();

    inline void clear_has_Open24Hours ();

    inline void set_has_Cash ();

    inline void clear_has_Cash ();

    inline void set_has_Card ();

    inline void clear_has_Card ();

    inline void set_has_ParkingType ();

    inline void clear_has_ParkingType ();

    inline void set_has_MetroLocation ();

    inline void clear_has_MetroLocation ();

    inline void set_has_AirPort ();

    inline void clear_has_AirPort ();

    inline void set_has_OvernightParking ();

    inline void clear_has_OvernightParking ();

    inline void set_has_Reservations ();

    inline void clear_has_Reservations ();

    inline void set_has_SelfParking ();

    inline void clear_has_SelfParking ();

    inline void set_has_Security ();

    inline void clear_has_Security ();

    inline void set_has_TollTag ();

    inline void clear_has_TollTag ();

    inline void set_has_SUVCharges ();

    inline void clear_has_SUVCharges ();

    inline void set_has_RV ();

    inline void clear_has_RV ();

    uint32 _has_bits_[ (13 + 31) / 32];

    T_e8Open24Hours _Open24Hours;

    T_e8CashOrCard _Cash;

    T_e8CashOrCard _Card;

    T_e8ParkingType _ParkingType;

    T_e8MetroLocation _MetroLocation;

    T_e8AirPort _AirPort;

    T_e8OvernightParking _OvernightParking;

    T_e8Reservations _Reservations;

    T_e8SelfParking _SelfParking;

    T_e8Security _Security;

    T_e8TollTag _TollTag;

    T_e8SUVCharges _SUVCharges;

    T_e8RV _RV;

};

/**
 * If the meaning of "T_PriceInfo" isn't clear, then there should be a description here.
 */
class T_PriceInfo {
public:

    /**
     * Default constructor
     */
    inline  T_PriceInfo ();

    /**
     * Copy constructor
     */
    inline  T_PriceInfo (const T_PriceInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_PriceInfo (const ::std::vector< float >& WeekdayHourly_, const ::std::vector< float >& SaturdayHourly_, const ::std::vector< float >& SundayHourly_, float WeekdayDaily_, float SaturdayDaily_, float SundayDaily_, float EarlyBird_, float Event_, float Other_);

    /**
     * Destructor
     */
    inline  ~T_PriceInfo();

    /**
     * Assignment operator
     */
    inline T_PriceInfo& operator = (const T_PriceInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PriceInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PriceInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PriceInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PriceInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WeekdayHourly"

    static const int kWeekdayHourly = 0;

    /**
     * Clears the field "WeekdayHourly".
     *
     * The field will be set to its default value. The hasWeekdayHourly()
     * method will return false.
     */
    inline void clearWeekdayHourly();

    /**
     * Checks whether the field "WeekdayHourly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWeekdayHourly()). Otherwise it will return false.
     */
    inline bool hasWeekdayHourly () const;

    /**
     * Returns the value of the member "WeekdayHourly".
     *
     * list of prices for each hour of occupancy during a Weekday
     *
     * @return The value of the field "WeekdayHourly"
     */
    inline const ::std::vector< float >& getWeekdayHourly () const;

    /**
     * Retrieves the value of the field "WeekdayHourly" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WeekdayHourly".
     */
    inline ::std::vector< float >& getWeekdayHourlyMutable ();

    /**
     * Sets the value of the member "WeekdayHourly".
     *
     * list of prices for each hour of occupancy during a Weekday
     *
     * @param WeekdayHourly The value which will be set
     */
    inline void setWeekdayHourly (const ::std::vector< float >& WeekdayHourly_);

    // API of field "SaturdayHourly"

    static const int kSaturdayHourly = 1;

    /**
     * Clears the field "SaturdayHourly".
     *
     * The field will be set to its default value. The hasSaturdayHourly()
     * method will return false.
     */
    inline void clearSaturdayHourly();

    /**
     * Checks whether the field "SaturdayHourly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSaturdayHourly()). Otherwise it will return false.
     */
    inline bool hasSaturdayHourly () const;

    /**
     * Returns the value of the member "SaturdayHourly".
     *
     * list of prices for each hour of occupancy during a Saturday
     *
     * @return The value of the field "SaturdayHourly"
     */
    inline const ::std::vector< float >& getSaturdayHourly () const;

    /**
     * Retrieves the value of the field "SaturdayHourly" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SaturdayHourly".
     */
    inline ::std::vector< float >& getSaturdayHourlyMutable ();

    /**
     * Sets the value of the member "SaturdayHourly".
     *
     * list of prices for each hour of occupancy during a Saturday
     *
     * @param SaturdayHourly The value which will be set
     */
    inline void setSaturdayHourly (const ::std::vector< float >& SaturdayHourly_);

    // API of field "SundayHourly"

    static const int kSundayHourly = 2;

    /**
     * Clears the field "SundayHourly".
     *
     * The field will be set to its default value. The hasSundayHourly()
     * method will return false.
     */
    inline void clearSundayHourly();

    /**
     * Checks whether the field "SundayHourly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSundayHourly()). Otherwise it will return false.
     */
    inline bool hasSundayHourly () const;

    /**
     * Returns the value of the member "SundayHourly".
     *
     * list of prices for each hour of occupancy during a Sunday
     *
     * @return The value of the field "SundayHourly"
     */
    inline const ::std::vector< float >& getSundayHourly () const;

    /**
     * Retrieves the value of the field "SundayHourly" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SundayHourly".
     */
    inline ::std::vector< float >& getSundayHourlyMutable ();

    /**
     * Sets the value of the member "SundayHourly".
     *
     * list of prices for each hour of occupancy during a Sunday
     *
     * @param SundayHourly The value which will be set
     */
    inline void setSundayHourly (const ::std::vector< float >& SundayHourly_);

    // API of field "WeekdayDaily"

    static const int kWeekdayDaily = 3;

    /**
     * Clears the field "WeekdayDaily".
     *
     * The field will be set to its default value. The hasWeekdayDaily()
     * method will return false.
     */
    inline void clearWeekdayDaily();

    /**
     * Checks whether the field "WeekdayDaily" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWeekdayDaily()). Otherwise it will return false.
     */
    inline bool hasWeekdayDaily () const;

    /**
     * Returns the value of the member "WeekdayDaily".
     *
     * the price of all-day parking on a weekday
     *
     * @return The value of the field "WeekdayDaily"
     */
    inline float getWeekdayDaily () const;

    /**
     * Sets the value of the member "WeekdayDaily".
     *
     * the price of all-day parking on a weekday
     *
     * @param WeekdayDaily The value which will be set
     */
    inline void setWeekdayDaily (float WeekdayDaily_);

    // API of field "SaturdayDaily"

    static const int kSaturdayDaily = 4;

    /**
     * Clears the field "SaturdayDaily".
     *
     * The field will be set to its default value. The hasSaturdayDaily()
     * method will return false.
     */
    inline void clearSaturdayDaily();

    /**
     * Checks whether the field "SaturdayDaily" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSaturdayDaily()). Otherwise it will return false.
     */
    inline bool hasSaturdayDaily () const;

    /**
     * Returns the value of the member "SaturdayDaily".
     *
     * the price of all-day parking on a Saturday
     *
     * @return The value of the field "SaturdayDaily"
     */
    inline float getSaturdayDaily () const;

    /**
     * Sets the value of the member "SaturdayDaily".
     *
     * the price of all-day parking on a Saturday
     *
     * @param SaturdayDaily The value which will be set
     */
    inline void setSaturdayDaily (float SaturdayDaily_);

    // API of field "SundayDaily"

    static const int kSundayDaily = 5;

    /**
     * Clears the field "SundayDaily".
     *
     * The field will be set to its default value. The hasSundayDaily()
     * method will return false.
     */
    inline void clearSundayDaily();

    /**
     * Checks whether the field "SundayDaily" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSundayDaily()). Otherwise it will return false.
     */
    inline bool hasSundayDaily () const;

    /**
     * Returns the value of the member "SundayDaily".
     *
     * the price of all-day parking on a Sunday
     *
     * @return The value of the field "SundayDaily"
     */
    inline float getSundayDaily () const;

    /**
     * Sets the value of the member "SundayDaily".
     *
     * the price of all-day parking on a Sunday
     *
     * @param SundayDaily The value which will be set
     */
    inline void setSundayDaily (float SundayDaily_);

    // API of field "EarlyBird"

    static const int kEarlyBird = 6;

    /**
     * Clears the field "EarlyBird".
     *
     * The field will be set to its default value. The hasEarlyBird()
     * method will return false.
     */
    inline void clearEarlyBird();

    /**
     * Checks whether the field "EarlyBird" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEarlyBird()). Otherwise it will return false.
     */
    inline bool hasEarlyBird () const;

    /**
     * Returns the value of the member "EarlyBird".
     *
     * where if a vehicle arrives before a certain time it gets a special single day rate
     *
     * @return The value of the field "EarlyBird"
     */
    inline float getEarlyBird () const;

    /**
     * Sets the value of the member "EarlyBird".
     *
     * where if a vehicle arrives before a certain time it gets a special single day rate
     *
     * @param EarlyBird The value which will be set
     */
    inline void setEarlyBird (float EarlyBird_);

    // API of field "Event"

    static const int kEvent = 7;

    /**
     * Clears the field "Event".
     *
     * The field will be set to its default value. The hasEvent()
     * method will return false.
     */
    inline void clearEvent();

    /**
     * Checks whether the field "Event" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEvent()). Otherwise it will return false.
     */
    inline bool hasEvent () const;

    /**
     * Returns the value of the member "Event".
     *
     * where a location may override its normal rates for a day due to a
     * special event that may be taking place in the vicinity of the Parking Location
     *
     * @return The value of the field "Event"
     */
    inline float getEvent () const;

    /**
     * Sets the value of the member "Event".
     *
     * where a location may override its normal rates for a day due to a
     * special event that may be taking place in the vicinity of the Parking Location
     *
     * @param Event The value which will be set
     */
    inline void setEvent (float Event_);

    // API of field "Other"

    static const int kOther = 8;

    /**
     * Clears the field "Other".
     *
     * The field will be set to its default value. The hasOther()
     * method will return false.
     */
    inline void clearOther();

    /**
     * Checks whether the field "Other" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOther()). Otherwise it will return false.
     */
    inline bool hasOther () const;

    /**
     * Returns the value of the member "Other".
     *
     * which is special pricing that does not fall into one of the two
     * normal categories
     *
     * @return The value of the field "Other"
     */
    inline float getOther () const;

    /**
     * Sets the value of the member "Other".
     *
     * which is special pricing that does not fall into one of the two
     * normal categories
     *
     * @param Other The value which will be set
     */
    inline void setOther (float Other_);

    static const T_PriceInfo &getDefaultInstance();

private:

    static const ::std::vector< float >& getFloatList_DefaultInstance ();

    inline void set_has_WeekdayHourly ();

    inline void clear_has_WeekdayHourly ();

    inline void set_has_SaturdayHourly ();

    inline void clear_has_SaturdayHourly ();

    inline void set_has_SundayHourly ();

    inline void clear_has_SundayHourly ();

    inline void set_has_WeekdayDaily ();

    inline void clear_has_WeekdayDaily ();

    inline void set_has_SaturdayDaily ();

    inline void clear_has_SaturdayDaily ();

    inline void set_has_SundayDaily ();

    inline void clear_has_SundayDaily ();

    inline void set_has_EarlyBird ();

    inline void clear_has_EarlyBird ();

    inline void set_has_Event ();

    inline void clear_has_Event ();

    inline void set_has_Other ();

    inline void clear_has_Other ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::std::vector< float > _WeekdayHourly;

    ::std::vector< float > _SaturdayHourly;

    ::std::vector< float > _SundayHourly;

    float _WeekdayDaily;

    float _SaturdayDaily;

    float _SundayDaily;

    float _EarlyBird;

    float _Event;

    float _Other;

};

/**
 * If the meaning of "T_Time" isn't clear, then there should be a description here.
 */
class T_Time {
public:

    /**
     * Default constructor
     */
    inline  T_Time ();

    /**
     * Copy constructor
     */
    inline  T_Time (const T_Time &rhs);

    /**
     * All fields constructor
     */
    inline  T_Time (uint32 Hours_, uint32 Minutes_);

    /**
     * Destructor
     */
    inline  ~T_Time();

    /**
     * Assignment operator
     */
    inline T_Time& operator = (const T_Time& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Time& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Time& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Time& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Time& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Hours"

    static const int kHours = 0;

    /**
     * Clears the field "Hours".
     *
     * The field will be set to its default value. The hasHours()
     * method will return false.
     */
    inline void clearHours();

    /**
     * Checks whether the field "Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHours()). Otherwise it will return false.
     */
    inline bool hasHours () const;

    /**
     * Returns the value of the member "Hours".
     *
     * Hours
     *
     * @return The value of the field "Hours"
     */
    inline uint32 getHours () const;

    /**
     * Sets the value of the member "Hours".
     *
     * Hours
     *
     * @param Hours The value which will be set
     */
    inline void setHours (uint32 Hours_);

    // API of field "Minutes"

    static const int kMinutes = 1;

    /**
     * Clears the field "Minutes".
     *
     * The field will be set to its default value. The hasMinutes()
     * method will return false.
     */
    inline void clearMinutes();

    /**
     * Checks whether the field "Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinutes()). Otherwise it will return false.
     */
    inline bool hasMinutes () const;

    /**
     * Returns the value of the member "Minutes".
     *
     * Minutes
     *
     * @return The value of the field "Minutes"
     */
    inline uint32 getMinutes () const;

    /**
     * Sets the value of the member "Minutes".
     *
     * Minutes
     *
     * @param Minutes The value which will be set
     */
    inline void setMinutes (uint32 Minutes_);

    static const T_Time &getDefaultInstance();

private:

    inline void set_has_Hours ();

    inline void clear_has_Hours ();

    inline void set_has_Minutes ();

    inline void clear_has_Minutes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _Hours;

    uint32 _Minutes;

};

/**
 * If the meaning of "T_PerDayOpeningTimes" isn't clear, then there should be a description here.
 */
class T_PerDayOpeningTimes {
public:

    /**
     * Default constructor
     */
    inline  T_PerDayOpeningTimes ();

    /**
     * Copy constructor
     */
    inline  T_PerDayOpeningTimes (const T_PerDayOpeningTimes &rhs);

    /**
     * All fields constructor
     */
    inline  T_PerDayOpeningTimes (const T_Time& StartTime_, const T_Time& EndTime_);

    /**
     * Destructor
     */
    inline  ~T_PerDayOpeningTimes();

    /**
     * Assignment operator
     */
    inline T_PerDayOpeningTimes& operator = (const T_PerDayOpeningTimes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PerDayOpeningTimes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PerDayOpeningTimes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PerDayOpeningTimes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PerDayOpeningTimes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartTime"

    static const int kStartTime = 0;

    /**
     * Clears the field "StartTime".
     *
     * The field will be set to its default value. The hasStartTime()
     * method will return false.
     */
    inline void clearStartTime();

    /**
     * Checks whether the field "StartTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartTime()). Otherwise it will return false.
     */
    inline bool hasStartTime () const;

    /**
     * Returns the value of the member "StartTime".
     *
     * Start time(24 hour)
     *
     * @return The value of the field "StartTime"
     */
    inline const T_Time& getStartTime () const;

    /**
     * Retrieves the value of the field "StartTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StartTime".
     */
    inline T_Time& getStartTimeMutable ();

    /**
     * Sets the value of the member "StartTime".
     *
     * Start time(24 hour)
     *
     * @param StartTime The value which will be set
     */
    inline void setStartTime (const T_Time& StartTime_);

    // API of field "EndTime"

    static const int kEndTime = 1;

    /**
     * Clears the field "EndTime".
     *
     * The field will be set to its default value. The hasEndTime()
     * method will return false.
     */
    inline void clearEndTime();

    /**
     * Checks whether the field "EndTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEndTime()). Otherwise it will return false.
     */
    inline bool hasEndTime () const;

    /**
     * Returns the value of the member "EndTime".
     *
     * Closing time(24 hour)
     *
     * @return The value of the field "EndTime"
     */
    inline const T_Time& getEndTime () const;

    /**
     * Retrieves the value of the field "EndTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EndTime".
     */
    inline T_Time& getEndTimeMutable ();

    /**
     * Sets the value of the member "EndTime".
     *
     * Closing time(24 hour)
     *
     * @param EndTime The value which will be set
     */
    inline void setEndTime (const T_Time& EndTime_);

    static const T_PerDayOpeningTimes &getDefaultInstance();

private:

    inline void set_has_StartTime ();

    inline void clear_has_StartTime ();

    inline void set_has_EndTime ();

    inline void clear_has_EndTime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_Time _StartTime;

    T_Time _EndTime;

};

/**
 * If the meaning of "T_OpeningTime" isn't clear, then there should be a description here.
 */
class T_OpeningTime {
public:

    /**
     * Default constructor
     */
    inline  T_OpeningTime ();

    /**
     * Copy constructor
     */
    inline  T_OpeningTime (const T_OpeningTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_OpeningTime (T_e8DayType DayType_, const ::std::vector< T_PerDayOpeningTimes >& PerDayOpeningTimes_);

    /**
     * Destructor
     */
    inline  ~T_OpeningTime();

    /**
     * Assignment operator
     */
    inline T_OpeningTime& operator = (const T_OpeningTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_OpeningTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_OpeningTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_OpeningTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_OpeningTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DayType"

    static const int kDayType = 0;

    /**
     * Clears the field "DayType".
     *
     * The field will be set to its default value. The hasDayType()
     * method will return false.
     */
    inline void clearDayType();

    /**
     * Checks whether the field "DayType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDayType()). Otherwise it will return false.
     */
    inline bool hasDayType () const;

    /**
     * Returns the value of the member "DayType".
     *
     * For which day opening time belongs to
     *
     * @return The value of the field "DayType"
     */
    inline T_e8DayType getDayType () const;

    /**
     * Sets the value of the member "DayType".
     *
     * For which day opening time belongs to
     *
     * @param DayType The value which will be set
     */
    inline void setDayType (T_e8DayType DayType_);

    // API of field "PerDayOpeningTimes"

    static const int kPerDayOpeningTimes = 1;

    /**
     * Clears the field "PerDayOpeningTimes".
     *
     * The field will be set to its default value. The hasPerDayOpeningTimes()
     * method will return false.
     */
    inline void clearPerDayOpeningTimes();

    /**
     * Checks whether the field "PerDayOpeningTimes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPerDayOpeningTimes()). Otherwise it will return false.
     */
    inline bool hasPerDayOpeningTimes () const;

    /**
     * Returns the value of the member "PerDayOpeningTimes".
     *
     * List of opening times per week,If specified hours are present.
     * <p>In case of Open 24 hours - Start and End time would be 24 hours,</p>
     * <p>In case of Closed for the day - Start and End time would be 00 hours.</p>
     *
     * @return The value of the field "PerDayOpeningTimes"
     */
    inline const ::std::vector< T_PerDayOpeningTimes >& getPerDayOpeningTimes () const;

    /**
     * Retrieves the value of the field "PerDayOpeningTimes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PerDayOpeningTimes".
     */
    inline ::std::vector< T_PerDayOpeningTimes >& getPerDayOpeningTimesMutable ();

    /**
     * Sets the value of the member "PerDayOpeningTimes".
     *
     * List of opening times per week,If specified hours are present.
     * <p>In case of Open 24 hours - Start and End time would be 24 hours,</p>
     * <p>In case of Closed for the day - Start and End time would be 00 hours.</p>
     *
     * @param PerDayOpeningTimes The value which will be set
     */
    inline void setPerDayOpeningTimes (const ::std::vector< T_PerDayOpeningTimes >& PerDayOpeningTimes_);

    static const T_OpeningTime &getDefaultInstance();

private:

    static const ::std::vector< T_PerDayOpeningTimes >& getT_PerDayOpeningTimesList_DefaultInstance ();

    inline void set_has_DayType ();

    inline void clear_has_DayType ();

    inline void set_has_PerDayOpeningTimes ();

    inline void clear_has_PerDayOpeningTimes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8DayType _DayType;

    ::std::vector< T_PerDayOpeningTimes > _PerDayOpeningTimes;

};

/**
 * If the meaning of "T_ParkingInfo" isn't clear, then there should be a description here.
 */
class T_ParkingInfo {
public:

    /**
     * Default constructor
     */
    inline  T_ParkingInfo ();

    /**
     * Copy constructor
     */
    inline  T_ParkingInfo (const T_ParkingInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_ParkingInfo (uint32 ID_, const ::std::string& Name_, const ::std::string& Address_, const ::std::string& SecondaryAddress_, const ::std::string& City_, const ::std::string& Zip_, const ::std::string& State_, const ::std::string& Phone_, uint32 Capacity_, float Distance_, const ::fi_types::T_PositionWGS84& PrimaryLocation_, const ::fi_types::T_PositionWGS84& SecondaryLocation_, uint32 PrimaryHeight_, uint32 SecondaryHeight_, uint32 AvailableTime_, uint8 RelativePricingHourly_, uint8 RelativePricingDaily_, T_e8OpenStatus OpenStatus_, const ::std::vector< T_OpeningTime >& OpeningTimes_, const ::std::vector< T_Fullness >& Fullness_, const T_AmenityInfo& Amenities_, const T_PriceInfo& PricingInfo_, bool IsFavorite_);

    /**
     * Destructor
     */
    inline  ~T_ParkingInfo();

    /**
     * Assignment operator
     */
    inline T_ParkingInfo& operator = (const T_ParkingInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ParkingInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ParkingInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ParkingInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ParkingInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * Unique ID of a parking location
     *
     * @return The value of the field "ID"
     */
    inline uint32 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * Unique ID of a parking location
     *
     * @param ID The value which will be set
     */
    inline void setID (uint32 ID_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Parking Location Name
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Parking Location Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Parking Location Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Parking Location Name
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "Address"

    static const int kAddress = 2;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * Parking address
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * Parking address
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Parking address
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Parking address
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "SecondaryAddress"

    static const int kSecondaryAddress = 3;

    /**
     * Clears the field "SecondaryAddress".
     *
     * The field will be set to its default value. The hasSecondaryAddress()
     * method will return false.
     */
    inline void clearSecondaryAddress();

    /**
     * Checks whether the field "SecondaryAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondaryAddress()). Otherwise it will return false.
     */
    inline bool hasSecondaryAddress () const;

    /**
     * Returns the value of the member "SecondaryAddress".
     *
     * Secondary Location address
     *
     * @return The value of the field "SecondaryAddress"
     */
    inline const ::std::string& getSecondaryAddress () const;

    /**
     * Retrieves the value of the field "SecondaryAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SecondaryAddress".
     */
    inline ::std::string& getSecondaryAddressMutable ();

    /**
     * Sets the value of the member "SecondaryAddress".
     *
     * Secondary Location address
     *
     * @param SecondaryAddress The value which will be set
     */
    inline void setSecondaryAddress (const ::std::string& SecondaryAddress_);

    /**
     * Sets the value of the member "SecondaryAddress".
     *
     * Secondary Location address
     *
     * @param SecondaryAddress The value which will be set
     */
    inline void setSecondaryAddress (const char* SecondaryAddress_);

    /**
     * Sets the value of the member "SecondaryAddress".
     *
     * Secondary Location address
     *
     * @param SecondaryAddress The value which will be set
     */
    inline void setSecondaryAddress (const char* value, size_t size);

    // API of field "City"

    static const int kCity = 4;

    /**
     * Clears the field "City".
     *
     * The field will be set to its default value. The hasCity()
     * method will return false.
     */
    inline void clearCity();

    /**
     * Checks whether the field "City" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCity()). Otherwise it will return false.
     */
    inline bool hasCity () const;

    /**
     * Returns the value of the member "City".
     *
     * City Name
     *
     * @return The value of the field "City"
     */
    inline const ::std::string& getCity () const;

    /**
     * Retrieves the value of the field "City" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "City".
     */
    inline ::std::string& getCityMutable ();

    /**
     * Sets the value of the member "City".
     *
     * City Name
     *
     * @param City The value which will be set
     */
    inline void setCity (const ::std::string& City_);

    /**
     * Sets the value of the member "City".
     *
     * City Name
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* City_);

    /**
     * Sets the value of the member "City".
     *
     * City Name
     *
     * @param City The value which will be set
     */
    inline void setCity (const char* value, size_t size);

    // API of field "Zip"

    static const int kZip = 5;

    /**
     * Clears the field "Zip".
     *
     * The field will be set to its default value. The hasZip()
     * method will return false.
     */
    inline void clearZip();

    /**
     * Checks whether the field "Zip" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setZip()). Otherwise it will return false.
     */
    inline bool hasZip () const;

    /**
     * Returns the value of the member "Zip".
     *
     * ZIP Value
     *
     * @return The value of the field "Zip"
     */
    inline const ::std::string& getZip () const;

    /**
     * Retrieves the value of the field "Zip" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Zip".
     */
    inline ::std::string& getZipMutable ();

    /**
     * Sets the value of the member "Zip".
     *
     * ZIP Value
     *
     * @param Zip The value which will be set
     */
    inline void setZip (const ::std::string& Zip_);

    /**
     * Sets the value of the member "Zip".
     *
     * ZIP Value
     *
     * @param Zip The value which will be set
     */
    inline void setZip (const char* Zip_);

    /**
     * Sets the value of the member "Zip".
     *
     * ZIP Value
     *
     * @param Zip The value which will be set
     */
    inline void setZip (const char* value, size_t size);

    // API of field "State"

    static const int kState = 6;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * State Name in Short Form
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * State Name in Short Form
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * State Name in Short Form
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * State Name in Short Form
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    // API of field "Phone"

    static const int kPhone = 7;

    /**
     * Clears the field "Phone".
     *
     * The field will be set to its default value. The hasPhone()
     * method will return false.
     */
    inline void clearPhone();

    /**
     * Checks whether the field "Phone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhone()). Otherwise it will return false.
     */
    inline bool hasPhone () const;

    /**
     * Returns the value of the member "Phone".
     *
     * Parking location Phone Number
     *
     * @return The value of the field "Phone"
     */
    inline const ::std::string& getPhone () const;

    /**
     * Retrieves the value of the field "Phone" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Phone".
     */
    inline ::std::string& getPhoneMutable ();

    /**
     * Sets the value of the member "Phone".
     *
     * Parking location Phone Number
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const ::std::string& Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Parking location Phone Number
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* Phone_);

    /**
     * Sets the value of the member "Phone".
     *
     * Parking location Phone Number
     *
     * @param Phone The value which will be set
     */
    inline void setPhone (const char* value, size_t size);

    // API of field "Capacity"

    static const int kCapacity = 8;

    /**
     * Clears the field "Capacity".
     *
     * The field will be set to its default value. The hasCapacity()
     * method will return false.
     */
    inline void clearCapacity();

    /**
     * Checks whether the field "Capacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCapacity()). Otherwise it will return false.
     */
    inline bool hasCapacity () const;

    /**
     * Returns the value of the member "Capacity".
     *
     * Parking Location capacity
     *
     * @return The value of the field "Capacity"
     */
    inline uint32 getCapacity () const;

    /**
     * Sets the value of the member "Capacity".
     *
     * Parking Location capacity
     *
     * @param Capacity The value which will be set
     */
    inline void setCapacity (uint32 Capacity_);

    // API of field "Distance"

    static const int kDistance = 9;

    /**
     * Clears the field "Distance".
     *
     * The field will be set to its default value. The hasDistance()
     * method will return false.
     */
    inline void clearDistance();

    /**
     * Checks whether the field "Distance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDistance()). Otherwise it will return false.
     */
    inline bool hasDistance () const;

    /**
     * Returns the value of the member "Distance".
     *
     * Parking station Distance Info in Miles
     *
     * @return The value of the field "Distance"
     */
    inline float getDistance () const;

    /**
     * Sets the value of the member "Distance".
     *
     * Parking station Distance Info in Miles
     *
     * @param Distance The value which will be set
     */
    inline void setDistance (float Distance_);

    // API of field "PrimaryLocation"

    static const int kPrimaryLocation = 10;

    /**
     * Clears the field "PrimaryLocation".
     *
     * The field will be set to its default value. The hasPrimaryLocation()
     * method will return false.
     */
    inline void clearPrimaryLocation();

    /**
     * Checks whether the field "PrimaryLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrimaryLocation()). Otherwise it will return false.
     */
    inline bool hasPrimaryLocation () const;

    /**
     * Returns the value of the member "PrimaryLocation".
     *
     * Location of Primary Entrance
     *
     * @return The value of the field "PrimaryLocation"
     */
    inline const ::fi_types::T_PositionWGS84& getPrimaryLocation () const;

    /**
     * Retrieves the value of the field "PrimaryLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PrimaryLocation".
     */
    inline ::fi_types::T_PositionWGS84& getPrimaryLocationMutable ();

    /**
     * Sets the value of the member "PrimaryLocation".
     *
     * Location of Primary Entrance
     *
     * @param PrimaryLocation The value which will be set
     */
    inline void setPrimaryLocation (const ::fi_types::T_PositionWGS84& PrimaryLocation_);

    // API of field "SecondaryLocation"

    static const int kSecondaryLocation = 11;

    /**
     * Clears the field "SecondaryLocation".
     *
     * The field will be set to its default value. The hasSecondaryLocation()
     * method will return false.
     */
    inline void clearSecondaryLocation();

    /**
     * Checks whether the field "SecondaryLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondaryLocation()). Otherwise it will return false.
     */
    inline bool hasSecondaryLocation () const;

    /**
     * Returns the value of the member "SecondaryLocation".
     *
     * Location of Secondary Entrance
     *
     * @return The value of the field "SecondaryLocation"
     */
    inline const ::fi_types::T_PositionWGS84& getSecondaryLocation () const;

    /**
     * Retrieves the value of the field "SecondaryLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SecondaryLocation".
     */
    inline ::fi_types::T_PositionWGS84& getSecondaryLocationMutable ();

    /**
     * Sets the value of the member "SecondaryLocation".
     *
     * Location of Secondary Entrance
     *
     * @param SecondaryLocation The value which will be set
     */
    inline void setSecondaryLocation (const ::fi_types::T_PositionWGS84& SecondaryLocation_);

    // API of field "PrimaryHeight"

    static const int kPrimaryHeight = 12;

    /**
     * Clears the field "PrimaryHeight".
     *
     * The field will be set to its default value. The hasPrimaryHeight()
     * method will return false.
     */
    inline void clearPrimaryHeight();

    /**
     * Checks whether the field "PrimaryHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrimaryHeight()). Otherwise it will return false.
     */
    inline bool hasPrimaryHeight () const;

    /**
     * Returns the value of the member "PrimaryHeight".
     *
     * Height of Primary Entrance in inches
     *
     * @return The value of the field "PrimaryHeight"
     */
    inline uint32 getPrimaryHeight () const;

    /**
     * Sets the value of the member "PrimaryHeight".
     *
     * Height of Primary Entrance in inches
     *
     * @param PrimaryHeight The value which will be set
     */
    inline void setPrimaryHeight (uint32 PrimaryHeight_);

    // API of field "SecondaryHeight"

    static const int kSecondaryHeight = 13;

    /**
     * Clears the field "SecondaryHeight".
     *
     * The field will be set to its default value. The hasSecondaryHeight()
     * method will return false.
     */
    inline void clearSecondaryHeight();

    /**
     * Checks whether the field "SecondaryHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondaryHeight()). Otherwise it will return false.
     */
    inline bool hasSecondaryHeight () const;

    /**
     * Returns the value of the member "SecondaryHeight".
     *
     * Height of Secondary Entrance in inches
     *
     * @return The value of the field "SecondaryHeight"
     */
    inline uint32 getSecondaryHeight () const;

    /**
     * Sets the value of the member "SecondaryHeight".
     *
     * Height of Secondary Entrance in inches
     *
     * @param SecondaryHeight The value which will be set
     */
    inline void setSecondaryHeight (uint32 SecondaryHeight_);

    // API of field "AvailableTime"

    static const int kAvailableTime = 14;

    /**
     * Clears the field "AvailableTime".
     *
     * The field will be set to its default value. The hasAvailableTime()
     * method will return false.
     */
    inline void clearAvailableTime();

    /**
     * Checks whether the field "AvailableTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailableTime()). Otherwise it will return false.
     */
    inline bool hasAvailableTime () const;

    /**
     * Returns the value of the member "AvailableTime".
     *
     * the time when availability data received from the broadcast
     *
     * @return The value of the field "AvailableTime"
     */
    inline uint32 getAvailableTime () const;

    /**
     * Sets the value of the member "AvailableTime".
     *
     * the time when availability data received from the broadcast
     *
     * @param AvailableTime The value which will be set
     */
    inline void setAvailableTime (uint32 AvailableTime_);

    // API of field "RelativePricingHourly"

    static const int kRelativePricingHourly = 15;

    /**
     * Clears the field "RelativePricingHourly".
     *
     * The field will be set to its default value. The hasRelativePricingHourly()
     * method will return false.
     */
    inline void clearRelativePricingHourly();

    /**
     * Checks whether the field "RelativePricingHourly" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRelativePricingHourly()). Otherwise it will return false.
     */
    inline bool hasRelativePricingHourly () const;

    /**
     * Returns the value of the member "RelativePricingHourly".
     *
     * Relative Price Hourly
     * <p>The valid range  is 0 - 9, where the range 1 - 9 represents the relative price of the location.</p>
     * <p>1 being the cheapest and 9 being the most expensive. The 0 value indicates that hourly parking is not available.</p>
     *
     * @return The value of the field "RelativePricingHourly"
     */
    inline uint8 getRelativePricingHourly () const;

    /**
     * Sets the value of the member "RelativePricingHourly".
     *
     * Relative Price Hourly
     * <p>The valid range  is 0 - 9, where the range 1 - 9 represents the relative price of the location.</p>
     * <p>1 being the cheapest and 9 being the most expensive. The 0 value indicates that hourly parking is not available.</p>
     *
     * @param RelativePricingHourly The value which will be set
     */
    inline void setRelativePricingHourly (uint8 RelativePricingHourly_);

    // API of field "RelativePricingDaily"

    static const int kRelativePricingDaily = 16;

    /**
     * Clears the field "RelativePricingDaily".
     *
     * The field will be set to its default value. The hasRelativePricingDaily()
     * method will return false.
     */
    inline void clearRelativePricingDaily();

    /**
     * Checks whether the field "RelativePricingDaily" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRelativePricingDaily()). Otherwise it will return false.
     */
    inline bool hasRelativePricingDaily () const;

    /**
     * Returns the value of the member "RelativePricingDaily".
     *
     * Relative Price Daily
     * <p>The valid range is 0 - 9, where the range 1 - 9 represents the relative price of the location.</p>
     * <p>1 being the cheapest and 9 being the most expensive. The 0 value indicates that either daily parking is not available.</p>
     *
     * @return The value of the field "RelativePricingDaily"
     */
    inline uint8 getRelativePricingDaily () const;

    /**
     * Sets the value of the member "RelativePricingDaily".
     *
     * Relative Price Daily
     * <p>The valid range is 0 - 9, where the range 1 - 9 represents the relative price of the location.</p>
     * <p>1 being the cheapest and 9 being the most expensive. The 0 value indicates that either daily parking is not available.</p>
     *
     * @param RelativePricingDaily The value which will be set
     */
    inline void setRelativePricingDaily (uint8 RelativePricingDaily_);

    // API of field "OpenStatus"

    static const int kOpenStatus = 17;

    /**
     * Clears the field "OpenStatus".
     *
     * The field will be set to its default value. The hasOpenStatus()
     * method will return false.
     */
    inline void clearOpenStatus();

    /**
     * Checks whether the field "OpenStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpenStatus()). Otherwise it will return false.
     */
    inline bool hasOpenStatus () const;

    /**
     * Returns the value of the member "OpenStatus".
     *
     * Parking Location Open Status
     *
     * @return The value of the field "OpenStatus"
     */
    inline T_e8OpenStatus getOpenStatus () const;

    /**
     * Sets the value of the member "OpenStatus".
     *
     * Parking Location Open Status
     *
     * @param OpenStatus The value which will be set
     */
    inline void setOpenStatus (T_e8OpenStatus OpenStatus_);

    // API of field "OpeningTimes"

    static const int kOpeningTimes = 18;

    /**
     * Clears the field "OpeningTimes".
     *
     * The field will be set to its default value. The hasOpeningTimes()
     * method will return false.
     */
    inline void clearOpeningTimes();

    /**
     * Checks whether the field "OpeningTimes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpeningTimes()). Otherwise it will return false.
     */
    inline bool hasOpeningTimes () const;

    /**
     * Returns the value of the member "OpeningTimes".
     *
     * Hours of operation for the Parking Location for each day of the week.
     * In Unknown case, list would be empty.
     *
     * @return The value of the field "OpeningTimes"
     */
    inline const ::std::vector< T_OpeningTime >& getOpeningTimes () const;

    /**
     * Retrieves the value of the field "OpeningTimes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OpeningTimes".
     */
    inline ::std::vector< T_OpeningTime >& getOpeningTimesMutable ();

    /**
     * Sets the value of the member "OpeningTimes".
     *
     * Hours of operation for the Parking Location for each day of the week.
     * In Unknown case, list would be empty.
     *
     * @param OpeningTimes The value which will be set
     */
    inline void setOpeningTimes (const ::std::vector< T_OpeningTime >& OpeningTimes_);

    // API of field "Fullness"

    static const int kFullness = 19;

    /**
     * Clears the field "Fullness".
     *
     * The field will be set to its default value. The hasFullness()
     * method will return false.
     */
    inline void clearFullness();

    /**
     * Checks whether the field "Fullness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFullness()). Otherwise it will return false.
     */
    inline bool hasFullness () const;

    /**
     * Returns the value of the member "Fullness".
     *
     * occupancy for now and next 1 hour(+15min,+30min,+45min,+60min)
     *
     * @return The value of the field "Fullness"
     */
    inline const ::std::vector< T_Fullness >& getFullness () const;

    /**
     * Retrieves the value of the field "Fullness" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Fullness".
     */
    inline ::std::vector< T_Fullness >& getFullnessMutable ();

    /**
     * Sets the value of the member "Fullness".
     *
     * occupancy for now and next 1 hour(+15min,+30min,+45min,+60min)
     *
     * @param Fullness The value which will be set
     */
    inline void setFullness (const ::std::vector< T_Fullness >& Fullness_);

    // API of field "Amenities"

    static const int kAmenities = 20;

    /**
     * Clears the field "Amenities".
     *
     * The field will be set to its default value. The hasAmenities()
     * method will return false.
     */
    inline void clearAmenities();

    /**
     * Checks whether the field "Amenities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmenities()). Otherwise it will return false.
     */
    inline bool hasAmenities () const;

    /**
     * Returns the value of the member "Amenities".
     *
     * Amenity information of parking location
     *
     * @return The value of the field "Amenities"
     */
    inline const T_AmenityInfo& getAmenities () const;

    /**
     * Retrieves the value of the field "Amenities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Amenities".
     */
    inline T_AmenityInfo& getAmenitiesMutable ();

    /**
     * Sets the value of the member "Amenities".
     *
     * Amenity information of parking location
     *
     * @param Amenities The value which will be set
     */
    inline void setAmenities (const T_AmenityInfo& Amenities_);

    // API of field "PricingInfo"

    static const int kPricingInfo = 21;

    /**
     * Clears the field "PricingInfo".
     *
     * The field will be set to its default value. The hasPricingInfo()
     * method will return false.
     */
    inline void clearPricingInfo();

    /**
     * Checks whether the field "PricingInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPricingInfo()). Otherwise it will return false.
     */
    inline bool hasPricingInfo () const;

    /**
     * Returns the value of the member "PricingInfo".
     *
     * Pricing values for different time slots for a parking location
     *
     * @return The value of the field "PricingInfo"
     */
    inline const T_PriceInfo& getPricingInfo () const;

    /**
     * Retrieves the value of the field "PricingInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PricingInfo".
     */
    inline T_PriceInfo& getPricingInfoMutable ();

    /**
     * Sets the value of the member "PricingInfo".
     *
     * Pricing values for different time slots for a parking location
     *
     * @param PricingInfo The value which will be set
     */
    inline void setPricingInfo (const T_PriceInfo& PricingInfo_);

    // API of field "IsFavorite"

    static const int kIsFavorite = 22;

    /**
     * Clears the field "IsFavorite".
     *
     * The field will be set to its default value. The hasIsFavorite()
     * method will return false.
     */
    inline void clearIsFavorite();

    /**
     * Checks whether the field "IsFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsFavorite()). Otherwise it will return false.
     */
    inline bool hasIsFavorite () const;

    /**
     * Returns the value of the member "IsFavorite".
     *
     * filed to indicate parking location is favorite or not.
     *
     * @return The value of the field "IsFavorite"
     */
    inline bool getIsFavorite () const;

    /**
     * Sets the value of the member "IsFavorite".
     *
     * filed to indicate parking location is favorite or not.
     *
     * @param IsFavorite The value which will be set
     */
    inline void setIsFavorite (bool IsFavorite_);

    static const T_ParkingInfo &getDefaultInstance();

private:

    static const ::std::vector< T_OpeningTime >& getT_OpeningTimeList_DefaultInstance ();

    static const ::std::vector< T_Fullness >& getT_FullnessList_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_Address ();

    inline void clear_has_Address ();

    inline void set_has_SecondaryAddress ();

    inline void clear_has_SecondaryAddress ();

    inline void set_has_City ();

    inline void clear_has_City ();

    inline void set_has_Zip ();

    inline void clear_has_Zip ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Phone ();

    inline void clear_has_Phone ();

    inline void set_has_Capacity ();

    inline void clear_has_Capacity ();

    inline void set_has_Distance ();

    inline void clear_has_Distance ();

    inline void set_has_PrimaryLocation ();

    inline void clear_has_PrimaryLocation ();

    inline void set_has_SecondaryLocation ();

    inline void clear_has_SecondaryLocation ();

    inline void set_has_PrimaryHeight ();

    inline void clear_has_PrimaryHeight ();

    inline void set_has_SecondaryHeight ();

    inline void clear_has_SecondaryHeight ();

    inline void set_has_AvailableTime ();

    inline void clear_has_AvailableTime ();

    inline void set_has_RelativePricingHourly ();

    inline void clear_has_RelativePricingHourly ();

    inline void set_has_RelativePricingDaily ();

    inline void clear_has_RelativePricingDaily ();

    inline void set_has_OpenStatus ();

    inline void clear_has_OpenStatus ();

    inline void set_has_OpeningTimes ();

    inline void clear_has_OpeningTimes ();

    inline void set_has_Fullness ();

    inline void clear_has_Fullness ();

    inline void set_has_Amenities ();

    inline void clear_has_Amenities ();

    inline void set_has_PricingInfo ();

    inline void clear_has_PricingInfo ();

    inline void set_has_IsFavorite ();

    inline void clear_has_IsFavorite ();

    uint32 _has_bits_[ (23 + 31) / 32];

    uint32 _ID;

    ::std::string _Name;

    ::std::string _Address;

    ::std::string _SecondaryAddress;

    ::std::string _City;

    ::std::string _Zip;

    ::std::string _State;

    ::std::string _Phone;

    uint32 _Capacity;

    float _Distance;

    ::fi_types::T_PositionWGS84 _PrimaryLocation;

    ::fi_types::T_PositionWGS84 _SecondaryLocation;

    uint32 _PrimaryHeight;

    uint32 _SecondaryHeight;

    uint32 _AvailableTime;

    uint8 _RelativePricingHourly;

    uint8 _RelativePricingDaily;

    T_e8OpenStatus _OpenStatus;

    ::std::vector< T_OpeningTime > _OpeningTimes;

    ::std::vector< T_Fullness > _Fullness;

    T_AmenityInfo _Amenities;

    T_PriceInfo _PricingInfo;

    bool _IsFavorite;

};

/**
 * If the meaning of "T_FilterConfig" isn't clear, then there should be a description here.
 */
class T_FilterConfig {
public:

    /**
     * Default constructor
     */
    inline  T_FilterConfig ();

    /**
     * Copy constructor
     */
    inline  T_FilterConfig (const T_FilterConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_FilterConfig (const T_AmenityInfo& Amenities_, T_e8OpenStatus ClosedLocations_, uint32 EntranceHeight_);

    /**
     * Destructor
     */
    inline  ~T_FilterConfig();

    /**
     * Assignment operator
     */
    inline T_FilterConfig& operator = (const T_FilterConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FilterConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FilterConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FilterConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FilterConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Amenities"

    static const int kAmenities = 0;

    /**
     * Clears the field "Amenities".
     *
     * The field will be set to its default value. The hasAmenities()
     * method will return false.
     */
    inline void clearAmenities();

    /**
     * Checks whether the field "Amenities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmenities()). Otherwise it will return false.
     */
    inline bool hasAmenities () const;

    /**
     * Returns the value of the member "Amenities".
     *
     * Amenities to be filtered.
     * Set UNKNOWN for amenities not used.
     *
     * @return The value of the field "Amenities"
     */
    inline const T_AmenityInfo& getAmenities () const;

    /**
     * Retrieves the value of the field "Amenities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Amenities".
     */
    inline T_AmenityInfo& getAmenitiesMutable ();

    /**
     * Sets the value of the member "Amenities".
     *
     * Amenities to be filtered.
     * Set UNKNOWN for amenities not used.
     *
     * @param Amenities The value which will be set
     */
    inline void setAmenities (const T_AmenityInfo& Amenities_);

    // API of field "ClosedLocations"

    static const int kClosedLocations = 1;

    /**
     * Clears the field "ClosedLocations".
     *
     * The field will be set to its default value. The hasClosedLocations()
     * method will return false.
     */
    inline void clearClosedLocations();

    /**
     * Checks whether the field "ClosedLocations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClosedLocations()). Otherwise it will return false.
     */
    inline bool hasClosedLocations () const;

    /**
     * Returns the value of the member "ClosedLocations".
     *
     * Filter parking location based on its Status.
     *
     * @return The value of the field "ClosedLocations"
     */
    inline T_e8OpenStatus getClosedLocations () const;

    /**
     * Sets the value of the member "ClosedLocations".
     *
     * Filter parking location based on its Status.
     *
     * @param ClosedLocations The value which will be set
     */
    inline void setClosedLocations (T_e8OpenStatus ClosedLocations_);

    // API of field "EntranceHeight"

    static const int kEntranceHeight = 2;

    /**
     * Clears the field "EntranceHeight".
     *
     * The field will be set to its default value. The hasEntranceHeight()
     * method will return false.
     */
    inline void clearEntranceHeight();

    /**
     * Checks whether the field "EntranceHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntranceHeight()). Otherwise it will return false.
     */
    inline bool hasEntranceHeight () const;

    /**
     * Returns the value of the member "EntranceHeight".
     *
     * Height of Primary or Secondary Entrance in inches
     *
     * @return The value of the field "EntranceHeight"
     */
    inline uint32 getEntranceHeight () const;

    /**
     * Sets the value of the member "EntranceHeight".
     *
     * Height of Primary or Secondary Entrance in inches
     *
     * @param EntranceHeight The value which will be set
     */
    inline void setEntranceHeight (uint32 EntranceHeight_);

    static const T_FilterConfig &getDefaultInstance();

private:

    inline void set_has_Amenities ();

    inline void clear_has_Amenities ();

    inline void set_has_ClosedLocations ();

    inline void clear_has_ClosedLocations ();

    inline void set_has_EntranceHeight ();

    inline void clear_has_EntranceHeight ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_AmenityInfo _Amenities;

    T_e8OpenStatus _ClosedLocations;

    uint32 _EntranceHeight;

};

/**
 * If the meaning of "T_AmenityConfig" isn't clear, then there should be a description here.
 */
class T_AmenityConfig {
public:

    /**
     * Default constructor
     */
    inline  T_AmenityConfig ();

    /**
     * Copy constructor
     */
    inline  T_AmenityConfig (const T_AmenityConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_AmenityConfig (const ::std::vector< T_e8Open24Hours >& Open24Hours_, const ::std::vector< T_e8CashOrCard >& Cash_, const ::std::vector< T_e8CashOrCard >& Card_, const ::std::vector< T_e8ParkingType >& ParkingType_, const ::std::vector< T_e8MetroLocation >& MetroLocation_, const ::std::vector< T_e8AirPort >& AirPort_, const ::std::vector< T_e8OvernightParking >& OvernightParking_, const ::std::vector< T_e8Reservations >& Reservations_, const ::std::vector< T_e8SelfParking >& SelfParking_, const ::std::vector< T_e8Security >& Security_, const ::std::vector< T_e8TollTag >& TollTag_, const ::std::vector< T_e8SUVCharges >& SUVCharges_, const ::std::vector< T_e8RV >& RV_);

    /**
     * Destructor
     */
    inline  ~T_AmenityConfig();

    /**
     * Assignment operator
     */
    inline T_AmenityConfig& operator = (const T_AmenityConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AmenityConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AmenityConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AmenityConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AmenityConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Open24Hours"

    static const int kOpen24Hours = 0;

    /**
     * Clears the field "Open24Hours".
     *
     * The field will be set to its default value. The hasOpen24Hours()
     * method will return false.
     */
    inline void clearOpen24Hours();

    /**
     * Checks whether the field "Open24Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpen24Hours()). Otherwise it will return false.
     */
    inline bool hasOpen24Hours () const;

    /**
     * Returns the value of the member "Open24Hours".
     *
     * list of ameneties for parking location availability for 24 hours
     *
     * @return The value of the field "Open24Hours"
     */
    inline const ::std::vector< T_e8Open24Hours >& getOpen24Hours () const;

    /**
     * Retrieves the value of the field "Open24Hours" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Open24Hours".
     */
    inline ::std::vector< T_e8Open24Hours >& getOpen24HoursMutable ();

    /**
     * Sets the value of the member "Open24Hours".
     *
     * list of ameneties for parking location availability for 24 hours
     *
     * @param Open24Hours The value which will be set
     */
    inline void setOpen24Hours (const ::std::vector< T_e8Open24Hours >& Open24Hours_);

    // API of field "Cash"

    static const int kCash = 1;

    /**
     * Clears the field "Cash".
     *
     * The field will be set to its default value. The hasCash()
     * method will return false.
     */
    inline void clearCash();

    /**
     * Checks whether the field "Cash" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCash()). Otherwise it will return false.
     */
    inline bool hasCash () const;

    /**
     * Returns the value of the member "Cash".
     *
     * list of ameneties for parking location Cash acceptance
     *
     * @return The value of the field "Cash"
     */
    inline const ::std::vector< T_e8CashOrCard >& getCash () const;

    /**
     * Retrieves the value of the field "Cash" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Cash".
     */
    inline ::std::vector< T_e8CashOrCard >& getCashMutable ();

    /**
     * Sets the value of the member "Cash".
     *
     * list of ameneties for parking location Cash acceptance
     *
     * @param Cash The value which will be set
     */
    inline void setCash (const ::std::vector< T_e8CashOrCard >& Cash_);

    // API of field "Card"

    static const int kCard = 2;

    /**
     * Clears the field "Card".
     *
     * The field will be set to its default value. The hasCard()
     * method will return false.
     */
    inline void clearCard();

    /**
     * Checks whether the field "Card" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCard()). Otherwise it will return false.
     */
    inline bool hasCard () const;

    /**
     * Returns the value of the member "Card".
     *
     * list of ameneties for parking location Credit or Debit Card acceptance
     *
     * @return The value of the field "Card"
     */
    inline const ::std::vector< T_e8CashOrCard >& getCard () const;

    /**
     * Retrieves the value of the field "Card" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Card".
     */
    inline ::std::vector< T_e8CashOrCard >& getCardMutable ();

    /**
     * Sets the value of the member "Card".
     *
     * list of ameneties for parking location Credit or Debit Card acceptance
     *
     * @param Card The value which will be set
     */
    inline void setCard (const ::std::vector< T_e8CashOrCard >& Card_);

    // API of field "ParkingType"

    static const int kParkingType = 3;

    /**
     * Clears the field "ParkingType".
     *
     * The field will be set to its default value. The hasParkingType()
     * method will return false.
     */
    inline void clearParkingType();

    /**
     * Checks whether the field "ParkingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingType()). Otherwise it will return false.
     */
    inline bool hasParkingType () const;

    /**
     * Returns the value of the member "ParkingType".
     *
     * list of ameneties for parking type
     *
     * @return The value of the field "ParkingType"
     */
    inline const ::std::vector< T_e8ParkingType >& getParkingType () const;

    /**
     * Retrieves the value of the field "ParkingType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ParkingType".
     */
    inline ::std::vector< T_e8ParkingType >& getParkingTypeMutable ();

    /**
     * Sets the value of the member "ParkingType".
     *
     * list of ameneties for parking type
     *
     * @param ParkingType The value which will be set
     */
    inline void setParkingType (const ::std::vector< T_e8ParkingType >& ParkingType_);

    // API of field "MetroLocation"

    static const int kMetroLocation = 4;

    /**
     * Clears the field "MetroLocation".
     *
     * The field will be set to its default value. The hasMetroLocation()
     * method will return false.
     */
    inline void clearMetroLocation();

    /**
     * Checks whether the field "MetroLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMetroLocation()). Otherwise it will return false.
     */
    inline bool hasMetroLocation () const;

    /**
     * Returns the value of the member "MetroLocation".
     *
     * list of ameneties forMetro Parking location ameneties
     *
     * @return The value of the field "MetroLocation"
     */
    inline const ::std::vector< T_e8MetroLocation >& getMetroLocation () const;

    /**
     * Retrieves the value of the field "MetroLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MetroLocation".
     */
    inline ::std::vector< T_e8MetroLocation >& getMetroLocationMutable ();

    /**
     * Sets the value of the member "MetroLocation".
     *
     * list of ameneties forMetro Parking location ameneties
     *
     * @param MetroLocation The value which will be set
     */
    inline void setMetroLocation (const ::std::vector< T_e8MetroLocation >& MetroLocation_);

    // API of field "AirPort"

    static const int kAirPort = 5;

    /**
     * Clears the field "AirPort".
     *
     * The field will be set to its default value. The hasAirPort()
     * method will return false.
     */
    inline void clearAirPort();

    /**
     * Checks whether the field "AirPort" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAirPort()). Otherwise it will return false.
     */
    inline bool hasAirPort () const;

    /**
     * Returns the value of the member "AirPort".
     *
     * list of ameneties for parking location belongs to airport
     *
     * @return The value of the field "AirPort"
     */
    inline const ::std::vector< T_e8AirPort >& getAirPort () const;

    /**
     * Retrieves the value of the field "AirPort" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AirPort".
     */
    inline ::std::vector< T_e8AirPort >& getAirPortMutable ();

    /**
     * Sets the value of the member "AirPort".
     *
     * list of ameneties for parking location belongs to airport
     *
     * @param AirPort The value which will be set
     */
    inline void setAirPort (const ::std::vector< T_e8AirPort >& AirPort_);

    // API of field "OvernightParking"

    static const int kOvernightParking = 6;

    /**
     * Clears the field "OvernightParking".
     *
     * The field will be set to its default value. The hasOvernightParking()
     * method will return false.
     */
    inline void clearOvernightParking();

    /**
     * Checks whether the field "OvernightParking" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOvernightParking()). Otherwise it will return false.
     */
    inline bool hasOvernightParking () const;

    /**
     * Returns the value of the member "OvernightParking".
     *
     * list of ameneties for parking location availability for overnight
     *
     * @return The value of the field "OvernightParking"
     */
    inline const ::std::vector< T_e8OvernightParking >& getOvernightParking () const;

    /**
     * Retrieves the value of the field "OvernightParking" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "OvernightParking".
     */
    inline ::std::vector< T_e8OvernightParking >& getOvernightParkingMutable ();

    /**
     * Sets the value of the member "OvernightParking".
     *
     * list of ameneties for parking location availability for overnight
     *
     * @param OvernightParking The value which will be set
     */
    inline void setOvernightParking (const ::std::vector< T_e8OvernightParking >& OvernightParking_);

    // API of field "Reservations"

    static const int kReservations = 7;

    /**
     * Clears the field "Reservations".
     *
     * The field will be set to its default value. The hasReservations()
     * method will return false.
     */
    inline void clearReservations();

    /**
     * Checks whether the field "Reservations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReservations()). Otherwise it will return false.
     */
    inline bool hasReservations () const;

    /**
     * Returns the value of the member "Reservations".
     *
     * list of ameneties for Reservations availability of parking location
     *
     * @return The value of the field "Reservations"
     */
    inline const ::std::vector< T_e8Reservations >& getReservations () const;

    /**
     * Retrieves the value of the field "Reservations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Reservations".
     */
    inline ::std::vector< T_e8Reservations >& getReservationsMutable ();

    /**
     * Sets the value of the member "Reservations".
     *
     * list of ameneties for Reservations availability of parking location
     *
     * @param Reservations The value which will be set
     */
    inline void setReservations (const ::std::vector< T_e8Reservations >& Reservations_);

    // API of field "SelfParking"

    static const int kSelfParking = 8;

    /**
     * Clears the field "SelfParking".
     *
     * The field will be set to its default value. The hasSelfParking()
     * method will return false.
     */
    inline void clearSelfParking();

    /**
     * Checks whether the field "SelfParking" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelfParking()). Otherwise it will return false.
     */
    inline bool hasSelfParking () const;

    /**
     * Returns the value of the member "SelfParking".
     *
     * list of ameneties for Self and Valet parking availability
     *
     * @return The value of the field "SelfParking"
     */
    inline const ::std::vector< T_e8SelfParking >& getSelfParking () const;

    /**
     * Retrieves the value of the field "SelfParking" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SelfParking".
     */
    inline ::std::vector< T_e8SelfParking >& getSelfParkingMutable ();

    /**
     * Sets the value of the member "SelfParking".
     *
     * list of ameneties for Self and Valet parking availability
     *
     * @param SelfParking The value which will be set
     */
    inline void setSelfParking (const ::std::vector< T_e8SelfParking >& SelfParking_);

    // API of field "Security"

    static const int kSecurity = 9;

    /**
     * Clears the field "Security".
     *
     * The field will be set to its default value. The hasSecurity()
     * method will return false.
     */
    inline void clearSecurity();

    /**
     * Checks whether the field "Security" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecurity()). Otherwise it will return false.
     */
    inline bool hasSecurity () const;

    /**
     * Returns the value of the member "Security".
     *
     * list of ameneties for Security details of parking location
     *
     * @return The value of the field "Security"
     */
    inline const ::std::vector< T_e8Security >& getSecurity () const;

    /**
     * Retrieves the value of the field "Security" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Security".
     */
    inline ::std::vector< T_e8Security >& getSecurityMutable ();

    /**
     * Sets the value of the member "Security".
     *
     * list of ameneties for Security details of parking location
     *
     * @param Security The value which will be set
     */
    inline void setSecurity (const ::std::vector< T_e8Security >& Security_);

    // API of field "TollTag"

    static const int kTollTag = 10;

    /**
     * Clears the field "TollTag".
     *
     * The field will be set to its default value. The hasTollTag()
     * method will return false.
     */
    inline void clearTollTag();

    /**
     * Checks whether the field "TollTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTollTag()). Otherwise it will return false.
     */
    inline bool hasTollTag () const;

    /**
     * Returns the value of the member "TollTag".
     *
     * list of ameneties for parking location Toll Tag payment acceptance
     *
     * @return The value of the field "TollTag"
     */
    inline const ::std::vector< T_e8TollTag >& getTollTag () const;

    /**
     * Retrieves the value of the field "TollTag" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TollTag".
     */
    inline ::std::vector< T_e8TollTag >& getTollTagMutable ();

    /**
     * Sets the value of the member "TollTag".
     *
     * list of ameneties for parking location Toll Tag payment acceptance
     *
     * @param TollTag The value which will be set
     */
    inline void setTollTag (const ::std::vector< T_e8TollTag >& TollTag_);

    // API of field "SUVCharges"

    static const int kSUVCharges = 11;

    /**
     * Clears the field "SUVCharges".
     *
     * The field will be set to its default value. The hasSUVCharges()
     * method will return false.
     */
    inline void clearSUVCharges();

    /**
     * Checks whether the field "SUVCharges" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUVCharges()). Otherwise it will return false.
     */
    inline bool hasSUVCharges () const;

    /**
     * Returns the value of the member "SUVCharges".
     *
     * list of ameneties for SUV or Van extra charges
     *
     * @return The value of the field "SUVCharges"
     */
    inline const ::std::vector< T_e8SUVCharges >& getSUVCharges () const;

    /**
     * Retrieves the value of the field "SUVCharges" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SUVCharges".
     */
    inline ::std::vector< T_e8SUVCharges >& getSUVChargesMutable ();

    /**
     * Sets the value of the member "SUVCharges".
     *
     * list of ameneties for SUV or Van extra charges
     *
     * @param SUVCharges The value which will be set
     */
    inline void setSUVCharges (const ::std::vector< T_e8SUVCharges >& SUVCharges_);

    // API of field "RV"

    static const int kRV = 12;

    /**
     * Clears the field "RV".
     *
     * The field will be set to its default value. The hasRV()
     * method will return false.
     */
    inline void clearRV();

    /**
     * Checks whether the field "RV" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRV()). Otherwise it will return false.
     */
    inline bool hasRV () const;

    /**
     * Returns the value of the member "RV".
     *
     * list of ameneties for availability details for RVs
     *
     * @return The value of the field "RV"
     */
    inline const ::std::vector< T_e8RV >& getRV () const;

    /**
     * Retrieves the value of the field "RV" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RV".
     */
    inline ::std::vector< T_e8RV >& getRVMutable ();

    /**
     * Sets the value of the member "RV".
     *
     * list of ameneties for availability details for RVs
     *
     * @param RV The value which will be set
     */
    inline void setRV (const ::std::vector< T_e8RV >& RV_);

    static const T_AmenityConfig &getDefaultInstance();

private:

    static const ::std::vector< T_e8Open24Hours >& getT_e8Open24HoursList_DefaultInstance ();

    static const ::std::vector< T_e8CashOrCard >& getT_e8CashOrCardList_DefaultInstance ();

    static const ::std::vector< T_e8ParkingType >& getT_e8ParkingTypeList_DefaultInstance ();

    static const ::std::vector< T_e8MetroLocation >& getT_e8MetroLocationList_DefaultInstance ();

    static const ::std::vector< T_e8AirPort >& getT_e8AirPortList_DefaultInstance ();

    static const ::std::vector< T_e8OvernightParking >& getT_e8OvernightParkingList_DefaultInstance ();

    static const ::std::vector< T_e8Reservations >& getT_e8ReservationsList_DefaultInstance ();

    static const ::std::vector< T_e8SelfParking >& getT_e8SelfParkingList_DefaultInstance ();

    static const ::std::vector< T_e8Security >& getT_e8SecurityList_DefaultInstance ();

    static const ::std::vector< T_e8TollTag >& getT_e8TollTagList_DefaultInstance ();

    static const ::std::vector< T_e8SUVCharges >& getT_e8SUVChargesList_DefaultInstance ();

    static const ::std::vector< T_e8RV >& getT_e8RVList_DefaultInstance ();

    inline void set_has_Open24Hours ();

    inline void clear_has_Open24Hours ();

    inline void set_has_Cash ();

    inline void clear_has_Cash ();

    inline void set_has_Card ();

    inline void clear_has_Card ();

    inline void set_has_ParkingType ();

    inline void clear_has_ParkingType ();

    inline void set_has_MetroLocation ();

    inline void clear_has_MetroLocation ();

    inline void set_has_AirPort ();

    inline void clear_has_AirPort ();

    inline void set_has_OvernightParking ();

    inline void clear_has_OvernightParking ();

    inline void set_has_Reservations ();

    inline void clear_has_Reservations ();

    inline void set_has_SelfParking ();

    inline void clear_has_SelfParking ();

    inline void set_has_Security ();

    inline void clear_has_Security ();

    inline void set_has_TollTag ();

    inline void clear_has_TollTag ();

    inline void set_has_SUVCharges ();

    inline void clear_has_SUVCharges ();

    inline void set_has_RV ();

    inline void clear_has_RV ();

    uint32 _has_bits_[ (13 + 31) / 32];

    ::std::vector< T_e8Open24Hours > _Open24Hours;

    ::std::vector< T_e8CashOrCard > _Cash;

    ::std::vector< T_e8CashOrCard > _Card;

    ::std::vector< T_e8ParkingType > _ParkingType;

    ::std::vector< T_e8MetroLocation > _MetroLocation;

    ::std::vector< T_e8AirPort > _AirPort;

    ::std::vector< T_e8OvernightParking > _OvernightParking;

    ::std::vector< T_e8Reservations > _Reservations;

    ::std::vector< T_e8SelfParking > _SelfParking;

    ::std::vector< T_e8Security > _Security;

    ::std::vector< T_e8TollTag > _TollTag;

    ::std::vector< T_e8SUVCharges > _SUVCharges;

    ::std::vector< T_e8RV > _RV;

};

/**
 * If the meaning of "T_FilterConfiguration" isn't clear, then there should be a description here.
 */
class T_FilterConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_FilterConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_FilterConfiguration (const T_FilterConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  T_FilterConfiguration (const T_AmenityConfig& Amenities_, const ::std::vector< T_e8OpenStatus >& ClosedLocations_, uint32 EntranceHeight_);

    /**
     * Destructor
     */
    inline  ~T_FilterConfiguration();

    /**
     * Assignment operator
     */
    inline T_FilterConfiguration& operator = (const T_FilterConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FilterConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FilterConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FilterConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FilterConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Amenities"

    static const int kAmenities = 0;

    /**
     * Clears the field "Amenities".
     *
     * The field will be set to its default value. The hasAmenities()
     * method will return false.
     */
    inline void clearAmenities();

    /**
     * Checks whether the field "Amenities" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmenities()). Otherwise it will return false.
     */
    inline bool hasAmenities () const;

    /**
     * Returns the value of the member "Amenities".
     *
     * Amenities to be filtered.
     *
     * @return The value of the field "Amenities"
     */
    inline const T_AmenityConfig& getAmenities () const;

    /**
     * Retrieves the value of the field "Amenities" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Amenities".
     */
    inline T_AmenityConfig& getAmenitiesMutable ();

    /**
     * Sets the value of the member "Amenities".
     *
     * Amenities to be filtered.
     *
     * @param Amenities The value which will be set
     */
    inline void setAmenities (const T_AmenityConfig& Amenities_);

    // API of field "ClosedLocations"

    static const int kClosedLocations = 1;

    /**
     * Clears the field "ClosedLocations".
     *
     * The field will be set to its default value. The hasClosedLocations()
     * method will return false.
     */
    inline void clearClosedLocations();

    /**
     * Checks whether the field "ClosedLocations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClosedLocations()). Otherwise it will return false.
     */
    inline bool hasClosedLocations () const;

    /**
     * Returns the value of the member "ClosedLocations".
     *
     * Filter parking location based on its Status.
     *
     * @return The value of the field "ClosedLocations"
     */
    inline const ::std::vector< T_e8OpenStatus >& getClosedLocations () const;

    /**
     * Retrieves the value of the field "ClosedLocations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ClosedLocations".
     */
    inline ::std::vector< T_e8OpenStatus >& getClosedLocationsMutable ();

    /**
     * Sets the value of the member "ClosedLocations".
     *
     * Filter parking location based on its Status.
     *
     * @param ClosedLocations The value which will be set
     */
    inline void setClosedLocations (const ::std::vector< T_e8OpenStatus >& ClosedLocations_);

    // API of field "EntranceHeight"

    static const int kEntranceHeight = 2;

    /**
     * Clears the field "EntranceHeight".
     *
     * The field will be set to its default value. The hasEntranceHeight()
     * method will return false.
     */
    inline void clearEntranceHeight();

    /**
     * Checks whether the field "EntranceHeight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntranceHeight()). Otherwise it will return false.
     */
    inline bool hasEntranceHeight () const;

    /**
     * Returns the value of the member "EntranceHeight".
     *
     * Height of Primary or Secondary Entrance in inches
     *
     * @return The value of the field "EntranceHeight"
     */
    inline uint32 getEntranceHeight () const;

    /**
     * Sets the value of the member "EntranceHeight".
     *
     * Height of Primary or Secondary Entrance in inches
     *
     * @param EntranceHeight The value which will be set
     */
    inline void setEntranceHeight (uint32 EntranceHeight_);

    static const T_FilterConfiguration &getDefaultInstance();

private:

    static const ::std::vector< T_e8OpenStatus >& getT_e8OpenStatusList_DefaultInstance ();

    inline void set_has_Amenities ();

    inline void clear_has_Amenities ();

    inline void set_has_ClosedLocations ();

    inline void clear_has_ClosedLocations ();

    inline void set_has_EntranceHeight ();

    inline void clear_has_EntranceHeight ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_AmenityConfig _Amenities;

    ::std::vector< T_e8OpenStatus > _ClosedLocations;

    uint32 _EntranceHeight;

};

inline  T_Fullness::T_Fullness ()  :
    _Type (::sxm_parking_main_fi_types::T_e8FullType__PARKING_FULLNESS_UNKNOWN),
    _Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Fullness::T_Fullness (const T_Fullness &rhs)  :
    _Type (::sxm_parking_main_fi_types::T_e8FullType__PARKING_FULLNESS_UNKNOWN),
    _Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Fullness::T_Fullness (T_e8FullType Type_, uint16 Value_)  :
    _Type (Type_),
    _Value (Value_)
{
    #ifndef NDEBUG
    if (!(T_e8FullType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8FullType", "Type", "T_Fullness");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Fullness::~T_Fullness() {
}

inline T_Fullness& T_Fullness::operator = (const T_Fullness& rhs) {
    if( this != &rhs ) {
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool T_Fullness::operator == (const T_Fullness& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool T_Fullness::operator != (const T_Fullness& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Fullness::operator < (const T_Fullness& rhs) const {
    if (hasType() || rhs.hasType()) {
        if ((uint32)getType() < (uint32)rhs.getType()) return true;
        if ((uint32)getType() > (uint32)rhs.getType()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool T_Fullness::operator > (const T_Fullness& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Fullness::clear() {
    clearType();
    clearValue();
}

inline void T_Fullness::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type = ::sxm_parking_main_fi_types::T_e8FullType__PARKING_FULLNESS_UNKNOWN;
     }
}

inline bool T_Fullness::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8FullType T_Fullness::getType () const {
    return _Type;
}

inline void T_Fullness::setType (T_e8FullType Type_) {
    #ifndef NDEBUG
    if (!(T_e8FullType_IsValid(Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Type_, "T_e8FullType", "Type", "T_Fullness");
    }
    #endif
    set_has_Type();
    this->_Type = Type_;
}

inline void T_Fullness::clearValue() {
    if (hasValue()) {
         clear_has_Value();
        _Value = 0u;
     }
}

inline bool T_Fullness::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_Fullness::getValue () const {
    return _Value;
}

inline void T_Fullness::setValue (uint16 Value_) {
    set_has_Value();
    this->_Value = Value_;
}

inline void T_Fullness::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Fullness::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Fullness::set_has_Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Fullness::clear_has_Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AmenityInfo::T_AmenityInfo ()  :
    _Open24Hours (::sxm_parking_main_fi_types::T_e8Open24Hours__UNKNOWN),
    _Cash (::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN),
    _Card (::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN),
    _ParkingType (::sxm_parking_main_fi_types::T_e8ParkingType__UNKNOWN),
    _MetroLocation (::sxm_parking_main_fi_types::T_e8MetroLocation__UNKNOWN),
    _AirPort (::sxm_parking_main_fi_types::T_e8AirPort__UNKNOWN),
    _OvernightParking (::sxm_parking_main_fi_types::T_e8OvernightParking__UNKNOWN),
    _Reservations (::sxm_parking_main_fi_types::T_e8Reservations__UNKNOWN),
    _SelfParking (::sxm_parking_main_fi_types::T_e8SelfParking__UNKNOWN),
    _Security (::sxm_parking_main_fi_types::T_e8Security__UNKNOWN),
    _TollTag (::sxm_parking_main_fi_types::T_e8TollTag__UNKNOWN),
    _SUVCharges (::sxm_parking_main_fi_types::T_e8SUVCharges__UNKNOWN),
    _RV (::sxm_parking_main_fi_types::T_e8RV__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AmenityInfo::T_AmenityInfo (const T_AmenityInfo &rhs)  :
    _Open24Hours (::sxm_parking_main_fi_types::T_e8Open24Hours__UNKNOWN),
    _Cash (::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN),
    _Card (::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN),
    _ParkingType (::sxm_parking_main_fi_types::T_e8ParkingType__UNKNOWN),
    _MetroLocation (::sxm_parking_main_fi_types::T_e8MetroLocation__UNKNOWN),
    _AirPort (::sxm_parking_main_fi_types::T_e8AirPort__UNKNOWN),
    _OvernightParking (::sxm_parking_main_fi_types::T_e8OvernightParking__UNKNOWN),
    _Reservations (::sxm_parking_main_fi_types::T_e8Reservations__UNKNOWN),
    _SelfParking (::sxm_parking_main_fi_types::T_e8SelfParking__UNKNOWN),
    _Security (::sxm_parking_main_fi_types::T_e8Security__UNKNOWN),
    _TollTag (::sxm_parking_main_fi_types::T_e8TollTag__UNKNOWN),
    _SUVCharges (::sxm_parking_main_fi_types::T_e8SUVCharges__UNKNOWN),
    _RV (::sxm_parking_main_fi_types::T_e8RV__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AmenityInfo::T_AmenityInfo (T_e8Open24Hours Open24Hours_, T_e8CashOrCard Cash_, T_e8CashOrCard Card_, T_e8ParkingType ParkingType_, T_e8MetroLocation MetroLocation_, T_e8AirPort AirPort_, T_e8OvernightParking OvernightParking_, T_e8Reservations Reservations_, T_e8SelfParking SelfParking_, T_e8Security Security_, T_e8TollTag TollTag_, T_e8SUVCharges SUVCharges_, T_e8RV RV_)  :
    _Open24Hours (Open24Hours_),
    _Cash (Cash_),
    _Card (Card_),
    _ParkingType (ParkingType_),
    _MetroLocation (MetroLocation_),
    _AirPort (AirPort_),
    _OvernightParking (OvernightParking_),
    _Reservations (Reservations_),
    _SelfParking (SelfParking_),
    _Security (Security_),
    _TollTag (TollTag_),
    _SUVCharges (SUVCharges_),
    _RV (RV_)
{
    #ifndef NDEBUG
    if (!(T_e8Open24Hours_IsValid(Open24Hours_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Open24Hours_, "T_e8Open24Hours", "Open24Hours", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8CashOrCard_IsValid(Cash_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Cash_, "T_e8CashOrCard", "Cash", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8CashOrCard_IsValid(Card_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Card_, "T_e8CashOrCard", "Card", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8ParkingType_IsValid(ParkingType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ParkingType_, "T_e8ParkingType", "ParkingType", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8MetroLocation_IsValid(MetroLocation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MetroLocation_, "T_e8MetroLocation", "MetroLocation", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8AirPort_IsValid(AirPort_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AirPort_, "T_e8AirPort", "AirPort", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8OvernightParking_IsValid(OvernightParking_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OvernightParking_, "T_e8OvernightParking", "OvernightParking", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8Reservations_IsValid(Reservations_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Reservations_, "T_e8Reservations", "Reservations", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8SelfParking_IsValid(SelfParking_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SelfParking_, "T_e8SelfParking", "SelfParking", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8Security_IsValid(Security_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Security_, "T_e8Security", "Security", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8TollTag_IsValid(TollTag_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TollTag_, "T_e8TollTag", "TollTag", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8SUVCharges_IsValid(SUVCharges_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SUVCharges_, "T_e8SUVCharges", "SUVCharges", "T_AmenityInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8RV_IsValid(RV_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RV_, "T_e8RV", "RV", "T_AmenityInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AmenityInfo::~T_AmenityInfo() {
}

inline T_AmenityInfo& T_AmenityInfo::operator = (const T_AmenityInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOpen24Hours()) {
            setOpen24Hours(rhs.getOpen24Hours());
        } else {
            clearOpen24Hours();
        }
        if (rhs.hasCash()) {
            setCash(rhs.getCash());
        } else {
            clearCash();
        }
        if (rhs.hasCard()) {
            setCard(rhs.getCard());
        } else {
            clearCard();
        }
        if (rhs.hasParkingType()) {
            setParkingType(rhs.getParkingType());
        } else {
            clearParkingType();
        }
        if (rhs.hasMetroLocation()) {
            setMetroLocation(rhs.getMetroLocation());
        } else {
            clearMetroLocation();
        }
        if (rhs.hasAirPort()) {
            setAirPort(rhs.getAirPort());
        } else {
            clearAirPort();
        }
        if (rhs.hasOvernightParking()) {
            setOvernightParking(rhs.getOvernightParking());
        } else {
            clearOvernightParking();
        }
        if (rhs.hasReservations()) {
            setReservations(rhs.getReservations());
        } else {
            clearReservations();
        }
        if (rhs.hasSelfParking()) {
            setSelfParking(rhs.getSelfParking());
        } else {
            clearSelfParking();
        }
        if (rhs.hasSecurity()) {
            setSecurity(rhs.getSecurity());
        } else {
            clearSecurity();
        }
        if (rhs.hasTollTag()) {
            setTollTag(rhs.getTollTag());
        } else {
            clearTollTag();
        }
        if (rhs.hasSUVCharges()) {
            setSUVCharges(rhs.getSUVCharges());
        } else {
            clearSUVCharges();
        }
        if (rhs.hasRV()) {
            setRV(rhs.getRV());
        } else {
            clearRV();
        }
    }
    return *this;
}

inline bool T_AmenityInfo::operator == (const T_AmenityInfo& rhs) const {
    return (((!hasOpen24Hours() && !rhs.hasOpen24Hours()) || getOpen24Hours() == rhs.getOpen24Hours()) &&
        ((!hasCash() && !rhs.hasCash()) || getCash() == rhs.getCash()) &&
        ((!hasCard() && !rhs.hasCard()) || getCard() == rhs.getCard()) &&
        ((!hasParkingType() && !rhs.hasParkingType()) || getParkingType() == rhs.getParkingType()) &&
        ((!hasMetroLocation() && !rhs.hasMetroLocation()) || getMetroLocation() == rhs.getMetroLocation()) &&
        ((!hasAirPort() && !rhs.hasAirPort()) || getAirPort() == rhs.getAirPort()) &&
        ((!hasOvernightParking() && !rhs.hasOvernightParking()) || getOvernightParking() == rhs.getOvernightParking()) &&
        ((!hasReservations() && !rhs.hasReservations()) || getReservations() == rhs.getReservations()) &&
        ((!hasSelfParking() && !rhs.hasSelfParking()) || getSelfParking() == rhs.getSelfParking()) &&
        ((!hasSecurity() && !rhs.hasSecurity()) || getSecurity() == rhs.getSecurity()) &&
        ((!hasTollTag() && !rhs.hasTollTag()) || getTollTag() == rhs.getTollTag()) &&
        ((!hasSUVCharges() && !rhs.hasSUVCharges()) || getSUVCharges() == rhs.getSUVCharges()) &&
        ((!hasRV() && !rhs.hasRV()) || getRV() == rhs.getRV()));
}

inline bool T_AmenityInfo::operator != (const T_AmenityInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AmenityInfo::operator < (const T_AmenityInfo& rhs) const {
    if (hasOpen24Hours() || rhs.hasOpen24Hours()) {
        if ((uint32)getOpen24Hours() < (uint32)rhs.getOpen24Hours()) return true;
        if ((uint32)getOpen24Hours() > (uint32)rhs.getOpen24Hours()) return false;
    }
    if (hasCash() || rhs.hasCash()) {
        if ((uint32)getCash() < (uint32)rhs.getCash()) return true;
        if ((uint32)getCash() > (uint32)rhs.getCash()) return false;
    }
    if (hasCard() || rhs.hasCard()) {
        if ((uint32)getCard() < (uint32)rhs.getCard()) return true;
        if ((uint32)getCard() > (uint32)rhs.getCard()) return false;
    }
    if (hasParkingType() || rhs.hasParkingType()) {
        if ((uint32)getParkingType() < (uint32)rhs.getParkingType()) return true;
        if ((uint32)getParkingType() > (uint32)rhs.getParkingType()) return false;
    }
    if (hasMetroLocation() || rhs.hasMetroLocation()) {
        if ((uint32)getMetroLocation() < (uint32)rhs.getMetroLocation()) return true;
        if ((uint32)getMetroLocation() > (uint32)rhs.getMetroLocation()) return false;
    }
    if (hasAirPort() || rhs.hasAirPort()) {
        if ((uint32)getAirPort() < (uint32)rhs.getAirPort()) return true;
        if ((uint32)getAirPort() > (uint32)rhs.getAirPort()) return false;
    }
    if (hasOvernightParking() || rhs.hasOvernightParking()) {
        if ((uint32)getOvernightParking() < (uint32)rhs.getOvernightParking()) return true;
        if ((uint32)getOvernightParking() > (uint32)rhs.getOvernightParking()) return false;
    }
    if (hasReservations() || rhs.hasReservations()) {
        if ((uint32)getReservations() < (uint32)rhs.getReservations()) return true;
        if ((uint32)getReservations() > (uint32)rhs.getReservations()) return false;
    }
    if (hasSelfParking() || rhs.hasSelfParking()) {
        if ((uint32)getSelfParking() < (uint32)rhs.getSelfParking()) return true;
        if ((uint32)getSelfParking() > (uint32)rhs.getSelfParking()) return false;
    }
    if (hasSecurity() || rhs.hasSecurity()) {
        if ((uint32)getSecurity() < (uint32)rhs.getSecurity()) return true;
        if ((uint32)getSecurity() > (uint32)rhs.getSecurity()) return false;
    }
    if (hasTollTag() || rhs.hasTollTag()) {
        if ((uint32)getTollTag() < (uint32)rhs.getTollTag()) return true;
        if ((uint32)getTollTag() > (uint32)rhs.getTollTag()) return false;
    }
    if (hasSUVCharges() || rhs.hasSUVCharges()) {
        if ((uint32)getSUVCharges() < (uint32)rhs.getSUVCharges()) return true;
        if ((uint32)getSUVCharges() > (uint32)rhs.getSUVCharges()) return false;
    }
    if (hasRV() || rhs.hasRV()) {
        if ((uint32)getRV() < (uint32)rhs.getRV()) return true;
        if ((uint32)getRV() > (uint32)rhs.getRV()) return false;
    }
    return false;
}

inline bool T_AmenityInfo::operator > (const T_AmenityInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AmenityInfo::clear() {
    clearOpen24Hours();
    clearCash();
    clearCard();
    clearParkingType();
    clearMetroLocation();
    clearAirPort();
    clearOvernightParking();
    clearReservations();
    clearSelfParking();
    clearSecurity();
    clearTollTag();
    clearSUVCharges();
    clearRV();
}

inline void T_AmenityInfo::clearOpen24Hours() {
    if (hasOpen24Hours()) {
         clear_has_Open24Hours();
        _Open24Hours = ::sxm_parking_main_fi_types::T_e8Open24Hours__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasOpen24Hours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8Open24Hours T_AmenityInfo::getOpen24Hours () const {
    return _Open24Hours;
}

inline void T_AmenityInfo::setOpen24Hours (T_e8Open24Hours Open24Hours_) {
    #ifndef NDEBUG
    if (!(T_e8Open24Hours_IsValid(Open24Hours_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Open24Hours_, "T_e8Open24Hours", "Open24Hours", "T_AmenityInfo");
    }
    #endif
    set_has_Open24Hours();
    this->_Open24Hours = Open24Hours_;
}

inline void T_AmenityInfo::clearCash() {
    if (hasCash()) {
         clear_has_Cash();
        _Cash = ::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasCash () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8CashOrCard T_AmenityInfo::getCash () const {
    return _Cash;
}

inline void T_AmenityInfo::setCash (T_e8CashOrCard Cash_) {
    #ifndef NDEBUG
    if (!(T_e8CashOrCard_IsValid(Cash_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Cash_, "T_e8CashOrCard", "Cash", "T_AmenityInfo");
    }
    #endif
    set_has_Cash();
    this->_Cash = Cash_;
}

inline void T_AmenityInfo::clearCard() {
    if (hasCard()) {
         clear_has_Card();
        _Card = ::sxm_parking_main_fi_types::T_e8CashOrCard__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasCard () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8CashOrCard T_AmenityInfo::getCard () const {
    return _Card;
}

inline void T_AmenityInfo::setCard (T_e8CashOrCard Card_) {
    #ifndef NDEBUG
    if (!(T_e8CashOrCard_IsValid(Card_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Card_, "T_e8CashOrCard", "Card", "T_AmenityInfo");
    }
    #endif
    set_has_Card();
    this->_Card = Card_;
}

inline void T_AmenityInfo::clearParkingType() {
    if (hasParkingType()) {
         clear_has_ParkingType();
        _ParkingType = ::sxm_parking_main_fi_types::T_e8ParkingType__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasParkingType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8ParkingType T_AmenityInfo::getParkingType () const {
    return _ParkingType;
}

inline void T_AmenityInfo::setParkingType (T_e8ParkingType ParkingType_) {
    #ifndef NDEBUG
    if (!(T_e8ParkingType_IsValid(ParkingType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ParkingType_, "T_e8ParkingType", "ParkingType", "T_AmenityInfo");
    }
    #endif
    set_has_ParkingType();
    this->_ParkingType = ParkingType_;
}

inline void T_AmenityInfo::clearMetroLocation() {
    if (hasMetroLocation()) {
         clear_has_MetroLocation();
        _MetroLocation = ::sxm_parking_main_fi_types::T_e8MetroLocation__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasMetroLocation () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8MetroLocation T_AmenityInfo::getMetroLocation () const {
    return _MetroLocation;
}

inline void T_AmenityInfo::setMetroLocation (T_e8MetroLocation MetroLocation_) {
    #ifndef NDEBUG
    if (!(T_e8MetroLocation_IsValid(MetroLocation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MetroLocation_, "T_e8MetroLocation", "MetroLocation", "T_AmenityInfo");
    }
    #endif
    set_has_MetroLocation();
    this->_MetroLocation = MetroLocation_;
}

inline void T_AmenityInfo::clearAirPort() {
    if (hasAirPort()) {
         clear_has_AirPort();
        _AirPort = ::sxm_parking_main_fi_types::T_e8AirPort__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasAirPort () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8AirPort T_AmenityInfo::getAirPort () const {
    return _AirPort;
}

inline void T_AmenityInfo::setAirPort (T_e8AirPort AirPort_) {
    #ifndef NDEBUG
    if (!(T_e8AirPort_IsValid(AirPort_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AirPort_, "T_e8AirPort", "AirPort", "T_AmenityInfo");
    }
    #endif
    set_has_AirPort();
    this->_AirPort = AirPort_;
}

inline void T_AmenityInfo::clearOvernightParking() {
    if (hasOvernightParking()) {
         clear_has_OvernightParking();
        _OvernightParking = ::sxm_parking_main_fi_types::T_e8OvernightParking__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasOvernightParking () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8OvernightParking T_AmenityInfo::getOvernightParking () const {
    return _OvernightParking;
}

inline void T_AmenityInfo::setOvernightParking (T_e8OvernightParking OvernightParking_) {
    #ifndef NDEBUG
    if (!(T_e8OvernightParking_IsValid(OvernightParking_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OvernightParking_, "T_e8OvernightParking", "OvernightParking", "T_AmenityInfo");
    }
    #endif
    set_has_OvernightParking();
    this->_OvernightParking = OvernightParking_;
}

inline void T_AmenityInfo::clearReservations() {
    if (hasReservations()) {
         clear_has_Reservations();
        _Reservations = ::sxm_parking_main_fi_types::T_e8Reservations__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasReservations () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8Reservations T_AmenityInfo::getReservations () const {
    return _Reservations;
}

inline void T_AmenityInfo::setReservations (T_e8Reservations Reservations_) {
    #ifndef NDEBUG
    if (!(T_e8Reservations_IsValid(Reservations_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Reservations_, "T_e8Reservations", "Reservations", "T_AmenityInfo");
    }
    #endif
    set_has_Reservations();
    this->_Reservations = Reservations_;
}

inline void T_AmenityInfo::clearSelfParking() {
    if (hasSelfParking()) {
         clear_has_SelfParking();
        _SelfParking = ::sxm_parking_main_fi_types::T_e8SelfParking__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasSelfParking () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline T_e8SelfParking T_AmenityInfo::getSelfParking () const {
    return _SelfParking;
}

inline void T_AmenityInfo::setSelfParking (T_e8SelfParking SelfParking_) {
    #ifndef NDEBUG
    if (!(T_e8SelfParking_IsValid(SelfParking_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SelfParking_, "T_e8SelfParking", "SelfParking", "T_AmenityInfo");
    }
    #endif
    set_has_SelfParking();
    this->_SelfParking = SelfParking_;
}

inline void T_AmenityInfo::clearSecurity() {
    if (hasSecurity()) {
         clear_has_Security();
        _Security = ::sxm_parking_main_fi_types::T_e8Security__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasSecurity () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline T_e8Security T_AmenityInfo::getSecurity () const {
    return _Security;
}

inline void T_AmenityInfo::setSecurity (T_e8Security Security_) {
    #ifndef NDEBUG
    if (!(T_e8Security_IsValid(Security_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Security_, "T_e8Security", "Security", "T_AmenityInfo");
    }
    #endif
    set_has_Security();
    this->_Security = Security_;
}

inline void T_AmenityInfo::clearTollTag() {
    if (hasTollTag()) {
         clear_has_TollTag();
        _TollTag = ::sxm_parking_main_fi_types::T_e8TollTag__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasTollTag () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline T_e8TollTag T_AmenityInfo::getTollTag () const {
    return _TollTag;
}

inline void T_AmenityInfo::setTollTag (T_e8TollTag TollTag_) {
    #ifndef NDEBUG
    if (!(T_e8TollTag_IsValid(TollTag_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TollTag_, "T_e8TollTag", "TollTag", "T_AmenityInfo");
    }
    #endif
    set_has_TollTag();
    this->_TollTag = TollTag_;
}

inline void T_AmenityInfo::clearSUVCharges() {
    if (hasSUVCharges()) {
         clear_has_SUVCharges();
        _SUVCharges = ::sxm_parking_main_fi_types::T_e8SUVCharges__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasSUVCharges () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8SUVCharges T_AmenityInfo::getSUVCharges () const {
    return _SUVCharges;
}

inline void T_AmenityInfo::setSUVCharges (T_e8SUVCharges SUVCharges_) {
    #ifndef NDEBUG
    if (!(T_e8SUVCharges_IsValid(SUVCharges_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SUVCharges_, "T_e8SUVCharges", "SUVCharges", "T_AmenityInfo");
    }
    #endif
    set_has_SUVCharges();
    this->_SUVCharges = SUVCharges_;
}

inline void T_AmenityInfo::clearRV() {
    if (hasRV()) {
         clear_has_RV();
        _RV = ::sxm_parking_main_fi_types::T_e8RV__UNKNOWN;
     }
}

inline bool T_AmenityInfo::hasRV () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline T_e8RV T_AmenityInfo::getRV () const {
    return _RV;
}

inline void T_AmenityInfo::setRV (T_e8RV RV_) {
    #ifndef NDEBUG
    if (!(T_e8RV_IsValid(RV_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RV_, "T_e8RV", "RV", "T_AmenityInfo");
    }
    #endif
    set_has_RV();
    this->_RV = RV_;
}

inline void T_AmenityInfo::set_has_Open24Hours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AmenityInfo::clear_has_Open24Hours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AmenityInfo::set_has_Cash () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AmenityInfo::clear_has_Cash () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AmenityInfo::set_has_Card () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AmenityInfo::clear_has_Card () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AmenityInfo::set_has_ParkingType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AmenityInfo::clear_has_ParkingType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AmenityInfo::set_has_MetroLocation () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AmenityInfo::clear_has_MetroLocation () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AmenityInfo::set_has_AirPort () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AmenityInfo::clear_has_AirPort () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AmenityInfo::set_has_OvernightParking () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AmenityInfo::clear_has_OvernightParking () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_AmenityInfo::set_has_Reservations () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_AmenityInfo::clear_has_Reservations () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_AmenityInfo::set_has_SelfParking () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_AmenityInfo::clear_has_SelfParking () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_AmenityInfo::set_has_Security () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_AmenityInfo::clear_has_Security () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_AmenityInfo::set_has_TollTag () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_AmenityInfo::clear_has_TollTag () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_AmenityInfo::set_has_SUVCharges () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_AmenityInfo::clear_has_SUVCharges () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_AmenityInfo::set_has_RV () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_AmenityInfo::clear_has_RV () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  T_PriceInfo::T_PriceInfo ()  :
    _WeekdayHourly (),
    _SaturdayHourly (),
    _SundayHourly (),
    _WeekdayDaily (0.0f),
    _SaturdayDaily (0.0f),
    _SundayDaily (0.0f),
    _EarlyBird (0.0f),
    _Event (0.0f),
    _Other (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PriceInfo::T_PriceInfo (const T_PriceInfo &rhs)  :
    _WeekdayHourly (),
    _SaturdayHourly (),
    _SundayHourly (),
    _WeekdayDaily (0.0f),
    _SaturdayDaily (0.0f),
    _SundayDaily (0.0f),
    _EarlyBird (0.0f),
    _Event (0.0f),
    _Other (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PriceInfo::T_PriceInfo (const ::std::vector< float >& WeekdayHourly_, const ::std::vector< float >& SaturdayHourly_, const ::std::vector< float >& SundayHourly_, float WeekdayDaily_, float SaturdayDaily_, float SundayDaily_, float EarlyBird_, float Event_, float Other_)  :
    _WeekdayHourly (WeekdayHourly_),
    _SaturdayHourly (SaturdayHourly_),
    _SundayHourly (SundayHourly_),
    _WeekdayDaily (WeekdayDaily_),
    _SaturdayDaily (SaturdayDaily_),
    _SundayDaily (SundayDaily_),
    _EarlyBird (EarlyBird_),
    _Event (Event_),
    _Other (Other_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PriceInfo::~T_PriceInfo() {
}

inline T_PriceInfo& T_PriceInfo::operator = (const T_PriceInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasWeekdayHourly()) {
            setWeekdayHourly(rhs.getWeekdayHourly());
        } else {
            clearWeekdayHourly();
        }
        if (rhs.hasSaturdayHourly()) {
            setSaturdayHourly(rhs.getSaturdayHourly());
        } else {
            clearSaturdayHourly();
        }
        if (rhs.hasSundayHourly()) {
            setSundayHourly(rhs.getSundayHourly());
        } else {
            clearSundayHourly();
        }
        if (rhs.hasWeekdayDaily()) {
            setWeekdayDaily(rhs.getWeekdayDaily());
        } else {
            clearWeekdayDaily();
        }
        if (rhs.hasSaturdayDaily()) {
            setSaturdayDaily(rhs.getSaturdayDaily());
        } else {
            clearSaturdayDaily();
        }
        if (rhs.hasSundayDaily()) {
            setSundayDaily(rhs.getSundayDaily());
        } else {
            clearSundayDaily();
        }
        if (rhs.hasEarlyBird()) {
            setEarlyBird(rhs.getEarlyBird());
        } else {
            clearEarlyBird();
        }
        if (rhs.hasEvent()) {
            setEvent(rhs.getEvent());
        } else {
            clearEvent();
        }
        if (rhs.hasOther()) {
            setOther(rhs.getOther());
        } else {
            clearOther();
        }
    }
    return *this;
}

inline bool T_PriceInfo::operator == (const T_PriceInfo& rhs) const {
    return (((!hasWeekdayHourly() && !rhs.hasWeekdayHourly()) || getWeekdayHourly() == rhs.getWeekdayHourly()) &&
        ((!hasSaturdayHourly() && !rhs.hasSaturdayHourly()) || getSaturdayHourly() == rhs.getSaturdayHourly()) &&
        ((!hasSundayHourly() && !rhs.hasSundayHourly()) || getSundayHourly() == rhs.getSundayHourly()) &&
        ((!hasWeekdayDaily() && !rhs.hasWeekdayDaily()) || getWeekdayDaily() == rhs.getWeekdayDaily()) &&
        ((!hasSaturdayDaily() && !rhs.hasSaturdayDaily()) || getSaturdayDaily() == rhs.getSaturdayDaily()) &&
        ((!hasSundayDaily() && !rhs.hasSundayDaily()) || getSundayDaily() == rhs.getSundayDaily()) &&
        ((!hasEarlyBird() && !rhs.hasEarlyBird()) || getEarlyBird() == rhs.getEarlyBird()) &&
        ((!hasEvent() && !rhs.hasEvent()) || getEvent() == rhs.getEvent()) &&
        ((!hasOther() && !rhs.hasOther()) || getOther() == rhs.getOther()));
}

inline bool T_PriceInfo::operator != (const T_PriceInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PriceInfo::operator < (const T_PriceInfo& rhs) const {
    if (hasWeekdayHourly() || rhs.hasWeekdayHourly()) {
        if (getWeekdayHourly() < rhs.getWeekdayHourly()) return true;
        if (getWeekdayHourly() > rhs.getWeekdayHourly()) return false;
    }
    if (hasSaturdayHourly() || rhs.hasSaturdayHourly()) {
        if (getSaturdayHourly() < rhs.getSaturdayHourly()) return true;
        if (getSaturdayHourly() > rhs.getSaturdayHourly()) return false;
    }
    if (hasSundayHourly() || rhs.hasSundayHourly()) {
        if (getSundayHourly() < rhs.getSundayHourly()) return true;
        if (getSundayHourly() > rhs.getSundayHourly()) return false;
    }
    if (hasWeekdayDaily() || rhs.hasWeekdayDaily()) {
        if (getWeekdayDaily() < rhs.getWeekdayDaily()) return true;
        if (getWeekdayDaily() > rhs.getWeekdayDaily()) return false;
    }
    if (hasSaturdayDaily() || rhs.hasSaturdayDaily()) {
        if (getSaturdayDaily() < rhs.getSaturdayDaily()) return true;
        if (getSaturdayDaily() > rhs.getSaturdayDaily()) return false;
    }
    if (hasSundayDaily() || rhs.hasSundayDaily()) {
        if (getSundayDaily() < rhs.getSundayDaily()) return true;
        if (getSundayDaily() > rhs.getSundayDaily()) return false;
    }
    if (hasEarlyBird() || rhs.hasEarlyBird()) {
        if (getEarlyBird() < rhs.getEarlyBird()) return true;
        if (getEarlyBird() > rhs.getEarlyBird()) return false;
    }
    if (hasEvent() || rhs.hasEvent()) {
        if (getEvent() < rhs.getEvent()) return true;
        if (getEvent() > rhs.getEvent()) return false;
    }
    if (hasOther() || rhs.hasOther()) {
        if (getOther() < rhs.getOther()) return true;
        if (getOther() > rhs.getOther()) return false;
    }
    return false;
}

inline bool T_PriceInfo::operator > (const T_PriceInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PriceInfo::clear() {
    clearWeekdayHourly();
    clearSaturdayHourly();
    clearSundayHourly();
    clearWeekdayDaily();
    clearSaturdayDaily();
    clearSundayDaily();
    clearEarlyBird();
    clearEvent();
    clearOther();
}

inline void T_PriceInfo::clearWeekdayHourly() {
    if (hasWeekdayHourly()) {
         clear_has_WeekdayHourly();
        _WeekdayHourly.clear();
     }
}

inline bool T_PriceInfo::hasWeekdayHourly () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< float >& T_PriceInfo::getWeekdayHourly () const {
    return _WeekdayHourly;
}

inline ::std::vector< float >& T_PriceInfo::getWeekdayHourlyMutable () {
    set_has_WeekdayHourly();
    return _WeekdayHourly;
}

inline void T_PriceInfo::setWeekdayHourly (const ::std::vector< float >& WeekdayHourly_) {
    set_has_WeekdayHourly();
    this->_WeekdayHourly = WeekdayHourly_;
}

inline void T_PriceInfo::clearSaturdayHourly() {
    if (hasSaturdayHourly()) {
         clear_has_SaturdayHourly();
        _SaturdayHourly.clear();
     }
}

inline bool T_PriceInfo::hasSaturdayHourly () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< float >& T_PriceInfo::getSaturdayHourly () const {
    return _SaturdayHourly;
}

inline ::std::vector< float >& T_PriceInfo::getSaturdayHourlyMutable () {
    set_has_SaturdayHourly();
    return _SaturdayHourly;
}

inline void T_PriceInfo::setSaturdayHourly (const ::std::vector< float >& SaturdayHourly_) {
    set_has_SaturdayHourly();
    this->_SaturdayHourly = SaturdayHourly_;
}

inline void T_PriceInfo::clearSundayHourly() {
    if (hasSundayHourly()) {
         clear_has_SundayHourly();
        _SundayHourly.clear();
     }
}

inline bool T_PriceInfo::hasSundayHourly () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< float >& T_PriceInfo::getSundayHourly () const {
    return _SundayHourly;
}

inline ::std::vector< float >& T_PriceInfo::getSundayHourlyMutable () {
    set_has_SundayHourly();
    return _SundayHourly;
}

inline void T_PriceInfo::setSundayHourly (const ::std::vector< float >& SundayHourly_) {
    set_has_SundayHourly();
    this->_SundayHourly = SundayHourly_;
}

inline void T_PriceInfo::clearWeekdayDaily() {
    if (hasWeekdayDaily()) {
         clear_has_WeekdayDaily();
        _WeekdayDaily = 0.0f;
     }
}

inline bool T_PriceInfo::hasWeekdayDaily () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_PriceInfo::getWeekdayDaily () const {
    return _WeekdayDaily;
}

inline void T_PriceInfo::setWeekdayDaily (float WeekdayDaily_) {
    set_has_WeekdayDaily();
    this->_WeekdayDaily = WeekdayDaily_;
}

inline void T_PriceInfo::clearSaturdayDaily() {
    if (hasSaturdayDaily()) {
         clear_has_SaturdayDaily();
        _SaturdayDaily = 0.0f;
     }
}

inline bool T_PriceInfo::hasSaturdayDaily () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_PriceInfo::getSaturdayDaily () const {
    return _SaturdayDaily;
}

inline void T_PriceInfo::setSaturdayDaily (float SaturdayDaily_) {
    set_has_SaturdayDaily();
    this->_SaturdayDaily = SaturdayDaily_;
}

inline void T_PriceInfo::clearSundayDaily() {
    if (hasSundayDaily()) {
         clear_has_SundayDaily();
        _SundayDaily = 0.0f;
     }
}

inline bool T_PriceInfo::hasSundayDaily () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float T_PriceInfo::getSundayDaily () const {
    return _SundayDaily;
}

inline void T_PriceInfo::setSundayDaily (float SundayDaily_) {
    set_has_SundayDaily();
    this->_SundayDaily = SundayDaily_;
}

inline void T_PriceInfo::clearEarlyBird() {
    if (hasEarlyBird()) {
         clear_has_EarlyBird();
        _EarlyBird = 0.0f;
     }
}

inline bool T_PriceInfo::hasEarlyBird () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline float T_PriceInfo::getEarlyBird () const {
    return _EarlyBird;
}

inline void T_PriceInfo::setEarlyBird (float EarlyBird_) {
    set_has_EarlyBird();
    this->_EarlyBird = EarlyBird_;
}

inline void T_PriceInfo::clearEvent() {
    if (hasEvent()) {
         clear_has_Event();
        _Event = 0.0f;
     }
}

inline bool T_PriceInfo::hasEvent () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline float T_PriceInfo::getEvent () const {
    return _Event;
}

inline void T_PriceInfo::setEvent (float Event_) {
    set_has_Event();
    this->_Event = Event_;
}

inline void T_PriceInfo::clearOther() {
    if (hasOther()) {
         clear_has_Other();
        _Other = 0.0f;
     }
}

inline bool T_PriceInfo::hasOther () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline float T_PriceInfo::getOther () const {
    return _Other;
}

inline void T_PriceInfo::setOther (float Other_) {
    set_has_Other();
    this->_Other = Other_;
}

inline void T_PriceInfo::set_has_WeekdayHourly () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PriceInfo::clear_has_WeekdayHourly () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PriceInfo::set_has_SaturdayHourly () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PriceInfo::clear_has_SaturdayHourly () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PriceInfo::set_has_SundayHourly () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PriceInfo::clear_has_SundayHourly () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PriceInfo::set_has_WeekdayDaily () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PriceInfo::clear_has_WeekdayDaily () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PriceInfo::set_has_SaturdayDaily () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PriceInfo::clear_has_SaturdayDaily () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PriceInfo::set_has_SundayDaily () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PriceInfo::clear_has_SundayDaily () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PriceInfo::set_has_EarlyBird () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PriceInfo::clear_has_EarlyBird () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_PriceInfo::set_has_Event () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_PriceInfo::clear_has_Event () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_PriceInfo::set_has_Other () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_PriceInfo::clear_has_Other () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_Time::T_Time ()  :
    _Hours (0u),
    _Minutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Time::T_Time (const T_Time &rhs)  :
    _Hours (0u),
    _Minutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Time::T_Time (uint32 Hours_, uint32 Minutes_)  :
    _Hours (Hours_),
    _Minutes (Minutes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Time::~T_Time() {
}

inline T_Time& T_Time::operator = (const T_Time& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHours()) {
            setHours(rhs.getHours());
        } else {
            clearHours();
        }
        if (rhs.hasMinutes()) {
            setMinutes(rhs.getMinutes());
        } else {
            clearMinutes();
        }
    }
    return *this;
}

inline bool T_Time::operator == (const T_Time& rhs) const {
    return (((!hasHours() && !rhs.hasHours()) || getHours() == rhs.getHours()) &&
        ((!hasMinutes() && !rhs.hasMinutes()) || getMinutes() == rhs.getMinutes()));
}

inline bool T_Time::operator != (const T_Time& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Time::operator < (const T_Time& rhs) const {
    if (hasHours() || rhs.hasHours()) {
        if (getHours() < rhs.getHours()) return true;
        if (getHours() > rhs.getHours()) return false;
    }
    if (hasMinutes() || rhs.hasMinutes()) {
        if (getMinutes() < rhs.getMinutes()) return true;
        if (getMinutes() > rhs.getMinutes()) return false;
    }
    return false;
}

inline bool T_Time::operator > (const T_Time& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Time::clear() {
    clearHours();
    clearMinutes();
}

inline void T_Time::clearHours() {
    if (hasHours()) {
         clear_has_Hours();
        _Hours = 0u;
     }
}

inline bool T_Time::hasHours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_Time::getHours () const {
    return _Hours;
}

inline void T_Time::setHours (uint32 Hours_) {
    set_has_Hours();
    this->_Hours = Hours_;
}

inline void T_Time::clearMinutes() {
    if (hasMinutes()) {
         clear_has_Minutes();
        _Minutes = 0u;
     }
}

inline bool T_Time::hasMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_Time::getMinutes () const {
    return _Minutes;
}

inline void T_Time::setMinutes (uint32 Minutes_) {
    set_has_Minutes();
    this->_Minutes = Minutes_;
}

inline void T_Time::set_has_Hours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Time::clear_has_Hours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Time::set_has_Minutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Time::clear_has_Minutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_PerDayOpeningTimes::T_PerDayOpeningTimes ()  :
    _StartTime (),
    _EndTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PerDayOpeningTimes::T_PerDayOpeningTimes (const T_PerDayOpeningTimes &rhs)  :
    _StartTime (),
    _EndTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PerDayOpeningTimes::T_PerDayOpeningTimes (const T_Time& StartTime_, const T_Time& EndTime_)  :
    _StartTime (StartTime_),
    _EndTime (EndTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PerDayOpeningTimes::~T_PerDayOpeningTimes() {
}

inline T_PerDayOpeningTimes& T_PerDayOpeningTimes::operator = (const T_PerDayOpeningTimes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStartTime()) {
            setStartTime(rhs.getStartTime());
        } else {
            clearStartTime();
        }
        if (rhs.hasEndTime()) {
            setEndTime(rhs.getEndTime());
        } else {
            clearEndTime();
        }
    }
    return *this;
}

inline bool T_PerDayOpeningTimes::operator == (const T_PerDayOpeningTimes& rhs) const {
    return (((!hasStartTime() && !rhs.hasStartTime()) || getStartTime() == rhs.getStartTime()) &&
        ((!hasEndTime() && !rhs.hasEndTime()) || getEndTime() == rhs.getEndTime()));
}

inline bool T_PerDayOpeningTimes::operator != (const T_PerDayOpeningTimes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PerDayOpeningTimes::operator < (const T_PerDayOpeningTimes& rhs) const {
    if (hasStartTime() || rhs.hasStartTime()) {
        if (getStartTime() < rhs.getStartTime()) return true;
        if (getStartTime() > rhs.getStartTime()) return false;
    }
    if (hasEndTime() || rhs.hasEndTime()) {
        if (getEndTime() < rhs.getEndTime()) return true;
        if (getEndTime() > rhs.getEndTime()) return false;
    }
    return false;
}

inline bool T_PerDayOpeningTimes::operator > (const T_PerDayOpeningTimes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PerDayOpeningTimes::clear() {
    clearStartTime();
    clearEndTime();
}

inline void T_PerDayOpeningTimes::clearStartTime() {
    if (hasStartTime()) {
         clear_has_StartTime();
        _StartTime.clear();
     }
}

inline bool T_PerDayOpeningTimes::hasStartTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_Time& T_PerDayOpeningTimes::getStartTime () const {
    return _StartTime;
}

inline T_Time& T_PerDayOpeningTimes::getStartTimeMutable () {
    set_has_StartTime();
    return _StartTime;
}

inline void T_PerDayOpeningTimes::setStartTime (const T_Time& StartTime_) {
    set_has_StartTime();
    this->_StartTime = StartTime_;
}

inline void T_PerDayOpeningTimes::clearEndTime() {
    if (hasEndTime()) {
         clear_has_EndTime();
        _EndTime.clear();
     }
}

inline bool T_PerDayOpeningTimes::hasEndTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_Time& T_PerDayOpeningTimes::getEndTime () const {
    return _EndTime;
}

inline T_Time& T_PerDayOpeningTimes::getEndTimeMutable () {
    set_has_EndTime();
    return _EndTime;
}

inline void T_PerDayOpeningTimes::setEndTime (const T_Time& EndTime_) {
    set_has_EndTime();
    this->_EndTime = EndTime_;
}

inline void T_PerDayOpeningTimes::set_has_StartTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PerDayOpeningTimes::clear_has_StartTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PerDayOpeningTimes::set_has_EndTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PerDayOpeningTimes::clear_has_EndTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_OpeningTime::T_OpeningTime ()  :
    _DayType (::sxm_parking_main_fi_types::T_e8DayType__MONDAY),
    _PerDayOpeningTimes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_OpeningTime::T_OpeningTime (const T_OpeningTime &rhs)  :
    _DayType (::sxm_parking_main_fi_types::T_e8DayType__MONDAY),
    _PerDayOpeningTimes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_OpeningTime::T_OpeningTime (T_e8DayType DayType_, const ::std::vector< T_PerDayOpeningTimes >& PerDayOpeningTimes_)  :
    _DayType (DayType_),
    _PerDayOpeningTimes (PerDayOpeningTimes_)
{
    #ifndef NDEBUG
    if (!(T_e8DayType_IsValid(DayType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DayType_, "T_e8DayType", "DayType", "T_OpeningTime");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_OpeningTime::~T_OpeningTime() {
}

inline T_OpeningTime& T_OpeningTime::operator = (const T_OpeningTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDayType()) {
            setDayType(rhs.getDayType());
        } else {
            clearDayType();
        }
        if (rhs.hasPerDayOpeningTimes()) {
            setPerDayOpeningTimes(rhs.getPerDayOpeningTimes());
        } else {
            clearPerDayOpeningTimes();
        }
    }
    return *this;
}

inline bool T_OpeningTime::operator == (const T_OpeningTime& rhs) const {
    return (((!hasDayType() && !rhs.hasDayType()) || getDayType() == rhs.getDayType()) &&
        ((!hasPerDayOpeningTimes() && !rhs.hasPerDayOpeningTimes()) || getPerDayOpeningTimes() == rhs.getPerDayOpeningTimes()));
}

inline bool T_OpeningTime::operator != (const T_OpeningTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_OpeningTime::operator < (const T_OpeningTime& rhs) const {
    if (hasDayType() || rhs.hasDayType()) {
        if ((uint32)getDayType() < (uint32)rhs.getDayType()) return true;
        if ((uint32)getDayType() > (uint32)rhs.getDayType()) return false;
    }
    if (hasPerDayOpeningTimes() || rhs.hasPerDayOpeningTimes()) {
        if (getPerDayOpeningTimes() < rhs.getPerDayOpeningTimes()) return true;
        if (getPerDayOpeningTimes() > rhs.getPerDayOpeningTimes()) return false;
    }
    return false;
}

inline bool T_OpeningTime::operator > (const T_OpeningTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_OpeningTime::clear() {
    clearDayType();
    clearPerDayOpeningTimes();
}

inline void T_OpeningTime::clearDayType() {
    if (hasDayType()) {
         clear_has_DayType();
        _DayType = ::sxm_parking_main_fi_types::T_e8DayType__MONDAY;
     }
}

inline bool T_OpeningTime::hasDayType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8DayType T_OpeningTime::getDayType () const {
    return _DayType;
}

inline void T_OpeningTime::setDayType (T_e8DayType DayType_) {
    #ifndef NDEBUG
    if (!(T_e8DayType_IsValid(DayType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DayType_, "T_e8DayType", "DayType", "T_OpeningTime");
    }
    #endif
    set_has_DayType();
    this->_DayType = DayType_;
}

inline void T_OpeningTime::clearPerDayOpeningTimes() {
    if (hasPerDayOpeningTimes()) {
         clear_has_PerDayOpeningTimes();
        _PerDayOpeningTimes.clear();
     }
}

inline bool T_OpeningTime::hasPerDayOpeningTimes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_PerDayOpeningTimes >& T_OpeningTime::getPerDayOpeningTimes () const {
    return _PerDayOpeningTimes;
}

inline ::std::vector< T_PerDayOpeningTimes >& T_OpeningTime::getPerDayOpeningTimesMutable () {
    set_has_PerDayOpeningTimes();
    return _PerDayOpeningTimes;
}

inline void T_OpeningTime::setPerDayOpeningTimes (const ::std::vector< T_PerDayOpeningTimes >& PerDayOpeningTimes_) {
    set_has_PerDayOpeningTimes();
    this->_PerDayOpeningTimes = PerDayOpeningTimes_;
}

inline void T_OpeningTime::set_has_DayType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_OpeningTime::clear_has_DayType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_OpeningTime::set_has_PerDayOpeningTimes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_OpeningTime::clear_has_PerDayOpeningTimes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ParkingInfo::T_ParkingInfo ()  :
    _ID (0u),
    _Name (),
    _Address (),
    _SecondaryAddress (),
    _City (),
    _Zip (),
    _State (),
    _Phone (),
    _Capacity (0u),
    _Distance (0.0f),
    _PrimaryLocation (),
    _SecondaryLocation (),
    _PrimaryHeight (0u),
    _SecondaryHeight (0u),
    _AvailableTime (0u),
    _RelativePricingHourly (0u),
    _RelativePricingDaily (0u),
    _OpenStatus (::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN),
    _OpeningTimes (),
    _Fullness (),
    _Amenities (),
    _PricingInfo (),
    _IsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ParkingInfo::T_ParkingInfo (const T_ParkingInfo &rhs)  :
    _ID (0u),
    _Name (),
    _Address (),
    _SecondaryAddress (),
    _City (),
    _Zip (),
    _State (),
    _Phone (),
    _Capacity (0u),
    _Distance (0.0f),
    _PrimaryLocation (),
    _SecondaryLocation (),
    _PrimaryHeight (0u),
    _SecondaryHeight (0u),
    _AvailableTime (0u),
    _RelativePricingHourly (0u),
    _RelativePricingDaily (0u),
    _OpenStatus (::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN),
    _OpeningTimes (),
    _Fullness (),
    _Amenities (),
    _PricingInfo (),
    _IsFavorite (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ParkingInfo::T_ParkingInfo (uint32 ID_, const ::std::string& Name_, const ::std::string& Address_, const ::std::string& SecondaryAddress_, const ::std::string& City_, const ::std::string& Zip_, const ::std::string& State_, const ::std::string& Phone_, uint32 Capacity_, float Distance_, const ::fi_types::T_PositionWGS84& PrimaryLocation_, const ::fi_types::T_PositionWGS84& SecondaryLocation_, uint32 PrimaryHeight_, uint32 SecondaryHeight_, uint32 AvailableTime_, uint8 RelativePricingHourly_, uint8 RelativePricingDaily_, T_e8OpenStatus OpenStatus_, const ::std::vector< T_OpeningTime >& OpeningTimes_, const ::std::vector< T_Fullness >& Fullness_, const T_AmenityInfo& Amenities_, const T_PriceInfo& PricingInfo_, bool IsFavorite_)  :
    _ID (ID_),
    _Name (Name_),
    _Address (Address_),
    _SecondaryAddress (SecondaryAddress_),
    _City (City_),
    _Zip (Zip_),
    _State (State_),
    _Phone (Phone_),
    _Capacity (Capacity_),
    _Distance (Distance_),
    _PrimaryLocation (PrimaryLocation_),
    _SecondaryLocation (SecondaryLocation_),
    _PrimaryHeight (PrimaryHeight_),
    _SecondaryHeight (SecondaryHeight_),
    _AvailableTime (AvailableTime_),
    _RelativePricingHourly (RelativePricingHourly_),
    _RelativePricingDaily (RelativePricingDaily_),
    _OpenStatus (OpenStatus_),
    _OpeningTimes (OpeningTimes_),
    _Fullness (Fullness_),
    _Amenities (Amenities_),
    _PricingInfo (PricingInfo_),
    _IsFavorite (IsFavorite_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SecondaryAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Zip_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8OpenStatus_IsValid(OpenStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OpenStatus_, "T_e8OpenStatus", "OpenStatus", "T_ParkingInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ParkingInfo::~T_ParkingInfo() {
}

inline T_ParkingInfo& T_ParkingInfo::operator = (const T_ParkingInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasSecondaryAddress()) {
            setSecondaryAddress(rhs.getSecondaryAddress());
        } else {
            clearSecondaryAddress();
        }
        if (rhs.hasCity()) {
            setCity(rhs.getCity());
        } else {
            clearCity();
        }
        if (rhs.hasZip()) {
            setZip(rhs.getZip());
        } else {
            clearZip();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasPhone()) {
            setPhone(rhs.getPhone());
        } else {
            clearPhone();
        }
        if (rhs.hasCapacity()) {
            setCapacity(rhs.getCapacity());
        } else {
            clearCapacity();
        }
        if (rhs.hasDistance()) {
            setDistance(rhs.getDistance());
        } else {
            clearDistance();
        }
        if (rhs.hasPrimaryLocation()) {
            setPrimaryLocation(rhs.getPrimaryLocation());
        } else {
            clearPrimaryLocation();
        }
        if (rhs.hasSecondaryLocation()) {
            setSecondaryLocation(rhs.getSecondaryLocation());
        } else {
            clearSecondaryLocation();
        }
        if (rhs.hasPrimaryHeight()) {
            setPrimaryHeight(rhs.getPrimaryHeight());
        } else {
            clearPrimaryHeight();
        }
        if (rhs.hasSecondaryHeight()) {
            setSecondaryHeight(rhs.getSecondaryHeight());
        } else {
            clearSecondaryHeight();
        }
        if (rhs.hasAvailableTime()) {
            setAvailableTime(rhs.getAvailableTime());
        } else {
            clearAvailableTime();
        }
        if (rhs.hasRelativePricingHourly()) {
            setRelativePricingHourly(rhs.getRelativePricingHourly());
        } else {
            clearRelativePricingHourly();
        }
        if (rhs.hasRelativePricingDaily()) {
            setRelativePricingDaily(rhs.getRelativePricingDaily());
        } else {
            clearRelativePricingDaily();
        }
        if (rhs.hasOpenStatus()) {
            setOpenStatus(rhs.getOpenStatus());
        } else {
            clearOpenStatus();
        }
        if (rhs.hasOpeningTimes()) {
            setOpeningTimes(rhs.getOpeningTimes());
        } else {
            clearOpeningTimes();
        }
        if (rhs.hasFullness()) {
            setFullness(rhs.getFullness());
        } else {
            clearFullness();
        }
        if (rhs.hasAmenities()) {
            setAmenities(rhs.getAmenities());
        } else {
            clearAmenities();
        }
        if (rhs.hasPricingInfo()) {
            setPricingInfo(rhs.getPricingInfo());
        } else {
            clearPricingInfo();
        }
        if (rhs.hasIsFavorite()) {
            setIsFavorite(rhs.getIsFavorite());
        } else {
            clearIsFavorite();
        }
    }
    return *this;
}

inline bool T_ParkingInfo::operator == (const T_ParkingInfo& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasSecondaryAddress() && !rhs.hasSecondaryAddress()) || getSecondaryAddress() == rhs.getSecondaryAddress()) &&
        ((!hasCity() && !rhs.hasCity()) || getCity() == rhs.getCity()) &&
        ((!hasZip() && !rhs.hasZip()) || getZip() == rhs.getZip()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasPhone() && !rhs.hasPhone()) || getPhone() == rhs.getPhone()) &&
        ((!hasCapacity() && !rhs.hasCapacity()) || getCapacity() == rhs.getCapacity()) &&
        ((!hasDistance() && !rhs.hasDistance()) || getDistance() == rhs.getDistance()) &&
        ((!hasPrimaryLocation() && !rhs.hasPrimaryLocation()) || getPrimaryLocation() == rhs.getPrimaryLocation()) &&
        ((!hasSecondaryLocation() && !rhs.hasSecondaryLocation()) || getSecondaryLocation() == rhs.getSecondaryLocation()) &&
        ((!hasPrimaryHeight() && !rhs.hasPrimaryHeight()) || getPrimaryHeight() == rhs.getPrimaryHeight()) &&
        ((!hasSecondaryHeight() && !rhs.hasSecondaryHeight()) || getSecondaryHeight() == rhs.getSecondaryHeight()) &&
        ((!hasAvailableTime() && !rhs.hasAvailableTime()) || getAvailableTime() == rhs.getAvailableTime()) &&
        ((!hasRelativePricingHourly() && !rhs.hasRelativePricingHourly()) || getRelativePricingHourly() == rhs.getRelativePricingHourly()) &&
        ((!hasRelativePricingDaily() && !rhs.hasRelativePricingDaily()) || getRelativePricingDaily() == rhs.getRelativePricingDaily()) &&
        ((!hasOpenStatus() && !rhs.hasOpenStatus()) || getOpenStatus() == rhs.getOpenStatus()) &&
        ((!hasOpeningTimes() && !rhs.hasOpeningTimes()) || getOpeningTimes() == rhs.getOpeningTimes()) &&
        ((!hasFullness() && !rhs.hasFullness()) || getFullness() == rhs.getFullness()) &&
        ((!hasAmenities() && !rhs.hasAmenities()) || getAmenities() == rhs.getAmenities()) &&
        ((!hasPricingInfo() && !rhs.hasPricingInfo()) || getPricingInfo() == rhs.getPricingInfo()) &&
        ((!hasIsFavorite() && !rhs.hasIsFavorite()) || getIsFavorite() == rhs.getIsFavorite()));
}

inline bool T_ParkingInfo::operator != (const T_ParkingInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ParkingInfo::operator < (const T_ParkingInfo& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasSecondaryAddress() || rhs.hasSecondaryAddress()) {
        if (getSecondaryAddress() < rhs.getSecondaryAddress()) return true;
        if (getSecondaryAddress() > rhs.getSecondaryAddress()) return false;
    }
    if (hasCity() || rhs.hasCity()) {
        if (getCity() < rhs.getCity()) return true;
        if (getCity() > rhs.getCity()) return false;
    }
    if (hasZip() || rhs.hasZip()) {
        if (getZip() < rhs.getZip()) return true;
        if (getZip() > rhs.getZip()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    if (hasPhone() || rhs.hasPhone()) {
        if (getPhone() < rhs.getPhone()) return true;
        if (getPhone() > rhs.getPhone()) return false;
    }
    if (hasCapacity() || rhs.hasCapacity()) {
        if (getCapacity() < rhs.getCapacity()) return true;
        if (getCapacity() > rhs.getCapacity()) return false;
    }
    if (hasDistance() || rhs.hasDistance()) {
        if (getDistance() < rhs.getDistance()) return true;
        if (getDistance() > rhs.getDistance()) return false;
    }
    if (hasPrimaryLocation() || rhs.hasPrimaryLocation()) {
        if (getPrimaryLocation() < rhs.getPrimaryLocation()) return true;
        if (getPrimaryLocation() > rhs.getPrimaryLocation()) return false;
    }
    if (hasSecondaryLocation() || rhs.hasSecondaryLocation()) {
        if (getSecondaryLocation() < rhs.getSecondaryLocation()) return true;
        if (getSecondaryLocation() > rhs.getSecondaryLocation()) return false;
    }
    if (hasPrimaryHeight() || rhs.hasPrimaryHeight()) {
        if (getPrimaryHeight() < rhs.getPrimaryHeight()) return true;
        if (getPrimaryHeight() > rhs.getPrimaryHeight()) return false;
    }
    if (hasSecondaryHeight() || rhs.hasSecondaryHeight()) {
        if (getSecondaryHeight() < rhs.getSecondaryHeight()) return true;
        if (getSecondaryHeight() > rhs.getSecondaryHeight()) return false;
    }
    if (hasAvailableTime() || rhs.hasAvailableTime()) {
        if (getAvailableTime() < rhs.getAvailableTime()) return true;
        if (getAvailableTime() > rhs.getAvailableTime()) return false;
    }
    if (hasRelativePricingHourly() || rhs.hasRelativePricingHourly()) {
        if (getRelativePricingHourly() < rhs.getRelativePricingHourly()) return true;
        if (getRelativePricingHourly() > rhs.getRelativePricingHourly()) return false;
    }
    if (hasRelativePricingDaily() || rhs.hasRelativePricingDaily()) {
        if (getRelativePricingDaily() < rhs.getRelativePricingDaily()) return true;
        if (getRelativePricingDaily() > rhs.getRelativePricingDaily()) return false;
    }
    if (hasOpenStatus() || rhs.hasOpenStatus()) {
        if ((uint32)getOpenStatus() < (uint32)rhs.getOpenStatus()) return true;
        if ((uint32)getOpenStatus() > (uint32)rhs.getOpenStatus()) return false;
    }
    if (hasOpeningTimes() || rhs.hasOpeningTimes()) {
        if (getOpeningTimes() < rhs.getOpeningTimes()) return true;
        if (getOpeningTimes() > rhs.getOpeningTimes()) return false;
    }
    if (hasFullness() || rhs.hasFullness()) {
        if (getFullness() < rhs.getFullness()) return true;
        if (getFullness() > rhs.getFullness()) return false;
    }
    if (hasAmenities() || rhs.hasAmenities()) {
        if (getAmenities() < rhs.getAmenities()) return true;
        if (getAmenities() > rhs.getAmenities()) return false;
    }
    if (hasPricingInfo() || rhs.hasPricingInfo()) {
        if (getPricingInfo() < rhs.getPricingInfo()) return true;
        if (getPricingInfo() > rhs.getPricingInfo()) return false;
    }
    if (hasIsFavorite() || rhs.hasIsFavorite()) {
        if (getIsFavorite() < rhs.getIsFavorite()) return true;
        if (getIsFavorite() > rhs.getIsFavorite()) return false;
    }
    return false;
}

inline bool T_ParkingInfo::operator > (const T_ParkingInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ParkingInfo::clear() {
    clearID();
    clearName();
    clearAddress();
    clearSecondaryAddress();
    clearCity();
    clearZip();
    clearState();
    clearPhone();
    clearCapacity();
    clearDistance();
    clearPrimaryLocation();
    clearSecondaryLocation();
    clearPrimaryHeight();
    clearSecondaryHeight();
    clearAvailableTime();
    clearRelativePricingHourly();
    clearRelativePricingDaily();
    clearOpenStatus();
    clearOpeningTimes();
    clearFullness();
    clearAmenities();
    clearPricingInfo();
    clearIsFavorite();
}

inline void T_ParkingInfo::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_ParkingInfo::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_ParkingInfo::getID () const {
    return _ID;
}

inline void T_ParkingInfo::setID (uint32 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_ParkingInfo::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool T_ParkingInfo::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_ParkingInfo::getName () const {
    return _Name;
}

inline ::std::string& T_ParkingInfo::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void T_ParkingInfo::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void T_ParkingInfo::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void T_ParkingInfo::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void T_ParkingInfo::clearAddress() {
    if (hasAddress()) {
         clear_has_Address();
        _Address.clear();
     }
}

inline bool T_ParkingInfo::hasAddress () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_ParkingInfo::getAddress () const {
    return _Address;
}

inline ::std::string& T_ParkingInfo::getAddressMutable () {
    set_has_Address();
    return _Address;
}

inline void T_ParkingInfo::setAddress (const ::std::string& Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address = Address_;
}

inline void T_ParkingInfo::setAddress (const char* Address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(Address_);
}

inline void T_ParkingInfo::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Address();
    this->_Address.assign(value, size);
}

inline void T_ParkingInfo::clearSecondaryAddress() {
    if (hasSecondaryAddress()) {
         clear_has_SecondaryAddress();
        _SecondaryAddress.clear();
     }
}

inline bool T_ParkingInfo::hasSecondaryAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_ParkingInfo::getSecondaryAddress () const {
    return _SecondaryAddress;
}

inline ::std::string& T_ParkingInfo::getSecondaryAddressMutable () {
    set_has_SecondaryAddress();
    return _SecondaryAddress;
}

inline void T_ParkingInfo::setSecondaryAddress (const ::std::string& SecondaryAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SecondaryAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SecondaryAddress();
    this->_SecondaryAddress = SecondaryAddress_;
}

inline void T_ParkingInfo::setSecondaryAddress (const char* SecondaryAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SecondaryAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SecondaryAddress();
    this->_SecondaryAddress.assign(SecondaryAddress_);
}

inline void T_ParkingInfo::setSecondaryAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SecondaryAddress();
    this->_SecondaryAddress.assign(value, size);
}

inline void T_ParkingInfo::clearCity() {
    if (hasCity()) {
         clear_has_City();
        _City.clear();
     }
}

inline bool T_ParkingInfo::hasCity () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_ParkingInfo::getCity () const {
    return _City;
}

inline ::std::string& T_ParkingInfo::getCityMutable () {
    set_has_City();
    return _City;
}

inline void T_ParkingInfo::setCity (const ::std::string& City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City = City_;
}

inline void T_ParkingInfo::setCity (const char* City_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (City_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(City_);
}

inline void T_ParkingInfo::setCity (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_City();
    this->_City.assign(value, size);
}

inline void T_ParkingInfo::clearZip() {
    if (hasZip()) {
         clear_has_Zip();
        _Zip.clear();
     }
}

inline bool T_ParkingInfo::hasZip () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_ParkingInfo::getZip () const {
    return _Zip;
}

inline ::std::string& T_ParkingInfo::getZipMutable () {
    set_has_Zip();
    return _Zip;
}

inline void T_ParkingInfo::setZip (const ::std::string& Zip_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Zip_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Zip();
    this->_Zip = Zip_;
}

inline void T_ParkingInfo::setZip (const char* Zip_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Zip_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Zip();
    this->_Zip.assign(Zip_);
}

inline void T_ParkingInfo::setZip (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Zip();
    this->_Zip.assign(value, size);
}

inline void T_ParkingInfo::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool T_ParkingInfo::hasState () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_ParkingInfo::getState () const {
    return _State;
}

inline ::std::string& T_ParkingInfo::getStateMutable () {
    set_has_State();
    return _State;
}

inline void T_ParkingInfo::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void T_ParkingInfo::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void T_ParkingInfo::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void T_ParkingInfo::clearPhone() {
    if (hasPhone()) {
         clear_has_Phone();
        _Phone.clear();
     }
}

inline bool T_ParkingInfo::hasPhone () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_ParkingInfo::getPhone () const {
    return _Phone;
}

inline ::std::string& T_ParkingInfo::getPhoneMutable () {
    set_has_Phone();
    return _Phone;
}

inline void T_ParkingInfo::setPhone (const ::std::string& Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone = Phone_;
}

inline void T_ParkingInfo::setPhone (const char* Phone_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Phone_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(Phone_);
}

inline void T_ParkingInfo::setPhone (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Phone();
    this->_Phone.assign(value, size);
}

inline void T_ParkingInfo::clearCapacity() {
    if (hasCapacity()) {
         clear_has_Capacity();
        _Capacity = 0u;
     }
}

inline bool T_ParkingInfo::hasCapacity () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_ParkingInfo::getCapacity () const {
    return _Capacity;
}

inline void T_ParkingInfo::setCapacity (uint32 Capacity_) {
    set_has_Capacity();
    this->_Capacity = Capacity_;
}

inline void T_ParkingInfo::clearDistance() {
    if (hasDistance()) {
         clear_has_Distance();
        _Distance = 0.0f;
     }
}

inline bool T_ParkingInfo::hasDistance () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline float T_ParkingInfo::getDistance () const {
    return _Distance;
}

inline void T_ParkingInfo::setDistance (float Distance_) {
    set_has_Distance();
    this->_Distance = Distance_;
}

inline void T_ParkingInfo::clearPrimaryLocation() {
    if (hasPrimaryLocation()) {
         clear_has_PrimaryLocation();
        _PrimaryLocation.clear();
     }
}

inline bool T_ParkingInfo::hasPrimaryLocation () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_ParkingInfo::getPrimaryLocation () const {
    return _PrimaryLocation;
}

inline ::fi_types::T_PositionWGS84& T_ParkingInfo::getPrimaryLocationMutable () {
    set_has_PrimaryLocation();
    return _PrimaryLocation;
}

inline void T_ParkingInfo::setPrimaryLocation (const ::fi_types::T_PositionWGS84& PrimaryLocation_) {
    set_has_PrimaryLocation();
    this->_PrimaryLocation = PrimaryLocation_;
}

inline void T_ParkingInfo::clearSecondaryLocation() {
    if (hasSecondaryLocation()) {
         clear_has_SecondaryLocation();
        _SecondaryLocation.clear();
     }
}

inline bool T_ParkingInfo::hasSecondaryLocation () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::fi_types::T_PositionWGS84& T_ParkingInfo::getSecondaryLocation () const {
    return _SecondaryLocation;
}

inline ::fi_types::T_PositionWGS84& T_ParkingInfo::getSecondaryLocationMutable () {
    set_has_SecondaryLocation();
    return _SecondaryLocation;
}

inline void T_ParkingInfo::setSecondaryLocation (const ::fi_types::T_PositionWGS84& SecondaryLocation_) {
    set_has_SecondaryLocation();
    this->_SecondaryLocation = SecondaryLocation_;
}

inline void T_ParkingInfo::clearPrimaryHeight() {
    if (hasPrimaryHeight()) {
         clear_has_PrimaryHeight();
        _PrimaryHeight = 0u;
     }
}

inline bool T_ParkingInfo::hasPrimaryHeight () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_ParkingInfo::getPrimaryHeight () const {
    return _PrimaryHeight;
}

inline void T_ParkingInfo::setPrimaryHeight (uint32 PrimaryHeight_) {
    set_has_PrimaryHeight();
    this->_PrimaryHeight = PrimaryHeight_;
}

inline void T_ParkingInfo::clearSecondaryHeight() {
    if (hasSecondaryHeight()) {
         clear_has_SecondaryHeight();
        _SecondaryHeight = 0u;
     }
}

inline bool T_ParkingInfo::hasSecondaryHeight () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_ParkingInfo::getSecondaryHeight () const {
    return _SecondaryHeight;
}

inline void T_ParkingInfo::setSecondaryHeight (uint32 SecondaryHeight_) {
    set_has_SecondaryHeight();
    this->_SecondaryHeight = SecondaryHeight_;
}

inline void T_ParkingInfo::clearAvailableTime() {
    if (hasAvailableTime()) {
         clear_has_AvailableTime();
        _AvailableTime = 0u;
     }
}

inline bool T_ParkingInfo::hasAvailableTime () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint32 T_ParkingInfo::getAvailableTime () const {
    return _AvailableTime;
}

inline void T_ParkingInfo::setAvailableTime (uint32 AvailableTime_) {
    set_has_AvailableTime();
    this->_AvailableTime = AvailableTime_;
}

inline void T_ParkingInfo::clearRelativePricingHourly() {
    if (hasRelativePricingHourly()) {
         clear_has_RelativePricingHourly();
        _RelativePricingHourly = 0u;
     }
}

inline bool T_ParkingInfo::hasRelativePricingHourly () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_ParkingInfo::getRelativePricingHourly () const {
    return _RelativePricingHourly;
}

inline void T_ParkingInfo::setRelativePricingHourly (uint8 RelativePricingHourly_) {
    set_has_RelativePricingHourly();
    this->_RelativePricingHourly = RelativePricingHourly_;
}

inline void T_ParkingInfo::clearRelativePricingDaily() {
    if (hasRelativePricingDaily()) {
         clear_has_RelativePricingDaily();
        _RelativePricingDaily = 0u;
     }
}

inline bool T_ParkingInfo::hasRelativePricingDaily () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_ParkingInfo::getRelativePricingDaily () const {
    return _RelativePricingDaily;
}

inline void T_ParkingInfo::setRelativePricingDaily (uint8 RelativePricingDaily_) {
    set_has_RelativePricingDaily();
    this->_RelativePricingDaily = RelativePricingDaily_;
}

inline void T_ParkingInfo::clearOpenStatus() {
    if (hasOpenStatus()) {
         clear_has_OpenStatus();
        _OpenStatus = ::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN;
     }
}

inline bool T_ParkingInfo::hasOpenStatus () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline T_e8OpenStatus T_ParkingInfo::getOpenStatus () const {
    return _OpenStatus;
}

inline void T_ParkingInfo::setOpenStatus (T_e8OpenStatus OpenStatus_) {
    #ifndef NDEBUG
    if (!(T_e8OpenStatus_IsValid(OpenStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OpenStatus_, "T_e8OpenStatus", "OpenStatus", "T_ParkingInfo");
    }
    #endif
    set_has_OpenStatus();
    this->_OpenStatus = OpenStatus_;
}

inline void T_ParkingInfo::clearOpeningTimes() {
    if (hasOpeningTimes()) {
         clear_has_OpeningTimes();
        _OpeningTimes.clear();
     }
}

inline bool T_ParkingInfo::hasOpeningTimes () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline const ::std::vector< T_OpeningTime >& T_ParkingInfo::getOpeningTimes () const {
    return _OpeningTimes;
}

inline ::std::vector< T_OpeningTime >& T_ParkingInfo::getOpeningTimesMutable () {
    set_has_OpeningTimes();
    return _OpeningTimes;
}

inline void T_ParkingInfo::setOpeningTimes (const ::std::vector< T_OpeningTime >& OpeningTimes_) {
    set_has_OpeningTimes();
    this->_OpeningTimes = OpeningTimes_;
}

inline void T_ParkingInfo::clearFullness() {
    if (hasFullness()) {
         clear_has_Fullness();
        _Fullness.clear();
     }
}

inline bool T_ParkingInfo::hasFullness () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::vector< T_Fullness >& T_ParkingInfo::getFullness () const {
    return _Fullness;
}

inline ::std::vector< T_Fullness >& T_ParkingInfo::getFullnessMutable () {
    set_has_Fullness();
    return _Fullness;
}

inline void T_ParkingInfo::setFullness (const ::std::vector< T_Fullness >& Fullness_) {
    set_has_Fullness();
    this->_Fullness = Fullness_;
}

inline void T_ParkingInfo::clearAmenities() {
    if (hasAmenities()) {
         clear_has_Amenities();
        _Amenities.clear();
     }
}

inline bool T_ParkingInfo::hasAmenities () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline const T_AmenityInfo& T_ParkingInfo::getAmenities () const {
    return _Amenities;
}

inline T_AmenityInfo& T_ParkingInfo::getAmenitiesMutable () {
    set_has_Amenities();
    return _Amenities;
}

inline void T_ParkingInfo::setAmenities (const T_AmenityInfo& Amenities_) {
    set_has_Amenities();
    this->_Amenities = Amenities_;
}

inline void T_ParkingInfo::clearPricingInfo() {
    if (hasPricingInfo()) {
         clear_has_PricingInfo();
        _PricingInfo.clear();
     }
}

inline bool T_ParkingInfo::hasPricingInfo () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline const T_PriceInfo& T_ParkingInfo::getPricingInfo () const {
    return _PricingInfo;
}

inline T_PriceInfo& T_ParkingInfo::getPricingInfoMutable () {
    set_has_PricingInfo();
    return _PricingInfo;
}

inline void T_ParkingInfo::setPricingInfo (const T_PriceInfo& PricingInfo_) {
    set_has_PricingInfo();
    this->_PricingInfo = PricingInfo_;
}

inline void T_ParkingInfo::clearIsFavorite() {
    if (hasIsFavorite()) {
         clear_has_IsFavorite();
        _IsFavorite = false;
     }
}

inline bool T_ParkingInfo::hasIsFavorite () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline bool T_ParkingInfo::getIsFavorite () const {
    return _IsFavorite;
}

inline void T_ParkingInfo::setIsFavorite (bool IsFavorite_) {
    set_has_IsFavorite();
    this->_IsFavorite = IsFavorite_;
}

inline void T_ParkingInfo::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ParkingInfo::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ParkingInfo::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ParkingInfo::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ParkingInfo::set_has_Address () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ParkingInfo::clear_has_Address () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ParkingInfo::set_has_SecondaryAddress () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ParkingInfo::clear_has_SecondaryAddress () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ParkingInfo::set_has_City () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ParkingInfo::clear_has_City () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ParkingInfo::set_has_Zip () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ParkingInfo::clear_has_Zip () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_ParkingInfo::set_has_State () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_ParkingInfo::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_ParkingInfo::set_has_Phone () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_ParkingInfo::clear_has_Phone () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_ParkingInfo::set_has_Capacity () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_ParkingInfo::clear_has_Capacity () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_ParkingInfo::set_has_Distance () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_ParkingInfo::clear_has_Distance () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_ParkingInfo::set_has_PrimaryLocation () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_ParkingInfo::clear_has_PrimaryLocation () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_ParkingInfo::set_has_SecondaryLocation () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_ParkingInfo::clear_has_SecondaryLocation () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_ParkingInfo::set_has_PrimaryHeight () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_ParkingInfo::clear_has_PrimaryHeight () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_ParkingInfo::set_has_SecondaryHeight () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_ParkingInfo::clear_has_SecondaryHeight () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_ParkingInfo::set_has_AvailableTime () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_ParkingInfo::clear_has_AvailableTime () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_ParkingInfo::set_has_RelativePricingHourly () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_ParkingInfo::clear_has_RelativePricingHourly () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_ParkingInfo::set_has_RelativePricingDaily () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_ParkingInfo::clear_has_RelativePricingDaily () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_ParkingInfo::set_has_OpenStatus () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_ParkingInfo::clear_has_OpenStatus () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_ParkingInfo::set_has_OpeningTimes () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_ParkingInfo::clear_has_OpeningTimes () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_ParkingInfo::set_has_Fullness () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_ParkingInfo::clear_has_Fullness () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_ParkingInfo::set_has_Amenities () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_ParkingInfo::clear_has_Amenities () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_ParkingInfo::set_has_PricingInfo () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_ParkingInfo::clear_has_PricingInfo () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_ParkingInfo::set_has_IsFavorite () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_ParkingInfo::clear_has_IsFavorite () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline  T_FilterConfig::T_FilterConfig ()  :
    _Amenities (),
    _ClosedLocations (::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN),
    _EntranceHeight (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FilterConfig::T_FilterConfig (const T_FilterConfig &rhs)  :
    _Amenities (),
    _ClosedLocations (::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN),
    _EntranceHeight (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FilterConfig::T_FilterConfig (const T_AmenityInfo& Amenities_, T_e8OpenStatus ClosedLocations_, uint32 EntranceHeight_)  :
    _Amenities (Amenities_),
    _ClosedLocations (ClosedLocations_),
    _EntranceHeight (EntranceHeight_)
{
    #ifndef NDEBUG
    if (!(T_e8OpenStatus_IsValid(ClosedLocations_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ClosedLocations_, "T_e8OpenStatus", "ClosedLocations", "T_FilterConfig");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FilterConfig::~T_FilterConfig() {
}

inline T_FilterConfig& T_FilterConfig::operator = (const T_FilterConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAmenities()) {
            setAmenities(rhs.getAmenities());
        } else {
            clearAmenities();
        }
        if (rhs.hasClosedLocations()) {
            setClosedLocations(rhs.getClosedLocations());
        } else {
            clearClosedLocations();
        }
        if (rhs.hasEntranceHeight()) {
            setEntranceHeight(rhs.getEntranceHeight());
        } else {
            clearEntranceHeight();
        }
    }
    return *this;
}

inline bool T_FilterConfig::operator == (const T_FilterConfig& rhs) const {
    return (((!hasAmenities() && !rhs.hasAmenities()) || getAmenities() == rhs.getAmenities()) &&
        ((!hasClosedLocations() && !rhs.hasClosedLocations()) || getClosedLocations() == rhs.getClosedLocations()) &&
        ((!hasEntranceHeight() && !rhs.hasEntranceHeight()) || getEntranceHeight() == rhs.getEntranceHeight()));
}

inline bool T_FilterConfig::operator != (const T_FilterConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FilterConfig::operator < (const T_FilterConfig& rhs) const {
    if (hasAmenities() || rhs.hasAmenities()) {
        if (getAmenities() < rhs.getAmenities()) return true;
        if (getAmenities() > rhs.getAmenities()) return false;
    }
    if (hasClosedLocations() || rhs.hasClosedLocations()) {
        if ((uint32)getClosedLocations() < (uint32)rhs.getClosedLocations()) return true;
        if ((uint32)getClosedLocations() > (uint32)rhs.getClosedLocations()) return false;
    }
    if (hasEntranceHeight() || rhs.hasEntranceHeight()) {
        if (getEntranceHeight() < rhs.getEntranceHeight()) return true;
        if (getEntranceHeight() > rhs.getEntranceHeight()) return false;
    }
    return false;
}

inline bool T_FilterConfig::operator > (const T_FilterConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FilterConfig::clear() {
    clearAmenities();
    clearClosedLocations();
    clearEntranceHeight();
}

inline void T_FilterConfig::clearAmenities() {
    if (hasAmenities()) {
         clear_has_Amenities();
        _Amenities.clear();
     }
}

inline bool T_FilterConfig::hasAmenities () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_AmenityInfo& T_FilterConfig::getAmenities () const {
    return _Amenities;
}

inline T_AmenityInfo& T_FilterConfig::getAmenitiesMutable () {
    set_has_Amenities();
    return _Amenities;
}

inline void T_FilterConfig::setAmenities (const T_AmenityInfo& Amenities_) {
    set_has_Amenities();
    this->_Amenities = Amenities_;
}

inline void T_FilterConfig::clearClosedLocations() {
    if (hasClosedLocations()) {
         clear_has_ClosedLocations();
        _ClosedLocations = ::sxm_parking_main_fi_types::T_e8OpenStatus__PARKING_STATUS_OPEN;
     }
}

inline bool T_FilterConfig::hasClosedLocations () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8OpenStatus T_FilterConfig::getClosedLocations () const {
    return _ClosedLocations;
}

inline void T_FilterConfig::setClosedLocations (T_e8OpenStatus ClosedLocations_) {
    #ifndef NDEBUG
    if (!(T_e8OpenStatus_IsValid(ClosedLocations_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ClosedLocations_, "T_e8OpenStatus", "ClosedLocations", "T_FilterConfig");
    }
    #endif
    set_has_ClosedLocations();
    this->_ClosedLocations = ClosedLocations_;
}

inline void T_FilterConfig::clearEntranceHeight() {
    if (hasEntranceHeight()) {
         clear_has_EntranceHeight();
        _EntranceHeight = 0u;
     }
}

inline bool T_FilterConfig::hasEntranceHeight () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_FilterConfig::getEntranceHeight () const {
    return _EntranceHeight;
}

inline void T_FilterConfig::setEntranceHeight (uint32 EntranceHeight_) {
    set_has_EntranceHeight();
    this->_EntranceHeight = EntranceHeight_;
}

inline void T_FilterConfig::set_has_Amenities () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FilterConfig::clear_has_Amenities () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FilterConfig::set_has_ClosedLocations () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FilterConfig::clear_has_ClosedLocations () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FilterConfig::set_has_EntranceHeight () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FilterConfig::clear_has_EntranceHeight () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AmenityConfig::T_AmenityConfig ()  :
    _Open24Hours (),
    _Cash (),
    _Card (),
    _ParkingType (),
    _MetroLocation (),
    _AirPort (),
    _OvernightParking (),
    _Reservations (),
    _SelfParking (),
    _Security (),
    _TollTag (),
    _SUVCharges (),
    _RV ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AmenityConfig::T_AmenityConfig (const T_AmenityConfig &rhs)  :
    _Open24Hours (),
    _Cash (),
    _Card (),
    _ParkingType (),
    _MetroLocation (),
    _AirPort (),
    _OvernightParking (),
    _Reservations (),
    _SelfParking (),
    _Security (),
    _TollTag (),
    _SUVCharges (),
    _RV ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AmenityConfig::T_AmenityConfig (const ::std::vector< T_e8Open24Hours >& Open24Hours_, const ::std::vector< T_e8CashOrCard >& Cash_, const ::std::vector< T_e8CashOrCard >& Card_, const ::std::vector< T_e8ParkingType >& ParkingType_, const ::std::vector< T_e8MetroLocation >& MetroLocation_, const ::std::vector< T_e8AirPort >& AirPort_, const ::std::vector< T_e8OvernightParking >& OvernightParking_, const ::std::vector< T_e8Reservations >& Reservations_, const ::std::vector< T_e8SelfParking >& SelfParking_, const ::std::vector< T_e8Security >& Security_, const ::std::vector< T_e8TollTag >& TollTag_, const ::std::vector< T_e8SUVCharges >& SUVCharges_, const ::std::vector< T_e8RV >& RV_)  :
    _Open24Hours (Open24Hours_),
    _Cash (Cash_),
    _Card (Card_),
    _ParkingType (ParkingType_),
    _MetroLocation (MetroLocation_),
    _AirPort (AirPort_),
    _OvernightParking (OvernightParking_),
    _Reservations (Reservations_),
    _SelfParking (SelfParking_),
    _Security (Security_),
    _TollTag (TollTag_),
    _SUVCharges (SUVCharges_),
    _RV (RV_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AmenityConfig::~T_AmenityConfig() {
}

inline T_AmenityConfig& T_AmenityConfig::operator = (const T_AmenityConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOpen24Hours()) {
            setOpen24Hours(rhs.getOpen24Hours());
        } else {
            clearOpen24Hours();
        }
        if (rhs.hasCash()) {
            setCash(rhs.getCash());
        } else {
            clearCash();
        }
        if (rhs.hasCard()) {
            setCard(rhs.getCard());
        } else {
            clearCard();
        }
        if (rhs.hasParkingType()) {
            setParkingType(rhs.getParkingType());
        } else {
            clearParkingType();
        }
        if (rhs.hasMetroLocation()) {
            setMetroLocation(rhs.getMetroLocation());
        } else {
            clearMetroLocation();
        }
        if (rhs.hasAirPort()) {
            setAirPort(rhs.getAirPort());
        } else {
            clearAirPort();
        }
        if (rhs.hasOvernightParking()) {
            setOvernightParking(rhs.getOvernightParking());
        } else {
            clearOvernightParking();
        }
        if (rhs.hasReservations()) {
            setReservations(rhs.getReservations());
        } else {
            clearReservations();
        }
        if (rhs.hasSelfParking()) {
            setSelfParking(rhs.getSelfParking());
        } else {
            clearSelfParking();
        }
        if (rhs.hasSecurity()) {
            setSecurity(rhs.getSecurity());
        } else {
            clearSecurity();
        }
        if (rhs.hasTollTag()) {
            setTollTag(rhs.getTollTag());
        } else {
            clearTollTag();
        }
        if (rhs.hasSUVCharges()) {
            setSUVCharges(rhs.getSUVCharges());
        } else {
            clearSUVCharges();
        }
        if (rhs.hasRV()) {
            setRV(rhs.getRV());
        } else {
            clearRV();
        }
    }
    return *this;
}

inline bool T_AmenityConfig::operator == (const T_AmenityConfig& rhs) const {
    return (((!hasOpen24Hours() && !rhs.hasOpen24Hours()) || getOpen24Hours() == rhs.getOpen24Hours()) &&
        ((!hasCash() && !rhs.hasCash()) || getCash() == rhs.getCash()) &&
        ((!hasCard() && !rhs.hasCard()) || getCard() == rhs.getCard()) &&
        ((!hasParkingType() && !rhs.hasParkingType()) || getParkingType() == rhs.getParkingType()) &&
        ((!hasMetroLocation() && !rhs.hasMetroLocation()) || getMetroLocation() == rhs.getMetroLocation()) &&
        ((!hasAirPort() && !rhs.hasAirPort()) || getAirPort() == rhs.getAirPort()) &&
        ((!hasOvernightParking() && !rhs.hasOvernightParking()) || getOvernightParking() == rhs.getOvernightParking()) &&
        ((!hasReservations() && !rhs.hasReservations()) || getReservations() == rhs.getReservations()) &&
        ((!hasSelfParking() && !rhs.hasSelfParking()) || getSelfParking() == rhs.getSelfParking()) &&
        ((!hasSecurity() && !rhs.hasSecurity()) || getSecurity() == rhs.getSecurity()) &&
        ((!hasTollTag() && !rhs.hasTollTag()) || getTollTag() == rhs.getTollTag()) &&
        ((!hasSUVCharges() && !rhs.hasSUVCharges()) || getSUVCharges() == rhs.getSUVCharges()) &&
        ((!hasRV() && !rhs.hasRV()) || getRV() == rhs.getRV()));
}

inline bool T_AmenityConfig::operator != (const T_AmenityConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AmenityConfig::operator < (const T_AmenityConfig& rhs) const {
    if (hasOpen24Hours() || rhs.hasOpen24Hours()) {
        if (getOpen24Hours() < rhs.getOpen24Hours()) return true;
        if (getOpen24Hours() > rhs.getOpen24Hours()) return false;
    }
    if (hasCash() || rhs.hasCash()) {
        if (getCash() < rhs.getCash()) return true;
        if (getCash() > rhs.getCash()) return false;
    }
    if (hasCard() || rhs.hasCard()) {
        if (getCard() < rhs.getCard()) return true;
        if (getCard() > rhs.getCard()) return false;
    }
    if (hasParkingType() || rhs.hasParkingType()) {
        if (getParkingType() < rhs.getParkingType()) return true;
        if (getParkingType() > rhs.getParkingType()) return false;
    }
    if (hasMetroLocation() || rhs.hasMetroLocation()) {
        if (getMetroLocation() < rhs.getMetroLocation()) return true;
        if (getMetroLocation() > rhs.getMetroLocation()) return false;
    }
    if (hasAirPort() || rhs.hasAirPort()) {
        if (getAirPort() < rhs.getAirPort()) return true;
        if (getAirPort() > rhs.getAirPort()) return false;
    }
    if (hasOvernightParking() || rhs.hasOvernightParking()) {
        if (getOvernightParking() < rhs.getOvernightParking()) return true;
        if (getOvernightParking() > rhs.getOvernightParking()) return false;
    }
    if (hasReservations() || rhs.hasReservations()) {
        if (getReservations() < rhs.getReservations()) return true;
        if (getReservations() > rhs.getReservations()) return false;
    }
    if (hasSelfParking() || rhs.hasSelfParking()) {
        if (getSelfParking() < rhs.getSelfParking()) return true;
        if (getSelfParking() > rhs.getSelfParking()) return false;
    }
    if (hasSecurity() || rhs.hasSecurity()) {
        if (getSecurity() < rhs.getSecurity()) return true;
        if (getSecurity() > rhs.getSecurity()) return false;
    }
    if (hasTollTag() || rhs.hasTollTag()) {
        if (getTollTag() < rhs.getTollTag()) return true;
        if (getTollTag() > rhs.getTollTag()) return false;
    }
    if (hasSUVCharges() || rhs.hasSUVCharges()) {
        if (getSUVCharges() < rhs.getSUVCharges()) return true;
        if (getSUVCharges() > rhs.getSUVCharges()) return false;
    }
    if (hasRV() || rhs.hasRV()) {
        if (getRV() < rhs.getRV()) return true;
        if (getRV() > rhs.getRV()) return false;
    }
    return false;
}

inline bool T_AmenityConfig::operator > (const T_AmenityConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AmenityConfig::clear() {
    clearOpen24Hours();
    clearCash();
    clearCard();
    clearParkingType();
    clearMetroLocation();
    clearAirPort();
    clearOvernightParking();
    clearReservations();
    clearSelfParking();
    clearSecurity();
    clearTollTag();
    clearSUVCharges();
    clearRV();
}

inline void T_AmenityConfig::clearOpen24Hours() {
    if (hasOpen24Hours()) {
         clear_has_Open24Hours();
        _Open24Hours.clear();
     }
}

inline bool T_AmenityConfig::hasOpen24Hours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< T_e8Open24Hours >& T_AmenityConfig::getOpen24Hours () const {
    return _Open24Hours;
}

inline ::std::vector< T_e8Open24Hours >& T_AmenityConfig::getOpen24HoursMutable () {
    set_has_Open24Hours();
    return _Open24Hours;
}

inline void T_AmenityConfig::setOpen24Hours (const ::std::vector< T_e8Open24Hours >& Open24Hours_) {
    set_has_Open24Hours();
    this->_Open24Hours = Open24Hours_;
}

inline void T_AmenityConfig::clearCash() {
    if (hasCash()) {
         clear_has_Cash();
        _Cash.clear();
     }
}

inline bool T_AmenityConfig::hasCash () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_e8CashOrCard >& T_AmenityConfig::getCash () const {
    return _Cash;
}

inline ::std::vector< T_e8CashOrCard >& T_AmenityConfig::getCashMutable () {
    set_has_Cash();
    return _Cash;
}

inline void T_AmenityConfig::setCash (const ::std::vector< T_e8CashOrCard >& Cash_) {
    set_has_Cash();
    this->_Cash = Cash_;
}

inline void T_AmenityConfig::clearCard() {
    if (hasCard()) {
         clear_has_Card();
        _Card.clear();
     }
}

inline bool T_AmenityConfig::hasCard () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_e8CashOrCard >& T_AmenityConfig::getCard () const {
    return _Card;
}

inline ::std::vector< T_e8CashOrCard >& T_AmenityConfig::getCardMutable () {
    set_has_Card();
    return _Card;
}

inline void T_AmenityConfig::setCard (const ::std::vector< T_e8CashOrCard >& Card_) {
    set_has_Card();
    this->_Card = Card_;
}

inline void T_AmenityConfig::clearParkingType() {
    if (hasParkingType()) {
         clear_has_ParkingType();
        _ParkingType.clear();
     }
}

inline bool T_AmenityConfig::hasParkingType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_e8ParkingType >& T_AmenityConfig::getParkingType () const {
    return _ParkingType;
}

inline ::std::vector< T_e8ParkingType >& T_AmenityConfig::getParkingTypeMutable () {
    set_has_ParkingType();
    return _ParkingType;
}

inline void T_AmenityConfig::setParkingType (const ::std::vector< T_e8ParkingType >& ParkingType_) {
    set_has_ParkingType();
    this->_ParkingType = ParkingType_;
}

inline void T_AmenityConfig::clearMetroLocation() {
    if (hasMetroLocation()) {
         clear_has_MetroLocation();
        _MetroLocation.clear();
     }
}

inline bool T_AmenityConfig::hasMetroLocation () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::vector< T_e8MetroLocation >& T_AmenityConfig::getMetroLocation () const {
    return _MetroLocation;
}

inline ::std::vector< T_e8MetroLocation >& T_AmenityConfig::getMetroLocationMutable () {
    set_has_MetroLocation();
    return _MetroLocation;
}

inline void T_AmenityConfig::setMetroLocation (const ::std::vector< T_e8MetroLocation >& MetroLocation_) {
    set_has_MetroLocation();
    this->_MetroLocation = MetroLocation_;
}

inline void T_AmenityConfig::clearAirPort() {
    if (hasAirPort()) {
         clear_has_AirPort();
        _AirPort.clear();
     }
}

inline bool T_AmenityConfig::hasAirPort () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< T_e8AirPort >& T_AmenityConfig::getAirPort () const {
    return _AirPort;
}

inline ::std::vector< T_e8AirPort >& T_AmenityConfig::getAirPortMutable () {
    set_has_AirPort();
    return _AirPort;
}

inline void T_AmenityConfig::setAirPort (const ::std::vector< T_e8AirPort >& AirPort_) {
    set_has_AirPort();
    this->_AirPort = AirPort_;
}

inline void T_AmenityConfig::clearOvernightParking() {
    if (hasOvernightParking()) {
         clear_has_OvernightParking();
        _OvernightParking.clear();
     }
}

inline bool T_AmenityConfig::hasOvernightParking () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::vector< T_e8OvernightParking >& T_AmenityConfig::getOvernightParking () const {
    return _OvernightParking;
}

inline ::std::vector< T_e8OvernightParking >& T_AmenityConfig::getOvernightParkingMutable () {
    set_has_OvernightParking();
    return _OvernightParking;
}

inline void T_AmenityConfig::setOvernightParking (const ::std::vector< T_e8OvernightParking >& OvernightParking_) {
    set_has_OvernightParking();
    this->_OvernightParking = OvernightParking_;
}

inline void T_AmenityConfig::clearReservations() {
    if (hasReservations()) {
         clear_has_Reservations();
        _Reservations.clear();
     }
}

inline bool T_AmenityConfig::hasReservations () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::vector< T_e8Reservations >& T_AmenityConfig::getReservations () const {
    return _Reservations;
}

inline ::std::vector< T_e8Reservations >& T_AmenityConfig::getReservationsMutable () {
    set_has_Reservations();
    return _Reservations;
}

inline void T_AmenityConfig::setReservations (const ::std::vector< T_e8Reservations >& Reservations_) {
    set_has_Reservations();
    this->_Reservations = Reservations_;
}

inline void T_AmenityConfig::clearSelfParking() {
    if (hasSelfParking()) {
         clear_has_SelfParking();
        _SelfParking.clear();
     }
}

inline bool T_AmenityConfig::hasSelfParking () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::vector< T_e8SelfParking >& T_AmenityConfig::getSelfParking () const {
    return _SelfParking;
}

inline ::std::vector< T_e8SelfParking >& T_AmenityConfig::getSelfParkingMutable () {
    set_has_SelfParking();
    return _SelfParking;
}

inline void T_AmenityConfig::setSelfParking (const ::std::vector< T_e8SelfParking >& SelfParking_) {
    set_has_SelfParking();
    this->_SelfParking = SelfParking_;
}

inline void T_AmenityConfig::clearSecurity() {
    if (hasSecurity()) {
         clear_has_Security();
        _Security.clear();
     }
}

inline bool T_AmenityConfig::hasSecurity () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::vector< T_e8Security >& T_AmenityConfig::getSecurity () const {
    return _Security;
}

inline ::std::vector< T_e8Security >& T_AmenityConfig::getSecurityMutable () {
    set_has_Security();
    return _Security;
}

inline void T_AmenityConfig::setSecurity (const ::std::vector< T_e8Security >& Security_) {
    set_has_Security();
    this->_Security = Security_;
}

inline void T_AmenityConfig::clearTollTag() {
    if (hasTollTag()) {
         clear_has_TollTag();
        _TollTag.clear();
     }
}

inline bool T_AmenityConfig::hasTollTag () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::vector< T_e8TollTag >& T_AmenityConfig::getTollTag () const {
    return _TollTag;
}

inline ::std::vector< T_e8TollTag >& T_AmenityConfig::getTollTagMutable () {
    set_has_TollTag();
    return _TollTag;
}

inline void T_AmenityConfig::setTollTag (const ::std::vector< T_e8TollTag >& TollTag_) {
    set_has_TollTag();
    this->_TollTag = TollTag_;
}

inline void T_AmenityConfig::clearSUVCharges() {
    if (hasSUVCharges()) {
         clear_has_SUVCharges();
        _SUVCharges.clear();
     }
}

inline bool T_AmenityConfig::hasSUVCharges () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::vector< T_e8SUVCharges >& T_AmenityConfig::getSUVCharges () const {
    return _SUVCharges;
}

inline ::std::vector< T_e8SUVCharges >& T_AmenityConfig::getSUVChargesMutable () {
    set_has_SUVCharges();
    return _SUVCharges;
}

inline void T_AmenityConfig::setSUVCharges (const ::std::vector< T_e8SUVCharges >& SUVCharges_) {
    set_has_SUVCharges();
    this->_SUVCharges = SUVCharges_;
}

inline void T_AmenityConfig::clearRV() {
    if (hasRV()) {
         clear_has_RV();
        _RV.clear();
     }
}

inline bool T_AmenityConfig::hasRV () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::std::vector< T_e8RV >& T_AmenityConfig::getRV () const {
    return _RV;
}

inline ::std::vector< T_e8RV >& T_AmenityConfig::getRVMutable () {
    set_has_RV();
    return _RV;
}

inline void T_AmenityConfig::setRV (const ::std::vector< T_e8RV >& RV_) {
    set_has_RV();
    this->_RV = RV_;
}

inline void T_AmenityConfig::set_has_Open24Hours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AmenityConfig::clear_has_Open24Hours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AmenityConfig::set_has_Cash () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AmenityConfig::clear_has_Cash () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AmenityConfig::set_has_Card () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AmenityConfig::clear_has_Card () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AmenityConfig::set_has_ParkingType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AmenityConfig::clear_has_ParkingType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_AmenityConfig::set_has_MetroLocation () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_AmenityConfig::clear_has_MetroLocation () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_AmenityConfig::set_has_AirPort () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_AmenityConfig::clear_has_AirPort () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_AmenityConfig::set_has_OvernightParking () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_AmenityConfig::clear_has_OvernightParking () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_AmenityConfig::set_has_Reservations () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_AmenityConfig::clear_has_Reservations () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_AmenityConfig::set_has_SelfParking () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_AmenityConfig::clear_has_SelfParking () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_AmenityConfig::set_has_Security () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_AmenityConfig::clear_has_Security () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_AmenityConfig::set_has_TollTag () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_AmenityConfig::clear_has_TollTag () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_AmenityConfig::set_has_SUVCharges () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_AmenityConfig::clear_has_SUVCharges () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_AmenityConfig::set_has_RV () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_AmenityConfig::clear_has_RV () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  T_FilterConfiguration::T_FilterConfiguration ()  :
    _Amenities (),
    _ClosedLocations (),
    _EntranceHeight (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FilterConfiguration::T_FilterConfiguration (const T_FilterConfiguration &rhs)  :
    _Amenities (),
    _ClosedLocations (),
    _EntranceHeight (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FilterConfiguration::T_FilterConfiguration (const T_AmenityConfig& Amenities_, const ::std::vector< T_e8OpenStatus >& ClosedLocations_, uint32 EntranceHeight_)  :
    _Amenities (Amenities_),
    _ClosedLocations (ClosedLocations_),
    _EntranceHeight (EntranceHeight_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FilterConfiguration::~T_FilterConfiguration() {
}

inline T_FilterConfiguration& T_FilterConfiguration::operator = (const T_FilterConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAmenities()) {
            setAmenities(rhs.getAmenities());
        } else {
            clearAmenities();
        }
        if (rhs.hasClosedLocations()) {
            setClosedLocations(rhs.getClosedLocations());
        } else {
            clearClosedLocations();
        }
        if (rhs.hasEntranceHeight()) {
            setEntranceHeight(rhs.getEntranceHeight());
        } else {
            clearEntranceHeight();
        }
    }
    return *this;
}

inline bool T_FilterConfiguration::operator == (const T_FilterConfiguration& rhs) const {
    return (((!hasAmenities() && !rhs.hasAmenities()) || getAmenities() == rhs.getAmenities()) &&
        ((!hasClosedLocations() && !rhs.hasClosedLocations()) || getClosedLocations() == rhs.getClosedLocations()) &&
        ((!hasEntranceHeight() && !rhs.hasEntranceHeight()) || getEntranceHeight() == rhs.getEntranceHeight()));
}

inline bool T_FilterConfiguration::operator != (const T_FilterConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FilterConfiguration::operator < (const T_FilterConfiguration& rhs) const {
    if (hasAmenities() || rhs.hasAmenities()) {
        if (getAmenities() < rhs.getAmenities()) return true;
        if (getAmenities() > rhs.getAmenities()) return false;
    }
    if (hasClosedLocations() || rhs.hasClosedLocations()) {
        if (getClosedLocations() < rhs.getClosedLocations()) return true;
        if (getClosedLocations() > rhs.getClosedLocations()) return false;
    }
    if (hasEntranceHeight() || rhs.hasEntranceHeight()) {
        if (getEntranceHeight() < rhs.getEntranceHeight()) return true;
        if (getEntranceHeight() > rhs.getEntranceHeight()) return false;
    }
    return false;
}

inline bool T_FilterConfiguration::operator > (const T_FilterConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FilterConfiguration::clear() {
    clearAmenities();
    clearClosedLocations();
    clearEntranceHeight();
}

inline void T_FilterConfiguration::clearAmenities() {
    if (hasAmenities()) {
         clear_has_Amenities();
        _Amenities.clear();
     }
}

inline bool T_FilterConfiguration::hasAmenities () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_AmenityConfig& T_FilterConfiguration::getAmenities () const {
    return _Amenities;
}

inline T_AmenityConfig& T_FilterConfiguration::getAmenitiesMutable () {
    set_has_Amenities();
    return _Amenities;
}

inline void T_FilterConfiguration::setAmenities (const T_AmenityConfig& Amenities_) {
    set_has_Amenities();
    this->_Amenities = Amenities_;
}

inline void T_FilterConfiguration::clearClosedLocations() {
    if (hasClosedLocations()) {
         clear_has_ClosedLocations();
        _ClosedLocations.clear();
     }
}

inline bool T_FilterConfiguration::hasClosedLocations () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_e8OpenStatus >& T_FilterConfiguration::getClosedLocations () const {
    return _ClosedLocations;
}

inline ::std::vector< T_e8OpenStatus >& T_FilterConfiguration::getClosedLocationsMutable () {
    set_has_ClosedLocations();
    return _ClosedLocations;
}

inline void T_FilterConfiguration::setClosedLocations (const ::std::vector< T_e8OpenStatus >& ClosedLocations_) {
    set_has_ClosedLocations();
    this->_ClosedLocations = ClosedLocations_;
}

inline void T_FilterConfiguration::clearEntranceHeight() {
    if (hasEntranceHeight()) {
         clear_has_EntranceHeight();
        _EntranceHeight = 0u;
     }
}

inline bool T_FilterConfiguration::hasEntranceHeight () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_FilterConfiguration::getEntranceHeight () const {
    return _EntranceHeight;
}

inline void T_FilterConfiguration::setEntranceHeight (uint32 EntranceHeight_) {
    set_has_EntranceHeight();
    this->_EntranceHeight = EntranceHeight_;
}

inline void T_FilterConfiguration::set_has_Amenities () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FilterConfiguration::clear_has_Amenities () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FilterConfiguration::set_has_ClosedLocations () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FilterConfiguration::clear_has_ClosedLocations () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FilterConfiguration::set_has_EntranceHeight () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FilterConfiguration::clear_has_EntranceHeight () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace sxm_parking_main_fi_types

#endif // SXM_PARKING_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
