/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types fi_types
 */

using namespace ::asf::stream::json;

namespace fi_types {

bool T_e8_DST_State_Parse (const char *str, size_t length, T_e8_DST_State &value)
{
    static stringEntry entries[] = {
        {14,"T_STANDARDTIME", 0U},
        {20,"T_DAYLIGHTSAVINGTIME", 1U},
        {21,"T_EVALUATIONNECESSARY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DST_State_Name (T_e8_DST_State value)
{
    static const char* enumerationLiterals[] = {
        "T_StandardTime",
        "T_DaylightSavingTime",
        "T_EvaluationNecessary",
    };

    if (T_e8_DST_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DST_State_IsValid (T_e8_DST_State value)
{
    switch (value) {
    case T_e8_DST_State__T_StandardTime:
    case T_e8_DST_State__T_DaylightSavingTime:
    case T_e8_DST_State__T_EvaluationNecessary:
        return true;
    default:
        return false;
    }
}

bool T_e16_ISOCountryCode_Parse (const char *str, size_t length, T_e16_ISOCountryCode &value)
{
    static stringEntry entries[] = {
        {15,"ISO_ALPHA_3_ABW", 1111U},
        {15,"ISO_ALPHA_3_AFG", 1223U},
        {15,"ISO_ALPHA_3_AGO", 1263U},
        {15,"ISO_ALPHA_3_AIA", 1313U},
        {15,"ISO_ALPHA_3_ALB", 1410U},
        {15,"ISO_ALPHA_3_AND", 1476U},
        {15,"ISO_ALPHA_3_ANT", 1492U},
        {15,"ISO_ALPHA_3_ARE", 1605U},
        {15,"ISO_ALPHA_3_ARG", 1607U},
        {15,"ISO_ALPHA_3_ARM", 1613U},
        {15,"ISO_ALPHA_3_ASM", 1645U},
        {15,"ISO_ALPHA_3_ATG", 1671U},
        {15,"ISO_ALPHA_3_AUS", 1715U},
        {15,"ISO_ALPHA_3_AUT", 1716U},
        {15,"ISO_ALPHA_3_AZE", 1861U},
        {15,"ISO_ALPHA_3_BDI", 2185U},
        {15,"ISO_ALPHA_3_BEL", 2220U},
        {15,"ISO_ALPHA_3_BEN", 2222U},
        {15,"ISO_ALPHA_3_BFA", 2241U},
        {15,"ISO_ALPHA_3_BGD", 2276U},
        {15,"ISO_ALPHA_3_BGR", 2290U},
        {15,"ISO_ALPHA_3_BHR", 2322U},
        {15,"ISO_ALPHA_3_BHS", 2323U},
        {15,"ISO_ALPHA_3_BIH", 2344U},
        {15,"ISO_ALPHA_3_BLR", 2450U},
        {15,"ISO_ALPHA_3_BLZ", 2458U},
        {15,"ISO_ALPHA_3_BMU", 2485U},
        {15,"ISO_ALPHA_3_BOL", 2540U},
        {15,"ISO_ALPHA_3_BRA", 2625U},
        {15,"ISO_ALPHA_3_BRB", 2626U},
        {15,"ISO_ALPHA_3_BRN", 2638U},
        {15,"ISO_ALPHA_3_BTN", 2702U},
        {15,"ISO_ALPHA_3_BWA", 2785U},
        {15,"ISO_ALPHA_3_CAF", 3110U},
        {15,"ISO_ALPHA_3_CAN", 3118U},
        {15,"ISO_ALPHA_3_CHE", 3333U},
        {15,"ISO_ALPHA_3_CHL", 3340U},
        {15,"ISO_ALPHA_3_CHN", 3342U},
        {15,"ISO_ALPHA_3_CIV", 3382U},
        {15,"ISO_ALPHA_3_CMR", 3506U},
        {15,"ISO_ALPHA_3_COD", 3556U},
        {15,"ISO_ALPHA_3_COG", 3559U},
        {15,"ISO_ALPHA_3_COK", 3563U},
        {15,"ISO_ALPHA_3_COL", 3564U},
        {15,"ISO_ALPHA_3_COM", 3565U},
        {15,"ISO_ALPHA_3_CPV", 3606U},
        {15,"ISO_ALPHA_3_CRI", 3657U},
        {15,"ISO_ALPHA_3_CUB", 3746U},
        {15,"ISO_ALPHA_3_CYM", 3885U},
        {15,"ISO_ALPHA_3_CYP", 3888U},
        {15,"ISO_ALPHA_3_CZE", 3909U},
        {15,"ISO_ALPHA_3_DEU", 4277U},
        {15,"ISO_ALPHA_3_DJI", 4425U},
        {15,"ISO_ALPHA_3_DMA", 4513U},
        {15,"ISO_ALPHA_3_DNK", 4555U},
        {15,"ISO_ALPHA_3_DOM", 4589U},
        {15,"ISO_ALPHA_3_DZA", 4929U},
        {15,"ISO_ALPHA_3_ECU", 5237U},
        {15,"ISO_ALPHA_3_EGY", 5369U},
        {15,"ISO_ALPHA_3_ERI", 5705U},
        {15,"ISO_ALPHA_3_ESH", 5736U},
        {15,"ISO_ALPHA_3_ESP", 5744U},
        {15,"ISO_ALPHA_3_EST", 5748U},
        {15,"ISO_ALPHA_3_ETH", 5768U},
        {15,"ISO_ALPHA_3_FIN", 6446U},
        {15,"ISO_ALPHA_3_FJI", 6473U},
        {15,"ISO_ALPHA_3_FLK", 6539U},
        {15,"ISO_ALPHA_3_FRA", 6721U},
        {15,"ISO_ALPHA_3_FRO", 6735U},
        {15,"ISO_ALPHA_3_FSM", 6765U},
        {15,"ISO_ALPHA_3_GAB", 7202U},
        {15,"ISO_ALPHA_3_GBR", 7250U},
        {15,"ISO_ALPHA_3_GEO", 7343U},
        {15,"ISO_ALPHA_3_GHA", 7425U},
        {15,"ISO_ALPHA_3_GIB", 7458U},
        {15,"ISO_ALPHA_3_GIN", 7470U},
        {15,"ISO_ALPHA_3_GLP", 7568U},
        {15,"ISO_ALPHA_3_GMB", 7586U},
        {15,"ISO_ALPHA_3_GNB", 7618U},
        {15,"ISO_ALPHA_3_GNQ", 7633U},
        {15,"ISO_ALPHA_3_GRC", 7747U},
        {15,"ISO_ALPHA_3_GRD", 7748U},
        {15,"ISO_ALPHA_3_GRL", 7756U},
        {15,"ISO_ALPHA_3_GTM", 7821U},
        {15,"ISO_ALPHA_3_GUF", 7846U},
        {15,"ISO_ALPHA_3_GUM", 7853U},
        {15,"ISO_ALPHA_3_GUY", 7865U},
        {15,"ISO_ALPHA_3_HKG", 8551U},
        {15,"ISO_ALPHA_3_HND", 8644U},
        {15,"ISO_ALPHA_3_HRV", 8790U},
        {15,"ISO_ALPHA_3_HTI", 8841U},
        {15,"ISO_ALPHA_3_HUN", 8878U},
        {15,"ISO_ALPHA_3_IDN", 9358U},
        {15,"ISO_ALPHA_3_IND", 9668U},
        {15,"ISO_ALPHA_3_INT", 9684U},
        {15,"ISO_ALPHA_3_IRL", 9804U},
        {15,"ISO_ALPHA_3_IRN", 9806U},
        {15,"ISO_ALPHA_3_IRQ", 9809U},
        {15,"ISO_ALPHA_3_ISL", 9836U},
        {15,"ISO_ALPHA_3_ISR", 9842U},
        {15,"ISO_ALPHA_3_ITA", 9857U},
        {15,"ISO_ALPHA_3_JAM", 10285U},
        {15,"ISO_ALPHA_3_JOR", 10738U},
        {15,"ISO_ALPHA_3_JPN", 10766U},
        {15,"ISO_ALPHA_3_KAZ", 11322U},
        {15,"ISO_ALPHA_3_KEN", 11438U},
        {15,"ISO_ALPHA_3_KGZ", 11514U},
        {15,"ISO_ALPHA_3_KHM", 11533U},
        {15,"ISO_ALPHA_3_KIR", 11570U},
        {15,"ISO_ALPHA_3_KNA", 11713U},
        {15,"ISO_ALPHA_3_KOR", 11762U},
        {15,"ISO_ALPHA_3_KWT", 12020U},
        {15,"ISO_ALPHA_3_LAO", 12335U},
        {15,"ISO_ALPHA_3_LBN", 12366U},
        {15,"ISO_ALPHA_3_LBR", 12370U},
        {15,"ISO_ALPHA_3_LBY", 12377U},
        {15,"ISO_ALPHA_3_LCA", 12385U},
        {15,"ISO_ALPHA_3_LIE", 12581U},
        {15,"ISO_ALPHA_3_LKA", 12641U},
        {15,"ISO_ALPHA_3_LSO", 12911U},
        {15,"ISO_ALPHA_3_LTU", 12949U},
        {15,"ISO_ALPHA_3_LUX", 12984U},
        {15,"ISO_ALPHA_3_LVA", 12993U},
        {15,"ISO_ALPHA_3_MAC", 13347U},
        {15,"ISO_ALPHA_3_MAR", 13362U},
        {15,"ISO_ALPHA_3_MCO", 13423U},
        {15,"ISO_ALPHA_3_MDA", 13441U},
        {15,"ISO_ALPHA_3_MDG", 13447U},
        {15,"ISO_ALPHA_3_MDV", 13462U},
        {15,"ISO_ALPHA_3_MEX", 13496U},
        {15,"ISO_ALPHA_3_MHL", 13580U},
        {15,"ISO_ALPHA_3_MKD", 13668U},
        {15,"ISO_ALPHA_3_MLI", 13705U},
        {15,"ISO_ALPHA_3_MLT", 13716U},
        {15,"ISO_ALPHA_3_MMR", 13746U},
        {15,"ISO_ALPHA_3_MNE", 13765U},
        {15,"ISO_ALPHA_3_MNG", 13767U},
        {15,"ISO_ALPHA_3_MNP", 13776U},
        {15,"ISO_ALPHA_3_MOZ", 13818U},
        {15,"ISO_ALPHA_3_MRT", 13908U},
        {15,"ISO_ALPHA_3_MSR", 13938U},
        {15,"ISO_ALPHA_3_MTQ", 13969U},
        {15,"ISO_ALPHA_3_MUS", 14003U},
        {15,"ISO_ALPHA_3_MWI", 14057U},
        {15,"ISO_ALPHA_3_MYS", 14131U},
        {15,"ISO_ALPHA_3_MYT", 14132U},
        {15,"ISO_ALPHA_3_NAM", 14381U},
        {15,"ISO_ALPHA_3_NCL", 14444U},
        {15,"ISO_ALPHA_3_NER", 14514U},
        {15,"ISO_ALPHA_3_NFK", 14539U},
        {15,"ISO_ALPHA_3_NGA", 14561U},
        {15,"ISO_ALPHA_3_NIC", 14627U},
        {15,"ISO_ALPHA_3_NIU", 14645U},
        {15,"ISO_ALPHA_3_NLD", 14724U},
        {15,"ISO_ALPHA_3_NOR", 14834U},
        {15,"ISO_ALPHA_3_NPL", 14860U},
        {15,"ISO_ALPHA_3_NRU", 14933U},
        {15,"ISO_ALPHA_3_NZL", 15180U},
        {15,"ISO_ALPHA_3_OMN", 15790U},
        {15,"ISO_ALPHA_3_PAK", 16427U},
        {15,"ISO_ALPHA_3_PAN", 16430U},
        {15,"ISO_ALPHA_3_PCN", 16494U},
        {15,"ISO_ALPHA_3_PER", 16562U},
        {15,"ISO_ALPHA_3_PHL", 16652U},
        {15,"ISO_ALPHA_3_PLW", 16791U},
        {15,"ISO_ALPHA_3_PNG", 16839U},
        {15,"ISO_ALPHA_3_POL", 16876U},
        {15,"ISO_ALPHA_3_PRI", 16969U},
        {15,"ISO_ALPHA_3_PRK", 16971U},
        {15,"ISO_ALPHA_3_PRT", 16980U},
        {15,"ISO_ALPHA_3_PRY", 16985U},
        {15,"ISO_ALPHA_3_PSE", 16997U},
        {15,"ISO_ALPHA_3_PYF", 17190U},
        {15,"ISO_ALPHA_3_QAT", 17460U},
        {15,"ISO_ALPHA_3_REU", 18613U},
        {15,"ISO_ALPHA_3_ROU", 18933U},
        {15,"ISO_ALPHA_3_RUS", 19123U},
        {15,"ISO_ALPHA_3_RWA", 19169U},
        {15,"ISO_ALPHA_3_SAU", 19509U},
        {15,"ISO_ALPHA_3_SDN", 19598U},
        {15,"ISO_ALPHA_3_SEN", 19630U},
        {15,"ISO_ALPHA_3_SGP", 19696U},
        {15,"ISO_ALPHA_3_SHN", 19726U},
        {15,"ISO_ALPHA_3_SJM", 19789U},
        {15,"ISO_ALPHA_3_SLB", 19842U},
        {15,"ISO_ALPHA_3_SLE", 19845U},
        {15,"ISO_ALPHA_3_SLV", 19862U},
        {15,"ISO_ALPHA_3_SMR", 19890U},
        {15,"ISO_ALPHA_3_SOM", 19949U},
        {15,"ISO_ALPHA_3_SPM", 19981U},
        {15,"ISO_ALPHA_3_SRB", 20034U},
        {15,"ISO_ALPHA_3_STP", 20112U},
        {15,"ISO_ALPHA_3_SUR", 20146U},
        {15,"ISO_ALPHA_3_SVK", 20171U},
        {15,"ISO_ALPHA_3_SVN", 20174U},
        {15,"ISO_ALPHA_3_SWE", 20197U},
        {15,"ISO_ALPHA_3_SWZ", 20218U},
        {15,"ISO_ALPHA_3_SYC", 20259U},
        {15,"ISO_ALPHA_3_SYR", 20274U},
        {15,"ISO_ALPHA_3_TCA", 20577U},
        {15,"ISO_ALPHA_3_TCD", 20580U},
        {15,"ISO_ALPHA_3_TGO", 20719U},
        {15,"ISO_ALPHA_3_THA", 20737U},
        {15,"ISO_ALPHA_3_TJK", 20811U},
        {15,"ISO_ALPHA_3_TKL", 20844U},
        {15,"ISO_ALPHA_3_TKM", 20845U},
        {15,"ISO_ALPHA_3_TLS", 20883U},
        {15,"ISO_ALPHA_3_TON", 20974U},
        {15,"ISO_ALPHA_3_TTO", 21135U},
        {15,"ISO_ALPHA_3_TUN", 21166U},
        {15,"ISO_ALPHA_3_TUR", 21170U},
        {15,"ISO_ALPHA_3_TUV", 21174U},
        {15,"ISO_ALPHA_3_TWN", 21230U},
        {15,"ISO_ALPHA_3_TZA", 21313U},
        {15,"ISO_ALPHA_3_UGA", 21729U},
        {15,"ISO_ALPHA_3_UKR", 21874U},
        {15,"ISO_ALPHA_3_URY", 22105U},
        {15,"ISO_ALPHA_3_USA", 22113U},
        {15,"ISO_ALPHA_3_UZB", 22338U},
        {15,"ISO_ALPHA_3_VAT", 22580U},
        {15,"ISO_ALPHA_3_VCT", 22644U},
        {15,"ISO_ALPHA_3_VEN", 22702U},
        {15,"ISO_ALPHA_3_VGB", 22754U},
        {15,"ISO_ALPHA_3_VIR", 22834U},
        {15,"ISO_ALPHA_3_VNM", 22989U},
        {15,"ISO_ALPHA_3_VUT", 23220U},
        {15,"ISO_ALPHA_3_WLF", 23942U},
        {15,"ISO_ALPHA_3_WSM", 24173U},
        {15,"ISO_ALPHA_3_YEM", 25773U},
        {15,"ISO_ALPHA_3_YUG", 26279U},
        {15,"ISO_ALPHA_3_ZAF", 26662U},
        {15,"ISO_ALPHA_3_ZMB", 27042U},
        {15,"ISO_ALPHA_3_ZWE", 27365U},
        {21,"ISO_ALPHA_3_UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 234, (unsigned int&) value);
}

const char* T_e16_ISOCountryCode_Name (T_e16_ISOCountryCode value)
{
    static const char* enumerationLiterals[] = {
        "ISO_ALPHA_3_UNDEFINED",
        "ISO_ALPHA_3_ABW",
        "ISO_ALPHA_3_AFG",
        "ISO_ALPHA_3_AGO",
        "ISO_ALPHA_3_AIA",
        "ISO_ALPHA_3_ALB",
        "ISO_ALPHA_3_AND",
        "ISO_ALPHA_3_ANT",
        "ISO_ALPHA_3_ARE",
        "ISO_ALPHA_3_ARG",
        "ISO_ALPHA_3_ARM",
        "ISO_ALPHA_3_ASM",
        "ISO_ALPHA_3_ATG",
        "ISO_ALPHA_3_AUS",
        "ISO_ALPHA_3_AUT",
        "ISO_ALPHA_3_AZE",
        "ISO_ALPHA_3_BDI",
        "ISO_ALPHA_3_BEL",
        "ISO_ALPHA_3_BEN",
        "ISO_ALPHA_3_BFA",
        "ISO_ALPHA_3_BGD",
        "ISO_ALPHA_3_BGR",
        "ISO_ALPHA_3_BHR",
        "ISO_ALPHA_3_BHS",
        "ISO_ALPHA_3_BIH",
        "ISO_ALPHA_3_BLR",
        "ISO_ALPHA_3_BLZ",
        "ISO_ALPHA_3_BMU",
        "ISO_ALPHA_3_BOL",
        "ISO_ALPHA_3_BRA",
        "ISO_ALPHA_3_BRB",
        "ISO_ALPHA_3_BRN",
        "ISO_ALPHA_3_BTN",
        "ISO_ALPHA_3_BWA",
        "ISO_ALPHA_3_CAF",
        "ISO_ALPHA_3_CAN",
        "ISO_ALPHA_3_CHE",
        "ISO_ALPHA_3_CHL",
        "ISO_ALPHA_3_CHN",
        "ISO_ALPHA_3_CIV",
        "ISO_ALPHA_3_CMR",
        "ISO_ALPHA_3_COD",
        "ISO_ALPHA_3_COG",
        "ISO_ALPHA_3_COK",
        "ISO_ALPHA_3_COL",
        "ISO_ALPHA_3_COM",
        "ISO_ALPHA_3_CPV",
        "ISO_ALPHA_3_CRI",
        "ISO_ALPHA_3_CUB",
        "ISO_ALPHA_3_CYM",
        "ISO_ALPHA_3_CYP",
        "ISO_ALPHA_3_CZE",
        "ISO_ALPHA_3_DEU",
        "ISO_ALPHA_3_DJI",
        "ISO_ALPHA_3_DMA",
        "ISO_ALPHA_3_DNK",
        "ISO_ALPHA_3_DOM",
        "ISO_ALPHA_3_DZA",
        "ISO_ALPHA_3_ECU",
        "ISO_ALPHA_3_EGY",
        "ISO_ALPHA_3_ERI",
        "ISO_ALPHA_3_ESH",
        "ISO_ALPHA_3_ESP",
        "ISO_ALPHA_3_EST",
        "ISO_ALPHA_3_ETH",
        "ISO_ALPHA_3_FIN",
        "ISO_ALPHA_3_FJI",
        "ISO_ALPHA_3_FLK",
        "ISO_ALPHA_3_FRA",
        "ISO_ALPHA_3_FRO",
        "ISO_ALPHA_3_FSM",
        "ISO_ALPHA_3_GAB",
        "ISO_ALPHA_3_GBR",
        "ISO_ALPHA_3_GEO",
        "ISO_ALPHA_3_GHA",
        "ISO_ALPHA_3_GIB",
        "ISO_ALPHA_3_GIN",
        "ISO_ALPHA_3_GLP",
        "ISO_ALPHA_3_GMB",
        "ISO_ALPHA_3_GNB",
        "ISO_ALPHA_3_GNQ",
        "ISO_ALPHA_3_GRC",
        "ISO_ALPHA_3_GRD",
        "ISO_ALPHA_3_GRL",
        "ISO_ALPHA_3_GTM",
        "ISO_ALPHA_3_GUF",
        "ISO_ALPHA_3_GUM",
        "ISO_ALPHA_3_GUY",
        "ISO_ALPHA_3_HKG",
        "ISO_ALPHA_3_HND",
        "ISO_ALPHA_3_HRV",
        "ISO_ALPHA_3_HTI",
        "ISO_ALPHA_3_HUN",
        "ISO_ALPHA_3_IDN",
        "ISO_ALPHA_3_IND",
        "ISO_ALPHA_3_INT",
        "ISO_ALPHA_3_IRL",
        "ISO_ALPHA_3_IRN",
        "ISO_ALPHA_3_IRQ",
        "ISO_ALPHA_3_ISL",
        "ISO_ALPHA_3_ISR",
        "ISO_ALPHA_3_ITA",
        "ISO_ALPHA_3_JAM",
        "ISO_ALPHA_3_JOR",
        "ISO_ALPHA_3_JPN",
        "ISO_ALPHA_3_KAZ",
        "ISO_ALPHA_3_KEN",
        "ISO_ALPHA_3_KGZ",
        "ISO_ALPHA_3_KHM",
        "ISO_ALPHA_3_KIR",
        "ISO_ALPHA_3_KNA",
        "ISO_ALPHA_3_KOR",
        "ISO_ALPHA_3_KWT",
        "ISO_ALPHA_3_LAO",
        "ISO_ALPHA_3_LBN",
        "ISO_ALPHA_3_LBR",
        "ISO_ALPHA_3_LBY",
        "ISO_ALPHA_3_LCA",
        "ISO_ALPHA_3_LIE",
        "ISO_ALPHA_3_LKA",
        "ISO_ALPHA_3_LSO",
        "ISO_ALPHA_3_LTU",
        "ISO_ALPHA_3_LUX",
        "ISO_ALPHA_3_LVA",
        "ISO_ALPHA_3_MAC",
        "ISO_ALPHA_3_MAR",
        "ISO_ALPHA_3_MCO",
        "ISO_ALPHA_3_MDA",
        "ISO_ALPHA_3_MDG",
        "ISO_ALPHA_3_MDV",
        "ISO_ALPHA_3_MEX",
        "ISO_ALPHA_3_MHL",
        "ISO_ALPHA_3_MKD",
        "ISO_ALPHA_3_MLI",
        "ISO_ALPHA_3_MLT",
        "ISO_ALPHA_3_MMR",
        "ISO_ALPHA_3_MNE",
        "ISO_ALPHA_3_MNG",
        "ISO_ALPHA_3_MNP",
        "ISO_ALPHA_3_MOZ",
        "ISO_ALPHA_3_MRT",
        "ISO_ALPHA_3_MSR",
        "ISO_ALPHA_3_MTQ",
        "ISO_ALPHA_3_MUS",
        "ISO_ALPHA_3_MWI",
        "ISO_ALPHA_3_MYS",
        "ISO_ALPHA_3_MYT",
        "ISO_ALPHA_3_NAM",
        "ISO_ALPHA_3_NCL",
        "ISO_ALPHA_3_NER",
        "ISO_ALPHA_3_NFK",
        "ISO_ALPHA_3_NGA",
        "ISO_ALPHA_3_NIC",
        "ISO_ALPHA_3_NIU",
        "ISO_ALPHA_3_NLD",
        "ISO_ALPHA_3_NOR",
        "ISO_ALPHA_3_NPL",
        "ISO_ALPHA_3_NRU",
        "ISO_ALPHA_3_NZL",
        "ISO_ALPHA_3_OMN",
        "ISO_ALPHA_3_PAK",
        "ISO_ALPHA_3_PAN",
        "ISO_ALPHA_3_PCN",
        "ISO_ALPHA_3_PER",
        "ISO_ALPHA_3_PHL",
        "ISO_ALPHA_3_PLW",
        "ISO_ALPHA_3_PNG",
        "ISO_ALPHA_3_POL",
        "ISO_ALPHA_3_PRI",
        "ISO_ALPHA_3_PRK",
        "ISO_ALPHA_3_PRT",
        "ISO_ALPHA_3_PRY",
        "ISO_ALPHA_3_PSE",
        "ISO_ALPHA_3_PYF",
        "ISO_ALPHA_3_QAT",
        "ISO_ALPHA_3_REU",
        "ISO_ALPHA_3_ROU",
        "ISO_ALPHA_3_RUS",
        "ISO_ALPHA_3_RWA",
        "ISO_ALPHA_3_SAU",
        "ISO_ALPHA_3_SDN",
        "ISO_ALPHA_3_SEN",
        "ISO_ALPHA_3_SGP",
        "ISO_ALPHA_3_SHN",
        "ISO_ALPHA_3_SJM",
        "ISO_ALPHA_3_SLB",
        "ISO_ALPHA_3_SLE",
        "ISO_ALPHA_3_SLV",
        "ISO_ALPHA_3_SMR",
        "ISO_ALPHA_3_SOM",
        "ISO_ALPHA_3_SPM",
        "ISO_ALPHA_3_SRB",
        "ISO_ALPHA_3_STP",
        "ISO_ALPHA_3_SUR",
        "ISO_ALPHA_3_SVK",
        "ISO_ALPHA_3_SVN",
        "ISO_ALPHA_3_SWE",
        "ISO_ALPHA_3_SWZ",
        "ISO_ALPHA_3_SYC",
        "ISO_ALPHA_3_SYR",
        "ISO_ALPHA_3_TCA",
        "ISO_ALPHA_3_TCD",
        "ISO_ALPHA_3_TGO",
        "ISO_ALPHA_3_THA",
        "ISO_ALPHA_3_TJK",
        "ISO_ALPHA_3_TKL",
        "ISO_ALPHA_3_TKM",
        "ISO_ALPHA_3_TLS",
        "ISO_ALPHA_3_TON",
        "ISO_ALPHA_3_TTO",
        "ISO_ALPHA_3_TUN",
        "ISO_ALPHA_3_TUR",
        "ISO_ALPHA_3_TUV",
        "ISO_ALPHA_3_TWN",
        "ISO_ALPHA_3_TZA",
        "ISO_ALPHA_3_UGA",
        "ISO_ALPHA_3_UKR",
        "ISO_ALPHA_3_URY",
        "ISO_ALPHA_3_USA",
        "ISO_ALPHA_3_UZB",
        "ISO_ALPHA_3_VAT",
        "ISO_ALPHA_3_VCT",
        "ISO_ALPHA_3_VEN",
        "ISO_ALPHA_3_VGB",
        "ISO_ALPHA_3_VIR",
        "ISO_ALPHA_3_VNM",
        "ISO_ALPHA_3_VUT",
        "ISO_ALPHA_3_WLF",
        "ISO_ALPHA_3_WSM",
        "ISO_ALPHA_3_YEM",
        "ISO_ALPHA_3_YUG",
        "ISO_ALPHA_3_ZAF",
        "ISO_ALPHA_3_ZMB",
        "ISO_ALPHA_3_ZWE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1111U,
        1223U,
        1263U,
        1313U,
        1410U,
        1476U,
        1492U,
        1605U,
        1607U,
        1613U,
        1645U,
        1671U,
        1715U,
        1716U,
        1861U,
        2185U,
        2220U,
        2222U,
        2241U,
        2276U,
        2290U,
        2322U,
        2323U,
        2344U,
        2450U,
        2458U,
        2485U,
        2540U,
        2625U,
        2626U,
        2638U,
        2702U,
        2785U,
        3110U,
        3118U,
        3333U,
        3340U,
        3342U,
        3382U,
        3506U,
        3556U,
        3559U,
        3563U,
        3564U,
        3565U,
        3606U,
        3657U,
        3746U,
        3885U,
        3888U,
        3909U,
        4277U,
        4425U,
        4513U,
        4555U,
        4589U,
        4929U,
        5237U,
        5369U,
        5705U,
        5736U,
        5744U,
        5748U,
        5768U,
        6446U,
        6473U,
        6539U,
        6721U,
        6735U,
        6765U,
        7202U,
        7250U,
        7343U,
        7425U,
        7458U,
        7470U,
        7568U,
        7586U,
        7618U,
        7633U,
        7747U,
        7748U,
        7756U,
        7821U,
        7846U,
        7853U,
        7865U,
        8551U,
        8644U,
        8790U,
        8841U,
        8878U,
        9358U,
        9668U,
        9684U,
        9804U,
        9806U,
        9809U,
        9836U,
        9842U,
        9857U,
        10285U,
        10738U,
        10766U,
        11322U,
        11438U,
        11514U,
        11533U,
        11570U,
        11713U,
        11762U,
        12020U,
        12335U,
        12366U,
        12370U,
        12377U,
        12385U,
        12581U,
        12641U,
        12911U,
        12949U,
        12984U,
        12993U,
        13347U,
        13362U,
        13423U,
        13441U,
        13447U,
        13462U,
        13496U,
        13580U,
        13668U,
        13705U,
        13716U,
        13746U,
        13765U,
        13767U,
        13776U,
        13818U,
        13908U,
        13938U,
        13969U,
        14003U,
        14057U,
        14131U,
        14132U,
        14381U,
        14444U,
        14514U,
        14539U,
        14561U,
        14627U,
        14645U,
        14724U,
        14834U,
        14860U,
        14933U,
        15180U,
        15790U,
        16427U,
        16430U,
        16494U,
        16562U,
        16652U,
        16791U,
        16839U,
        16876U,
        16969U,
        16971U,
        16980U,
        16985U,
        16997U,
        17190U,
        17460U,
        18613U,
        18933U,
        19123U,
        19169U,
        19509U,
        19598U,
        19630U,
        19696U,
        19726U,
        19789U,
        19842U,
        19845U,
        19862U,
        19890U,
        19949U,
        19981U,
        20034U,
        20112U,
        20146U,
        20171U,
        20174U,
        20197U,
        20218U,
        20259U,
        20274U,
        20577U,
        20580U,
        20719U,
        20737U,
        20811U,
        20844U,
        20845U,
        20883U,
        20974U,
        21135U,
        21166U,
        21170U,
        21174U,
        21230U,
        21313U,
        21729U,
        21874U,
        22105U,
        22113U,
        22338U,
        22580U,
        22644U,
        22702U,
        22754U,
        22834U,
        22989U,
        23220U,
        23942U,
        24173U,
        25773U,
        26279U,
        26662U,
        27042U,
        27365U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 234, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_ISOCountryCode_IsValid (T_e16_ISOCountryCode value)
{
    switch (value) {
    case T_e16_ISOCountryCode__ISO_ALPHA_3_UNDEFINED:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AFG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ALB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DZA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ASM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AND:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AGO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AIA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ATG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ARG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ARM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ABW:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AUS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AUT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_AZE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BHS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BHR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BGD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BRB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BLR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BEL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BLZ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BEN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BMU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BTN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BOL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BIH:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BWA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BRA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BRN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BGR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BFA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_BDI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KHM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CMR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CAN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CPV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CYM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CAF:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TCD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CHL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CHN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_COL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_COM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_COG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_COD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_COK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CRI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CIV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_HRV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CUB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CYP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CZE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DNK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DJI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DMA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DOM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ECU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_EGY:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SLV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GNQ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ERI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_EST:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ETH:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FLK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FRO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FJI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FIN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FRA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GUF:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PYF:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GAB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GMB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GEO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_DEU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GHA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GIB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GRC:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GRL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GRD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GLP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GUM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GTM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GIN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GNB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GUY:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_HTI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VAT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_HND:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_HKG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_HUN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ISL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_IND:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_IDN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_INT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_IRN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_IRQ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_IRL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ISR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ITA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_JAM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_JPN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_JOR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KAZ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KEN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KIR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PRK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KOR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KWT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KGZ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LAO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LVA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LBN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LSO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LBR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LBY:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LIE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LTU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LUX:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MAC:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MKD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MDG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MWI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MYS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MDV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MLI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MLT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MHL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MTQ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MRT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MUS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MYT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MEX:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_FSM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MDA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MCO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MNG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MNE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MSR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MAR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MOZ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MMR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NAM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NRU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NPL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NLD:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ANT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NCL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NZL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NIC:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NER:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NGA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NIU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NFK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_MNP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_NOR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PSE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_OMN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PAK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PLW:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PAN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PNG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PRY:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PER:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PHL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PCN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_POL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PRT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_PRI:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_QAT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_REU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ROU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_RUS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_RWA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_KNA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LCA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VCT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_WSM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SMR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_STP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SAU:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SEN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SRB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SYC:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SLE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SGP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SVK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SVN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SLB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SOM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ZAF:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ESP:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_LKA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SHN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SPM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SDN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SUR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SJM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SWZ:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SWE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_CHE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_SYR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TWN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TJK:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TZA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_THA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TLS:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TGO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TKL:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TON:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TTO:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TUN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TUR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TKM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TCA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_TUV:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_UGA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_UKR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ARE:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_GBR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_USA:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_URY:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_UZB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VUT:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VEN:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VNM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VGB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_VIR:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_WLF:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ESH:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_YEM:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_YUG:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ZMB:
    case T_e16_ISOCountryCode__ISO_ALPHA_3_ZWE:
        return true;
    default:
        return false;
    }
}

bool T_e16_ISOLanguageCode_Parse (const char *str, size_t length, T_e16_ISOLanguageCode &value)
{
    static stringEntry entries[] = {
        {12,"ISO_639_1_AA", 24929U},
        {12,"ISO_639_1_AB", 24930U},
        {12,"ISO_639_1_AE", 24933U},
        {12,"ISO_639_1_AF", 24934U},
        {12,"ISO_639_1_AK", 24939U},
        {12,"ISO_639_1_AM", 24941U},
        {12,"ISO_639_1_AN", 24942U},
        {12,"ISO_639_1_AR", 24946U},
        {12,"ISO_639_1_AS", 24947U},
        {12,"ISO_639_1_AV", 24950U},
        {12,"ISO_639_1_AY", 24953U},
        {12,"ISO_639_1_AZ", 24954U},
        {12,"ISO_639_1_BA", 25185U},
        {12,"ISO_639_1_BE", 25189U},
        {12,"ISO_639_1_BG", 25191U},
        {12,"ISO_639_1_BH", 25192U},
        {12,"ISO_639_1_BI", 25193U},
        {12,"ISO_639_1_BL", 25196U},
        {12,"ISO_639_1_BM", 25197U},
        {12,"ISO_639_1_BN", 25198U},
        {12,"ISO_639_1_BO", 25199U},
        {12,"ISO_639_1_BR", 25202U},
        {12,"ISO_639_1_BS", 25203U},
        {12,"ISO_639_1_BT", 25204U},
        {12,"ISO_639_1_CA", 25441U},
        {12,"ISO_639_1_CE", 25445U},
        {12,"ISO_639_1_CF", 25446U},
        {12,"ISO_639_1_CH", 25448U},
        {12,"ISO_639_1_CL", 25452U},
        {12,"ISO_639_1_CN", 25454U},
        {12,"ISO_639_1_CO", 25455U},
        {12,"ISO_639_1_CR", 25458U},
        {12,"ISO_639_1_CS", 25459U},
        {12,"ISO_639_1_CT", 25460U},
        {12,"ISO_639_1_CU", 25461U},
        {12,"ISO_639_1_CV", 25462U},
        {12,"ISO_639_1_CY", 25465U},
        {12,"ISO_639_1_DA", 25697U},
        {12,"ISO_639_1_DE", 25701U},
        {12,"ISO_639_1_DV", 25718U},
        {12,"ISO_639_1_DZ", 25722U},
        {12,"ISO_639_1_EE", 25957U},
        {12,"ISO_639_1_EG", 25959U},
        {12,"ISO_639_1_EL", 25964U},
        {12,"ISO_639_1_EN", 25966U},
        {12,"ISO_639_1_EO", 25967U},
        {12,"ISO_639_1_ES", 25971U},
        {12,"ISO_639_1_ET", 25972U},
        {12,"ISO_639_1_EU", 25973U},
        {12,"ISO_639_1_FA", 26209U},
        {12,"ISO_639_1_FF", 26214U},
        {12,"ISO_639_1_FI", 26217U},
        {12,"ISO_639_1_FJ", 26218U},
        {12,"ISO_639_1_FO", 26223U},
        {12,"ISO_639_1_FR", 26226U},
        {12,"ISO_639_1_FY", 26233U},
        {12,"ISO_639_1_GA", 26465U},
        {12,"ISO_639_1_GD", 26468U},
        {12,"ISO_639_1_GL", 26476U},
        {12,"ISO_639_1_GN", 26478U},
        {12,"ISO_639_1_GU", 26485U},
        {12,"ISO_639_1_GV", 26486U},
        {12,"ISO_639_1_HA", 26721U},
        {12,"ISO_639_1_HE", 26725U},
        {12,"ISO_639_1_HI", 26729U},
        {12,"ISO_639_1_HO", 26735U},
        {12,"ISO_639_1_HR", 26738U},
        {12,"ISO_639_1_HU", 26741U},
        {12,"ISO_639_1_HY", 26745U},
        {12,"ISO_639_1_HZ", 26746U},
        {12,"ISO_639_1_IA", 26977U},
        {12,"ISO_639_1_ID", 26980U},
        {12,"ISO_639_1_IE", 26981U},
        {12,"ISO_639_1_IG", 26983U},
        {12,"ISO_639_1_II", 26985U},
        {12,"ISO_639_1_IK", 26987U},
        {12,"ISO_639_1_IO", 26991U},
        {12,"ISO_639_1_IS", 26995U},
        {12,"ISO_639_1_IT", 26996U},
        {12,"ISO_639_1_IU", 26997U},
        {12,"ISO_639_1_JA", 27233U},
        {12,"ISO_639_1_JV", 27254U},
        {12,"ISO_639_1_KA", 27489U},
        {12,"ISO_639_1_KG", 27495U},
        {12,"ISO_639_1_KI", 27497U},
        {12,"ISO_639_1_KJ", 27498U},
        {12,"ISO_639_1_KK", 27499U},
        {12,"ISO_639_1_KL", 27500U},
        {12,"ISO_639_1_KM", 27501U},
        {12,"ISO_639_1_KN", 27502U},
        {12,"ISO_639_1_KO", 27503U},
        {12,"ISO_639_1_KR", 27506U},
        {12,"ISO_639_1_KS", 27507U},
        {12,"ISO_639_1_KU", 27509U},
        {12,"ISO_639_1_KV", 27510U},
        {12,"ISO_639_1_KW", 27511U},
        {12,"ISO_639_1_KY", 27513U},
        {12,"ISO_639_1_LA", 27745U},
        {12,"ISO_639_1_LB", 27746U},
        {12,"ISO_639_1_LG", 27751U},
        {12,"ISO_639_1_LI", 27753U},
        {12,"ISO_639_1_LN", 27758U},
        {12,"ISO_639_1_LO", 27759U},
        {12,"ISO_639_1_LT", 27764U},
        {12,"ISO_639_1_LU", 27765U},
        {12,"ISO_639_1_LV", 27766U},
        {12,"ISO_639_1_MC", 28003U},
        {12,"ISO_639_1_MG", 28007U},
        {12,"ISO_639_1_MH", 28008U},
        {12,"ISO_639_1_MI", 28009U},
        {12,"ISO_639_1_MK", 28011U},
        {12,"ISO_639_1_ML", 28012U},
        {12,"ISO_639_1_MN", 28014U},
        {12,"ISO_639_1_MO", 28015U},
        {12,"ISO_639_1_MR", 28018U},
        {12,"ISO_639_1_MS", 28019U},
        {12,"ISO_639_1_MT", 28020U},
        {12,"ISO_639_1_MY", 28025U},
        {12,"ISO_639_1_NA", 28257U},
        {12,"ISO_639_1_NB", 28258U},
        {12,"ISO_639_1_ND", 28260U},
        {12,"ISO_639_1_NE", 28261U},
        {12,"ISO_639_1_NG", 28263U},
        {12,"ISO_639_1_NL", 28268U},
        {12,"ISO_639_1_NN", 28270U},
        {12,"ISO_639_1_NO", 28271U},
        {12,"ISO_639_1_NR", 28274U},
        {12,"ISO_639_1_NV", 28278U},
        {12,"ISO_639_1_NY", 28281U},
        {12,"ISO_639_1_OC", 28515U},
        {12,"ISO_639_1_OJ", 28522U},
        {12,"ISO_639_1_OM", 28525U},
        {12,"ISO_639_1_OR", 28530U},
        {12,"ISO_639_1_OS", 28531U},
        {12,"ISO_639_1_PA", 28769U},
        {12,"ISO_639_1_PI", 28777U},
        {12,"ISO_639_1_PL", 28780U},
        {12,"ISO_639_1_PS", 28787U},
        {12,"ISO_639_1_PT", 28788U},
        {12,"ISO_639_1_QU", 29045U},
        {12,"ISO_639_1_RM", 29293U},
        {12,"ISO_639_1_RN", 29294U},
        {12,"ISO_639_1_RO", 29295U},
        {12,"ISO_639_1_RT", 29300U},
        {12,"ISO_639_1_RU", 29301U},
        {12,"ISO_639_1_RW", 29303U},
        {12,"ISO_639_1_SA", 29537U},
        {12,"ISO_639_1_SB", 29538U},
        {12,"ISO_639_1_SC", 29539U},
        {12,"ISO_639_1_SD", 29540U},
        {12,"ISO_639_1_SE", 29541U},
        {12,"ISO_639_1_SG", 29543U},
        {12,"ISO_639_1_SH", 29544U},
        {12,"ISO_639_1_SI", 29545U},
        {12,"ISO_639_1_SK", 29547U},
        {12,"ISO_639_1_SL", 29548U},
        {12,"ISO_639_1_SM", 29549U},
        {12,"ISO_639_1_SN", 29550U},
        {12,"ISO_639_1_SO", 29551U},
        {12,"ISO_639_1_SQ", 29553U},
        {12,"ISO_639_1_SR", 29554U},
        {12,"ISO_639_1_SS", 29555U},
        {12,"ISO_639_1_ST", 29556U},
        {12,"ISO_639_1_SU", 29557U},
        {12,"ISO_639_1_SV", 29558U},
        {12,"ISO_639_1_SW", 29559U},
        {12,"ISO_639_1_SX", 29560U},
        {12,"ISO_639_1_TA", 29793U},
        {12,"ISO_639_1_TE", 29797U},
        {12,"ISO_639_1_TG", 29799U},
        {12,"ISO_639_1_TH", 29800U},
        {12,"ISO_639_1_TI", 29801U},
        {12,"ISO_639_1_TK", 29803U},
        {12,"ISO_639_1_TL", 29804U},
        {12,"ISO_639_1_TN", 29806U},
        {12,"ISO_639_1_TO", 29807U},
        {12,"ISO_639_1_TR", 29810U},
        {12,"ISO_639_1_TS", 29811U},
        {12,"ISO_639_1_TT", 29812U},
        {12,"ISO_639_1_TW", 29815U},
        {12,"ISO_639_1_TY", 29817U},
        {12,"ISO_639_1_UE", 30053U},
        {12,"ISO_639_1_UG", 30055U},
        {12,"ISO_639_1_UK", 30059U},
        {12,"ISO_639_1_UL", 30060U},
        {12,"ISO_639_1_UR", 30066U},
        {12,"ISO_639_1_UZ", 30074U},
        {12,"ISO_639_1_VA", 30305U},
        {12,"ISO_639_1_VE", 30309U},
        {12,"ISO_639_1_VI", 30313U},
        {12,"ISO_639_1_VO", 30319U},
        {12,"ISO_639_1_WA", 30561U},
        {12,"ISO_639_1_WO", 30575U},
        {12,"ISO_639_1_XH", 30824U},
        {12,"ISO_639_1_YI", 31081U},
        {12,"ISO_639_1_YO", 31087U},
        {12,"ISO_639_1_ZA", 31329U},
        {12,"ISO_639_1_ZH", 31336U},
        {12,"ISO_639_1_ZL", 31340U},
        {12,"ISO_639_1_ZU", 31349U},
        {19,"ISO_639_1_UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 201, (unsigned int&) value);
}

const char* T_e16_ISOLanguageCode_Name (T_e16_ISOLanguageCode value)
{
    static const char* enumerationLiterals[] = {
        "ISO_639_1_undefined",
        "ISO_639_1_aa",
        "ISO_639_1_ab",
        "ISO_639_1_ae",
        "ISO_639_1_af",
        "ISO_639_1_ak",
        "ISO_639_1_am",
        "ISO_639_1_an",
        "ISO_639_1_ar",
        "ISO_639_1_as",
        "ISO_639_1_av",
        "ISO_639_1_ay",
        "ISO_639_1_az",
        "ISO_639_1_ba",
        "ISO_639_1_be",
        "ISO_639_1_bg",
        "ISO_639_1_bh",
        "ISO_639_1_bi",
        "ISO_639_1_bl",
        "ISO_639_1_bm",
        "ISO_639_1_bn",
        "ISO_639_1_bo",
        "ISO_639_1_br",
        "ISO_639_1_bs",
        "ISO_639_1_bt",
        "ISO_639_1_ca",
        "ISO_639_1_ce",
        "ISO_639_1_cf",
        "ISO_639_1_ch",
        "ISO_639_1_cl",
        "ISO_639_1_cn",
        "ISO_639_1_co",
        "ISO_639_1_cr",
        "ISO_639_1_cs",
        "ISO_639_1_ct",
        "ISO_639_1_cu",
        "ISO_639_1_cv",
        "ISO_639_1_cy",
        "ISO_639_1_da",
        "ISO_639_1_de",
        "ISO_639_1_dv",
        "ISO_639_1_dz",
        "ISO_639_1_ee",
        "ISO_639_1_eg",
        "ISO_639_1_el",
        "ISO_639_1_en",
        "ISO_639_1_eo",
        "ISO_639_1_es",
        "ISO_639_1_et",
        "ISO_639_1_eu",
        "ISO_639_1_fa",
        "ISO_639_1_ff",
        "ISO_639_1_fi",
        "ISO_639_1_fj",
        "ISO_639_1_fo",
        "ISO_639_1_fr",
        "ISO_639_1_fy",
        "ISO_639_1_ga",
        "ISO_639_1_gd",
        "ISO_639_1_gl",
        "ISO_639_1_gn",
        "ISO_639_1_gu",
        "ISO_639_1_gv",
        "ISO_639_1_ha",
        "ISO_639_1_he",
        "ISO_639_1_hi",
        "ISO_639_1_ho",
        "ISO_639_1_hr",
        "ISO_639_1_hu",
        "ISO_639_1_hy",
        "ISO_639_1_hz",
        "ISO_639_1_ia",
        "ISO_639_1_id",
        "ISO_639_1_ie",
        "ISO_639_1_ig",
        "ISO_639_1_ii",
        "ISO_639_1_ik",
        "ISO_639_1_io",
        "ISO_639_1_is",
        "ISO_639_1_it",
        "ISO_639_1_iu",
        "ISO_639_1_ja",
        "ISO_639_1_jv",
        "ISO_639_1_ka",
        "ISO_639_1_kg",
        "ISO_639_1_ki",
        "ISO_639_1_kj",
        "ISO_639_1_kk",
        "ISO_639_1_kl",
        "ISO_639_1_km",
        "ISO_639_1_kn",
        "ISO_639_1_ko",
        "ISO_639_1_kr",
        "ISO_639_1_ks",
        "ISO_639_1_ku",
        "ISO_639_1_kv",
        "ISO_639_1_kw",
        "ISO_639_1_ky",
        "ISO_639_1_la",
        "ISO_639_1_lb",
        "ISO_639_1_lg",
        "ISO_639_1_li",
        "ISO_639_1_ln",
        "ISO_639_1_lo",
        "ISO_639_1_lt",
        "ISO_639_1_lu",
        "ISO_639_1_lv",
        "ISO_639_1_mc",
        "ISO_639_1_mg",
        "ISO_639_1_mh",
        "ISO_639_1_mi",
        "ISO_639_1_mk",
        "ISO_639_1_ml",
        "ISO_639_1_mn",
        "ISO_639_1_mo",
        "ISO_639_1_mr",
        "ISO_639_1_ms",
        "ISO_639_1_mt",
        "ISO_639_1_my",
        "ISO_639_1_na",
        "ISO_639_1_nb",
        "ISO_639_1_nd",
        "ISO_639_1_ne",
        "ISO_639_1_ng",
        "ISO_639_1_nl",
        "ISO_639_1_nn",
        "ISO_639_1_no",
        "ISO_639_1_nr",
        "ISO_639_1_nv",
        "ISO_639_1_ny",
        "ISO_639_1_oc",
        "ISO_639_1_oj",
        "ISO_639_1_om",
        "ISO_639_1_or",
        "ISO_639_1_os",
        "ISO_639_1_pa",
        "ISO_639_1_pi",
        "ISO_639_1_pl",
        "ISO_639_1_ps",
        "ISO_639_1_pt",
        "ISO_639_1_qu",
        "ISO_639_1_rm",
        "ISO_639_1_rn",
        "ISO_639_1_ro",
        "ISO_639_1_rt",
        "ISO_639_1_ru",
        "ISO_639_1_rw",
        "ISO_639_1_sa",
        "ISO_639_1_sb",
        "ISO_639_1_sc",
        "ISO_639_1_sd",
        "ISO_639_1_se",
        "ISO_639_1_sg",
        "ISO_639_1_sh",
        "ISO_639_1_si",
        "ISO_639_1_sk",
        "ISO_639_1_sl",
        "ISO_639_1_sm",
        "ISO_639_1_sn",
        "ISO_639_1_so",
        "ISO_639_1_sq",
        "ISO_639_1_sr",
        "ISO_639_1_ss",
        "ISO_639_1_st",
        "ISO_639_1_su",
        "ISO_639_1_sv",
        "ISO_639_1_sw",
        "ISO_639_1_sx",
        "ISO_639_1_ta",
        "ISO_639_1_te",
        "ISO_639_1_tg",
        "ISO_639_1_th",
        "ISO_639_1_ti",
        "ISO_639_1_tk",
        "ISO_639_1_tl",
        "ISO_639_1_tn",
        "ISO_639_1_to",
        "ISO_639_1_tr",
        "ISO_639_1_ts",
        "ISO_639_1_tt",
        "ISO_639_1_tw",
        "ISO_639_1_ty",
        "ISO_639_1_ue",
        "ISO_639_1_ug",
        "ISO_639_1_uk",
        "ISO_639_1_ul",
        "ISO_639_1_ur",
        "ISO_639_1_uz",
        "ISO_639_1_va",
        "ISO_639_1_ve",
        "ISO_639_1_vi",
        "ISO_639_1_vo",
        "ISO_639_1_wa",
        "ISO_639_1_wo",
        "ISO_639_1_xh",
        "ISO_639_1_yi",
        "ISO_639_1_yo",
        "ISO_639_1_za",
        "ISO_639_1_zh",
        "ISO_639_1_zl",
        "ISO_639_1_zu",
    };

    static unsigned int enumerationValues[] = {
        0U,
        24929U,
        24930U,
        24933U,
        24934U,
        24939U,
        24941U,
        24942U,
        24946U,
        24947U,
        24950U,
        24953U,
        24954U,
        25185U,
        25189U,
        25191U,
        25192U,
        25193U,
        25196U,
        25197U,
        25198U,
        25199U,
        25202U,
        25203U,
        25204U,
        25441U,
        25445U,
        25446U,
        25448U,
        25452U,
        25454U,
        25455U,
        25458U,
        25459U,
        25460U,
        25461U,
        25462U,
        25465U,
        25697U,
        25701U,
        25718U,
        25722U,
        25957U,
        25959U,
        25964U,
        25966U,
        25967U,
        25971U,
        25972U,
        25973U,
        26209U,
        26214U,
        26217U,
        26218U,
        26223U,
        26226U,
        26233U,
        26465U,
        26468U,
        26476U,
        26478U,
        26485U,
        26486U,
        26721U,
        26725U,
        26729U,
        26735U,
        26738U,
        26741U,
        26745U,
        26746U,
        26977U,
        26980U,
        26981U,
        26983U,
        26985U,
        26987U,
        26991U,
        26995U,
        26996U,
        26997U,
        27233U,
        27254U,
        27489U,
        27495U,
        27497U,
        27498U,
        27499U,
        27500U,
        27501U,
        27502U,
        27503U,
        27506U,
        27507U,
        27509U,
        27510U,
        27511U,
        27513U,
        27745U,
        27746U,
        27751U,
        27753U,
        27758U,
        27759U,
        27764U,
        27765U,
        27766U,
        28003U,
        28007U,
        28008U,
        28009U,
        28011U,
        28012U,
        28014U,
        28015U,
        28018U,
        28019U,
        28020U,
        28025U,
        28257U,
        28258U,
        28260U,
        28261U,
        28263U,
        28268U,
        28270U,
        28271U,
        28274U,
        28278U,
        28281U,
        28515U,
        28522U,
        28525U,
        28530U,
        28531U,
        28769U,
        28777U,
        28780U,
        28787U,
        28788U,
        29045U,
        29293U,
        29294U,
        29295U,
        29300U,
        29301U,
        29303U,
        29537U,
        29538U,
        29539U,
        29540U,
        29541U,
        29543U,
        29544U,
        29545U,
        29547U,
        29548U,
        29549U,
        29550U,
        29551U,
        29553U,
        29554U,
        29555U,
        29556U,
        29557U,
        29558U,
        29559U,
        29560U,
        29793U,
        29797U,
        29799U,
        29800U,
        29801U,
        29803U,
        29804U,
        29806U,
        29807U,
        29810U,
        29811U,
        29812U,
        29815U,
        29817U,
        30053U,
        30055U,
        30059U,
        30060U,
        30066U,
        30074U,
        30305U,
        30309U,
        30313U,
        30319U,
        30561U,
        30575U,
        30824U,
        31081U,
        31087U,
        31329U,
        31336U,
        31340U,
        31349U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 201, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e16_ISOLanguageCode_IsValid (T_e16_ISOLanguageCode value)
{
    switch (value) {
    case T_e16_ISOLanguageCode__ISO_639_1_undefined:
    case T_e16_ISOLanguageCode__ISO_639_1_aa:
    case T_e16_ISOLanguageCode__ISO_639_1_ab:
    case T_e16_ISOLanguageCode__ISO_639_1_ae:
    case T_e16_ISOLanguageCode__ISO_639_1_af:
    case T_e16_ISOLanguageCode__ISO_639_1_ak:
    case T_e16_ISOLanguageCode__ISO_639_1_am:
    case T_e16_ISOLanguageCode__ISO_639_1_an:
    case T_e16_ISOLanguageCode__ISO_639_1_ar:
    case T_e16_ISOLanguageCode__ISO_639_1_as:
    case T_e16_ISOLanguageCode__ISO_639_1_av:
    case T_e16_ISOLanguageCode__ISO_639_1_ay:
    case T_e16_ISOLanguageCode__ISO_639_1_az:
    case T_e16_ISOLanguageCode__ISO_639_1_ba:
    case T_e16_ISOLanguageCode__ISO_639_1_be:
    case T_e16_ISOLanguageCode__ISO_639_1_bg:
    case T_e16_ISOLanguageCode__ISO_639_1_bh:
    case T_e16_ISOLanguageCode__ISO_639_1_bi:
    case T_e16_ISOLanguageCode__ISO_639_1_bl:
    case T_e16_ISOLanguageCode__ISO_639_1_bm:
    case T_e16_ISOLanguageCode__ISO_639_1_bn:
    case T_e16_ISOLanguageCode__ISO_639_1_bo:
    case T_e16_ISOLanguageCode__ISO_639_1_br:
    case T_e16_ISOLanguageCode__ISO_639_1_bs:
    case T_e16_ISOLanguageCode__ISO_639_1_bt:
    case T_e16_ISOLanguageCode__ISO_639_1_ca:
    case T_e16_ISOLanguageCode__ISO_639_1_ce:
    case T_e16_ISOLanguageCode__ISO_639_1_cf:
    case T_e16_ISOLanguageCode__ISO_639_1_ch:
    case T_e16_ISOLanguageCode__ISO_639_1_cl:
    case T_e16_ISOLanguageCode__ISO_639_1_cn:
    case T_e16_ISOLanguageCode__ISO_639_1_co:
    case T_e16_ISOLanguageCode__ISO_639_1_cr:
    case T_e16_ISOLanguageCode__ISO_639_1_cs:
    case T_e16_ISOLanguageCode__ISO_639_1_ct:
    case T_e16_ISOLanguageCode__ISO_639_1_cu:
    case T_e16_ISOLanguageCode__ISO_639_1_cv:
    case T_e16_ISOLanguageCode__ISO_639_1_cy:
    case T_e16_ISOLanguageCode__ISO_639_1_da:
    case T_e16_ISOLanguageCode__ISO_639_1_de:
    case T_e16_ISOLanguageCode__ISO_639_1_dv:
    case T_e16_ISOLanguageCode__ISO_639_1_dz:
    case T_e16_ISOLanguageCode__ISO_639_1_ee:
    case T_e16_ISOLanguageCode__ISO_639_1_eg:
    case T_e16_ISOLanguageCode__ISO_639_1_el:
    case T_e16_ISOLanguageCode__ISO_639_1_en:
    case T_e16_ISOLanguageCode__ISO_639_1_eo:
    case T_e16_ISOLanguageCode__ISO_639_1_es:
    case T_e16_ISOLanguageCode__ISO_639_1_et:
    case T_e16_ISOLanguageCode__ISO_639_1_eu:
    case T_e16_ISOLanguageCode__ISO_639_1_fa:
    case T_e16_ISOLanguageCode__ISO_639_1_ff:
    case T_e16_ISOLanguageCode__ISO_639_1_fi:
    case T_e16_ISOLanguageCode__ISO_639_1_fj:
    case T_e16_ISOLanguageCode__ISO_639_1_fo:
    case T_e16_ISOLanguageCode__ISO_639_1_fr:
    case T_e16_ISOLanguageCode__ISO_639_1_fy:
    case T_e16_ISOLanguageCode__ISO_639_1_ga:
    case T_e16_ISOLanguageCode__ISO_639_1_gd:
    case T_e16_ISOLanguageCode__ISO_639_1_gl:
    case T_e16_ISOLanguageCode__ISO_639_1_gn:
    case T_e16_ISOLanguageCode__ISO_639_1_gu:
    case T_e16_ISOLanguageCode__ISO_639_1_gv:
    case T_e16_ISOLanguageCode__ISO_639_1_ha:
    case T_e16_ISOLanguageCode__ISO_639_1_he:
    case T_e16_ISOLanguageCode__ISO_639_1_hi:
    case T_e16_ISOLanguageCode__ISO_639_1_ho:
    case T_e16_ISOLanguageCode__ISO_639_1_hr:
    case T_e16_ISOLanguageCode__ISO_639_1_hu:
    case T_e16_ISOLanguageCode__ISO_639_1_hy:
    case T_e16_ISOLanguageCode__ISO_639_1_hz:
    case T_e16_ISOLanguageCode__ISO_639_1_ia:
    case T_e16_ISOLanguageCode__ISO_639_1_id:
    case T_e16_ISOLanguageCode__ISO_639_1_ie:
    case T_e16_ISOLanguageCode__ISO_639_1_ig:
    case T_e16_ISOLanguageCode__ISO_639_1_ii:
    case T_e16_ISOLanguageCode__ISO_639_1_ik:
    case T_e16_ISOLanguageCode__ISO_639_1_io:
    case T_e16_ISOLanguageCode__ISO_639_1_is:
    case T_e16_ISOLanguageCode__ISO_639_1_it:
    case T_e16_ISOLanguageCode__ISO_639_1_iu:
    case T_e16_ISOLanguageCode__ISO_639_1_ja:
    case T_e16_ISOLanguageCode__ISO_639_1_jv:
    case T_e16_ISOLanguageCode__ISO_639_1_ka:
    case T_e16_ISOLanguageCode__ISO_639_1_kg:
    case T_e16_ISOLanguageCode__ISO_639_1_ki:
    case T_e16_ISOLanguageCode__ISO_639_1_kj:
    case T_e16_ISOLanguageCode__ISO_639_1_kk:
    case T_e16_ISOLanguageCode__ISO_639_1_kl:
    case T_e16_ISOLanguageCode__ISO_639_1_km:
    case T_e16_ISOLanguageCode__ISO_639_1_kn:
    case T_e16_ISOLanguageCode__ISO_639_1_ko:
    case T_e16_ISOLanguageCode__ISO_639_1_kr:
    case T_e16_ISOLanguageCode__ISO_639_1_ks:
    case T_e16_ISOLanguageCode__ISO_639_1_ku:
    case T_e16_ISOLanguageCode__ISO_639_1_kv:
    case T_e16_ISOLanguageCode__ISO_639_1_kw:
    case T_e16_ISOLanguageCode__ISO_639_1_ky:
    case T_e16_ISOLanguageCode__ISO_639_1_la:
    case T_e16_ISOLanguageCode__ISO_639_1_lb:
    case T_e16_ISOLanguageCode__ISO_639_1_lg:
    case T_e16_ISOLanguageCode__ISO_639_1_li:
    case T_e16_ISOLanguageCode__ISO_639_1_ln:
    case T_e16_ISOLanguageCode__ISO_639_1_lo:
    case T_e16_ISOLanguageCode__ISO_639_1_lt:
    case T_e16_ISOLanguageCode__ISO_639_1_lu:
    case T_e16_ISOLanguageCode__ISO_639_1_lv:
    case T_e16_ISOLanguageCode__ISO_639_1_mc:
    case T_e16_ISOLanguageCode__ISO_639_1_mg:
    case T_e16_ISOLanguageCode__ISO_639_1_mh:
    case T_e16_ISOLanguageCode__ISO_639_1_mi:
    case T_e16_ISOLanguageCode__ISO_639_1_mk:
    case T_e16_ISOLanguageCode__ISO_639_1_ml:
    case T_e16_ISOLanguageCode__ISO_639_1_mn:
    case T_e16_ISOLanguageCode__ISO_639_1_mo:
    case T_e16_ISOLanguageCode__ISO_639_1_mr:
    case T_e16_ISOLanguageCode__ISO_639_1_ms:
    case T_e16_ISOLanguageCode__ISO_639_1_mt:
    case T_e16_ISOLanguageCode__ISO_639_1_my:
    case T_e16_ISOLanguageCode__ISO_639_1_na:
    case T_e16_ISOLanguageCode__ISO_639_1_nb:
    case T_e16_ISOLanguageCode__ISO_639_1_nd:
    case T_e16_ISOLanguageCode__ISO_639_1_ne:
    case T_e16_ISOLanguageCode__ISO_639_1_ng:
    case T_e16_ISOLanguageCode__ISO_639_1_nl:
    case T_e16_ISOLanguageCode__ISO_639_1_nn:
    case T_e16_ISOLanguageCode__ISO_639_1_no:
    case T_e16_ISOLanguageCode__ISO_639_1_nr:
    case T_e16_ISOLanguageCode__ISO_639_1_nv:
    case T_e16_ISOLanguageCode__ISO_639_1_ny:
    case T_e16_ISOLanguageCode__ISO_639_1_oc:
    case T_e16_ISOLanguageCode__ISO_639_1_oj:
    case T_e16_ISOLanguageCode__ISO_639_1_om:
    case T_e16_ISOLanguageCode__ISO_639_1_or:
    case T_e16_ISOLanguageCode__ISO_639_1_os:
    case T_e16_ISOLanguageCode__ISO_639_1_pa:
    case T_e16_ISOLanguageCode__ISO_639_1_pi:
    case T_e16_ISOLanguageCode__ISO_639_1_pl:
    case T_e16_ISOLanguageCode__ISO_639_1_ps:
    case T_e16_ISOLanguageCode__ISO_639_1_pt:
    case T_e16_ISOLanguageCode__ISO_639_1_qu:
    case T_e16_ISOLanguageCode__ISO_639_1_rm:
    case T_e16_ISOLanguageCode__ISO_639_1_rn:
    case T_e16_ISOLanguageCode__ISO_639_1_ro:
    case T_e16_ISOLanguageCode__ISO_639_1_rt:
    case T_e16_ISOLanguageCode__ISO_639_1_ru:
    case T_e16_ISOLanguageCode__ISO_639_1_rw:
    case T_e16_ISOLanguageCode__ISO_639_1_sa:
    case T_e16_ISOLanguageCode__ISO_639_1_sb:
    case T_e16_ISOLanguageCode__ISO_639_1_sc:
    case T_e16_ISOLanguageCode__ISO_639_1_sd:
    case T_e16_ISOLanguageCode__ISO_639_1_se:
    case T_e16_ISOLanguageCode__ISO_639_1_sg:
    case T_e16_ISOLanguageCode__ISO_639_1_sh:
    case T_e16_ISOLanguageCode__ISO_639_1_si:
    case T_e16_ISOLanguageCode__ISO_639_1_sk:
    case T_e16_ISOLanguageCode__ISO_639_1_sl:
    case T_e16_ISOLanguageCode__ISO_639_1_sm:
    case T_e16_ISOLanguageCode__ISO_639_1_sn:
    case T_e16_ISOLanguageCode__ISO_639_1_so:
    case T_e16_ISOLanguageCode__ISO_639_1_sq:
    case T_e16_ISOLanguageCode__ISO_639_1_sr:
    case T_e16_ISOLanguageCode__ISO_639_1_ss:
    case T_e16_ISOLanguageCode__ISO_639_1_st:
    case T_e16_ISOLanguageCode__ISO_639_1_su:
    case T_e16_ISOLanguageCode__ISO_639_1_sv:
    case T_e16_ISOLanguageCode__ISO_639_1_sw:
    case T_e16_ISOLanguageCode__ISO_639_1_sx:
    case T_e16_ISOLanguageCode__ISO_639_1_ta:
    case T_e16_ISOLanguageCode__ISO_639_1_te:
    case T_e16_ISOLanguageCode__ISO_639_1_tg:
    case T_e16_ISOLanguageCode__ISO_639_1_th:
    case T_e16_ISOLanguageCode__ISO_639_1_ti:
    case T_e16_ISOLanguageCode__ISO_639_1_tk:
    case T_e16_ISOLanguageCode__ISO_639_1_tl:
    case T_e16_ISOLanguageCode__ISO_639_1_tn:
    case T_e16_ISOLanguageCode__ISO_639_1_to:
    case T_e16_ISOLanguageCode__ISO_639_1_tr:
    case T_e16_ISOLanguageCode__ISO_639_1_ts:
    case T_e16_ISOLanguageCode__ISO_639_1_tt:
    case T_e16_ISOLanguageCode__ISO_639_1_tw:
    case T_e16_ISOLanguageCode__ISO_639_1_ty:
    case T_e16_ISOLanguageCode__ISO_639_1_ue:
    case T_e16_ISOLanguageCode__ISO_639_1_ug:
    case T_e16_ISOLanguageCode__ISO_639_1_uk:
    case T_e16_ISOLanguageCode__ISO_639_1_ul:
    case T_e16_ISOLanguageCode__ISO_639_1_ur:
    case T_e16_ISOLanguageCode__ISO_639_1_uz:
    case T_e16_ISOLanguageCode__ISO_639_1_va:
    case T_e16_ISOLanguageCode__ISO_639_1_ve:
    case T_e16_ISOLanguageCode__ISO_639_1_vi:
    case T_e16_ISOLanguageCode__ISO_639_1_vo:
    case T_e16_ISOLanguageCode__ISO_639_1_wa:
    case T_e16_ISOLanguageCode__ISO_639_1_wo:
    case T_e16_ISOLanguageCode__ISO_639_1_xh:
    case T_e16_ISOLanguageCode__ISO_639_1_yi:
    case T_e16_ISOLanguageCode__ISO_639_1_yo:
    case T_e16_ISOLanguageCode__ISO_639_1_za:
    case T_e16_ISOLanguageCode__ISO_639_1_zh:
    case T_e16_ISOLanguageCode__ISO_639_1_zl:
    case T_e16_ISOLanguageCode__ISO_639_1_zu:
        return true;
    default:
        return false;
    }
}

bool T_e8_FuelType_Parse (const char *str, size_t length, T_e8_FuelType &value)
{
    static stringEntry entries[] = {
        {6,"DIESEL", 2U},
        {6,"PETROL", 1U},
        {8,"HYDROGEN", 3U},
        {8,"RESERVED", 0U},
        {20,"COMPRESSEDNATURALGAS", 4U},
        {21,"LIQUIFIEDPETROLEUMGAS", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_FuelType_Name (T_e8_FuelType value)
{
    static const char* enumerationLiterals[] = {
        "Reserved",
        "Petrol",
        "Diesel",
        "Hydrogen",
        "CompressedNaturalGas",
        "LiquifiedPetroleumGas",
    };

    if (T_e8_FuelType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_FuelType_IsValid (T_e8_FuelType value)
{
    switch (value) {
    case T_e8_FuelType__Reserved:
    case T_e8_FuelType__Petrol:
    case T_e8_FuelType__Diesel:
    case T_e8_FuelType__Hydrogen:
    case T_e8_FuelType__CompressedNaturalGas:
    case T_e8_FuelType__LiquifiedPetroleumGas:
        return true;
    default:
        return false;
    }
}

} // namespace fi_types
