/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_MOVIES_MAIN_FIPROXY_H
#define SXM_MOVIES_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_movies_main_fi.h"
#include <string>

namespace sxm_movies_main_fi {

class Sxm_movies_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class GetMovieInfoCallbackIF {
public:
    virtual ~GetMovieInfoCallbackIF() {}

    virtual void onGetMovieInfoError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMovieInfoError >& error) = 0;

    virtual void onGetMovieInfoResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMovieInfoResult >& result) = 0;
};

class GetMoviesListCallbackIF {
public:
    virtual ~GetMoviesListCallbackIF() {}

    virtual void onGetMoviesListError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMoviesListError >& error) = 0;

    virtual void onGetMoviesListResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMoviesListResult >& result) = 0;
};

class GetTheatreInfoCallbackIF {
public:
    virtual ~GetTheatreInfoCallbackIF() {}

    virtual void onGetTheatreInfoError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTheatreInfoError >& error) = 0;

    virtual void onGetTheatreInfoResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTheatreInfoResult >& result) = 0;
};

class GetTheatreListCallbackIF {
public:
    virtual ~GetTheatreListCallbackIF() {}

    virtual void onGetTheatreListError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTheatreListError >& error) = 0;

    virtual void onGetTheatreListResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTheatreListResult >& result) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class SearchMovieCallbackIF {
public:
    virtual ~SearchMovieCallbackIF() {}

    virtual void onSearchMovieError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SearchMovieError >& error) = 0;

    virtual void onSearchMovieResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SearchMovieResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class TheatreListsStatusCallbackIF {
public:
    virtual ~TheatreListsStatusCallbackIF() {}

    virtual void onTheatreListsStatusError(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< TheatreListsStatusError >& error) = 0;

    virtual void onTheatreListsStatusStatus(const ::boost::shared_ptr< Sxm_movies_main_fiProxy >& proxy, const ::boost::shared_ptr< TheatreListsStatusStatus >& status) = 0;
};

class Sxm_movies_main_fiProxyCallback;

/**
 * Sxm_movies_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_movies_main_fi' (specified in file
 * sxm_movies_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_movies_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Movies
 *
 * Version: $Revision:   0.2  $
 *
 * Author: Narasimhulu Kavadapu
 *
 * Date: $Date:   Feb 14 2013  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_movies_main_fi
 *
 * <b>Description of 'sxm_movies_main_fi':</b>
 *
 * RBEI
 */
class Sxm_movies_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_movies_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_movies_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_movies_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_movies_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_movies_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_movies_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_movies_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_movies_main_fiProxy();

    // Method 'GetTheatreList'

    /**
     * Call the method 'GetTheatreList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetTheatreList'</b>:
     *
     * This method is used to get list of theaters containing theater name and other details.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID Theatre type information to filter theatre info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param Operation Operation to be performed
     *
     * @param MovieID To get theatre list playing particular movie.
     * MovieID shall be zero , for complete theater list.
     *
     * @param SearchString To get theater list containing "SearchString".
     * SearchString shall be used for "SearchTheaters" case
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTheatreListStart(GetTheatreListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, uint32 movieID, const ::std::string& searchString);

    // Method 'GetTheatreInfo'

    /**
     * Call the method 'GetTheatreInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetTheatreInfo'</b>:
     *
     * Get complete details of particular theater.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param THEATRE_LOCID Theatre Location ID
     *
     * @param ListID Theatre Location Type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTheatreInfoStart(GetTheatreInfoCallbackIF& cb, uint32 tHEATRE_LOCID, uint32 listID);

    // Method 'GetMoviesList'

    /**
     * Call the method 'GetMoviesList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetMoviesList'</b>:
     *
     * This method is used to get list of movies containing movie name and other required details.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID Movie information to filter movie info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param Theater_LOCID here Theater_LOCID implies a theater location ID to get movies list of particular theater.
     * for complete movies list,Theater_LOCID should be zero.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetMoviesListStart(GetMoviesListCallbackIF& cb, uint32 listID, uint32 theater_LOCID);

    // Method 'GetMovieInfo'

    /**
     * Call the method 'GetMovieInfo'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetMovieInfo'</b>:
     *
     * Get complete details of particular theater.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MOVIE_ID Movie ID
     *
     * @param ListID Theatre Location Type in which movie is playing
     *
     * @param Theater_LOCID here Theater_LOCID implies a theater location ID to get movies details if playing in particular theater.
     * for particular movie detials(i.e MOVI_ID) playing in any theatre ,Theater_LOCID should be zero.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetMovieInfoStart(GetMovieInfoCallbackIF& cb, uint32 mOVIE_ID, uint32 listID, uint32 theater_LOCID);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method is used to add a Theatre
     * to favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Theater_LOCID Theatre Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 theater_LOCID);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method is used to Remove Theatre
     * from favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Theater_LOCID Theatre Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 theater_LOCID);

    // Method 'SearchMovie'

    /**
     * Call the method 'SearchMovie'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SearchMovie'</b>:
     *
     * This method is used to get list of movies containing used typed string.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param MovieName Name of the movie user want to search for.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSearchMovieStart(SearchMovieCallbackIF& cb, const ::std::string& movieName);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure theatre lists.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Generic configuration for all lists of Theatres
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Property 'TheatreListsStatus'

    /**
     * Notify on the property 'TheatreListsStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TheatreListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTheatreListsStatusUpReg(TheatreListsStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TheatreListsStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TheatreListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param act The act which was previously returned by the
     * sendTheatreListsStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTheatreListsStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TheatreListsStatus'.
     */
    void sendTheatreListsStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'TheatreListsStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTheatreListsStatus() returns true.
     *
     * @return the previously received value of the property 'TheatreListsStatus'.
     */
    const TheatreListsStatusStatus& getTheatreListsStatus() const;

    /**
     * Determines whether a status message for the property 'TheatreListsStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTheatreListsStatus() const;

    /**
     * Request the value of the property 'TheatreListsStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TheatreListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTheatreListsStatusGet(TheatreListsStatusCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Movies Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Movies Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Movies Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Movies List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Movies List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Movies List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Movies List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_movies_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'TheatreListsStatus'

    ::asf::core::nullable< TheatreListsStatusStatus > _theatreListsStatus;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_movies_main_fiProxyCallback;
};

} // namespace sxm_movies_main_fi

#endif // SXM_MOVIES_MAIN_FIPROXY_H
