/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_movies_main_fiCca.h"
#include "sxm_movies_main_fiJson.h"
#include "sxm_movies_main_fiProxy.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_movies_main_fi {

/*static*/ ::asf::core::Logger Sxm_movies_main_fiProxy::_logger ("/sxm_movies_main_fi/Sxm_movies_main_fiProxy");


class Sxm_movies_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_movies_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_movies_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_movies_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetTheatreList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetTheatreListResult);
                                setActAndLogResult(message, "GetTheatreList", reinterpret_cast<act_t>(this), _logger);
                                ((GetTheatreListCallbackIF*) _callback)->onGetTheatreListResult (proxy, ::boost::static_pointer_cast<GetTheatreListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetTheatreListError);
                                setActAndLogError(message, "GetTheatreList", reinterpret_cast<act_t>(this), _logger);
                                ((GetTheatreListCallbackIF*) _callback)->onGetTheatreListError (proxy, ::boost::static_pointer_cast<GetTheatreListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetTheatreInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetTheatreInfoResult);
                                setActAndLogResult(message, "GetTheatreInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetTheatreInfoCallbackIF*) _callback)->onGetTheatreInfoResult (proxy, ::boost::static_pointer_cast<GetTheatreInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetTheatreInfoError);
                                setActAndLogError(message, "GetTheatreInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetTheatreInfoCallbackIF*) _callback)->onGetTheatreInfoError (proxy, ::boost::static_pointer_cast<GetTheatreInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetMoviesList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetMoviesListResult);
                                setActAndLogResult(message, "GetMoviesList", reinterpret_cast<act_t>(this), _logger);
                                ((GetMoviesListCallbackIF*) _callback)->onGetMoviesListResult (proxy, ::boost::static_pointer_cast<GetMoviesListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetMoviesListError);
                                setActAndLogError(message, "GetMoviesList", reinterpret_cast<act_t>(this), _logger);
                                ((GetMoviesListCallbackIF*) _callback)->onGetMoviesListError (proxy, ::boost::static_pointer_cast<GetMoviesListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetMovieInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetMovieInfoResult);
                                setActAndLogResult(message, "GetMovieInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetMovieInfoCallbackIF*) _callback)->onGetMovieInfoResult (proxy, ::boost::static_pointer_cast<GetMovieInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::GetMovieInfoError);
                                setActAndLogError(message, "GetMovieInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetMovieInfoCallbackIF*) _callback)->onGetMovieInfoError (proxy, ::boost::static_pointer_cast<GetMovieInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AddFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::AddFavoriteResult);
                                setActAndLogResult(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteResult (proxy, ::boost::static_pointer_cast<AddFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::AddFavoriteError);
                                setActAndLogError(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, ::boost::static_pointer_cast<AddFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RemoveFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::RemoveFavoriteResult);
                                setActAndLogResult(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteResult (proxy, ::boost::static_pointer_cast<RemoveFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::RemoveFavoriteError);
                                setActAndLogError(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, ::boost::static_pointer_cast<RemoveFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SearchMovie: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SearchMovieResult);
                                setActAndLogResult(message, "SearchMovie", reinterpret_cast<act_t>(this), _logger);
                                ((SearchMovieCallbackIF*) _callback)->onSearchMovieResult (proxy, ::boost::static_pointer_cast<SearchMovieResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SearchMovieError);
                                setActAndLogError(message, "SearchMovie", reinterpret_cast<act_t>(this), _logger);
                                ((SearchMovieCallbackIF*) _callback)->onSearchMovieError (proxy, ::boost::static_pointer_cast<SearchMovieError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetListsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SetListsConfigResult);
                                setActAndLogResult(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigResult (proxy, ::boost::static_pointer_cast<SetListsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SetListsConfigError);
                                setActAndLogError(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, ::boost::static_pointer_cast<SetListsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TheatreListsStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::TheatreListsStatusStatus);
                                setActAndLogStatus(message, "TheatreListsStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TheatreListsStatusStatus> payload = ::boost::static_pointer_cast<TheatreListsStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TheatreListsStatusStatus >& refNullableStatus = proxy->_theatreListsStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TheatreListsStatusCallbackIF*) _callback)->onTheatreListsStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TheatreListsStatusCallbackIF*) _callback)->onTheatreListsStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::TheatreListsStatusError);
                                setActAndLogError(message, "TheatreListsStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TheatreListsStatusCallbackIF*) _callback)->onTheatreListsStatusError(proxy, ::boost::static_pointer_cast<TheatreListsStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmDataServiceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SxmDataServiceStatusStatus);
                                setActAndLogStatus(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmDataServiceStatusStatus> payload = ::boost::static_pointer_cast<SxmDataServiceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmDataServiceStatusStatus >& refNullableStatus = proxy->_sxmDataServiceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SxmDataServiceStatusError);
                                setActAndLogError(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError(proxy, ::boost::static_pointer_cast<SxmDataServiceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmListMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SxmListModeStatus);
                                setActAndLogStatus(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmListModeStatus> payload = ::boost::static_pointer_cast<SxmListModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmListModeStatus >& refNullableStatus = proxy->_sxmListMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_movies_main_fi::SxmListModeError);
                                setActAndLogError(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError(proxy, ::boost::static_pointer_cast<SxmListModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_movies_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_movies_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetTheatreList: {
                ::boost::shared_ptr< GetTheatreListError > payload (new GetTheatreListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTheatreList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetTheatreListCallbackIF*) _callback)->onGetTheatreListError (proxy, payload);
                return true;
            }
            case FID_GetTheatreInfo: {
                ::boost::shared_ptr< GetTheatreInfoError > payload (new GetTheatreInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTheatreInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetTheatreInfoCallbackIF*) _callback)->onGetTheatreInfoError (proxy, payload);
                return true;
            }
            case FID_GetMoviesList: {
                ::boost::shared_ptr< GetMoviesListError > payload (new GetMoviesListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetMoviesList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetMoviesListCallbackIF*) _callback)->onGetMoviesListError (proxy, payload);
                return true;
            }
            case FID_GetMovieInfo: {
                ::boost::shared_ptr< GetMovieInfoError > payload (new GetMovieInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetMovieInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetMovieInfoCallbackIF*) _callback)->onGetMovieInfoError (proxy, payload);
                return true;
            }
            case FID_AddFavorite: {
                ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, payload);
                return true;
            }
            case FID_RemoveFavorite: {
                ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, payload);
                return true;
            }
            case FID_SearchMovie: {
                ::boost::shared_ptr< SearchMovieError > payload (new SearchMovieError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SearchMovie", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SearchMovieCallbackIF*) _callback)->onSearchMovieError (proxy, payload);
                return true;
            }
            case FID_SetListsConfig: {
                ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetListsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, payload);
                return true;
            }
            case FID_TheatreListsStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TheatreListsStatusError > payload (new TheatreListsStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TheatreListsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TheatreListsStatusCallbackIF*) _callback)->onTheatreListsStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmDataServiceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmListMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmListMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_movies_main_fiProxyCallback::_logger (Sxm_movies_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_movies_main_fiProxy > Sxm_movies_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_movies_main_fiProxy >  proxyNew(new Sxm_movies_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_movies_main_fiProxy > Sxm_movies_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_movies_main_fiProxy >  proxyNew(new Sxm_movies_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_movies_main_fiProxy > Sxm_movies_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_movies_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_movies_main_fiProxy >  proxyNew(new Sxm_movies_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_movies_main_fiProxy::Sxm_movies_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_movies_main_fiProxy::~Sxm_movies_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_movies_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_movies_main_fiProxy::sendGetTheatreListStart(GetTheatreListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, uint32 movieID, const ::std::string& searchString) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetTheatreList);
        ::boost::shared_ptr< GetTheatreListStart > payload (new GetTheatreListStart());
        payload->setListID(listID);
        payload->setOperation(operation);
        payload->setMovieID(movieID);
        payload->setSearchString(searchString);
        CCA_MESSAGE(ccaMessage,header,GetTheatreListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetTheatreList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetTheatreList);
        ::boost::shared_ptr< GetTheatreListError > payload (new GetTheatreListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetTheatreListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetTheatreList", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendGetTheatreInfoStart(GetTheatreInfoCallbackIF& cb, uint32 tHEATRE_LOCID, uint32 listID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetTheatreInfo);
        ::boost::shared_ptr< GetTheatreInfoStart > payload (new GetTheatreInfoStart());
        payload->setTHEATRE_LOCID(tHEATRE_LOCID);
        payload->setListID(listID);
        CCA_MESSAGE(ccaMessage,header,GetTheatreInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetTheatreInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetTheatreInfo);
        ::boost::shared_ptr< GetTheatreInfoError > payload (new GetTheatreInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetTheatreInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetTheatreInfo", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendGetMoviesListStart(GetMoviesListCallbackIF& cb, uint32 listID, uint32 theater_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetMoviesList);
        ::boost::shared_ptr< GetMoviesListStart > payload (new GetMoviesListStart());
        payload->setListID(listID);
        payload->setTheater_LOCID(theater_LOCID);
        CCA_MESSAGE(ccaMessage,header,GetMoviesListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetMoviesList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetMoviesList);
        ::boost::shared_ptr< GetMoviesListError > payload (new GetMoviesListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetMoviesListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetMoviesList", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendGetMovieInfoStart(GetMovieInfoCallbackIF& cb, uint32 mOVIE_ID, uint32 listID, uint32 theater_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetMovieInfo);
        ::boost::shared_ptr< GetMovieInfoStart > payload (new GetMovieInfoStart());
        payload->setMOVIE_ID(mOVIE_ID);
        payload->setListID(listID);
        payload->setTheater_LOCID(theater_LOCID);
        CCA_MESSAGE(ccaMessage,header,GetMovieInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetMovieInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetMovieInfo);
        ::boost::shared_ptr< GetMovieInfoError > payload (new GetMovieInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetMovieInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetMovieInfo", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 theater_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteStart > payload (new AddFavoriteStart());
        payload->setTheater_LOCID(theater_LOCID);
        CCA_MESSAGE(ccaMessage,header,AddFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AddFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AddFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AddFavorite", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 theater_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteStart > payload (new RemoveFavoriteStart());
        payload->setTheater_LOCID(theater_LOCID);
        CCA_MESSAGE(ccaMessage,header,RemoveFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RemoveFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoveFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RemoveFavorite", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendSearchMovieStart(SearchMovieCallbackIF& cb, const ::std::string& movieName) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SearchMovie);
        ::boost::shared_ptr< SearchMovieStart > payload (new SearchMovieStart());
        payload->setMovieName(movieName);
        CCA_MESSAGE(ccaMessage,header,SearchMovieStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SearchMovie", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SearchMovie);
        ::boost::shared_ptr< SearchMovieError > payload (new SearchMovieError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SearchMovieError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SearchMovie", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigStart > payload (new SetListsConfigStart());
        payload->setConfig(config);
        CCA_MESSAGE(ccaMessage,header,SetListsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetListsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetListsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetListsConfig", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendTheatreListsStatusUpReg(TheatreListsStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TheatreListsStatus);
        ::boost::shared_ptr< TheatreListsStatusUpReg > payload (new TheatreListsStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,TheatreListsStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TheatreListsStatusRelUpReg > payloadRelUpRegHeap (new TheatreListsStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TheatreListsStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_movies_main_fi::TheatreListsStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TheatreListsStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TheatreListsStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TheatreListsStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTheatreListsStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TheatreListsStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TheatreListsStatusStatus > payloadLoopback (new TheatreListsStatusStatus(getTheatreListsStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TheatreListsStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TheatreListsStatus);
        ::boost::shared_ptr< TheatreListsStatusError > payload (new TheatreListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TheatreListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TheatreListsStatus", &cb);
    }
}

bool Sxm_movies_main_fiProxy::sendTheatreListsStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TheatreListsStatus,"TheatreListsStatus");
}

void Sxm_movies_main_fiProxy::sendTheatreListsStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TheatreListsStatus);
}

const TheatreListsStatusStatus& Sxm_movies_main_fiProxy::getTheatreListsStatus() const {
    return _theatreListsStatus.get();
}

bool Sxm_movies_main_fiProxy::hasTheatreListsStatus() const {
    return _theatreListsStatus.hasValue();
}

act_t Sxm_movies_main_fiProxy::sendTheatreListsStatusGet(TheatreListsStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TheatreListsStatus);
        ::boost::shared_ptr< TheatreListsStatusGet > payload (new TheatreListsStatusGet());
        CCA_MESSAGE(ccaMessage,header,TheatreListsStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TheatreListsStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TheatreListsStatus);
        ::boost::shared_ptr< TheatreListsStatusError > payload (new TheatreListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TheatreListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TheatreListsStatus", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusUpReg > payload (new SxmDataServiceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmDataServiceStatusRelUpReg > payloadRelUpRegHeap (new SxmDataServiceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmDataServiceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_movies_main_fi::SxmDataServiceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmDataServiceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmDataServiceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmDataServiceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmDataServiceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmDataServiceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmDataServiceStatusStatus > payloadLoopback (new SxmDataServiceStatusStatus(getSxmDataServiceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmDataServiceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

bool Sxm_movies_main_fiProxy::sendSxmDataServiceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmDataServiceStatus,"SxmDataServiceStatus");
}

void Sxm_movies_main_fiProxy::sendSxmDataServiceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmDataServiceStatus);
}

const SxmDataServiceStatusStatus& Sxm_movies_main_fiProxy::getSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.get();
}

bool Sxm_movies_main_fiProxy::hasSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.hasValue();
}

act_t Sxm_movies_main_fiProxy::sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusGet > payload (new SxmDataServiceStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmDataServiceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

act_t Sxm_movies_main_fiProxy::sendSxmListModeUpReg(SxmListModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeUpReg > payload (new SxmListModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmListModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmListModeRelUpReg > payloadRelUpRegHeap (new SxmListModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmListMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_movies_main_fi::SxmListModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmListMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmListMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmListMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmListMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmListMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmListModeStatus > payloadLoopback (new SxmListModeStatus(getSxmListMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmListModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmListMode", &cb);
    }
}

bool Sxm_movies_main_fiProxy::sendSxmListModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmListMode,"SxmListMode");
}

void Sxm_movies_main_fiProxy::sendSxmListModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmListMode);
}

const SxmListModeStatus& Sxm_movies_main_fiProxy::getSxmListMode() const {
    return _sxmListMode.get();
}

bool Sxm_movies_main_fiProxy::hasSxmListMode() const {
    return _sxmListMode.hasValue();
}

act_t Sxm_movies_main_fiProxy::sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeSet > payload (new SxmListModeSet());
        payload->setListMode(listMode);
        CCA_MESSAGE(ccaMessage,header,SxmListModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SxmListMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SxmListMode", &cb);
    }
}


void Sxm_movies_main_fiProxy::clearAllProperties ()
{
    _theatreListsStatus = ::asf::core::nullable<TheatreListsStatusStatus>();
    _sxmDataServiceStatus = ::asf::core::nullable<SxmDataServiceStatusStatus>();
    _sxmListMode = ::asf::core::nullable<SxmListModeStatus>();
}

void Sxm_movies_main_fiProxy::sendRelUpRegAll()
{
    sendTheatreListsStatusRelUpRegAll();
    sendSxmDataServiceStatusRelUpRegAll();
    sendSxmListModeRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_movies_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_movies_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_movies_main_fi
