/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "sxm_fuel_main_fi_types.h"
#include "sxm_fuel_main_fi_typesCca.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_typesCca.h"
#include <string>
#include <vector>


void serializeCca(const ::sxm_fuel_main_fi_types::T_FuelInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStationName();
    out << in.getBrand();
    out << (uint8) in.getFuelType();
    out << in.getFuel_LOCID();
    out << in.getFuelName();
    out << in.getFuelPrice();
    out << in.getFuelAge();
    serializeCca(in.getFuelLoc(), out, majorVersion);
    out << in.getFuelDistKm();
    out << in.getFuelDistMile();
    out << in.getNumPrices();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_fuel_main_fi_types::T_FuelInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o0;
    in >> o0;
    out.setStationName(o0);
    ::std::string o1;
    in >> o1;
    out.setBrand(o1);
    uint8 o2;
    in >> o2;
    out.setFuelType((::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum)o2);
    uint32 o3;
    in >> o3;
    out.setFuel_LOCID(o3);
    ::std::string o4;
    in >> o4;
    out.setFuelName(o4);
    ::std::string o5;
    in >> o5;
    out.setFuelPrice(o5);
    uint8 o6;
    in >> o6;
    out.setFuelAge(o6);
    deserializeCca(in, out.getFuelLocMutable(), majorVersion);
    float o7;
    in >> o7;
    out.setFuelDistKm(o7);
    float o8;
    in >> o8;
    out.setFuelDistMile(o8);
    uint32 o9;
    in >> o9;
    out.setNumPrices(o9);
}

void serializeCca(const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getFuelType();
    out << in.getFuelName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_fuel_main_fi_types::T_FuelTypeInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o10;
    in >> o10;
    out.setFuelType((::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum)o10);
    ::std::string o11;
    in >> o11;
    out.setFuelName(o11);
}

void serializeCca(const ::sxm_fuel_main_fi_types::T_FuelTypeInfolist& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getFuelName();
    out << in.getFuelPrice();
    out << in.getFuelAge();
    out << (uint8) in.getFuelAvail();
    out << (uint8) in.getFuelType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_fuel_main_fi_types::T_FuelTypeInfolist& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o12;
    in >> o12;
    out.setFuelName(o12);
    ::std::string o13;
    in >> o13;
    out.setFuelPrice(o13);
    uint8 o14;
    in >> o14;
    out.setFuelAge(o14);
    bool o15;
    in >> o15;
    out.setFuelAvail(o15);
    uint8 o16;
    in >> o16;
    out.setFuelType((::sxm_fuel_main_fi_types::T_e8_FuelTypeEnum)o16);
}

void serializeCca(const ::sxm_fuel_main_fi_types::T_FuelStationInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStationName();
    out << in.getBrand();
    out << in.getStreetName();
    out << in.getCity();
    out << in.getState();
    out << in.getZipCode();
    out << in.getPhone();
    out << in.getFuel_LOCID();
    out << in.getAmenity();
    out << (uint8) in.getFuelFavInfo();
    serializeCca(in.getFuelLocation(), out, majorVersion);
    {
        uint32 o17 = static_cast<uint32>(in.getFuelTypelist().size());
        out << o17;
        ::std::vector< ::sxm_fuel_main_fi_types::T_FuelTypeInfolist >::const_iterator o18;
        for (o18 = in.getFuelTypelist().begin(); o18 != in.getFuelTypelist().end(); ++o18) {
            serializeCca((*o18), out, majorVersion);
        }
    }
    {
        uint32 o19 = static_cast<uint32>(in.getStationAmenitylist().size());
        out << o19;
        ::std::vector< ::sxm_fuel_main_fi_types::T_e8_FuelStationAmenity >::const_iterator o20;
        for (o20 = in.getStationAmenitylist().begin(); o20 != in.getStationAmenitylist().end(); ++o20) {
            out << (uint8) (*o20);
        }
    }
    out << in.getNumPrices();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_fuel_main_fi_types::T_FuelStationInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o21;
    in >> o21;
    out.setStationName(o21);
    ::std::string o22;
    in >> o22;
    out.setBrand(o22);
    ::std::string o23;
    in >> o23;
    out.setStreetName(o23);
    ::std::string o24;
    in >> o24;
    out.setCity(o24);
    ::std::string o25;
    in >> o25;
    out.setState(o25);
    ::std::string o26;
    in >> o26;
    out.setZipCode(o26);
    ::std::string o27;
    in >> o27;
    out.setPhone(o27);
    uint32 o28;
    in >> o28;
    out.setFuel_LOCID(o28);
    ::std::string o29;
    in >> o29;
    out.setAmenity(o29);
    bool o30;
    in >> o30;
    out.setFuelFavInfo(o30);
    deserializeCca(in, out.getFuelLocationMutable(), majorVersion);
    {
        uint32 o31;
        in >> o31;
        out.getFuelTypelistMutable().clear ();
        out.getFuelTypelistMutable().reserve (o31);
        for (uint32 o32 = 0; o32 < o31; o32++) {
            ::sxm_fuel_main_fi_types::T_FuelTypeInfolist o33;
            deserializeCca(in, o33, majorVersion);
            out.getFuelTypelistMutable().push_back (o33);
        }
    }
    {
        uint32 o34;
        in >> o34;
        out.getStationAmenitylistMutable().clear ();
        out.getStationAmenitylistMutable().reserve (o34);
        for (uint32 o35 = 0; o35 < o34; o35++) {
            uint8 o36;
            in >> o36;
            out.getStationAmenitylistMutable().push_back((::sxm_fuel_main_fi_types::T_e8_FuelStationAmenity) o36);
        }
    }
    uint32 o37;
    in >> o37;
    out.setNumPrices(o37);
}

