/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_FUEL_MAIN_FIPROXY_H
#define SXM_FUEL_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_fuel_main_fi.h"
#include "sxm_fuel_main_fi_types.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <string>

namespace sxm_fuel_main_fi {

class Sxm_fuel_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class FuelBrandNameListCallbackIF {
public:
    virtual ~FuelBrandNameListCallbackIF() {}

    virtual void onFuelBrandNameListError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelBrandNameListError >& error) = 0;

    virtual void onFuelBrandNameListStatus(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelBrandNameListStatus >& status) = 0;
};

class FuelInfoListsStatusCallbackIF {
public:
    virtual ~FuelInfoListsStatusCallbackIF() {}

    virtual void onFuelInfoListsStatusError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelInfoListsStatusError >& error) = 0;

    virtual void onFuelInfoListsStatusStatus(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelInfoListsStatusStatus >& status) = 0;
};

class FuelTypeListCallbackIF {
public:
    virtual ~FuelTypeListCallbackIF() {}

    virtual void onFuelTypeListError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelTypeListError >& error) = 0;

    virtual void onFuelTypeListStatus(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< FuelTypeListStatus >& status) = 0;
};

class GetFuelInfoListCallbackIF {
public:
    virtual ~GetFuelInfoListCallbackIF() {}

    virtual void onGetFuelInfoListError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFuelInfoListError >& error) = 0;

    virtual void onGetFuelInfoListResult(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFuelInfoListResult >& result) = 0;
};

class GetFuelStationInfoCallbackIF {
public:
    virtual ~GetFuelStationInfoCallbackIF() {}

    virtual void onGetFuelStationInfoError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFuelStationInfoError >& error) = 0;

    virtual void onGetFuelStationInfoResult(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFuelStationInfoResult >& result) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class Sxm_fuel_main_fiProxyCallback;

/**
 * Sxm_fuel_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_fuel_main_fi' (specified in file
 * sxm_fuel_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_fuel_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Fuel
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Tapeswar Puhan (Fuel)
 *
 * Date: $Date:   Jun 28 2012  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_fuel_main_fi
 *
 * <b>Description of 'sxm_fuel_main_fi':</b>
 *
 * RBEI
 */
class Sxm_fuel_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_fuel_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_fuel_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_fuel_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_fuel_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_fuel_main_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_fuel_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_fuel_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Sxm_fuel_main_fiProxy();

    // Method 'GetFuelInfoList'

    /**
     * Call the method 'GetFuelInfoList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetFuelInfoList'</b>:
     *
     * This method is used to get fuel information
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID Fuel type information to filter fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param Operation Operation to be performed
     *
     * @param Brand Brand name to filter fuel info
     *
     * @param FuelType Fuel type information to filter fuel info
     *
     * @param SortType SortType for sort operation
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFuelInfoListStart(GetFuelInfoListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, const ::std::string& brand, const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& fuelType, ::sxm_fuel_main_fi_types::T_e8_SortType sortType);

    // Method 'GetFuelStationInfo'

    /**
     * Call the method 'GetFuelStationInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetFuelStationInfo'</b>:
     *
     * Get Fuel information for a fuel station
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FUEL_LOCID Loc ID as input
     *
     * @param ListID Location Type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFuelStationInfoStart(GetFuelStationInfoCallbackIF& cb, uint32 fUEL_LOCID, uint32 listID);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method is used to add fuel station
     * information into favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FUEL_LOCID Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 fUEL_LOCID);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method is used to Remove fuel station
     * information from favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param FUEL_LOCID Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 fUEL_LOCID);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure all lists
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Generic configuration for all list of fuel
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Property 'FuelInfoListsStatus'

    /**
     * Notify on the property 'FuelInfoListsStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelInfoListsStatusUpReg(FuelInfoListsStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FuelInfoListsStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param act The act which was previously returned by the
     * sendFuelInfoListsStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFuelInfoListsStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FuelInfoListsStatus'.
     */
    void sendFuelInfoListsStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'FuelInfoListsStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFuelInfoListsStatus() returns true.
     *
     * @return the previously received value of the property 'FuelInfoListsStatus'.
     */
    const FuelInfoListsStatusStatus& getFuelInfoListsStatus() const;

    /**
     * Determines whether a status message for the property 'FuelInfoListsStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFuelInfoListsStatus() const;

    /**
     * Request the value of the property 'FuelInfoListsStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelInfoListsStatusGet(FuelInfoListsStatusCallbackIF& cb);

    // Property 'FuelBrandNameList'

    /**
     * Notify on the property 'FuelBrandNameList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelBrandNameListUpReg(FuelBrandNameListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FuelBrandNameList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param act The act which was previously returned by the
     * sendFuelBrandNameListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFuelBrandNameListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FuelBrandNameList'.
     */
    void sendFuelBrandNameListRelUpRegAll ();

    /**
     * Returns the current value of the property 'FuelBrandNameList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFuelBrandNameList() returns true.
     *
     * @return the previously received value of the property 'FuelBrandNameList'.
     */
    const FuelBrandNameListStatus& getFuelBrandNameList() const;

    /**
     * Determines whether a status message for the property 'FuelBrandNameList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFuelBrandNameList() const;

    /**
     * Request the value of the property 'FuelBrandNameList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelBrandNameListGet(FuelBrandNameListCallbackIF& cb);

    // Property 'FuelTypeList'

    /**
     * Notify on the property 'FuelTypeList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FuelTypeList'</b>:
     *
     * Get all Avalable Fuel type Names.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelTypeListUpReg(FuelTypeListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FuelTypeList'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FuelTypeList'</b>:
     *
     * Get all Avalable Fuel type Names.
     *
     * @param act The act which was previously returned by the
     * sendFuelTypeListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFuelTypeListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FuelTypeList'.
     */
    void sendFuelTypeListRelUpRegAll ();

    /**
     * Returns the current value of the property 'FuelTypeList' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFuelTypeList() returns true.
     *
     * @return the previously received value of the property 'FuelTypeList'.
     */
    const FuelTypeListStatus& getFuelTypeList() const;

    /**
     * Determines whether a status message for the property 'FuelTypeList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFuelTypeList() const;

    /**
     * Request the value of the property 'FuelTypeList' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FuelTypeList'</b>:
     *
     * Get all Avalable Fuel type Names.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFuelTypeListGet(FuelTypeListCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Fuel Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Fuel Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Fuel Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Fuel List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Fuel List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Fuel List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Fuel List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_fuel_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'FuelInfoListsStatus'

    ::asf::core::nullable< FuelInfoListsStatusStatus > _fuelInfoListsStatus;

    // Property 'FuelBrandNameList'

    ::asf::core::nullable< FuelBrandNameListStatus > _fuelBrandNameList;

    // Property 'FuelTypeList'

    ::asf::core::nullable< FuelTypeListStatus > _fuelTypeList;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_fuel_main_fiProxyCallback;
};

} // namespace sxm_fuel_main_fi

#endif // SXM_FUEL_MAIN_FIPROXY_H
