/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_fuel_main_fiCca.h"
#include "sxm_fuel_main_fiJson.h"
#include "sxm_fuel_main_fiProxy.h"
#include "sxm_fuel_main_fi_types.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_fuel_main_fi {

/*static*/ ::asf::core::Logger Sxm_fuel_main_fiProxy::_logger ("/sxm_fuel_main_fi/Sxm_fuel_main_fiProxy");


class Sxm_fuel_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_fuel_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_fuel_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_fuel_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetFuelInfoList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::GetFuelInfoListResult);
                                setActAndLogResult(message, "GetFuelInfoList", reinterpret_cast<act_t>(this), _logger);
                                ((GetFuelInfoListCallbackIF*) _callback)->onGetFuelInfoListResult (proxy, ::boost::static_pointer_cast<GetFuelInfoListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::GetFuelInfoListError);
                                setActAndLogError(message, "GetFuelInfoList", reinterpret_cast<act_t>(this), _logger);
                                ((GetFuelInfoListCallbackIF*) _callback)->onGetFuelInfoListError (proxy, ::boost::static_pointer_cast<GetFuelInfoListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetFuelStationInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::GetFuelStationInfoResult);
                                setActAndLogResult(message, "GetFuelStationInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetFuelStationInfoCallbackIF*) _callback)->onGetFuelStationInfoResult (proxy, ::boost::static_pointer_cast<GetFuelStationInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::GetFuelStationInfoError);
                                setActAndLogError(message, "GetFuelStationInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetFuelStationInfoCallbackIF*) _callback)->onGetFuelStationInfoError (proxy, ::boost::static_pointer_cast<GetFuelStationInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AddFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::AddFavoriteResult);
                                setActAndLogResult(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteResult (proxy, ::boost::static_pointer_cast<AddFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::AddFavoriteError);
                                setActAndLogError(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, ::boost::static_pointer_cast<AddFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RemoveFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::RemoveFavoriteResult);
                                setActAndLogResult(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteResult (proxy, ::boost::static_pointer_cast<RemoveFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::RemoveFavoriteError);
                                setActAndLogError(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, ::boost::static_pointer_cast<RemoveFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetListsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SetListsConfigResult);
                                setActAndLogResult(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigResult (proxy, ::boost::static_pointer_cast<SetListsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SetListsConfigError);
                                setActAndLogError(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, ::boost::static_pointer_cast<SetListsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FuelInfoListsStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelInfoListsStatusStatus);
                                setActAndLogStatus(message, "FuelInfoListsStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FuelInfoListsStatusStatus> payload = ::boost::static_pointer_cast<FuelInfoListsStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FuelInfoListsStatusStatus >& refNullableStatus = proxy->_fuelInfoListsStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FuelInfoListsStatusCallbackIF*) _callback)->onFuelInfoListsStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelInfoListsStatusCallbackIF*) _callback)->onFuelInfoListsStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelInfoListsStatusError);
                                setActAndLogError(message, "FuelInfoListsStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelInfoListsStatusCallbackIF*) _callback)->onFuelInfoListsStatusError(proxy, ::boost::static_pointer_cast<FuelInfoListsStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FuelBrandNameList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelBrandNameListStatus);
                                setActAndLogStatus(message, "FuelBrandNameList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FuelBrandNameListStatus> payload = ::boost::static_pointer_cast<FuelBrandNameListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FuelBrandNameListStatus >& refNullableStatus = proxy->_fuelBrandNameList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FuelBrandNameListCallbackIF*) _callback)->onFuelBrandNameListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelBrandNameListCallbackIF*) _callback)->onFuelBrandNameListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelBrandNameListError);
                                setActAndLogError(message, "FuelBrandNameList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelBrandNameListCallbackIF*) _callback)->onFuelBrandNameListError(proxy, ::boost::static_pointer_cast<FuelBrandNameListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FuelTypeList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelTypeListStatus);
                                setActAndLogStatus(message, "FuelTypeList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FuelTypeListStatus> payload = ::boost::static_pointer_cast<FuelTypeListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FuelTypeListStatus >& refNullableStatus = proxy->_fuelTypeList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FuelTypeListCallbackIF*) _callback)->onFuelTypeListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelTypeListCallbackIF*) _callback)->onFuelTypeListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::FuelTypeListError);
                                setActAndLogError(message, "FuelTypeList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FuelTypeListCallbackIF*) _callback)->onFuelTypeListError(proxy, ::boost::static_pointer_cast<FuelTypeListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmDataServiceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SxmDataServiceStatusStatus);
                                setActAndLogStatus(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmDataServiceStatusStatus> payload = ::boost::static_pointer_cast<SxmDataServiceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmDataServiceStatusStatus >& refNullableStatus = proxy->_sxmDataServiceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SxmDataServiceStatusError);
                                setActAndLogError(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError(proxy, ::boost::static_pointer_cast<SxmDataServiceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmListMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SxmListModeStatus);
                                setActAndLogStatus(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmListModeStatus> payload = ::boost::static_pointer_cast<SxmListModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmListModeStatus >& refNullableStatus = proxy->_sxmListMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_fuel_main_fi::SxmListModeError);
                                setActAndLogError(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError(proxy, ::boost::static_pointer_cast<SxmListModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_fuel_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_fuel_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetFuelInfoList: {
                ::boost::shared_ptr< GetFuelInfoListError > payload (new GetFuelInfoListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetFuelInfoList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetFuelInfoListCallbackIF*) _callback)->onGetFuelInfoListError (proxy, payload);
                return true;
            }
            case FID_GetFuelStationInfo: {
                ::boost::shared_ptr< GetFuelStationInfoError > payload (new GetFuelStationInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetFuelStationInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetFuelStationInfoCallbackIF*) _callback)->onGetFuelStationInfoError (proxy, payload);
                return true;
            }
            case FID_AddFavorite: {
                ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, payload);
                return true;
            }
            case FID_RemoveFavorite: {
                ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, payload);
                return true;
            }
            case FID_SetListsConfig: {
                ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetListsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, payload);
                return true;
            }
            case FID_FuelInfoListsStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FuelInfoListsStatusError > payload (new FuelInfoListsStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FuelInfoListsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FuelInfoListsStatusCallbackIF*) _callback)->onFuelInfoListsStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FuelBrandNameList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FuelBrandNameListError > payload (new FuelBrandNameListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FuelBrandNameList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FuelBrandNameListCallbackIF*) _callback)->onFuelBrandNameListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FuelTypeList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FuelTypeListError > payload (new FuelTypeListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FuelTypeList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FuelTypeListCallbackIF*) _callback)->onFuelTypeListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmDataServiceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmListMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmListMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_fuel_main_fiProxyCallback::_logger (Sxm_fuel_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_fuel_main_fiProxy > Sxm_fuel_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_fuel_main_fiProxy >  proxyNew(new Sxm_fuel_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_fuel_main_fiProxy > Sxm_fuel_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_fuel_main_fiProxy >  proxyNew(new Sxm_fuel_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_fuel_main_fiProxy > Sxm_fuel_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_fuel_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_fuel_main_fiProxy >  proxyNew(new Sxm_fuel_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_fuel_main_fiProxy::Sxm_fuel_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_fuel_main_fiProxy::~Sxm_fuel_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_fuel_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_fuel_main_fiProxy::sendGetFuelInfoListStart(GetFuelInfoListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, const ::std::string& brand, const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& fuelType, ::sxm_fuel_main_fi_types::T_e8_SortType sortType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetFuelInfoList);
        ::boost::shared_ptr< GetFuelInfoListStart > payload (new GetFuelInfoListStart());
        payload->setListID(listID);
        payload->setOperation(operation);
        payload->setBrand(brand);
        payload->setFuelType(fuelType);
        payload->setSortType(sortType);
        CCA_MESSAGE(ccaMessage,header,GetFuelInfoListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetFuelInfoList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetFuelInfoList);
        ::boost::shared_ptr< GetFuelInfoListError > payload (new GetFuelInfoListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetFuelInfoListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetFuelInfoList", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendGetFuelStationInfoStart(GetFuelStationInfoCallbackIF& cb, uint32 fUEL_LOCID, uint32 listID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetFuelStationInfo);
        ::boost::shared_ptr< GetFuelStationInfoStart > payload (new GetFuelStationInfoStart());
        payload->setFUEL_LOCID(fUEL_LOCID);
        payload->setListID(listID);
        CCA_MESSAGE(ccaMessage,header,GetFuelStationInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetFuelStationInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetFuelStationInfo);
        ::boost::shared_ptr< GetFuelStationInfoError > payload (new GetFuelStationInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetFuelStationInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetFuelStationInfo", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 fUEL_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteStart > payload (new AddFavoriteStart());
        payload->setFUEL_LOCID(fUEL_LOCID);
        CCA_MESSAGE(ccaMessage,header,AddFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AddFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AddFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AddFavorite", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 fUEL_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteStart > payload (new RemoveFavoriteStart());
        payload->setFUEL_LOCID(fUEL_LOCID);
        CCA_MESSAGE(ccaMessage,header,RemoveFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RemoveFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoveFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RemoveFavorite", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigStart > payload (new SetListsConfigStart());
        payload->setConfig(config);
        CCA_MESSAGE(ccaMessage,header,SetListsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetListsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetListsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetListsConfig", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendFuelInfoListsStatusUpReg(FuelInfoListsStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FuelInfoListsStatus);
        ::boost::shared_ptr< FuelInfoListsStatusUpReg > payload (new FuelInfoListsStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,FuelInfoListsStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FuelInfoListsStatusRelUpReg > payloadRelUpRegHeap (new FuelInfoListsStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FuelInfoListsStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_fuel_main_fi::FuelInfoListsStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FuelInfoListsStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FuelInfoListsStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FuelInfoListsStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFuelInfoListsStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FuelInfoListsStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FuelInfoListsStatusStatus > payloadLoopback (new FuelInfoListsStatusStatus(getFuelInfoListsStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FuelInfoListsStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelInfoListsStatus);
        ::boost::shared_ptr< FuelInfoListsStatusError > payload (new FuelInfoListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelInfoListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FuelInfoListsStatus", &cb);
    }
}

bool Sxm_fuel_main_fiProxy::sendFuelInfoListsStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FuelInfoListsStatus,"FuelInfoListsStatus");
}

void Sxm_fuel_main_fiProxy::sendFuelInfoListsStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FuelInfoListsStatus);
}

const FuelInfoListsStatusStatus& Sxm_fuel_main_fiProxy::getFuelInfoListsStatus() const {
    return _fuelInfoListsStatus.get();
}

bool Sxm_fuel_main_fiProxy::hasFuelInfoListsStatus() const {
    return _fuelInfoListsStatus.hasValue();
}

act_t Sxm_fuel_main_fiProxy::sendFuelInfoListsStatusGet(FuelInfoListsStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FuelInfoListsStatus);
        ::boost::shared_ptr< FuelInfoListsStatusGet > payload (new FuelInfoListsStatusGet());
        CCA_MESSAGE(ccaMessage,header,FuelInfoListsStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FuelInfoListsStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelInfoListsStatus);
        ::boost::shared_ptr< FuelInfoListsStatusError > payload (new FuelInfoListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelInfoListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FuelInfoListsStatus", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendFuelBrandNameListUpReg(FuelBrandNameListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FuelBrandNameList);
        ::boost::shared_ptr< FuelBrandNameListUpReg > payload (new FuelBrandNameListUpReg());
        CCA_MESSAGE(ccaMessage,header,FuelBrandNameListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FuelBrandNameListRelUpReg > payloadRelUpRegHeap (new FuelBrandNameListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FuelBrandNameList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_fuel_main_fi::FuelBrandNameListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FuelBrandNameList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FuelBrandNameList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FuelBrandNameList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFuelBrandNameList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FuelBrandNameList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FuelBrandNameListStatus > payloadLoopback (new FuelBrandNameListStatus(getFuelBrandNameList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FuelBrandNameListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelBrandNameList);
        ::boost::shared_ptr< FuelBrandNameListError > payload (new FuelBrandNameListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelBrandNameListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FuelBrandNameList", &cb);
    }
}

bool Sxm_fuel_main_fiProxy::sendFuelBrandNameListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FuelBrandNameList,"FuelBrandNameList");
}

void Sxm_fuel_main_fiProxy::sendFuelBrandNameListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FuelBrandNameList);
}

const FuelBrandNameListStatus& Sxm_fuel_main_fiProxy::getFuelBrandNameList() const {
    return _fuelBrandNameList.get();
}

bool Sxm_fuel_main_fiProxy::hasFuelBrandNameList() const {
    return _fuelBrandNameList.hasValue();
}

act_t Sxm_fuel_main_fiProxy::sendFuelBrandNameListGet(FuelBrandNameListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FuelBrandNameList);
        ::boost::shared_ptr< FuelBrandNameListGet > payload (new FuelBrandNameListGet());
        CCA_MESSAGE(ccaMessage,header,FuelBrandNameListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FuelBrandNameList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelBrandNameList);
        ::boost::shared_ptr< FuelBrandNameListError > payload (new FuelBrandNameListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelBrandNameListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FuelBrandNameList", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendFuelTypeListUpReg(FuelTypeListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FuelTypeList);
        ::boost::shared_ptr< FuelTypeListUpReg > payload (new FuelTypeListUpReg());
        CCA_MESSAGE(ccaMessage,header,FuelTypeListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FuelTypeListRelUpReg > payloadRelUpRegHeap (new FuelTypeListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FuelTypeList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_fuel_main_fi::FuelTypeListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FuelTypeList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FuelTypeList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FuelTypeList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFuelTypeList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FuelTypeList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FuelTypeListStatus > payloadLoopback (new FuelTypeListStatus(getFuelTypeList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FuelTypeListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelTypeList);
        ::boost::shared_ptr< FuelTypeListError > payload (new FuelTypeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelTypeListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FuelTypeList", &cb);
    }
}

bool Sxm_fuel_main_fiProxy::sendFuelTypeListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FuelTypeList,"FuelTypeList");
}

void Sxm_fuel_main_fiProxy::sendFuelTypeListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FuelTypeList);
}

const FuelTypeListStatus& Sxm_fuel_main_fiProxy::getFuelTypeList() const {
    return _fuelTypeList.get();
}

bool Sxm_fuel_main_fiProxy::hasFuelTypeList() const {
    return _fuelTypeList.hasValue();
}

act_t Sxm_fuel_main_fiProxy::sendFuelTypeListGet(FuelTypeListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FuelTypeList);
        ::boost::shared_ptr< FuelTypeListGet > payload (new FuelTypeListGet());
        CCA_MESSAGE(ccaMessage,header,FuelTypeListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FuelTypeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FuelTypeList);
        ::boost::shared_ptr< FuelTypeListError > payload (new FuelTypeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FuelTypeListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FuelTypeList", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusUpReg > payload (new SxmDataServiceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmDataServiceStatusRelUpReg > payloadRelUpRegHeap (new SxmDataServiceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmDataServiceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_fuel_main_fi::SxmDataServiceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmDataServiceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmDataServiceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmDataServiceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmDataServiceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmDataServiceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmDataServiceStatusStatus > payloadLoopback (new SxmDataServiceStatusStatus(getSxmDataServiceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmDataServiceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

bool Sxm_fuel_main_fiProxy::sendSxmDataServiceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmDataServiceStatus,"SxmDataServiceStatus");
}

void Sxm_fuel_main_fiProxy::sendSxmDataServiceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmDataServiceStatus);
}

const SxmDataServiceStatusStatus& Sxm_fuel_main_fiProxy::getSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.get();
}

bool Sxm_fuel_main_fiProxy::hasSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.hasValue();
}

act_t Sxm_fuel_main_fiProxy::sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusGet > payload (new SxmDataServiceStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmDataServiceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

act_t Sxm_fuel_main_fiProxy::sendSxmListModeUpReg(SxmListModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeUpReg > payload (new SxmListModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmListModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmListModeRelUpReg > payloadRelUpRegHeap (new SxmListModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmListMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_fuel_main_fi::SxmListModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmListMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmListMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmListMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmListMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmListMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmListModeStatus > payloadLoopback (new SxmListModeStatus(getSxmListMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmListModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmListMode", &cb);
    }
}

bool Sxm_fuel_main_fiProxy::sendSxmListModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmListMode,"SxmListMode");
}

void Sxm_fuel_main_fiProxy::sendSxmListModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmListMode);
}

const SxmListModeStatus& Sxm_fuel_main_fiProxy::getSxmListMode() const {
    return _sxmListMode.get();
}

bool Sxm_fuel_main_fiProxy::hasSxmListMode() const {
    return _sxmListMode.hasValue();
}

act_t Sxm_fuel_main_fiProxy::sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeSet > payload (new SxmListModeSet());
        payload->setListMode(listMode);
        CCA_MESSAGE(ccaMessage,header,SxmListModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SxmListMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SxmListMode", &cb);
    }
}


void Sxm_fuel_main_fiProxy::clearAllProperties ()
{
    _fuelInfoListsStatus = ::asf::core::nullable<FuelInfoListsStatusStatus>();
    _fuelBrandNameList = ::asf::core::nullable<FuelBrandNameListStatus>();
    _fuelTypeList = ::asf::core::nullable<FuelTypeListStatus>();
    _sxmDataServiceStatus = ::asf::core::nullable<SxmDataServiceStatusStatus>();
    _sxmListMode = ::asf::core::nullable<SxmListModeStatus>();
}

void Sxm_fuel_main_fiProxy::sendRelUpRegAll()
{
    sendFuelInfoListsStatusRelUpRegAll();
    sendFuelBrandNameListRelUpRegAll();
    sendFuelTypeListRelUpRegAll();
    sendSxmDataServiceStatusRelUpRegAll();
    sendSxmListModeRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_fuel_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_fuel_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_fuel_main_fi
