/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "sxm_fuel_main_fi.h"
#include "sxm_fuel_main_fiJson.h"
#include "sxm_fuel_main_fiJsonPrivate.h"
#include "sxm_fuel_main_fi_types.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_fuel_main_fi_typesJsonPrivate.h"
#include "sxm_main_fi_typesConst.h"
#include "sxm_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "GetFuelInfoListStart"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    if (!isSparse || value.hasOperation()) {
        yajl_gen_string(g, (const unsigned char*)  "Operation" , 9);
        const char* s = ::sxm_main_fi_types::T_e8_SxmListOperation_Name(value.getOperation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOperation());
    }
    if (!isSparse || value.hasBrand()) {
        yajl_gen_string(g, (const unsigned char*)  "Brand" , 5);
        const char *s = value.getBrand().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFuelType()) {
        yajl_gen_string(g, (const unsigned char*)  "FuelType" , 8);
        serializeJson(value.getFuelType(), g, options);
    }
    if (!isSparse || value.hasSortType()) {
        yajl_gen_string(g, (const unsigned char*)  "SortType" , 8);
        const char* s = ::sxm_fuel_main_fi_types::T_e8_SortType_Name(value.getSortType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSortType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelInfoListResult"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    if (!isSparse || value.hasOperation()) {
        yajl_gen_string(g, (const unsigned char*)  "Operation" , 9);
        const char* s = ::sxm_main_fi_types::T_e8_SxmListOperation_Name(value.getOperation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOperation());
    }
    if (!isSparse || value.hasListInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "ListInfo" , 8);
        serializeJson(value.getListInfo(), g, options);
    }
    if (!isSparse || value.hasFuelInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "FuelInfoList" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_fuel_main_fi_types::T_FuelInfo >& o1 = value.getFuelInfoList();
        {
            ::std::vector< ::sxm_fuel_main_fi_types::T_FuelInfo >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelInfoListErrorStructure"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelInfoListError"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelInfoListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::sxm_fuel_main_fi::GetFuelInfoListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::sxm_fuel_main_fi::GetFuelInfoListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::sxm_fuel_main_fi::GetFuelInfoListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelStationInfoStart"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFUEL_LOCID()) {
        yajl_gen_string(g, (const unsigned char*)  "FUEL_LOCID" , 10);
        yajl_gen_integer(g, (long long)value.getFUEL_LOCID());
    }
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelStationInfoResult"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFuelStationInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "FuelStationInfo" , 15);
        serializeJson(value.getFuelStationInfo(), g, options);
    }
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelStationInfoErrorStructure"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFuelStationInfoError"

void serializeJson (const ::sxm_fuel_main_fi::GetFuelStationInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::sxm_fuel_main_fi::GetFuelStationInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::sxm_fuel_main_fi::GetFuelStationInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::sxm_fuel_main_fi::GetFuelStationInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFavoriteStart"

void serializeJson (const ::sxm_fuel_main_fi::AddFavoriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFUEL_LOCID()) {
        yajl_gen_string(g, (const unsigned char*)  "FUEL_LOCID" , 10);
        yajl_gen_integer(g, (long long)value.getFUEL_LOCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::AddFavoriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddFavoriteResult"

void serializeJson (const ::sxm_fuel_main_fi::AddFavoriteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::AddFavoriteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoveFavoriteStart"

void serializeJson (const ::sxm_fuel_main_fi::RemoveFavoriteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFUEL_LOCID()) {
        yajl_gen_string(g, (const unsigned char*)  "FUEL_LOCID" , 10);
        yajl_gen_integer(g, (long long)value.getFUEL_LOCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::RemoveFavoriteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoveFavoriteResult"

void serializeJson (const ::sxm_fuel_main_fi::RemoveFavoriteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::RemoveFavoriteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetListsConfigStart"

void serializeJson (const ::sxm_fuel_main_fi::SetListsConfigStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfig()) {
        yajl_gen_string(g, (const unsigned char*)  "Config" , 6);
        serializeJson(value.getConfig(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::SetListsConfigStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetListsConfigResult"

void serializeJson (const ::sxm_fuel_main_fi::SetListsConfigResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::SetListsConfigResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FuelInfoListsStatusStatus"

void serializeJson (const ::sxm_fuel_main_fi::FuelInfoListsStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "InfoList" , 8);
        serializeJson(value.getInfoList(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::FuelInfoListsStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FuelBrandNameListStatus"

void serializeJson (const ::sxm_fuel_main_fi::FuelBrandNameListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBrandName()) {
        yajl_gen_string(g, (const unsigned char*)  "BrandName" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o3 = value.getBrandName();
        {
            ::std::vector< ::std::string >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char *s = (*o2).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::FuelBrandNameListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FuelTypeListStatus"

void serializeJson (const ::sxm_fuel_main_fi::FuelTypeListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTypeName()) {
        yajl_gen_string(g, (const unsigned char*)  "TypeName" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_fuel_main_fi_types::T_FuelTypeInfo >& o5 = value.getTypeName();
        {
            ::std::vector< ::sxm_fuel_main_fi_types::T_FuelTypeInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::FuelTypeListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SxmDataServiceStatusStatus"

void serializeJson (const ::sxm_fuel_main_fi::SxmDataServiceStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "DataServiceState" , 16);
        serializeJson(value.getDataServiceState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::SxmDataServiceStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SxmListModeStatus"

void serializeJson (const ::sxm_fuel_main_fi::SxmListModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListMode()) {
        yajl_gen_string(g, (const unsigned char*)  "ListMode" , 8);
        serializeJson(value.getListMode(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::SxmListModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SxmListModeSet"

void serializeJson (const ::sxm_fuel_main_fi::SxmListModeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListMode()) {
        yajl_gen_string(g, (const unsigned char*)  "ListMode" , 8);
        serializeJson(value.getListMode(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_fuel_main_fi::SxmListModeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelInfoListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelInfoListResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelInfoListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelInfoListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelStationInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelStationInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelStationInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::GetFuelStationInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::AddFavoriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::AddFavoriteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::RemoveFavoriteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::RemoveFavoriteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::SetListsConfigStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::SetListsConfigResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::FuelInfoListsStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::FuelBrandNameListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::FuelTypeListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::SxmDataServiceStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::SxmListModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi
using namespace ::asf::stream::json;

namespace sxm_fuel_main_fi {

std::ostream& operator<<(std::ostream& o, const ::sxm_fuel_main_fi::SxmListModeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_fuel_main_fi

