#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_FUEL_MAIN_FI_H
#define SXM_FUEL_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_fuel_main_fi_types.h"
#include "sxm_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_fuel_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Fuel
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Tapeswar Puhan (Fuel)
 *
 * Date: $Date:   Jun 28 2012  16:00 PM  $
 *
 * Department: ECV
 *
 * Title: sxm_fuel_main_fi
 *
 * <b>Description of 'sxm_fuel_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_fuel_main_fi {

static const int SERVICE_ID = 151;

static const int FID_GetFuelInfoList = 1;

static const int FID_GetFuelStationInfo = 3;

static const int FID_AddFavorite = 4;

static const int FID_RemoveFavorite = 5;

static const int FID_SetListsConfig = 6;

static const int FID_FuelInfoListsStatus = 16;

static const int FID_FuelBrandNameList = 17;

static const int FID_FuelTypeList = 18;

static const int FID_SxmDataServiceStatus = 19;

static const int FID_SxmListMode = 20;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 7;

// forward declarations
class GetFuelInfoListStart;

class GetFuelInfoListResult;

class GetFuelInfoListErrorStructure;

class GetFuelInfoListError;

class GetFuelStationInfoStart;

class GetFuelStationInfoResult;

class GetFuelStationInfoErrorStructure;

class GetFuelStationInfoError;

class AddFavoriteStart;

class AddFavoriteResult;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class SetListsConfigStart;

class SetListsConfigResult;

class FuelInfoListsStatusStatus;

class FuelBrandNameListStatus;

class FuelTypeListStatus;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

// type definitions
/**
 * The abort error message of the method "GetFuelInfoList"
 * This method is used to get fuel information
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFuelInfoListAbortError;

/**
 * The abort error message of the method "GetFuelStationInfo"
 * Get Fuel information for a fuel station
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFuelStationInfoAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method is used to add fuel station
 * information into favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The error message of 'AddFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method is used to Remove fuel station
 * information from favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The error message of 'RemoveFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The error message of 'SetListsConfig'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigError;

/**
 * The get message of the property "FuelInfoListsStatus"
 * Status of all configured Lists
 * Fuel information Available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelInfoListsStatusGet;

/**
 * The upreg message of the property "FuelInfoListsStatus"
 * Status of all configured Lists
 * Register for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelInfoListsStatusUpReg;

/**
 * The relUpReg message of the property "FuelInfoListsStatus"
 * Status of all configured Lists
 * Unregister for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelInfoListsStatusRelUpReg;

/**
 * The error message of 'FuelInfoListsStatus'
 * todo
 */
typedef ::asf::cca::CcaTypes::DefaultError FuelInfoListsStatusError;

/**
 * The get message of the property "FuelBrandNameList"
 * Get all Avalable Brand Names.
 * List of All Avalable brand Name
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelBrandNameListGet;

/**
 * The upreg message of the property "FuelBrandNameList"
 * Get all Avalable Brand Names.
 * Register for Brand Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelBrandNameListUpReg;

/**
 * The relUpReg message of the property "FuelBrandNameList"
 * Get all Avalable Brand Names.
 * Unregister for Brand Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelBrandNameListRelUpReg;

/**
 * The error message of 'FuelBrandNameList'
 * This error code specifies Brand Name List is empty
 */
typedef ::asf::cca::CcaTypes::DefaultError FuelBrandNameListError;

/**
 * The get message of the property "FuelTypeList"
 * Get all Avalable Fuel type Names.
 * List of All Avalable Fuel type Name
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelTypeListGet;

/**
 * The upreg message of the property "FuelTypeList"
 * Get all Avalable Fuel type Names.
 * Register for  Fuel Type Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelTypeListUpReg;

/**
 * The relUpReg message of the property "FuelTypeList"
 * Get all Avalable Fuel type Names.
 * Unregister for  Fuel Type Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelTypeListRelUpReg;

/**
 * The error message of 'FuelTypeList'
 * This error code specifies  Fuel Type Name List is empty
 */
typedef ::asf::cca::CcaTypes::DefaultError FuelTypeListError;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Fuel Data Service
 * Status of Fuel Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Fuel Data Service
 * Register for Fuel Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Fuel Data Service
 * Unregister for Fuel Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Fuel Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Fuel List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Fuel List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;


/**
 * The start message of the method "GetFuelInfoList"
 * This method is used to get fuel information
 */
class GetFuelInfoListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFuelInfoListStart ();

    /**
     * Copy constructor
     */
    inline  GetFuelInfoListStart (const GetFuelInfoListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelInfoListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::std::string& Brand_, const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& FuelType_, ::sxm_fuel_main_fi_types::T_e8_SortType SortType_);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelInfoListStart();

    /**
     * Assignment operator
     */
    inline GetFuelInfoListStart& operator = (const GetFuelInfoListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelInfoListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelInfoListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelInfoListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelInfoListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Fuel type information to filter fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Fuel type information to filter fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "Brand"

    static const int kBrand = 2;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand name to filter fuel info
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "FuelType"

    static const int kFuelType = 3;

    /**
     * Clears the field "FuelType".
     *
     * The field will be set to its default value. The hasFuelType()
     * method will return false.
     */
    inline void clearFuelType();

    /**
     * Checks whether the field "FuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelType()). Otherwise it will return false.
     */
    inline bool hasFuelType () const;

    /**
     * Returns the value of the member "FuelType".
     *
     * Fuel type information to filter fuel info
     *
     * @return The value of the field "FuelType"
     */
    inline const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& getFuelType () const;

    /**
     * Retrieves the value of the field "FuelType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelType".
     */
    inline ::sxm_fuel_main_fi_types::T_FuelTypeInfo& getFuelTypeMutable ();

    /**
     * Sets the value of the member "FuelType".
     *
     * Fuel type information to filter fuel info
     *
     * @param FuelType The value which will be set
     */
    inline void setFuelType (const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& FuelType_);

    // API of field "SortType"

    static const int kSortType = 4;

    /**
     * Clears the field "SortType".
     *
     * The field will be set to its default value. The hasSortType()
     * method will return false.
     */
    inline void clearSortType();

    /**
     * Checks whether the field "SortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSortType()). Otherwise it will return false.
     */
    inline bool hasSortType () const;

    /**
     * Returns the value of the member "SortType".
     *
     * SortType for sort operation
     *
     * @return The value of the field "SortType"
     */
    inline ::sxm_fuel_main_fi_types::T_e8_SortType getSortType () const;

    /**
     * Sets the value of the member "SortType".
     *
     * SortType for sort operation
     *
     * @param SortType The value which will be set
     */
    inline void setSortType (::sxm_fuel_main_fi_types::T_e8_SortType SortType_);

    static const GetFuelInfoListStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_FuelType ();

    inline void clear_has_FuelType ();

    inline void set_has_SortType ();

    inline void clear_has_SortType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::std::string _Brand;

    ::sxm_fuel_main_fi_types::T_FuelTypeInfo _FuelType;

    ::sxm_fuel_main_fi_types::T_e8_SortType _SortType;

};

/**
 * The result message of the method "GetFuelInfoList"
 * This method is used to get fuel information
 */
class GetFuelInfoListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFuelInfoListResult ();

    /**
     * Copy constructor
     */
    inline  GetFuelInfoListResult (const GetFuelInfoListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelInfoListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_fuel_main_fi_types::T_FuelInfoList& FuelInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelInfoListResult();

    /**
     * Assignment operator
     */
    inline GetFuelInfoListResult& operator = (const GetFuelInfoListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelInfoListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelInfoListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelInfoListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelInfoListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Fuel type information to filter fuel info
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Fuel type information to filter fuel info
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "ListInfo"

    static const int kListInfo = 2;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfo& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::sxm_main_fi_types::T_SxmListInfo& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_);

    // API of field "FuelInfoList"

    static const int kFuelInfoList = 3;

    /**
     * Clears the field "FuelInfoList".
     *
     * The field will be set to its default value. The hasFuelInfoList()
     * method will return false.
     */
    inline void clearFuelInfoList();

    /**
     * Checks whether the field "FuelInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelInfoList()). Otherwise it will return false.
     */
    inline bool hasFuelInfoList () const;

    /**
     * Returns the value of the member "FuelInfoList".
     *
     * Get all fuel information list
     *
     * @return The value of the field "FuelInfoList"
     */
    inline const ::sxm_fuel_main_fi_types::T_FuelInfoList& getFuelInfoList () const;

    /**
     * Retrieves the value of the field "FuelInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelInfoList".
     */
    inline ::sxm_fuel_main_fi_types::T_FuelInfoList& getFuelInfoListMutable ();

    /**
     * Sets the value of the member "FuelInfoList".
     *
     * Get all fuel information list
     *
     * @param FuelInfoList The value which will be set
     */
    inline void setFuelInfoList (const ::sxm_fuel_main_fi_types::T_FuelInfoList& FuelInfoList_);

    static const GetFuelInfoListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_fuel_main_fi_types::T_FuelInfo >& getT_FuelInfoList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    inline void set_has_FuelInfoList ();

    inline void clear_has_FuelInfoList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmListInfo _ListInfo;

    ::sxm_fuel_main_fi_types::T_FuelInfoList _FuelInfoList;

};

/**
 * The error message of 'GetFuelInfoList'
 */
class GetFuelInfoListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFuelInfoListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFuelInfoListErrorStructure (const GetFuelInfoListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelInfoListErrorStructure (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFuelInfoListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFuelInfoListErrorStructure& operator = (const GetFuelInfoListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelInfoListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelInfoListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelInfoListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelInfoListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies fuel list is empty
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies fuel list is empty
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_);

    static const GetFuelInfoListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFuelInfoList'
 */
class GetFuelInfoListError  : public ::asf::core::Payload {
public:

    enum GetFuelInfoListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFuelInfoListError ();

   /**
     * Copy constructor
     */
    inline  GetFuelInfoListError (const GetFuelInfoListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelInfoListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFuelInfoListError& operator = (const GetFuelInfoListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelInfoListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelInfoListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelInfoListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelInfoListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFuelInfoListError::GetFuelInfoListErrorField getField () const;

    inline void setField(GetFuelInfoListError::GetFuelInfoListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFuelInfoListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFuelInfoListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFuelInfoListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFuelInfoListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFuelInfoListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFuelInfoListError &getDefaultInstance();

private:

    inline void cloneData (const GetFuelInfoListError& rhs);

    inline void deleteData ();

    GetFuelInfoListErrorField __field;

    union {
        GetFuelInfoListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetFuelStationInfo"
 * Get Fuel information for a fuel station
 */
class GetFuelStationInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFuelStationInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetFuelStationInfoStart (const GetFuelStationInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelStationInfoStart (uint32 FUEL_LOCID_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelStationInfoStart();

    /**
     * Assignment operator
     */
    inline GetFuelStationInfoStart& operator = (const GetFuelStationInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelStationInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelStationInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelStationInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelStationInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FUEL_LOCID"

    static const int kFUEL_LOCID = 0;

    /**
     * Clears the field "FUEL_LOCID".
     *
     * The field will be set to its default value. The hasFUEL_LOCID()
     * method will return false.
     */
    inline void clearFUEL_LOCID();

    /**
     * Checks whether the field "FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasFUEL_LOCID () const;

    /**
     * Returns the value of the member "FUEL_LOCID".
     *
     * Loc ID as input
     *
     * @return The value of the field "FUEL_LOCID"
     */
    inline uint32 getFUEL_LOCID () const;

    /**
     * Sets the value of the member "FUEL_LOCID".
     *
     * Loc ID as input
     *
     * @param FUEL_LOCID The value which will be set
     */
    inline void setFUEL_LOCID (uint32 FUEL_LOCID_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetFuelStationInfoStart &getDefaultInstance();

private:

    inline void set_has_FUEL_LOCID ();

    inline void clear_has_FUEL_LOCID ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _FUEL_LOCID;

    uint32 _ListID;

};

/**
 * The result message of the method "GetFuelStationInfo"
 * Get Fuel information for a fuel station
 */
class GetFuelStationInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFuelStationInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetFuelStationInfoResult (const GetFuelStationInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelStationInfoResult (const ::sxm_fuel_main_fi_types::T_FuelStationInfo& FuelStationInfo_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelStationInfoResult();

    /**
     * Assignment operator
     */
    inline GetFuelStationInfoResult& operator = (const GetFuelStationInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelStationInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelStationInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelStationInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelStationInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FuelStationInfo"

    static const int kFuelStationInfo = 0;

    /**
     * Clears the field "FuelStationInfo".
     *
     * The field will be set to its default value. The hasFuelStationInfo()
     * method will return false.
     */
    inline void clearFuelStationInfo();

    /**
     * Checks whether the field "FuelStationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelStationInfo()). Otherwise it will return false.
     */
    inline bool hasFuelStationInfo () const;

    /**
     * Returns the value of the member "FuelStationInfo".
     *
     * Fuel station information
     *
     * @return The value of the field "FuelStationInfo"
     */
    inline const ::sxm_fuel_main_fi_types::T_FuelStationInfo& getFuelStationInfo () const;

    /**
     * Retrieves the value of the field "FuelStationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FuelStationInfo".
     */
    inline ::sxm_fuel_main_fi_types::T_FuelStationInfo& getFuelStationInfoMutable ();

    /**
     * Sets the value of the member "FuelStationInfo".
     *
     * Fuel station information
     *
     * @param FuelStationInfo The value which will be set
     */
    inline void setFuelStationInfo (const ::sxm_fuel_main_fi_types::T_FuelStationInfo& FuelStationInfo_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetFuelStationInfoResult &getDefaultInstance();

private:

    inline void set_has_FuelStationInfo ();

    inline void clear_has_FuelStationInfo ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_fuel_main_fi_types::T_FuelStationInfo _FuelStationInfo;

    uint32 _ListID;

};

/**
 * The error message of 'GetFuelStationInfo'
 */
class GetFuelStationInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFuelStationInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFuelStationInfoErrorStructure (const GetFuelStationInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFuelStationInfoErrorStructure (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetFuelStationInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFuelStationInfoErrorStructure& operator = (const GetFuelStationInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelStationInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelStationInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelStationInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelStationInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies fuel station unavailability
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies fuel station unavailability
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_);

    static const GetFuelStationInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetFuelStationInfo'
 */
class GetFuelStationInfoError  : public ::asf::core::Payload {
public:

    enum GetFuelStationInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFuelStationInfoError ();

   /**
     * Copy constructor
     */
    inline  GetFuelStationInfoError (const GetFuelStationInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFuelStationInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFuelStationInfoError& operator = (const GetFuelStationInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFuelStationInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFuelStationInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFuelStationInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFuelStationInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFuelStationInfoError::GetFuelStationInfoErrorField getField () const;

    inline void setField(GetFuelStationInfoError::GetFuelStationInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFuelStationInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFuelStationInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFuelStationInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFuelStationInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFuelStationInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFuelStationInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetFuelStationInfoError& rhs);

    inline void deleteData ();

    GetFuelStationInfoErrorField __field;

    union {
        GetFuelStationInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method is used to add fuel station
 * information into favorite list
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (uint32 FUEL_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FUEL_LOCID"

    static const int kFUEL_LOCID = 0;

    /**
     * Clears the field "FUEL_LOCID".
     *
     * The field will be set to its default value. The hasFUEL_LOCID()
     * method will return false.
     */
    inline void clearFUEL_LOCID();

    /**
     * Checks whether the field "FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasFUEL_LOCID () const;

    /**
     * Returns the value of the member "FUEL_LOCID".
     *
     * Location ID
     *
     * @return The value of the field "FUEL_LOCID"
     */
    inline uint32 getFUEL_LOCID () const;

    /**
     * Sets the value of the member "FUEL_LOCID".
     *
     * Location ID
     *
     * @param FUEL_LOCID The value which will be set
     */
    inline void setFUEL_LOCID (uint32 FUEL_LOCID_);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_FUEL_LOCID ();

    inline void clear_has_FUEL_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _FUEL_LOCID;

};

/**
 * The result message of the method "AddFavorite"
 * This method is used to add fuel station
 * information into favorite list
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method is used to Remove fuel station
 * information from favorite list
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (uint32 FUEL_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FUEL_LOCID"

    static const int kFUEL_LOCID = 0;

    /**
     * Clears the field "FUEL_LOCID".
     *
     * The field will be set to its default value. The hasFUEL_LOCID()
     * method will return false.
     */
    inline void clearFUEL_LOCID();

    /**
     * Checks whether the field "FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasFUEL_LOCID () const;

    /**
     * Returns the value of the member "FUEL_LOCID".
     *
     * Location ID
     *
     * @return The value of the field "FUEL_LOCID"
     */
    inline uint32 getFUEL_LOCID () const;

    /**
     * Sets the value of the member "FUEL_LOCID".
     *
     * Location ID
     *
     * @param FUEL_LOCID The value which will be set
     */
    inline void setFUEL_LOCID (uint32 FUEL_LOCID_);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_FUEL_LOCID ();

    inline void clear_has_FUEL_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _FUEL_LOCID;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method is used to Remove fuel station
 * information from favorite list
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully remove from favorite list return True
     * else return False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully remove from favorite list return True
     * else return False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Generic configuration for all list of fuel
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Generic configuration for all list of fuel
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The status message of the property "FuelInfoListsStatus"
 * Status of all configured Lists
 */
class FuelInfoListsStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FuelInfoListsStatusStatus ();

    /**
     * Copy constructor
     */
    inline  FuelInfoListsStatusStatus (const FuelInfoListsStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FuelInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    /**
     * Destructor
     */
    inline virtual  ~FuelInfoListsStatusStatus();

    /**
     * Assignment operator
     */
    inline FuelInfoListsStatusStatus& operator = (const FuelInfoListsStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FuelInfoListsStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FuelInfoListsStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FuelInfoListsStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FuelInfoListsStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InfoList"

    static const int kInfoList = 0;

    /**
     * Clears the field "InfoList".
     *
     * The field will be set to its default value. The hasInfoList()
     * method will return false.
     */
    inline void clearInfoList();

    /**
     * Checks whether the field "InfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfoList()). Otherwise it will return false.
     */
    inline bool hasInfoList () const;

    /**
     * Returns the value of the member "InfoList".
     *
     * list containing status of all list provide by fuel
     *
     * @return The value of the field "InfoList"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getInfoList () const;

    /**
     * Retrieves the value of the field "InfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InfoList".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getInfoListMutable ();

    /**
     * Sets the value of the member "InfoList".
     *
     * list containing status of all list provide by fuel
     *
     * @param InfoList The value which will be set
     */
    inline void setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    static const FuelInfoListsStatusStatus &getDefaultInstance();

private:

    inline void set_has_InfoList ();

    inline void clear_has_InfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _InfoList;

};

/**
 * The status message of the property "FuelBrandNameList"
 * Get all Avalable Brand Names.
 */
class FuelBrandNameListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FuelBrandNameListStatus ();

    /**
     * Copy constructor
     */
    inline  FuelBrandNameListStatus (const FuelBrandNameListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FuelBrandNameListStatus (const ::sxm_fuel_main_fi_types::T_BrandNameList& BrandName_);

    /**
     * Destructor
     */
    inline virtual  ~FuelBrandNameListStatus();

    /**
     * Assignment operator
     */
    inline FuelBrandNameListStatus& operator = (const FuelBrandNameListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FuelBrandNameListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FuelBrandNameListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FuelBrandNameListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FuelBrandNameListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrandName"

    static const int kBrandName = 0;

    /**
     * Clears the field "BrandName".
     *
     * The field will be set to its default value. The hasBrandName()
     * method will return false.
     */
    inline void clearBrandName();

    /**
     * Checks whether the field "BrandName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrandName()). Otherwise it will return false.
     */
    inline bool hasBrandName () const;

    /**
     * Returns the value of the member "BrandName".
     *
     * List of All Avalable brand Names
     *
     * @return The value of the field "BrandName"
     */
    inline const ::sxm_fuel_main_fi_types::T_BrandNameList& getBrandName () const;

    /**
     * Retrieves the value of the field "BrandName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BrandName".
     */
    inline ::sxm_fuel_main_fi_types::T_BrandNameList& getBrandNameMutable ();

    /**
     * Sets the value of the member "BrandName".
     *
     * List of All Avalable brand Names
     *
     * @param BrandName The value which will be set
     */
    inline void setBrandName (const ::sxm_fuel_main_fi_types::T_BrandNameList& BrandName_);

    static const FuelBrandNameListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_BrandName ();

    inline void clear_has_BrandName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_fuel_main_fi_types::T_BrandNameList _BrandName;

};

/**
 * The status message of the property "FuelTypeList"
 * Get all Avalable Fuel type Names.
 */
class FuelTypeListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FuelTypeListStatus ();

    /**
     * Copy constructor
     */
    inline  FuelTypeListStatus (const FuelTypeListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FuelTypeListStatus (const ::sxm_fuel_main_fi_types::T_FuelTypeList& TypeName_);

    /**
     * Destructor
     */
    inline virtual  ~FuelTypeListStatus();

    /**
     * Assignment operator
     */
    inline FuelTypeListStatus& operator = (const FuelTypeListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FuelTypeListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FuelTypeListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FuelTypeListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FuelTypeListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TypeName"

    static const int kTypeName = 0;

    /**
     * Clears the field "TypeName".
     *
     * The field will be set to its default value. The hasTypeName()
     * method will return false.
     */
    inline void clearTypeName();

    /**
     * Checks whether the field "TypeName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTypeName()). Otherwise it will return false.
     */
    inline bool hasTypeName () const;

    /**
     * Returns the value of the member "TypeName".
     *
     * List of All Avalable Fuel Type Names
     *
     * @return The value of the field "TypeName"
     */
    inline const ::sxm_fuel_main_fi_types::T_FuelTypeList& getTypeName () const;

    /**
     * Retrieves the value of the field "TypeName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TypeName".
     */
    inline ::sxm_fuel_main_fi_types::T_FuelTypeList& getTypeNameMutable ();

    /**
     * Sets the value of the member "TypeName".
     *
     * List of All Avalable Fuel Type Names
     *
     * @param TypeName The value which will be set
     */
    inline void setTypeName (const ::sxm_fuel_main_fi_types::T_FuelTypeList& TypeName_);

    static const FuelTypeListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_fuel_main_fi_types::T_FuelTypeInfo >& getT_FuelTypeInfoList_DefaultInstance ();

    inline void set_has_TypeName ();

    inline void clear_has_TypeName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_fuel_main_fi_types::T_FuelTypeList _TypeName;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Fuel Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Fuel Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Fuel Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Fuel List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Fuel List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Fuel List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Fuel List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Fuel List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Fuel List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

inline  GetFuelInfoListStart::GetFuelInfoListStart ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Brand (),
    _FuelType (),
    _SortType (::sxm_fuel_main_fi_types::T_e8_SortType__FUEL_SORT_BY_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelInfoListStart::GetFuelInfoListStart (const GetFuelInfoListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Brand (),
    _FuelType (),
    _SortType (::sxm_fuel_main_fi_types::T_e8_SortType__FUEL_SORT_BY_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelInfoListStart::GetFuelInfoListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::std::string& Brand_, const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& FuelType_, ::sxm_fuel_main_fi_types::T_e8_SortType SortType_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _Brand (Brand_),
    _FuelType (FuelType_),
    _SortType (SortType_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFuelInfoListStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8_SortType_IsValid(SortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SortType_, "T_e8_SortType", "SortType", "GetFuelInfoListStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelInfoListStart::~GetFuelInfoListStart() {
}

inline GetFuelInfoListStart& GetFuelInfoListStart::operator = (const GetFuelInfoListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasFuelType()) {
            setFuelType(rhs.getFuelType());
        } else {
            clearFuelType();
        }
        if (rhs.hasSortType()) {
            setSortType(rhs.getSortType());
        } else {
            clearSortType();
        }
    }
    return *this;
}

inline bool GetFuelInfoListStart::operator == (const GetFuelInfoListStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasFuelType() && !rhs.hasFuelType()) || getFuelType() == rhs.getFuelType()) &&
        ((!hasSortType() && !rhs.hasSortType()) || getSortType() == rhs.getSortType()));
}

inline bool GetFuelInfoListStart::operator != (const GetFuelInfoListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelInfoListStart::operator < (const GetFuelInfoListStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasFuelType() || rhs.hasFuelType()) {
        if (getFuelType() < rhs.getFuelType()) return true;
        if (getFuelType() > rhs.getFuelType()) return false;
    }
    if (hasSortType() || rhs.hasSortType()) {
        if ((uint32)getSortType() < (uint32)rhs.getSortType()) return true;
        if ((uint32)getSortType() > (uint32)rhs.getSortType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFuelInfoListStart::clone() {
    return new GetFuelInfoListStart(*this);
}

inline bool GetFuelInfoListStart::operator > (const GetFuelInfoListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelInfoListStart::clear() {
    clearListID();
    clearOperation();
    clearBrand();
    clearFuelType();
    clearSortType();
}

inline void GetFuelInfoListStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFuelInfoListStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFuelInfoListStart::getListID () const {
    return _ListID;
}

inline void GetFuelInfoListStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFuelInfoListStart::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetFuelInfoListStart::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetFuelInfoListStart::getOperation () const {
    return _Operation;
}

inline void GetFuelInfoListStart::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFuelInfoListStart");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetFuelInfoListStart::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool GetFuelInfoListStart::hasBrand () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& GetFuelInfoListStart::getBrand () const {
    return _Brand;
}

inline ::std::string& GetFuelInfoListStart::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void GetFuelInfoListStart::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void GetFuelInfoListStart::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void GetFuelInfoListStart::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void GetFuelInfoListStart::clearFuelType() {
    if (hasFuelType()) {
         clear_has_FuelType();
        _FuelType.clear();
     }
}

inline bool GetFuelInfoListStart::hasFuelType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& GetFuelInfoListStart::getFuelType () const {
    return _FuelType;
}

inline ::sxm_fuel_main_fi_types::T_FuelTypeInfo& GetFuelInfoListStart::getFuelTypeMutable () {
    set_has_FuelType();
    return _FuelType;
}

inline void GetFuelInfoListStart::setFuelType (const ::sxm_fuel_main_fi_types::T_FuelTypeInfo& FuelType_) {
    set_has_FuelType();
    this->_FuelType = FuelType_;
}

inline void GetFuelInfoListStart::clearSortType() {
    if (hasSortType()) {
         clear_has_SortType();
        _SortType = ::sxm_fuel_main_fi_types::T_e8_SortType__FUEL_SORT_BY_NONE;
     }
}

inline bool GetFuelInfoListStart::hasSortType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::sxm_fuel_main_fi_types::T_e8_SortType GetFuelInfoListStart::getSortType () const {
    return _SortType;
}

inline void GetFuelInfoListStart::setSortType (::sxm_fuel_main_fi_types::T_e8_SortType SortType_) {
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8_SortType_IsValid(SortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SortType_, "T_e8_SortType", "SortType", "GetFuelInfoListStart");
    }
    #endif
    set_has_SortType();
    this->_SortType = SortType_;
}

inline void GetFuelInfoListStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelInfoListStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFuelInfoListStart::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFuelInfoListStart::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetFuelInfoListStart::set_has_Brand () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetFuelInfoListStart::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetFuelInfoListStart::set_has_FuelType () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetFuelInfoListStart::clear_has_FuelType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetFuelInfoListStart::set_has_SortType () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetFuelInfoListStart::clear_has_SortType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetFuelInfoListResult::GetFuelInfoListResult ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _FuelInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelInfoListResult::GetFuelInfoListResult (const GetFuelInfoListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _FuelInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelInfoListResult::GetFuelInfoListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_fuel_main_fi_types::T_FuelInfoList& FuelInfoList_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _ListInfo (ListInfo_),
    _FuelInfoList (FuelInfoList_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFuelInfoListResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelInfoListResult::~GetFuelInfoListResult() {
}

inline GetFuelInfoListResult& GetFuelInfoListResult::operator = (const GetFuelInfoListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
        if (rhs.hasFuelInfoList()) {
            setFuelInfoList(rhs.getFuelInfoList());
        } else {
            clearFuelInfoList();
        }
    }
    return *this;
}

inline bool GetFuelInfoListResult::operator == (const GetFuelInfoListResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()) &&
        ((!hasFuelInfoList() && !rhs.hasFuelInfoList()) || getFuelInfoList() == rhs.getFuelInfoList()));
}

inline bool GetFuelInfoListResult::operator != (const GetFuelInfoListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelInfoListResult::operator < (const GetFuelInfoListResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    if (hasFuelInfoList() || rhs.hasFuelInfoList()) {
        if (getFuelInfoList() < rhs.getFuelInfoList()) return true;
        if (getFuelInfoList() > rhs.getFuelInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFuelInfoListResult::clone() {
    return new GetFuelInfoListResult(*this);
}

inline bool GetFuelInfoListResult::operator > (const GetFuelInfoListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelInfoListResult::clear() {
    clearListID();
    clearOperation();
    clearListInfo();
    clearFuelInfoList();
}

inline void GetFuelInfoListResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFuelInfoListResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFuelInfoListResult::getListID () const {
    return _ListID;
}

inline void GetFuelInfoListResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFuelInfoListResult::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetFuelInfoListResult::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetFuelInfoListResult::getOperation () const {
    return _Operation;
}

inline void GetFuelInfoListResult::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetFuelInfoListResult");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetFuelInfoListResult::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool GetFuelInfoListResult::hasListInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfo& GetFuelInfoListResult::getListInfo () const {
    return _ListInfo;
}

inline ::sxm_main_fi_types::T_SxmListInfo& GetFuelInfoListResult::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void GetFuelInfoListResult::setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void GetFuelInfoListResult::clearFuelInfoList() {
    if (hasFuelInfoList()) {
         clear_has_FuelInfoList();
        _FuelInfoList.clear();
     }
}

inline bool GetFuelInfoListResult::hasFuelInfoList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_fuel_main_fi_types::T_FuelInfoList& GetFuelInfoListResult::getFuelInfoList () const {
    return _FuelInfoList;
}

inline ::sxm_fuel_main_fi_types::T_FuelInfoList& GetFuelInfoListResult::getFuelInfoListMutable () {
    set_has_FuelInfoList();
    return _FuelInfoList;
}

inline void GetFuelInfoListResult::setFuelInfoList (const ::sxm_fuel_main_fi_types::T_FuelInfoList& FuelInfoList_) {
    set_has_FuelInfoList();
    this->_FuelInfoList = FuelInfoList_;
}

inline void GetFuelInfoListResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelInfoListResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFuelInfoListResult::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFuelInfoListResult::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetFuelInfoListResult::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetFuelInfoListResult::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetFuelInfoListResult::set_has_FuelInfoList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetFuelInfoListResult::clear_has_FuelInfoList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetFuelInfoListErrorStructure::GetFuelInfoListErrorStructure ()  :
    _ErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelInfoListErrorStructure::GetFuelInfoListErrorStructure (const GetFuelInfoListErrorStructure &rhs)  :
    _ErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelInfoListErrorStructure::GetFuelInfoListErrorStructure (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8FuelErrorTypes", "ErrorCode", "GetFuelInfoListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelInfoListErrorStructure::~GetFuelInfoListErrorStructure() {
}

inline GetFuelInfoListErrorStructure& GetFuelInfoListErrorStructure::operator = (const GetFuelInfoListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetFuelInfoListErrorStructure::operator == (const GetFuelInfoListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetFuelInfoListErrorStructure::operator != (const GetFuelInfoListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelInfoListErrorStructure::operator < (const GetFuelInfoListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetFuelInfoListErrorStructure::operator > (const GetFuelInfoListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelInfoListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetFuelInfoListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY;
     }
}

inline bool GetFuelInfoListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes GetFuelInfoListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetFuelInfoListErrorStructure::setErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8FuelErrorTypes", "ErrorCode", "GetFuelInfoListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetFuelInfoListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelInfoListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFuelInfoListError::GetFuelInfoListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetFuelInfoListError::GetFuelInfoListError (const GetFuelInfoListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetFuelInfoListError::~GetFuelInfoListError() {
    deleteData ();
}

inline GetFuelInfoListError& GetFuelInfoListError::operator = (const GetFuelInfoListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetFuelInfoListError::operator == (const GetFuelInfoListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetFuelInfoListError::operator != (const GetFuelInfoListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelInfoListError::operator < (const GetFuelInfoListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetFuelInfoListError::operator > (const GetFuelInfoListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetFuelInfoListError::GetFuelInfoListErrorField GetFuelInfoListError::getField () const {
    return __field;
}

inline void GetFuelInfoListError::setField(GetFuelInfoListError::GetFuelInfoListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetFuelInfoListError::clone() {
    return new GetFuelInfoListError(*this);
}

inline bool GetFuelInfoListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetFuelInfoListErrorStructure& GetFuelInfoListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFuelInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetFuelInfoListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFuelInfoListErrorStructure& GetFuelInfoListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFuelInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFuelInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFuelInfoListErrorStructure* GetFuelInfoListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetFuelInfoListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFuelInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetFuelInfoListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetFuelInfoListError::replaceCcaErrorCode (GetFuelInfoListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetFuelInfoListError::setCcaErrorCode (const GetFuelInfoListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetFuelInfoListErrorStructure(value);
    }
}

inline bool GetFuelInfoListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetFuelInfoListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetFuelInfoListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetFuelInfoListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetFuelInfoListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetFuelInfoListError::cloneData (const GetFuelInfoListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetFuelInfoListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetFuelInfoListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetFuelInfoListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetFuelStationInfoStart::GetFuelStationInfoStart ()  :
    _FUEL_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelStationInfoStart::GetFuelStationInfoStart (const GetFuelStationInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FUEL_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelStationInfoStart::GetFuelStationInfoStart (uint32 FUEL_LOCID_, uint32 ListID_)  :
    _FUEL_LOCID (FUEL_LOCID_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelStationInfoStart::~GetFuelStationInfoStart() {
}

inline GetFuelStationInfoStart& GetFuelStationInfoStart::operator = (const GetFuelStationInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFUEL_LOCID()) {
            setFUEL_LOCID(rhs.getFUEL_LOCID());
        } else {
            clearFUEL_LOCID();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetFuelStationInfoStart::operator == (const GetFuelStationInfoStart& rhs) const {
    return (((!hasFUEL_LOCID() && !rhs.hasFUEL_LOCID()) || getFUEL_LOCID() == rhs.getFUEL_LOCID()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetFuelStationInfoStart::operator != (const GetFuelStationInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelStationInfoStart::operator < (const GetFuelStationInfoStart& rhs) const {
    if (hasFUEL_LOCID() || rhs.hasFUEL_LOCID()) {
        if (getFUEL_LOCID() < rhs.getFUEL_LOCID()) return true;
        if (getFUEL_LOCID() > rhs.getFUEL_LOCID()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFuelStationInfoStart::clone() {
    return new GetFuelStationInfoStart(*this);
}

inline bool GetFuelStationInfoStart::operator > (const GetFuelStationInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelStationInfoStart::clear() {
    clearFUEL_LOCID();
    clearListID();
}

inline void GetFuelStationInfoStart::clearFUEL_LOCID() {
    if (hasFUEL_LOCID()) {
         clear_has_FUEL_LOCID();
        _FUEL_LOCID = 0u;
     }
}

inline bool GetFuelStationInfoStart::hasFUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetFuelStationInfoStart::getFUEL_LOCID () const {
    return _FUEL_LOCID;
}

inline void GetFuelStationInfoStart::setFUEL_LOCID (uint32 FUEL_LOCID_) {
    set_has_FUEL_LOCID();
    this->_FUEL_LOCID = FUEL_LOCID_;
}

inline void GetFuelStationInfoStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFuelStationInfoStart::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetFuelStationInfoStart::getListID () const {
    return _ListID;
}

inline void GetFuelStationInfoStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFuelStationInfoStart::set_has_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelStationInfoStart::clear_has_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFuelStationInfoStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFuelStationInfoStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetFuelStationInfoResult::GetFuelStationInfoResult ()  :
    _FuelStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelStationInfoResult::GetFuelStationInfoResult (const GetFuelStationInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _FuelStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelStationInfoResult::GetFuelStationInfoResult (const ::sxm_fuel_main_fi_types::T_FuelStationInfo& FuelStationInfo_, uint32 ListID_)  :
    _FuelStationInfo (FuelStationInfo_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelStationInfoResult::~GetFuelStationInfoResult() {
}

inline GetFuelStationInfoResult& GetFuelStationInfoResult::operator = (const GetFuelStationInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFuelStationInfo()) {
            setFuelStationInfo(rhs.getFuelStationInfo());
        } else {
            clearFuelStationInfo();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetFuelStationInfoResult::operator == (const GetFuelStationInfoResult& rhs) const {
    return (((!hasFuelStationInfo() && !rhs.hasFuelStationInfo()) || getFuelStationInfo() == rhs.getFuelStationInfo()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetFuelStationInfoResult::operator != (const GetFuelStationInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelStationInfoResult::operator < (const GetFuelStationInfoResult& rhs) const {
    if (hasFuelStationInfo() || rhs.hasFuelStationInfo()) {
        if (getFuelStationInfo() < rhs.getFuelStationInfo()) return true;
        if (getFuelStationInfo() > rhs.getFuelStationInfo()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetFuelStationInfoResult::clone() {
    return new GetFuelStationInfoResult(*this);
}

inline bool GetFuelStationInfoResult::operator > (const GetFuelStationInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelStationInfoResult::clear() {
    clearFuelStationInfo();
    clearListID();
}

inline void GetFuelStationInfoResult::clearFuelStationInfo() {
    if (hasFuelStationInfo()) {
         clear_has_FuelStationInfo();
        _FuelStationInfo.clear();
     }
}

inline bool GetFuelStationInfoResult::hasFuelStationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_fuel_main_fi_types::T_FuelStationInfo& GetFuelStationInfoResult::getFuelStationInfo () const {
    return _FuelStationInfo;
}

inline ::sxm_fuel_main_fi_types::T_FuelStationInfo& GetFuelStationInfoResult::getFuelStationInfoMutable () {
    set_has_FuelStationInfo();
    return _FuelStationInfo;
}

inline void GetFuelStationInfoResult::setFuelStationInfo (const ::sxm_fuel_main_fi_types::T_FuelStationInfo& FuelStationInfo_) {
    set_has_FuelStationInfo();
    this->_FuelStationInfo = FuelStationInfo_;
}

inline void GetFuelStationInfoResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetFuelStationInfoResult::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetFuelStationInfoResult::getListID () const {
    return _ListID;
}

inline void GetFuelStationInfoResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetFuelStationInfoResult::set_has_FuelStationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelStationInfoResult::clear_has_FuelStationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetFuelStationInfoResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetFuelStationInfoResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetFuelStationInfoErrorStructure::GetFuelStationInfoErrorStructure ()  :
    _ErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetFuelStationInfoErrorStructure::GetFuelStationInfoErrorStructure (const GetFuelStationInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetFuelStationInfoErrorStructure::GetFuelStationInfoErrorStructure (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8FuelErrorTypes", "ErrorCode", "GetFuelStationInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetFuelStationInfoErrorStructure::~GetFuelStationInfoErrorStructure() {
}

inline GetFuelStationInfoErrorStructure& GetFuelStationInfoErrorStructure::operator = (const GetFuelStationInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetFuelStationInfoErrorStructure::operator == (const GetFuelStationInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetFuelStationInfoErrorStructure::operator != (const GetFuelStationInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelStationInfoErrorStructure::operator < (const GetFuelStationInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetFuelStationInfoErrorStructure::operator > (const GetFuelStationInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetFuelStationInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetFuelStationInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes__FUEL_INFOLIST_EMPTY;
     }
}

inline bool GetFuelStationInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_fuel_main_fi_types::T_e8FuelErrorTypes GetFuelStationInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetFuelStationInfoErrorStructure::setErrorCode (::sxm_fuel_main_fi_types::T_e8FuelErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_fuel_main_fi_types::T_e8FuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8FuelErrorTypes", "ErrorCode", "GetFuelStationInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetFuelStationInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetFuelStationInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetFuelStationInfoError::GetFuelStationInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetFuelStationInfoError::GetFuelStationInfoError (const GetFuelStationInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetFuelStationInfoError::~GetFuelStationInfoError() {
    deleteData ();
}

inline GetFuelStationInfoError& GetFuelStationInfoError::operator = (const GetFuelStationInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetFuelStationInfoError::operator == (const GetFuelStationInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetFuelStationInfoError::operator != (const GetFuelStationInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetFuelStationInfoError::operator < (const GetFuelStationInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetFuelStationInfoError::operator > (const GetFuelStationInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetFuelStationInfoError::GetFuelStationInfoErrorField GetFuelStationInfoError::getField () const {
    return __field;
}

inline void GetFuelStationInfoError::setField(GetFuelStationInfoError::GetFuelStationInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetFuelStationInfoError::clone() {
    return new GetFuelStationInfoError(*this);
}

inline bool GetFuelStationInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetFuelStationInfoErrorStructure& GetFuelStationInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFuelStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetFuelStationInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFuelStationInfoErrorStructure& GetFuelStationInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetFuelStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFuelStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetFuelStationInfoErrorStructure* GetFuelStationInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetFuelStationInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetFuelStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetFuelStationInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetFuelStationInfoError::replaceCcaErrorCode (GetFuelStationInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetFuelStationInfoError::setCcaErrorCode (const GetFuelStationInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetFuelStationInfoErrorStructure(value);
    }
}

inline bool GetFuelStationInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetFuelStationInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetFuelStationInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetFuelStationInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetFuelStationInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetFuelStationInfoError::cloneData (const GetFuelStationInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetFuelStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetFuelStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetFuelStationInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (uint32 FUEL_LOCID_)  :
    _FUEL_LOCID (FUEL_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFUEL_LOCID()) {
            setFUEL_LOCID(rhs.getFUEL_LOCID());
        } else {
            clearFUEL_LOCID();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasFUEL_LOCID() && !rhs.hasFUEL_LOCID()) || getFUEL_LOCID() == rhs.getFUEL_LOCID()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasFUEL_LOCID() || rhs.hasFUEL_LOCID()) {
        if (getFUEL_LOCID() < rhs.getFUEL_LOCID()) return true;
        if (getFUEL_LOCID() > rhs.getFUEL_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearFUEL_LOCID();
}

inline void AddFavoriteStart::clearFUEL_LOCID() {
    if (hasFUEL_LOCID()) {
         clear_has_FUEL_LOCID();
        _FUEL_LOCID = 0u;
     }
}

inline bool AddFavoriteStart::hasFUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AddFavoriteStart::getFUEL_LOCID () const {
    return _FUEL_LOCID;
}

inline void AddFavoriteStart::setFUEL_LOCID (uint32 FUEL_LOCID_) {
    set_has_FUEL_LOCID();
    this->_FUEL_LOCID = FUEL_LOCID_;
}

inline void AddFavoriteStart::set_has_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearStatus();
}

inline void AddFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AddFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AddFavoriteResult::getStatus () const {
    return _Status;
}

inline void AddFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AddFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (uint32 FUEL_LOCID_)  :
    _FUEL_LOCID (FUEL_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFUEL_LOCID()) {
            setFUEL_LOCID(rhs.getFUEL_LOCID());
        } else {
            clearFUEL_LOCID();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasFUEL_LOCID() && !rhs.hasFUEL_LOCID()) || getFUEL_LOCID() == rhs.getFUEL_LOCID()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasFUEL_LOCID() || rhs.hasFUEL_LOCID()) {
        if (getFUEL_LOCID() < rhs.getFUEL_LOCID()) return true;
        if (getFUEL_LOCID() > rhs.getFUEL_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearFUEL_LOCID();
}

inline void RemoveFavoriteStart::clearFUEL_LOCID() {
    if (hasFUEL_LOCID()) {
         clear_has_FUEL_LOCID();
        _FUEL_LOCID = 0u;
     }
}

inline bool RemoveFavoriteStart::hasFUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RemoveFavoriteStart::getFUEL_LOCID () const {
    return _FUEL_LOCID;
}

inline void RemoveFavoriteStart::setFUEL_LOCID (uint32 FUEL_LOCID_) {
    set_has_FUEL_LOCID();
    this->_FUEL_LOCID = FUEL_LOCID_;
}

inline void RemoveFavoriteStart::set_has_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearStatus();
}

inline void RemoveFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RemoveFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getStatus () const {
    return _Status;
}

inline void RemoveFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RemoveFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FuelInfoListsStatusStatus::FuelInfoListsStatusStatus ()  :
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FuelInfoListsStatusStatus::FuelInfoListsStatusStatus (const FuelInfoListsStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FuelInfoListsStatusStatus::FuelInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_)  :
    _InfoList (InfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FuelInfoListsStatusStatus::~FuelInfoListsStatusStatus() {
}

inline FuelInfoListsStatusStatus& FuelInfoListsStatusStatus::operator = (const FuelInfoListsStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInfoList()) {
            setInfoList(rhs.getInfoList());
        } else {
            clearInfoList();
        }
    }
    return *this;
}

inline bool FuelInfoListsStatusStatus::operator == (const FuelInfoListsStatusStatus& rhs) const {
    return (((!hasInfoList() && !rhs.hasInfoList()) || getInfoList() == rhs.getInfoList()));
}

inline bool FuelInfoListsStatusStatus::operator != (const FuelInfoListsStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FuelInfoListsStatusStatus::operator < (const FuelInfoListsStatusStatus& rhs) const {
    if (hasInfoList() || rhs.hasInfoList()) {
        if (getInfoList() < rhs.getInfoList()) return true;
        if (getInfoList() > rhs.getInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FuelInfoListsStatusStatus::clone() {
    return new FuelInfoListsStatusStatus(*this);
}

inline bool FuelInfoListsStatusStatus::operator > (const FuelInfoListsStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FuelInfoListsStatusStatus::clear() {
    clearInfoList();
}

inline void FuelInfoListsStatusStatus::clearInfoList() {
    if (hasInfoList()) {
         clear_has_InfoList();
        _InfoList.clear();
     }
}

inline bool FuelInfoListsStatusStatus::hasInfoList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& FuelInfoListsStatusStatus::getInfoList () const {
    return _InfoList;
}

inline ::sxm_main_fi_types::T_SxmListInfos& FuelInfoListsStatusStatus::getInfoListMutable () {
    set_has_InfoList();
    return _InfoList;
}

inline void FuelInfoListsStatusStatus::setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_) {
    set_has_InfoList();
    this->_InfoList = InfoList_;
}

inline void FuelInfoListsStatusStatus::set_has_InfoList () {
    _has_bits_[0] |= 1u << 0;
}

inline void FuelInfoListsStatusStatus::clear_has_InfoList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FuelBrandNameListStatus::FuelBrandNameListStatus ()  :
    _BrandName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FuelBrandNameListStatus::FuelBrandNameListStatus (const FuelBrandNameListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _BrandName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FuelBrandNameListStatus::FuelBrandNameListStatus (const ::sxm_fuel_main_fi_types::T_BrandNameList& BrandName_)  :
    _BrandName (BrandName_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FuelBrandNameListStatus::~FuelBrandNameListStatus() {
}

inline FuelBrandNameListStatus& FuelBrandNameListStatus::operator = (const FuelBrandNameListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBrandName()) {
            setBrandName(rhs.getBrandName());
        } else {
            clearBrandName();
        }
    }
    return *this;
}

inline bool FuelBrandNameListStatus::operator == (const FuelBrandNameListStatus& rhs) const {
    return (((!hasBrandName() && !rhs.hasBrandName()) || getBrandName() == rhs.getBrandName()));
}

inline bool FuelBrandNameListStatus::operator != (const FuelBrandNameListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FuelBrandNameListStatus::operator < (const FuelBrandNameListStatus& rhs) const {
    if (hasBrandName() || rhs.hasBrandName()) {
        if (getBrandName() < rhs.getBrandName()) return true;
        if (getBrandName() > rhs.getBrandName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FuelBrandNameListStatus::clone() {
    return new FuelBrandNameListStatus(*this);
}

inline bool FuelBrandNameListStatus::operator > (const FuelBrandNameListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FuelBrandNameListStatus::clear() {
    clearBrandName();
}

inline void FuelBrandNameListStatus::clearBrandName() {
    if (hasBrandName()) {
         clear_has_BrandName();
        _BrandName.clear();
     }
}

inline bool FuelBrandNameListStatus::hasBrandName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_fuel_main_fi_types::T_BrandNameList& FuelBrandNameListStatus::getBrandName () const {
    return _BrandName;
}

inline ::sxm_fuel_main_fi_types::T_BrandNameList& FuelBrandNameListStatus::getBrandNameMutable () {
    set_has_BrandName();
    return _BrandName;
}

inline void FuelBrandNameListStatus::setBrandName (const ::sxm_fuel_main_fi_types::T_BrandNameList& BrandName_) {
    set_has_BrandName();
    this->_BrandName = BrandName_;
}

inline void FuelBrandNameListStatus::set_has_BrandName () {
    _has_bits_[0] |= 1u << 0;
}

inline void FuelBrandNameListStatus::clear_has_BrandName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FuelTypeListStatus::FuelTypeListStatus ()  :
    _TypeName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FuelTypeListStatus::FuelTypeListStatus (const FuelTypeListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TypeName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FuelTypeListStatus::FuelTypeListStatus (const ::sxm_fuel_main_fi_types::T_FuelTypeList& TypeName_)  :
    _TypeName (TypeName_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FuelTypeListStatus::~FuelTypeListStatus() {
}

inline FuelTypeListStatus& FuelTypeListStatus::operator = (const FuelTypeListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTypeName()) {
            setTypeName(rhs.getTypeName());
        } else {
            clearTypeName();
        }
    }
    return *this;
}

inline bool FuelTypeListStatus::operator == (const FuelTypeListStatus& rhs) const {
    return (((!hasTypeName() && !rhs.hasTypeName()) || getTypeName() == rhs.getTypeName()));
}

inline bool FuelTypeListStatus::operator != (const FuelTypeListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FuelTypeListStatus::operator < (const FuelTypeListStatus& rhs) const {
    if (hasTypeName() || rhs.hasTypeName()) {
        if (getTypeName() < rhs.getTypeName()) return true;
        if (getTypeName() > rhs.getTypeName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FuelTypeListStatus::clone() {
    return new FuelTypeListStatus(*this);
}

inline bool FuelTypeListStatus::operator > (const FuelTypeListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FuelTypeListStatus::clear() {
    clearTypeName();
}

inline void FuelTypeListStatus::clearTypeName() {
    if (hasTypeName()) {
         clear_has_TypeName();
        _TypeName.clear();
     }
}

inline bool FuelTypeListStatus::hasTypeName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_fuel_main_fi_types::T_FuelTypeList& FuelTypeListStatus::getTypeName () const {
    return _TypeName;
}

inline ::sxm_fuel_main_fi_types::T_FuelTypeList& FuelTypeListStatus::getTypeNameMutable () {
    set_has_TypeName();
    return _TypeName;
}

inline void FuelTypeListStatus::setTypeName (const ::sxm_fuel_main_fi_types::T_FuelTypeList& TypeName_) {
    set_has_TypeName();
    this->_TypeName = TypeName_;
}

inline void FuelTypeListStatus::set_has_TypeName () {
    _has_bits_[0] |= 1u << 0;
}

inline void FuelTypeListStatus::clear_has_TypeName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_fuel_main_fi

#endif // SXM_FUEL_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
