/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CANADIAN_FUEL_MAIN_FIPROXY_H
#define SXM_CANADIAN_FUEL_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "sxm_canadian_fuel_main_fi.h"
#include "sxm_canadian_fuel_main_fi_types.h"
#include "sxm_canadian_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <string>

namespace sxm_canadian_fuel_main_fi {

class Sxm_canadian_fuel_main_fiProxy;

class AddFavoriteCallbackIF {
public:
    virtual ~AddFavoriteCallbackIF() {}

    virtual void onAddFavoriteError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteError >& error) = 0;

    virtual void onAddFavoriteResult(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< AddFavoriteResult >& result) = 0;
};

class CanadianFuelBrandNameListCallbackIF {
public:
    virtual ~CanadianFuelBrandNameListCallbackIF() {}

    virtual void onCanadianFuelBrandNameListError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelBrandNameListError >& error) = 0;

    virtual void onCanadianFuelBrandNameListStatus(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelBrandNameListStatus >& status) = 0;
};

class CanadianFuelInfoListsStatusCallbackIF {
public:
    virtual ~CanadianFuelInfoListsStatusCallbackIF() {}

    virtual void onCanadianFuelInfoListsStatusError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelInfoListsStatusError >& error) = 0;

    virtual void onCanadianFuelInfoListsStatusStatus(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelInfoListsStatusStatus >& status) = 0;
};

class CanadianFuelTypeListCallbackIF {
public:
    virtual ~CanadianFuelTypeListCallbackIF() {}

    virtual void onCanadianFuelTypeListError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelTypeListError >& error) = 0;

    virtual void onCanadianFuelTypeListStatus(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< CanadianFuelTypeListStatus >& status) = 0;
};

class GetCanadianFuelInfoListCallbackIF {
public:
    virtual ~GetCanadianFuelInfoListCallbackIF() {}

    virtual void onGetCanadianFuelInfoListError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetCanadianFuelInfoListError >& error) = 0;

    virtual void onGetCanadianFuelInfoListResult(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetCanadianFuelInfoListResult >& result) = 0;
};

class GetCanadianFuelStationInfoCallbackIF {
public:
    virtual ~GetCanadianFuelStationInfoCallbackIF() {}

    virtual void onGetCanadianFuelStationInfoError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetCanadianFuelStationInfoError >& error) = 0;

    virtual void onGetCanadianFuelStationInfoResult(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< GetCanadianFuelStationInfoResult >& result) = 0;
};

class RemoveFavoriteCallbackIF {
public:
    virtual ~RemoveFavoriteCallbackIF() {}

    virtual void onRemoveFavoriteError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteError >& error) = 0;

    virtual void onRemoveFavoriteResult(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< RemoveFavoriteResult >& result) = 0;
};

class SetListsConfigCallbackIF {
public:
    virtual ~SetListsConfigCallbackIF() {}

    virtual void onSetListsConfigError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigError >& error) = 0;

    virtual void onSetListsConfigResult(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SetListsConfigResult >& result) = 0;
};

class SxmDataServiceStatusCallbackIF {
public:
    virtual ~SxmDataServiceStatusCallbackIF() {}

    virtual void onSxmDataServiceStatusError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusError >& error) = 0;

    virtual void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmDataServiceStatusStatus >& status) = 0;
};

class SxmListModeCallbackIF {
public:
    virtual ~SxmListModeCallbackIF() {}

    virtual void onSxmListModeError(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeError >& error) = 0;

    virtual void onSxmListModeStatus(const ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >& proxy, const ::boost::shared_ptr< SxmListModeStatus >& status) = 0;
};

class Sxm_canadian_fuel_main_fiProxyCallback;

/**
 * Sxm_canadian_fuel_main_fiProxy is the client side representation of the
 * CCA Functional Interface 'sxm_canadian_fuel_main_fi' (specified in file
 * sxm_canadian_fuel_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_canadian_fuel_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Canadian Fuel
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Naba Kishore Behera (Canadian Fuel)
 *
 * Date: $Date:   Jun 26 2015  10:00 AM  $
 *
 * Department: ECV2
 *
 * Title: sxm_canadian_fuel_main_fi
 *
 * <b>Description of 'sxm_canadian_fuel_main_fi':</b>
 *
 * RBEI
 */
class Sxm_canadian_fuel_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_canadian_fuel_main_fiProxy. The caller has
     * to pass the port name and the service information. It is only possible
     * to use this function if the port is defined in the CMC model as "wired
     * at runtime"-port. The application id of the CCA Server will be
     * determined with help of the CCA SrvSupplier messages. It's guranteed
     * that the corresponding CCA server will have the specified major version
     * and at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_canadian_fuel_main_fiProxy. The caller has
     * to pass the port name and the service information. It is only possible
     * to use this function if the port is defined in the CMC model as "wired
     * at runtime"-port. The proxy will connect to the CCA application
     * specified by appId. The CCA SrvSupplier messages will be used to
     * determine the availability of this application and the service. It's
     * guranteed that the corresponding CCA server will have the specified
     * major version and at least the specified minor version of that
     * interface.
     */
    static ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_canadian_fuel_main_fiProxy. The caller has
     * to pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_canadian_fuel_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Sxm_canadian_fuel_main_fiProxy();

    // Method 'GetCanadianFuelInfoList'

    /**
     * Call the method 'GetCanadianFuelInfoList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetCanadianFuelInfoList'</b>:
     *
     * This method is used to get canadian fuel information
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ListID Canadian Fuel type information to filter canadian fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param Operation Operation to be performed
     *
     * @param Brand Brand name to filter canadian fuel info
     *
     * @param CanadianFuelType Canadian Fuel type information to filter canadian fuel info
     *
     * @param SortType SortType for sort operation
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetCanadianFuelInfoListStart(GetCanadianFuelInfoListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, const ::std::string& brand, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& canadianFuelType, ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType sortType);

    // Method 'GetCanadianFuelStationInfo'

    /**
     * Call the method 'GetCanadianFuelStationInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetCanadianFuelStationInfo'</b>:
     *
     * Get Canadian Fuel information for a canadian fuel station
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param CANADIAN_FUEL_LOCID Loc ID as input
     *
     * @param ListID Location Type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetCanadianFuelStationInfoStart(GetCanadianFuelStationInfoCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID, uint32 listID);

    // Method 'AddFavorite'

    /**
     * Call the method 'AddFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddFavorite'</b>:
     *
     * This method is used to add canadian fuel station
     * information into favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param CANADIAN_FUEL_LOCID Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID);

    // Method 'RemoveFavorite'

    /**
     * Call the method 'RemoveFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RemoveFavorite'</b>:
     *
     * This method is used to Remove canadian fuel station
     * information from favorite list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param CANADIAN_FUEL_LOCID Location ID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID);

    // Method 'SetListsConfig'

    /**
     * Call the method 'SetListsConfig'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetListsConfig'</b>:
     *
     * This method is used to configure all lists
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Config Generic configuration for all list of canadian fuel
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config);

    // Property 'CanadianFuelInfoListsStatus'

    /**
     * Notify on the property 'CanadianFuelInfoListsStatus'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelInfoListsStatusUpReg(CanadianFuelInfoListsStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CanadianFuelInfoListsStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param act The act which was previously returned by the
     * sendCanadianFuelInfoListsStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCanadianFuelInfoListsStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CanadianFuelInfoListsStatus'.
     */
    void sendCanadianFuelInfoListsStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'CanadianFuelInfoListsStatus'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCanadianFuelInfoListsStatus() returns true.
     *
     * @return the previously received value of the property 'CanadianFuelInfoListsStatus'.
     */
    const CanadianFuelInfoListsStatusStatus& getCanadianFuelInfoListsStatus() const;

    /**
     * Determines whether a status message for the property 'CanadianFuelInfoListsStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanadianFuelInfoListsStatus() const;

    /**
     * Request the value of the property 'CanadianFuelInfoListsStatus' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelInfoListsStatus'</b>:
     *
     * Status of all configured Lists
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelInfoListsStatusGet(CanadianFuelInfoListsStatusCallbackIF& cb);

    // Property 'CanadianFuelBrandNameList'

    /**
     * Notify on the property 'CanadianFuelBrandNameList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelBrandNameListUpReg(CanadianFuelBrandNameListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CanadianFuelBrandNameList'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param act The act which was previously returned by the
     * sendCanadianFuelBrandNameListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCanadianFuelBrandNameListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CanadianFuelBrandNameList'.
     */
    void sendCanadianFuelBrandNameListRelUpRegAll ();

    /**
     * Returns the current value of the property 'CanadianFuelBrandNameList'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCanadianFuelBrandNameList() returns true.
     *
     * @return the previously received value of the property 'CanadianFuelBrandNameList'.
     */
    const CanadianFuelBrandNameListStatus& getCanadianFuelBrandNameList() const;

    /**
     * Determines whether a status message for the property 'CanadianFuelBrandNameList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanadianFuelBrandNameList() const;

    /**
     * Request the value of the property 'CanadianFuelBrandNameList' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelBrandNameList'</b>:
     *
     * Get all Avalable Brand Names.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelBrandNameListGet(CanadianFuelBrandNameListCallbackIF& cb);

    // Property 'CanadianFuelTypeList'

    /**
     * Notify on the property 'CanadianFuelTypeList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelTypeList'</b>:
     *
     * Get all Avalable Canadian Fuel type Names.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelTypeListUpReg(CanadianFuelTypeListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CanadianFuelTypeList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelTypeList'</b>:
     *
     * Get all Avalable Canadian Fuel type Names.
     *
     * @param act The act which was previously returned by the
     * sendCanadianFuelTypeListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCanadianFuelTypeListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CanadianFuelTypeList'.
     */
    void sendCanadianFuelTypeListRelUpRegAll ();

    /**
     * Returns the current value of the property 'CanadianFuelTypeList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCanadianFuelTypeList() returns true.
     *
     * @return the previously received value of the property 'CanadianFuelTypeList'.
     */
    const CanadianFuelTypeListStatus& getCanadianFuelTypeList() const;

    /**
     * Determines whether a status message for the property 'CanadianFuelTypeList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanadianFuelTypeList() const;

    /**
     * Request the value of the property 'CanadianFuelTypeList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'CanadianFuelTypeList'</b>:
     *
     * Get all Avalable Canadian Fuel type Names.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanadianFuelTypeListGet(CanadianFuelTypeListCallbackIF& cb);

    // Property 'SxmDataServiceStatus'

    /**
     * Notify on the property 'SxmDataServiceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Canadian Fuel Data Service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmDataServiceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Canadian Fuel Data Service
     *
     * @param act The act which was previously returned by the
     * sendSxmDataServiceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmDataServiceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmDataServiceStatus'.
     */
    void sendSxmDataServiceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmDataServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSxmDataServiceStatus() returns true.
     *
     * @return the previously received value of the property 'SxmDataServiceStatus'.
     */
    const SxmDataServiceStatusStatus& getSxmDataServiceStatus() const;

    /**
     * Determines whether a status message for the property 'SxmDataServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmDataServiceStatus() const;

    /**
     * Request the value of the property 'SxmDataServiceStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SxmDataServiceStatus'</b>:
     *
     * Get the Status of Canadian Fuel Data Service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb);

    // Property 'SxmListMode'

    /**
     * Notify on the property 'SxmListMode'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Canadian Fuel List.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeUpReg(SxmListModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SxmListMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Canadian Fuel List.
     *
     * @param act The act which was previously returned by the
     * sendSxmListModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSxmListModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SxmListMode'.
     */
    void sendSxmListModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SxmListMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSxmListMode() returns true.
     *
     * @return the previously received value of the property 'SxmListMode'.
     */
    const SxmListModeStatus& getSxmListMode() const;

    /**
     * Determines whether a status message for the property 'SxmListMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSxmListMode() const;

    /**
     * Set the value of the property 'SxmListMode'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'SxmListMode'</b>:
     *
     * Set the Mode of Canadian Fuel List.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param ListMode Set the Mode of Canadian Fuel List
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_canadian_fuel_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'CanadianFuelInfoListsStatus'

    ::asf::core::nullable< CanadianFuelInfoListsStatusStatus > _canadianFuelInfoListsStatus;

    // Property 'CanadianFuelBrandNameList'

    ::asf::core::nullable< CanadianFuelBrandNameListStatus > _canadianFuelBrandNameList;

    // Property 'CanadianFuelTypeList'

    ::asf::core::nullable< CanadianFuelTypeListStatus > _canadianFuelTypeList;

    // Property 'SxmDataServiceStatus'

    ::asf::core::nullable< SxmDataServiceStatusStatus > _sxmDataServiceStatus;

    // Property 'SxmListMode'

    ::asf::core::nullable< SxmListModeStatus > _sxmListMode;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_canadian_fuel_main_fiProxyCallback;
};

} // namespace sxm_canadian_fuel_main_fi

#endif // SXM_CANADIAN_FUEL_MAIN_FIPROXY_H
