/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_canadian_fuel_main_fiCca.h"
#include "sxm_canadian_fuel_main_fiJson.h"
#include "sxm_canadian_fuel_main_fiProxy.h"
#include "sxm_canadian_fuel_main_fi_types.h"
#include "sxm_canadian_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_canadian_fuel_main_fi {

/*static*/ ::asf::core::Logger Sxm_canadian_fuel_main_fiProxy::_logger ("/sxm_canadian_fuel_main_fi/Sxm_canadian_fuel_main_fiProxy");


class Sxm_canadian_fuel_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_canadian_fuel_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_canadian_fuel_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_canadian_fuel_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_GetCanadianFuelInfoList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::GetCanadianFuelInfoListResult);
                                setActAndLogResult(message, "GetCanadianFuelInfoList", reinterpret_cast<act_t>(this), _logger);
                                ((GetCanadianFuelInfoListCallbackIF*) _callback)->onGetCanadianFuelInfoListResult (proxy, ::boost::static_pointer_cast<GetCanadianFuelInfoListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::GetCanadianFuelInfoListError);
                                setActAndLogError(message, "GetCanadianFuelInfoList", reinterpret_cast<act_t>(this), _logger);
                                ((GetCanadianFuelInfoListCallbackIF*) _callback)->onGetCanadianFuelInfoListError (proxy, ::boost::static_pointer_cast<GetCanadianFuelInfoListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetCanadianFuelStationInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::GetCanadianFuelStationInfoResult);
                                setActAndLogResult(message, "GetCanadianFuelStationInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetCanadianFuelStationInfoCallbackIF*) _callback)->onGetCanadianFuelStationInfoResult (proxy, ::boost::static_pointer_cast<GetCanadianFuelStationInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::GetCanadianFuelStationInfoError);
                                setActAndLogError(message, "GetCanadianFuelStationInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GetCanadianFuelStationInfoCallbackIF*) _callback)->onGetCanadianFuelStationInfoError (proxy, ::boost::static_pointer_cast<GetCanadianFuelStationInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AddFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::AddFavoriteResult);
                                setActAndLogResult(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteResult (proxy, ::boost::static_pointer_cast<AddFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::AddFavoriteError);
                                setActAndLogError(message, "AddFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, ::boost::static_pointer_cast<AddFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RemoveFavorite: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::RemoveFavoriteResult);
                                setActAndLogResult(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteResult (proxy, ::boost::static_pointer_cast<RemoveFavoriteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::RemoveFavoriteError);
                                setActAndLogError(message, "RemoveFavorite", reinterpret_cast<act_t>(this), _logger);
                                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, ::boost::static_pointer_cast<RemoveFavoriteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetListsConfig: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SetListsConfigResult);
                                setActAndLogResult(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigResult (proxy, ::boost::static_pointer_cast<SetListsConfigResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SetListsConfigError);
                                setActAndLogError(message, "SetListsConfig", reinterpret_cast<act_t>(this), _logger);
                                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, ::boost::static_pointer_cast<SetListsConfigError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CanadianFuelInfoListsStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusStatus);
                                setActAndLogStatus(message, "CanadianFuelInfoListsStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CanadianFuelInfoListsStatusStatus> payload = ::boost::static_pointer_cast<CanadianFuelInfoListsStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CanadianFuelInfoListsStatusStatus >& refNullableStatus = proxy->_canadianFuelInfoListsStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CanadianFuelInfoListsStatusCallbackIF*) _callback)->onCanadianFuelInfoListsStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelInfoListsStatusCallbackIF*) _callback)->onCanadianFuelInfoListsStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusError);
                                setActAndLogError(message, "CanadianFuelInfoListsStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelInfoListsStatusCallbackIF*) _callback)->onCanadianFuelInfoListsStatusError(proxy, ::boost::static_pointer_cast<CanadianFuelInfoListsStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CanadianFuelBrandNameList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelBrandNameListStatus);
                                setActAndLogStatus(message, "CanadianFuelBrandNameList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CanadianFuelBrandNameListStatus> payload = ::boost::static_pointer_cast<CanadianFuelBrandNameListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CanadianFuelBrandNameListStatus >& refNullableStatus = proxy->_canadianFuelBrandNameList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CanadianFuelBrandNameListCallbackIF*) _callback)->onCanadianFuelBrandNameListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelBrandNameListCallbackIF*) _callback)->onCanadianFuelBrandNameListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelBrandNameListError);
                                setActAndLogError(message, "CanadianFuelBrandNameList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelBrandNameListCallbackIF*) _callback)->onCanadianFuelBrandNameListError(proxy, ::boost::static_pointer_cast<CanadianFuelBrandNameListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CanadianFuelTypeList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelTypeListStatus);
                                setActAndLogStatus(message, "CanadianFuelTypeList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CanadianFuelTypeListStatus> payload = ::boost::static_pointer_cast<CanadianFuelTypeListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CanadianFuelTypeListStatus >& refNullableStatus = proxy->_canadianFuelTypeList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CanadianFuelTypeListCallbackIF*) _callback)->onCanadianFuelTypeListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelTypeListCallbackIF*) _callback)->onCanadianFuelTypeListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelTypeListError);
                                setActAndLogError(message, "CanadianFuelTypeList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CanadianFuelTypeListCallbackIF*) _callback)->onCanadianFuelTypeListError(proxy, ::boost::static_pointer_cast<CanadianFuelTypeListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmDataServiceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmDataServiceStatusStatus);
                                setActAndLogStatus(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmDataServiceStatusStatus> payload = ::boost::static_pointer_cast<SxmDataServiceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmDataServiceStatusStatus >& refNullableStatus = proxy->_sxmDataServiceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmDataServiceStatusError);
                                setActAndLogError(message, "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError(proxy, ::boost::static_pointer_cast<SxmDataServiceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SxmListMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmListModeStatus);
                                setActAndLogStatus(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SxmListModeStatus> payload = ::boost::static_pointer_cast<SxmListModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SxmListModeStatus >& refNullableStatus = proxy->_sxmListMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmListModeError);
                                setActAndLogError(message, "SxmListMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError(proxy, ::boost::static_pointer_cast<SxmListModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_canadian_fuel_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_canadian_fuel_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_GetCanadianFuelInfoList: {
                ::boost::shared_ptr< GetCanadianFuelInfoListError > payload (new GetCanadianFuelInfoListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCanadianFuelInfoList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetCanadianFuelInfoListCallbackIF*) _callback)->onGetCanadianFuelInfoListError (proxy, payload);
                return true;
            }
            case FID_GetCanadianFuelStationInfo: {
                ::boost::shared_ptr< GetCanadianFuelStationInfoError > payload (new GetCanadianFuelStationInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCanadianFuelStationInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetCanadianFuelStationInfoCallbackIF*) _callback)->onGetCanadianFuelStationInfoError (proxy, payload);
                return true;
            }
            case FID_AddFavorite: {
                ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AddFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AddFavoriteCallbackIF*) _callback)->onAddFavoriteError (proxy, payload);
                return true;
            }
            case FID_RemoveFavorite: {
                ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveFavorite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RemoveFavoriteCallbackIF*) _callback)->onRemoveFavoriteError (proxy, payload);
                return true;
            }
            case FID_SetListsConfig: {
                ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetListsConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetListsConfigCallbackIF*) _callback)->onSetListsConfigError (proxy, payload);
                return true;
            }
            case FID_CanadianFuelInfoListsStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CanadianFuelInfoListsStatusError > payload (new CanadianFuelInfoListsStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CanadianFuelInfoListsStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CanadianFuelInfoListsStatusCallbackIF*) _callback)->onCanadianFuelInfoListsStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CanadianFuelBrandNameList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CanadianFuelBrandNameListError > payload (new CanadianFuelBrandNameListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CanadianFuelBrandNameList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CanadianFuelBrandNameListCallbackIF*) _callback)->onCanadianFuelBrandNameListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CanadianFuelTypeList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CanadianFuelTypeListError > payload (new CanadianFuelTypeListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CanadianFuelTypeList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CanadianFuelTypeListCallbackIF*) _callback)->onCanadianFuelTypeListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmDataServiceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmDataServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmDataServiceStatusCallbackIF*) _callback)->onSxmDataServiceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SxmListMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SxmListMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SxmListModeCallbackIF*) _callback)->onSxmListModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_canadian_fuel_main_fiProxyCallback::_logger (Sxm_canadian_fuel_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > Sxm_canadian_fuel_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >  proxyNew(new Sxm_canadian_fuel_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > Sxm_canadian_fuel_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >  proxyNew(new Sxm_canadian_fuel_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy > Sxm_canadian_fuel_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_canadian_fuel_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_canadian_fuel_main_fiProxy >  proxyNew(new Sxm_canadian_fuel_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_canadian_fuel_main_fiProxy::Sxm_canadian_fuel_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_canadian_fuel_main_fiProxy::~Sxm_canadian_fuel_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_canadian_fuel_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendGetCanadianFuelInfoListStart(GetCanadianFuelInfoListCallbackIF& cb, uint32 listID, ::sxm_main_fi_types::T_e8_SxmListOperation operation, const ::std::string& brand, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& canadianFuelType, ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType sortType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetCanadianFuelInfoList);
        ::boost::shared_ptr< GetCanadianFuelInfoListStart > payload (new GetCanadianFuelInfoListStart());
        payload->setListID(listID);
        payload->setOperation(operation);
        payload->setBrand(brand);
        payload->setCanadianFuelType(canadianFuelType);
        payload->setSortType(sortType);
        CCA_MESSAGE(ccaMessage,header,GetCanadianFuelInfoListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetCanadianFuelInfoList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetCanadianFuelInfoList);
        ::boost::shared_ptr< GetCanadianFuelInfoListError > payload (new GetCanadianFuelInfoListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetCanadianFuelInfoListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetCanadianFuelInfoList", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendGetCanadianFuelStationInfoStart(GetCanadianFuelStationInfoCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID, uint32 listID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetCanadianFuelStationInfo);
        ::boost::shared_ptr< GetCanadianFuelStationInfoStart > payload (new GetCanadianFuelStationInfoStart());
        payload->setCANADIAN_FUEL_LOCID(cANADIAN_FUEL_LOCID);
        payload->setListID(listID);
        CCA_MESSAGE(ccaMessage,header,GetCanadianFuelStationInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetCanadianFuelStationInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetCanadianFuelStationInfo);
        ::boost::shared_ptr< GetCanadianFuelStationInfoError > payload (new GetCanadianFuelStationInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetCanadianFuelStationInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetCanadianFuelStationInfo", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendAddFavoriteStart(AddFavoriteCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteStart > payload (new AddFavoriteStart());
        payload->setCANADIAN_FUEL_LOCID(cANADIAN_FUEL_LOCID);
        CCA_MESSAGE(ccaMessage,header,AddFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AddFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AddFavorite);
        ::boost::shared_ptr< AddFavoriteError > payload (new AddFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AddFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AddFavorite", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendRemoveFavoriteStart(RemoveFavoriteCallbackIF& cb, uint32 cANADIAN_FUEL_LOCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteStart > payload (new RemoveFavoriteStart());
        payload->setCANADIAN_FUEL_LOCID(cANADIAN_FUEL_LOCID);
        CCA_MESSAGE(ccaMessage,header,RemoveFavoriteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RemoveFavorite", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RemoveFavorite);
        ::boost::shared_ptr< RemoveFavoriteError > payload (new RemoveFavoriteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RemoveFavoriteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RemoveFavorite", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendSetListsConfigStart(SetListsConfigCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListsConfig& config) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigStart > payload (new SetListsConfigStart());
        payload->setConfig(config);
        CCA_MESSAGE(ccaMessage,header,SetListsConfigStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetListsConfig", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetListsConfig);
        ::boost::shared_ptr< SetListsConfigError > payload (new SetListsConfigError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetListsConfigError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetListsConfig", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelInfoListsStatusUpReg(CanadianFuelInfoListsStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CanadianFuelInfoListsStatus);
        ::boost::shared_ptr< CanadianFuelInfoListsStatusUpReg > payload (new CanadianFuelInfoListsStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelInfoListsStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CanadianFuelInfoListsStatusRelUpReg > payloadRelUpRegHeap (new CanadianFuelInfoListsStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CanadianFuelInfoListsStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CanadianFuelInfoListsStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CanadianFuelInfoListsStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CanadianFuelInfoListsStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCanadianFuelInfoListsStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CanadianFuelInfoListsStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CanadianFuelInfoListsStatusStatus > payloadLoopback (new CanadianFuelInfoListsStatusStatus(getCanadianFuelInfoListsStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CanadianFuelInfoListsStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelInfoListsStatus);
        ::boost::shared_ptr< CanadianFuelInfoListsStatusError > payload (new CanadianFuelInfoListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelInfoListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CanadianFuelInfoListsStatus", &cb);
    }
}

bool Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelInfoListsStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CanadianFuelInfoListsStatus,"CanadianFuelInfoListsStatus");
}

void Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelInfoListsStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CanadianFuelInfoListsStatus);
}

const CanadianFuelInfoListsStatusStatus& Sxm_canadian_fuel_main_fiProxy::getCanadianFuelInfoListsStatus() const {
    return _canadianFuelInfoListsStatus.get();
}

bool Sxm_canadian_fuel_main_fiProxy::hasCanadianFuelInfoListsStatus() const {
    return _canadianFuelInfoListsStatus.hasValue();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelInfoListsStatusGet(CanadianFuelInfoListsStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CanadianFuelInfoListsStatus);
        ::boost::shared_ptr< CanadianFuelInfoListsStatusGet > payload (new CanadianFuelInfoListsStatusGet());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelInfoListsStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CanadianFuelInfoListsStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelInfoListsStatus);
        ::boost::shared_ptr< CanadianFuelInfoListsStatusError > payload (new CanadianFuelInfoListsStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelInfoListsStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CanadianFuelInfoListsStatus", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelBrandNameListUpReg(CanadianFuelBrandNameListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CanadianFuelBrandNameList);
        ::boost::shared_ptr< CanadianFuelBrandNameListUpReg > payload (new CanadianFuelBrandNameListUpReg());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelBrandNameListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CanadianFuelBrandNameListRelUpReg > payloadRelUpRegHeap (new CanadianFuelBrandNameListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CanadianFuelBrandNameList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelBrandNameListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CanadianFuelBrandNameList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CanadianFuelBrandNameList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CanadianFuelBrandNameList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCanadianFuelBrandNameList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CanadianFuelBrandNameList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CanadianFuelBrandNameListStatus > payloadLoopback (new CanadianFuelBrandNameListStatus(getCanadianFuelBrandNameList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CanadianFuelBrandNameListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelBrandNameList);
        ::boost::shared_ptr< CanadianFuelBrandNameListError > payload (new CanadianFuelBrandNameListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelBrandNameListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CanadianFuelBrandNameList", &cb);
    }
}

bool Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelBrandNameListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CanadianFuelBrandNameList,"CanadianFuelBrandNameList");
}

void Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelBrandNameListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CanadianFuelBrandNameList);
}

const CanadianFuelBrandNameListStatus& Sxm_canadian_fuel_main_fiProxy::getCanadianFuelBrandNameList() const {
    return _canadianFuelBrandNameList.get();
}

bool Sxm_canadian_fuel_main_fiProxy::hasCanadianFuelBrandNameList() const {
    return _canadianFuelBrandNameList.hasValue();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelBrandNameListGet(CanadianFuelBrandNameListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CanadianFuelBrandNameList);
        ::boost::shared_ptr< CanadianFuelBrandNameListGet > payload (new CanadianFuelBrandNameListGet());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelBrandNameListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CanadianFuelBrandNameList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelBrandNameList);
        ::boost::shared_ptr< CanadianFuelBrandNameListError > payload (new CanadianFuelBrandNameListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelBrandNameListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CanadianFuelBrandNameList", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelTypeListUpReg(CanadianFuelTypeListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CanadianFuelTypeList);
        ::boost::shared_ptr< CanadianFuelTypeListUpReg > payload (new CanadianFuelTypeListUpReg());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelTypeListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CanadianFuelTypeListRelUpReg > payloadRelUpRegHeap (new CanadianFuelTypeListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CanadianFuelTypeList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::CanadianFuelTypeListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CanadianFuelTypeList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CanadianFuelTypeList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CanadianFuelTypeList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCanadianFuelTypeList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CanadianFuelTypeList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CanadianFuelTypeListStatus > payloadLoopback (new CanadianFuelTypeListStatus(getCanadianFuelTypeList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CanadianFuelTypeListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelTypeList);
        ::boost::shared_ptr< CanadianFuelTypeListError > payload (new CanadianFuelTypeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelTypeListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CanadianFuelTypeList", &cb);
    }
}

bool Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelTypeListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CanadianFuelTypeList,"CanadianFuelTypeList");
}

void Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelTypeListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CanadianFuelTypeList);
}

const CanadianFuelTypeListStatus& Sxm_canadian_fuel_main_fiProxy::getCanadianFuelTypeList() const {
    return _canadianFuelTypeList.get();
}

bool Sxm_canadian_fuel_main_fiProxy::hasCanadianFuelTypeList() const {
    return _canadianFuelTypeList.hasValue();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendCanadianFuelTypeListGet(CanadianFuelTypeListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CanadianFuelTypeList);
        ::boost::shared_ptr< CanadianFuelTypeListGet > payload (new CanadianFuelTypeListGet());
        CCA_MESSAGE(ccaMessage,header,CanadianFuelTypeListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CanadianFuelTypeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CanadianFuelTypeList);
        ::boost::shared_ptr< CanadianFuelTypeListError > payload (new CanadianFuelTypeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CanadianFuelTypeListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CanadianFuelTypeList", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendSxmDataServiceStatusUpReg(SxmDataServiceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusUpReg > payload (new SxmDataServiceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmDataServiceStatusRelUpReg > payloadRelUpRegHeap (new SxmDataServiceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmDataServiceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmDataServiceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmDataServiceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmDataServiceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmDataServiceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmDataServiceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmDataServiceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmDataServiceStatusStatus > payloadLoopback (new SxmDataServiceStatusStatus(getSxmDataServiceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmDataServiceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

bool Sxm_canadian_fuel_main_fiProxy::sendSxmDataServiceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmDataServiceStatus,"SxmDataServiceStatus");
}

void Sxm_canadian_fuel_main_fiProxy::sendSxmDataServiceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmDataServiceStatus);
}

const SxmDataServiceStatusStatus& Sxm_canadian_fuel_main_fiProxy::getSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.get();
}

bool Sxm_canadian_fuel_main_fiProxy::hasSxmDataServiceStatus() const {
    return _sxmDataServiceStatus.hasValue();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendSxmDataServiceStatusGet(SxmDataServiceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusGet > payload (new SxmDataServiceStatusGet());
        CCA_MESSAGE(ccaMessage,header,SxmDataServiceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SxmDataServiceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmDataServiceStatus);
        ::boost::shared_ptr< SxmDataServiceStatusError > payload (new SxmDataServiceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmDataServiceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SxmDataServiceStatus", &cb);
    }
}

act_t Sxm_canadian_fuel_main_fiProxy::sendSxmListModeUpReg(SxmListModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeUpReg > payload (new SxmListModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SxmListModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SxmListModeRelUpReg > payloadRelUpRegHeap (new SxmListModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SxmListMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_canadian_fuel_main_fi::SxmListModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SxmListMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SxmListMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SxmListMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSxmListMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SxmListMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SxmListModeStatus > payloadLoopback (new SxmListModeStatus(getSxmListMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SxmListModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SxmListMode", &cb);
    }
}

bool Sxm_canadian_fuel_main_fiProxy::sendSxmListModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SxmListMode,"SxmListMode");
}

void Sxm_canadian_fuel_main_fiProxy::sendSxmListModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SxmListMode);
}

const SxmListModeStatus& Sxm_canadian_fuel_main_fiProxy::getSxmListMode() const {
    return _sxmListMode.get();
}

bool Sxm_canadian_fuel_main_fiProxy::hasSxmListMode() const {
    return _sxmListMode.hasValue();
}

act_t Sxm_canadian_fuel_main_fiProxy::sendSxmListModeSet(SxmListModeCallbackIF& cb, const ::sxm_main_fi_types::T_SxmListMode& listMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeSet > payload (new SxmListModeSet());
        payload->setListMode(listMode);
        CCA_MESSAGE(ccaMessage,header,SxmListModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SxmListMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SxmListMode);
        ::boost::shared_ptr< SxmListModeError > payload (new SxmListModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SxmListModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SxmListMode", &cb);
    }
}


void Sxm_canadian_fuel_main_fiProxy::clearAllProperties ()
{
    _canadianFuelInfoListsStatus = ::asf::core::nullable<CanadianFuelInfoListsStatusStatus>();
    _canadianFuelBrandNameList = ::asf::core::nullable<CanadianFuelBrandNameListStatus>();
    _canadianFuelTypeList = ::asf::core::nullable<CanadianFuelTypeListStatus>();
    _sxmDataServiceStatus = ::asf::core::nullable<SxmDataServiceStatusStatus>();
    _sxmListMode = ::asf::core::nullable<SxmListModeStatus>();
}

void Sxm_canadian_fuel_main_fiProxy::sendRelUpRegAll()
{
    sendCanadianFuelInfoListsStatusRelUpRegAll();
    sendCanadianFuelBrandNameListRelUpRegAll();
    sendCanadianFuelTypeListRelUpRegAll();
    sendSxmDataServiceStatusRelUpRegAll();
    sendSxmListModeRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_canadian_fuel_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_canadian_fuel_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_canadian_fuel_main_fi
