#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_CANADIAN_FUEL_MAIN_FI_H
#define SXM_CANADIAN_FUEL_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "sxm_canadian_fuel_main_fi_types.h"
#include "sxm_canadian_fuel_main_fi_typesConst.h"
#include "sxm_main_fi_types.h"
#include "sxm_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'sxm_canadian_fuel_main_fi'
 *
 * Fullname: Sirius XM Data Services Functional Interface Specification for Canadian Fuel
 *
 * Version: $Revision:   0.1  $
 *
 * Author: Naba Kishore Behera (Canadian Fuel)
 *
 * Date: $Date:   Jun 26 2015  10:00 AM  $
 *
 * Department: ECV2
 *
 * Title: sxm_canadian_fuel_main_fi
 *
 * <b>Description of 'sxm_canadian_fuel_main_fi':</b>
 *
 * RBEI
 */

namespace sxm_canadian_fuel_main_fi {

static const int SERVICE_ID = 189;

static const int FID_GetCanadianFuelInfoList = 1;

static const int FID_GetCanadianFuelStationInfo = 3;

static const int FID_AddFavorite = 4;

static const int FID_RemoveFavorite = 5;

static const int FID_SetListsConfig = 6;

static const int FID_CanadianFuelInfoListsStatus = 16;

static const int FID_CanadianFuelBrandNameList = 17;

static const int FID_CanadianFuelTypeList = 18;

static const int FID_SxmDataServiceStatus = 19;

static const int FID_SxmListMode = 20;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 1;

// forward declarations
class GetCanadianFuelInfoListStart;

class GetCanadianFuelInfoListResult;

class GetCanadianFuelInfoListErrorStructure;

class GetCanadianFuelInfoListError;

class GetCanadianFuelStationInfoStart;

class GetCanadianFuelStationInfoResult;

class GetCanadianFuelStationInfoErrorStructure;

class GetCanadianFuelStationInfoError;

class AddFavoriteStart;

class AddFavoriteResult;

class RemoveFavoriteStart;

class RemoveFavoriteResult;

class SetListsConfigStart;

class SetListsConfigResult;

class CanadianFuelInfoListsStatusStatus;

class CanadianFuelBrandNameListStatus;

class CanadianFuelTypeListStatus;

class SxmDataServiceStatusStatus;

class SxmListModeStatus;

class SxmListModeSet;

// type definitions
/**
 * The abort error message of the method "GetCanadianFuelInfoList"
 * This method is used to get canadian fuel information
 */
typedef ::asf::cca::CcaTypes::DefaultError GetCanadianFuelInfoListAbortError;

/**
 * The abort error message of the method "GetCanadianFuelStationInfo"
 * Get Canadian Fuel information for a canadian fuel station
 */
typedef ::asf::cca::CcaTypes::DefaultError GetCanadianFuelStationInfoAbortError;

/**
 * The abort error message of the method "AddFavorite"
 * This method is used to add canadian fuel station
 * information into favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteAbortError;

/**
 * The error message of 'AddFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError AddFavoriteError;

/**
 * The abort error message of the method "RemoveFavorite"
 * This method is used to Remove canadian fuel station
 * information from favorite list
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteAbortError;

/**
 * The error message of 'RemoveFavorite'
 */
typedef ::asf::cca::CcaTypes::DefaultError RemoveFavoriteError;

/**
 * The abort error message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigAbortError;

/**
 * The error message of 'SetListsConfig'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetListsConfigError;

/**
 * The get message of the property "CanadianFuelInfoListsStatus"
 * Status of all configured Lists
 * Canadian Fuel information Available
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelInfoListsStatusGet;

/**
 * The upreg message of the property "CanadianFuelInfoListsStatus"
 * Status of all configured Lists
 * Register for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelInfoListsStatusUpReg;

/**
 * The relUpReg message of the property "CanadianFuelInfoListsStatus"
 * Status of all configured Lists
 * Unregister for Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelInfoListsStatusRelUpReg;

/**
 * The error message of 'CanadianFuelInfoListsStatus'
 * todo
 */
typedef ::asf::cca::CcaTypes::DefaultError CanadianFuelInfoListsStatusError;

/**
 * The get message of the property "CanadianFuelBrandNameList"
 * Get all Avalable Brand Names.
 * List of All Avalable brand Name
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelBrandNameListGet;

/**
 * The upreg message of the property "CanadianFuelBrandNameList"
 * Get all Avalable Brand Names.
 * Register for Brand Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelBrandNameListUpReg;

/**
 * The relUpReg message of the property "CanadianFuelBrandNameList"
 * Get all Avalable Brand Names.
 * Unregister for Brand Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelBrandNameListRelUpReg;

/**
 * The error message of 'CanadianFuelBrandNameList'
 * This error code specifies Brand Name List is empty
 */
typedef ::asf::cca::CcaTypes::DefaultError CanadianFuelBrandNameListError;

/**
 * The get message of the property "CanadianFuelTypeList"
 * Get all Avalable Canadian Fuel type Names.
 * List of All Available Canadian Fuel type Name
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelTypeListGet;

/**
 * The upreg message of the property "CanadianFuelTypeList"
 * Get all Avalable Canadian Fuel type Names.
 * Register for Canadian Fuel Type Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelTypeListUpReg;

/**
 * The relUpReg message of the property "CanadianFuelTypeList"
 * Get all Avalable Canadian Fuel type Names.
 * Unregister for Canadian Fuel Type Name List Changes
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CanadianFuelTypeListRelUpReg;

/**
 * The error message of 'CanadianFuelTypeList'
 * This error code specifies Canadian Fuel Type Name List is empty
 */
typedef ::asf::cca::CcaTypes::DefaultError CanadianFuelTypeListError;

/**
 * The get message of the property "SxmDataServiceStatus"
 * Get the Status of Canadian Fuel Data Service
 * Status of Canadian Fuel Data Service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusGet;

/**
 * The upreg message of the property "SxmDataServiceStatus"
 * Get the Status of Canadian Fuel Data Service
 * Register for Canadian Fuel Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusUpReg;

/**
 * The relUpReg message of the property "SxmDataServiceStatus"
 * Get the Status of Canadian Fuel Data Service
 * Unregister for Canadian Fuel Data Service Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmDataServiceStatusRelUpReg;

/**
 * The error message of 'SxmDataServiceStatus'
 * This error code specifies Canadian Fuel Data Service Status is not available
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmDataServiceStatusError;

/**
 * The upreg message of the property "SxmListMode"
 * Set the Mode of Canadian Fuel List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeUpReg;

/**
 * The relUpReg message of the property "SxmListMode"
 * Set the Mode of Canadian Fuel List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SxmListModeRelUpReg;

/**
 * The error message of 'SxmListMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SxmListModeError;


/**
 * The start message of the method "GetCanadianFuelInfoList"
 * This method is used to get canadian fuel information
 */
class GetCanadianFuelInfoListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelInfoListStart ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelInfoListStart (const GetCanadianFuelInfoListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelInfoListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::std::string& Brand_, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& CanadianFuelType_, ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType SortType_);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelInfoListStart();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelInfoListStart& operator = (const GetCanadianFuelInfoListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelInfoListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelInfoListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelInfoListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelInfoListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Canadian Fuel type information to filter canadian fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Canadian Fuel type information to filter canadian fuel info
     * first items according to T_e8_SxmPredefinedListIds
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation to be performed
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "Brand"

    static const int kBrand = 2;

    /**
     * Clears the field "Brand".
     *
     * The field will be set to its default value. The hasBrand()
     * method will return false.
     */
    inline void clearBrand();

    /**
     * Checks whether the field "Brand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrand()). Otherwise it will return false.
     */
    inline bool hasBrand () const;

    /**
     * Returns the value of the member "Brand".
     *
     * Brand name to filter canadian fuel info
     *
     * @return The value of the field "Brand"
     */
    inline const ::std::string& getBrand () const;

    /**
     * Retrieves the value of the field "Brand" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Brand".
     */
    inline ::std::string& getBrandMutable ();

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter canadian fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const ::std::string& Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter canadian fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* Brand_);

    /**
     * Sets the value of the member "Brand".
     *
     * Brand name to filter canadian fuel info
     *
     * @param Brand The value which will be set
     */
    inline void setBrand (const char* value, size_t size);

    // API of field "CanadianFuelType"

    static const int kCanadianFuelType = 3;

    /**
     * Clears the field "CanadianFuelType".
     *
     * The field will be set to its default value. The hasCanadianFuelType()
     * method will return false.
     */
    inline void clearCanadianFuelType();

    /**
     * Checks whether the field "CanadianFuelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanadianFuelType()). Otherwise it will return false.
     */
    inline bool hasCanadianFuelType () const;

    /**
     * Returns the value of the member "CanadianFuelType".
     *
     * Canadian Fuel type information to filter canadian fuel info
     *
     * @return The value of the field "CanadianFuelType"
     */
    inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& getCanadianFuelType () const;

    /**
     * Retrieves the value of the field "CanadianFuelType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanadianFuelType".
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& getCanadianFuelTypeMutable ();

    /**
     * Sets the value of the member "CanadianFuelType".
     *
     * Canadian Fuel type information to filter canadian fuel info
     *
     * @param CanadianFuelType The value which will be set
     */
    inline void setCanadianFuelType (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& CanadianFuelType_);

    // API of field "SortType"

    static const int kSortType = 4;

    /**
     * Clears the field "SortType".
     *
     * The field will be set to its default value. The hasSortType()
     * method will return false.
     */
    inline void clearSortType();

    /**
     * Checks whether the field "SortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSortType()). Otherwise it will return false.
     */
    inline bool hasSortType () const;

    /**
     * Returns the value of the member "SortType".
     *
     * SortType for sort operation
     *
     * @return The value of the field "SortType"
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType getSortType () const;

    /**
     * Sets the value of the member "SortType".
     *
     * SortType for sort operation
     *
     * @param SortType The value which will be set
     */
    inline void setSortType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType SortType_);

    static const GetCanadianFuelInfoListStart &getDefaultInstance();

private:

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_Brand ();

    inline void clear_has_Brand ();

    inline void set_has_CanadianFuelType ();

    inline void clear_has_CanadianFuelType ();

    inline void set_has_SortType ();

    inline void clear_has_SortType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::std::string _Brand;

    ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo _CanadianFuelType;

    ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType _SortType;

};

/**
 * The result message of the method "GetCanadianFuelInfoList"
 * This method is used to get canadian fuel information
 */
class GetCanadianFuelInfoListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelInfoListResult ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelInfoListResult (const GetCanadianFuelInfoListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelInfoListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& CanadianFuelInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelInfoListResult();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelInfoListResult& operator = (const GetCanadianFuelInfoListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelInfoListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelInfoListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelInfoListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelInfoListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListID"

    static const int kListID = 0;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Canadian Fuel type information to filter canadian fuel info
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Canadian Fuel type information to filter canadian fuel info
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @return The value of the field "Operation"
     */
    inline ::sxm_main_fi_types::T_e8_SxmListOperation getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * Operation as in method-start
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_);

    // API of field "ListInfo"

    static const int kListInfo = 2;

    /**
     * Clears the field "ListInfo".
     *
     * The field will be set to its default value. The hasListInfo()
     * method will return false.
     */
    inline void clearListInfo();

    /**
     * Checks whether the field "ListInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInfo()). Otherwise it will return false.
     */
    inline bool hasListInfo () const;

    /**
     * Returns the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @return The value of the field "ListInfo"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfo& getListInfo () const;

    /**
     * Retrieves the value of the field "ListInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListInfo".
     */
    inline ::sxm_main_fi_types::T_SxmListInfo& getListInfoMutable ();

    /**
     * Sets the value of the member "ListInfo".
     *
     * Information about the received list
     *
     * @param ListInfo The value which will be set
     */
    inline void setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_);

    // API of field "CanadianFuelInfoList"

    static const int kCanadianFuelInfoList = 3;

    /**
     * Clears the field "CanadianFuelInfoList".
     *
     * The field will be set to its default value. The hasCanadianFuelInfoList()
     * method will return false.
     */
    inline void clearCanadianFuelInfoList();

    /**
     * Checks whether the field "CanadianFuelInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanadianFuelInfoList()). Otherwise it will return false.
     */
    inline bool hasCanadianFuelInfoList () const;

    /**
     * Returns the value of the member "CanadianFuelInfoList".
     *
     * Get all Canadian fuel information list
     *
     * @return The value of the field "CanadianFuelInfoList"
     */
    inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& getCanadianFuelInfoList () const;

    /**
     * Retrieves the value of the field "CanadianFuelInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanadianFuelInfoList".
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& getCanadianFuelInfoListMutable ();

    /**
     * Sets the value of the member "CanadianFuelInfoList".
     *
     * Get all Canadian fuel information list
     *
     * @param CanadianFuelInfoList The value which will be set
     */
    inline void setCanadianFuelInfoList (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& CanadianFuelInfoList_);

    static const GetCanadianFuelInfoListResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfo >& getT_CanFuelInfoList_DefaultInstance ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    inline void set_has_ListInfo ();

    inline void clear_has_ListInfo ();

    inline void set_has_CanadianFuelInfoList ();

    inline void clear_has_CanadianFuelInfoList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _ListID;

    ::sxm_main_fi_types::T_e8_SxmListOperation _Operation;

    ::sxm_main_fi_types::T_SxmListInfo _ListInfo;

    ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList _CanadianFuelInfoList;

};

/**
 * The error message of 'GetCanadianFuelInfoList'
 */
class GetCanadianFuelInfoListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelInfoListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelInfoListErrorStructure (const GetCanadianFuelInfoListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelInfoListErrorStructure (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetCanadianFuelInfoListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelInfoListErrorStructure& operator = (const GetCanadianFuelInfoListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelInfoListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelInfoListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelInfoListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelInfoListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies canadian fuel list is empty
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies canadian fuel list is empty
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_);

    static const GetCanadianFuelInfoListErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetCanadianFuelInfoList'
 */
class GetCanadianFuelInfoListError  : public ::asf::core::Payload {
public:

    enum GetCanadianFuelInfoListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetCanadianFuelInfoListError ();

   /**
     * Copy constructor
     */
    inline  GetCanadianFuelInfoListError (const GetCanadianFuelInfoListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelInfoListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetCanadianFuelInfoListError& operator = (const GetCanadianFuelInfoListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelInfoListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelInfoListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelInfoListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelInfoListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetCanadianFuelInfoListError::GetCanadianFuelInfoListErrorField getField () const;

    inline void setField(GetCanadianFuelInfoListError::GetCanadianFuelInfoListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetCanadianFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetCanadianFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetCanadianFuelInfoListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetCanadianFuelInfoListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetCanadianFuelInfoListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetCanadianFuelInfoListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetCanadianFuelInfoListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetCanadianFuelInfoListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetCanadianFuelInfoListError &getDefaultInstance();

private:

    inline void cloneData (const GetCanadianFuelInfoListError& rhs);

    inline void deleteData ();

    GetCanadianFuelInfoListErrorField __field;

    union {
        GetCanadianFuelInfoListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetCanadianFuelStationInfo"
 * Get Canadian Fuel information for a canadian fuel station
 */
class GetCanadianFuelStationInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelStationInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelStationInfoStart (const GetCanadianFuelStationInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelStationInfoStart (uint32 CANADIAN_FUEL_LOCID_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelStationInfoStart();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelStationInfoStart& operator = (const GetCanadianFuelStationInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelStationInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelStationInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelStationInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelStationInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CANADIAN_FUEL_LOCID"

    static const int kCANADIAN_FUEL_LOCID = 0;

    /**
     * Clears the field "CANADIAN_FUEL_LOCID".
     *
     * The field will be set to its default value. The hasCANADIAN_FUEL_LOCID()
     * method will return false.
     */
    inline void clearCANADIAN_FUEL_LOCID();

    /**
     * Checks whether the field "CANADIAN_FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCANADIAN_FUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasCANADIAN_FUEL_LOCID () const;

    /**
     * Returns the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Loc ID as input
     *
     * @return The value of the field "CANADIAN_FUEL_LOCID"
     */
    inline uint32 getCANADIAN_FUEL_LOCID () const;

    /**
     * Sets the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Loc ID as input
     *
     * @param CANADIAN_FUEL_LOCID The value which will be set
     */
    inline void setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetCanadianFuelStationInfoStart &getDefaultInstance();

private:

    inline void set_has_CANADIAN_FUEL_LOCID ();

    inline void clear_has_CANADIAN_FUEL_LOCID ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _CANADIAN_FUEL_LOCID;

    uint32 _ListID;

};

/**
 * The result message of the method "GetCanadianFuelStationInfo"
 * Get Canadian Fuel information for a canadian fuel station
 */
class GetCanadianFuelStationInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelStationInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelStationInfoResult (const GetCanadianFuelStationInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelStationInfoResult (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& CanadianFuelStationInfo_, uint32 ListID_);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelStationInfoResult();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelStationInfoResult& operator = (const GetCanadianFuelStationInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelStationInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelStationInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelStationInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelStationInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanadianFuelStationInfo"

    static const int kCanadianFuelStationInfo = 0;

    /**
     * Clears the field "CanadianFuelStationInfo".
     *
     * The field will be set to its default value. The hasCanadianFuelStationInfo()
     * method will return false.
     */
    inline void clearCanadianFuelStationInfo();

    /**
     * Checks whether the field "CanadianFuelStationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanadianFuelStationInfo()). Otherwise it will return false.
     */
    inline bool hasCanadianFuelStationInfo () const;

    /**
     * Returns the value of the member "CanadianFuelStationInfo".
     *
     * Canadian Fuel station information
     *
     * @return The value of the field "CanadianFuelStationInfo"
     */
    inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& getCanadianFuelStationInfo () const;

    /**
     * Retrieves the value of the field "CanadianFuelStationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanadianFuelStationInfo".
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& getCanadianFuelStationInfoMutable ();

    /**
     * Sets the value of the member "CanadianFuelStationInfo".
     *
     * Canadian Fuel station information
     *
     * @param CanadianFuelStationInfo The value which will be set
     */
    inline void setCanadianFuelStationInfo (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& CanadianFuelStationInfo_);

    // API of field "ListID"

    static const int kListID = 1;

    /**
     * Clears the field "ListID".
     *
     * The field will be set to its default value. The hasListID()
     * method will return false.
     */
    inline void clearListID();

    /**
     * Checks whether the field "ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListID()). Otherwise it will return false.
     */
    inline bool hasListID () const;

    /**
     * Returns the value of the member "ListID".
     *
     * Location Type
     *
     * @return The value of the field "ListID"
     */
    inline uint32 getListID () const;

    /**
     * Sets the value of the member "ListID".
     *
     * Location Type
     *
     * @param ListID The value which will be set
     */
    inline void setListID (uint32 ListID_);

    static const GetCanadianFuelStationInfoResult &getDefaultInstance();

private:

    inline void set_has_CanadianFuelStationInfo ();

    inline void clear_has_CanadianFuelStationInfo ();

    inline void set_has_ListID ();

    inline void clear_has_ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo _CanadianFuelStationInfo;

    uint32 _ListID;

};

/**
 * The error message of 'GetCanadianFuelStationInfo'
 */
class GetCanadianFuelStationInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetCanadianFuelStationInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetCanadianFuelStationInfoErrorStructure (const GetCanadianFuelStationInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetCanadianFuelStationInfoErrorStructure (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GetCanadianFuelStationInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetCanadianFuelStationInfoErrorStructure& operator = (const GetCanadianFuelStationInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelStationInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelStationInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelStationInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelStationInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * This error code specifies canadian fuel station unavailability
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * This error code specifies canadian fuel station unavailability
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_);

    static const GetCanadianFuelStationInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes _ErrorCode;

};

/**
 * The error message of 'GetCanadianFuelStationInfo'
 */
class GetCanadianFuelStationInfoError  : public ::asf::core::Payload {
public:

    enum GetCanadianFuelStationInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetCanadianFuelStationInfoError ();

   /**
     * Copy constructor
     */
    inline  GetCanadianFuelStationInfoError (const GetCanadianFuelStationInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetCanadianFuelStationInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetCanadianFuelStationInfoError& operator = (const GetCanadianFuelStationInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCanadianFuelStationInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCanadianFuelStationInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCanadianFuelStationInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCanadianFuelStationInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoErrorField getField () const;

    inline void setField(GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetCanadianFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetCanadianFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetCanadianFuelStationInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetCanadianFuelStationInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetCanadianFuelStationInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetCanadianFuelStationInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetCanadianFuelStationInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetCanadianFuelStationInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetCanadianFuelStationInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetCanadianFuelStationInfoError& rhs);

    inline void deleteData ();

    GetCanadianFuelStationInfoErrorField __field;

    union {
        GetCanadianFuelStationInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddFavorite"
 * This method is used to add canadian fuel station
 * information into favorite list
 */
class AddFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteStart (const AddFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteStart (uint32 CANADIAN_FUEL_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteStart();

    /**
     * Assignment operator
     */
    inline AddFavoriteStart& operator = (const AddFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CANADIAN_FUEL_LOCID"

    static const int kCANADIAN_FUEL_LOCID = 0;

    /**
     * Clears the field "CANADIAN_FUEL_LOCID".
     *
     * The field will be set to its default value. The hasCANADIAN_FUEL_LOCID()
     * method will return false.
     */
    inline void clearCANADIAN_FUEL_LOCID();

    /**
     * Checks whether the field "CANADIAN_FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCANADIAN_FUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasCANADIAN_FUEL_LOCID () const;

    /**
     * Returns the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Location ID
     *
     * @return The value of the field "CANADIAN_FUEL_LOCID"
     */
    inline uint32 getCANADIAN_FUEL_LOCID () const;

    /**
     * Sets the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Location ID
     *
     * @param CANADIAN_FUEL_LOCID The value which will be set
     */
    inline void setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_);

    static const AddFavoriteStart &getDefaultInstance();

private:

    inline void set_has_CANADIAN_FUEL_LOCID ();

    inline void clear_has_CANADIAN_FUEL_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _CANADIAN_FUEL_LOCID;

};

/**
 * The result message of the method "AddFavorite"
 * This method is used to add canadian fuel station
 * information into favorite list
 */
class AddFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  AddFavoriteResult (const AddFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~AddFavoriteResult();

    /**
     * Assignment operator
     */
    inline AddFavoriteResult& operator = (const AddFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully add in favorite list return True
     * else return False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const AddFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "RemoveFavorite"
 * This method is used to Remove canadian fuel station
 * information from favorite list
 */
class RemoveFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteStart (const RemoveFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteStart (uint32 CANADIAN_FUEL_LOCID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteStart();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteStart& operator = (const RemoveFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CANADIAN_FUEL_LOCID"

    static const int kCANADIAN_FUEL_LOCID = 0;

    /**
     * Clears the field "CANADIAN_FUEL_LOCID".
     *
     * The field will be set to its default value. The hasCANADIAN_FUEL_LOCID()
     * method will return false.
     */
    inline void clearCANADIAN_FUEL_LOCID();

    /**
     * Checks whether the field "CANADIAN_FUEL_LOCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCANADIAN_FUEL_LOCID()). Otherwise it will return false.
     */
    inline bool hasCANADIAN_FUEL_LOCID () const;

    /**
     * Returns the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Location ID
     *
     * @return The value of the field "CANADIAN_FUEL_LOCID"
     */
    inline uint32 getCANADIAN_FUEL_LOCID () const;

    /**
     * Sets the value of the member "CANADIAN_FUEL_LOCID".
     *
     * Location ID
     *
     * @param CANADIAN_FUEL_LOCID The value which will be set
     */
    inline void setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_);

    static const RemoveFavoriteStart &getDefaultInstance();

private:

    inline void set_has_CANADIAN_FUEL_LOCID ();

    inline void clear_has_CANADIAN_FUEL_LOCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _CANADIAN_FUEL_LOCID;

};

/**
 * The result message of the method "RemoveFavorite"
 * This method is used to Remove canadian fuel station
 * information from favorite list
 */
class RemoveFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  RemoveFavoriteResult (const RemoveFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveFavoriteResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveFavoriteResult();

    /**
     * Assignment operator
     */
    inline RemoveFavoriteResult& operator = (const RemoveFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Successfully remove from favorite list return True
     * else return False
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Successfully remove from favorite list return True
     * else return False
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const RemoveFavoriteResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigStart ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigStart (const SetListsConfigStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigStart();

    /**
     * Assignment operator
     */
    inline SetListsConfigStart& operator = (const SetListsConfigStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Generic configuration for all list of canadian fuel
     *
     * @return The value of the field "Config"
     */
    inline const ::sxm_main_fi_types::T_SxmListsConfig& getConfig () const;

    /**
     * Retrieves the value of the field "Config" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Config".
     */
    inline ::sxm_main_fi_types::T_SxmListsConfig& getConfigMutable ();

    /**
     * Sets the value of the member "Config".
     *
     * Generic configuration for all list of canadian fuel
     *
     * @param Config The value which will be set
     */
    inline void setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_);

    static const SetListsConfigStart &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListsConfig _Config;

};

/**
 * The result message of the method "SetListsConfig"
 * This method is used to configure all lists
 */
class SetListsConfigResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetListsConfigResult ();

    /**
     * Copy constructor
     */
    inline  SetListsConfigResult (const SetListsConfigResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetListsConfigResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetListsConfigResult();

    /**
     * Assignment operator
     */
    inline SetListsConfigResult& operator = (const SetListsConfigResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetListsConfigResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetListsConfigResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetListsConfigResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetListsConfigResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * TRUE if value was accepted
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetListsConfigResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The status message of the property "CanadianFuelInfoListsStatus"
 * Status of all configured Lists
 */
class CanadianFuelInfoListsStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanadianFuelInfoListsStatusStatus ();

    /**
     * Copy constructor
     */
    inline  CanadianFuelInfoListsStatusStatus (const CanadianFuelInfoListsStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CanadianFuelInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    /**
     * Destructor
     */
    inline virtual  ~CanadianFuelInfoListsStatusStatus();

    /**
     * Assignment operator
     */
    inline CanadianFuelInfoListsStatusStatus& operator = (const CanadianFuelInfoListsStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanadianFuelInfoListsStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanadianFuelInfoListsStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanadianFuelInfoListsStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanadianFuelInfoListsStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InfoList"

    static const int kInfoList = 0;

    /**
     * Clears the field "InfoList".
     *
     * The field will be set to its default value. The hasInfoList()
     * method will return false.
     */
    inline void clearInfoList();

    /**
     * Checks whether the field "InfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInfoList()). Otherwise it will return false.
     */
    inline bool hasInfoList () const;

    /**
     * Returns the value of the member "InfoList".
     *
     * list containing status of all list provide by canadian fuel
     *
     * @return The value of the field "InfoList"
     */
    inline const ::sxm_main_fi_types::T_SxmListInfos& getInfoList () const;

    /**
     * Retrieves the value of the field "InfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InfoList".
     */
    inline ::sxm_main_fi_types::T_SxmListInfos& getInfoListMutable ();

    /**
     * Sets the value of the member "InfoList".
     *
     * list containing status of all list provide by canadian fuel
     *
     * @param InfoList The value which will be set
     */
    inline void setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_);

    static const CanadianFuelInfoListsStatusStatus &getDefaultInstance();

private:

    inline void set_has_InfoList ();

    inline void clear_has_InfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListInfos _InfoList;

};

/**
 * The status message of the property "CanadianFuelBrandNameList"
 * Get all Avalable Brand Names.
 */
class CanadianFuelBrandNameListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanadianFuelBrandNameListStatus ();

    /**
     * Copy constructor
     */
    inline  CanadianFuelBrandNameListStatus (const CanadianFuelBrandNameListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CanadianFuelBrandNameListStatus (const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& BrandName_);

    /**
     * Destructor
     */
    inline virtual  ~CanadianFuelBrandNameListStatus();

    /**
     * Assignment operator
     */
    inline CanadianFuelBrandNameListStatus& operator = (const CanadianFuelBrandNameListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanadianFuelBrandNameListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanadianFuelBrandNameListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanadianFuelBrandNameListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanadianFuelBrandNameListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrandName"

    static const int kBrandName = 0;

    /**
     * Clears the field "BrandName".
     *
     * The field will be set to its default value. The hasBrandName()
     * method will return false.
     */
    inline void clearBrandName();

    /**
     * Checks whether the field "BrandName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrandName()). Otherwise it will return false.
     */
    inline bool hasBrandName () const;

    /**
     * Returns the value of the member "BrandName".
     *
     * List of All Avalable brand Names
     *
     * @return The value of the field "BrandName"
     */
    inline const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& getBrandName () const;

    /**
     * Retrieves the value of the field "BrandName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BrandName".
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& getBrandNameMutable ();

    /**
     * Sets the value of the member "BrandName".
     *
     * List of All Avalable brand Names
     *
     * @param BrandName The value which will be set
     */
    inline void setBrandName (const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& BrandName_);

    static const CanadianFuelBrandNameListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_BrandName ();

    inline void clear_has_BrandName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList _BrandName;

};

/**
 * The status message of the property "CanadianFuelTypeList"
 * Get all Avalable Canadian Fuel type Names.
 */
class CanadianFuelTypeListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CanadianFuelTypeListStatus ();

    /**
     * Copy constructor
     */
    inline  CanadianFuelTypeListStatus (const CanadianFuelTypeListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CanadianFuelTypeListStatus (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& TypeName_);

    /**
     * Destructor
     */
    inline virtual  ~CanadianFuelTypeListStatus();

    /**
     * Assignment operator
     */
    inline CanadianFuelTypeListStatus& operator = (const CanadianFuelTypeListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CanadianFuelTypeListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CanadianFuelTypeListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CanadianFuelTypeListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CanadianFuelTypeListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TypeName"

    static const int kTypeName = 0;

    /**
     * Clears the field "TypeName".
     *
     * The field will be set to its default value. The hasTypeName()
     * method will return false.
     */
    inline void clearTypeName();

    /**
     * Checks whether the field "TypeName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTypeName()). Otherwise it will return false.
     */
    inline bool hasTypeName () const;

    /**
     * Returns the value of the member "TypeName".
     *
     * List of All Available Canadian Fuel Type Names
     *
     * @return The value of the field "TypeName"
     */
    inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& getTypeName () const;

    /**
     * Retrieves the value of the field "TypeName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TypeName".
     */
    inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& getTypeNameMutable ();

    /**
     * Sets the value of the member "TypeName".
     *
     * List of All Available Canadian Fuel Type Names
     *
     * @param TypeName The value which will be set
     */
    inline void setTypeName (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& TypeName_);

    static const CanadianFuelTypeListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo >& getT_CanFuelTypeInfoList_DefaultInstance ();

    inline void set_has_TypeName ();

    inline void clear_has_TypeName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList _TypeName;

};

/**
 * The status message of the property "SxmDataServiceStatus"
 * Get the Status of Canadian Fuel Data Service
 */
class SxmDataServiceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmDataServiceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~SxmDataServiceStatusStatus();

    /**
     * Assignment operator
     */
    inline SxmDataServiceStatusStatus& operator = (const SxmDataServiceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmDataServiceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataServiceState"

    static const int kDataServiceState = 0;

    /**
     * Clears the field "DataServiceState".
     *
     * The field will be set to its default value. The hasDataServiceState()
     * method will return false.
     */
    inline void clearDataServiceState();

    /**
     * Checks whether the field "DataServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataServiceState()). Otherwise it will return false.
     */
    inline bool hasDataServiceState () const;

    /**
     * Returns the value of the member "DataServiceState".
     *
     * Status of Canadian Fuel Data Service
     *
     * @return The value of the field "DataServiceState"
     */
    inline const ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceState () const;

    /**
     * Retrieves the value of the field "DataServiceState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataServiceState".
     */
    inline ::sxm_main_fi_types::T_SxmDataSrvState& getDataServiceStateMutable ();

    /**
     * Sets the value of the member "DataServiceState".
     *
     * Status of Canadian Fuel Data Service
     *
     * @param DataServiceState The value which will be set
     */
    inline void setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_);

    static const SxmDataServiceStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataServiceState ();

    inline void clear_has_DataServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmDataSrvState _DataServiceState;

};

/**
 * The status message of the property "SxmListMode"
 * Set the Mode of Canadian Fuel List.
 */
class SxmListModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeStatus ();

    /**
     * Copy constructor
     */
    inline  SxmListModeStatus (const SxmListModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeStatus();

    /**
     * Assignment operator
     */
    inline SxmListModeStatus& operator = (const SxmListModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Canadian Fuel List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Canadian Fuel List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeStatus &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

/**
 * The set message of the property "SxmListMode"
 * Set the Mode of Canadian Fuel List.
 */
class SxmListModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SxmListModeSet ();

    /**
     * Copy constructor
     */
    inline  SxmListModeSet (const SxmListModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    /**
     * Destructor
     */
    inline virtual  ~SxmListModeSet();

    /**
     * Assignment operator
     */
    inline SxmListModeSet& operator = (const SxmListModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SxmListModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SxmListModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SxmListModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SxmListModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListMode"

    static const int kListMode = 0;

    /**
     * Clears the field "ListMode".
     *
     * The field will be set to its default value. The hasListMode()
     * method will return false.
     */
    inline void clearListMode();

    /**
     * Checks whether the field "ListMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListMode()). Otherwise it will return false.
     */
    inline bool hasListMode () const;

    /**
     * Returns the value of the member "ListMode".
     *
     * Set the Mode of Canadian Fuel List
     *
     * @return The value of the field "ListMode"
     */
    inline const ::sxm_main_fi_types::T_SxmListMode& getListMode () const;

    /**
     * Retrieves the value of the field "ListMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListMode".
     */
    inline ::sxm_main_fi_types::T_SxmListMode& getListModeMutable ();

    /**
     * Sets the value of the member "ListMode".
     *
     * Set the Mode of Canadian Fuel List
     *
     * @param ListMode The value which will be set
     */
    inline void setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_);

    static const SxmListModeSet &getDefaultInstance();

private:

    inline void set_has_ListMode ();

    inline void clear_has_ListMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_main_fi_types::T_SxmListMode _ListMode;

};

inline  GetCanadianFuelInfoListStart::GetCanadianFuelInfoListStart ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Brand (),
    _CanadianFuelType (),
    _SortType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType__CAN_FUEL_SORT_BY_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListStart::GetCanadianFuelInfoListStart (const GetCanadianFuelInfoListStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _Brand (),
    _CanadianFuelType (),
    _SortType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType__CAN_FUEL_SORT_BY_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelInfoListStart::GetCanadianFuelInfoListStart (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::std::string& Brand_, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& CanadianFuelType_, ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType SortType_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _Brand (Brand_),
    _CanadianFuelType (CanadianFuelType_),
    _SortType (SortType_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetCanadianFuelInfoListStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType_IsValid(SortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SortType_, "T_e8_CanFuelSortType", "SortType", "GetCanadianFuelInfoListStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListStart::~GetCanadianFuelInfoListStart() {
}

inline GetCanadianFuelInfoListStart& GetCanadianFuelInfoListStart::operator = (const GetCanadianFuelInfoListStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasBrand()) {
            setBrand(rhs.getBrand());
        } else {
            clearBrand();
        }
        if (rhs.hasCanadianFuelType()) {
            setCanadianFuelType(rhs.getCanadianFuelType());
        } else {
            clearCanadianFuelType();
        }
        if (rhs.hasSortType()) {
            setSortType(rhs.getSortType());
        } else {
            clearSortType();
        }
    }
    return *this;
}

inline bool GetCanadianFuelInfoListStart::operator == (const GetCanadianFuelInfoListStart& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasBrand() && !rhs.hasBrand()) || getBrand() == rhs.getBrand()) &&
        ((!hasCanadianFuelType() && !rhs.hasCanadianFuelType()) || getCanadianFuelType() == rhs.getCanadianFuelType()) &&
        ((!hasSortType() && !rhs.hasSortType()) || getSortType() == rhs.getSortType()));
}

inline bool GetCanadianFuelInfoListStart::operator != (const GetCanadianFuelInfoListStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelInfoListStart::operator < (const GetCanadianFuelInfoListStart& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasBrand() || rhs.hasBrand()) {
        if (getBrand() < rhs.getBrand()) return true;
        if (getBrand() > rhs.getBrand()) return false;
    }
    if (hasCanadianFuelType() || rhs.hasCanadianFuelType()) {
        if (getCanadianFuelType() < rhs.getCanadianFuelType()) return true;
        if (getCanadianFuelType() > rhs.getCanadianFuelType()) return false;
    }
    if (hasSortType() || rhs.hasSortType()) {
        if ((uint32)getSortType() < (uint32)rhs.getSortType()) return true;
        if ((uint32)getSortType() > (uint32)rhs.getSortType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCanadianFuelInfoListStart::clone() {
    return new GetCanadianFuelInfoListStart(*this);
}

inline bool GetCanadianFuelInfoListStart::operator > (const GetCanadianFuelInfoListStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelInfoListStart::clear() {
    clearListID();
    clearOperation();
    clearBrand();
    clearCanadianFuelType();
    clearSortType();
}

inline void GetCanadianFuelInfoListStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetCanadianFuelInfoListStart::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetCanadianFuelInfoListStart::getListID () const {
    return _ListID;
}

inline void GetCanadianFuelInfoListStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetCanadianFuelInfoListStart::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetCanadianFuelInfoListStart::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetCanadianFuelInfoListStart::getOperation () const {
    return _Operation;
}

inline void GetCanadianFuelInfoListStart::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetCanadianFuelInfoListStart");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetCanadianFuelInfoListStart::clearBrand() {
    if (hasBrand()) {
         clear_has_Brand();
        _Brand.clear();
     }
}

inline bool GetCanadianFuelInfoListStart::hasBrand () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& GetCanadianFuelInfoListStart::getBrand () const {
    return _Brand;
}

inline ::std::string& GetCanadianFuelInfoListStart::getBrandMutable () {
    set_has_Brand();
    return _Brand;
}

inline void GetCanadianFuelInfoListStart::setBrand (const ::std::string& Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand = Brand_;
}

inline void GetCanadianFuelInfoListStart::setBrand (const char* Brand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Brand_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(Brand_);
}

inline void GetCanadianFuelInfoListStart::setBrand (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Brand();
    this->_Brand.assign(value, size);
}

inline void GetCanadianFuelInfoListStart::clearCanadianFuelType() {
    if (hasCanadianFuelType()) {
         clear_has_CanadianFuelType();
        _CanadianFuelType.clear();
     }
}

inline bool GetCanadianFuelInfoListStart::hasCanadianFuelType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& GetCanadianFuelInfoListStart::getCanadianFuelType () const {
    return _CanadianFuelType;
}

inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& GetCanadianFuelInfoListStart::getCanadianFuelTypeMutable () {
    set_has_CanadianFuelType();
    return _CanadianFuelType;
}

inline void GetCanadianFuelInfoListStart::setCanadianFuelType (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeInfo& CanadianFuelType_) {
    set_has_CanadianFuelType();
    this->_CanadianFuelType = CanadianFuelType_;
}

inline void GetCanadianFuelInfoListStart::clearSortType() {
    if (hasSortType()) {
         clear_has_SortType();
        _SortType = ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType__CAN_FUEL_SORT_BY_NONE;
     }
}

inline bool GetCanadianFuelInfoListStart::hasSortType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType GetCanadianFuelInfoListStart::getSortType () const {
    return _SortType;
}

inline void GetCanadianFuelInfoListStart::setSortType (::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType SortType_) {
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8_CanFuelSortType_IsValid(SortType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SortType_, "T_e8_CanFuelSortType", "SortType", "GetCanadianFuelInfoListStart");
    }
    #endif
    set_has_SortType();
    this->_SortType = SortType_;
}

inline void GetCanadianFuelInfoListStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelInfoListStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetCanadianFuelInfoListStart::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetCanadianFuelInfoListStart::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetCanadianFuelInfoListStart::set_has_Brand () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetCanadianFuelInfoListStart::clear_has_Brand () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetCanadianFuelInfoListStart::set_has_CanadianFuelType () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetCanadianFuelInfoListStart::clear_has_CanadianFuelType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void GetCanadianFuelInfoListStart::set_has_SortType () {
    _has_bits_[0] |= 1u << 4;
}

inline void GetCanadianFuelInfoListStart::clear_has_SortType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  GetCanadianFuelInfoListResult::GetCanadianFuelInfoListResult ()  :
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _CanadianFuelInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListResult::GetCanadianFuelInfoListResult (const GetCanadianFuelInfoListResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ListID (0u),
    _Operation (::sxm_main_fi_types::T_e8_SxmListOperation__IDLE),
    _ListInfo (),
    _CanadianFuelInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelInfoListResult::GetCanadianFuelInfoListResult (uint32 ListID_, ::sxm_main_fi_types::T_e8_SxmListOperation Operation_, const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_, const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& CanadianFuelInfoList_)  :
    _ListID (ListID_),
    _Operation (Operation_),
    _ListInfo (ListInfo_),
    _CanadianFuelInfoList (CanadianFuelInfoList_)
{
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetCanadianFuelInfoListResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListResult::~GetCanadianFuelInfoListResult() {
}

inline GetCanadianFuelInfoListResult& GetCanadianFuelInfoListResult::operator = (const GetCanadianFuelInfoListResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
        if (rhs.hasListInfo()) {
            setListInfo(rhs.getListInfo());
        } else {
            clearListInfo();
        }
        if (rhs.hasCanadianFuelInfoList()) {
            setCanadianFuelInfoList(rhs.getCanadianFuelInfoList());
        } else {
            clearCanadianFuelInfoList();
        }
    }
    return *this;
}

inline bool GetCanadianFuelInfoListResult::operator == (const GetCanadianFuelInfoListResult& rhs) const {
    return (((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()) &&
        ((!hasListInfo() && !rhs.hasListInfo()) || getListInfo() == rhs.getListInfo()) &&
        ((!hasCanadianFuelInfoList() && !rhs.hasCanadianFuelInfoList()) || getCanadianFuelInfoList() == rhs.getCanadianFuelInfoList()));
}

inline bool GetCanadianFuelInfoListResult::operator != (const GetCanadianFuelInfoListResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelInfoListResult::operator < (const GetCanadianFuelInfoListResult& rhs) const {
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if ((uint32)getOperation() < (uint32)rhs.getOperation()) return true;
        if ((uint32)getOperation() > (uint32)rhs.getOperation()) return false;
    }
    if (hasListInfo() || rhs.hasListInfo()) {
        if (getListInfo() < rhs.getListInfo()) return true;
        if (getListInfo() > rhs.getListInfo()) return false;
    }
    if (hasCanadianFuelInfoList() || rhs.hasCanadianFuelInfoList()) {
        if (getCanadianFuelInfoList() < rhs.getCanadianFuelInfoList()) return true;
        if (getCanadianFuelInfoList() > rhs.getCanadianFuelInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCanadianFuelInfoListResult::clone() {
    return new GetCanadianFuelInfoListResult(*this);
}

inline bool GetCanadianFuelInfoListResult::operator > (const GetCanadianFuelInfoListResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelInfoListResult::clear() {
    clearListID();
    clearOperation();
    clearListInfo();
    clearCanadianFuelInfoList();
}

inline void GetCanadianFuelInfoListResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetCanadianFuelInfoListResult::hasListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetCanadianFuelInfoListResult::getListID () const {
    return _ListID;
}

inline void GetCanadianFuelInfoListResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetCanadianFuelInfoListResult::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = ::sxm_main_fi_types::T_e8_SxmListOperation__IDLE;
     }
}

inline bool GetCanadianFuelInfoListResult::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::sxm_main_fi_types::T_e8_SxmListOperation GetCanadianFuelInfoListResult::getOperation () const {
    return _Operation;
}

inline void GetCanadianFuelInfoListResult::setOperation (::sxm_main_fi_types::T_e8_SxmListOperation Operation_) {
    #ifndef NDEBUG
    if (!(::sxm_main_fi_types::T_e8_SxmListOperation_IsValid(Operation_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Operation_, "T_e8_SxmListOperation", "Operation", "GetCanadianFuelInfoListResult");
    }
    #endif
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void GetCanadianFuelInfoListResult::clearListInfo() {
    if (hasListInfo()) {
         clear_has_ListInfo();
        _ListInfo.clear();
     }
}

inline bool GetCanadianFuelInfoListResult::hasListInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfo& GetCanadianFuelInfoListResult::getListInfo () const {
    return _ListInfo;
}

inline ::sxm_main_fi_types::T_SxmListInfo& GetCanadianFuelInfoListResult::getListInfoMutable () {
    set_has_ListInfo();
    return _ListInfo;
}

inline void GetCanadianFuelInfoListResult::setListInfo (const ::sxm_main_fi_types::T_SxmListInfo& ListInfo_) {
    set_has_ListInfo();
    this->_ListInfo = ListInfo_;
}

inline void GetCanadianFuelInfoListResult::clearCanadianFuelInfoList() {
    if (hasCanadianFuelInfoList()) {
         clear_has_CanadianFuelInfoList();
        _CanadianFuelInfoList.clear();
     }
}

inline bool GetCanadianFuelInfoListResult::hasCanadianFuelInfoList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& GetCanadianFuelInfoListResult::getCanadianFuelInfoList () const {
    return _CanadianFuelInfoList;
}

inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& GetCanadianFuelInfoListResult::getCanadianFuelInfoListMutable () {
    set_has_CanadianFuelInfoList();
    return _CanadianFuelInfoList;
}

inline void GetCanadianFuelInfoListResult::setCanadianFuelInfoList (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelInfoList& CanadianFuelInfoList_) {
    set_has_CanadianFuelInfoList();
    this->_CanadianFuelInfoList = CanadianFuelInfoList_;
}

inline void GetCanadianFuelInfoListResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelInfoListResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetCanadianFuelInfoListResult::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetCanadianFuelInfoListResult::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetCanadianFuelInfoListResult::set_has_ListInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetCanadianFuelInfoListResult::clear_has_ListInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetCanadianFuelInfoListResult::set_has_CanadianFuelInfoList () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetCanadianFuelInfoListResult::clear_has_CanadianFuelInfoList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetCanadianFuelInfoListErrorStructure::GetCanadianFuelInfoListErrorStructure ()  :
    _ErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListErrorStructure::GetCanadianFuelInfoListErrorStructure (const GetCanadianFuelInfoListErrorStructure &rhs)  :
    _ErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelInfoListErrorStructure::GetCanadianFuelInfoListErrorStructure (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8CanFuelErrorTypes", "ErrorCode", "GetCanadianFuelInfoListErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelInfoListErrorStructure::~GetCanadianFuelInfoListErrorStructure() {
}

inline GetCanadianFuelInfoListErrorStructure& GetCanadianFuelInfoListErrorStructure::operator = (const GetCanadianFuelInfoListErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetCanadianFuelInfoListErrorStructure::operator == (const GetCanadianFuelInfoListErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetCanadianFuelInfoListErrorStructure::operator != (const GetCanadianFuelInfoListErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelInfoListErrorStructure::operator < (const GetCanadianFuelInfoListErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetCanadianFuelInfoListErrorStructure::operator > (const GetCanadianFuelInfoListErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelInfoListErrorStructure::clear() {
    clearErrorCode();
}

inline void GetCanadianFuelInfoListErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY;
     }
}

inline bool GetCanadianFuelInfoListErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes GetCanadianFuelInfoListErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetCanadianFuelInfoListErrorStructure::setErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8CanFuelErrorTypes", "ErrorCode", "GetCanadianFuelInfoListErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetCanadianFuelInfoListErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelInfoListErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCanadianFuelInfoListError::GetCanadianFuelInfoListError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetCanadianFuelInfoListError::GetCanadianFuelInfoListError (const GetCanadianFuelInfoListError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetCanadianFuelInfoListError::~GetCanadianFuelInfoListError() {
    deleteData ();
}

inline GetCanadianFuelInfoListError& GetCanadianFuelInfoListError::operator = (const GetCanadianFuelInfoListError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetCanadianFuelInfoListError::operator == (const GetCanadianFuelInfoListError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetCanadianFuelInfoListError::operator != (const GetCanadianFuelInfoListError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelInfoListError::operator < (const GetCanadianFuelInfoListError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetCanadianFuelInfoListError::operator > (const GetCanadianFuelInfoListError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetCanadianFuelInfoListError::GetCanadianFuelInfoListErrorField GetCanadianFuelInfoListError::getField () const {
    return __field;
}

inline void GetCanadianFuelInfoListError::setField(GetCanadianFuelInfoListError::GetCanadianFuelInfoListErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetCanadianFuelInfoListError::clone() {
    return new GetCanadianFuelInfoListError(*this);
}

inline bool GetCanadianFuelInfoListError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetCanadianFuelInfoListErrorStructure& GetCanadianFuelInfoListError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetCanadianFuelInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetCanadianFuelInfoListErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetCanadianFuelInfoListErrorStructure& GetCanadianFuelInfoListError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetCanadianFuelInfoListError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetCanadianFuelInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetCanadianFuelInfoListErrorStructure* GetCanadianFuelInfoListError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetCanadianFuelInfoListError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetCanadianFuelInfoListErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetCanadianFuelInfoListErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetCanadianFuelInfoListError::replaceCcaErrorCode (GetCanadianFuelInfoListErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetCanadianFuelInfoListError::setCcaErrorCode (const GetCanadianFuelInfoListErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetCanadianFuelInfoListErrorStructure(value);
    }
}

inline bool GetCanadianFuelInfoListError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetCanadianFuelInfoListError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetCanadianFuelInfoListError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetCanadianFuelInfoListError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetCanadianFuelInfoListError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetCanadianFuelInfoListError::cloneData (const GetCanadianFuelInfoListError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetCanadianFuelInfoListErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetCanadianFuelInfoListErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetCanadianFuelInfoListError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  GetCanadianFuelStationInfoStart::GetCanadianFuelStationInfoStart ()  :
    _CANADIAN_FUEL_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoStart::GetCanadianFuelStationInfoStart (const GetCanadianFuelStationInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _CANADIAN_FUEL_LOCID (0u),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelStationInfoStart::GetCanadianFuelStationInfoStart (uint32 CANADIAN_FUEL_LOCID_, uint32 ListID_)  :
    _CANADIAN_FUEL_LOCID (CANADIAN_FUEL_LOCID_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoStart::~GetCanadianFuelStationInfoStart() {
}

inline GetCanadianFuelStationInfoStart& GetCanadianFuelStationInfoStart::operator = (const GetCanadianFuelStationInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCANADIAN_FUEL_LOCID()) {
            setCANADIAN_FUEL_LOCID(rhs.getCANADIAN_FUEL_LOCID());
        } else {
            clearCANADIAN_FUEL_LOCID();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetCanadianFuelStationInfoStart::operator == (const GetCanadianFuelStationInfoStart& rhs) const {
    return (((!hasCANADIAN_FUEL_LOCID() && !rhs.hasCANADIAN_FUEL_LOCID()) || getCANADIAN_FUEL_LOCID() == rhs.getCANADIAN_FUEL_LOCID()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetCanadianFuelStationInfoStart::operator != (const GetCanadianFuelStationInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelStationInfoStart::operator < (const GetCanadianFuelStationInfoStart& rhs) const {
    if (hasCANADIAN_FUEL_LOCID() || rhs.hasCANADIAN_FUEL_LOCID()) {
        if (getCANADIAN_FUEL_LOCID() < rhs.getCANADIAN_FUEL_LOCID()) return true;
        if (getCANADIAN_FUEL_LOCID() > rhs.getCANADIAN_FUEL_LOCID()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCanadianFuelStationInfoStart::clone() {
    return new GetCanadianFuelStationInfoStart(*this);
}

inline bool GetCanadianFuelStationInfoStart::operator > (const GetCanadianFuelStationInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelStationInfoStart::clear() {
    clearCANADIAN_FUEL_LOCID();
    clearListID();
}

inline void GetCanadianFuelStationInfoStart::clearCANADIAN_FUEL_LOCID() {
    if (hasCANADIAN_FUEL_LOCID()) {
         clear_has_CANADIAN_FUEL_LOCID();
        _CANADIAN_FUEL_LOCID = 0u;
     }
}

inline bool GetCanadianFuelStationInfoStart::hasCANADIAN_FUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetCanadianFuelStationInfoStart::getCANADIAN_FUEL_LOCID () const {
    return _CANADIAN_FUEL_LOCID;
}

inline void GetCanadianFuelStationInfoStart::setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_) {
    set_has_CANADIAN_FUEL_LOCID();
    this->_CANADIAN_FUEL_LOCID = CANADIAN_FUEL_LOCID_;
}

inline void GetCanadianFuelStationInfoStart::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetCanadianFuelStationInfoStart::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetCanadianFuelStationInfoStart::getListID () const {
    return _ListID;
}

inline void GetCanadianFuelStationInfoStart::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetCanadianFuelStationInfoStart::set_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelStationInfoStart::clear_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetCanadianFuelStationInfoStart::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetCanadianFuelStationInfoStart::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetCanadianFuelStationInfoResult::GetCanadianFuelStationInfoResult ()  :
    _CanadianFuelStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoResult::GetCanadianFuelStationInfoResult (const GetCanadianFuelStationInfoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _CanadianFuelStationInfo (),
    _ListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelStationInfoResult::GetCanadianFuelStationInfoResult (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& CanadianFuelStationInfo_, uint32 ListID_)  :
    _CanadianFuelStationInfo (CanadianFuelStationInfo_),
    _ListID (ListID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoResult::~GetCanadianFuelStationInfoResult() {
}

inline GetCanadianFuelStationInfoResult& GetCanadianFuelStationInfoResult::operator = (const GetCanadianFuelStationInfoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCanadianFuelStationInfo()) {
            setCanadianFuelStationInfo(rhs.getCanadianFuelStationInfo());
        } else {
            clearCanadianFuelStationInfo();
        }
        if (rhs.hasListID()) {
            setListID(rhs.getListID());
        } else {
            clearListID();
        }
    }
    return *this;
}

inline bool GetCanadianFuelStationInfoResult::operator == (const GetCanadianFuelStationInfoResult& rhs) const {
    return (((!hasCanadianFuelStationInfo() && !rhs.hasCanadianFuelStationInfo()) || getCanadianFuelStationInfo() == rhs.getCanadianFuelStationInfo()) &&
        ((!hasListID() && !rhs.hasListID()) || getListID() == rhs.getListID()));
}

inline bool GetCanadianFuelStationInfoResult::operator != (const GetCanadianFuelStationInfoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelStationInfoResult::operator < (const GetCanadianFuelStationInfoResult& rhs) const {
    if (hasCanadianFuelStationInfo() || rhs.hasCanadianFuelStationInfo()) {
        if (getCanadianFuelStationInfo() < rhs.getCanadianFuelStationInfo()) return true;
        if (getCanadianFuelStationInfo() > rhs.getCanadianFuelStationInfo()) return false;
    }
    if (hasListID() || rhs.hasListID()) {
        if (getListID() < rhs.getListID()) return true;
        if (getListID() > rhs.getListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCanadianFuelStationInfoResult::clone() {
    return new GetCanadianFuelStationInfoResult(*this);
}

inline bool GetCanadianFuelStationInfoResult::operator > (const GetCanadianFuelStationInfoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelStationInfoResult::clear() {
    clearCanadianFuelStationInfo();
    clearListID();
}

inline void GetCanadianFuelStationInfoResult::clearCanadianFuelStationInfo() {
    if (hasCanadianFuelStationInfo()) {
         clear_has_CanadianFuelStationInfo();
        _CanadianFuelStationInfo.clear();
     }
}

inline bool GetCanadianFuelStationInfoResult::hasCanadianFuelStationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& GetCanadianFuelStationInfoResult::getCanadianFuelStationInfo () const {
    return _CanadianFuelStationInfo;
}

inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& GetCanadianFuelStationInfoResult::getCanadianFuelStationInfoMutable () {
    set_has_CanadianFuelStationInfo();
    return _CanadianFuelStationInfo;
}

inline void GetCanadianFuelStationInfoResult::setCanadianFuelStationInfo (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelStationInfo& CanadianFuelStationInfo_) {
    set_has_CanadianFuelStationInfo();
    this->_CanadianFuelStationInfo = CanadianFuelStationInfo_;
}

inline void GetCanadianFuelStationInfoResult::clearListID() {
    if (hasListID()) {
         clear_has_ListID();
        _ListID = 0u;
     }
}

inline bool GetCanadianFuelStationInfoResult::hasListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetCanadianFuelStationInfoResult::getListID () const {
    return _ListID;
}

inline void GetCanadianFuelStationInfoResult::setListID (uint32 ListID_) {
    set_has_ListID();
    this->_ListID = ListID_;
}

inline void GetCanadianFuelStationInfoResult::set_has_CanadianFuelStationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelStationInfoResult::clear_has_CanadianFuelStationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetCanadianFuelStationInfoResult::set_has_ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetCanadianFuelStationInfoResult::clear_has_ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetCanadianFuelStationInfoErrorStructure::GetCanadianFuelStationInfoErrorStructure ()  :
    _ErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoErrorStructure::GetCanadianFuelStationInfoErrorStructure (const GetCanadianFuelStationInfoErrorStructure &rhs)  :
    _ErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCanadianFuelStationInfoErrorStructure::GetCanadianFuelStationInfoErrorStructure (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8CanFuelErrorTypes", "ErrorCode", "GetCanadianFuelStationInfoErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCanadianFuelStationInfoErrorStructure::~GetCanadianFuelStationInfoErrorStructure() {
}

inline GetCanadianFuelStationInfoErrorStructure& GetCanadianFuelStationInfoErrorStructure::operator = (const GetCanadianFuelStationInfoErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool GetCanadianFuelStationInfoErrorStructure::operator == (const GetCanadianFuelStationInfoErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool GetCanadianFuelStationInfoErrorStructure::operator != (const GetCanadianFuelStationInfoErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelStationInfoErrorStructure::operator < (const GetCanadianFuelStationInfoErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool GetCanadianFuelStationInfoErrorStructure::operator > (const GetCanadianFuelStationInfoErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCanadianFuelStationInfoErrorStructure::clear() {
    clearErrorCode();
}

inline void GetCanadianFuelStationInfoErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes__CAN_FUEL_INFOLIST_EMPTY;
     }
}

inline bool GetCanadianFuelStationInfoErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes GetCanadianFuelStationInfoErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void GetCanadianFuelStationInfoErrorStructure::setErrorCode (::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes ErrorCode_) {
    #ifndef NDEBUG
    if (!(::sxm_canadian_fuel_main_fi_types::T_e8CanFuelErrorTypes_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "T_e8CanFuelErrorTypes", "ErrorCode", "GetCanadianFuelStationInfoErrorStructure");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void GetCanadianFuelStationInfoErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCanadianFuelStationInfoErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoError (const GetCanadianFuelStationInfoError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  GetCanadianFuelStationInfoError::~GetCanadianFuelStationInfoError() {
    deleteData ();
}

inline GetCanadianFuelStationInfoError& GetCanadianFuelStationInfoError::operator = (const GetCanadianFuelStationInfoError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool GetCanadianFuelStationInfoError::operator == (const GetCanadianFuelStationInfoError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool GetCanadianFuelStationInfoError::operator != (const GetCanadianFuelStationInfoError& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCanadianFuelStationInfoError::operator < (const GetCanadianFuelStationInfoError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool GetCanadianFuelStationInfoError::operator > (const GetCanadianFuelStationInfoError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoErrorField GetCanadianFuelStationInfoError::getField () const {
    return __field;
}

inline void GetCanadianFuelStationInfoError::setField(GetCanadianFuelStationInfoError::GetCanadianFuelStationInfoErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* GetCanadianFuelStationInfoError::clone() {
    return new GetCanadianFuelStationInfoError(*this);
}

inline bool GetCanadianFuelStationInfoError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const GetCanadianFuelStationInfoErrorStructure& GetCanadianFuelStationInfoError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetCanadianFuelStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return GetCanadianFuelStationInfoErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetCanadianFuelStationInfoErrorStructure& GetCanadianFuelStationInfoError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "GetCanadianFuelStationInfoError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetCanadianFuelStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline GetCanadianFuelStationInfoErrorStructure* GetCanadianFuelStationInfoError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'GetCanadianFuelStationInfoError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new GetCanadianFuelStationInfoErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        GetCanadianFuelStationInfoErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void GetCanadianFuelStationInfoError::replaceCcaErrorCode (GetCanadianFuelStationInfoErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void GetCanadianFuelStationInfoError::setCcaErrorCode (const GetCanadianFuelStationInfoErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new GetCanadianFuelStationInfoErrorStructure(value);
    }
}

inline bool GetCanadianFuelStationInfoError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode GetCanadianFuelStationInfoError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "GetCanadianFuelStationInfoError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void GetCanadianFuelStationInfoError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "GetCanadianFuelStationInfoError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void GetCanadianFuelStationInfoError::cloneData (const GetCanadianFuelStationInfoError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new GetCanadianFuelStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new GetCanadianFuelStationInfoErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void GetCanadianFuelStationInfoError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AddFavoriteStart::AddFavoriteStart ()  :
    _CANADIAN_FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteStart::AddFavoriteStart (const AddFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _CANADIAN_FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteStart::AddFavoriteStart (uint32 CANADIAN_FUEL_LOCID_)  :
    _CANADIAN_FUEL_LOCID (CANADIAN_FUEL_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteStart::~AddFavoriteStart() {
}

inline AddFavoriteStart& AddFavoriteStart::operator = (const AddFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCANADIAN_FUEL_LOCID()) {
            setCANADIAN_FUEL_LOCID(rhs.getCANADIAN_FUEL_LOCID());
        } else {
            clearCANADIAN_FUEL_LOCID();
        }
    }
    return *this;
}

inline bool AddFavoriteStart::operator == (const AddFavoriteStart& rhs) const {
    return (((!hasCANADIAN_FUEL_LOCID() && !rhs.hasCANADIAN_FUEL_LOCID()) || getCANADIAN_FUEL_LOCID() == rhs.getCANADIAN_FUEL_LOCID()));
}

inline bool AddFavoriteStart::operator != (const AddFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteStart::operator < (const AddFavoriteStart& rhs) const {
    if (hasCANADIAN_FUEL_LOCID() || rhs.hasCANADIAN_FUEL_LOCID()) {
        if (getCANADIAN_FUEL_LOCID() < rhs.getCANADIAN_FUEL_LOCID()) return true;
        if (getCANADIAN_FUEL_LOCID() > rhs.getCANADIAN_FUEL_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteStart::clone() {
    return new AddFavoriteStart(*this);
}

inline bool AddFavoriteStart::operator > (const AddFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteStart::clear() {
    clearCANADIAN_FUEL_LOCID();
}

inline void AddFavoriteStart::clearCANADIAN_FUEL_LOCID() {
    if (hasCANADIAN_FUEL_LOCID()) {
         clear_has_CANADIAN_FUEL_LOCID();
        _CANADIAN_FUEL_LOCID = 0u;
     }
}

inline bool AddFavoriteStart::hasCANADIAN_FUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AddFavoriteStart::getCANADIAN_FUEL_LOCID () const {
    return _CANADIAN_FUEL_LOCID;
}

inline void AddFavoriteStart::setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_) {
    set_has_CANADIAN_FUEL_LOCID();
    this->_CANADIAN_FUEL_LOCID = CANADIAN_FUEL_LOCID_;
}

inline void AddFavoriteStart::set_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteStart::clear_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddFavoriteResult::AddFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddFavoriteResult::AddFavoriteResult (const AddFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddFavoriteResult::AddFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddFavoriteResult::~AddFavoriteResult() {
}

inline AddFavoriteResult& AddFavoriteResult::operator = (const AddFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AddFavoriteResult::operator == (const AddFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AddFavoriteResult::operator != (const AddFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AddFavoriteResult::operator < (const AddFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddFavoriteResult::clone() {
    return new AddFavoriteResult(*this);
}

inline bool AddFavoriteResult::operator > (const AddFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddFavoriteResult::clear() {
    clearStatus();
}

inline void AddFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool AddFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AddFavoriteResult::getStatus () const {
    return _Status;
}

inline void AddFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void AddFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteStart::RemoveFavoriteStart ()  :
    _CANADIAN_FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (const RemoveFavoriteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _CANADIAN_FUEL_LOCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteStart::RemoveFavoriteStart (uint32 CANADIAN_FUEL_LOCID_)  :
    _CANADIAN_FUEL_LOCID (CANADIAN_FUEL_LOCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteStart::~RemoveFavoriteStart() {
}

inline RemoveFavoriteStart& RemoveFavoriteStart::operator = (const RemoveFavoriteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCANADIAN_FUEL_LOCID()) {
            setCANADIAN_FUEL_LOCID(rhs.getCANADIAN_FUEL_LOCID());
        } else {
            clearCANADIAN_FUEL_LOCID();
        }
    }
    return *this;
}

inline bool RemoveFavoriteStart::operator == (const RemoveFavoriteStart& rhs) const {
    return (((!hasCANADIAN_FUEL_LOCID() && !rhs.hasCANADIAN_FUEL_LOCID()) || getCANADIAN_FUEL_LOCID() == rhs.getCANADIAN_FUEL_LOCID()));
}

inline bool RemoveFavoriteStart::operator != (const RemoveFavoriteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteStart::operator < (const RemoveFavoriteStart& rhs) const {
    if (hasCANADIAN_FUEL_LOCID() || rhs.hasCANADIAN_FUEL_LOCID()) {
        if (getCANADIAN_FUEL_LOCID() < rhs.getCANADIAN_FUEL_LOCID()) return true;
        if (getCANADIAN_FUEL_LOCID() > rhs.getCANADIAN_FUEL_LOCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteStart::clone() {
    return new RemoveFavoriteStart(*this);
}

inline bool RemoveFavoriteStart::operator > (const RemoveFavoriteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteStart::clear() {
    clearCANADIAN_FUEL_LOCID();
}

inline void RemoveFavoriteStart::clearCANADIAN_FUEL_LOCID() {
    if (hasCANADIAN_FUEL_LOCID()) {
         clear_has_CANADIAN_FUEL_LOCID();
        _CANADIAN_FUEL_LOCID = 0u;
     }
}

inline bool RemoveFavoriteStart::hasCANADIAN_FUEL_LOCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RemoveFavoriteStart::getCANADIAN_FUEL_LOCID () const {
    return _CANADIAN_FUEL_LOCID;
}

inline void RemoveFavoriteStart::setCANADIAN_FUEL_LOCID (uint32 CANADIAN_FUEL_LOCID_) {
    set_has_CANADIAN_FUEL_LOCID();
    this->_CANADIAN_FUEL_LOCID = CANADIAN_FUEL_LOCID_;
}

inline void RemoveFavoriteStart::set_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteStart::clear_has_CANADIAN_FUEL_LOCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveFavoriteResult::RemoveFavoriteResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (const RemoveFavoriteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveFavoriteResult::RemoveFavoriteResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveFavoriteResult::~RemoveFavoriteResult() {
}

inline RemoveFavoriteResult& RemoveFavoriteResult::operator = (const RemoveFavoriteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RemoveFavoriteResult::operator == (const RemoveFavoriteResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RemoveFavoriteResult::operator != (const RemoveFavoriteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveFavoriteResult::operator < (const RemoveFavoriteResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveFavoriteResult::clone() {
    return new RemoveFavoriteResult(*this);
}

inline bool RemoveFavoriteResult::operator > (const RemoveFavoriteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveFavoriteResult::clear() {
    clearStatus();
}

inline void RemoveFavoriteResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool RemoveFavoriteResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoveFavoriteResult::getStatus () const {
    return _Status;
}

inline void RemoveFavoriteResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void RemoveFavoriteResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveFavoriteResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigStart::SetListsConfigStart ()  :
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigStart::SetListsConfigStart (const SetListsConfigStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Config ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigStart::SetListsConfigStart (const ::sxm_main_fi_types::T_SxmListsConfig& Config_)  :
    _Config (Config_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigStart::~SetListsConfigStart() {
}

inline SetListsConfigStart& SetListsConfigStart::operator = (const SetListsConfigStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfig()) {
            setConfig(rhs.getConfig());
        } else {
            clearConfig();
        }
    }
    return *this;
}

inline bool SetListsConfigStart::operator == (const SetListsConfigStart& rhs) const {
    return (((!hasConfig() && !rhs.hasConfig()) || getConfig() == rhs.getConfig()));
}

inline bool SetListsConfigStart::operator != (const SetListsConfigStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigStart::operator < (const SetListsConfigStart& rhs) const {
    if (hasConfig() || rhs.hasConfig()) {
        if (getConfig() < rhs.getConfig()) return true;
        if (getConfig() > rhs.getConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigStart::clone() {
    return new SetListsConfigStart(*this);
}

inline bool SetListsConfigStart::operator > (const SetListsConfigStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigStart::clear() {
    clearConfig();
}

inline void SetListsConfigStart::clearConfig() {
    if (hasConfig()) {
         clear_has_Config();
        _Config.clear();
     }
}

inline bool SetListsConfigStart::hasConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfig () const {
    return _Config;
}

inline ::sxm_main_fi_types::T_SxmListsConfig& SetListsConfigStart::getConfigMutable () {
    set_has_Config();
    return _Config;
}

inline void SetListsConfigStart::setConfig (const ::sxm_main_fi_types::T_SxmListsConfig& Config_) {
    set_has_Config();
    this->_Config = Config_;
}

inline void SetListsConfigStart::set_has_Config () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigStart::clear_has_Config () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetListsConfigResult::SetListsConfigResult ()  :
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetListsConfigResult::SetListsConfigResult (const SetListsConfigResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetListsConfigResult::SetListsConfigResult (bool Status_)  :
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetListsConfigResult::~SetListsConfigResult() {
}

inline SetListsConfigResult& SetListsConfigResult::operator = (const SetListsConfigResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetListsConfigResult::operator == (const SetListsConfigResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetListsConfigResult::operator != (const SetListsConfigResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetListsConfigResult::operator < (const SetListsConfigResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetListsConfigResult::clone() {
    return new SetListsConfigResult(*this);
}

inline bool SetListsConfigResult::operator > (const SetListsConfigResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetListsConfigResult::clear() {
    clearStatus();
}

inline void SetListsConfigResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SetListsConfigResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetListsConfigResult::getStatus () const {
    return _Status;
}

inline void SetListsConfigResult::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SetListsConfigResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetListsConfigResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanadianFuelInfoListsStatusStatus::CanadianFuelInfoListsStatusStatus ()  :
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanadianFuelInfoListsStatusStatus::CanadianFuelInfoListsStatusStatus (const CanadianFuelInfoListsStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _InfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanadianFuelInfoListsStatusStatus::CanadianFuelInfoListsStatusStatus (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_)  :
    _InfoList (InfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanadianFuelInfoListsStatusStatus::~CanadianFuelInfoListsStatusStatus() {
}

inline CanadianFuelInfoListsStatusStatus& CanadianFuelInfoListsStatusStatus::operator = (const CanadianFuelInfoListsStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInfoList()) {
            setInfoList(rhs.getInfoList());
        } else {
            clearInfoList();
        }
    }
    return *this;
}

inline bool CanadianFuelInfoListsStatusStatus::operator == (const CanadianFuelInfoListsStatusStatus& rhs) const {
    return (((!hasInfoList() && !rhs.hasInfoList()) || getInfoList() == rhs.getInfoList()));
}

inline bool CanadianFuelInfoListsStatusStatus::operator != (const CanadianFuelInfoListsStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CanadianFuelInfoListsStatusStatus::operator < (const CanadianFuelInfoListsStatusStatus& rhs) const {
    if (hasInfoList() || rhs.hasInfoList()) {
        if (getInfoList() < rhs.getInfoList()) return true;
        if (getInfoList() > rhs.getInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanadianFuelInfoListsStatusStatus::clone() {
    return new CanadianFuelInfoListsStatusStatus(*this);
}

inline bool CanadianFuelInfoListsStatusStatus::operator > (const CanadianFuelInfoListsStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanadianFuelInfoListsStatusStatus::clear() {
    clearInfoList();
}

inline void CanadianFuelInfoListsStatusStatus::clearInfoList() {
    if (hasInfoList()) {
         clear_has_InfoList();
        _InfoList.clear();
     }
}

inline bool CanadianFuelInfoListsStatusStatus::hasInfoList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListInfos& CanadianFuelInfoListsStatusStatus::getInfoList () const {
    return _InfoList;
}

inline ::sxm_main_fi_types::T_SxmListInfos& CanadianFuelInfoListsStatusStatus::getInfoListMutable () {
    set_has_InfoList();
    return _InfoList;
}

inline void CanadianFuelInfoListsStatusStatus::setInfoList (const ::sxm_main_fi_types::T_SxmListInfos& InfoList_) {
    set_has_InfoList();
    this->_InfoList = InfoList_;
}

inline void CanadianFuelInfoListsStatusStatus::set_has_InfoList () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanadianFuelInfoListsStatusStatus::clear_has_InfoList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanadianFuelBrandNameListStatus::CanadianFuelBrandNameListStatus ()  :
    _BrandName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanadianFuelBrandNameListStatus::CanadianFuelBrandNameListStatus (const CanadianFuelBrandNameListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _BrandName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanadianFuelBrandNameListStatus::CanadianFuelBrandNameListStatus (const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& BrandName_)  :
    _BrandName (BrandName_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanadianFuelBrandNameListStatus::~CanadianFuelBrandNameListStatus() {
}

inline CanadianFuelBrandNameListStatus& CanadianFuelBrandNameListStatus::operator = (const CanadianFuelBrandNameListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBrandName()) {
            setBrandName(rhs.getBrandName());
        } else {
            clearBrandName();
        }
    }
    return *this;
}

inline bool CanadianFuelBrandNameListStatus::operator == (const CanadianFuelBrandNameListStatus& rhs) const {
    return (((!hasBrandName() && !rhs.hasBrandName()) || getBrandName() == rhs.getBrandName()));
}

inline bool CanadianFuelBrandNameListStatus::operator != (const CanadianFuelBrandNameListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CanadianFuelBrandNameListStatus::operator < (const CanadianFuelBrandNameListStatus& rhs) const {
    if (hasBrandName() || rhs.hasBrandName()) {
        if (getBrandName() < rhs.getBrandName()) return true;
        if (getBrandName() > rhs.getBrandName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanadianFuelBrandNameListStatus::clone() {
    return new CanadianFuelBrandNameListStatus(*this);
}

inline bool CanadianFuelBrandNameListStatus::operator > (const CanadianFuelBrandNameListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanadianFuelBrandNameListStatus::clear() {
    clearBrandName();
}

inline void CanadianFuelBrandNameListStatus::clearBrandName() {
    if (hasBrandName()) {
         clear_has_BrandName();
        _BrandName.clear();
     }
}

inline bool CanadianFuelBrandNameListStatus::hasBrandName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& CanadianFuelBrandNameListStatus::getBrandName () const {
    return _BrandName;
}

inline ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& CanadianFuelBrandNameListStatus::getBrandNameMutable () {
    set_has_BrandName();
    return _BrandName;
}

inline void CanadianFuelBrandNameListStatus::setBrandName (const ::sxm_canadian_fuel_main_fi_types::T_CanBrandNameList& BrandName_) {
    set_has_BrandName();
    this->_BrandName = BrandName_;
}

inline void CanadianFuelBrandNameListStatus::set_has_BrandName () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanadianFuelBrandNameListStatus::clear_has_BrandName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CanadianFuelTypeListStatus::CanadianFuelTypeListStatus ()  :
    _TypeName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CanadianFuelTypeListStatus::CanadianFuelTypeListStatus (const CanadianFuelTypeListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TypeName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CanadianFuelTypeListStatus::CanadianFuelTypeListStatus (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& TypeName_)  :
    _TypeName (TypeName_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CanadianFuelTypeListStatus::~CanadianFuelTypeListStatus() {
}

inline CanadianFuelTypeListStatus& CanadianFuelTypeListStatus::operator = (const CanadianFuelTypeListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTypeName()) {
            setTypeName(rhs.getTypeName());
        } else {
            clearTypeName();
        }
    }
    return *this;
}

inline bool CanadianFuelTypeListStatus::operator == (const CanadianFuelTypeListStatus& rhs) const {
    return (((!hasTypeName() && !rhs.hasTypeName()) || getTypeName() == rhs.getTypeName()));
}

inline bool CanadianFuelTypeListStatus::operator != (const CanadianFuelTypeListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CanadianFuelTypeListStatus::operator < (const CanadianFuelTypeListStatus& rhs) const {
    if (hasTypeName() || rhs.hasTypeName()) {
        if (getTypeName() < rhs.getTypeName()) return true;
        if (getTypeName() > rhs.getTypeName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CanadianFuelTypeListStatus::clone() {
    return new CanadianFuelTypeListStatus(*this);
}

inline bool CanadianFuelTypeListStatus::operator > (const CanadianFuelTypeListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CanadianFuelTypeListStatus::clear() {
    clearTypeName();
}

inline void CanadianFuelTypeListStatus::clearTypeName() {
    if (hasTypeName()) {
         clear_has_TypeName();
        _TypeName.clear();
     }
}

inline bool CanadianFuelTypeListStatus::hasTypeName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& CanadianFuelTypeListStatus::getTypeName () const {
    return _TypeName;
}

inline ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& CanadianFuelTypeListStatus::getTypeNameMutable () {
    set_has_TypeName();
    return _TypeName;
}

inline void CanadianFuelTypeListStatus::setTypeName (const ::sxm_canadian_fuel_main_fi_types::T_CanFuelTypeList& TypeName_) {
    set_has_TypeName();
    this->_TypeName = TypeName_;
}

inline void CanadianFuelTypeListStatus::set_has_TypeName () {
    _has_bits_[0] |= 1u << 0;
}

inline void CanadianFuelTypeListStatus::clear_has_TypeName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus ()  :
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const SxmDataServiceStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DataServiceState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmDataServiceStatusStatus::SxmDataServiceStatusStatus (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_)  :
    _DataServiceState (DataServiceState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmDataServiceStatusStatus::~SxmDataServiceStatusStatus() {
}

inline SxmDataServiceStatusStatus& SxmDataServiceStatusStatus::operator = (const SxmDataServiceStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataServiceState()) {
            setDataServiceState(rhs.getDataServiceState());
        } else {
            clearDataServiceState();
        }
    }
    return *this;
}

inline bool SxmDataServiceStatusStatus::operator == (const SxmDataServiceStatusStatus& rhs) const {
    return (((!hasDataServiceState() && !rhs.hasDataServiceState()) || getDataServiceState() == rhs.getDataServiceState()));
}

inline bool SxmDataServiceStatusStatus::operator != (const SxmDataServiceStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmDataServiceStatusStatus::operator < (const SxmDataServiceStatusStatus& rhs) const {
    if (hasDataServiceState() || rhs.hasDataServiceState()) {
        if (getDataServiceState() < rhs.getDataServiceState()) return true;
        if (getDataServiceState() > rhs.getDataServiceState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmDataServiceStatusStatus::clone() {
    return new SxmDataServiceStatusStatus(*this);
}

inline bool SxmDataServiceStatusStatus::operator > (const SxmDataServiceStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmDataServiceStatusStatus::clear() {
    clearDataServiceState();
}

inline void SxmDataServiceStatusStatus::clearDataServiceState() {
    if (hasDataServiceState()) {
         clear_has_DataServiceState();
        _DataServiceState.clear();
     }
}

inline bool SxmDataServiceStatusStatus::hasDataServiceState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceState () const {
    return _DataServiceState;
}

inline ::sxm_main_fi_types::T_SxmDataSrvState& SxmDataServiceStatusStatus::getDataServiceStateMutable () {
    set_has_DataServiceState();
    return _DataServiceState;
}

inline void SxmDataServiceStatusStatus::setDataServiceState (const ::sxm_main_fi_types::T_SxmDataSrvState& DataServiceState_) {
    set_has_DataServiceState();
    this->_DataServiceState = DataServiceState_;
}

inline void SxmDataServiceStatusStatus::set_has_DataServiceState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmDataServiceStatusStatus::clear_has_DataServiceState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeStatus::SxmListModeStatus ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeStatus::SxmListModeStatus (const SxmListModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeStatus::SxmListModeStatus (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeStatus::~SxmListModeStatus() {
}

inline SxmListModeStatus& SxmListModeStatus::operator = (const SxmListModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeStatus::operator == (const SxmListModeStatus& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeStatus::operator != (const SxmListModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeStatus::operator < (const SxmListModeStatus& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeStatus::clone() {
    return new SxmListModeStatus(*this);
}

inline bool SxmListModeStatus::operator > (const SxmListModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeStatus::clear() {
    clearListMode();
}

inline void SxmListModeStatus::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeStatus::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeStatus::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeStatus::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeStatus::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeStatus::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SxmListModeSet::SxmListModeSet ()  :
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SxmListModeSet::SxmListModeSet (const SxmListModeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _ListMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SxmListModeSet::SxmListModeSet (const ::sxm_main_fi_types::T_SxmListMode& ListMode_)  :
    _ListMode (ListMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SxmListModeSet::~SxmListModeSet() {
}

inline SxmListModeSet& SxmListModeSet::operator = (const SxmListModeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListMode()) {
            setListMode(rhs.getListMode());
        } else {
            clearListMode();
        }
    }
    return *this;
}

inline bool SxmListModeSet::operator == (const SxmListModeSet& rhs) const {
    return (((!hasListMode() && !rhs.hasListMode()) || getListMode() == rhs.getListMode()));
}

inline bool SxmListModeSet::operator != (const SxmListModeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SxmListModeSet::operator < (const SxmListModeSet& rhs) const {
    if (hasListMode() || rhs.hasListMode()) {
        if (getListMode() < rhs.getListMode()) return true;
        if (getListMode() > rhs.getListMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SxmListModeSet::clone() {
    return new SxmListModeSet(*this);
}

inline bool SxmListModeSet::operator > (const SxmListModeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SxmListModeSet::clear() {
    clearListMode();
}

inline void SxmListModeSet::clearListMode() {
    if (hasListMode()) {
         clear_has_ListMode();
        _ListMode.clear();
     }
}

inline bool SxmListModeSet::hasListMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListMode () const {
    return _ListMode;
}

inline ::sxm_main_fi_types::T_SxmListMode& SxmListModeSet::getListModeMutable () {
    set_has_ListMode();
    return _ListMode;
}

inline void SxmListModeSet::setListMode (const ::sxm_main_fi_types::T_SxmListMode& ListMode_) {
    set_has_ListMode();
    this->_ListMode = ListMode_;
}

inline void SxmListModeSet::set_has_ListMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SxmListModeSet::clear_has_ListMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_canadian_fuel_main_fi

#endif // SXM_CANADIAN_FUEL_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
