/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "sxm_audio_main_fi_types.h"
#include "sxm_audio_main_fi_typesCca.h"
#include "sxm_audio_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::sxm_audio_main_fi_types::T_ChannelListEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getServiceID();
    out << in.getChannelID();
    out << (uint8) in.getChannelNameAvail();
    out << in.getChannelName();
    out << in.getChannelArtistName();
    out << in.getChannelSongName();
    out << in.getPresetNumber();
    out << (uint8) in.getIsLocked();
    out << (uint8) in.getIsAvailable();
    out << (uint8) in.getIsMature();
    out << (uint8) in.getIsSkipped();
    out << (uint8) in.getChannelGraphicAvail();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_ChannelListEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o0;
    in >> o0;
    out.setServiceID(o0);
    uint16 o1;
    in >> o1;
    out.setChannelID(o1);
    bool o2;
    in >> o2;
    out.setChannelNameAvail(o2);
    ::std::string o3;
    in >> o3;
    out.setChannelName(o3);
    ::std::string o4;
    in >> o4;
    out.setChannelArtistName(o4);
    ::std::string o5;
    in >> o5;
    out.setChannelSongName(o5);
    uint8 o6;
    in >> o6;
    out.setPresetNumber(o6);
    bool o7;
    in >> o7;
    out.setIsLocked(o7);
    bool o8;
    in >> o8;
    out.setIsAvailable(o8);
    bool o9;
    in >> o9;
    out.setIsMature(o9);
    bool o10;
    in >> o10;
    out.setIsSkipped(o10);
    uint8 o11;
    in >> o11;
    out.setChannelGraphicAvail((::sxm_audio_main_fi_types::T_e8_Graphics)o11);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_CategoryListEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getCategoryType();
    out << (uint8) in.getCategoryNameAvail();
    out << in.getCategoryName();
    {
        uint32 o12 = static_cast<uint32>(in.getChannelList().size());
        out << o12;
        ::std::vector< ::sxm_audio_main_fi_types::T_ChannelListEntry >::const_iterator o13;
        for (o13 = in.getChannelList().begin(); o13 != in.getChannelList().end(); ++o13) {
            serializeCca((*o13), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_CategoryListEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o14;
    in >> o14;
    out.setCategoryType(o14);
    bool o15;
    in >> o15;
    out.setCategoryNameAvail(o15);
    ::std::string o16;
    in >> o16;
    out.setCategoryName(o16);
    {
        uint32 o17;
        in >> o17;
        out.getChannelListMutable().clear ();
        out.getChannelListMutable().reserve (o17);
        for (uint32 o18 = 0; o18 < o17; o18++) {
            ::sxm_audio_main_fi_types::T_ChannelListEntry o19;
            deserializeCca(in, o19, majorVersion);
            out.getChannelListMutable().push_back (o19);
        }
    }
}

void serializeCca(const ::sxm_audio_main_fi_types::T_PresetListEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getServiceID();
    out << in.getChannelID();
    out << (uint8) in.getChannelNameAvail();
    out << in.getChannelName();
    out << (uint8) in.getChannelActive();
    out << (uint8) in.getChnGraphicAvail();
    out << (uint8) in.getIsSmartFavorite();
    out << (uint8) in.getIsLocked();
    out << (uint8) in.getIsAvailable();
    out << (uint8) in.getIsMature();
    out << (uint8) in.getIsSkipped();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_PresetListEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o20;
    in >> o20;
    out.setServiceID(o20);
    uint16 o21;
    in >> o21;
    out.setChannelID(o21);
    bool o22;
    in >> o22;
    out.setChannelNameAvail(o22);
    ::std::string o23;
    in >> o23;
    out.setChannelName(o23);
    bool o24;
    in >> o24;
    out.setChannelActive(o24);
    uint8 o25;
    in >> o25;
    out.setChnGraphicAvail((::sxm_audio_main_fi_types::T_e8_Graphics)o25);
    bool o26;
    in >> o26;
    out.setIsSmartFavorite(o26);
    bool o27;
    in >> o27;
    out.setIsLocked(o27);
    bool o28;
    in >> o28;
    out.setIsAvailable(o28);
    bool o29;
    in >> o29;
    out.setIsMature(o29);
    bool o30;
    in >> o30;
    out.setIsSkipped(o30);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_ChannelInformation& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getChannelNumber();
    out << in.getSID();
    out << (uint8) in.getChannelNameAvail();
    out << in.getChannelName();
    out << in.getCategoryType();
    out << in.getPrimaryCategoryType();
    out << (uint8) in.getCategoryNameAvail();
    out << in.getCategoryName();
    out << (uint8) in.getArtistSongnameAvail();
    out << (uint8) in.getArtistNameAvail();
    out << in.getArtistName();
    out << (uint8) in.getSongNameAvail();
    out << in.getSongName();
    out << (uint8) in.getExtSongNameAvail();
    out << in.getExtSongName();
    out << (uint8) in.getExtArtistNameAvail();
    out << in.getExtArtistName();
    out << (uint8) in.getChnGraphicAvail();
    out << (uint8) in.getChnArtAvail();
    out << (uint8) in.getAlbumArtAvail();
    out << (uint8) in.getIsLocked();
    out << (uint8) in.getIsAvailable();
    out << (uint8) in.getIsMature();
    out << (uint8) in.getIsSkipped();
    out << (uint8) in.getArtistAlertStatus();
    out << (uint8) in.getSongAlertStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_ChannelInformation& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o31;
    in >> o31;
    out.setChannelNumber(o31);
    uint16 o32;
    in >> o32;
    out.setSID(o32);
    bool o33;
    in >> o33;
    out.setChannelNameAvail(o33);
    ::std::string o34;
    in >> o34;
    out.setChannelName(o34);
    uint16 o35;
    in >> o35;
    out.setCategoryType(o35);
    uint16 o36;
    in >> o36;
    out.setPrimaryCategoryType(o36);
    bool o37;
    in >> o37;
    out.setCategoryNameAvail(o37);
    ::std::string o38;
    in >> o38;
    out.setCategoryName(o38);
    bool o39;
    in >> o39;
    out.setArtistSongnameAvail(o39);
    bool o40;
    in >> o40;
    out.setArtistNameAvail(o40);
    ::std::string o41;
    in >> o41;
    out.setArtistName(o41);
    bool o42;
    in >> o42;
    out.setSongNameAvail(o42);
    ::std::string o43;
    in >> o43;
    out.setSongName(o43);
    bool o44;
    in >> o44;
    out.setExtSongNameAvail(o44);
    ::std::string o45;
    in >> o45;
    out.setExtSongName(o45);
    bool o46;
    in >> o46;
    out.setExtArtistNameAvail(o46);
    ::std::string o47;
    in >> o47;
    out.setExtArtistName(o47);
    bool o48;
    in >> o48;
    out.setChnGraphicAvail(o48);
    uint8 o49;
    in >> o49;
    out.setChnArtAvail((::sxm_audio_main_fi_types::T_e8_Graphics)o49);
    uint8 o50;
    in >> o50;
    out.setAlbumArtAvail((::sxm_audio_main_fi_types::T_e8_Graphics)o50);
    bool o51;
    in >> o51;
    out.setIsLocked(o51);
    bool o52;
    in >> o52;
    out.setIsAvailable(o52);
    bool o53;
    in >> o53;
    out.setIsMature(o53);
    bool o54;
    in >> o54;
    out.setIsSkipped(o54);
    bool o55;
    in >> o55;
    out.setArtistAlertStatus(o55);
    bool o56;
    in >> o56;
    out.setSongAlertStatus(o56);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmSignalQuality& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAntennaStatus();
    out << (uint8) in.getSignalQualityStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmSignalQuality& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o57;
    in >> o57;
    out.setAntennaStatus((::sxm_audio_main_fi_types::T_e8_Sxm_AntennaState)o57);
    uint8 o58;
    in >> o58;
    out.setSignalQualityStatus((::sxm_audio_main_fi_types::T_e8_Sxm_SignalQuality)o58);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmDetSignalQuality& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSigQuality();
    out << in.getTunerStatus();
    out << in.getENSALockStatus();
    out << in.getENSBLockStatus();
    out << in.getBerS1();
    out << in.getBerS2();
    out << in.getBerT();
    out << in.getCtoNS1A();
    out << in.getCtoNS1B();
    out << in.getCtoNS2A();
    out << in.getCtoNS2B();
    out << in.getRSErrsWords();
    out << in.getRSErrSatSymb();
    out << in.getRSErrTerrSymb();
    out << in.getTunerCarrFreqOfset();
    out << in.getRSSI();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmDetSignalQuality& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o59;
    in >> o59;
    out.setSigQuality(o59);
    ::std::string o60;
    in >> o60;
    out.setTunerStatus(o60);
    ::std::string o61;
    in >> o61;
    out.setENSALockStatus(o61);
    ::std::string o62;
    in >> o62;
    out.setENSBLockStatus(o62);
    ::std::string o63;
    in >> o63;
    out.setBerS1(o63);
    ::std::string o64;
    in >> o64;
    out.setBerS2(o64);
    ::std::string o65;
    in >> o65;
    out.setBerT(o65);
    ::std::string o66;
    in >> o66;
    out.setCtoNS1A(o66);
    ::std::string o67;
    in >> o67;
    out.setCtoNS1B(o67);
    ::std::string o68;
    in >> o68;
    out.setCtoNS2A(o68);
    ::std::string o69;
    in >> o69;
    out.setCtoNS2B(o69);
    ::std::string o70;
    in >> o70;
    out.setRSErrsWords(o70);
    ::std::string o71;
    in >> o71;
    out.setRSErrSatSymb(o71);
    ::std::string o72;
    in >> o72;
    out.setRSErrTerrSymb(o72);
    ::std::string o73;
    in >> o73;
    out.setTunerCarrFreqOfset(o73);
    ::std::string o74;
    in >> o74;
    out.setRSSI(o74);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmDetOvrlSignalQuality& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getReceiverState();
    out << in.getOBerS1A();
    out << in.getOBerS2A();
    out << in.getOBerTA();
    out << in.getOBerS1B();
    out << in.getOBerS2B();
    out << in.getOBerTB();
    out << in.getOBERTrbWrdErRt0A();
    out << in.getOBERTrbWrdErRt0B();
    out << in.getOBERTrbWrdErRt1A();
    out << in.getOBERTrbWrdErRt1B();
    out << in.getOBERTrbWrdErRt2A();
    out << in.getOBERTrbWrdErRt2B();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmDetOvrlSignalQuality& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o75;
    in >> o75;
    out.setReceiverState(o75);
    ::std::string o76;
    in >> o76;
    out.setOBerS1A(o76);
    ::std::string o77;
    in >> o77;
    out.setOBerS2A(o77);
    ::std::string o78;
    in >> o78;
    out.setOBerTA(o78);
    ::std::string o79;
    in >> o79;
    out.setOBerS1B(o79);
    ::std::string o80;
    in >> o80;
    out.setOBerS2B(o80);
    ::std::string o81;
    in >> o81;
    out.setOBerTB(o81);
    ::std::string o82;
    in >> o82;
    out.setOBERTrbWrdErRt0A(o82);
    ::std::string o83;
    in >> o83;
    out.setOBERTrbWrdErRt0B(o83);
    ::std::string o84;
    in >> o84;
    out.setOBERTrbWrdErRt1A(o84);
    ::std::string o85;
    in >> o85;
    out.setOBERTrbWrdErRt1B(o85);
    ::std::string o86;
    in >> o86;
    out.setOBERTrbWrdErRt2A(o86);
    ::std::string o87;
    in >> o87;
    out.setOBERTrbWrdErRt2B(o87);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmVersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getModuleId();
    out << in.getHwRev();
    out << in.getSwRev();
    out << in.getSxiRev();
    out << in.getBbRev();
    out << in.getHDecRev();
    out << in.getRFRev();
    out << in.getCapability();
    out << in.getSPLRev();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmVersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o88;
    in >> o88;
    out.setModuleId(o88);
    ::std::string o89;
    in >> o89;
    out.setHwRev(o89);
    ::std::string o90;
    in >> o90;
    out.setSwRev(o90);
    ::std::string o91;
    in >> o91;
    out.setSxiRev(o91);
    ::std::string o92;
    in >> o92;
    out.setBbRev(o92);
    ::std::string o93;
    in >> o93;
    out.setHDecRev(o93);
    ::std::string o94;
    in >> o94;
    out.setRFRev(o94);
    ::std::string o95;
    in >> o95;
    out.setCapability(o95);
    ::std::string o96;
    in >> o96;
    out.setSPLRev(o96);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmDataSubStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSubStatus();
    out << in.getReasonCode();
    out << in.getSuspendedDate();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmDataSubStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o97;
    in >> o97;
    out.setSubStatus(o97);
    uint8 o98;
    in >> o98;
    out.setReasonCode(o98);
    uint32 o99;
    in >> o99;
    out.setSuspendedDate(o99);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getDetSignalQuality(), out, majorVersion);
    serializeCca(in.getDetOvrlSignalQuality(), out, majorVersion);
    serializeCca(in.getSxmVersionInfo(), out, majorVersion);
    serializeCca(in.getSxmSubscriptionState(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getDetSignalQualityMutable(), majorVersion);
    deserializeCca(in, out.getDetOvrlSignalQualityMutable(), majorVersion);
    deserializeCca(in, out.getSxmVersionInfoMutable(), majorVersion);
    deserializeCca(in, out.getSxmSubscriptionStateMutable(), majorVersion);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmSmsDbInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getCgsDb();
    out << in.getFuelDb();
    out << in.getMovieDb();
    out << in.getTabWeatherDb();
    out << in.getStockDb();
    out << in.getWsAlertsDb();
    out << in.getSportsDB();
    out << in.getParkingDB();
    out << in.getPhoneticsDB();
    out << in.getFuelCanadaDB();
    out << in.getSafeViewdb();
    out << in.getSmsVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmSmsDbInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o100;
    in >> o100;
    out.setCgsDb(o100);
    ::std::string o101;
    in >> o101;
    out.setFuelDb(o101);
    ::std::string o102;
    in >> o102;
    out.setMovieDb(o102);
    ::std::string o103;
    in >> o103;
    out.setTabWeatherDb(o103);
    ::std::string o104;
    in >> o104;
    out.setStockDb(o104);
    ::std::string o105;
    in >> o105;
    out.setWsAlertsDb(o105);
    ::std::string o106;
    in >> o106;
    out.setSportsDB(o106);
    ::std::string o107;
    in >> o107;
    out.setParkingDB(o107);
    ::std::string o108;
    in >> o108;
    out.setPhoneticsDB(o108);
    ::std::string o109;
    in >> o109;
    out.setFuelCanadaDB(o109);
    ::std::string o110;
    in >> o110;
    out.setSafeViewdb(o110);
    ::std::string o111;
    in >> o111;
    out.setSmsVersion(o111);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SxmAudioSubInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSubStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SxmAudioSubInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o112;
    in >> o112;
    out.setSubStatus(o112);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SmartFavoritePreset& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPresetIndex();
    out << (uint8) in.getIsSmartFavorite();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SmartFavoritePreset& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o113;
    in >> o113;
    out.setPresetIndex(o113);
    bool o114;
    in >> o114;
    out.setIsSmartFavorite(o114);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SFListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPresetIndex();
    out << (uint8) in.getIsRepeated();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SFListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o115;
    in >> o115;
    out.setPresetIndex(o115);
    bool o116;
    in >> o116;
    out.setIsRepeated(o116);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_InstantReplayStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getRecordDuration();
    out << in.getTimeToLive();
    out << in.getPlayPercentage();
    out << in.getFillPercentage();
    out << in.getElapsedTime();
    out << (uint8) in.getPlaybackStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_InstantReplayStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o117;
    in >> o117;
    out.setRecordDuration(o117);
    uint32 o118;
    in >> o118;
    out.setTimeToLive(o118);
    uint8 o119;
    in >> o119;
    out.setPlayPercentage(o119);
    uint8 o120;
    in >> o120;
    out.setFillPercentage(o120);
    uint32 o121;
    in >> o121;
    out.setElapsedTime(o121);
    uint8 o122;
    in >> o122;
    out.setPlaybackStatus((::sxm_audio_main_fi_types::T_e8_IRPlaybackStatus)o122);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_RegisteredFavorite& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getContentName();
    out << (uint8) in.getIsEnabled();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_RegisteredFavorite& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o123;
    in >> o123;
    out.setContentName(o123);
    bool o124;
    in >> o124;
    out.setIsEnabled(o124);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_b8_ChannelStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getCHANNEL_STATUS_MATURED()) {
        bitmask |= (1 << 0);
    }
    if (in.getCHANNEL_STATUS_LOCKED()) {
        bitmask |= (1 << 1);
    }
    if (in.getCHANNEL_STATUS_SKIPPED()) {
        bitmask |= (1 << 2);
    }
    if (in.getCHANNEL_STATUS_TUNABLE()) {
        bitmask |= (1 << 3);
    }
    if (in.getCHANNEL_STATUS_B4_RFU()) {
        bitmask |= (1 << 4);
    }
    if (in.getCHANNEL_STATUS_B5_RFU()) {
        bitmask |= (1 << 5);
    }
    if (in.getCHANNEL_STATUS_B6_RFU()) {
        bitmask |= (1 << 6);
    }
    if (in.getCHANNEL_STATUS_B7_RFU()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_b8_ChannelStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o125;
    in >> o125;
    uint8 bitmask(o125);

    if (bitmask & (1 << 0)) {
        out.setCHANNEL_STATUS_MATURED (true);
    }
    if (bitmask & (1 << 1)) {
        out.setCHANNEL_STATUS_LOCKED (true);
    }
    if (bitmask & (1 << 2)) {
        out.setCHANNEL_STATUS_SKIPPED (true);
    }
    if (bitmask & (1 << 3)) {
        out.setCHANNEL_STATUS_TUNABLE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setCHANNEL_STATUS_B4_RFU (true);
    }
    if (bitmask & (1 << 5)) {
        out.setCHANNEL_STATUS_B5_RFU (true);
    }
    if (bitmask & (1 << 6)) {
        out.setCHANNEL_STATUS_B6_RFU (true);
    }
    if (bitmask & (1 << 7)) {
        out.setCHANNEL_STATUS_B7_RFU (true);
    }
}

void serializeCca(const ::sxm_audio_main_fi_types::T_AlertInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getServiceID();
    out << in.getChannelID();
    out << (uint8) in.getFavoriteType();
    out << in.getChannelName();
    out << in.getArtistName();
    out << in.getSongName();
    out << (uint8) in.getChnGraphicsAvailable();
    serializeCca(in.getChannelStatus(), out, majorVersion);
    out << (uint8) in.getIsExpired();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_AlertInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o126;
    in >> o126;
    out.setServiceID(o126);
    uint16 o127;
    in >> o127;
    out.setChannelID(o127);
    uint8 o128;
    in >> o128;
    out.setFavoriteType((::sxm_audio_main_fi_types::T_e8_FavoriteType)o128);
    ::std::string o129;
    in >> o129;
    out.setChannelName(o129);
    ::std::string o130;
    in >> o130;
    out.setArtistName(o130);
    ::std::string o131;
    in >> o131;
    out.setSongName(o131);
    uint8 o132;
    in >> o132;
    out.setChnGraphicsAvailable((::sxm_audio_main_fi_types::T_e8_Graphics)o132);
    deserializeCca(in, out.getChannelStatusMutable(), majorVersion);
    bool o133;
    in >> o133;
    out.setIsExpired(o133);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_MarketListEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAbbrMarketName();
    out << in.getFullMarketName();
    out << (uint8) in.getBIsActiveMarket();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_MarketListEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o134;
    in >> o134;
    out.setAbbrMarketName(o134);
    ::std::string o135;
    in >> o135;
    out.setFullMarketName(o135);
    bool o136;
    in >> o136;
    out.setBIsActiveMarket(o136);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getSportType();
    out << in.getLeagueID();
    out << (uint8) in.getLeagueType();
    out << in.getLeagueAbbrName();
    out << in.getLeagueFullName();
    out << in.getTeamID();
    out << in.getTeamName();
    out << in.getTeamNickName();
    out << in.getTeamAbbrName();
    out << in.getTeamFullName();
    out << (uint8) in.getIsFavorite();
    out << (uint8) in.getIsMonitored();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_FavoriteTeam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o137;
    in >> o137;
    out.setSportType((::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport)o137);
    uint8 o138;
    in >> o138;
    out.setLeagueID(o138);
    uint8 o139;
    in >> o139;
    out.setLeagueType((::sxm_audio_main_fi_types::T_e8_SportsFlash_League)o139);
    ::std::string o140;
    in >> o140;
    out.setLeagueAbbrName(o140);
    ::std::string o141;
    in >> o141;
    out.setLeagueFullName(o141);
    uint16 o142;
    in >> o142;
    out.setTeamID(o142);
    ::std::string o143;
    in >> o143;
    out.setTeamName(o143);
    ::std::string o144;
    in >> o144;
    out.setTeamNickName(o144);
    ::std::string o145;
    in >> o145;
    out.setTeamAbbrName(o145);
    ::std::string o146;
    in >> o146;
    out.setTeamFullName(o146);
    bool o147;
    in >> o147;
    out.setIsFavorite(o147);
    bool o148;
    in >> o148;
    out.setIsMonitored(o148);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_Game& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getChannelID();
    out << in.getServiceID();
    out << (uint8) in.getIsLocked();
    out << (uint8) in.getIsMature();
    out << (uint8) in.getIsSkipped();
    out << in.getBias();
    serializeCca(in.getHomeTeam(), out, majorVersion);
    serializeCca(in.getAwayTeam(), out, majorVersion);
    out << (uint8) in.getChnGraphicsAvailable();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_Game& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o149;
    in >> o149;
    out.setChannelID(o149);
    uint16 o150;
    in >> o150;
    out.setServiceID(o150);
    bool o151;
    in >> o151;
    out.setIsLocked(o151);
    bool o152;
    in >> o152;
    out.setIsMature(o152);
    bool o153;
    in >> o153;
    out.setIsSkipped(o153);
    uint16 o154;
    in >> o154;
    out.setBias(o154);
    deserializeCca(in, out.getHomeTeamMutable(), majorVersion);
    deserializeCca(in, out.getAwayTeamMutable(), majorVersion);
    uint8 o155;
    in >> o155;
    out.setChnGraphicsAvailable((::sxm_audio_main_fi_types::T_e8_Graphics)o155);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getGameInfo(), out, majorVersion);
    out << in.getFlashEventID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_FlashEvent& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getGameInfoMutable(), majorVersion);
    uint32 o156;
    in >> o156;
    out.setFlashEventID(o156);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_League& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getSportType();
    out << in.getLeagueID();
    out << (uint8) in.getLeagueType();
    out << in.getLeagueAbbrName();
    out << in.getLeagueFullName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_League& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o157;
    in >> o157;
    out.setSportType((::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport)o157);
    uint8 o158;
    in >> o158;
    out.setLeagueID(o158);
    uint8 o159;
    in >> o159;
    out.setLeagueType((::sxm_audio_main_fi_types::T_e8_SportsFlash_League)o159);
    ::std::string o160;
    in >> o160;
    out.setLeagueAbbrName(o160);
    ::std::string o161;
    in >> o161;
    out.setLeagueFullName(o161);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_Team& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTeamID();
    out << in.getTeamName();
    out << in.getTeamNickName();
    out << in.getTeamAbbrName();
    out << in.getTeamFullName();
    out << (uint8) in.getIsFavorite();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_Team& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o162;
    in >> o162;
    out.setTeamID(o162);
    ::std::string o163;
    in >> o163;
    out.setTeamName(o163);
    ::std::string o164;
    in >> o164;
    out.setTeamNickName(o164);
    ::std::string o165;
    in >> o165;
    out.setTeamAbbrName(o165);
    ::std::string o166;
    in >> o166;
    out.setTeamFullName(o166);
    bool o167;
    in >> o167;
    out.setIsFavorite(o167);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getLeagueID();
    out << in.getTeamID();
    out << (uint8) in.getStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o168;
    in >> o168;
    out.setLeagueID(o168);
    uint16 o169;
    in >> o169;
    out.setTeamID(o169);
    bool o170;
    in >> o170;
    out.setStatus(o170);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_BrowseRateConfiguration& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDuration();
    out << in.getRate();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_BrowseRateConfiguration& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o171;
    in >> o171;
    out.setDuration(o171);
    uint16 o172;
    in >> o172;
    out.setRate(o172);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_BrowseChannelConfig& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o173 = static_cast<uint32>(in.getConfiguration().size());
        out << o173;
        ::std::vector< ::sxm_audio_main_fi_types::T_BrowseRateConfiguration >::const_iterator o174;
        for (o174 = in.getConfiguration().begin(); o174 != in.getConfiguration().end(); ++o174) {
            serializeCca((*o174), out, majorVersion);
        }
    }
    out << (uint8) in.getLoop();
    out << (uint8) in.getType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_BrowseChannelConfig& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o175;
        in >> o175;
        out.getConfigurationMutable().clear ();
        out.getConfigurationMutable().reserve (o175);
        for (uint32 o176 = 0; o176 < o175; o176++) {
            ::sxm_audio_main_fi_types::T_BrowseRateConfiguration o177;
            deserializeCca(in, o177, majorVersion);
            out.getConfigurationMutable().push_back (o177);
        }
    }
    uint8 o178;
    in >> o178;
    out.setLoop((::sxm_audio_main_fi_types::T_e8_BrowseChannelLoop)o178);
    uint8 o179;
    in >> o179;
    out.setType((::sxm_audio_main_fi_types::T_e8_BrowseChannelType)o179);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 bitmask = 0;
    if (in.getCHANNEL_EVENT_SERVICE_ID()) {
        bitmask |= (1 << 0);
    }
    if (in.getCHANNEL_EVENT_CHANNEL_ID()) {
        bitmask |= (1 << 1);
    }
    if (in.getCHANNEL_EVENT_ATTRIBUTES()) {
        bitmask |= (1 << 2);
    }
    if (in.getCHANNEL_EVENT_NAME()) {
        bitmask |= (1 << 3);
    }
    if (in.getCHANNEL_EVENT_CATEGORY()) {
        bitmask |= (1 << 4);
    }
    if (in.getCHANNEL_EVENT_TITLE()) {
        bitmask |= (1 << 5);
    }
    if (in.getCHANNEL_EVENT_ARTIST()) {
        bitmask |= (1 << 6);
    }
    if (in.getCHANNEL_EVENT_ALBUM()) {
        bitmask |= (1 << 7);
    }
    if (in.getCHANNEL_EVENT_ART()) {
        bitmask |= (1 << 8);
    }
    if (in.getCHANNEL_EVENT_REMOVED()) {
        bitmask |= (1 << 9);
    }
    if (in.getCHANNEL_EVENT_b10_reserved()) {
        bitmask |= (1 << 10);
    }
    if (in.getCHANNEL_EVENT_b11_reserved()) {
        bitmask |= (1 << 11);
    }
    if (in.getCHANNEL_EVENT_b12_reserved()) {
        bitmask |= (1 << 12);
    }
    if (in.getCHANNEL_EVENT_b13_reserved()) {
        bitmask |= (1 << 13);
    }
    if (in.getCHANNEL_EVENT_b14_reserved()) {
        bitmask |= (1 << 14);
    }
    if (in.getCHANNEL_EVENT_b15_reserved()) {
        bitmask |= (1 << 15);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_b16_CHANNEL_EVENT& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o180;
    in >> o180;
    uint16 bitmask(o180);

    if (bitmask & (1 << 0)) {
        out.setCHANNEL_EVENT_SERVICE_ID (true);
    }
    if (bitmask & (1 << 1)) {
        out.setCHANNEL_EVENT_CHANNEL_ID (true);
    }
    if (bitmask & (1 << 2)) {
        out.setCHANNEL_EVENT_ATTRIBUTES (true);
    }
    if (bitmask & (1 << 3)) {
        out.setCHANNEL_EVENT_NAME (true);
    }
    if (bitmask & (1 << 4)) {
        out.setCHANNEL_EVENT_CATEGORY (true);
    }
    if (bitmask & (1 << 5)) {
        out.setCHANNEL_EVENT_TITLE (true);
    }
    if (bitmask & (1 << 6)) {
        out.setCHANNEL_EVENT_ARTIST (true);
    }
    if (bitmask & (1 << 7)) {
        out.setCHANNEL_EVENT_ALBUM (true);
    }
    if (bitmask & (1 << 8)) {
        out.setCHANNEL_EVENT_ART (true);
    }
    if (bitmask & (1 << 9)) {
        out.setCHANNEL_EVENT_REMOVED (true);
    }
    if (bitmask & (1 << 10)) {
        out.setCHANNEL_EVENT_b10_reserved (true);
    }
    if (bitmask & (1 << 11)) {
        out.setCHANNEL_EVENT_b11_reserved (true);
    }
    if (bitmask & (1 << 12)) {
        out.setCHANNEL_EVENT_b12_reserved (true);
    }
    if (bitmask & (1 << 13)) {
        out.setCHANNEL_EVENT_b13_reserved (true);
    }
    if (bitmask & (1 << 14)) {
        out.setCHANNEL_EVENT_b14_reserved (true);
    }
    if (bitmask & (1 << 15)) {
        out.setCHANNEL_EVENT_b15_reserved (true);
    }
}

void serializeCca(const ::sxm_audio_main_fi_types::T_LocalTimeDate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getS16Year();
    out << in.getU8Month();
    out << in.getU8Day();
    out << in.getU8Hours();
    out << in.getU8Minutes();
    out << in.getU8Seconds();
    out << in.getU8Weekday();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_LocalTimeDate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int16 o181;
    in >> o181;
    out.setS16Year(o181);
    uint8 o182;
    in >> o182;
    out.setU8Month(o182);
    uint8 o183;
    in >> o183;
    out.setU8Day(o183);
    uint8 o184;
    in >> o184;
    out.setU8Hours(o184);
    uint8 o185;
    in >> o185;
    out.setU8Minutes(o185);
    uint8 o186;
    in >> o186;
    out.setU8Seconds(o186);
    uint8 o187;
    in >> o187;
    out.setU8Weekday(o187);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_PresetEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getIndex();
    out << in.getSID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_PresetEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o188;
    in >> o188;
    out.setIndex(o188);
    uint16 o189;
    in >> o189;
    out.setSID(o189);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_ProfileResponse& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getStatus();
    out << (uint8) in.getProfileAction();
    out << (uint8) in.getProfileStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_ProfileResponse& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o190;
    in >> o190;
    out.setStatus((::sxm_audio_main_fi_types::T_Status)o190);
    uint8 o191;
    in >> o191;
    out.setProfileAction((::sxm_audio_main_fi_types::T_ProfileAction)o191);
    uint8 o192;
    in >> o192;
    out.setProfileStatus((::sxm_audio_main_fi_types::T_ProfileStatus)o192);
}

void serializeCca(const ::sxm_audio_main_fi_types::T_PresetsConfiguration& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBandCount();
    out << in.getBandCapacity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::sxm_audio_main_fi_types::T_PresetsConfiguration& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o193;
    in >> o193;
    out.setBandCount(o193);
    uint8 o194;
    in >> o194;
    out.setBandCapacity(o194);
}

