/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "fi_types.h"
#include "fi_typesJsonPrivate.h"
#include "sxm_agw_main_fi_types.h"
#include "sxm_agw_main_fi_typesConst.h"
#include "sxm_agw_main_fi_typesJson.h"
#include "sxm_agw_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_SXMSharedMemoryDescription"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTileType()) {
        yajl_gen_string(g, (const unsigned char*)  "TileType" , 8);
        const char* s = ::sxm_agw_main_fi_types::T_e8_SXMTileType_Name(value.getTileType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTileType());
    }
    if (!isSparse || value.hasTileDataType()) {
        yajl_gen_string(g, (const unsigned char*)  "TileDataType" , 12);
        const char* s = ::sxm_agw_main_fi_types::T_e8_SXMTileDataType_Name(value.getTileDataType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTileDataType());
    }
    if (!isSparse || value.hasSharedMemoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "SharedMemoryName" , 16);
        const char *s = value.getSharedMemoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSharedMemorySize()) {
        yajl_gen_string(g, (const unsigned char*)  "SharedMemorySize" , 16);
        yajl_gen_integer(g, (long long)value.getSharedMemorySize());
    }
    if (!isSparse || value.hasTimeout()) {
        yajl_gen_string(g, (const unsigned char*)  "Timeout" , 7);
        yajl_gen_integer(g, (long long)value.getTimeout());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMSharedMemoryTile"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasUpperLeftCorner()) {
        yajl_gen_string(g, (const unsigned char*)  "UpperLeftCorner" , 15);
        serializeJson(value.getUpperLeftCorner(), g, options);
    }
    if (!isSparse || value.hasLowerRightCorner()) {
        yajl_gen_string(g, (const unsigned char*)  "LowerRightCorner" , 16);
        serializeJson(value.getLowerRightCorner(), g, options);
    }
    if (!isSparse || value.hasWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "Width" , 5);
        yajl_gen_integer(g, (long long)value.getWidth());
    }
    if (!isSparse || value.hasHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "Height" , 6);
        yajl_gen_integer(g, (long long)value.getHeight());
    }
    if (!isSparse || value.hasPixelValueOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "PixelValueOffset" , 16);
        yajl_gen_integer(g, (long long)value.getPixelValueOffset());
    }
    if (!isSparse || value.hasPixelValuePrecision()) {
        yajl_gen_string(g, (const unsigned char*)  "PixelValuePrecision" , 19);
        yajl_gen_integer(g, (long long)value.getPixelValuePrecision());
    }
    if (!isSparse || value.hasAddressOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "AddressOffset" , 13);
        yajl_gen_integer(g, (long long)value.getAddressOffset());
    }
    if (!isSparse || value.hasTileSize()) {
        yajl_gen_string(g, (const unsigned char*)  "TileSize" , 8);
        yajl_gen_integer(g, (long long)value.getTileSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShape"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShape& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_RESERVED:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_Reserved" , 10);
            serializeJson(value.getT_Reserved(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_FRONT:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeFront" , 19);
            serializeJson(value.getT_SXMShapeTypeFront(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_PRESSURE_CENTER:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypePressureCenter" , 28);
            serializeJson(value.getT_SXMShapeTypePressureCenter(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_ISOBAR:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeIsobar" , 20);
            serializeJson(value.getT_SXMShapeTypeIsobar(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_POSITION:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeStormPosition" , 27);
            serializeJson(value.getT_SXMShapeTypeStormPosition(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_WIND_RADIUS:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeWindRadius" , 24);
            serializeJson(value.getT_SXMShapeTypeWindRadius(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_ATTRIBUTES:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeStormAttributes" , 29);
            serializeJson(value.getT_SXMShapeTypeStormAttributes(), g, options);
            break;
        }
    case ::sxm_agw_main_fi_types::T_SXMShape::E_T_SXMSHAPE_TYPE_STORM_TRACK:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_SXMShapeTypeStormTrack" , 24);
            serializeJson(value.getT_SXMShapeTypeStormTrack(), g, options);
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::sxm_agw_main_fi_types::T_SXMShape& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeFront"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeFront& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasFrontType()) {
        yajl_gen_string(g, (const unsigned char*)  "FrontType" , 9);
        const char* s = ::sxm_agw_main_fi_types::T_e8_FrontType_Name(value.getFrontType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFrontType());
    }
    if (!isSparse || value.hasGeoPoints()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoints" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::fi_types::T_PositionWGS84 >& o1 = value.getGeoPoints();
        {
            ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeFront& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypePressureCenter"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypePressureCenter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasPressureType()) {
        yajl_gen_string(g, (const unsigned char*)  "PressureType" , 12);
        const char* s = ::sxm_agw_main_fi_types::T_e8_PressureType_Name(value.getPressureType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPressureType());
    }
    if (!isSparse || value.hasPressure()) {
        yajl_gen_string(g, (const unsigned char*)  "Pressure" , 8);
        yajl_gen_integer(g, (long long)value.getPressure());
    }
    if (!isSparse || value.hasGeoPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoint" , 8);
        serializeJson(value.getGeoPoint(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypePressureCenter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeIsobar"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeIsobar& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasPressure()) {
        yajl_gen_string(g, (const unsigned char*)  "Pressure" , 8);
        yajl_gen_integer(g, (long long)value.getPressure());
    }
    if (!isSparse || value.hasGeoPoints()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoints" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::fi_types::T_PositionWGS84 >& o3 = value.getGeoPoints();
        {
            ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeIsobar& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeStormPosition"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasStormUniqueId()) {
        yajl_gen_string(g, (const unsigned char*)  "StormUniqueId" , 13);
        const char *s = value.getStormUniqueId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStormName()) {
        yajl_gen_string(g, (const unsigned char*)  "StormName" , 9);
        const char *s = value.getStormName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSequenceId()) {
        yajl_gen_string(g, (const unsigned char*)  "SequenceId" , 10);
        yajl_gen_integer(g, (long long)value.getSequenceId());
    }
    if (!isSparse || value.hasPositionType()) {
        yajl_gen_string(g, (const unsigned char*)  "PositionType" , 12);
        const char* s = ::sxm_agw_main_fi_types::T_e8_StormPositionType_Name(value.getPositionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPositionType());
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "Direction" , 9);
        yajl_gen_integer(g, (long long)value.getDirection());
    }
    if (!isSparse || value.hasSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "Speed" , 5);
        yajl_gen_integer(g, (long long)value.getSpeed());
    }
    if (!isSparse || value.hasMaxSustainedWinds()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxSustainedWinds" , 17);
        yajl_gen_integer(g, (long long)value.getMaxSustainedWinds());
    }
    if (!isSparse || value.hasGusts()) {
        yajl_gen_string(g, (const unsigned char*)  "Gusts" , 5);
        yajl_gen_integer(g, (long long)value.getGusts());
    }
    if (!isSparse || value.hasPressure()) {
        yajl_gen_string(g, (const unsigned char*)  "Pressure" , 8);
        yajl_gen_integer(g, (long long)value.getPressure());
    }
    if (!isSparse || value.hasTimestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "Timestamp" , 9);
        serializeJson(value.getTimestamp(), g, options);
    }
    if (!isSparse || value.hasStormType()) {
        yajl_gen_string(g, (const unsigned char*)  "StormType" , 9);
        const char* s = ::sxm_agw_main_fi_types::T_e8_StormType_Name(value.getStormType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStormType());
    }
    if (!isSparse || value.hasGeoPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoint" , 8);
        serializeJson(value.getGeoPoint(), g, options);
    }
    if (!isSparse || value.hasWindRadii()) {
        yajl_gen_string(g, (const unsigned char*)  "WindRadii" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius >& o5 = value.getWindRadii();
        {
            ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeWindRadius"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasStormUniqueId()) {
        yajl_gen_string(g, (const unsigned char*)  "StormUniqueId" , 13);
        const char *s = value.getStormUniqueId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSequenceId()) {
        yajl_gen_string(g, (const unsigned char*)  "SequenceId" , 10);
        yajl_gen_integer(g, (long long)value.getSequenceId());
    }
    if (!isSparse || value.hasWindSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "WindSpeed" , 9);
        yajl_gen_integer(g, (long long)value.getWindSpeed());
    }
    if (!isSparse || value.hasGeoPoints()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoints" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< ::fi_types::T_PositionWGS84 >& o7 = value.getGeoPoints();
        {
            ::std::vector< ::fi_types::T_PositionWGS84 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeStormAttributes"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormAttributes& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIssueTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IssueTime" , 9);
        serializeJson(value.getIssueTime(), g, options);
    }
    if (!isSparse || value.hasStormUniqueId()) {
        yajl_gen_string(g, (const unsigned char*)  "StormUniqueId" , 13);
        const char *s = value.getStormUniqueId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasObservationTime()) {
        yajl_gen_string(g, (const unsigned char*)  "ObservationTime" , 15);
        serializeJson(value.getObservationTime(), g, options);
    }
    if (!isSparse || value.hasEchoTopHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "EchoTopHeight" , 13);
        yajl_gen_integer(g, (long long)value.getEchoTopHeight());
    }
    if (!isSparse || value.hasMovementDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "MovementDirection" , 17);
        yajl_gen_integer(g, (long long)value.getMovementDirection());
    }
    if (!isSparse || value.hasMovementSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "MovementSpeed" , 13);
        yajl_gen_integer(g, (long long)value.getMovementSpeed());
    }
    if (!isSparse || value.hasStormType()) {
        yajl_gen_string(g, (const unsigned char*)  "StormType" , 9);
        serializeJson(value.getStormType(), g, options);
    }
    if (!isSparse || value.hasGeoPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "GeoPoint" , 8);
        serializeJson(value.getGeoPoint(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormAttributes& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_StormType"

void serializeJson (const ::sxm_agw_main_fi_types::T_b8_StormType& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getHailProbable()) {
        yajl_gen_string(g, (const unsigned char*)  "HailProbable" , 12);
        yajl_gen_bool(g, (bool)value.getHailProbable());
    }
    if (value.getHailPositive()) {
        yajl_gen_string(g, (const unsigned char*)  "HailPositive" , 12);
        yajl_gen_bool(g, (bool)value.getHailPositive());
    }
    if (value.getMesocyclonic()) {
        yajl_gen_string(g, (const unsigned char*)  "Mesocyclonic" , 12);
        yajl_gen_bool(g, (bool)value.getMesocyclonic());
    }
    if (value.getTornadic()) {
        yajl_gen_string(g, (const unsigned char*)  "Tornadic" , 8);
        yajl_gen_bool(g, (bool)value.getTornadic());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_b8_StormType& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SXMShapeTypeStormTrack"

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormTrack& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStormUniqueId()) {
        yajl_gen_string(g, (const unsigned char*)  "StormUniqueId" , 13);
        const char *s = value.getStormUniqueId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStormName()) {
        yajl_gen_string(g, (const unsigned char*)  "StormName" , 9);
        const char *s = value.getStormName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStormPositions()) {
        yajl_gen_string(g, (const unsigned char*)  "StormPositions" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition >& o9 = value.getStormPositions();
        {
            ::std::vector< ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormTrack& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShape& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeFront& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypePressureCenter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeIsobar& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormPosition& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeWindRadius& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormAttributes& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_b8_StormType& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types
using namespace ::asf::stream::json;

namespace sxm_agw_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::sxm_agw_main_fi_types::T_SXMShapeTypeStormTrack& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace sxm_agw_main_fi_types

