/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_AGW_MAIN_FIPROXY_H
#define SXM_AGW_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "sxm_agw_main_fi.h"
#include "sxm_agw_main_fi_types.h"
#include "sxm_agw_main_fi_typesConst.h"
#include <vector>

namespace sxm_agw_main_fi {

class Sxm_agw_main_fiProxy;

class AcquireAccessToSharedMemoryCallbackIF {
public:
    virtual ~AcquireAccessToSharedMemoryCallbackIF() {}

    virtual void onAcquireAccessToSharedMemoryError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< AcquireAccessToSharedMemoryError >& error) = 0;

    virtual void onAcquireAccessToSharedMemoryResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< AcquireAccessToSharedMemoryResult >& result) = 0;
};

class ExchangeCapabilitiesCallbackIF {
public:
    virtual ~ExchangeCapabilitiesCallbackIF() {}

    virtual void onExchangeCapabilitiesError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< ExchangeCapabilitiesError >& error) = 0;

    virtual void onExchangeCapabilitiesResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< ExchangeCapabilitiesResult >& result) = 0;
};

class GetStormAttributesDataCallbackIF {
public:
    virtual ~GetStormAttributesDataCallbackIF() {}

    virtual void onGetStormAttributesDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStormAttributesDataError >& error) = 0;

    virtual void onGetStormAttributesDataResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStormAttributesDataResult >& result) = 0;
};

class GetStormTrackDataCallbackIF {
public:
    virtual ~GetStormTrackDataCallbackIF() {}

    virtual void onGetStormTrackDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStormTrackDataError >& error) = 0;

    virtual void onGetStormTrackDataResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStormTrackDataResult >& result) = 0;
};

class GetSurfaceDataCallbackIF {
public:
    virtual ~GetSurfaceDataCallbackIF() {}

    virtual void onGetSurfaceDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSurfaceDataError >& error) = 0;

    virtual void onGetSurfaceDataResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSurfaceDataResult >& result) = 0;
};

class NowradDataCallbackIF {
public:
    virtual ~NowradDataCallbackIF() {}

    virtual void onNowradDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< NowradDataError >& error) = 0;

    virtual void onNowradDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< NowradDataStatus >& status) = 0;
};

class ReleaseAccessFromSharedMemoryCallbackIF {
public:
    virtual ~ReleaseAccessFromSharedMemoryCallbackIF() {}

    virtual void onReleaseAccessFromSharedMemoryError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< ReleaseAccessFromSharedMemoryError >& error) = 0;

    virtual void onReleaseAccessFromSharedMemoryResult(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< ReleaseAccessFromSharedMemoryResult >& result) = 0;
};

class StormAttributesDataCallbackIF {
public:
    virtual ~StormAttributesDataCallbackIF() {}

    virtual void onStormAttributesDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< StormAttributesDataError >& error) = 0;

    virtual void onStormAttributesDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< StormAttributesDataStatus >& status) = 0;
};

class StormTrackDataCallbackIF {
public:
    virtual ~StormTrackDataCallbackIF() {}

    virtual void onStormTrackDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< StormTrackDataError >& error) = 0;

    virtual void onStormTrackDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< StormTrackDataStatus >& status) = 0;
};

class SurfaceDataCallbackIF {
public:
    virtual ~SurfaceDataCallbackIF() {}

    virtual void onSurfaceDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< SurfaceDataError >& error) = 0;

    virtual void onSurfaceDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< SurfaceDataStatus >& status) = 0;
};

class WindDirectionDataCallbackIF {
public:
    virtual ~WindDirectionDataCallbackIF() {}

    virtual void onWindDirectionDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< WindDirectionDataError >& error) = 0;

    virtual void onWindDirectionDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< WindDirectionDataStatus >& status) = 0;
};

class WindMagnitudeDataCallbackIF {
public:
    virtual ~WindMagnitudeDataCallbackIF() {}

    virtual void onWindMagnitudeDataError(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< WindMagnitudeDataError >& error) = 0;

    virtual void onWindMagnitudeDataStatus(const ::boost::shared_ptr< Sxm_agw_main_fiProxy >& proxy, const ::boost::shared_ptr< WindMagnitudeDataStatus >& status) = 0;
};

class Sxm_agw_main_fiProxyCallback;

/**
 * Sxm_agw_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'sxm_agw_main_fi' (specified in file
 * sxm_agw_main_fi.xml).
 *
 * CCA Functional Interface 'sxm_agw_main_fi'
 *
 * Fullname: VD_RadioData SXM Weather Application Functional Interface
 *
 * Version: $Revision:   2.01  $
 *
 * Author: tbd
 *
 * Date: $Date:  Jan 16 2013   $
 *
 * Department: RBEI/ECV
 *
 * Title: sxm_agw_main_fi
 *
 * <b>Description of 'sxm_agw_main_fi':</b>
 *
 * ..
 */
class Sxm_agw_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Sxm_agw_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_agw_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_agw_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Sxm_agw_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Sxm_agw_main_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Sxm_agw_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Sxm_agw_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Sxm_agw_main_fiProxy();

    // Method 'ExchangeCapabilities'

    /**
     * Call the method 'ExchangeCapabilities'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ExchangeCapabilities'</b>:
     *
     * Method to exchange capabilities between server and client.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param SharedMemories Shared memory data for different graphical tile protocols, requested from client.
     * The client only adds protocols in this list for which he wants to exchange data.
     * Name and size will be left empty from client, they have to be filled from server.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExchangeCapabilitiesStart(ExchangeCapabilitiesCallbackIF& cb, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& sharedMemories);

    // Method 'GetSurfaceData'

    /**
     * Call the method 'GetSurfaceData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetSurfaceData'</b>:
     *
     * Method to get all surface data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSurfaceDataStart(GetSurfaceDataCallbackIF& cb);

    // Method 'GetStormAttributesData'

    /**
     * Call the method 'GetStormAttributesData'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetStormAttributesData'</b>:
     *
     * Method to get all storm-attributes data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStormAttributesDataStart(GetStormAttributesDataCallbackIF& cb);

    // Method 'GetStormTrackData'

    /**
     * Call the method 'GetStormTrackData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetStormTrackData'</b>:
     *
     * Method to get all storm-track data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStormTrackDataStart(GetStormTrackDataCallbackIF& cb);

    // Method 'AcquireAccessToSharedMemory'

    /**
     * Call the method 'AcquireAccessToSharedMemory'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AcquireAccessToSharedMemory'</b>:
     *
     * This method is used by client to acquire access to shared memory for one protocol.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TileType Protocol to acquire access to.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcquireAccessToSharedMemoryStart(AcquireAccessToSharedMemoryCallbackIF& cb, ::sxm_agw_main_fi_types::T_e8_SXMTileType tileType);

    // Method 'ReleaseAccessFromSharedMemory'

    /**
     * Call the method 'ReleaseAccessFromSharedMemory'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ReleaseAccessFromSharedMemory'</b>:
     *
     * This method is used to release the locked Shared Memory. This method implies
     * that the client has copied the necessary contents.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TileType Protocol to release access from.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseAccessFromSharedMemoryStart(ReleaseAccessFromSharedMemoryCallbackIF& cb, ::sxm_agw_main_fi_types::T_e8_SXMTileType tileType);

    // Property 'NowradData'

    /**
     * Notify on the property 'NowradData'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'NowradData'</b>:
     *
     * This property gives information if NOWRAD data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNowradDataUpReg(NowradDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NowradData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NowradData'</b>:
     *
     * This property gives information if NOWRAD data has changed.
     *
     * @param act The act which was previously returned by the
     * sendNowradDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNowradDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NowradData'.
     */
    void sendNowradDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'NowradData' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasNowradData() returns true.
     *
     * @return the previously received value of the property 'NowradData'.
     */
    const NowradDataStatus& getNowradData() const;

    /**
     * Determines whether a status message for the property 'NowradData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNowradData() const;

    /**
     * Request the value of the property 'NowradData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NowradData'</b>:
     *
     * This property gives information if NOWRAD data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNowradDataGet(NowradDataCallbackIF& cb);

    // Property 'WindMagnitudeData'

    /**
     * Notify on the property 'WindMagnitudeData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WindMagnitudeData'</b>:
     *
     * This property gives information if wind-magnitude data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWindMagnitudeDataUpReg(WindMagnitudeDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WindMagnitudeData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WindMagnitudeData'</b>:
     *
     * This property gives information if wind-magnitude data has changed.
     *
     * @param act The act which was previously returned by the
     * sendWindMagnitudeDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWindMagnitudeDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WindMagnitudeData'.
     */
    void sendWindMagnitudeDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'WindMagnitudeData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWindMagnitudeData() returns true.
     *
     * @return the previously received value of the property 'WindMagnitudeData'.
     */
    const WindMagnitudeDataStatus& getWindMagnitudeData() const;

    /**
     * Determines whether a status message for the property 'WindMagnitudeData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWindMagnitudeData() const;

    /**
     * Request the value of the property 'WindMagnitudeData' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WindMagnitudeData'</b>:
     *
     * This property gives information if wind-magnitude data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWindMagnitudeDataGet(WindMagnitudeDataCallbackIF& cb);

    // Property 'WindDirectionData'

    /**
     * Notify on the property 'WindDirectionData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WindDirectionData'</b>:
     *
     * This property gives information if wind-direction data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWindDirectionDataUpReg(WindDirectionDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WindDirectionData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WindDirectionData'</b>:
     *
     * This property gives information if wind-direction data has changed.
     *
     * @param act The act which was previously returned by the
     * sendWindDirectionDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWindDirectionDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WindDirectionData'.
     */
    void sendWindDirectionDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'WindDirectionData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWindDirectionData() returns true.
     *
     * @return the previously received value of the property 'WindDirectionData'.
     */
    const WindDirectionDataStatus& getWindDirectionData() const;

    /**
     * Determines whether a status message for the property 'WindDirectionData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWindDirectionData() const;

    /**
     * Request the value of the property 'WindDirectionData' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WindDirectionData'</b>:
     *
     * This property gives information if wind-direction data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWindDirectionDataGet(WindDirectionDataCallbackIF& cb);

    // Property 'SurfaceData'

    /**
     * Notify on the property 'SurfaceData'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SurfaceData'</b>:
     *
     * This property gives information if surface data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSurfaceDataUpReg(SurfaceDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SurfaceData'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SurfaceData'</b>:
     *
     * This property gives information if surface data has changed.
     *
     * @param act The act which was previously returned by the
     * sendSurfaceDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSurfaceDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SurfaceData'.
     */
    void sendSurfaceDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'SurfaceData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSurfaceData() returns true.
     *
     * @return the previously received value of the property 'SurfaceData'.
     */
    const SurfaceDataStatus& getSurfaceData() const;

    /**
     * Determines whether a status message for the property 'SurfaceData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSurfaceData() const;

    /**
     * Request the value of the property 'SurfaceData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SurfaceData'</b>:
     *
     * This property gives information if surface data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSurfaceDataGet(SurfaceDataCallbackIF& cb);

    // Property 'StormAttributesData'

    /**
     * Notify on the property 'StormAttributesData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'StormAttributesData'</b>:
     *
     * This property gives information if storm-attributes data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStormAttributesDataUpReg(StormAttributesDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'StormAttributesData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'StormAttributesData'</b>:
     *
     * This property gives information if storm-attributes data has changed.
     *
     * @param act The act which was previously returned by the
     * sendStormAttributesDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendStormAttributesDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'StormAttributesData'.
     */
    void sendStormAttributesDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'StormAttributesData' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasStormAttributesData() returns true.
     *
     * @return the previously received value of the property 'StormAttributesData'.
     */
    const StormAttributesDataStatus& getStormAttributesData() const;

    /**
     * Determines whether a status message for the property 'StormAttributesData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStormAttributesData() const;

    /**
     * Request the value of the property 'StormAttributesData' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'StormAttributesData'</b>:
     *
     * This property gives information if storm-attributes data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStormAttributesDataGet(StormAttributesDataCallbackIF& cb);

    // Property 'StormTrackData'

    /**
     * Notify on the property 'StormTrackData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'StormTrackData'</b>:
     *
     * This property gives information if storm-track data has changed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStormTrackDataUpReg(StormTrackDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'StormTrackData'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'StormTrackData'</b>:
     *
     * This property gives information if storm-track data has changed.
     *
     * @param act The act which was previously returned by the
     * sendStormTrackDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendStormTrackDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'StormTrackData'.
     */
    void sendStormTrackDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'StormTrackData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasStormTrackData() returns true.
     *
     * @return the previously received value of the property 'StormTrackData'.
     */
    const StormTrackDataStatus& getStormTrackData() const;

    /**
     * Determines whether a status message for the property 'StormTrackData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStormTrackData() const;

    /**
     * Request the value of the property 'StormTrackData' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'StormTrackData'</b>:
     *
     * This property gives information if storm-track data has changed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStormTrackDataGet(StormTrackDataCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Sxm_agw_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'NowradData'

    ::asf::core::nullable< NowradDataStatus > _nowradData;

    // Property 'WindMagnitudeData'

    ::asf::core::nullable< WindMagnitudeDataStatus > _windMagnitudeData;

    // Property 'WindDirectionData'

    ::asf::core::nullable< WindDirectionDataStatus > _windDirectionData;

    // Property 'SurfaceData'

    ::asf::core::nullable< SurfaceDataStatus > _surfaceData;

    // Property 'StormAttributesData'

    ::asf::core::nullable< StormAttributesDataStatus > _stormAttributesData;

    // Property 'StormTrackData'

    ::asf::core::nullable< StormTrackDataStatus > _stormTrackData;

    DECLARE_CLASS_LOGGER();

    friend class Sxm_agw_main_fiProxyCallback;
};

} // namespace sxm_agw_main_fi

#endif // SXM_AGW_MAIN_FIPROXY_H
