/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "sxm_agw_main_fiCca.h"
#include "sxm_agw_main_fiJson.h"
#include "sxm_agw_main_fiProxy.h"
#include "sxm_agw_main_fi_types.h"
#include "sxm_agw_main_fi_typesConst.h"
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace sxm_agw_main_fi {

/*static*/ ::asf::core::Logger Sxm_agw_main_fiProxy::_logger ("/sxm_agw_main_fi/Sxm_agw_main_fiProxy");


class Sxm_agw_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Sxm_agw_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Sxm_agw_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_agw_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_ExchangeCapabilities: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::ExchangeCapabilitiesResult);
                                setActAndLogResult(message, "ExchangeCapabilities", reinterpret_cast<act_t>(this), _logger);
                                ((ExchangeCapabilitiesCallbackIF*) _callback)->onExchangeCapabilitiesResult (proxy, ::boost::static_pointer_cast<ExchangeCapabilitiesResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::ExchangeCapabilitiesError);
                                setActAndLogError(message, "ExchangeCapabilities", reinterpret_cast<act_t>(this), _logger);
                                ((ExchangeCapabilitiesCallbackIF*) _callback)->onExchangeCapabilitiesError (proxy, ::boost::static_pointer_cast<ExchangeCapabilitiesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetSurfaceData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetSurfaceDataResult);
                                setActAndLogResult(message, "GetSurfaceData", reinterpret_cast<act_t>(this), _logger);
                                ((GetSurfaceDataCallbackIF*) _callback)->onGetSurfaceDataResult (proxy, ::boost::static_pointer_cast<GetSurfaceDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetSurfaceDataError);
                                setActAndLogError(message, "GetSurfaceData", reinterpret_cast<act_t>(this), _logger);
                                ((GetSurfaceDataCallbackIF*) _callback)->onGetSurfaceDataError (proxy, ::boost::static_pointer_cast<GetSurfaceDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetStormAttributesData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetStormAttributesDataResult);
                                setActAndLogResult(message, "GetStormAttributesData", reinterpret_cast<act_t>(this), _logger);
                                ((GetStormAttributesDataCallbackIF*) _callback)->onGetStormAttributesDataResult (proxy, ::boost::static_pointer_cast<GetStormAttributesDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetStormAttributesDataError);
                                setActAndLogError(message, "GetStormAttributesData", reinterpret_cast<act_t>(this), _logger);
                                ((GetStormAttributesDataCallbackIF*) _callback)->onGetStormAttributesDataError (proxy, ::boost::static_pointer_cast<GetStormAttributesDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetStormTrackData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetStormTrackDataResult);
                                setActAndLogResult(message, "GetStormTrackData", reinterpret_cast<act_t>(this), _logger);
                                ((GetStormTrackDataCallbackIF*) _callback)->onGetStormTrackDataResult (proxy, ::boost::static_pointer_cast<GetStormTrackDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::GetStormTrackDataError);
                                setActAndLogError(message, "GetStormTrackData", reinterpret_cast<act_t>(this), _logger);
                                ((GetStormTrackDataCallbackIF*) _callback)->onGetStormTrackDataError (proxy, ::boost::static_pointer_cast<GetStormTrackDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AcquireAccessToSharedMemory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::AcquireAccessToSharedMemoryResult);
                                setActAndLogResult(message, "AcquireAccessToSharedMemory", reinterpret_cast<act_t>(this), _logger);
                                ((AcquireAccessToSharedMemoryCallbackIF*) _callback)->onAcquireAccessToSharedMemoryResult (proxy, ::boost::static_pointer_cast<AcquireAccessToSharedMemoryResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::AcquireAccessToSharedMemoryError);
                                setActAndLogError(message, "AcquireAccessToSharedMemory", reinterpret_cast<act_t>(this), _logger);
                                ((AcquireAccessToSharedMemoryCallbackIF*) _callback)->onAcquireAccessToSharedMemoryError (proxy, ::boost::static_pointer_cast<AcquireAccessToSharedMemoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReleaseAccessFromSharedMemory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::ReleaseAccessFromSharedMemoryResult);
                                setActAndLogResult(message, "ReleaseAccessFromSharedMemory", reinterpret_cast<act_t>(this), _logger);
                                ((ReleaseAccessFromSharedMemoryCallbackIF*) _callback)->onReleaseAccessFromSharedMemoryResult (proxy, ::boost::static_pointer_cast<ReleaseAccessFromSharedMemoryResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::ReleaseAccessFromSharedMemoryError);
                                setActAndLogError(message, "ReleaseAccessFromSharedMemory", reinterpret_cast<act_t>(this), _logger);
                                ((ReleaseAccessFromSharedMemoryCallbackIF*) _callback)->onReleaseAccessFromSharedMemoryError (proxy, ::boost::static_pointer_cast<ReleaseAccessFromSharedMemoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NowradData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::NowradDataStatus);
                                setActAndLogStatus(message, "NowradData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NowradDataStatus> payload = ::boost::static_pointer_cast<NowradDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NowradDataStatus >& refNullableStatus = proxy->_nowradData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NowradDataCallbackIF*) _callback)->onNowradDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NowradDataCallbackIF*) _callback)->onNowradDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::NowradDataError);
                                setActAndLogError(message, "NowradData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NowradDataCallbackIF*) _callback)->onNowradDataError(proxy, ::boost::static_pointer_cast<NowradDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WindMagnitudeData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::WindMagnitudeDataStatus);
                                setActAndLogStatus(message, "WindMagnitudeData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WindMagnitudeDataStatus> payload = ::boost::static_pointer_cast<WindMagnitudeDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WindMagnitudeDataStatus >& refNullableStatus = proxy->_windMagnitudeData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WindMagnitudeDataCallbackIF*) _callback)->onWindMagnitudeDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WindMagnitudeDataCallbackIF*) _callback)->onWindMagnitudeDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::WindMagnitudeDataError);
                                setActAndLogError(message, "WindMagnitudeData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WindMagnitudeDataCallbackIF*) _callback)->onWindMagnitudeDataError(proxy, ::boost::static_pointer_cast<WindMagnitudeDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WindDirectionData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::WindDirectionDataStatus);
                                setActAndLogStatus(message, "WindDirectionData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WindDirectionDataStatus> payload = ::boost::static_pointer_cast<WindDirectionDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WindDirectionDataStatus >& refNullableStatus = proxy->_windDirectionData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WindDirectionDataCallbackIF*) _callback)->onWindDirectionDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WindDirectionDataCallbackIF*) _callback)->onWindDirectionDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::WindDirectionDataError);
                                setActAndLogError(message, "WindDirectionData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WindDirectionDataCallbackIF*) _callback)->onWindDirectionDataError(proxy, ::boost::static_pointer_cast<WindDirectionDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SurfaceData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::SurfaceDataStatus);
                                setActAndLogStatus(message, "SurfaceData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SurfaceDataStatus> payload = ::boost::static_pointer_cast<SurfaceDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SurfaceDataStatus >& refNullableStatus = proxy->_surfaceData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SurfaceDataCallbackIF*) _callback)->onSurfaceDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SurfaceDataCallbackIF*) _callback)->onSurfaceDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::SurfaceDataError);
                                setActAndLogError(message, "SurfaceData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SurfaceDataCallbackIF*) _callback)->onSurfaceDataError(proxy, ::boost::static_pointer_cast<SurfaceDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StormAttributesData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::StormAttributesDataStatus);
                                setActAndLogStatus(message, "StormAttributesData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StormAttributesDataStatus> payload = ::boost::static_pointer_cast<StormAttributesDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StormAttributesDataStatus >& refNullableStatus = proxy->_stormAttributesData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StormAttributesDataCallbackIF*) _callback)->onStormAttributesDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StormAttributesDataCallbackIF*) _callback)->onStormAttributesDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::StormAttributesDataError);
                                setActAndLogError(message, "StormAttributesData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StormAttributesDataCallbackIF*) _callback)->onStormAttributesDataError(proxy, ::boost::static_pointer_cast<StormAttributesDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StormTrackData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::StormTrackDataStatus);
                                setActAndLogStatus(message, "StormTrackData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StormTrackDataStatus> payload = ::boost::static_pointer_cast<StormTrackDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StormTrackDataStatus >& refNullableStatus = proxy->_stormTrackData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StormTrackDataCallbackIF*) _callback)->onStormTrackDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StormTrackDataCallbackIF*) _callback)->onStormTrackDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::sxm_agw_main_fi::StormTrackDataError);
                                setActAndLogError(message, "StormTrackData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StormTrackDataCallbackIF*) _callback)->onStormTrackDataError(proxy, ::boost::static_pointer_cast<StormTrackDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Sxm_agw_main_fiProxy> proxy = ::boost::static_pointer_cast<Sxm_agw_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_ExchangeCapabilities: {
                ::boost::shared_ptr< ExchangeCapabilitiesError > payload (new ExchangeCapabilitiesError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExchangeCapabilities", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ExchangeCapabilitiesCallbackIF*) _callback)->onExchangeCapabilitiesError (proxy, payload);
                return true;
            }
            case FID_GetSurfaceData: {
                ::boost::shared_ptr< GetSurfaceDataError > payload (new GetSurfaceDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSurfaceData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetSurfaceDataCallbackIF*) _callback)->onGetSurfaceDataError (proxy, payload);
                return true;
            }
            case FID_GetStormAttributesData: {
                ::boost::shared_ptr< GetStormAttributesDataError > payload (new GetStormAttributesDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStormAttributesData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStormAttributesDataCallbackIF*) _callback)->onGetStormAttributesDataError (proxy, payload);
                return true;
            }
            case FID_GetStormTrackData: {
                ::boost::shared_ptr< GetStormTrackDataError > payload (new GetStormTrackDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStormTrackData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStormTrackDataCallbackIF*) _callback)->onGetStormTrackDataError (proxy, payload);
                return true;
            }
            case FID_AcquireAccessToSharedMemory: {
                ::boost::shared_ptr< AcquireAccessToSharedMemoryError > payload (new AcquireAccessToSharedMemoryError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AcquireAccessToSharedMemory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AcquireAccessToSharedMemoryCallbackIF*) _callback)->onAcquireAccessToSharedMemoryError (proxy, payload);
                return true;
            }
            case FID_ReleaseAccessFromSharedMemory: {
                ::boost::shared_ptr< ReleaseAccessFromSharedMemoryError > payload (new ReleaseAccessFromSharedMemoryError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseAccessFromSharedMemory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ReleaseAccessFromSharedMemoryCallbackIF*) _callback)->onReleaseAccessFromSharedMemoryError (proxy, payload);
                return true;
            }
            case FID_NowradData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< NowradDataError > payload (new NowradDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NowradData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NowradDataCallbackIF*) _callback)->onNowradDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WindMagnitudeData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WindMagnitudeDataError > payload (new WindMagnitudeDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WindMagnitudeData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WindMagnitudeDataCallbackIF*) _callback)->onWindMagnitudeDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WindDirectionData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WindDirectionDataError > payload (new WindDirectionDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WindDirectionData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WindDirectionDataCallbackIF*) _callback)->onWindDirectionDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SurfaceData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SurfaceDataError > payload (new SurfaceDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SurfaceData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SurfaceDataCallbackIF*) _callback)->onSurfaceDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StormAttributesData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StormAttributesDataError > payload (new StormAttributesDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StormAttributesData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StormAttributesDataCallbackIF*) _callback)->onStormAttributesDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StormTrackData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StormTrackDataError > payload (new StormTrackDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StormTrackData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StormTrackDataCallbackIF*) _callback)->onStormTrackDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Sxm_agw_main_fiProxyCallback::_logger (Sxm_agw_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Sxm_agw_main_fiProxy > Sxm_agw_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_agw_main_fiProxy >  proxyNew(new Sxm_agw_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_agw_main_fiProxy > Sxm_agw_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Sxm_agw_main_fiProxy >  proxyNew(new Sxm_agw_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Sxm_agw_main_fiProxy > Sxm_agw_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Sxm_agw_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Sxm_agw_main_fiProxy >  proxyNew(new Sxm_agw_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Sxm_agw_main_fiProxy::Sxm_agw_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Sxm_agw_main_fiProxy::~Sxm_agw_main_fiProxy()
{
    LOG_INFO ("Entering ~Sxm_agw_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Sxm_agw_main_fiProxy::sendExchangeCapabilitiesStart(ExchangeCapabilitiesCallbackIF& cb, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& sharedMemories) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ExchangeCapabilities);
        ::boost::shared_ptr< ExchangeCapabilitiesStart > payload (new ExchangeCapabilitiesStart());
        payload->setSharedMemories(sharedMemories);
        CCA_MESSAGE(ccaMessage,header,ExchangeCapabilitiesStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ExchangeCapabilities", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ExchangeCapabilities);
        ::boost::shared_ptr< ExchangeCapabilitiesError > payload (new ExchangeCapabilitiesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ExchangeCapabilitiesError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ExchangeCapabilities", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendGetSurfaceDataStart(GetSurfaceDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetSurfaceData);
        ::boost::shared_ptr< GetSurfaceDataStart > payload (new GetSurfaceDataStart());
        CCA_MESSAGE(ccaMessage,header,GetSurfaceDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetSurfaceData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetSurfaceData);
        ::boost::shared_ptr< GetSurfaceDataError > payload (new GetSurfaceDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetSurfaceDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetSurfaceData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendGetStormAttributesDataStart(GetStormAttributesDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetStormAttributesData);
        ::boost::shared_ptr< GetStormAttributesDataStart > payload (new GetStormAttributesDataStart());
        CCA_MESSAGE(ccaMessage,header,GetStormAttributesDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStormAttributesData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetStormAttributesData);
        ::boost::shared_ptr< GetStormAttributesDataError > payload (new GetStormAttributesDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStormAttributesDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStormAttributesData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendGetStormTrackDataStart(GetStormTrackDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetStormTrackData);
        ::boost::shared_ptr< GetStormTrackDataStart > payload (new GetStormTrackDataStart());
        CCA_MESSAGE(ccaMessage,header,GetStormTrackDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStormTrackData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetStormTrackData);
        ::boost::shared_ptr< GetStormTrackDataError > payload (new GetStormTrackDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStormTrackDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStormTrackData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendAcquireAccessToSharedMemoryStart(AcquireAccessToSharedMemoryCallbackIF& cb, ::sxm_agw_main_fi_types::T_e8_SXMTileType tileType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AcquireAccessToSharedMemory);
        ::boost::shared_ptr< AcquireAccessToSharedMemoryStart > payload (new AcquireAccessToSharedMemoryStart());
        payload->setTileType(tileType);
        CCA_MESSAGE(ccaMessage,header,AcquireAccessToSharedMemoryStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AcquireAccessToSharedMemory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AcquireAccessToSharedMemory);
        ::boost::shared_ptr< AcquireAccessToSharedMemoryError > payload (new AcquireAccessToSharedMemoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AcquireAccessToSharedMemoryError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AcquireAccessToSharedMemory", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendReleaseAccessFromSharedMemoryStart(ReleaseAccessFromSharedMemoryCallbackIF& cb, ::sxm_agw_main_fi_types::T_e8_SXMTileType tileType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ReleaseAccessFromSharedMemory);
        ::boost::shared_ptr< ReleaseAccessFromSharedMemoryStart > payload (new ReleaseAccessFromSharedMemoryStart());
        payload->setTileType(tileType);
        CCA_MESSAGE(ccaMessage,header,ReleaseAccessFromSharedMemoryStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ReleaseAccessFromSharedMemory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReleaseAccessFromSharedMemory);
        ::boost::shared_ptr< ReleaseAccessFromSharedMemoryError > payload (new ReleaseAccessFromSharedMemoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReleaseAccessFromSharedMemoryError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ReleaseAccessFromSharedMemory", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendNowradDataUpReg(NowradDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_NowradData);
        ::boost::shared_ptr< NowradDataUpReg > payload (new NowradDataUpReg());
        CCA_MESSAGE(ccaMessage,header,NowradDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< NowradDataRelUpReg > payloadRelUpRegHeap (new NowradDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_NowradData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::NowradDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_NowradData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "NowradData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "NowradData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasNowradData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_NowradData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< NowradDataStatus > payloadLoopback (new NowradDataStatus(getNowradData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,NowradDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NowradData);
        ::boost::shared_ptr< NowradDataError > payload (new NowradDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NowradDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "NowradData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendNowradDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_NowradData,"NowradData");
}

void Sxm_agw_main_fiProxy::sendNowradDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_NowradData);
}

const NowradDataStatus& Sxm_agw_main_fiProxy::getNowradData() const {
    return _nowradData.get();
}

bool Sxm_agw_main_fiProxy::hasNowradData() const {
    return _nowradData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendNowradDataGet(NowradDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_NowradData);
        ::boost::shared_ptr< NowradDataGet > payload (new NowradDataGet());
        CCA_MESSAGE(ccaMessage,header,NowradDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "NowradData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NowradData);
        ::boost::shared_ptr< NowradDataError > payload (new NowradDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NowradDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "NowradData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendWindMagnitudeDataUpReg(WindMagnitudeDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WindMagnitudeData);
        ::boost::shared_ptr< WindMagnitudeDataUpReg > payload (new WindMagnitudeDataUpReg());
        CCA_MESSAGE(ccaMessage,header,WindMagnitudeDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WindMagnitudeDataRelUpReg > payloadRelUpRegHeap (new WindMagnitudeDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WindMagnitudeData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::WindMagnitudeDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WindMagnitudeData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WindMagnitudeData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WindMagnitudeData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWindMagnitudeData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WindMagnitudeData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WindMagnitudeDataStatus > payloadLoopback (new WindMagnitudeDataStatus(getWindMagnitudeData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WindMagnitudeDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WindMagnitudeData);
        ::boost::shared_ptr< WindMagnitudeDataError > payload (new WindMagnitudeDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WindMagnitudeDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WindMagnitudeData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendWindMagnitudeDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WindMagnitudeData,"WindMagnitudeData");
}

void Sxm_agw_main_fiProxy::sendWindMagnitudeDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WindMagnitudeData);
}

const WindMagnitudeDataStatus& Sxm_agw_main_fiProxy::getWindMagnitudeData() const {
    return _windMagnitudeData.get();
}

bool Sxm_agw_main_fiProxy::hasWindMagnitudeData() const {
    return _windMagnitudeData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendWindMagnitudeDataGet(WindMagnitudeDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WindMagnitudeData);
        ::boost::shared_ptr< WindMagnitudeDataGet > payload (new WindMagnitudeDataGet());
        CCA_MESSAGE(ccaMessage,header,WindMagnitudeDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WindMagnitudeData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WindMagnitudeData);
        ::boost::shared_ptr< WindMagnitudeDataError > payload (new WindMagnitudeDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WindMagnitudeDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WindMagnitudeData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendWindDirectionDataUpReg(WindDirectionDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WindDirectionData);
        ::boost::shared_ptr< WindDirectionDataUpReg > payload (new WindDirectionDataUpReg());
        CCA_MESSAGE(ccaMessage,header,WindDirectionDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WindDirectionDataRelUpReg > payloadRelUpRegHeap (new WindDirectionDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WindDirectionData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::WindDirectionDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WindDirectionData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WindDirectionData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WindDirectionData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWindDirectionData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WindDirectionData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WindDirectionDataStatus > payloadLoopback (new WindDirectionDataStatus(getWindDirectionData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WindDirectionDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WindDirectionData);
        ::boost::shared_ptr< WindDirectionDataError > payload (new WindDirectionDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WindDirectionDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WindDirectionData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendWindDirectionDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WindDirectionData,"WindDirectionData");
}

void Sxm_agw_main_fiProxy::sendWindDirectionDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WindDirectionData);
}

const WindDirectionDataStatus& Sxm_agw_main_fiProxy::getWindDirectionData() const {
    return _windDirectionData.get();
}

bool Sxm_agw_main_fiProxy::hasWindDirectionData() const {
    return _windDirectionData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendWindDirectionDataGet(WindDirectionDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WindDirectionData);
        ::boost::shared_ptr< WindDirectionDataGet > payload (new WindDirectionDataGet());
        CCA_MESSAGE(ccaMessage,header,WindDirectionDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WindDirectionData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WindDirectionData);
        ::boost::shared_ptr< WindDirectionDataError > payload (new WindDirectionDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WindDirectionDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WindDirectionData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendSurfaceDataUpReg(SurfaceDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SurfaceData);
        ::boost::shared_ptr< SurfaceDataUpReg > payload (new SurfaceDataUpReg());
        CCA_MESSAGE(ccaMessage,header,SurfaceDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SurfaceDataRelUpReg > payloadRelUpRegHeap (new SurfaceDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SurfaceData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::SurfaceDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SurfaceData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SurfaceData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SurfaceData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSurfaceData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SurfaceData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SurfaceDataStatus > payloadLoopback (new SurfaceDataStatus(getSurfaceData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SurfaceDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurfaceData);
        ::boost::shared_ptr< SurfaceDataError > payload (new SurfaceDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurfaceDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SurfaceData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendSurfaceDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SurfaceData,"SurfaceData");
}

void Sxm_agw_main_fiProxy::sendSurfaceDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SurfaceData);
}

const SurfaceDataStatus& Sxm_agw_main_fiProxy::getSurfaceData() const {
    return _surfaceData.get();
}

bool Sxm_agw_main_fiProxy::hasSurfaceData() const {
    return _surfaceData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendSurfaceDataGet(SurfaceDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SurfaceData);
        ::boost::shared_ptr< SurfaceDataGet > payload (new SurfaceDataGet());
        CCA_MESSAGE(ccaMessage,header,SurfaceDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SurfaceData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurfaceData);
        ::boost::shared_ptr< SurfaceDataError > payload (new SurfaceDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurfaceDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SurfaceData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendStormAttributesDataUpReg(StormAttributesDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StormAttributesData);
        ::boost::shared_ptr< StormAttributesDataUpReg > payload (new StormAttributesDataUpReg());
        CCA_MESSAGE(ccaMessage,header,StormAttributesDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StormAttributesDataRelUpReg > payloadRelUpRegHeap (new StormAttributesDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StormAttributesData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::StormAttributesDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StormAttributesData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StormAttributesData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StormAttributesData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStormAttributesData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StormAttributesData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StormAttributesDataStatus > payloadLoopback (new StormAttributesDataStatus(getStormAttributesData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StormAttributesDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StormAttributesData);
        ::boost::shared_ptr< StormAttributesDataError > payload (new StormAttributesDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StormAttributesDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StormAttributesData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendStormAttributesDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StormAttributesData,"StormAttributesData");
}

void Sxm_agw_main_fiProxy::sendStormAttributesDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StormAttributesData);
}

const StormAttributesDataStatus& Sxm_agw_main_fiProxy::getStormAttributesData() const {
    return _stormAttributesData.get();
}

bool Sxm_agw_main_fiProxy::hasStormAttributesData() const {
    return _stormAttributesData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendStormAttributesDataGet(StormAttributesDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StormAttributesData);
        ::boost::shared_ptr< StormAttributesDataGet > payload (new StormAttributesDataGet());
        CCA_MESSAGE(ccaMessage,header,StormAttributesDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StormAttributesData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StormAttributesData);
        ::boost::shared_ptr< StormAttributesDataError > payload (new StormAttributesDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StormAttributesDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StormAttributesData", &cb);
    }
}

act_t Sxm_agw_main_fiProxy::sendStormTrackDataUpReg(StormTrackDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StormTrackData);
        ::boost::shared_ptr< StormTrackDataUpReg > payload (new StormTrackDataUpReg());
        CCA_MESSAGE(ccaMessage,header,StormTrackDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StormTrackDataRelUpReg > payloadRelUpRegHeap (new StormTrackDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StormTrackData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::sxm_agw_main_fi::StormTrackDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StormTrackData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StormTrackData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StormTrackData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStormTrackData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StormTrackData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StormTrackDataStatus > payloadLoopback (new StormTrackDataStatus(getStormTrackData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StormTrackDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StormTrackData);
        ::boost::shared_ptr< StormTrackDataError > payload (new StormTrackDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StormTrackDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StormTrackData", &cb);
    }
}

bool Sxm_agw_main_fiProxy::sendStormTrackDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StormTrackData,"StormTrackData");
}

void Sxm_agw_main_fiProxy::sendStormTrackDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StormTrackData);
}

const StormTrackDataStatus& Sxm_agw_main_fiProxy::getStormTrackData() const {
    return _stormTrackData.get();
}

bool Sxm_agw_main_fiProxy::hasStormTrackData() const {
    return _stormTrackData.hasValue();
}

act_t Sxm_agw_main_fiProxy::sendStormTrackDataGet(StormTrackDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StormTrackData);
        ::boost::shared_ptr< StormTrackDataGet > payload (new StormTrackDataGet());
        CCA_MESSAGE(ccaMessage,header,StormTrackDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StormTrackData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StormTrackData);
        ::boost::shared_ptr< StormTrackDataError > payload (new StormTrackDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StormTrackDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StormTrackData", &cb);
    }
}


void Sxm_agw_main_fiProxy::clearAllProperties ()
{
    _nowradData = ::asf::core::nullable<NowradDataStatus>();
    _windMagnitudeData = ::asf::core::nullable<WindMagnitudeDataStatus>();
    _windDirectionData = ::asf::core::nullable<WindDirectionDataStatus>();
    _surfaceData = ::asf::core::nullable<SurfaceDataStatus>();
    _stormAttributesData = ::asf::core::nullable<StormAttributesDataStatus>();
    _stormTrackData = ::asf::core::nullable<StormTrackDataStatus>();
}

void Sxm_agw_main_fiProxy::sendRelUpRegAll()
{
    sendNowradDataRelUpRegAll();
    sendWindMagnitudeDataRelUpRegAll();
    sendWindDirectionDataRelUpRegAll();
    sendSurfaceDataRelUpRegAll();
    sendStormAttributesDataRelUpRegAll();
    sendStormTrackDataRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Sxm_agw_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Sxm_agw_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace sxm_agw_main_fi
