#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SXM_AGW_MAIN_FI_H
#define SXM_AGW_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "sxm_agw_main_fi_types.h"
#include "sxm_agw_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'sxm_agw_main_fi'
 *
 * Fullname: VD_RadioData SXM Weather Application Functional Interface
 *
 * Version: $Revision:   2.01  $
 *
 * Author: tbd
 *
 * Date: $Date:  Jan 16 2013   $
 *
 * Department: RBEI/ECV
 *
 * Title: sxm_agw_main_fi
 *
 * <b>Description of 'sxm_agw_main_fi':</b>
 *
 * ..
 */

namespace sxm_agw_main_fi {

static const int SERVICE_ID = 152;

static const int FID_NowradData = 8193;

static const int FID_WindMagnitudeData = 8194;

static const int FID_WindDirectionData = 8195;

static const int FID_SurfaceData = 8196;

static const int FID_StormAttributesData = 8197;

static const int FID_StormTrackData = 8198;

static const int FID_ExchangeCapabilities = 4097;

static const int FID_GetSurfaceData = 4098;

static const int FID_GetStormAttributesData = 4099;

static const int FID_GetStormTrackData = 4100;

static const int FID_AcquireAccessToSharedMemory = 4101;

static const int FID_ReleaseAccessFromSharedMemory = 4102;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class NowradDataStatus;

class WindMagnitudeDataStatus;

class WindDirectionDataStatus;

class SurfaceDataStatus;

class StormAttributesDataStatus;

class StormTrackDataStatus;

class ExchangeCapabilitiesStart;

class ExchangeCapabilitiesResult;

class GetSurfaceDataResult;

class GetStormAttributesDataResult;

class GetStormTrackDataResult;

class AcquireAccessToSharedMemoryStart;

class AcquireAccessToSharedMemoryResult;

class ReleaseAccessFromSharedMemoryStart;

// type definitions
/**
 * The get message of the property "NowradData"
 * This property gives information if NOWRAD data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowradDataGet;

/**
 * The upreg message of the property "NowradData"
 * This property gives information if NOWRAD data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowradDataUpReg;

/**
 * The relUpReg message of the property "NowradData"
 * This property gives information if NOWRAD data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NowradDataRelUpReg;

/**
 * The error message of 'NowradData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError NowradDataError;

/**
 * The get message of the property "WindMagnitudeData"
 * This property gives information if wind-magnitude data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindMagnitudeDataGet;

/**
 * The upreg message of the property "WindMagnitudeData"
 * This property gives information if wind-magnitude data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindMagnitudeDataUpReg;

/**
 * The relUpReg message of the property "WindMagnitudeData"
 * This property gives information if wind-magnitude data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindMagnitudeDataRelUpReg;

/**
 * The error message of 'WindMagnitudeData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError WindMagnitudeDataError;

/**
 * The get message of the property "WindDirectionData"
 * This property gives information if wind-direction data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindDirectionDataGet;

/**
 * The upreg message of the property "WindDirectionData"
 * This property gives information if wind-direction data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindDirectionDataUpReg;

/**
 * The relUpReg message of the property "WindDirectionData"
 * This property gives information if wind-direction data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WindDirectionDataRelUpReg;

/**
 * The error message of 'WindDirectionData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError WindDirectionDataError;

/**
 * The get message of the property "SurfaceData"
 * This property gives information if surface data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurfaceDataGet;

/**
 * The upreg message of the property "SurfaceData"
 * This property gives information if surface data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurfaceDataUpReg;

/**
 * The relUpReg message of the property "SurfaceData"
 * This property gives information if surface data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurfaceDataRelUpReg;

/**
 * The error message of 'SurfaceData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError SurfaceDataError;

/**
 * The get message of the property "StormAttributesData"
 * This property gives information if storm-attributes data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormAttributesDataGet;

/**
 * The upreg message of the property "StormAttributesData"
 * This property gives information if storm-attributes data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormAttributesDataUpReg;

/**
 * The relUpReg message of the property "StormAttributesData"
 * This property gives information if storm-attributes data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormAttributesDataRelUpReg;

/**
 * The error message of 'StormAttributesData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError StormAttributesDataError;

/**
 * The get message of the property "StormTrackData"
 * This property gives information if storm-track data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormTrackDataGet;

/**
 * The upreg message of the property "StormTrackData"
 * This property gives information if storm-track data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormTrackDataUpReg;

/**
 * The relUpReg message of the property "StormTrackData"
 * This property gives information if storm-track data has changed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StormTrackDataRelUpReg;

/**
 * The error message of 'StormTrackData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError StormTrackDataError;

/**
 * The abort error message of the method "ExchangeCapabilities"
 * Method to exchange capabilities between server and client.
 */
typedef ::asf::cca::CcaTypes::DefaultError ExchangeCapabilitiesAbortError;

/**
 * The error message of 'ExchangeCapabilities'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ExchangeCapabilitiesError;

/**
 * The start message of the method "GetSurfaceData"
 * Method to get all surface data.
 * No parameters included, always the complete data is requested.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSurfaceDataStart;

/**
 * The abort error message of the method "GetSurfaceData"
 * Method to get all surface data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSurfaceDataAbortError;

/**
 * The error message of 'GetSurfaceData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSurfaceDataError;

/**
 * The start message of the method "GetStormAttributesData"
 * Method to get all storm-attributes data.
 * No parameters included, always the complete data is requested.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetStormAttributesDataStart;

/**
 * The abort error message of the method "GetStormAttributesData"
 * Method to get all storm-attributes data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStormAttributesDataAbortError;

/**
 * The error message of 'GetStormAttributesData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStormAttributesDataError;

/**
 * The start message of the method "GetStormTrackData"
 * Method to get all storm-track data.
 * No parameters included, always the complete data is requested.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetStormTrackDataStart;

/**
 * The abort error message of the method "GetStormTrackData"
 * Method to get all storm-track data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStormTrackDataAbortError;

/**
 * The error message of 'GetStormTrackData'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStormTrackDataError;

/**
 * The abort error message of the method "AcquireAccessToSharedMemory"
 * This method is used by client to acquire access to shared memory for one protocol.
 */
typedef ::asf::cca::CcaTypes::DefaultError AcquireAccessToSharedMemoryAbortError;

/**
 * The error message of 'AcquireAccessToSharedMemory'
 * Error type of tU16 defined in error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError AcquireAccessToSharedMemoryError;

/**
 * The result message of the method "ReleaseAccessFromSharedMemory"
 * This method is used to release the locked Shared Memory. This method implies
 * that the client has copied the necessary contents.
 * No parameters required.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReleaseAccessFromSharedMemoryResult;

/**
 * The abort error message of the method "ReleaseAccessFromSharedMemory"
 * This method is used to release the locked Shared Memory. This method implies
 * that the client has copied the necessary contents.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseAccessFromSharedMemoryAbortError;

/**
 * The error message of 'ReleaseAccessFromSharedMemory'
 * Error type of tU16 defined in general error definitions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseAccessFromSharedMemoryError;


/**
 * The status message of the property "NowradData"
 * This property gives information if NOWRAD data has changed.
 */
class NowradDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NowradDataStatus ();

    /**
     * Copy constructor
     */
    inline  NowradDataStatus (const NowradDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NowradDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~NowradDataStatus();

    /**
     * Assignment operator
     */
    inline NowradDataStatus& operator = (const NowradDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NowradDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NowradDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NowradDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NowradDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in NOWRAD data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in NOWRAD data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const NowradDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The status message of the property "WindMagnitudeData"
 * This property gives information if wind-magnitude data has changed.
 */
class WindMagnitudeDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WindMagnitudeDataStatus ();

    /**
     * Copy constructor
     */
    inline  WindMagnitudeDataStatus (const WindMagnitudeDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WindMagnitudeDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~WindMagnitudeDataStatus();

    /**
     * Assignment operator
     */
    inline WindMagnitudeDataStatus& operator = (const WindMagnitudeDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WindMagnitudeDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WindMagnitudeDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WindMagnitudeDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WindMagnitudeDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in wind-magnitude data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in wind-magnitude data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const WindMagnitudeDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The status message of the property "WindDirectionData"
 * This property gives information if wind-direction data has changed.
 */
class WindDirectionDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WindDirectionDataStatus ();

    /**
     * Copy constructor
     */
    inline  WindDirectionDataStatus (const WindDirectionDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WindDirectionDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~WindDirectionDataStatus();

    /**
     * Assignment operator
     */
    inline WindDirectionDataStatus& operator = (const WindDirectionDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WindDirectionDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WindDirectionDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WindDirectionDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WindDirectionDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in wind-direction data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in wind-direction data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const WindDirectionDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The status message of the property "SurfaceData"
 * This property gives information if surface data has changed.
 */
class SurfaceDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurfaceDataStatus ();

    /**
     * Copy constructor
     */
    inline  SurfaceDataStatus (const SurfaceDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SurfaceDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~SurfaceDataStatus();

    /**
     * Assignment operator
     */
    inline SurfaceDataStatus& operator = (const SurfaceDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurfaceDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurfaceDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurfaceDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurfaceDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in surface data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in surface data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const SurfaceDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The status message of the property "StormAttributesData"
 * This property gives information if storm-attributes data has changed.
 */
class StormAttributesDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StormAttributesDataStatus ();

    /**
     * Copy constructor
     */
    inline  StormAttributesDataStatus (const StormAttributesDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StormAttributesDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~StormAttributesDataStatus();

    /**
     * Assignment operator
     */
    inline StormAttributesDataStatus& operator = (const StormAttributesDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StormAttributesDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StormAttributesDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StormAttributesDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StormAttributesDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in storm-attributes data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in storm-attributes data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const StormAttributesDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The status message of the property "StormTrackData"
 * This property gives information if storm-track data has changed.
 */
class StormTrackDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StormTrackDataStatus ();

    /**
     * Copy constructor
     */
    inline  StormTrackDataStatus (const StormTrackDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StormTrackDataStatus (uint32 UpdateCounter_);

    /**
     * Destructor
     */
    inline virtual  ~StormTrackDataStatus();

    /**
     * Assignment operator
     */
    inline StormTrackDataStatus& operator = (const StormTrackDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StormTrackDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StormTrackDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StormTrackDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StormTrackDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Counter increased with each change in storm-track data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Counter increased with each change in storm-track data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    static const StormTrackDataStatus &getDefaultInstance();

private:

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _UpdateCounter;

};

/**
 * The start message of the method "ExchangeCapabilities"
 * Method to exchange capabilities between server and client.
 * Wanted capabilities from client.
 */
class ExchangeCapabilitiesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExchangeCapabilitiesStart ();

    /**
     * Copy constructor
     */
    inline  ExchangeCapabilitiesStart (const ExchangeCapabilitiesStart &rhs);

    /**
     * All fields constructor
     */
    inline  ExchangeCapabilitiesStart (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_);

    /**
     * Destructor
     */
    inline virtual  ~ExchangeCapabilitiesStart();

    /**
     * Assignment operator
     */
    inline ExchangeCapabilitiesStart& operator = (const ExchangeCapabilitiesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExchangeCapabilitiesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExchangeCapabilitiesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExchangeCapabilitiesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExchangeCapabilitiesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SharedMemories"

    static const int kSharedMemories = 0;

    /**
     * Clears the field "SharedMemories".
     *
     * The field will be set to its default value. The hasSharedMemories()
     * method will return false.
     */
    inline void clearSharedMemories();

    /**
     * Checks whether the field "SharedMemories" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedMemories()). Otherwise it will return false.
     */
    inline bool hasSharedMemories () const;

    /**
     * Returns the value of the member "SharedMemories".
     *
     * Shared memory data for different graphical tile protocols, requested from client.
     * The client only adds protocols in this list for which he wants to exchange data.
     * Name and size will be left empty from client, they have to be filled from server.
     *
     * @return The value of the field "SharedMemories"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getSharedMemories () const;

    /**
     * Retrieves the value of the field "SharedMemories" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SharedMemories".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getSharedMemoriesMutable ();

    /**
     * Sets the value of the member "SharedMemories".
     *
     * Shared memory data for different graphical tile protocols, requested from client.
     * The client only adds protocols in this list for which he wants to exchange data.
     * Name and size will be left empty from client, they have to be filled from server.
     *
     * @param SharedMemories The value which will be set
     */
    inline void setSharedMemories (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_);

    static const ExchangeCapabilitiesStart &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getT_SXMSharedMemoryDescriptionList_DefaultInstance ();

    inline void set_has_SharedMemories ();

    inline void clear_has_SharedMemories ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription > _SharedMemories;

};

/**
 * The result message of the method "ExchangeCapabilities"
 * Method to exchange capabilities between server and client.
 * Provided capabilities from server.
 */
class ExchangeCapabilitiesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExchangeCapabilitiesResult ();

    /**
     * Copy constructor
     */
    inline  ExchangeCapabilitiesResult (const ExchangeCapabilitiesResult &rhs);

    /**
     * All fields constructor
     */
    inline  ExchangeCapabilitiesResult (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_);

    /**
     * Destructor
     */
    inline virtual  ~ExchangeCapabilitiesResult();

    /**
     * Assignment operator
     */
    inline ExchangeCapabilitiesResult& operator = (const ExchangeCapabilitiesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExchangeCapabilitiesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExchangeCapabilitiesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExchangeCapabilitiesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExchangeCapabilitiesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SharedMemories"

    static const int kSharedMemories = 0;

    /**
     * Clears the field "SharedMemories".
     *
     * The field will be set to its default value. The hasSharedMemories()
     * method will return false.
     */
    inline void clearSharedMemories();

    /**
     * Checks whether the field "SharedMemories" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSharedMemories()). Otherwise it will return false.
     */
    inline bool hasSharedMemories () const;

    /**
     * Returns the value of the member "SharedMemories".
     *
     * Shared memory data for different graphical tile protocols.
     *
     * @return The value of the field "SharedMemories"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getSharedMemories () const;

    /**
     * Retrieves the value of the field "SharedMemories" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SharedMemories".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getSharedMemoriesMutable ();

    /**
     * Sets the value of the member "SharedMemories".
     *
     * Shared memory data for different graphical tile protocols.
     *
     * @param SharedMemories The value which will be set
     */
    inline void setSharedMemories (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_);

    static const ExchangeCapabilitiesResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& getT_SXMSharedMemoryDescriptionList_DefaultInstance ();

    inline void set_has_SharedMemories ();

    inline void clear_has_SharedMemories ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription > _SharedMemories;

};

/**
 * The result message of the method "GetSurfaceData"
 * Method to get all surface data.
 */
class GetSurfaceDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSurfaceDataResult ();

    /**
     * Copy constructor
     */
    inline  GetSurfaceDataResult (const GetSurfaceDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetSurfaceDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    /**
     * Destructor
     */
    inline virtual  ~GetSurfaceDataResult();

    /**
     * Assignment operator
     */
    inline GetSurfaceDataResult& operator = (const GetSurfaceDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSurfaceDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSurfaceDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSurfaceDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSurfaceDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for surface data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for surface data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    // API of field "Shapes"

    static const int kShapes = 1;

    /**
     * Clears the field "Shapes".
     *
     * The field will be set to its default value. The hasShapes()
     * method will return false.
     */
    inline void clearShapes();

    /**
     * Checks whether the field "Shapes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShapes()). Otherwise it will return false.
     */
    inline bool hasShapes () const;

    /**
     * Returns the value of the member "Shapes".
     *
     * <p>All shapes for surface in one list.</p>
     * <p>Possible shape-types are T_SXMShapeTypeFront, T_SXMShapeTypePressureCenter and T_SXMShapeTypeIsobar.</p>
     *
     * @return The value of the field "Shapes"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapes () const;

    /**
     * Retrieves the value of the field "Shapes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Shapes".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapesMutable ();

    /**
     * Sets the value of the member "Shapes".
     *
     * <p>All shapes for surface in one list.</p>
     * <p>Possible shape-types are T_SXMShapeTypeFront, T_SXMShapeTypePressureCenter and T_SXMShapeTypeIsobar.</p>
     *
     * @param Shapes The value which will be set
     */
    inline void setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    static const GetSurfaceDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getT_SXMShapeList_DefaultInstance ();

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    inline void set_has_Shapes ();

    inline void clear_has_Shapes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _UpdateCounter;

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape > _Shapes;

};

/**
 * The result message of the method "GetStormAttributesData"
 * Method to get all storm-attributes data.
 */
class GetStormAttributesDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStormAttributesDataResult ();

    /**
     * Copy constructor
     */
    inline  GetStormAttributesDataResult (const GetStormAttributesDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStormAttributesDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    /**
     * Destructor
     */
    inline virtual  ~GetStormAttributesDataResult();

    /**
     * Assignment operator
     */
    inline GetStormAttributesDataResult& operator = (const GetStormAttributesDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStormAttributesDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStormAttributesDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStormAttributesDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStormAttributesDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for storm-attributes data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for storm-attributes data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    // API of field "Shapes"

    static const int kShapes = 1;

    /**
     * Clears the field "Shapes".
     *
     * The field will be set to its default value. The hasShapes()
     * method will return false.
     */
    inline void clearShapes();

    /**
     * Checks whether the field "Shapes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShapes()). Otherwise it will return false.
     */
    inline bool hasShapes () const;

    /**
     * Returns the value of the member "Shapes".
     *
     * <p>All shapes for storm-attributes in one list.</p>
     * <p>Possible shape-type is only T_SXMShapeTypeStormAttributes.</p>
     *
     * @return The value of the field "Shapes"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapes () const;

    /**
     * Retrieves the value of the field "Shapes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Shapes".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapesMutable ();

    /**
     * Sets the value of the member "Shapes".
     *
     * <p>All shapes for storm-attributes in one list.</p>
     * <p>Possible shape-type is only T_SXMShapeTypeStormAttributes.</p>
     *
     * @param Shapes The value which will be set
     */
    inline void setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    static const GetStormAttributesDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getT_SXMShapeList_DefaultInstance ();

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    inline void set_has_Shapes ();

    inline void clear_has_Shapes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _UpdateCounter;

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape > _Shapes;

};

/**
 * The result message of the method "GetStormTrackData"
 * Method to get all storm-track data.
 */
class GetStormTrackDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStormTrackDataResult ();

    /**
     * Copy constructor
     */
    inline  GetStormTrackDataResult (const GetStormTrackDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStormTrackDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    /**
     * Destructor
     */
    inline virtual  ~GetStormTrackDataResult();

    /**
     * Assignment operator
     */
    inline GetStormTrackDataResult& operator = (const GetStormTrackDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStormTrackDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStormTrackDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStormTrackDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStormTrackDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 0;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for storm-track data.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for storm-track data.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    // API of field "Shapes"

    static const int kShapes = 1;

    /**
     * Clears the field "Shapes".
     *
     * The field will be set to its default value. The hasShapes()
     * method will return false.
     */
    inline void clearShapes();

    /**
     * Checks whether the field "Shapes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShapes()). Otherwise it will return false.
     */
    inline bool hasShapes () const;

    /**
     * Returns the value of the member "Shapes".
     *
     * <p>All shapes for storm-track in one list.</p>
     * <p>Possible shape-types are T_SXMShapeTypeStormPosition and T_SXMShapeTypeWindRadius.
     * Since version 2.0 it is possible to transmit the type T_SXMShapeStormTrack directly.</p>
     *
     * @return The value of the field "Shapes"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapes () const;

    /**
     * Retrieves the value of the field "Shapes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Shapes".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getShapesMutable ();

    /**
     * Sets the value of the member "Shapes".
     *
     * <p>All shapes for storm-track in one list.</p>
     * <p>Possible shape-types are T_SXMShapeTypeStormPosition and T_SXMShapeTypeWindRadius.
     * Since version 2.0 it is possible to transmit the type T_SXMShapeStormTrack directly.</p>
     *
     * @param Shapes The value which will be set
     */
    inline void setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_);

    static const GetStormTrackDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& getT_SXMShapeList_DefaultInstance ();

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    inline void set_has_Shapes ();

    inline void clear_has_Shapes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _UpdateCounter;

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape > _Shapes;

};

/**
 * The start message of the method "AcquireAccessToSharedMemory"
 * This method is used by client to acquire access to shared memory for one protocol.
 */
class AcquireAccessToSharedMemoryStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcquireAccessToSharedMemoryStart ();

    /**
     * Copy constructor
     */
    inline  AcquireAccessToSharedMemoryStart (const AcquireAccessToSharedMemoryStart &rhs);

    /**
     * All fields constructor
     */
    inline  AcquireAccessToSharedMemoryStart (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_);

    /**
     * Destructor
     */
    inline virtual  ~AcquireAccessToSharedMemoryStart();

    /**
     * Assignment operator
     */
    inline AcquireAccessToSharedMemoryStart& operator = (const AcquireAccessToSharedMemoryStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireAccessToSharedMemoryStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireAccessToSharedMemoryStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireAccessToSharedMemoryStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireAccessToSharedMemoryStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TileType"

    static const int kTileType = 0;

    /**
     * Clears the field "TileType".
     *
     * The field will be set to its default value. The hasTileType()
     * method will return false.
     */
    inline void clearTileType();

    /**
     * Checks whether the field "TileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileType()). Otherwise it will return false.
     */
    inline bool hasTileType () const;

    /**
     * Returns the value of the member "TileType".
     *
     * Protocol to acquire access to.
     *
     * @return The value of the field "TileType"
     */
    inline ::sxm_agw_main_fi_types::T_e8_SXMTileType getTileType () const;

    /**
     * Sets the value of the member "TileType".
     *
     * Protocol to acquire access to.
     *
     * @param TileType The value which will be set
     */
    inline void setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_);

    static const AcquireAccessToSharedMemoryStart &getDefaultInstance();

private:

    inline void set_has_TileType ();

    inline void clear_has_TileType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_agw_main_fi_types::T_e8_SXMTileType _TileType;

};

/**
 * The result message of the method "AcquireAccessToSharedMemory"
 * This method is used by client to acquire access to shared memory for one protocol.
 */
class AcquireAccessToSharedMemoryResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcquireAccessToSharedMemoryResult ();

    /**
     * Copy constructor
     */
    inline  AcquireAccessToSharedMemoryResult (const AcquireAccessToSharedMemoryResult &rhs);

    /**
     * All fields constructor
     */
    inline  AcquireAccessToSharedMemoryResult (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_, bool AccessGranted_, uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& TileList_);

    /**
     * Destructor
     */
    inline virtual  ~AcquireAccessToSharedMemoryResult();

    /**
     * Assignment operator
     */
    inline AcquireAccessToSharedMemoryResult& operator = (const AcquireAccessToSharedMemoryResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcquireAccessToSharedMemoryResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcquireAccessToSharedMemoryResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcquireAccessToSharedMemoryResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcquireAccessToSharedMemoryResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TileType"

    static const int kTileType = 0;

    /**
     * Clears the field "TileType".
     *
     * The field will be set to its default value. The hasTileType()
     * method will return false.
     */
    inline void clearTileType();

    /**
     * Checks whether the field "TileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileType()). Otherwise it will return false.
     */
    inline bool hasTileType () const;

    /**
     * Returns the value of the member "TileType".
     *
     * Protocol access was requested to.
     *
     * @return The value of the field "TileType"
     */
    inline ::sxm_agw_main_fi_types::T_e8_SXMTileType getTileType () const;

    /**
     * Sets the value of the member "TileType".
     *
     * Protocol access was requested to.
     *
     * @param TileType The value which will be set
     */
    inline void setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_);

    // API of field "AccessGranted"

    static const int kAccessGranted = 1;

    /**
     * Clears the field "AccessGranted".
     *
     * The field will be set to its default value. The hasAccessGranted()
     * method will return false.
     */
    inline void clearAccessGranted();

    /**
     * Checks whether the field "AccessGranted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccessGranted()). Otherwise it will return false.
     */
    inline bool hasAccessGranted () const;

    /**
     * Returns the value of the member "AccessGranted".
     *
     * <p>TRUE: Access to requested SharedMemory is granted.</p>
     * <p>FALSE: Access to requested SharedMemory is denied.</p>
     *
     * @return The value of the field "AccessGranted"
     */
    inline bool getAccessGranted () const;

    /**
     * Sets the value of the member "AccessGranted".
     *
     * <p>TRUE: Access to requested SharedMemory is granted.</p>
     * <p>FALSE: Access to requested SharedMemory is denied.</p>
     *
     * @param AccessGranted The value which will be set
     */
    inline void setAccessGranted (bool AccessGranted_);

    // API of field "UpdateCounter"

    static const int kUpdateCounter = 2;

    /**
     * Clears the field "UpdateCounter".
     *
     * The field will be set to its default value. The hasUpdateCounter()
     * method will return false.
     */
    inline void clearUpdateCounter();

    /**
     * Checks whether the field "UpdateCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateCounter()). Otherwise it will return false.
     */
    inline bool hasUpdateCounter () const;

    /**
     * Returns the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for protocol defined by TileType.
     * If AccessGranted is FALSE, this paramter does not matter.
     *
     * @return The value of the field "UpdateCounter"
     */
    inline uint32 getUpdateCounter () const;

    /**
     * Sets the value of the member "UpdateCounter".
     *
     * Latest UpdateCounter for protocol defined by TileType.
     * If AccessGranted is FALSE, this paramter does not matter.
     *
     * @param UpdateCounter The value which will be set
     */
    inline void setUpdateCounter (uint32 UpdateCounter_);

    // API of field "TileList"

    static const int kTileList = 3;

    /**
     * Clears the field "TileList".
     *
     * The field will be set to its default value. The hasTileList()
     * method will return false.
     */
    inline void clearTileList();

    /**
     * Checks whether the field "TileList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileList()). Otherwise it will return false.
     */
    inline bool hasTileList () const;

    /**
     * Returns the value of the member "TileList".
     *
     * List containing the tiles in shared memory, with address offset and the size of tile in bytes.
     * If AccessGranted is FALSE, this list is empty.
     *
     * @return The value of the field "TileList"
     */
    inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& getTileList () const;

    /**
     * Retrieves the value of the field "TileList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TileList".
     */
    inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& getTileListMutable ();

    /**
     * Sets the value of the member "TileList".
     *
     * List containing the tiles in shared memory, with address offset and the size of tile in bytes.
     * If AccessGranted is FALSE, this list is empty.
     *
     * @param TileList The value which will be set
     */
    inline void setTileList (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& TileList_);

    static const AcquireAccessToSharedMemoryResult &getDefaultInstance();

private:

    static const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& getT_SXMSharedMemoryTileList_DefaultInstance ();

    inline void set_has_TileType ();

    inline void clear_has_TileType ();

    inline void set_has_AccessGranted ();

    inline void clear_has_AccessGranted ();

    inline void set_has_UpdateCounter ();

    inline void clear_has_UpdateCounter ();

    inline void set_has_TileList ();

    inline void clear_has_TileList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::sxm_agw_main_fi_types::T_e8_SXMTileType _TileType;

    bool _AccessGranted;

    uint32 _UpdateCounter;

    ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile > _TileList;

};

/**
 * The start message of the method "ReleaseAccessFromSharedMemory"
 * This method is used to release the locked Shared Memory. This method implies
 * that the client has copied the necessary contents.
 */
class ReleaseAccessFromSharedMemoryStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseAccessFromSharedMemoryStart ();

    /**
     * Copy constructor
     */
    inline  ReleaseAccessFromSharedMemoryStart (const ReleaseAccessFromSharedMemoryStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseAccessFromSharedMemoryStart (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseAccessFromSharedMemoryStart();

    /**
     * Assignment operator
     */
    inline ReleaseAccessFromSharedMemoryStart& operator = (const ReleaseAccessFromSharedMemoryStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseAccessFromSharedMemoryStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseAccessFromSharedMemoryStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseAccessFromSharedMemoryStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseAccessFromSharedMemoryStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TileType"

    static const int kTileType = 0;

    /**
     * Clears the field "TileType".
     *
     * The field will be set to its default value. The hasTileType()
     * method will return false.
     */
    inline void clearTileType();

    /**
     * Checks whether the field "TileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTileType()). Otherwise it will return false.
     */
    inline bool hasTileType () const;

    /**
     * Returns the value of the member "TileType".
     *
     * Protocol to release access from.
     *
     * @return The value of the field "TileType"
     */
    inline ::sxm_agw_main_fi_types::T_e8_SXMTileType getTileType () const;

    /**
     * Sets the value of the member "TileType".
     *
     * Protocol to release access from.
     *
     * @param TileType The value which will be set
     */
    inline void setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_);

    static const ReleaseAccessFromSharedMemoryStart &getDefaultInstance();

private:

    inline void set_has_TileType ();

    inline void clear_has_TileType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::sxm_agw_main_fi_types::T_e8_SXMTileType _TileType;

};

inline  NowradDataStatus::NowradDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NowradDataStatus::NowradDataStatus (const NowradDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NowradDataStatus::NowradDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NowradDataStatus::~NowradDataStatus() {
}

inline NowradDataStatus& NowradDataStatus::operator = (const NowradDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool NowradDataStatus::operator == (const NowradDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool NowradDataStatus::operator != (const NowradDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NowradDataStatus::operator < (const NowradDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NowradDataStatus::clone() {
    return new NowradDataStatus(*this);
}

inline bool NowradDataStatus::operator > (const NowradDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NowradDataStatus::clear() {
    clearUpdateCounter();
}

inline void NowradDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool NowradDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 NowradDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void NowradDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void NowradDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void NowradDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WindMagnitudeDataStatus::WindMagnitudeDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WindMagnitudeDataStatus::WindMagnitudeDataStatus (const WindMagnitudeDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WindMagnitudeDataStatus::WindMagnitudeDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WindMagnitudeDataStatus::~WindMagnitudeDataStatus() {
}

inline WindMagnitudeDataStatus& WindMagnitudeDataStatus::operator = (const WindMagnitudeDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool WindMagnitudeDataStatus::operator == (const WindMagnitudeDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool WindMagnitudeDataStatus::operator != (const WindMagnitudeDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool WindMagnitudeDataStatus::operator < (const WindMagnitudeDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WindMagnitudeDataStatus::clone() {
    return new WindMagnitudeDataStatus(*this);
}

inline bool WindMagnitudeDataStatus::operator > (const WindMagnitudeDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WindMagnitudeDataStatus::clear() {
    clearUpdateCounter();
}

inline void WindMagnitudeDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool WindMagnitudeDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 WindMagnitudeDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void WindMagnitudeDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void WindMagnitudeDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void WindMagnitudeDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WindDirectionDataStatus::WindDirectionDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WindDirectionDataStatus::WindDirectionDataStatus (const WindDirectionDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WindDirectionDataStatus::WindDirectionDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WindDirectionDataStatus::~WindDirectionDataStatus() {
}

inline WindDirectionDataStatus& WindDirectionDataStatus::operator = (const WindDirectionDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool WindDirectionDataStatus::operator == (const WindDirectionDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool WindDirectionDataStatus::operator != (const WindDirectionDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool WindDirectionDataStatus::operator < (const WindDirectionDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WindDirectionDataStatus::clone() {
    return new WindDirectionDataStatus(*this);
}

inline bool WindDirectionDataStatus::operator > (const WindDirectionDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WindDirectionDataStatus::clear() {
    clearUpdateCounter();
}

inline void WindDirectionDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool WindDirectionDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 WindDirectionDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void WindDirectionDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void WindDirectionDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void WindDirectionDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SurfaceDataStatus::SurfaceDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SurfaceDataStatus::SurfaceDataStatus (const SurfaceDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SurfaceDataStatus::SurfaceDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SurfaceDataStatus::~SurfaceDataStatus() {
}

inline SurfaceDataStatus& SurfaceDataStatus::operator = (const SurfaceDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool SurfaceDataStatus::operator == (const SurfaceDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool SurfaceDataStatus::operator != (const SurfaceDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SurfaceDataStatus::operator < (const SurfaceDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SurfaceDataStatus::clone() {
    return new SurfaceDataStatus(*this);
}

inline bool SurfaceDataStatus::operator > (const SurfaceDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SurfaceDataStatus::clear() {
    clearUpdateCounter();
}

inline void SurfaceDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool SurfaceDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SurfaceDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void SurfaceDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void SurfaceDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void SurfaceDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StormAttributesDataStatus::StormAttributesDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StormAttributesDataStatus::StormAttributesDataStatus (const StormAttributesDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StormAttributesDataStatus::StormAttributesDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StormAttributesDataStatus::~StormAttributesDataStatus() {
}

inline StormAttributesDataStatus& StormAttributesDataStatus::operator = (const StormAttributesDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool StormAttributesDataStatus::operator == (const StormAttributesDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool StormAttributesDataStatus::operator != (const StormAttributesDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool StormAttributesDataStatus::operator < (const StormAttributesDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StormAttributesDataStatus::clone() {
    return new StormAttributesDataStatus(*this);
}

inline bool StormAttributesDataStatus::operator > (const StormAttributesDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StormAttributesDataStatus::clear() {
    clearUpdateCounter();
}

inline void StormAttributesDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool StormAttributesDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 StormAttributesDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void StormAttributesDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void StormAttributesDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void StormAttributesDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StormTrackDataStatus::StormTrackDataStatus ()  :
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StormTrackDataStatus::StormTrackDataStatus (const StormTrackDataStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StormTrackDataStatus::StormTrackDataStatus (uint32 UpdateCounter_)  :
    _UpdateCounter (UpdateCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StormTrackDataStatus::~StormTrackDataStatus() {
}

inline StormTrackDataStatus& StormTrackDataStatus::operator = (const StormTrackDataStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
    }
    return *this;
}

inline bool StormTrackDataStatus::operator == (const StormTrackDataStatus& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()));
}

inline bool StormTrackDataStatus::operator != (const StormTrackDataStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool StormTrackDataStatus::operator < (const StormTrackDataStatus& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StormTrackDataStatus::clone() {
    return new StormTrackDataStatus(*this);
}

inline bool StormTrackDataStatus::operator > (const StormTrackDataStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StormTrackDataStatus::clear() {
    clearUpdateCounter();
}

inline void StormTrackDataStatus::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool StormTrackDataStatus::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 StormTrackDataStatus::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void StormTrackDataStatus::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void StormTrackDataStatus::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void StormTrackDataStatus::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ExchangeCapabilitiesStart::ExchangeCapabilitiesStart ()  :
    _SharedMemories ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExchangeCapabilitiesStart::ExchangeCapabilitiesStart (const ExchangeCapabilitiesStart &rhs)  :
    ::asf::core::Payload(rhs),
    _SharedMemories ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExchangeCapabilitiesStart::ExchangeCapabilitiesStart (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_)  :
    _SharedMemories (SharedMemories_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExchangeCapabilitiesStart::~ExchangeCapabilitiesStart() {
}

inline ExchangeCapabilitiesStart& ExchangeCapabilitiesStart::operator = (const ExchangeCapabilitiesStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSharedMemories()) {
            setSharedMemories(rhs.getSharedMemories());
        } else {
            clearSharedMemories();
        }
    }
    return *this;
}

inline bool ExchangeCapabilitiesStart::operator == (const ExchangeCapabilitiesStart& rhs) const {
    return (((!hasSharedMemories() && !rhs.hasSharedMemories()) || getSharedMemories() == rhs.getSharedMemories()));
}

inline bool ExchangeCapabilitiesStart::operator != (const ExchangeCapabilitiesStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ExchangeCapabilitiesStart::operator < (const ExchangeCapabilitiesStart& rhs) const {
    if (hasSharedMemories() || rhs.hasSharedMemories()) {
        if (getSharedMemories() < rhs.getSharedMemories()) return true;
        if (getSharedMemories() > rhs.getSharedMemories()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExchangeCapabilitiesStart::clone() {
    return new ExchangeCapabilitiesStart(*this);
}

inline bool ExchangeCapabilitiesStart::operator > (const ExchangeCapabilitiesStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExchangeCapabilitiesStart::clear() {
    clearSharedMemories();
}

inline void ExchangeCapabilitiesStart::clearSharedMemories() {
    if (hasSharedMemories()) {
         clear_has_SharedMemories();
        _SharedMemories.clear();
     }
}

inline bool ExchangeCapabilitiesStart::hasSharedMemories () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& ExchangeCapabilitiesStart::getSharedMemories () const {
    return _SharedMemories;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& ExchangeCapabilitiesStart::getSharedMemoriesMutable () {
    set_has_SharedMemories();
    return _SharedMemories;
}

inline void ExchangeCapabilitiesStart::setSharedMemories (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_) {
    set_has_SharedMemories();
    this->_SharedMemories = SharedMemories_;
}

inline void ExchangeCapabilitiesStart::set_has_SharedMemories () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExchangeCapabilitiesStart::clear_has_SharedMemories () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ExchangeCapabilitiesResult::ExchangeCapabilitiesResult ()  :
    _SharedMemories ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExchangeCapabilitiesResult::ExchangeCapabilitiesResult (const ExchangeCapabilitiesResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SharedMemories ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExchangeCapabilitiesResult::ExchangeCapabilitiesResult (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_)  :
    _SharedMemories (SharedMemories_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExchangeCapabilitiesResult::~ExchangeCapabilitiesResult() {
}

inline ExchangeCapabilitiesResult& ExchangeCapabilitiesResult::operator = (const ExchangeCapabilitiesResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSharedMemories()) {
            setSharedMemories(rhs.getSharedMemories());
        } else {
            clearSharedMemories();
        }
    }
    return *this;
}

inline bool ExchangeCapabilitiesResult::operator == (const ExchangeCapabilitiesResult& rhs) const {
    return (((!hasSharedMemories() && !rhs.hasSharedMemories()) || getSharedMemories() == rhs.getSharedMemories()));
}

inline bool ExchangeCapabilitiesResult::operator != (const ExchangeCapabilitiesResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ExchangeCapabilitiesResult::operator < (const ExchangeCapabilitiesResult& rhs) const {
    if (hasSharedMemories() || rhs.hasSharedMemories()) {
        if (getSharedMemories() < rhs.getSharedMemories()) return true;
        if (getSharedMemories() > rhs.getSharedMemories()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExchangeCapabilitiesResult::clone() {
    return new ExchangeCapabilitiesResult(*this);
}

inline bool ExchangeCapabilitiesResult::operator > (const ExchangeCapabilitiesResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExchangeCapabilitiesResult::clear() {
    clearSharedMemories();
}

inline void ExchangeCapabilitiesResult::clearSharedMemories() {
    if (hasSharedMemories()) {
         clear_has_SharedMemories();
        _SharedMemories.clear();
     }
}

inline bool ExchangeCapabilitiesResult::hasSharedMemories () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& ExchangeCapabilitiesResult::getSharedMemories () const {
    return _SharedMemories;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& ExchangeCapabilitiesResult::getSharedMemoriesMutable () {
    set_has_SharedMemories();
    return _SharedMemories;
}

inline void ExchangeCapabilitiesResult::setSharedMemories (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryDescription >& SharedMemories_) {
    set_has_SharedMemories();
    this->_SharedMemories = SharedMemories_;
}

inline void ExchangeCapabilitiesResult::set_has_SharedMemories () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExchangeCapabilitiesResult::clear_has_SharedMemories () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSurfaceDataResult::GetSurfaceDataResult ()  :
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSurfaceDataResult::GetSurfaceDataResult (const GetSurfaceDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSurfaceDataResult::GetSurfaceDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_)  :
    _UpdateCounter (UpdateCounter_),
    _Shapes (Shapes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSurfaceDataResult::~GetSurfaceDataResult() {
}

inline GetSurfaceDataResult& GetSurfaceDataResult::operator = (const GetSurfaceDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
        if (rhs.hasShapes()) {
            setShapes(rhs.getShapes());
        } else {
            clearShapes();
        }
    }
    return *this;
}

inline bool GetSurfaceDataResult::operator == (const GetSurfaceDataResult& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()) &&
        ((!hasShapes() && !rhs.hasShapes()) || getShapes() == rhs.getShapes()));
}

inline bool GetSurfaceDataResult::operator != (const GetSurfaceDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSurfaceDataResult::operator < (const GetSurfaceDataResult& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    if (hasShapes() || rhs.hasShapes()) {
        if (getShapes() < rhs.getShapes()) return true;
        if (getShapes() > rhs.getShapes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSurfaceDataResult::clone() {
    return new GetSurfaceDataResult(*this);
}

inline bool GetSurfaceDataResult::operator > (const GetSurfaceDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSurfaceDataResult::clear() {
    clearUpdateCounter();
    clearShapes();
}

inline void GetSurfaceDataResult::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool GetSurfaceDataResult::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetSurfaceDataResult::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void GetSurfaceDataResult::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void GetSurfaceDataResult::clearShapes() {
    if (hasShapes()) {
         clear_has_Shapes();
        _Shapes.clear();
     }
}

inline bool GetSurfaceDataResult::hasShapes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetSurfaceDataResult::getShapes () const {
    return _Shapes;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetSurfaceDataResult::getShapesMutable () {
    set_has_Shapes();
    return _Shapes;
}

inline void GetSurfaceDataResult::setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_) {
    set_has_Shapes();
    this->_Shapes = Shapes_;
}

inline void GetSurfaceDataResult::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSurfaceDataResult::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetSurfaceDataResult::set_has_Shapes () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetSurfaceDataResult::clear_has_Shapes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetStormAttributesDataResult::GetStormAttributesDataResult ()  :
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStormAttributesDataResult::GetStormAttributesDataResult (const GetStormAttributesDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStormAttributesDataResult::GetStormAttributesDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_)  :
    _UpdateCounter (UpdateCounter_),
    _Shapes (Shapes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStormAttributesDataResult::~GetStormAttributesDataResult() {
}

inline GetStormAttributesDataResult& GetStormAttributesDataResult::operator = (const GetStormAttributesDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
        if (rhs.hasShapes()) {
            setShapes(rhs.getShapes());
        } else {
            clearShapes();
        }
    }
    return *this;
}

inline bool GetStormAttributesDataResult::operator == (const GetStormAttributesDataResult& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()) &&
        ((!hasShapes() && !rhs.hasShapes()) || getShapes() == rhs.getShapes()));
}

inline bool GetStormAttributesDataResult::operator != (const GetStormAttributesDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStormAttributesDataResult::operator < (const GetStormAttributesDataResult& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    if (hasShapes() || rhs.hasShapes()) {
        if (getShapes() < rhs.getShapes()) return true;
        if (getShapes() > rhs.getShapes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStormAttributesDataResult::clone() {
    return new GetStormAttributesDataResult(*this);
}

inline bool GetStormAttributesDataResult::operator > (const GetStormAttributesDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStormAttributesDataResult::clear() {
    clearUpdateCounter();
    clearShapes();
}

inline void GetStormAttributesDataResult::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool GetStormAttributesDataResult::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetStormAttributesDataResult::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void GetStormAttributesDataResult::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void GetStormAttributesDataResult::clearShapes() {
    if (hasShapes()) {
         clear_has_Shapes();
        _Shapes.clear();
     }
}

inline bool GetStormAttributesDataResult::hasShapes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetStormAttributesDataResult::getShapes () const {
    return _Shapes;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetStormAttributesDataResult::getShapesMutable () {
    set_has_Shapes();
    return _Shapes;
}

inline void GetStormAttributesDataResult::setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_) {
    set_has_Shapes();
    this->_Shapes = Shapes_;
}

inline void GetStormAttributesDataResult::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStormAttributesDataResult::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStormAttributesDataResult::set_has_Shapes () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStormAttributesDataResult::clear_has_Shapes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetStormTrackDataResult::GetStormTrackDataResult ()  :
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStormTrackDataResult::GetStormTrackDataResult (const GetStormTrackDataResult &rhs)  :
    ::asf::core::Payload(rhs),
    _UpdateCounter (0u),
    _Shapes ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStormTrackDataResult::GetStormTrackDataResult (uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_)  :
    _UpdateCounter (UpdateCounter_),
    _Shapes (Shapes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStormTrackDataResult::~GetStormTrackDataResult() {
}

inline GetStormTrackDataResult& GetStormTrackDataResult::operator = (const GetStormTrackDataResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
        if (rhs.hasShapes()) {
            setShapes(rhs.getShapes());
        } else {
            clearShapes();
        }
    }
    return *this;
}

inline bool GetStormTrackDataResult::operator == (const GetStormTrackDataResult& rhs) const {
    return (((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()) &&
        ((!hasShapes() && !rhs.hasShapes()) || getShapes() == rhs.getShapes()));
}

inline bool GetStormTrackDataResult::operator != (const GetStormTrackDataResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStormTrackDataResult::operator < (const GetStormTrackDataResult& rhs) const {
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    if (hasShapes() || rhs.hasShapes()) {
        if (getShapes() < rhs.getShapes()) return true;
        if (getShapes() > rhs.getShapes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStormTrackDataResult::clone() {
    return new GetStormTrackDataResult(*this);
}

inline bool GetStormTrackDataResult::operator > (const GetStormTrackDataResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStormTrackDataResult::clear() {
    clearUpdateCounter();
    clearShapes();
}

inline void GetStormTrackDataResult::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool GetStormTrackDataResult::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetStormTrackDataResult::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void GetStormTrackDataResult::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void GetStormTrackDataResult::clearShapes() {
    if (hasShapes()) {
         clear_has_Shapes();
        _Shapes.clear();
     }
}

inline bool GetStormTrackDataResult::hasShapes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetStormTrackDataResult::getShapes () const {
    return _Shapes;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& GetStormTrackDataResult::getShapesMutable () {
    set_has_Shapes();
    return _Shapes;
}

inline void GetStormTrackDataResult::setShapes (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMShape >& Shapes_) {
    set_has_Shapes();
    this->_Shapes = Shapes_;
}

inline void GetStormTrackDataResult::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStormTrackDataResult::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStormTrackDataResult::set_has_Shapes () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStormTrackDataResult::clear_has_Shapes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AcquireAccessToSharedMemoryStart::AcquireAccessToSharedMemoryStart ()  :
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AcquireAccessToSharedMemoryStart::AcquireAccessToSharedMemoryStart (const AcquireAccessToSharedMemoryStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AcquireAccessToSharedMemoryStart::AcquireAccessToSharedMemoryStart (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_)  :
    _TileType (TileType_)
{
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "AcquireAccessToSharedMemoryStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AcquireAccessToSharedMemoryStart::~AcquireAccessToSharedMemoryStart() {
}

inline AcquireAccessToSharedMemoryStart& AcquireAccessToSharedMemoryStart::operator = (const AcquireAccessToSharedMemoryStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTileType()) {
            setTileType(rhs.getTileType());
        } else {
            clearTileType();
        }
    }
    return *this;
}

inline bool AcquireAccessToSharedMemoryStart::operator == (const AcquireAccessToSharedMemoryStart& rhs) const {
    return (((!hasTileType() && !rhs.hasTileType()) || getTileType() == rhs.getTileType()));
}

inline bool AcquireAccessToSharedMemoryStart::operator != (const AcquireAccessToSharedMemoryStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AcquireAccessToSharedMemoryStart::operator < (const AcquireAccessToSharedMemoryStart& rhs) const {
    if (hasTileType() || rhs.hasTileType()) {
        if ((uint32)getTileType() < (uint32)rhs.getTileType()) return true;
        if ((uint32)getTileType() > (uint32)rhs.getTileType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AcquireAccessToSharedMemoryStart::clone() {
    return new AcquireAccessToSharedMemoryStart(*this);
}

inline bool AcquireAccessToSharedMemoryStart::operator > (const AcquireAccessToSharedMemoryStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AcquireAccessToSharedMemoryStart::clear() {
    clearTileType();
}

inline void AcquireAccessToSharedMemoryStart::clearTileType() {
    if (hasTileType()) {
         clear_has_TileType();
        _TileType = ::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved;
     }
}

inline bool AcquireAccessToSharedMemoryStart::hasTileType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_agw_main_fi_types::T_e8_SXMTileType AcquireAccessToSharedMemoryStart::getTileType () const {
    return _TileType;
}

inline void AcquireAccessToSharedMemoryStart::setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_) {
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "AcquireAccessToSharedMemoryStart");
    }
    #endif
    set_has_TileType();
    this->_TileType = TileType_;
}

inline void AcquireAccessToSharedMemoryStart::set_has_TileType () {
    _has_bits_[0] |= 1u << 0;
}

inline void AcquireAccessToSharedMemoryStart::clear_has_TileType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AcquireAccessToSharedMemoryResult::AcquireAccessToSharedMemoryResult ()  :
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved),
    _AccessGranted (false),
    _UpdateCounter (0u),
    _TileList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AcquireAccessToSharedMemoryResult::AcquireAccessToSharedMemoryResult (const AcquireAccessToSharedMemoryResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved),
    _AccessGranted (false),
    _UpdateCounter (0u),
    _TileList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AcquireAccessToSharedMemoryResult::AcquireAccessToSharedMemoryResult (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_, bool AccessGranted_, uint32 UpdateCounter_, const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& TileList_)  :
    _TileType (TileType_),
    _AccessGranted (AccessGranted_),
    _UpdateCounter (UpdateCounter_),
    _TileList (TileList_)
{
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "AcquireAccessToSharedMemoryResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AcquireAccessToSharedMemoryResult::~AcquireAccessToSharedMemoryResult() {
}

inline AcquireAccessToSharedMemoryResult& AcquireAccessToSharedMemoryResult::operator = (const AcquireAccessToSharedMemoryResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTileType()) {
            setTileType(rhs.getTileType());
        } else {
            clearTileType();
        }
        if (rhs.hasAccessGranted()) {
            setAccessGranted(rhs.getAccessGranted());
        } else {
            clearAccessGranted();
        }
        if (rhs.hasUpdateCounter()) {
            setUpdateCounter(rhs.getUpdateCounter());
        } else {
            clearUpdateCounter();
        }
        if (rhs.hasTileList()) {
            setTileList(rhs.getTileList());
        } else {
            clearTileList();
        }
    }
    return *this;
}

inline bool AcquireAccessToSharedMemoryResult::operator == (const AcquireAccessToSharedMemoryResult& rhs) const {
    return (((!hasTileType() && !rhs.hasTileType()) || getTileType() == rhs.getTileType()) &&
        ((!hasAccessGranted() && !rhs.hasAccessGranted()) || getAccessGranted() == rhs.getAccessGranted()) &&
        ((!hasUpdateCounter() && !rhs.hasUpdateCounter()) || getUpdateCounter() == rhs.getUpdateCounter()) &&
        ((!hasTileList() && !rhs.hasTileList()) || getTileList() == rhs.getTileList()));
}

inline bool AcquireAccessToSharedMemoryResult::operator != (const AcquireAccessToSharedMemoryResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AcquireAccessToSharedMemoryResult::operator < (const AcquireAccessToSharedMemoryResult& rhs) const {
    if (hasTileType() || rhs.hasTileType()) {
        if ((uint32)getTileType() < (uint32)rhs.getTileType()) return true;
        if ((uint32)getTileType() > (uint32)rhs.getTileType()) return false;
    }
    if (hasAccessGranted() || rhs.hasAccessGranted()) {
        if (getAccessGranted() < rhs.getAccessGranted()) return true;
        if (getAccessGranted() > rhs.getAccessGranted()) return false;
    }
    if (hasUpdateCounter() || rhs.hasUpdateCounter()) {
        if (getUpdateCounter() < rhs.getUpdateCounter()) return true;
        if (getUpdateCounter() > rhs.getUpdateCounter()) return false;
    }
    if (hasTileList() || rhs.hasTileList()) {
        if (getTileList() < rhs.getTileList()) return true;
        if (getTileList() > rhs.getTileList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AcquireAccessToSharedMemoryResult::clone() {
    return new AcquireAccessToSharedMemoryResult(*this);
}

inline bool AcquireAccessToSharedMemoryResult::operator > (const AcquireAccessToSharedMemoryResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AcquireAccessToSharedMemoryResult::clear() {
    clearTileType();
    clearAccessGranted();
    clearUpdateCounter();
    clearTileList();
}

inline void AcquireAccessToSharedMemoryResult::clearTileType() {
    if (hasTileType()) {
         clear_has_TileType();
        _TileType = ::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved;
     }
}

inline bool AcquireAccessToSharedMemoryResult::hasTileType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_agw_main_fi_types::T_e8_SXMTileType AcquireAccessToSharedMemoryResult::getTileType () const {
    return _TileType;
}

inline void AcquireAccessToSharedMemoryResult::setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_) {
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "AcquireAccessToSharedMemoryResult");
    }
    #endif
    set_has_TileType();
    this->_TileType = TileType_;
}

inline void AcquireAccessToSharedMemoryResult::clearAccessGranted() {
    if (hasAccessGranted()) {
         clear_has_AccessGranted();
        _AccessGranted = false;
     }
}

inline bool AcquireAccessToSharedMemoryResult::hasAccessGranted () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool AcquireAccessToSharedMemoryResult::getAccessGranted () const {
    return _AccessGranted;
}

inline void AcquireAccessToSharedMemoryResult::setAccessGranted (bool AccessGranted_) {
    set_has_AccessGranted();
    this->_AccessGranted = AccessGranted_;
}

inline void AcquireAccessToSharedMemoryResult::clearUpdateCounter() {
    if (hasUpdateCounter()) {
         clear_has_UpdateCounter();
        _UpdateCounter = 0u;
     }
}

inline bool AcquireAccessToSharedMemoryResult::hasUpdateCounter () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 AcquireAccessToSharedMemoryResult::getUpdateCounter () const {
    return _UpdateCounter;
}

inline void AcquireAccessToSharedMemoryResult::setUpdateCounter (uint32 UpdateCounter_) {
    set_has_UpdateCounter();
    this->_UpdateCounter = UpdateCounter_;
}

inline void AcquireAccessToSharedMemoryResult::clearTileList() {
    if (hasTileList()) {
         clear_has_TileList();
        _TileList.clear();
     }
}

inline bool AcquireAccessToSharedMemoryResult::hasTileList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& AcquireAccessToSharedMemoryResult::getTileList () const {
    return _TileList;
}

inline ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& AcquireAccessToSharedMemoryResult::getTileListMutable () {
    set_has_TileList();
    return _TileList;
}

inline void AcquireAccessToSharedMemoryResult::setTileList (const ::std::vector< ::sxm_agw_main_fi_types::T_SXMSharedMemoryTile >& TileList_) {
    set_has_TileList();
    this->_TileList = TileList_;
}

inline void AcquireAccessToSharedMemoryResult::set_has_TileType () {
    _has_bits_[0] |= 1u << 0;
}

inline void AcquireAccessToSharedMemoryResult::clear_has_TileType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AcquireAccessToSharedMemoryResult::set_has_AccessGranted () {
    _has_bits_[0] |= 1u << 1;
}

inline void AcquireAccessToSharedMemoryResult::clear_has_AccessGranted () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AcquireAccessToSharedMemoryResult::set_has_UpdateCounter () {
    _has_bits_[0] |= 1u << 2;
}

inline void AcquireAccessToSharedMemoryResult::clear_has_UpdateCounter () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AcquireAccessToSharedMemoryResult::set_has_TileList () {
    _has_bits_[0] |= 1u << 3;
}

inline void AcquireAccessToSharedMemoryResult::clear_has_TileList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReleaseAccessFromSharedMemoryStart::ReleaseAccessFromSharedMemoryStart ()  :
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReleaseAccessFromSharedMemoryStart::ReleaseAccessFromSharedMemoryStart (const ReleaseAccessFromSharedMemoryStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TileType (::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReleaseAccessFromSharedMemoryStart::ReleaseAccessFromSharedMemoryStart (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_)  :
    _TileType (TileType_)
{
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "ReleaseAccessFromSharedMemoryStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReleaseAccessFromSharedMemoryStart::~ReleaseAccessFromSharedMemoryStart() {
}

inline ReleaseAccessFromSharedMemoryStart& ReleaseAccessFromSharedMemoryStart::operator = (const ReleaseAccessFromSharedMemoryStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTileType()) {
            setTileType(rhs.getTileType());
        } else {
            clearTileType();
        }
    }
    return *this;
}

inline bool ReleaseAccessFromSharedMemoryStart::operator == (const ReleaseAccessFromSharedMemoryStart& rhs) const {
    return (((!hasTileType() && !rhs.hasTileType()) || getTileType() == rhs.getTileType()));
}

inline bool ReleaseAccessFromSharedMemoryStart::operator != (const ReleaseAccessFromSharedMemoryStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ReleaseAccessFromSharedMemoryStart::operator < (const ReleaseAccessFromSharedMemoryStart& rhs) const {
    if (hasTileType() || rhs.hasTileType()) {
        if ((uint32)getTileType() < (uint32)rhs.getTileType()) return true;
        if ((uint32)getTileType() > (uint32)rhs.getTileType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReleaseAccessFromSharedMemoryStart::clone() {
    return new ReleaseAccessFromSharedMemoryStart(*this);
}

inline bool ReleaseAccessFromSharedMemoryStart::operator > (const ReleaseAccessFromSharedMemoryStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReleaseAccessFromSharedMemoryStart::clear() {
    clearTileType();
}

inline void ReleaseAccessFromSharedMemoryStart::clearTileType() {
    if (hasTileType()) {
         clear_has_TileType();
        _TileType = ::sxm_agw_main_fi_types::T_e8_SXMTileType__T_Reserved;
     }
}

inline bool ReleaseAccessFromSharedMemoryStart::hasTileType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::sxm_agw_main_fi_types::T_e8_SXMTileType ReleaseAccessFromSharedMemoryStart::getTileType () const {
    return _TileType;
}

inline void ReleaseAccessFromSharedMemoryStart::setTileType (::sxm_agw_main_fi_types::T_e8_SXMTileType TileType_) {
    #ifndef NDEBUG
    if (!(::sxm_agw_main_fi_types::T_e8_SXMTileType_IsValid(TileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TileType_, "T_e8_SXMTileType", "TileType", "ReleaseAccessFromSharedMemoryStart");
    }
    #endif
    set_has_TileType();
    this->_TileType = TileType_;
}

inline void ReleaseAccessFromSharedMemoryStart::set_has_TileType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReleaseAccessFromSharedMemoryStart::clear_has_TileType () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace sxm_agw_main_fi

#endif // SXM_AGW_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
