/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SWITCHCTRL_MAIN_FIPROXY_H
#define SWITCHCTRL_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "switchctrl_main_fi.h"

namespace switchctrl_main_fi {

class Switchctrl_main_fiProxy;

class BeepInfoCallbackIF {
public:
    virtual ~BeepInfoCallbackIF() {}

    virtual void onBeepInfoError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< BeepInfoError >& error) = 0;

    virtual void onBeepInfoResult(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< BeepInfoResult >& result) = 0;
};

class HardwareVersionCallbackIF {
public:
    virtual ~HardwareVersionCallbackIF() {}

    virtual void onHardwareVersionError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< HardwareVersionError >& error) = 0;

    virtual void onHardwareVersionStatus(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< HardwareVersionStatus >& status) = 0;
};

class ITCommander_ConnectionCallbackIF {
public:
    virtual ~ITCommander_ConnectionCallbackIF() {}

    virtual void onITCommander_ConnectionError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< ITCommander_ConnectionError >& error) = 0;

    virtual void onITCommander_ConnectionStatus(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< ITCommander_ConnectionStatus >& status) = 0;
};

class PrimaryIntegratedSwitch_ConnectionCallbackIF {
public:
    virtual ~PrimaryIntegratedSwitch_ConnectionCallbackIF() {}

    virtual void onPrimaryIntegratedSwitch_ConnectionError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionError >& error) = 0;

    virtual void onPrimaryIntegratedSwitch_ConnectionStatus(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< PrimaryIntegratedSwitch_ConnectionStatus >& status) = 0;
};

class RearSeat_ConnectionCallbackIF {
public:
    virtual ~RearSeat_ConnectionCallbackIF() {}

    virtual void onRearSeat_ConnectionError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RearSeat_ConnectionError >& error) = 0;

    virtual void onRearSeat_ConnectionStatus(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RearSeat_ConnectionStatus >& status) = 0;
};

class ResetHistoryCallbackIF {
public:
    virtual ~ResetHistoryCallbackIF() {}

    virtual void onResetHistoryError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetHistoryError >& error) = 0;

    virtual void onResetHistoryResult(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetHistoryResult >& result) = 0;
};

class SoftwareVersionCallbackIF {
public:
    virtual ~SoftwareVersionCallbackIF() {}

    virtual void onSoftwareVersionError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< SoftwareVersionError >& error) = 0;

    virtual void onSoftwareVersionStatus(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< SoftwareVersionStatus >& status) = 0;
};

class VersionInfoCallbackIF {
public:
    virtual ~VersionInfoCallbackIF() {}

    virtual void onVersionInfoError(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< VersionInfoError >& error) = 0;

    virtual void onVersionInfoResult(const ::boost::shared_ptr< Switchctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< VersionInfoResult >& result) = 0;
};

class Switchctrl_main_fiProxyCallback;

/**
 * Switchctrl_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'switchctrl_main_fi' (specified in file
 * switchctrl_main_fi.xml).
 *
 * CCA Functional Interface 'switchctrl_main_fi'
 *
 * Fullname: SwitchCtrl CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: Sandeep Gupta (RBEI/ECV)
 *
 * Date: $Date: 12 Nov 2015 09:00:00  $
 *
 * Department:
 *
 * Title: SWITCH_CONTROL_FI
 *
 * <b>Description of 'switchctrl_main_fi':</b>
 *
 * SwitchCtrl_FI messages for CCA applications
 */
class Switchctrl_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Switchctrl_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Switchctrl_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Switchctrl_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Switchctrl_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Switchctrl_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Switchctrl_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Switchctrl_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Switchctrl_main_fiProxy();

    // Method 'ResetHistory'

    /**
     * Call the method 'ResetHistory'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Send INC message request to V850 to reset MCAN Units Connection History.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetHistoryStart(ResetHistoryCallbackIF& cb);

    // Method 'VersionInfo'

    /**
     * Call the method 'VersionInfo'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'VersionInfo'</b>:
     *
     * Send INC message request to V850 to get version for MCAN Units Connection History.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionInfoStart(VersionInfoCallbackIF& cb);

    // Method 'BeepInfo'

    /**
     * Call the method 'BeepInfo'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'BeepInfo'</b>:
     *
     * AUDIO calls this function as a trigger to send Beep information
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8NoOfBeeps AUDIO sends No of Beep and Frequency of the beep
     *
     * @param u8BeepTime AUDIO sends Time of Beep
     *
     * @param u8Period AUDIO sends The period of Beep
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBeepInfoStart(BeepInfoCallbackIF& cb, uint8 u8NoOfBeeps, uint8 u8BeepTime, uint8 u8Period);

    // Property 'RearSeat_Connection'

    /**
     * Notify on the property 'RearSeat_Connection'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RearSeat_Connection'</b>:
     *
     * This property gives information about the connection status to the Rear Seat MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRearSeat_ConnectionUpReg(RearSeat_ConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RearSeat_Connection'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RearSeat_Connection'</b>:
     *
     * This property gives information about the connection status to the Rear Seat MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendRearSeat_ConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRearSeat_ConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RearSeat_Connection'.
     */
    void sendRearSeat_ConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'RearSeat_Connection' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRearSeat_Connection() returns true.
     *
     * @return the previously received value of the property 'RearSeat_Connection'.
     */
    const RearSeat_ConnectionStatus& getRearSeat_Connection() const;

    /**
     * Determines whether a status message for the property 'RearSeat_Connection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRearSeat_Connection() const;

    /**
     * Request the value of the property 'RearSeat_Connection' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RearSeat_Connection'</b>:
     *
     * This property gives information about the connection status to the Rear Seat MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRearSeat_ConnectionGet(RearSeat_ConnectionCallbackIF& cb);

    // Property 'ITCommander_Connection'

    /**
     * Notify on the property 'ITCommander_Connection'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ITCommander_Connection'</b>:
     *
     * This property gives information about the connection status to the IT Commander MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendITCommander_ConnectionUpReg(ITCommander_ConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ITCommander_Connection'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ITCommander_Connection'</b>:
     *
     * This property gives information about the connection status to the IT Commander MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendITCommander_ConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendITCommander_ConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ITCommander_Connection'.
     */
    void sendITCommander_ConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'ITCommander_Connection' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasITCommander_Connection() returns true.
     *
     * @return the previously received value of the property 'ITCommander_Connection'.
     */
    const ITCommander_ConnectionStatus& getITCommander_Connection() const;

    /**
     * Determines whether a status message for the property 'ITCommander_Connection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasITCommander_Connection() const;

    /**
     * Request the value of the property 'ITCommander_Connection' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ITCommander_Connection'</b>:
     *
     * This property gives information about the connection status to the IT Commander MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendITCommander_ConnectionGet(ITCommander_ConnectionCallbackIF& cb);

    // Property 'HardwareVersion'

    /**
     * Notify on the property 'HardwareVersion'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHardwareVersionUpReg(HardwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'HardwareVersion'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendHardwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendHardwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'HardwareVersion'.
     */
    void sendHardwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'HardwareVersion' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasHardwareVersion() returns true.
     *
     * @return the previously received value of the property 'HardwareVersion'.
     */
    const HardwareVersionStatus& getHardwareVersion() const;

    /**
     * Determines whether a status message for the property 'HardwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasHardwareVersion() const;

    /**
     * Request the value of the property 'HardwareVersion' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHardwareVersionGet(HardwareVersionCallbackIF& cb);

    // Property 'SoftwareVersion'

    /**
     * Notify on the property 'SoftwareVersion'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoftwareVersionUpReg(SoftwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SoftwareVersion'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendSoftwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSoftwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SoftwareVersion'.
     */
    void sendSoftwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'SoftwareVersion' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSoftwareVersion() returns true.
     *
     * @return the previously received value of the property 'SoftwareVersion'.
     */
    const SoftwareVersionStatus& getSoftwareVersion() const;

    /**
     * Determines whether a status message for the property 'SoftwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSoftwareVersion() const;

    /**
     * Request the value of the property 'SoftwareVersion' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSoftwareVersionGet(SoftwareVersionCallbackIF& cb);

    // Property 'PrimaryIntegratedSwitch_Connection'

    /**
     * Notify on the property 'PrimaryIntegratedSwitch_Connection'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'PrimaryIntegratedSwitch_Connection'</b>:
     *
     * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrimaryIntegratedSwitch_ConnectionUpReg(PrimaryIntegratedSwitch_ConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'PrimaryIntegratedSwitch_Connection'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PrimaryIntegratedSwitch_Connection'</b>:
     *
     * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendPrimaryIntegratedSwitch_ConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPrimaryIntegratedSwitch_ConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PrimaryIntegratedSwitch_Connection'.
     */
    void sendPrimaryIntegratedSwitch_ConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'PrimaryIntegratedSwitch_Connection' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasPrimaryIntegratedSwitch_Connection() returns true.
     *
     * @return the previously received value of the property 'PrimaryIntegratedSwitch_Connection'.
     */
    const PrimaryIntegratedSwitch_ConnectionStatus& getPrimaryIntegratedSwitch_Connection() const;

    /**
     * Determines whether a status message for the property 'PrimaryIntegratedSwitch_Connection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPrimaryIntegratedSwitch_Connection() const;

    /**
     * Request the value of the property 'PrimaryIntegratedSwitch_Connection'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PrimaryIntegratedSwitch_Connection'</b>:
     *
     * This property gives information about the connection status to the Primary Integrated Switch MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrimaryIntegratedSwitch_ConnectionGet(PrimaryIntegratedSwitch_ConnectionCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Switchctrl_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'RearSeat_Connection'

    ::asf::core::nullable< RearSeat_ConnectionStatus > _rearSeat_Connection;

    // Property 'ITCommander_Connection'

    ::asf::core::nullable< ITCommander_ConnectionStatus > _iTCommander_Connection;

    // Property 'HardwareVersion'

    ::asf::core::nullable< HardwareVersionStatus > _hardwareVersion;

    // Property 'SoftwareVersion'

    ::asf::core::nullable< SoftwareVersionStatus > _softwareVersion;

    // Property 'PrimaryIntegratedSwitch_Connection'

    ::asf::core::nullable< PrimaryIntegratedSwitch_ConnectionStatus > _primaryIntegratedSwitch_Connection;

    DECLARE_CLASS_LOGGER();

    friend class Switchctrl_main_fiProxyCallback;
};

} // namespace switchctrl_main_fi

#endif // SWITCHCTRL_MAIN_FIPROXY_H
