/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm/startupcontroller.h"
#include "org/bosch/cm/lcm/startupcontrollerConst.h"
#include "org/bosch/cm/lcm/startupcontrollerDBus.h"
#include "org/bosch/cm/lcm/startupcontrollerJson.h"
#include "org/bosch/cm/lcm/startupcontrollerStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

DEFINE_CLASS_LOGGER("/org/bosch/cm/lcm/org/bosch/cm/lcm/startupcontroller", StartupcontrollerStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 10, "FI_Version", 0 },
    { 13, "StartupStatus", 1 },
    { 24, "StartupFailureIndication", 2 },
};

class StartupcontrollerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    StartupcontrollerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    StartupcontrollerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    StartupcontrollerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.lcm.startupcontroller"),
          _logger(logger) {}

    virtual ~StartupcontrollerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void StartupcontrollerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* StartupcontrollerStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.lcm.startupcontroller\">\n"
            "    <property access=\"read\" name=\"FI_Version\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"StartupStatus\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"StartupFailureIndication\" type=\"(uuu)\"/>\n"
            "</interface>\n";
}

void StartupcontrollerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<StartupcontrollerStub*>(getStub()))->onGetAll (properties);
}

void StartupcontrollerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FI_Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "StartupStatus");
            ::boost::shared_ptr< StartupStatusSet > payload(new StartupStatusSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<StartupcontrollerStub*>(getStub())->onStartupStatusSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "StartupFailureIndication");
            ::boost::shared_ptr< StartupFailureIndicationSet > payload(new StartupFailureIndicationSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<StartupcontrollerStub*>(getStub())->onStartupFailureIndicationSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void StartupcontrollerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FI_Version");
            ::boost::shared_ptr< FI_VersionGet > payload(new FI_VersionGet());
            payload->setAct(act);
            static_cast<StartupcontrollerStub*>(getStub())->onFI_VersionGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "StartupStatus");
            ::boost::shared_ptr< StartupStatusGet > payload(new StartupStatusGet());
            payload->setAct(act);
            static_cast<StartupcontrollerStub*>(getStub())->onStartupStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "StartupFailureIndication");
            ::boost::shared_ptr< StartupFailureIndicationGet > payload(new StartupFailureIndicationGet());
            payload->setAct(act);
            static_cast<StartupcontrollerStub*>(getStub())->onStartupFailureIndicationGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

StartupcontrollerStub::StartupcontrollerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new StartupcontrollerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

StartupcontrollerStub::StartupcontrollerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new StartupcontrollerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

StartupcontrollerStub::~StartupcontrollerStub() {
    delete _stubDelegate;
}

void StartupcontrollerStub::sendFI_VersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FI_VersionUpdate payload(_FI_VersionProperty);

        LOG_INFO ("-> send%s", "FI_VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FI_Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.startupcontroller", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FI_VersionUpdate");
    }
}

void StartupcontrollerStub::onFI_VersionGet(const ::boost::shared_ptr< FI_VersionGet >& fI_Version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FI_VersionGet", fI_Version->getAct());
    sendFI_VersionGetUpdate(_FI_VersionProperty.getFI_Version(), fI_Version->getAct());
}

void StartupcontrollerStub::sendFI_VersionGetUpdate(const ::std::string& fI_Version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FI_VersionGet payload(fI_Version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FI_VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void StartupcontrollerStub::setFI_Version(const ::std::string& fI_Version) {
    if(fI_Version!=_FI_VersionProperty.getFI_Version()) {
        _FI_VersionProperty.setFI_Version(fI_Version);
        sendFI_VersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& StartupcontrollerStub::getFI_Version() const {
    return _FI_VersionProperty.getFI_Version();
}

::std::string& StartupcontrollerStub::getFI_VersionMutable() {
    return _FI_VersionProperty.getFI_VersionMutable();
}

void StartupcontrollerStub::sendStartupStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupStatusUpdate payload(_StartupStatusProperty);

        LOG_INFO ("-> send%s", "StartupStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.startupcontroller", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupStatusUpdate");
    }
}

void StartupcontrollerStub::onStartupStatusGet(const ::boost::shared_ptr< StartupStatusGet >& startupStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupStatusGet", startupStatus->getAct());
    sendStartupStatusGetUpdate(_StartupStatusProperty.getStartupStatus(), startupStatus->getAct());
}

void StartupcontrollerStub::sendStartupStatusGetUpdate(StartupState startupStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupStatusGet payload(startupStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void StartupcontrollerStub::onStartupStatusSet(const ::boost::shared_ptr< StartupStatusSet >& startupStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupStatusSet", startupStatus->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*startupStatus, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setStartupStatus (startupStatus->getStartupStatus());
    sendStartupStatusSetUpdate(startupStatus->getAct());
}

void StartupcontrollerStub::sendStartupStatusSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupStatusSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void StartupcontrollerStub::setStartupStatus(StartupState startupStatus) {
    if(startupStatus!=_StartupStatusProperty.getStartupStatus()) {
        _StartupStatusProperty.setStartupStatus(startupStatus);
        sendStartupStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

StartupState StartupcontrollerStub::getStartupStatus() const {
    return _StartupStatusProperty.getStartupStatus();
}

void StartupcontrollerStub::sendStartupFailureIndicationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupFailureIndicationUpdate payload(_StartupFailureIndicationProperty);

        LOG_INFO ("-> send%s", "StartupFailureIndicationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupFailureIndication", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.startupcontroller", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupFailureIndicationUpdate");
    }
}

void StartupcontrollerStub::onStartupFailureIndicationGet(const ::boost::shared_ptr< StartupFailureIndicationGet >& startupFailureIndication) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupFailureIndicationGet", startupFailureIndication->getAct());
    sendStartupFailureIndicationGetUpdate(_StartupFailureIndicationProperty.getStartupFailureIndication(), startupFailureIndication->getAct());
}

void StartupcontrollerStub::sendStartupFailureIndicationGetUpdate(const StartupFailureInfo& startupFailureIndication, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupFailureIndicationGet payload(startupFailureIndication);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupFailureIndicationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void StartupcontrollerStub::onStartupFailureIndicationSet(const ::boost::shared_ptr< StartupFailureIndicationSet >& startupFailureIndication) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupFailureIndicationSet", startupFailureIndication->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*startupFailureIndication, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setStartupFailureIndication (startupFailureIndication->getStartupFailureIndication());
    sendStartupFailureIndicationSetUpdate(startupFailureIndication->getAct());
}

void StartupcontrollerStub::sendStartupFailureIndicationSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupFailureIndicationSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void StartupcontrollerStub::setStartupFailureIndication(const StartupFailureInfo& startupFailureIndication) {
    if(startupFailureIndication!=_StartupFailureIndicationProperty.getStartupFailureIndication()) {
        _StartupFailureIndicationProperty.setStartupFailureIndication(startupFailureIndication);
        sendStartupFailureIndicationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const StartupFailureInfo& StartupcontrollerStub::getStartupFailureIndication() const {
    return _StartupFailureIndicationProperty.getStartupFailureIndication();
}

StartupFailureInfo& StartupcontrollerStub::getStartupFailureIndicationMutable() {
    return _StartupFailureIndicationProperty.getStartupFailureIndicationMutable();
}

void StartupcontrollerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'FI_Version'
    {
        ::asf::dbus::DBusVariant variant;
        FI_VersionGet payload(_FI_VersionProperty.getFI_Version());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FI_Version", variant));
    }

    //property 'StartupStatus'
    {
        ::asf::dbus::DBusVariant variant;
        StartupStatusGet payload(_StartupStatusProperty.getStartupStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupStatus", variant));
    }

    //property 'StartupFailureIndication'
    {
        ::asf::dbus::DBusVariant variant;
        StartupFailureIndicationGet payload(_StartupFailureIndicationProperty.getStartupFailureIndication());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupFailureIndication", variant));
    }
}

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
