/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm/startupcontroller.h"
#include "org/bosch/cm/lcm/startupcontrollerConst.h"
#include "org/bosch/cm/lcm/startupcontrollerDBus.h"
#include "org/bosch/cm/lcm/startupcontrollerJson.h"
#include "org/bosch/cm/lcm/startupcontrollerProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

DEFINE_CLASS_LOGGER("/org/bosch/cm/lcm/org/bosch/cm/lcm/startupcontroller", StartupcontrollerProxy);

class StartupcontrollerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    StartupcontrollerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< StartupcontrollerProxy >& proxyShared = ::boost::static_pointer_cast< StartupcontrollerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_FI_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FI_VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FI_Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FI_VersionError> payload = ::boost::static_pointer_cast<FI_VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FI_VersionCallbackIF*) _callback)->onFI_VersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FI_VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FI_Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FI_VersionUpdate> payload = ::boost::static_pointer_cast<FI_VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FI_VersionCallbackIF*) _callback)->onFI_VersionUpdate(proxyShared, payload);
                        proxyShared->_fI_Version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartupStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupStatusError> payload = ::boost::static_pointer_cast<StartupStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartupStatusCallbackIF*) _callback)->onStartupStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupStatusUpdate> payload = ::boost::static_pointer_cast<StartupStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartupStatusCallbackIF*) _callback)->onStartupStatusUpdate(proxyShared, payload);
                        proxyShared->_startupStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartupFailureIndication:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupFailureIndicationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupFailureIndication", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupFailureIndicationError> payload = ::boost::static_pointer_cast<StartupFailureIndicationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupFailureIndicationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupFailureIndication", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupFailureIndicationUpdate> payload = ::boost::static_pointer_cast<StartupFailureIndicationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationUpdate(proxyShared, payload);
                        proxyShared->_startupFailureIndication = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_FI_Version: {
                ::boost::shared_ptr< FI_VersionError > payload = ::boost::shared_ptr< FI_VersionError >
                (new FI_VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Startupcontroller is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FI_Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StartupcontrollerProxy> proxyShared = ::boost::static_pointer_cast<StartupcontrollerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FI_VersionCallbackIF*) _callback)->onFI_VersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartupStatus: {
                ::boost::shared_ptr< StartupStatusError > payload = ::boost::shared_ptr< StartupStatusError >
                (new StartupStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Startupcontroller is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartupStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StartupcontrollerProxy> proxyShared = ::boost::static_pointer_cast<StartupcontrollerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartupStatusCallbackIF*) _callback)->onStartupStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartupFailureIndication: {
                ::boost::shared_ptr< StartupFailureIndicationError > payload = ::boost::shared_ptr< StartupFailureIndicationError >
                (new StartupFailureIndicationError(DBUS_ERROR_NO_SERVER, "The DBus service Startupcontroller is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartupFailureIndication", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StartupcontrollerProxy> proxyShared = ::boost::static_pointer_cast<StartupcontrollerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& StartupcontrollerProxyCallback::_logger (StartupcontrollerProxy::_logger);

StartupcontrollerProxy::StartupcontrollerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.lcm.startupcontroller", serviceAvailable, _logger) {
}

StartupcontrollerProxy::~StartupcontrollerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< StartupcontrollerProxy > StartupcontrollerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<StartupcontrollerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< StartupcontrollerProxy > proxyNew(new StartupcontrollerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t StartupcontrollerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t StartupcontrollerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void StartupcontrollerProxy::clearAllProperties ()
{
    _fI_Version = ::asf::core::nullable< FI_VersionUpdate >();
    _startupStatus = ::asf::core::nullable< StartupStatusUpdate >();
    _startupFailureIndication = ::asf::core::nullable< StartupFailureIndicationUpdate >();
}

void StartupcontrollerProxy::sendDeregisterAll () const
{
    sendStartupFailureIndicationDeregisterAll();
}


act_t StartupcontrollerProxy::sendFI_VersionGet(FI_VersionCallbackIF& cb) {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(ID_FI_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FI_Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FI_Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& StartupcontrollerProxy::getFI_Version() const {
    return _fI_Version.get().getFI_Version();
}

bool StartupcontrollerProxy::hasFI_Version() const {
    return _fI_Version.hasValue();
}



act_t StartupcontrollerProxy::sendStartupStatusGet(StartupStatusCallbackIF& cb) {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(ID_StartupStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartupStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartupStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void StartupcontrollerProxy::sendStartupStatusSet(StartupState startupStatus) {
    StartupStatusSet parameter(startupStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "StartupStatus");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "StartupStatus", propertyContent);
}

act_t StartupcontrollerProxy::sendStartupStatusSet(StartupStatusCallbackIF& cb, StartupState startupStatus) {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(ID_StartupStatus, &cb);
    StartupStatusSet parameter(startupStatus);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "StartupStatus", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "StartupStatus", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

StartupState StartupcontrollerProxy::getStartupStatus() const {
    return _startupStatus.get().getStartupStatus();
}

bool StartupcontrollerProxy::hasStartupStatus() const {
    return _startupStatus.hasValue();
}


act_t StartupcontrollerProxy::sendStartupFailureIndicationRegister(StartupFailureIndicationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartupFailureIndication, "StartupFailureIndication", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartupFailureIndication", &cb, act);
    return act;
}

bool StartupcontrollerProxy::sendStartupFailureIndicationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartupFailureIndication", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartupFailureIndication", act, static_cast<int>(rv));
    return rv;
}

act_t StartupcontrollerProxy::sendStartupFailureIndicationGet(StartupFailureIndicationCallbackIF& cb) {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(ID_StartupFailureIndication, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartupFailureIndication", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartupFailureIndication", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void StartupcontrollerProxy::sendStartupFailureIndicationSet(const StartupFailureInfo& startupFailureIndication) {
    StartupFailureIndicationSet parameter(startupFailureIndication);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "StartupFailureIndication");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "StartupFailureIndication", propertyContent);
}

act_t StartupcontrollerProxy::sendStartupFailureIndicationSet(StartupFailureIndicationCallbackIF& cb, const StartupFailureInfo& startupFailureIndication) {
    StartupcontrollerProxyCallback* callback = new StartupcontrollerProxyCallback(ID_StartupFailureIndication, &cb);
    StartupFailureIndicationSet parameter(startupFailureIndication);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "StartupFailureIndication", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "StartupFailureIndication", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const StartupFailureInfo& StartupcontrollerProxy::getStartupFailureIndication() const {
    return _startupFailureIndication.get().getStartupFailureIndication();
}

bool StartupcontrollerProxy::hasStartupFailureIndication() const {
    return _startupFailureIndication.hasValue();
}

void StartupcontrollerProxy::sendStartupFailureIndicationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartupFailureIndication");
    _dbusProxyDelegate->deregisterSignalCallback("StartupFailureIndication", 0, _dbusDaemonProxy.get(), true);
}

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
