/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_STARTUPCONTROLLERCONST_H
#define ORG_BOSCH_CM_LCM_STARTUPCONTROLLERCONST_H

#include <cstddef>

/**
 * the StartupController service is used to communicate between LCM and StartupController application
 * 	The LCM informs the StartupController when all applications have been started
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

/**
 * Startup state enum
 */
enum StartupState {

    /**
     * Init state
     */
    StartupState__STARTUP_INIT,
    /**
     * Startup actived
     */
    StartupState__STARTUP_ACTIVE,
    /**
     * Startup done
     */
    StartupState__STARTUP_DONE

};

bool StartupState_Parse (const char *str, size_t length, StartupState &value);

const char* StartupState_Name (StartupState value);

bool StartupState_IsValid (StartupState value);

/**
 * Startup failure enum
 */
enum StartupFailure {

    /**
     * No failure
     */
    StartupFailure__STARTUP_FAILURE_NONE,
    /**
     * "TimeoutStartSec=<sec>" in service file of systemd is used
     */
    StartupFailure__STARTUP_FAILURE_STARTUPTIME_AVAILABLE,
    /**
     * Timer "TimeoutStartSec=<sec>" expired
     */
    StartupFailure__STARTUP_FAILURE_STARTUPTIME_EXPIRED,
    /**
     * Shutdown failed
     */
    StartupFailure__STARTUP_FAILURE_SHUTDOWN_FAILED,
    /**
     * CLI parameter "StartupTime=<sec>" is used, for debugging
     */
    StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE,
    /**
     * Timer "Debugging StartupTime=<sec>" expired, for debugging
     */
    StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED

};

bool StartupFailure_Parse (const char *str, size_t length, StartupFailure &value);

const char* StartupFailure_Name (StartupFailure value);

bool StartupFailure_IsValid (StartupFailure value);

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_STARTUPCONTROLLERCONST_H
