/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/bosch/cm/lcm/startupcontrollerConst.h"
#include <cstddef>

/**
 * the StartupController service is used to communicate between LCM and StartupController application
 * 	The LCM informs the StartupController when all applications have been started
 */

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

bool StartupState_Parse (const char *str, size_t length, StartupState &value)
{
    static stringEntry entries[] = {
        {12,"STARTUP_DONE", 2U},
        {12,"STARTUP_INIT", 0U},
        {14,"STARTUP_ACTIVE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* StartupState_Name (StartupState value)
{
    static const char* enumerationLiterals[] = {
        "STARTUP_INIT",
        "STARTUP_ACTIVE",
        "STARTUP_DONE",
    };

    if (StartupState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool StartupState_IsValid (StartupState value)
{
    switch (value) {
    case StartupState__STARTUP_INIT:
    case StartupState__STARTUP_ACTIVE:
    case StartupState__STARTUP_DONE:
        return true;
    default:
        return false;
    }
}

bool StartupFailure_Parse (const char *str, size_t length, StartupFailure &value)
{
    static stringEntry entries[] = {
        {20,"STARTUP_FAILURE_NONE", 0U},
        {31,"STARTUP_FAILURE_SHUTDOWN_FAILED", 3U},
        {35,"STARTUP_FAILURE_STARTUPTIME_EXPIRED", 2U},
        {37,"STARTUP_FAILURE_STARTUPTIME_AVAILABLE", 1U},
        {45,"STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED", 5U},
        {47,"STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* StartupFailure_Name (StartupFailure value)
{
    static const char* enumerationLiterals[] = {
        "STARTUP_FAILURE_NONE",
        "STARTUP_FAILURE_STARTUPTIME_AVAILABLE",
        "STARTUP_FAILURE_STARTUPTIME_EXPIRED",
        "STARTUP_FAILURE_SHUTDOWN_FAILED",
        "STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE",
        "STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED",
    };

    if (StartupFailure_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool StartupFailure_IsValid (StartupFailure value)
{
    switch (value) {
    case StartupFailure__STARTUP_FAILURE_NONE:
    case StartupFailure__STARTUP_FAILURE_STARTUPTIME_AVAILABLE:
    case StartupFailure__STARTUP_FAILURE_STARTUPTIME_EXPIRED:
    case StartupFailure__STARTUP_FAILURE_SHUTDOWN_FAILED:
    case StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_AVAILABLE:
    case StartupFailure__STARTUP_FAILURE_DEBUGGING_STARTUPTIME_EXPIRED:
        return true;
    default:
        return false;
    }
}

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
