#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_STARTUPCONTROLLER_H
#define ORG_BOSCH_CM_LCM_STARTUPCONTROLLER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/lcm/startupcontrollerConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * the StartupController service is used to communicate between LCM and StartupController application
 * 	The LCM informs the StartupController when all applications have been started
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace startupcontroller {

// method IDs

// signal IDs

// property IDs
static const uint16 ID_FI_Version = 0;
static const uint16 ID_StartupStatus = 1;
static const uint16 ID_StartupFailureIndication = 2;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class StartupFailureInfo;

class FI_VersionUpdate;

class FI_VersionRegister;

class StartupStatusUpdate;

class StartupStatusRegister;

class StartupFailureIndicationUpdate;

class StartupFailureIndicationRegister;

// type definitions
/**
 * This encodes the version string of the running
 * 	    instance.
 */
typedef FI_VersionUpdate FI_VersionSet;

/**
 * This encodes the version string of the running
 * 	    instance.
 */
typedef FI_VersionUpdate FI_VersionGet;

/**
 * If the meaning of "FI_VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FI_VersionError;

/**
 * Status of the startup
 */
typedef StartupStatusUpdate StartupStatusSet;

/**
 * Status of the startup
 */
typedef StartupStatusUpdate StartupStatusGet;

/**
 * If the meaning of "StartupStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupStatusError;

/**
 * Message describes the failure of the startup
 */
typedef StartupFailureIndicationUpdate StartupFailureIndicationSet;

/**
 * Message describes the failure of the startup
 */
typedef StartupFailureIndicationUpdate StartupFailureIndicationGet;

/**
 * If the meaning of "StartupFailureIndicationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupFailureIndicationError;


/**
 * Startup failure Information struct
 */
class StartupFailureInfo {
public:

    /**
     * Default constructor
     */
    inline  StartupFailureInfo ();

    /**
     * Copy constructor
     */
    inline  StartupFailureInfo (const StartupFailureInfo &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFailureInfo (StartupState StartupStatus_, StartupFailure failure_, uint32 data_);

    /**
     * Destructor
     */
    inline  ~StartupFailureInfo();

    /**
     * Assignment operator
     */
    inline StartupFailureInfo& operator = (const StartupFailureInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFailureInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFailureInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFailureInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFailureInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupStatus"

    static const int kStartupStatus = 0;

    /**
     * Clears the field "StartupStatus".
     *
     * The field will be set to its default value. The hasStartupStatus()
     * method will return false.
     */
    inline void clearStartupStatus();

    /**
     * Checks whether the field "StartupStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupStatus()). Otherwise it will return false.
     */
    inline bool hasStartupStatus () const;

    /**
     * Returns the value of the member "StartupStatus".
     *
     * Status of the startup
     *
     * @return The value of the field "StartupStatus"
     */
    inline StartupState getStartupStatus () const;

    /**
     * Sets the value of the member "StartupStatus".
     *
     * Status of the startup
     *
     * @param StartupStatus The value which will be set
     */
    inline void setStartupStatus (StartupState StartupStatus_);

    // API of field "failure"

    static const int kFailure = 1;

    /**
     * Clears the field "failure".
     *
     * The field will be set to its default value. The hasFailure()
     * method will return false.
     */
    inline void clearFailure();

    /**
     * Checks whether the field "failure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFailure()). Otherwise it will return false.
     */
    inline bool hasFailure () const;

    /**
     * Returns the value of the member "failure".
     *
     * Startup failure
     *
     * @return The value of the field "failure"
     */
    inline StartupFailure getFailure () const;

    /**
     * Sets the value of the member "failure".
     *
     * Startup failure
     *
     * @param failure The value which will be set
     */
    inline void setFailure (StartupFailure failure_);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * Extra failure information
     *
     * @return The value of the field "data"
     */
    inline uint32 getData () const;

    /**
     * Sets the value of the member "data".
     *
     * Extra failure information
     *
     * @param data The value which will be set
     */
    inline void setData (uint32 data_);

    static const StartupFailureInfo &getDefaultInstance();

private:

    inline void set_has_StartupStatus ();

    inline void clear_has_StartupStatus ();

    inline void set_has_failure ();

    inline void clear_has_failure ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    StartupState _StartupStatus;

    StartupFailure _failure;

    uint32 _data;

};

/**
 * This encodes the version string of the running
 * 	    instance.
 */
class FI_VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  FI_VersionUpdate (const FI_VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FI_VersionUpdate (const ::std::string& FI_Version_);

    /**
     * Destructor
     */
    inline virtual  ~FI_VersionUpdate();

    /**
     * Assignment operator
     */
    inline FI_VersionUpdate& operator = (const FI_VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FI_Version"

    static const int kFI_Version = 0;

    /**
     * Clears the field "FI_Version".
     *
     * The field will be set to its default value. The hasFI_Version()
     * method will return false.
     */
    inline void clearFI_Version();

    /**
     * Checks whether the field "FI_Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFI_Version()). Otherwise it will return false.
     */
    inline bool hasFI_Version () const;

    /**
     * Returns the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    instance.
     *
     * @return The value of the field "FI_Version"
     */
    inline const ::std::string& getFI_Version () const;

    /**
     * Retrieves the value of the field "FI_Version" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FI_Version".
     */
    inline ::std::string& getFI_VersionMutable ();

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const ::std::string& FI_Version_);

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const char* FI_Version_);

    /**
     * Sets the value of the member "FI_Version".
     *
     * This encodes the version string of the running
     * 	    instance.
     *
     * @param FI_Version The value which will be set
     */
    inline void setFI_Version (const char* value, size_t size);

    static const FI_VersionUpdate &getDefaultInstance();

private:

    inline void set_has_FI_Version ();

    inline void clear_has_FI_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FI_Version;

};

/**
 * This encodes the version string of the running
 * 	    instance.
 */
class FI_VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VersionRegister ();

    /**
     * Copy constructor
     */
    inline  FI_VersionRegister (const FI_VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FI_VersionRegister();

    /**
     * Assignment operator
     */
    inline FI_VersionRegister& operator = (const FI_VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FI_VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Status of the startup
 */
class StartupStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  StartupStatusUpdate (const StartupStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StartupStatusUpdate (StartupState StartupStatus_);

    /**
     * Destructor
     */
    inline virtual  ~StartupStatusUpdate();

    /**
     * Assignment operator
     */
    inline StartupStatusUpdate& operator = (const StartupStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupStatus"

    static const int kStartupStatus = 0;

    /**
     * Clears the field "StartupStatus".
     *
     * The field will be set to its default value. The hasStartupStatus()
     * method will return false.
     */
    inline void clearStartupStatus();

    /**
     * Checks whether the field "StartupStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupStatus()). Otherwise it will return false.
     */
    inline bool hasStartupStatus () const;

    /**
     * Returns the value of the member "StartupStatus".
     *
     * Status of the startup
     *
     * @return The value of the field "StartupStatus"
     */
    inline StartupState getStartupStatus () const;

    /**
     * Sets the value of the member "StartupStatus".
     *
     * Status of the startup
     *
     * @param StartupStatus The value which will be set
     */
    inline void setStartupStatus (StartupState StartupStatus_);

    static const StartupStatusUpdate &getDefaultInstance();

private:

    inline void set_has_StartupStatus ();

    inline void clear_has_StartupStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    StartupState _StartupStatus;

};

/**
 * Status of the startup
 */
class StartupStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupStatusRegister ();

    /**
     * Copy constructor
     */
    inline  StartupStatusRegister (const StartupStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StartupStatusRegister();

    /**
     * Assignment operator
     */
    inline StartupStatusRegister& operator = (const StartupStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StartupStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Message describes the failure of the startup
 */
class StartupFailureIndicationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFailureIndicationUpdate ();

    /**
     * Copy constructor
     */
    inline  StartupFailureIndicationUpdate (const StartupFailureIndicationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFailureIndicationUpdate (const StartupFailureInfo& StartupFailureIndication_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFailureIndicationUpdate();

    /**
     * Assignment operator
     */
    inline StartupFailureIndicationUpdate& operator = (const StartupFailureIndicationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFailureIndicationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFailureIndicationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFailureIndicationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFailureIndicationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupFailureIndication"

    static const int kStartupFailureIndication = 0;

    /**
     * Clears the field "StartupFailureIndication".
     *
     * The field will be set to its default value. The hasStartupFailureIndication()
     * method will return false.
     */
    inline void clearStartupFailureIndication();

    /**
     * Checks whether the field "StartupFailureIndication" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupFailureIndication()). Otherwise it will return false.
     */
    inline bool hasStartupFailureIndication () const;

    /**
     * Returns the value of the member "StartupFailureIndication".
     *
     * Message describes the failure of the startup
     *
     * @return The value of the field "StartupFailureIndication"
     */
    inline const StartupFailureInfo& getStartupFailureIndication () const;

    /**
     * Retrieves the value of the field "StartupFailureIndication" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StartupFailureIndication".
     */
    inline StartupFailureInfo& getStartupFailureIndicationMutable ();

    /**
     * Sets the value of the member "StartupFailureIndication".
     *
     * Message describes the failure of the startup
     *
     * @param StartupFailureIndication The value which will be set
     */
    inline void setStartupFailureIndication (const StartupFailureInfo& StartupFailureIndication_);

    static const StartupFailureIndicationUpdate &getDefaultInstance();

private:

    inline void set_has_StartupFailureIndication ();

    inline void clear_has_StartupFailureIndication ();

    uint32 _has_bits_[ (1 + 31) / 32];

    StartupFailureInfo _StartupFailureIndication;

};

/**
 * Message describes the failure of the startup
 */
class StartupFailureIndicationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFailureIndicationRegister ();

    /**
     * Copy constructor
     */
    inline  StartupFailureIndicationRegister (const StartupFailureIndicationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StartupFailureIndicationRegister();

    /**
     * Assignment operator
     */
    inline StartupFailureIndicationRegister& operator = (const StartupFailureIndicationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFailureIndicationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFailureIndicationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFailureIndicationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFailureIndicationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StartupFailureIndicationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  StartupFailureInfo::StartupFailureInfo ()  :
    _StartupStatus (::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT),
    _failure (::org::bosch::cm::lcm::startupcontroller::StartupFailure__STARTUP_FAILURE_NONE),
    _data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFailureInfo::StartupFailureInfo (const StartupFailureInfo &rhs)  :
    _StartupStatus (::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT),
    _failure (::org::bosch::cm::lcm::startupcontroller::StartupFailure__STARTUP_FAILURE_NONE),
    _data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFailureInfo::StartupFailureInfo (StartupState StartupStatus_, StartupFailure failure_, uint32 data_)  :
    _StartupStatus (StartupStatus_),
    _failure (failure_),
    _data (data_)
{
    #ifndef NDEBUG
    if (!(StartupState_IsValid(StartupStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StartupStatus_, "StartupState", "StartupStatus", "StartupFailureInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(StartupFailure_IsValid(failure_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", failure_, "StartupFailure", "failure", "StartupFailureInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupFailureInfo::~StartupFailureInfo() {
}

inline StartupFailureInfo& StartupFailureInfo::operator = (const StartupFailureInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStartupStatus()) {
            setStartupStatus(rhs.getStartupStatus());
        } else {
            clearStartupStatus();
        }
        if (rhs.hasFailure()) {
            setFailure(rhs.getFailure());
        } else {
            clearFailure();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool StartupFailureInfo::operator == (const StartupFailureInfo& rhs) const {
    return (((!hasStartupStatus() && !rhs.hasStartupStatus()) || getStartupStatus() == rhs.getStartupStatus()) &&
        ((!hasFailure() && !rhs.hasFailure()) || getFailure() == rhs.getFailure()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool StartupFailureInfo::operator != (const StartupFailureInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFailureInfo::operator < (const StartupFailureInfo& rhs) const {
    if (hasStartupStatus() || rhs.hasStartupStatus()) {
        if ((uint32)getStartupStatus() < (uint32)rhs.getStartupStatus()) return true;
        if ((uint32)getStartupStatus() > (uint32)rhs.getStartupStatus()) return false;
    }
    if (hasFailure() || rhs.hasFailure()) {
        if ((uint32)getFailure() < (uint32)rhs.getFailure()) return true;
        if ((uint32)getFailure() > (uint32)rhs.getFailure()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline bool StartupFailureInfo::operator > (const StartupFailureInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFailureInfo::clear() {
    clearStartupStatus();
    clearFailure();
    clearData();
}

inline void StartupFailureInfo::clearStartupStatus() {
    if (hasStartupStatus()) {
         clear_has_StartupStatus();
        _StartupStatus = ::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT;
     }
}

inline bool StartupFailureInfo::hasStartupStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline StartupState StartupFailureInfo::getStartupStatus () const {
    return _StartupStatus;
}

inline void StartupFailureInfo::setStartupStatus (StartupState StartupStatus_) {
    #ifndef NDEBUG
    if (!(StartupState_IsValid(StartupStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StartupStatus_, "StartupState", "StartupStatus", "StartupFailureInfo");
    }
    #endif
    set_has_StartupStatus();
    this->_StartupStatus = StartupStatus_;
}

inline void StartupFailureInfo::clearFailure() {
    if (hasFailure()) {
         clear_has_failure();
        _failure = ::org::bosch::cm::lcm::startupcontroller::StartupFailure__STARTUP_FAILURE_NONE;
     }
}

inline bool StartupFailureInfo::hasFailure () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline StartupFailure StartupFailureInfo::getFailure () const {
    return _failure;
}

inline void StartupFailureInfo::setFailure (StartupFailure failure_) {
    #ifndef NDEBUG
    if (!(StartupFailure_IsValid(failure_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", failure_, "StartupFailure", "failure", "StartupFailureInfo");
    }
    #endif
    set_has_failure();
    this->_failure = failure_;
}

inline void StartupFailureInfo::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = 0u;
     }
}

inline bool StartupFailureInfo::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartupFailureInfo::getData () const {
    return _data;
}

inline void StartupFailureInfo::setData (uint32 data_) {
    set_has_data();
    this->_data = data_;
}

inline void StartupFailureInfo::set_has_StartupStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupFailureInfo::clear_has_StartupStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartupFailureInfo::set_has_failure () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartupFailureInfo::clear_has_failure () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartupFailureInfo::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartupFailureInfo::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FI_VersionUpdate::FI_VersionUpdate ()  :
    _FI_Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_VersionUpdate::FI_VersionUpdate (const FI_VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _FI_Version ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_VersionUpdate::FI_VersionUpdate (const ::std::string& FI_Version_)  :
    _FI_Version (FI_Version_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FI_VersionUpdate::~FI_VersionUpdate() {
}

inline FI_VersionUpdate& FI_VersionUpdate::operator = (const FI_VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFI_Version()) {
            setFI_Version(rhs.getFI_Version());
        } else {
            clearFI_Version();
        }
    }
    return *this;
}

inline bool FI_VersionUpdate::operator == (const FI_VersionUpdate& rhs) const {
    return (((!hasFI_Version() && !rhs.hasFI_Version()) || getFI_Version() == rhs.getFI_Version()));
}

inline bool FI_VersionUpdate::operator != (const FI_VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_VersionUpdate::operator < (const FI_VersionUpdate& rhs) const {
    if (hasFI_Version() || rhs.hasFI_Version()) {
        if (getFI_Version() < rhs.getFI_Version()) return true;
        if (getFI_Version() > rhs.getFI_Version()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FI_VersionUpdate::clone() {
    return new FI_VersionUpdate(*this);
}

inline bool FI_VersionUpdate::operator > (const FI_VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_VersionUpdate::clear() {
    clearFI_Version();
}

inline void FI_VersionUpdate::clearFI_Version() {
    if (hasFI_Version()) {
         clear_has_FI_Version();
        _FI_Version.clear();
     }
}

inline bool FI_VersionUpdate::hasFI_Version () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FI_VersionUpdate::getFI_Version () const {
    return _FI_Version;
}

inline ::std::string& FI_VersionUpdate::getFI_VersionMutable () {
    set_has_FI_Version();
    return _FI_Version;
}

inline void FI_VersionUpdate::setFI_Version (const ::std::string& FI_Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version = FI_Version_;
}

inline void FI_VersionUpdate::setFI_Version (const char* FI_Version_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FI_Version_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version.assign(FI_Version_);
}

inline void FI_VersionUpdate::setFI_Version (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FI_Version();
    this->_FI_Version.assign(value, size);
}

inline void FI_VersionUpdate::set_has_FI_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void FI_VersionUpdate::clear_has_FI_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FI_VersionRegister::FI_VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_VersionRegister::FI_VersionRegister (const FI_VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_VersionRegister::~FI_VersionRegister() {
}

inline FI_VersionRegister& FI_VersionRegister::operator = (const FI_VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FI_VersionRegister::operator == (const FI_VersionRegister& ) const {
    return true;
}

inline bool FI_VersionRegister::operator != (const FI_VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_VersionRegister::operator < (const FI_VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FI_VersionRegister::clone() {
    return new FI_VersionRegister(*this);
}

inline bool FI_VersionRegister::operator > (const FI_VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_VersionRegister::clear() {
}

inline  StartupStatusUpdate::StartupStatusUpdate ()  :
    _StartupStatus (::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupStatusUpdate::StartupStatusUpdate (const StartupStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _StartupStatus (::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupStatusUpdate::StartupStatusUpdate (StartupState StartupStatus_)  :
    _StartupStatus (StartupStatus_)
{
    #ifndef NDEBUG
    if (!(StartupState_IsValid(StartupStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StartupStatus_, "StartupState", "StartupStatus", "StartupStatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupStatusUpdate::~StartupStatusUpdate() {
}

inline StartupStatusUpdate& StartupStatusUpdate::operator = (const StartupStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStartupStatus()) {
            setStartupStatus(rhs.getStartupStatus());
        } else {
            clearStartupStatus();
        }
    }
    return *this;
}

inline bool StartupStatusUpdate::operator == (const StartupStatusUpdate& rhs) const {
    return (((!hasStartupStatus() && !rhs.hasStartupStatus()) || getStartupStatus() == rhs.getStartupStatus()));
}

inline bool StartupStatusUpdate::operator != (const StartupStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupStatusUpdate::operator < (const StartupStatusUpdate& rhs) const {
    if (hasStartupStatus() || rhs.hasStartupStatus()) {
        if ((uint32)getStartupStatus() < (uint32)rhs.getStartupStatus()) return true;
        if ((uint32)getStartupStatus() > (uint32)rhs.getStartupStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartupStatusUpdate::clone() {
    return new StartupStatusUpdate(*this);
}

inline bool StartupStatusUpdate::operator > (const StartupStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupStatusUpdate::clear() {
    clearStartupStatus();
}

inline void StartupStatusUpdate::clearStartupStatus() {
    if (hasStartupStatus()) {
         clear_has_StartupStatus();
        _StartupStatus = ::org::bosch::cm::lcm::startupcontroller::StartupState__STARTUP_INIT;
     }
}

inline bool StartupStatusUpdate::hasStartupStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline StartupState StartupStatusUpdate::getStartupStatus () const {
    return _StartupStatus;
}

inline void StartupStatusUpdate::setStartupStatus (StartupState StartupStatus_) {
    #ifndef NDEBUG
    if (!(StartupState_IsValid(StartupStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StartupStatus_, "StartupState", "StartupStatus", "StartupStatusUpdate");
    }
    #endif
    set_has_StartupStatus();
    this->_StartupStatus = StartupStatus_;
}

inline void StartupStatusUpdate::set_has_StartupStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupStatusUpdate::clear_has_StartupStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartupStatusRegister::StartupStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupStatusRegister::StartupStatusRegister (const StartupStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupStatusRegister::~StartupStatusRegister() {
}

inline StartupStatusRegister& StartupStatusRegister::operator = (const StartupStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StartupStatusRegister::operator == (const StartupStatusRegister& ) const {
    return true;
}

inline bool StartupStatusRegister::operator != (const StartupStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupStatusRegister::operator < (const StartupStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StartupStatusRegister::clone() {
    return new StartupStatusRegister(*this);
}

inline bool StartupStatusRegister::operator > (const StartupStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupStatusRegister::clear() {
}

inline  StartupFailureIndicationUpdate::StartupFailureIndicationUpdate ()  :
    _StartupFailureIndication ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFailureIndicationUpdate::StartupFailureIndicationUpdate (const StartupFailureIndicationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _StartupFailureIndication ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFailureIndicationUpdate::StartupFailureIndicationUpdate (const StartupFailureInfo& StartupFailureIndication_)  :
    _StartupFailureIndication (StartupFailureIndication_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupFailureIndicationUpdate::~StartupFailureIndicationUpdate() {
}

inline StartupFailureIndicationUpdate& StartupFailureIndicationUpdate::operator = (const StartupFailureIndicationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStartupFailureIndication()) {
            setStartupFailureIndication(rhs.getStartupFailureIndication());
        } else {
            clearStartupFailureIndication();
        }
    }
    return *this;
}

inline bool StartupFailureIndicationUpdate::operator == (const StartupFailureIndicationUpdate& rhs) const {
    return (((!hasStartupFailureIndication() && !rhs.hasStartupFailureIndication()) || getStartupFailureIndication() == rhs.getStartupFailureIndication()));
}

inline bool StartupFailureIndicationUpdate::operator != (const StartupFailureIndicationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFailureIndicationUpdate::operator < (const StartupFailureIndicationUpdate& rhs) const {
    if (hasStartupFailureIndication() || rhs.hasStartupFailureIndication()) {
        if (getStartupFailureIndication() < rhs.getStartupFailureIndication()) return true;
        if (getStartupFailureIndication() > rhs.getStartupFailureIndication()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartupFailureIndicationUpdate::clone() {
    return new StartupFailureIndicationUpdate(*this);
}

inline bool StartupFailureIndicationUpdate::operator > (const StartupFailureIndicationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFailureIndicationUpdate::clear() {
    clearStartupFailureIndication();
}

inline void StartupFailureIndicationUpdate::clearStartupFailureIndication() {
    if (hasStartupFailureIndication()) {
         clear_has_StartupFailureIndication();
        _StartupFailureIndication.clear();
     }
}

inline bool StartupFailureIndicationUpdate::hasStartupFailureIndication () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const StartupFailureInfo& StartupFailureIndicationUpdate::getStartupFailureIndication () const {
    return _StartupFailureIndication;
}

inline StartupFailureInfo& StartupFailureIndicationUpdate::getStartupFailureIndicationMutable () {
    set_has_StartupFailureIndication();
    return _StartupFailureIndication;
}

inline void StartupFailureIndicationUpdate::setStartupFailureIndication (const StartupFailureInfo& StartupFailureIndication_) {
    set_has_StartupFailureIndication();
    this->_StartupFailureIndication = StartupFailureIndication_;
}

inline void StartupFailureIndicationUpdate::set_has_StartupFailureIndication () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupFailureIndicationUpdate::clear_has_StartupFailureIndication () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartupFailureIndicationRegister::StartupFailureIndicationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFailureIndicationRegister::StartupFailureIndicationRegister (const StartupFailureIndicationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFailureIndicationRegister::~StartupFailureIndicationRegister() {
}

inline StartupFailureIndicationRegister& StartupFailureIndicationRegister::operator = (const StartupFailureIndicationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StartupFailureIndicationRegister::operator == (const StartupFailureIndicationRegister& ) const {
    return true;
}

inline bool StartupFailureIndicationRegister::operator != (const StartupFailureIndicationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFailureIndicationRegister::operator < (const StartupFailureIndicationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StartupFailureIndicationRegister::clone() {
    return new StartupFailureIndicationRegister(*this);
}

inline bool StartupFailureIndicationRegister::operator > (const StartupFailureIndicationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFailureIndicationRegister::clear() {
}

} // namespace startupcontroller
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_STARTUPCONTROLLER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
