/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "spm_core_fi_types.h"
#include "spm_core_fi_typesConst.h"
#include "spm_core_fi_typesJson.h"
#include "spm_core_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "TTimeDate"

void serializeJson (const ::spm_core_fi_types::TTimeDate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "s16Year" , 7);
        yajl_gen_integer(g, (long long)value.getS16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hour" , 6);
        yajl_gen_integer(g, (long long)value.getU8Hour());
    }
    if (!isSparse || value.hasU8Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minute" , 8);
        yajl_gen_integer(g, (long long)value.getU8Minute());
    }
    if (!isSparse || value.hasU8Second()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Second" , 8);
        yajl_gen_integer(g, (long long)value.getU8Second());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::TTimeDate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TSwVersionInfo"

void serializeJson (const ::spm_core_fi_types::TSwVersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSwBuildVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwBuildVersion" , 15);
        const char *s = value.getTSwBuildVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTSwCustomerVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwCustomerVersion" , 18);
        const char *s = value.getTSwCustomerVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::TSwVersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_SubState0"

void serializeJson (const ::spm_core_fi_types::T_b32_SubState0& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_e32_SET_SD_CARD_ACCESS()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SET_SD_CARD_ACCESS" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SET_SD_CARD_ACCESS());
    }
    if (value.getSPM_e32_EMERGENCY_OFF()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_EMERGENCY_OFF" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_EMERGENCY_OFF());
    }
    if (value.getSPM_e32_FAST_SHUTDOWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FAST_SHUTDOWN" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FAST_SHUTDOWN());
    }
    if (value.getSPM_e32_DIMMING()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DIMMING" , 15);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DIMMING());
    }
    if (value.getSPM_e32_DOWNLOAD()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DOWNLOAD" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DOWNLOAD());
    }
    if (value.getSPM_e32_DIAG_ACTIVITY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DIAG_ACTIVITY" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DIAG_ACTIVITY());
    }
    if (value.getSPM_e32_DIAGNOSIS()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DIAGNOSIS" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DIAGNOSIS());
    }
    if (value.getSPM_e32_PHONE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_PHONE" , 13);
        yajl_gen_bool(g, (bool)value.getSPM_e32_PHONE());
    }
    if (value.getSPM_e32_ACCESSORY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ACCESSORY" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ACCESSORY());
    }
    if (value.getSPM_e32_IGNITION()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_IGNITION" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_IGNITION());
    }
    if (value.getSPM_e32_TRANSPORTMODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TRANSPORTMODE" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TRANSPORTMODE());
    }
    if (value.getSPM_e32_DOOROPEN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DOOROPEN" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DOOROPEN());
    }
    if (value.getSPM_e32_DOORLOCK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DOORLOCK" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DOORLOCK());
    }
    if (value.getSPM_e32_TRIGGER_FORCE_ON()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TRIGGER_FORCE_ON" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TRIGGER_FORCE_ON());
    }
    if (value.getSPM_e32_CLIMATE_INFO()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CLIMATE_INFO" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CLIMATE_INFO());
    }
    if (value.getSPM_e32_PARK_DISTANCE_CTRL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_PARK_DISTANCE_CTRL" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_e32_PARK_DISTANCE_CTRL());
    }
    if (value.getSPM_e32_FACTORY_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FACTORY_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FACTORY_MODE());
    }
    if (value.getSPM_e32_CD_INSERT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CD_INSERT" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CD_INSERT());
    }
    if (value.getSPM_e32_SD_INSERT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SD_INSERT" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SD_INSERT());
    }
    if (value.getSPM_e32_EJECT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_EJECT" , 13);
        yajl_gen_bool(g, (bool)value.getSPM_e32_EJECT());
    }
    if (value.getSPM_e32_ON_TIPPER()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ON_TIPPER" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ON_TIPPER());
    }
    if (value.getSPM_e32_SOFTTOP_OPEN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SOFTTOP_OPEN" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SOFTTOP_OPEN());
    }
    if (value.getSPM_e32_AIRBAG_DEPLOYED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_AIRBAG_DEPLOYED" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_AIRBAG_DEPLOYED());
    }
    if (value.getSPM_e32_KEY_PRESENT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_KEY_PRESENT" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_KEY_PRESENT());
    }
    if (value.getSPM_e32_NETWORK_ACTIVITY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_NETWORK_ACTIVITY" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_NETWORK_ACTIVITY());
    }
    if (value.getSPM_e32_OFF_TIPPER()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_OFF_TIPPER" , 18);
        yajl_gen_bool(g, (bool)value.getSPM_e32_OFF_TIPPER());
    }
    if (value.getSPM_e32_OFF_LASTSTATE_CYCLE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_OFF_LASTSTATE_CYCLE" , 27);
        yajl_gen_bool(g, (bool)value.getSPM_e32_OFF_LASTSTATE_CYCLE());
    }
    if (value.getSPM_e32_DIAG_REQUEST()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DIAG_REQUEST" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DIAG_REQUEST());
    }
    if (value.getSPM_e32_BACKLIGHT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_BACKLIGHT" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_BACKLIGHT());
    }
    if (value.getSPM_e32_HIGH_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_HIGH_VOLTAGE" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_HIGH_VOLTAGE());
    }
    if (value.getSPM_e32_RCV_CONNECTED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_RCV_CONNECTED" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_RCV_CONNECTED());
    }
    if (value.getSPM_e32_OFF_LEARN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_OFF_LEARN" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_OFF_LEARN());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_b32_SubState0& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_SubState1"

void serializeJson (const ::spm_core_fi_types::T_b32_SubState1& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_e32_HEARTBEAT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_HEARTBEAT" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_HEARTBEAT());
    }
    if (value.getSPM_e32_USER_ON_REQ()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_USER_ON_REQ" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_USER_ON_REQ());
    }
    if (value.getSPM_e32_BACKGROUND_ON_REQ()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_BACKGROUND_ON_REQ" , 25);
        yajl_gen_bool(g, (bool)value.getSPM_e32_BACKGROUND_ON_REQ());
    }
    if (value.getSPM_e32_MULTIMEDIA_ON()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MULTIMEDIA_ON" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MULTIMEDIA_ON());
    }
    if (value.getSPM_e32_ANIMATION()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ANIMATION" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ANIMATION());
    }
    if (value.getSPM_e32_MULTIMEDIA_OPERATION()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MULTIMEDIA_OPERATION" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MULTIMEDIA_OPERATION());
    }
    if (value.getSPM_e32_TELEMATIC_ACTIVE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TELEMATIC_ACTIVE" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TELEMATIC_ACTIVE());
    }
    if (value.getSPM_e32_STANDBY_REQ()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_STANDBY_REQ" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_STANDBY_REQ());
    }
    if (value.getSPM_e32_ACCESSORY_ACTIVE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ACCESSORY_ACTIVE" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ACCESSORY_ACTIVE());
    }
    if (value.getSPM_e32_SHUTDOWN_BATTERY_SAVING()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SHUTDOWN_BATTERY_SAVING" , 31);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SHUTDOWN_BATTERY_SAVING());
    }
    if (value.getSPM_e32_TML_REQ_BACKGROUND()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TML_REQ_BACKGROUND" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TML_REQ_BACKGROUND());
    }
    if (value.getSPM_e32_IGNITION_TIMEOUT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_IGNITION_TIMEOUT" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_IGNITION_TIMEOUT());
    }
    if (value.getSPM_e32_IGNITION_INVALID()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_IGNITION_INVALID" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_IGNITION_INVALID());
    }
    if (value.getSPM_e32_FIRST_PIC_DRAWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FIRST_PIC_DRAWN" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FIRST_PIC_DRAWN());
    }
    if (value.getSPM_e32_OVERTEMP()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_OVERTEMP" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_OVERTEMP());
    }
    if (value.getSPM_e32_LOCK_ACTIVITY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_LOCK_ACTIVITY" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_LOCK_ACTIVITY());
    }
    if (value.getSPM_e32_SYSSTATE_CHECK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SYSSTATE_CHECK" , 22);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SYSSTATE_CHECK());
    }
    if (value.getSPM_e32_CR_TEMPERATURE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CR_TEMPERATURE" , 22);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CR_TEMPERATURE());
    }
    if (value.getSPM_e32_PUSH_TO_TALK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_PUSH_TO_TALK" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_PUSH_TO_TALK());
    }
    if (value.getSPM_e32_ROUTEGUIDANCE_ACTIVE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ROUTEGUIDANCE_ACTIVE" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ROUTEGUIDANCE_ACTIVE());
    }
    if (value.getSPM_e32_HW_IGNITION()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_HW_IGNITION" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_HW_IGNITION());
    }
    if (value.getSPM_e32_CAN_WAKEUP()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CAN_WAKEUP" , 18);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CAN_WAKEUP());
    }
    if (value.getSPM_e32_DOWNLOAD_PERMISSION()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DOWNLOAD_PERMISSION" , 27);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DOWNLOAD_PERMISSION());
    }
    if (value.getSPM_e32_IGNITION_LOGIC()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_IGNITION_LOGIC" , 22);
        yajl_gen_bool(g, (bool)value.getSPM_e32_IGNITION_LOGIC());
    }
    if (value.getSPM_e32_LOW_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_LOW_VOLTAGE" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_LOW_VOLTAGE());
    }
    if (value.getSPM_e32_STATE_DEBOUNCE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_STATE_DEBOUNCE" , 22);
        yajl_gen_bool(g, (bool)value.getSPM_e32_STATE_DEBOUNCE());
    }
    if (value.getSPM_e32_NETWORK_FAILURE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_NETWORK_FAILURE" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_NETWORK_FAILURE());
    }
    if (value.getSPM_e32_STATE_TO()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_STATE_TO" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_STATE_TO());
    }
    if (value.getSPM_e32_DEBUG_WAKEUP()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DEBUG_WAKEUP" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DEBUG_WAKEUP());
    }
    if (value.getSPM_e32_AUTOMATIC()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_AUTOMATIC" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_AUTOMATIC());
    }
    if (value.getSPM_e32_CODE_REQUEST()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CODE_REQUEST" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CODE_REQUEST());
    }
    if (value.getSPM_e32_SYNC_SHUTDOWN_ACK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SYNC_SHUTDOWN_ACK" , 25);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SYNC_SHUTDOWN_ACK());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_b32_SubState1& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_SubState2"

void serializeJson (const ::spm_core_fi_types::T_b32_SubState2& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_e32_FRIENDLY_USER()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FRIENDLY_USER" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FRIENDLY_USER());
    }
    if (value.getSPM_e32_NISSAN_CMF1()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_NISSAN_CMF1" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_NISSAN_CMF1());
    }
    if (value.getSPM_e32_PREPARE_SHUTDOWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_PREPARE_SHUTDOWN" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_PREPARE_SHUTDOWN());
    }
    if (value.getSPM_e32_SHUTDOWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SHUTDOWN" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SHUTDOWN());
    }
    if (value.getSPM_e32_HKEY_PRESSED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_HKEY_PRESSED" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_HKEY_PRESSED());
    }
    if (value.getSPM_e32_CD_INSERT_CLAMPS()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CD_INSERT_CLAMPS" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CD_INSERT_CLAMPS());
    }
    if (value.getSPM_e32_CRITICAL_LOW_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CRITICAL_LOW_VOLTAGE" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CRITICAL_LOW_VOLTAGE());
    }
    if (value.getSPM_e32_ENDURING_LOW_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ENDURING_LOW_VOLTAGE" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ENDURING_LOW_VOLTAGE());
    }
    if (value.getSPM_e32_DIAG_FAST_SHUTDOWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_DIAG_FAST_SHUTDOWN" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_e32_DIAG_FAST_SHUTDOWN());
    }
    if (value.getSPM_e32_USING_ACCESSORY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_USING_ACCESSORY" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_USING_ACCESSORY());
    }
    if (value.getSPM_e32_BACKGROUND_IMM_OFF()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_BACKGROUND_IMM_OFF" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_e32_BACKGROUND_IMM_OFF());
    }
    if (value.getSPM_e32_ROLLER_RIG_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ROLLER_RIG_MODE" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ROLLER_RIG_MODE());
    }
    if (value.getSPM_e32_REMOTE_ON_ACTIVE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_REMOTE_ON_ACTIVE" , 24);
        yajl_gen_bool(g, (bool)value.getSPM_e32_REMOTE_ON_ACTIVE());
    }
    if (value.getSPM_e32_ENDURING_CR_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ENDURING_CR_VOLTAGE" , 27);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ENDURING_CR_VOLTAGE());
    }
    if (value.getSPM_e32_NORMAL_VOLT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_NORMAL_VOLT" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_NORMAL_VOLT());
    }
    if (value.getSPM_e32_Q_CRITICAL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_Q_CRITICAL" , 18);
        yajl_gen_bool(g, (bool)value.getSPM_e32_Q_CRITICAL());
    }
    if (value.getSPM_e32_TRIGGER_RESET()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TRIGGER_RESET" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TRIGGER_RESET());
    }
    if (value.getSPM_e32_CAR_WAKEUP()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CAR_WAKEUP" , 18);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CAR_WAKEUP());
    }
    if (value.getSPM_e32_PHONE_CONNECTED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_PHONE_CONNECTED" , 23);
        yajl_gen_bool(g, (bool)value.getSPM_e32_PHONE_CONNECTED());
    }
    if (value.getSPM_e32_CUSTOMER_DOWNLOAD()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CUSTOMER_DOWNLOAD" , 25);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CUSTOMER_DOWNLOAD());
    }
    if (value.getSPM_e32_STARTUP()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_STARTUP" , 15);
        yajl_gen_bool(g, (bool)value.getSPM_e32_STARTUP());
    }
    if (value.getSPM_e32_MOST_OFF()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_OFF" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_OFF());
    }
    if (value.getSPM_e32_MOST_OFF_ERR()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_OFF_ERR" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_OFF_ERR());
    }
    if (value.getSPM_e32_MOST_WAIT_FOR_SHUTDOWN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_WAIT_FOR_SHUTDOWN" , 30);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_WAIT_FOR_SHUTDOWN());
    }
    if (value.getSPM_e32_MOST_RBD()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_RBD" , 16);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_RBD());
    }
    if (value.getSPM_e32_MOST_SHUTDOWN_EXECUTE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_SHUTDOWN_EXECUTE" , 29);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_SHUTDOWN_EXECUTE());
    }
    if (value.getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY" , 33);
        yajl_gen_bool(g, (bool)value.getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY());
    }
    if (value.getSPM_e32_SYSSTATE_NETWORK_FAILED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SYSSTATE_NETWORK_FAILED" , 31);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SYSSTATE_NETWORK_FAILED());
    }
    if (value.getSPM_e32_SAFE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_SAFE" , 12);
        yajl_gen_bool(g, (bool)value.getSPM_e32_SAFE());
    }
    if (value.getSPM_e32_FSM_SHUTDOWN_FINISHED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FSM_SHUTDOWN_FINISHED" , 29);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FSM_SHUTDOWN_FINISHED());
    }
    if (value.getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK" , 33);
        yajl_gen_bool(g, (bool)value.getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK());
    }
    if (value.getSPM_e32_WAIT_FOR_FSM_RESTART_ACK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_WAIT_FOR_FSM_RESTART_ACK" , 32);
        yajl_gen_bool(g, (bool)value.getSPM_e32_WAIT_FOR_FSM_RESTART_ACK());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_b32_SubState2& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_SubState3"

void serializeJson (const ::spm_core_fi_types::T_b32_SubState3& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_e32_VALET_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_VALET_MODE" , 18);
        yajl_gen_bool(g, (bool)value.getSPM_e32_VALET_MODE());
    }
    if (value.getSPM_e32_CRANK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CRANK" , 13);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CRANK());
    }
    if (value.getSPM_e32_EMERGENCY_CALL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_EMERGENCY_CALL" , 22);
        yajl_gen_bool(g, (bool)value.getSPM_e32_EMERGENCY_CALL());
    }
    if (value.getSPM_e32_LIN()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_LIN" , 11);
        yajl_gen_bool(g, (bool)value.getSPM_e32_LIN());
    }
    if (value.getSPM_e32_CELLNETWORK()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CELLNETWORK" , 19);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CELLNETWORK());
    }
    if (value.getSPM_e32_EXTERNAL_GPIO()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_EXTERNAL_GPIO" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_EXTERNAL_GPIO());
    }
    if (value.getSPM_e32_BLUETOOTH()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_BLUETOOTH" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_BLUETOOTH());
    }
    if (value.getSPM_e32_UART()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_UART" , 12);
        yajl_gen_bool(g, (bool)value.getSPM_e32_UART());
    }
    if (value.getSPM_e32_USB()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_USB" , 11);
        yajl_gen_bool(g, (bool)value.getSPM_e32_USB());
    }
    if (value.getSPM_e32_CRITICAL_HIGH_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_CRITICAL_HIGH_VOLTAGE" , 29);
        yajl_gen_bool(g, (bool)value.getSPM_e32_CRITICAL_HIGH_VOLTAGE());
    }
    if (value.getSPM_e32_ENDURING_HIGH_VOLTAGE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ENDURING_HIGH_VOLTAGE" , 29);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ENDURING_HIGH_VOLTAGE());
    }
    if (value.getSPM_e32_OVER_THE_AIR()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_OVER_THE_AIR" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_e32_OVER_THE_AIR());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_b32_SubState3& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_b32_DIM_STATE"

void serializeJson (const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_U32_DIMMINGSTATE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE" , 20);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE());
    }
    if (value.getSPM_U32_DIMSMINGTATE_CLIMATE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMSMINGTATE_CLIMATE" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMSMINGTATE_CLIMATE());
    }
    if (value.getSPM_U32_DIMMINGSTATE_BACKLIGHT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE_BACKLIGHT" , 30);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE_BACKLIGHT());
    }
    if (value.getSPM_U32_DIMMINGSTATE_HOUR_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE_HOUR_MODE" , 30);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE_HOUR_MODE());
    }
    if (value.getSPM_U32_DIMMINGSTATE_ALL_OFF()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE_ALL_OFF" , 28);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE_ALL_OFF());
    }
    if (value.getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF" , 42);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF());
    }
    if (value.getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED" , 49);
        yajl_gen_bool(g, (bool)value.getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED());
    }
    if (value.getSPM_U32DIMMINGSTATE_ALL_ON()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_U32DIMMINGSTATE_ALL_ON" , 26);
        yajl_gen_bool(g, (bool)value.getSPM_U32DIMMINGSTATE_ALL_ON());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_HistoryTrigger"

void serializeJson (const ::spm_core_fi_types::T_SPM_HistoryTrigger& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Timestamp()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Timestamp" , 12);
        yajl_gen_integer(g, (long long)value.getU32Timestamp());
    }
    if (!isSparse || value.hasETriggerType()) {
        yajl_gen_string(g, (const unsigned char*)  "eTriggerType" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SubStateType_Name(value.getETriggerType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getETriggerType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_HistoryTrigger& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_TransPortMode"

void serializeJson (const ::spm_core_fi_types::T_SPM_TransPortMode& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasYEAR()) {
        yajl_gen_string(g, (const unsigned char*)  "YEAR" , 4);
        yajl_gen_integer(g, (long long)value.getYEAR());
    }
    if (!isSparse || value.hasMONTH()) {
        yajl_gen_string(g, (const unsigned char*)  "MONTH" , 5);
        yajl_gen_integer(g, (long long)value.getMONTH());
    }
    if (!isSparse || value.hasDAY()) {
        yajl_gen_string(g, (const unsigned char*)  "DAY" , 3);
        yajl_gen_integer(g, (long long)value.getDAY());
    }
    if (!isSparse || value.hasHOUR()) {
        yajl_gen_string(g, (const unsigned char*)  "HOUR" , 4);
        yajl_gen_integer(g, (long long)value.getHOUR());
    }
    if (!isSparse || value.hasMINUTE()) {
        yajl_gen_string(g, (const unsigned char*)  "MINUTE" , 6);
        yajl_gen_integer(g, (long long)value.getMINUTE());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_TransPortMode& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SubStateEntry"

void serializeJson (const ::spm_core_fi_types::T_SubStateEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSubStateMask0()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateMask0" , 14);
        serializeJson(value.getTSubStateMask0(), g, options);
    }
    if (!isSparse || value.hasTSubStateData0()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateData0" , 14);
        serializeJson(value.getTSubStateData0(), g, options);
    }
    if (!isSparse || value.hasTSubStateMask1()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateMask1" , 14);
        serializeJson(value.getTSubStateMask1(), g, options);
    }
    if (!isSparse || value.hasTSubStateData1()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateData1" , 14);
        serializeJson(value.getTSubStateData1(), g, options);
    }
    if (!isSparse || value.hasTSubStateMask2()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateMask2" , 14);
        serializeJson(value.getTSubStateMask2(), g, options);
    }
    if (!isSparse || value.hasTSubStateData2()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateData2" , 14);
        serializeJson(value.getTSubStateData2(), g, options);
    }
    if (!isSparse || value.hasTSubStateMask3()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateMask3" , 14);
        serializeJson(value.getTSubStateMask3(), g, options);
    }
    if (!isSparse || value.hasTSubStateData3()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStateData3" , 14);
        serializeJson(value.getTSubStateData3(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SubStateEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ProcessElement"

void serializeJson (const ::spm_core_fi_types::T_ProcessElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTProcessName()) {
        yajl_gen_string(g, (const unsigned char*)  "tProcessName" , 12);
        const char *s = value.getTProcessName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTConfiguredProcessName()) {
        yajl_gen_string(g, (const unsigned char*)  "tConfiguredProcessName" , 22);
        const char *s = value.getTConfiguredProcessName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEProcState()) {
        yajl_gen_string(g, (const unsigned char*)  "eProcState" , 10);
        const char* s = ::spm_core_fi_types::T_e8_ProcessState_Name(value.getEProcState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEProcState());
    }
    if (!isSparse || value.hasU32StartTimeSinceStart()) {
        yajl_gen_string(g, (const unsigned char*)  "u32StartTimeSinceStart" , 22);
        yajl_gen_integer(g, (long long)value.getU32StartTimeSinceStart());
    }
    if (!isSparse || value.hasTSwitchOnDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwitchOnDate" , 13);
        serializeJson(value.getTSwitchOnDate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_ProcessElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ResetElement"

void serializeJson (const ::spm_core_fi_types::T_ResetElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTResetDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tResetDate" , 10);
        serializeJson(value.getTResetDate(), g, options);
    }
    if (!isSparse || value.hasTSwVersionInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwVersionInfo" , 14);
        serializeJson(value.getTSwVersionInfo(), g, options);
    }
    if (!isSparse || value.hasEReset()) {
        yajl_gen_string(g, (const unsigned char*)  "eReset" , 6);
        const char* s = ::spm_core_fi_types::T_e8_LcmResetReason_Name(value.getEReset());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEReset());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_ResetElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_WakeupElement"

void serializeJson (const ::spm_core_fi_types::T_WakeupElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTWakeupDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tWakeupDate" , 11);
        serializeJson(value.getTWakeupDate(), g, options);
    }
    if (!isSparse || value.hasEWakeupReason()) {
        yajl_gen_string(g, (const unsigned char*)  "eWakeupReason" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON_Name(value.getEWakeupReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEWakeupReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_WakeupElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_StateChangeElement"

void serializeJson (const ::spm_core_fi_types::T_StateChangeElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTWakeupDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tWakeupDate" , 11);
        serializeJson(value.getTWakeupDate(), g, options);
    }
    if (!isSparse || value.hasTSysState()) {
        yajl_gen_string(g, (const unsigned char*)  "tSysState" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_Name(value.getTSysState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTSysState());
    }
    if (!isSparse || value.hasTElemType()) {
        yajl_gen_string(g, (const unsigned char*)  "tElemType" , 9);
        const char* s = ::spm_core_fi_types::T_e8_StateEntryType_Name(value.getTElemType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTElemType());
    }
    if (!isSparse || value.hasTWakeup()) {
        yajl_gen_string(g, (const unsigned char*)  "tWakeup" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON_Name(value.getTWakeup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTWakeup());
    }
    if (!isSparse || value.hasTReset()) {
        yajl_gen_string(g, (const unsigned char*)  "tReset" , 6);
        const char* s = ::spm_core_fi_types::T_e8_LcmResetReason_Name(value.getTReset());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTReset());
    }
    if (!isSparse || value.hasTSubStates()) {
        yajl_gen_string(g, (const unsigned char*)  "tSubStates" , 10);
        serializeJson(value.getTSubStates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_StateChangeElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SwitchOnElement"

void serializeJson (const ::spm_core_fi_types::T_SwitchOnElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSwitchOnDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwitchOnDate" , 13);
        serializeJson(value.getTSwitchOnDate(), g, options);
    }
    if (!isSparse || value.hasESwitchOnReason()) {
        yajl_gen_string(g, (const unsigned char*)  "eSwitchOnReason" , 15);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SubStateType_Name(value.getESwitchOnReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getESwitchOnReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SwitchOnElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_b32_SYSPWRSAVEMODE"

void serializeJson (const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSPM_e32_TRANSPORTMODE()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_TRANSPORTMODE" , 21);
        yajl_gen_bool(g, (bool)value.getSPM_e32_TRANSPORTMODE());
    }
    if (value.getSPM_e32_ROLLER()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_ROLLER" , 14);
        yajl_gen_bool(g, (bool)value.getSPM_e32_ROLLER());
    }
    if (value.getSPM_e32_FACTORY()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_FACTORY" , 15);
        yajl_gen_bool(g, (bool)value.getSPM_e32_FACTORY());
    }
    if (value.getSPM_e32_QCRITICAL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPM_e32_QCRITICAL" , 17);
        yajl_gen_bool(g, (bool)value.getSPM_e32_QCRITICAL());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_PartnumberItem"

void serializeJson (const ::spm_core_fi_types::T_SPM_PartnumberItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "Number" , 6);
        yajl_gen_integer(g, (long long)value.getNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_PartnumberItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_AlphacodeItem"

void serializeJson (const ::spm_core_fi_types::T_SPM_AlphacodeItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAlphacode1()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode1" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode1());
    }
    if (!isSparse || value.hasAlphacode2()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode2" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_AlphacodeItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_RestrictedDlLock"

void serializeJson (const ::spm_core_fi_types::T_SPM_RestrictedDlLock& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrRestrictedLockArea()) {
        yajl_gen_string(g, (const unsigned char*)  "strRestrictedLockArea" , 21);
        const char *s = value.getStrRestrictedLockArea().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16AppIdLockOwner()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AppIdLockOwner" , 17);
        yajl_gen_integer(g, (long long)value.getU16AppIdLockOwner());
    }
    if (!isSparse || value.hasU16AppIdLockRequester()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AppIdLockRequester" , 21);
        yajl_gen_integer(g, (long long)value.getU16AppIdLockRequester());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_RestrictedDlLock& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_UpdateLockState"

void serializeJson (const ::spm_core_fi_types::T_SPM_UpdateLockState& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrLockName()) {
        yajl_gen_string(g, (const unsigned char*)  "strLockName" , 11);
        const char *s = value.getStrLockName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasELockState()) {
        yajl_gen_string(g, (const unsigned char*)  "eLockState" , 10);
        const char* s = ::spm_core_fi_types::T_e8_UpdateLockState_Name(value.getELockState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getELockState());
    }
    if (!isSparse || value.hasU16LockOwner()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LockOwner" , 12);
        yajl_gen_integer(g, (long long)value.getU16LockOwner());
    }
    if (!isSparse || value.hasLu16LockUsers()) {
        yajl_gen_string(g, (const unsigned char*)  "lu16LockUsers" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o1 = value.getLu16LockUsers();
        {
            ::std::vector< uint16 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_UpdateLockState& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_VoltageEventCounter"

void serializeJson (const ::spm_core_fi_types::T_SPM_VoltageEventCounter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLowVoltageCount()) {
        yajl_gen_string(g, (const unsigned char*)  "LowVoltageCount" , 15);
        yajl_gen_integer(g, (long long)value.getLowVoltageCount());
    }
    if (!isSparse || value.hasCrLowVoltageCount()) {
        yajl_gen_string(g, (const unsigned char*)  "CrLowVoltageCount" , 17);
        yajl_gen_integer(g, (long long)value.getCrLowVoltageCount());
    }
    if (!isSparse || value.hasHighVoltageCount()) {
        yajl_gen_string(g, (const unsigned char*)  "HighVoltageCount" , 16);
        yajl_gen_integer(g, (long long)value.getHighVoltageCount());
    }
    if (!isSparse || value.hasCrHighVoltageCount()) {
        yajl_gen_string(g, (const unsigned char*)  "CrHighVoltageCount" , 18);
        yajl_gen_integer(g, (long long)value.getCrHighVoltageCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_VoltageEventCounter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_VoltageRange"

void serializeJson (const ::spm_core_fi_types::T_SPM_VoltageRange& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVoltageValue()) {
        yajl_gen_string(g, (const unsigned char*)  "VoltageValue" , 12);
        yajl_gen_integer(g, (long long)value.getVoltageValue());
    }
    if (!isSparse || value.hasOperationTime()) {
        yajl_gen_string(g, (const unsigned char*)  "OperationTime" , 13);
        yajl_gen_integer(g, (long long)value.getOperationTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_VoltageRange& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_SystemStatisticsData"

void serializeJson (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMaxValue()) {
        yajl_gen_string(g, (const unsigned char*)  "MaxValue" , 8);
        yajl_gen_integer(g, (long long)value.getMaxValue());
    }
    if (!isSparse || value.hasAvgValue()) {
        yajl_gen_string(g, (const unsigned char*)  "AvgValue" , 8);
        yajl_gen_integer(g, (long long)value.getAvgValue());
    }
    if (!isSparse || value.hasMinValue()) {
        yajl_gen_string(g, (const unsigned char*)  "MinValue" , 8);
        yajl_gen_integer(g, (long long)value.getMinValue());
    }
    if (!isSparse || value.hasStatisticDataDisabled()) {
        yajl_gen_string(g, (const unsigned char*)  "StatisticDataDisabled" , 21);
        yajl_gen_bool(g, (bool)value.getStatisticDataDisabled());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_ResetInfoStatisticData"

void serializeJson (const ::spm_core_fi_types::T_SPM_ResetInfoStatisticData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTLastResetDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tLastResetDate" , 14);
        serializeJson(value.getTLastResetDate(), g, options);
    }
    if (!isSparse || value.hasTLastResetReason()) {
        yajl_gen_string(g, (const unsigned char*)  "tLastResetReason" , 16);
        const char* s = ::spm_core_fi_types::T_e8_LcmResetReason_Name(value.getTLastResetReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTLastResetReason());
    }
    if (!isSparse || value.hasU32ApApplicationError()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApApplicationError" , 21);
        yajl_gen_integer(g, (long long)value.getU32ApApplicationError());
    }
    if (!isSparse || value.hasU32ApSoftware()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApSoftware" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApSoftware());
    }
    if (!isSparse || value.hasU32ApEcuReset()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApEcuReset" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApEcuReset());
    }
    if (!isSparse || value.hasU32ApDownload()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApDownload" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApDownload());
    }
    if (!isSparse || value.hasU32ApDownloadError()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApDownloadError" , 18);
        yajl_gen_integer(g, (long long)value.getU32ApDownloadError());
    }
    if (!isSparse || value.hasU32ApOvertemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApOvertemperature" , 20);
        yajl_gen_integer(g, (long long)value.getU32ApOvertemperature());
    }
    if (!isSparse || value.hasU32ApUser()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApUser" , 9);
        yajl_gen_integer(g, (long long)value.getU32ApUser());
    }
    if (!isSparse || value.hasU32ApLcmIntern()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApLcmIntern" , 14);
        yajl_gen_integer(g, (long long)value.getU32ApLcmIntern());
    }
    if (!isSparse || value.hasU32ApWarmstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApWarmstartCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32ApWarmstartCount());
    }
    if (!isSparse || value.hasU32ApPowerOnCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerOnCount" , 17);
        yajl_gen_integer(g, (long long)value.getU32ApPowerOnCount());
    }
    if (!isSparse || value.hasU32ApPowerLossCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerLossCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32ApPowerLossCount());
    }
    if (!isSparse || value.hasU32ApPowerOffCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerOffCount" , 18);
        yajl_gen_integer(g, (long long)value.getU32ApPowerOffCount());
    }
    if (!isSparse || value.hasU32ApSccCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApSccCount" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApSccCount());
    }
    if (!isSparse || value.hasU32ApUnknownCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApUnknownCount" , 17);
        yajl_gen_integer(g, (long long)value.getU32ApUnknownCount());
    }
    if (!isSparse || value.hasU32SccHwWdtCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccHwWdtCount" , 16);
        yajl_gen_integer(g, (long long)value.getU32SccHwWdtCount());
    }
    if (!isSparse || value.hasU32SccPowerOnCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccPowerOnCount" , 18);
        yajl_gen_integer(g, (long long)value.getU32SccPowerOnCount());
    }
    if (!isSparse || value.hasU32SccColdstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccColdstartCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccColdstartCount());
    }
    if (!isSparse || value.hasU32SccAppmodeChangeCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccAppmodeChangeCount" , 24);
        yajl_gen_integer(g, (long long)value.getU32SccAppmodeChangeCount());
    }
    if (!isSparse || value.hasU32SccDuringLpwCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringLpwCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccDuringLpwCount());
    }
    if (!isSparse || value.hasU32SccDuringPllOszCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringPllOszCount" , 23);
        yajl_gen_integer(g, (long long)value.getU32SccDuringPllOszCount());
    }
    if (!isSparse || value.hasU32SccDuringSWCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringSWCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32SccDuringSWCount());
    }
    if (!isSparse || value.hasU32SccWarmstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccWarmstartCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccWarmstartCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_ResetInfoStatisticData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_SPM_SWVersionStatisticData"

void serializeJson (const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrBuildVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "strBuildVersion" , 15);
        const char *s = value.getStrBuildVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStrBuildVersionCustomer()) {
        yajl_gen_string(g, (const unsigned char*)  "strBuildVersionCustomer" , 23);
        const char *s = value.getStrBuildVersionCustomer().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStrCustomerVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "strCustomerVersion" , 18);
        const char *s = value.getStrCustomerVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTResetInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "tResetInfo" , 10);
        serializeJson(value.getTResetInfo(), g, options);
    }
    if (!isSparse || value.hasTResetHistoryList()) {
        yajl_gen_string(g, (const unsigned char*)  "tResetHistoryList" , 17);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& o3 = value.getTResetHistoryList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTWakeupHistoryList()) {
        yajl_gen_string(g, (const unsigned char*)  "tWakeupHistoryList" , 18);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& o5 = value.getTWakeupHistoryList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTSwitchOnList()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwitchOnList" , 13);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& o7 = value.getTSwitchOnList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTStateHistoryList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateHistoryList" , 17);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o9 = value.getTStateHistoryList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTErrStateHistory01List()) {
        yajl_gen_string(g, (const unsigned char*)  "tErrStateHistory01List" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o11 = value.getTErrStateHistory01List();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTErrStateHistory02List()) {
        yajl_gen_string(g, (const unsigned char*)  "tErrStateHistory02List" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o13 = value.getTErrStateHistory02List();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTErrStateHistory03List()) {
        yajl_gen_string(g, (const unsigned char*)  "tErrStateHistory03List" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o15 = value.getTErrStateHistory03List();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTErrStateHistory04List()) {
        yajl_gen_string(g, (const unsigned char*)  "tErrStateHistory04List" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o17 = value.getTErrStateHistory04List();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasTErrStateHistory05List()) {
        yajl_gen_string(g, (const unsigned char*)  "tErrStateHistory05List" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o19 = value.getTErrStateHistory05List();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU32SystemOperationTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SystemOperationTime" , 22);
        yajl_gen_integer(g, (long long)value.getU32SystemOperationTime());
    }
    if (!isSparse || value.hasTCpuUsage()) {
        yajl_gen_string(g, (const unsigned char*)  "tCpuUsage" , 9);
        serializeJson(value.getTCpuUsage(), g, options);
    }
    if (!isSparse || value.hasTRamUsage()) {
        yajl_gen_string(g, (const unsigned char*)  "tRamUsage" , 9);
        serializeJson(value.getTRamUsage(), g, options);
    }
    if (!isSparse || value.hasTStartupTime()) {
        yajl_gen_string(g, (const unsigned char*)  "tStartupTime" , 12);
        serializeJson(value.getTStartupTime(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::TTimeDate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::TSwVersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_b32_SubState0& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_b32_SubState1& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_b32_SubState2& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_b32_SubState3& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_HistoryTrigger& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_TransPortMode& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SubStateEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_ProcessElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_ResetElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_WakeupElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_StateChangeElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SwitchOnElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_PartnumberItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_AlphacodeItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_RestrictedDlLock& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_UpdateLockState& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_VoltageEventCounter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_VoltageRange& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_SystemStatisticsData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_ResetInfoStatisticData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types
using namespace ::asf::stream::json;

namespace spm_core_fi_types {

std::ostream& operator<<(std::ostream& o, const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace spm_core_fi_types

