/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "spm_core_fi_types.h"
#include "spm_core_fi_typesCca.h"
#include "spm_core_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::spm_core_fi_types::TTimeDate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getS16Year();
    out << in.getU8Month();
    out << in.getU8Day();
    out << in.getU8Hour();
    out << in.getU8Minute();
    out << in.getU8Second();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::TTimeDate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int16 o0;
    in >> o0;
    out.setS16Year(o0);
    uint8 o1;
    in >> o1;
    out.setU8Month(o1);
    uint8 o2;
    in >> o2;
    out.setU8Day(o2);
    uint8 o3;
    in >> o3;
    out.setU8Hour(o3);
    uint8 o4;
    in >> o4;
    out.setU8Minute(o4);
    uint8 o5;
    in >> o5;
    out.setU8Second(o5);
}

void serializeCca(const ::spm_core_fi_types::TSwVersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTSwBuildVersion();
    out << in.getTSwCustomerVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::TSwVersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o6;
    in >> o6;
    out.setTSwBuildVersion(o6);
    ::std::string o7;
    in >> o7;
    out.setTSwCustomerVersion(o7);
}

void serializeCca(const ::spm_core_fi_types::T_b32_SubState0& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_e32_SET_SD_CARD_ACCESS()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_e32_EMERGENCY_OFF()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_e32_FAST_SHUTDOWN()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_e32_DIMMING()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPM_e32_DOWNLOAD()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPM_e32_DIAG_ACTIVITY()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPM_e32_DIAGNOSIS()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPM_e32_PHONE()) {
        bitmask |= (1 << 7);
    }
    if (in.getSPM_e32_ACCESSORY()) {
        bitmask |= (1 << 8);
    }
    if (in.getSPM_e32_IGNITION()) {
        bitmask |= (1 << 9);
    }
    if (in.getSPM_e32_TRANSPORTMODE()) {
        bitmask |= (1 << 10);
    }
    if (in.getSPM_e32_DOOROPEN()) {
        bitmask |= (1 << 11);
    }
    if (in.getSPM_e32_DOORLOCK()) {
        bitmask |= (1 << 12);
    }
    if (in.getSPM_e32_TRIGGER_FORCE_ON()) {
        bitmask |= (1 << 13);
    }
    if (in.getSPM_e32_CLIMATE_INFO()) {
        bitmask |= (1 << 14);
    }
    if (in.getSPM_e32_PARK_DISTANCE_CTRL()) {
        bitmask |= (1 << 15);
    }
    if (in.getSPM_e32_FACTORY_MODE()) {
        bitmask |= (1 << 16);
    }
    if (in.getSPM_e32_CD_INSERT()) {
        bitmask |= (1 << 17);
    }
    if (in.getSPM_e32_SD_INSERT()) {
        bitmask |= (1 << 18);
    }
    if (in.getSPM_e32_EJECT()) {
        bitmask |= (1 << 19);
    }
    if (in.getSPM_e32_ON_TIPPER()) {
        bitmask |= (1 << 20);
    }
    if (in.getSPM_e32_SOFTTOP_OPEN()) {
        bitmask |= (1 << 21);
    }
    if (in.getSPM_e32_AIRBAG_DEPLOYED()) {
        bitmask |= (1 << 22);
    }
    if (in.getSPM_e32_KEY_PRESENT()) {
        bitmask |= (1 << 23);
    }
    if (in.getSPM_e32_NETWORK_ACTIVITY()) {
        bitmask |= (1 << 24);
    }
    if (in.getSPM_e32_OFF_TIPPER()) {
        bitmask |= (1 << 25);
    }
    if (in.getSPM_e32_OFF_LASTSTATE_CYCLE()) {
        bitmask |= (1 << 26);
    }
    if (in.getSPM_e32_DIAG_REQUEST()) {
        bitmask |= (1 << 27);
    }
    if (in.getSPM_e32_BACKLIGHT()) {
        bitmask |= (1 << 28);
    }
    if (in.getSPM_e32_HIGH_VOLTAGE()) {
        bitmask |= (1 << 29);
    }
    if (in.getSPM_e32_RCV_CONNECTED()) {
        bitmask |= (1 << 30);
    }
    if (in.getSPM_e32_OFF_LEARN()) {
        bitmask |= (1 << 31);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_b32_SubState0& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o8;
    in >> o8;
    uint32 bitmask(o8);

    if (bitmask & (1 << 0)) {
        out.setSPM_e32_SET_SD_CARD_ACCESS (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_e32_EMERGENCY_OFF (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_e32_FAST_SHUTDOWN (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_e32_DIMMING (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPM_e32_DOWNLOAD (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPM_e32_DIAG_ACTIVITY (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPM_e32_DIAGNOSIS (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPM_e32_PHONE (true);
    }
    if (bitmask & (1 << 8)) {
        out.setSPM_e32_ACCESSORY (true);
    }
    if (bitmask & (1 << 9)) {
        out.setSPM_e32_IGNITION (true);
    }
    if (bitmask & (1 << 10)) {
        out.setSPM_e32_TRANSPORTMODE (true);
    }
    if (bitmask & (1 << 11)) {
        out.setSPM_e32_DOOROPEN (true);
    }
    if (bitmask & (1 << 12)) {
        out.setSPM_e32_DOORLOCK (true);
    }
    if (bitmask & (1 << 13)) {
        out.setSPM_e32_TRIGGER_FORCE_ON (true);
    }
    if (bitmask & (1 << 14)) {
        out.setSPM_e32_CLIMATE_INFO (true);
    }
    if (bitmask & (1 << 15)) {
        out.setSPM_e32_PARK_DISTANCE_CTRL (true);
    }
    if (bitmask & (1 << 16)) {
        out.setSPM_e32_FACTORY_MODE (true);
    }
    if (bitmask & (1 << 17)) {
        out.setSPM_e32_CD_INSERT (true);
    }
    if (bitmask & (1 << 18)) {
        out.setSPM_e32_SD_INSERT (true);
    }
    if (bitmask & (1 << 19)) {
        out.setSPM_e32_EJECT (true);
    }
    if (bitmask & (1 << 20)) {
        out.setSPM_e32_ON_TIPPER (true);
    }
    if (bitmask & (1 << 21)) {
        out.setSPM_e32_SOFTTOP_OPEN (true);
    }
    if (bitmask & (1 << 22)) {
        out.setSPM_e32_AIRBAG_DEPLOYED (true);
    }
    if (bitmask & (1 << 23)) {
        out.setSPM_e32_KEY_PRESENT (true);
    }
    if (bitmask & (1 << 24)) {
        out.setSPM_e32_NETWORK_ACTIVITY (true);
    }
    if (bitmask & (1 << 25)) {
        out.setSPM_e32_OFF_TIPPER (true);
    }
    if (bitmask & (1 << 26)) {
        out.setSPM_e32_OFF_LASTSTATE_CYCLE (true);
    }
    if (bitmask & (1 << 27)) {
        out.setSPM_e32_DIAG_REQUEST (true);
    }
    if (bitmask & (1 << 28)) {
        out.setSPM_e32_BACKLIGHT (true);
    }
    if (bitmask & (1 << 29)) {
        out.setSPM_e32_HIGH_VOLTAGE (true);
    }
    if (bitmask & (1 << 30)) {
        out.setSPM_e32_RCV_CONNECTED (true);
    }
    if (bitmask & (1 << 31)) {
        out.setSPM_e32_OFF_LEARN (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_b32_SubState1& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_e32_HEARTBEAT()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_e32_USER_ON_REQ()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_e32_BACKGROUND_ON_REQ()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_e32_MULTIMEDIA_ON()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPM_e32_ANIMATION()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPM_e32_MULTIMEDIA_OPERATION()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPM_e32_TELEMATIC_ACTIVE()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPM_e32_STANDBY_REQ()) {
        bitmask |= (1 << 7);
    }
    if (in.getSPM_e32_ACCESSORY_ACTIVE()) {
        bitmask |= (1 << 8);
    }
    if (in.getSPM_e32_SHUTDOWN_BATTERY_SAVING()) {
        bitmask |= (1 << 9);
    }
    if (in.getSPM_e32_TML_REQ_BACKGROUND()) {
        bitmask |= (1 << 10);
    }
    if (in.getSPM_e32_IGNITION_TIMEOUT()) {
        bitmask |= (1 << 11);
    }
    if (in.getSPM_e32_IGNITION_INVALID()) {
        bitmask |= (1 << 12);
    }
    if (in.getSPM_e32_FIRST_PIC_DRAWN()) {
        bitmask |= (1 << 13);
    }
    if (in.getSPM_e32_OVERTEMP()) {
        bitmask |= (1 << 14);
    }
    if (in.getSPM_e32_LOCK_ACTIVITY()) {
        bitmask |= (1 << 15);
    }
    if (in.getSPM_e32_SYSSTATE_CHECK()) {
        bitmask |= (1 << 16);
    }
    if (in.getSPM_e32_CR_TEMPERATURE()) {
        bitmask |= (1 << 17);
    }
    if (in.getSPM_e32_PUSH_TO_TALK()) {
        bitmask |= (1 << 18);
    }
    if (in.getSPM_e32_ROUTEGUIDANCE_ACTIVE()) {
        bitmask |= (1 << 19);
    }
    if (in.getSPM_e32_HW_IGNITION()) {
        bitmask |= (1 << 20);
    }
    if (in.getSPM_e32_CAN_WAKEUP()) {
        bitmask |= (1 << 21);
    }
    if (in.getSPM_e32_DOWNLOAD_PERMISSION()) {
        bitmask |= (1 << 22);
    }
    if (in.getSPM_e32_IGNITION_LOGIC()) {
        bitmask |= (1 << 23);
    }
    if (in.getSPM_e32_LOW_VOLTAGE()) {
        bitmask |= (1 << 24);
    }
    if (in.getSPM_e32_STATE_DEBOUNCE()) {
        bitmask |= (1 << 25);
    }
    if (in.getSPM_e32_NETWORK_FAILURE()) {
        bitmask |= (1 << 26);
    }
    if (in.getSPM_e32_STATE_TO()) {
        bitmask |= (1 << 27);
    }
    if (in.getSPM_e32_DEBUG_WAKEUP()) {
        bitmask |= (1 << 28);
    }
    if (in.getSPM_e32_AUTOMATIC()) {
        bitmask |= (1 << 29);
    }
    if (in.getSPM_e32_CODE_REQUEST()) {
        bitmask |= (1 << 30);
    }
    if (in.getSPM_e32_SYNC_SHUTDOWN_ACK()) {
        bitmask |= (1 << 31);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_b32_SubState1& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o9;
    in >> o9;
    uint32 bitmask(o9);

    if (bitmask & (1 << 0)) {
        out.setSPM_e32_HEARTBEAT (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_e32_USER_ON_REQ (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_e32_BACKGROUND_ON_REQ (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_e32_MULTIMEDIA_ON (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPM_e32_ANIMATION (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPM_e32_MULTIMEDIA_OPERATION (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPM_e32_TELEMATIC_ACTIVE (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPM_e32_STANDBY_REQ (true);
    }
    if (bitmask & (1 << 8)) {
        out.setSPM_e32_ACCESSORY_ACTIVE (true);
    }
    if (bitmask & (1 << 9)) {
        out.setSPM_e32_SHUTDOWN_BATTERY_SAVING (true);
    }
    if (bitmask & (1 << 10)) {
        out.setSPM_e32_TML_REQ_BACKGROUND (true);
    }
    if (bitmask & (1 << 11)) {
        out.setSPM_e32_IGNITION_TIMEOUT (true);
    }
    if (bitmask & (1 << 12)) {
        out.setSPM_e32_IGNITION_INVALID (true);
    }
    if (bitmask & (1 << 13)) {
        out.setSPM_e32_FIRST_PIC_DRAWN (true);
    }
    if (bitmask & (1 << 14)) {
        out.setSPM_e32_OVERTEMP (true);
    }
    if (bitmask & (1 << 15)) {
        out.setSPM_e32_LOCK_ACTIVITY (true);
    }
    if (bitmask & (1 << 16)) {
        out.setSPM_e32_SYSSTATE_CHECK (true);
    }
    if (bitmask & (1 << 17)) {
        out.setSPM_e32_CR_TEMPERATURE (true);
    }
    if (bitmask & (1 << 18)) {
        out.setSPM_e32_PUSH_TO_TALK (true);
    }
    if (bitmask & (1 << 19)) {
        out.setSPM_e32_ROUTEGUIDANCE_ACTIVE (true);
    }
    if (bitmask & (1 << 20)) {
        out.setSPM_e32_HW_IGNITION (true);
    }
    if (bitmask & (1 << 21)) {
        out.setSPM_e32_CAN_WAKEUP (true);
    }
    if (bitmask & (1 << 22)) {
        out.setSPM_e32_DOWNLOAD_PERMISSION (true);
    }
    if (bitmask & (1 << 23)) {
        out.setSPM_e32_IGNITION_LOGIC (true);
    }
    if (bitmask & (1 << 24)) {
        out.setSPM_e32_LOW_VOLTAGE (true);
    }
    if (bitmask & (1 << 25)) {
        out.setSPM_e32_STATE_DEBOUNCE (true);
    }
    if (bitmask & (1 << 26)) {
        out.setSPM_e32_NETWORK_FAILURE (true);
    }
    if (bitmask & (1 << 27)) {
        out.setSPM_e32_STATE_TO (true);
    }
    if (bitmask & (1 << 28)) {
        out.setSPM_e32_DEBUG_WAKEUP (true);
    }
    if (bitmask & (1 << 29)) {
        out.setSPM_e32_AUTOMATIC (true);
    }
    if (bitmask & (1 << 30)) {
        out.setSPM_e32_CODE_REQUEST (true);
    }
    if (bitmask & (1 << 31)) {
        out.setSPM_e32_SYNC_SHUTDOWN_ACK (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_b32_SubState2& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_e32_FRIENDLY_USER()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_e32_NISSAN_CMF1()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_e32_PREPARE_SHUTDOWN()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_e32_SHUTDOWN()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPM_e32_HKEY_PRESSED()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPM_e32_CD_INSERT_CLAMPS()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPM_e32_CRITICAL_LOW_VOLTAGE()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPM_e32_ENDURING_LOW_VOLTAGE()) {
        bitmask |= (1 << 7);
    }
    if (in.getSPM_e32_DIAG_FAST_SHUTDOWN()) {
        bitmask |= (1 << 8);
    }
    if (in.getSPM_e32_USING_ACCESSORY()) {
        bitmask |= (1 << 9);
    }
    if (in.getSPM_e32_BACKGROUND_IMM_OFF()) {
        bitmask |= (1 << 10);
    }
    if (in.getSPM_e32_ROLLER_RIG_MODE()) {
        bitmask |= (1 << 11);
    }
    if (in.getSPM_e32_REMOTE_ON_ACTIVE()) {
        bitmask |= (1 << 12);
    }
    if (in.getSPM_e32_ENDURING_CR_VOLTAGE()) {
        bitmask |= (1 << 13);
    }
    if (in.getSPM_e32_NORMAL_VOLT()) {
        bitmask |= (1 << 14);
    }
    if (in.getSPM_e32_Q_CRITICAL()) {
        bitmask |= (1 << 15);
    }
    if (in.getSPM_e32_TRIGGER_RESET()) {
        bitmask |= (1 << 16);
    }
    if (in.getSPM_e32_CAR_WAKEUP()) {
        bitmask |= (1 << 17);
    }
    if (in.getSPM_e32_PHONE_CONNECTED()) {
        bitmask |= (1 << 18);
    }
    if (in.getSPM_e32_CUSTOMER_DOWNLOAD()) {
        bitmask |= (1 << 19);
    }
    if (in.getSPM_e32_STARTUP()) {
        bitmask |= (1 << 20);
    }
    if (in.getSPM_e32_MOST_OFF()) {
        bitmask |= (1 << 21);
    }
    if (in.getSPM_e32_MOST_OFF_ERR()) {
        bitmask |= (1 << 22);
    }
    if (in.getSPM_e32_MOST_WAIT_FOR_SHUTDOWN()) {
        bitmask |= (1 << 23);
    }
    if (in.getSPM_e32_MOST_RBD()) {
        bitmask |= (1 << 24);
    }
    if (in.getSPM_e32_MOST_SHUTDOWN_EXECUTE()) {
        bitmask |= (1 << 25);
    }
    if (in.getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY()) {
        bitmask |= (1 << 26);
    }
    if (in.getSPM_e32_SYSSTATE_NETWORK_FAILED()) {
        bitmask |= (1 << 27);
    }
    if (in.getSPM_e32_SAFE()) {
        bitmask |= (1 << 28);
    }
    if (in.getSPM_e32_FSM_SHUTDOWN_FINISHED()) {
        bitmask |= (1 << 29);
    }
    if (in.getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK()) {
        bitmask |= (1 << 30);
    }
    if (in.getSPM_e32_WAIT_FOR_FSM_RESTART_ACK()) {
        bitmask |= (1 << 31);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_b32_SubState2& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o10;
    in >> o10;
    uint32 bitmask(o10);

    if (bitmask & (1 << 0)) {
        out.setSPM_e32_FRIENDLY_USER (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_e32_NISSAN_CMF1 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_e32_PREPARE_SHUTDOWN (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_e32_SHUTDOWN (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPM_e32_HKEY_PRESSED (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPM_e32_CD_INSERT_CLAMPS (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPM_e32_CRITICAL_LOW_VOLTAGE (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPM_e32_ENDURING_LOW_VOLTAGE (true);
    }
    if (bitmask & (1 << 8)) {
        out.setSPM_e32_DIAG_FAST_SHUTDOWN (true);
    }
    if (bitmask & (1 << 9)) {
        out.setSPM_e32_USING_ACCESSORY (true);
    }
    if (bitmask & (1 << 10)) {
        out.setSPM_e32_BACKGROUND_IMM_OFF (true);
    }
    if (bitmask & (1 << 11)) {
        out.setSPM_e32_ROLLER_RIG_MODE (true);
    }
    if (bitmask & (1 << 12)) {
        out.setSPM_e32_REMOTE_ON_ACTIVE (true);
    }
    if (bitmask & (1 << 13)) {
        out.setSPM_e32_ENDURING_CR_VOLTAGE (true);
    }
    if (bitmask & (1 << 14)) {
        out.setSPM_e32_NORMAL_VOLT (true);
    }
    if (bitmask & (1 << 15)) {
        out.setSPM_e32_Q_CRITICAL (true);
    }
    if (bitmask & (1 << 16)) {
        out.setSPM_e32_TRIGGER_RESET (true);
    }
    if (bitmask & (1 << 17)) {
        out.setSPM_e32_CAR_WAKEUP (true);
    }
    if (bitmask & (1 << 18)) {
        out.setSPM_e32_PHONE_CONNECTED (true);
    }
    if (bitmask & (1 << 19)) {
        out.setSPM_e32_CUSTOMER_DOWNLOAD (true);
    }
    if (bitmask & (1 << 20)) {
        out.setSPM_e32_STARTUP (true);
    }
    if (bitmask & (1 << 21)) {
        out.setSPM_e32_MOST_OFF (true);
    }
    if (bitmask & (1 << 22)) {
        out.setSPM_e32_MOST_OFF_ERR (true);
    }
    if (bitmask & (1 << 23)) {
        out.setSPM_e32_MOST_WAIT_FOR_SHUTDOWN (true);
    }
    if (bitmask & (1 << 24)) {
        out.setSPM_e32_MOST_RBD (true);
    }
    if (bitmask & (1 << 25)) {
        out.setSPM_e32_MOST_SHUTDOWN_EXECUTE (true);
    }
    if (bitmask & (1 << 26)) {
        out.setSPM_e32_MOST_PWR_SWITCH_OFF_DELAY (true);
    }
    if (bitmask & (1 << 27)) {
        out.setSPM_e32_SYSSTATE_NETWORK_FAILED (true);
    }
    if (bitmask & (1 << 28)) {
        out.setSPM_e32_SAFE (true);
    }
    if (bitmask & (1 << 29)) {
        out.setSPM_e32_FSM_SHUTDOWN_FINISHED (true);
    }
    if (bitmask & (1 << 30)) {
        out.setSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK (true);
    }
    if (bitmask & (1 << 31)) {
        out.setSPM_e32_WAIT_FOR_FSM_RESTART_ACK (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_b32_SubState3& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_e32_VALET_MODE()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_e32_CRANK()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_e32_EMERGENCY_CALL()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_e32_LIN()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPM_e32_CELLNETWORK()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPM_e32_EXTERNAL_GPIO()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPM_e32_BLUETOOTH()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPM_e32_UART()) {
        bitmask |= (1 << 7);
    }
    if (in.getSPM_e32_USB()) {
        bitmask |= (1 << 8);
    }
    if (in.getSPM_e32_CRITICAL_HIGH_VOLTAGE()) {
        bitmask |= (1 << 9);
    }
    if (in.getSPM_e32_ENDURING_HIGH_VOLTAGE()) {
        bitmask |= (1 << 10);
    }
    if (in.getSPM_e32_OVER_THE_AIR()) {
        bitmask |= (1 << 11);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_b32_SubState3& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o11;
    in >> o11;
    uint32 bitmask(o11);

    if (bitmask & (1 << 0)) {
        out.setSPM_e32_VALET_MODE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_e32_CRANK (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_e32_EMERGENCY_CALL (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_e32_LIN (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPM_e32_CELLNETWORK (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPM_e32_EXTERNAL_GPIO (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPM_e32_BLUETOOTH (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPM_e32_UART (true);
    }
    if (bitmask & (1 << 8)) {
        out.setSPM_e32_USB (true);
    }
    if (bitmask & (1 << 9)) {
        out.setSPM_e32_CRITICAL_HIGH_VOLTAGE (true);
    }
    if (bitmask & (1 << 10)) {
        out.setSPM_e32_ENDURING_HIGH_VOLTAGE (true);
    }
    if (bitmask & (1 << 11)) {
        out.setSPM_e32_OVER_THE_AIR (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_U32_DIMMINGSTATE()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_U32_DIMSMINGTATE_CLIMATE()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_U32_DIMMINGSTATE_BACKLIGHT()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_U32_DIMMINGSTATE_HOUR_MODE()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPM_U32_DIMMINGSTATE_ALL_OFF()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPM_U32DIMMINGSTATE_ALL_ON()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_b32_DIM_STATE& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o12;
    in >> o12;
    uint32 bitmask(o12);

    if (bitmask & (1 << 0)) {
        out.setSPM_U32_DIMMINGSTATE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_U32_DIMSMINGTATE_CLIMATE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_U32_DIMMINGSTATE_BACKLIGHT (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_U32_DIMMINGSTATE_HOUR_MODE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPM_U32_DIMMINGSTATE_ALL_OFF (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPM_U32DIMMINGSTATE_ALL_ON (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_SPM_HistoryTrigger& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32Timestamp();
    out << (uint32) in.getETriggerType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_HistoryTrigger& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o13;
    in >> o13;
    out.setU32Timestamp(o13);
    uint32 o14;
    in >> o14;
    out.setETriggerType((::spm_core_fi_types::T_SPM_e32_SubStateType)o14);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_TransPortMode& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getYEAR();
    out << in.getMONTH();
    out << in.getDAY();
    out << in.getHOUR();
    out << in.getMINUTE();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_TransPortMode& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o15;
    in >> o15;
    out.setYEAR(o15);
    uint32 o16;
    in >> o16;
    out.setMONTH(o16);
    uint32 o17;
    in >> o17;
    out.setDAY(o17);
    uint32 o18;
    in >> o18;
    out.setHOUR(o18);
    uint32 o19;
    in >> o19;
    out.setMINUTE(o19);
}

void serializeCca(const ::spm_core_fi_types::T_SubStateEntry& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTSubStateMask0(), out, majorVersion);
    serializeCca(in.getTSubStateData0(), out, majorVersion);
    serializeCca(in.getTSubStateMask1(), out, majorVersion);
    serializeCca(in.getTSubStateData1(), out, majorVersion);
    serializeCca(in.getTSubStateMask2(), out, majorVersion);
    serializeCca(in.getTSubStateData2(), out, majorVersion);
    serializeCca(in.getTSubStateMask3(), out, majorVersion);
    serializeCca(in.getTSubStateData3(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SubStateEntry& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTSubStateMask0Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateData0Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateMask1Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateData1Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateMask2Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateData2Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateMask3Mutable(), majorVersion);
    deserializeCca(in, out.getTSubStateData3Mutable(), majorVersion);
}

void serializeCca(const ::spm_core_fi_types::T_ProcessElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTProcessName();
    out << in.getTConfiguredProcessName();
    out << (uint8) in.getEProcState();
    out << in.getU32StartTimeSinceStart();
    serializeCca(in.getTSwitchOnDate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_ProcessElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o20;
    in >> o20;
    out.setTProcessName(o20);
    ::std::string o21;
    in >> o21;
    out.setTConfiguredProcessName(o21);
    uint8 o22;
    in >> o22;
    out.setEProcState((::spm_core_fi_types::T_e8_ProcessState)o22);
    uint32 o23;
    in >> o23;
    out.setU32StartTimeSinceStart(o23);
    deserializeCca(in, out.getTSwitchOnDateMutable(), majorVersion);
}

void serializeCca(const ::spm_core_fi_types::T_ResetElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTResetDate(), out, majorVersion);
    serializeCca(in.getTSwVersionInfo(), out, majorVersion);
    out << (uint8) in.getEReset();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_ResetElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTResetDateMutable(), majorVersion);
    deserializeCca(in, out.getTSwVersionInfoMutable(), majorVersion);
    uint8 o24;
    in >> o24;
    out.setEReset((::spm_core_fi_types::T_e8_LcmResetReason)o24);
}

void serializeCca(const ::spm_core_fi_types::T_WakeupElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTWakeupDate(), out, majorVersion);
    out << (uint32) in.getEWakeupReason();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_WakeupElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTWakeupDateMutable(), majorVersion);
    uint32 o25;
    in >> o25;
    out.setEWakeupReason((::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON)o25);
}

void serializeCca(const ::spm_core_fi_types::T_StateChangeElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTWakeupDate(), out, majorVersion);
    out << (uint32) in.getTSysState();
    out << (uint8) in.getTElemType();
    out << (uint32) in.getTWakeup();
    out << (uint8) in.getTReset();
    serializeCca(in.getTSubStates(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_StateChangeElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTWakeupDateMutable(), majorVersion);
    uint32 o26;
    in >> o26;
    out.setTSysState((::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES)o26);
    uint8 o27;
    in >> o27;
    out.setTElemType((::spm_core_fi_types::T_e8_StateEntryType)o27);
    uint32 o28;
    in >> o28;
    out.setTWakeup((::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON)o28);
    uint8 o29;
    in >> o29;
    out.setTReset((::spm_core_fi_types::T_e8_LcmResetReason)o29);
    deserializeCca(in, out.getTSubStatesMutable(), majorVersion);
}

void serializeCca(const ::spm_core_fi_types::T_SwitchOnElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTSwitchOnDate(), out, majorVersion);
    out << (uint32) in.getESwitchOnReason();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SwitchOnElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTSwitchOnDateMutable(), majorVersion);
    uint32 o30;
    in >> o30;
    out.setESwitchOnReason((::spm_core_fi_types::T_SPM_e32_SubStateType)o30);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getSPM_e32_TRANSPORTMODE()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPM_e32_ROLLER()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPM_e32_FACTORY()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPM_e32_QCRITICAL()) {
        bitmask |= (1 << 3);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o31;
    in >> o31;
    uint32 bitmask(o31);

    if (bitmask & (1 << 0)) {
        out.setSPM_e32_TRANSPORTMODE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPM_e32_ROLLER (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPM_e32_FACTORY (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPM_e32_QCRITICAL (true);
    }
}

void serializeCca(const ::spm_core_fi_types::T_SPM_PartnumberItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPart();
    out << in.getNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_PartnumberItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o32;
    in >> o32;
    out.setPart(o32);
    uint32 o33;
    in >> o33;
    out.setNumber(o33);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_AlphacodeItem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPart();
    out << in.getAlphacode1();
    out << in.getAlphacode2();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_AlphacodeItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o34;
    in >> o34;
    out.setPart(o34);
    uint8 o35;
    in >> o35;
    out.setAlphacode1(o35);
    uint8 o36;
    in >> o36;
    out.setAlphacode2(o36);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_RestrictedDlLock& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStrRestrictedLockArea();
    out << in.getU16AppIdLockOwner();
    out << in.getU16AppIdLockRequester();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_RestrictedDlLock& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o37;
    in >> o37;
    out.setStrRestrictedLockArea(o37);
    uint16 o38;
    in >> o38;
    out.setU16AppIdLockOwner(o38);
    uint16 o39;
    in >> o39;
    out.setU16AppIdLockRequester(o39);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_UpdateLockState& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStrLockName();
    out << (uint8) in.getELockState();
    out << in.getU16LockOwner();
    {
        uint32 o40 = static_cast<uint32>(in.getLu16LockUsers().size());
        out << o40;
        ::std::vector< uint16 >::const_iterator o41;
        for (o41 = in.getLu16LockUsers().begin(); o41 != in.getLu16LockUsers().end(); ++o41) {
            out << (*o41);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_UpdateLockState& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o42;
    in >> o42;
    out.setStrLockName(o42);
    uint8 o43;
    in >> o43;
    out.setELockState((::spm_core_fi_types::T_e8_UpdateLockState)o43);
    uint16 o44;
    in >> o44;
    out.setU16LockOwner(o44);
    {
        uint32 o45;
        in >> o45;
        out.getLu16LockUsersMutable().clear ();
        out.getLu16LockUsersMutable().reserve (o45);
        for (uint32 o46 = 0; o46 < o45; o46++) {
            uint16 o47;
            in >> o47;
            out.getLu16LockUsersMutable().push_back(o47);
        }
    }
}

void serializeCca(const ::spm_core_fi_types::T_SPM_VoltageEventCounter& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getLowVoltageCount();
    out << in.getCrLowVoltageCount();
    out << in.getHighVoltageCount();
    out << in.getCrHighVoltageCount();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_VoltageEventCounter& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o48;
    in >> o48;
    out.setLowVoltageCount(o48);
    uint32 o49;
    in >> o49;
    out.setCrLowVoltageCount(o49);
    uint32 o50;
    in >> o50;
    out.setHighVoltageCount(o50);
    uint32 o51;
    in >> o51;
    out.setCrHighVoltageCount(o51);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_VoltageRange& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVoltageValue();
    out << in.getOperationTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_VoltageRange& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o52;
    in >> o52;
    out.setVoltageValue(o52);
    uint32 o53;
    in >> o53;
    out.setOperationTime(o53);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_SystemStatisticsData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getMaxValue();
    out << in.getAvgValue();
    out << in.getMinValue();
    out << (uint8) in.getStatisticDataDisabled();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_SystemStatisticsData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o54;
    in >> o54;
    out.setMaxValue(o54);
    uint32 o55;
    in >> o55;
    out.setAvgValue(o55);
    uint32 o56;
    in >> o56;
    out.setMinValue(o56);
    bool o57;
    in >> o57;
    out.setStatisticDataDisabled(o57);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_ResetInfoStatisticData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getTLastResetDate(), out, majorVersion);
    out << (uint8) in.getTLastResetReason();
    out << in.getU32ApApplicationError();
    out << in.getU32ApSoftware();
    out << in.getU32ApEcuReset();
    out << in.getU32ApDownload();
    out << in.getU32ApDownloadError();
    out << in.getU32ApOvertemperature();
    out << in.getU32ApUser();
    out << in.getU32ApLcmIntern();
    out << in.getU32ApWarmstartCount();
    out << in.getU32ApPowerOnCount();
    out << in.getU32ApPowerLossCount();
    out << in.getU32ApPowerOffCount();
    out << in.getU32ApSccCount();
    out << in.getU32ApUnknownCount();
    out << in.getU32SccHwWdtCount();
    out << in.getU32SccPowerOnCount();
    out << in.getU32SccColdstartCount();
    out << in.getU32SccAppmodeChangeCount();
    out << in.getU32SccDuringLpwCount();
    out << in.getU32SccDuringPllOszCount();
    out << in.getU32SccDuringSWCount();
    out << in.getU32SccWarmstartCount();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_ResetInfoStatisticData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getTLastResetDateMutable(), majorVersion);
    uint8 o58;
    in >> o58;
    out.setTLastResetReason((::spm_core_fi_types::T_e8_LcmResetReason)o58);
    uint32 o59;
    in >> o59;
    out.setU32ApApplicationError(o59);
    uint32 o60;
    in >> o60;
    out.setU32ApSoftware(o60);
    uint32 o61;
    in >> o61;
    out.setU32ApEcuReset(o61);
    uint32 o62;
    in >> o62;
    out.setU32ApDownload(o62);
    uint32 o63;
    in >> o63;
    out.setU32ApDownloadError(o63);
    uint32 o64;
    in >> o64;
    out.setU32ApOvertemperature(o64);
    uint32 o65;
    in >> o65;
    out.setU32ApUser(o65);
    uint32 o66;
    in >> o66;
    out.setU32ApLcmIntern(o66);
    uint32 o67;
    in >> o67;
    out.setU32ApWarmstartCount(o67);
    uint32 o68;
    in >> o68;
    out.setU32ApPowerOnCount(o68);
    uint32 o69;
    in >> o69;
    out.setU32ApPowerLossCount(o69);
    uint32 o70;
    in >> o70;
    out.setU32ApPowerOffCount(o70);
    uint32 o71;
    in >> o71;
    out.setU32ApSccCount(o71);
    uint32 o72;
    in >> o72;
    out.setU32ApUnknownCount(o72);
    uint32 o73;
    in >> o73;
    out.setU32SccHwWdtCount(o73);
    uint32 o74;
    in >> o74;
    out.setU32SccPowerOnCount(o74);
    uint32 o75;
    in >> o75;
    out.setU32SccColdstartCount(o75);
    uint32 o76;
    in >> o76;
    out.setU32SccAppmodeChangeCount(o76);
    uint32 o77;
    in >> o77;
    out.setU32SccDuringLpwCount(o77);
    uint32 o78;
    in >> o78;
    out.setU32SccDuringPllOszCount(o78);
    uint32 o79;
    in >> o79;
    out.setU32SccDuringSWCount(o79);
    uint32 o80;
    in >> o80;
    out.setU32SccWarmstartCount(o80);
}

void serializeCca(const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getStrBuildVersion();
    out << in.getStrBuildVersionCustomer();
    out << in.getStrCustomerVersion();
    serializeCca(in.getTResetInfo(), out, majorVersion);
    {
        uint32 o81 = static_cast<uint32>(in.getTResetHistoryList().size());
        out << o81;
        ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >::const_iterator o82;
        for (o82 = in.getTResetHistoryList().begin(); o82 != in.getTResetHistoryList().end(); ++o82) {
            serializeCca((*o82), out, majorVersion);
        }
    }
    {
        uint32 o83 = static_cast<uint32>(in.getTWakeupHistoryList().size());
        out << o83;
        ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >::const_iterator o84;
        for (o84 = in.getTWakeupHistoryList().begin(); o84 != in.getTWakeupHistoryList().end(); ++o84) {
            serializeCca((*o84), out, majorVersion);
        }
    }
    {
        uint32 o85 = static_cast<uint32>(in.getTSwitchOnList().size());
        out << o85;
        ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >::const_iterator o86;
        for (o86 = in.getTSwitchOnList().begin(); o86 != in.getTSwitchOnList().end(); ++o86) {
            serializeCca((*o86), out, majorVersion);
        }
    }
    {
        uint32 o87 = static_cast<uint32>(in.getTStateHistoryList().size());
        out << o87;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o88;
        for (o88 = in.getTStateHistoryList().begin(); o88 != in.getTStateHistoryList().end(); ++o88) {
            serializeCca((*o88), out, majorVersion);
        }
    }
    {
        uint32 o89 = static_cast<uint32>(in.getTErrStateHistory01List().size());
        out << o89;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o90;
        for (o90 = in.getTErrStateHistory01List().begin(); o90 != in.getTErrStateHistory01List().end(); ++o90) {
            serializeCca((*o90), out, majorVersion);
        }
    }
    {
        uint32 o91 = static_cast<uint32>(in.getTErrStateHistory02List().size());
        out << o91;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o92;
        for (o92 = in.getTErrStateHistory02List().begin(); o92 != in.getTErrStateHistory02List().end(); ++o92) {
            serializeCca((*o92), out, majorVersion);
        }
    }
    {
        uint32 o93 = static_cast<uint32>(in.getTErrStateHistory03List().size());
        out << o93;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o94;
        for (o94 = in.getTErrStateHistory03List().begin(); o94 != in.getTErrStateHistory03List().end(); ++o94) {
            serializeCca((*o94), out, majorVersion);
        }
    }
    {
        uint32 o95 = static_cast<uint32>(in.getTErrStateHistory04List().size());
        out << o95;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o96;
        for (o96 = in.getTErrStateHistory04List().begin(); o96 != in.getTErrStateHistory04List().end(); ++o96) {
            serializeCca((*o96), out, majorVersion);
        }
    }
    {
        uint32 o97 = static_cast<uint32>(in.getTErrStateHistory05List().size());
        out << o97;
        ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o98;
        for (o98 = in.getTErrStateHistory05List().begin(); o98 != in.getTErrStateHistory05List().end(); ++o98) {
            serializeCca((*o98), out, majorVersion);
        }
    }
    out << in.getU32SystemOperationTime();
    serializeCca(in.getTCpuUsage(), out, majorVersion);
    serializeCca(in.getTRamUsage(), out, majorVersion);
    serializeCca(in.getTStartupTime(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::spm_core_fi_types::T_SPM_SWVersionStatisticData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o99;
    in >> o99;
    out.setStrBuildVersion(o99);
    ::std::string o100;
    in >> o100;
    out.setStrBuildVersionCustomer(o100);
    ::std::string o101;
    in >> o101;
    out.setStrCustomerVersion(o101);
    deserializeCca(in, out.getTResetInfoMutable(), majorVersion);
    {
        uint32 o102;
        in >> o102;
        out.getTResetHistoryListMutable().clear ();
        out.getTResetHistoryListMutable().reserve (o102);
        for (uint32 o103 = 0; o103 < o102; o103++) {
            ::spm_core_fi_types::T_ResetElement *o104 = new ::spm_core_fi_types::T_ResetElement();
            deserializeCca(in, (*o104), majorVersion);
            out.getTResetHistoryListMutable().push_back (o104);
        }
    }
    {
        uint32 o105;
        in >> o105;
        out.getTWakeupHistoryListMutable().clear ();
        out.getTWakeupHistoryListMutable().reserve (o105);
        for (uint32 o106 = 0; o106 < o105; o106++) {
            ::spm_core_fi_types::T_WakeupElement *o107 = new ::spm_core_fi_types::T_WakeupElement();
            deserializeCca(in, (*o107), majorVersion);
            out.getTWakeupHistoryListMutable().push_back (o107);
        }
    }
    {
        uint32 o108;
        in >> o108;
        out.getTSwitchOnListMutable().clear ();
        out.getTSwitchOnListMutable().reserve (o108);
        for (uint32 o109 = 0; o109 < o108; o109++) {
            ::spm_core_fi_types::T_SwitchOnElement *o110 = new ::spm_core_fi_types::T_SwitchOnElement();
            deserializeCca(in, (*o110), majorVersion);
            out.getTSwitchOnListMutable().push_back (o110);
        }
    }
    {
        uint32 o111;
        in >> o111;
        out.getTStateHistoryListMutable().clear ();
        out.getTStateHistoryListMutable().reserve (o111);
        for (uint32 o112 = 0; o112 < o111; o112++) {
            ::spm_core_fi_types::T_StateChangeElement *o113 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o113), majorVersion);
            out.getTStateHistoryListMutable().push_back (o113);
        }
    }
    {
        uint32 o114;
        in >> o114;
        out.getTErrStateHistory01ListMutable().clear ();
        out.getTErrStateHistory01ListMutable().reserve (o114);
        for (uint32 o115 = 0; o115 < o114; o115++) {
            ::spm_core_fi_types::T_StateChangeElement *o116 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o116), majorVersion);
            out.getTErrStateHistory01ListMutable().push_back (o116);
        }
    }
    {
        uint32 o117;
        in >> o117;
        out.getTErrStateHistory02ListMutable().clear ();
        out.getTErrStateHistory02ListMutable().reserve (o117);
        for (uint32 o118 = 0; o118 < o117; o118++) {
            ::spm_core_fi_types::T_StateChangeElement *o119 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o119), majorVersion);
            out.getTErrStateHistory02ListMutable().push_back (o119);
        }
    }
    {
        uint32 o120;
        in >> o120;
        out.getTErrStateHistory03ListMutable().clear ();
        out.getTErrStateHistory03ListMutable().reserve (o120);
        for (uint32 o121 = 0; o121 < o120; o121++) {
            ::spm_core_fi_types::T_StateChangeElement *o122 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o122), majorVersion);
            out.getTErrStateHistory03ListMutable().push_back (o122);
        }
    }
    {
        uint32 o123;
        in >> o123;
        out.getTErrStateHistory04ListMutable().clear ();
        out.getTErrStateHistory04ListMutable().reserve (o123);
        for (uint32 o124 = 0; o124 < o123; o124++) {
            ::spm_core_fi_types::T_StateChangeElement *o125 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o125), majorVersion);
            out.getTErrStateHistory04ListMutable().push_back (o125);
        }
    }
    {
        uint32 o126;
        in >> o126;
        out.getTErrStateHistory05ListMutable().clear ();
        out.getTErrStateHistory05ListMutable().reserve (o126);
        for (uint32 o127 = 0; o127 < o126; o127++) {
            ::spm_core_fi_types::T_StateChangeElement *o128 = new ::spm_core_fi_types::T_StateChangeElement();
            deserializeCca(in, (*o128), majorVersion);
            out.getTErrStateHistory05ListMutable().push_back (o128);
        }
    }
    uint32 o129;
    in >> o129;
    out.setU32SystemOperationTime(o129);
    deserializeCca(in, out.getTCpuUsageMutable(), majorVersion);
    deserializeCca(in, out.getTRamUsageMutable(), majorVersion);
    deserializeCca(in, out.getTStartupTimeMutable(), majorVersion);
}

