#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SPM_CORE_FI_TYPES_H
#define SPM_CORE_FI_TYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "spm_core_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types spm_core_fi_types
 */

namespace spm_core_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TTimeDate;

class TSwVersionInfo;

class T_b32_SubState0;

class T_b32_SubState1;

class T_b32_SubState2;

class T_b32_SubState3;

class T_SPM_b32_DIM_STATE;

class T_SPM_HistoryTrigger;

class T_SPM_TransPortMode;

class T_SubStateEntry;

class T_ProcessElement;

class T_ResetElement;

class T_WakeupElement;

class T_StateChangeElement;

class T_SwitchOnElement;

class T_SPM_b32_SYSPWRSAVEMODE;

class T_SPM_PartnumberItem;

class T_SPM_AlphacodeItem;

class T_SPM_RestrictedDlLock;

class T_SPM_UpdateLockState;

class T_SPM_VoltageEventCounter;

class T_SPM_VoltageRange;

class T_SPM_SystemStatisticsData;

class T_SPM_ResetInfoStatisticData;

class T_SPM_SWVersionStatisticData;

// type definitions
/**
 * If the meaning of "T_SPM_TransPortModeList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_SPM_TransPortMode > T_SPM_TransPortModeList;

/**
 * If the meaning of "T_SPM_ProcessInfo" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_ProcessElement > T_SPM_ProcessInfo;

/**
 * If the meaning of "T_SPM_Vin" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_SPM_Vin;

/**
 * If the meaning of "T_SPM_VinHistory" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_SPM_Vin > T_SPM_VinHistory;

/**
 * If the meaning of "T_SPM_PartnumberList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_SPM_PartnumberItem > T_SPM_PartnumberList;

/**
 * If the meaning of "T_SPM_AlphacodeList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_SPM_AlphacodeItem > T_SPM_AlphacodeList;

/**
 * If the meaning of "T_SPM_AppIdList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_SPM_AppIdList;


/**
 * If the meaning of "TTimeDate" isn't clear, then there should be a description here.
 */
class TTimeDate {
public:

    /**
     * Default constructor
     */
    inline  TTimeDate ();

    /**
     * Copy constructor
     */
    inline  TTimeDate (const TTimeDate &rhs);

    /**
     * All fields constructor
     */
    inline  TTimeDate (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_);

    /**
     * Destructor
     */
    inline  ~TTimeDate();

    /**
     * Assignment operator
     */
    inline TTimeDate& operator = (const TTimeDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTimeDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTimeDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTimeDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTimeDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     * If the meaning of "s16Year" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     * If the meaning of "s16Year" isn't clear, then there should be a description here.
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * If the meaning of "u8Month" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * If the meaning of "u8Month" isn't clear, then there should be a description here.
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * If the meaning of "u8Day" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * If the meaning of "u8Day" isn't clear, then there should be a description here.
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hour"

    static const int kU8Hour = 3;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     * If the meaning of "u8Hour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     * If the meaning of "u8Hour" isn't clear, then there should be a description here.
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 4;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     * If the meaning of "u8Minute" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     * If the meaning of "u8Minute" isn't clear, then there should be a description here.
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Second"

    static const int kU8Second = 5;

    /**
     * Clears the field "u8Second".
     *
     * The field will be set to its default value. The hasU8Second()
     * method will return false.
     */
    inline void clearU8Second();

    /**
     * Checks whether the field "u8Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Second()). Otherwise it will return false.
     */
    inline bool hasU8Second () const;

    /**
     * Returns the value of the member "u8Second".
     *
     * If the meaning of "u8Second" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Second"
     */
    inline uint8 getU8Second () const;

    /**
     * Sets the value of the member "u8Second".
     *
     * If the meaning of "u8Second" isn't clear, then there should be a description here.
     *
     * @param u8Second The value which will be set
     */
    inline void setU8Second (uint8 u8Second_);

    static const TTimeDate &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Second ();

    inline void clear_has_u8Second ();

    uint32 _has_bits_[ (6 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Second;

};

/**
 * If the meaning of "TSwVersionInfo" isn't clear, then there should be a description here.
 */
class TSwVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  TSwVersionInfo ();

    /**
     * Copy constructor
     */
    inline  TSwVersionInfo (const TSwVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  TSwVersionInfo (const ::std::string& tSwBuildVersion_, const ::std::string& tSwCustomerVersion_);

    /**
     * Destructor
     */
    inline  ~TSwVersionInfo();

    /**
     * Assignment operator
     */
    inline TSwVersionInfo& operator = (const TSwVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TSwVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TSwVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TSwVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TSwVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSwBuildVersion"

    static const int kTSwBuildVersion = 0;

    /**
     * Clears the field "tSwBuildVersion".
     *
     * The field will be set to its default value. The hasTSwBuildVersion()
     * method will return false.
     */
    inline void clearTSwBuildVersion();

    /**
     * Checks whether the field "tSwBuildVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwBuildVersion()). Otherwise it will return false.
     */
    inline bool hasTSwBuildVersion () const;

    /**
     * Returns the value of the member "tSwBuildVersion".
     *
     * If the meaning of "tSwBuildVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSwBuildVersion"
     */
    inline const ::std::string& getTSwBuildVersion () const;

    /**
     * Retrieves the value of the field "tSwBuildVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwBuildVersion".
     */
    inline ::std::string& getTSwBuildVersionMutable ();

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     * If the meaning of "tSwBuildVersion" isn't clear, then there should be a description here.
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const ::std::string& tSwBuildVersion_);

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     * If the meaning of "tSwBuildVersion" isn't clear, then there should be a description here.
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const char* tSwBuildVersion_);

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     * If the meaning of "tSwBuildVersion" isn't clear, then there should be a description here.
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const char* value, size_t size);

    /**
     * Release the object stored in the field "tSwBuildVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwBuildVersion"
     */
    inline ::std::string* releaseTSwBuildVersion();

    /**
     * Replace the field "tSwBuildVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwBuildVersion (::std::string* tSwBuildVersion_);

    // API of field "tSwCustomerVersion"

    static const int kTSwCustomerVersion = 1;

    /**
     * Clears the field "tSwCustomerVersion".
     *
     * The field will be set to its default value. The hasTSwCustomerVersion()
     * method will return false.
     */
    inline void clearTSwCustomerVersion();

    /**
     * Checks whether the field "tSwCustomerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwCustomerVersion()). Otherwise it will return false.
     */
    inline bool hasTSwCustomerVersion () const;

    /**
     * Returns the value of the member "tSwCustomerVersion".
     *
     * If the meaning of "tSwCustomerVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSwCustomerVersion"
     */
    inline const ::std::string& getTSwCustomerVersion () const;

    /**
     * Retrieves the value of the field "tSwCustomerVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwCustomerVersion".
     */
    inline ::std::string& getTSwCustomerVersionMutable ();

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     * If the meaning of "tSwCustomerVersion" isn't clear, then there should be a description here.
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const ::std::string& tSwCustomerVersion_);

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     * If the meaning of "tSwCustomerVersion" isn't clear, then there should be a description here.
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const char* tSwCustomerVersion_);

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     * If the meaning of "tSwCustomerVersion" isn't clear, then there should be a description here.
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const char* value, size_t size);

    /**
     * Release the object stored in the field "tSwCustomerVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwCustomerVersion"
     */
    inline ::std::string* releaseTSwCustomerVersion();

    /**
     * Replace the field "tSwCustomerVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwCustomerVersion (::std::string* tSwCustomerVersion_);

    static const TSwVersionInfo &getDefaultInstance();

private:

    inline void set_has_tSwBuildVersion ();

    inline void clear_has_tSwBuildVersion ();

    inline void set_has_tSwCustomerVersion ();

    inline void clear_has_tSwCustomerVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _tSwBuildVersion;

    ::std::string* _tSwCustomerVersion;

};

/**
 * On/Off reasons 1..32 (bit-coded).
 */
class T_b32_SubState0 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState0 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState0 (const T_b32_SubState0 &c);

    /**
     * Field constructor
     */
    inline  T_b32_SubState0 (bool SPM_e32_SET_SD_CARD_ACCESS, bool SPM_e32_EMERGENCY_OFF, bool SPM_e32_FAST_SHUTDOWN, bool SPM_e32_DIMMING, bool SPM_e32_DOWNLOAD, bool SPM_e32_DIAG_ACTIVITY, bool SPM_e32_DIAGNOSIS, bool SPM_e32_PHONE, bool SPM_e32_ACCESSORY, bool SPM_e32_IGNITION, bool SPM_e32_TRANSPORTMODE, bool SPM_e32_DOOROPEN, bool SPM_e32_DOORLOCK, bool SPM_e32_TRIGGER_FORCE_ON, bool SPM_e32_CLIMATE_INFO, bool SPM_e32_PARK_DISTANCE_CTRL, bool SPM_e32_FACTORY_MODE, bool SPM_e32_CD_INSERT, bool SPM_e32_SD_INSERT, bool SPM_e32_EJECT, bool SPM_e32_ON_TIPPER, bool SPM_e32_SOFTTOP_OPEN, bool SPM_e32_AIRBAG_DEPLOYED, bool SPM_e32_KEY_PRESENT, bool SPM_e32_NETWORK_ACTIVITY, bool SPM_e32_OFF_TIPPER, bool SPM_e32_OFF_LASTSTATE_CYCLE, bool SPM_e32_DIAG_REQUEST, bool SPM_e32_BACKLIGHT, bool SPM_e32_HIGH_VOLTAGE, bool SPM_e32_RCV_CONNECTED, bool SPM_e32_OFF_LEARN);

    /**
     * Assignment operator
     */
    inline T_b32_SubState0& operator = (const T_b32_SubState0& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState0& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState0& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState0& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState0& rhs) const;

    /**
     * Sets the value of the member "SPM_e32_SET_SD_CARD_ACCESS".
     *
     * If the meaning of "SPM_e32_SET_SD_CARD_ACCESS" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SET_SD_CARD_ACCESS The value which will be set
     */
    inline void setSPM_e32_SET_SD_CARD_ACCESS (bool SPM_e32_SET_SD_CARD_ACCESS);

    /**
     * Returns the value of the member "SPM_e32_SET_SD_CARD_ACCESS".
     *
     * If the meaning of "SPM_e32_SET_SD_CARD_ACCESS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SET_SD_CARD_ACCESS"
     */
    inline bool getSPM_e32_SET_SD_CARD_ACCESS () const;

    /**
     * Sets the value of the member "SPM_e32_EMERGENCY_OFF".
     *
     * If the meaning of "SPM_e32_EMERGENCY_OFF" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_EMERGENCY_OFF The value which will be set
     */
    inline void setSPM_e32_EMERGENCY_OFF (bool SPM_e32_EMERGENCY_OFF);

    /**
     * Returns the value of the member "SPM_e32_EMERGENCY_OFF".
     *
     * If the meaning of "SPM_e32_EMERGENCY_OFF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_EMERGENCY_OFF"
     */
    inline bool getSPM_e32_EMERGENCY_OFF () const;

    /**
     * Sets the value of the member "SPM_e32_FAST_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_FAST_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FAST_SHUTDOWN The value which will be set
     */
    inline void setSPM_e32_FAST_SHUTDOWN (bool SPM_e32_FAST_SHUTDOWN);

    /**
     * Returns the value of the member "SPM_e32_FAST_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_FAST_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FAST_SHUTDOWN"
     */
    inline bool getSPM_e32_FAST_SHUTDOWN () const;

    /**
     * Sets the value of the member "SPM_e32_DIMMING".
     *
     * If the meaning of "SPM_e32_DIMMING" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DIMMING The value which will be set
     */
    inline void setSPM_e32_DIMMING (bool SPM_e32_DIMMING);

    /**
     * Returns the value of the member "SPM_e32_DIMMING".
     *
     * If the meaning of "SPM_e32_DIMMING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DIMMING"
     */
    inline bool getSPM_e32_DIMMING () const;

    /**
     * Sets the value of the member "SPM_e32_DOWNLOAD".
     *
     * If the meaning of "SPM_e32_DOWNLOAD" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DOWNLOAD The value which will be set
     */
    inline void setSPM_e32_DOWNLOAD (bool SPM_e32_DOWNLOAD);

    /**
     * Returns the value of the member "SPM_e32_DOWNLOAD".
     *
     * If the meaning of "SPM_e32_DOWNLOAD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DOWNLOAD"
     */
    inline bool getSPM_e32_DOWNLOAD () const;

    /**
     * Sets the value of the member "SPM_e32_DIAG_ACTIVITY".
     *
     * If the meaning of "SPM_e32_DIAG_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DIAG_ACTIVITY The value which will be set
     */
    inline void setSPM_e32_DIAG_ACTIVITY (bool SPM_e32_DIAG_ACTIVITY);

    /**
     * Returns the value of the member "SPM_e32_DIAG_ACTIVITY".
     *
     * If the meaning of "SPM_e32_DIAG_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DIAG_ACTIVITY"
     */
    inline bool getSPM_e32_DIAG_ACTIVITY () const;

    /**
     * Sets the value of the member "SPM_e32_DIAGNOSIS".
     *
     * If the meaning of "SPM_e32_DIAGNOSIS" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DIAGNOSIS The value which will be set
     */
    inline void setSPM_e32_DIAGNOSIS (bool SPM_e32_DIAGNOSIS);

    /**
     * Returns the value of the member "SPM_e32_DIAGNOSIS".
     *
     * If the meaning of "SPM_e32_DIAGNOSIS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DIAGNOSIS"
     */
    inline bool getSPM_e32_DIAGNOSIS () const;

    /**
     * Sets the value of the member "SPM_e32_PHONE".
     *
     * If the meaning of "SPM_e32_PHONE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_PHONE The value which will be set
     */
    inline void setSPM_e32_PHONE (bool SPM_e32_PHONE);

    /**
     * Returns the value of the member "SPM_e32_PHONE".
     *
     * If the meaning of "SPM_e32_PHONE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_PHONE"
     */
    inline bool getSPM_e32_PHONE () const;

    /**
     * Sets the value of the member "SPM_e32_ACCESSORY".
     *
     * If the meaning of "SPM_e32_ACCESSORY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ACCESSORY The value which will be set
     */
    inline void setSPM_e32_ACCESSORY (bool SPM_e32_ACCESSORY);

    /**
     * Returns the value of the member "SPM_e32_ACCESSORY".
     *
     * If the meaning of "SPM_e32_ACCESSORY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ACCESSORY"
     */
    inline bool getSPM_e32_ACCESSORY () const;

    /**
     * Sets the value of the member "SPM_e32_IGNITION".
     *
     * If the meaning of "SPM_e32_IGNITION" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_IGNITION The value which will be set
     */
    inline void setSPM_e32_IGNITION (bool SPM_e32_IGNITION);

    /**
     * Returns the value of the member "SPM_e32_IGNITION".
     *
     * If the meaning of "SPM_e32_IGNITION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_IGNITION"
     */
    inline bool getSPM_e32_IGNITION () const;

    /**
     * Sets the value of the member "SPM_e32_TRANSPORTMODE".
     *
     * If the meaning of "SPM_e32_TRANSPORTMODE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TRANSPORTMODE The value which will be set
     */
    inline void setSPM_e32_TRANSPORTMODE (bool SPM_e32_TRANSPORTMODE);

    /**
     * Returns the value of the member "SPM_e32_TRANSPORTMODE".
     *
     * If the meaning of "SPM_e32_TRANSPORTMODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TRANSPORTMODE"
     */
    inline bool getSPM_e32_TRANSPORTMODE () const;

    /**
     * Sets the value of the member "SPM_e32_DOOROPEN".
     *
     * If the meaning of "SPM_e32_DOOROPEN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DOOROPEN The value which will be set
     */
    inline void setSPM_e32_DOOROPEN (bool SPM_e32_DOOROPEN);

    /**
     * Returns the value of the member "SPM_e32_DOOROPEN".
     *
     * If the meaning of "SPM_e32_DOOROPEN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DOOROPEN"
     */
    inline bool getSPM_e32_DOOROPEN () const;

    /**
     * Sets the value of the member "SPM_e32_DOORLOCK".
     *
     * If the meaning of "SPM_e32_DOORLOCK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DOORLOCK The value which will be set
     */
    inline void setSPM_e32_DOORLOCK (bool SPM_e32_DOORLOCK);

    /**
     * Returns the value of the member "SPM_e32_DOORLOCK".
     *
     * If the meaning of "SPM_e32_DOORLOCK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DOORLOCK"
     */
    inline bool getSPM_e32_DOORLOCK () const;

    /**
     * Sets the value of the member "SPM_e32_TRIGGER_FORCE_ON".
     *
     * If the meaning of "SPM_e32_TRIGGER_FORCE_ON" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TRIGGER_FORCE_ON The value which will be set
     */
    inline void setSPM_e32_TRIGGER_FORCE_ON (bool SPM_e32_TRIGGER_FORCE_ON);

    /**
     * Returns the value of the member "SPM_e32_TRIGGER_FORCE_ON".
     *
     * If the meaning of "SPM_e32_TRIGGER_FORCE_ON" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TRIGGER_FORCE_ON"
     */
    inline bool getSPM_e32_TRIGGER_FORCE_ON () const;

    /**
     * Sets the value of the member "SPM_e32_CLIMATE_INFO".
     *
     * If the meaning of "SPM_e32_CLIMATE_INFO" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CLIMATE_INFO The value which will be set
     */
    inline void setSPM_e32_CLIMATE_INFO (bool SPM_e32_CLIMATE_INFO);

    /**
     * Returns the value of the member "SPM_e32_CLIMATE_INFO".
     *
     * If the meaning of "SPM_e32_CLIMATE_INFO" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CLIMATE_INFO"
     */
    inline bool getSPM_e32_CLIMATE_INFO () const;

    /**
     * Sets the value of the member "SPM_e32_PARK_DISTANCE_CTRL".
     *
     * If the meaning of "SPM_e32_PARK_DISTANCE_CTRL" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_PARK_DISTANCE_CTRL The value which will be set
     */
    inline void setSPM_e32_PARK_DISTANCE_CTRL (bool SPM_e32_PARK_DISTANCE_CTRL);

    /**
     * Returns the value of the member "SPM_e32_PARK_DISTANCE_CTRL".
     *
     * If the meaning of "SPM_e32_PARK_DISTANCE_CTRL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_PARK_DISTANCE_CTRL"
     */
    inline bool getSPM_e32_PARK_DISTANCE_CTRL () const;

    /**
     * Sets the value of the member "SPM_e32_FACTORY_MODE".
     *
     * If the meaning of "SPM_e32_FACTORY_MODE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FACTORY_MODE The value which will be set
     */
    inline void setSPM_e32_FACTORY_MODE (bool SPM_e32_FACTORY_MODE);

    /**
     * Returns the value of the member "SPM_e32_FACTORY_MODE".
     *
     * If the meaning of "SPM_e32_FACTORY_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FACTORY_MODE"
     */
    inline bool getSPM_e32_FACTORY_MODE () const;

    /**
     * Sets the value of the member "SPM_e32_CD_INSERT".
     *
     * If the meaning of "SPM_e32_CD_INSERT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CD_INSERT The value which will be set
     */
    inline void setSPM_e32_CD_INSERT (bool SPM_e32_CD_INSERT);

    /**
     * Returns the value of the member "SPM_e32_CD_INSERT".
     *
     * If the meaning of "SPM_e32_CD_INSERT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CD_INSERT"
     */
    inline bool getSPM_e32_CD_INSERT () const;

    /**
     * Sets the value of the member "SPM_e32_SD_INSERT".
     *
     * If the meaning of "SPM_e32_SD_INSERT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SD_INSERT The value which will be set
     */
    inline void setSPM_e32_SD_INSERT (bool SPM_e32_SD_INSERT);

    /**
     * Returns the value of the member "SPM_e32_SD_INSERT".
     *
     * If the meaning of "SPM_e32_SD_INSERT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SD_INSERT"
     */
    inline bool getSPM_e32_SD_INSERT () const;

    /**
     * Sets the value of the member "SPM_e32_EJECT".
     *
     * If the meaning of "SPM_e32_EJECT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_EJECT The value which will be set
     */
    inline void setSPM_e32_EJECT (bool SPM_e32_EJECT);

    /**
     * Returns the value of the member "SPM_e32_EJECT".
     *
     * If the meaning of "SPM_e32_EJECT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_EJECT"
     */
    inline bool getSPM_e32_EJECT () const;

    /**
     * Sets the value of the member "SPM_e32_ON_TIPPER".
     *
     * If the meaning of "SPM_e32_ON_TIPPER" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ON_TIPPER The value which will be set
     */
    inline void setSPM_e32_ON_TIPPER (bool SPM_e32_ON_TIPPER);

    /**
     * Returns the value of the member "SPM_e32_ON_TIPPER".
     *
     * If the meaning of "SPM_e32_ON_TIPPER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ON_TIPPER"
     */
    inline bool getSPM_e32_ON_TIPPER () const;

    /**
     * Sets the value of the member "SPM_e32_SOFTTOP_OPEN".
     *
     * If the meaning of "SPM_e32_SOFTTOP_OPEN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SOFTTOP_OPEN The value which will be set
     */
    inline void setSPM_e32_SOFTTOP_OPEN (bool SPM_e32_SOFTTOP_OPEN);

    /**
     * Returns the value of the member "SPM_e32_SOFTTOP_OPEN".
     *
     * If the meaning of "SPM_e32_SOFTTOP_OPEN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SOFTTOP_OPEN"
     */
    inline bool getSPM_e32_SOFTTOP_OPEN () const;

    /**
     * Sets the value of the member "SPM_e32_AIRBAG_DEPLOYED".
     *
     * If the meaning of "SPM_e32_AIRBAG_DEPLOYED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_AIRBAG_DEPLOYED The value which will be set
     */
    inline void setSPM_e32_AIRBAG_DEPLOYED (bool SPM_e32_AIRBAG_DEPLOYED);

    /**
     * Returns the value of the member "SPM_e32_AIRBAG_DEPLOYED".
     *
     * If the meaning of "SPM_e32_AIRBAG_DEPLOYED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_AIRBAG_DEPLOYED"
     */
    inline bool getSPM_e32_AIRBAG_DEPLOYED () const;

    /**
     * Sets the value of the member "SPM_e32_KEY_PRESENT".
     *
     * If the meaning of "SPM_e32_KEY_PRESENT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_KEY_PRESENT The value which will be set
     */
    inline void setSPM_e32_KEY_PRESENT (bool SPM_e32_KEY_PRESENT);

    /**
     * Returns the value of the member "SPM_e32_KEY_PRESENT".
     *
     * If the meaning of "SPM_e32_KEY_PRESENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_KEY_PRESENT"
     */
    inline bool getSPM_e32_KEY_PRESENT () const;

    /**
     * Sets the value of the member "SPM_e32_NETWORK_ACTIVITY".
     *
     * If the meaning of "SPM_e32_NETWORK_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_NETWORK_ACTIVITY The value which will be set
     */
    inline void setSPM_e32_NETWORK_ACTIVITY (bool SPM_e32_NETWORK_ACTIVITY);

    /**
     * Returns the value of the member "SPM_e32_NETWORK_ACTIVITY".
     *
     * If the meaning of "SPM_e32_NETWORK_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_NETWORK_ACTIVITY"
     */
    inline bool getSPM_e32_NETWORK_ACTIVITY () const;

    /**
     * Sets the value of the member "SPM_e32_OFF_TIPPER".
     *
     * If the meaning of "SPM_e32_OFF_TIPPER" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_OFF_TIPPER The value which will be set
     */
    inline void setSPM_e32_OFF_TIPPER (bool SPM_e32_OFF_TIPPER);

    /**
     * Returns the value of the member "SPM_e32_OFF_TIPPER".
     *
     * If the meaning of "SPM_e32_OFF_TIPPER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_OFF_TIPPER"
     */
    inline bool getSPM_e32_OFF_TIPPER () const;

    /**
     * Sets the value of the member "SPM_e32_OFF_LASTSTATE_CYCLE".
     *
     * If the meaning of "SPM_e32_OFF_LASTSTATE_CYCLE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_OFF_LASTSTATE_CYCLE The value which will be set
     */
    inline void setSPM_e32_OFF_LASTSTATE_CYCLE (bool SPM_e32_OFF_LASTSTATE_CYCLE);

    /**
     * Returns the value of the member "SPM_e32_OFF_LASTSTATE_CYCLE".
     *
     * If the meaning of "SPM_e32_OFF_LASTSTATE_CYCLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_OFF_LASTSTATE_CYCLE"
     */
    inline bool getSPM_e32_OFF_LASTSTATE_CYCLE () const;

    /**
     * Sets the value of the member "SPM_e32_DIAG_REQUEST".
     *
     * If the meaning of "SPM_e32_DIAG_REQUEST" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DIAG_REQUEST The value which will be set
     */
    inline void setSPM_e32_DIAG_REQUEST (bool SPM_e32_DIAG_REQUEST);

    /**
     * Returns the value of the member "SPM_e32_DIAG_REQUEST".
     *
     * If the meaning of "SPM_e32_DIAG_REQUEST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DIAG_REQUEST"
     */
    inline bool getSPM_e32_DIAG_REQUEST () const;

    /**
     * Sets the value of the member "SPM_e32_BACKLIGHT".
     *
     * If the meaning of "SPM_e32_BACKLIGHT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_BACKLIGHT The value which will be set
     */
    inline void setSPM_e32_BACKLIGHT (bool SPM_e32_BACKLIGHT);

    /**
     * Returns the value of the member "SPM_e32_BACKLIGHT".
     *
     * If the meaning of "SPM_e32_BACKLIGHT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_BACKLIGHT"
     */
    inline bool getSPM_e32_BACKLIGHT () const;

    /**
     * Sets the value of the member "SPM_e32_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_HIGH_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_HIGH_VOLTAGE (bool SPM_e32_HIGH_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_HIGH_VOLTAGE"
     */
    inline bool getSPM_e32_HIGH_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_RCV_CONNECTED".
     *
     * If the meaning of "SPM_e32_RCV_CONNECTED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_RCV_CONNECTED The value which will be set
     */
    inline void setSPM_e32_RCV_CONNECTED (bool SPM_e32_RCV_CONNECTED);

    /**
     * Returns the value of the member "SPM_e32_RCV_CONNECTED".
     *
     * If the meaning of "SPM_e32_RCV_CONNECTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_RCV_CONNECTED"
     */
    inline bool getSPM_e32_RCV_CONNECTED () const;

    /**
     * Sets the value of the member "SPM_e32_OFF_LEARN".
     *
     * If the meaning of "SPM_e32_OFF_LEARN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_OFF_LEARN The value which will be set
     */
    inline void setSPM_e32_OFF_LEARN (bool SPM_e32_OFF_LEARN);

    /**
     * Returns the value of the member "SPM_e32_OFF_LEARN".
     *
     * If the meaning of "SPM_e32_OFF_LEARN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_OFF_LEARN"
     */
    inline bool getSPM_e32_OFF_LEARN () const;

    static const T_b32_SubState0 &getDefaultInstance();

private:

    bool _SPM_e32_SET_SD_CARD_ACCESS:1;

    bool _SPM_e32_EMERGENCY_OFF:1;

    bool _SPM_e32_FAST_SHUTDOWN:1;

    bool _SPM_e32_DIMMING:1;

    bool _SPM_e32_DOWNLOAD:1;

    bool _SPM_e32_DIAG_ACTIVITY:1;

    bool _SPM_e32_DIAGNOSIS:1;

    bool _SPM_e32_PHONE:1;

    bool _SPM_e32_ACCESSORY:1;

    bool _SPM_e32_IGNITION:1;

    bool _SPM_e32_TRANSPORTMODE:1;

    bool _SPM_e32_DOOROPEN:1;

    bool _SPM_e32_DOORLOCK:1;

    bool _SPM_e32_TRIGGER_FORCE_ON:1;

    bool _SPM_e32_CLIMATE_INFO:1;

    bool _SPM_e32_PARK_DISTANCE_CTRL:1;

    bool _SPM_e32_FACTORY_MODE:1;

    bool _SPM_e32_CD_INSERT:1;

    bool _SPM_e32_SD_INSERT:1;

    bool _SPM_e32_EJECT:1;

    bool _SPM_e32_ON_TIPPER:1;

    bool _SPM_e32_SOFTTOP_OPEN:1;

    bool _SPM_e32_AIRBAG_DEPLOYED:1;

    bool _SPM_e32_KEY_PRESENT:1;

    bool _SPM_e32_NETWORK_ACTIVITY:1;

    bool _SPM_e32_OFF_TIPPER:1;

    bool _SPM_e32_OFF_LASTSTATE_CYCLE:1;

    bool _SPM_e32_DIAG_REQUEST:1;

    bool _SPM_e32_BACKLIGHT:1;

    bool _SPM_e32_HIGH_VOLTAGE:1;

    bool _SPM_e32_RCV_CONNECTED:1;

    bool _SPM_e32_OFF_LEARN:1;

};

/**
 * On/Off reasons 1..32 (bit-coded).
 */
class T_b32_SubState1 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState1 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState1 (const T_b32_SubState1 &c);

    /**
     * Field constructor
     */
    inline  T_b32_SubState1 (bool SPM_e32_HEARTBEAT, bool SPM_e32_USER_ON_REQ, bool SPM_e32_BACKGROUND_ON_REQ, bool SPM_e32_MULTIMEDIA_ON, bool SPM_e32_ANIMATION, bool SPM_e32_MULTIMEDIA_OPERATION, bool SPM_e32_TELEMATIC_ACTIVE, bool SPM_e32_STANDBY_REQ, bool SPM_e32_ACCESSORY_ACTIVE, bool SPM_e32_SHUTDOWN_BATTERY_SAVING, bool SPM_e32_TML_REQ_BACKGROUND, bool SPM_e32_IGNITION_TIMEOUT, bool SPM_e32_IGNITION_INVALID, bool SPM_e32_FIRST_PIC_DRAWN, bool SPM_e32_OVERTEMP, bool SPM_e32_LOCK_ACTIVITY, bool SPM_e32_SYSSTATE_CHECK, bool SPM_e32_CR_TEMPERATURE, bool SPM_e32_PUSH_TO_TALK, bool SPM_e32_ROUTEGUIDANCE_ACTIVE, bool SPM_e32_HW_IGNITION, bool SPM_e32_CAN_WAKEUP, bool SPM_e32_DOWNLOAD_PERMISSION, bool SPM_e32_IGNITION_LOGIC, bool SPM_e32_LOW_VOLTAGE, bool SPM_e32_STATE_DEBOUNCE, bool SPM_e32_NETWORK_FAILURE, bool SPM_e32_STATE_TO, bool SPM_e32_DEBUG_WAKEUP, bool SPM_e32_AUTOMATIC, bool SPM_e32_CODE_REQUEST, bool SPM_e32_SYNC_SHUTDOWN_ACK);

    /**
     * Assignment operator
     */
    inline T_b32_SubState1& operator = (const T_b32_SubState1& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState1& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState1& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState1& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState1& rhs) const;

    /**
     * Sets the value of the member "SPM_e32_HEARTBEAT".
     *
     * If the meaning of "SPM_e32_HEARTBEAT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_HEARTBEAT The value which will be set
     */
    inline void setSPM_e32_HEARTBEAT (bool SPM_e32_HEARTBEAT);

    /**
     * Returns the value of the member "SPM_e32_HEARTBEAT".
     *
     * If the meaning of "SPM_e32_HEARTBEAT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_HEARTBEAT"
     */
    inline bool getSPM_e32_HEARTBEAT () const;

    /**
     * Sets the value of the member "SPM_e32_USER_ON_REQ".
     *
     * If the meaning of "SPM_e32_USER_ON_REQ" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_USER_ON_REQ The value which will be set
     */
    inline void setSPM_e32_USER_ON_REQ (bool SPM_e32_USER_ON_REQ);

    /**
     * Returns the value of the member "SPM_e32_USER_ON_REQ".
     *
     * If the meaning of "SPM_e32_USER_ON_REQ" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_USER_ON_REQ"
     */
    inline bool getSPM_e32_USER_ON_REQ () const;

    /**
     * Sets the value of the member "SPM_e32_BACKGROUND_ON_REQ".
     *
     * If the meaning of "SPM_e32_BACKGROUND_ON_REQ" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_BACKGROUND_ON_REQ The value which will be set
     */
    inline void setSPM_e32_BACKGROUND_ON_REQ (bool SPM_e32_BACKGROUND_ON_REQ);

    /**
     * Returns the value of the member "SPM_e32_BACKGROUND_ON_REQ".
     *
     * If the meaning of "SPM_e32_BACKGROUND_ON_REQ" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_BACKGROUND_ON_REQ"
     */
    inline bool getSPM_e32_BACKGROUND_ON_REQ () const;

    /**
     * Sets the value of the member "SPM_e32_MULTIMEDIA_ON".
     *
     * If the meaning of "SPM_e32_MULTIMEDIA_ON" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MULTIMEDIA_ON The value which will be set
     */
    inline void setSPM_e32_MULTIMEDIA_ON (bool SPM_e32_MULTIMEDIA_ON);

    /**
     * Returns the value of the member "SPM_e32_MULTIMEDIA_ON".
     *
     * If the meaning of "SPM_e32_MULTIMEDIA_ON" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MULTIMEDIA_ON"
     */
    inline bool getSPM_e32_MULTIMEDIA_ON () const;

    /**
     * Sets the value of the member "SPM_e32_ANIMATION".
     *
     * If the meaning of "SPM_e32_ANIMATION" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ANIMATION The value which will be set
     */
    inline void setSPM_e32_ANIMATION (bool SPM_e32_ANIMATION);

    /**
     * Returns the value of the member "SPM_e32_ANIMATION".
     *
     * If the meaning of "SPM_e32_ANIMATION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ANIMATION"
     */
    inline bool getSPM_e32_ANIMATION () const;

    /**
     * Sets the value of the member "SPM_e32_MULTIMEDIA_OPERATION".
     *
     * If the meaning of "SPM_e32_MULTIMEDIA_OPERATION" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MULTIMEDIA_OPERATION The value which will be set
     */
    inline void setSPM_e32_MULTIMEDIA_OPERATION (bool SPM_e32_MULTIMEDIA_OPERATION);

    /**
     * Returns the value of the member "SPM_e32_MULTIMEDIA_OPERATION".
     *
     * If the meaning of "SPM_e32_MULTIMEDIA_OPERATION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MULTIMEDIA_OPERATION"
     */
    inline bool getSPM_e32_MULTIMEDIA_OPERATION () const;

    /**
     * Sets the value of the member "SPM_e32_TELEMATIC_ACTIVE".
     *
     * If the meaning of "SPM_e32_TELEMATIC_ACTIVE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TELEMATIC_ACTIVE The value which will be set
     */
    inline void setSPM_e32_TELEMATIC_ACTIVE (bool SPM_e32_TELEMATIC_ACTIVE);

    /**
     * Returns the value of the member "SPM_e32_TELEMATIC_ACTIVE".
     *
     * If the meaning of "SPM_e32_TELEMATIC_ACTIVE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TELEMATIC_ACTIVE"
     */
    inline bool getSPM_e32_TELEMATIC_ACTIVE () const;

    /**
     * Sets the value of the member "SPM_e32_STANDBY_REQ".
     *
     * If the meaning of "SPM_e32_STANDBY_REQ" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_STANDBY_REQ The value which will be set
     */
    inline void setSPM_e32_STANDBY_REQ (bool SPM_e32_STANDBY_REQ);

    /**
     * Returns the value of the member "SPM_e32_STANDBY_REQ".
     *
     * If the meaning of "SPM_e32_STANDBY_REQ" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_STANDBY_REQ"
     */
    inline bool getSPM_e32_STANDBY_REQ () const;

    /**
     * Sets the value of the member "SPM_e32_ACCESSORY_ACTIVE".
     *
     * If the meaning of "SPM_e32_ACCESSORY_ACTIVE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ACCESSORY_ACTIVE The value which will be set
     */
    inline void setSPM_e32_ACCESSORY_ACTIVE (bool SPM_e32_ACCESSORY_ACTIVE);

    /**
     * Returns the value of the member "SPM_e32_ACCESSORY_ACTIVE".
     *
     * If the meaning of "SPM_e32_ACCESSORY_ACTIVE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ACCESSORY_ACTIVE"
     */
    inline bool getSPM_e32_ACCESSORY_ACTIVE () const;

    /**
     * Sets the value of the member "SPM_e32_SHUTDOWN_BATTERY_SAVING".
     *
     * If the meaning of "SPM_e32_SHUTDOWN_BATTERY_SAVING" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SHUTDOWN_BATTERY_SAVING The value which will be set
     */
    inline void setSPM_e32_SHUTDOWN_BATTERY_SAVING (bool SPM_e32_SHUTDOWN_BATTERY_SAVING);

    /**
     * Returns the value of the member "SPM_e32_SHUTDOWN_BATTERY_SAVING".
     *
     * If the meaning of "SPM_e32_SHUTDOWN_BATTERY_SAVING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SHUTDOWN_BATTERY_SAVING"
     */
    inline bool getSPM_e32_SHUTDOWN_BATTERY_SAVING () const;

    /**
     * Sets the value of the member "SPM_e32_TML_REQ_BACKGROUND".
     *
     * If the meaning of "SPM_e32_TML_REQ_BACKGROUND" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TML_REQ_BACKGROUND The value which will be set
     */
    inline void setSPM_e32_TML_REQ_BACKGROUND (bool SPM_e32_TML_REQ_BACKGROUND);

    /**
     * Returns the value of the member "SPM_e32_TML_REQ_BACKGROUND".
     *
     * If the meaning of "SPM_e32_TML_REQ_BACKGROUND" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TML_REQ_BACKGROUND"
     */
    inline bool getSPM_e32_TML_REQ_BACKGROUND () const;

    /**
     * Sets the value of the member "SPM_e32_IGNITION_TIMEOUT".
     *
     * If the meaning of "SPM_e32_IGNITION_TIMEOUT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_IGNITION_TIMEOUT The value which will be set
     */
    inline void setSPM_e32_IGNITION_TIMEOUT (bool SPM_e32_IGNITION_TIMEOUT);

    /**
     * Returns the value of the member "SPM_e32_IGNITION_TIMEOUT".
     *
     * If the meaning of "SPM_e32_IGNITION_TIMEOUT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_IGNITION_TIMEOUT"
     */
    inline bool getSPM_e32_IGNITION_TIMEOUT () const;

    /**
     * Sets the value of the member "SPM_e32_IGNITION_INVALID".
     *
     * If the meaning of "SPM_e32_IGNITION_INVALID" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_IGNITION_INVALID The value which will be set
     */
    inline void setSPM_e32_IGNITION_INVALID (bool SPM_e32_IGNITION_INVALID);

    /**
     * Returns the value of the member "SPM_e32_IGNITION_INVALID".
     *
     * If the meaning of "SPM_e32_IGNITION_INVALID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_IGNITION_INVALID"
     */
    inline bool getSPM_e32_IGNITION_INVALID () const;

    /**
     * Sets the value of the member "SPM_e32_FIRST_PIC_DRAWN".
     *
     * If the meaning of "SPM_e32_FIRST_PIC_DRAWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FIRST_PIC_DRAWN The value which will be set
     */
    inline void setSPM_e32_FIRST_PIC_DRAWN (bool SPM_e32_FIRST_PIC_DRAWN);

    /**
     * Returns the value of the member "SPM_e32_FIRST_PIC_DRAWN".
     *
     * If the meaning of "SPM_e32_FIRST_PIC_DRAWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FIRST_PIC_DRAWN"
     */
    inline bool getSPM_e32_FIRST_PIC_DRAWN () const;

    /**
     * Sets the value of the member "SPM_e32_OVERTEMP".
     *
     * If the meaning of "SPM_e32_OVERTEMP" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_OVERTEMP The value which will be set
     */
    inline void setSPM_e32_OVERTEMP (bool SPM_e32_OVERTEMP);

    /**
     * Returns the value of the member "SPM_e32_OVERTEMP".
     *
     * If the meaning of "SPM_e32_OVERTEMP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_OVERTEMP"
     */
    inline bool getSPM_e32_OVERTEMP () const;

    /**
     * Sets the value of the member "SPM_e32_LOCK_ACTIVITY".
     *
     * If the meaning of "SPM_e32_LOCK_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_LOCK_ACTIVITY The value which will be set
     */
    inline void setSPM_e32_LOCK_ACTIVITY (bool SPM_e32_LOCK_ACTIVITY);

    /**
     * Returns the value of the member "SPM_e32_LOCK_ACTIVITY".
     *
     * If the meaning of "SPM_e32_LOCK_ACTIVITY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_LOCK_ACTIVITY"
     */
    inline bool getSPM_e32_LOCK_ACTIVITY () const;

    /**
     * Sets the value of the member "SPM_e32_SYSSTATE_CHECK".
     *
     * If the meaning of "SPM_e32_SYSSTATE_CHECK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SYSSTATE_CHECK The value which will be set
     */
    inline void setSPM_e32_SYSSTATE_CHECK (bool SPM_e32_SYSSTATE_CHECK);

    /**
     * Returns the value of the member "SPM_e32_SYSSTATE_CHECK".
     *
     * If the meaning of "SPM_e32_SYSSTATE_CHECK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SYSSTATE_CHECK"
     */
    inline bool getSPM_e32_SYSSTATE_CHECK () const;

    /**
     * Sets the value of the member "SPM_e32_CR_TEMPERATURE".
     *
     * If the meaning of "SPM_e32_CR_TEMPERATURE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CR_TEMPERATURE The value which will be set
     */
    inline void setSPM_e32_CR_TEMPERATURE (bool SPM_e32_CR_TEMPERATURE);

    /**
     * Returns the value of the member "SPM_e32_CR_TEMPERATURE".
     *
     * If the meaning of "SPM_e32_CR_TEMPERATURE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CR_TEMPERATURE"
     */
    inline bool getSPM_e32_CR_TEMPERATURE () const;

    /**
     * Sets the value of the member "SPM_e32_PUSH_TO_TALK".
     *
     * If the meaning of "SPM_e32_PUSH_TO_TALK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_PUSH_TO_TALK The value which will be set
     */
    inline void setSPM_e32_PUSH_TO_TALK (bool SPM_e32_PUSH_TO_TALK);

    /**
     * Returns the value of the member "SPM_e32_PUSH_TO_TALK".
     *
     * If the meaning of "SPM_e32_PUSH_TO_TALK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_PUSH_TO_TALK"
     */
    inline bool getSPM_e32_PUSH_TO_TALK () const;

    /**
     * Sets the value of the member "SPM_e32_ROUTEGUIDANCE_ACTIVE".
     *
     * If the meaning of "SPM_e32_ROUTEGUIDANCE_ACTIVE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ROUTEGUIDANCE_ACTIVE The value which will be set
     */
    inline void setSPM_e32_ROUTEGUIDANCE_ACTIVE (bool SPM_e32_ROUTEGUIDANCE_ACTIVE);

    /**
     * Returns the value of the member "SPM_e32_ROUTEGUIDANCE_ACTIVE".
     *
     * If the meaning of "SPM_e32_ROUTEGUIDANCE_ACTIVE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ROUTEGUIDANCE_ACTIVE"
     */
    inline bool getSPM_e32_ROUTEGUIDANCE_ACTIVE () const;

    /**
     * Sets the value of the member "SPM_e32_HW_IGNITION".
     *
     * If the meaning of "SPM_e32_HW_IGNITION" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_HW_IGNITION The value which will be set
     */
    inline void setSPM_e32_HW_IGNITION (bool SPM_e32_HW_IGNITION);

    /**
     * Returns the value of the member "SPM_e32_HW_IGNITION".
     *
     * If the meaning of "SPM_e32_HW_IGNITION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_HW_IGNITION"
     */
    inline bool getSPM_e32_HW_IGNITION () const;

    /**
     * Sets the value of the member "SPM_e32_CAN_WAKEUP".
     *
     * If the meaning of "SPM_e32_CAN_WAKEUP" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CAN_WAKEUP The value which will be set
     */
    inline void setSPM_e32_CAN_WAKEUP (bool SPM_e32_CAN_WAKEUP);

    /**
     * Returns the value of the member "SPM_e32_CAN_WAKEUP".
     *
     * If the meaning of "SPM_e32_CAN_WAKEUP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CAN_WAKEUP"
     */
    inline bool getSPM_e32_CAN_WAKEUP () const;

    /**
     * Sets the value of the member "SPM_e32_DOWNLOAD_PERMISSION".
     *
     * If the meaning of "SPM_e32_DOWNLOAD_PERMISSION" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DOWNLOAD_PERMISSION The value which will be set
     */
    inline void setSPM_e32_DOWNLOAD_PERMISSION (bool SPM_e32_DOWNLOAD_PERMISSION);

    /**
     * Returns the value of the member "SPM_e32_DOWNLOAD_PERMISSION".
     *
     * If the meaning of "SPM_e32_DOWNLOAD_PERMISSION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DOWNLOAD_PERMISSION"
     */
    inline bool getSPM_e32_DOWNLOAD_PERMISSION () const;

    /**
     * Sets the value of the member "SPM_e32_IGNITION_LOGIC".
     *
     * If the meaning of "SPM_e32_IGNITION_LOGIC" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_IGNITION_LOGIC The value which will be set
     */
    inline void setSPM_e32_IGNITION_LOGIC (bool SPM_e32_IGNITION_LOGIC);

    /**
     * Returns the value of the member "SPM_e32_IGNITION_LOGIC".
     *
     * If the meaning of "SPM_e32_IGNITION_LOGIC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_IGNITION_LOGIC"
     */
    inline bool getSPM_e32_IGNITION_LOGIC () const;

    /**
     * Sets the value of the member "SPM_e32_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_LOW_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_LOW_VOLTAGE (bool SPM_e32_LOW_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_LOW_VOLTAGE"
     */
    inline bool getSPM_e32_LOW_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_STATE_DEBOUNCE".
     *
     * If the meaning of "SPM_e32_STATE_DEBOUNCE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_STATE_DEBOUNCE The value which will be set
     */
    inline void setSPM_e32_STATE_DEBOUNCE (bool SPM_e32_STATE_DEBOUNCE);

    /**
     * Returns the value of the member "SPM_e32_STATE_DEBOUNCE".
     *
     * If the meaning of "SPM_e32_STATE_DEBOUNCE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_STATE_DEBOUNCE"
     */
    inline bool getSPM_e32_STATE_DEBOUNCE () const;

    /**
     * Sets the value of the member "SPM_e32_NETWORK_FAILURE".
     *
     * If the meaning of "SPM_e32_NETWORK_FAILURE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_NETWORK_FAILURE The value which will be set
     */
    inline void setSPM_e32_NETWORK_FAILURE (bool SPM_e32_NETWORK_FAILURE);

    /**
     * Returns the value of the member "SPM_e32_NETWORK_FAILURE".
     *
     * If the meaning of "SPM_e32_NETWORK_FAILURE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_NETWORK_FAILURE"
     */
    inline bool getSPM_e32_NETWORK_FAILURE () const;

    /**
     * Sets the value of the member "SPM_e32_STATE_TO".
     *
     * If the meaning of "SPM_e32_STATE_TO" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_STATE_TO The value which will be set
     */
    inline void setSPM_e32_STATE_TO (bool SPM_e32_STATE_TO);

    /**
     * Returns the value of the member "SPM_e32_STATE_TO".
     *
     * If the meaning of "SPM_e32_STATE_TO" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_STATE_TO"
     */
    inline bool getSPM_e32_STATE_TO () const;

    /**
     * Sets the value of the member "SPM_e32_DEBUG_WAKEUP".
     *
     * If the meaning of "SPM_e32_DEBUG_WAKEUP" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DEBUG_WAKEUP The value which will be set
     */
    inline void setSPM_e32_DEBUG_WAKEUP (bool SPM_e32_DEBUG_WAKEUP);

    /**
     * Returns the value of the member "SPM_e32_DEBUG_WAKEUP".
     *
     * If the meaning of "SPM_e32_DEBUG_WAKEUP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DEBUG_WAKEUP"
     */
    inline bool getSPM_e32_DEBUG_WAKEUP () const;

    /**
     * Sets the value of the member "SPM_e32_AUTOMATIC".
     *
     * If the meaning of "SPM_e32_AUTOMATIC" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_AUTOMATIC The value which will be set
     */
    inline void setSPM_e32_AUTOMATIC (bool SPM_e32_AUTOMATIC);

    /**
     * Returns the value of the member "SPM_e32_AUTOMATIC".
     *
     * If the meaning of "SPM_e32_AUTOMATIC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_AUTOMATIC"
     */
    inline bool getSPM_e32_AUTOMATIC () const;

    /**
     * Sets the value of the member "SPM_e32_CODE_REQUEST".
     *
     * If the meaning of "SPM_e32_CODE_REQUEST" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CODE_REQUEST The value which will be set
     */
    inline void setSPM_e32_CODE_REQUEST (bool SPM_e32_CODE_REQUEST);

    /**
     * Returns the value of the member "SPM_e32_CODE_REQUEST".
     *
     * If the meaning of "SPM_e32_CODE_REQUEST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CODE_REQUEST"
     */
    inline bool getSPM_e32_CODE_REQUEST () const;

    /**
     * Sets the value of the member "SPM_e32_SYNC_SHUTDOWN_ACK".
     *
     * If the meaning of "SPM_e32_SYNC_SHUTDOWN_ACK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SYNC_SHUTDOWN_ACK The value which will be set
     */
    inline void setSPM_e32_SYNC_SHUTDOWN_ACK (bool SPM_e32_SYNC_SHUTDOWN_ACK);

    /**
     * Returns the value of the member "SPM_e32_SYNC_SHUTDOWN_ACK".
     *
     * If the meaning of "SPM_e32_SYNC_SHUTDOWN_ACK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SYNC_SHUTDOWN_ACK"
     */
    inline bool getSPM_e32_SYNC_SHUTDOWN_ACK () const;

    static const T_b32_SubState1 &getDefaultInstance();

private:

    bool _SPM_e32_HEARTBEAT:1;

    bool _SPM_e32_USER_ON_REQ:1;

    bool _SPM_e32_BACKGROUND_ON_REQ:1;

    bool _SPM_e32_MULTIMEDIA_ON:1;

    bool _SPM_e32_ANIMATION:1;

    bool _SPM_e32_MULTIMEDIA_OPERATION:1;

    bool _SPM_e32_TELEMATIC_ACTIVE:1;

    bool _SPM_e32_STANDBY_REQ:1;

    bool _SPM_e32_ACCESSORY_ACTIVE:1;

    bool _SPM_e32_SHUTDOWN_BATTERY_SAVING:1;

    bool _SPM_e32_TML_REQ_BACKGROUND:1;

    bool _SPM_e32_IGNITION_TIMEOUT:1;

    bool _SPM_e32_IGNITION_INVALID:1;

    bool _SPM_e32_FIRST_PIC_DRAWN:1;

    bool _SPM_e32_OVERTEMP:1;

    bool _SPM_e32_LOCK_ACTIVITY:1;

    bool _SPM_e32_SYSSTATE_CHECK:1;

    bool _SPM_e32_CR_TEMPERATURE:1;

    bool _SPM_e32_PUSH_TO_TALK:1;

    bool _SPM_e32_ROUTEGUIDANCE_ACTIVE:1;

    bool _SPM_e32_HW_IGNITION:1;

    bool _SPM_e32_CAN_WAKEUP:1;

    bool _SPM_e32_DOWNLOAD_PERMISSION:1;

    bool _SPM_e32_IGNITION_LOGIC:1;

    bool _SPM_e32_LOW_VOLTAGE:1;

    bool _SPM_e32_STATE_DEBOUNCE:1;

    bool _SPM_e32_NETWORK_FAILURE:1;

    bool _SPM_e32_STATE_TO:1;

    bool _SPM_e32_DEBUG_WAKEUP:1;

    bool _SPM_e32_AUTOMATIC:1;

    bool _SPM_e32_CODE_REQUEST:1;

    bool _SPM_e32_SYNC_SHUTDOWN_ACK:1;

};

/**
 * On/Off reasons 1..32 (bit-coded).
 */
class T_b32_SubState2 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState2 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState2 (const T_b32_SubState2 &c);

    /**
     * Field constructor
     */
    inline  T_b32_SubState2 (bool SPM_e32_FRIENDLY_USER, bool SPM_e32_NISSAN_CMF1, bool SPM_e32_PREPARE_SHUTDOWN, bool SPM_e32_SHUTDOWN, bool SPM_e32_HKEY_PRESSED, bool SPM_e32_CD_INSERT_CLAMPS, bool SPM_e32_CRITICAL_LOW_VOLTAGE, bool SPM_e32_ENDURING_LOW_VOLTAGE, bool SPM_e32_DIAG_FAST_SHUTDOWN, bool SPM_e32_USING_ACCESSORY, bool SPM_e32_BACKGROUND_IMM_OFF, bool SPM_e32_ROLLER_RIG_MODE, bool SPM_e32_REMOTE_ON_ACTIVE, bool SPM_e32_ENDURING_CR_VOLTAGE, bool SPM_e32_NORMAL_VOLT, bool SPM_e32_Q_CRITICAL, bool SPM_e32_TRIGGER_RESET, bool SPM_e32_CAR_WAKEUP, bool SPM_e32_PHONE_CONNECTED, bool SPM_e32_CUSTOMER_DOWNLOAD, bool SPM_e32_STARTUP, bool SPM_e32_MOST_OFF, bool SPM_e32_MOST_OFF_ERR, bool SPM_e32_MOST_WAIT_FOR_SHUTDOWN, bool SPM_e32_MOST_RBD, bool SPM_e32_MOST_SHUTDOWN_EXECUTE, bool SPM_e32_MOST_PWR_SWITCH_OFF_DELAY, bool SPM_e32_SYSSTATE_NETWORK_FAILED, bool SPM_e32_SAFE, bool SPM_e32_FSM_SHUTDOWN_FINISHED, bool SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK, bool SPM_e32_WAIT_FOR_FSM_RESTART_ACK);

    /**
     * Assignment operator
     */
    inline T_b32_SubState2& operator = (const T_b32_SubState2& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState2& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState2& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState2& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState2& rhs) const;

    /**
     * Sets the value of the member "SPM_e32_FRIENDLY_USER".
     *
     * If the meaning of "SPM_e32_FRIENDLY_USER" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FRIENDLY_USER The value which will be set
     */
    inline void setSPM_e32_FRIENDLY_USER (bool SPM_e32_FRIENDLY_USER);

    /**
     * Returns the value of the member "SPM_e32_FRIENDLY_USER".
     *
     * If the meaning of "SPM_e32_FRIENDLY_USER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FRIENDLY_USER"
     */
    inline bool getSPM_e32_FRIENDLY_USER () const;

    /**
     * Sets the value of the member "SPM_e32_NISSAN_CMF1".
     *
     * If the meaning of "SPM_e32_NISSAN_CMF1" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_NISSAN_CMF1 The value which will be set
     */
    inline void setSPM_e32_NISSAN_CMF1 (bool SPM_e32_NISSAN_CMF1);

    /**
     * Returns the value of the member "SPM_e32_NISSAN_CMF1".
     *
     * If the meaning of "SPM_e32_NISSAN_CMF1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_NISSAN_CMF1"
     */
    inline bool getSPM_e32_NISSAN_CMF1 () const;

    /**
     * Sets the value of the member "SPM_e32_PREPARE_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_PREPARE_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_PREPARE_SHUTDOWN The value which will be set
     */
    inline void setSPM_e32_PREPARE_SHUTDOWN (bool SPM_e32_PREPARE_SHUTDOWN);

    /**
     * Returns the value of the member "SPM_e32_PREPARE_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_PREPARE_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_PREPARE_SHUTDOWN"
     */
    inline bool getSPM_e32_PREPARE_SHUTDOWN () const;

    /**
     * Sets the value of the member "SPM_e32_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SHUTDOWN The value which will be set
     */
    inline void setSPM_e32_SHUTDOWN (bool SPM_e32_SHUTDOWN);

    /**
     * Returns the value of the member "SPM_e32_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SHUTDOWN"
     */
    inline bool getSPM_e32_SHUTDOWN () const;

    /**
     * Sets the value of the member "SPM_e32_HKEY_PRESSED".
     *
     * If the meaning of "SPM_e32_HKEY_PRESSED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_HKEY_PRESSED The value which will be set
     */
    inline void setSPM_e32_HKEY_PRESSED (bool SPM_e32_HKEY_PRESSED);

    /**
     * Returns the value of the member "SPM_e32_HKEY_PRESSED".
     *
     * If the meaning of "SPM_e32_HKEY_PRESSED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_HKEY_PRESSED"
     */
    inline bool getSPM_e32_HKEY_PRESSED () const;

    /**
     * Sets the value of the member "SPM_e32_CD_INSERT_CLAMPS".
     *
     * If the meaning of "SPM_e32_CD_INSERT_CLAMPS" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CD_INSERT_CLAMPS The value which will be set
     */
    inline void setSPM_e32_CD_INSERT_CLAMPS (bool SPM_e32_CD_INSERT_CLAMPS);

    /**
     * Returns the value of the member "SPM_e32_CD_INSERT_CLAMPS".
     *
     * If the meaning of "SPM_e32_CD_INSERT_CLAMPS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CD_INSERT_CLAMPS"
     */
    inline bool getSPM_e32_CD_INSERT_CLAMPS () const;

    /**
     * Sets the value of the member "SPM_e32_CRITICAL_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_CRITICAL_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CRITICAL_LOW_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_CRITICAL_LOW_VOLTAGE (bool SPM_e32_CRITICAL_LOW_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_CRITICAL_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_CRITICAL_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CRITICAL_LOW_VOLTAGE"
     */
    inline bool getSPM_e32_CRITICAL_LOW_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_ENDURING_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ENDURING_LOW_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_ENDURING_LOW_VOLTAGE (bool SPM_e32_ENDURING_LOW_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_ENDURING_LOW_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_LOW_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ENDURING_LOW_VOLTAGE"
     */
    inline bool getSPM_e32_ENDURING_LOW_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_DIAG_FAST_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_DIAG_FAST_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_DIAG_FAST_SHUTDOWN The value which will be set
     */
    inline void setSPM_e32_DIAG_FAST_SHUTDOWN (bool SPM_e32_DIAG_FAST_SHUTDOWN);

    /**
     * Returns the value of the member "SPM_e32_DIAG_FAST_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_DIAG_FAST_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_DIAG_FAST_SHUTDOWN"
     */
    inline bool getSPM_e32_DIAG_FAST_SHUTDOWN () const;

    /**
     * Sets the value of the member "SPM_e32_USING_ACCESSORY".
     *
     * If the meaning of "SPM_e32_USING_ACCESSORY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_USING_ACCESSORY The value which will be set
     */
    inline void setSPM_e32_USING_ACCESSORY (bool SPM_e32_USING_ACCESSORY);

    /**
     * Returns the value of the member "SPM_e32_USING_ACCESSORY".
     *
     * If the meaning of "SPM_e32_USING_ACCESSORY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_USING_ACCESSORY"
     */
    inline bool getSPM_e32_USING_ACCESSORY () const;

    /**
     * Sets the value of the member "SPM_e32_BACKGROUND_IMM_OFF".
     *
     * If the meaning of "SPM_e32_BACKGROUND_IMM_OFF" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_BACKGROUND_IMM_OFF The value which will be set
     */
    inline void setSPM_e32_BACKGROUND_IMM_OFF (bool SPM_e32_BACKGROUND_IMM_OFF);

    /**
     * Returns the value of the member "SPM_e32_BACKGROUND_IMM_OFF".
     *
     * If the meaning of "SPM_e32_BACKGROUND_IMM_OFF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_BACKGROUND_IMM_OFF"
     */
    inline bool getSPM_e32_BACKGROUND_IMM_OFF () const;

    /**
     * Sets the value of the member "SPM_e32_ROLLER_RIG_MODE".
     *
     * If the meaning of "SPM_e32_ROLLER_RIG_MODE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ROLLER_RIG_MODE The value which will be set
     */
    inline void setSPM_e32_ROLLER_RIG_MODE (bool SPM_e32_ROLLER_RIG_MODE);

    /**
     * Returns the value of the member "SPM_e32_ROLLER_RIG_MODE".
     *
     * If the meaning of "SPM_e32_ROLLER_RIG_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ROLLER_RIG_MODE"
     */
    inline bool getSPM_e32_ROLLER_RIG_MODE () const;

    /**
     * Sets the value of the member "SPM_e32_REMOTE_ON_ACTIVE".
     *
     * If the meaning of "SPM_e32_REMOTE_ON_ACTIVE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_REMOTE_ON_ACTIVE The value which will be set
     */
    inline void setSPM_e32_REMOTE_ON_ACTIVE (bool SPM_e32_REMOTE_ON_ACTIVE);

    /**
     * Returns the value of the member "SPM_e32_REMOTE_ON_ACTIVE".
     *
     * If the meaning of "SPM_e32_REMOTE_ON_ACTIVE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_REMOTE_ON_ACTIVE"
     */
    inline bool getSPM_e32_REMOTE_ON_ACTIVE () const;

    /**
     * Sets the value of the member "SPM_e32_ENDURING_CR_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_CR_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ENDURING_CR_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_ENDURING_CR_VOLTAGE (bool SPM_e32_ENDURING_CR_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_ENDURING_CR_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_CR_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ENDURING_CR_VOLTAGE"
     */
    inline bool getSPM_e32_ENDURING_CR_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_NORMAL_VOLT".
     *
     * If the meaning of "SPM_e32_NORMAL_VOLT" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_NORMAL_VOLT The value which will be set
     */
    inline void setSPM_e32_NORMAL_VOLT (bool SPM_e32_NORMAL_VOLT);

    /**
     * Returns the value of the member "SPM_e32_NORMAL_VOLT".
     *
     * If the meaning of "SPM_e32_NORMAL_VOLT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_NORMAL_VOLT"
     */
    inline bool getSPM_e32_NORMAL_VOLT () const;

    /**
     * Sets the value of the member "SPM_e32_Q_CRITICAL".
     *
     * If the meaning of "SPM_e32_Q_CRITICAL" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_Q_CRITICAL The value which will be set
     */
    inline void setSPM_e32_Q_CRITICAL (bool SPM_e32_Q_CRITICAL);

    /**
     * Returns the value of the member "SPM_e32_Q_CRITICAL".
     *
     * If the meaning of "SPM_e32_Q_CRITICAL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_Q_CRITICAL"
     */
    inline bool getSPM_e32_Q_CRITICAL () const;

    /**
     * Sets the value of the member "SPM_e32_TRIGGER_RESET".
     *
     * If the meaning of "SPM_e32_TRIGGER_RESET" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TRIGGER_RESET The value which will be set
     */
    inline void setSPM_e32_TRIGGER_RESET (bool SPM_e32_TRIGGER_RESET);

    /**
     * Returns the value of the member "SPM_e32_TRIGGER_RESET".
     *
     * If the meaning of "SPM_e32_TRIGGER_RESET" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TRIGGER_RESET"
     */
    inline bool getSPM_e32_TRIGGER_RESET () const;

    /**
     * Sets the value of the member "SPM_e32_CAR_WAKEUP".
     *
     * If the meaning of "SPM_e32_CAR_WAKEUP" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CAR_WAKEUP The value which will be set
     */
    inline void setSPM_e32_CAR_WAKEUP (bool SPM_e32_CAR_WAKEUP);

    /**
     * Returns the value of the member "SPM_e32_CAR_WAKEUP".
     *
     * If the meaning of "SPM_e32_CAR_WAKEUP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CAR_WAKEUP"
     */
    inline bool getSPM_e32_CAR_WAKEUP () const;

    /**
     * Sets the value of the member "SPM_e32_PHONE_CONNECTED".
     *
     * If the meaning of "SPM_e32_PHONE_CONNECTED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_PHONE_CONNECTED The value which will be set
     */
    inline void setSPM_e32_PHONE_CONNECTED (bool SPM_e32_PHONE_CONNECTED);

    /**
     * Returns the value of the member "SPM_e32_PHONE_CONNECTED".
     *
     * If the meaning of "SPM_e32_PHONE_CONNECTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_PHONE_CONNECTED"
     */
    inline bool getSPM_e32_PHONE_CONNECTED () const;

    /**
     * Sets the value of the member "SPM_e32_CUSTOMER_DOWNLOAD".
     *
     * If the meaning of "SPM_e32_CUSTOMER_DOWNLOAD" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CUSTOMER_DOWNLOAD The value which will be set
     */
    inline void setSPM_e32_CUSTOMER_DOWNLOAD (bool SPM_e32_CUSTOMER_DOWNLOAD);

    /**
     * Returns the value of the member "SPM_e32_CUSTOMER_DOWNLOAD".
     *
     * If the meaning of "SPM_e32_CUSTOMER_DOWNLOAD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CUSTOMER_DOWNLOAD"
     */
    inline bool getSPM_e32_CUSTOMER_DOWNLOAD () const;

    /**
     * Sets the value of the member "SPM_e32_STARTUP".
     *
     * If the meaning of "SPM_e32_STARTUP" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_STARTUP The value which will be set
     */
    inline void setSPM_e32_STARTUP (bool SPM_e32_STARTUP);

    /**
     * Returns the value of the member "SPM_e32_STARTUP".
     *
     * If the meaning of "SPM_e32_STARTUP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_STARTUP"
     */
    inline bool getSPM_e32_STARTUP () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_OFF".
     *
     * If the meaning of "SPM_e32_MOST_OFF" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_OFF The value which will be set
     */
    inline void setSPM_e32_MOST_OFF (bool SPM_e32_MOST_OFF);

    /**
     * Returns the value of the member "SPM_e32_MOST_OFF".
     *
     * If the meaning of "SPM_e32_MOST_OFF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_OFF"
     */
    inline bool getSPM_e32_MOST_OFF () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_OFF_ERR".
     *
     * If the meaning of "SPM_e32_MOST_OFF_ERR" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_OFF_ERR The value which will be set
     */
    inline void setSPM_e32_MOST_OFF_ERR (bool SPM_e32_MOST_OFF_ERR);

    /**
     * Returns the value of the member "SPM_e32_MOST_OFF_ERR".
     *
     * If the meaning of "SPM_e32_MOST_OFF_ERR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_OFF_ERR"
     */
    inline bool getSPM_e32_MOST_OFF_ERR () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_WAIT_FOR_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_MOST_WAIT_FOR_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_WAIT_FOR_SHUTDOWN The value which will be set
     */
    inline void setSPM_e32_MOST_WAIT_FOR_SHUTDOWN (bool SPM_e32_MOST_WAIT_FOR_SHUTDOWN);

    /**
     * Returns the value of the member "SPM_e32_MOST_WAIT_FOR_SHUTDOWN".
     *
     * If the meaning of "SPM_e32_MOST_WAIT_FOR_SHUTDOWN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_WAIT_FOR_SHUTDOWN"
     */
    inline bool getSPM_e32_MOST_WAIT_FOR_SHUTDOWN () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_RBD".
     *
     * If the meaning of "SPM_e32_MOST_RBD" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_RBD The value which will be set
     */
    inline void setSPM_e32_MOST_RBD (bool SPM_e32_MOST_RBD);

    /**
     * Returns the value of the member "SPM_e32_MOST_RBD".
     *
     * If the meaning of "SPM_e32_MOST_RBD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_RBD"
     */
    inline bool getSPM_e32_MOST_RBD () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_SHUTDOWN_EXECUTE".
     *
     * If the meaning of "SPM_e32_MOST_SHUTDOWN_EXECUTE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_SHUTDOWN_EXECUTE The value which will be set
     */
    inline void setSPM_e32_MOST_SHUTDOWN_EXECUTE (bool SPM_e32_MOST_SHUTDOWN_EXECUTE);

    /**
     * Returns the value of the member "SPM_e32_MOST_SHUTDOWN_EXECUTE".
     *
     * If the meaning of "SPM_e32_MOST_SHUTDOWN_EXECUTE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_SHUTDOWN_EXECUTE"
     */
    inline bool getSPM_e32_MOST_SHUTDOWN_EXECUTE () const;

    /**
     * Sets the value of the member "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY".
     *
     * If the meaning of "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_MOST_PWR_SWITCH_OFF_DELAY The value which will be set
     */
    inline void setSPM_e32_MOST_PWR_SWITCH_OFF_DELAY (bool SPM_e32_MOST_PWR_SWITCH_OFF_DELAY);

    /**
     * Returns the value of the member "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY".
     *
     * If the meaning of "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_MOST_PWR_SWITCH_OFF_DELAY"
     */
    inline bool getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY () const;

    /**
     * Sets the value of the member "SPM_e32_SYSSTATE_NETWORK_FAILED".
     *
     * If the meaning of "SPM_e32_SYSSTATE_NETWORK_FAILED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SYSSTATE_NETWORK_FAILED The value which will be set
     */
    inline void setSPM_e32_SYSSTATE_NETWORK_FAILED (bool SPM_e32_SYSSTATE_NETWORK_FAILED);

    /**
     * Returns the value of the member "SPM_e32_SYSSTATE_NETWORK_FAILED".
     *
     * If the meaning of "SPM_e32_SYSSTATE_NETWORK_FAILED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SYSSTATE_NETWORK_FAILED"
     */
    inline bool getSPM_e32_SYSSTATE_NETWORK_FAILED () const;

    /**
     * Sets the value of the member "SPM_e32_SAFE".
     *
     * If the meaning of "SPM_e32_SAFE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_SAFE The value which will be set
     */
    inline void setSPM_e32_SAFE (bool SPM_e32_SAFE);

    /**
     * Returns the value of the member "SPM_e32_SAFE".
     *
     * If the meaning of "SPM_e32_SAFE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_SAFE"
     */
    inline bool getSPM_e32_SAFE () const;

    /**
     * Sets the value of the member "SPM_e32_FSM_SHUTDOWN_FINISHED".
     *
     * If the meaning of "SPM_e32_FSM_SHUTDOWN_FINISHED" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FSM_SHUTDOWN_FINISHED The value which will be set
     */
    inline void setSPM_e32_FSM_SHUTDOWN_FINISHED (bool SPM_e32_FSM_SHUTDOWN_FINISHED);

    /**
     * Returns the value of the member "SPM_e32_FSM_SHUTDOWN_FINISHED".
     *
     * If the meaning of "SPM_e32_FSM_SHUTDOWN_FINISHED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FSM_SHUTDOWN_FINISHED"
     */
    inline bool getSPM_e32_FSM_SHUTDOWN_FINISHED () const;

    /**
     * Sets the value of the member "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK".
     *
     * If the meaning of "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK The value which will be set
     */
    inline void setSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK (bool SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK);

    /**
     * Returns the value of the member "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK".
     *
     * If the meaning of "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK"
     */
    inline bool getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK () const;

    /**
     * Sets the value of the member "SPM_e32_WAIT_FOR_FSM_RESTART_ACK".
     *
     * If the meaning of "SPM_e32_WAIT_FOR_FSM_RESTART_ACK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_WAIT_FOR_FSM_RESTART_ACK The value which will be set
     */
    inline void setSPM_e32_WAIT_FOR_FSM_RESTART_ACK (bool SPM_e32_WAIT_FOR_FSM_RESTART_ACK);

    /**
     * Returns the value of the member "SPM_e32_WAIT_FOR_FSM_RESTART_ACK".
     *
     * If the meaning of "SPM_e32_WAIT_FOR_FSM_RESTART_ACK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_WAIT_FOR_FSM_RESTART_ACK"
     */
    inline bool getSPM_e32_WAIT_FOR_FSM_RESTART_ACK () const;

    static const T_b32_SubState2 &getDefaultInstance();

private:

    bool _SPM_e32_FRIENDLY_USER:1;

    bool _SPM_e32_NISSAN_CMF1:1;

    bool _SPM_e32_PREPARE_SHUTDOWN:1;

    bool _SPM_e32_SHUTDOWN:1;

    bool _SPM_e32_HKEY_PRESSED:1;

    bool _SPM_e32_CD_INSERT_CLAMPS:1;

    bool _SPM_e32_CRITICAL_LOW_VOLTAGE:1;

    bool _SPM_e32_ENDURING_LOW_VOLTAGE:1;

    bool _SPM_e32_DIAG_FAST_SHUTDOWN:1;

    bool _SPM_e32_USING_ACCESSORY:1;

    bool _SPM_e32_BACKGROUND_IMM_OFF:1;

    bool _SPM_e32_ROLLER_RIG_MODE:1;

    bool _SPM_e32_REMOTE_ON_ACTIVE:1;

    bool _SPM_e32_ENDURING_CR_VOLTAGE:1;

    bool _SPM_e32_NORMAL_VOLT:1;

    bool _SPM_e32_Q_CRITICAL:1;

    bool _SPM_e32_TRIGGER_RESET:1;

    bool _SPM_e32_CAR_WAKEUP:1;

    bool _SPM_e32_PHONE_CONNECTED:1;

    bool _SPM_e32_CUSTOMER_DOWNLOAD:1;

    bool _SPM_e32_STARTUP:1;

    bool _SPM_e32_MOST_OFF:1;

    bool _SPM_e32_MOST_OFF_ERR:1;

    bool _SPM_e32_MOST_WAIT_FOR_SHUTDOWN:1;

    bool _SPM_e32_MOST_RBD:1;

    bool _SPM_e32_MOST_SHUTDOWN_EXECUTE:1;

    bool _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY:1;

    bool _SPM_e32_SYSSTATE_NETWORK_FAILED:1;

    bool _SPM_e32_SAFE:1;

    bool _SPM_e32_FSM_SHUTDOWN_FINISHED:1;

    bool _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK:1;

    bool _SPM_e32_WAIT_FOR_FSM_RESTART_ACK:1;

};

/**
 * On/Off reasons 1..32 (bit-coded).
 */
class T_b32_SubState3 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState3 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState3 (const T_b32_SubState3 &c);

    /**
     * Field constructor
     */
    inline  T_b32_SubState3 (bool SPM_e32_VALET_MODE, bool SPM_e32_CRANK, bool SPM_e32_EMERGENCY_CALL, bool SPM_e32_LIN, bool SPM_e32_CELLNETWORK, bool SPM_e32_EXTERNAL_GPIO, bool SPM_e32_BLUETOOTH, bool SPM_e32_UART, bool SPM_e32_USB, bool SPM_e32_CRITICAL_HIGH_VOLTAGE, bool SPM_e32_ENDURING_HIGH_VOLTAGE, bool SPM_e32_OVER_THE_AIR);

    /**
     * Assignment operator
     */
    inline T_b32_SubState3& operator = (const T_b32_SubState3& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState3& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState3& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState3& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState3& rhs) const;

    /**
     * Sets the value of the member "SPM_e32_VALET_MODE".
     *
     * If the meaning of "SPM_e32_VALET_MODE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_VALET_MODE The value which will be set
     */
    inline void setSPM_e32_VALET_MODE (bool SPM_e32_VALET_MODE);

    /**
     * Returns the value of the member "SPM_e32_VALET_MODE".
     *
     * If the meaning of "SPM_e32_VALET_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_VALET_MODE"
     */
    inline bool getSPM_e32_VALET_MODE () const;

    /**
     * Sets the value of the member "SPM_e32_CRANK".
     *
     * If the meaning of "SPM_e32_CRANK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CRANK The value which will be set
     */
    inline void setSPM_e32_CRANK (bool SPM_e32_CRANK);

    /**
     * Returns the value of the member "SPM_e32_CRANK".
     *
     * If the meaning of "SPM_e32_CRANK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CRANK"
     */
    inline bool getSPM_e32_CRANK () const;

    /**
     * Sets the value of the member "SPM_e32_EMERGENCY_CALL".
     *
     * If the meaning of "SPM_e32_EMERGENCY_CALL" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_EMERGENCY_CALL The value which will be set
     */
    inline void setSPM_e32_EMERGENCY_CALL (bool SPM_e32_EMERGENCY_CALL);

    /**
     * Returns the value of the member "SPM_e32_EMERGENCY_CALL".
     *
     * If the meaning of "SPM_e32_EMERGENCY_CALL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_EMERGENCY_CALL"
     */
    inline bool getSPM_e32_EMERGENCY_CALL () const;

    /**
     * Sets the value of the member "SPM_e32_LIN".
     *
     * If the meaning of "SPM_e32_LIN" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_LIN The value which will be set
     */
    inline void setSPM_e32_LIN (bool SPM_e32_LIN);

    /**
     * Returns the value of the member "SPM_e32_LIN".
     *
     * If the meaning of "SPM_e32_LIN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_LIN"
     */
    inline bool getSPM_e32_LIN () const;

    /**
     * Sets the value of the member "SPM_e32_CELLNETWORK".
     *
     * If the meaning of "SPM_e32_CELLNETWORK" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CELLNETWORK The value which will be set
     */
    inline void setSPM_e32_CELLNETWORK (bool SPM_e32_CELLNETWORK);

    /**
     * Returns the value of the member "SPM_e32_CELLNETWORK".
     *
     * If the meaning of "SPM_e32_CELLNETWORK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CELLNETWORK"
     */
    inline bool getSPM_e32_CELLNETWORK () const;

    /**
     * Sets the value of the member "SPM_e32_EXTERNAL_GPIO".
     *
     * If the meaning of "SPM_e32_EXTERNAL_GPIO" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_EXTERNAL_GPIO The value which will be set
     */
    inline void setSPM_e32_EXTERNAL_GPIO (bool SPM_e32_EXTERNAL_GPIO);

    /**
     * Returns the value of the member "SPM_e32_EXTERNAL_GPIO".
     *
     * If the meaning of "SPM_e32_EXTERNAL_GPIO" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_EXTERNAL_GPIO"
     */
    inline bool getSPM_e32_EXTERNAL_GPIO () const;

    /**
     * Sets the value of the member "SPM_e32_BLUETOOTH".
     *
     * If the meaning of "SPM_e32_BLUETOOTH" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_BLUETOOTH The value which will be set
     */
    inline void setSPM_e32_BLUETOOTH (bool SPM_e32_BLUETOOTH);

    /**
     * Returns the value of the member "SPM_e32_BLUETOOTH".
     *
     * If the meaning of "SPM_e32_BLUETOOTH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_BLUETOOTH"
     */
    inline bool getSPM_e32_BLUETOOTH () const;

    /**
     * Sets the value of the member "SPM_e32_UART".
     *
     * If the meaning of "SPM_e32_UART" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_UART The value which will be set
     */
    inline void setSPM_e32_UART (bool SPM_e32_UART);

    /**
     * Returns the value of the member "SPM_e32_UART".
     *
     * If the meaning of "SPM_e32_UART" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_UART"
     */
    inline bool getSPM_e32_UART () const;

    /**
     * Sets the value of the member "SPM_e32_USB".
     *
     * If the meaning of "SPM_e32_USB" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_USB The value which will be set
     */
    inline void setSPM_e32_USB (bool SPM_e32_USB);

    /**
     * Returns the value of the member "SPM_e32_USB".
     *
     * If the meaning of "SPM_e32_USB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_USB"
     */
    inline bool getSPM_e32_USB () const;

    /**
     * Sets the value of the member "SPM_e32_CRITICAL_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_CRITICAL_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_CRITICAL_HIGH_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_CRITICAL_HIGH_VOLTAGE (bool SPM_e32_CRITICAL_HIGH_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_CRITICAL_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_CRITICAL_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_CRITICAL_HIGH_VOLTAGE"
     */
    inline bool getSPM_e32_CRITICAL_HIGH_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_ENDURING_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ENDURING_HIGH_VOLTAGE The value which will be set
     */
    inline void setSPM_e32_ENDURING_HIGH_VOLTAGE (bool SPM_e32_ENDURING_HIGH_VOLTAGE);

    /**
     * Returns the value of the member "SPM_e32_ENDURING_HIGH_VOLTAGE".
     *
     * If the meaning of "SPM_e32_ENDURING_HIGH_VOLTAGE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ENDURING_HIGH_VOLTAGE"
     */
    inline bool getSPM_e32_ENDURING_HIGH_VOLTAGE () const;

    /**
     * Sets the value of the member "SPM_e32_OVER_THE_AIR".
     *
     * If the meaning of "SPM_e32_OVER_THE_AIR" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_OVER_THE_AIR The value which will be set
     */
    inline void setSPM_e32_OVER_THE_AIR (bool SPM_e32_OVER_THE_AIR);

    /**
     * Returns the value of the member "SPM_e32_OVER_THE_AIR".
     *
     * If the meaning of "SPM_e32_OVER_THE_AIR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_OVER_THE_AIR"
     */
    inline bool getSPM_e32_OVER_THE_AIR () const;

    static const T_b32_SubState3 &getDefaultInstance();

private:

    bool _SPM_e32_VALET_MODE:1;

    bool _SPM_e32_CRANK:1;

    bool _SPM_e32_EMERGENCY_CALL:1;

    bool _SPM_e32_LIN:1;

    bool _SPM_e32_CELLNETWORK:1;

    bool _SPM_e32_EXTERNAL_GPIO:1;

    bool _SPM_e32_BLUETOOTH:1;

    bool _SPM_e32_UART:1;

    bool _SPM_e32_USB:1;

    bool _SPM_e32_CRITICAL_HIGH_VOLTAGE:1;

    bool _SPM_e32_ENDURING_HIGH_VOLTAGE:1;

    bool _SPM_e32_OVER_THE_AIR:1;

};

/**
 * bitmap type of available states for DIMMING.
 */
class T_SPM_b32_DIM_STATE {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_b32_DIM_STATE ();

    /**
     * Copy constructor
     */
    inline  T_SPM_b32_DIM_STATE (const T_SPM_b32_DIM_STATE &c);

    /**
     * Field constructor
     */
    inline  T_SPM_b32_DIM_STATE (bool SPM_U32_DIMMINGSTATE, bool SPM_U32_DIMSMINGTATE_CLIMATE, bool SPM_U32_DIMMINGSTATE_BACKLIGHT, bool SPM_U32_DIMMINGSTATE_HOUR_MODE, bool SPM_U32_DIMMINGSTATE_ALL_OFF, bool SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF, bool SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED, bool SPM_U32DIMMINGSTATE_ALL_ON);

    /**
     * Assignment operator
     */
    inline T_SPM_b32_DIM_STATE& operator = (const T_SPM_b32_DIM_STATE& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE (bool SPM_U32_DIMMINGSTATE);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE"
     */
    inline bool getSPM_U32_DIMMINGSTATE () const;

    /**
     * Sets the value of the member "SPM_U32_DIMSMINGTATE_CLIMATE".
     *
     * If the meaning of "SPM_U32_DIMSMINGTATE_CLIMATE" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMSMINGTATE_CLIMATE The value which will be set
     */
    inline void setSPM_U32_DIMSMINGTATE_CLIMATE (bool SPM_U32_DIMSMINGTATE_CLIMATE);

    /**
     * Returns the value of the member "SPM_U32_DIMSMINGTATE_CLIMATE".
     *
     * If the meaning of "SPM_U32_DIMSMINGTATE_CLIMATE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMSMINGTATE_CLIMATE"
     */
    inline bool getSPM_U32_DIMSMINGTATE_CLIMATE () const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE_BACKLIGHT".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_BACKLIGHT" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE_BACKLIGHT The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE_BACKLIGHT (bool SPM_U32_DIMMINGSTATE_BACKLIGHT);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE_BACKLIGHT".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_BACKLIGHT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE_BACKLIGHT"
     */
    inline bool getSPM_U32_DIMMINGSTATE_BACKLIGHT () const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE_HOUR_MODE".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_HOUR_MODE" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE_HOUR_MODE The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE_HOUR_MODE (bool SPM_U32_DIMMINGSTATE_HOUR_MODE);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE_HOUR_MODE".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_HOUR_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE_HOUR_MODE"
     */
    inline bool getSPM_U32_DIMMINGSTATE_HOUR_MODE () const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE_ALL_OFF".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_ALL_OFF" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE_ALL_OFF The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE_ALL_OFF (bool SPM_U32_DIMMINGSTATE_ALL_OFF);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE_ALL_OFF".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_ALL_OFF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE_ALL_OFF"
     */
    inline bool getSPM_U32_DIMMINGSTATE_ALL_OFF () const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF (bool SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF"
     */
    inline bool getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF () const;

    /**
     * Sets the value of the member "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED" isn't clear, then there should be a description here.
     *
     * @param SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED The value which will be set
     */
    inline void setSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED (bool SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED);

    /**
     * Returns the value of the member "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED".
     *
     * If the meaning of "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED"
     */
    inline bool getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED () const;

    /**
     * Sets the value of the member "SPM_U32DIMMINGSTATE_ALL_ON".
     *
     * If the meaning of "SPM_U32DIMMINGSTATE_ALL_ON" isn't clear, then there should be a description here.
     *
     * @param SPM_U32DIMMINGSTATE_ALL_ON The value which will be set
     */
    inline void setSPM_U32DIMMINGSTATE_ALL_ON (bool SPM_U32DIMMINGSTATE_ALL_ON);

    /**
     * Returns the value of the member "SPM_U32DIMMINGSTATE_ALL_ON".
     *
     * If the meaning of "SPM_U32DIMMINGSTATE_ALL_ON" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_U32DIMMINGSTATE_ALL_ON"
     */
    inline bool getSPM_U32DIMMINGSTATE_ALL_ON () const;

    static const T_SPM_b32_DIM_STATE &getDefaultInstance();

private:

    bool _SPM_U32_DIMMINGSTATE:1;

    bool _SPM_U32_DIMSMINGTATE_CLIMATE:1;

    bool _SPM_U32_DIMMINGSTATE_BACKLIGHT:1;

    bool _SPM_U32_DIMMINGSTATE_HOUR_MODE:1;

    bool _SPM_U32_DIMMINGSTATE_ALL_OFF:1;

    bool _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF:1;

    bool _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED:1;

    bool _SPM_U32DIMMINGSTATE_ALL_ON:1;

};

/**
 * If the meaning of "T_SPM_HistoryTrigger" isn't clear, then there should be a description here.
 */
class T_SPM_HistoryTrigger {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_HistoryTrigger ();

    /**
     * Copy constructor
     */
    inline  T_SPM_HistoryTrigger (const T_SPM_HistoryTrigger &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_HistoryTrigger (uint32 u32Timestamp_, T_SPM_e32_SubStateType eTriggerType_);

    /**
     * Destructor
     */
    inline  ~T_SPM_HistoryTrigger();

    /**
     * Assignment operator
     */
    inline T_SPM_HistoryTrigger& operator = (const T_SPM_HistoryTrigger& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Timestamp"

    static const int kU32Timestamp = 0;

    /**
     * Clears the field "u32Timestamp".
     *
     * The field will be set to its default value. The hasU32Timestamp()
     * method will return false.
     */
    inline void clearU32Timestamp();

    /**
     * Checks whether the field "u32Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Timestamp()). Otherwise it will return false.
     */
    inline bool hasU32Timestamp () const;

    /**
     * Returns the value of the member "u32Timestamp".
     *
     * If the meaning of "u32Timestamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Timestamp"
     */
    inline uint32 getU32Timestamp () const;

    /**
     * Sets the value of the member "u32Timestamp".
     *
     * If the meaning of "u32Timestamp" isn't clear, then there should be a description here.
     *
     * @param u32Timestamp The value which will be set
     */
    inline void setU32Timestamp (uint32 u32Timestamp_);

    // API of field "eTriggerType"

    static const int kETriggerType = 1;

    /**
     * Clears the field "eTriggerType".
     *
     * The field will be set to its default value. The hasETriggerType()
     * method will return false.
     */
    inline void clearETriggerType();

    /**
     * Checks whether the field "eTriggerType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setETriggerType()). Otherwise it will return false.
     */
    inline bool hasETriggerType () const;

    /**
     * Returns the value of the member "eTriggerType".
     *
     * If the meaning of "eTriggerType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eTriggerType"
     */
    inline T_SPM_e32_SubStateType getETriggerType () const;

    /**
     * Sets the value of the member "eTriggerType".
     *
     * If the meaning of "eTriggerType" isn't clear, then there should be a description here.
     *
     * @param eTriggerType The value which will be set
     */
    inline void setETriggerType (T_SPM_e32_SubStateType eTriggerType_);

    static const T_SPM_HistoryTrigger &getDefaultInstance();

private:

    inline void set_has_u32Timestamp ();

    inline void clear_has_u32Timestamp ();

    inline void set_has_eTriggerType ();

    inline void clear_has_eTriggerType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Timestamp;

    T_SPM_e32_SubStateType _eTriggerType;

};

/**
 * If the meaning of "T_SPM_TransPortMode" isn't clear, then there should be a description here.
 */
class T_SPM_TransPortMode {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_TransPortMode ();

    /**
     * Copy constructor
     */
    inline  T_SPM_TransPortMode (const T_SPM_TransPortMode &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_TransPortMode (uint32 YEAR_, uint32 MONTH_, uint32 DAY_, uint32 HOUR_, uint32 MINUTE_);

    /**
     * Destructor
     */
    inline  ~T_SPM_TransPortMode();

    /**
     * Assignment operator
     */
    inline T_SPM_TransPortMode& operator = (const T_SPM_TransPortMode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_TransPortMode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_TransPortMode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_TransPortMode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_TransPortMode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "YEAR"

    static const int kYEAR = 0;

    /**
     * Clears the field "YEAR".
     *
     * The field will be set to its default value. The hasYEAR()
     * method will return false.
     */
    inline void clearYEAR();

    /**
     * Checks whether the field "YEAR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYEAR()). Otherwise it will return false.
     */
    inline bool hasYEAR () const;

    /**
     * Returns the value of the member "YEAR".
     *
     * If the meaning of "YEAR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "YEAR"
     */
    inline uint32 getYEAR () const;

    /**
     * Sets the value of the member "YEAR".
     *
     * If the meaning of "YEAR" isn't clear, then there should be a description here.
     *
     * @param YEAR The value which will be set
     */
    inline void setYEAR (uint32 YEAR_);

    // API of field "MONTH"

    static const int kMONTH = 1;

    /**
     * Clears the field "MONTH".
     *
     * The field will be set to its default value. The hasMONTH()
     * method will return false.
     */
    inline void clearMONTH();

    /**
     * Checks whether the field "MONTH" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMONTH()). Otherwise it will return false.
     */
    inline bool hasMONTH () const;

    /**
     * Returns the value of the member "MONTH".
     *
     * If the meaning of "MONTH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MONTH"
     */
    inline uint32 getMONTH () const;

    /**
     * Sets the value of the member "MONTH".
     *
     * If the meaning of "MONTH" isn't clear, then there should be a description here.
     *
     * @param MONTH The value which will be set
     */
    inline void setMONTH (uint32 MONTH_);

    // API of field "DAY"

    static const int kDAY = 2;

    /**
     * Clears the field "DAY".
     *
     * The field will be set to its default value. The hasDAY()
     * method will return false.
     */
    inline void clearDAY();

    /**
     * Checks whether the field "DAY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDAY()). Otherwise it will return false.
     */
    inline bool hasDAY () const;

    /**
     * Returns the value of the member "DAY".
     *
     * If the meaning of "DAY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAY"
     */
    inline uint32 getDAY () const;

    /**
     * Sets the value of the member "DAY".
     *
     * If the meaning of "DAY" isn't clear, then there should be a description here.
     *
     * @param DAY The value which will be set
     */
    inline void setDAY (uint32 DAY_);

    // API of field "HOUR"

    static const int kHOUR = 3;

    /**
     * Clears the field "HOUR".
     *
     * The field will be set to its default value. The hasHOUR()
     * method will return false.
     */
    inline void clearHOUR();

    /**
     * Checks whether the field "HOUR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHOUR()). Otherwise it will return false.
     */
    inline bool hasHOUR () const;

    /**
     * Returns the value of the member "HOUR".
     *
     * If the meaning of "HOUR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HOUR"
     */
    inline uint32 getHOUR () const;

    /**
     * Sets the value of the member "HOUR".
     *
     * If the meaning of "HOUR" isn't clear, then there should be a description here.
     *
     * @param HOUR The value which will be set
     */
    inline void setHOUR (uint32 HOUR_);

    // API of field "MINUTE"

    static const int kMINUTE = 4;

    /**
     * Clears the field "MINUTE".
     *
     * The field will be set to its default value. The hasMINUTE()
     * method will return false.
     */
    inline void clearMINUTE();

    /**
     * Checks whether the field "MINUTE" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMINUTE()). Otherwise it will return false.
     */
    inline bool hasMINUTE () const;

    /**
     * Returns the value of the member "MINUTE".
     *
     * If the meaning of "MINUTE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MINUTE"
     */
    inline uint32 getMINUTE () const;

    /**
     * Sets the value of the member "MINUTE".
     *
     * If the meaning of "MINUTE" isn't clear, then there should be a description here.
     *
     * @param MINUTE The value which will be set
     */
    inline void setMINUTE (uint32 MINUTE_);

    static const T_SPM_TransPortMode &getDefaultInstance();

private:

    inline void set_has_YEAR ();

    inline void clear_has_YEAR ();

    inline void set_has_MONTH ();

    inline void clear_has_MONTH ();

    inline void set_has_DAY ();

    inline void clear_has_DAY ();

    inline void set_has_HOUR ();

    inline void clear_has_HOUR ();

    inline void set_has_MINUTE ();

    inline void clear_has_MINUTE ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _YEAR;

    uint32 _MONTH;

    uint32 _DAY;

    uint32 _HOUR;

    uint32 _MINUTE;

};

/**
 * If the meaning of "T_SubStateEntry" isn't clear, then there should be a description here.
 */
class T_SubStateEntry {
public:

    /**
     * Default constructor
     */
    inline  T_SubStateEntry ();

    /**
     * Copy constructor
     */
    inline  T_SubStateEntry (const T_SubStateEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_SubStateEntry (const T_b32_SubState0& tSubStateMask0_, const T_b32_SubState0& tSubStateData0_, const T_b32_SubState1& tSubStateMask1_, const T_b32_SubState1& tSubStateData1_, const T_b32_SubState2& tSubStateMask2_, const T_b32_SubState2& tSubStateData2_, const T_b32_SubState3& tSubStateMask3_, const T_b32_SubState3& tSubStateData3_);

    /**
     * Destructor
     */
    inline  ~T_SubStateEntry();

    /**
     * Assignment operator
     */
    inline T_SubStateEntry& operator = (const T_SubStateEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SubStateEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SubStateEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SubStateEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SubStateEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSubStateMask0"

    static const int kTSubStateMask0 = 0;

    /**
     * Clears the field "tSubStateMask0".
     *
     * The field will be set to its default value. The hasTSubStateMask0()
     * method will return false.
     */
    inline void clearTSubStateMask0();

    /**
     * Checks whether the field "tSubStateMask0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask0()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask0 () const;

    /**
     * Returns the value of the member "tSubStateMask0".
     *
     * If the meaning of "tSubStateMask0" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateMask0"
     */
    inline const T_b32_SubState0& getTSubStateMask0 () const;

    /**
     * Retrieves the value of the field "tSubStateMask0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask0".
     */
    inline T_b32_SubState0& getTSubStateMask0Mutable ();

    /**
     * Sets the value of the member "tSubStateMask0".
     *
     * If the meaning of "tSubStateMask0" isn't clear, then there should be a description here.
     *
     * @param tSubStateMask0 The value which will be set
     */
    inline void setTSubStateMask0 (const T_b32_SubState0& tSubStateMask0_);

    /**
     * Release the object stored in the field "tSubStateMask0".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateMask0"
     */
    inline T_b32_SubState0* releaseTSubStateMask0();

    /**
     * Replace the field "tSubStateMask0".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateMask0 (T_b32_SubState0* tSubStateMask0_);

    // API of field "tSubStateData0"

    static const int kTSubStateData0 = 1;

    /**
     * Clears the field "tSubStateData0".
     *
     * The field will be set to its default value. The hasTSubStateData0()
     * method will return false.
     */
    inline void clearTSubStateData0();

    /**
     * Checks whether the field "tSubStateData0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData0()). Otherwise it will return false.
     */
    inline bool hasTSubStateData0 () const;

    /**
     * Returns the value of the member "tSubStateData0".
     *
     * If the meaning of "tSubStateData0" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateData0"
     */
    inline const T_b32_SubState0& getTSubStateData0 () const;

    /**
     * Retrieves the value of the field "tSubStateData0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData0".
     */
    inline T_b32_SubState0& getTSubStateData0Mutable ();

    /**
     * Sets the value of the member "tSubStateData0".
     *
     * If the meaning of "tSubStateData0" isn't clear, then there should be a description here.
     *
     * @param tSubStateData0 The value which will be set
     */
    inline void setTSubStateData0 (const T_b32_SubState0& tSubStateData0_);

    /**
     * Release the object stored in the field "tSubStateData0".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateData0"
     */
    inline T_b32_SubState0* releaseTSubStateData0();

    /**
     * Replace the field "tSubStateData0".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateData0 (T_b32_SubState0* tSubStateData0_);

    // API of field "tSubStateMask1"

    static const int kTSubStateMask1 = 2;

    /**
     * Clears the field "tSubStateMask1".
     *
     * The field will be set to its default value. The hasTSubStateMask1()
     * method will return false.
     */
    inline void clearTSubStateMask1();

    /**
     * Checks whether the field "tSubStateMask1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask1()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask1 () const;

    /**
     * Returns the value of the member "tSubStateMask1".
     *
     * If the meaning of "tSubStateMask1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateMask1"
     */
    inline const T_b32_SubState1& getTSubStateMask1 () const;

    /**
     * Retrieves the value of the field "tSubStateMask1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask1".
     */
    inline T_b32_SubState1& getTSubStateMask1Mutable ();

    /**
     * Sets the value of the member "tSubStateMask1".
     *
     * If the meaning of "tSubStateMask1" isn't clear, then there should be a description here.
     *
     * @param tSubStateMask1 The value which will be set
     */
    inline void setTSubStateMask1 (const T_b32_SubState1& tSubStateMask1_);

    /**
     * Release the object stored in the field "tSubStateMask1".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateMask1"
     */
    inline T_b32_SubState1* releaseTSubStateMask1();

    /**
     * Replace the field "tSubStateMask1".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateMask1 (T_b32_SubState1* tSubStateMask1_);

    // API of field "tSubStateData1"

    static const int kTSubStateData1 = 3;

    /**
     * Clears the field "tSubStateData1".
     *
     * The field will be set to its default value. The hasTSubStateData1()
     * method will return false.
     */
    inline void clearTSubStateData1();

    /**
     * Checks whether the field "tSubStateData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData1()). Otherwise it will return false.
     */
    inline bool hasTSubStateData1 () const;

    /**
     * Returns the value of the member "tSubStateData1".
     *
     * If the meaning of "tSubStateData1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateData1"
     */
    inline const T_b32_SubState1& getTSubStateData1 () const;

    /**
     * Retrieves the value of the field "tSubStateData1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData1".
     */
    inline T_b32_SubState1& getTSubStateData1Mutable ();

    /**
     * Sets the value of the member "tSubStateData1".
     *
     * If the meaning of "tSubStateData1" isn't clear, then there should be a description here.
     *
     * @param tSubStateData1 The value which will be set
     */
    inline void setTSubStateData1 (const T_b32_SubState1& tSubStateData1_);

    /**
     * Release the object stored in the field "tSubStateData1".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateData1"
     */
    inline T_b32_SubState1* releaseTSubStateData1();

    /**
     * Replace the field "tSubStateData1".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateData1 (T_b32_SubState1* tSubStateData1_);

    // API of field "tSubStateMask2"

    static const int kTSubStateMask2 = 4;

    /**
     * Clears the field "tSubStateMask2".
     *
     * The field will be set to its default value. The hasTSubStateMask2()
     * method will return false.
     */
    inline void clearTSubStateMask2();

    /**
     * Checks whether the field "tSubStateMask2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask2()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask2 () const;

    /**
     * Returns the value of the member "tSubStateMask2".
     *
     * If the meaning of "tSubStateMask2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateMask2"
     */
    inline const T_b32_SubState2& getTSubStateMask2 () const;

    /**
     * Retrieves the value of the field "tSubStateMask2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask2".
     */
    inline T_b32_SubState2& getTSubStateMask2Mutable ();

    /**
     * Sets the value of the member "tSubStateMask2".
     *
     * If the meaning of "tSubStateMask2" isn't clear, then there should be a description here.
     *
     * @param tSubStateMask2 The value which will be set
     */
    inline void setTSubStateMask2 (const T_b32_SubState2& tSubStateMask2_);

    /**
     * Release the object stored in the field "tSubStateMask2".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateMask2"
     */
    inline T_b32_SubState2* releaseTSubStateMask2();

    /**
     * Replace the field "tSubStateMask2".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateMask2 (T_b32_SubState2* tSubStateMask2_);

    // API of field "tSubStateData2"

    static const int kTSubStateData2 = 5;

    /**
     * Clears the field "tSubStateData2".
     *
     * The field will be set to its default value. The hasTSubStateData2()
     * method will return false.
     */
    inline void clearTSubStateData2();

    /**
     * Checks whether the field "tSubStateData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData2()). Otherwise it will return false.
     */
    inline bool hasTSubStateData2 () const;

    /**
     * Returns the value of the member "tSubStateData2".
     *
     * If the meaning of "tSubStateData2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateData2"
     */
    inline const T_b32_SubState2& getTSubStateData2 () const;

    /**
     * Retrieves the value of the field "tSubStateData2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData2".
     */
    inline T_b32_SubState2& getTSubStateData2Mutable ();

    /**
     * Sets the value of the member "tSubStateData2".
     *
     * If the meaning of "tSubStateData2" isn't clear, then there should be a description here.
     *
     * @param tSubStateData2 The value which will be set
     */
    inline void setTSubStateData2 (const T_b32_SubState2& tSubStateData2_);

    /**
     * Release the object stored in the field "tSubStateData2".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateData2"
     */
    inline T_b32_SubState2* releaseTSubStateData2();

    /**
     * Replace the field "tSubStateData2".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateData2 (T_b32_SubState2* tSubStateData2_);

    // API of field "tSubStateMask3"

    static const int kTSubStateMask3 = 6;

    /**
     * Clears the field "tSubStateMask3".
     *
     * The field will be set to its default value. The hasTSubStateMask3()
     * method will return false.
     */
    inline void clearTSubStateMask3();

    /**
     * Checks whether the field "tSubStateMask3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask3()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask3 () const;

    /**
     * Returns the value of the member "tSubStateMask3".
     *
     * If the meaning of "tSubStateMask3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateMask3"
     */
    inline const T_b32_SubState3& getTSubStateMask3 () const;

    /**
     * Retrieves the value of the field "tSubStateMask3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask3".
     */
    inline T_b32_SubState3& getTSubStateMask3Mutable ();

    /**
     * Sets the value of the member "tSubStateMask3".
     *
     * If the meaning of "tSubStateMask3" isn't clear, then there should be a description here.
     *
     * @param tSubStateMask3 The value which will be set
     */
    inline void setTSubStateMask3 (const T_b32_SubState3& tSubStateMask3_);

    /**
     * Release the object stored in the field "tSubStateMask3".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateMask3"
     */
    inline T_b32_SubState3* releaseTSubStateMask3();

    /**
     * Replace the field "tSubStateMask3".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateMask3 (T_b32_SubState3* tSubStateMask3_);

    // API of field "tSubStateData3"

    static const int kTSubStateData3 = 7;

    /**
     * Clears the field "tSubStateData3".
     *
     * The field will be set to its default value. The hasTSubStateData3()
     * method will return false.
     */
    inline void clearTSubStateData3();

    /**
     * Checks whether the field "tSubStateData3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData3()). Otherwise it will return false.
     */
    inline bool hasTSubStateData3 () const;

    /**
     * Returns the value of the member "tSubStateData3".
     *
     * If the meaning of "tSubStateData3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStateData3"
     */
    inline const T_b32_SubState3& getTSubStateData3 () const;

    /**
     * Retrieves the value of the field "tSubStateData3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData3".
     */
    inline T_b32_SubState3& getTSubStateData3Mutable ();

    /**
     * Sets the value of the member "tSubStateData3".
     *
     * If the meaning of "tSubStateData3" isn't clear, then there should be a description here.
     *
     * @param tSubStateData3 The value which will be set
     */
    inline void setTSubStateData3 (const T_b32_SubState3& tSubStateData3_);

    /**
     * Release the object stored in the field "tSubStateData3".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStateData3"
     */
    inline T_b32_SubState3* releaseTSubStateData3();

    /**
     * Replace the field "tSubStateData3".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStateData3 (T_b32_SubState3* tSubStateData3_);

    static const T_SubStateEntry &getDefaultInstance();

private:

    inline void set_has_tSubStateMask0 ();

    inline void clear_has_tSubStateMask0 ();

    inline void set_has_tSubStateData0 ();

    inline void clear_has_tSubStateData0 ();

    inline void set_has_tSubStateMask1 ();

    inline void clear_has_tSubStateMask1 ();

    inline void set_has_tSubStateData1 ();

    inline void clear_has_tSubStateData1 ();

    inline void set_has_tSubStateMask2 ();

    inline void clear_has_tSubStateMask2 ();

    inline void set_has_tSubStateData2 ();

    inline void clear_has_tSubStateData2 ();

    inline void set_has_tSubStateMask3 ();

    inline void clear_has_tSubStateMask3 ();

    inline void set_has_tSubStateData3 ();

    inline void clear_has_tSubStateData3 ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_b32_SubState0* _tSubStateMask0;

    T_b32_SubState0* _tSubStateData0;

    T_b32_SubState1* _tSubStateMask1;

    T_b32_SubState1* _tSubStateData1;

    T_b32_SubState2* _tSubStateMask2;

    T_b32_SubState2* _tSubStateData2;

    T_b32_SubState3* _tSubStateMask3;

    T_b32_SubState3* _tSubStateData3;

};

/**
 * If the meaning of "T_ProcessElement" isn't clear, then there should be a description here.
 */
class T_ProcessElement {
public:

    /**
     * Default constructor
     */
    inline  T_ProcessElement ();

    /**
     * Copy constructor
     */
    inline  T_ProcessElement (const T_ProcessElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProcessElement (const ::std::string& tProcessName_, const ::std::string& tConfiguredProcessName_, T_e8_ProcessState eProcState_, uint32 u32StartTimeSinceStart_, const TTimeDate& tSwitchOnDate_);

    /**
     * Destructor
     */
    inline  ~T_ProcessElement();

    /**
     * Assignment operator
     */
    inline T_ProcessElement& operator = (const T_ProcessElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProcessElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProcessElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProcessElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProcessElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tProcessName"

    static const int kTProcessName = 0;

    /**
     * Clears the field "tProcessName".
     *
     * The field will be set to its default value. The hasTProcessName()
     * method will return false.
     */
    inline void clearTProcessName();

    /**
     * Checks whether the field "tProcessName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTProcessName()). Otherwise it will return false.
     */
    inline bool hasTProcessName () const;

    /**
     * Returns the value of the member "tProcessName".
     *
     * If the meaning of "tProcessName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tProcessName"
     */
    inline const ::std::string& getTProcessName () const;

    /**
     * Retrieves the value of the field "tProcessName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tProcessName".
     */
    inline ::std::string& getTProcessNameMutable ();

    /**
     * Sets the value of the member "tProcessName".
     *
     * If the meaning of "tProcessName" isn't clear, then there should be a description here.
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const ::std::string& tProcessName_);

    /**
     * Sets the value of the member "tProcessName".
     *
     * If the meaning of "tProcessName" isn't clear, then there should be a description here.
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const char* tProcessName_);

    /**
     * Sets the value of the member "tProcessName".
     *
     * If the meaning of "tProcessName" isn't clear, then there should be a description here.
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const char* value, size_t size);

    /**
     * Release the object stored in the field "tProcessName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tProcessName"
     */
    inline ::std::string* releaseTProcessName();

    /**
     * Replace the field "tProcessName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTProcessName (::std::string* tProcessName_);

    // API of field "tConfiguredProcessName"

    static const int kTConfiguredProcessName = 1;

    /**
     * Clears the field "tConfiguredProcessName".
     *
     * The field will be set to its default value. The hasTConfiguredProcessName()
     * method will return false.
     */
    inline void clearTConfiguredProcessName();

    /**
     * Checks whether the field "tConfiguredProcessName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTConfiguredProcessName()). Otherwise it will return false.
     */
    inline bool hasTConfiguredProcessName () const;

    /**
     * Returns the value of the member "tConfiguredProcessName".
     *
     * If the meaning of "tConfiguredProcessName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tConfiguredProcessName"
     */
    inline const ::std::string& getTConfiguredProcessName () const;

    /**
     * Retrieves the value of the field "tConfiguredProcessName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tConfiguredProcessName".
     */
    inline ::std::string& getTConfiguredProcessNameMutable ();

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     * If the meaning of "tConfiguredProcessName" isn't clear, then there should be a description here.
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const ::std::string& tConfiguredProcessName_);

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     * If the meaning of "tConfiguredProcessName" isn't clear, then there should be a description here.
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const char* tConfiguredProcessName_);

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     * If the meaning of "tConfiguredProcessName" isn't clear, then there should be a description here.
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const char* value, size_t size);

    /**
     * Release the object stored in the field "tConfiguredProcessName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tConfiguredProcessName"
     */
    inline ::std::string* releaseTConfiguredProcessName();

    /**
     * Replace the field "tConfiguredProcessName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTConfiguredProcessName (::std::string* tConfiguredProcessName_);

    // API of field "eProcState"

    static const int kEProcState = 2;

    /**
     * Clears the field "eProcState".
     *
     * The field will be set to its default value. The hasEProcState()
     * method will return false.
     */
    inline void clearEProcState();

    /**
     * Checks whether the field "eProcState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEProcState()). Otherwise it will return false.
     */
    inline bool hasEProcState () const;

    /**
     * Returns the value of the member "eProcState".
     *
     * If the meaning of "eProcState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eProcState"
     */
    inline T_e8_ProcessState getEProcState () const;

    /**
     * Sets the value of the member "eProcState".
     *
     * If the meaning of "eProcState" isn't clear, then there should be a description here.
     *
     * @param eProcState The value which will be set
     */
    inline void setEProcState (T_e8_ProcessState eProcState_);

    // API of field "u32StartTimeSinceStart"

    static const int kU32StartTimeSinceStart = 3;

    /**
     * Clears the field "u32StartTimeSinceStart".
     *
     * The field will be set to its default value. The hasU32StartTimeSinceStart()
     * method will return false.
     */
    inline void clearU32StartTimeSinceStart();

    /**
     * Checks whether the field "u32StartTimeSinceStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32StartTimeSinceStart()). Otherwise it will return false.
     */
    inline bool hasU32StartTimeSinceStart () const;

    /**
     * Returns the value of the member "u32StartTimeSinceStart".
     *
     * If the meaning of "u32StartTimeSinceStart" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32StartTimeSinceStart"
     */
    inline uint32 getU32StartTimeSinceStart () const;

    /**
     * Sets the value of the member "u32StartTimeSinceStart".
     *
     * If the meaning of "u32StartTimeSinceStart" isn't clear, then there should be a description here.
     *
     * @param u32StartTimeSinceStart The value which will be set
     */
    inline void setU32StartTimeSinceStart (uint32 u32StartTimeSinceStart_);

    // API of field "tSwitchOnDate"

    static const int kTSwitchOnDate = 4;

    /**
     * Clears the field "tSwitchOnDate".
     *
     * The field will be set to its default value. The hasTSwitchOnDate()
     * method will return false.
     */
    inline void clearTSwitchOnDate();

    /**
     * Checks whether the field "tSwitchOnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnDate()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnDate () const;

    /**
     * Returns the value of the member "tSwitchOnDate".
     *
     * If the meaning of "tSwitchOnDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSwitchOnDate"
     */
    inline const TTimeDate& getTSwitchOnDate () const;

    /**
     * Retrieves the value of the field "tSwitchOnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnDate".
     */
    inline TTimeDate& getTSwitchOnDateMutable ();

    /**
     * Sets the value of the member "tSwitchOnDate".
     *
     * If the meaning of "tSwitchOnDate" isn't clear, then there should be a description here.
     *
     * @param tSwitchOnDate The value which will be set
     */
    inline void setTSwitchOnDate (const TTimeDate& tSwitchOnDate_);

    /**
     * Release the object stored in the field "tSwitchOnDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwitchOnDate"
     */
    inline TTimeDate* releaseTSwitchOnDate();

    /**
     * Replace the field "tSwitchOnDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwitchOnDate (TTimeDate* tSwitchOnDate_);

    static const T_ProcessElement &getDefaultInstance();

private:

    inline void set_has_tProcessName ();

    inline void clear_has_tProcessName ();

    inline void set_has_tConfiguredProcessName ();

    inline void clear_has_tConfiguredProcessName ();

    inline void set_has_eProcState ();

    inline void clear_has_eProcState ();

    inline void set_has_u32StartTimeSinceStart ();

    inline void clear_has_u32StartTimeSinceStart ();

    inline void set_has_tSwitchOnDate ();

    inline void clear_has_tSwitchOnDate ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string* _tProcessName;

    ::std::string* _tConfiguredProcessName;

    T_e8_ProcessState _eProcState;

    uint32 _u32StartTimeSinceStart;

    TTimeDate* _tSwitchOnDate;

};

/**
 * If the meaning of "T_ResetElement" isn't clear, then there should be a description here.
 */
class T_ResetElement {
public:

    /**
     * Default constructor
     */
    inline  T_ResetElement ();

    /**
     * Copy constructor
     */
    inline  T_ResetElement (const T_ResetElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_ResetElement (const TTimeDate& tResetDate_, const TSwVersionInfo& tSwVersionInfo_, T_e8_LcmResetReason eReset_);

    /**
     * Destructor
     */
    inline  ~T_ResetElement();

    /**
     * Assignment operator
     */
    inline T_ResetElement& operator = (const T_ResetElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ResetElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ResetElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ResetElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ResetElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tResetDate"

    static const int kTResetDate = 0;

    /**
     * Clears the field "tResetDate".
     *
     * The field will be set to its default value. The hasTResetDate()
     * method will return false.
     */
    inline void clearTResetDate();

    /**
     * Checks whether the field "tResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTResetDate()). Otherwise it will return false.
     */
    inline bool hasTResetDate () const;

    /**
     * Returns the value of the member "tResetDate".
     *
     * If the meaning of "tResetDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tResetDate"
     */
    inline const TTimeDate& getTResetDate () const;

    /**
     * Retrieves the value of the field "tResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tResetDate".
     */
    inline TTimeDate& getTResetDateMutable ();

    /**
     * Sets the value of the member "tResetDate".
     *
     * If the meaning of "tResetDate" isn't clear, then there should be a description here.
     *
     * @param tResetDate The value which will be set
     */
    inline void setTResetDate (const TTimeDate& tResetDate_);

    /**
     * Release the object stored in the field "tResetDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tResetDate"
     */
    inline TTimeDate* releaseTResetDate();

    /**
     * Replace the field "tResetDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTResetDate (TTimeDate* tResetDate_);

    // API of field "tSwVersionInfo"

    static const int kTSwVersionInfo = 1;

    /**
     * Clears the field "tSwVersionInfo".
     *
     * The field will be set to its default value. The hasTSwVersionInfo()
     * method will return false.
     */
    inline void clearTSwVersionInfo();

    /**
     * Checks whether the field "tSwVersionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwVersionInfo()). Otherwise it will return false.
     */
    inline bool hasTSwVersionInfo () const;

    /**
     * Returns the value of the member "tSwVersionInfo".
     *
     * If the meaning of "tSwVersionInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSwVersionInfo"
     */
    inline const TSwVersionInfo& getTSwVersionInfo () const;

    /**
     * Retrieves the value of the field "tSwVersionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwVersionInfo".
     */
    inline TSwVersionInfo& getTSwVersionInfoMutable ();

    /**
     * Sets the value of the member "tSwVersionInfo".
     *
     * If the meaning of "tSwVersionInfo" isn't clear, then there should be a description here.
     *
     * @param tSwVersionInfo The value which will be set
     */
    inline void setTSwVersionInfo (const TSwVersionInfo& tSwVersionInfo_);

    /**
     * Release the object stored in the field "tSwVersionInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwVersionInfo"
     */
    inline TSwVersionInfo* releaseTSwVersionInfo();

    /**
     * Replace the field "tSwVersionInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwVersionInfo (TSwVersionInfo* tSwVersionInfo_);

    // API of field "eReset"

    static const int kEReset = 2;

    /**
     * Clears the field "eReset".
     *
     * The field will be set to its default value. The hasEReset()
     * method will return false.
     */
    inline void clearEReset();

    /**
     * Checks whether the field "eReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEReset()). Otherwise it will return false.
     */
    inline bool hasEReset () const;

    /**
     * Returns the value of the member "eReset".
     *
     * If the meaning of "eReset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eReset"
     */
    inline T_e8_LcmResetReason getEReset () const;

    /**
     * Sets the value of the member "eReset".
     *
     * If the meaning of "eReset" isn't clear, then there should be a description here.
     *
     * @param eReset The value which will be set
     */
    inline void setEReset (T_e8_LcmResetReason eReset_);

    static const T_ResetElement &getDefaultInstance();

private:

    inline void set_has_tResetDate ();

    inline void clear_has_tResetDate ();

    inline void set_has_tSwVersionInfo ();

    inline void clear_has_tSwVersionInfo ();

    inline void set_has_eReset ();

    inline void clear_has_eReset ();

    uint32 _has_bits_[ (3 + 31) / 32];

    TTimeDate* _tResetDate;

    TSwVersionInfo* _tSwVersionInfo;

    T_e8_LcmResetReason _eReset;

};

/**
 * If the meaning of "T_WakeupElement" isn't clear, then there should be a description here.
 */
class T_WakeupElement {
public:

    /**
     * Default constructor
     */
    inline  T_WakeupElement ();

    /**
     * Copy constructor
     */
    inline  T_WakeupElement (const T_WakeupElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_WakeupElement (const TTimeDate& tWakeupDate_, T_SPM_e32_WAKEUP_REASON eWakeupReason_);

    /**
     * Destructor
     */
    inline  ~T_WakeupElement();

    /**
     * Assignment operator
     */
    inline T_WakeupElement& operator = (const T_WakeupElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WakeupElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WakeupElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WakeupElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WakeupElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tWakeupDate"

    static const int kTWakeupDate = 0;

    /**
     * Clears the field "tWakeupDate".
     *
     * The field will be set to its default value. The hasTWakeupDate()
     * method will return false.
     */
    inline void clearTWakeupDate();

    /**
     * Checks whether the field "tWakeupDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupDate()). Otherwise it will return false.
     */
    inline bool hasTWakeupDate () const;

    /**
     * Returns the value of the member "tWakeupDate".
     *
     * If the meaning of "tWakeupDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tWakeupDate"
     */
    inline const TTimeDate& getTWakeupDate () const;

    /**
     * Retrieves the value of the field "tWakeupDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupDate".
     */
    inline TTimeDate& getTWakeupDateMutable ();

    /**
     * Sets the value of the member "tWakeupDate".
     *
     * If the meaning of "tWakeupDate" isn't clear, then there should be a description here.
     *
     * @param tWakeupDate The value which will be set
     */
    inline void setTWakeupDate (const TTimeDate& tWakeupDate_);

    /**
     * Release the object stored in the field "tWakeupDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tWakeupDate"
     */
    inline TTimeDate* releaseTWakeupDate();

    /**
     * Replace the field "tWakeupDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTWakeupDate (TTimeDate* tWakeupDate_);

    // API of field "eWakeupReason"

    static const int kEWakeupReason = 1;

    /**
     * Clears the field "eWakeupReason".
     *
     * The field will be set to its default value. The hasEWakeupReason()
     * method will return false.
     */
    inline void clearEWakeupReason();

    /**
     * Checks whether the field "eWakeupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEWakeupReason()). Otherwise it will return false.
     */
    inline bool hasEWakeupReason () const;

    /**
     * Returns the value of the member "eWakeupReason".
     *
     * If the meaning of "eWakeupReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eWakeupReason"
     */
    inline T_SPM_e32_WAKEUP_REASON getEWakeupReason () const;

    /**
     * Sets the value of the member "eWakeupReason".
     *
     * If the meaning of "eWakeupReason" isn't clear, then there should be a description here.
     *
     * @param eWakeupReason The value which will be set
     */
    inline void setEWakeupReason (T_SPM_e32_WAKEUP_REASON eWakeupReason_);

    static const T_WakeupElement &getDefaultInstance();

private:

    inline void set_has_tWakeupDate ();

    inline void clear_has_tWakeupDate ();

    inline void set_has_eWakeupReason ();

    inline void clear_has_eWakeupReason ();

    uint32 _has_bits_[ (2 + 31) / 32];

    TTimeDate* _tWakeupDate;

    T_SPM_e32_WAKEUP_REASON _eWakeupReason;

};

/**
 * If the meaning of "T_StateChangeElement" isn't clear, then there should be a description here.
 */
class T_StateChangeElement {
public:

    /**
     * Default constructor
     */
    inline  T_StateChangeElement ();

    /**
     * Copy constructor
     */
    inline  T_StateChangeElement (const T_StateChangeElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_StateChangeElement (const TTimeDate& tWakeupDate_, T_SPM_e32_SYSTEM_STATES tSysState_, T_e8_StateEntryType tElemType_, T_SPM_e32_WAKEUP_REASON tWakeup_, T_e8_LcmResetReason tReset_, const T_SubStateEntry& tSubStates_);

    /**
     * Destructor
     */
    inline  ~T_StateChangeElement();

    /**
     * Assignment operator
     */
    inline T_StateChangeElement& operator = (const T_StateChangeElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StateChangeElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StateChangeElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StateChangeElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StateChangeElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tWakeupDate"

    static const int kTWakeupDate = 0;

    /**
     * Clears the field "tWakeupDate".
     *
     * The field will be set to its default value. The hasTWakeupDate()
     * method will return false.
     */
    inline void clearTWakeupDate();

    /**
     * Checks whether the field "tWakeupDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupDate()). Otherwise it will return false.
     */
    inline bool hasTWakeupDate () const;

    /**
     * Returns the value of the member "tWakeupDate".
     *
     * If the meaning of "tWakeupDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tWakeupDate"
     */
    inline const TTimeDate& getTWakeupDate () const;

    /**
     * Retrieves the value of the field "tWakeupDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupDate".
     */
    inline TTimeDate& getTWakeupDateMutable ();

    /**
     * Sets the value of the member "tWakeupDate".
     *
     * If the meaning of "tWakeupDate" isn't clear, then there should be a description here.
     *
     * @param tWakeupDate The value which will be set
     */
    inline void setTWakeupDate (const TTimeDate& tWakeupDate_);

    /**
     * Release the object stored in the field "tWakeupDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tWakeupDate"
     */
    inline TTimeDate* releaseTWakeupDate();

    /**
     * Replace the field "tWakeupDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTWakeupDate (TTimeDate* tWakeupDate_);

    // API of field "tSysState"

    static const int kTSysState = 1;

    /**
     * Clears the field "tSysState".
     *
     * The field will be set to its default value. The hasTSysState()
     * method will return false.
     */
    inline void clearTSysState();

    /**
     * Checks whether the field "tSysState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSysState()). Otherwise it will return false.
     */
    inline bool hasTSysState () const;

    /**
     * Returns the value of the member "tSysState".
     *
     * If the meaning of "tSysState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSysState"
     */
    inline T_SPM_e32_SYSTEM_STATES getTSysState () const;

    /**
     * Sets the value of the member "tSysState".
     *
     * If the meaning of "tSysState" isn't clear, then there should be a description here.
     *
     * @param tSysState The value which will be set
     */
    inline void setTSysState (T_SPM_e32_SYSTEM_STATES tSysState_);

    // API of field "tElemType"

    static const int kTElemType = 2;

    /**
     * Clears the field "tElemType".
     *
     * The field will be set to its default value. The hasTElemType()
     * method will return false.
     */
    inline void clearTElemType();

    /**
     * Checks whether the field "tElemType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTElemType()). Otherwise it will return false.
     */
    inline bool hasTElemType () const;

    /**
     * Returns the value of the member "tElemType".
     *
     * If the meaning of "tElemType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tElemType"
     */
    inline T_e8_StateEntryType getTElemType () const;

    /**
     * Sets the value of the member "tElemType".
     *
     * If the meaning of "tElemType" isn't clear, then there should be a description here.
     *
     * @param tElemType The value which will be set
     */
    inline void setTElemType (T_e8_StateEntryType tElemType_);

    // API of field "tWakeup"

    static const int kTWakeup = 3;

    /**
     * Clears the field "tWakeup".
     *
     * The field will be set to its default value. The hasTWakeup()
     * method will return false.
     */
    inline void clearTWakeup();

    /**
     * Checks whether the field "tWakeup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeup()). Otherwise it will return false.
     */
    inline bool hasTWakeup () const;

    /**
     * Returns the value of the member "tWakeup".
     *
     * If the meaning of "tWakeup" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tWakeup"
     */
    inline T_SPM_e32_WAKEUP_REASON getTWakeup () const;

    /**
     * Sets the value of the member "tWakeup".
     *
     * If the meaning of "tWakeup" isn't clear, then there should be a description here.
     *
     * @param tWakeup The value which will be set
     */
    inline void setTWakeup (T_SPM_e32_WAKEUP_REASON tWakeup_);

    // API of field "tReset"

    static const int kTReset = 4;

    /**
     * Clears the field "tReset".
     *
     * The field will be set to its default value. The hasTReset()
     * method will return false.
     */
    inline void clearTReset();

    /**
     * Checks whether the field "tReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTReset()). Otherwise it will return false.
     */
    inline bool hasTReset () const;

    /**
     * Returns the value of the member "tReset".
     *
     * If the meaning of "tReset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tReset"
     */
    inline T_e8_LcmResetReason getTReset () const;

    /**
     * Sets the value of the member "tReset".
     *
     * If the meaning of "tReset" isn't clear, then there should be a description here.
     *
     * @param tReset The value which will be set
     */
    inline void setTReset (T_e8_LcmResetReason tReset_);

    // API of field "tSubStates"

    static const int kTSubStates = 5;

    /**
     * Clears the field "tSubStates".
     *
     * The field will be set to its default value. The hasTSubStates()
     * method will return false.
     */
    inline void clearTSubStates();

    /**
     * Checks whether the field "tSubStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStates()). Otherwise it will return false.
     */
    inline bool hasTSubStates () const;

    /**
     * Returns the value of the member "tSubStates".
     *
     * If the meaning of "tSubStates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubStates"
     */
    inline const T_SubStateEntry& getTSubStates () const;

    /**
     * Retrieves the value of the field "tSubStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStates".
     */
    inline T_SubStateEntry& getTSubStatesMutable ();

    /**
     * Sets the value of the member "tSubStates".
     *
     * If the meaning of "tSubStates" isn't clear, then there should be a description here.
     *
     * @param tSubStates The value which will be set
     */
    inline void setTSubStates (const T_SubStateEntry& tSubStates_);

    /**
     * Release the object stored in the field "tSubStates".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSubStates"
     */
    inline T_SubStateEntry* releaseTSubStates();

    /**
     * Replace the field "tSubStates".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSubStates (T_SubStateEntry* tSubStates_);

    static const T_StateChangeElement &getDefaultInstance();

private:

    inline void set_has_tWakeupDate ();

    inline void clear_has_tWakeupDate ();

    inline void set_has_tSysState ();

    inline void clear_has_tSysState ();

    inline void set_has_tElemType ();

    inline void clear_has_tElemType ();

    inline void set_has_tWakeup ();

    inline void clear_has_tWakeup ();

    inline void set_has_tReset ();

    inline void clear_has_tReset ();

    inline void set_has_tSubStates ();

    inline void clear_has_tSubStates ();

    uint32 _has_bits_[ (6 + 31) / 32];

    TTimeDate* _tWakeupDate;

    T_SPM_e32_SYSTEM_STATES _tSysState;

    T_e8_StateEntryType _tElemType;

    T_SPM_e32_WAKEUP_REASON _tWakeup;

    T_e8_LcmResetReason _tReset;

    T_SubStateEntry* _tSubStates;

};

/**
 * If the meaning of "T_SwitchOnElement" isn't clear, then there should be a description here.
 */
class T_SwitchOnElement {
public:

    /**
     * Default constructor
     */
    inline  T_SwitchOnElement ();

    /**
     * Copy constructor
     */
    inline  T_SwitchOnElement (const T_SwitchOnElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_SwitchOnElement (const TTimeDate& tSwitchOnDate_, T_SPM_e32_SubStateType eSwitchOnReason_);

    /**
     * Destructor
     */
    inline  ~T_SwitchOnElement();

    /**
     * Assignment operator
     */
    inline T_SwitchOnElement& operator = (const T_SwitchOnElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SwitchOnElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SwitchOnElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SwitchOnElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SwitchOnElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSwitchOnDate"

    static const int kTSwitchOnDate = 0;

    /**
     * Clears the field "tSwitchOnDate".
     *
     * The field will be set to its default value. The hasTSwitchOnDate()
     * method will return false.
     */
    inline void clearTSwitchOnDate();

    /**
     * Checks whether the field "tSwitchOnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnDate()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnDate () const;

    /**
     * Returns the value of the member "tSwitchOnDate".
     *
     * If the meaning of "tSwitchOnDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSwitchOnDate"
     */
    inline const TTimeDate& getTSwitchOnDate () const;

    /**
     * Retrieves the value of the field "tSwitchOnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnDate".
     */
    inline TTimeDate& getTSwitchOnDateMutable ();

    /**
     * Sets the value of the member "tSwitchOnDate".
     *
     * If the meaning of "tSwitchOnDate" isn't clear, then there should be a description here.
     *
     * @param tSwitchOnDate The value which will be set
     */
    inline void setTSwitchOnDate (const TTimeDate& tSwitchOnDate_);

    /**
     * Release the object stored in the field "tSwitchOnDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwitchOnDate"
     */
    inline TTimeDate* releaseTSwitchOnDate();

    /**
     * Replace the field "tSwitchOnDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwitchOnDate (TTimeDate* tSwitchOnDate_);

    // API of field "eSwitchOnReason"

    static const int kESwitchOnReason = 1;

    /**
     * Clears the field "eSwitchOnReason".
     *
     * The field will be set to its default value. The hasESwitchOnReason()
     * method will return false.
     */
    inline void clearESwitchOnReason();

    /**
     * Checks whether the field "eSwitchOnReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESwitchOnReason()). Otherwise it will return false.
     */
    inline bool hasESwitchOnReason () const;

    /**
     * Returns the value of the member "eSwitchOnReason".
     *
     * If the meaning of "eSwitchOnReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSwitchOnReason"
     */
    inline T_SPM_e32_SubStateType getESwitchOnReason () const;

    /**
     * Sets the value of the member "eSwitchOnReason".
     *
     * If the meaning of "eSwitchOnReason" isn't clear, then there should be a description here.
     *
     * @param eSwitchOnReason The value which will be set
     */
    inline void setESwitchOnReason (T_SPM_e32_SubStateType eSwitchOnReason_);

    static const T_SwitchOnElement &getDefaultInstance();

private:

    inline void set_has_tSwitchOnDate ();

    inline void clear_has_tSwitchOnDate ();

    inline void set_has_eSwitchOnReason ();

    inline void clear_has_eSwitchOnReason ();

    uint32 _has_bits_[ (2 + 31) / 32];

    TTimeDate* _tSwitchOnDate;

    T_SPM_e32_SubStateType _eSwitchOnReason;

};

/**
 * Power save modes 1..32 (bit-coded).
 */
class T_SPM_b32_SYSPWRSAVEMODE {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE ();

    /**
     * Copy constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE (const T_SPM_b32_SYSPWRSAVEMODE &c);

    /**
     * Field constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE (bool SPM_e32_TRANSPORTMODE, bool SPM_e32_ROLLER, bool SPM_e32_FACTORY, bool SPM_e32_QCRITICAL);

    /**
     * Assignment operator
     */
    inline T_SPM_b32_SYSPWRSAVEMODE& operator = (const T_SPM_b32_SYSPWRSAVEMODE& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Sets the value of the member "SPM_e32_TRANSPORTMODE".
     *
     * If the meaning of "SPM_e32_TRANSPORTMODE" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_TRANSPORTMODE The value which will be set
     */
    inline void setSPM_e32_TRANSPORTMODE (bool SPM_e32_TRANSPORTMODE);

    /**
     * Returns the value of the member "SPM_e32_TRANSPORTMODE".
     *
     * If the meaning of "SPM_e32_TRANSPORTMODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_TRANSPORTMODE"
     */
    inline bool getSPM_e32_TRANSPORTMODE () const;

    /**
     * Sets the value of the member "SPM_e32_ROLLER".
     *
     * If the meaning of "SPM_e32_ROLLER" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_ROLLER The value which will be set
     */
    inline void setSPM_e32_ROLLER (bool SPM_e32_ROLLER);

    /**
     * Returns the value of the member "SPM_e32_ROLLER".
     *
     * If the meaning of "SPM_e32_ROLLER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_ROLLER"
     */
    inline bool getSPM_e32_ROLLER () const;

    /**
     * Sets the value of the member "SPM_e32_FACTORY".
     *
     * If the meaning of "SPM_e32_FACTORY" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_FACTORY The value which will be set
     */
    inline void setSPM_e32_FACTORY (bool SPM_e32_FACTORY);

    /**
     * Returns the value of the member "SPM_e32_FACTORY".
     *
     * If the meaning of "SPM_e32_FACTORY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_FACTORY"
     */
    inline bool getSPM_e32_FACTORY () const;

    /**
     * Sets the value of the member "SPM_e32_QCRITICAL".
     *
     * If the meaning of "SPM_e32_QCRITICAL" isn't clear, then there should be a description here.
     *
     * @param SPM_e32_QCRITICAL The value which will be set
     */
    inline void setSPM_e32_QCRITICAL (bool SPM_e32_QCRITICAL);

    /**
     * Returns the value of the member "SPM_e32_QCRITICAL".
     *
     * If the meaning of "SPM_e32_QCRITICAL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPM_e32_QCRITICAL"
     */
    inline bool getSPM_e32_QCRITICAL () const;

    static const T_SPM_b32_SYSPWRSAVEMODE &getDefaultInstance();

private:

    bool _SPM_e32_TRANSPORTMODE:1;

    bool _SPM_e32_ROLLER:1;

    bool _SPM_e32_FACTORY:1;

    bool _SPM_e32_QCRITICAL:1;

};

/**
 * One part and partnumber item.
 */
class T_SPM_PartnumberItem {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_PartnumberItem ();

    /**
     * Copy constructor
     */
    inline  T_SPM_PartnumberItem (const T_SPM_PartnumberItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_PartnumberItem (const ::std::string& Part_, uint32 Number_);

    /**
     * Destructor
     */
    inline  ~T_SPM_PartnumberItem();

    /**
     * Assignment operator
     */
    inline T_SPM_PartnumberItem& operator = (const T_SPM_PartnumberItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    // API of field "Number"

    static const int kNumber = 1;

    /**
     * Clears the field "Number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "Number".
     *
     * If the meaning of "Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Number"
     */
    inline uint32 getNumber () const;

    /**
     * Sets the value of the member "Number".
     *
     * If the meaning of "Number" isn't clear, then there should be a description here.
     *
     * @param Number The value which will be set
     */
    inline void setNumber (uint32 Number_);

    static const T_SPM_PartnumberItem &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Number ();

    inline void clear_has_Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _Part;

    uint32 _Number;

};

/**
 * One part and alphacode item.
 */
class T_SPM_AlphacodeItem {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_AlphacodeItem ();

    /**
     * Copy constructor
     */
    inline  T_SPM_AlphacodeItem (const T_SPM_AlphacodeItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_AlphacodeItem (const ::std::string& Part_, uint8 Alphacode1_, uint8 Alphacode2_);

    /**
     * Destructor
     */
    inline  ~T_SPM_AlphacodeItem();

    /**
     * Assignment operator
     */
    inline T_SPM_AlphacodeItem& operator = (const T_SPM_AlphacodeItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * If the meaning of "Part" isn't clear, then there should be a description here.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    // API of field "Alphacode1"

    static const int kAlphacode1 = 1;

    /**
     * Clears the field "Alphacode1".
     *
     * The field will be set to its default value. The hasAlphacode1()
     * method will return false.
     */
    inline void clearAlphacode1();

    /**
     * Checks whether the field "Alphacode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode1()). Otherwise it will return false.
     */
    inline bool hasAlphacode1 () const;

    /**
     * Returns the value of the member "Alphacode1".
     *
     * If the meaning of "Alphacode1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Alphacode1"
     */
    inline uint8 getAlphacode1 () const;

    /**
     * Sets the value of the member "Alphacode1".
     *
     * If the meaning of "Alphacode1" isn't clear, then there should be a description here.
     *
     * @param Alphacode1 The value which will be set
     */
    inline void setAlphacode1 (uint8 Alphacode1_);

    // API of field "Alphacode2"

    static const int kAlphacode2 = 2;

    /**
     * Clears the field "Alphacode2".
     *
     * The field will be set to its default value. The hasAlphacode2()
     * method will return false.
     */
    inline void clearAlphacode2();

    /**
     * Checks whether the field "Alphacode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode2()). Otherwise it will return false.
     */
    inline bool hasAlphacode2 () const;

    /**
     * Returns the value of the member "Alphacode2".
     *
     * If the meaning of "Alphacode2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Alphacode2"
     */
    inline uint8 getAlphacode2 () const;

    /**
     * Sets the value of the member "Alphacode2".
     *
     * If the meaning of "Alphacode2" isn't clear, then there should be a description here.
     *
     * @param Alphacode2 The value which will be set
     */
    inline void setAlphacode2 (uint8 Alphacode2_);

    static const T_SPM_AlphacodeItem &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Alphacode1 ();

    inline void clear_has_Alphacode1 ();

    inline void set_has_Alphacode2 ();

    inline void clear_has_Alphacode2 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _Part;

    uint8 _Alphacode1;

    uint8 _Alphacode2;

};

/**
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>!!! replaced by T_SPM_UpdateLockState !!!</p>
 */
class T_SPM_RestrictedDlLock {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_RestrictedDlLock ();

    /**
     * Copy constructor
     */
    inline  T_SPM_RestrictedDlLock (const T_SPM_RestrictedDlLock &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_RestrictedDlLock (const ::std::string& strRestrictedLockArea_, uint16 u16AppIdLockOwner_, uint16 u16AppIdLockRequester_);

    /**
     * Destructor
     */
    inline  ~T_SPM_RestrictedDlLock();

    /**
     * Assignment operator
     */
    inline T_SPM_RestrictedDlLock& operator = (const T_SPM_RestrictedDlLock& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strRestrictedLockArea"

    static const int kStrRestrictedLockArea = 0;

    /**
     * Clears the field "strRestrictedLockArea".
     *
     * The field will be set to its default value. The hasStrRestrictedLockArea()
     * method will return false.
     */
    inline void clearStrRestrictedLockArea();

    /**
     * Checks whether the field "strRestrictedLockArea" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrRestrictedLockArea()). Otherwise it will return false.
     */
    inline bool hasStrRestrictedLockArea () const;

    /**
     * Returns the value of the member "strRestrictedLockArea".
     *
     * If the meaning of "strRestrictedLockArea" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strRestrictedLockArea"
     */
    inline const ::std::string& getStrRestrictedLockArea () const;

    /**
     * Retrieves the value of the field "strRestrictedLockArea" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strRestrictedLockArea".
     */
    inline ::std::string& getStrRestrictedLockAreaMutable ();

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     * If the meaning of "strRestrictedLockArea" isn't clear, then there should be a description here.
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const ::std::string& strRestrictedLockArea_);

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     * If the meaning of "strRestrictedLockArea" isn't clear, then there should be a description here.
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const char* strRestrictedLockArea_);

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     * If the meaning of "strRestrictedLockArea" isn't clear, then there should be a description here.
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const char* value, size_t size);

    /**
     * Release the object stored in the field "strRestrictedLockArea".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strRestrictedLockArea"
     */
    inline ::std::string* releaseStrRestrictedLockArea();

    /**
     * Replace the field "strRestrictedLockArea".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrRestrictedLockArea (::std::string* strRestrictedLockArea_);

    // API of field "u16AppIdLockOwner"

    static const int kU16AppIdLockOwner = 1;

    /**
     * Clears the field "u16AppIdLockOwner".
     *
     * The field will be set to its default value. The hasU16AppIdLockOwner()
     * method will return false.
     */
    inline void clearU16AppIdLockOwner();

    /**
     * Checks whether the field "u16AppIdLockOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppIdLockOwner()). Otherwise it will return false.
     */
    inline bool hasU16AppIdLockOwner () const;

    /**
     * Returns the value of the member "u16AppIdLockOwner".
     *
     * If the meaning of "u16AppIdLockOwner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16AppIdLockOwner"
     */
    inline uint16 getU16AppIdLockOwner () const;

    /**
     * Sets the value of the member "u16AppIdLockOwner".
     *
     * If the meaning of "u16AppIdLockOwner" isn't clear, then there should be a description here.
     *
     * @param u16AppIdLockOwner The value which will be set
     */
    inline void setU16AppIdLockOwner (uint16 u16AppIdLockOwner_);

    // API of field "u16AppIdLockRequester"

    static const int kU16AppIdLockRequester = 2;

    /**
     * Clears the field "u16AppIdLockRequester".
     *
     * The field will be set to its default value. The hasU16AppIdLockRequester()
     * method will return false.
     */
    inline void clearU16AppIdLockRequester();

    /**
     * Checks whether the field "u16AppIdLockRequester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppIdLockRequester()). Otherwise it will return false.
     */
    inline bool hasU16AppIdLockRequester () const;

    /**
     * Returns the value of the member "u16AppIdLockRequester".
     *
     * If the meaning of "u16AppIdLockRequester" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16AppIdLockRequester"
     */
    inline uint16 getU16AppIdLockRequester () const;

    /**
     * Sets the value of the member "u16AppIdLockRequester".
     *
     * If the meaning of "u16AppIdLockRequester" isn't clear, then there should be a description here.
     *
     * @param u16AppIdLockRequester The value which will be set
     */
    inline void setU16AppIdLockRequester (uint16 u16AppIdLockRequester_);

    static const T_SPM_RestrictedDlLock &getDefaultInstance();

private:

    inline void set_has_strRestrictedLockArea ();

    inline void clear_has_strRestrictedLockArea ();

    inline void set_has_u16AppIdLockOwner ();

    inline void clear_has_u16AppIdLockOwner ();

    inline void set_has_u16AppIdLockRequester ();

    inline void clear_has_u16AppIdLockRequester ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _strRestrictedLockArea;

    uint16 _u16AppIdLockOwner;

    uint16 _u16AppIdLockRequester;

};

/**
 * If the meaning of "T_SPM_UpdateLockState" isn't clear, then there should be a description here.
 */
class T_SPM_UpdateLockState {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_UpdateLockState ();

    /**
     * Copy constructor
     */
    inline  T_SPM_UpdateLockState (const T_SPM_UpdateLockState &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_UpdateLockState (const ::std::string& strLockName_, T_e8_UpdateLockState eLockState_, uint16 u16LockOwner_, const ::std::vector< uint16 >& lu16LockUsers_);

    /**
     * Destructor
     */
    inline  ~T_SPM_UpdateLockState();

    /**
     * Assignment operator
     */
    inline T_SPM_UpdateLockState& operator = (const T_SPM_UpdateLockState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLockName"

    static const int kStrLockName = 0;

    /**
     * Clears the field "strLockName".
     *
     * The field will be set to its default value. The hasStrLockName()
     * method will return false.
     */
    inline void clearStrLockName();

    /**
     * Checks whether the field "strLockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLockName()). Otherwise it will return false.
     */
    inline bool hasStrLockName () const;

    /**
     * Returns the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLockName"
     */
    inline const ::std::string& getStrLockName () const;

    /**
     * Retrieves the value of the field "strLockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLockName".
     */
    inline ::std::string& getStrLockNameMutable ();

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const ::std::string& strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLockName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLockName"
     */
    inline ::std::string* releaseStrLockName();

    /**
     * Replace the field "strLockName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLockName (::std::string* strLockName_);

    // API of field "eLockState"

    static const int kELockState = 1;

    /**
     * Clears the field "eLockState".
     *
     * The field will be set to its default value. The hasELockState()
     * method will return false.
     */
    inline void clearELockState();

    /**
     * Checks whether the field "eLockState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setELockState()). Otherwise it will return false.
     */
    inline bool hasELockState () const;

    /**
     * Returns the value of the member "eLockState".
     *
     * If the meaning of "eLockState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eLockState"
     */
    inline T_e8_UpdateLockState getELockState () const;

    /**
     * Sets the value of the member "eLockState".
     *
     * If the meaning of "eLockState" isn't clear, then there should be a description here.
     *
     * @param eLockState The value which will be set
     */
    inline void setELockState (T_e8_UpdateLockState eLockState_);

    // API of field "u16LockOwner"

    static const int kU16LockOwner = 2;

    /**
     * Clears the field "u16LockOwner".
     *
     * The field will be set to its default value. The hasU16LockOwner()
     * method will return false.
     */
    inline void clearU16LockOwner();

    /**
     * Checks whether the field "u16LockOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LockOwner()). Otherwise it will return false.
     */
    inline bool hasU16LockOwner () const;

    /**
     * Returns the value of the member "u16LockOwner".
     *
     * If the meaning of "u16LockOwner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16LockOwner"
     */
    inline uint16 getU16LockOwner () const;

    /**
     * Sets the value of the member "u16LockOwner".
     *
     * If the meaning of "u16LockOwner" isn't clear, then there should be a description here.
     *
     * @param u16LockOwner The value which will be set
     */
    inline void setU16LockOwner (uint16 u16LockOwner_);

    // API of field "lu16LockUsers"

    static const int kLu16LockUsers = 3;

    /**
     * Clears the field "lu16LockUsers".
     *
     * The field will be set to its default value. The hasLu16LockUsers()
     * method will return false.
     */
    inline void clearLu16LockUsers();

    /**
     * Checks whether the field "lu16LockUsers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLu16LockUsers()). Otherwise it will return false.
     */
    inline bool hasLu16LockUsers () const;

    /**
     * Returns the value of the member "lu16LockUsers".
     *
     * If the meaning of "lu16LockUsers" isn't clear, then there should be a description here.
     *
     * @return The value of the field "lu16LockUsers"
     */
    inline const ::std::vector< uint16 >& getLu16LockUsers () const;

    /**
     * Retrieves the value of the field "lu16LockUsers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "lu16LockUsers".
     */
    inline ::std::vector< uint16 >& getLu16LockUsersMutable ();

    /**
     * Sets the value of the member "lu16LockUsers".
     *
     * If the meaning of "lu16LockUsers" isn't clear, then there should be a description here.
     *
     * @param lu16LockUsers The value which will be set
     */
    inline void setLu16LockUsers (const ::std::vector< uint16 >& lu16LockUsers_);

    /**
     * Release the object stored in the field "lu16LockUsers".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "lu16LockUsers"
     */
    inline ::std::vector< uint16 >* releaseLu16LockUsers();

    /**
     * Replace the field "lu16LockUsers".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceLu16LockUsers (::std::vector< uint16 >* lu16LockUsers_);

    static const T_SPM_UpdateLockState &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_strLockName ();

    inline void clear_has_strLockName ();

    inline void set_has_eLockState ();

    inline void clear_has_eLockState ();

    inline void set_has_u16LockOwner ();

    inline void clear_has_u16LockOwner ();

    inline void set_has_lu16LockUsers ();

    inline void clear_has_lu16LockUsers ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string* _strLockName;

    T_e8_UpdateLockState _eLockState;

    uint16 _u16LockOwner;

    ::std::vector< uint16 >* _lu16LockUsers;

};

/**
 * If the meaning of "T_SPM_VoltageEventCounter" isn't clear, then there should be a description here.
 */
class T_SPM_VoltageEventCounter {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_VoltageEventCounter ();

    /**
     * Copy constructor
     */
    inline  T_SPM_VoltageEventCounter (const T_SPM_VoltageEventCounter &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_VoltageEventCounter (uint32 LowVoltageCount_, uint32 CrLowVoltageCount_, uint32 HighVoltageCount_, uint32 CrHighVoltageCount_);

    /**
     * Destructor
     */
    inline  ~T_SPM_VoltageEventCounter();

    /**
     * Assignment operator
     */
    inline T_SPM_VoltageEventCounter& operator = (const T_SPM_VoltageEventCounter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LowVoltageCount"

    static const int kLowVoltageCount = 0;

    /**
     * Clears the field "LowVoltageCount".
     *
     * The field will be set to its default value. The hasLowVoltageCount()
     * method will return false.
     */
    inline void clearLowVoltageCount();

    /**
     * Checks whether the field "LowVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowVoltageCount()). Otherwise it will return false.
     */
    inline bool hasLowVoltageCount () const;

    /**
     * Returns the value of the member "LowVoltageCount".
     *
     * Low voltage event counter
     *
     * @return The value of the field "LowVoltageCount"
     */
    inline uint32 getLowVoltageCount () const;

    /**
     * Sets the value of the member "LowVoltageCount".
     *
     * Low voltage event counter
     *
     * @param LowVoltageCount The value which will be set
     */
    inline void setLowVoltageCount (uint32 LowVoltageCount_);

    // API of field "CrLowVoltageCount"

    static const int kCrLowVoltageCount = 1;

    /**
     * Clears the field "CrLowVoltageCount".
     *
     * The field will be set to its default value. The hasCrLowVoltageCount()
     * method will return false.
     */
    inline void clearCrLowVoltageCount();

    /**
     * Checks whether the field "CrLowVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCrLowVoltageCount()). Otherwise it will return false.
     */
    inline bool hasCrLowVoltageCount () const;

    /**
     * Returns the value of the member "CrLowVoltageCount".
     *
     * Critical low voltage event counter
     *
     * @return The value of the field "CrLowVoltageCount"
     */
    inline uint32 getCrLowVoltageCount () const;

    /**
     * Sets the value of the member "CrLowVoltageCount".
     *
     * Critical low voltage event counter
     *
     * @param CrLowVoltageCount The value which will be set
     */
    inline void setCrLowVoltageCount (uint32 CrLowVoltageCount_);

    // API of field "HighVoltageCount"

    static const int kHighVoltageCount = 2;

    /**
     * Clears the field "HighVoltageCount".
     *
     * The field will be set to its default value. The hasHighVoltageCount()
     * method will return false.
     */
    inline void clearHighVoltageCount();

    /**
     * Checks whether the field "HighVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHighVoltageCount()). Otherwise it will return false.
     */
    inline bool hasHighVoltageCount () const;

    /**
     * Returns the value of the member "HighVoltageCount".
     *
     * High voltage event counter
     *
     * @return The value of the field "HighVoltageCount"
     */
    inline uint32 getHighVoltageCount () const;

    /**
     * Sets the value of the member "HighVoltageCount".
     *
     * High voltage event counter
     *
     * @param HighVoltageCount The value which will be set
     */
    inline void setHighVoltageCount (uint32 HighVoltageCount_);

    // API of field "CrHighVoltageCount"

    static const int kCrHighVoltageCount = 3;

    /**
     * Clears the field "CrHighVoltageCount".
     *
     * The field will be set to its default value. The hasCrHighVoltageCount()
     * method will return false.
     */
    inline void clearCrHighVoltageCount();

    /**
     * Checks whether the field "CrHighVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCrHighVoltageCount()). Otherwise it will return false.
     */
    inline bool hasCrHighVoltageCount () const;

    /**
     * Returns the value of the member "CrHighVoltageCount".
     *
     * Critical high voltage event counter
     *
     * @return The value of the field "CrHighVoltageCount"
     */
    inline uint32 getCrHighVoltageCount () const;

    /**
     * Sets the value of the member "CrHighVoltageCount".
     *
     * Critical high voltage event counter
     *
     * @param CrHighVoltageCount The value which will be set
     */
    inline void setCrHighVoltageCount (uint32 CrHighVoltageCount_);

    static const T_SPM_VoltageEventCounter &getDefaultInstance();

private:

    inline void set_has_LowVoltageCount ();

    inline void clear_has_LowVoltageCount ();

    inline void set_has_CrLowVoltageCount ();

    inline void clear_has_CrLowVoltageCount ();

    inline void set_has_HighVoltageCount ();

    inline void clear_has_HighVoltageCount ();

    inline void set_has_CrHighVoltageCount ();

    inline void clear_has_CrHighVoltageCount ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _LowVoltageCount;

    uint32 _CrLowVoltageCount;

    uint32 _HighVoltageCount;

    uint32 _CrHighVoltageCount;

};

/**
 * If the meaning of "T_SPM_VoltageRange" isn't clear, then there should be a description here.
 */
class T_SPM_VoltageRange {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_VoltageRange ();

    /**
     * Copy constructor
     */
    inline  T_SPM_VoltageRange (const T_SPM_VoltageRange &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_VoltageRange (uint16 VoltageValue_, uint32 OperationTime_);

    /**
     * Destructor
     */
    inline  ~T_SPM_VoltageRange();

    /**
     * Assignment operator
     */
    inline T_SPM_VoltageRange& operator = (const T_SPM_VoltageRange& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_VoltageRange& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_VoltageRange& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_VoltageRange& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_VoltageRange& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageValue"

    static const int kVoltageValue = 0;

    /**
     * Clears the field "VoltageValue".
     *
     * The field will be set to its default value. The hasVoltageValue()
     * method will return false.
     */
    inline void clearVoltageValue();

    /**
     * Checks whether the field "VoltageValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageValue()). Otherwise it will return false.
     */
    inline bool hasVoltageValue () const;

    /**
     * Returns the value of the member "VoltageValue".
     *
     * Voltage value in Mv
     *
     * @return The value of the field "VoltageValue"
     */
    inline uint16 getVoltageValue () const;

    /**
     * Sets the value of the member "VoltageValue".
     *
     * Voltage value in Mv
     *
     * @param VoltageValue The value which will be set
     */
    inline void setVoltageValue (uint16 VoltageValue_);

    // API of field "OperationTime"

    static const int kOperationTime = 1;

    /**
     * Clears the field "OperationTime".
     *
     * The field will be set to its default value. The hasOperationTime()
     * method will return false.
     */
    inline void clearOperationTime();

    /**
     * Checks whether the field "OperationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperationTime()). Otherwise it will return false.
     */
    inline bool hasOperationTime () const;

    /**
     * Returns the value of the member "OperationTime".
     *
     * Operation time in second corresponding voltage value
     *
     * @return The value of the field "OperationTime"
     */
    inline uint32 getOperationTime () const;

    /**
     * Sets the value of the member "OperationTime".
     *
     * Operation time in second corresponding voltage value
     *
     * @param OperationTime The value which will be set
     */
    inline void setOperationTime (uint32 OperationTime_);

    static const T_SPM_VoltageRange &getDefaultInstance();

private:

    inline void set_has_VoltageValue ();

    inline void clear_has_VoltageValue ();

    inline void set_has_OperationTime ();

    inline void clear_has_OperationTime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _VoltageValue;

    uint32 _OperationTime;

};

/**
 * If the meaning of "T_SPM_SystemStatisticsData" isn't clear, then there should be a description here.
 */
class T_SPM_SystemStatisticsData {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_SystemStatisticsData ();

    /**
     * Copy constructor
     */
    inline  T_SPM_SystemStatisticsData (const T_SPM_SystemStatisticsData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_SystemStatisticsData (uint32 MaxValue_, uint32 AvgValue_, uint32 MinValue_, bool StatisticDataDisabled_);

    /**
     * Destructor
     */
    inline  ~T_SPM_SystemStatisticsData();

    /**
     * Assignment operator
     */
    inline T_SPM_SystemStatisticsData& operator = (const T_SPM_SystemStatisticsData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MaxValue"

    static const int kMaxValue = 0;

    /**
     * Clears the field "MaxValue".
     *
     * The field will be set to its default value. The hasMaxValue()
     * method will return false.
     */
    inline void clearMaxValue();

    /**
     * Checks whether the field "MaxValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxValue()). Otherwise it will return false.
     */
    inline bool hasMaxValue () const;

    /**
     * Returns the value of the member "MaxValue".
     *
     * Maximum value of statistic data
     *
     * @return The value of the field "MaxValue"
     */
    inline uint32 getMaxValue () const;

    /**
     * Sets the value of the member "MaxValue".
     *
     * Maximum value of statistic data
     *
     * @param MaxValue The value which will be set
     */
    inline void setMaxValue (uint32 MaxValue_);

    // API of field "AvgValue"

    static const int kAvgValue = 1;

    /**
     * Clears the field "AvgValue".
     *
     * The field will be set to its default value. The hasAvgValue()
     * method will return false.
     */
    inline void clearAvgValue();

    /**
     * Checks whether the field "AvgValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvgValue()). Otherwise it will return false.
     */
    inline bool hasAvgValue () const;

    /**
     * Returns the value of the member "AvgValue".
     *
     * Average value of statistic data
     *
     * @return The value of the field "AvgValue"
     */
    inline uint32 getAvgValue () const;

    /**
     * Sets the value of the member "AvgValue".
     *
     * Average value of statistic data
     *
     * @param AvgValue The value which will be set
     */
    inline void setAvgValue (uint32 AvgValue_);

    // API of field "MinValue"

    static const int kMinValue = 2;

    /**
     * Clears the field "MinValue".
     *
     * The field will be set to its default value. The hasMinValue()
     * method will return false.
     */
    inline void clearMinValue();

    /**
     * Checks whether the field "MinValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinValue()). Otherwise it will return false.
     */
    inline bool hasMinValue () const;

    /**
     * Returns the value of the member "MinValue".
     *
     * Minimum value of statistic data
     *
     * @return The value of the field "MinValue"
     */
    inline uint32 getMinValue () const;

    /**
     * Sets the value of the member "MinValue".
     *
     * Minimum value of statistic data
     *
     * @param MinValue The value which will be set
     */
    inline void setMinValue (uint32 MinValue_);

    // API of field "StatisticDataDisabled"

    static const int kStatisticDataDisabled = 3;

    /**
     * Clears the field "StatisticDataDisabled".
     *
     * The field will be set to its default value. The hasStatisticDataDisabled()
     * method will return false.
     */
    inline void clearStatisticDataDisabled();

    /**
     * Checks whether the field "StatisticDataDisabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatisticDataDisabled()). Otherwise it will return false.
     */
    inline bool hasStatisticDataDisabled () const;

    /**
     * Returns the value of the member "StatisticDataDisabled".
     *
     * True when project decided to disable this feature.
     *
     * @return The value of the field "StatisticDataDisabled"
     */
    inline bool getStatisticDataDisabled () const;

    /**
     * Sets the value of the member "StatisticDataDisabled".
     *
     * True when project decided to disable this feature.
     *
     * @param StatisticDataDisabled The value which will be set
     */
    inline void setStatisticDataDisabled (bool StatisticDataDisabled_);

    static const T_SPM_SystemStatisticsData &getDefaultInstance();

private:

    inline void set_has_MaxValue ();

    inline void clear_has_MaxValue ();

    inline void set_has_AvgValue ();

    inline void clear_has_AvgValue ();

    inline void set_has_MinValue ();

    inline void clear_has_MinValue ();

    inline void set_has_StatisticDataDisabled ();

    inline void clear_has_StatisticDataDisabled ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _MaxValue;

    uint32 _AvgValue;

    uint32 _MinValue;

    bool _StatisticDataDisabled;

};

/**
 * If the meaning of "T_SPM_ResetInfoStatisticData" isn't clear, then there should be a description here.
 */
class T_SPM_ResetInfoStatisticData {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_ResetInfoStatisticData ();

    /**
     * Copy constructor
     */
    inline  T_SPM_ResetInfoStatisticData (const T_SPM_ResetInfoStatisticData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_ResetInfoStatisticData (const TTimeDate& tLastResetDate_, T_e8_LcmResetReason tLastResetReason_, uint32 u32ApApplicationError_, uint32 u32ApSoftware_, uint32 u32ApEcuReset_, uint32 u32ApDownload_, uint32 u32ApDownloadError_, uint32 u32ApOvertemperature_, uint32 u32ApUser_, uint32 u32ApLcmIntern_, uint32 u32ApWarmstartCount_, uint32 u32ApPowerOnCount_, uint32 u32ApPowerLossCount_, uint32 u32ApPowerOffCount_, uint32 u32ApSccCount_, uint32 u32ApUnknownCount_, uint32 u32SccHwWdtCount_, uint32 u32SccPowerOnCount_, uint32 u32SccColdstartCount_, uint32 u32SccAppmodeChangeCount_, uint32 u32SccDuringLpwCount_, uint32 u32SccDuringPllOszCount_, uint32 u32SccDuringSWCount_, uint32 u32SccWarmstartCount_);

    /**
     * Destructor
     */
    inline  ~T_SPM_ResetInfoStatisticData();

    /**
     * Assignment operator
     */
    inline T_SPM_ResetInfoStatisticData& operator = (const T_SPM_ResetInfoStatisticData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tLastResetDate"

    static const int kTLastResetDate = 0;

    /**
     * Clears the field "tLastResetDate".
     *
     * The field will be set to its default value. The hasTLastResetDate()
     * method will return false.
     */
    inline void clearTLastResetDate();

    /**
     * Checks whether the field "tLastResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetDate()). Otherwise it will return false.
     */
    inline bool hasTLastResetDate () const;

    /**
     * Returns the value of the member "tLastResetDate".
     *
     * If the meaning of "tLastResetDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tLastResetDate"
     */
    inline const TTimeDate& getTLastResetDate () const;

    /**
     * Retrieves the value of the field "tLastResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tLastResetDate".
     */
    inline TTimeDate& getTLastResetDateMutable ();

    /**
     * Sets the value of the member "tLastResetDate".
     *
     * If the meaning of "tLastResetDate" isn't clear, then there should be a description here.
     *
     * @param tLastResetDate The value which will be set
     */
    inline void setTLastResetDate (const TTimeDate& tLastResetDate_);

    /**
     * Release the object stored in the field "tLastResetDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tLastResetDate"
     */
    inline TTimeDate* releaseTLastResetDate();

    /**
     * Replace the field "tLastResetDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTLastResetDate (TTimeDate* tLastResetDate_);

    // API of field "tLastResetReason"

    static const int kTLastResetReason = 1;

    /**
     * Clears the field "tLastResetReason".
     *
     * The field will be set to its default value. The hasTLastResetReason()
     * method will return false.
     */
    inline void clearTLastResetReason();

    /**
     * Checks whether the field "tLastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetReason()). Otherwise it will return false.
     */
    inline bool hasTLastResetReason () const;

    /**
     * Returns the value of the member "tLastResetReason".
     *
     * If the meaning of "tLastResetReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tLastResetReason"
     */
    inline T_e8_LcmResetReason getTLastResetReason () const;

    /**
     * Sets the value of the member "tLastResetReason".
     *
     * If the meaning of "tLastResetReason" isn't clear, then there should be a description here.
     *
     * @param tLastResetReason The value which will be set
     */
    inline void setTLastResetReason (T_e8_LcmResetReason tLastResetReason_);

    // API of field "u32ApApplicationError"

    static const int kU32ApApplicationError = 2;

    /**
     * Clears the field "u32ApApplicationError".
     *
     * The field will be set to its default value. The hasU32ApApplicationError()
     * method will return false.
     */
    inline void clearU32ApApplicationError();

    /**
     * Checks whether the field "u32ApApplicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApApplicationError()). Otherwise it will return false.
     */
    inline bool hasU32ApApplicationError () const;

    /**
     * Returns the value of the member "u32ApApplicationError".
     *
     * If the meaning of "u32ApApplicationError" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApApplicationError"
     */
    inline uint32 getU32ApApplicationError () const;

    /**
     * Sets the value of the member "u32ApApplicationError".
     *
     * If the meaning of "u32ApApplicationError" isn't clear, then there should be a description here.
     *
     * @param u32ApApplicationError The value which will be set
     */
    inline void setU32ApApplicationError (uint32 u32ApApplicationError_);

    // API of field "u32ApSoftware"

    static const int kU32ApSoftware = 3;

    /**
     * Clears the field "u32ApSoftware".
     *
     * The field will be set to its default value. The hasU32ApSoftware()
     * method will return false.
     */
    inline void clearU32ApSoftware();

    /**
     * Checks whether the field "u32ApSoftware" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSoftware()). Otherwise it will return false.
     */
    inline bool hasU32ApSoftware () const;

    /**
     * Returns the value of the member "u32ApSoftware".
     *
     * If the meaning of "u32ApSoftware" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApSoftware"
     */
    inline uint32 getU32ApSoftware () const;

    /**
     * Sets the value of the member "u32ApSoftware".
     *
     * If the meaning of "u32ApSoftware" isn't clear, then there should be a description here.
     *
     * @param u32ApSoftware The value which will be set
     */
    inline void setU32ApSoftware (uint32 u32ApSoftware_);

    // API of field "u32ApEcuReset"

    static const int kU32ApEcuReset = 4;

    /**
     * Clears the field "u32ApEcuReset".
     *
     * The field will be set to its default value. The hasU32ApEcuReset()
     * method will return false.
     */
    inline void clearU32ApEcuReset();

    /**
     * Checks whether the field "u32ApEcuReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApEcuReset()). Otherwise it will return false.
     */
    inline bool hasU32ApEcuReset () const;

    /**
     * Returns the value of the member "u32ApEcuReset".
     *
     * If the meaning of "u32ApEcuReset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApEcuReset"
     */
    inline uint32 getU32ApEcuReset () const;

    /**
     * Sets the value of the member "u32ApEcuReset".
     *
     * If the meaning of "u32ApEcuReset" isn't clear, then there should be a description here.
     *
     * @param u32ApEcuReset The value which will be set
     */
    inline void setU32ApEcuReset (uint32 u32ApEcuReset_);

    // API of field "u32ApDownload"

    static const int kU32ApDownload = 5;

    /**
     * Clears the field "u32ApDownload".
     *
     * The field will be set to its default value. The hasU32ApDownload()
     * method will return false.
     */
    inline void clearU32ApDownload();

    /**
     * Checks whether the field "u32ApDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownload()). Otherwise it will return false.
     */
    inline bool hasU32ApDownload () const;

    /**
     * Returns the value of the member "u32ApDownload".
     *
     * If the meaning of "u32ApDownload" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApDownload"
     */
    inline uint32 getU32ApDownload () const;

    /**
     * Sets the value of the member "u32ApDownload".
     *
     * If the meaning of "u32ApDownload" isn't clear, then there should be a description here.
     *
     * @param u32ApDownload The value which will be set
     */
    inline void setU32ApDownload (uint32 u32ApDownload_);

    // API of field "u32ApDownloadError"

    static const int kU32ApDownloadError = 6;

    /**
     * Clears the field "u32ApDownloadError".
     *
     * The field will be set to its default value. The hasU32ApDownloadError()
     * method will return false.
     */
    inline void clearU32ApDownloadError();

    /**
     * Checks whether the field "u32ApDownloadError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownloadError()). Otherwise it will return false.
     */
    inline bool hasU32ApDownloadError () const;

    /**
     * Returns the value of the member "u32ApDownloadError".
     *
     * If the meaning of "u32ApDownloadError" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApDownloadError"
     */
    inline uint32 getU32ApDownloadError () const;

    /**
     * Sets the value of the member "u32ApDownloadError".
     *
     * If the meaning of "u32ApDownloadError" isn't clear, then there should be a description here.
     *
     * @param u32ApDownloadError The value which will be set
     */
    inline void setU32ApDownloadError (uint32 u32ApDownloadError_);

    // API of field "u32ApOvertemperature"

    static const int kU32ApOvertemperature = 7;

    /**
     * Clears the field "u32ApOvertemperature".
     *
     * The field will be set to its default value. The hasU32ApOvertemperature()
     * method will return false.
     */
    inline void clearU32ApOvertemperature();

    /**
     * Checks whether the field "u32ApOvertemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApOvertemperature()). Otherwise it will return false.
     */
    inline bool hasU32ApOvertemperature () const;

    /**
     * Returns the value of the member "u32ApOvertemperature".
     *
     * If the meaning of "u32ApOvertemperature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApOvertemperature"
     */
    inline uint32 getU32ApOvertemperature () const;

    /**
     * Sets the value of the member "u32ApOvertemperature".
     *
     * If the meaning of "u32ApOvertemperature" isn't clear, then there should be a description here.
     *
     * @param u32ApOvertemperature The value which will be set
     */
    inline void setU32ApOvertemperature (uint32 u32ApOvertemperature_);

    // API of field "u32ApUser"

    static const int kU32ApUser = 8;

    /**
     * Clears the field "u32ApUser".
     *
     * The field will be set to its default value. The hasU32ApUser()
     * method will return false.
     */
    inline void clearU32ApUser();

    /**
     * Checks whether the field "u32ApUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUser()). Otherwise it will return false.
     */
    inline bool hasU32ApUser () const;

    /**
     * Returns the value of the member "u32ApUser".
     *
     * If the meaning of "u32ApUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApUser"
     */
    inline uint32 getU32ApUser () const;

    /**
     * Sets the value of the member "u32ApUser".
     *
     * If the meaning of "u32ApUser" isn't clear, then there should be a description here.
     *
     * @param u32ApUser The value which will be set
     */
    inline void setU32ApUser (uint32 u32ApUser_);

    // API of field "u32ApLcmIntern"

    static const int kU32ApLcmIntern = 9;

    /**
     * Clears the field "u32ApLcmIntern".
     *
     * The field will be set to its default value. The hasU32ApLcmIntern()
     * method will return false.
     */
    inline void clearU32ApLcmIntern();

    /**
     * Checks whether the field "u32ApLcmIntern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApLcmIntern()). Otherwise it will return false.
     */
    inline bool hasU32ApLcmIntern () const;

    /**
     * Returns the value of the member "u32ApLcmIntern".
     *
     * If the meaning of "u32ApLcmIntern" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApLcmIntern"
     */
    inline uint32 getU32ApLcmIntern () const;

    /**
     * Sets the value of the member "u32ApLcmIntern".
     *
     * If the meaning of "u32ApLcmIntern" isn't clear, then there should be a description here.
     *
     * @param u32ApLcmIntern The value which will be set
     */
    inline void setU32ApLcmIntern (uint32 u32ApLcmIntern_);

    // API of field "u32ApWarmstartCount"

    static const int kU32ApWarmstartCount = 10;

    /**
     * Clears the field "u32ApWarmstartCount".
     *
     * The field will be set to its default value. The hasU32ApWarmstartCount()
     * method will return false.
     */
    inline void clearU32ApWarmstartCount();

    /**
     * Checks whether the field "u32ApWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32ApWarmstartCount () const;

    /**
     * Returns the value of the member "u32ApWarmstartCount".
     *
     * If the meaning of "u32ApWarmstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApWarmstartCount"
     */
    inline uint32 getU32ApWarmstartCount () const;

    /**
     * Sets the value of the member "u32ApWarmstartCount".
     *
     * If the meaning of "u32ApWarmstartCount" isn't clear, then there should be a description here.
     *
     * @param u32ApWarmstartCount The value which will be set
     */
    inline void setU32ApWarmstartCount (uint32 u32ApWarmstartCount_);

    // API of field "u32ApPowerOnCount"

    static const int kU32ApPowerOnCount = 11;

    /**
     * Clears the field "u32ApPowerOnCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOnCount()
     * method will return false.
     */
    inline void clearU32ApPowerOnCount();

    /**
     * Checks whether the field "u32ApPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOnCount () const;

    /**
     * Returns the value of the member "u32ApPowerOnCount".
     *
     * If the meaning of "u32ApPowerOnCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerOnCount"
     */
    inline uint32 getU32ApPowerOnCount () const;

    /**
     * Sets the value of the member "u32ApPowerOnCount".
     *
     * If the meaning of "u32ApPowerOnCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerOnCount The value which will be set
     */
    inline void setU32ApPowerOnCount (uint32 u32ApPowerOnCount_);

    // API of field "u32ApPowerLossCount"

    static const int kU32ApPowerLossCount = 12;

    /**
     * Clears the field "u32ApPowerLossCount".
     *
     * The field will be set to its default value. The hasU32ApPowerLossCount()
     * method will return false.
     */
    inline void clearU32ApPowerLossCount();

    /**
     * Checks whether the field "u32ApPowerLossCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerLossCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerLossCount () const;

    /**
     * Returns the value of the member "u32ApPowerLossCount".
     *
     * If the meaning of "u32ApPowerLossCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerLossCount"
     */
    inline uint32 getU32ApPowerLossCount () const;

    /**
     * Sets the value of the member "u32ApPowerLossCount".
     *
     * If the meaning of "u32ApPowerLossCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerLossCount The value which will be set
     */
    inline void setU32ApPowerLossCount (uint32 u32ApPowerLossCount_);

    // API of field "u32ApPowerOffCount"

    static const int kU32ApPowerOffCount = 13;

    /**
     * Clears the field "u32ApPowerOffCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOffCount()
     * method will return false.
     */
    inline void clearU32ApPowerOffCount();

    /**
     * Checks whether the field "u32ApPowerOffCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOffCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOffCount () const;

    /**
     * Returns the value of the member "u32ApPowerOffCount".
     *
     * If the meaning of "u32ApPowerOffCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerOffCount"
     */
    inline uint32 getU32ApPowerOffCount () const;

    /**
     * Sets the value of the member "u32ApPowerOffCount".
     *
     * If the meaning of "u32ApPowerOffCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerOffCount The value which will be set
     */
    inline void setU32ApPowerOffCount (uint32 u32ApPowerOffCount_);

    // API of field "u32ApSccCount"

    static const int kU32ApSccCount = 14;

    /**
     * Clears the field "u32ApSccCount".
     *
     * The field will be set to its default value. The hasU32ApSccCount()
     * method will return false.
     */
    inline void clearU32ApSccCount();

    /**
     * Checks whether the field "u32ApSccCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSccCount()). Otherwise it will return false.
     */
    inline bool hasU32ApSccCount () const;

    /**
     * Returns the value of the member "u32ApSccCount".
     *
     * If the meaning of "u32ApSccCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApSccCount"
     */
    inline uint32 getU32ApSccCount () const;

    /**
     * Sets the value of the member "u32ApSccCount".
     *
     * If the meaning of "u32ApSccCount" isn't clear, then there should be a description here.
     *
     * @param u32ApSccCount The value which will be set
     */
    inline void setU32ApSccCount (uint32 u32ApSccCount_);

    // API of field "u32ApUnknownCount"

    static const int kU32ApUnknownCount = 15;

    /**
     * Clears the field "u32ApUnknownCount".
     *
     * The field will be set to its default value. The hasU32ApUnknownCount()
     * method will return false.
     */
    inline void clearU32ApUnknownCount();

    /**
     * Checks whether the field "u32ApUnknownCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUnknownCount()). Otherwise it will return false.
     */
    inline bool hasU32ApUnknownCount () const;

    /**
     * Returns the value of the member "u32ApUnknownCount".
     *
     * If the meaning of "u32ApUnknownCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApUnknownCount"
     */
    inline uint32 getU32ApUnknownCount () const;

    /**
     * Sets the value of the member "u32ApUnknownCount".
     *
     * If the meaning of "u32ApUnknownCount" isn't clear, then there should be a description here.
     *
     * @param u32ApUnknownCount The value which will be set
     */
    inline void setU32ApUnknownCount (uint32 u32ApUnknownCount_);

    // API of field "u32SccHwWdtCount"

    static const int kU32SccHwWdtCount = 16;

    /**
     * Clears the field "u32SccHwWdtCount".
     *
     * The field will be set to its default value. The hasU32SccHwWdtCount()
     * method will return false.
     */
    inline void clearU32SccHwWdtCount();

    /**
     * Checks whether the field "u32SccHwWdtCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccHwWdtCount()). Otherwise it will return false.
     */
    inline bool hasU32SccHwWdtCount () const;

    /**
     * Returns the value of the member "u32SccHwWdtCount".
     *
     * If the meaning of "u32SccHwWdtCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccHwWdtCount"
     */
    inline uint32 getU32SccHwWdtCount () const;

    /**
     * Sets the value of the member "u32SccHwWdtCount".
     *
     * If the meaning of "u32SccHwWdtCount" isn't clear, then there should be a description here.
     *
     * @param u32SccHwWdtCount The value which will be set
     */
    inline void setU32SccHwWdtCount (uint32 u32SccHwWdtCount_);

    // API of field "u32SccPowerOnCount"

    static const int kU32SccPowerOnCount = 17;

    /**
     * Clears the field "u32SccPowerOnCount".
     *
     * The field will be set to its default value. The hasU32SccPowerOnCount()
     * method will return false.
     */
    inline void clearU32SccPowerOnCount();

    /**
     * Checks whether the field "u32SccPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32SccPowerOnCount () const;

    /**
     * Returns the value of the member "u32SccPowerOnCount".
     *
     * If the meaning of "u32SccPowerOnCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccPowerOnCount"
     */
    inline uint32 getU32SccPowerOnCount () const;

    /**
     * Sets the value of the member "u32SccPowerOnCount".
     *
     * If the meaning of "u32SccPowerOnCount" isn't clear, then there should be a description here.
     *
     * @param u32SccPowerOnCount The value which will be set
     */
    inline void setU32SccPowerOnCount (uint32 u32SccPowerOnCount_);

    // API of field "u32SccColdstartCount"

    static const int kU32SccColdstartCount = 18;

    /**
     * Clears the field "u32SccColdstartCount".
     *
     * The field will be set to its default value. The hasU32SccColdstartCount()
     * method will return false.
     */
    inline void clearU32SccColdstartCount();

    /**
     * Checks whether the field "u32SccColdstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccColdstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccColdstartCount () const;

    /**
     * Returns the value of the member "u32SccColdstartCount".
     *
     * If the meaning of "u32SccColdstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccColdstartCount"
     */
    inline uint32 getU32SccColdstartCount () const;

    /**
     * Sets the value of the member "u32SccColdstartCount".
     *
     * If the meaning of "u32SccColdstartCount" isn't clear, then there should be a description here.
     *
     * @param u32SccColdstartCount The value which will be set
     */
    inline void setU32SccColdstartCount (uint32 u32SccColdstartCount_);

    // API of field "u32SccAppmodeChangeCount"

    static const int kU32SccAppmodeChangeCount = 19;

    /**
     * Clears the field "u32SccAppmodeChangeCount".
     *
     * The field will be set to its default value. The hasU32SccAppmodeChangeCount()
     * method will return false.
     */
    inline void clearU32SccAppmodeChangeCount();

    /**
     * Checks whether the field "u32SccAppmodeChangeCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccAppmodeChangeCount()). Otherwise it will return false.
     */
    inline bool hasU32SccAppmodeChangeCount () const;

    /**
     * Returns the value of the member "u32SccAppmodeChangeCount".
     *
     * If the meaning of "u32SccAppmodeChangeCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccAppmodeChangeCount"
     */
    inline uint32 getU32SccAppmodeChangeCount () const;

    /**
     * Sets the value of the member "u32SccAppmodeChangeCount".
     *
     * If the meaning of "u32SccAppmodeChangeCount" isn't clear, then there should be a description here.
     *
     * @param u32SccAppmodeChangeCount The value which will be set
     */
    inline void setU32SccAppmodeChangeCount (uint32 u32SccAppmodeChangeCount_);

    // API of field "u32SccDuringLpwCount"

    static const int kU32SccDuringLpwCount = 20;

    /**
     * Clears the field "u32SccDuringLpwCount".
     *
     * The field will be set to its default value. The hasU32SccDuringLpwCount()
     * method will return false.
     */
    inline void clearU32SccDuringLpwCount();

    /**
     * Checks whether the field "u32SccDuringLpwCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringLpwCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringLpwCount () const;

    /**
     * Returns the value of the member "u32SccDuringLpwCount".
     *
     * If the meaning of "u32SccDuringLpwCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringLpwCount"
     */
    inline uint32 getU32SccDuringLpwCount () const;

    /**
     * Sets the value of the member "u32SccDuringLpwCount".
     *
     * If the meaning of "u32SccDuringLpwCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringLpwCount The value which will be set
     */
    inline void setU32SccDuringLpwCount (uint32 u32SccDuringLpwCount_);

    // API of field "u32SccDuringPllOszCount"

    static const int kU32SccDuringPllOszCount = 21;

    /**
     * Clears the field "u32SccDuringPllOszCount".
     *
     * The field will be set to its default value. The hasU32SccDuringPllOszCount()
     * method will return false.
     */
    inline void clearU32SccDuringPllOszCount();

    /**
     * Checks whether the field "u32SccDuringPllOszCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringPllOszCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringPllOszCount () const;

    /**
     * Returns the value of the member "u32SccDuringPllOszCount".
     *
     * If the meaning of "u32SccDuringPllOszCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringPllOszCount"
     */
    inline uint32 getU32SccDuringPllOszCount () const;

    /**
     * Sets the value of the member "u32SccDuringPllOszCount".
     *
     * If the meaning of "u32SccDuringPllOszCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringPllOszCount The value which will be set
     */
    inline void setU32SccDuringPllOszCount (uint32 u32SccDuringPllOszCount_);

    // API of field "u32SccDuringSWCount"

    static const int kU32SccDuringSWCount = 22;

    /**
     * Clears the field "u32SccDuringSWCount".
     *
     * The field will be set to its default value. The hasU32SccDuringSWCount()
     * method will return false.
     */
    inline void clearU32SccDuringSWCount();

    /**
     * Checks whether the field "u32SccDuringSWCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringSWCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringSWCount () const;

    /**
     * Returns the value of the member "u32SccDuringSWCount".
     *
     * If the meaning of "u32SccDuringSWCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringSWCount"
     */
    inline uint32 getU32SccDuringSWCount () const;

    /**
     * Sets the value of the member "u32SccDuringSWCount".
     *
     * If the meaning of "u32SccDuringSWCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringSWCount The value which will be set
     */
    inline void setU32SccDuringSWCount (uint32 u32SccDuringSWCount_);

    // API of field "u32SccWarmstartCount"

    static const int kU32SccWarmstartCount = 23;

    /**
     * Clears the field "u32SccWarmstartCount".
     *
     * The field will be set to its default value. The hasU32SccWarmstartCount()
     * method will return false.
     */
    inline void clearU32SccWarmstartCount();

    /**
     * Checks whether the field "u32SccWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccWarmstartCount () const;

    /**
     * Returns the value of the member "u32SccWarmstartCount".
     *
     * If the meaning of "u32SccWarmstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccWarmstartCount"
     */
    inline uint32 getU32SccWarmstartCount () const;

    /**
     * Sets the value of the member "u32SccWarmstartCount".
     *
     * If the meaning of "u32SccWarmstartCount" isn't clear, then there should be a description here.
     *
     * @param u32SccWarmstartCount The value which will be set
     */
    inline void setU32SccWarmstartCount (uint32 u32SccWarmstartCount_);

    static const T_SPM_ResetInfoStatisticData &getDefaultInstance();

private:

    inline void set_has_tLastResetDate ();

    inline void clear_has_tLastResetDate ();

    inline void set_has_tLastResetReason ();

    inline void clear_has_tLastResetReason ();

    inline void set_has_u32ApApplicationError ();

    inline void clear_has_u32ApApplicationError ();

    inline void set_has_u32ApSoftware ();

    inline void clear_has_u32ApSoftware ();

    inline void set_has_u32ApEcuReset ();

    inline void clear_has_u32ApEcuReset ();

    inline void set_has_u32ApDownload ();

    inline void clear_has_u32ApDownload ();

    inline void set_has_u32ApDownloadError ();

    inline void clear_has_u32ApDownloadError ();

    inline void set_has_u32ApOvertemperature ();

    inline void clear_has_u32ApOvertemperature ();

    inline void set_has_u32ApUser ();

    inline void clear_has_u32ApUser ();

    inline void set_has_u32ApLcmIntern ();

    inline void clear_has_u32ApLcmIntern ();

    inline void set_has_u32ApWarmstartCount ();

    inline void clear_has_u32ApWarmstartCount ();

    inline void set_has_u32ApPowerOnCount ();

    inline void clear_has_u32ApPowerOnCount ();

    inline void set_has_u32ApPowerLossCount ();

    inline void clear_has_u32ApPowerLossCount ();

    inline void set_has_u32ApPowerOffCount ();

    inline void clear_has_u32ApPowerOffCount ();

    inline void set_has_u32ApSccCount ();

    inline void clear_has_u32ApSccCount ();

    inline void set_has_u32ApUnknownCount ();

    inline void clear_has_u32ApUnknownCount ();

    inline void set_has_u32SccHwWdtCount ();

    inline void clear_has_u32SccHwWdtCount ();

    inline void set_has_u32SccPowerOnCount ();

    inline void clear_has_u32SccPowerOnCount ();

    inline void set_has_u32SccColdstartCount ();

    inline void clear_has_u32SccColdstartCount ();

    inline void set_has_u32SccAppmodeChangeCount ();

    inline void clear_has_u32SccAppmodeChangeCount ();

    inline void set_has_u32SccDuringLpwCount ();

    inline void clear_has_u32SccDuringLpwCount ();

    inline void set_has_u32SccDuringPllOszCount ();

    inline void clear_has_u32SccDuringPllOszCount ();

    inline void set_has_u32SccDuringSWCount ();

    inline void clear_has_u32SccDuringSWCount ();

    inline void set_has_u32SccWarmstartCount ();

    inline void clear_has_u32SccWarmstartCount ();

    uint32 _has_bits_[ (24 + 31) / 32];

    TTimeDate* _tLastResetDate;

    T_e8_LcmResetReason _tLastResetReason;

    uint32 _u32ApApplicationError;

    uint32 _u32ApSoftware;

    uint32 _u32ApEcuReset;

    uint32 _u32ApDownload;

    uint32 _u32ApDownloadError;

    uint32 _u32ApOvertemperature;

    uint32 _u32ApUser;

    uint32 _u32ApLcmIntern;

    uint32 _u32ApWarmstartCount;

    uint32 _u32ApPowerOnCount;

    uint32 _u32ApPowerLossCount;

    uint32 _u32ApPowerOffCount;

    uint32 _u32ApSccCount;

    uint32 _u32ApUnknownCount;

    uint32 _u32SccHwWdtCount;

    uint32 _u32SccPowerOnCount;

    uint32 _u32SccColdstartCount;

    uint32 _u32SccAppmodeChangeCount;

    uint32 _u32SccDuringLpwCount;

    uint32 _u32SccDuringPllOszCount;

    uint32 _u32SccDuringSWCount;

    uint32 _u32SccWarmstartCount;

};

/**
 * If the meaning of "T_SPM_SWVersionStatisticData" isn't clear, then there should be a description here.
 */
class T_SPM_SWVersionStatisticData {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_SWVersionStatisticData ();

    /**
     * Copy constructor
     */
    inline  T_SPM_SWVersionStatisticData (const T_SPM_SWVersionStatisticData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_SWVersionStatisticData (const ::std::string& strBuildVersion_, const ::std::string& strBuildVersionCustomer_, const ::std::string& strCustomerVersion_, const T_SPM_ResetInfoStatisticData& tResetInfo_, const ::boost::ptr_vector< T_ResetElement >& tResetHistoryList_, const ::boost::ptr_vector< T_WakeupElement >& tWakeupHistoryList_, const ::boost::ptr_vector< T_SwitchOnElement >& tSwitchOnList_, const ::boost::ptr_vector< T_StateChangeElement >& tStateHistoryList_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory01List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory02List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory03List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory04List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory05List_, uint32 u32SystemOperationTime_, const T_SPM_SystemStatisticsData& tCpuUsage_, const T_SPM_SystemStatisticsData& tRamUsage_, const T_SPM_SystemStatisticsData& tStartupTime_);

    /**
     * Destructor
     */
    inline  ~T_SPM_SWVersionStatisticData();

    /**
     * Assignment operator
     */
    inline T_SPM_SWVersionStatisticData& operator = (const T_SPM_SWVersionStatisticData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_SWVersionStatisticData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_SWVersionStatisticData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_SWVersionStatisticData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_SWVersionStatisticData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strBuildVersion"

    static const int kStrBuildVersion = 0;

    /**
     * Clears the field "strBuildVersion".
     *
     * The field will be set to its default value. The hasStrBuildVersion()
     * method will return false.
     */
    inline void clearStrBuildVersion();

    /**
     * Checks whether the field "strBuildVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrBuildVersion()). Otherwise it will return false.
     */
    inline bool hasStrBuildVersion () const;

    /**
     * Returns the value of the member "strBuildVersion".
     *
     * Software build version label
     *
     * @return The value of the field "strBuildVersion"
     */
    inline const ::std::string& getStrBuildVersion () const;

    /**
     * Retrieves the value of the field "strBuildVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strBuildVersion".
     */
    inline ::std::string& getStrBuildVersionMutable ();

    /**
     * Sets the value of the member "strBuildVersion".
     *
     * Software build version label
     *
     * @param strBuildVersion The value which will be set
     */
    inline void setStrBuildVersion (const ::std::string& strBuildVersion_);

    /**
     * Sets the value of the member "strBuildVersion".
     *
     * Software build version label
     *
     * @param strBuildVersion The value which will be set
     */
    inline void setStrBuildVersion (const char* strBuildVersion_);

    /**
     * Sets the value of the member "strBuildVersion".
     *
     * Software build version label
     *
     * @param strBuildVersion The value which will be set
     */
    inline void setStrBuildVersion (const char* value, size_t size);

    /**
     * Release the object stored in the field "strBuildVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strBuildVersion"
     */
    inline ::std::string* releaseStrBuildVersion();

    /**
     * Replace the field "strBuildVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrBuildVersion (::std::string* strBuildVersion_);

    // API of field "strBuildVersionCustomer"

    static const int kStrBuildVersionCustomer = 1;

    /**
     * Clears the field "strBuildVersionCustomer".
     *
     * The field will be set to its default value. The hasStrBuildVersionCustomer()
     * method will return false.
     */
    inline void clearStrBuildVersionCustomer();

    /**
     * Checks whether the field "strBuildVersionCustomer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrBuildVersionCustomer()). Otherwise it will return false.
     */
    inline bool hasStrBuildVersionCustomer () const;

    /**
     * Returns the value of the member "strBuildVersionCustomer".
     *
     * Software build version
     *
     * @return The value of the field "strBuildVersionCustomer"
     */
    inline const ::std::string& getStrBuildVersionCustomer () const;

    /**
     * Retrieves the value of the field "strBuildVersionCustomer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strBuildVersionCustomer".
     */
    inline ::std::string& getStrBuildVersionCustomerMutable ();

    /**
     * Sets the value of the member "strBuildVersionCustomer".
     *
     * Software build version
     *
     * @param strBuildVersionCustomer The value which will be set
     */
    inline void setStrBuildVersionCustomer (const ::std::string& strBuildVersionCustomer_);

    /**
     * Sets the value of the member "strBuildVersionCustomer".
     *
     * Software build version
     *
     * @param strBuildVersionCustomer The value which will be set
     */
    inline void setStrBuildVersionCustomer (const char* strBuildVersionCustomer_);

    /**
     * Sets the value of the member "strBuildVersionCustomer".
     *
     * Software build version
     *
     * @param strBuildVersionCustomer The value which will be set
     */
    inline void setStrBuildVersionCustomer (const char* value, size_t size);

    /**
     * Release the object stored in the field "strBuildVersionCustomer".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strBuildVersionCustomer"
     */
    inline ::std::string* releaseStrBuildVersionCustomer();

    /**
     * Replace the field "strBuildVersionCustomer".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrBuildVersionCustomer (::std::string* strBuildVersionCustomer_);

    // API of field "strCustomerVersion"

    static const int kStrCustomerVersion = 2;

    /**
     * Clears the field "strCustomerVersion".
     *
     * The field will be set to its default value. The hasStrCustomerVersion()
     * method will return false.
     */
    inline void clearStrCustomerVersion();

    /**
     * Checks whether the field "strCustomerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrCustomerVersion()). Otherwise it will return false.
     */
    inline bool hasStrCustomerVersion () const;

    /**
     * Returns the value of the member "strCustomerVersion".
     *
     * Software customer version
     *
     * @return The value of the field "strCustomerVersion"
     */
    inline const ::std::string& getStrCustomerVersion () const;

    /**
     * Retrieves the value of the field "strCustomerVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strCustomerVersion".
     */
    inline ::std::string& getStrCustomerVersionMutable ();

    /**
     * Sets the value of the member "strCustomerVersion".
     *
     * Software customer version
     *
     * @param strCustomerVersion The value which will be set
     */
    inline void setStrCustomerVersion (const ::std::string& strCustomerVersion_);

    /**
     * Sets the value of the member "strCustomerVersion".
     *
     * Software customer version
     *
     * @param strCustomerVersion The value which will be set
     */
    inline void setStrCustomerVersion (const char* strCustomerVersion_);

    /**
     * Sets the value of the member "strCustomerVersion".
     *
     * Software customer version
     *
     * @param strCustomerVersion The value which will be set
     */
    inline void setStrCustomerVersion (const char* value, size_t size);

    /**
     * Release the object stored in the field "strCustomerVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strCustomerVersion"
     */
    inline ::std::string* releaseStrCustomerVersion();

    /**
     * Replace the field "strCustomerVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrCustomerVersion (::std::string* strCustomerVersion_);

    // API of field "tResetInfo"

    static const int kTResetInfo = 3;

    /**
     * Clears the field "tResetInfo".
     *
     * The field will be set to its default value. The hasTResetInfo()
     * method will return false.
     */
    inline void clearTResetInfo();

    /**
     * Checks whether the field "tResetInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTResetInfo()). Otherwise it will return false.
     */
    inline bool hasTResetInfo () const;

    /**
     * Returns the value of the member "tResetInfo".
     *
     * Reset information statistic data
     *
     * @return The value of the field "tResetInfo"
     */
    inline const T_SPM_ResetInfoStatisticData& getTResetInfo () const;

    /**
     * Retrieves the value of the field "tResetInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tResetInfo".
     */
    inline T_SPM_ResetInfoStatisticData& getTResetInfoMutable ();

    /**
     * Sets the value of the member "tResetInfo".
     *
     * Reset information statistic data
     *
     * @param tResetInfo The value which will be set
     */
    inline void setTResetInfo (const T_SPM_ResetInfoStatisticData& tResetInfo_);

    /**
     * Release the object stored in the field "tResetInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tResetInfo"
     */
    inline T_SPM_ResetInfoStatisticData* releaseTResetInfo();

    /**
     * Replace the field "tResetInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTResetInfo (T_SPM_ResetInfoStatisticData* tResetInfo_);

    // API of field "tResetHistoryList"

    static const int kTResetHistoryList = 4;

    /**
     * Clears the field "tResetHistoryList".
     *
     * The field will be set to its default value. The hasTResetHistoryList()
     * method will return false.
     */
    inline void clearTResetHistoryList();

    /**
     * Checks whether the field "tResetHistoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTResetHistoryList()). Otherwise it will return false.
     */
    inline bool hasTResetHistoryList () const;

    /**
     * Returns the value of the member "tResetHistoryList".
     *
     * Reset history statistic data
     *
     * @return The value of the field "tResetHistoryList"
     */
    inline const ::boost::ptr_vector< T_ResetElement >& getTResetHistoryList () const;

    /**
     * Retrieves the value of the field "tResetHistoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tResetHistoryList".
     */
    inline ::boost::ptr_vector< T_ResetElement >& getTResetHistoryListMutable ();

    /**
     * Sets the value of the member "tResetHistoryList".
     *
     * Reset history statistic data
     *
     * @param tResetHistoryList The value which will be set
     */
    inline void setTResetHistoryList (const ::boost::ptr_vector< T_ResetElement >& tResetHistoryList_);

    /**
     * Release the object stored in the field "tResetHistoryList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tResetHistoryList"
     */
    inline ::boost::ptr_vector< T_ResetElement >* releaseTResetHistoryList();

    /**
     * Replace the field "tResetHistoryList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTResetHistoryList (::boost::ptr_vector< T_ResetElement >* tResetHistoryList_);

    // API of field "tWakeupHistoryList"

    static const int kTWakeupHistoryList = 5;

    /**
     * Clears the field "tWakeupHistoryList".
     *
     * The field will be set to its default value. The hasTWakeupHistoryList()
     * method will return false.
     */
    inline void clearTWakeupHistoryList();

    /**
     * Checks whether the field "tWakeupHistoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupHistoryList()). Otherwise it will return false.
     */
    inline bool hasTWakeupHistoryList () const;

    /**
     * Returns the value of the member "tWakeupHistoryList".
     *
     * Wake up statistic data
     *
     * @return The value of the field "tWakeupHistoryList"
     */
    inline const ::boost::ptr_vector< T_WakeupElement >& getTWakeupHistoryList () const;

    /**
     * Retrieves the value of the field "tWakeupHistoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupHistoryList".
     */
    inline ::boost::ptr_vector< T_WakeupElement >& getTWakeupHistoryListMutable ();

    /**
     * Sets the value of the member "tWakeupHistoryList".
     *
     * Wake up statistic data
     *
     * @param tWakeupHistoryList The value which will be set
     */
    inline void setTWakeupHistoryList (const ::boost::ptr_vector< T_WakeupElement >& tWakeupHistoryList_);

    /**
     * Release the object stored in the field "tWakeupHistoryList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tWakeupHistoryList"
     */
    inline ::boost::ptr_vector< T_WakeupElement >* releaseTWakeupHistoryList();

    /**
     * Replace the field "tWakeupHistoryList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTWakeupHistoryList (::boost::ptr_vector< T_WakeupElement >* tWakeupHistoryList_);

    // API of field "tSwitchOnList"

    static const int kTSwitchOnList = 6;

    /**
     * Clears the field "tSwitchOnList".
     *
     * The field will be set to its default value. The hasTSwitchOnList()
     * method will return false.
     */
    inline void clearTSwitchOnList();

    /**
     * Checks whether the field "tSwitchOnList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnList()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnList () const;

    /**
     * Returns the value of the member "tSwitchOnList".
     *
     * Switch On statistic data
     *
     * @return The value of the field "tSwitchOnList"
     */
    inline const ::boost::ptr_vector< T_SwitchOnElement >& getTSwitchOnList () const;

    /**
     * Retrieves the value of the field "tSwitchOnList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnList".
     */
    inline ::boost::ptr_vector< T_SwitchOnElement >& getTSwitchOnListMutable ();

    /**
     * Sets the value of the member "tSwitchOnList".
     *
     * Switch On statistic data
     *
     * @param tSwitchOnList The value which will be set
     */
    inline void setTSwitchOnList (const ::boost::ptr_vector< T_SwitchOnElement >& tSwitchOnList_);

    /**
     * Release the object stored in the field "tSwitchOnList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwitchOnList"
     */
    inline ::boost::ptr_vector< T_SwitchOnElement >* releaseTSwitchOnList();

    /**
     * Replace the field "tSwitchOnList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwitchOnList (::boost::ptr_vector< T_SwitchOnElement >* tSwitchOnList_);

    // API of field "tStateHistoryList"

    static const int kTStateHistoryList = 7;

    /**
     * Clears the field "tStateHistoryList".
     *
     * The field will be set to its default value. The hasTStateHistoryList()
     * method will return false.
     */
    inline void clearTStateHistoryList();

    /**
     * Checks whether the field "tStateHistoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateHistoryList()). Otherwise it will return false.
     */
    inline bool hasTStateHistoryList () const;

    /**
     * Returns the value of the member "tStateHistoryList".
     *
     * System state statistic data
     *
     * @return The value of the field "tStateHistoryList"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTStateHistoryList () const;

    /**
     * Retrieves the value of the field "tStateHistoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateHistoryList".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTStateHistoryListMutable ();

    /**
     * Sets the value of the member "tStateHistoryList".
     *
     * System state statistic data
     *
     * @param tStateHistoryList The value which will be set
     */
    inline void setTStateHistoryList (const ::boost::ptr_vector< T_StateChangeElement >& tStateHistoryList_);

    /**
     * Release the object stored in the field "tStateHistoryList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateHistoryList"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTStateHistoryList();

    /**
     * Replace the field "tStateHistoryList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateHistoryList (::boost::ptr_vector< T_StateChangeElement >* tStateHistoryList_);

    // API of field "tErrStateHistory01List"

    static const int kTErrStateHistory01List = 8;

    /**
     * Clears the field "tErrStateHistory01List".
     *
     * The field will be set to its default value. The hasTErrStateHistory01List()
     * method will return false.
     */
    inline void clearTErrStateHistory01List();

    /**
     * Checks whether the field "tErrStateHistory01List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTErrStateHistory01List()). Otherwise it will return false.
     */
    inline bool hasTErrStateHistory01List () const;

    /**
     * Returns the value of the member "tErrStateHistory01List".
     *
     * Error state history 01
     *
     * @return The value of the field "tErrStateHistory01List"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory01List () const;

    /**
     * Retrieves the value of the field "tErrStateHistory01List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tErrStateHistory01List".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory01ListMutable ();

    /**
     * Sets the value of the member "tErrStateHistory01List".
     *
     * Error state history 01
     *
     * @param tErrStateHistory01List The value which will be set
     */
    inline void setTErrStateHistory01List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory01List_);

    /**
     * Release the object stored in the field "tErrStateHistory01List".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tErrStateHistory01List"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTErrStateHistory01List();

    /**
     * Replace the field "tErrStateHistory01List".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTErrStateHistory01List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory01List_);

    // API of field "tErrStateHistory02List"

    static const int kTErrStateHistory02List = 9;

    /**
     * Clears the field "tErrStateHistory02List".
     *
     * The field will be set to its default value. The hasTErrStateHistory02List()
     * method will return false.
     */
    inline void clearTErrStateHistory02List();

    /**
     * Checks whether the field "tErrStateHistory02List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTErrStateHistory02List()). Otherwise it will return false.
     */
    inline bool hasTErrStateHistory02List () const;

    /**
     * Returns the value of the member "tErrStateHistory02List".
     *
     * Error state history 02
     *
     * @return The value of the field "tErrStateHistory02List"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory02List () const;

    /**
     * Retrieves the value of the field "tErrStateHistory02List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tErrStateHistory02List".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory02ListMutable ();

    /**
     * Sets the value of the member "tErrStateHistory02List".
     *
     * Error state history 02
     *
     * @param tErrStateHistory02List The value which will be set
     */
    inline void setTErrStateHistory02List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory02List_);

    /**
     * Release the object stored in the field "tErrStateHistory02List".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tErrStateHistory02List"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTErrStateHistory02List();

    /**
     * Replace the field "tErrStateHistory02List".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTErrStateHistory02List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory02List_);

    // API of field "tErrStateHistory03List"

    static const int kTErrStateHistory03List = 10;

    /**
     * Clears the field "tErrStateHistory03List".
     *
     * The field will be set to its default value. The hasTErrStateHistory03List()
     * method will return false.
     */
    inline void clearTErrStateHistory03List();

    /**
     * Checks whether the field "tErrStateHistory03List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTErrStateHistory03List()). Otherwise it will return false.
     */
    inline bool hasTErrStateHistory03List () const;

    /**
     * Returns the value of the member "tErrStateHistory03List".
     *
     * Error state history 03
     *
     * @return The value of the field "tErrStateHistory03List"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory03List () const;

    /**
     * Retrieves the value of the field "tErrStateHistory03List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tErrStateHistory03List".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory03ListMutable ();

    /**
     * Sets the value of the member "tErrStateHistory03List".
     *
     * Error state history 03
     *
     * @param tErrStateHistory03List The value which will be set
     */
    inline void setTErrStateHistory03List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory03List_);

    /**
     * Release the object stored in the field "tErrStateHistory03List".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tErrStateHistory03List"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTErrStateHistory03List();

    /**
     * Replace the field "tErrStateHistory03List".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTErrStateHistory03List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory03List_);

    // API of field "tErrStateHistory04List"

    static const int kTErrStateHistory04List = 11;

    /**
     * Clears the field "tErrStateHistory04List".
     *
     * The field will be set to its default value. The hasTErrStateHistory04List()
     * method will return false.
     */
    inline void clearTErrStateHistory04List();

    /**
     * Checks whether the field "tErrStateHistory04List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTErrStateHistory04List()). Otherwise it will return false.
     */
    inline bool hasTErrStateHistory04List () const;

    /**
     * Returns the value of the member "tErrStateHistory04List".
     *
     * Error state history 04
     *
     * @return The value of the field "tErrStateHistory04List"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory04List () const;

    /**
     * Retrieves the value of the field "tErrStateHistory04List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tErrStateHistory04List".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory04ListMutable ();

    /**
     * Sets the value of the member "tErrStateHistory04List".
     *
     * Error state history 04
     *
     * @param tErrStateHistory04List The value which will be set
     */
    inline void setTErrStateHistory04List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory04List_);

    /**
     * Release the object stored in the field "tErrStateHistory04List".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tErrStateHistory04List"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTErrStateHistory04List();

    /**
     * Replace the field "tErrStateHistory04List".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTErrStateHistory04List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory04List_);

    // API of field "tErrStateHistory05List"

    static const int kTErrStateHistory05List = 12;

    /**
     * Clears the field "tErrStateHistory05List".
     *
     * The field will be set to its default value. The hasTErrStateHistory05List()
     * method will return false.
     */
    inline void clearTErrStateHistory05List();

    /**
     * Checks whether the field "tErrStateHistory05List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTErrStateHistory05List()). Otherwise it will return false.
     */
    inline bool hasTErrStateHistory05List () const;

    /**
     * Returns the value of the member "tErrStateHistory05List".
     *
     * Error state history 05
     *
     * @return The value of the field "tErrStateHistory05List"
     */
    inline const ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory05List () const;

    /**
     * Retrieves the value of the field "tErrStateHistory05List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tErrStateHistory05List".
     */
    inline ::boost::ptr_vector< T_StateChangeElement >& getTErrStateHistory05ListMutable ();

    /**
     * Sets the value of the member "tErrStateHistory05List".
     *
     * Error state history 05
     *
     * @param tErrStateHistory05List The value which will be set
     */
    inline void setTErrStateHistory05List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory05List_);

    /**
     * Release the object stored in the field "tErrStateHistory05List".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tErrStateHistory05List"
     */
    inline ::boost::ptr_vector< T_StateChangeElement >* releaseTErrStateHistory05List();

    /**
     * Replace the field "tErrStateHistory05List".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTErrStateHistory05List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory05List_);

    // API of field "u32SystemOperationTime"

    static const int kU32SystemOperationTime = 13;

    /**
     * Clears the field "u32SystemOperationTime".
     *
     * The field will be set to its default value. The hasU32SystemOperationTime()
     * method will return false.
     */
    inline void clearU32SystemOperationTime();

    /**
     * Checks whether the field "u32SystemOperationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SystemOperationTime()). Otherwise it will return false.
     */
    inline bool hasU32SystemOperationTime () const;

    /**
     * Returns the value of the member "u32SystemOperationTime".
     *
     * System operation time in seconds
     *
     * @return The value of the field "u32SystemOperationTime"
     */
    inline uint32 getU32SystemOperationTime () const;

    /**
     * Sets the value of the member "u32SystemOperationTime".
     *
     * System operation time in seconds
     *
     * @param u32SystemOperationTime The value which will be set
     */
    inline void setU32SystemOperationTime (uint32 u32SystemOperationTime_);

    // API of field "tCpuUsage"

    static const int kTCpuUsage = 14;

    /**
     * Clears the field "tCpuUsage".
     *
     * The field will be set to its default value. The hasTCpuUsage()
     * method will return false.
     */
    inline void clearTCpuUsage();

    /**
     * Checks whether the field "tCpuUsage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTCpuUsage()). Otherwise it will return false.
     */
    inline bool hasTCpuUsage () const;

    /**
     * Returns the value of the member "tCpuUsage".
     *
     * CPU usage statistic data
     *
     * @return The value of the field "tCpuUsage"
     */
    inline const T_SPM_SystemStatisticsData& getTCpuUsage () const;

    /**
     * Retrieves the value of the field "tCpuUsage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tCpuUsage".
     */
    inline T_SPM_SystemStatisticsData& getTCpuUsageMutable ();

    /**
     * Sets the value of the member "tCpuUsage".
     *
     * CPU usage statistic data
     *
     * @param tCpuUsage The value which will be set
     */
    inline void setTCpuUsage (const T_SPM_SystemStatisticsData& tCpuUsage_);

    /**
     * Release the object stored in the field "tCpuUsage".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tCpuUsage"
     */
    inline T_SPM_SystemStatisticsData* releaseTCpuUsage();

    /**
     * Replace the field "tCpuUsage".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTCpuUsage (T_SPM_SystemStatisticsData* tCpuUsage_);

    // API of field "tRamUsage"

    static const int kTRamUsage = 15;

    /**
     * Clears the field "tRamUsage".
     *
     * The field will be set to its default value. The hasTRamUsage()
     * method will return false.
     */
    inline void clearTRamUsage();

    /**
     * Checks whether the field "tRamUsage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTRamUsage()). Otherwise it will return false.
     */
    inline bool hasTRamUsage () const;

    /**
     * Returns the value of the member "tRamUsage".
     *
     * RAM usage statistic data
     *
     * @return The value of the field "tRamUsage"
     */
    inline const T_SPM_SystemStatisticsData& getTRamUsage () const;

    /**
     * Retrieves the value of the field "tRamUsage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tRamUsage".
     */
    inline T_SPM_SystemStatisticsData& getTRamUsageMutable ();

    /**
     * Sets the value of the member "tRamUsage".
     *
     * RAM usage statistic data
     *
     * @param tRamUsage The value which will be set
     */
    inline void setTRamUsage (const T_SPM_SystemStatisticsData& tRamUsage_);

    /**
     * Release the object stored in the field "tRamUsage".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tRamUsage"
     */
    inline T_SPM_SystemStatisticsData* releaseTRamUsage();

    /**
     * Replace the field "tRamUsage".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTRamUsage (T_SPM_SystemStatisticsData* tRamUsage_);

    // API of field "tStartupTime"

    static const int kTStartupTime = 16;

    /**
     * Clears the field "tStartupTime".
     *
     * The field will be set to its default value. The hasTStartupTime()
     * method will return false.
     */
    inline void clearTStartupTime();

    /**
     * Checks whether the field "tStartupTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStartupTime()). Otherwise it will return false.
     */
    inline bool hasTStartupTime () const;

    /**
     * Returns the value of the member "tStartupTime".
     *
     * Startup Time statistic data
     *
     * @return The value of the field "tStartupTime"
     */
    inline const T_SPM_SystemStatisticsData& getTStartupTime () const;

    /**
     * Retrieves the value of the field "tStartupTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStartupTime".
     */
    inline T_SPM_SystemStatisticsData& getTStartupTimeMutable ();

    /**
     * Sets the value of the member "tStartupTime".
     *
     * Startup Time statistic data
     *
     * @param tStartupTime The value which will be set
     */
    inline void setTStartupTime (const T_SPM_SystemStatisticsData& tStartupTime_);

    /**
     * Release the object stored in the field "tStartupTime".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStartupTime"
     */
    inline T_SPM_SystemStatisticsData* releaseTStartupTime();

    /**
     * Replace the field "tStartupTime".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStartupTime (T_SPM_SystemStatisticsData* tStartupTime_);

    static const T_SPM_SWVersionStatisticData &getDefaultInstance();

private:

    static const ::boost::ptr_vector< T_ResetElement >& getT_ResetElementPointerList_DefaultInstance ();

    static const ::boost::ptr_vector< T_WakeupElement >& getT_WakeupElementPointerList_DefaultInstance ();

    static const ::boost::ptr_vector< T_SwitchOnElement >& getT_SwitchOnElementPointerList_DefaultInstance ();

    static const ::boost::ptr_vector< T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_strBuildVersion ();

    inline void clear_has_strBuildVersion ();

    inline void set_has_strBuildVersionCustomer ();

    inline void clear_has_strBuildVersionCustomer ();

    inline void set_has_strCustomerVersion ();

    inline void clear_has_strCustomerVersion ();

    inline void set_has_tResetInfo ();

    inline void clear_has_tResetInfo ();

    inline void set_has_tResetHistoryList ();

    inline void clear_has_tResetHistoryList ();

    inline void set_has_tWakeupHistoryList ();

    inline void clear_has_tWakeupHistoryList ();

    inline void set_has_tSwitchOnList ();

    inline void clear_has_tSwitchOnList ();

    inline void set_has_tStateHistoryList ();

    inline void clear_has_tStateHistoryList ();

    inline void set_has_tErrStateHistory01List ();

    inline void clear_has_tErrStateHistory01List ();

    inline void set_has_tErrStateHistory02List ();

    inline void clear_has_tErrStateHistory02List ();

    inline void set_has_tErrStateHistory03List ();

    inline void clear_has_tErrStateHistory03List ();

    inline void set_has_tErrStateHistory04List ();

    inline void clear_has_tErrStateHistory04List ();

    inline void set_has_tErrStateHistory05List ();

    inline void clear_has_tErrStateHistory05List ();

    inline void set_has_u32SystemOperationTime ();

    inline void clear_has_u32SystemOperationTime ();

    inline void set_has_tCpuUsage ();

    inline void clear_has_tCpuUsage ();

    inline void set_has_tRamUsage ();

    inline void clear_has_tRamUsage ();

    inline void set_has_tStartupTime ();

    inline void clear_has_tStartupTime ();

    uint32 _has_bits_[ (17 + 31) / 32];

    ::std::string* _strBuildVersion;

    ::std::string* _strBuildVersionCustomer;

    ::std::string* _strCustomerVersion;

    T_SPM_ResetInfoStatisticData* _tResetInfo;

    ::boost::ptr_vector< T_ResetElement >* _tResetHistoryList;

    ::boost::ptr_vector< T_WakeupElement >* _tWakeupHistoryList;

    ::boost::ptr_vector< T_SwitchOnElement >* _tSwitchOnList;

    ::boost::ptr_vector< T_StateChangeElement >* _tStateHistoryList;

    ::boost::ptr_vector< T_StateChangeElement >* _tErrStateHistory01List;

    ::boost::ptr_vector< T_StateChangeElement >* _tErrStateHistory02List;

    ::boost::ptr_vector< T_StateChangeElement >* _tErrStateHistory03List;

    ::boost::ptr_vector< T_StateChangeElement >* _tErrStateHistory04List;

    ::boost::ptr_vector< T_StateChangeElement >* _tErrStateHistory05List;

    uint32 _u32SystemOperationTime;

    T_SPM_SystemStatisticsData* _tCpuUsage;

    T_SPM_SystemStatisticsData* _tRamUsage;

    T_SPM_SystemStatisticsData* _tStartupTime;

};

inline  TTimeDate::TTimeDate ()  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TTimeDate::TTimeDate (const TTimeDate &rhs)  :
    _s16Year (0),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TTimeDate::TTimeDate (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_)  :
    _s16Year (s16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hour (u8Hour_),
    _u8Minute (u8Minute_),
    _u8Second (u8Second_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TTimeDate::~TTimeDate() {
}

inline TTimeDate& TTimeDate::operator = (const TTimeDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasS16Year()) {
            setS16Year(rhs.getS16Year());
        } else {
            clearS16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hour()) {
            setU8Hour(rhs.getU8Hour());
        } else {
            clearU8Hour();
        }
        if (rhs.hasU8Minute()) {
            setU8Minute(rhs.getU8Minute());
        } else {
            clearU8Minute();
        }
        if (rhs.hasU8Second()) {
            setU8Second(rhs.getU8Second());
        } else {
            clearU8Second();
        }
    }
    return *this;
}

inline bool TTimeDate::operator == (const TTimeDate& rhs) const {
    return (((!hasS16Year() && !rhs.hasS16Year()) || getS16Year() == rhs.getS16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hour() && !rhs.hasU8Hour()) || getU8Hour() == rhs.getU8Hour()) &&
        ((!hasU8Minute() && !rhs.hasU8Minute()) || getU8Minute() == rhs.getU8Minute()) &&
        ((!hasU8Second() && !rhs.hasU8Second()) || getU8Second() == rhs.getU8Second()));
}

inline bool TTimeDate::operator != (const TTimeDate& rhs) const {
    return ! (*this == rhs);
}

inline bool TTimeDate::operator < (const TTimeDate& rhs) const {
    if (hasS16Year() || rhs.hasS16Year()) {
        if (getS16Year() < rhs.getS16Year()) return true;
        if (getS16Year() > rhs.getS16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hour() || rhs.hasU8Hour()) {
        if (getU8Hour() < rhs.getU8Hour()) return true;
        if (getU8Hour() > rhs.getU8Hour()) return false;
    }
    if (hasU8Minute() || rhs.hasU8Minute()) {
        if (getU8Minute() < rhs.getU8Minute()) return true;
        if (getU8Minute() > rhs.getU8Minute()) return false;
    }
    if (hasU8Second() || rhs.hasU8Second()) {
        if (getU8Second() < rhs.getU8Second()) return true;
        if (getU8Second() > rhs.getU8Second()) return false;
    }
    return false;
}

inline bool TTimeDate::operator > (const TTimeDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TTimeDate::clear() {
    clearS16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hour();
    clearU8Minute();
    clearU8Second();
}

inline void TTimeDate::clearS16Year() {
    if (hasS16Year()) {
         clear_has_s16Year();
        _s16Year = 0;
     }
}

inline bool TTimeDate::hasS16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int16 TTimeDate::getS16Year () const {
    return _s16Year;
}

inline void TTimeDate::setS16Year (int16 s16Year_) {
    set_has_s16Year();
    this->_s16Year = s16Year_;
}

inline void TTimeDate::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool TTimeDate::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 TTimeDate::getU8Month () const {
    return _u8Month;
}

inline void TTimeDate::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void TTimeDate::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool TTimeDate::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 TTimeDate::getU8Day () const {
    return _u8Day;
}

inline void TTimeDate::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void TTimeDate::clearU8Hour() {
    if (hasU8Hour()) {
         clear_has_u8Hour();
        _u8Hour = 0u;
     }
}

inline bool TTimeDate::hasU8Hour () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 TTimeDate::getU8Hour () const {
    return _u8Hour;
}

inline void TTimeDate::setU8Hour (uint8 u8Hour_) {
    set_has_u8Hour();
    this->_u8Hour = u8Hour_;
}

inline void TTimeDate::clearU8Minute() {
    if (hasU8Minute()) {
         clear_has_u8Minute();
        _u8Minute = 0u;
     }
}

inline bool TTimeDate::hasU8Minute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 TTimeDate::getU8Minute () const {
    return _u8Minute;
}

inline void TTimeDate::setU8Minute (uint8 u8Minute_) {
    set_has_u8Minute();
    this->_u8Minute = u8Minute_;
}

inline void TTimeDate::clearU8Second() {
    if (hasU8Second()) {
         clear_has_u8Second();
        _u8Second = 0u;
     }
}

inline bool TTimeDate::hasU8Second () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 TTimeDate::getU8Second () const {
    return _u8Second;
}

inline void TTimeDate::setU8Second (uint8 u8Second_) {
    set_has_u8Second();
    this->_u8Second = u8Second_;
}

inline void TTimeDate::set_has_s16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void TTimeDate::clear_has_s16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TTimeDate::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void TTimeDate::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TTimeDate::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void TTimeDate::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void TTimeDate::set_has_u8Hour () {
    _has_bits_[0] |= 1u << 3;
}

inline void TTimeDate::clear_has_u8Hour () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void TTimeDate::set_has_u8Minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void TTimeDate::clear_has_u8Minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void TTimeDate::set_has_u8Second () {
    _has_bits_[0] |= 1u << 5;
}

inline void TTimeDate::clear_has_u8Second () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  TSwVersionInfo::TSwVersionInfo ()  :
    _tSwBuildVersion (NULL),
    _tSwCustomerVersion (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TSwVersionInfo::TSwVersionInfo (const TSwVersionInfo &rhs)  :
    _tSwBuildVersion (NULL),
    _tSwCustomerVersion (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TSwVersionInfo::TSwVersionInfo (const ::std::string& tSwBuildVersion_, const ::std::string& tSwCustomerVersion_)  :
    _tSwBuildVersion (new ::std::string(tSwBuildVersion_)),
    _tSwCustomerVersion (new ::std::string(tSwCustomerVersion_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TSwVersionInfo::~TSwVersionInfo() {
    delete _tSwBuildVersion;
    delete _tSwCustomerVersion;
}

inline TSwVersionInfo& TSwVersionInfo::operator = (const TSwVersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTSwBuildVersion()) {
            setTSwBuildVersion(rhs.getTSwBuildVersion());
        } else {
            clearTSwBuildVersion();
        }
        if (rhs.hasTSwCustomerVersion()) {
            setTSwCustomerVersion(rhs.getTSwCustomerVersion());
        } else {
            clearTSwCustomerVersion();
        }
    }
    return *this;
}

inline bool TSwVersionInfo::operator == (const TSwVersionInfo& rhs) const {
    return (((!hasTSwBuildVersion() && !rhs.hasTSwBuildVersion()) || getTSwBuildVersion() == rhs.getTSwBuildVersion()) &&
        ((!hasTSwCustomerVersion() && !rhs.hasTSwCustomerVersion()) || getTSwCustomerVersion() == rhs.getTSwCustomerVersion()));
}

inline bool TSwVersionInfo::operator != (const TSwVersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool TSwVersionInfo::operator < (const TSwVersionInfo& rhs) const {
    if (hasTSwBuildVersion() || rhs.hasTSwBuildVersion()) {
        if (getTSwBuildVersion() < rhs.getTSwBuildVersion()) return true;
        if (getTSwBuildVersion() > rhs.getTSwBuildVersion()) return false;
    }
    if (hasTSwCustomerVersion() || rhs.hasTSwCustomerVersion()) {
        if (getTSwCustomerVersion() < rhs.getTSwCustomerVersion()) return true;
        if (getTSwCustomerVersion() > rhs.getTSwCustomerVersion()) return false;
    }
    return false;
}

inline bool TSwVersionInfo::operator > (const TSwVersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TSwVersionInfo::clear() {
    clearTSwBuildVersion();
    clearTSwCustomerVersion();
}

inline void TSwVersionInfo::clearTSwBuildVersion() {
    if (hasTSwBuildVersion()) {
         clear_has_tSwBuildVersion();
        if (_tSwBuildVersion != NULL) {
            _tSwBuildVersion->clear();
        }
     }
}

inline bool TSwVersionInfo::hasTSwBuildVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TSwVersionInfo::getTSwBuildVersion () const {
    if (_tSwBuildVersion == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_tSwBuildVersion;
}

inline ::std::string& TSwVersionInfo::getTSwBuildVersionMutable () {
    set_has_tSwBuildVersion();
    if (_tSwBuildVersion == NULL) {
        _tSwBuildVersion = new ::std::string ();
        CHECK_ALLOCATION( _tSwBuildVersion );
    }
    return *_tSwBuildVersion;
}

inline void TSwVersionInfo::setTSwBuildVersion (const ::std::string& tSwBuildVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwBuildVersion();
    if (this->_tSwBuildVersion == NULL) {
        this->_tSwBuildVersion = new ::std::string (tSwBuildVersion_);
        CHECK_ALLOCATION( this->_tSwBuildVersion );
    } else {
        *this->_tSwBuildVersion = tSwBuildVersion_;
    }
}

inline void TSwVersionInfo::setTSwBuildVersion (const char* tSwBuildVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwBuildVersion();
    if (this->_tSwBuildVersion == NULL) {
        this->_tSwBuildVersion = new ::std::string (tSwBuildVersion_);
        CHECK_ALLOCATION( this->_tSwBuildVersion );
    } else {
        this->_tSwBuildVersion->assign(tSwBuildVersion_);
    }
}

inline void TSwVersionInfo::setTSwBuildVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwBuildVersion();
    if (this->_tSwBuildVersion == NULL) {
        this->_tSwBuildVersion = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_tSwBuildVersion );
    } else {
        this->_tSwBuildVersion->assign(value, size);
    }
}

inline ::std::string* TSwVersionInfo::releaseTSwBuildVersion() {
    clear_has_tSwBuildVersion();
    ::std::string* temp = _tSwBuildVersion;
    this->_tSwBuildVersion = NULL;
    return temp;
}

inline void TSwVersionInfo::replaceTSwBuildVersion (::std::string* tSwBuildVersion_) {
    set_has_tSwBuildVersion();
    if (this->_tSwBuildVersion != tSwBuildVersion_) {
        if (this->_tSwBuildVersion != NULL) {
            delete this->_tSwBuildVersion;
        }
        this->_tSwBuildVersion = tSwBuildVersion_;
    }
}

inline void TSwVersionInfo::clearTSwCustomerVersion() {
    if (hasTSwCustomerVersion()) {
         clear_has_tSwCustomerVersion();
        if (_tSwCustomerVersion != NULL) {
            _tSwCustomerVersion->clear();
        }
     }
}

inline bool TSwVersionInfo::hasTSwCustomerVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& TSwVersionInfo::getTSwCustomerVersion () const {
    if (_tSwCustomerVersion == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_tSwCustomerVersion;
}

inline ::std::string& TSwVersionInfo::getTSwCustomerVersionMutable () {
    set_has_tSwCustomerVersion();
    if (_tSwCustomerVersion == NULL) {
        _tSwCustomerVersion = new ::std::string ();
        CHECK_ALLOCATION( _tSwCustomerVersion );
    }
    return *_tSwCustomerVersion;
}

inline void TSwVersionInfo::setTSwCustomerVersion (const ::std::string& tSwCustomerVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwCustomerVersion();
    if (this->_tSwCustomerVersion == NULL) {
        this->_tSwCustomerVersion = new ::std::string (tSwCustomerVersion_);
        CHECK_ALLOCATION( this->_tSwCustomerVersion );
    } else {
        *this->_tSwCustomerVersion = tSwCustomerVersion_;
    }
}

inline void TSwVersionInfo::setTSwCustomerVersion (const char* tSwCustomerVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSwCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwCustomerVersion();
    if (this->_tSwCustomerVersion == NULL) {
        this->_tSwCustomerVersion = new ::std::string (tSwCustomerVersion_);
        CHECK_ALLOCATION( this->_tSwCustomerVersion );
    } else {
        this->_tSwCustomerVersion->assign(tSwCustomerVersion_);
    }
}

inline void TSwVersionInfo::setTSwCustomerVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSwCustomerVersion();
    if (this->_tSwCustomerVersion == NULL) {
        this->_tSwCustomerVersion = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_tSwCustomerVersion );
    } else {
        this->_tSwCustomerVersion->assign(value, size);
    }
}

inline ::std::string* TSwVersionInfo::releaseTSwCustomerVersion() {
    clear_has_tSwCustomerVersion();
    ::std::string* temp = _tSwCustomerVersion;
    this->_tSwCustomerVersion = NULL;
    return temp;
}

inline void TSwVersionInfo::replaceTSwCustomerVersion (::std::string* tSwCustomerVersion_) {
    set_has_tSwCustomerVersion();
    if (this->_tSwCustomerVersion != tSwCustomerVersion_) {
        if (this->_tSwCustomerVersion != NULL) {
            delete this->_tSwCustomerVersion;
        }
        this->_tSwCustomerVersion = tSwCustomerVersion_;
    }
}

inline void TSwVersionInfo::set_has_tSwBuildVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void TSwVersionInfo::clear_has_tSwBuildVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TSwVersionInfo::set_has_tSwCustomerVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void TSwVersionInfo::clear_has_tSwCustomerVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b32_SubState0::T_b32_SubState0 ()  :
    _SPM_e32_SET_SD_CARD_ACCESS (false),
    _SPM_e32_EMERGENCY_OFF (false),
    _SPM_e32_FAST_SHUTDOWN (false),
    _SPM_e32_DIMMING (false),
    _SPM_e32_DOWNLOAD (false),
    _SPM_e32_DIAG_ACTIVITY (false),
    _SPM_e32_DIAGNOSIS (false),
    _SPM_e32_PHONE (false),
    _SPM_e32_ACCESSORY (false),
    _SPM_e32_IGNITION (false),
    _SPM_e32_TRANSPORTMODE (false),
    _SPM_e32_DOOROPEN (false),
    _SPM_e32_DOORLOCK (false),
    _SPM_e32_TRIGGER_FORCE_ON (false),
    _SPM_e32_CLIMATE_INFO (false),
    _SPM_e32_PARK_DISTANCE_CTRL (false),
    _SPM_e32_FACTORY_MODE (false),
    _SPM_e32_CD_INSERT (false),
    _SPM_e32_SD_INSERT (false),
    _SPM_e32_EJECT (false),
    _SPM_e32_ON_TIPPER (false),
    _SPM_e32_SOFTTOP_OPEN (false),
    _SPM_e32_AIRBAG_DEPLOYED (false),
    _SPM_e32_KEY_PRESENT (false),
    _SPM_e32_NETWORK_ACTIVITY (false),
    _SPM_e32_OFF_TIPPER (false),
    _SPM_e32_OFF_LASTSTATE_CYCLE (false),
    _SPM_e32_DIAG_REQUEST (false),
    _SPM_e32_BACKLIGHT (false),
    _SPM_e32_HIGH_VOLTAGE (false),
    _SPM_e32_RCV_CONNECTED (false),
    _SPM_e32_OFF_LEARN (false)
{
}

inline  T_b32_SubState0::T_b32_SubState0 (const T_b32_SubState0 &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_SubState0::T_b32_SubState0 (bool SPM_e32_SET_SD_CARD_ACCESS, bool SPM_e32_EMERGENCY_OFF, bool SPM_e32_FAST_SHUTDOWN, bool SPM_e32_DIMMING, bool SPM_e32_DOWNLOAD, bool SPM_e32_DIAG_ACTIVITY, bool SPM_e32_DIAGNOSIS, bool SPM_e32_PHONE, bool SPM_e32_ACCESSORY, bool SPM_e32_IGNITION, bool SPM_e32_TRANSPORTMODE, bool SPM_e32_DOOROPEN, bool SPM_e32_DOORLOCK, bool SPM_e32_TRIGGER_FORCE_ON, bool SPM_e32_CLIMATE_INFO, bool SPM_e32_PARK_DISTANCE_CTRL, bool SPM_e32_FACTORY_MODE, bool SPM_e32_CD_INSERT, bool SPM_e32_SD_INSERT, bool SPM_e32_EJECT, bool SPM_e32_ON_TIPPER, bool SPM_e32_SOFTTOP_OPEN, bool SPM_e32_AIRBAG_DEPLOYED, bool SPM_e32_KEY_PRESENT, bool SPM_e32_NETWORK_ACTIVITY, bool SPM_e32_OFF_TIPPER, bool SPM_e32_OFF_LASTSTATE_CYCLE, bool SPM_e32_DIAG_REQUEST, bool SPM_e32_BACKLIGHT, bool SPM_e32_HIGH_VOLTAGE, bool SPM_e32_RCV_CONNECTED, bool SPM_e32_OFF_LEARN) :
    _SPM_e32_SET_SD_CARD_ACCESS (SPM_e32_SET_SD_CARD_ACCESS),
    _SPM_e32_EMERGENCY_OFF (SPM_e32_EMERGENCY_OFF),
    _SPM_e32_FAST_SHUTDOWN (SPM_e32_FAST_SHUTDOWN),
    _SPM_e32_DIMMING (SPM_e32_DIMMING),
    _SPM_e32_DOWNLOAD (SPM_e32_DOWNLOAD),
    _SPM_e32_DIAG_ACTIVITY (SPM_e32_DIAG_ACTIVITY),
    _SPM_e32_DIAGNOSIS (SPM_e32_DIAGNOSIS),
    _SPM_e32_PHONE (SPM_e32_PHONE),
    _SPM_e32_ACCESSORY (SPM_e32_ACCESSORY),
    _SPM_e32_IGNITION (SPM_e32_IGNITION),
    _SPM_e32_TRANSPORTMODE (SPM_e32_TRANSPORTMODE),
    _SPM_e32_DOOROPEN (SPM_e32_DOOROPEN),
    _SPM_e32_DOORLOCK (SPM_e32_DOORLOCK),
    _SPM_e32_TRIGGER_FORCE_ON (SPM_e32_TRIGGER_FORCE_ON),
    _SPM_e32_CLIMATE_INFO (SPM_e32_CLIMATE_INFO),
    _SPM_e32_PARK_DISTANCE_CTRL (SPM_e32_PARK_DISTANCE_CTRL),
    _SPM_e32_FACTORY_MODE (SPM_e32_FACTORY_MODE),
    _SPM_e32_CD_INSERT (SPM_e32_CD_INSERT),
    _SPM_e32_SD_INSERT (SPM_e32_SD_INSERT),
    _SPM_e32_EJECT (SPM_e32_EJECT),
    _SPM_e32_ON_TIPPER (SPM_e32_ON_TIPPER),
    _SPM_e32_SOFTTOP_OPEN (SPM_e32_SOFTTOP_OPEN),
    _SPM_e32_AIRBAG_DEPLOYED (SPM_e32_AIRBAG_DEPLOYED),
    _SPM_e32_KEY_PRESENT (SPM_e32_KEY_PRESENT),
    _SPM_e32_NETWORK_ACTIVITY (SPM_e32_NETWORK_ACTIVITY),
    _SPM_e32_OFF_TIPPER (SPM_e32_OFF_TIPPER),
    _SPM_e32_OFF_LASTSTATE_CYCLE (SPM_e32_OFF_LASTSTATE_CYCLE),
    _SPM_e32_DIAG_REQUEST (SPM_e32_DIAG_REQUEST),
    _SPM_e32_BACKLIGHT (SPM_e32_BACKLIGHT),
    _SPM_e32_HIGH_VOLTAGE (SPM_e32_HIGH_VOLTAGE),
    _SPM_e32_RCV_CONNECTED (SPM_e32_RCV_CONNECTED),
    _SPM_e32_OFF_LEARN (SPM_e32_OFF_LEARN)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_SubState0& T_b32_SubState0::operator = (const T_b32_SubState0& rhs) {
    if( this != &rhs ) {
        _SPM_e32_SET_SD_CARD_ACCESS = rhs._SPM_e32_SET_SD_CARD_ACCESS;
        _SPM_e32_EMERGENCY_OFF = rhs._SPM_e32_EMERGENCY_OFF;
        _SPM_e32_FAST_SHUTDOWN = rhs._SPM_e32_FAST_SHUTDOWN;
        _SPM_e32_DIMMING = rhs._SPM_e32_DIMMING;
        _SPM_e32_DOWNLOAD = rhs._SPM_e32_DOWNLOAD;
        _SPM_e32_DIAG_ACTIVITY = rhs._SPM_e32_DIAG_ACTIVITY;
        _SPM_e32_DIAGNOSIS = rhs._SPM_e32_DIAGNOSIS;
        _SPM_e32_PHONE = rhs._SPM_e32_PHONE;
        _SPM_e32_ACCESSORY = rhs._SPM_e32_ACCESSORY;
        _SPM_e32_IGNITION = rhs._SPM_e32_IGNITION;
        _SPM_e32_TRANSPORTMODE = rhs._SPM_e32_TRANSPORTMODE;
        _SPM_e32_DOOROPEN = rhs._SPM_e32_DOOROPEN;
        _SPM_e32_DOORLOCK = rhs._SPM_e32_DOORLOCK;
        _SPM_e32_TRIGGER_FORCE_ON = rhs._SPM_e32_TRIGGER_FORCE_ON;
        _SPM_e32_CLIMATE_INFO = rhs._SPM_e32_CLIMATE_INFO;
        _SPM_e32_PARK_DISTANCE_CTRL = rhs._SPM_e32_PARK_DISTANCE_CTRL;
        _SPM_e32_FACTORY_MODE = rhs._SPM_e32_FACTORY_MODE;
        _SPM_e32_CD_INSERT = rhs._SPM_e32_CD_INSERT;
        _SPM_e32_SD_INSERT = rhs._SPM_e32_SD_INSERT;
        _SPM_e32_EJECT = rhs._SPM_e32_EJECT;
        _SPM_e32_ON_TIPPER = rhs._SPM_e32_ON_TIPPER;
        _SPM_e32_SOFTTOP_OPEN = rhs._SPM_e32_SOFTTOP_OPEN;
        _SPM_e32_AIRBAG_DEPLOYED = rhs._SPM_e32_AIRBAG_DEPLOYED;
        _SPM_e32_KEY_PRESENT = rhs._SPM_e32_KEY_PRESENT;
        _SPM_e32_NETWORK_ACTIVITY = rhs._SPM_e32_NETWORK_ACTIVITY;
        _SPM_e32_OFF_TIPPER = rhs._SPM_e32_OFF_TIPPER;
        _SPM_e32_OFF_LASTSTATE_CYCLE = rhs._SPM_e32_OFF_LASTSTATE_CYCLE;
        _SPM_e32_DIAG_REQUEST = rhs._SPM_e32_DIAG_REQUEST;
        _SPM_e32_BACKLIGHT = rhs._SPM_e32_BACKLIGHT;
        _SPM_e32_HIGH_VOLTAGE = rhs._SPM_e32_HIGH_VOLTAGE;
        _SPM_e32_RCV_CONNECTED = rhs._SPM_e32_RCV_CONNECTED;
        _SPM_e32_OFF_LEARN = rhs._SPM_e32_OFF_LEARN;
    }
    return *this;
}

inline bool T_b32_SubState0::operator == (const T_b32_SubState0& rhs) const {
    return (_SPM_e32_SET_SD_CARD_ACCESS == rhs._SPM_e32_SET_SD_CARD_ACCESS &&
        _SPM_e32_EMERGENCY_OFF == rhs._SPM_e32_EMERGENCY_OFF &&
        _SPM_e32_FAST_SHUTDOWN == rhs._SPM_e32_FAST_SHUTDOWN &&
        _SPM_e32_DIMMING == rhs._SPM_e32_DIMMING &&
        _SPM_e32_DOWNLOAD == rhs._SPM_e32_DOWNLOAD &&
        _SPM_e32_DIAG_ACTIVITY == rhs._SPM_e32_DIAG_ACTIVITY &&
        _SPM_e32_DIAGNOSIS == rhs._SPM_e32_DIAGNOSIS &&
        _SPM_e32_PHONE == rhs._SPM_e32_PHONE &&
        _SPM_e32_ACCESSORY == rhs._SPM_e32_ACCESSORY &&
        _SPM_e32_IGNITION == rhs._SPM_e32_IGNITION &&
        _SPM_e32_TRANSPORTMODE == rhs._SPM_e32_TRANSPORTMODE &&
        _SPM_e32_DOOROPEN == rhs._SPM_e32_DOOROPEN &&
        _SPM_e32_DOORLOCK == rhs._SPM_e32_DOORLOCK &&
        _SPM_e32_TRIGGER_FORCE_ON == rhs._SPM_e32_TRIGGER_FORCE_ON &&
        _SPM_e32_CLIMATE_INFO == rhs._SPM_e32_CLIMATE_INFO &&
        _SPM_e32_PARK_DISTANCE_CTRL == rhs._SPM_e32_PARK_DISTANCE_CTRL &&
        _SPM_e32_FACTORY_MODE == rhs._SPM_e32_FACTORY_MODE &&
        _SPM_e32_CD_INSERT == rhs._SPM_e32_CD_INSERT &&
        _SPM_e32_SD_INSERT == rhs._SPM_e32_SD_INSERT &&
        _SPM_e32_EJECT == rhs._SPM_e32_EJECT &&
        _SPM_e32_ON_TIPPER == rhs._SPM_e32_ON_TIPPER &&
        _SPM_e32_SOFTTOP_OPEN == rhs._SPM_e32_SOFTTOP_OPEN &&
        _SPM_e32_AIRBAG_DEPLOYED == rhs._SPM_e32_AIRBAG_DEPLOYED &&
        _SPM_e32_KEY_PRESENT == rhs._SPM_e32_KEY_PRESENT &&
        _SPM_e32_NETWORK_ACTIVITY == rhs._SPM_e32_NETWORK_ACTIVITY &&
        _SPM_e32_OFF_TIPPER == rhs._SPM_e32_OFF_TIPPER &&
        _SPM_e32_OFF_LASTSTATE_CYCLE == rhs._SPM_e32_OFF_LASTSTATE_CYCLE &&
        _SPM_e32_DIAG_REQUEST == rhs._SPM_e32_DIAG_REQUEST &&
        _SPM_e32_BACKLIGHT == rhs._SPM_e32_BACKLIGHT &&
        _SPM_e32_HIGH_VOLTAGE == rhs._SPM_e32_HIGH_VOLTAGE &&
        _SPM_e32_RCV_CONNECTED == rhs._SPM_e32_RCV_CONNECTED &&
        _SPM_e32_OFF_LEARN == rhs._SPM_e32_OFF_LEARN);
}

inline bool T_b32_SubState0::operator != (const T_b32_SubState0& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_SubState0::operator < (const T_b32_SubState0& rhs) const {
    if (getSPM_e32_SET_SD_CARD_ACCESS() < rhs.getSPM_e32_SET_SD_CARD_ACCESS()) return true;
    if (getSPM_e32_SET_SD_CARD_ACCESS() > rhs.getSPM_e32_SET_SD_CARD_ACCESS()) return false;

    if (getSPM_e32_EMERGENCY_OFF() < rhs.getSPM_e32_EMERGENCY_OFF()) return true;
    if (getSPM_e32_EMERGENCY_OFF() > rhs.getSPM_e32_EMERGENCY_OFF()) return false;

    if (getSPM_e32_FAST_SHUTDOWN() < rhs.getSPM_e32_FAST_SHUTDOWN()) return true;
    if (getSPM_e32_FAST_SHUTDOWN() > rhs.getSPM_e32_FAST_SHUTDOWN()) return false;

    if (getSPM_e32_DIMMING() < rhs.getSPM_e32_DIMMING()) return true;
    if (getSPM_e32_DIMMING() > rhs.getSPM_e32_DIMMING()) return false;

    if (getSPM_e32_DOWNLOAD() < rhs.getSPM_e32_DOWNLOAD()) return true;
    if (getSPM_e32_DOWNLOAD() > rhs.getSPM_e32_DOWNLOAD()) return false;

    if (getSPM_e32_DIAG_ACTIVITY() < rhs.getSPM_e32_DIAG_ACTIVITY()) return true;
    if (getSPM_e32_DIAG_ACTIVITY() > rhs.getSPM_e32_DIAG_ACTIVITY()) return false;

    if (getSPM_e32_DIAGNOSIS() < rhs.getSPM_e32_DIAGNOSIS()) return true;
    if (getSPM_e32_DIAGNOSIS() > rhs.getSPM_e32_DIAGNOSIS()) return false;

    if (getSPM_e32_PHONE() < rhs.getSPM_e32_PHONE()) return true;
    if (getSPM_e32_PHONE() > rhs.getSPM_e32_PHONE()) return false;

    if (getSPM_e32_ACCESSORY() < rhs.getSPM_e32_ACCESSORY()) return true;
    if (getSPM_e32_ACCESSORY() > rhs.getSPM_e32_ACCESSORY()) return false;

    if (getSPM_e32_IGNITION() < rhs.getSPM_e32_IGNITION()) return true;
    if (getSPM_e32_IGNITION() > rhs.getSPM_e32_IGNITION()) return false;

    if (getSPM_e32_TRANSPORTMODE() < rhs.getSPM_e32_TRANSPORTMODE()) return true;
    if (getSPM_e32_TRANSPORTMODE() > rhs.getSPM_e32_TRANSPORTMODE()) return false;

    if (getSPM_e32_DOOROPEN() < rhs.getSPM_e32_DOOROPEN()) return true;
    if (getSPM_e32_DOOROPEN() > rhs.getSPM_e32_DOOROPEN()) return false;

    if (getSPM_e32_DOORLOCK() < rhs.getSPM_e32_DOORLOCK()) return true;
    if (getSPM_e32_DOORLOCK() > rhs.getSPM_e32_DOORLOCK()) return false;

    if (getSPM_e32_TRIGGER_FORCE_ON() < rhs.getSPM_e32_TRIGGER_FORCE_ON()) return true;
    if (getSPM_e32_TRIGGER_FORCE_ON() > rhs.getSPM_e32_TRIGGER_FORCE_ON()) return false;

    if (getSPM_e32_CLIMATE_INFO() < rhs.getSPM_e32_CLIMATE_INFO()) return true;
    if (getSPM_e32_CLIMATE_INFO() > rhs.getSPM_e32_CLIMATE_INFO()) return false;

    if (getSPM_e32_PARK_DISTANCE_CTRL() < rhs.getSPM_e32_PARK_DISTANCE_CTRL()) return true;
    if (getSPM_e32_PARK_DISTANCE_CTRL() > rhs.getSPM_e32_PARK_DISTANCE_CTRL()) return false;

    if (getSPM_e32_FACTORY_MODE() < rhs.getSPM_e32_FACTORY_MODE()) return true;
    if (getSPM_e32_FACTORY_MODE() > rhs.getSPM_e32_FACTORY_MODE()) return false;

    if (getSPM_e32_CD_INSERT() < rhs.getSPM_e32_CD_INSERT()) return true;
    if (getSPM_e32_CD_INSERT() > rhs.getSPM_e32_CD_INSERT()) return false;

    if (getSPM_e32_SD_INSERT() < rhs.getSPM_e32_SD_INSERT()) return true;
    if (getSPM_e32_SD_INSERT() > rhs.getSPM_e32_SD_INSERT()) return false;

    if (getSPM_e32_EJECT() < rhs.getSPM_e32_EJECT()) return true;
    if (getSPM_e32_EJECT() > rhs.getSPM_e32_EJECT()) return false;

    if (getSPM_e32_ON_TIPPER() < rhs.getSPM_e32_ON_TIPPER()) return true;
    if (getSPM_e32_ON_TIPPER() > rhs.getSPM_e32_ON_TIPPER()) return false;

    if (getSPM_e32_SOFTTOP_OPEN() < rhs.getSPM_e32_SOFTTOP_OPEN()) return true;
    if (getSPM_e32_SOFTTOP_OPEN() > rhs.getSPM_e32_SOFTTOP_OPEN()) return false;

    if (getSPM_e32_AIRBAG_DEPLOYED() < rhs.getSPM_e32_AIRBAG_DEPLOYED()) return true;
    if (getSPM_e32_AIRBAG_DEPLOYED() > rhs.getSPM_e32_AIRBAG_DEPLOYED()) return false;

    if (getSPM_e32_KEY_PRESENT() < rhs.getSPM_e32_KEY_PRESENT()) return true;
    if (getSPM_e32_KEY_PRESENT() > rhs.getSPM_e32_KEY_PRESENT()) return false;

    if (getSPM_e32_NETWORK_ACTIVITY() < rhs.getSPM_e32_NETWORK_ACTIVITY()) return true;
    if (getSPM_e32_NETWORK_ACTIVITY() > rhs.getSPM_e32_NETWORK_ACTIVITY()) return false;

    if (getSPM_e32_OFF_TIPPER() < rhs.getSPM_e32_OFF_TIPPER()) return true;
    if (getSPM_e32_OFF_TIPPER() > rhs.getSPM_e32_OFF_TIPPER()) return false;

    if (getSPM_e32_OFF_LASTSTATE_CYCLE() < rhs.getSPM_e32_OFF_LASTSTATE_CYCLE()) return true;
    if (getSPM_e32_OFF_LASTSTATE_CYCLE() > rhs.getSPM_e32_OFF_LASTSTATE_CYCLE()) return false;

    if (getSPM_e32_DIAG_REQUEST() < rhs.getSPM_e32_DIAG_REQUEST()) return true;
    if (getSPM_e32_DIAG_REQUEST() > rhs.getSPM_e32_DIAG_REQUEST()) return false;

    if (getSPM_e32_BACKLIGHT() < rhs.getSPM_e32_BACKLIGHT()) return true;
    if (getSPM_e32_BACKLIGHT() > rhs.getSPM_e32_BACKLIGHT()) return false;

    if (getSPM_e32_HIGH_VOLTAGE() < rhs.getSPM_e32_HIGH_VOLTAGE()) return true;
    if (getSPM_e32_HIGH_VOLTAGE() > rhs.getSPM_e32_HIGH_VOLTAGE()) return false;

    if (getSPM_e32_RCV_CONNECTED() < rhs.getSPM_e32_RCV_CONNECTED()) return true;
    if (getSPM_e32_RCV_CONNECTED() > rhs.getSPM_e32_RCV_CONNECTED()) return false;

    if (getSPM_e32_OFF_LEARN() < rhs.getSPM_e32_OFF_LEARN()) return true;
    if (getSPM_e32_OFF_LEARN() > rhs.getSPM_e32_OFF_LEARN()) return false;

    return false;
}

inline bool T_b32_SubState0::operator > (const T_b32_SubState0& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_SubState0::setSPM_e32_SET_SD_CARD_ACCESS (bool SPM_e32_SET_SD_CARD_ACCESS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SET_SD_CARD_ACCESS = SPM_e32_SET_SD_CARD_ACCESS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_SET_SD_CARD_ACCESS () const {
    return _SPM_e32_SET_SD_CARD_ACCESS;
}

inline void T_b32_SubState0::setSPM_e32_EMERGENCY_OFF (bool SPM_e32_EMERGENCY_OFF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_EMERGENCY_OFF = SPM_e32_EMERGENCY_OFF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_EMERGENCY_OFF () const {
    return _SPM_e32_EMERGENCY_OFF;
}

inline void T_b32_SubState0::setSPM_e32_FAST_SHUTDOWN (bool SPM_e32_FAST_SHUTDOWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FAST_SHUTDOWN = SPM_e32_FAST_SHUTDOWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_FAST_SHUTDOWN () const {
    return _SPM_e32_FAST_SHUTDOWN;
}

inline void T_b32_SubState0::setSPM_e32_DIMMING (bool SPM_e32_DIMMING) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DIMMING = SPM_e32_DIMMING;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DIMMING () const {
    return _SPM_e32_DIMMING;
}

inline void T_b32_SubState0::setSPM_e32_DOWNLOAD (bool SPM_e32_DOWNLOAD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DOWNLOAD = SPM_e32_DOWNLOAD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DOWNLOAD () const {
    return _SPM_e32_DOWNLOAD;
}

inline void T_b32_SubState0::setSPM_e32_DIAG_ACTIVITY (bool SPM_e32_DIAG_ACTIVITY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DIAG_ACTIVITY = SPM_e32_DIAG_ACTIVITY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DIAG_ACTIVITY () const {
    return _SPM_e32_DIAG_ACTIVITY;
}

inline void T_b32_SubState0::setSPM_e32_DIAGNOSIS (bool SPM_e32_DIAGNOSIS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DIAGNOSIS = SPM_e32_DIAGNOSIS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DIAGNOSIS () const {
    return _SPM_e32_DIAGNOSIS;
}

inline void T_b32_SubState0::setSPM_e32_PHONE (bool SPM_e32_PHONE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_PHONE = SPM_e32_PHONE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_PHONE () const {
    return _SPM_e32_PHONE;
}

inline void T_b32_SubState0::setSPM_e32_ACCESSORY (bool SPM_e32_ACCESSORY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ACCESSORY = SPM_e32_ACCESSORY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_ACCESSORY () const {
    return _SPM_e32_ACCESSORY;
}

inline void T_b32_SubState0::setSPM_e32_IGNITION (bool SPM_e32_IGNITION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_IGNITION = SPM_e32_IGNITION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_IGNITION () const {
    return _SPM_e32_IGNITION;
}

inline void T_b32_SubState0::setSPM_e32_TRANSPORTMODE (bool SPM_e32_TRANSPORTMODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TRANSPORTMODE = SPM_e32_TRANSPORTMODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_TRANSPORTMODE () const {
    return _SPM_e32_TRANSPORTMODE;
}

inline void T_b32_SubState0::setSPM_e32_DOOROPEN (bool SPM_e32_DOOROPEN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DOOROPEN = SPM_e32_DOOROPEN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DOOROPEN () const {
    return _SPM_e32_DOOROPEN;
}

inline void T_b32_SubState0::setSPM_e32_DOORLOCK (bool SPM_e32_DOORLOCK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DOORLOCK = SPM_e32_DOORLOCK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DOORLOCK () const {
    return _SPM_e32_DOORLOCK;
}

inline void T_b32_SubState0::setSPM_e32_TRIGGER_FORCE_ON (bool SPM_e32_TRIGGER_FORCE_ON) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TRIGGER_FORCE_ON = SPM_e32_TRIGGER_FORCE_ON;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_TRIGGER_FORCE_ON () const {
    return _SPM_e32_TRIGGER_FORCE_ON;
}

inline void T_b32_SubState0::setSPM_e32_CLIMATE_INFO (bool SPM_e32_CLIMATE_INFO) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CLIMATE_INFO = SPM_e32_CLIMATE_INFO;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_CLIMATE_INFO () const {
    return _SPM_e32_CLIMATE_INFO;
}

inline void T_b32_SubState0::setSPM_e32_PARK_DISTANCE_CTRL (bool SPM_e32_PARK_DISTANCE_CTRL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_PARK_DISTANCE_CTRL = SPM_e32_PARK_DISTANCE_CTRL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_PARK_DISTANCE_CTRL () const {
    return _SPM_e32_PARK_DISTANCE_CTRL;
}

inline void T_b32_SubState0::setSPM_e32_FACTORY_MODE (bool SPM_e32_FACTORY_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FACTORY_MODE = SPM_e32_FACTORY_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_FACTORY_MODE () const {
    return _SPM_e32_FACTORY_MODE;
}

inline void T_b32_SubState0::setSPM_e32_CD_INSERT (bool SPM_e32_CD_INSERT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CD_INSERT = SPM_e32_CD_INSERT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_CD_INSERT () const {
    return _SPM_e32_CD_INSERT;
}

inline void T_b32_SubState0::setSPM_e32_SD_INSERT (bool SPM_e32_SD_INSERT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SD_INSERT = SPM_e32_SD_INSERT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_SD_INSERT () const {
    return _SPM_e32_SD_INSERT;
}

inline void T_b32_SubState0::setSPM_e32_EJECT (bool SPM_e32_EJECT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_EJECT = SPM_e32_EJECT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_EJECT () const {
    return _SPM_e32_EJECT;
}

inline void T_b32_SubState0::setSPM_e32_ON_TIPPER (bool SPM_e32_ON_TIPPER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ON_TIPPER = SPM_e32_ON_TIPPER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_ON_TIPPER () const {
    return _SPM_e32_ON_TIPPER;
}

inline void T_b32_SubState0::setSPM_e32_SOFTTOP_OPEN (bool SPM_e32_SOFTTOP_OPEN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SOFTTOP_OPEN = SPM_e32_SOFTTOP_OPEN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_SOFTTOP_OPEN () const {
    return _SPM_e32_SOFTTOP_OPEN;
}

inline void T_b32_SubState0::setSPM_e32_AIRBAG_DEPLOYED (bool SPM_e32_AIRBAG_DEPLOYED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_AIRBAG_DEPLOYED = SPM_e32_AIRBAG_DEPLOYED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_AIRBAG_DEPLOYED () const {
    return _SPM_e32_AIRBAG_DEPLOYED;
}

inline void T_b32_SubState0::setSPM_e32_KEY_PRESENT (bool SPM_e32_KEY_PRESENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_KEY_PRESENT = SPM_e32_KEY_PRESENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_KEY_PRESENT () const {
    return _SPM_e32_KEY_PRESENT;
}

inline void T_b32_SubState0::setSPM_e32_NETWORK_ACTIVITY (bool SPM_e32_NETWORK_ACTIVITY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_NETWORK_ACTIVITY = SPM_e32_NETWORK_ACTIVITY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_NETWORK_ACTIVITY () const {
    return _SPM_e32_NETWORK_ACTIVITY;
}

inline void T_b32_SubState0::setSPM_e32_OFF_TIPPER (bool SPM_e32_OFF_TIPPER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_OFF_TIPPER = SPM_e32_OFF_TIPPER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_OFF_TIPPER () const {
    return _SPM_e32_OFF_TIPPER;
}

inline void T_b32_SubState0::setSPM_e32_OFF_LASTSTATE_CYCLE (bool SPM_e32_OFF_LASTSTATE_CYCLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_OFF_LASTSTATE_CYCLE = SPM_e32_OFF_LASTSTATE_CYCLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_OFF_LASTSTATE_CYCLE () const {
    return _SPM_e32_OFF_LASTSTATE_CYCLE;
}

inline void T_b32_SubState0::setSPM_e32_DIAG_REQUEST (bool SPM_e32_DIAG_REQUEST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DIAG_REQUEST = SPM_e32_DIAG_REQUEST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_DIAG_REQUEST () const {
    return _SPM_e32_DIAG_REQUEST;
}

inline void T_b32_SubState0::setSPM_e32_BACKLIGHT (bool SPM_e32_BACKLIGHT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_BACKLIGHT = SPM_e32_BACKLIGHT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_BACKLIGHT () const {
    return _SPM_e32_BACKLIGHT;
}

inline void T_b32_SubState0::setSPM_e32_HIGH_VOLTAGE (bool SPM_e32_HIGH_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_HIGH_VOLTAGE = SPM_e32_HIGH_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_HIGH_VOLTAGE () const {
    return _SPM_e32_HIGH_VOLTAGE;
}

inline void T_b32_SubState0::setSPM_e32_RCV_CONNECTED (bool SPM_e32_RCV_CONNECTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_RCV_CONNECTED = SPM_e32_RCV_CONNECTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_RCV_CONNECTED () const {
    return _SPM_e32_RCV_CONNECTED;
}

inline void T_b32_SubState0::setSPM_e32_OFF_LEARN (bool SPM_e32_OFF_LEARN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_OFF_LEARN = SPM_e32_OFF_LEARN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState0::getSPM_e32_OFF_LEARN () const {
    return _SPM_e32_OFF_LEARN;
}

inline  T_b32_SubState1::T_b32_SubState1 ()  :
    _SPM_e32_HEARTBEAT (false),
    _SPM_e32_USER_ON_REQ (false),
    _SPM_e32_BACKGROUND_ON_REQ (false),
    _SPM_e32_MULTIMEDIA_ON (false),
    _SPM_e32_ANIMATION (false),
    _SPM_e32_MULTIMEDIA_OPERATION (false),
    _SPM_e32_TELEMATIC_ACTIVE (false),
    _SPM_e32_STANDBY_REQ (false),
    _SPM_e32_ACCESSORY_ACTIVE (false),
    _SPM_e32_SHUTDOWN_BATTERY_SAVING (false),
    _SPM_e32_TML_REQ_BACKGROUND (false),
    _SPM_e32_IGNITION_TIMEOUT (false),
    _SPM_e32_IGNITION_INVALID (false),
    _SPM_e32_FIRST_PIC_DRAWN (false),
    _SPM_e32_OVERTEMP (false),
    _SPM_e32_LOCK_ACTIVITY (false),
    _SPM_e32_SYSSTATE_CHECK (false),
    _SPM_e32_CR_TEMPERATURE (false),
    _SPM_e32_PUSH_TO_TALK (false),
    _SPM_e32_ROUTEGUIDANCE_ACTIVE (false),
    _SPM_e32_HW_IGNITION (false),
    _SPM_e32_CAN_WAKEUP (false),
    _SPM_e32_DOWNLOAD_PERMISSION (false),
    _SPM_e32_IGNITION_LOGIC (false),
    _SPM_e32_LOW_VOLTAGE (false),
    _SPM_e32_STATE_DEBOUNCE (false),
    _SPM_e32_NETWORK_FAILURE (false),
    _SPM_e32_STATE_TO (false),
    _SPM_e32_DEBUG_WAKEUP (false),
    _SPM_e32_AUTOMATIC (false),
    _SPM_e32_CODE_REQUEST (false),
    _SPM_e32_SYNC_SHUTDOWN_ACK (false)
{
}

inline  T_b32_SubState1::T_b32_SubState1 (const T_b32_SubState1 &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_SubState1::T_b32_SubState1 (bool SPM_e32_HEARTBEAT, bool SPM_e32_USER_ON_REQ, bool SPM_e32_BACKGROUND_ON_REQ, bool SPM_e32_MULTIMEDIA_ON, bool SPM_e32_ANIMATION, bool SPM_e32_MULTIMEDIA_OPERATION, bool SPM_e32_TELEMATIC_ACTIVE, bool SPM_e32_STANDBY_REQ, bool SPM_e32_ACCESSORY_ACTIVE, bool SPM_e32_SHUTDOWN_BATTERY_SAVING, bool SPM_e32_TML_REQ_BACKGROUND, bool SPM_e32_IGNITION_TIMEOUT, bool SPM_e32_IGNITION_INVALID, bool SPM_e32_FIRST_PIC_DRAWN, bool SPM_e32_OVERTEMP, bool SPM_e32_LOCK_ACTIVITY, bool SPM_e32_SYSSTATE_CHECK, bool SPM_e32_CR_TEMPERATURE, bool SPM_e32_PUSH_TO_TALK, bool SPM_e32_ROUTEGUIDANCE_ACTIVE, bool SPM_e32_HW_IGNITION, bool SPM_e32_CAN_WAKEUP, bool SPM_e32_DOWNLOAD_PERMISSION, bool SPM_e32_IGNITION_LOGIC, bool SPM_e32_LOW_VOLTAGE, bool SPM_e32_STATE_DEBOUNCE, bool SPM_e32_NETWORK_FAILURE, bool SPM_e32_STATE_TO, bool SPM_e32_DEBUG_WAKEUP, bool SPM_e32_AUTOMATIC, bool SPM_e32_CODE_REQUEST, bool SPM_e32_SYNC_SHUTDOWN_ACK) :
    _SPM_e32_HEARTBEAT (SPM_e32_HEARTBEAT),
    _SPM_e32_USER_ON_REQ (SPM_e32_USER_ON_REQ),
    _SPM_e32_BACKGROUND_ON_REQ (SPM_e32_BACKGROUND_ON_REQ),
    _SPM_e32_MULTIMEDIA_ON (SPM_e32_MULTIMEDIA_ON),
    _SPM_e32_ANIMATION (SPM_e32_ANIMATION),
    _SPM_e32_MULTIMEDIA_OPERATION (SPM_e32_MULTIMEDIA_OPERATION),
    _SPM_e32_TELEMATIC_ACTIVE (SPM_e32_TELEMATIC_ACTIVE),
    _SPM_e32_STANDBY_REQ (SPM_e32_STANDBY_REQ),
    _SPM_e32_ACCESSORY_ACTIVE (SPM_e32_ACCESSORY_ACTIVE),
    _SPM_e32_SHUTDOWN_BATTERY_SAVING (SPM_e32_SHUTDOWN_BATTERY_SAVING),
    _SPM_e32_TML_REQ_BACKGROUND (SPM_e32_TML_REQ_BACKGROUND),
    _SPM_e32_IGNITION_TIMEOUT (SPM_e32_IGNITION_TIMEOUT),
    _SPM_e32_IGNITION_INVALID (SPM_e32_IGNITION_INVALID),
    _SPM_e32_FIRST_PIC_DRAWN (SPM_e32_FIRST_PIC_DRAWN),
    _SPM_e32_OVERTEMP (SPM_e32_OVERTEMP),
    _SPM_e32_LOCK_ACTIVITY (SPM_e32_LOCK_ACTIVITY),
    _SPM_e32_SYSSTATE_CHECK (SPM_e32_SYSSTATE_CHECK),
    _SPM_e32_CR_TEMPERATURE (SPM_e32_CR_TEMPERATURE),
    _SPM_e32_PUSH_TO_TALK (SPM_e32_PUSH_TO_TALK),
    _SPM_e32_ROUTEGUIDANCE_ACTIVE (SPM_e32_ROUTEGUIDANCE_ACTIVE),
    _SPM_e32_HW_IGNITION (SPM_e32_HW_IGNITION),
    _SPM_e32_CAN_WAKEUP (SPM_e32_CAN_WAKEUP),
    _SPM_e32_DOWNLOAD_PERMISSION (SPM_e32_DOWNLOAD_PERMISSION),
    _SPM_e32_IGNITION_LOGIC (SPM_e32_IGNITION_LOGIC),
    _SPM_e32_LOW_VOLTAGE (SPM_e32_LOW_VOLTAGE),
    _SPM_e32_STATE_DEBOUNCE (SPM_e32_STATE_DEBOUNCE),
    _SPM_e32_NETWORK_FAILURE (SPM_e32_NETWORK_FAILURE),
    _SPM_e32_STATE_TO (SPM_e32_STATE_TO),
    _SPM_e32_DEBUG_WAKEUP (SPM_e32_DEBUG_WAKEUP),
    _SPM_e32_AUTOMATIC (SPM_e32_AUTOMATIC),
    _SPM_e32_CODE_REQUEST (SPM_e32_CODE_REQUEST),
    _SPM_e32_SYNC_SHUTDOWN_ACK (SPM_e32_SYNC_SHUTDOWN_ACK)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_SubState1& T_b32_SubState1::operator = (const T_b32_SubState1& rhs) {
    if( this != &rhs ) {
        _SPM_e32_HEARTBEAT = rhs._SPM_e32_HEARTBEAT;
        _SPM_e32_USER_ON_REQ = rhs._SPM_e32_USER_ON_REQ;
        _SPM_e32_BACKGROUND_ON_REQ = rhs._SPM_e32_BACKGROUND_ON_REQ;
        _SPM_e32_MULTIMEDIA_ON = rhs._SPM_e32_MULTIMEDIA_ON;
        _SPM_e32_ANIMATION = rhs._SPM_e32_ANIMATION;
        _SPM_e32_MULTIMEDIA_OPERATION = rhs._SPM_e32_MULTIMEDIA_OPERATION;
        _SPM_e32_TELEMATIC_ACTIVE = rhs._SPM_e32_TELEMATIC_ACTIVE;
        _SPM_e32_STANDBY_REQ = rhs._SPM_e32_STANDBY_REQ;
        _SPM_e32_ACCESSORY_ACTIVE = rhs._SPM_e32_ACCESSORY_ACTIVE;
        _SPM_e32_SHUTDOWN_BATTERY_SAVING = rhs._SPM_e32_SHUTDOWN_BATTERY_SAVING;
        _SPM_e32_TML_REQ_BACKGROUND = rhs._SPM_e32_TML_REQ_BACKGROUND;
        _SPM_e32_IGNITION_TIMEOUT = rhs._SPM_e32_IGNITION_TIMEOUT;
        _SPM_e32_IGNITION_INVALID = rhs._SPM_e32_IGNITION_INVALID;
        _SPM_e32_FIRST_PIC_DRAWN = rhs._SPM_e32_FIRST_PIC_DRAWN;
        _SPM_e32_OVERTEMP = rhs._SPM_e32_OVERTEMP;
        _SPM_e32_LOCK_ACTIVITY = rhs._SPM_e32_LOCK_ACTIVITY;
        _SPM_e32_SYSSTATE_CHECK = rhs._SPM_e32_SYSSTATE_CHECK;
        _SPM_e32_CR_TEMPERATURE = rhs._SPM_e32_CR_TEMPERATURE;
        _SPM_e32_PUSH_TO_TALK = rhs._SPM_e32_PUSH_TO_TALK;
        _SPM_e32_ROUTEGUIDANCE_ACTIVE = rhs._SPM_e32_ROUTEGUIDANCE_ACTIVE;
        _SPM_e32_HW_IGNITION = rhs._SPM_e32_HW_IGNITION;
        _SPM_e32_CAN_WAKEUP = rhs._SPM_e32_CAN_WAKEUP;
        _SPM_e32_DOWNLOAD_PERMISSION = rhs._SPM_e32_DOWNLOAD_PERMISSION;
        _SPM_e32_IGNITION_LOGIC = rhs._SPM_e32_IGNITION_LOGIC;
        _SPM_e32_LOW_VOLTAGE = rhs._SPM_e32_LOW_VOLTAGE;
        _SPM_e32_STATE_DEBOUNCE = rhs._SPM_e32_STATE_DEBOUNCE;
        _SPM_e32_NETWORK_FAILURE = rhs._SPM_e32_NETWORK_FAILURE;
        _SPM_e32_STATE_TO = rhs._SPM_e32_STATE_TO;
        _SPM_e32_DEBUG_WAKEUP = rhs._SPM_e32_DEBUG_WAKEUP;
        _SPM_e32_AUTOMATIC = rhs._SPM_e32_AUTOMATIC;
        _SPM_e32_CODE_REQUEST = rhs._SPM_e32_CODE_REQUEST;
        _SPM_e32_SYNC_SHUTDOWN_ACK = rhs._SPM_e32_SYNC_SHUTDOWN_ACK;
    }
    return *this;
}

inline bool T_b32_SubState1::operator == (const T_b32_SubState1& rhs) const {
    return (_SPM_e32_HEARTBEAT == rhs._SPM_e32_HEARTBEAT &&
        _SPM_e32_USER_ON_REQ == rhs._SPM_e32_USER_ON_REQ &&
        _SPM_e32_BACKGROUND_ON_REQ == rhs._SPM_e32_BACKGROUND_ON_REQ &&
        _SPM_e32_MULTIMEDIA_ON == rhs._SPM_e32_MULTIMEDIA_ON &&
        _SPM_e32_ANIMATION == rhs._SPM_e32_ANIMATION &&
        _SPM_e32_MULTIMEDIA_OPERATION == rhs._SPM_e32_MULTIMEDIA_OPERATION &&
        _SPM_e32_TELEMATIC_ACTIVE == rhs._SPM_e32_TELEMATIC_ACTIVE &&
        _SPM_e32_STANDBY_REQ == rhs._SPM_e32_STANDBY_REQ &&
        _SPM_e32_ACCESSORY_ACTIVE == rhs._SPM_e32_ACCESSORY_ACTIVE &&
        _SPM_e32_SHUTDOWN_BATTERY_SAVING == rhs._SPM_e32_SHUTDOWN_BATTERY_SAVING &&
        _SPM_e32_TML_REQ_BACKGROUND == rhs._SPM_e32_TML_REQ_BACKGROUND &&
        _SPM_e32_IGNITION_TIMEOUT == rhs._SPM_e32_IGNITION_TIMEOUT &&
        _SPM_e32_IGNITION_INVALID == rhs._SPM_e32_IGNITION_INVALID &&
        _SPM_e32_FIRST_PIC_DRAWN == rhs._SPM_e32_FIRST_PIC_DRAWN &&
        _SPM_e32_OVERTEMP == rhs._SPM_e32_OVERTEMP &&
        _SPM_e32_LOCK_ACTIVITY == rhs._SPM_e32_LOCK_ACTIVITY &&
        _SPM_e32_SYSSTATE_CHECK == rhs._SPM_e32_SYSSTATE_CHECK &&
        _SPM_e32_CR_TEMPERATURE == rhs._SPM_e32_CR_TEMPERATURE &&
        _SPM_e32_PUSH_TO_TALK == rhs._SPM_e32_PUSH_TO_TALK &&
        _SPM_e32_ROUTEGUIDANCE_ACTIVE == rhs._SPM_e32_ROUTEGUIDANCE_ACTIVE &&
        _SPM_e32_HW_IGNITION == rhs._SPM_e32_HW_IGNITION &&
        _SPM_e32_CAN_WAKEUP == rhs._SPM_e32_CAN_WAKEUP &&
        _SPM_e32_DOWNLOAD_PERMISSION == rhs._SPM_e32_DOWNLOAD_PERMISSION &&
        _SPM_e32_IGNITION_LOGIC == rhs._SPM_e32_IGNITION_LOGIC &&
        _SPM_e32_LOW_VOLTAGE == rhs._SPM_e32_LOW_VOLTAGE &&
        _SPM_e32_STATE_DEBOUNCE == rhs._SPM_e32_STATE_DEBOUNCE &&
        _SPM_e32_NETWORK_FAILURE == rhs._SPM_e32_NETWORK_FAILURE &&
        _SPM_e32_STATE_TO == rhs._SPM_e32_STATE_TO &&
        _SPM_e32_DEBUG_WAKEUP == rhs._SPM_e32_DEBUG_WAKEUP &&
        _SPM_e32_AUTOMATIC == rhs._SPM_e32_AUTOMATIC &&
        _SPM_e32_CODE_REQUEST == rhs._SPM_e32_CODE_REQUEST &&
        _SPM_e32_SYNC_SHUTDOWN_ACK == rhs._SPM_e32_SYNC_SHUTDOWN_ACK);
}

inline bool T_b32_SubState1::operator != (const T_b32_SubState1& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_SubState1::operator < (const T_b32_SubState1& rhs) const {
    if (getSPM_e32_HEARTBEAT() < rhs.getSPM_e32_HEARTBEAT()) return true;
    if (getSPM_e32_HEARTBEAT() > rhs.getSPM_e32_HEARTBEAT()) return false;

    if (getSPM_e32_USER_ON_REQ() < rhs.getSPM_e32_USER_ON_REQ()) return true;
    if (getSPM_e32_USER_ON_REQ() > rhs.getSPM_e32_USER_ON_REQ()) return false;

    if (getSPM_e32_BACKGROUND_ON_REQ() < rhs.getSPM_e32_BACKGROUND_ON_REQ()) return true;
    if (getSPM_e32_BACKGROUND_ON_REQ() > rhs.getSPM_e32_BACKGROUND_ON_REQ()) return false;

    if (getSPM_e32_MULTIMEDIA_ON() < rhs.getSPM_e32_MULTIMEDIA_ON()) return true;
    if (getSPM_e32_MULTIMEDIA_ON() > rhs.getSPM_e32_MULTIMEDIA_ON()) return false;

    if (getSPM_e32_ANIMATION() < rhs.getSPM_e32_ANIMATION()) return true;
    if (getSPM_e32_ANIMATION() > rhs.getSPM_e32_ANIMATION()) return false;

    if (getSPM_e32_MULTIMEDIA_OPERATION() < rhs.getSPM_e32_MULTIMEDIA_OPERATION()) return true;
    if (getSPM_e32_MULTIMEDIA_OPERATION() > rhs.getSPM_e32_MULTIMEDIA_OPERATION()) return false;

    if (getSPM_e32_TELEMATIC_ACTIVE() < rhs.getSPM_e32_TELEMATIC_ACTIVE()) return true;
    if (getSPM_e32_TELEMATIC_ACTIVE() > rhs.getSPM_e32_TELEMATIC_ACTIVE()) return false;

    if (getSPM_e32_STANDBY_REQ() < rhs.getSPM_e32_STANDBY_REQ()) return true;
    if (getSPM_e32_STANDBY_REQ() > rhs.getSPM_e32_STANDBY_REQ()) return false;

    if (getSPM_e32_ACCESSORY_ACTIVE() < rhs.getSPM_e32_ACCESSORY_ACTIVE()) return true;
    if (getSPM_e32_ACCESSORY_ACTIVE() > rhs.getSPM_e32_ACCESSORY_ACTIVE()) return false;

    if (getSPM_e32_SHUTDOWN_BATTERY_SAVING() < rhs.getSPM_e32_SHUTDOWN_BATTERY_SAVING()) return true;
    if (getSPM_e32_SHUTDOWN_BATTERY_SAVING() > rhs.getSPM_e32_SHUTDOWN_BATTERY_SAVING()) return false;

    if (getSPM_e32_TML_REQ_BACKGROUND() < rhs.getSPM_e32_TML_REQ_BACKGROUND()) return true;
    if (getSPM_e32_TML_REQ_BACKGROUND() > rhs.getSPM_e32_TML_REQ_BACKGROUND()) return false;

    if (getSPM_e32_IGNITION_TIMEOUT() < rhs.getSPM_e32_IGNITION_TIMEOUT()) return true;
    if (getSPM_e32_IGNITION_TIMEOUT() > rhs.getSPM_e32_IGNITION_TIMEOUT()) return false;

    if (getSPM_e32_IGNITION_INVALID() < rhs.getSPM_e32_IGNITION_INVALID()) return true;
    if (getSPM_e32_IGNITION_INVALID() > rhs.getSPM_e32_IGNITION_INVALID()) return false;

    if (getSPM_e32_FIRST_PIC_DRAWN() < rhs.getSPM_e32_FIRST_PIC_DRAWN()) return true;
    if (getSPM_e32_FIRST_PIC_DRAWN() > rhs.getSPM_e32_FIRST_PIC_DRAWN()) return false;

    if (getSPM_e32_OVERTEMP() < rhs.getSPM_e32_OVERTEMP()) return true;
    if (getSPM_e32_OVERTEMP() > rhs.getSPM_e32_OVERTEMP()) return false;

    if (getSPM_e32_LOCK_ACTIVITY() < rhs.getSPM_e32_LOCK_ACTIVITY()) return true;
    if (getSPM_e32_LOCK_ACTIVITY() > rhs.getSPM_e32_LOCK_ACTIVITY()) return false;

    if (getSPM_e32_SYSSTATE_CHECK() < rhs.getSPM_e32_SYSSTATE_CHECK()) return true;
    if (getSPM_e32_SYSSTATE_CHECK() > rhs.getSPM_e32_SYSSTATE_CHECK()) return false;

    if (getSPM_e32_CR_TEMPERATURE() < rhs.getSPM_e32_CR_TEMPERATURE()) return true;
    if (getSPM_e32_CR_TEMPERATURE() > rhs.getSPM_e32_CR_TEMPERATURE()) return false;

    if (getSPM_e32_PUSH_TO_TALK() < rhs.getSPM_e32_PUSH_TO_TALK()) return true;
    if (getSPM_e32_PUSH_TO_TALK() > rhs.getSPM_e32_PUSH_TO_TALK()) return false;

    if (getSPM_e32_ROUTEGUIDANCE_ACTIVE() < rhs.getSPM_e32_ROUTEGUIDANCE_ACTIVE()) return true;
    if (getSPM_e32_ROUTEGUIDANCE_ACTIVE() > rhs.getSPM_e32_ROUTEGUIDANCE_ACTIVE()) return false;

    if (getSPM_e32_HW_IGNITION() < rhs.getSPM_e32_HW_IGNITION()) return true;
    if (getSPM_e32_HW_IGNITION() > rhs.getSPM_e32_HW_IGNITION()) return false;

    if (getSPM_e32_CAN_WAKEUP() < rhs.getSPM_e32_CAN_WAKEUP()) return true;
    if (getSPM_e32_CAN_WAKEUP() > rhs.getSPM_e32_CAN_WAKEUP()) return false;

    if (getSPM_e32_DOWNLOAD_PERMISSION() < rhs.getSPM_e32_DOWNLOAD_PERMISSION()) return true;
    if (getSPM_e32_DOWNLOAD_PERMISSION() > rhs.getSPM_e32_DOWNLOAD_PERMISSION()) return false;

    if (getSPM_e32_IGNITION_LOGIC() < rhs.getSPM_e32_IGNITION_LOGIC()) return true;
    if (getSPM_e32_IGNITION_LOGIC() > rhs.getSPM_e32_IGNITION_LOGIC()) return false;

    if (getSPM_e32_LOW_VOLTAGE() < rhs.getSPM_e32_LOW_VOLTAGE()) return true;
    if (getSPM_e32_LOW_VOLTAGE() > rhs.getSPM_e32_LOW_VOLTAGE()) return false;

    if (getSPM_e32_STATE_DEBOUNCE() < rhs.getSPM_e32_STATE_DEBOUNCE()) return true;
    if (getSPM_e32_STATE_DEBOUNCE() > rhs.getSPM_e32_STATE_DEBOUNCE()) return false;

    if (getSPM_e32_NETWORK_FAILURE() < rhs.getSPM_e32_NETWORK_FAILURE()) return true;
    if (getSPM_e32_NETWORK_FAILURE() > rhs.getSPM_e32_NETWORK_FAILURE()) return false;

    if (getSPM_e32_STATE_TO() < rhs.getSPM_e32_STATE_TO()) return true;
    if (getSPM_e32_STATE_TO() > rhs.getSPM_e32_STATE_TO()) return false;

    if (getSPM_e32_DEBUG_WAKEUP() < rhs.getSPM_e32_DEBUG_WAKEUP()) return true;
    if (getSPM_e32_DEBUG_WAKEUP() > rhs.getSPM_e32_DEBUG_WAKEUP()) return false;

    if (getSPM_e32_AUTOMATIC() < rhs.getSPM_e32_AUTOMATIC()) return true;
    if (getSPM_e32_AUTOMATIC() > rhs.getSPM_e32_AUTOMATIC()) return false;

    if (getSPM_e32_CODE_REQUEST() < rhs.getSPM_e32_CODE_REQUEST()) return true;
    if (getSPM_e32_CODE_REQUEST() > rhs.getSPM_e32_CODE_REQUEST()) return false;

    if (getSPM_e32_SYNC_SHUTDOWN_ACK() < rhs.getSPM_e32_SYNC_SHUTDOWN_ACK()) return true;
    if (getSPM_e32_SYNC_SHUTDOWN_ACK() > rhs.getSPM_e32_SYNC_SHUTDOWN_ACK()) return false;

    return false;
}

inline bool T_b32_SubState1::operator > (const T_b32_SubState1& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_SubState1::setSPM_e32_HEARTBEAT (bool SPM_e32_HEARTBEAT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_HEARTBEAT = SPM_e32_HEARTBEAT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_HEARTBEAT () const {
    return _SPM_e32_HEARTBEAT;
}

inline void T_b32_SubState1::setSPM_e32_USER_ON_REQ (bool SPM_e32_USER_ON_REQ) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_USER_ON_REQ = SPM_e32_USER_ON_REQ;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_USER_ON_REQ () const {
    return _SPM_e32_USER_ON_REQ;
}

inline void T_b32_SubState1::setSPM_e32_BACKGROUND_ON_REQ (bool SPM_e32_BACKGROUND_ON_REQ) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_BACKGROUND_ON_REQ = SPM_e32_BACKGROUND_ON_REQ;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_BACKGROUND_ON_REQ () const {
    return _SPM_e32_BACKGROUND_ON_REQ;
}

inline void T_b32_SubState1::setSPM_e32_MULTIMEDIA_ON (bool SPM_e32_MULTIMEDIA_ON) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MULTIMEDIA_ON = SPM_e32_MULTIMEDIA_ON;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_MULTIMEDIA_ON () const {
    return _SPM_e32_MULTIMEDIA_ON;
}

inline void T_b32_SubState1::setSPM_e32_ANIMATION (bool SPM_e32_ANIMATION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ANIMATION = SPM_e32_ANIMATION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_ANIMATION () const {
    return _SPM_e32_ANIMATION;
}

inline void T_b32_SubState1::setSPM_e32_MULTIMEDIA_OPERATION (bool SPM_e32_MULTIMEDIA_OPERATION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MULTIMEDIA_OPERATION = SPM_e32_MULTIMEDIA_OPERATION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_MULTIMEDIA_OPERATION () const {
    return _SPM_e32_MULTIMEDIA_OPERATION;
}

inline void T_b32_SubState1::setSPM_e32_TELEMATIC_ACTIVE (bool SPM_e32_TELEMATIC_ACTIVE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TELEMATIC_ACTIVE = SPM_e32_TELEMATIC_ACTIVE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_TELEMATIC_ACTIVE () const {
    return _SPM_e32_TELEMATIC_ACTIVE;
}

inline void T_b32_SubState1::setSPM_e32_STANDBY_REQ (bool SPM_e32_STANDBY_REQ) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_STANDBY_REQ = SPM_e32_STANDBY_REQ;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_STANDBY_REQ () const {
    return _SPM_e32_STANDBY_REQ;
}

inline void T_b32_SubState1::setSPM_e32_ACCESSORY_ACTIVE (bool SPM_e32_ACCESSORY_ACTIVE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ACCESSORY_ACTIVE = SPM_e32_ACCESSORY_ACTIVE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_ACCESSORY_ACTIVE () const {
    return _SPM_e32_ACCESSORY_ACTIVE;
}

inline void T_b32_SubState1::setSPM_e32_SHUTDOWN_BATTERY_SAVING (bool SPM_e32_SHUTDOWN_BATTERY_SAVING) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SHUTDOWN_BATTERY_SAVING = SPM_e32_SHUTDOWN_BATTERY_SAVING;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_SHUTDOWN_BATTERY_SAVING () const {
    return _SPM_e32_SHUTDOWN_BATTERY_SAVING;
}

inline void T_b32_SubState1::setSPM_e32_TML_REQ_BACKGROUND (bool SPM_e32_TML_REQ_BACKGROUND) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TML_REQ_BACKGROUND = SPM_e32_TML_REQ_BACKGROUND;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_TML_REQ_BACKGROUND () const {
    return _SPM_e32_TML_REQ_BACKGROUND;
}

inline void T_b32_SubState1::setSPM_e32_IGNITION_TIMEOUT (bool SPM_e32_IGNITION_TIMEOUT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_IGNITION_TIMEOUT = SPM_e32_IGNITION_TIMEOUT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_IGNITION_TIMEOUT () const {
    return _SPM_e32_IGNITION_TIMEOUT;
}

inline void T_b32_SubState1::setSPM_e32_IGNITION_INVALID (bool SPM_e32_IGNITION_INVALID) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_IGNITION_INVALID = SPM_e32_IGNITION_INVALID;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_IGNITION_INVALID () const {
    return _SPM_e32_IGNITION_INVALID;
}

inline void T_b32_SubState1::setSPM_e32_FIRST_PIC_DRAWN (bool SPM_e32_FIRST_PIC_DRAWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FIRST_PIC_DRAWN = SPM_e32_FIRST_PIC_DRAWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_FIRST_PIC_DRAWN () const {
    return _SPM_e32_FIRST_PIC_DRAWN;
}

inline void T_b32_SubState1::setSPM_e32_OVERTEMP (bool SPM_e32_OVERTEMP) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_OVERTEMP = SPM_e32_OVERTEMP;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_OVERTEMP () const {
    return _SPM_e32_OVERTEMP;
}

inline void T_b32_SubState1::setSPM_e32_LOCK_ACTIVITY (bool SPM_e32_LOCK_ACTIVITY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_LOCK_ACTIVITY = SPM_e32_LOCK_ACTIVITY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_LOCK_ACTIVITY () const {
    return _SPM_e32_LOCK_ACTIVITY;
}

inline void T_b32_SubState1::setSPM_e32_SYSSTATE_CHECK (bool SPM_e32_SYSSTATE_CHECK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SYSSTATE_CHECK = SPM_e32_SYSSTATE_CHECK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_SYSSTATE_CHECK () const {
    return _SPM_e32_SYSSTATE_CHECK;
}

inline void T_b32_SubState1::setSPM_e32_CR_TEMPERATURE (bool SPM_e32_CR_TEMPERATURE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CR_TEMPERATURE = SPM_e32_CR_TEMPERATURE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_CR_TEMPERATURE () const {
    return _SPM_e32_CR_TEMPERATURE;
}

inline void T_b32_SubState1::setSPM_e32_PUSH_TO_TALK (bool SPM_e32_PUSH_TO_TALK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_PUSH_TO_TALK = SPM_e32_PUSH_TO_TALK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_PUSH_TO_TALK () const {
    return _SPM_e32_PUSH_TO_TALK;
}

inline void T_b32_SubState1::setSPM_e32_ROUTEGUIDANCE_ACTIVE (bool SPM_e32_ROUTEGUIDANCE_ACTIVE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ROUTEGUIDANCE_ACTIVE = SPM_e32_ROUTEGUIDANCE_ACTIVE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_ROUTEGUIDANCE_ACTIVE () const {
    return _SPM_e32_ROUTEGUIDANCE_ACTIVE;
}

inline void T_b32_SubState1::setSPM_e32_HW_IGNITION (bool SPM_e32_HW_IGNITION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_HW_IGNITION = SPM_e32_HW_IGNITION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_HW_IGNITION () const {
    return _SPM_e32_HW_IGNITION;
}

inline void T_b32_SubState1::setSPM_e32_CAN_WAKEUP (bool SPM_e32_CAN_WAKEUP) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CAN_WAKEUP = SPM_e32_CAN_WAKEUP;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_CAN_WAKEUP () const {
    return _SPM_e32_CAN_WAKEUP;
}

inline void T_b32_SubState1::setSPM_e32_DOWNLOAD_PERMISSION (bool SPM_e32_DOWNLOAD_PERMISSION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DOWNLOAD_PERMISSION = SPM_e32_DOWNLOAD_PERMISSION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_DOWNLOAD_PERMISSION () const {
    return _SPM_e32_DOWNLOAD_PERMISSION;
}

inline void T_b32_SubState1::setSPM_e32_IGNITION_LOGIC (bool SPM_e32_IGNITION_LOGIC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_IGNITION_LOGIC = SPM_e32_IGNITION_LOGIC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_IGNITION_LOGIC () const {
    return _SPM_e32_IGNITION_LOGIC;
}

inline void T_b32_SubState1::setSPM_e32_LOW_VOLTAGE (bool SPM_e32_LOW_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_LOW_VOLTAGE = SPM_e32_LOW_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_LOW_VOLTAGE () const {
    return _SPM_e32_LOW_VOLTAGE;
}

inline void T_b32_SubState1::setSPM_e32_STATE_DEBOUNCE (bool SPM_e32_STATE_DEBOUNCE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_STATE_DEBOUNCE = SPM_e32_STATE_DEBOUNCE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_STATE_DEBOUNCE () const {
    return _SPM_e32_STATE_DEBOUNCE;
}

inline void T_b32_SubState1::setSPM_e32_NETWORK_FAILURE (bool SPM_e32_NETWORK_FAILURE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_NETWORK_FAILURE = SPM_e32_NETWORK_FAILURE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_NETWORK_FAILURE () const {
    return _SPM_e32_NETWORK_FAILURE;
}

inline void T_b32_SubState1::setSPM_e32_STATE_TO (bool SPM_e32_STATE_TO) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_STATE_TO = SPM_e32_STATE_TO;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_STATE_TO () const {
    return _SPM_e32_STATE_TO;
}

inline void T_b32_SubState1::setSPM_e32_DEBUG_WAKEUP (bool SPM_e32_DEBUG_WAKEUP) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DEBUG_WAKEUP = SPM_e32_DEBUG_WAKEUP;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_DEBUG_WAKEUP () const {
    return _SPM_e32_DEBUG_WAKEUP;
}

inline void T_b32_SubState1::setSPM_e32_AUTOMATIC (bool SPM_e32_AUTOMATIC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_AUTOMATIC = SPM_e32_AUTOMATIC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_AUTOMATIC () const {
    return _SPM_e32_AUTOMATIC;
}

inline void T_b32_SubState1::setSPM_e32_CODE_REQUEST (bool SPM_e32_CODE_REQUEST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CODE_REQUEST = SPM_e32_CODE_REQUEST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_CODE_REQUEST () const {
    return _SPM_e32_CODE_REQUEST;
}

inline void T_b32_SubState1::setSPM_e32_SYNC_SHUTDOWN_ACK (bool SPM_e32_SYNC_SHUTDOWN_ACK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SYNC_SHUTDOWN_ACK = SPM_e32_SYNC_SHUTDOWN_ACK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState1::getSPM_e32_SYNC_SHUTDOWN_ACK () const {
    return _SPM_e32_SYNC_SHUTDOWN_ACK;
}

inline  T_b32_SubState2::T_b32_SubState2 ()  :
    _SPM_e32_FRIENDLY_USER (false),
    _SPM_e32_NISSAN_CMF1 (false),
    _SPM_e32_PREPARE_SHUTDOWN (false),
    _SPM_e32_SHUTDOWN (false),
    _SPM_e32_HKEY_PRESSED (false),
    _SPM_e32_CD_INSERT_CLAMPS (false),
    _SPM_e32_CRITICAL_LOW_VOLTAGE (false),
    _SPM_e32_ENDURING_LOW_VOLTAGE (false),
    _SPM_e32_DIAG_FAST_SHUTDOWN (false),
    _SPM_e32_USING_ACCESSORY (false),
    _SPM_e32_BACKGROUND_IMM_OFF (false),
    _SPM_e32_ROLLER_RIG_MODE (false),
    _SPM_e32_REMOTE_ON_ACTIVE (false),
    _SPM_e32_ENDURING_CR_VOLTAGE (false),
    _SPM_e32_NORMAL_VOLT (false),
    _SPM_e32_Q_CRITICAL (false),
    _SPM_e32_TRIGGER_RESET (false),
    _SPM_e32_CAR_WAKEUP (false),
    _SPM_e32_PHONE_CONNECTED (false),
    _SPM_e32_CUSTOMER_DOWNLOAD (false),
    _SPM_e32_STARTUP (false),
    _SPM_e32_MOST_OFF (false),
    _SPM_e32_MOST_OFF_ERR (false),
    _SPM_e32_MOST_WAIT_FOR_SHUTDOWN (false),
    _SPM_e32_MOST_RBD (false),
    _SPM_e32_MOST_SHUTDOWN_EXECUTE (false),
    _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY (false),
    _SPM_e32_SYSSTATE_NETWORK_FAILED (false),
    _SPM_e32_SAFE (false),
    _SPM_e32_FSM_SHUTDOWN_FINISHED (false),
    _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK (false),
    _SPM_e32_WAIT_FOR_FSM_RESTART_ACK (false)
{
}

inline  T_b32_SubState2::T_b32_SubState2 (const T_b32_SubState2 &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_SubState2::T_b32_SubState2 (bool SPM_e32_FRIENDLY_USER, bool SPM_e32_NISSAN_CMF1, bool SPM_e32_PREPARE_SHUTDOWN, bool SPM_e32_SHUTDOWN, bool SPM_e32_HKEY_PRESSED, bool SPM_e32_CD_INSERT_CLAMPS, bool SPM_e32_CRITICAL_LOW_VOLTAGE, bool SPM_e32_ENDURING_LOW_VOLTAGE, bool SPM_e32_DIAG_FAST_SHUTDOWN, bool SPM_e32_USING_ACCESSORY, bool SPM_e32_BACKGROUND_IMM_OFF, bool SPM_e32_ROLLER_RIG_MODE, bool SPM_e32_REMOTE_ON_ACTIVE, bool SPM_e32_ENDURING_CR_VOLTAGE, bool SPM_e32_NORMAL_VOLT, bool SPM_e32_Q_CRITICAL, bool SPM_e32_TRIGGER_RESET, bool SPM_e32_CAR_WAKEUP, bool SPM_e32_PHONE_CONNECTED, bool SPM_e32_CUSTOMER_DOWNLOAD, bool SPM_e32_STARTUP, bool SPM_e32_MOST_OFF, bool SPM_e32_MOST_OFF_ERR, bool SPM_e32_MOST_WAIT_FOR_SHUTDOWN, bool SPM_e32_MOST_RBD, bool SPM_e32_MOST_SHUTDOWN_EXECUTE, bool SPM_e32_MOST_PWR_SWITCH_OFF_DELAY, bool SPM_e32_SYSSTATE_NETWORK_FAILED, bool SPM_e32_SAFE, bool SPM_e32_FSM_SHUTDOWN_FINISHED, bool SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK, bool SPM_e32_WAIT_FOR_FSM_RESTART_ACK) :
    _SPM_e32_FRIENDLY_USER (SPM_e32_FRIENDLY_USER),
    _SPM_e32_NISSAN_CMF1 (SPM_e32_NISSAN_CMF1),
    _SPM_e32_PREPARE_SHUTDOWN (SPM_e32_PREPARE_SHUTDOWN),
    _SPM_e32_SHUTDOWN (SPM_e32_SHUTDOWN),
    _SPM_e32_HKEY_PRESSED (SPM_e32_HKEY_PRESSED),
    _SPM_e32_CD_INSERT_CLAMPS (SPM_e32_CD_INSERT_CLAMPS),
    _SPM_e32_CRITICAL_LOW_VOLTAGE (SPM_e32_CRITICAL_LOW_VOLTAGE),
    _SPM_e32_ENDURING_LOW_VOLTAGE (SPM_e32_ENDURING_LOW_VOLTAGE),
    _SPM_e32_DIAG_FAST_SHUTDOWN (SPM_e32_DIAG_FAST_SHUTDOWN),
    _SPM_e32_USING_ACCESSORY (SPM_e32_USING_ACCESSORY),
    _SPM_e32_BACKGROUND_IMM_OFF (SPM_e32_BACKGROUND_IMM_OFF),
    _SPM_e32_ROLLER_RIG_MODE (SPM_e32_ROLLER_RIG_MODE),
    _SPM_e32_REMOTE_ON_ACTIVE (SPM_e32_REMOTE_ON_ACTIVE),
    _SPM_e32_ENDURING_CR_VOLTAGE (SPM_e32_ENDURING_CR_VOLTAGE),
    _SPM_e32_NORMAL_VOLT (SPM_e32_NORMAL_VOLT),
    _SPM_e32_Q_CRITICAL (SPM_e32_Q_CRITICAL),
    _SPM_e32_TRIGGER_RESET (SPM_e32_TRIGGER_RESET),
    _SPM_e32_CAR_WAKEUP (SPM_e32_CAR_WAKEUP),
    _SPM_e32_PHONE_CONNECTED (SPM_e32_PHONE_CONNECTED),
    _SPM_e32_CUSTOMER_DOWNLOAD (SPM_e32_CUSTOMER_DOWNLOAD),
    _SPM_e32_STARTUP (SPM_e32_STARTUP),
    _SPM_e32_MOST_OFF (SPM_e32_MOST_OFF),
    _SPM_e32_MOST_OFF_ERR (SPM_e32_MOST_OFF_ERR),
    _SPM_e32_MOST_WAIT_FOR_SHUTDOWN (SPM_e32_MOST_WAIT_FOR_SHUTDOWN),
    _SPM_e32_MOST_RBD (SPM_e32_MOST_RBD),
    _SPM_e32_MOST_SHUTDOWN_EXECUTE (SPM_e32_MOST_SHUTDOWN_EXECUTE),
    _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY (SPM_e32_MOST_PWR_SWITCH_OFF_DELAY),
    _SPM_e32_SYSSTATE_NETWORK_FAILED (SPM_e32_SYSSTATE_NETWORK_FAILED),
    _SPM_e32_SAFE (SPM_e32_SAFE),
    _SPM_e32_FSM_SHUTDOWN_FINISHED (SPM_e32_FSM_SHUTDOWN_FINISHED),
    _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK (SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK),
    _SPM_e32_WAIT_FOR_FSM_RESTART_ACK (SPM_e32_WAIT_FOR_FSM_RESTART_ACK)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_SubState2& T_b32_SubState2::operator = (const T_b32_SubState2& rhs) {
    if( this != &rhs ) {
        _SPM_e32_FRIENDLY_USER = rhs._SPM_e32_FRIENDLY_USER;
        _SPM_e32_NISSAN_CMF1 = rhs._SPM_e32_NISSAN_CMF1;
        _SPM_e32_PREPARE_SHUTDOWN = rhs._SPM_e32_PREPARE_SHUTDOWN;
        _SPM_e32_SHUTDOWN = rhs._SPM_e32_SHUTDOWN;
        _SPM_e32_HKEY_PRESSED = rhs._SPM_e32_HKEY_PRESSED;
        _SPM_e32_CD_INSERT_CLAMPS = rhs._SPM_e32_CD_INSERT_CLAMPS;
        _SPM_e32_CRITICAL_LOW_VOLTAGE = rhs._SPM_e32_CRITICAL_LOW_VOLTAGE;
        _SPM_e32_ENDURING_LOW_VOLTAGE = rhs._SPM_e32_ENDURING_LOW_VOLTAGE;
        _SPM_e32_DIAG_FAST_SHUTDOWN = rhs._SPM_e32_DIAG_FAST_SHUTDOWN;
        _SPM_e32_USING_ACCESSORY = rhs._SPM_e32_USING_ACCESSORY;
        _SPM_e32_BACKGROUND_IMM_OFF = rhs._SPM_e32_BACKGROUND_IMM_OFF;
        _SPM_e32_ROLLER_RIG_MODE = rhs._SPM_e32_ROLLER_RIG_MODE;
        _SPM_e32_REMOTE_ON_ACTIVE = rhs._SPM_e32_REMOTE_ON_ACTIVE;
        _SPM_e32_ENDURING_CR_VOLTAGE = rhs._SPM_e32_ENDURING_CR_VOLTAGE;
        _SPM_e32_NORMAL_VOLT = rhs._SPM_e32_NORMAL_VOLT;
        _SPM_e32_Q_CRITICAL = rhs._SPM_e32_Q_CRITICAL;
        _SPM_e32_TRIGGER_RESET = rhs._SPM_e32_TRIGGER_RESET;
        _SPM_e32_CAR_WAKEUP = rhs._SPM_e32_CAR_WAKEUP;
        _SPM_e32_PHONE_CONNECTED = rhs._SPM_e32_PHONE_CONNECTED;
        _SPM_e32_CUSTOMER_DOWNLOAD = rhs._SPM_e32_CUSTOMER_DOWNLOAD;
        _SPM_e32_STARTUP = rhs._SPM_e32_STARTUP;
        _SPM_e32_MOST_OFF = rhs._SPM_e32_MOST_OFF;
        _SPM_e32_MOST_OFF_ERR = rhs._SPM_e32_MOST_OFF_ERR;
        _SPM_e32_MOST_WAIT_FOR_SHUTDOWN = rhs._SPM_e32_MOST_WAIT_FOR_SHUTDOWN;
        _SPM_e32_MOST_RBD = rhs._SPM_e32_MOST_RBD;
        _SPM_e32_MOST_SHUTDOWN_EXECUTE = rhs._SPM_e32_MOST_SHUTDOWN_EXECUTE;
        _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY = rhs._SPM_e32_MOST_PWR_SWITCH_OFF_DELAY;
        _SPM_e32_SYSSTATE_NETWORK_FAILED = rhs._SPM_e32_SYSSTATE_NETWORK_FAILED;
        _SPM_e32_SAFE = rhs._SPM_e32_SAFE;
        _SPM_e32_FSM_SHUTDOWN_FINISHED = rhs._SPM_e32_FSM_SHUTDOWN_FINISHED;
        _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK = rhs._SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK;
        _SPM_e32_WAIT_FOR_FSM_RESTART_ACK = rhs._SPM_e32_WAIT_FOR_FSM_RESTART_ACK;
    }
    return *this;
}

inline bool T_b32_SubState2::operator == (const T_b32_SubState2& rhs) const {
    return (_SPM_e32_FRIENDLY_USER == rhs._SPM_e32_FRIENDLY_USER &&
        _SPM_e32_NISSAN_CMF1 == rhs._SPM_e32_NISSAN_CMF1 &&
        _SPM_e32_PREPARE_SHUTDOWN == rhs._SPM_e32_PREPARE_SHUTDOWN &&
        _SPM_e32_SHUTDOWN == rhs._SPM_e32_SHUTDOWN &&
        _SPM_e32_HKEY_PRESSED == rhs._SPM_e32_HKEY_PRESSED &&
        _SPM_e32_CD_INSERT_CLAMPS == rhs._SPM_e32_CD_INSERT_CLAMPS &&
        _SPM_e32_CRITICAL_LOW_VOLTAGE == rhs._SPM_e32_CRITICAL_LOW_VOLTAGE &&
        _SPM_e32_ENDURING_LOW_VOLTAGE == rhs._SPM_e32_ENDURING_LOW_VOLTAGE &&
        _SPM_e32_DIAG_FAST_SHUTDOWN == rhs._SPM_e32_DIAG_FAST_SHUTDOWN &&
        _SPM_e32_USING_ACCESSORY == rhs._SPM_e32_USING_ACCESSORY &&
        _SPM_e32_BACKGROUND_IMM_OFF == rhs._SPM_e32_BACKGROUND_IMM_OFF &&
        _SPM_e32_ROLLER_RIG_MODE == rhs._SPM_e32_ROLLER_RIG_MODE &&
        _SPM_e32_REMOTE_ON_ACTIVE == rhs._SPM_e32_REMOTE_ON_ACTIVE &&
        _SPM_e32_ENDURING_CR_VOLTAGE == rhs._SPM_e32_ENDURING_CR_VOLTAGE &&
        _SPM_e32_NORMAL_VOLT == rhs._SPM_e32_NORMAL_VOLT &&
        _SPM_e32_Q_CRITICAL == rhs._SPM_e32_Q_CRITICAL &&
        _SPM_e32_TRIGGER_RESET == rhs._SPM_e32_TRIGGER_RESET &&
        _SPM_e32_CAR_WAKEUP == rhs._SPM_e32_CAR_WAKEUP &&
        _SPM_e32_PHONE_CONNECTED == rhs._SPM_e32_PHONE_CONNECTED &&
        _SPM_e32_CUSTOMER_DOWNLOAD == rhs._SPM_e32_CUSTOMER_DOWNLOAD &&
        _SPM_e32_STARTUP == rhs._SPM_e32_STARTUP &&
        _SPM_e32_MOST_OFF == rhs._SPM_e32_MOST_OFF &&
        _SPM_e32_MOST_OFF_ERR == rhs._SPM_e32_MOST_OFF_ERR &&
        _SPM_e32_MOST_WAIT_FOR_SHUTDOWN == rhs._SPM_e32_MOST_WAIT_FOR_SHUTDOWN &&
        _SPM_e32_MOST_RBD == rhs._SPM_e32_MOST_RBD &&
        _SPM_e32_MOST_SHUTDOWN_EXECUTE == rhs._SPM_e32_MOST_SHUTDOWN_EXECUTE &&
        _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY == rhs._SPM_e32_MOST_PWR_SWITCH_OFF_DELAY &&
        _SPM_e32_SYSSTATE_NETWORK_FAILED == rhs._SPM_e32_SYSSTATE_NETWORK_FAILED &&
        _SPM_e32_SAFE == rhs._SPM_e32_SAFE &&
        _SPM_e32_FSM_SHUTDOWN_FINISHED == rhs._SPM_e32_FSM_SHUTDOWN_FINISHED &&
        _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK == rhs._SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK &&
        _SPM_e32_WAIT_FOR_FSM_RESTART_ACK == rhs._SPM_e32_WAIT_FOR_FSM_RESTART_ACK);
}

inline bool T_b32_SubState2::operator != (const T_b32_SubState2& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_SubState2::operator < (const T_b32_SubState2& rhs) const {
    if (getSPM_e32_FRIENDLY_USER() < rhs.getSPM_e32_FRIENDLY_USER()) return true;
    if (getSPM_e32_FRIENDLY_USER() > rhs.getSPM_e32_FRIENDLY_USER()) return false;

    if (getSPM_e32_NISSAN_CMF1() < rhs.getSPM_e32_NISSAN_CMF1()) return true;
    if (getSPM_e32_NISSAN_CMF1() > rhs.getSPM_e32_NISSAN_CMF1()) return false;

    if (getSPM_e32_PREPARE_SHUTDOWN() < rhs.getSPM_e32_PREPARE_SHUTDOWN()) return true;
    if (getSPM_e32_PREPARE_SHUTDOWN() > rhs.getSPM_e32_PREPARE_SHUTDOWN()) return false;

    if (getSPM_e32_SHUTDOWN() < rhs.getSPM_e32_SHUTDOWN()) return true;
    if (getSPM_e32_SHUTDOWN() > rhs.getSPM_e32_SHUTDOWN()) return false;

    if (getSPM_e32_HKEY_PRESSED() < rhs.getSPM_e32_HKEY_PRESSED()) return true;
    if (getSPM_e32_HKEY_PRESSED() > rhs.getSPM_e32_HKEY_PRESSED()) return false;

    if (getSPM_e32_CD_INSERT_CLAMPS() < rhs.getSPM_e32_CD_INSERT_CLAMPS()) return true;
    if (getSPM_e32_CD_INSERT_CLAMPS() > rhs.getSPM_e32_CD_INSERT_CLAMPS()) return false;

    if (getSPM_e32_CRITICAL_LOW_VOLTAGE() < rhs.getSPM_e32_CRITICAL_LOW_VOLTAGE()) return true;
    if (getSPM_e32_CRITICAL_LOW_VOLTAGE() > rhs.getSPM_e32_CRITICAL_LOW_VOLTAGE()) return false;

    if (getSPM_e32_ENDURING_LOW_VOLTAGE() < rhs.getSPM_e32_ENDURING_LOW_VOLTAGE()) return true;
    if (getSPM_e32_ENDURING_LOW_VOLTAGE() > rhs.getSPM_e32_ENDURING_LOW_VOLTAGE()) return false;

    if (getSPM_e32_DIAG_FAST_SHUTDOWN() < rhs.getSPM_e32_DIAG_FAST_SHUTDOWN()) return true;
    if (getSPM_e32_DIAG_FAST_SHUTDOWN() > rhs.getSPM_e32_DIAG_FAST_SHUTDOWN()) return false;

    if (getSPM_e32_USING_ACCESSORY() < rhs.getSPM_e32_USING_ACCESSORY()) return true;
    if (getSPM_e32_USING_ACCESSORY() > rhs.getSPM_e32_USING_ACCESSORY()) return false;

    if (getSPM_e32_BACKGROUND_IMM_OFF() < rhs.getSPM_e32_BACKGROUND_IMM_OFF()) return true;
    if (getSPM_e32_BACKGROUND_IMM_OFF() > rhs.getSPM_e32_BACKGROUND_IMM_OFF()) return false;

    if (getSPM_e32_ROLLER_RIG_MODE() < rhs.getSPM_e32_ROLLER_RIG_MODE()) return true;
    if (getSPM_e32_ROLLER_RIG_MODE() > rhs.getSPM_e32_ROLLER_RIG_MODE()) return false;

    if (getSPM_e32_REMOTE_ON_ACTIVE() < rhs.getSPM_e32_REMOTE_ON_ACTIVE()) return true;
    if (getSPM_e32_REMOTE_ON_ACTIVE() > rhs.getSPM_e32_REMOTE_ON_ACTIVE()) return false;

    if (getSPM_e32_ENDURING_CR_VOLTAGE() < rhs.getSPM_e32_ENDURING_CR_VOLTAGE()) return true;
    if (getSPM_e32_ENDURING_CR_VOLTAGE() > rhs.getSPM_e32_ENDURING_CR_VOLTAGE()) return false;

    if (getSPM_e32_NORMAL_VOLT() < rhs.getSPM_e32_NORMAL_VOLT()) return true;
    if (getSPM_e32_NORMAL_VOLT() > rhs.getSPM_e32_NORMAL_VOLT()) return false;

    if (getSPM_e32_Q_CRITICAL() < rhs.getSPM_e32_Q_CRITICAL()) return true;
    if (getSPM_e32_Q_CRITICAL() > rhs.getSPM_e32_Q_CRITICAL()) return false;

    if (getSPM_e32_TRIGGER_RESET() < rhs.getSPM_e32_TRIGGER_RESET()) return true;
    if (getSPM_e32_TRIGGER_RESET() > rhs.getSPM_e32_TRIGGER_RESET()) return false;

    if (getSPM_e32_CAR_WAKEUP() < rhs.getSPM_e32_CAR_WAKEUP()) return true;
    if (getSPM_e32_CAR_WAKEUP() > rhs.getSPM_e32_CAR_WAKEUP()) return false;

    if (getSPM_e32_PHONE_CONNECTED() < rhs.getSPM_e32_PHONE_CONNECTED()) return true;
    if (getSPM_e32_PHONE_CONNECTED() > rhs.getSPM_e32_PHONE_CONNECTED()) return false;

    if (getSPM_e32_CUSTOMER_DOWNLOAD() < rhs.getSPM_e32_CUSTOMER_DOWNLOAD()) return true;
    if (getSPM_e32_CUSTOMER_DOWNLOAD() > rhs.getSPM_e32_CUSTOMER_DOWNLOAD()) return false;

    if (getSPM_e32_STARTUP() < rhs.getSPM_e32_STARTUP()) return true;
    if (getSPM_e32_STARTUP() > rhs.getSPM_e32_STARTUP()) return false;

    if (getSPM_e32_MOST_OFF() < rhs.getSPM_e32_MOST_OFF()) return true;
    if (getSPM_e32_MOST_OFF() > rhs.getSPM_e32_MOST_OFF()) return false;

    if (getSPM_e32_MOST_OFF_ERR() < rhs.getSPM_e32_MOST_OFF_ERR()) return true;
    if (getSPM_e32_MOST_OFF_ERR() > rhs.getSPM_e32_MOST_OFF_ERR()) return false;

    if (getSPM_e32_MOST_WAIT_FOR_SHUTDOWN() < rhs.getSPM_e32_MOST_WAIT_FOR_SHUTDOWN()) return true;
    if (getSPM_e32_MOST_WAIT_FOR_SHUTDOWN() > rhs.getSPM_e32_MOST_WAIT_FOR_SHUTDOWN()) return false;

    if (getSPM_e32_MOST_RBD() < rhs.getSPM_e32_MOST_RBD()) return true;
    if (getSPM_e32_MOST_RBD() > rhs.getSPM_e32_MOST_RBD()) return false;

    if (getSPM_e32_MOST_SHUTDOWN_EXECUTE() < rhs.getSPM_e32_MOST_SHUTDOWN_EXECUTE()) return true;
    if (getSPM_e32_MOST_SHUTDOWN_EXECUTE() > rhs.getSPM_e32_MOST_SHUTDOWN_EXECUTE()) return false;

    if (getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY() < rhs.getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY()) return true;
    if (getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY() > rhs.getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY()) return false;

    if (getSPM_e32_SYSSTATE_NETWORK_FAILED() < rhs.getSPM_e32_SYSSTATE_NETWORK_FAILED()) return true;
    if (getSPM_e32_SYSSTATE_NETWORK_FAILED() > rhs.getSPM_e32_SYSSTATE_NETWORK_FAILED()) return false;

    if (getSPM_e32_SAFE() < rhs.getSPM_e32_SAFE()) return true;
    if (getSPM_e32_SAFE() > rhs.getSPM_e32_SAFE()) return false;

    if (getSPM_e32_FSM_SHUTDOWN_FINISHED() < rhs.getSPM_e32_FSM_SHUTDOWN_FINISHED()) return true;
    if (getSPM_e32_FSM_SHUTDOWN_FINISHED() > rhs.getSPM_e32_FSM_SHUTDOWN_FINISHED()) return false;

    if (getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK() < rhs.getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK()) return true;
    if (getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK() > rhs.getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK()) return false;

    if (getSPM_e32_WAIT_FOR_FSM_RESTART_ACK() < rhs.getSPM_e32_WAIT_FOR_FSM_RESTART_ACK()) return true;
    if (getSPM_e32_WAIT_FOR_FSM_RESTART_ACK() > rhs.getSPM_e32_WAIT_FOR_FSM_RESTART_ACK()) return false;

    return false;
}

inline bool T_b32_SubState2::operator > (const T_b32_SubState2& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_SubState2::setSPM_e32_FRIENDLY_USER (bool SPM_e32_FRIENDLY_USER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FRIENDLY_USER = SPM_e32_FRIENDLY_USER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_FRIENDLY_USER () const {
    return _SPM_e32_FRIENDLY_USER;
}

inline void T_b32_SubState2::setSPM_e32_NISSAN_CMF1 (bool SPM_e32_NISSAN_CMF1) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_NISSAN_CMF1 = SPM_e32_NISSAN_CMF1;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_NISSAN_CMF1 () const {
    return _SPM_e32_NISSAN_CMF1;
}

inline void T_b32_SubState2::setSPM_e32_PREPARE_SHUTDOWN (bool SPM_e32_PREPARE_SHUTDOWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_PREPARE_SHUTDOWN = SPM_e32_PREPARE_SHUTDOWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_PREPARE_SHUTDOWN () const {
    return _SPM_e32_PREPARE_SHUTDOWN;
}

inline void T_b32_SubState2::setSPM_e32_SHUTDOWN (bool SPM_e32_SHUTDOWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SHUTDOWN = SPM_e32_SHUTDOWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_SHUTDOWN () const {
    return _SPM_e32_SHUTDOWN;
}

inline void T_b32_SubState2::setSPM_e32_HKEY_PRESSED (bool SPM_e32_HKEY_PRESSED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_HKEY_PRESSED = SPM_e32_HKEY_PRESSED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_HKEY_PRESSED () const {
    return _SPM_e32_HKEY_PRESSED;
}

inline void T_b32_SubState2::setSPM_e32_CD_INSERT_CLAMPS (bool SPM_e32_CD_INSERT_CLAMPS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CD_INSERT_CLAMPS = SPM_e32_CD_INSERT_CLAMPS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_CD_INSERT_CLAMPS () const {
    return _SPM_e32_CD_INSERT_CLAMPS;
}

inline void T_b32_SubState2::setSPM_e32_CRITICAL_LOW_VOLTAGE (bool SPM_e32_CRITICAL_LOW_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CRITICAL_LOW_VOLTAGE = SPM_e32_CRITICAL_LOW_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_CRITICAL_LOW_VOLTAGE () const {
    return _SPM_e32_CRITICAL_LOW_VOLTAGE;
}

inline void T_b32_SubState2::setSPM_e32_ENDURING_LOW_VOLTAGE (bool SPM_e32_ENDURING_LOW_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ENDURING_LOW_VOLTAGE = SPM_e32_ENDURING_LOW_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_ENDURING_LOW_VOLTAGE () const {
    return _SPM_e32_ENDURING_LOW_VOLTAGE;
}

inline void T_b32_SubState2::setSPM_e32_DIAG_FAST_SHUTDOWN (bool SPM_e32_DIAG_FAST_SHUTDOWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_DIAG_FAST_SHUTDOWN = SPM_e32_DIAG_FAST_SHUTDOWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_DIAG_FAST_SHUTDOWN () const {
    return _SPM_e32_DIAG_FAST_SHUTDOWN;
}

inline void T_b32_SubState2::setSPM_e32_USING_ACCESSORY (bool SPM_e32_USING_ACCESSORY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_USING_ACCESSORY = SPM_e32_USING_ACCESSORY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_USING_ACCESSORY () const {
    return _SPM_e32_USING_ACCESSORY;
}

inline void T_b32_SubState2::setSPM_e32_BACKGROUND_IMM_OFF (bool SPM_e32_BACKGROUND_IMM_OFF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_BACKGROUND_IMM_OFF = SPM_e32_BACKGROUND_IMM_OFF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_BACKGROUND_IMM_OFF () const {
    return _SPM_e32_BACKGROUND_IMM_OFF;
}

inline void T_b32_SubState2::setSPM_e32_ROLLER_RIG_MODE (bool SPM_e32_ROLLER_RIG_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ROLLER_RIG_MODE = SPM_e32_ROLLER_RIG_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_ROLLER_RIG_MODE () const {
    return _SPM_e32_ROLLER_RIG_MODE;
}

inline void T_b32_SubState2::setSPM_e32_REMOTE_ON_ACTIVE (bool SPM_e32_REMOTE_ON_ACTIVE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_REMOTE_ON_ACTIVE = SPM_e32_REMOTE_ON_ACTIVE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_REMOTE_ON_ACTIVE () const {
    return _SPM_e32_REMOTE_ON_ACTIVE;
}

inline void T_b32_SubState2::setSPM_e32_ENDURING_CR_VOLTAGE (bool SPM_e32_ENDURING_CR_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ENDURING_CR_VOLTAGE = SPM_e32_ENDURING_CR_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_ENDURING_CR_VOLTAGE () const {
    return _SPM_e32_ENDURING_CR_VOLTAGE;
}

inline void T_b32_SubState2::setSPM_e32_NORMAL_VOLT (bool SPM_e32_NORMAL_VOLT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_NORMAL_VOLT = SPM_e32_NORMAL_VOLT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_NORMAL_VOLT () const {
    return _SPM_e32_NORMAL_VOLT;
}

inline void T_b32_SubState2::setSPM_e32_Q_CRITICAL (bool SPM_e32_Q_CRITICAL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_Q_CRITICAL = SPM_e32_Q_CRITICAL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_Q_CRITICAL () const {
    return _SPM_e32_Q_CRITICAL;
}

inline void T_b32_SubState2::setSPM_e32_TRIGGER_RESET (bool SPM_e32_TRIGGER_RESET) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TRIGGER_RESET = SPM_e32_TRIGGER_RESET;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_TRIGGER_RESET () const {
    return _SPM_e32_TRIGGER_RESET;
}

inline void T_b32_SubState2::setSPM_e32_CAR_WAKEUP (bool SPM_e32_CAR_WAKEUP) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CAR_WAKEUP = SPM_e32_CAR_WAKEUP;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_CAR_WAKEUP () const {
    return _SPM_e32_CAR_WAKEUP;
}

inline void T_b32_SubState2::setSPM_e32_PHONE_CONNECTED (bool SPM_e32_PHONE_CONNECTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_PHONE_CONNECTED = SPM_e32_PHONE_CONNECTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_PHONE_CONNECTED () const {
    return _SPM_e32_PHONE_CONNECTED;
}

inline void T_b32_SubState2::setSPM_e32_CUSTOMER_DOWNLOAD (bool SPM_e32_CUSTOMER_DOWNLOAD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CUSTOMER_DOWNLOAD = SPM_e32_CUSTOMER_DOWNLOAD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_CUSTOMER_DOWNLOAD () const {
    return _SPM_e32_CUSTOMER_DOWNLOAD;
}

inline void T_b32_SubState2::setSPM_e32_STARTUP (bool SPM_e32_STARTUP) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_STARTUP = SPM_e32_STARTUP;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_STARTUP () const {
    return _SPM_e32_STARTUP;
}

inline void T_b32_SubState2::setSPM_e32_MOST_OFF (bool SPM_e32_MOST_OFF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_OFF = SPM_e32_MOST_OFF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_OFF () const {
    return _SPM_e32_MOST_OFF;
}

inline void T_b32_SubState2::setSPM_e32_MOST_OFF_ERR (bool SPM_e32_MOST_OFF_ERR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_OFF_ERR = SPM_e32_MOST_OFF_ERR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_OFF_ERR () const {
    return _SPM_e32_MOST_OFF_ERR;
}

inline void T_b32_SubState2::setSPM_e32_MOST_WAIT_FOR_SHUTDOWN (bool SPM_e32_MOST_WAIT_FOR_SHUTDOWN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_WAIT_FOR_SHUTDOWN = SPM_e32_MOST_WAIT_FOR_SHUTDOWN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_WAIT_FOR_SHUTDOWN () const {
    return _SPM_e32_MOST_WAIT_FOR_SHUTDOWN;
}

inline void T_b32_SubState2::setSPM_e32_MOST_RBD (bool SPM_e32_MOST_RBD) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_RBD = SPM_e32_MOST_RBD;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_RBD () const {
    return _SPM_e32_MOST_RBD;
}

inline void T_b32_SubState2::setSPM_e32_MOST_SHUTDOWN_EXECUTE (bool SPM_e32_MOST_SHUTDOWN_EXECUTE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_SHUTDOWN_EXECUTE = SPM_e32_MOST_SHUTDOWN_EXECUTE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_SHUTDOWN_EXECUTE () const {
    return _SPM_e32_MOST_SHUTDOWN_EXECUTE;
}

inline void T_b32_SubState2::setSPM_e32_MOST_PWR_SWITCH_OFF_DELAY (bool SPM_e32_MOST_PWR_SWITCH_OFF_DELAY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_MOST_PWR_SWITCH_OFF_DELAY = SPM_e32_MOST_PWR_SWITCH_OFF_DELAY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_MOST_PWR_SWITCH_OFF_DELAY () const {
    return _SPM_e32_MOST_PWR_SWITCH_OFF_DELAY;
}

inline void T_b32_SubState2::setSPM_e32_SYSSTATE_NETWORK_FAILED (bool SPM_e32_SYSSTATE_NETWORK_FAILED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SYSSTATE_NETWORK_FAILED = SPM_e32_SYSSTATE_NETWORK_FAILED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_SYSSTATE_NETWORK_FAILED () const {
    return _SPM_e32_SYSSTATE_NETWORK_FAILED;
}

inline void T_b32_SubState2::setSPM_e32_SAFE (bool SPM_e32_SAFE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_SAFE = SPM_e32_SAFE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_SAFE () const {
    return _SPM_e32_SAFE;
}

inline void T_b32_SubState2::setSPM_e32_FSM_SHUTDOWN_FINISHED (bool SPM_e32_FSM_SHUTDOWN_FINISHED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FSM_SHUTDOWN_FINISHED = SPM_e32_FSM_SHUTDOWN_FINISHED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_FSM_SHUTDOWN_FINISHED () const {
    return _SPM_e32_FSM_SHUTDOWN_FINISHED;
}

inline void T_b32_SubState2::setSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK (bool SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK = SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK () const {
    return _SPM_e32_WAIT_FOR_FSM_SHUTDOWN_ACK;
}

inline void T_b32_SubState2::setSPM_e32_WAIT_FOR_FSM_RESTART_ACK (bool SPM_e32_WAIT_FOR_FSM_RESTART_ACK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_WAIT_FOR_FSM_RESTART_ACK = SPM_e32_WAIT_FOR_FSM_RESTART_ACK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState2::getSPM_e32_WAIT_FOR_FSM_RESTART_ACK () const {
    return _SPM_e32_WAIT_FOR_FSM_RESTART_ACK;
}

inline  T_b32_SubState3::T_b32_SubState3 ()  :
    _SPM_e32_VALET_MODE (false),
    _SPM_e32_CRANK (false),
    _SPM_e32_EMERGENCY_CALL (false),
    _SPM_e32_LIN (false),
    _SPM_e32_CELLNETWORK (false),
    _SPM_e32_EXTERNAL_GPIO (false),
    _SPM_e32_BLUETOOTH (false),
    _SPM_e32_UART (false),
    _SPM_e32_USB (false),
    _SPM_e32_CRITICAL_HIGH_VOLTAGE (false),
    _SPM_e32_ENDURING_HIGH_VOLTAGE (false),
    _SPM_e32_OVER_THE_AIR (false)
{
}

inline  T_b32_SubState3::T_b32_SubState3 (const T_b32_SubState3 &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_SubState3::T_b32_SubState3 (bool SPM_e32_VALET_MODE, bool SPM_e32_CRANK, bool SPM_e32_EMERGENCY_CALL, bool SPM_e32_LIN, bool SPM_e32_CELLNETWORK, bool SPM_e32_EXTERNAL_GPIO, bool SPM_e32_BLUETOOTH, bool SPM_e32_UART, bool SPM_e32_USB, bool SPM_e32_CRITICAL_HIGH_VOLTAGE, bool SPM_e32_ENDURING_HIGH_VOLTAGE, bool SPM_e32_OVER_THE_AIR) :
    _SPM_e32_VALET_MODE (SPM_e32_VALET_MODE),
    _SPM_e32_CRANK (SPM_e32_CRANK),
    _SPM_e32_EMERGENCY_CALL (SPM_e32_EMERGENCY_CALL),
    _SPM_e32_LIN (SPM_e32_LIN),
    _SPM_e32_CELLNETWORK (SPM_e32_CELLNETWORK),
    _SPM_e32_EXTERNAL_GPIO (SPM_e32_EXTERNAL_GPIO),
    _SPM_e32_BLUETOOTH (SPM_e32_BLUETOOTH),
    _SPM_e32_UART (SPM_e32_UART),
    _SPM_e32_USB (SPM_e32_USB),
    _SPM_e32_CRITICAL_HIGH_VOLTAGE (SPM_e32_CRITICAL_HIGH_VOLTAGE),
    _SPM_e32_ENDURING_HIGH_VOLTAGE (SPM_e32_ENDURING_HIGH_VOLTAGE),
    _SPM_e32_OVER_THE_AIR (SPM_e32_OVER_THE_AIR)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_SubState3& T_b32_SubState3::operator = (const T_b32_SubState3& rhs) {
    if( this != &rhs ) {
        _SPM_e32_VALET_MODE = rhs._SPM_e32_VALET_MODE;
        _SPM_e32_CRANK = rhs._SPM_e32_CRANK;
        _SPM_e32_EMERGENCY_CALL = rhs._SPM_e32_EMERGENCY_CALL;
        _SPM_e32_LIN = rhs._SPM_e32_LIN;
        _SPM_e32_CELLNETWORK = rhs._SPM_e32_CELLNETWORK;
        _SPM_e32_EXTERNAL_GPIO = rhs._SPM_e32_EXTERNAL_GPIO;
        _SPM_e32_BLUETOOTH = rhs._SPM_e32_BLUETOOTH;
        _SPM_e32_UART = rhs._SPM_e32_UART;
        _SPM_e32_USB = rhs._SPM_e32_USB;
        _SPM_e32_CRITICAL_HIGH_VOLTAGE = rhs._SPM_e32_CRITICAL_HIGH_VOLTAGE;
        _SPM_e32_ENDURING_HIGH_VOLTAGE = rhs._SPM_e32_ENDURING_HIGH_VOLTAGE;
        _SPM_e32_OVER_THE_AIR = rhs._SPM_e32_OVER_THE_AIR;
    }
    return *this;
}

inline bool T_b32_SubState3::operator == (const T_b32_SubState3& rhs) const {
    return (_SPM_e32_VALET_MODE == rhs._SPM_e32_VALET_MODE &&
        _SPM_e32_CRANK == rhs._SPM_e32_CRANK &&
        _SPM_e32_EMERGENCY_CALL == rhs._SPM_e32_EMERGENCY_CALL &&
        _SPM_e32_LIN == rhs._SPM_e32_LIN &&
        _SPM_e32_CELLNETWORK == rhs._SPM_e32_CELLNETWORK &&
        _SPM_e32_EXTERNAL_GPIO == rhs._SPM_e32_EXTERNAL_GPIO &&
        _SPM_e32_BLUETOOTH == rhs._SPM_e32_BLUETOOTH &&
        _SPM_e32_UART == rhs._SPM_e32_UART &&
        _SPM_e32_USB == rhs._SPM_e32_USB &&
        _SPM_e32_CRITICAL_HIGH_VOLTAGE == rhs._SPM_e32_CRITICAL_HIGH_VOLTAGE &&
        _SPM_e32_ENDURING_HIGH_VOLTAGE == rhs._SPM_e32_ENDURING_HIGH_VOLTAGE &&
        _SPM_e32_OVER_THE_AIR == rhs._SPM_e32_OVER_THE_AIR);
}

inline bool T_b32_SubState3::operator != (const T_b32_SubState3& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_SubState3::operator < (const T_b32_SubState3& rhs) const {
    if (getSPM_e32_VALET_MODE() < rhs.getSPM_e32_VALET_MODE()) return true;
    if (getSPM_e32_VALET_MODE() > rhs.getSPM_e32_VALET_MODE()) return false;

    if (getSPM_e32_CRANK() < rhs.getSPM_e32_CRANK()) return true;
    if (getSPM_e32_CRANK() > rhs.getSPM_e32_CRANK()) return false;

    if (getSPM_e32_EMERGENCY_CALL() < rhs.getSPM_e32_EMERGENCY_CALL()) return true;
    if (getSPM_e32_EMERGENCY_CALL() > rhs.getSPM_e32_EMERGENCY_CALL()) return false;

    if (getSPM_e32_LIN() < rhs.getSPM_e32_LIN()) return true;
    if (getSPM_e32_LIN() > rhs.getSPM_e32_LIN()) return false;

    if (getSPM_e32_CELLNETWORK() < rhs.getSPM_e32_CELLNETWORK()) return true;
    if (getSPM_e32_CELLNETWORK() > rhs.getSPM_e32_CELLNETWORK()) return false;

    if (getSPM_e32_EXTERNAL_GPIO() < rhs.getSPM_e32_EXTERNAL_GPIO()) return true;
    if (getSPM_e32_EXTERNAL_GPIO() > rhs.getSPM_e32_EXTERNAL_GPIO()) return false;

    if (getSPM_e32_BLUETOOTH() < rhs.getSPM_e32_BLUETOOTH()) return true;
    if (getSPM_e32_BLUETOOTH() > rhs.getSPM_e32_BLUETOOTH()) return false;

    if (getSPM_e32_UART() < rhs.getSPM_e32_UART()) return true;
    if (getSPM_e32_UART() > rhs.getSPM_e32_UART()) return false;

    if (getSPM_e32_USB() < rhs.getSPM_e32_USB()) return true;
    if (getSPM_e32_USB() > rhs.getSPM_e32_USB()) return false;

    if (getSPM_e32_CRITICAL_HIGH_VOLTAGE() < rhs.getSPM_e32_CRITICAL_HIGH_VOLTAGE()) return true;
    if (getSPM_e32_CRITICAL_HIGH_VOLTAGE() > rhs.getSPM_e32_CRITICAL_HIGH_VOLTAGE()) return false;

    if (getSPM_e32_ENDURING_HIGH_VOLTAGE() < rhs.getSPM_e32_ENDURING_HIGH_VOLTAGE()) return true;
    if (getSPM_e32_ENDURING_HIGH_VOLTAGE() > rhs.getSPM_e32_ENDURING_HIGH_VOLTAGE()) return false;

    if (getSPM_e32_OVER_THE_AIR() < rhs.getSPM_e32_OVER_THE_AIR()) return true;
    if (getSPM_e32_OVER_THE_AIR() > rhs.getSPM_e32_OVER_THE_AIR()) return false;

    return false;
}

inline bool T_b32_SubState3::operator > (const T_b32_SubState3& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_SubState3::setSPM_e32_VALET_MODE (bool SPM_e32_VALET_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_VALET_MODE = SPM_e32_VALET_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_VALET_MODE () const {
    return _SPM_e32_VALET_MODE;
}

inline void T_b32_SubState3::setSPM_e32_CRANK (bool SPM_e32_CRANK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CRANK = SPM_e32_CRANK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_CRANK () const {
    return _SPM_e32_CRANK;
}

inline void T_b32_SubState3::setSPM_e32_EMERGENCY_CALL (bool SPM_e32_EMERGENCY_CALL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_EMERGENCY_CALL = SPM_e32_EMERGENCY_CALL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_EMERGENCY_CALL () const {
    return _SPM_e32_EMERGENCY_CALL;
}

inline void T_b32_SubState3::setSPM_e32_LIN (bool SPM_e32_LIN) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_LIN = SPM_e32_LIN;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_LIN () const {
    return _SPM_e32_LIN;
}

inline void T_b32_SubState3::setSPM_e32_CELLNETWORK (bool SPM_e32_CELLNETWORK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CELLNETWORK = SPM_e32_CELLNETWORK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_CELLNETWORK () const {
    return _SPM_e32_CELLNETWORK;
}

inline void T_b32_SubState3::setSPM_e32_EXTERNAL_GPIO (bool SPM_e32_EXTERNAL_GPIO) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_EXTERNAL_GPIO = SPM_e32_EXTERNAL_GPIO;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_EXTERNAL_GPIO () const {
    return _SPM_e32_EXTERNAL_GPIO;
}

inline void T_b32_SubState3::setSPM_e32_BLUETOOTH (bool SPM_e32_BLUETOOTH) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_BLUETOOTH = SPM_e32_BLUETOOTH;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_BLUETOOTH () const {
    return _SPM_e32_BLUETOOTH;
}

inline void T_b32_SubState3::setSPM_e32_UART (bool SPM_e32_UART) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_UART = SPM_e32_UART;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_UART () const {
    return _SPM_e32_UART;
}

inline void T_b32_SubState3::setSPM_e32_USB (bool SPM_e32_USB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_USB = SPM_e32_USB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_USB () const {
    return _SPM_e32_USB;
}

inline void T_b32_SubState3::setSPM_e32_CRITICAL_HIGH_VOLTAGE (bool SPM_e32_CRITICAL_HIGH_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_CRITICAL_HIGH_VOLTAGE = SPM_e32_CRITICAL_HIGH_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_CRITICAL_HIGH_VOLTAGE () const {
    return _SPM_e32_CRITICAL_HIGH_VOLTAGE;
}

inline void T_b32_SubState3::setSPM_e32_ENDURING_HIGH_VOLTAGE (bool SPM_e32_ENDURING_HIGH_VOLTAGE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ENDURING_HIGH_VOLTAGE = SPM_e32_ENDURING_HIGH_VOLTAGE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_ENDURING_HIGH_VOLTAGE () const {
    return _SPM_e32_ENDURING_HIGH_VOLTAGE;
}

inline void T_b32_SubState3::setSPM_e32_OVER_THE_AIR (bool SPM_e32_OVER_THE_AIR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_OVER_THE_AIR = SPM_e32_OVER_THE_AIR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_SubState3::getSPM_e32_OVER_THE_AIR () const {
    return _SPM_e32_OVER_THE_AIR;
}

inline  T_SPM_b32_DIM_STATE::T_SPM_b32_DIM_STATE ()  :
    _SPM_U32_DIMMINGSTATE (false),
    _SPM_U32_DIMSMINGTATE_CLIMATE (false),
    _SPM_U32_DIMMINGSTATE_BACKLIGHT (false),
    _SPM_U32_DIMMINGSTATE_HOUR_MODE (false),
    _SPM_U32_DIMMINGSTATE_ALL_OFF (false),
    _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF (false),
    _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED (false),
    _SPM_U32DIMMINGSTATE_ALL_ON (false)
{
}

inline  T_SPM_b32_DIM_STATE::T_SPM_b32_DIM_STATE (const T_SPM_b32_DIM_STATE &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_SPM_b32_DIM_STATE::T_SPM_b32_DIM_STATE (bool SPM_U32_DIMMINGSTATE, bool SPM_U32_DIMSMINGTATE_CLIMATE, bool SPM_U32_DIMMINGSTATE_BACKLIGHT, bool SPM_U32_DIMMINGSTATE_HOUR_MODE, bool SPM_U32_DIMMINGSTATE_ALL_OFF, bool SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF, bool SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED, bool SPM_U32DIMMINGSTATE_ALL_ON) :
    _SPM_U32_DIMMINGSTATE (SPM_U32_DIMMINGSTATE),
    _SPM_U32_DIMSMINGTATE_CLIMATE (SPM_U32_DIMSMINGTATE_CLIMATE),
    _SPM_U32_DIMMINGSTATE_BACKLIGHT (SPM_U32_DIMMINGSTATE_BACKLIGHT),
    _SPM_U32_DIMMINGSTATE_HOUR_MODE (SPM_U32_DIMMINGSTATE_HOUR_MODE),
    _SPM_U32_DIMMINGSTATE_ALL_OFF (SPM_U32_DIMMINGSTATE_ALL_OFF),
    _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF (SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF),
    _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED (SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED),
    _SPM_U32DIMMINGSTATE_ALL_ON (SPM_U32DIMMINGSTATE_ALL_ON)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_SPM_b32_DIM_STATE& T_SPM_b32_DIM_STATE::operator = (const T_SPM_b32_DIM_STATE& rhs) {
    if( this != &rhs ) {
        _SPM_U32_DIMMINGSTATE = rhs._SPM_U32_DIMMINGSTATE;
        _SPM_U32_DIMSMINGTATE_CLIMATE = rhs._SPM_U32_DIMSMINGTATE_CLIMATE;
        _SPM_U32_DIMMINGSTATE_BACKLIGHT = rhs._SPM_U32_DIMMINGSTATE_BACKLIGHT;
        _SPM_U32_DIMMINGSTATE_HOUR_MODE = rhs._SPM_U32_DIMMINGSTATE_HOUR_MODE;
        _SPM_U32_DIMMINGSTATE_ALL_OFF = rhs._SPM_U32_DIMMINGSTATE_ALL_OFF;
        _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF = rhs._SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF;
        _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED = rhs._SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED;
        _SPM_U32DIMMINGSTATE_ALL_ON = rhs._SPM_U32DIMMINGSTATE_ALL_ON;
    }
    return *this;
}

inline bool T_SPM_b32_DIM_STATE::operator == (const T_SPM_b32_DIM_STATE& rhs) const {
    return (_SPM_U32_DIMMINGSTATE == rhs._SPM_U32_DIMMINGSTATE &&
        _SPM_U32_DIMSMINGTATE_CLIMATE == rhs._SPM_U32_DIMSMINGTATE_CLIMATE &&
        _SPM_U32_DIMMINGSTATE_BACKLIGHT == rhs._SPM_U32_DIMMINGSTATE_BACKLIGHT &&
        _SPM_U32_DIMMINGSTATE_HOUR_MODE == rhs._SPM_U32_DIMMINGSTATE_HOUR_MODE &&
        _SPM_U32_DIMMINGSTATE_ALL_OFF == rhs._SPM_U32_DIMMINGSTATE_ALL_OFF &&
        _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF == rhs._SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF &&
        _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED == rhs._SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED &&
        _SPM_U32DIMMINGSTATE_ALL_ON == rhs._SPM_U32DIMMINGSTATE_ALL_ON);
}

inline bool T_SPM_b32_DIM_STATE::operator != (const T_SPM_b32_DIM_STATE& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_b32_DIM_STATE::operator < (const T_SPM_b32_DIM_STATE& rhs) const {
    if (getSPM_U32_DIMMINGSTATE() < rhs.getSPM_U32_DIMMINGSTATE()) return true;
    if (getSPM_U32_DIMMINGSTATE() > rhs.getSPM_U32_DIMMINGSTATE()) return false;

    if (getSPM_U32_DIMSMINGTATE_CLIMATE() < rhs.getSPM_U32_DIMSMINGTATE_CLIMATE()) return true;
    if (getSPM_U32_DIMSMINGTATE_CLIMATE() > rhs.getSPM_U32_DIMSMINGTATE_CLIMATE()) return false;

    if (getSPM_U32_DIMMINGSTATE_BACKLIGHT() < rhs.getSPM_U32_DIMMINGSTATE_BACKLIGHT()) return true;
    if (getSPM_U32_DIMMINGSTATE_BACKLIGHT() > rhs.getSPM_U32_DIMMINGSTATE_BACKLIGHT()) return false;

    if (getSPM_U32_DIMMINGSTATE_HOUR_MODE() < rhs.getSPM_U32_DIMMINGSTATE_HOUR_MODE()) return true;
    if (getSPM_U32_DIMMINGSTATE_HOUR_MODE() > rhs.getSPM_U32_DIMMINGSTATE_HOUR_MODE()) return false;

    if (getSPM_U32_DIMMINGSTATE_ALL_OFF() < rhs.getSPM_U32_DIMMINGSTATE_ALL_OFF()) return true;
    if (getSPM_U32_DIMMINGSTATE_ALL_OFF() > rhs.getSPM_U32_DIMMINGSTATE_ALL_OFF()) return false;

    if (getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF() < rhs.getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF()) return true;
    if (getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF() > rhs.getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF()) return false;

    if (getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED() < rhs.getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED()) return true;
    if (getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED() > rhs.getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED()) return false;

    if (getSPM_U32DIMMINGSTATE_ALL_ON() < rhs.getSPM_U32DIMMINGSTATE_ALL_ON()) return true;
    if (getSPM_U32DIMMINGSTATE_ALL_ON() > rhs.getSPM_U32DIMMINGSTATE_ALL_ON()) return false;

    return false;
}

inline bool T_SPM_b32_DIM_STATE::operator > (const T_SPM_b32_DIM_STATE& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE (bool SPM_U32_DIMMINGSTATE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE = SPM_U32_DIMMINGSTATE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE () const {
    return _SPM_U32_DIMMINGSTATE;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMSMINGTATE_CLIMATE (bool SPM_U32_DIMSMINGTATE_CLIMATE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMSMINGTATE_CLIMATE = SPM_U32_DIMSMINGTATE_CLIMATE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMSMINGTATE_CLIMATE () const {
    return _SPM_U32_DIMSMINGTATE_CLIMATE;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE_BACKLIGHT (bool SPM_U32_DIMMINGSTATE_BACKLIGHT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE_BACKLIGHT = SPM_U32_DIMMINGSTATE_BACKLIGHT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE_BACKLIGHT () const {
    return _SPM_U32_DIMMINGSTATE_BACKLIGHT;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE_HOUR_MODE (bool SPM_U32_DIMMINGSTATE_HOUR_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE_HOUR_MODE = SPM_U32_DIMMINGSTATE_HOUR_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE_HOUR_MODE () const {
    return _SPM_U32_DIMMINGSTATE_HOUR_MODE;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE_ALL_OFF (bool SPM_U32_DIMMINGSTATE_ALL_OFF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE_ALL_OFF = SPM_U32_DIMMINGSTATE_ALL_OFF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE_ALL_OFF () const {
    return _SPM_U32_DIMMINGSTATE_ALL_OFF;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF (bool SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF = SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF () const {
    return _SPM_U32_DIMMINGSTATE_TLIN_ON_BACKLIGHT_OFF;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED (bool SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED = SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED () const {
    return _SPM_U32_DIMMINGSTATE_TLIN_OFF_BACKLIGHT_UNCHANGED;
}

inline void T_SPM_b32_DIM_STATE::setSPM_U32DIMMINGSTATE_ALL_ON (bool SPM_U32DIMMINGSTATE_ALL_ON) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_U32DIMMINGSTATE_ALL_ON = SPM_U32DIMMINGSTATE_ALL_ON;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_DIM_STATE::getSPM_U32DIMMINGSTATE_ALL_ON () const {
    return _SPM_U32DIMMINGSTATE_ALL_ON;
}

inline  T_SPM_HistoryTrigger::T_SPM_HistoryTrigger ()  :
    _u32Timestamp (0u),
    _eTriggerType (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_HistoryTrigger::T_SPM_HistoryTrigger (const T_SPM_HistoryTrigger &rhs)  :
    _u32Timestamp (0u),
    _eTriggerType (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_HistoryTrigger::T_SPM_HistoryTrigger (uint32 u32Timestamp_, T_SPM_e32_SubStateType eTriggerType_)  :
    _u32Timestamp (u32Timestamp_),
    _eTriggerType (eTriggerType_)
{
    #ifndef NDEBUG
    if (!(T_SPM_e32_SubStateType_IsValid(eTriggerType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eTriggerType_, "T_SPM_e32_SubStateType", "eTriggerType", "T_SPM_HistoryTrigger");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_HistoryTrigger::~T_SPM_HistoryTrigger() {
}

inline T_SPM_HistoryTrigger& T_SPM_HistoryTrigger::operator = (const T_SPM_HistoryTrigger& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32Timestamp()) {
            setU32Timestamp(rhs.getU32Timestamp());
        } else {
            clearU32Timestamp();
        }
        if (rhs.hasETriggerType()) {
            setETriggerType(rhs.getETriggerType());
        } else {
            clearETriggerType();
        }
    }
    return *this;
}

inline bool T_SPM_HistoryTrigger::operator == (const T_SPM_HistoryTrigger& rhs) const {
    return (((!hasU32Timestamp() && !rhs.hasU32Timestamp()) || getU32Timestamp() == rhs.getU32Timestamp()) &&
        ((!hasETriggerType() && !rhs.hasETriggerType()) || getETriggerType() == rhs.getETriggerType()));
}

inline bool T_SPM_HistoryTrigger::operator != (const T_SPM_HistoryTrigger& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_HistoryTrigger::operator < (const T_SPM_HistoryTrigger& rhs) const {
    if (hasU32Timestamp() || rhs.hasU32Timestamp()) {
        if (getU32Timestamp() < rhs.getU32Timestamp()) return true;
        if (getU32Timestamp() > rhs.getU32Timestamp()) return false;
    }
    if (hasETriggerType() || rhs.hasETriggerType()) {
        if ((uint32)getETriggerType() < (uint32)rhs.getETriggerType()) return true;
        if ((uint32)getETriggerType() > (uint32)rhs.getETriggerType()) return false;
    }
    return false;
}

inline bool T_SPM_HistoryTrigger::operator > (const T_SPM_HistoryTrigger& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_HistoryTrigger::clear() {
    clearU32Timestamp();
    clearETriggerType();
}

inline void T_SPM_HistoryTrigger::clearU32Timestamp() {
    if (hasU32Timestamp()) {
         clear_has_u32Timestamp();
        _u32Timestamp = 0u;
     }
}

inline bool T_SPM_HistoryTrigger::hasU32Timestamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SPM_HistoryTrigger::getU32Timestamp () const {
    return _u32Timestamp;
}

inline void T_SPM_HistoryTrigger::setU32Timestamp (uint32 u32Timestamp_) {
    set_has_u32Timestamp();
    this->_u32Timestamp = u32Timestamp_;
}

inline void T_SPM_HistoryTrigger::clearETriggerType() {
    if (hasETriggerType()) {
         clear_has_eTriggerType();
        _eTriggerType = ::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS;
     }
}

inline bool T_SPM_HistoryTrigger::hasETriggerType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_SPM_e32_SubStateType T_SPM_HistoryTrigger::getETriggerType () const {
    return _eTriggerType;
}

inline void T_SPM_HistoryTrigger::setETriggerType (T_SPM_e32_SubStateType eTriggerType_) {
    #ifndef NDEBUG
    if (!(T_SPM_e32_SubStateType_IsValid(eTriggerType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eTriggerType_, "T_SPM_e32_SubStateType", "eTriggerType", "T_SPM_HistoryTrigger");
    }
    #endif
    set_has_eTriggerType();
    this->_eTriggerType = eTriggerType_;
}

inline void T_SPM_HistoryTrigger::set_has_u32Timestamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_HistoryTrigger::clear_has_u32Timestamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_HistoryTrigger::set_has_eTriggerType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_HistoryTrigger::clear_has_eTriggerType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SPM_TransPortMode::T_SPM_TransPortMode ()  :
    _YEAR (0u),
    _MONTH (0u),
    _DAY (0u),
    _HOUR (0u),
    _MINUTE (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_TransPortMode::T_SPM_TransPortMode (const T_SPM_TransPortMode &rhs)  :
    _YEAR (0u),
    _MONTH (0u),
    _DAY (0u),
    _HOUR (0u),
    _MINUTE (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_TransPortMode::T_SPM_TransPortMode (uint32 YEAR_, uint32 MONTH_, uint32 DAY_, uint32 HOUR_, uint32 MINUTE_)  :
    _YEAR (YEAR_),
    _MONTH (MONTH_),
    _DAY (DAY_),
    _HOUR (HOUR_),
    _MINUTE (MINUTE_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_TransPortMode::~T_SPM_TransPortMode() {
}

inline T_SPM_TransPortMode& T_SPM_TransPortMode::operator = (const T_SPM_TransPortMode& rhs) {
    if( this != &rhs ) {
        if (rhs.hasYEAR()) {
            setYEAR(rhs.getYEAR());
        } else {
            clearYEAR();
        }
        if (rhs.hasMONTH()) {
            setMONTH(rhs.getMONTH());
        } else {
            clearMONTH();
        }
        if (rhs.hasDAY()) {
            setDAY(rhs.getDAY());
        } else {
            clearDAY();
        }
        if (rhs.hasHOUR()) {
            setHOUR(rhs.getHOUR());
        } else {
            clearHOUR();
        }
        if (rhs.hasMINUTE()) {
            setMINUTE(rhs.getMINUTE());
        } else {
            clearMINUTE();
        }
    }
    return *this;
}

inline bool T_SPM_TransPortMode::operator == (const T_SPM_TransPortMode& rhs) const {
    return (((!hasYEAR() && !rhs.hasYEAR()) || getYEAR() == rhs.getYEAR()) &&
        ((!hasMONTH() && !rhs.hasMONTH()) || getMONTH() == rhs.getMONTH()) &&
        ((!hasDAY() && !rhs.hasDAY()) || getDAY() == rhs.getDAY()) &&
        ((!hasHOUR() && !rhs.hasHOUR()) || getHOUR() == rhs.getHOUR()) &&
        ((!hasMINUTE() && !rhs.hasMINUTE()) || getMINUTE() == rhs.getMINUTE()));
}

inline bool T_SPM_TransPortMode::operator != (const T_SPM_TransPortMode& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_TransPortMode::operator < (const T_SPM_TransPortMode& rhs) const {
    if (hasYEAR() || rhs.hasYEAR()) {
        if (getYEAR() < rhs.getYEAR()) return true;
        if (getYEAR() > rhs.getYEAR()) return false;
    }
    if (hasMONTH() || rhs.hasMONTH()) {
        if (getMONTH() < rhs.getMONTH()) return true;
        if (getMONTH() > rhs.getMONTH()) return false;
    }
    if (hasDAY() || rhs.hasDAY()) {
        if (getDAY() < rhs.getDAY()) return true;
        if (getDAY() > rhs.getDAY()) return false;
    }
    if (hasHOUR() || rhs.hasHOUR()) {
        if (getHOUR() < rhs.getHOUR()) return true;
        if (getHOUR() > rhs.getHOUR()) return false;
    }
    if (hasMINUTE() || rhs.hasMINUTE()) {
        if (getMINUTE() < rhs.getMINUTE()) return true;
        if (getMINUTE() > rhs.getMINUTE()) return false;
    }
    return false;
}

inline bool T_SPM_TransPortMode::operator > (const T_SPM_TransPortMode& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_TransPortMode::clear() {
    clearYEAR();
    clearMONTH();
    clearDAY();
    clearHOUR();
    clearMINUTE();
}

inline void T_SPM_TransPortMode::clearYEAR() {
    if (hasYEAR()) {
         clear_has_YEAR();
        _YEAR = 0u;
     }
}

inline bool T_SPM_TransPortMode::hasYEAR () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SPM_TransPortMode::getYEAR () const {
    return _YEAR;
}

inline void T_SPM_TransPortMode::setYEAR (uint32 YEAR_) {
    set_has_YEAR();
    this->_YEAR = YEAR_;
}

inline void T_SPM_TransPortMode::clearMONTH() {
    if (hasMONTH()) {
         clear_has_MONTH();
        _MONTH = 0u;
     }
}

inline bool T_SPM_TransPortMode::hasMONTH () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SPM_TransPortMode::getMONTH () const {
    return _MONTH;
}

inline void T_SPM_TransPortMode::setMONTH (uint32 MONTH_) {
    set_has_MONTH();
    this->_MONTH = MONTH_;
}

inline void T_SPM_TransPortMode::clearDAY() {
    if (hasDAY()) {
         clear_has_DAY();
        _DAY = 0u;
     }
}

inline bool T_SPM_TransPortMode::hasDAY () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SPM_TransPortMode::getDAY () const {
    return _DAY;
}

inline void T_SPM_TransPortMode::setDAY (uint32 DAY_) {
    set_has_DAY();
    this->_DAY = DAY_;
}

inline void T_SPM_TransPortMode::clearHOUR() {
    if (hasHOUR()) {
         clear_has_HOUR();
        _HOUR = 0u;
     }
}

inline bool T_SPM_TransPortMode::hasHOUR () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SPM_TransPortMode::getHOUR () const {
    return _HOUR;
}

inline void T_SPM_TransPortMode::setHOUR (uint32 HOUR_) {
    set_has_HOUR();
    this->_HOUR = HOUR_;
}

inline void T_SPM_TransPortMode::clearMINUTE() {
    if (hasMINUTE()) {
         clear_has_MINUTE();
        _MINUTE = 0u;
     }
}

inline bool T_SPM_TransPortMode::hasMINUTE () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_SPM_TransPortMode::getMINUTE () const {
    return _MINUTE;
}

inline void T_SPM_TransPortMode::setMINUTE (uint32 MINUTE_) {
    set_has_MINUTE();
    this->_MINUTE = MINUTE_;
}

inline void T_SPM_TransPortMode::set_has_YEAR () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_TransPortMode::clear_has_YEAR () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_TransPortMode::set_has_MONTH () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_TransPortMode::clear_has_MONTH () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_TransPortMode::set_has_DAY () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_TransPortMode::clear_has_DAY () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_TransPortMode::set_has_HOUR () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_TransPortMode::clear_has_HOUR () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SPM_TransPortMode::set_has_MINUTE () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SPM_TransPortMode::clear_has_MINUTE () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SubStateEntry::T_SubStateEntry ()  :
    _tSubStateMask0 (NULL),
    _tSubStateData0 (NULL),
    _tSubStateMask1 (NULL),
    _tSubStateData1 (NULL),
    _tSubStateMask2 (NULL),
    _tSubStateData2 (NULL),
    _tSubStateMask3 (NULL),
    _tSubStateData3 (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SubStateEntry::T_SubStateEntry (const T_SubStateEntry &rhs)  :
    _tSubStateMask0 (NULL),
    _tSubStateData0 (NULL),
    _tSubStateMask1 (NULL),
    _tSubStateData1 (NULL),
    _tSubStateMask2 (NULL),
    _tSubStateData2 (NULL),
    _tSubStateMask3 (NULL),
    _tSubStateData3 (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SubStateEntry::T_SubStateEntry (const T_b32_SubState0& tSubStateMask0_, const T_b32_SubState0& tSubStateData0_, const T_b32_SubState1& tSubStateMask1_, const T_b32_SubState1& tSubStateData1_, const T_b32_SubState2& tSubStateMask2_, const T_b32_SubState2& tSubStateData2_, const T_b32_SubState3& tSubStateMask3_, const T_b32_SubState3& tSubStateData3_)  :
    _tSubStateMask0 (new T_b32_SubState0(tSubStateMask0_)),
    _tSubStateData0 (new T_b32_SubState0(tSubStateData0_)),
    _tSubStateMask1 (new T_b32_SubState1(tSubStateMask1_)),
    _tSubStateData1 (new T_b32_SubState1(tSubStateData1_)),
    _tSubStateMask2 (new T_b32_SubState2(tSubStateMask2_)),
    _tSubStateData2 (new T_b32_SubState2(tSubStateData2_)),
    _tSubStateMask3 (new T_b32_SubState3(tSubStateMask3_)),
    _tSubStateData3 (new T_b32_SubState3(tSubStateData3_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SubStateEntry::~T_SubStateEntry() {
    delete _tSubStateMask0;
    delete _tSubStateData0;
    delete _tSubStateMask1;
    delete _tSubStateData1;
    delete _tSubStateMask2;
    delete _tSubStateData2;
    delete _tSubStateMask3;
    delete _tSubStateData3;
}

inline T_SubStateEntry& T_SubStateEntry::operator = (const T_SubStateEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTSubStateMask0()) {
            setTSubStateMask0(rhs.getTSubStateMask0());
        } else {
            clearTSubStateMask0();
        }
        if (rhs.hasTSubStateData0()) {
            setTSubStateData0(rhs.getTSubStateData0());
        } else {
            clearTSubStateData0();
        }
        if (rhs.hasTSubStateMask1()) {
            setTSubStateMask1(rhs.getTSubStateMask1());
        } else {
            clearTSubStateMask1();
        }
        if (rhs.hasTSubStateData1()) {
            setTSubStateData1(rhs.getTSubStateData1());
        } else {
            clearTSubStateData1();
        }
        if (rhs.hasTSubStateMask2()) {
            setTSubStateMask2(rhs.getTSubStateMask2());
        } else {
            clearTSubStateMask2();
        }
        if (rhs.hasTSubStateData2()) {
            setTSubStateData2(rhs.getTSubStateData2());
        } else {
            clearTSubStateData2();
        }
        if (rhs.hasTSubStateMask3()) {
            setTSubStateMask3(rhs.getTSubStateMask3());
        } else {
            clearTSubStateMask3();
        }
        if (rhs.hasTSubStateData3()) {
            setTSubStateData3(rhs.getTSubStateData3());
        } else {
            clearTSubStateData3();
        }
    }
    return *this;
}

inline bool T_SubStateEntry::operator == (const T_SubStateEntry& rhs) const {
    return (((!hasTSubStateMask0() && !rhs.hasTSubStateMask0()) || getTSubStateMask0() == rhs.getTSubStateMask0()) &&
        ((!hasTSubStateData0() && !rhs.hasTSubStateData0()) || getTSubStateData0() == rhs.getTSubStateData0()) &&
        ((!hasTSubStateMask1() && !rhs.hasTSubStateMask1()) || getTSubStateMask1() == rhs.getTSubStateMask1()) &&
        ((!hasTSubStateData1() && !rhs.hasTSubStateData1()) || getTSubStateData1() == rhs.getTSubStateData1()) &&
        ((!hasTSubStateMask2() && !rhs.hasTSubStateMask2()) || getTSubStateMask2() == rhs.getTSubStateMask2()) &&
        ((!hasTSubStateData2() && !rhs.hasTSubStateData2()) || getTSubStateData2() == rhs.getTSubStateData2()) &&
        ((!hasTSubStateMask3() && !rhs.hasTSubStateMask3()) || getTSubStateMask3() == rhs.getTSubStateMask3()) &&
        ((!hasTSubStateData3() && !rhs.hasTSubStateData3()) || getTSubStateData3() == rhs.getTSubStateData3()));
}

inline bool T_SubStateEntry::operator != (const T_SubStateEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SubStateEntry::operator < (const T_SubStateEntry& rhs) const {
    if (hasTSubStateMask0() || rhs.hasTSubStateMask0()) {
        if (getTSubStateMask0() < rhs.getTSubStateMask0()) return true;
        if (getTSubStateMask0() > rhs.getTSubStateMask0()) return false;
    }
    if (hasTSubStateData0() || rhs.hasTSubStateData0()) {
        if (getTSubStateData0() < rhs.getTSubStateData0()) return true;
        if (getTSubStateData0() > rhs.getTSubStateData0()) return false;
    }
    if (hasTSubStateMask1() || rhs.hasTSubStateMask1()) {
        if (getTSubStateMask1() < rhs.getTSubStateMask1()) return true;
        if (getTSubStateMask1() > rhs.getTSubStateMask1()) return false;
    }
    if (hasTSubStateData1() || rhs.hasTSubStateData1()) {
        if (getTSubStateData1() < rhs.getTSubStateData1()) return true;
        if (getTSubStateData1() > rhs.getTSubStateData1()) return false;
    }
    if (hasTSubStateMask2() || rhs.hasTSubStateMask2()) {
        if (getTSubStateMask2() < rhs.getTSubStateMask2()) return true;
        if (getTSubStateMask2() > rhs.getTSubStateMask2()) return false;
    }
    if (hasTSubStateData2() || rhs.hasTSubStateData2()) {
        if (getTSubStateData2() < rhs.getTSubStateData2()) return true;
        if (getTSubStateData2() > rhs.getTSubStateData2()) return false;
    }
    if (hasTSubStateMask3() || rhs.hasTSubStateMask3()) {
        if (getTSubStateMask3() < rhs.getTSubStateMask3()) return true;
        if (getTSubStateMask3() > rhs.getTSubStateMask3()) return false;
    }
    if (hasTSubStateData3() || rhs.hasTSubStateData3()) {
        if (getTSubStateData3() < rhs.getTSubStateData3()) return true;
        if (getTSubStateData3() > rhs.getTSubStateData3()) return false;
    }
    return false;
}

inline bool T_SubStateEntry::operator > (const T_SubStateEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SubStateEntry::clear() {
    clearTSubStateMask0();
    clearTSubStateData0();
    clearTSubStateMask1();
    clearTSubStateData1();
    clearTSubStateMask2();
    clearTSubStateData2();
    clearTSubStateMask3();
    clearTSubStateData3();
}

inline void T_SubStateEntry::clearTSubStateMask0() {
    if (hasTSubStateMask0()) {
         clear_has_tSubStateMask0();
        delete _tSubStateMask0;
        _tSubStateMask0 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateMask0 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_b32_SubState0& T_SubStateEntry::getTSubStateMask0 () const {
    if (_tSubStateMask0 == NULL) {
        return T_b32_SubState0::getDefaultInstance();
    }
    return *_tSubStateMask0;
}

inline T_b32_SubState0& T_SubStateEntry::getTSubStateMask0Mutable () {
    set_has_tSubStateMask0();
    if (_tSubStateMask0 == NULL) {
        _tSubStateMask0 = new T_b32_SubState0 ();
        CHECK_ALLOCATION( _tSubStateMask0 );
    }
    return *_tSubStateMask0;
}

inline void T_SubStateEntry::setTSubStateMask0 (const T_b32_SubState0& tSubStateMask0_) {
    set_has_tSubStateMask0();
    if (this->_tSubStateMask0 == NULL) {
        this->_tSubStateMask0 = new T_b32_SubState0 (tSubStateMask0_);
        CHECK_ALLOCATION( this->_tSubStateMask0 );
    } else {
        *this->_tSubStateMask0 = tSubStateMask0_;
    }
}

inline T_b32_SubState0* T_SubStateEntry::releaseTSubStateMask0() {
    clear_has_tSubStateMask0();
    T_b32_SubState0* temp = _tSubStateMask0;
    this->_tSubStateMask0 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateMask0 (T_b32_SubState0* tSubStateMask0_) {
    set_has_tSubStateMask0();
    if (this->_tSubStateMask0 != tSubStateMask0_) {
        if (this->_tSubStateMask0 != NULL) {
            delete this->_tSubStateMask0;
        }
        this->_tSubStateMask0 = tSubStateMask0_;
    }
}

inline void T_SubStateEntry::clearTSubStateData0() {
    if (hasTSubStateData0()) {
         clear_has_tSubStateData0();
        delete _tSubStateData0;
        _tSubStateData0 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateData0 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b32_SubState0& T_SubStateEntry::getTSubStateData0 () const {
    if (_tSubStateData0 == NULL) {
        return T_b32_SubState0::getDefaultInstance();
    }
    return *_tSubStateData0;
}

inline T_b32_SubState0& T_SubStateEntry::getTSubStateData0Mutable () {
    set_has_tSubStateData0();
    if (_tSubStateData0 == NULL) {
        _tSubStateData0 = new T_b32_SubState0 ();
        CHECK_ALLOCATION( _tSubStateData0 );
    }
    return *_tSubStateData0;
}

inline void T_SubStateEntry::setTSubStateData0 (const T_b32_SubState0& tSubStateData0_) {
    set_has_tSubStateData0();
    if (this->_tSubStateData0 == NULL) {
        this->_tSubStateData0 = new T_b32_SubState0 (tSubStateData0_);
        CHECK_ALLOCATION( this->_tSubStateData0 );
    } else {
        *this->_tSubStateData0 = tSubStateData0_;
    }
}

inline T_b32_SubState0* T_SubStateEntry::releaseTSubStateData0() {
    clear_has_tSubStateData0();
    T_b32_SubState0* temp = _tSubStateData0;
    this->_tSubStateData0 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateData0 (T_b32_SubState0* tSubStateData0_) {
    set_has_tSubStateData0();
    if (this->_tSubStateData0 != tSubStateData0_) {
        if (this->_tSubStateData0 != NULL) {
            delete this->_tSubStateData0;
        }
        this->_tSubStateData0 = tSubStateData0_;
    }
}

inline void T_SubStateEntry::clearTSubStateMask1() {
    if (hasTSubStateMask1()) {
         clear_has_tSubStateMask1();
        delete _tSubStateMask1;
        _tSubStateMask1 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateMask1 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_b32_SubState1& T_SubStateEntry::getTSubStateMask1 () const {
    if (_tSubStateMask1 == NULL) {
        return T_b32_SubState1::getDefaultInstance();
    }
    return *_tSubStateMask1;
}

inline T_b32_SubState1& T_SubStateEntry::getTSubStateMask1Mutable () {
    set_has_tSubStateMask1();
    if (_tSubStateMask1 == NULL) {
        _tSubStateMask1 = new T_b32_SubState1 ();
        CHECK_ALLOCATION( _tSubStateMask1 );
    }
    return *_tSubStateMask1;
}

inline void T_SubStateEntry::setTSubStateMask1 (const T_b32_SubState1& tSubStateMask1_) {
    set_has_tSubStateMask1();
    if (this->_tSubStateMask1 == NULL) {
        this->_tSubStateMask1 = new T_b32_SubState1 (tSubStateMask1_);
        CHECK_ALLOCATION( this->_tSubStateMask1 );
    } else {
        *this->_tSubStateMask1 = tSubStateMask1_;
    }
}

inline T_b32_SubState1* T_SubStateEntry::releaseTSubStateMask1() {
    clear_has_tSubStateMask1();
    T_b32_SubState1* temp = _tSubStateMask1;
    this->_tSubStateMask1 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateMask1 (T_b32_SubState1* tSubStateMask1_) {
    set_has_tSubStateMask1();
    if (this->_tSubStateMask1 != tSubStateMask1_) {
        if (this->_tSubStateMask1 != NULL) {
            delete this->_tSubStateMask1;
        }
        this->_tSubStateMask1 = tSubStateMask1_;
    }
}

inline void T_SubStateEntry::clearTSubStateData1() {
    if (hasTSubStateData1()) {
         clear_has_tSubStateData1();
        delete _tSubStateData1;
        _tSubStateData1 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateData1 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b32_SubState1& T_SubStateEntry::getTSubStateData1 () const {
    if (_tSubStateData1 == NULL) {
        return T_b32_SubState1::getDefaultInstance();
    }
    return *_tSubStateData1;
}

inline T_b32_SubState1& T_SubStateEntry::getTSubStateData1Mutable () {
    set_has_tSubStateData1();
    if (_tSubStateData1 == NULL) {
        _tSubStateData1 = new T_b32_SubState1 ();
        CHECK_ALLOCATION( _tSubStateData1 );
    }
    return *_tSubStateData1;
}

inline void T_SubStateEntry::setTSubStateData1 (const T_b32_SubState1& tSubStateData1_) {
    set_has_tSubStateData1();
    if (this->_tSubStateData1 == NULL) {
        this->_tSubStateData1 = new T_b32_SubState1 (tSubStateData1_);
        CHECK_ALLOCATION( this->_tSubStateData1 );
    } else {
        *this->_tSubStateData1 = tSubStateData1_;
    }
}

inline T_b32_SubState1* T_SubStateEntry::releaseTSubStateData1() {
    clear_has_tSubStateData1();
    T_b32_SubState1* temp = _tSubStateData1;
    this->_tSubStateData1 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateData1 (T_b32_SubState1* tSubStateData1_) {
    set_has_tSubStateData1();
    if (this->_tSubStateData1 != tSubStateData1_) {
        if (this->_tSubStateData1 != NULL) {
            delete this->_tSubStateData1;
        }
        this->_tSubStateData1 = tSubStateData1_;
    }
}

inline void T_SubStateEntry::clearTSubStateMask2() {
    if (hasTSubStateMask2()) {
         clear_has_tSubStateMask2();
        delete _tSubStateMask2;
        _tSubStateMask2 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateMask2 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_b32_SubState2& T_SubStateEntry::getTSubStateMask2 () const {
    if (_tSubStateMask2 == NULL) {
        return T_b32_SubState2::getDefaultInstance();
    }
    return *_tSubStateMask2;
}

inline T_b32_SubState2& T_SubStateEntry::getTSubStateMask2Mutable () {
    set_has_tSubStateMask2();
    if (_tSubStateMask2 == NULL) {
        _tSubStateMask2 = new T_b32_SubState2 ();
        CHECK_ALLOCATION( _tSubStateMask2 );
    }
    return *_tSubStateMask2;
}

inline void T_SubStateEntry::setTSubStateMask2 (const T_b32_SubState2& tSubStateMask2_) {
    set_has_tSubStateMask2();
    if (this->_tSubStateMask2 == NULL) {
        this->_tSubStateMask2 = new T_b32_SubState2 (tSubStateMask2_);
        CHECK_ALLOCATION( this->_tSubStateMask2 );
    } else {
        *this->_tSubStateMask2 = tSubStateMask2_;
    }
}

inline T_b32_SubState2* T_SubStateEntry::releaseTSubStateMask2() {
    clear_has_tSubStateMask2();
    T_b32_SubState2* temp = _tSubStateMask2;
    this->_tSubStateMask2 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateMask2 (T_b32_SubState2* tSubStateMask2_) {
    set_has_tSubStateMask2();
    if (this->_tSubStateMask2 != tSubStateMask2_) {
        if (this->_tSubStateMask2 != NULL) {
            delete this->_tSubStateMask2;
        }
        this->_tSubStateMask2 = tSubStateMask2_;
    }
}

inline void T_SubStateEntry::clearTSubStateData2() {
    if (hasTSubStateData2()) {
         clear_has_tSubStateData2();
        delete _tSubStateData2;
        _tSubStateData2 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateData2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_b32_SubState2& T_SubStateEntry::getTSubStateData2 () const {
    if (_tSubStateData2 == NULL) {
        return T_b32_SubState2::getDefaultInstance();
    }
    return *_tSubStateData2;
}

inline T_b32_SubState2& T_SubStateEntry::getTSubStateData2Mutable () {
    set_has_tSubStateData2();
    if (_tSubStateData2 == NULL) {
        _tSubStateData2 = new T_b32_SubState2 ();
        CHECK_ALLOCATION( _tSubStateData2 );
    }
    return *_tSubStateData2;
}

inline void T_SubStateEntry::setTSubStateData2 (const T_b32_SubState2& tSubStateData2_) {
    set_has_tSubStateData2();
    if (this->_tSubStateData2 == NULL) {
        this->_tSubStateData2 = new T_b32_SubState2 (tSubStateData2_);
        CHECK_ALLOCATION( this->_tSubStateData2 );
    } else {
        *this->_tSubStateData2 = tSubStateData2_;
    }
}

inline T_b32_SubState2* T_SubStateEntry::releaseTSubStateData2() {
    clear_has_tSubStateData2();
    T_b32_SubState2* temp = _tSubStateData2;
    this->_tSubStateData2 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateData2 (T_b32_SubState2* tSubStateData2_) {
    set_has_tSubStateData2();
    if (this->_tSubStateData2 != tSubStateData2_) {
        if (this->_tSubStateData2 != NULL) {
            delete this->_tSubStateData2;
        }
        this->_tSubStateData2 = tSubStateData2_;
    }
}

inline void T_SubStateEntry::clearTSubStateMask3() {
    if (hasTSubStateMask3()) {
         clear_has_tSubStateMask3();
        delete _tSubStateMask3;
        _tSubStateMask3 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateMask3 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_b32_SubState3& T_SubStateEntry::getTSubStateMask3 () const {
    if (_tSubStateMask3 == NULL) {
        return T_b32_SubState3::getDefaultInstance();
    }
    return *_tSubStateMask3;
}

inline T_b32_SubState3& T_SubStateEntry::getTSubStateMask3Mutable () {
    set_has_tSubStateMask3();
    if (_tSubStateMask3 == NULL) {
        _tSubStateMask3 = new T_b32_SubState3 ();
        CHECK_ALLOCATION( _tSubStateMask3 );
    }
    return *_tSubStateMask3;
}

inline void T_SubStateEntry::setTSubStateMask3 (const T_b32_SubState3& tSubStateMask3_) {
    set_has_tSubStateMask3();
    if (this->_tSubStateMask3 == NULL) {
        this->_tSubStateMask3 = new T_b32_SubState3 (tSubStateMask3_);
        CHECK_ALLOCATION( this->_tSubStateMask3 );
    } else {
        *this->_tSubStateMask3 = tSubStateMask3_;
    }
}

inline T_b32_SubState3* T_SubStateEntry::releaseTSubStateMask3() {
    clear_has_tSubStateMask3();
    T_b32_SubState3* temp = _tSubStateMask3;
    this->_tSubStateMask3 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateMask3 (T_b32_SubState3* tSubStateMask3_) {
    set_has_tSubStateMask3();
    if (this->_tSubStateMask3 != tSubStateMask3_) {
        if (this->_tSubStateMask3 != NULL) {
            delete this->_tSubStateMask3;
        }
        this->_tSubStateMask3 = tSubStateMask3_;
    }
}

inline void T_SubStateEntry::clearTSubStateData3() {
    if (hasTSubStateData3()) {
         clear_has_tSubStateData3();
        delete _tSubStateData3;
        _tSubStateData3 = NULL;
     }
}

inline bool T_SubStateEntry::hasTSubStateData3 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_b32_SubState3& T_SubStateEntry::getTSubStateData3 () const {
    if (_tSubStateData3 == NULL) {
        return T_b32_SubState3::getDefaultInstance();
    }
    return *_tSubStateData3;
}

inline T_b32_SubState3& T_SubStateEntry::getTSubStateData3Mutable () {
    set_has_tSubStateData3();
    if (_tSubStateData3 == NULL) {
        _tSubStateData3 = new T_b32_SubState3 ();
        CHECK_ALLOCATION( _tSubStateData3 );
    }
    return *_tSubStateData3;
}

inline void T_SubStateEntry::setTSubStateData3 (const T_b32_SubState3& tSubStateData3_) {
    set_has_tSubStateData3();
    if (this->_tSubStateData3 == NULL) {
        this->_tSubStateData3 = new T_b32_SubState3 (tSubStateData3_);
        CHECK_ALLOCATION( this->_tSubStateData3 );
    } else {
        *this->_tSubStateData3 = tSubStateData3_;
    }
}

inline T_b32_SubState3* T_SubStateEntry::releaseTSubStateData3() {
    clear_has_tSubStateData3();
    T_b32_SubState3* temp = _tSubStateData3;
    this->_tSubStateData3 = NULL;
    return temp;
}

inline void T_SubStateEntry::replaceTSubStateData3 (T_b32_SubState3* tSubStateData3_) {
    set_has_tSubStateData3();
    if (this->_tSubStateData3 != tSubStateData3_) {
        if (this->_tSubStateData3 != NULL) {
            delete this->_tSubStateData3;
        }
        this->_tSubStateData3 = tSubStateData3_;
    }
}

inline void T_SubStateEntry::set_has_tSubStateMask0 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SubStateEntry::clear_has_tSubStateMask0 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SubStateEntry::set_has_tSubStateData0 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SubStateEntry::clear_has_tSubStateData0 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SubStateEntry::set_has_tSubStateMask1 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SubStateEntry::clear_has_tSubStateMask1 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SubStateEntry::set_has_tSubStateData1 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SubStateEntry::clear_has_tSubStateData1 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SubStateEntry::set_has_tSubStateMask2 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SubStateEntry::clear_has_tSubStateMask2 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SubStateEntry::set_has_tSubStateData2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SubStateEntry::clear_has_tSubStateData2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SubStateEntry::set_has_tSubStateMask3 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SubStateEntry::clear_has_tSubStateMask3 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SubStateEntry::set_has_tSubStateData3 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SubStateEntry::clear_has_tSubStateData3 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_ProcessElement::T_ProcessElement ()  :
    _tProcessName (NULL),
    _tConfiguredProcessName (NULL),
    _eProcState (::spm_core_fi_types::T_e8_ProcessState__SPM_e8_ProcessToStart),
    _u32StartTimeSinceStart (0u),
    _tSwitchOnDate (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ProcessElement::T_ProcessElement (const T_ProcessElement &rhs)  :
    _tProcessName (NULL),
    _tConfiguredProcessName (NULL),
    _eProcState (::spm_core_fi_types::T_e8_ProcessState__SPM_e8_ProcessToStart),
    _u32StartTimeSinceStart (0u),
    _tSwitchOnDate (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ProcessElement::T_ProcessElement (const ::std::string& tProcessName_, const ::std::string& tConfiguredProcessName_, T_e8_ProcessState eProcState_, uint32 u32StartTimeSinceStart_, const TTimeDate& tSwitchOnDate_)  :
    _tProcessName (new ::std::string(tProcessName_)),
    _tConfiguredProcessName (new ::std::string(tConfiguredProcessName_)),
    _eProcState (eProcState_),
    _u32StartTimeSinceStart (u32StartTimeSinceStart_),
    _tSwitchOnDate (new TTimeDate(tSwitchOnDate_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tConfiguredProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_ProcessState_IsValid(eProcState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eProcState_, "T_e8_ProcessState", "eProcState", "T_ProcessElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ProcessElement::~T_ProcessElement() {
    delete _tProcessName;
    delete _tConfiguredProcessName;
    delete _tSwitchOnDate;
}

inline T_ProcessElement& T_ProcessElement::operator = (const T_ProcessElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTProcessName()) {
            setTProcessName(rhs.getTProcessName());
        } else {
            clearTProcessName();
        }
        if (rhs.hasTConfiguredProcessName()) {
            setTConfiguredProcessName(rhs.getTConfiguredProcessName());
        } else {
            clearTConfiguredProcessName();
        }
        if (rhs.hasEProcState()) {
            setEProcState(rhs.getEProcState());
        } else {
            clearEProcState();
        }
        if (rhs.hasU32StartTimeSinceStart()) {
            setU32StartTimeSinceStart(rhs.getU32StartTimeSinceStart());
        } else {
            clearU32StartTimeSinceStart();
        }
        if (rhs.hasTSwitchOnDate()) {
            setTSwitchOnDate(rhs.getTSwitchOnDate());
        } else {
            clearTSwitchOnDate();
        }
    }
    return *this;
}

inline bool T_ProcessElement::operator == (const T_ProcessElement& rhs) const {
    return (((!hasTProcessName() && !rhs.hasTProcessName()) || getTProcessName() == rhs.getTProcessName()) &&
        ((!hasTConfiguredProcessName() && !rhs.hasTConfiguredProcessName()) || getTConfiguredProcessName() == rhs.getTConfiguredProcessName()) &&
        ((!hasEProcState() && !rhs.hasEProcState()) || getEProcState() == rhs.getEProcState()) &&
        ((!hasU32StartTimeSinceStart() && !rhs.hasU32StartTimeSinceStart()) || getU32StartTimeSinceStart() == rhs.getU32StartTimeSinceStart()) &&
        ((!hasTSwitchOnDate() && !rhs.hasTSwitchOnDate()) || getTSwitchOnDate() == rhs.getTSwitchOnDate()));
}

inline bool T_ProcessElement::operator != (const T_ProcessElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ProcessElement::operator < (const T_ProcessElement& rhs) const {
    if (hasTProcessName() || rhs.hasTProcessName()) {
        if (getTProcessName() < rhs.getTProcessName()) return true;
        if (getTProcessName() > rhs.getTProcessName()) return false;
    }
    if (hasTConfiguredProcessName() || rhs.hasTConfiguredProcessName()) {
        if (getTConfiguredProcessName() < rhs.getTConfiguredProcessName()) return true;
        if (getTConfiguredProcessName() > rhs.getTConfiguredProcessName()) return false;
    }
    if (hasEProcState() || rhs.hasEProcState()) {
        if ((uint32)getEProcState() < (uint32)rhs.getEProcState()) return true;
        if ((uint32)getEProcState() > (uint32)rhs.getEProcState()) return false;
    }
    if (hasU32StartTimeSinceStart() || rhs.hasU32StartTimeSinceStart()) {
        if (getU32StartTimeSinceStart() < rhs.getU32StartTimeSinceStart()) return true;
        if (getU32StartTimeSinceStart() > rhs.getU32StartTimeSinceStart()) return false;
    }
    if (hasTSwitchOnDate() || rhs.hasTSwitchOnDate()) {
        if (getTSwitchOnDate() < rhs.getTSwitchOnDate()) return true;
        if (getTSwitchOnDate() > rhs.getTSwitchOnDate()) return false;
    }
    return false;
}

inline bool T_ProcessElement::operator > (const T_ProcessElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ProcessElement::clear() {
    clearTProcessName();
    clearTConfiguredProcessName();
    clearEProcState();
    clearU32StartTimeSinceStart();
    clearTSwitchOnDate();
}

inline void T_ProcessElement::clearTProcessName() {
    if (hasTProcessName()) {
         clear_has_tProcessName();
        if (_tProcessName != NULL) {
            _tProcessName->clear();
        }
     }
}

inline bool T_ProcessElement::hasTProcessName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_ProcessElement::getTProcessName () const {
    if (_tProcessName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_tProcessName;
}

inline ::std::string& T_ProcessElement::getTProcessNameMutable () {
    set_has_tProcessName();
    if (_tProcessName == NULL) {
        _tProcessName = new ::std::string ();
        CHECK_ALLOCATION( _tProcessName );
    }
    return *_tProcessName;
}

inline void T_ProcessElement::setTProcessName (const ::std::string& tProcessName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tProcessName();
    if (this->_tProcessName == NULL) {
        this->_tProcessName = new ::std::string (tProcessName_);
        CHECK_ALLOCATION( this->_tProcessName );
    } else {
        *this->_tProcessName = tProcessName_;
    }
}

inline void T_ProcessElement::setTProcessName (const char* tProcessName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tProcessName();
    if (this->_tProcessName == NULL) {
        this->_tProcessName = new ::std::string (tProcessName_);
        CHECK_ALLOCATION( this->_tProcessName );
    } else {
        this->_tProcessName->assign(tProcessName_);
    }
}

inline void T_ProcessElement::setTProcessName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tProcessName();
    if (this->_tProcessName == NULL) {
        this->_tProcessName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_tProcessName );
    } else {
        this->_tProcessName->assign(value, size);
    }
}

inline ::std::string* T_ProcessElement::releaseTProcessName() {
    clear_has_tProcessName();
    ::std::string* temp = _tProcessName;
    this->_tProcessName = NULL;
    return temp;
}

inline void T_ProcessElement::replaceTProcessName (::std::string* tProcessName_) {
    set_has_tProcessName();
    if (this->_tProcessName != tProcessName_) {
        if (this->_tProcessName != NULL) {
            delete this->_tProcessName;
        }
        this->_tProcessName = tProcessName_;
    }
}

inline void T_ProcessElement::clearTConfiguredProcessName() {
    if (hasTConfiguredProcessName()) {
         clear_has_tConfiguredProcessName();
        if (_tConfiguredProcessName != NULL) {
            _tConfiguredProcessName->clear();
        }
     }
}

inline bool T_ProcessElement::hasTConfiguredProcessName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_ProcessElement::getTConfiguredProcessName () const {
    if (_tConfiguredProcessName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_tConfiguredProcessName;
}

inline ::std::string& T_ProcessElement::getTConfiguredProcessNameMutable () {
    set_has_tConfiguredProcessName();
    if (_tConfiguredProcessName == NULL) {
        _tConfiguredProcessName = new ::std::string ();
        CHECK_ALLOCATION( _tConfiguredProcessName );
    }
    return *_tConfiguredProcessName;
}

inline void T_ProcessElement::setTConfiguredProcessName (const ::std::string& tConfiguredProcessName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tConfiguredProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tConfiguredProcessName();
    if (this->_tConfiguredProcessName == NULL) {
        this->_tConfiguredProcessName = new ::std::string (tConfiguredProcessName_);
        CHECK_ALLOCATION( this->_tConfiguredProcessName );
    } else {
        *this->_tConfiguredProcessName = tConfiguredProcessName_;
    }
}

inline void T_ProcessElement::setTConfiguredProcessName (const char* tConfiguredProcessName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tConfiguredProcessName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tConfiguredProcessName();
    if (this->_tConfiguredProcessName == NULL) {
        this->_tConfiguredProcessName = new ::std::string (tConfiguredProcessName_);
        CHECK_ALLOCATION( this->_tConfiguredProcessName );
    } else {
        this->_tConfiguredProcessName->assign(tConfiguredProcessName_);
    }
}

inline void T_ProcessElement::setTConfiguredProcessName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tConfiguredProcessName();
    if (this->_tConfiguredProcessName == NULL) {
        this->_tConfiguredProcessName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_tConfiguredProcessName );
    } else {
        this->_tConfiguredProcessName->assign(value, size);
    }
}

inline ::std::string* T_ProcessElement::releaseTConfiguredProcessName() {
    clear_has_tConfiguredProcessName();
    ::std::string* temp = _tConfiguredProcessName;
    this->_tConfiguredProcessName = NULL;
    return temp;
}

inline void T_ProcessElement::replaceTConfiguredProcessName (::std::string* tConfiguredProcessName_) {
    set_has_tConfiguredProcessName();
    if (this->_tConfiguredProcessName != tConfiguredProcessName_) {
        if (this->_tConfiguredProcessName != NULL) {
            delete this->_tConfiguredProcessName;
        }
        this->_tConfiguredProcessName = tConfiguredProcessName_;
    }
}

inline void T_ProcessElement::clearEProcState() {
    if (hasEProcState()) {
         clear_has_eProcState();
        _eProcState = ::spm_core_fi_types::T_e8_ProcessState__SPM_e8_ProcessToStart;
     }
}

inline bool T_ProcessElement::hasEProcState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_ProcessState T_ProcessElement::getEProcState () const {
    return _eProcState;
}

inline void T_ProcessElement::setEProcState (T_e8_ProcessState eProcState_) {
    #ifndef NDEBUG
    if (!(T_e8_ProcessState_IsValid(eProcState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eProcState_, "T_e8_ProcessState", "eProcState", "T_ProcessElement");
    }
    #endif
    set_has_eProcState();
    this->_eProcState = eProcState_;
}

inline void T_ProcessElement::clearU32StartTimeSinceStart() {
    if (hasU32StartTimeSinceStart()) {
         clear_has_u32StartTimeSinceStart();
        _u32StartTimeSinceStart = 0u;
     }
}

inline bool T_ProcessElement::hasU32StartTimeSinceStart () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_ProcessElement::getU32StartTimeSinceStart () const {
    return _u32StartTimeSinceStart;
}

inline void T_ProcessElement::setU32StartTimeSinceStart (uint32 u32StartTimeSinceStart_) {
    set_has_u32StartTimeSinceStart();
    this->_u32StartTimeSinceStart = u32StartTimeSinceStart_;
}

inline void T_ProcessElement::clearTSwitchOnDate() {
    if (hasTSwitchOnDate()) {
         clear_has_tSwitchOnDate();
        if (_tSwitchOnDate != NULL) {
            _tSwitchOnDate->clear();
        }
     }
}

inline bool T_ProcessElement::hasTSwitchOnDate () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const TTimeDate& T_ProcessElement::getTSwitchOnDate () const {
    if (_tSwitchOnDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tSwitchOnDate;
}

inline TTimeDate& T_ProcessElement::getTSwitchOnDateMutable () {
    set_has_tSwitchOnDate();
    if (_tSwitchOnDate == NULL) {
        _tSwitchOnDate = new TTimeDate ();
        CHECK_ALLOCATION( _tSwitchOnDate );
    }
    return *_tSwitchOnDate;
}

inline void T_ProcessElement::setTSwitchOnDate (const TTimeDate& tSwitchOnDate_) {
    set_has_tSwitchOnDate();
    if (this->_tSwitchOnDate == NULL) {
        this->_tSwitchOnDate = new TTimeDate (tSwitchOnDate_);
        CHECK_ALLOCATION( this->_tSwitchOnDate );
    } else {
        *this->_tSwitchOnDate = tSwitchOnDate_;
    }
}

inline TTimeDate* T_ProcessElement::releaseTSwitchOnDate() {
    clear_has_tSwitchOnDate();
    TTimeDate* temp = _tSwitchOnDate;
    this->_tSwitchOnDate = NULL;
    return temp;
}

inline void T_ProcessElement::replaceTSwitchOnDate (TTimeDate* tSwitchOnDate_) {
    set_has_tSwitchOnDate();
    if (this->_tSwitchOnDate != tSwitchOnDate_) {
        if (this->_tSwitchOnDate != NULL) {
            delete this->_tSwitchOnDate;
        }
        this->_tSwitchOnDate = tSwitchOnDate_;
    }
}

inline void T_ProcessElement::set_has_tProcessName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ProcessElement::clear_has_tProcessName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ProcessElement::set_has_tConfiguredProcessName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ProcessElement::clear_has_tConfiguredProcessName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ProcessElement::set_has_eProcState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ProcessElement::clear_has_eProcState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ProcessElement::set_has_u32StartTimeSinceStart () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ProcessElement::clear_has_u32StartTimeSinceStart () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ProcessElement::set_has_tSwitchOnDate () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ProcessElement::clear_has_tSwitchOnDate () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_ResetElement::T_ResetElement ()  :
    _tResetDate (NULL),
    _tSwVersionInfo (NULL),
    _eReset (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ResetElement::T_ResetElement (const T_ResetElement &rhs)  :
    _tResetDate (NULL),
    _tSwVersionInfo (NULL),
    _eReset (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ResetElement::T_ResetElement (const TTimeDate& tResetDate_, const TSwVersionInfo& tSwVersionInfo_, T_e8_LcmResetReason eReset_)  :
    _tResetDate (new TTimeDate(tResetDate_)),
    _tSwVersionInfo (new TSwVersionInfo(tSwVersionInfo_)),
    _eReset (eReset_)
{
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(eReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eReset_, "T_e8_LcmResetReason", "eReset", "T_ResetElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ResetElement::~T_ResetElement() {
    delete _tResetDate;
    delete _tSwVersionInfo;
}

inline T_ResetElement& T_ResetElement::operator = (const T_ResetElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTResetDate()) {
            setTResetDate(rhs.getTResetDate());
        } else {
            clearTResetDate();
        }
        if (rhs.hasTSwVersionInfo()) {
            setTSwVersionInfo(rhs.getTSwVersionInfo());
        } else {
            clearTSwVersionInfo();
        }
        if (rhs.hasEReset()) {
            setEReset(rhs.getEReset());
        } else {
            clearEReset();
        }
    }
    return *this;
}

inline bool T_ResetElement::operator == (const T_ResetElement& rhs) const {
    return (((!hasTResetDate() && !rhs.hasTResetDate()) || getTResetDate() == rhs.getTResetDate()) &&
        ((!hasTSwVersionInfo() && !rhs.hasTSwVersionInfo()) || getTSwVersionInfo() == rhs.getTSwVersionInfo()) &&
        ((!hasEReset() && !rhs.hasEReset()) || getEReset() == rhs.getEReset()));
}

inline bool T_ResetElement::operator != (const T_ResetElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ResetElement::operator < (const T_ResetElement& rhs) const {
    if (hasTResetDate() || rhs.hasTResetDate()) {
        if (getTResetDate() < rhs.getTResetDate()) return true;
        if (getTResetDate() > rhs.getTResetDate()) return false;
    }
    if (hasTSwVersionInfo() || rhs.hasTSwVersionInfo()) {
        if (getTSwVersionInfo() < rhs.getTSwVersionInfo()) return true;
        if (getTSwVersionInfo() > rhs.getTSwVersionInfo()) return false;
    }
    if (hasEReset() || rhs.hasEReset()) {
        if ((uint32)getEReset() < (uint32)rhs.getEReset()) return true;
        if ((uint32)getEReset() > (uint32)rhs.getEReset()) return false;
    }
    return false;
}

inline bool T_ResetElement::operator > (const T_ResetElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ResetElement::clear() {
    clearTResetDate();
    clearTSwVersionInfo();
    clearEReset();
}

inline void T_ResetElement::clearTResetDate() {
    if (hasTResetDate()) {
         clear_has_tResetDate();
        if (_tResetDate != NULL) {
            _tResetDate->clear();
        }
     }
}

inline bool T_ResetElement::hasTResetDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TTimeDate& T_ResetElement::getTResetDate () const {
    if (_tResetDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tResetDate;
}

inline TTimeDate& T_ResetElement::getTResetDateMutable () {
    set_has_tResetDate();
    if (_tResetDate == NULL) {
        _tResetDate = new TTimeDate ();
        CHECK_ALLOCATION( _tResetDate );
    }
    return *_tResetDate;
}

inline void T_ResetElement::setTResetDate (const TTimeDate& tResetDate_) {
    set_has_tResetDate();
    if (this->_tResetDate == NULL) {
        this->_tResetDate = new TTimeDate (tResetDate_);
        CHECK_ALLOCATION( this->_tResetDate );
    } else {
        *this->_tResetDate = tResetDate_;
    }
}

inline TTimeDate* T_ResetElement::releaseTResetDate() {
    clear_has_tResetDate();
    TTimeDate* temp = _tResetDate;
    this->_tResetDate = NULL;
    return temp;
}

inline void T_ResetElement::replaceTResetDate (TTimeDate* tResetDate_) {
    set_has_tResetDate();
    if (this->_tResetDate != tResetDate_) {
        if (this->_tResetDate != NULL) {
            delete this->_tResetDate;
        }
        this->_tResetDate = tResetDate_;
    }
}

inline void T_ResetElement::clearTSwVersionInfo() {
    if (hasTSwVersionInfo()) {
         clear_has_tSwVersionInfo();
        if (_tSwVersionInfo != NULL) {
            _tSwVersionInfo->clear();
        }
     }
}

inline bool T_ResetElement::hasTSwVersionInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const TSwVersionInfo& T_ResetElement::getTSwVersionInfo () const {
    if (_tSwVersionInfo == NULL) {
        return TSwVersionInfo::getDefaultInstance();
    }
    return *_tSwVersionInfo;
}

inline TSwVersionInfo& T_ResetElement::getTSwVersionInfoMutable () {
    set_has_tSwVersionInfo();
    if (_tSwVersionInfo == NULL) {
        _tSwVersionInfo = new TSwVersionInfo ();
        CHECK_ALLOCATION( _tSwVersionInfo );
    }
    return *_tSwVersionInfo;
}

inline void T_ResetElement::setTSwVersionInfo (const TSwVersionInfo& tSwVersionInfo_) {
    set_has_tSwVersionInfo();
    if (this->_tSwVersionInfo == NULL) {
        this->_tSwVersionInfo = new TSwVersionInfo (tSwVersionInfo_);
        CHECK_ALLOCATION( this->_tSwVersionInfo );
    } else {
        *this->_tSwVersionInfo = tSwVersionInfo_;
    }
}

inline TSwVersionInfo* T_ResetElement::releaseTSwVersionInfo() {
    clear_has_tSwVersionInfo();
    TSwVersionInfo* temp = _tSwVersionInfo;
    this->_tSwVersionInfo = NULL;
    return temp;
}

inline void T_ResetElement::replaceTSwVersionInfo (TSwVersionInfo* tSwVersionInfo_) {
    set_has_tSwVersionInfo();
    if (this->_tSwVersionInfo != tSwVersionInfo_) {
        if (this->_tSwVersionInfo != NULL) {
            delete this->_tSwVersionInfo;
        }
        this->_tSwVersionInfo = tSwVersionInfo_;
    }
}

inline void T_ResetElement::clearEReset() {
    if (hasEReset()) {
         clear_has_eReset();
        _eReset = ::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR;
     }
}

inline bool T_ResetElement::hasEReset () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_LcmResetReason T_ResetElement::getEReset () const {
    return _eReset;
}

inline void T_ResetElement::setEReset (T_e8_LcmResetReason eReset_) {
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(eReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eReset_, "T_e8_LcmResetReason", "eReset", "T_ResetElement");
    }
    #endif
    set_has_eReset();
    this->_eReset = eReset_;
}

inline void T_ResetElement::set_has_tResetDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ResetElement::clear_has_tResetDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ResetElement::set_has_tSwVersionInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ResetElement::clear_has_tSwVersionInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ResetElement::set_has_eReset () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ResetElement::clear_has_eReset () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_WakeupElement::T_WakeupElement ()  :
    _tWakeupDate (NULL),
    _eWakeupReason (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_WakeupElement::T_WakeupElement (const T_WakeupElement &rhs)  :
    _tWakeupDate (NULL),
    _eWakeupReason (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_WakeupElement::T_WakeupElement (const TTimeDate& tWakeupDate_, T_SPM_e32_WAKEUP_REASON eWakeupReason_)  :
    _tWakeupDate (new TTimeDate(tWakeupDate_)),
    _eWakeupReason (eWakeupReason_)
{
    #ifndef NDEBUG
    if (!(T_SPM_e32_WAKEUP_REASON_IsValid(eWakeupReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eWakeupReason_, "T_SPM_e32_WAKEUP_REASON", "eWakeupReason", "T_WakeupElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_WakeupElement::~T_WakeupElement() {
    delete _tWakeupDate;
}

inline T_WakeupElement& T_WakeupElement::operator = (const T_WakeupElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTWakeupDate()) {
            setTWakeupDate(rhs.getTWakeupDate());
        } else {
            clearTWakeupDate();
        }
        if (rhs.hasEWakeupReason()) {
            setEWakeupReason(rhs.getEWakeupReason());
        } else {
            clearEWakeupReason();
        }
    }
    return *this;
}

inline bool T_WakeupElement::operator == (const T_WakeupElement& rhs) const {
    return (((!hasTWakeupDate() && !rhs.hasTWakeupDate()) || getTWakeupDate() == rhs.getTWakeupDate()) &&
        ((!hasEWakeupReason() && !rhs.hasEWakeupReason()) || getEWakeupReason() == rhs.getEWakeupReason()));
}

inline bool T_WakeupElement::operator != (const T_WakeupElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_WakeupElement::operator < (const T_WakeupElement& rhs) const {
    if (hasTWakeupDate() || rhs.hasTWakeupDate()) {
        if (getTWakeupDate() < rhs.getTWakeupDate()) return true;
        if (getTWakeupDate() > rhs.getTWakeupDate()) return false;
    }
    if (hasEWakeupReason() || rhs.hasEWakeupReason()) {
        if ((uint32)getEWakeupReason() < (uint32)rhs.getEWakeupReason()) return true;
        if ((uint32)getEWakeupReason() > (uint32)rhs.getEWakeupReason()) return false;
    }
    return false;
}

inline bool T_WakeupElement::operator > (const T_WakeupElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_WakeupElement::clear() {
    clearTWakeupDate();
    clearEWakeupReason();
}

inline void T_WakeupElement::clearTWakeupDate() {
    if (hasTWakeupDate()) {
         clear_has_tWakeupDate();
        if (_tWakeupDate != NULL) {
            _tWakeupDate->clear();
        }
     }
}

inline bool T_WakeupElement::hasTWakeupDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TTimeDate& T_WakeupElement::getTWakeupDate () const {
    if (_tWakeupDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tWakeupDate;
}

inline TTimeDate& T_WakeupElement::getTWakeupDateMutable () {
    set_has_tWakeupDate();
    if (_tWakeupDate == NULL) {
        _tWakeupDate = new TTimeDate ();
        CHECK_ALLOCATION( _tWakeupDate );
    }
    return *_tWakeupDate;
}

inline void T_WakeupElement::setTWakeupDate (const TTimeDate& tWakeupDate_) {
    set_has_tWakeupDate();
    if (this->_tWakeupDate == NULL) {
        this->_tWakeupDate = new TTimeDate (tWakeupDate_);
        CHECK_ALLOCATION( this->_tWakeupDate );
    } else {
        *this->_tWakeupDate = tWakeupDate_;
    }
}

inline TTimeDate* T_WakeupElement::releaseTWakeupDate() {
    clear_has_tWakeupDate();
    TTimeDate* temp = _tWakeupDate;
    this->_tWakeupDate = NULL;
    return temp;
}

inline void T_WakeupElement::replaceTWakeupDate (TTimeDate* tWakeupDate_) {
    set_has_tWakeupDate();
    if (this->_tWakeupDate != tWakeupDate_) {
        if (this->_tWakeupDate != NULL) {
            delete this->_tWakeupDate;
        }
        this->_tWakeupDate = tWakeupDate_;
    }
}

inline void T_WakeupElement::clearEWakeupReason() {
    if (hasEWakeupReason()) {
         clear_has_eWakeupReason();
        _eWakeupReason = ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID;
     }
}

inline bool T_WakeupElement::hasEWakeupReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_SPM_e32_WAKEUP_REASON T_WakeupElement::getEWakeupReason () const {
    return _eWakeupReason;
}

inline void T_WakeupElement::setEWakeupReason (T_SPM_e32_WAKEUP_REASON eWakeupReason_) {
    #ifndef NDEBUG
    if (!(T_SPM_e32_WAKEUP_REASON_IsValid(eWakeupReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eWakeupReason_, "T_SPM_e32_WAKEUP_REASON", "eWakeupReason", "T_WakeupElement");
    }
    #endif
    set_has_eWakeupReason();
    this->_eWakeupReason = eWakeupReason_;
}

inline void T_WakeupElement::set_has_tWakeupDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_WakeupElement::clear_has_tWakeupDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_WakeupElement::set_has_eWakeupReason () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_WakeupElement::clear_has_eWakeupReason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_StateChangeElement::T_StateChangeElement ()  :
    _tWakeupDate (NULL),
    _tSysState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND),
    _tElemType (::spm_core_fi_types::T_e8_StateEntryType__SPM_e8_HistoryEntryWakeup),
    _tWakeup (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID),
    _tReset (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR),
    _tSubStates (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StateChangeElement::T_StateChangeElement (const T_StateChangeElement &rhs)  :
    _tWakeupDate (NULL),
    _tSysState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND),
    _tElemType (::spm_core_fi_types::T_e8_StateEntryType__SPM_e8_HistoryEntryWakeup),
    _tWakeup (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID),
    _tReset (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR),
    _tSubStates (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StateChangeElement::T_StateChangeElement (const TTimeDate& tWakeupDate_, T_SPM_e32_SYSTEM_STATES tSysState_, T_e8_StateEntryType tElemType_, T_SPM_e32_WAKEUP_REASON tWakeup_, T_e8_LcmResetReason tReset_, const T_SubStateEntry& tSubStates_)  :
    _tWakeupDate (new TTimeDate(tWakeupDate_)),
    _tSysState (tSysState_),
    _tElemType (tElemType_),
    _tWakeup (tWakeup_),
    _tReset (tReset_),
    _tSubStates (new T_SubStateEntry(tSubStates_))
{
    #ifndef NDEBUG
    if (!(T_SPM_e32_SYSTEM_STATES_IsValid(tSysState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tSysState_, "T_SPM_e32_SYSTEM_STATES", "tSysState", "T_StateChangeElement");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_StateEntryType_IsValid(tElemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tElemType_, "T_e8_StateEntryType", "tElemType", "T_StateChangeElement");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_SPM_e32_WAKEUP_REASON_IsValid(tWakeup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tWakeup_, "T_SPM_e32_WAKEUP_REASON", "tWakeup", "T_StateChangeElement");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(tReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tReset_, "T_e8_LcmResetReason", "tReset", "T_StateChangeElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StateChangeElement::~T_StateChangeElement() {
    delete _tWakeupDate;
    delete _tSubStates;
}

inline T_StateChangeElement& T_StateChangeElement::operator = (const T_StateChangeElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTWakeupDate()) {
            setTWakeupDate(rhs.getTWakeupDate());
        } else {
            clearTWakeupDate();
        }
        if (rhs.hasTSysState()) {
            setTSysState(rhs.getTSysState());
        } else {
            clearTSysState();
        }
        if (rhs.hasTElemType()) {
            setTElemType(rhs.getTElemType());
        } else {
            clearTElemType();
        }
        if (rhs.hasTWakeup()) {
            setTWakeup(rhs.getTWakeup());
        } else {
            clearTWakeup();
        }
        if (rhs.hasTReset()) {
            setTReset(rhs.getTReset());
        } else {
            clearTReset();
        }
        if (rhs.hasTSubStates()) {
            setTSubStates(rhs.getTSubStates());
        } else {
            clearTSubStates();
        }
    }
    return *this;
}

inline bool T_StateChangeElement::operator == (const T_StateChangeElement& rhs) const {
    return (((!hasTWakeupDate() && !rhs.hasTWakeupDate()) || getTWakeupDate() == rhs.getTWakeupDate()) &&
        ((!hasTSysState() && !rhs.hasTSysState()) || getTSysState() == rhs.getTSysState()) &&
        ((!hasTElemType() && !rhs.hasTElemType()) || getTElemType() == rhs.getTElemType()) &&
        ((!hasTWakeup() && !rhs.hasTWakeup()) || getTWakeup() == rhs.getTWakeup()) &&
        ((!hasTReset() && !rhs.hasTReset()) || getTReset() == rhs.getTReset()) &&
        ((!hasTSubStates() && !rhs.hasTSubStates()) || getTSubStates() == rhs.getTSubStates()));
}

inline bool T_StateChangeElement::operator != (const T_StateChangeElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StateChangeElement::operator < (const T_StateChangeElement& rhs) const {
    if (hasTWakeupDate() || rhs.hasTWakeupDate()) {
        if (getTWakeupDate() < rhs.getTWakeupDate()) return true;
        if (getTWakeupDate() > rhs.getTWakeupDate()) return false;
    }
    if (hasTSysState() || rhs.hasTSysState()) {
        if ((uint32)getTSysState() < (uint32)rhs.getTSysState()) return true;
        if ((uint32)getTSysState() > (uint32)rhs.getTSysState()) return false;
    }
    if (hasTElemType() || rhs.hasTElemType()) {
        if ((uint32)getTElemType() < (uint32)rhs.getTElemType()) return true;
        if ((uint32)getTElemType() > (uint32)rhs.getTElemType()) return false;
    }
    if (hasTWakeup() || rhs.hasTWakeup()) {
        if ((uint32)getTWakeup() < (uint32)rhs.getTWakeup()) return true;
        if ((uint32)getTWakeup() > (uint32)rhs.getTWakeup()) return false;
    }
    if (hasTReset() || rhs.hasTReset()) {
        if ((uint32)getTReset() < (uint32)rhs.getTReset()) return true;
        if ((uint32)getTReset() > (uint32)rhs.getTReset()) return false;
    }
    if (hasTSubStates() || rhs.hasTSubStates()) {
        if (getTSubStates() < rhs.getTSubStates()) return true;
        if (getTSubStates() > rhs.getTSubStates()) return false;
    }
    return false;
}

inline bool T_StateChangeElement::operator > (const T_StateChangeElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StateChangeElement::clear() {
    clearTWakeupDate();
    clearTSysState();
    clearTElemType();
    clearTWakeup();
    clearTReset();
    clearTSubStates();
}

inline void T_StateChangeElement::clearTWakeupDate() {
    if (hasTWakeupDate()) {
         clear_has_tWakeupDate();
        if (_tWakeupDate != NULL) {
            _tWakeupDate->clear();
        }
     }
}

inline bool T_StateChangeElement::hasTWakeupDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TTimeDate& T_StateChangeElement::getTWakeupDate () const {
    if (_tWakeupDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tWakeupDate;
}

inline TTimeDate& T_StateChangeElement::getTWakeupDateMutable () {
    set_has_tWakeupDate();
    if (_tWakeupDate == NULL) {
        _tWakeupDate = new TTimeDate ();
        CHECK_ALLOCATION( _tWakeupDate );
    }
    return *_tWakeupDate;
}

inline void T_StateChangeElement::setTWakeupDate (const TTimeDate& tWakeupDate_) {
    set_has_tWakeupDate();
    if (this->_tWakeupDate == NULL) {
        this->_tWakeupDate = new TTimeDate (tWakeupDate_);
        CHECK_ALLOCATION( this->_tWakeupDate );
    } else {
        *this->_tWakeupDate = tWakeupDate_;
    }
}

inline TTimeDate* T_StateChangeElement::releaseTWakeupDate() {
    clear_has_tWakeupDate();
    TTimeDate* temp = _tWakeupDate;
    this->_tWakeupDate = NULL;
    return temp;
}

inline void T_StateChangeElement::replaceTWakeupDate (TTimeDate* tWakeupDate_) {
    set_has_tWakeupDate();
    if (this->_tWakeupDate != tWakeupDate_) {
        if (this->_tWakeupDate != NULL) {
            delete this->_tWakeupDate;
        }
        this->_tWakeupDate = tWakeupDate_;
    }
}

inline void T_StateChangeElement::clearTSysState() {
    if (hasTSysState()) {
         clear_has_tSysState();
        _tSysState = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND;
     }
}

inline bool T_StateChangeElement::hasTSysState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_SPM_e32_SYSTEM_STATES T_StateChangeElement::getTSysState () const {
    return _tSysState;
}

inline void T_StateChangeElement::setTSysState (T_SPM_e32_SYSTEM_STATES tSysState_) {
    #ifndef NDEBUG
    if (!(T_SPM_e32_SYSTEM_STATES_IsValid(tSysState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tSysState_, "T_SPM_e32_SYSTEM_STATES", "tSysState", "T_StateChangeElement");
    }
    #endif
    set_has_tSysState();
    this->_tSysState = tSysState_;
}

inline void T_StateChangeElement::clearTElemType() {
    if (hasTElemType()) {
         clear_has_tElemType();
        _tElemType = ::spm_core_fi_types::T_e8_StateEntryType__SPM_e8_HistoryEntryWakeup;
     }
}

inline bool T_StateChangeElement::hasTElemType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_StateEntryType T_StateChangeElement::getTElemType () const {
    return _tElemType;
}

inline void T_StateChangeElement::setTElemType (T_e8_StateEntryType tElemType_) {
    #ifndef NDEBUG
    if (!(T_e8_StateEntryType_IsValid(tElemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tElemType_, "T_e8_StateEntryType", "tElemType", "T_StateChangeElement");
    }
    #endif
    set_has_tElemType();
    this->_tElemType = tElemType_;
}

inline void T_StateChangeElement::clearTWakeup() {
    if (hasTWakeup()) {
         clear_has_tWakeup();
        _tWakeup = ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON__SPM_U32_WAKEUP_INVALID;
     }
}

inline bool T_StateChangeElement::hasTWakeup () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_SPM_e32_WAKEUP_REASON T_StateChangeElement::getTWakeup () const {
    return _tWakeup;
}

inline void T_StateChangeElement::setTWakeup (T_SPM_e32_WAKEUP_REASON tWakeup_) {
    #ifndef NDEBUG
    if (!(T_SPM_e32_WAKEUP_REASON_IsValid(tWakeup_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tWakeup_, "T_SPM_e32_WAKEUP_REASON", "tWakeup", "T_StateChangeElement");
    }
    #endif
    set_has_tWakeup();
    this->_tWakeup = tWakeup_;
}

inline void T_StateChangeElement::clearTReset() {
    if (hasTReset()) {
         clear_has_tReset();
        _tReset = ::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR;
     }
}

inline bool T_StateChangeElement::hasTReset () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_LcmResetReason T_StateChangeElement::getTReset () const {
    return _tReset;
}

inline void T_StateChangeElement::setTReset (T_e8_LcmResetReason tReset_) {
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(tReset_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tReset_, "T_e8_LcmResetReason", "tReset", "T_StateChangeElement");
    }
    #endif
    set_has_tReset();
    this->_tReset = tReset_;
}

inline void T_StateChangeElement::clearTSubStates() {
    if (hasTSubStates()) {
         clear_has_tSubStates();
        if (_tSubStates != NULL) {
            _tSubStates->clear();
        }
     }
}

inline bool T_StateChangeElement::hasTSubStates () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_SubStateEntry& T_StateChangeElement::getTSubStates () const {
    if (_tSubStates == NULL) {
        return T_SubStateEntry::getDefaultInstance();
    }
    return *_tSubStates;
}

inline T_SubStateEntry& T_StateChangeElement::getTSubStatesMutable () {
    set_has_tSubStates();
    if (_tSubStates == NULL) {
        _tSubStates = new T_SubStateEntry ();
        CHECK_ALLOCATION( _tSubStates );
    }
    return *_tSubStates;
}

inline void T_StateChangeElement::setTSubStates (const T_SubStateEntry& tSubStates_) {
    set_has_tSubStates();
    if (this->_tSubStates == NULL) {
        this->_tSubStates = new T_SubStateEntry (tSubStates_);
        CHECK_ALLOCATION( this->_tSubStates );
    } else {
        *this->_tSubStates = tSubStates_;
    }
}

inline T_SubStateEntry* T_StateChangeElement::releaseTSubStates() {
    clear_has_tSubStates();
    T_SubStateEntry* temp = _tSubStates;
    this->_tSubStates = NULL;
    return temp;
}

inline void T_StateChangeElement::replaceTSubStates (T_SubStateEntry* tSubStates_) {
    set_has_tSubStates();
    if (this->_tSubStates != tSubStates_) {
        if (this->_tSubStates != NULL) {
            delete this->_tSubStates;
        }
        this->_tSubStates = tSubStates_;
    }
}

inline void T_StateChangeElement::set_has_tWakeupDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StateChangeElement::clear_has_tWakeupDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StateChangeElement::set_has_tSysState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StateChangeElement::clear_has_tSysState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_StateChangeElement::set_has_tElemType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_StateChangeElement::clear_has_tElemType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_StateChangeElement::set_has_tWakeup () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_StateChangeElement::clear_has_tWakeup () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_StateChangeElement::set_has_tReset () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_StateChangeElement::clear_has_tReset () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_StateChangeElement::set_has_tSubStates () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_StateChangeElement::clear_has_tSubStates () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_SwitchOnElement::T_SwitchOnElement ()  :
    _tSwitchOnDate (NULL),
    _eSwitchOnReason (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SwitchOnElement::T_SwitchOnElement (const T_SwitchOnElement &rhs)  :
    _tSwitchOnDate (NULL),
    _eSwitchOnReason (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SwitchOnElement::T_SwitchOnElement (const TTimeDate& tSwitchOnDate_, T_SPM_e32_SubStateType eSwitchOnReason_)  :
    _tSwitchOnDate (new TTimeDate(tSwitchOnDate_)),
    _eSwitchOnReason (eSwitchOnReason_)
{
    #ifndef NDEBUG
    if (!(T_SPM_e32_SubStateType_IsValid(eSwitchOnReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSwitchOnReason_, "T_SPM_e32_SubStateType", "eSwitchOnReason", "T_SwitchOnElement");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SwitchOnElement::~T_SwitchOnElement() {
    delete _tSwitchOnDate;
}

inline T_SwitchOnElement& T_SwitchOnElement::operator = (const T_SwitchOnElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTSwitchOnDate()) {
            setTSwitchOnDate(rhs.getTSwitchOnDate());
        } else {
            clearTSwitchOnDate();
        }
        if (rhs.hasESwitchOnReason()) {
            setESwitchOnReason(rhs.getESwitchOnReason());
        } else {
            clearESwitchOnReason();
        }
    }
    return *this;
}

inline bool T_SwitchOnElement::operator == (const T_SwitchOnElement& rhs) const {
    return (((!hasTSwitchOnDate() && !rhs.hasTSwitchOnDate()) || getTSwitchOnDate() == rhs.getTSwitchOnDate()) &&
        ((!hasESwitchOnReason() && !rhs.hasESwitchOnReason()) || getESwitchOnReason() == rhs.getESwitchOnReason()));
}

inline bool T_SwitchOnElement::operator != (const T_SwitchOnElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SwitchOnElement::operator < (const T_SwitchOnElement& rhs) const {
    if (hasTSwitchOnDate() || rhs.hasTSwitchOnDate()) {
        if (getTSwitchOnDate() < rhs.getTSwitchOnDate()) return true;
        if (getTSwitchOnDate() > rhs.getTSwitchOnDate()) return false;
    }
    if (hasESwitchOnReason() || rhs.hasESwitchOnReason()) {
        if ((uint32)getESwitchOnReason() < (uint32)rhs.getESwitchOnReason()) return true;
        if ((uint32)getESwitchOnReason() > (uint32)rhs.getESwitchOnReason()) return false;
    }
    return false;
}

inline bool T_SwitchOnElement::operator > (const T_SwitchOnElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SwitchOnElement::clear() {
    clearTSwitchOnDate();
    clearESwitchOnReason();
}

inline void T_SwitchOnElement::clearTSwitchOnDate() {
    if (hasTSwitchOnDate()) {
         clear_has_tSwitchOnDate();
        if (_tSwitchOnDate != NULL) {
            _tSwitchOnDate->clear();
        }
     }
}

inline bool T_SwitchOnElement::hasTSwitchOnDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TTimeDate& T_SwitchOnElement::getTSwitchOnDate () const {
    if (_tSwitchOnDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tSwitchOnDate;
}

inline TTimeDate& T_SwitchOnElement::getTSwitchOnDateMutable () {
    set_has_tSwitchOnDate();
    if (_tSwitchOnDate == NULL) {
        _tSwitchOnDate = new TTimeDate ();
        CHECK_ALLOCATION( _tSwitchOnDate );
    }
    return *_tSwitchOnDate;
}

inline void T_SwitchOnElement::setTSwitchOnDate (const TTimeDate& tSwitchOnDate_) {
    set_has_tSwitchOnDate();
    if (this->_tSwitchOnDate == NULL) {
        this->_tSwitchOnDate = new TTimeDate (tSwitchOnDate_);
        CHECK_ALLOCATION( this->_tSwitchOnDate );
    } else {
        *this->_tSwitchOnDate = tSwitchOnDate_;
    }
}

inline TTimeDate* T_SwitchOnElement::releaseTSwitchOnDate() {
    clear_has_tSwitchOnDate();
    TTimeDate* temp = _tSwitchOnDate;
    this->_tSwitchOnDate = NULL;
    return temp;
}

inline void T_SwitchOnElement::replaceTSwitchOnDate (TTimeDate* tSwitchOnDate_) {
    set_has_tSwitchOnDate();
    if (this->_tSwitchOnDate != tSwitchOnDate_) {
        if (this->_tSwitchOnDate != NULL) {
            delete this->_tSwitchOnDate;
        }
        this->_tSwitchOnDate = tSwitchOnDate_;
    }
}

inline void T_SwitchOnElement::clearESwitchOnReason() {
    if (hasESwitchOnReason()) {
         clear_has_eSwitchOnReason();
        _eSwitchOnReason = ::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS;
     }
}

inline bool T_SwitchOnElement::hasESwitchOnReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_SPM_e32_SubStateType T_SwitchOnElement::getESwitchOnReason () const {
    return _eSwitchOnReason;
}

inline void T_SwitchOnElement::setESwitchOnReason (T_SPM_e32_SubStateType eSwitchOnReason_) {
    #ifndef NDEBUG
    if (!(T_SPM_e32_SubStateType_IsValid(eSwitchOnReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSwitchOnReason_, "T_SPM_e32_SubStateType", "eSwitchOnReason", "T_SwitchOnElement");
    }
    #endif
    set_has_eSwitchOnReason();
    this->_eSwitchOnReason = eSwitchOnReason_;
}

inline void T_SwitchOnElement::set_has_tSwitchOnDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SwitchOnElement::clear_has_tSwitchOnDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SwitchOnElement::set_has_eSwitchOnReason () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SwitchOnElement::clear_has_eSwitchOnReason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SPM_b32_SYSPWRSAVEMODE::T_SPM_b32_SYSPWRSAVEMODE ()  :
    _SPM_e32_TRANSPORTMODE (false),
    _SPM_e32_ROLLER (false),
    _SPM_e32_FACTORY (false),
    _SPM_e32_QCRITICAL (false)
{
}

inline  T_SPM_b32_SYSPWRSAVEMODE::T_SPM_b32_SYSPWRSAVEMODE (const T_SPM_b32_SYSPWRSAVEMODE &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_SPM_b32_SYSPWRSAVEMODE::T_SPM_b32_SYSPWRSAVEMODE (bool SPM_e32_TRANSPORTMODE, bool SPM_e32_ROLLER, bool SPM_e32_FACTORY, bool SPM_e32_QCRITICAL) :
    _SPM_e32_TRANSPORTMODE (SPM_e32_TRANSPORTMODE),
    _SPM_e32_ROLLER (SPM_e32_ROLLER),
    _SPM_e32_FACTORY (SPM_e32_FACTORY),
    _SPM_e32_QCRITICAL (SPM_e32_QCRITICAL)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_SPM_b32_SYSPWRSAVEMODE& T_SPM_b32_SYSPWRSAVEMODE::operator = (const T_SPM_b32_SYSPWRSAVEMODE& rhs) {
    if( this != &rhs ) {
        _SPM_e32_TRANSPORTMODE = rhs._SPM_e32_TRANSPORTMODE;
        _SPM_e32_ROLLER = rhs._SPM_e32_ROLLER;
        _SPM_e32_FACTORY = rhs._SPM_e32_FACTORY;
        _SPM_e32_QCRITICAL = rhs._SPM_e32_QCRITICAL;
    }
    return *this;
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::operator == (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const {
    return (_SPM_e32_TRANSPORTMODE == rhs._SPM_e32_TRANSPORTMODE &&
        _SPM_e32_ROLLER == rhs._SPM_e32_ROLLER &&
        _SPM_e32_FACTORY == rhs._SPM_e32_FACTORY &&
        _SPM_e32_QCRITICAL == rhs._SPM_e32_QCRITICAL);
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::operator != (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::operator < (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const {
    if (getSPM_e32_TRANSPORTMODE() < rhs.getSPM_e32_TRANSPORTMODE()) return true;
    if (getSPM_e32_TRANSPORTMODE() > rhs.getSPM_e32_TRANSPORTMODE()) return false;

    if (getSPM_e32_ROLLER() < rhs.getSPM_e32_ROLLER()) return true;
    if (getSPM_e32_ROLLER() > rhs.getSPM_e32_ROLLER()) return false;

    if (getSPM_e32_FACTORY() < rhs.getSPM_e32_FACTORY()) return true;
    if (getSPM_e32_FACTORY() > rhs.getSPM_e32_FACTORY()) return false;

    if (getSPM_e32_QCRITICAL() < rhs.getSPM_e32_QCRITICAL()) return true;
    if (getSPM_e32_QCRITICAL() > rhs.getSPM_e32_QCRITICAL()) return false;

    return false;
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::operator > (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_b32_SYSPWRSAVEMODE::setSPM_e32_TRANSPORTMODE (bool SPM_e32_TRANSPORTMODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_TRANSPORTMODE = SPM_e32_TRANSPORTMODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::getSPM_e32_TRANSPORTMODE () const {
    return _SPM_e32_TRANSPORTMODE;
}

inline void T_SPM_b32_SYSPWRSAVEMODE::setSPM_e32_ROLLER (bool SPM_e32_ROLLER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_ROLLER = SPM_e32_ROLLER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::getSPM_e32_ROLLER () const {
    return _SPM_e32_ROLLER;
}

inline void T_SPM_b32_SYSPWRSAVEMODE::setSPM_e32_FACTORY (bool SPM_e32_FACTORY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_FACTORY = SPM_e32_FACTORY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::getSPM_e32_FACTORY () const {
    return _SPM_e32_FACTORY;
}

inline void T_SPM_b32_SYSPWRSAVEMODE::setSPM_e32_QCRITICAL (bool SPM_e32_QCRITICAL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPM_e32_QCRITICAL = SPM_e32_QCRITICAL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_SPM_b32_SYSPWRSAVEMODE::getSPM_e32_QCRITICAL () const {
    return _SPM_e32_QCRITICAL;
}

inline  T_SPM_PartnumberItem::T_SPM_PartnumberItem ()  :
    _Part (NULL),
    _Number (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_PartnumberItem::T_SPM_PartnumberItem (const T_SPM_PartnumberItem &rhs)  :
    _Part (NULL),
    _Number (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_PartnumberItem::T_SPM_PartnumberItem (const ::std::string& Part_, uint32 Number_)  :
    _Part (new ::std::string(Part_)),
    _Number (Number_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_PartnumberItem::~T_SPM_PartnumberItem() {
    delete _Part;
}

inline T_SPM_PartnumberItem& T_SPM_PartnumberItem::operator = (const T_SPM_PartnumberItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPart()) {
            setPart(rhs.getPart());
        } else {
            clearPart();
        }
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
    }
    return *this;
}

inline bool T_SPM_PartnumberItem::operator == (const T_SPM_PartnumberItem& rhs) const {
    return (((!hasPart() && !rhs.hasPart()) || getPart() == rhs.getPart()) &&
        ((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()));
}

inline bool T_SPM_PartnumberItem::operator != (const T_SPM_PartnumberItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_PartnumberItem::operator < (const T_SPM_PartnumberItem& rhs) const {
    if (hasPart() || rhs.hasPart()) {
        if (getPart() < rhs.getPart()) return true;
        if (getPart() > rhs.getPart()) return false;
    }
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    return false;
}

inline bool T_SPM_PartnumberItem::operator > (const T_SPM_PartnumberItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_PartnumberItem::clear() {
    clearPart();
    clearNumber();
}

inline void T_SPM_PartnumberItem::clearPart() {
    if (hasPart()) {
         clear_has_Part();
        if (_Part != NULL) {
            _Part->clear();
        }
     }
}

inline bool T_SPM_PartnumberItem::hasPart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SPM_PartnumberItem::getPart () const {
    if (_Part == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Part;
}

inline ::std::string& T_SPM_PartnumberItem::getPartMutable () {
    set_has_Part();
    if (_Part == NULL) {
        _Part = new ::std::string ();
        CHECK_ALLOCATION( _Part );
    }
    return *_Part;
}

inline void T_SPM_PartnumberItem::setPart (const ::std::string& Part_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (Part_);
        CHECK_ALLOCATION( this->_Part );
    } else {
        *this->_Part = Part_;
    }
}

inline void T_SPM_PartnumberItem::setPart (const char* Part_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (Part_);
        CHECK_ALLOCATION( this->_Part );
    } else {
        this->_Part->assign(Part_);
    }
}

inline void T_SPM_PartnumberItem::setPart (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Part );
    } else {
        this->_Part->assign(value, size);
    }
}

inline ::std::string* T_SPM_PartnumberItem::releasePart() {
    clear_has_Part();
    ::std::string* temp = _Part;
    this->_Part = NULL;
    return temp;
}

inline void T_SPM_PartnumberItem::replacePart (::std::string* Part_) {
    set_has_Part();
    if (this->_Part != Part_) {
        if (this->_Part != NULL) {
            delete this->_Part;
        }
        this->_Part = Part_;
    }
}

inline void T_SPM_PartnumberItem::clearNumber() {
    if (hasNumber()) {
         clear_has_Number();
        _Number = 0u;
     }
}

inline bool T_SPM_PartnumberItem::hasNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SPM_PartnumberItem::getNumber () const {
    return _Number;
}

inline void T_SPM_PartnumberItem::setNumber (uint32 Number_) {
    set_has_Number();
    this->_Number = Number_;
}

inline void T_SPM_PartnumberItem::set_has_Part () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_PartnumberItem::clear_has_Part () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_PartnumberItem::set_has_Number () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_PartnumberItem::clear_has_Number () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SPM_AlphacodeItem::T_SPM_AlphacodeItem ()  :
    _Part (NULL),
    _Alphacode1 (0u),
    _Alphacode2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_AlphacodeItem::T_SPM_AlphacodeItem (const T_SPM_AlphacodeItem &rhs)  :
    _Part (NULL),
    _Alphacode1 (0u),
    _Alphacode2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_AlphacodeItem::T_SPM_AlphacodeItem (const ::std::string& Part_, uint8 Alphacode1_, uint8 Alphacode2_)  :
    _Part (new ::std::string(Part_)),
    _Alphacode1 (Alphacode1_),
    _Alphacode2 (Alphacode2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_AlphacodeItem::~T_SPM_AlphacodeItem() {
    delete _Part;
}

inline T_SPM_AlphacodeItem& T_SPM_AlphacodeItem::operator = (const T_SPM_AlphacodeItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPart()) {
            setPart(rhs.getPart());
        } else {
            clearPart();
        }
        if (rhs.hasAlphacode1()) {
            setAlphacode1(rhs.getAlphacode1());
        } else {
            clearAlphacode1();
        }
        if (rhs.hasAlphacode2()) {
            setAlphacode2(rhs.getAlphacode2());
        } else {
            clearAlphacode2();
        }
    }
    return *this;
}

inline bool T_SPM_AlphacodeItem::operator == (const T_SPM_AlphacodeItem& rhs) const {
    return (((!hasPart() && !rhs.hasPart()) || getPart() == rhs.getPart()) &&
        ((!hasAlphacode1() && !rhs.hasAlphacode1()) || getAlphacode1() == rhs.getAlphacode1()) &&
        ((!hasAlphacode2() && !rhs.hasAlphacode2()) || getAlphacode2() == rhs.getAlphacode2()));
}

inline bool T_SPM_AlphacodeItem::operator != (const T_SPM_AlphacodeItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_AlphacodeItem::operator < (const T_SPM_AlphacodeItem& rhs) const {
    if (hasPart() || rhs.hasPart()) {
        if (getPart() < rhs.getPart()) return true;
        if (getPart() > rhs.getPart()) return false;
    }
    if (hasAlphacode1() || rhs.hasAlphacode1()) {
        if (getAlphacode1() < rhs.getAlphacode1()) return true;
        if (getAlphacode1() > rhs.getAlphacode1()) return false;
    }
    if (hasAlphacode2() || rhs.hasAlphacode2()) {
        if (getAlphacode2() < rhs.getAlphacode2()) return true;
        if (getAlphacode2() > rhs.getAlphacode2()) return false;
    }
    return false;
}

inline bool T_SPM_AlphacodeItem::operator > (const T_SPM_AlphacodeItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_AlphacodeItem::clear() {
    clearPart();
    clearAlphacode1();
    clearAlphacode2();
}

inline void T_SPM_AlphacodeItem::clearPart() {
    if (hasPart()) {
         clear_has_Part();
        if (_Part != NULL) {
            _Part->clear();
        }
     }
}

inline bool T_SPM_AlphacodeItem::hasPart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SPM_AlphacodeItem::getPart () const {
    if (_Part == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Part;
}

inline ::std::string& T_SPM_AlphacodeItem::getPartMutable () {
    set_has_Part();
    if (_Part == NULL) {
        _Part = new ::std::string ();
        CHECK_ALLOCATION( _Part );
    }
    return *_Part;
}

inline void T_SPM_AlphacodeItem::setPart (const ::std::string& Part_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (Part_);
        CHECK_ALLOCATION( this->_Part );
    } else {
        *this->_Part = Part_;
    }
}

inline void T_SPM_AlphacodeItem::setPart (const char* Part_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Part_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (Part_);
        CHECK_ALLOCATION( this->_Part );
    } else {
        this->_Part->assign(Part_);
    }
}

inline void T_SPM_AlphacodeItem::setPart (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Part();
    if (this->_Part == NULL) {
        this->_Part = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Part );
    } else {
        this->_Part->assign(value, size);
    }
}

inline ::std::string* T_SPM_AlphacodeItem::releasePart() {
    clear_has_Part();
    ::std::string* temp = _Part;
    this->_Part = NULL;
    return temp;
}

inline void T_SPM_AlphacodeItem::replacePart (::std::string* Part_) {
    set_has_Part();
    if (this->_Part != Part_) {
        if (this->_Part != NULL) {
            delete this->_Part;
        }
        this->_Part = Part_;
    }
}

inline void T_SPM_AlphacodeItem::clearAlphacode1() {
    if (hasAlphacode1()) {
         clear_has_Alphacode1();
        _Alphacode1 = 0u;
     }
}

inline bool T_SPM_AlphacodeItem::hasAlphacode1 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SPM_AlphacodeItem::getAlphacode1 () const {
    return _Alphacode1;
}

inline void T_SPM_AlphacodeItem::setAlphacode1 (uint8 Alphacode1_) {
    set_has_Alphacode1();
    this->_Alphacode1 = Alphacode1_;
}

inline void T_SPM_AlphacodeItem::clearAlphacode2() {
    if (hasAlphacode2()) {
         clear_has_Alphacode2();
        _Alphacode2 = 0u;
     }
}

inline bool T_SPM_AlphacodeItem::hasAlphacode2 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_SPM_AlphacodeItem::getAlphacode2 () const {
    return _Alphacode2;
}

inline void T_SPM_AlphacodeItem::setAlphacode2 (uint8 Alphacode2_) {
    set_has_Alphacode2();
    this->_Alphacode2 = Alphacode2_;
}

inline void T_SPM_AlphacodeItem::set_has_Part () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_AlphacodeItem::clear_has_Part () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_AlphacodeItem::set_has_Alphacode1 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_AlphacodeItem::clear_has_Alphacode1 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_AlphacodeItem::set_has_Alphacode2 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_AlphacodeItem::clear_has_Alphacode2 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SPM_RestrictedDlLock::T_SPM_RestrictedDlLock ()  :
    _strRestrictedLockArea (NULL),
    _u16AppIdLockOwner (0u),
    _u16AppIdLockRequester (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_RestrictedDlLock::T_SPM_RestrictedDlLock (const T_SPM_RestrictedDlLock &rhs)  :
    _strRestrictedLockArea (NULL),
    _u16AppIdLockOwner (0u),
    _u16AppIdLockRequester (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_RestrictedDlLock::T_SPM_RestrictedDlLock (const ::std::string& strRestrictedLockArea_, uint16 u16AppIdLockOwner_, uint16 u16AppIdLockRequester_)  :
    _strRestrictedLockArea (new ::std::string(strRestrictedLockArea_)),
    _u16AppIdLockOwner (u16AppIdLockOwner_),
    _u16AppIdLockRequester (u16AppIdLockRequester_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedLockArea_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_RestrictedDlLock::~T_SPM_RestrictedDlLock() {
    delete _strRestrictedLockArea;
}

inline T_SPM_RestrictedDlLock& T_SPM_RestrictedDlLock::operator = (const T_SPM_RestrictedDlLock& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrRestrictedLockArea()) {
            setStrRestrictedLockArea(rhs.getStrRestrictedLockArea());
        } else {
            clearStrRestrictedLockArea();
        }
        if (rhs.hasU16AppIdLockOwner()) {
            setU16AppIdLockOwner(rhs.getU16AppIdLockOwner());
        } else {
            clearU16AppIdLockOwner();
        }
        if (rhs.hasU16AppIdLockRequester()) {
            setU16AppIdLockRequester(rhs.getU16AppIdLockRequester());
        } else {
            clearU16AppIdLockRequester();
        }
    }
    return *this;
}

inline bool T_SPM_RestrictedDlLock::operator == (const T_SPM_RestrictedDlLock& rhs) const {
    return (((!hasStrRestrictedLockArea() && !rhs.hasStrRestrictedLockArea()) || getStrRestrictedLockArea() == rhs.getStrRestrictedLockArea()) &&
        ((!hasU16AppIdLockOwner() && !rhs.hasU16AppIdLockOwner()) || getU16AppIdLockOwner() == rhs.getU16AppIdLockOwner()) &&
        ((!hasU16AppIdLockRequester() && !rhs.hasU16AppIdLockRequester()) || getU16AppIdLockRequester() == rhs.getU16AppIdLockRequester()));
}

inline bool T_SPM_RestrictedDlLock::operator != (const T_SPM_RestrictedDlLock& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_RestrictedDlLock::operator < (const T_SPM_RestrictedDlLock& rhs) const {
    if (hasStrRestrictedLockArea() || rhs.hasStrRestrictedLockArea()) {
        if (getStrRestrictedLockArea() < rhs.getStrRestrictedLockArea()) return true;
        if (getStrRestrictedLockArea() > rhs.getStrRestrictedLockArea()) return false;
    }
    if (hasU16AppIdLockOwner() || rhs.hasU16AppIdLockOwner()) {
        if (getU16AppIdLockOwner() < rhs.getU16AppIdLockOwner()) return true;
        if (getU16AppIdLockOwner() > rhs.getU16AppIdLockOwner()) return false;
    }
    if (hasU16AppIdLockRequester() || rhs.hasU16AppIdLockRequester()) {
        if (getU16AppIdLockRequester() < rhs.getU16AppIdLockRequester()) return true;
        if (getU16AppIdLockRequester() > rhs.getU16AppIdLockRequester()) return false;
    }
    return false;
}

inline bool T_SPM_RestrictedDlLock::operator > (const T_SPM_RestrictedDlLock& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_RestrictedDlLock::clear() {
    clearStrRestrictedLockArea();
    clearU16AppIdLockOwner();
    clearU16AppIdLockRequester();
}

inline void T_SPM_RestrictedDlLock::clearStrRestrictedLockArea() {
    if (hasStrRestrictedLockArea()) {
         clear_has_strRestrictedLockArea();
        if (_strRestrictedLockArea != NULL) {
            _strRestrictedLockArea->clear();
        }
     }
}

inline bool T_SPM_RestrictedDlLock::hasStrRestrictedLockArea () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SPM_RestrictedDlLock::getStrRestrictedLockArea () const {
    if (_strRestrictedLockArea == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strRestrictedLockArea;
}

inline ::std::string& T_SPM_RestrictedDlLock::getStrRestrictedLockAreaMutable () {
    set_has_strRestrictedLockArea();
    if (_strRestrictedLockArea == NULL) {
        _strRestrictedLockArea = new ::std::string ();
        CHECK_ALLOCATION( _strRestrictedLockArea );
    }
    return *_strRestrictedLockArea;
}

inline void T_SPM_RestrictedDlLock::setStrRestrictedLockArea (const ::std::string& strRestrictedLockArea_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedLockArea_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedLockArea();
    if (this->_strRestrictedLockArea == NULL) {
        this->_strRestrictedLockArea = new ::std::string (strRestrictedLockArea_);
        CHECK_ALLOCATION( this->_strRestrictedLockArea );
    } else {
        *this->_strRestrictedLockArea = strRestrictedLockArea_;
    }
}

inline void T_SPM_RestrictedDlLock::setStrRestrictedLockArea (const char* strRestrictedLockArea_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedLockArea_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedLockArea();
    if (this->_strRestrictedLockArea == NULL) {
        this->_strRestrictedLockArea = new ::std::string (strRestrictedLockArea_);
        CHECK_ALLOCATION( this->_strRestrictedLockArea );
    } else {
        this->_strRestrictedLockArea->assign(strRestrictedLockArea_);
    }
}

inline void T_SPM_RestrictedDlLock::setStrRestrictedLockArea (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedLockArea();
    if (this->_strRestrictedLockArea == NULL) {
        this->_strRestrictedLockArea = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strRestrictedLockArea );
    } else {
        this->_strRestrictedLockArea->assign(value, size);
    }
}

inline ::std::string* T_SPM_RestrictedDlLock::releaseStrRestrictedLockArea() {
    clear_has_strRestrictedLockArea();
    ::std::string* temp = _strRestrictedLockArea;
    this->_strRestrictedLockArea = NULL;
    return temp;
}

inline void T_SPM_RestrictedDlLock::replaceStrRestrictedLockArea (::std::string* strRestrictedLockArea_) {
    set_has_strRestrictedLockArea();
    if (this->_strRestrictedLockArea != strRestrictedLockArea_) {
        if (this->_strRestrictedLockArea != NULL) {
            delete this->_strRestrictedLockArea;
        }
        this->_strRestrictedLockArea = strRestrictedLockArea_;
    }
}

inline void T_SPM_RestrictedDlLock::clearU16AppIdLockOwner() {
    if (hasU16AppIdLockOwner()) {
         clear_has_u16AppIdLockOwner();
        _u16AppIdLockOwner = 0u;
     }
}

inline bool T_SPM_RestrictedDlLock::hasU16AppIdLockOwner () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SPM_RestrictedDlLock::getU16AppIdLockOwner () const {
    return _u16AppIdLockOwner;
}

inline void T_SPM_RestrictedDlLock::setU16AppIdLockOwner (uint16 u16AppIdLockOwner_) {
    set_has_u16AppIdLockOwner();
    this->_u16AppIdLockOwner = u16AppIdLockOwner_;
}

inline void T_SPM_RestrictedDlLock::clearU16AppIdLockRequester() {
    if (hasU16AppIdLockRequester()) {
         clear_has_u16AppIdLockRequester();
        _u16AppIdLockRequester = 0u;
     }
}

inline bool T_SPM_RestrictedDlLock::hasU16AppIdLockRequester () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_SPM_RestrictedDlLock::getU16AppIdLockRequester () const {
    return _u16AppIdLockRequester;
}

inline void T_SPM_RestrictedDlLock::setU16AppIdLockRequester (uint16 u16AppIdLockRequester_) {
    set_has_u16AppIdLockRequester();
    this->_u16AppIdLockRequester = u16AppIdLockRequester_;
}

inline void T_SPM_RestrictedDlLock::set_has_strRestrictedLockArea () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_RestrictedDlLock::clear_has_strRestrictedLockArea () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_RestrictedDlLock::set_has_u16AppIdLockOwner () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_RestrictedDlLock::clear_has_u16AppIdLockOwner () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_RestrictedDlLock::set_has_u16AppIdLockRequester () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_RestrictedDlLock::clear_has_u16AppIdLockRequester () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SPM_UpdateLockState::T_SPM_UpdateLockState ()  :
    _strLockName (NULL),
    _eLockState (::spm_core_fi_types::T_e8_UpdateLockState__SPM_e8_Used),
    _u16LockOwner (0u),
    _lu16LockUsers (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_UpdateLockState::T_SPM_UpdateLockState (const T_SPM_UpdateLockState &rhs)  :
    _strLockName (NULL),
    _eLockState (::spm_core_fi_types::T_e8_UpdateLockState__SPM_e8_Used),
    _u16LockOwner (0u),
    _lu16LockUsers (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_UpdateLockState::T_SPM_UpdateLockState (const ::std::string& strLockName_, T_e8_UpdateLockState eLockState_, uint16 u16LockOwner_, const ::std::vector< uint16 >& lu16LockUsers_)  :
    _strLockName (new ::std::string(strLockName_)),
    _eLockState (eLockState_),
    _u16LockOwner (u16LockOwner_),
    _lu16LockUsers (new ::std::vector< uint16 >(lu16LockUsers_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_UpdateLockState_IsValid(eLockState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eLockState_, "T_e8_UpdateLockState", "eLockState", "T_SPM_UpdateLockState");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_UpdateLockState::~T_SPM_UpdateLockState() {
    delete _strLockName;
    delete _lu16LockUsers;
}

inline T_SPM_UpdateLockState& T_SPM_UpdateLockState::operator = (const T_SPM_UpdateLockState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrLockName()) {
            setStrLockName(rhs.getStrLockName());
        } else {
            clearStrLockName();
        }
        if (rhs.hasELockState()) {
            setELockState(rhs.getELockState());
        } else {
            clearELockState();
        }
        if (rhs.hasU16LockOwner()) {
            setU16LockOwner(rhs.getU16LockOwner());
        } else {
            clearU16LockOwner();
        }
        if (rhs.hasLu16LockUsers()) {
            setLu16LockUsers(rhs.getLu16LockUsers());
        } else {
            clearLu16LockUsers();
        }
    }
    return *this;
}

inline bool T_SPM_UpdateLockState::operator == (const T_SPM_UpdateLockState& rhs) const {
    return (((!hasStrLockName() && !rhs.hasStrLockName()) || getStrLockName() == rhs.getStrLockName()) &&
        ((!hasELockState() && !rhs.hasELockState()) || getELockState() == rhs.getELockState()) &&
        ((!hasU16LockOwner() && !rhs.hasU16LockOwner()) || getU16LockOwner() == rhs.getU16LockOwner()) &&
        ((!hasLu16LockUsers() && !rhs.hasLu16LockUsers()) || getLu16LockUsers() == rhs.getLu16LockUsers()));
}

inline bool T_SPM_UpdateLockState::operator != (const T_SPM_UpdateLockState& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_UpdateLockState::operator < (const T_SPM_UpdateLockState& rhs) const {
    if (hasStrLockName() || rhs.hasStrLockName()) {
        if (getStrLockName() < rhs.getStrLockName()) return true;
        if (getStrLockName() > rhs.getStrLockName()) return false;
    }
    if (hasELockState() || rhs.hasELockState()) {
        if ((uint32)getELockState() < (uint32)rhs.getELockState()) return true;
        if ((uint32)getELockState() > (uint32)rhs.getELockState()) return false;
    }
    if (hasU16LockOwner() || rhs.hasU16LockOwner()) {
        if (getU16LockOwner() < rhs.getU16LockOwner()) return true;
        if (getU16LockOwner() > rhs.getU16LockOwner()) return false;
    }
    if (hasLu16LockUsers() || rhs.hasLu16LockUsers()) {
        if (getLu16LockUsers() < rhs.getLu16LockUsers()) return true;
        if (getLu16LockUsers() > rhs.getLu16LockUsers()) return false;
    }
    return false;
}

inline bool T_SPM_UpdateLockState::operator > (const T_SPM_UpdateLockState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_UpdateLockState::clear() {
    clearStrLockName();
    clearELockState();
    clearU16LockOwner();
    clearLu16LockUsers();
}

inline void T_SPM_UpdateLockState::clearStrLockName() {
    if (hasStrLockName()) {
         clear_has_strLockName();
        if (_strLockName != NULL) {
            _strLockName->clear();
        }
     }
}

inline bool T_SPM_UpdateLockState::hasStrLockName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SPM_UpdateLockState::getStrLockName () const {
    if (_strLockName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strLockName;
}

inline ::std::string& T_SPM_UpdateLockState::getStrLockNameMutable () {
    set_has_strLockName();
    if (_strLockName == NULL) {
        _strLockName = new ::std::string ();
        CHECK_ALLOCATION( _strLockName );
    }
    return *_strLockName;
}

inline void T_SPM_UpdateLockState::setStrLockName (const ::std::string& strLockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (strLockName_);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        *this->_strLockName = strLockName_;
    }
}

inline void T_SPM_UpdateLockState::setStrLockName (const char* strLockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (strLockName_);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        this->_strLockName->assign(strLockName_);
    }
}

inline void T_SPM_UpdateLockState::setStrLockName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        this->_strLockName->assign(value, size);
    }
}

inline ::std::string* T_SPM_UpdateLockState::releaseStrLockName() {
    clear_has_strLockName();
    ::std::string* temp = _strLockName;
    this->_strLockName = NULL;
    return temp;
}

inline void T_SPM_UpdateLockState::replaceStrLockName (::std::string* strLockName_) {
    set_has_strLockName();
    if (this->_strLockName != strLockName_) {
        if (this->_strLockName != NULL) {
            delete this->_strLockName;
        }
        this->_strLockName = strLockName_;
    }
}

inline void T_SPM_UpdateLockState::clearELockState() {
    if (hasELockState()) {
         clear_has_eLockState();
        _eLockState = ::spm_core_fi_types::T_e8_UpdateLockState__SPM_e8_Used;
     }
}

inline bool T_SPM_UpdateLockState::hasELockState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_UpdateLockState T_SPM_UpdateLockState::getELockState () const {
    return _eLockState;
}

inline void T_SPM_UpdateLockState::setELockState (T_e8_UpdateLockState eLockState_) {
    #ifndef NDEBUG
    if (!(T_e8_UpdateLockState_IsValid(eLockState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eLockState_, "T_e8_UpdateLockState", "eLockState", "T_SPM_UpdateLockState");
    }
    #endif
    set_has_eLockState();
    this->_eLockState = eLockState_;
}

inline void T_SPM_UpdateLockState::clearU16LockOwner() {
    if (hasU16LockOwner()) {
         clear_has_u16LockOwner();
        _u16LockOwner = 0u;
     }
}

inline bool T_SPM_UpdateLockState::hasU16LockOwner () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_SPM_UpdateLockState::getU16LockOwner () const {
    return _u16LockOwner;
}

inline void T_SPM_UpdateLockState::setU16LockOwner (uint16 u16LockOwner_) {
    set_has_u16LockOwner();
    this->_u16LockOwner = u16LockOwner_;
}

inline void T_SPM_UpdateLockState::clearLu16LockUsers() {
    if (hasLu16LockUsers()) {
         clear_has_lu16LockUsers();
        if (_lu16LockUsers != NULL) {
            _lu16LockUsers->clear();
        }
     }
}

inline bool T_SPM_UpdateLockState::hasLu16LockUsers () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< uint16 >& T_SPM_UpdateLockState::getLu16LockUsers () const {
    if (_lu16LockUsers == NULL) {
        return getUint16List_DefaultInstance();
    }
    return *_lu16LockUsers;
}

inline ::std::vector< uint16 >& T_SPM_UpdateLockState::getLu16LockUsersMutable () {
    set_has_lu16LockUsers();
    if (_lu16LockUsers == NULL) {
        _lu16LockUsers = new ::std::vector< uint16 > ();
        CHECK_ALLOCATION( _lu16LockUsers );
    }
    return *_lu16LockUsers;
}

inline void T_SPM_UpdateLockState::setLu16LockUsers (const ::std::vector< uint16 >& lu16LockUsers_) {
    set_has_lu16LockUsers();
    if (this->_lu16LockUsers == NULL) {
        this->_lu16LockUsers = new ::std::vector< uint16 > (lu16LockUsers_);
        CHECK_ALLOCATION( this->_lu16LockUsers );
    } else {
        *this->_lu16LockUsers = lu16LockUsers_;
    }
}

inline ::std::vector< uint16 >* T_SPM_UpdateLockState::releaseLu16LockUsers() {
    clear_has_lu16LockUsers();
    ::std::vector< uint16 >* temp = _lu16LockUsers;
    this->_lu16LockUsers = NULL;
    return temp;
}

inline void T_SPM_UpdateLockState::replaceLu16LockUsers (::std::vector< uint16 >* lu16LockUsers_) {
    set_has_lu16LockUsers();
    if (this->_lu16LockUsers != lu16LockUsers_) {
        if (this->_lu16LockUsers != NULL) {
            delete this->_lu16LockUsers;
        }
        this->_lu16LockUsers = lu16LockUsers_;
    }
}

inline void T_SPM_UpdateLockState::set_has_strLockName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_UpdateLockState::clear_has_strLockName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_UpdateLockState::set_has_eLockState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_UpdateLockState::clear_has_eLockState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_UpdateLockState::set_has_u16LockOwner () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_UpdateLockState::clear_has_u16LockOwner () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_UpdateLockState::set_has_lu16LockUsers () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_UpdateLockState::clear_has_lu16LockUsers () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SPM_VoltageEventCounter::T_SPM_VoltageEventCounter ()  :
    _LowVoltageCount (0u),
    _CrLowVoltageCount (0u),
    _HighVoltageCount (0u),
    _CrHighVoltageCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_VoltageEventCounter::T_SPM_VoltageEventCounter (const T_SPM_VoltageEventCounter &rhs)  :
    _LowVoltageCount (0u),
    _CrLowVoltageCount (0u),
    _HighVoltageCount (0u),
    _CrHighVoltageCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_VoltageEventCounter::T_SPM_VoltageEventCounter (uint32 LowVoltageCount_, uint32 CrLowVoltageCount_, uint32 HighVoltageCount_, uint32 CrHighVoltageCount_)  :
    _LowVoltageCount (LowVoltageCount_),
    _CrLowVoltageCount (CrLowVoltageCount_),
    _HighVoltageCount (HighVoltageCount_),
    _CrHighVoltageCount (CrHighVoltageCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_VoltageEventCounter::~T_SPM_VoltageEventCounter() {
}

inline T_SPM_VoltageEventCounter& T_SPM_VoltageEventCounter::operator = (const T_SPM_VoltageEventCounter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLowVoltageCount()) {
            setLowVoltageCount(rhs.getLowVoltageCount());
        } else {
            clearLowVoltageCount();
        }
        if (rhs.hasCrLowVoltageCount()) {
            setCrLowVoltageCount(rhs.getCrLowVoltageCount());
        } else {
            clearCrLowVoltageCount();
        }
        if (rhs.hasHighVoltageCount()) {
            setHighVoltageCount(rhs.getHighVoltageCount());
        } else {
            clearHighVoltageCount();
        }
        if (rhs.hasCrHighVoltageCount()) {
            setCrHighVoltageCount(rhs.getCrHighVoltageCount());
        } else {
            clearCrHighVoltageCount();
        }
    }
    return *this;
}

inline bool T_SPM_VoltageEventCounter::operator == (const T_SPM_VoltageEventCounter& rhs) const {
    return (((!hasLowVoltageCount() && !rhs.hasLowVoltageCount()) || getLowVoltageCount() == rhs.getLowVoltageCount()) &&
        ((!hasCrLowVoltageCount() && !rhs.hasCrLowVoltageCount()) || getCrLowVoltageCount() == rhs.getCrLowVoltageCount()) &&
        ((!hasHighVoltageCount() && !rhs.hasHighVoltageCount()) || getHighVoltageCount() == rhs.getHighVoltageCount()) &&
        ((!hasCrHighVoltageCount() && !rhs.hasCrHighVoltageCount()) || getCrHighVoltageCount() == rhs.getCrHighVoltageCount()));
}

inline bool T_SPM_VoltageEventCounter::operator != (const T_SPM_VoltageEventCounter& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_VoltageEventCounter::operator < (const T_SPM_VoltageEventCounter& rhs) const {
    if (hasLowVoltageCount() || rhs.hasLowVoltageCount()) {
        if (getLowVoltageCount() < rhs.getLowVoltageCount()) return true;
        if (getLowVoltageCount() > rhs.getLowVoltageCount()) return false;
    }
    if (hasCrLowVoltageCount() || rhs.hasCrLowVoltageCount()) {
        if (getCrLowVoltageCount() < rhs.getCrLowVoltageCount()) return true;
        if (getCrLowVoltageCount() > rhs.getCrLowVoltageCount()) return false;
    }
    if (hasHighVoltageCount() || rhs.hasHighVoltageCount()) {
        if (getHighVoltageCount() < rhs.getHighVoltageCount()) return true;
        if (getHighVoltageCount() > rhs.getHighVoltageCount()) return false;
    }
    if (hasCrHighVoltageCount() || rhs.hasCrHighVoltageCount()) {
        if (getCrHighVoltageCount() < rhs.getCrHighVoltageCount()) return true;
        if (getCrHighVoltageCount() > rhs.getCrHighVoltageCount()) return false;
    }
    return false;
}

inline bool T_SPM_VoltageEventCounter::operator > (const T_SPM_VoltageEventCounter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_VoltageEventCounter::clear() {
    clearLowVoltageCount();
    clearCrLowVoltageCount();
    clearHighVoltageCount();
    clearCrHighVoltageCount();
}

inline void T_SPM_VoltageEventCounter::clearLowVoltageCount() {
    if (hasLowVoltageCount()) {
         clear_has_LowVoltageCount();
        _LowVoltageCount = 0u;
     }
}

inline bool T_SPM_VoltageEventCounter::hasLowVoltageCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SPM_VoltageEventCounter::getLowVoltageCount () const {
    return _LowVoltageCount;
}

inline void T_SPM_VoltageEventCounter::setLowVoltageCount (uint32 LowVoltageCount_) {
    set_has_LowVoltageCount();
    this->_LowVoltageCount = LowVoltageCount_;
}

inline void T_SPM_VoltageEventCounter::clearCrLowVoltageCount() {
    if (hasCrLowVoltageCount()) {
         clear_has_CrLowVoltageCount();
        _CrLowVoltageCount = 0u;
     }
}

inline bool T_SPM_VoltageEventCounter::hasCrLowVoltageCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SPM_VoltageEventCounter::getCrLowVoltageCount () const {
    return _CrLowVoltageCount;
}

inline void T_SPM_VoltageEventCounter::setCrLowVoltageCount (uint32 CrLowVoltageCount_) {
    set_has_CrLowVoltageCount();
    this->_CrLowVoltageCount = CrLowVoltageCount_;
}

inline void T_SPM_VoltageEventCounter::clearHighVoltageCount() {
    if (hasHighVoltageCount()) {
         clear_has_HighVoltageCount();
        _HighVoltageCount = 0u;
     }
}

inline bool T_SPM_VoltageEventCounter::hasHighVoltageCount () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SPM_VoltageEventCounter::getHighVoltageCount () const {
    return _HighVoltageCount;
}

inline void T_SPM_VoltageEventCounter::setHighVoltageCount (uint32 HighVoltageCount_) {
    set_has_HighVoltageCount();
    this->_HighVoltageCount = HighVoltageCount_;
}

inline void T_SPM_VoltageEventCounter::clearCrHighVoltageCount() {
    if (hasCrHighVoltageCount()) {
         clear_has_CrHighVoltageCount();
        _CrHighVoltageCount = 0u;
     }
}

inline bool T_SPM_VoltageEventCounter::hasCrHighVoltageCount () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SPM_VoltageEventCounter::getCrHighVoltageCount () const {
    return _CrHighVoltageCount;
}

inline void T_SPM_VoltageEventCounter::setCrHighVoltageCount (uint32 CrHighVoltageCount_) {
    set_has_CrHighVoltageCount();
    this->_CrHighVoltageCount = CrHighVoltageCount_;
}

inline void T_SPM_VoltageEventCounter::set_has_LowVoltageCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_VoltageEventCounter::clear_has_LowVoltageCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_VoltageEventCounter::set_has_CrLowVoltageCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_VoltageEventCounter::clear_has_CrLowVoltageCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_VoltageEventCounter::set_has_HighVoltageCount () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_VoltageEventCounter::clear_has_HighVoltageCount () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_VoltageEventCounter::set_has_CrHighVoltageCount () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_VoltageEventCounter::clear_has_CrHighVoltageCount () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SPM_VoltageRange::T_SPM_VoltageRange ()  :
    _VoltageValue (0u),
    _OperationTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_VoltageRange::T_SPM_VoltageRange (const T_SPM_VoltageRange &rhs)  :
    _VoltageValue (0u),
    _OperationTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_VoltageRange::T_SPM_VoltageRange (uint16 VoltageValue_, uint32 OperationTime_)  :
    _VoltageValue (VoltageValue_),
    _OperationTime (OperationTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_VoltageRange::~T_SPM_VoltageRange() {
}

inline T_SPM_VoltageRange& T_SPM_VoltageRange::operator = (const T_SPM_VoltageRange& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVoltageValue()) {
            setVoltageValue(rhs.getVoltageValue());
        } else {
            clearVoltageValue();
        }
        if (rhs.hasOperationTime()) {
            setOperationTime(rhs.getOperationTime());
        } else {
            clearOperationTime();
        }
    }
    return *this;
}

inline bool T_SPM_VoltageRange::operator == (const T_SPM_VoltageRange& rhs) const {
    return (((!hasVoltageValue() && !rhs.hasVoltageValue()) || getVoltageValue() == rhs.getVoltageValue()) &&
        ((!hasOperationTime() && !rhs.hasOperationTime()) || getOperationTime() == rhs.getOperationTime()));
}

inline bool T_SPM_VoltageRange::operator != (const T_SPM_VoltageRange& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_VoltageRange::operator < (const T_SPM_VoltageRange& rhs) const {
    if (hasVoltageValue() || rhs.hasVoltageValue()) {
        if (getVoltageValue() < rhs.getVoltageValue()) return true;
        if (getVoltageValue() > rhs.getVoltageValue()) return false;
    }
    if (hasOperationTime() || rhs.hasOperationTime()) {
        if (getOperationTime() < rhs.getOperationTime()) return true;
        if (getOperationTime() > rhs.getOperationTime()) return false;
    }
    return false;
}

inline bool T_SPM_VoltageRange::operator > (const T_SPM_VoltageRange& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_VoltageRange::clear() {
    clearVoltageValue();
    clearOperationTime();
}

inline void T_SPM_VoltageRange::clearVoltageValue() {
    if (hasVoltageValue()) {
         clear_has_VoltageValue();
        _VoltageValue = 0u;
     }
}

inline bool T_SPM_VoltageRange::hasVoltageValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SPM_VoltageRange::getVoltageValue () const {
    return _VoltageValue;
}

inline void T_SPM_VoltageRange::setVoltageValue (uint16 VoltageValue_) {
    set_has_VoltageValue();
    this->_VoltageValue = VoltageValue_;
}

inline void T_SPM_VoltageRange::clearOperationTime() {
    if (hasOperationTime()) {
         clear_has_OperationTime();
        _OperationTime = 0u;
     }
}

inline bool T_SPM_VoltageRange::hasOperationTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SPM_VoltageRange::getOperationTime () const {
    return _OperationTime;
}

inline void T_SPM_VoltageRange::setOperationTime (uint32 OperationTime_) {
    set_has_OperationTime();
    this->_OperationTime = OperationTime_;
}

inline void T_SPM_VoltageRange::set_has_VoltageValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_VoltageRange::clear_has_VoltageValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_VoltageRange::set_has_OperationTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_VoltageRange::clear_has_OperationTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SPM_SystemStatisticsData::T_SPM_SystemStatisticsData ()  :
    _MaxValue (0u),
    _AvgValue (0u),
    _MinValue (0u),
    _StatisticDataDisabled (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_SystemStatisticsData::T_SPM_SystemStatisticsData (const T_SPM_SystemStatisticsData &rhs)  :
    _MaxValue (0u),
    _AvgValue (0u),
    _MinValue (0u),
    _StatisticDataDisabled (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_SystemStatisticsData::T_SPM_SystemStatisticsData (uint32 MaxValue_, uint32 AvgValue_, uint32 MinValue_, bool StatisticDataDisabled_)  :
    _MaxValue (MaxValue_),
    _AvgValue (AvgValue_),
    _MinValue (MinValue_),
    _StatisticDataDisabled (StatisticDataDisabled_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_SystemStatisticsData::~T_SPM_SystemStatisticsData() {
}

inline T_SPM_SystemStatisticsData& T_SPM_SystemStatisticsData::operator = (const T_SPM_SystemStatisticsData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMaxValue()) {
            setMaxValue(rhs.getMaxValue());
        } else {
            clearMaxValue();
        }
        if (rhs.hasAvgValue()) {
            setAvgValue(rhs.getAvgValue());
        } else {
            clearAvgValue();
        }
        if (rhs.hasMinValue()) {
            setMinValue(rhs.getMinValue());
        } else {
            clearMinValue();
        }
        if (rhs.hasStatisticDataDisabled()) {
            setStatisticDataDisabled(rhs.getStatisticDataDisabled());
        } else {
            clearStatisticDataDisabled();
        }
    }
    return *this;
}

inline bool T_SPM_SystemStatisticsData::operator == (const T_SPM_SystemStatisticsData& rhs) const {
    return (((!hasMaxValue() && !rhs.hasMaxValue()) || getMaxValue() == rhs.getMaxValue()) &&
        ((!hasAvgValue() && !rhs.hasAvgValue()) || getAvgValue() == rhs.getAvgValue()) &&
        ((!hasMinValue() && !rhs.hasMinValue()) || getMinValue() == rhs.getMinValue()) &&
        ((!hasStatisticDataDisabled() && !rhs.hasStatisticDataDisabled()) || getStatisticDataDisabled() == rhs.getStatisticDataDisabled()));
}

inline bool T_SPM_SystemStatisticsData::operator != (const T_SPM_SystemStatisticsData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_SystemStatisticsData::operator < (const T_SPM_SystemStatisticsData& rhs) const {
    if (hasMaxValue() || rhs.hasMaxValue()) {
        if (getMaxValue() < rhs.getMaxValue()) return true;
        if (getMaxValue() > rhs.getMaxValue()) return false;
    }
    if (hasAvgValue() || rhs.hasAvgValue()) {
        if (getAvgValue() < rhs.getAvgValue()) return true;
        if (getAvgValue() > rhs.getAvgValue()) return false;
    }
    if (hasMinValue() || rhs.hasMinValue()) {
        if (getMinValue() < rhs.getMinValue()) return true;
        if (getMinValue() > rhs.getMinValue()) return false;
    }
    if (hasStatisticDataDisabled() || rhs.hasStatisticDataDisabled()) {
        if (getStatisticDataDisabled() < rhs.getStatisticDataDisabled()) return true;
        if (getStatisticDataDisabled() > rhs.getStatisticDataDisabled()) return false;
    }
    return false;
}

inline bool T_SPM_SystemStatisticsData::operator > (const T_SPM_SystemStatisticsData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_SystemStatisticsData::clear() {
    clearMaxValue();
    clearAvgValue();
    clearMinValue();
    clearStatisticDataDisabled();
}

inline void T_SPM_SystemStatisticsData::clearMaxValue() {
    if (hasMaxValue()) {
         clear_has_MaxValue();
        _MaxValue = 0u;
     }
}

inline bool T_SPM_SystemStatisticsData::hasMaxValue () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SPM_SystemStatisticsData::getMaxValue () const {
    return _MaxValue;
}

inline void T_SPM_SystemStatisticsData::setMaxValue (uint32 MaxValue_) {
    set_has_MaxValue();
    this->_MaxValue = MaxValue_;
}

inline void T_SPM_SystemStatisticsData::clearAvgValue() {
    if (hasAvgValue()) {
         clear_has_AvgValue();
        _AvgValue = 0u;
     }
}

inline bool T_SPM_SystemStatisticsData::hasAvgValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SPM_SystemStatisticsData::getAvgValue () const {
    return _AvgValue;
}

inline void T_SPM_SystemStatisticsData::setAvgValue (uint32 AvgValue_) {
    set_has_AvgValue();
    this->_AvgValue = AvgValue_;
}

inline void T_SPM_SystemStatisticsData::clearMinValue() {
    if (hasMinValue()) {
         clear_has_MinValue();
        _MinValue = 0u;
     }
}

inline bool T_SPM_SystemStatisticsData::hasMinValue () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SPM_SystemStatisticsData::getMinValue () const {
    return _MinValue;
}

inline void T_SPM_SystemStatisticsData::setMinValue (uint32 MinValue_) {
    set_has_MinValue();
    this->_MinValue = MinValue_;
}

inline void T_SPM_SystemStatisticsData::clearStatisticDataDisabled() {
    if (hasStatisticDataDisabled()) {
         clear_has_StatisticDataDisabled();
        _StatisticDataDisabled = false;
     }
}

inline bool T_SPM_SystemStatisticsData::hasStatisticDataDisabled () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_SPM_SystemStatisticsData::getStatisticDataDisabled () const {
    return _StatisticDataDisabled;
}

inline void T_SPM_SystemStatisticsData::setStatisticDataDisabled (bool StatisticDataDisabled_) {
    set_has_StatisticDataDisabled();
    this->_StatisticDataDisabled = StatisticDataDisabled_;
}

inline void T_SPM_SystemStatisticsData::set_has_MaxValue () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_SystemStatisticsData::clear_has_MaxValue () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_SystemStatisticsData::set_has_AvgValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_SystemStatisticsData::clear_has_AvgValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_SystemStatisticsData::set_has_MinValue () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_SystemStatisticsData::clear_has_MinValue () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_SystemStatisticsData::set_has_StatisticDataDisabled () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_SystemStatisticsData::clear_has_StatisticDataDisabled () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SPM_ResetInfoStatisticData::T_SPM_ResetInfoStatisticData ()  :
    _tLastResetDate (NULL),
    _tLastResetReason (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR),
    _u32ApApplicationError (0u),
    _u32ApSoftware (0u),
    _u32ApEcuReset (0u),
    _u32ApDownload (0u),
    _u32ApDownloadError (0u),
    _u32ApOvertemperature (0u),
    _u32ApUser (0u),
    _u32ApLcmIntern (0u),
    _u32ApWarmstartCount (0u),
    _u32ApPowerOnCount (0u),
    _u32ApPowerLossCount (0u),
    _u32ApPowerOffCount (0u),
    _u32ApSccCount (0u),
    _u32ApUnknownCount (0u),
    _u32SccHwWdtCount (0u),
    _u32SccPowerOnCount (0u),
    _u32SccColdstartCount (0u),
    _u32SccAppmodeChangeCount (0u),
    _u32SccDuringLpwCount (0u),
    _u32SccDuringPllOszCount (0u),
    _u32SccDuringSWCount (0u),
    _u32SccWarmstartCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_ResetInfoStatisticData::T_SPM_ResetInfoStatisticData (const T_SPM_ResetInfoStatisticData &rhs)  :
    _tLastResetDate (NULL),
    _tLastResetReason (::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR),
    _u32ApApplicationError (0u),
    _u32ApSoftware (0u),
    _u32ApEcuReset (0u),
    _u32ApDownload (0u),
    _u32ApDownloadError (0u),
    _u32ApOvertemperature (0u),
    _u32ApUser (0u),
    _u32ApLcmIntern (0u),
    _u32ApWarmstartCount (0u),
    _u32ApPowerOnCount (0u),
    _u32ApPowerLossCount (0u),
    _u32ApPowerOffCount (0u),
    _u32ApSccCount (0u),
    _u32ApUnknownCount (0u),
    _u32SccHwWdtCount (0u),
    _u32SccPowerOnCount (0u),
    _u32SccColdstartCount (0u),
    _u32SccAppmodeChangeCount (0u),
    _u32SccDuringLpwCount (0u),
    _u32SccDuringPllOszCount (0u),
    _u32SccDuringSWCount (0u),
    _u32SccWarmstartCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_ResetInfoStatisticData::T_SPM_ResetInfoStatisticData (const TTimeDate& tLastResetDate_, T_e8_LcmResetReason tLastResetReason_, uint32 u32ApApplicationError_, uint32 u32ApSoftware_, uint32 u32ApEcuReset_, uint32 u32ApDownload_, uint32 u32ApDownloadError_, uint32 u32ApOvertemperature_, uint32 u32ApUser_, uint32 u32ApLcmIntern_, uint32 u32ApWarmstartCount_, uint32 u32ApPowerOnCount_, uint32 u32ApPowerLossCount_, uint32 u32ApPowerOffCount_, uint32 u32ApSccCount_, uint32 u32ApUnknownCount_, uint32 u32SccHwWdtCount_, uint32 u32SccPowerOnCount_, uint32 u32SccColdstartCount_, uint32 u32SccAppmodeChangeCount_, uint32 u32SccDuringLpwCount_, uint32 u32SccDuringPllOszCount_, uint32 u32SccDuringSWCount_, uint32 u32SccWarmstartCount_)  :
    _tLastResetDate (new TTimeDate(tLastResetDate_)),
    _tLastResetReason (tLastResetReason_),
    _u32ApApplicationError (u32ApApplicationError_),
    _u32ApSoftware (u32ApSoftware_),
    _u32ApEcuReset (u32ApEcuReset_),
    _u32ApDownload (u32ApDownload_),
    _u32ApDownloadError (u32ApDownloadError_),
    _u32ApOvertemperature (u32ApOvertemperature_),
    _u32ApUser (u32ApUser_),
    _u32ApLcmIntern (u32ApLcmIntern_),
    _u32ApWarmstartCount (u32ApWarmstartCount_),
    _u32ApPowerOnCount (u32ApPowerOnCount_),
    _u32ApPowerLossCount (u32ApPowerLossCount_),
    _u32ApPowerOffCount (u32ApPowerOffCount_),
    _u32ApSccCount (u32ApSccCount_),
    _u32ApUnknownCount (u32ApUnknownCount_),
    _u32SccHwWdtCount (u32SccHwWdtCount_),
    _u32SccPowerOnCount (u32SccPowerOnCount_),
    _u32SccColdstartCount (u32SccColdstartCount_),
    _u32SccAppmodeChangeCount (u32SccAppmodeChangeCount_),
    _u32SccDuringLpwCount (u32SccDuringLpwCount_),
    _u32SccDuringPllOszCount (u32SccDuringPllOszCount_),
    _u32SccDuringSWCount (u32SccDuringSWCount_),
    _u32SccWarmstartCount (u32SccWarmstartCount_)
{
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(tLastResetReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tLastResetReason_, "T_e8_LcmResetReason", "tLastResetReason", "T_SPM_ResetInfoStatisticData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_ResetInfoStatisticData::~T_SPM_ResetInfoStatisticData() {
    delete _tLastResetDate;
}

inline T_SPM_ResetInfoStatisticData& T_SPM_ResetInfoStatisticData::operator = (const T_SPM_ResetInfoStatisticData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTLastResetDate()) {
            setTLastResetDate(rhs.getTLastResetDate());
        } else {
            clearTLastResetDate();
        }
        if (rhs.hasTLastResetReason()) {
            setTLastResetReason(rhs.getTLastResetReason());
        } else {
            clearTLastResetReason();
        }
        if (rhs.hasU32ApApplicationError()) {
            setU32ApApplicationError(rhs.getU32ApApplicationError());
        } else {
            clearU32ApApplicationError();
        }
        if (rhs.hasU32ApSoftware()) {
            setU32ApSoftware(rhs.getU32ApSoftware());
        } else {
            clearU32ApSoftware();
        }
        if (rhs.hasU32ApEcuReset()) {
            setU32ApEcuReset(rhs.getU32ApEcuReset());
        } else {
            clearU32ApEcuReset();
        }
        if (rhs.hasU32ApDownload()) {
            setU32ApDownload(rhs.getU32ApDownload());
        } else {
            clearU32ApDownload();
        }
        if (rhs.hasU32ApDownloadError()) {
            setU32ApDownloadError(rhs.getU32ApDownloadError());
        } else {
            clearU32ApDownloadError();
        }
        if (rhs.hasU32ApOvertemperature()) {
            setU32ApOvertemperature(rhs.getU32ApOvertemperature());
        } else {
            clearU32ApOvertemperature();
        }
        if (rhs.hasU32ApUser()) {
            setU32ApUser(rhs.getU32ApUser());
        } else {
            clearU32ApUser();
        }
        if (rhs.hasU32ApLcmIntern()) {
            setU32ApLcmIntern(rhs.getU32ApLcmIntern());
        } else {
            clearU32ApLcmIntern();
        }
        if (rhs.hasU32ApWarmstartCount()) {
            setU32ApWarmstartCount(rhs.getU32ApWarmstartCount());
        } else {
            clearU32ApWarmstartCount();
        }
        if (rhs.hasU32ApPowerOnCount()) {
            setU32ApPowerOnCount(rhs.getU32ApPowerOnCount());
        } else {
            clearU32ApPowerOnCount();
        }
        if (rhs.hasU32ApPowerLossCount()) {
            setU32ApPowerLossCount(rhs.getU32ApPowerLossCount());
        } else {
            clearU32ApPowerLossCount();
        }
        if (rhs.hasU32ApPowerOffCount()) {
            setU32ApPowerOffCount(rhs.getU32ApPowerOffCount());
        } else {
            clearU32ApPowerOffCount();
        }
        if (rhs.hasU32ApSccCount()) {
            setU32ApSccCount(rhs.getU32ApSccCount());
        } else {
            clearU32ApSccCount();
        }
        if (rhs.hasU32ApUnknownCount()) {
            setU32ApUnknownCount(rhs.getU32ApUnknownCount());
        } else {
            clearU32ApUnknownCount();
        }
        if (rhs.hasU32SccHwWdtCount()) {
            setU32SccHwWdtCount(rhs.getU32SccHwWdtCount());
        } else {
            clearU32SccHwWdtCount();
        }
        if (rhs.hasU32SccPowerOnCount()) {
            setU32SccPowerOnCount(rhs.getU32SccPowerOnCount());
        } else {
            clearU32SccPowerOnCount();
        }
        if (rhs.hasU32SccColdstartCount()) {
            setU32SccColdstartCount(rhs.getU32SccColdstartCount());
        } else {
            clearU32SccColdstartCount();
        }
        if (rhs.hasU32SccAppmodeChangeCount()) {
            setU32SccAppmodeChangeCount(rhs.getU32SccAppmodeChangeCount());
        } else {
            clearU32SccAppmodeChangeCount();
        }
        if (rhs.hasU32SccDuringLpwCount()) {
            setU32SccDuringLpwCount(rhs.getU32SccDuringLpwCount());
        } else {
            clearU32SccDuringLpwCount();
        }
        if (rhs.hasU32SccDuringPllOszCount()) {
            setU32SccDuringPllOszCount(rhs.getU32SccDuringPllOszCount());
        } else {
            clearU32SccDuringPllOszCount();
        }
        if (rhs.hasU32SccDuringSWCount()) {
            setU32SccDuringSWCount(rhs.getU32SccDuringSWCount());
        } else {
            clearU32SccDuringSWCount();
        }
        if (rhs.hasU32SccWarmstartCount()) {
            setU32SccWarmstartCount(rhs.getU32SccWarmstartCount());
        } else {
            clearU32SccWarmstartCount();
        }
    }
    return *this;
}

inline bool T_SPM_ResetInfoStatisticData::operator == (const T_SPM_ResetInfoStatisticData& rhs) const {
    return (((!hasTLastResetDate() && !rhs.hasTLastResetDate()) || getTLastResetDate() == rhs.getTLastResetDate()) &&
        ((!hasTLastResetReason() && !rhs.hasTLastResetReason()) || getTLastResetReason() == rhs.getTLastResetReason()) &&
        ((!hasU32ApApplicationError() && !rhs.hasU32ApApplicationError()) || getU32ApApplicationError() == rhs.getU32ApApplicationError()) &&
        ((!hasU32ApSoftware() && !rhs.hasU32ApSoftware()) || getU32ApSoftware() == rhs.getU32ApSoftware()) &&
        ((!hasU32ApEcuReset() && !rhs.hasU32ApEcuReset()) || getU32ApEcuReset() == rhs.getU32ApEcuReset()) &&
        ((!hasU32ApDownload() && !rhs.hasU32ApDownload()) || getU32ApDownload() == rhs.getU32ApDownload()) &&
        ((!hasU32ApDownloadError() && !rhs.hasU32ApDownloadError()) || getU32ApDownloadError() == rhs.getU32ApDownloadError()) &&
        ((!hasU32ApOvertemperature() && !rhs.hasU32ApOvertemperature()) || getU32ApOvertemperature() == rhs.getU32ApOvertemperature()) &&
        ((!hasU32ApUser() && !rhs.hasU32ApUser()) || getU32ApUser() == rhs.getU32ApUser()) &&
        ((!hasU32ApLcmIntern() && !rhs.hasU32ApLcmIntern()) || getU32ApLcmIntern() == rhs.getU32ApLcmIntern()) &&
        ((!hasU32ApWarmstartCount() && !rhs.hasU32ApWarmstartCount()) || getU32ApWarmstartCount() == rhs.getU32ApWarmstartCount()) &&
        ((!hasU32ApPowerOnCount() && !rhs.hasU32ApPowerOnCount()) || getU32ApPowerOnCount() == rhs.getU32ApPowerOnCount()) &&
        ((!hasU32ApPowerLossCount() && !rhs.hasU32ApPowerLossCount()) || getU32ApPowerLossCount() == rhs.getU32ApPowerLossCount()) &&
        ((!hasU32ApPowerOffCount() && !rhs.hasU32ApPowerOffCount()) || getU32ApPowerOffCount() == rhs.getU32ApPowerOffCount()) &&
        ((!hasU32ApSccCount() && !rhs.hasU32ApSccCount()) || getU32ApSccCount() == rhs.getU32ApSccCount()) &&
        ((!hasU32ApUnknownCount() && !rhs.hasU32ApUnknownCount()) || getU32ApUnknownCount() == rhs.getU32ApUnknownCount()) &&
        ((!hasU32SccHwWdtCount() && !rhs.hasU32SccHwWdtCount()) || getU32SccHwWdtCount() == rhs.getU32SccHwWdtCount()) &&
        ((!hasU32SccPowerOnCount() && !rhs.hasU32SccPowerOnCount()) || getU32SccPowerOnCount() == rhs.getU32SccPowerOnCount()) &&
        ((!hasU32SccColdstartCount() && !rhs.hasU32SccColdstartCount()) || getU32SccColdstartCount() == rhs.getU32SccColdstartCount()) &&
        ((!hasU32SccAppmodeChangeCount() && !rhs.hasU32SccAppmodeChangeCount()) || getU32SccAppmodeChangeCount() == rhs.getU32SccAppmodeChangeCount()) &&
        ((!hasU32SccDuringLpwCount() && !rhs.hasU32SccDuringLpwCount()) || getU32SccDuringLpwCount() == rhs.getU32SccDuringLpwCount()) &&
        ((!hasU32SccDuringPllOszCount() && !rhs.hasU32SccDuringPllOszCount()) || getU32SccDuringPllOszCount() == rhs.getU32SccDuringPllOszCount()) &&
        ((!hasU32SccDuringSWCount() && !rhs.hasU32SccDuringSWCount()) || getU32SccDuringSWCount() == rhs.getU32SccDuringSWCount()) &&
        ((!hasU32SccWarmstartCount() && !rhs.hasU32SccWarmstartCount()) || getU32SccWarmstartCount() == rhs.getU32SccWarmstartCount()));
}

inline bool T_SPM_ResetInfoStatisticData::operator != (const T_SPM_ResetInfoStatisticData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_ResetInfoStatisticData::operator < (const T_SPM_ResetInfoStatisticData& rhs) const {
    if (hasTLastResetDate() || rhs.hasTLastResetDate()) {
        if (getTLastResetDate() < rhs.getTLastResetDate()) return true;
        if (getTLastResetDate() > rhs.getTLastResetDate()) return false;
    }
    if (hasTLastResetReason() || rhs.hasTLastResetReason()) {
        if ((uint32)getTLastResetReason() < (uint32)rhs.getTLastResetReason()) return true;
        if ((uint32)getTLastResetReason() > (uint32)rhs.getTLastResetReason()) return false;
    }
    if (hasU32ApApplicationError() || rhs.hasU32ApApplicationError()) {
        if (getU32ApApplicationError() < rhs.getU32ApApplicationError()) return true;
        if (getU32ApApplicationError() > rhs.getU32ApApplicationError()) return false;
    }
    if (hasU32ApSoftware() || rhs.hasU32ApSoftware()) {
        if (getU32ApSoftware() < rhs.getU32ApSoftware()) return true;
        if (getU32ApSoftware() > rhs.getU32ApSoftware()) return false;
    }
    if (hasU32ApEcuReset() || rhs.hasU32ApEcuReset()) {
        if (getU32ApEcuReset() < rhs.getU32ApEcuReset()) return true;
        if (getU32ApEcuReset() > rhs.getU32ApEcuReset()) return false;
    }
    if (hasU32ApDownload() || rhs.hasU32ApDownload()) {
        if (getU32ApDownload() < rhs.getU32ApDownload()) return true;
        if (getU32ApDownload() > rhs.getU32ApDownload()) return false;
    }
    if (hasU32ApDownloadError() || rhs.hasU32ApDownloadError()) {
        if (getU32ApDownloadError() < rhs.getU32ApDownloadError()) return true;
        if (getU32ApDownloadError() > rhs.getU32ApDownloadError()) return false;
    }
    if (hasU32ApOvertemperature() || rhs.hasU32ApOvertemperature()) {
        if (getU32ApOvertemperature() < rhs.getU32ApOvertemperature()) return true;
        if (getU32ApOvertemperature() > rhs.getU32ApOvertemperature()) return false;
    }
    if (hasU32ApUser() || rhs.hasU32ApUser()) {
        if (getU32ApUser() < rhs.getU32ApUser()) return true;
        if (getU32ApUser() > rhs.getU32ApUser()) return false;
    }
    if (hasU32ApLcmIntern() || rhs.hasU32ApLcmIntern()) {
        if (getU32ApLcmIntern() < rhs.getU32ApLcmIntern()) return true;
        if (getU32ApLcmIntern() > rhs.getU32ApLcmIntern()) return false;
    }
    if (hasU32ApWarmstartCount() || rhs.hasU32ApWarmstartCount()) {
        if (getU32ApWarmstartCount() < rhs.getU32ApWarmstartCount()) return true;
        if (getU32ApWarmstartCount() > rhs.getU32ApWarmstartCount()) return false;
    }
    if (hasU32ApPowerOnCount() || rhs.hasU32ApPowerOnCount()) {
        if (getU32ApPowerOnCount() < rhs.getU32ApPowerOnCount()) return true;
        if (getU32ApPowerOnCount() > rhs.getU32ApPowerOnCount()) return false;
    }
    if (hasU32ApPowerLossCount() || rhs.hasU32ApPowerLossCount()) {
        if (getU32ApPowerLossCount() < rhs.getU32ApPowerLossCount()) return true;
        if (getU32ApPowerLossCount() > rhs.getU32ApPowerLossCount()) return false;
    }
    if (hasU32ApPowerOffCount() || rhs.hasU32ApPowerOffCount()) {
        if (getU32ApPowerOffCount() < rhs.getU32ApPowerOffCount()) return true;
        if (getU32ApPowerOffCount() > rhs.getU32ApPowerOffCount()) return false;
    }
    if (hasU32ApSccCount() || rhs.hasU32ApSccCount()) {
        if (getU32ApSccCount() < rhs.getU32ApSccCount()) return true;
        if (getU32ApSccCount() > rhs.getU32ApSccCount()) return false;
    }
    if (hasU32ApUnknownCount() || rhs.hasU32ApUnknownCount()) {
        if (getU32ApUnknownCount() < rhs.getU32ApUnknownCount()) return true;
        if (getU32ApUnknownCount() > rhs.getU32ApUnknownCount()) return false;
    }
    if (hasU32SccHwWdtCount() || rhs.hasU32SccHwWdtCount()) {
        if (getU32SccHwWdtCount() < rhs.getU32SccHwWdtCount()) return true;
        if (getU32SccHwWdtCount() > rhs.getU32SccHwWdtCount()) return false;
    }
    if (hasU32SccPowerOnCount() || rhs.hasU32SccPowerOnCount()) {
        if (getU32SccPowerOnCount() < rhs.getU32SccPowerOnCount()) return true;
        if (getU32SccPowerOnCount() > rhs.getU32SccPowerOnCount()) return false;
    }
    if (hasU32SccColdstartCount() || rhs.hasU32SccColdstartCount()) {
        if (getU32SccColdstartCount() < rhs.getU32SccColdstartCount()) return true;
        if (getU32SccColdstartCount() > rhs.getU32SccColdstartCount()) return false;
    }
    if (hasU32SccAppmodeChangeCount() || rhs.hasU32SccAppmodeChangeCount()) {
        if (getU32SccAppmodeChangeCount() < rhs.getU32SccAppmodeChangeCount()) return true;
        if (getU32SccAppmodeChangeCount() > rhs.getU32SccAppmodeChangeCount()) return false;
    }
    if (hasU32SccDuringLpwCount() || rhs.hasU32SccDuringLpwCount()) {
        if (getU32SccDuringLpwCount() < rhs.getU32SccDuringLpwCount()) return true;
        if (getU32SccDuringLpwCount() > rhs.getU32SccDuringLpwCount()) return false;
    }
    if (hasU32SccDuringPllOszCount() || rhs.hasU32SccDuringPllOszCount()) {
        if (getU32SccDuringPllOszCount() < rhs.getU32SccDuringPllOszCount()) return true;
        if (getU32SccDuringPllOszCount() > rhs.getU32SccDuringPllOszCount()) return false;
    }
    if (hasU32SccDuringSWCount() || rhs.hasU32SccDuringSWCount()) {
        if (getU32SccDuringSWCount() < rhs.getU32SccDuringSWCount()) return true;
        if (getU32SccDuringSWCount() > rhs.getU32SccDuringSWCount()) return false;
    }
    if (hasU32SccWarmstartCount() || rhs.hasU32SccWarmstartCount()) {
        if (getU32SccWarmstartCount() < rhs.getU32SccWarmstartCount()) return true;
        if (getU32SccWarmstartCount() > rhs.getU32SccWarmstartCount()) return false;
    }
    return false;
}

inline bool T_SPM_ResetInfoStatisticData::operator > (const T_SPM_ResetInfoStatisticData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_ResetInfoStatisticData::clear() {
    clearTLastResetDate();
    clearTLastResetReason();
    clearU32ApApplicationError();
    clearU32ApSoftware();
    clearU32ApEcuReset();
    clearU32ApDownload();
    clearU32ApDownloadError();
    clearU32ApOvertemperature();
    clearU32ApUser();
    clearU32ApLcmIntern();
    clearU32ApWarmstartCount();
    clearU32ApPowerOnCount();
    clearU32ApPowerLossCount();
    clearU32ApPowerOffCount();
    clearU32ApSccCount();
    clearU32ApUnknownCount();
    clearU32SccHwWdtCount();
    clearU32SccPowerOnCount();
    clearU32SccColdstartCount();
    clearU32SccAppmodeChangeCount();
    clearU32SccDuringLpwCount();
    clearU32SccDuringPllOszCount();
    clearU32SccDuringSWCount();
    clearU32SccWarmstartCount();
}

inline void T_SPM_ResetInfoStatisticData::clearTLastResetDate() {
    if (hasTLastResetDate()) {
         clear_has_tLastResetDate();
        if (_tLastResetDate != NULL) {
            _tLastResetDate->clear();
        }
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasTLastResetDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const TTimeDate& T_SPM_ResetInfoStatisticData::getTLastResetDate () const {
    if (_tLastResetDate == NULL) {
        return TTimeDate::getDefaultInstance();
    }
    return *_tLastResetDate;
}

inline TTimeDate& T_SPM_ResetInfoStatisticData::getTLastResetDateMutable () {
    set_has_tLastResetDate();
    if (_tLastResetDate == NULL) {
        _tLastResetDate = new TTimeDate ();
        CHECK_ALLOCATION( _tLastResetDate );
    }
    return *_tLastResetDate;
}

inline void T_SPM_ResetInfoStatisticData::setTLastResetDate (const TTimeDate& tLastResetDate_) {
    set_has_tLastResetDate();
    if (this->_tLastResetDate == NULL) {
        this->_tLastResetDate = new TTimeDate (tLastResetDate_);
        CHECK_ALLOCATION( this->_tLastResetDate );
    } else {
        *this->_tLastResetDate = tLastResetDate_;
    }
}

inline TTimeDate* T_SPM_ResetInfoStatisticData::releaseTLastResetDate() {
    clear_has_tLastResetDate();
    TTimeDate* temp = _tLastResetDate;
    this->_tLastResetDate = NULL;
    return temp;
}

inline void T_SPM_ResetInfoStatisticData::replaceTLastResetDate (TTimeDate* tLastResetDate_) {
    set_has_tLastResetDate();
    if (this->_tLastResetDate != tLastResetDate_) {
        if (this->_tLastResetDate != NULL) {
            delete this->_tLastResetDate;
        }
        this->_tLastResetDate = tLastResetDate_;
    }
}

inline void T_SPM_ResetInfoStatisticData::clearTLastResetReason() {
    if (hasTLastResetReason()) {
         clear_has_tLastResetReason();
        _tLastResetReason = ::spm_core_fi_types::T_e8_LcmResetReason__SPM_eHMI_APP_ERROR;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasTLastResetReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_LcmResetReason T_SPM_ResetInfoStatisticData::getTLastResetReason () const {
    return _tLastResetReason;
}

inline void T_SPM_ResetInfoStatisticData::setTLastResetReason (T_e8_LcmResetReason tLastResetReason_) {
    #ifndef NDEBUG
    if (!(T_e8_LcmResetReason_IsValid(tLastResetReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tLastResetReason_, "T_e8_LcmResetReason", "tLastResetReason", "T_SPM_ResetInfoStatisticData");
    }
    #endif
    set_has_tLastResetReason();
    this->_tLastResetReason = tLastResetReason_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApApplicationError() {
    if (hasU32ApApplicationError()) {
         clear_has_u32ApApplicationError();
        _u32ApApplicationError = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApApplicationError () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApApplicationError () const {
    return _u32ApApplicationError;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApApplicationError (uint32 u32ApApplicationError_) {
    set_has_u32ApApplicationError();
    this->_u32ApApplicationError = u32ApApplicationError_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApSoftware() {
    if (hasU32ApSoftware()) {
         clear_has_u32ApSoftware();
        _u32ApSoftware = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApSoftware () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApSoftware () const {
    return _u32ApSoftware;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApSoftware (uint32 u32ApSoftware_) {
    set_has_u32ApSoftware();
    this->_u32ApSoftware = u32ApSoftware_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApEcuReset() {
    if (hasU32ApEcuReset()) {
         clear_has_u32ApEcuReset();
        _u32ApEcuReset = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApEcuReset () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApEcuReset () const {
    return _u32ApEcuReset;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApEcuReset (uint32 u32ApEcuReset_) {
    set_has_u32ApEcuReset();
    this->_u32ApEcuReset = u32ApEcuReset_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApDownload() {
    if (hasU32ApDownload()) {
         clear_has_u32ApDownload();
        _u32ApDownload = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApDownload () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApDownload () const {
    return _u32ApDownload;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApDownload (uint32 u32ApDownload_) {
    set_has_u32ApDownload();
    this->_u32ApDownload = u32ApDownload_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApDownloadError() {
    if (hasU32ApDownloadError()) {
         clear_has_u32ApDownloadError();
        _u32ApDownloadError = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApDownloadError () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApDownloadError () const {
    return _u32ApDownloadError;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApDownloadError (uint32 u32ApDownloadError_) {
    set_has_u32ApDownloadError();
    this->_u32ApDownloadError = u32ApDownloadError_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApOvertemperature() {
    if (hasU32ApOvertemperature()) {
         clear_has_u32ApOvertemperature();
        _u32ApOvertemperature = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApOvertemperature () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApOvertemperature () const {
    return _u32ApOvertemperature;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApOvertemperature (uint32 u32ApOvertemperature_) {
    set_has_u32ApOvertemperature();
    this->_u32ApOvertemperature = u32ApOvertemperature_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApUser() {
    if (hasU32ApUser()) {
         clear_has_u32ApUser();
        _u32ApUser = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApUser () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApUser () const {
    return _u32ApUser;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApUser (uint32 u32ApUser_) {
    set_has_u32ApUser();
    this->_u32ApUser = u32ApUser_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApLcmIntern() {
    if (hasU32ApLcmIntern()) {
         clear_has_u32ApLcmIntern();
        _u32ApLcmIntern = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApLcmIntern () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApLcmIntern () const {
    return _u32ApLcmIntern;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApLcmIntern (uint32 u32ApLcmIntern_) {
    set_has_u32ApLcmIntern();
    this->_u32ApLcmIntern = u32ApLcmIntern_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApWarmstartCount() {
    if (hasU32ApWarmstartCount()) {
         clear_has_u32ApWarmstartCount();
        _u32ApWarmstartCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApWarmstartCount () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApWarmstartCount () const {
    return _u32ApWarmstartCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApWarmstartCount (uint32 u32ApWarmstartCount_) {
    set_has_u32ApWarmstartCount();
    this->_u32ApWarmstartCount = u32ApWarmstartCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApPowerOnCount() {
    if (hasU32ApPowerOnCount()) {
         clear_has_u32ApPowerOnCount();
        _u32ApPowerOnCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApPowerOnCount () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApPowerOnCount () const {
    return _u32ApPowerOnCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApPowerOnCount (uint32 u32ApPowerOnCount_) {
    set_has_u32ApPowerOnCount();
    this->_u32ApPowerOnCount = u32ApPowerOnCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApPowerLossCount() {
    if (hasU32ApPowerLossCount()) {
         clear_has_u32ApPowerLossCount();
        _u32ApPowerLossCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApPowerLossCount () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApPowerLossCount () const {
    return _u32ApPowerLossCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApPowerLossCount (uint32 u32ApPowerLossCount_) {
    set_has_u32ApPowerLossCount();
    this->_u32ApPowerLossCount = u32ApPowerLossCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApPowerOffCount() {
    if (hasU32ApPowerOffCount()) {
         clear_has_u32ApPowerOffCount();
        _u32ApPowerOffCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApPowerOffCount () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApPowerOffCount () const {
    return _u32ApPowerOffCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApPowerOffCount (uint32 u32ApPowerOffCount_) {
    set_has_u32ApPowerOffCount();
    this->_u32ApPowerOffCount = u32ApPowerOffCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApSccCount() {
    if (hasU32ApSccCount()) {
         clear_has_u32ApSccCount();
        _u32ApSccCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApSccCount () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApSccCount () const {
    return _u32ApSccCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApSccCount (uint32 u32ApSccCount_) {
    set_has_u32ApSccCount();
    this->_u32ApSccCount = u32ApSccCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32ApUnknownCount() {
    if (hasU32ApUnknownCount()) {
         clear_has_u32ApUnknownCount();
        _u32ApUnknownCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32ApUnknownCount () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32ApUnknownCount () const {
    return _u32ApUnknownCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32ApUnknownCount (uint32 u32ApUnknownCount_) {
    set_has_u32ApUnknownCount();
    this->_u32ApUnknownCount = u32ApUnknownCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccHwWdtCount() {
    if (hasU32SccHwWdtCount()) {
         clear_has_u32SccHwWdtCount();
        _u32SccHwWdtCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccHwWdtCount () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccHwWdtCount () const {
    return _u32SccHwWdtCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccHwWdtCount (uint32 u32SccHwWdtCount_) {
    set_has_u32SccHwWdtCount();
    this->_u32SccHwWdtCount = u32SccHwWdtCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccPowerOnCount() {
    if (hasU32SccPowerOnCount()) {
         clear_has_u32SccPowerOnCount();
        _u32SccPowerOnCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccPowerOnCount () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccPowerOnCount () const {
    return _u32SccPowerOnCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccPowerOnCount (uint32 u32SccPowerOnCount_) {
    set_has_u32SccPowerOnCount();
    this->_u32SccPowerOnCount = u32SccPowerOnCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccColdstartCount() {
    if (hasU32SccColdstartCount()) {
         clear_has_u32SccColdstartCount();
        _u32SccColdstartCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccColdstartCount () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccColdstartCount () const {
    return _u32SccColdstartCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccColdstartCount (uint32 u32SccColdstartCount_) {
    set_has_u32SccColdstartCount();
    this->_u32SccColdstartCount = u32SccColdstartCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccAppmodeChangeCount() {
    if (hasU32SccAppmodeChangeCount()) {
         clear_has_u32SccAppmodeChangeCount();
        _u32SccAppmodeChangeCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccAppmodeChangeCount () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccAppmodeChangeCount () const {
    return _u32SccAppmodeChangeCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccAppmodeChangeCount (uint32 u32SccAppmodeChangeCount_) {
    set_has_u32SccAppmodeChangeCount();
    this->_u32SccAppmodeChangeCount = u32SccAppmodeChangeCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccDuringLpwCount() {
    if (hasU32SccDuringLpwCount()) {
         clear_has_u32SccDuringLpwCount();
        _u32SccDuringLpwCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccDuringLpwCount () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccDuringLpwCount () const {
    return _u32SccDuringLpwCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccDuringLpwCount (uint32 u32SccDuringLpwCount_) {
    set_has_u32SccDuringLpwCount();
    this->_u32SccDuringLpwCount = u32SccDuringLpwCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccDuringPllOszCount() {
    if (hasU32SccDuringPllOszCount()) {
         clear_has_u32SccDuringPllOszCount();
        _u32SccDuringPllOszCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccDuringPllOszCount () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccDuringPllOszCount () const {
    return _u32SccDuringPllOszCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccDuringPllOszCount (uint32 u32SccDuringPllOszCount_) {
    set_has_u32SccDuringPllOszCount();
    this->_u32SccDuringPllOszCount = u32SccDuringPllOszCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccDuringSWCount() {
    if (hasU32SccDuringSWCount()) {
         clear_has_u32SccDuringSWCount();
        _u32SccDuringSWCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccDuringSWCount () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccDuringSWCount () const {
    return _u32SccDuringSWCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccDuringSWCount (uint32 u32SccDuringSWCount_) {
    set_has_u32SccDuringSWCount();
    this->_u32SccDuringSWCount = u32SccDuringSWCount_;
}

inline void T_SPM_ResetInfoStatisticData::clearU32SccWarmstartCount() {
    if (hasU32SccWarmstartCount()) {
         clear_has_u32SccWarmstartCount();
        _u32SccWarmstartCount = 0u;
     }
}

inline bool T_SPM_ResetInfoStatisticData::hasU32SccWarmstartCount () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint32 T_SPM_ResetInfoStatisticData::getU32SccWarmstartCount () const {
    return _u32SccWarmstartCount;
}

inline void T_SPM_ResetInfoStatisticData::setU32SccWarmstartCount (uint32 u32SccWarmstartCount_) {
    set_has_u32SccWarmstartCount();
    this->_u32SccWarmstartCount = u32SccWarmstartCount_;
}

inline void T_SPM_ResetInfoStatisticData::set_has_tLastResetDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_tLastResetDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_ResetInfoStatisticData::set_has_tLastResetReason () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_tLastResetReason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApApplicationError () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApApplicationError () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApSoftware () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApSoftware () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApEcuReset () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApEcuReset () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApDownload () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApDownload () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApDownloadError () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApDownloadError () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApOvertemperature () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApOvertemperature () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApUser () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApUser () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApLcmIntern () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApLcmIntern () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApWarmstartCount () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApWarmstartCount () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApPowerOnCount () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApPowerOnCount () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApPowerLossCount () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApPowerLossCount () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApPowerOffCount () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApPowerOffCount () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApSccCount () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApSccCount () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32ApUnknownCount () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32ApUnknownCount () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccHwWdtCount () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccHwWdtCount () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccPowerOnCount () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccPowerOnCount () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccColdstartCount () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccColdstartCount () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccAppmodeChangeCount () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccAppmodeChangeCount () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccDuringLpwCount () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccDuringLpwCount () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccDuringPllOszCount () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccDuringPllOszCount () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccDuringSWCount () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccDuringSWCount () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_SPM_ResetInfoStatisticData::set_has_u32SccWarmstartCount () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_SPM_ResetInfoStatisticData::clear_has_u32SccWarmstartCount () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline  T_SPM_SWVersionStatisticData::T_SPM_SWVersionStatisticData ()  :
    _strBuildVersion (NULL),
    _strBuildVersionCustomer (NULL),
    _strCustomerVersion (NULL),
    _tResetInfo (NULL),
    _tResetHistoryList (NULL),
    _tWakeupHistoryList (NULL),
    _tSwitchOnList (NULL),
    _tStateHistoryList (NULL),
    _tErrStateHistory01List (NULL),
    _tErrStateHistory02List (NULL),
    _tErrStateHistory03List (NULL),
    _tErrStateHistory04List (NULL),
    _tErrStateHistory05List (NULL),
    _u32SystemOperationTime (0u),
    _tCpuUsage (NULL),
    _tRamUsage (NULL),
    _tStartupTime (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SPM_SWVersionStatisticData::T_SPM_SWVersionStatisticData (const T_SPM_SWVersionStatisticData &rhs)  :
    _strBuildVersion (NULL),
    _strBuildVersionCustomer (NULL),
    _strCustomerVersion (NULL),
    _tResetInfo (NULL),
    _tResetHistoryList (NULL),
    _tWakeupHistoryList (NULL),
    _tSwitchOnList (NULL),
    _tStateHistoryList (NULL),
    _tErrStateHistory01List (NULL),
    _tErrStateHistory02List (NULL),
    _tErrStateHistory03List (NULL),
    _tErrStateHistory04List (NULL),
    _tErrStateHistory05List (NULL),
    _u32SystemOperationTime (0u),
    _tCpuUsage (NULL),
    _tRamUsage (NULL),
    _tStartupTime (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SPM_SWVersionStatisticData::T_SPM_SWVersionStatisticData (const ::std::string& strBuildVersion_, const ::std::string& strBuildVersionCustomer_, const ::std::string& strCustomerVersion_, const T_SPM_ResetInfoStatisticData& tResetInfo_, const ::boost::ptr_vector< T_ResetElement >& tResetHistoryList_, const ::boost::ptr_vector< T_WakeupElement >& tWakeupHistoryList_, const ::boost::ptr_vector< T_SwitchOnElement >& tSwitchOnList_, const ::boost::ptr_vector< T_StateChangeElement >& tStateHistoryList_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory01List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory02List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory03List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory04List_, const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory05List_, uint32 u32SystemOperationTime_, const T_SPM_SystemStatisticsData& tCpuUsage_, const T_SPM_SystemStatisticsData& tRamUsage_, const T_SPM_SystemStatisticsData& tStartupTime_)  :
    _strBuildVersion (new ::std::string(strBuildVersion_)),
    _strBuildVersionCustomer (new ::std::string(strBuildVersionCustomer_)),
    _strCustomerVersion (new ::std::string(strCustomerVersion_)),
    _tResetInfo (new T_SPM_ResetInfoStatisticData(tResetInfo_)),
    _tResetHistoryList (new ::boost::ptr_vector< T_ResetElement >(tResetHistoryList_)),
    _tWakeupHistoryList (new ::boost::ptr_vector< T_WakeupElement >(tWakeupHistoryList_)),
    _tSwitchOnList (new ::boost::ptr_vector< T_SwitchOnElement >(tSwitchOnList_)),
    _tStateHistoryList (new ::boost::ptr_vector< T_StateChangeElement >(tStateHistoryList_)),
    _tErrStateHistory01List (new ::boost::ptr_vector< T_StateChangeElement >(tErrStateHistory01List_)),
    _tErrStateHistory02List (new ::boost::ptr_vector< T_StateChangeElement >(tErrStateHistory02List_)),
    _tErrStateHistory03List (new ::boost::ptr_vector< T_StateChangeElement >(tErrStateHistory03List_)),
    _tErrStateHistory04List (new ::boost::ptr_vector< T_StateChangeElement >(tErrStateHistory04List_)),
    _tErrStateHistory05List (new ::boost::ptr_vector< T_StateChangeElement >(tErrStateHistory05List_)),
    _u32SystemOperationTime (u32SystemOperationTime_),
    _tCpuUsage (new T_SPM_SystemStatisticsData(tCpuUsage_)),
    _tRamUsage (new T_SPM_SystemStatisticsData(tRamUsage_)),
    _tStartupTime (new T_SPM_SystemStatisticsData(tStartupTime_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersionCustomer_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SPM_SWVersionStatisticData::~T_SPM_SWVersionStatisticData() {
    delete _strBuildVersion;
    delete _strBuildVersionCustomer;
    delete _strCustomerVersion;
    delete _tResetInfo;
    delete _tResetHistoryList;
    delete _tWakeupHistoryList;
    delete _tSwitchOnList;
    delete _tStateHistoryList;
    delete _tErrStateHistory01List;
    delete _tErrStateHistory02List;
    delete _tErrStateHistory03List;
    delete _tErrStateHistory04List;
    delete _tErrStateHistory05List;
    delete _tCpuUsage;
    delete _tRamUsage;
    delete _tStartupTime;
}

inline T_SPM_SWVersionStatisticData& T_SPM_SWVersionStatisticData::operator = (const T_SPM_SWVersionStatisticData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrBuildVersion()) {
            setStrBuildVersion(rhs.getStrBuildVersion());
        } else {
            clearStrBuildVersion();
        }
        if (rhs.hasStrBuildVersionCustomer()) {
            setStrBuildVersionCustomer(rhs.getStrBuildVersionCustomer());
        } else {
            clearStrBuildVersionCustomer();
        }
        if (rhs.hasStrCustomerVersion()) {
            setStrCustomerVersion(rhs.getStrCustomerVersion());
        } else {
            clearStrCustomerVersion();
        }
        if (rhs.hasTResetInfo()) {
            setTResetInfo(rhs.getTResetInfo());
        } else {
            clearTResetInfo();
        }
        if (rhs.hasTResetHistoryList()) {
            setTResetHistoryList(rhs.getTResetHistoryList());
        } else {
            clearTResetHistoryList();
        }
        if (rhs.hasTWakeupHistoryList()) {
            setTWakeupHistoryList(rhs.getTWakeupHistoryList());
        } else {
            clearTWakeupHistoryList();
        }
        if (rhs.hasTSwitchOnList()) {
            setTSwitchOnList(rhs.getTSwitchOnList());
        } else {
            clearTSwitchOnList();
        }
        if (rhs.hasTStateHistoryList()) {
            setTStateHistoryList(rhs.getTStateHistoryList());
        } else {
            clearTStateHistoryList();
        }
        if (rhs.hasTErrStateHistory01List()) {
            setTErrStateHistory01List(rhs.getTErrStateHistory01List());
        } else {
            clearTErrStateHistory01List();
        }
        if (rhs.hasTErrStateHistory02List()) {
            setTErrStateHistory02List(rhs.getTErrStateHistory02List());
        } else {
            clearTErrStateHistory02List();
        }
        if (rhs.hasTErrStateHistory03List()) {
            setTErrStateHistory03List(rhs.getTErrStateHistory03List());
        } else {
            clearTErrStateHistory03List();
        }
        if (rhs.hasTErrStateHistory04List()) {
            setTErrStateHistory04List(rhs.getTErrStateHistory04List());
        } else {
            clearTErrStateHistory04List();
        }
        if (rhs.hasTErrStateHistory05List()) {
            setTErrStateHistory05List(rhs.getTErrStateHistory05List());
        } else {
            clearTErrStateHistory05List();
        }
        if (rhs.hasU32SystemOperationTime()) {
            setU32SystemOperationTime(rhs.getU32SystemOperationTime());
        } else {
            clearU32SystemOperationTime();
        }
        if (rhs.hasTCpuUsage()) {
            setTCpuUsage(rhs.getTCpuUsage());
        } else {
            clearTCpuUsage();
        }
        if (rhs.hasTRamUsage()) {
            setTRamUsage(rhs.getTRamUsage());
        } else {
            clearTRamUsage();
        }
        if (rhs.hasTStartupTime()) {
            setTStartupTime(rhs.getTStartupTime());
        } else {
            clearTStartupTime();
        }
    }
    return *this;
}

inline bool T_SPM_SWVersionStatisticData::operator == (const T_SPM_SWVersionStatisticData& rhs) const {
    return (((!hasStrBuildVersion() && !rhs.hasStrBuildVersion()) || getStrBuildVersion() == rhs.getStrBuildVersion()) &&
        ((!hasStrBuildVersionCustomer() && !rhs.hasStrBuildVersionCustomer()) || getStrBuildVersionCustomer() == rhs.getStrBuildVersionCustomer()) &&
        ((!hasStrCustomerVersion() && !rhs.hasStrCustomerVersion()) || getStrCustomerVersion() == rhs.getStrCustomerVersion()) &&
        ((!hasTResetInfo() && !rhs.hasTResetInfo()) || getTResetInfo() == rhs.getTResetInfo()) &&
        ((!hasTResetHistoryList() && !rhs.hasTResetHistoryList()) || getTResetHistoryList() == rhs.getTResetHistoryList()) &&
        ((!hasTWakeupHistoryList() && !rhs.hasTWakeupHistoryList()) || getTWakeupHistoryList() == rhs.getTWakeupHistoryList()) &&
        ((!hasTSwitchOnList() && !rhs.hasTSwitchOnList()) || getTSwitchOnList() == rhs.getTSwitchOnList()) &&
        ((!hasTStateHistoryList() && !rhs.hasTStateHistoryList()) || getTStateHistoryList() == rhs.getTStateHistoryList()) &&
        ((!hasTErrStateHistory01List() && !rhs.hasTErrStateHistory01List()) || getTErrStateHistory01List() == rhs.getTErrStateHistory01List()) &&
        ((!hasTErrStateHistory02List() && !rhs.hasTErrStateHistory02List()) || getTErrStateHistory02List() == rhs.getTErrStateHistory02List()) &&
        ((!hasTErrStateHistory03List() && !rhs.hasTErrStateHistory03List()) || getTErrStateHistory03List() == rhs.getTErrStateHistory03List()) &&
        ((!hasTErrStateHistory04List() && !rhs.hasTErrStateHistory04List()) || getTErrStateHistory04List() == rhs.getTErrStateHistory04List()) &&
        ((!hasTErrStateHistory05List() && !rhs.hasTErrStateHistory05List()) || getTErrStateHistory05List() == rhs.getTErrStateHistory05List()) &&
        ((!hasU32SystemOperationTime() && !rhs.hasU32SystemOperationTime()) || getU32SystemOperationTime() == rhs.getU32SystemOperationTime()) &&
        ((!hasTCpuUsage() && !rhs.hasTCpuUsage()) || getTCpuUsage() == rhs.getTCpuUsage()) &&
        ((!hasTRamUsage() && !rhs.hasTRamUsage()) || getTRamUsage() == rhs.getTRamUsage()) &&
        ((!hasTStartupTime() && !rhs.hasTStartupTime()) || getTStartupTime() == rhs.getTStartupTime()));
}

inline bool T_SPM_SWVersionStatisticData::operator != (const T_SPM_SWVersionStatisticData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SPM_SWVersionStatisticData::operator < (const T_SPM_SWVersionStatisticData& rhs) const {
    if (hasStrBuildVersion() || rhs.hasStrBuildVersion()) {
        if (getStrBuildVersion() < rhs.getStrBuildVersion()) return true;
        if (getStrBuildVersion() > rhs.getStrBuildVersion()) return false;
    }
    if (hasStrBuildVersionCustomer() || rhs.hasStrBuildVersionCustomer()) {
        if (getStrBuildVersionCustomer() < rhs.getStrBuildVersionCustomer()) return true;
        if (getStrBuildVersionCustomer() > rhs.getStrBuildVersionCustomer()) return false;
    }
    if (hasStrCustomerVersion() || rhs.hasStrCustomerVersion()) {
        if (getStrCustomerVersion() < rhs.getStrCustomerVersion()) return true;
        if (getStrCustomerVersion() > rhs.getStrCustomerVersion()) return false;
    }
    if (hasTResetInfo() || rhs.hasTResetInfo()) {
        if (getTResetInfo() < rhs.getTResetInfo()) return true;
        if (getTResetInfo() > rhs.getTResetInfo()) return false;
    }
    if (hasTResetHistoryList() || rhs.hasTResetHistoryList()) {
        if (getTResetHistoryList() < rhs.getTResetHistoryList()) return true;
        if (getTResetHistoryList() > rhs.getTResetHistoryList()) return false;
    }
    if (hasTWakeupHistoryList() || rhs.hasTWakeupHistoryList()) {
        if (getTWakeupHistoryList() < rhs.getTWakeupHistoryList()) return true;
        if (getTWakeupHistoryList() > rhs.getTWakeupHistoryList()) return false;
    }
    if (hasTSwitchOnList() || rhs.hasTSwitchOnList()) {
        if (getTSwitchOnList() < rhs.getTSwitchOnList()) return true;
        if (getTSwitchOnList() > rhs.getTSwitchOnList()) return false;
    }
    if (hasTStateHistoryList() || rhs.hasTStateHistoryList()) {
        if (getTStateHistoryList() < rhs.getTStateHistoryList()) return true;
        if (getTStateHistoryList() > rhs.getTStateHistoryList()) return false;
    }
    if (hasTErrStateHistory01List() || rhs.hasTErrStateHistory01List()) {
        if (getTErrStateHistory01List() < rhs.getTErrStateHistory01List()) return true;
        if (getTErrStateHistory01List() > rhs.getTErrStateHistory01List()) return false;
    }
    if (hasTErrStateHistory02List() || rhs.hasTErrStateHistory02List()) {
        if (getTErrStateHistory02List() < rhs.getTErrStateHistory02List()) return true;
        if (getTErrStateHistory02List() > rhs.getTErrStateHistory02List()) return false;
    }
    if (hasTErrStateHistory03List() || rhs.hasTErrStateHistory03List()) {
        if (getTErrStateHistory03List() < rhs.getTErrStateHistory03List()) return true;
        if (getTErrStateHistory03List() > rhs.getTErrStateHistory03List()) return false;
    }
    if (hasTErrStateHistory04List() || rhs.hasTErrStateHistory04List()) {
        if (getTErrStateHistory04List() < rhs.getTErrStateHistory04List()) return true;
        if (getTErrStateHistory04List() > rhs.getTErrStateHistory04List()) return false;
    }
    if (hasTErrStateHistory05List() || rhs.hasTErrStateHistory05List()) {
        if (getTErrStateHistory05List() < rhs.getTErrStateHistory05List()) return true;
        if (getTErrStateHistory05List() > rhs.getTErrStateHistory05List()) return false;
    }
    if (hasU32SystemOperationTime() || rhs.hasU32SystemOperationTime()) {
        if (getU32SystemOperationTime() < rhs.getU32SystemOperationTime()) return true;
        if (getU32SystemOperationTime() > rhs.getU32SystemOperationTime()) return false;
    }
    if (hasTCpuUsage() || rhs.hasTCpuUsage()) {
        if (getTCpuUsage() < rhs.getTCpuUsage()) return true;
        if (getTCpuUsage() > rhs.getTCpuUsage()) return false;
    }
    if (hasTRamUsage() || rhs.hasTRamUsage()) {
        if (getTRamUsage() < rhs.getTRamUsage()) return true;
        if (getTRamUsage() > rhs.getTRamUsage()) return false;
    }
    if (hasTStartupTime() || rhs.hasTStartupTime()) {
        if (getTStartupTime() < rhs.getTStartupTime()) return true;
        if (getTStartupTime() > rhs.getTStartupTime()) return false;
    }
    return false;
}

inline bool T_SPM_SWVersionStatisticData::operator > (const T_SPM_SWVersionStatisticData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SPM_SWVersionStatisticData::clear() {
    clearStrBuildVersion();
    clearStrBuildVersionCustomer();
    clearStrCustomerVersion();
    clearTResetInfo();
    clearTResetHistoryList();
    clearTWakeupHistoryList();
    clearTSwitchOnList();
    clearTStateHistoryList();
    clearTErrStateHistory01List();
    clearTErrStateHistory02List();
    clearTErrStateHistory03List();
    clearTErrStateHistory04List();
    clearTErrStateHistory05List();
    clearU32SystemOperationTime();
    clearTCpuUsage();
    clearTRamUsage();
    clearTStartupTime();
}

inline void T_SPM_SWVersionStatisticData::clearStrBuildVersion() {
    if (hasStrBuildVersion()) {
         clear_has_strBuildVersion();
        if (_strBuildVersion != NULL) {
            _strBuildVersion->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasStrBuildVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_SPM_SWVersionStatisticData::getStrBuildVersion () const {
    if (_strBuildVersion == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strBuildVersion;
}

inline ::std::string& T_SPM_SWVersionStatisticData::getStrBuildVersionMutable () {
    set_has_strBuildVersion();
    if (_strBuildVersion == NULL) {
        _strBuildVersion = new ::std::string ();
        CHECK_ALLOCATION( _strBuildVersion );
    }
    return *_strBuildVersion;
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersion (const ::std::string& strBuildVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersion();
    if (this->_strBuildVersion == NULL) {
        this->_strBuildVersion = new ::std::string (strBuildVersion_);
        CHECK_ALLOCATION( this->_strBuildVersion );
    } else {
        *this->_strBuildVersion = strBuildVersion_;
    }
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersion (const char* strBuildVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersion();
    if (this->_strBuildVersion == NULL) {
        this->_strBuildVersion = new ::std::string (strBuildVersion_);
        CHECK_ALLOCATION( this->_strBuildVersion );
    } else {
        this->_strBuildVersion->assign(strBuildVersion_);
    }
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersion();
    if (this->_strBuildVersion == NULL) {
        this->_strBuildVersion = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strBuildVersion );
    } else {
        this->_strBuildVersion->assign(value, size);
    }
}

inline ::std::string* T_SPM_SWVersionStatisticData::releaseStrBuildVersion() {
    clear_has_strBuildVersion();
    ::std::string* temp = _strBuildVersion;
    this->_strBuildVersion = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceStrBuildVersion (::std::string* strBuildVersion_) {
    set_has_strBuildVersion();
    if (this->_strBuildVersion != strBuildVersion_) {
        if (this->_strBuildVersion != NULL) {
            delete this->_strBuildVersion;
        }
        this->_strBuildVersion = strBuildVersion_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearStrBuildVersionCustomer() {
    if (hasStrBuildVersionCustomer()) {
         clear_has_strBuildVersionCustomer();
        if (_strBuildVersionCustomer != NULL) {
            _strBuildVersionCustomer->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasStrBuildVersionCustomer () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SPM_SWVersionStatisticData::getStrBuildVersionCustomer () const {
    if (_strBuildVersionCustomer == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strBuildVersionCustomer;
}

inline ::std::string& T_SPM_SWVersionStatisticData::getStrBuildVersionCustomerMutable () {
    set_has_strBuildVersionCustomer();
    if (_strBuildVersionCustomer == NULL) {
        _strBuildVersionCustomer = new ::std::string ();
        CHECK_ALLOCATION( _strBuildVersionCustomer );
    }
    return *_strBuildVersionCustomer;
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersionCustomer (const ::std::string& strBuildVersionCustomer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersionCustomer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersionCustomer();
    if (this->_strBuildVersionCustomer == NULL) {
        this->_strBuildVersionCustomer = new ::std::string (strBuildVersionCustomer_);
        CHECK_ALLOCATION( this->_strBuildVersionCustomer );
    } else {
        *this->_strBuildVersionCustomer = strBuildVersionCustomer_;
    }
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersionCustomer (const char* strBuildVersionCustomer_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBuildVersionCustomer_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersionCustomer();
    if (this->_strBuildVersionCustomer == NULL) {
        this->_strBuildVersionCustomer = new ::std::string (strBuildVersionCustomer_);
        CHECK_ALLOCATION( this->_strBuildVersionCustomer );
    } else {
        this->_strBuildVersionCustomer->assign(strBuildVersionCustomer_);
    }
}

inline void T_SPM_SWVersionStatisticData::setStrBuildVersionCustomer (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBuildVersionCustomer();
    if (this->_strBuildVersionCustomer == NULL) {
        this->_strBuildVersionCustomer = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strBuildVersionCustomer );
    } else {
        this->_strBuildVersionCustomer->assign(value, size);
    }
}

inline ::std::string* T_SPM_SWVersionStatisticData::releaseStrBuildVersionCustomer() {
    clear_has_strBuildVersionCustomer();
    ::std::string* temp = _strBuildVersionCustomer;
    this->_strBuildVersionCustomer = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceStrBuildVersionCustomer (::std::string* strBuildVersionCustomer_) {
    set_has_strBuildVersionCustomer();
    if (this->_strBuildVersionCustomer != strBuildVersionCustomer_) {
        if (this->_strBuildVersionCustomer != NULL) {
            delete this->_strBuildVersionCustomer;
        }
        this->_strBuildVersionCustomer = strBuildVersionCustomer_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearStrCustomerVersion() {
    if (hasStrCustomerVersion()) {
         clear_has_strCustomerVersion();
        if (_strCustomerVersion != NULL) {
            _strCustomerVersion->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasStrCustomerVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SPM_SWVersionStatisticData::getStrCustomerVersion () const {
    if (_strCustomerVersion == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strCustomerVersion;
}

inline ::std::string& T_SPM_SWVersionStatisticData::getStrCustomerVersionMutable () {
    set_has_strCustomerVersion();
    if (_strCustomerVersion == NULL) {
        _strCustomerVersion = new ::std::string ();
        CHECK_ALLOCATION( _strCustomerVersion );
    }
    return *_strCustomerVersion;
}

inline void T_SPM_SWVersionStatisticData::setStrCustomerVersion (const ::std::string& strCustomerVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCustomerVersion();
    if (this->_strCustomerVersion == NULL) {
        this->_strCustomerVersion = new ::std::string (strCustomerVersion_);
        CHECK_ALLOCATION( this->_strCustomerVersion );
    } else {
        *this->_strCustomerVersion = strCustomerVersion_;
    }
}

inline void T_SPM_SWVersionStatisticData::setStrCustomerVersion (const char* strCustomerVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCustomerVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCustomerVersion();
    if (this->_strCustomerVersion == NULL) {
        this->_strCustomerVersion = new ::std::string (strCustomerVersion_);
        CHECK_ALLOCATION( this->_strCustomerVersion );
    } else {
        this->_strCustomerVersion->assign(strCustomerVersion_);
    }
}

inline void T_SPM_SWVersionStatisticData::setStrCustomerVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCustomerVersion();
    if (this->_strCustomerVersion == NULL) {
        this->_strCustomerVersion = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strCustomerVersion );
    } else {
        this->_strCustomerVersion->assign(value, size);
    }
}

inline ::std::string* T_SPM_SWVersionStatisticData::releaseStrCustomerVersion() {
    clear_has_strCustomerVersion();
    ::std::string* temp = _strCustomerVersion;
    this->_strCustomerVersion = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceStrCustomerVersion (::std::string* strCustomerVersion_) {
    set_has_strCustomerVersion();
    if (this->_strCustomerVersion != strCustomerVersion_) {
        if (this->_strCustomerVersion != NULL) {
            delete this->_strCustomerVersion;
        }
        this->_strCustomerVersion = strCustomerVersion_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTResetInfo() {
    if (hasTResetInfo()) {
         clear_has_tResetInfo();
        if (_tResetInfo != NULL) {
            _tResetInfo->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTResetInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_SPM_ResetInfoStatisticData& T_SPM_SWVersionStatisticData::getTResetInfo () const {
    if (_tResetInfo == NULL) {
        return T_SPM_ResetInfoStatisticData::getDefaultInstance();
    }
    return *_tResetInfo;
}

inline T_SPM_ResetInfoStatisticData& T_SPM_SWVersionStatisticData::getTResetInfoMutable () {
    set_has_tResetInfo();
    if (_tResetInfo == NULL) {
        _tResetInfo = new T_SPM_ResetInfoStatisticData ();
        CHECK_ALLOCATION( _tResetInfo );
    }
    return *_tResetInfo;
}

inline void T_SPM_SWVersionStatisticData::setTResetInfo (const T_SPM_ResetInfoStatisticData& tResetInfo_) {
    set_has_tResetInfo();
    if (this->_tResetInfo == NULL) {
        this->_tResetInfo = new T_SPM_ResetInfoStatisticData (tResetInfo_);
        CHECK_ALLOCATION( this->_tResetInfo );
    } else {
        *this->_tResetInfo = tResetInfo_;
    }
}

inline T_SPM_ResetInfoStatisticData* T_SPM_SWVersionStatisticData::releaseTResetInfo() {
    clear_has_tResetInfo();
    T_SPM_ResetInfoStatisticData* temp = _tResetInfo;
    this->_tResetInfo = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTResetInfo (T_SPM_ResetInfoStatisticData* tResetInfo_) {
    set_has_tResetInfo();
    if (this->_tResetInfo != tResetInfo_) {
        if (this->_tResetInfo != NULL) {
            delete this->_tResetInfo;
        }
        this->_tResetInfo = tResetInfo_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTResetHistoryList() {
    if (hasTResetHistoryList()) {
         clear_has_tResetHistoryList();
        if (_tResetHistoryList != NULL) {
            _tResetHistoryList->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTResetHistoryList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::boost::ptr_vector< T_ResetElement >& T_SPM_SWVersionStatisticData::getTResetHistoryList () const {
    if (_tResetHistoryList == NULL) {
        return getT_ResetElementPointerList_DefaultInstance();
    }
    return *_tResetHistoryList;
}

inline ::boost::ptr_vector< T_ResetElement >& T_SPM_SWVersionStatisticData::getTResetHistoryListMutable () {
    set_has_tResetHistoryList();
    if (_tResetHistoryList == NULL) {
        _tResetHistoryList = new ::boost::ptr_vector< T_ResetElement > ();
        CHECK_ALLOCATION( _tResetHistoryList );
    }
    return *_tResetHistoryList;
}

inline void T_SPM_SWVersionStatisticData::setTResetHistoryList (const ::boost::ptr_vector< T_ResetElement >& tResetHistoryList_) {
    set_has_tResetHistoryList();
    if (this->_tResetHistoryList == NULL) {
        this->_tResetHistoryList = new ::boost::ptr_vector< T_ResetElement > (tResetHistoryList_);
        CHECK_ALLOCATION( this->_tResetHistoryList );
    } else {
        *this->_tResetHistoryList = tResetHistoryList_;
    }
}

inline ::boost::ptr_vector< T_ResetElement >* T_SPM_SWVersionStatisticData::releaseTResetHistoryList() {
    clear_has_tResetHistoryList();
    ::boost::ptr_vector< T_ResetElement >* temp = _tResetHistoryList;
    this->_tResetHistoryList = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTResetHistoryList (::boost::ptr_vector< T_ResetElement >* tResetHistoryList_) {
    set_has_tResetHistoryList();
    if (this->_tResetHistoryList != tResetHistoryList_) {
        if (this->_tResetHistoryList != NULL) {
            delete this->_tResetHistoryList;
        }
        this->_tResetHistoryList = tResetHistoryList_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTWakeupHistoryList() {
    if (hasTWakeupHistoryList()) {
         clear_has_tWakeupHistoryList();
        if (_tWakeupHistoryList != NULL) {
            _tWakeupHistoryList->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTWakeupHistoryList () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::boost::ptr_vector< T_WakeupElement >& T_SPM_SWVersionStatisticData::getTWakeupHistoryList () const {
    if (_tWakeupHistoryList == NULL) {
        return getT_WakeupElementPointerList_DefaultInstance();
    }
    return *_tWakeupHistoryList;
}

inline ::boost::ptr_vector< T_WakeupElement >& T_SPM_SWVersionStatisticData::getTWakeupHistoryListMutable () {
    set_has_tWakeupHistoryList();
    if (_tWakeupHistoryList == NULL) {
        _tWakeupHistoryList = new ::boost::ptr_vector< T_WakeupElement > ();
        CHECK_ALLOCATION( _tWakeupHistoryList );
    }
    return *_tWakeupHistoryList;
}

inline void T_SPM_SWVersionStatisticData::setTWakeupHistoryList (const ::boost::ptr_vector< T_WakeupElement >& tWakeupHistoryList_) {
    set_has_tWakeupHistoryList();
    if (this->_tWakeupHistoryList == NULL) {
        this->_tWakeupHistoryList = new ::boost::ptr_vector< T_WakeupElement > (tWakeupHistoryList_);
        CHECK_ALLOCATION( this->_tWakeupHistoryList );
    } else {
        *this->_tWakeupHistoryList = tWakeupHistoryList_;
    }
}

inline ::boost::ptr_vector< T_WakeupElement >* T_SPM_SWVersionStatisticData::releaseTWakeupHistoryList() {
    clear_has_tWakeupHistoryList();
    ::boost::ptr_vector< T_WakeupElement >* temp = _tWakeupHistoryList;
    this->_tWakeupHistoryList = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTWakeupHistoryList (::boost::ptr_vector< T_WakeupElement >* tWakeupHistoryList_) {
    set_has_tWakeupHistoryList();
    if (this->_tWakeupHistoryList != tWakeupHistoryList_) {
        if (this->_tWakeupHistoryList != NULL) {
            delete this->_tWakeupHistoryList;
        }
        this->_tWakeupHistoryList = tWakeupHistoryList_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTSwitchOnList() {
    if (hasTSwitchOnList()) {
         clear_has_tSwitchOnList();
        if (_tSwitchOnList != NULL) {
            _tSwitchOnList->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTSwitchOnList () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::boost::ptr_vector< T_SwitchOnElement >& T_SPM_SWVersionStatisticData::getTSwitchOnList () const {
    if (_tSwitchOnList == NULL) {
        return getT_SwitchOnElementPointerList_DefaultInstance();
    }
    return *_tSwitchOnList;
}

inline ::boost::ptr_vector< T_SwitchOnElement >& T_SPM_SWVersionStatisticData::getTSwitchOnListMutable () {
    set_has_tSwitchOnList();
    if (_tSwitchOnList == NULL) {
        _tSwitchOnList = new ::boost::ptr_vector< T_SwitchOnElement > ();
        CHECK_ALLOCATION( _tSwitchOnList );
    }
    return *_tSwitchOnList;
}

inline void T_SPM_SWVersionStatisticData::setTSwitchOnList (const ::boost::ptr_vector< T_SwitchOnElement >& tSwitchOnList_) {
    set_has_tSwitchOnList();
    if (this->_tSwitchOnList == NULL) {
        this->_tSwitchOnList = new ::boost::ptr_vector< T_SwitchOnElement > (tSwitchOnList_);
        CHECK_ALLOCATION( this->_tSwitchOnList );
    } else {
        *this->_tSwitchOnList = tSwitchOnList_;
    }
}

inline ::boost::ptr_vector< T_SwitchOnElement >* T_SPM_SWVersionStatisticData::releaseTSwitchOnList() {
    clear_has_tSwitchOnList();
    ::boost::ptr_vector< T_SwitchOnElement >* temp = _tSwitchOnList;
    this->_tSwitchOnList = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTSwitchOnList (::boost::ptr_vector< T_SwitchOnElement >* tSwitchOnList_) {
    set_has_tSwitchOnList();
    if (this->_tSwitchOnList != tSwitchOnList_) {
        if (this->_tSwitchOnList != NULL) {
            delete this->_tSwitchOnList;
        }
        this->_tSwitchOnList = tSwitchOnList_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTStateHistoryList() {
    if (hasTStateHistoryList()) {
         clear_has_tStateHistoryList();
        if (_tStateHistoryList != NULL) {
            _tStateHistoryList->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTStateHistoryList () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTStateHistoryList () const {
    if (_tStateHistoryList == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tStateHistoryList;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTStateHistoryListMutable () {
    set_has_tStateHistoryList();
    if (_tStateHistoryList == NULL) {
        _tStateHistoryList = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tStateHistoryList );
    }
    return *_tStateHistoryList;
}

inline void T_SPM_SWVersionStatisticData::setTStateHistoryList (const ::boost::ptr_vector< T_StateChangeElement >& tStateHistoryList_) {
    set_has_tStateHistoryList();
    if (this->_tStateHistoryList == NULL) {
        this->_tStateHistoryList = new ::boost::ptr_vector< T_StateChangeElement > (tStateHistoryList_);
        CHECK_ALLOCATION( this->_tStateHistoryList );
    } else {
        *this->_tStateHistoryList = tStateHistoryList_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTStateHistoryList() {
    clear_has_tStateHistoryList();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tStateHistoryList;
    this->_tStateHistoryList = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTStateHistoryList (::boost::ptr_vector< T_StateChangeElement >* tStateHistoryList_) {
    set_has_tStateHistoryList();
    if (this->_tStateHistoryList != tStateHistoryList_) {
        if (this->_tStateHistoryList != NULL) {
            delete this->_tStateHistoryList;
        }
        this->_tStateHistoryList = tStateHistoryList_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTErrStateHistory01List() {
    if (hasTErrStateHistory01List()) {
         clear_has_tErrStateHistory01List();
        if (_tErrStateHistory01List != NULL) {
            _tErrStateHistory01List->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTErrStateHistory01List () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory01List () const {
    if (_tErrStateHistory01List == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tErrStateHistory01List;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory01ListMutable () {
    set_has_tErrStateHistory01List();
    if (_tErrStateHistory01List == NULL) {
        _tErrStateHistory01List = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tErrStateHistory01List );
    }
    return *_tErrStateHistory01List;
}

inline void T_SPM_SWVersionStatisticData::setTErrStateHistory01List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory01List_) {
    set_has_tErrStateHistory01List();
    if (this->_tErrStateHistory01List == NULL) {
        this->_tErrStateHistory01List = new ::boost::ptr_vector< T_StateChangeElement > (tErrStateHistory01List_);
        CHECK_ALLOCATION( this->_tErrStateHistory01List );
    } else {
        *this->_tErrStateHistory01List = tErrStateHistory01List_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTErrStateHistory01List() {
    clear_has_tErrStateHistory01List();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tErrStateHistory01List;
    this->_tErrStateHistory01List = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTErrStateHistory01List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory01List_) {
    set_has_tErrStateHistory01List();
    if (this->_tErrStateHistory01List != tErrStateHistory01List_) {
        if (this->_tErrStateHistory01List != NULL) {
            delete this->_tErrStateHistory01List;
        }
        this->_tErrStateHistory01List = tErrStateHistory01List_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTErrStateHistory02List() {
    if (hasTErrStateHistory02List()) {
         clear_has_tErrStateHistory02List();
        if (_tErrStateHistory02List != NULL) {
            _tErrStateHistory02List->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTErrStateHistory02List () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory02List () const {
    if (_tErrStateHistory02List == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tErrStateHistory02List;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory02ListMutable () {
    set_has_tErrStateHistory02List();
    if (_tErrStateHistory02List == NULL) {
        _tErrStateHistory02List = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tErrStateHistory02List );
    }
    return *_tErrStateHistory02List;
}

inline void T_SPM_SWVersionStatisticData::setTErrStateHistory02List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory02List_) {
    set_has_tErrStateHistory02List();
    if (this->_tErrStateHistory02List == NULL) {
        this->_tErrStateHistory02List = new ::boost::ptr_vector< T_StateChangeElement > (tErrStateHistory02List_);
        CHECK_ALLOCATION( this->_tErrStateHistory02List );
    } else {
        *this->_tErrStateHistory02List = tErrStateHistory02List_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTErrStateHistory02List() {
    clear_has_tErrStateHistory02List();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tErrStateHistory02List;
    this->_tErrStateHistory02List = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTErrStateHistory02List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory02List_) {
    set_has_tErrStateHistory02List();
    if (this->_tErrStateHistory02List != tErrStateHistory02List_) {
        if (this->_tErrStateHistory02List != NULL) {
            delete this->_tErrStateHistory02List;
        }
        this->_tErrStateHistory02List = tErrStateHistory02List_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTErrStateHistory03List() {
    if (hasTErrStateHistory03List()) {
         clear_has_tErrStateHistory03List();
        if (_tErrStateHistory03List != NULL) {
            _tErrStateHistory03List->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTErrStateHistory03List () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory03List () const {
    if (_tErrStateHistory03List == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tErrStateHistory03List;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory03ListMutable () {
    set_has_tErrStateHistory03List();
    if (_tErrStateHistory03List == NULL) {
        _tErrStateHistory03List = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tErrStateHistory03List );
    }
    return *_tErrStateHistory03List;
}

inline void T_SPM_SWVersionStatisticData::setTErrStateHistory03List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory03List_) {
    set_has_tErrStateHistory03List();
    if (this->_tErrStateHistory03List == NULL) {
        this->_tErrStateHistory03List = new ::boost::ptr_vector< T_StateChangeElement > (tErrStateHistory03List_);
        CHECK_ALLOCATION( this->_tErrStateHistory03List );
    } else {
        *this->_tErrStateHistory03List = tErrStateHistory03List_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTErrStateHistory03List() {
    clear_has_tErrStateHistory03List();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tErrStateHistory03List;
    this->_tErrStateHistory03List = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTErrStateHistory03List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory03List_) {
    set_has_tErrStateHistory03List();
    if (this->_tErrStateHistory03List != tErrStateHistory03List_) {
        if (this->_tErrStateHistory03List != NULL) {
            delete this->_tErrStateHistory03List;
        }
        this->_tErrStateHistory03List = tErrStateHistory03List_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTErrStateHistory04List() {
    if (hasTErrStateHistory04List()) {
         clear_has_tErrStateHistory04List();
        if (_tErrStateHistory04List != NULL) {
            _tErrStateHistory04List->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTErrStateHistory04List () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory04List () const {
    if (_tErrStateHistory04List == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tErrStateHistory04List;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory04ListMutable () {
    set_has_tErrStateHistory04List();
    if (_tErrStateHistory04List == NULL) {
        _tErrStateHistory04List = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tErrStateHistory04List );
    }
    return *_tErrStateHistory04List;
}

inline void T_SPM_SWVersionStatisticData::setTErrStateHistory04List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory04List_) {
    set_has_tErrStateHistory04List();
    if (this->_tErrStateHistory04List == NULL) {
        this->_tErrStateHistory04List = new ::boost::ptr_vector< T_StateChangeElement > (tErrStateHistory04List_);
        CHECK_ALLOCATION( this->_tErrStateHistory04List );
    } else {
        *this->_tErrStateHistory04List = tErrStateHistory04List_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTErrStateHistory04List() {
    clear_has_tErrStateHistory04List();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tErrStateHistory04List;
    this->_tErrStateHistory04List = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTErrStateHistory04List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory04List_) {
    set_has_tErrStateHistory04List();
    if (this->_tErrStateHistory04List != tErrStateHistory04List_) {
        if (this->_tErrStateHistory04List != NULL) {
            delete this->_tErrStateHistory04List;
        }
        this->_tErrStateHistory04List = tErrStateHistory04List_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTErrStateHistory05List() {
    if (hasTErrStateHistory05List()) {
         clear_has_tErrStateHistory05List();
        if (_tErrStateHistory05List != NULL) {
            _tErrStateHistory05List->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTErrStateHistory05List () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory05List () const {
    if (_tErrStateHistory05List == NULL) {
        return getT_StateChangeElementPointerList_DefaultInstance();
    }
    return *_tErrStateHistory05List;
}

inline ::boost::ptr_vector< T_StateChangeElement >& T_SPM_SWVersionStatisticData::getTErrStateHistory05ListMutable () {
    set_has_tErrStateHistory05List();
    if (_tErrStateHistory05List == NULL) {
        _tErrStateHistory05List = new ::boost::ptr_vector< T_StateChangeElement > ();
        CHECK_ALLOCATION( _tErrStateHistory05List );
    }
    return *_tErrStateHistory05List;
}

inline void T_SPM_SWVersionStatisticData::setTErrStateHistory05List (const ::boost::ptr_vector< T_StateChangeElement >& tErrStateHistory05List_) {
    set_has_tErrStateHistory05List();
    if (this->_tErrStateHistory05List == NULL) {
        this->_tErrStateHistory05List = new ::boost::ptr_vector< T_StateChangeElement > (tErrStateHistory05List_);
        CHECK_ALLOCATION( this->_tErrStateHistory05List );
    } else {
        *this->_tErrStateHistory05List = tErrStateHistory05List_;
    }
}

inline ::boost::ptr_vector< T_StateChangeElement >* T_SPM_SWVersionStatisticData::releaseTErrStateHistory05List() {
    clear_has_tErrStateHistory05List();
    ::boost::ptr_vector< T_StateChangeElement >* temp = _tErrStateHistory05List;
    this->_tErrStateHistory05List = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTErrStateHistory05List (::boost::ptr_vector< T_StateChangeElement >* tErrStateHistory05List_) {
    set_has_tErrStateHistory05List();
    if (this->_tErrStateHistory05List != tErrStateHistory05List_) {
        if (this->_tErrStateHistory05List != NULL) {
            delete this->_tErrStateHistory05List;
        }
        this->_tErrStateHistory05List = tErrStateHistory05List_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearU32SystemOperationTime() {
    if (hasU32SystemOperationTime()) {
         clear_has_u32SystemOperationTime();
        _u32SystemOperationTime = 0u;
     }
}

inline bool T_SPM_SWVersionStatisticData::hasU32SystemOperationTime () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_SPM_SWVersionStatisticData::getU32SystemOperationTime () const {
    return _u32SystemOperationTime;
}

inline void T_SPM_SWVersionStatisticData::setU32SystemOperationTime (uint32 u32SystemOperationTime_) {
    set_has_u32SystemOperationTime();
    this->_u32SystemOperationTime = u32SystemOperationTime_;
}

inline void T_SPM_SWVersionStatisticData::clearTCpuUsage() {
    if (hasTCpuUsage()) {
         clear_has_tCpuUsage();
        if (_tCpuUsage != NULL) {
            _tCpuUsage->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTCpuUsage () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTCpuUsage () const {
    if (_tCpuUsage == NULL) {
        return T_SPM_SystemStatisticsData::getDefaultInstance();
    }
    return *_tCpuUsage;
}

inline T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTCpuUsageMutable () {
    set_has_tCpuUsage();
    if (_tCpuUsage == NULL) {
        _tCpuUsage = new T_SPM_SystemStatisticsData ();
        CHECK_ALLOCATION( _tCpuUsage );
    }
    return *_tCpuUsage;
}

inline void T_SPM_SWVersionStatisticData::setTCpuUsage (const T_SPM_SystemStatisticsData& tCpuUsage_) {
    set_has_tCpuUsage();
    if (this->_tCpuUsage == NULL) {
        this->_tCpuUsage = new T_SPM_SystemStatisticsData (tCpuUsage_);
        CHECK_ALLOCATION( this->_tCpuUsage );
    } else {
        *this->_tCpuUsage = tCpuUsage_;
    }
}

inline T_SPM_SystemStatisticsData* T_SPM_SWVersionStatisticData::releaseTCpuUsage() {
    clear_has_tCpuUsage();
    T_SPM_SystemStatisticsData* temp = _tCpuUsage;
    this->_tCpuUsage = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTCpuUsage (T_SPM_SystemStatisticsData* tCpuUsage_) {
    set_has_tCpuUsage();
    if (this->_tCpuUsage != tCpuUsage_) {
        if (this->_tCpuUsage != NULL) {
            delete this->_tCpuUsage;
        }
        this->_tCpuUsage = tCpuUsage_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTRamUsage() {
    if (hasTRamUsage()) {
         clear_has_tRamUsage();
        if (_tRamUsage != NULL) {
            _tRamUsage->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTRamUsage () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTRamUsage () const {
    if (_tRamUsage == NULL) {
        return T_SPM_SystemStatisticsData::getDefaultInstance();
    }
    return *_tRamUsage;
}

inline T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTRamUsageMutable () {
    set_has_tRamUsage();
    if (_tRamUsage == NULL) {
        _tRamUsage = new T_SPM_SystemStatisticsData ();
        CHECK_ALLOCATION( _tRamUsage );
    }
    return *_tRamUsage;
}

inline void T_SPM_SWVersionStatisticData::setTRamUsage (const T_SPM_SystemStatisticsData& tRamUsage_) {
    set_has_tRamUsage();
    if (this->_tRamUsage == NULL) {
        this->_tRamUsage = new T_SPM_SystemStatisticsData (tRamUsage_);
        CHECK_ALLOCATION( this->_tRamUsage );
    } else {
        *this->_tRamUsage = tRamUsage_;
    }
}

inline T_SPM_SystemStatisticsData* T_SPM_SWVersionStatisticData::releaseTRamUsage() {
    clear_has_tRamUsage();
    T_SPM_SystemStatisticsData* temp = _tRamUsage;
    this->_tRamUsage = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTRamUsage (T_SPM_SystemStatisticsData* tRamUsage_) {
    set_has_tRamUsage();
    if (this->_tRamUsage != tRamUsage_) {
        if (this->_tRamUsage != NULL) {
            delete this->_tRamUsage;
        }
        this->_tRamUsage = tRamUsage_;
    }
}

inline void T_SPM_SWVersionStatisticData::clearTStartupTime() {
    if (hasTStartupTime()) {
         clear_has_tStartupTime();
        if (_tStartupTime != NULL) {
            _tStartupTime->clear();
        }
     }
}

inline bool T_SPM_SWVersionStatisticData::hasTStartupTime () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTStartupTime () const {
    if (_tStartupTime == NULL) {
        return T_SPM_SystemStatisticsData::getDefaultInstance();
    }
    return *_tStartupTime;
}

inline T_SPM_SystemStatisticsData& T_SPM_SWVersionStatisticData::getTStartupTimeMutable () {
    set_has_tStartupTime();
    if (_tStartupTime == NULL) {
        _tStartupTime = new T_SPM_SystemStatisticsData ();
        CHECK_ALLOCATION( _tStartupTime );
    }
    return *_tStartupTime;
}

inline void T_SPM_SWVersionStatisticData::setTStartupTime (const T_SPM_SystemStatisticsData& tStartupTime_) {
    set_has_tStartupTime();
    if (this->_tStartupTime == NULL) {
        this->_tStartupTime = new T_SPM_SystemStatisticsData (tStartupTime_);
        CHECK_ALLOCATION( this->_tStartupTime );
    } else {
        *this->_tStartupTime = tStartupTime_;
    }
}

inline T_SPM_SystemStatisticsData* T_SPM_SWVersionStatisticData::releaseTStartupTime() {
    clear_has_tStartupTime();
    T_SPM_SystemStatisticsData* temp = _tStartupTime;
    this->_tStartupTime = NULL;
    return temp;
}

inline void T_SPM_SWVersionStatisticData::replaceTStartupTime (T_SPM_SystemStatisticsData* tStartupTime_) {
    set_has_tStartupTime();
    if (this->_tStartupTime != tStartupTime_) {
        if (this->_tStartupTime != NULL) {
            delete this->_tStartupTime;
        }
        this->_tStartupTime = tStartupTime_;
    }
}

inline void T_SPM_SWVersionStatisticData::set_has_strBuildVersion () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SPM_SWVersionStatisticData::clear_has_strBuildVersion () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SPM_SWVersionStatisticData::set_has_strBuildVersionCustomer () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SPM_SWVersionStatisticData::clear_has_strBuildVersionCustomer () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SPM_SWVersionStatisticData::set_has_strCustomerVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SPM_SWVersionStatisticData::clear_has_strCustomerVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SPM_SWVersionStatisticData::set_has_tResetInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tResetInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SPM_SWVersionStatisticData::set_has_tResetHistoryList () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tResetHistoryList () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SPM_SWVersionStatisticData::set_has_tWakeupHistoryList () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tWakeupHistoryList () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SPM_SWVersionStatisticData::set_has_tSwitchOnList () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tSwitchOnList () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SPM_SWVersionStatisticData::set_has_tStateHistoryList () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tStateHistoryList () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SPM_SWVersionStatisticData::set_has_tErrStateHistory01List () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tErrStateHistory01List () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SPM_SWVersionStatisticData::set_has_tErrStateHistory02List () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tErrStateHistory02List () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SPM_SWVersionStatisticData::set_has_tErrStateHistory03List () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tErrStateHistory03List () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_SPM_SWVersionStatisticData::set_has_tErrStateHistory04List () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tErrStateHistory04List () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_SPM_SWVersionStatisticData::set_has_tErrStateHistory05List () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tErrStateHistory05List () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_SPM_SWVersionStatisticData::set_has_u32SystemOperationTime () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_SPM_SWVersionStatisticData::clear_has_u32SystemOperationTime () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_SPM_SWVersionStatisticData::set_has_tCpuUsage () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tCpuUsage () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_SPM_SWVersionStatisticData::set_has_tRamUsage () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tRamUsage () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_SPM_SWVersionStatisticData::set_has_tStartupTime () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_SPM_SWVersionStatisticData::clear_has_tStartupTime () {
    _has_bits_[0] &= ~ (1u << 16);
}

} // namespace spm_core_fi_types

#endif // SPM_CORE_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
